% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{unique.igraph.es}
\alias{unique.igraph.es}
\title{Remove duplicate edges from an edge sequence}
\usage{
\method{unique}{igraph.es}(x, incomparables = FALSE, ...)
}
\arguments{
\item{x}{An edge sequence.}

\item{incomparables}{a vector of values that cannot be compared.
Passed to base function \code{duplicated}. See details there.}

\item{...}{Passed to base function \code{duplicated()}.}
}
\value{
An edge sequence with the duplicate vertices removed.
}
\description{
Remove duplicate edges from an edge sequence
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
E(g)[1, 1:5, 1:10, 5:10]
E(g)[1, 1:5, 1:10, 5:10] \%>\% unique()
}
\seealso{
Other vertex and edge sequence operations: \code{\link{c.igraph.es}},
  \code{\link{c.igraph.vs}},
  \code{\link{difference.igraph.es}},
  \code{\link{difference.igraph.vs}},
  \code{\link{igraph-es-indexing2}},
  \code{\link{igraph-es-indexing}},
  \code{\link{igraph-vs-indexing2}},
  \code{\link{igraph-vs-indexing}},
  \code{\link{intersection.igraph.es}},
  \code{\link{intersection.igraph.vs}},
  \code{\link{rev.igraph.es}}, \code{\link{rev.igraph.vs}},
  \code{\link{union.igraph.es}},
  \code{\link{union.igraph.vs}},
  \code{\link{unique.igraph.vs}}
}
