% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_}
\alias{layout_}
\alias{layout}
\alias{print.igraph_layout_spec}
\alias{print.igraph_layout_modifier}
\title{Graph layouts}
\usage{
layout_(graph, layout, ...)

\method{print}{igraph_layout_spec}(x, ...)

\method{print}{igraph_layout_modifier}(x, ...)
}
\arguments{
\item{graph}{The input graph.}

\item{layout}{The layout specification. It must be a call
to a layout specification function.}

\item{...}{Further modifiers, see a complete list below.
For the \code{print} methods, it is ignored.}

\item{x}{The layout specification}
}
\value{
The return value of the layout function, usually a
  two column matrix. For 3D layouts a three column matrix.
}
\description{
This is a generic function to apply a layout function to
a graph.
}
\details{
There are two ways to calculate graph layouts in igraph.
The first way is to call a layout function (they all have
prefix \code{layout_} on a graph, to get the vertex coordinates.

The second way (new in igraph 0.8.0), has two steps, and it
is more flexible. First you call a layout specification
function (the one without the \code{layout_} prefix, and
then \code{layout_} (or \code{\link{add_layout_}}) to
perform the layouting.

The second way is preferred, as it is more flexible. It allows
operations before and after the layouting. E.g. using the
\code{component_wise} argument, the layout can be calculated
separately for each component, and then merged to get the
final results.
}
\section{Modifiers}{

Modifiers modify how a layout calculation is performed.
Currently implemented modifyers: \itemize{
  \item \code{component_wise} calculates the layout separately
    for each component of the graph, and then merges
    them.
  \item \code{normalize} scales the layout to a square.
}
}

\examples{
g <- make_ring(10) + make_full_graph(5)
coords <- layout_(g, as_star())
plot(g, layout = coords)
}
\seealso{
\code{\link{add_layout_}} to add the layout to the
  graph as an attribute.

Other graph layouts: \code{\link{add_layout_}},
  \code{\link{component_wise}},
  \code{\link{layout_as_bipartite}},
  \code{\link{layout_as_star}},
  \code{\link{layout_as_tree}},
  \code{\link{layout_in_circle}},
  \code{\link{layout_nicely}},
  \code{\link{layout_on_grid}},
  \code{\link{layout_on_sphere}},
  \code{\link{layout_randomly}},
  \code{\link{layout_with_dh}},
  \code{\link{layout_with_fr}},
  \code{\link{layout_with_gem}},
  \code{\link{layout_with_graphopt}},
  \code{\link{layout_with_kk}},
  \code{\link{layout_with_lgl}},
  \code{\link{layout_with_mds}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{merge_coords}}, \code{\link{norm_coords}},
  \code{\link{normalize}}
}
