% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxnet.deviance.R
\name{coxnet.deviance}
\alias{coxnet.deviance}
\title{compute deviance for cox model output}
\usage{
coxnet.deviance(pred = NULL, y, x = 0, offset = NULL,
  weights = NULL, beta = NULL)
}
\arguments{
\item{pred}{matrix of predictions}

\item{y}{a survival response matrix, as produced by \code{Surv}}

\item{x}{optional \code{x} matrix, if \code{pred} is \code{NULL}}

\item{offset}{optional offset}

\item{weights}{optional observation weights}

\item{beta}{optional coefficient vector/matrix, supplied if \code{pred=NULL}}
}
\value{
a single or vector of deviances
}
\description{
Given a fit or coefficients, compute the deciance (-2 log partial likelihood) for
right-censored survival data
}
\details{
\code{coxnet.deviance} computes the deviance for a single prediction, or a matrix of predictions
}
\seealso{
\code{coxgrad}
}
\author{
Trevor Hastie\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{Cox}
\keyword{model}
