% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderers.R
\name{gif_file}
\alias{gif_file}
\alias{gif_image}
\alias{print.gif_image}
\alias{knit_print.gif_image}
\alias{split.gif_image}
\title{Wrap a gif file for easy handling}
\usage{
gif_file(file)

\method{print}{gif_image}(x, ...)

knit_print.gif_image(x, options, ...)

\method{split}{gif_image}(x, f, drop = FALSE, ...)
}
\arguments{
\item{file}{The gif file to be wrapped}

\item{x}{A \code{gif_image} object}

\item{...}{Arguments passed on}

\item{f}{a ‘factor’ in the sense that \link[base:factor]{as.factor(f)} defines
the grouping, or a list of such factors in which case their interaction is
used for the grouping.}

\item{drop}{logical indicating if levels that do not occur should be dropped
    (if \code{f} is a \code{factor} or a list).}
}
\value{
\code{gif_file} returns a \code{gif_image} object. \code{split} returns a list of
\code{magick-image} objects and requires magick to work.
}
\description{
This is a simple class for gif files that takes care printing the file
correctly in different environment (e.g. knitr, RStudio, etc.). If your
renderer produces a gif file you can wrap the final output in \code{gif_file} to
get all of these benefits for free.
}
\keyword{internal}
