% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-vector.R
\name{chk_vector}
\alias{chk_vector}
\alias{vld_vector}
\title{Check Vector}
\usage{
chk_vector(x, x_name = NULL)

vld_vector(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a vector using

\code{(is.atomic(x) && !is.matrix(x) && !is.array(x)) || is.list(x)}
}
\details{
\code{is.vector(x)} is not reliable because it returns TRUE only
if the object is a vector with no attributes apart from names.
}
\section{Functions}{
\itemize{
\item \code{vld_vector()}: Validate Vector

}}
\examples{
# chk_vector
chk_vector(1)
chk_vector(list())
try(chk_vector(matrix(1)))
# vld_vector
vld_vector(1)
}
\seealso{
\code{\link[=is.atomic]{is.atomic()}}, \code{\link[=is.matrix]{is.matrix()}}, \code{\link[=is.array]{is.array()}}, \code{\link[=is.list]{is.list()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other data_structure_checkers: 
\code{\link{chk_array}()},
\code{\link{chk_atomic}()},
\code{\link{chk_list}()},
\code{\link{chk_matrix}()}
}
\concept{data_structure_checkers}
