% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_standata.R
\name{standata.brmsfit}
\alias{standata.brmsfit}
\alias{standata}
\title{Extract data passed to Stan}
\usage{
\method{standata}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  newdata2 = NULL,
  new_objects = NULL,
  incl_autocor = TRUE,
  internal = FALSE,
  control = list(),
  ...
)

standata(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{newdata2}{A named \code{list} of objects containing new data, which
cannot be passed via argument \code{newdata}. Required for some objects 
used in autocorrelation structures, or \code{\link{stanvars}}.}

\item{new_objects}{Deprecated alias of \code{newdata2}.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{internal}{Logical, indicates if the data should be prepared 
for internal use in other post-processing methods.}

\item{control}{A named list currently for internal usage only.}

\item{...}{More arguments passed to \code{\link{make_standata}}.}
}
\value{
A named list containing the data originally passed to Stan.
}
\description{
Extract all data that was used by Stan to fit the model.
}
