% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_trace.R
\name{bold_trace}
\alias{bold_trace}
\alias{read_trace}
\title{Get BOLD trace files}
\usage{
bold_trace(taxon = NULL, ids = NULL, bin = NULL, container = NULL,
  institutions = NULL, researchers = NULL, geo = NULL,
  marker = NULL, dest = NULL, overwrite = TRUE, progress = TRUE,
  ...)

read_trace(x)
}
\arguments{
\item{taxon}{(character) Returns all records containing matching taxa. Taxa 
includes the ranks of  phylum, class, order, family, subfamily, genus, 
and species.}

\item{ids}{(character) Returns all records containing matching IDs. IDs 
include Sample IDs, Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) Returns all records contained in matching BINs. A 
BIN is defined by a Barcode Index Number URI.}

\item{container}{(character) Returns all records contained in matching 
projects or datasets. Containers include project codes and dataset codes}

\item{institutions}{(character) Returns all records stored in matching 
institutions. Institutions are the Specimen Storing Site.}

\item{researchers}{(character) Returns all records containing matching 
researcher names. Researchers include collectors and specimen identifiers.}

\item{geo}{(character) Returns all records collected in matching geographic 
sites. Geographic sites includes countries and province/states.}

\item{marker}{(character) Returns all records containing matching
marker codes.}

\item{dest}{(character) A directory to write the files to}

\item{overwrite}{(logical) Overwrite existing directory and file?}

\item{progress}{(logical) Print progress or not. NOT AVAILABLE FOR NOW.
HOPEFULLY WILL RETURN SOON.}

\item{...}{Further args passed on to \code{\link[crul]{HttpClient}}}

\item{x}{Object to print or read.}
}
\description{
Get BOLD trace files
}
\examples{
\dontrun{
# Use a specific destination directory
bold_trace(taxon='Bombus', geo='Alaska', dest="~/mytarfiles")

# Another example
# bold_trace(ids='ACRJP618-11', dest="~/mytarfiles")
# bold_trace(ids=c('ACRJP618-11','ACRJP619-11'), dest="~/mytarfiles")

# read file in
x <- bold_trace(ids=c('ACRJP618-11','ACRJP619-11'), dest="~/mytarfiles")
(res <- read_trace(x$ab1[2]))

# The progress dialog is pretty verbose, so quiet=TRUE is a nice touch,
# but not by default
# Beware, this one take a while
# x <- bold_trace(taxon='Osmia', quiet=TRUE)

if (requireNamespace("sangerseqR", quietly = TRUE)) {
 library("sangerseqR")
 primarySeq(res)
 secondarySeq(res)
 head(traceMatrix(res))
}
}
}
\references{
\url{http://v4.boldsystems.org/index.php/resources/api?type=webservices}
}
