% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical.controls.R
\name{empirical.controls}
\alias{empirical.controls}
\title{A function for estimating the probability that each gene is an empirical control}
\usage{
empirical.controls(
  dat,
  mod,
  mod0 = NULL,
  n.sv,
  B = 5,
  type = c("norm", "counts")
)
}
\arguments{
\item{dat}{The transformed data matrix with the variables in rows and samples in columns}

\item{mod}{The model matrix being used to fit the data}

\item{mod0}{The null model being compared when fitting the data}

\item{n.sv}{The number of surogate variables to estimate}

\item{B}{The number of iterations of the irwsva algorithm to perform}

\item{type}{If type is norm then standard irwsva is applied, if type is counts, then the moderated log transform is applied first}
}
\value{
pcontrol A vector of probabilites that each gene is a control.
}
\description{
This function uses the iteratively reweighted surrogate variable analysis approach
to estimate the probability that each gene is an empirical control.
}
\examples{
library(bladderbatch)
data(bladderdata)
dat <- bladderEset[1:5000,]

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)

n.sv = num.sv(edata,mod,method="leek")
pcontrol <- empirical.controls(edata,mod,mod0=NULL,n.sv=n.sv,type="norm")

}
