% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mefisto.R
\name{plot_factors_vs_cov}
\alias{plot_factors_vs_cov}
\title{Scatterplots of a factor's values againt the sample covariates}
\usage{
plot_factors_vs_cov(
  object,
  factors = "all",
  covariates = NULL,
  warped = TRUE,
  show_missing = TRUE,
  scale = FALSE,
  color_by = NULL,
  shape_by = NULL,
  color_name = NULL,
  shape_name = NULL,
  dot_size = 1.5,
  alpha = 1,
  stroke = NULL,
  legend = TRUE,
  rotate_x = FALSE,
  rotate_y = FALSE,
  return_data = FALSE,
  show_variance = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object using MEFISTO.}

\item{factors}{character or numeric specifying the factor(s) to plot, default is "all"}

\item{covariates}{specifies sample covariate(s) to plot against:
(1) a character giving the name of a column present in the sample covariates or sample metadata.
(2) a character giving the name of a feature present in the training data.
(3) a vector of the same length as the number of samples specifying continuous numeric values per sample.
Default is the first sample covariates in covariates slot}

\item{warped}{logical indicating whether to show the aligned covariate (default: TRUE), 
only relevant if warping has been used to align multiple sample groups}

\item{show_missing}{(for 1-dim covariates) logical indicating whether to include samples for which \code{shape_by} or \code{color_by} is missing}

\item{scale}{logical indicating whether to scale factor values.}

\item{color_by}{(for 1-dim covariates) specifies groups or values used to color the samples. This can be either:
(1) a character giving the name of a feature present in the training data.
(2) a character giving the same of a column present in the sample metadata.
(3) a vector of the same length as the number of samples specifying discrete groups or continuous numeric values.}

\item{shape_by}{(for 1-dim covariates) specifies groups or values used to shape the samples. This can be either:
(1) a character giving the name of a feature present in the training data, 
(2) a character giving the same of a column present in the sample metadata.
(3) a vector of the same length as the number of samples specifying discrete groups.}

\item{color_name}{(for 1-dim covariates) name for color legend.}

\item{shape_name}{(for 1-dim covariates) name for shape legend.}

\item{dot_size}{(for 1-dim covariates) numeric indicating dot size.}

\item{alpha}{(for 1-dim covariates) numeric indicating dot transparency.}

\item{stroke}{(for 1-dim covariates) numeric indicating the stroke size}

\item{legend}{(for 1-dim covariates) logical indicating whether to add legend.}

\item{rotate_x}{(for spatial, 2-dim covariates) Rotate covariate on x-axis}

\item{rotate_y}{(for spatial, 2-dim covariates) Rotate covariate on y-axis}

\item{return_data}{logical indicating whether to return the data frame to plot instead of plotting}

\item{show_variance}{(for 1-dim covariates) logical indicating whether to show the marginal variance of inferred factor values 
(only relevant for 1-dimensional covariates)}
}
\value{
Returns a \code{ggplot2} object
}
\description{
Scatterplots of a factor's values againt the sample covariates
}
\details{
To investigate the factors pattern along the covariates (such as time or a spatial coordinate) 
this function an be used to plot a scatterplot of the factor againt the values of each covariate
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "MEFISTO_model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_factors_vs_cov(model)
}
