% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportStats.R
\name{exportStats}
\alias{exportStats}
\title{Various statistics of the count data.}
\usage{
exportStats(obj, p = cumNormStat(obj), file = "~/Desktop/res.stats.tsv")
}
\arguments{
\item{obj}{A MRexperiment object with count data.}

\item{p}{Quantile value to calculate the scaling factor and quantiles for
the various samples.}

\item{file}{Output file name.}
}
\value{
None.
}
\description{
A matrix of values for each sample. The matrix consists of sample ids, the
sample scaling factor, quantile value, the number identified features, and library size (depth of coverage).
}
\examples{

data(lungData)
dataDirectory <- system.file("extdata", package="metagenomeSeq")
exportStats(lungData[,1:5],file=file.path(dataDirectory,"tmp.tsv"))
head(read.csv(file=file.path(dataDirectory,"tmp.tsv"),sep="\\t"))

}
\seealso{
\code{\link{cumNorm}} \code{\link{quantile}}
}
