% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmSQTLtest.R
\docType{class}
\name{dmSQTLtest-class}
\alias{dmSQTLtest-class}
\alias{results,dmSQTLtest-method}
\title{dmSQTLtest object}
\usage{
\S4method{results}{dmSQTLtest}(x)
}
\arguments{
\item{x}{dmSQTLtest object.}

\item{...}{Other parameters that can be defined by methods using this 
generic.}
}
\value{
\itemize{ \item \code{results(x)}: Get a data frame with gene-level results. 
}
}
\description{
dmSQTLtest extends the \code{\linkS4class{dmSQTLfit}} class by adding the 
null model Dirichlet-multinomial likelihoods and the gene-level results of 
testing for differential transcript/exon usage QTLs. Result of 
\code{\link{dmTest}}.
}
\section{Slots}{

\describe{
\item{\code{lik_null}}{List of numeric vectors with the per gene-snp DM null model 
likelihoods.}

\item{\code{results_gene}}{Data frame with the gene-level results including: 
\code{gene_id} - gene IDs, \code{block_id} - block IDs, \code{snp_id} - SNP
IDs, \code{lr} - likelihood ratio statistics based on the DM model, 
\code{df} - degrees of freedom, \code{pvalue} - p-values estimated based on
permutations and \code{adj_pvalue} - Benjamini & Hochberg adjusted 
p-values.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmSQTLdata object
# --------------------------------------------------------------------------
# Use subsets of data defined in the GeuvadisTranscriptExpr package

library(GeuvadisTranscriptExpr)

geuv_counts <- GeuvadisTranscriptExpr::counts
geuv_genotypes <- GeuvadisTranscriptExpr::genotypes
geuv_gene_ranges <- GeuvadisTranscriptExpr::gene_ranges
geuv_snp_ranges <- GeuvadisTranscriptExpr::snp_ranges

colnames(geuv_counts)[c(1,2)] <- c("feature_id", "gene_id")
colnames(geuv_genotypes)[4] <- "snp_id"
geuv_samples <- data.frame(sample_id = colnames(geuv_counts)[-c(1,2)])

d <- dmSQTLdata(counts = geuv_counts, gene_ranges = geuv_gene_ranges,  
  genotypes = geuv_genotypes, snp_ranges = geuv_snp_ranges, 
  samples = geuv_samples, window = 5e3)

# --------------------------------------------------------------------------
# sQTL analysis - simple group comparison
# --------------------------------------------------------------------------

## Filtering
d <- dmFilter(d, min_samps_gene_expr = 70, min_samps_feature_expr = 5,
  minor_allele_freq = 5, min_gene_expr = 10, min_feature_expr = 10)
  
plotData(d)

## To make the analysis reproducible
set.seed(123)
## Calculate precision
d <- dmPrecision(d)

plotPrecision(d)

## Fit full model proportions
d <- dmFit(d)

## Fit null model proportions, perform the LR test to detect tuQTLs 
## and use the permutation approach to adjust the p-values
d <- dmTest(d)

## Plot the gene-level p-values
plotPValues(d)

## Get the gene-level results
head(results(d))

}
\seealso{
\code{\linkS4class{dmSQTLdata}}, 
  \code{\linkS4class{dmSQTLprecision}}, \code{\linkS4class{dmSQTLfit}}
}
\author{
Malgorzata Nowicka
}
