#
# PySNMP MIB module IP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/IP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:17:37 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, SingleValueConstraint, ConstraintsIntersection, ValueRangeConstraint, ConstraintsUnion, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "SingleValueConstraint", "ConstraintsIntersection", "ValueRangeConstraint", "ConstraintsUnion")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( InetAddress, InetVersion, InetAddressPrefixLength, InetZoneIndex, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetVersion", "InetAddressPrefixLength", "InetZoneIndex", "InetAddressType")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, ModuleIdentity, TimeTicks, Counter64, NotificationType, Integer32, Unsigned32, ObjectIdentity, Gauge32, zeroDotZero, iso, MibIdentifier, Bits, mib_2, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "ModuleIdentity", "TimeTicks", "Counter64", "NotificationType", "Integer32", "Unsigned32", "ObjectIdentity", "Gauge32", "zeroDotZero", "iso", "MibIdentifier", "Bits", "mib-2", "Counter32")
( DisplayString, TextualConvention, StorageType, RowStatus, PhysAddress, TimeStamp, TestAndIncr, TruthValue, RowPointer, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention", "StorageType", "RowStatus", "PhysAddress", "TimeStamp", "TestAndIncr", "TruthValue", "RowPointer")
ipMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 48)).setRevisions(("2006-02-02 00:00", "1994-11-01 00:00", "1991-03-31 00:00",))
if mibBuilder.loadTexts: ipMIB.setLastUpdated('200602020000Z')
if mibBuilder.loadTexts: ipMIB.setOrganization('IETF IPv6 MIB Revision Team')
if mibBuilder.loadTexts: ipMIB.setContactInfo('Editor:\n\n\n            Shawn A. Routhier\n            Interworking Labs\n            108 Whispering Pines Dr. Suite 235\n            Scotts Valley, CA 95066\n            USA\n            EMail: <sar@iwl.com>')
if mibBuilder.loadTexts: ipMIB.setDescription('The MIB module for managing IP and ICMP implementations, but\n            excluding their management of IP routes.\n\n            Copyright (C) The Internet Society (2006).  This version of\n            this MIB module is part of RFC 4293; see the RFC itself for\n            full legal notices.')
class IpAddressOriginTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5, 6,))
    namedValues = NamedValues(("other", 1), ("manual", 2), ("dhcp", 4), ("linklayer", 5), ("random", 6),)

class IpAddressStatusTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))
    namedValues = NamedValues(("preferred", 1), ("deprecated", 2), ("invalid", 3), ("inaccessible", 4), ("unknown", 5), ("tentative", 6), ("duplicate", 7), ("optimistic", 8),)

class IpAddressPrefixOriginTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))
    namedValues = NamedValues(("other", 1), ("manual", 2), ("wellknown", 3), ("dhcp", 4), ("routeradv", 5),)

class Ipv6AddressIfIdentifierTC(OctetString, TextualConvention):
    displayHint = '2x:'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,8)

ip = MibIdentifier((1, 3, 6, 1, 2, 1, 4))
ipForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipForwarding.setDescription('The indication of whether this entity is acting as an IPv4\n            router in respect to the forwarding of datagrams received\n            by, but not addressed to, this entity.  IPv4 routers forward\n            datagrams.  IPv4 hosts do not (except those source-routed\n            via the host).\n\n            When this object is written, the entity should save the\n            change to non-volatile storage and restore the object from\n            non-volatile storage upon re-initialization of the system.\n            Note: a stronger requirement is not used because this object\n            was previously defined.')
ipDefaultTTL = MibScalar((1, 3, 6, 1, 2, 1, 4, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipDefaultTTL.setDescription('The default value inserted into the Time-To-Live field of\n            the IPv4 header of datagrams originated at this entity,\n            whenever a TTL value is not supplied by the transport layer\n\n\n            protocol.\n\n            When this object is written, the entity should save the\n            change to non-volatile storage and restore the object from\n            non-volatile storage upon re-initialization of the system.\n            Note: a stronger requirement is not used because this object\n            was previously defined.')
ipReasmTimeout = MibScalar((1, 3, 6, 1, 2, 1, 4, 13), Integer32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmTimeout.setDescription('The maximum number of seconds that received fragments are\n            held while they are awaiting reassembly at this entity.')
ipv6IpForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 25), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IpForwarding.setDescription('The indication of whether this entity is acting as an IPv6\n            router on any interface in respect to the forwarding of\n            datagrams received by, but not addressed to, this entity.\n            IPv6 routers forward datagrams.  IPv6 hosts do not (except\n            those source-routed via the host).\n\n            When this object is written, the entity SHOULD save the\n            change to non-volatile storage and restore the object from\n            non-volatile storage upon re-initialization of the system.')
ipv6IpDefaultHopLimit = MibScalar((1, 3, 6, 1, 2, 1, 4, 26), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IpDefaultHopLimit.setDescription('The default value inserted into the Hop Limit field of the\n            IPv6 header of datagrams originated at this entity whenever\n            a Hop Limit value is not supplied by the transport layer\n            protocol.\n\n            When this object is written, the entity SHOULD save the\n            change to non-volatile storage and restore the object from\n            non-volatile storage upon re-initialization of the system.')
ipv4InterfaceTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 27), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceTableLastChange.setDescription('The value of sysUpTime on the most recent occasion at which\n            a row in the ipv4InterfaceTable was added or deleted, or\n            when an ipv4InterfaceReasmMaxSize or an\n            ipv4InterfaceEnableStatus object was modified.\n\n            If new objects are added to the ipv4InterfaceTable that\n            require the ipv4InterfaceTableLastChange to be updated when\n            they are modified, they must specify that requirement in\n            their description clause.')
ipv4InterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 4, 28), )
if mibBuilder.loadTexts: ipv4InterfaceTable.setDescription('The table containing per-interface IPv4-specific\n            information.')
ipv4InterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 28, 1), ).setIndexNames((0, "IP-MIB", "ipv4InterfaceIfIndex"))
if mibBuilder.loadTexts: ipv4InterfaceEntry.setDescription('An entry containing IPv4-specific information for a specific\n            interface.')
ipv4InterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv4InterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to\n            which this entry is applicable.  The interface identified by\n            a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipv4InterfaceReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceReasmMaxSize.setDescription('The size of the largest IPv4 datagram that this entity can\n            re-assemble from incoming IPv4 fragmented datagrams received\n            on this interface.')
ipv4InterfaceEnableStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv4InterfaceEnableStatus.setDescription('The indication of whether IPv4 is enabled (up) or disabled\n            (down) on this interface.  This object does not affect the\n            state of the interface itself, only its connection to an\n            IPv4 stack.  The IF-MIB should be used to control the state\n            of the interface.')
ipv4InterfaceRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 4), Unsigned32().clone(1000)).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceRetransmitTime.setDescription('The time between retransmissions of ARP requests to a\n            neighbor when resolving the address or when probing the\n            reachability of a neighbor.')
ipv6InterfaceTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 29), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceTableLastChange.setDescription('The value of sysUpTime on the most recent occasion at which\n            a row in the ipv6InterfaceTable was added or deleted or when\n            an ipv6InterfaceReasmMaxSize, ipv6InterfaceIdentifier,\n            ipv6InterfaceEnableStatus, ipv6InterfaceReachableTime,\n            ipv6InterfaceRetransmitTime, or ipv6InterfaceForwarding\n            object was modified.\n\n            If new objects are added to the ipv6InterfaceTable that\n            require the ipv6InterfaceTableLastChange to be updated when\n            they are modified, they must specify that requirement in\n            their description clause.')
ipv6InterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 4, 30), )
if mibBuilder.loadTexts: ipv6InterfaceTable.setDescription('The table containing per-interface IPv6-specific\n            information.')
ipv6InterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 30, 1), ).setIndexNames((0, "IP-MIB", "ipv6InterfaceIfIndex"))
if mibBuilder.loadTexts: ipv6InterfaceEntry.setDescription('An entry containing IPv6-specific information for a given\n            interface.')
ipv6InterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv6InterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to\n            which this entry is applicable.  The interface identified by\n            a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipv6InterfaceReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1500,65535))).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceReasmMaxSize.setDescription('The size of the largest IPv6 datagram that this entity can\n            re-assemble from incoming IPv6 fragmented datagrams received\n            on this interface.')
ipv6InterfaceIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 3), Ipv6AddressIfIdentifierTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceIdentifier.setDescription('The Interface Identifier for this interface.  The Interface\n            Identifier is combined with an address prefix to form an\n            interface address.\n\n            By default, the Interface Identifier is auto-configured\n            according to the rules of the link type to which this\n            interface is attached.\n\n\n            A zero length identifier may be used where appropriate.  One\n            possible example is a loopback interface.')
ipv6InterfaceEnableStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6InterfaceEnableStatus.setDescription('The indication of whether IPv6 is enabled (up) or disabled\n            (down) on this interface.  This object does not affect the\n            state of the interface itself, only its connection to an\n            IPv6 stack.  The IF-MIB should be used to control the state\n            of the interface.\n\n            When this object is written, the entity SHOULD save the\n            change to non-volatile storage and restore the object from\n            non-volatile storage upon re-initialization of the system.')
ipv6InterfaceReachableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 6), Unsigned32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceReachableTime.setDescription('The time a neighbor is considered reachable after receiving\n            a reachability confirmation.')
ipv6InterfaceRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 7), Unsigned32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceRetransmitTime.setDescription('The time between retransmissions of Neighbor Solicitation\n            messages to a neighbor when resolving the address or when\n            probing the reachability of a neighbor.')
ipv6InterfaceForwarding = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6InterfaceForwarding.setDescription('The indication of whether this entity is acting as an IPv6\n            router on this interface with respect to the forwarding of\n            datagrams received by, but not addressed to, this entity.\n            IPv6 routers forward datagrams.  IPv6 hosts do not (except\n            those source-routed via the host).\n\n            This object is constrained by ipv6IpForwarding and is\n            ignored if ipv6IpForwarding is set to notForwarding.  Those\n            systems that do not provide per-interface control of the\n            forwarding function should set this object to forwarding for\n            all interfaces and allow the ipv6IpForwarding object to\n            control the forwarding capability.\n\n            When this object is written, the entity SHOULD save the\n            change to non-volatile storage and restore the object from\n            non-volatile storage upon re-initialization of the system.')
ipTrafficStats = MibIdentifier((1, 3, 6, 1, 2, 1, 4, 31))
ipSystemStatsTable = MibTable((1, 3, 6, 1, 2, 1, 4, 31, 1), )
if mibBuilder.loadTexts: ipSystemStatsTable.setDescription('The table containing system wide, IP version specific\n            traffic statistics.  This table and the ipIfStatsTable\n            contain similar objects whose difference is in their\n            granularity.  Where this table contains system wide traffic\n            statistics, the ipIfStatsTable contains the same statistics\n            but counted on a per-interface basis.')
ipSystemStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 31, 1, 1), ).setIndexNames((0, "IP-MIB", "ipSystemStatsIPVersion"))
if mibBuilder.loadTexts: ipSystemStatsEntry.setDescription('A statistics entry containing system-wide objects for a\n            particular IP version.')
ipSystemStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 1), InetVersion())
if mibBuilder.loadTexts: ipSystemStatsIPVersion.setDescription('The IP version of this row.')
ipSystemStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInReceives.setDescription('The total number of input IP datagrams received, including\n            those received in error.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInReceives.setDescription('The total number of input IP datagrams received, including\n            those received in error.  This object counts the same\n            datagrams as ipSystemStatsInReceives, but allows for larger\n            values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInOctets.setDescription('The total number of octets received in input IP datagrams,\n            including those received in error.  Octets from datagrams\n            counted in ipSystemStatsInReceives MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInOctets.setDescription('The total number of octets received in input IP datagrams,\n            including those received in error.  This object counts the\n            same octets as ipSystemStatsInOctets, but allows for larger\n\n\n            values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInHdrErrors.setDescription('The number of input IP datagrams discarded due to errors in\n            their IP headers, including version number mismatch, other\n            format errors, hop count exceeded, errors discovered in\n            processing their IP options, etc.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInNoRoutes.setDescription('The number of input IP datagrams discarded because no route\n            could be found to transmit them to their destination.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInAddrErrors.setDescription("The number of input IP datagrams discarded because the IP\n            address in their IP header's destination field was not a\n            valid address to be received at this entity.  This count\n            includes invalid addresses (e.g., ::0).  For entities\n            that are not IP routers and therefore do not forward\n\n\n            datagrams, this counter includes datagrams discarded\n            because the destination address was not a local address.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.")
ipSystemStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInUnknownProtos.setDescription('The number of locally-addressed IP datagrams received\n            successfully but discarded because of an unknown or\n            unsupported protocol.\n\n            When tracking interface statistics, the counter of the\n            interface to which these datagrams were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the datagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInTruncatedPkts.setDescription("The number of input IP datagrams discarded because the\n            datagram frame didn't carry enough data.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.")
ipSystemStatsInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInForwDatagrams.setDescription('The number of input datagrams for which this entity was not\n            their final IP destination and for which this entity\n            attempted to find a route to forward them to that final\n            destination.  In entities that do not act as IP routers,\n            this counter will include only those datagrams that were\n            Source-Routed via this entity, and the Source-Route\n            processing was successful.\n\n            When tracking interface statistics, the counter of the\n            incoming interface is incremented for each datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInForwDatagrams.setDescription('The number of input datagrams for which this entity was not\n            their final IP destination and for which this entity\n            attempted to find a route to forward them to that final\n            destination.  This object counts the same packets as\n            ipSystemStatsInForwDatagrams, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmReqds.setDescription('The number of IP fragments received that needed to be\n            reassembled at this interface.\n\n            When tracking interface statistics, the counter of the\n            interface to which these fragments were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the fragments.\n\n            Discontinuities in the value of this counter can occur at\n\n\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmOKs.setDescription('The number of IP datagrams successfully reassembled.\n\n            When tracking interface statistics, the counter of the\n            interface to which these datagrams were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the datagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmFails.setDescription('The number of failures detected by the IP re-assembly\n            algorithm (for whatever reason: timed out, errors, etc.).\n            Note that this is not necessarily a count of discarded IP\n            fragments since some algorithms (notably the algorithm in\n            RFC 815) can lose track of the number of fragments by\n            combining them as they are received.\n\n            When tracking interface statistics, the counter of the\n            interface to which these fragments were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the fragments.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInDiscards.setDescription('The number of input IP datagrams for which no problems were\n            encountered to prevent their continued processing, but\n            were discarded (e.g., for lack of buffer space).  Note that\n            this counter does not include any datagrams discarded while\n            awaiting re-assembly.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInDelivers.setDescription('The total number of datagrams successfully delivered to IP\n            user-protocols (including ICMP).\n\n            When tracking interface statistics, the counter of the\n            interface to which these datagrams were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the datagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInDelivers.setDescription('The total number of datagrams successfully delivered to IP\n            user-protocols (including ICMP).  This object counts the\n            same packets as ipSystemStatsInDelivers, but allows for\n            larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutRequests.setDescription('The total number of IP datagrams that local IP user-\n            protocols (including ICMP) supplied to IP in requests for\n            transmission.  Note that this counter does not include any\n            datagrams counted in ipSystemStatsOutForwDatagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutRequests.setDescription('The total number of IP datagrams that local IP user-\n            protocols (including ICMP) supplied to IP in requests for\n            transmission.  This object counts the same packets as\n            ipSystemStatsOutRequests, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutNoRoutes.setDescription('The number of locally generated IP datagrams discarded\n            because no route could be found to transmit them to their\n            destination.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their\n            final IP destination and for which it was successful in\n            finding a path to their final destination.  In entities\n            that do not act as IP routers, this counter will include\n            only those datagrams that were Source-Routed via this\n            entity, and the Source-Route processing was successful.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            forwarded datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their\n            final IP destination and for which it was successful in\n            finding a path to their final destination.  This object\n            counts the same packets as ipSystemStatsOutForwDatagrams,\n            but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutDiscards.setDescription('The number of output IP datagrams for which no problem was\n            encountered to prevent their transmission to their\n            destination, but were discarded (e.g., for lack of\n            buffer space).  Note that this counter would include\n\n\n            datagrams counted in ipSystemStatsOutForwDatagrams if any\n            such datagrams met this (discretionary) discard criterion.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragReqds.setDescription('The number of IP datagrams that would require fragmentation\n            in order to be transmitted.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragOKs.setDescription('The number of IP datagrams that have been successfully\n            fragmented.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragFails.setDescription('The number of IP datagrams that have been discarded because\n            they needed to be fragmented but could not be.  This\n            includes IPv4 packets that have the DF bit set and IPv6\n            packets that are being forwarded and exceed the outgoing\n            link MTU.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for an unsuccessfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragCreates.setDescription('The number of output datagram fragments that have been\n            generated as a result of IP fragmentation.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutTransmits.setDescription('The total number of IP datagrams that this entity supplied\n            to the lower layers for transmission.  This includes\n            datagrams generated locally and those forwarded by this\n            entity.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n\n\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 31), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutTransmits.setDescription('The total number of IP datagrams that this entity supplied\n            to the lower layers for transmission.  This object counts\n            the same datagrams as ipSystemStatsOutTransmits, but allows\n            for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutOctets.setDescription('The total number of octets in IP datagrams delivered to the\n            lower layers for transmission.  Octets from datagrams\n            counted in ipSystemStatsOutTransmits MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 33), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutOctets.setDescription('The total number of octets in IP datagrams delivered to the\n            lower layers for transmission.  This objects counts the same\n            octets as ipSystemStatsOutOctets, but allows for larger\n            values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n\n\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInMcastPkts.setDescription('The number of IP multicast datagrams received.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 35), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInMcastPkts.setDescription('The number of IP multicast datagrams received.  This object\n            counts the same datagrams as ipSystemStatsInMcastPkts but\n            allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInMcastOctets.setDescription('The total number of octets received in IP multicast\n            datagrams.  Octets from datagrams counted in\n            ipSystemStatsInMcastPkts MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 37), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInMcastOctets.setDescription('The total number of octets received in IP multicast\n            datagrams.  This object counts the same octets as\n            ipSystemStatsInMcastOctets, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 39), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted.  This\n            object counts the same datagrams as\n            ipSystemStatsOutMcastPkts, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast\n            datagrams.  Octets from datagrams counted in\n\n\n            ipSystemStatsOutMcastPkts MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 41), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast\n            datagrams.  This object counts the same octets as\n            ipSystemStatsOutMcastOctets, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInBcastPkts.setDescription('The number of IP broadcast datagrams received.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 43), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInBcastPkts.setDescription('The number of IP broadcast datagrams received.  This object\n            counts the same datagrams as ipSystemStatsInBcastPkts but\n            allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n\n\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsHCOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 45), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted.  This\n            object counts the same datagrams as\n            ipSystemStatsOutBcastPkts, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipSystemStatsDiscontinuityTime.')
ipSystemStatsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 46), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\n            any one or more of this entry's counters suffered a\n            discontinuity.\n\n            If no such discontinuities have occurred since the last re-\n            initialization of the local management subsystem, then this\n            object contains a zero value.")
ipSystemStatsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 47), Unsigned32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsRefreshRate.setDescription('The minimum reasonable polling interval for this entry.\n            This object provides an indication of the minimum amount of\n            time required to update the counters in this entry.')
ipIfStatsTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 31, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsTableLastChange.setDescription('The value of sysUpTime on the most recent occasion at which\n            a row in the ipIfStatsTable was added or deleted.\n\n            If new objects are added to the ipIfStatsTable that require\n            the ipIfStatsTableLastChange to be updated when they are\n            modified, they must specify that requirement in their\n            description clause.')
ipIfStatsTable = MibTable((1, 3, 6, 1, 2, 1, 4, 31, 3), )
if mibBuilder.loadTexts: ipIfStatsTable.setDescription('The table containing per-interface traffic statistics.  This\n            table and the ipSystemStatsTable contain similar objects\n            whose difference is in their granularity.  Where this table\n            contains per-interface statistics, the ipSystemStatsTable\n            contains the same statistics, but counted on a system wide\n            basis.')
ipIfStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 31, 3, 1), ).setIndexNames((0, "IP-MIB", "ipIfStatsIPVersion"), (0, "IP-MIB", "ipIfStatsIfIndex"))
if mibBuilder.loadTexts: ipIfStatsEntry.setDescription('An interface statistics entry containing objects for a\n            particular interface and version of IP.')
ipIfStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 1), InetVersion())
if mibBuilder.loadTexts: ipIfStatsIPVersion.setDescription('The IP version of this row.')
ipIfStatsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 2), InterfaceIndex())
if mibBuilder.loadTexts: ipIfStatsIfIndex.setDescription("The index value that uniquely identifies the interface to\n            which this entry is applicable.  The interface identified by\n            a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipIfStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInReceives.setDescription('The total number of input IP datagrams received, including\n            those received in error.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInReceives.setDescription('The total number of input IP datagrams received, including\n            those received in error.  This object counts the same\n            datagrams as ipIfStatsInReceives, but allows for larger\n            values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInOctets.setDescription('The total number of octets received in input IP datagrams,\n            including those received in error.  Octets from datagrams\n            counted in ipIfStatsInReceives MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInOctets.setDescription('The total number of octets received in input IP datagrams,\n            including those received in error.  This object counts the\n            same octets as ipIfStatsInOctets, but allows for larger\n            values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInHdrErrors.setDescription('The number of input IP datagrams discarded due to errors in\n            their IP headers, including version number mismatch, other\n            format errors, hop count exceeded, errors discovered in\n            processing their IP options, etc.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInNoRoutes.setDescription('The number of input IP datagrams discarded because no route\n            could be found to transmit them to their destination.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInAddrErrors.setDescription("The number of input IP datagrams discarded because the IP\n            address in their IP header's destination field was not a\n            valid address to be received at this entity.  This count\n            includes invalid addresses (e.g., ::0).  For entities that\n            are not IP routers and therefore do not forward datagrams,\n            this counter includes datagrams discarded because the\n            destination address was not a local address.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.")
ipIfStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInUnknownProtos.setDescription('The number of locally-addressed IP datagrams received\n            successfully but discarded because of an unknown or\n            unsupported protocol.\n\n            When tracking interface statistics, the counter of the\n            interface to which these datagrams were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the datagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n\n\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInTruncatedPkts.setDescription("The number of input IP datagrams discarded because the\n            datagram frame didn't carry enough data.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.")
ipIfStatsInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInForwDatagrams.setDescription('The number of input datagrams for which this entity was not\n            their final IP destination and for which this entity\n            attempted to find a route to forward them to that final\n            destination.  In entities that do not act as IP routers,\n            this counter will include only those datagrams that were\n            Source-Routed via this entity, and the Source-Route\n            processing was successful.\n\n            When tracking interface statistics, the counter of the\n            incoming interface is incremented for each datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInForwDatagrams.setDescription('The number of input datagrams for which this entity was not\n            their final IP destination and for which this entity\n            attempted to find a route to forward them to that final\n            destination.  This object counts the same packets as\n\n\n            ipIfStatsInForwDatagrams, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmReqds.setDescription('The number of IP fragments received that needed to be\n            reassembled at this interface.\n\n            When tracking interface statistics, the counter of the\n            interface to which these fragments were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the fragments.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmOKs.setDescription('The number of IP datagrams successfully reassembled.\n\n            When tracking interface statistics, the counter of the\n            interface to which these datagrams were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the datagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmFails.setDescription('The number of failures detected by the IP re-assembly\n            algorithm (for whatever reason: timed out, errors, etc.).\n            Note that this is not necessarily a count of discarded IP\n            fragments since some algorithms (notably the algorithm in\n            RFC 815) can lose track of the number of fragments by\n            combining them as they are received.\n\n            When tracking interface statistics, the counter of the\n            interface to which these fragments were addressed is\n            incremented.  This interface might not be the same as the\n            input interface for some of the fragments.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInDiscards.setDescription('The number of input IP datagrams for which no problems were\n            encountered to prevent their continued processing, but\n            were discarded (e.g., for lack of buffer space).  Note that\n            this counter does not include any datagrams discarded while\n            awaiting re-assembly.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInDelivers.setDescription('The total number of datagrams successfully delivered to IP\n            user-protocols (including ICMP).\n\n            When tracking interface statistics, the counter of the\n            interface to which these datagrams were addressed is\n            incremented.  This interface might not be the same as the\n\n\n            input interface for some of the datagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInDelivers.setDescription('The total number of datagrams successfully delivered to IP\n            user-protocols (including ICMP).  This object counts the\n            same packets as ipIfStatsInDelivers, but allows for larger\n            values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutRequests.setDescription('The total number of IP datagrams that local IP user-\n            protocols (including ICMP) supplied to IP in requests for\n            transmission.  Note that this counter does not include any\n            datagrams counted in ipIfStatsOutForwDatagrams.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutRequests.setDescription('The total number of IP datagrams that local IP user-\n            protocols (including ICMP) supplied to IP in requests for\n            transmission.  This object counts the same packets as\n\n\n            ipIfStatsOutRequests, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their\n            final IP destination and for which it was successful in\n            finding a path to their final destination.  In entities\n            that do not act as IP routers, this counter will include\n            only those datagrams that were Source-Routed via this\n            entity, and the Source-Route processing was successful.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            forwarded datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutForwDatagrams.setDescription('The number of datagrams for which this entity was not their\n            final IP destination and for which it was successful in\n            finding a path to their final destination.  This object\n            counts the same packets as ipIfStatsOutForwDatagrams, but\n            allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n\n\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutDiscards.setDescription('The number of output IP datagrams for which no problem was\n            encountered to prevent their transmission to their\n            destination, but were discarded (e.g., for lack of\n            buffer space).  Note that this counter would include\n            datagrams counted in ipIfStatsOutForwDatagrams if any such\n            datagrams met this (discretionary) discard criterion.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragReqds.setDescription('The number of IP datagrams that would require fragmentation\n            in order to be transmitted.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragOKs.setDescription('The number of IP datagrams that have been successfully\n            fragmented.\n\n            When tracking interface statistics, the counter of the\n\n\n            outgoing interface is incremented for a successfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragFails.setDescription('The number of IP datagrams that have been discarded because\n            they needed to be fragmented but could not be.  This\n            includes IPv4 packets that have the DF bit set and IPv6\n            packets that are being forwarded and exceed the outgoing\n            link MTU.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for an unsuccessfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragCreates.setDescription('The number of output datagram fragments that have been\n            generated as a result of IP fragmentation.\n\n            When tracking interface statistics, the counter of the\n            outgoing interface is incremented for a successfully\n            fragmented datagram.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutTransmits.setDescription('The total number of IP datagrams that this entity supplied\n            to the lower layers for transmission.  This includes\n            datagrams generated locally and those forwarded by this\n            entity.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 31), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutTransmits.setDescription('The total number of IP datagrams that this entity supplied\n            to the lower layers for transmission.  This object counts\n            the same datagrams as ipIfStatsOutTransmits, but allows for\n            larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutOctets.setDescription('The total number of octets in IP datagrams delivered to the\n            lower layers for transmission.  Octets from datagrams\n            counted in ipIfStatsOutTransmits MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 33), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutOctets.setDescription('The total number of octets in IP datagrams delivered to the\n            lower layers for transmission.  This objects counts the same\n            octets as ipIfStatsOutOctets, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInMcastPkts.setDescription('The number of IP multicast datagrams received.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 35), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInMcastPkts.setDescription('The number of IP multicast datagrams received.  This object\n            counts the same datagrams as ipIfStatsInMcastPkts, but\n            allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInMcastOctets.setDescription('The total number of octets received in IP multicast\n\n\n            datagrams.  Octets from datagrams counted in\n            ipIfStatsInMcastPkts MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 37), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInMcastOctets.setDescription('The total number of octets received in IP multicast\n            datagrams.  This object counts the same octets as\n            ipIfStatsInMcastOctets, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 39), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutMcastPkts.setDescription('The number of IP multicast datagrams transmitted.  This\n            object counts the same datagrams as ipIfStatsOutMcastPkts,\n            but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n\n\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast\n            datagrams.  Octets from datagrams counted in\n            ipIfStatsOutMcastPkts MUST be counted here.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 41), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutMcastOctets.setDescription('The total number of octets transmitted in IP multicast\n            datagrams.  This object counts the same octets as\n            ipIfStatsOutMcastOctets, but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInBcastPkts.setDescription('The number of IP broadcast datagrams received.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 43), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInBcastPkts.setDescription('The number of IP broadcast datagrams received.  This object\n            counts the same datagrams as ipIfStatsInBcastPkts, but\n            allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsHCOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 45), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutBcastPkts.setDescription('The number of IP broadcast datagrams transmitted.  This\n            object counts the same datagrams as ipIfStatsOutBcastPkts,\n            but allows for larger values.\n\n            Discontinuities in the value of this counter can occur at\n            re-initialization of the management system, and at other\n            times as indicated by the value of\n            ipIfStatsDiscontinuityTime.')
ipIfStatsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 46), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\n\n\n            any one or more of this entry's counters suffered a\n            discontinuity.\n\n            If no such discontinuities have occurred since the last re-\n            initialization of the local management subsystem, then this\n            object contains a zero value.")
ipIfStatsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 47), Unsigned32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsRefreshRate.setDescription('The minimum reasonable polling interval for this entry.\n            This object provides an indication of the minimum amount of\n            time required to update the counters in this entry.')
ipAddressPrefixTable = MibTable((1, 3, 6, 1, 2, 1, 4, 32), )
if mibBuilder.loadTexts: ipAddressPrefixTable.setDescription("This table allows the user to determine the source of an IP\n            address or set of IP addresses, and allows other tables to\n            share the information via pointer rather than by copying.\n\n            For example, when the node configures both a unicast and\n            anycast address for a prefix, the ipAddressPrefix objects\n            for those addresses will point to a single row in this\n            table.\n\n            This table primarily provides support for IPv6 prefixes, and\n            several of the objects are less meaningful for IPv4.  The\n            table continues to allow IPv4 addresses to allow future\n            flexibility.  In order to promote a common configuration,\n            this document includes suggestions for default values for\n            IPv4 prefixes.  Each of these values may be overridden if an\n            object is meaningful to the node.\n\n            All prefixes used by this entity should be included in this\n            table independent of how the entity learned the prefix.\n            (This table isn't limited to prefixes learned from router\n\n\n            advertisements.)")
ipAddressPrefixEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 32, 1), ).setIndexNames((0, "IP-MIB", "ipAddressPrefixIfIndex"), (0, "IP-MIB", "ipAddressPrefixType"), (0, "IP-MIB", "ipAddressPrefixPrefix"), (0, "IP-MIB", "ipAddressPrefixLength"))
if mibBuilder.loadTexts: ipAddressPrefixEntry.setDescription('An entry in the ipAddressPrefixTable.')
ipAddressPrefixIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipAddressPrefixIfIndex.setDescription("The index value that uniquely identifies the interface on\n            which this prefix is configured.  The interface identified\n            by a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipAddressPrefixType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 2), InetAddressType())
if mibBuilder.loadTexts: ipAddressPrefixType.setDescription('The address type of ipAddressPrefix.')
ipAddressPrefixPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 3), InetAddress())
if mibBuilder.loadTexts: ipAddressPrefixPrefix.setDescription('The address prefix.  The address type of this object is\n            specified in ipAddressPrefixType.  The length of this object\n            is the standard length for objects of that type (4 or 16\n            bytes).  Any bits after ipAddressPrefixLength must be zero.\n\n            Implementors need to be aware that, if the size of\n            ipAddressPrefixPrefix exceeds 114 octets, then OIDS of\n            instances of columns in this row will have more than 128\n            sub-identifiers and cannot be accessed using SNMPv1,\n            SNMPv2c, or SNMPv3.')
ipAddressPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 4), InetAddressPrefixLength())
if mibBuilder.loadTexts: ipAddressPrefixLength.setDescription("The prefix length associated with this prefix.\n\n            The value 0 has no special meaning for this object.  It\n            simply refers to address '::/0'.")
ipAddressPrefixOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 5), IpAddressPrefixOriginTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixOrigin.setDescription('The origin of this prefix.')
ipAddressPrefixOnLinkFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixOnLinkFlag.setDescription("This object has the value 'true(1)', if this prefix can be\n            used for on-link determination; otherwise, the value is\n            'false(2)'.\n\n            The default for IPv4 prefixes is 'true(1)'.")
ipAddressPrefixAutonomousFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAutonomousFlag.setDescription("Autonomous address configuration flag.  When true(1),\n            indicates that this prefix can be used for autonomous\n            address configuration (i.e., can be used to form a local\n            interface address).  If false(2), it is not used to auto-\n            configure a local interface address.\n\n            The default for IPv4 prefixes is 'false(2)'.")
ipAddressPrefixAdvPreferredLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 8), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAdvPreferredLifetime.setDescription('The remaining length of time, in seconds, that this prefix\n            will continue to be preferred, i.e., time until deprecation.\n\n            A value of 4,294,967,295 represents infinity.\n\n            The address generated from a deprecated prefix should no\n            longer be used as a source address in new communications,\n            but packets received on such an interface are processed as\n            expected.\n\n            The default for IPv4 prefixes is 4,294,967,295 (infinity).')
ipAddressPrefixAdvValidLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 9), Unsigned32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAdvValidLifetime.setDescription('The remaining length of time, in seconds, that this prefix\n            will continue to be valid, i.e., time until invalidation.  A\n            value of 4,294,967,295 represents infinity.\n\n            The address generated from an invalidated prefix should not\n            appear as the destination or source address of a packet.\n\n\n            The default for IPv4 prefixes is 4,294,967,295 (infinity).')
ipAddressSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 4, 33), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipAddressSpinLock.setDescription("An advisory lock used to allow cooperating SNMP managers to\n            coordinate their use of the set operation in creating or\n            modifying rows within this table.\n\n            In order to use this lock to coordinate the use of set\n            operations, managers should first retrieve\n            ipAddressTableSpinLock.  They should then determine the\n            appropriate row to create or modify.  Finally, they should\n            issue the appropriate set command, including the retrieved\n            value of ipAddressSpinLock.  If another manager has altered\n            the table in the meantime, then the value of\n            ipAddressSpinLock will have changed, and the creation will\n            fail as it will be specifying an incorrect value for\n            ipAddressSpinLock.  It is suggested, but not required, that\n            the ipAddressSpinLock be the first var bind for each set of\n            objects representing a 'row' in a PDU.")
ipAddressTable = MibTable((1, 3, 6, 1, 2, 1, 4, 34), )
if mibBuilder.loadTexts: ipAddressTable.setDescription("This table contains addressing information relevant to the\n            entity's interfaces.\n\n            This table does not contain multicast address information.\n            Tables for such information should be contained in multicast\n            specific MIBs, such as RFC 3019.\n\n            While this table is writable, the user will note that\n            several objects, such as ipAddressOrigin, are not.  The\n            intention in allowing a user to write to this table is to\n            allow them to add or remove any entry that isn't\n\n\n            permanent.  The user should be allowed to modify objects\n            and entries when that would not cause inconsistencies\n            within the table.  Allowing write access to objects, such\n            as ipAddressOrigin, could allow a user to insert an entry\n            and then label it incorrectly.\n\n            Note well: When including IPv6 link-local addresses in this\n            table, the entry must use an InetAddressType of 'ipv6z' in\n            order to differentiate between the possible interfaces.")
ipAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 34, 1), ).setIndexNames((0, "IP-MIB", "ipAddressAddrType"), (0, "IP-MIB", "ipAddressAddr"))
if mibBuilder.loadTexts: ipAddressEntry.setDescription('An address mapping for a particular interface.')
ipAddressAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 1), InetAddressType())
if mibBuilder.loadTexts: ipAddressAddrType.setDescription('The address type of ipAddressAddr.')
ipAddressAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 2), InetAddress())
if mibBuilder.loadTexts: ipAddressAddr.setDescription("The IP address to which this entry's addressing information\n\n\n            pertains.  The address type of this object is specified in\n            ipAddressAddrType.\n\n            Implementors need to be aware that if the size of\n            ipAddressAddr exceeds 116 octets, then OIDS of instances of\n            columns in this row will have more than 128 sub-identifiers\n            and cannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
ipAddressIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 3), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressIfIndex.setDescription("The index value that uniquely identifies the interface to\n            which this entry is applicable.  The interface identified by\n            a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unicast", 1), ("anycast", 2), ("broadcast", 3),)).clone('unicast')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressType.setDescription('The type of address.  broadcast(3) is not a valid value for\n            IPv6 addresses (RFC 3513).')
ipAddressPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 5), RowPointer().clone((0, 0))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefix.setDescription('A pointer to the row in the prefix table to which this\n            address belongs.  May be { 0 0 } if there is no such row.')
ipAddressOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 6), IpAddressOriginTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressOrigin.setDescription('The origin of the address.')
ipAddressStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 7), IpAddressStatusTC().clone('preferred')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressStatus.setDescription('The status of the address, describing if the address can be\n            used for communication.\n\n            In the absence of other information, an IPv4 address is\n            always preferred(1).')
ipAddressCreated = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressCreated.setDescription('The value of sysUpTime at the time this entry was created.\n            If this entry was created prior to the last re-\n            initialization of the local network management subsystem,\n            then this object contains a zero value.')
ipAddressLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressLastChanged.setDescription('The value of sysUpTime at the time this entry was last\n            updated.  If this entry was updated prior to the last re-\n            initialization of the local network management subsystem,\n            then this object contains a zero value.')
ipAddressRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressRowStatus.setDescription('The status of this conceptual row.\n\n            The RowStatus TC requires that this DESCRIPTION clause\n            states under which circumstances other objects in this row\n\n\n            can be modified.  The value of this object has no effect on\n            whether other objects in this conceptual row can be\n            modified.\n\n            A conceptual row can not be made active until the\n            ipAddressIfIndex has been set to a valid index.')
ipAddressStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 11), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressStorageType.setDescription("The storage type for this conceptual row.  If this object\n            has a value of 'permanent', then no other objects are\n            required to be able to be modified.")
ipNetToPhysicalTable = MibTable((1, 3, 6, 1, 2, 1, 4, 35), )
if mibBuilder.loadTexts: ipNetToPhysicalTable.setDescription("The IP Address Translation table used for mapping from IP\n            addresses to physical addresses.\n\n            The Address Translation tables contain the IP address to\n            'physical' address equivalences.  Some interfaces do not use\n            translation tables for determining address equivalences\n            (e.g., DDN-X.25 has an algorithmic method); if all\n            interfaces are of this type, then the Address Translation\n            table is empty, i.e., has zero entries.\n\n            While many protocols may be used to populate this table, ARP\n            and Neighbor Discovery are the most likely\n            options.")
ipNetToPhysicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 35, 1), ).setIndexNames((0, "IP-MIB", "ipNetToPhysicalIfIndex"), (0, "IP-MIB", "ipNetToPhysicalNetAddressType"), (0, "IP-MIB", "ipNetToPhysicalNetAddress"))
if mibBuilder.loadTexts: ipNetToPhysicalEntry.setDescription("Each entry contains one IP address to `physical' address\n            equivalence.")
ipNetToPhysicalIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipNetToPhysicalIfIndex.setDescription("The index value that uniquely identifies the interface to\n            which this entry is applicable.  The interface identified by\n            a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipNetToPhysicalNetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 2), InetAddressType())
if mibBuilder.loadTexts: ipNetToPhysicalNetAddressType.setDescription('The type of ipNetToPhysicalNetAddress.')
ipNetToPhysicalNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 3), InetAddress())
if mibBuilder.loadTexts: ipNetToPhysicalNetAddress.setDescription("The IP Address corresponding to the media-dependent\n            `physical' address.  The address type of this object is\n            specified in ipNetToPhysicalAddressType.\n\n            Implementors need to be aware that if the size of\n\n\n            ipNetToPhysicalNetAddress exceeds 115 octets, then OIDS of\n            instances of columns in this row will have more than 128\n            sub-identifiers and cannot be accessed using SNMPv1,\n            SNMPv2c, or SNMPv3.")
ipNetToPhysicalPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 4), PhysAddress().subtype(subtypeSpec=ValueSizeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalPhysAddress.setDescription("The media-dependent `physical' address.\n\n            As the entries in this table are typically not persistent\n            when this object is written the entity SHOULD NOT save the\n            change to non-volatile storage.")
ipNetToPhysicalLastUpdated = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipNetToPhysicalLastUpdated.setDescription('The value of sysUpTime at the time this entry was last\n            updated.  If this entry was updated prior to the last re-\n            initialization of the local network management subsystem,\n            then this object contains a zero value.')
ipNetToPhysicalType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4), ("local", 5),)).clone('static')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalType.setDescription("The type of mapping.\n\n            Setting this object to the value invalid(2) has the effect\n            of invalidating the corresponding entry in the\n            ipNetToPhysicalTable.  That is, it effectively dis-\n            associates the interface identified with said entry from the\n            mapping identified with said entry.  It is an\n            implementation-specific matter as to whether the agent\n\n\n            removes an invalidated entry from the table.  Accordingly,\n            management stations must be prepared to receive tabular\n            information from agents that corresponds to entries not\n            currently in use.  Proper interpretation of such entries\n            requires examination of the relevant ipNetToPhysicalType\n            object.\n\n            The 'dynamic(3)' type indicates that the IP address to\n            physical addresses mapping has been dynamically resolved\n            using e.g., IPv4 ARP or the IPv6 Neighbor Discovery\n            protocol.\n\n            The 'static(4)' type indicates that the mapping has been\n            statically configured.  Both of these refer to entries that\n            provide mappings for other entities addresses.\n\n            The 'local(5)' type indicates that the mapping is provided\n            for an entity's own interface address.\n\n            As the entries in this table are typically not persistent\n            when this object is written the entity SHOULD NOT save the\n            change to non-volatile storage.")
ipNetToPhysicalState = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("reachable", 1), ("stale", 2), ("delay", 3), ("probe", 4), ("invalid", 5), ("unknown", 6), ("incomplete", 7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipNetToPhysicalState.setDescription('The Neighbor Unreachability Detection state for the\n            interface when the address mapping in this entry is used.\n            If Neighbor Unreachability Detection is not in use (e.g. for\n            IPv4), this object is always unknown(6).')
ipNetToPhysicalRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalRowStatus.setDescription("The status of this conceptual row.\n\n            The RowStatus TC requires that this DESCRIPTION clause\n            states under which circumstances other objects in this row\n            can be modified.  The value of this object has no effect on\n            whether other objects in this conceptual row can be\n            modified.\n\n            A conceptual row can not be made active until the\n            ipNetToPhysicalPhysAddress object has been set.\n\n            Note that if the ipNetToPhysicalType is set to 'invalid',\n            the managed node may delete the entry independent of the\n            state of this object.")
ipv6ScopeZoneIndexTable = MibTable((1, 3, 6, 1, 2, 1, 4, 36), )
if mibBuilder.loadTexts: ipv6ScopeZoneIndexTable.setDescription('The table used to describe IPv6 unicast and multicast scope\n            zones.\n\n            For those objects that have names rather than numbers, the\n            names were chosen to coincide with the names used in the\n            IPv6 address architecture document. ')
ipv6ScopeZoneIndexEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 36, 1), ).setIndexNames((0, "IP-MIB", "ipv6ScopeZoneIndexIfIndex"))
if mibBuilder.loadTexts: ipv6ScopeZoneIndexEntry.setDescription('Each entry contains the list of scope identifiers on a given\n            interface.')
ipv6ScopeZoneIndexIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv6ScopeZoneIndexIfIndex.setDescription("The index value that uniquely identifies the interface to\n            which these scopes belong.  The interface identified by a\n            particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipv6ScopeZoneIndexLinkLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 2), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexLinkLocal.setDescription('The zone index for the link-local scope on this interface.')
ipv6ScopeZoneIndex3 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 3), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex3.setDescription('The zone index for scope 3 on this interface.')
ipv6ScopeZoneIndexAdminLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 4), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexAdminLocal.setDescription('The zone index for the admin-local scope on this interface.')
ipv6ScopeZoneIndexSiteLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 5), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexSiteLocal.setDescription('The zone index for the site-local scope on this interface.')
ipv6ScopeZoneIndex6 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 6), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex6.setDescription('The zone index for scope 6 on this interface.')
ipv6ScopeZoneIndex7 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 7), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex7.setDescription('The zone index for scope 7 on this interface.')
ipv6ScopeZoneIndexOrganizationLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 8), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexOrganizationLocal.setDescription('The zone index for the organization-local scope on this\n            interface.')
ipv6ScopeZoneIndex9 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 9), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex9.setDescription('The zone index for scope 9 on this interface.')
ipv6ScopeZoneIndexA = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 10), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexA.setDescription('The zone index for scope A on this interface.')
ipv6ScopeZoneIndexB = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 11), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexB.setDescription('The zone index for scope B on this interface.')
ipv6ScopeZoneIndexC = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 12), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexC.setDescription('The zone index for scope C on this interface.')
ipv6ScopeZoneIndexD = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 13), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexD.setDescription('The zone index for scope D on this interface.')
ipDefaultRouterTable = MibTable((1, 3, 6, 1, 2, 1, 4, 37), )
if mibBuilder.loadTexts: ipDefaultRouterTable.setDescription('The table used to describe the default routers known to this\n\n\n            entity.')
ipDefaultRouterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 37, 1), ).setIndexNames((0, "IP-MIB", "ipDefaultRouterAddressType"), (0, "IP-MIB", "ipDefaultRouterAddress"), (0, "IP-MIB", "ipDefaultRouterIfIndex"))
if mibBuilder.loadTexts: ipDefaultRouterEntry.setDescription('Each entry contains information about a default router known\n            to this entity.')
ipDefaultRouterAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 1), InetAddressType())
if mibBuilder.loadTexts: ipDefaultRouterAddressType.setDescription('The address type for this row.')
ipDefaultRouterAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 2), InetAddress())
if mibBuilder.loadTexts: ipDefaultRouterAddress.setDescription('The IP address of the default router represented by this\n            row.  The address type of this object is specified in\n            ipDefaultRouterAddressType.\n\n            Implementers need to be aware that if the size of\n            ipDefaultRouterAddress exceeds 115 octets, then OIDS of\n            instances of columns in this row will have more than 128\n            sub-identifiers and cannot be accessed using SNMPv1,\n            SNMPv2c, or SNMPv3.')
ipDefaultRouterIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 3), InterfaceIndex())
if mibBuilder.loadTexts: ipDefaultRouterIfIndex.setDescription("The index value that uniquely identifies the interface by\n            which the router can be reached.  The interface identified\n            by a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipDefaultRouterLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: ipDefaultRouterLifetime.setDescription('The remaining length of time, in seconds, that this router\n            will continue to be useful as a default router.  A value of\n            zero indicates that it is no longer useful as a default\n            router.  It is left to the implementer of the MIB as to\n            whether a router with a lifetime of zero is removed from the\n            list.\n\n            For IPv6, this value should be extracted from the router\n            advertisement messages.')
ipDefaultRouterPreference = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(-2, -1, 0, 1,))).clone(namedValues=NamedValues(("reserved", -2), ("low", -1), ("medium", 0), ("high", 1),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipDefaultRouterPreference.setDescription('An indication of preference given to this router as a\n            default router as described in he Default Router\n            Preferences document.  Treating the value as a\n            2 bit signed integer allows for simple arithmetic\n            comparisons.\n\n            For IPv4 routers or IPv6 routers that are not using the\n            updated router advertisement format, this object is set to\n            medium (0).')
ipv6RouterAdvertSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 4, 38), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6RouterAdvertSpinLock.setDescription("An advisory lock used to allow cooperating SNMP managers to\n            coordinate their use of the set operation in creating or\n            modifying rows within this table.\n\n            In order to use this lock to coordinate the use of set\n            operations, managers should first retrieve\n            ipv6RouterAdvertSpinLock.  They should then determine the\n            appropriate row to create or modify.  Finally, they should\n            issue the appropriate set command including the retrieved\n            value of ipv6RouterAdvertSpinLock.  If another manager has\n            altered the table in the meantime, then the value of\n            ipv6RouterAdvertSpinLock will have changed and the creation\n            will fail as it will be specifying an incorrect value for\n            ipv6RouterAdvertSpinLock.  It is suggested, but not\n            required, that the ipv6RouterAdvertSpinLock be the first var\n            bind for each set of objects representing a 'row' in a PDU.")
ipv6RouterAdvertTable = MibTable((1, 3, 6, 1, 2, 1, 4, 39), )
if mibBuilder.loadTexts: ipv6RouterAdvertTable.setDescription('The table containing information used to construct router\n            advertisements.')
ipv6RouterAdvertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 39, 1), ).setIndexNames((0, "IP-MIB", "ipv6RouterAdvertIfIndex"))
if mibBuilder.loadTexts: ipv6RouterAdvertEntry.setDescription('An entry containing information used to construct router\n            advertisements.\n\n            Information in this table is persistent, and when this\n            object is written, the entity SHOULD save the change to\n            non-volatile storage.')
ipv6RouterAdvertIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipv6RouterAdvertIfIndex.setDescription("The index value that uniquely identifies the interface on\n            which router advertisements constructed with this\n            information will be transmitted.  The interface identified\n            by a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipv6RouterAdvertSendAdverts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 2), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertSendAdverts.setDescription('A flag indicating whether the router sends periodic\n            router advertisements and responds to router solicitations\n            on this interface.')
ipv6RouterAdvertMaxInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(4,1800)).clone(600)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertMaxInterval.setDescription('The maximum time allowed between sending unsolicited router\n\n\n            advertisements from this interface.')
ipv6RouterAdvertMinInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(3,1350))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertMinInterval.setDescription('The minimum time allowed between sending unsolicited router\n            advertisements from this interface.\n\n            The default is 0.33 * ipv6RouterAdvertMaxInterval, however,\n            in the case of a low value for ipv6RouterAdvertMaxInterval,\n            the minimum value for this object is restricted to 3.')
ipv6RouterAdvertManagedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 5), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertManagedFlag.setDescription("The true/false value to be placed into the 'managed address\n            configuration' flag field in router advertisements sent from\n            this interface.")
ipv6RouterAdvertOtherConfigFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertOtherConfigFlag.setDescription("The true/false value to be placed into the 'other stateful\n            configuration' flag field in router advertisements sent from\n            this interface.")
ipv6RouterAdvertLinkMTU = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 7), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertLinkMTU.setDescription('The value to be placed in MTU options sent by the router on\n            this interface.\n\n            A value of zero indicates that no MTU options are sent.')
ipv6RouterAdvertReachableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,3600000))).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertReachableTime.setDescription("The value to be placed in the reachable time field in router\n            advertisement messages sent from this interface.\n\n            A value of zero in the router advertisement indicates that\n            the advertisement isn't specifying a value for reachable\n            time.")
ipv6RouterAdvertRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 9), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertRetransmitTime.setDescription("The value to be placed in the retransmit timer field in\n            router advertisements sent from this interface.\n\n            A value of zero in the router advertisement indicates that\n            the advertisement isn't specifying a value for retrans\n            time.")
ipv6RouterAdvertCurHopLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertCurHopLimit.setDescription("The default value to be placed in the current hop limit\n            field in router advertisements sent from this interface.\n\n\n            The value should be set to the current diameter of the\n            Internet.\n\n            A value of zero in the router advertisement indicates that\n            the advertisement isn't specifying a value for curHopLimit.\n\n            The default should be set to the value specified in the IANA\n            web pages (www.iana.org) at the time of implementation.")
ipv6RouterAdvertDefaultLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 11), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(4,9000),))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertDefaultLifetime.setDescription('The value to be placed in the router lifetime field of\n            router advertisements sent from this interface.  This value\n            MUST be either 0 or between ipv6RouterAdvertMaxInterval and\n            9000 seconds.\n\n            A value of zero indicates that the router is not to be used\n            as a default router.\n\n            The default is 3 * ipv6RouterAdvertMaxInterval.')
ipv6RouterAdvertRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertRowStatus.setDescription('The status of this conceptual row.\n\n            As all objects in this conceptual row have default values, a\n            row can be created and made active by setting this object\n            appropriately.\n\n            The RowStatus TC requires that this DESCRIPTION clause\n            states under which circumstances other objects in this row\n            can be modified.  The value of this object has no effect on\n            whether other objects in this conceptual row can be\n            modified.')
icmp = MibIdentifier((1, 3, 6, 1, 2, 1, 5))
icmpStatsTable = MibTable((1, 3, 6, 1, 2, 1, 5, 29), )
if mibBuilder.loadTexts: icmpStatsTable.setDescription('The table of generic system-wide ICMP counters.')
icmpStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 5, 29, 1), ).setIndexNames((0, "IP-MIB", "icmpStatsIPVersion"))
if mibBuilder.loadTexts: icmpStatsEntry.setDescription('A conceptual row in the icmpStatsTable.')
icmpStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 1), InetVersion())
if mibBuilder.loadTexts: icmpStatsIPVersion.setDescription('The IP version of the statistics.')
icmpStatsInMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsInMsgs.setDescription('The total number of ICMP messages that the entity received.\n            Note that this counter includes all those counted by\n            icmpStatsInErrors.')
icmpStatsInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsInErrors.setDescription('The number of ICMP messages that the entity received but\n            determined as having ICMP-specific errors (bad ICMP\n            checksums, bad length, etc.).')
icmpStatsOutMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsOutMsgs.setDescription('The total number of ICMP messages that the entity attempted\n            to send.  Note that this counter includes all those counted\n            by icmpStatsOutErrors.')
icmpStatsOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsOutErrors.setDescription("The number of ICMP messages that this entity did not send\n            due to problems discovered within ICMP, such as a lack of\n            buffers.  This value should not include errors discovered\n            outside the ICMP layer, such as the inability of IP to route\n            the resultant datagram.  In some implementations, there may\n            be no types of error that contribute to this counter's\n            value.")
icmpMsgStatsTable = MibTable((1, 3, 6, 1, 2, 1, 5, 30), )
if mibBuilder.loadTexts: icmpMsgStatsTable.setDescription('The table of system-wide per-version, per-message type ICMP\n            counters.')
icmpMsgStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 5, 30, 1), ).setIndexNames((0, "IP-MIB", "icmpMsgStatsIPVersion"), (0, "IP-MIB", "icmpMsgStatsType"))
if mibBuilder.loadTexts: icmpMsgStatsEntry.setDescription('A conceptual row in the icmpMsgStatsTable.\n\n            The system should track each ICMP type value, even if that\n            ICMP type is not supported by the system.  However, a\n            given row need not be instantiated unless a message of that\n            type has been processed, i.e., the row for\n            icmpMsgStatsType=X MAY be instantiated before but MUST be\n            instantiated after the first message with Type=X is\n            received or transmitted.  After receiving or transmitting\n            any succeeding messages with Type=X, the relevant counter\n            must be incremented.')
icmpMsgStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 1), InetVersion())
if mibBuilder.loadTexts: icmpMsgStatsIPVersion.setDescription('The IP version of the statistics.')
icmpMsgStatsType = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255)))
if mibBuilder.loadTexts: icmpMsgStatsType.setDescription('The ICMP type field of the message type being counted by\n            this row.\n\n            Note that ICMP message types are scoped by the address type\n            in use.')
icmpMsgStatsInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpMsgStatsInPkts.setDescription('The number of input packets for this AF and type.')
icmpMsgStatsOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpMsgStatsOutPkts.setDescription('The number of output packets for this AF and type.')
ipMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2))
ipMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2, 1))
ipMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2, 2))
ipMIBCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 48, 2, 1, 2)).setObjects(*(("IP-MIB", "ipSystemStatsGroup"), ("IP-MIB", "ipAddressGroup"), ("IP-MIB", "ipNetToPhysicalGroup"), ("IP-MIB", "ipDefaultRouterGroup"), ("IP-MIB", "icmpStatsGroup"), ("IP-MIB", "ipSystemStatsHCOctetGroup"), ("IP-MIB", "ipSystemStatsHCPacketGroup"), ("IP-MIB", "ipIfStatsGroup"), ("IP-MIB", "ipIfStatsHCOctetGroup"), ("IP-MIB", "ipIfStatsHCPacketGroup"), ("IP-MIB", "ipv4GeneralGroup"), ("IP-MIB", "ipv4IfGroup"), ("IP-MIB", "ipv4SystemStatsGroup"), ("IP-MIB", "ipv4SystemStatsHCPacketGroup"), ("IP-MIB", "ipv4IfStatsGroup"), ("IP-MIB", "ipv4IfStatsHCPacketGroup"), ("IP-MIB", "ipv6GeneralGroup2"), ("IP-MIB", "ipv6IfGroup"), ("IP-MIB", "ipAddressPrefixGroup"), ("IP-MIB", "ipv6ScopeGroup"), ("IP-MIB", "ipv6RouterAdvertGroup"), ("IP-MIB", "ipLastChangeGroup"),))
if mibBuilder.loadTexts: ipMIBCompliance2.setDescription('The compliance statement for systems that implement IP -\n             either IPv4 or IPv6.\n\n            There are a number of INDEX objects that cannot be\n            represented in the form of OBJECT clauses in SMIv2, but\n            for which we have the following compliance requirements,\n            expressed in OBJECT clause form in this description\n            clause:\n\n\n            -- OBJECT        ipSystemStatsIPVersion\n            -- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n            -- DESCRIPTION\n            --     This MIB requires support for only IPv4 and IPv6\n            --     versions.\n            --\n            -- OBJECT        ipIfStatsIPVersion\n            -- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n            -- DESCRIPTION\n            --     This MIB requires support for only IPv4 and IPv6\n            --     versions.\n            --\n            -- OBJECT        icmpStatsIPVersion\n            -- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n            -- DESCRIPTION\n            --     This MIB requires support for only IPv4 and IPv6\n            --     versions.\n            --\n            -- OBJECT        icmpMsgStatsIPVersion\n            -- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n            -- DESCRIPTION\n            --     This MIB requires support for only IPv4 and IPv6\n            --     versions.\n            --\n            -- OBJECT        ipAddressPrefixType\n            -- SYNTAX        InetAddressType {ipv4(1), ipv6(2)}\n            -- DESCRIPTION\n            --     This MIB requires support for only global IPv4 and\n            --     IPv6 address types.\n            --\n            -- OBJECT        ipAddressPrefixPrefix\n            -- SYNTAX        InetAddress (Size(4 | 16))\n            -- DESCRIPTION\n            --     This MIB requires support for only global IPv4 and\n            --     IPv6 addresses and so the size can be either 4 or\n            --     16 bytes.\n            --\n            -- OBJECT        ipAddressAddrType\n            -- SYNTAX        InetAddressType {ipv4(1), ipv6(2),\n            --                                ipv4z(3), ipv6z(4)}\n            -- DESCRIPTION\n            --     This MIB requires support for only global and\n            --     non-global IPv4 and IPv6 address types.\n            --\n            -- OBJECT        ipAddressAddr\n            -- SYNTAX        InetAddress (Size(4 | 8 | 16 | 20))\n            -- DESCRIPTION\n            --     This MIB requires support for only global and\n\n\n            --     non-global IPv4 and IPv6 addresses and so the size\n            --     can be 4, 8, 16, or 20 bytes.\n            --\n            -- OBJECT        ipNetToPhysicalNetAddressType\n            -- SYNTAX        InetAddressType {ipv4(1), ipv6(2),\n            --                                ipv4z(3), ipv6z(4)}\n            -- DESCRIPTION\n            --     This MIB requires support for only global and\n            --     non-global IPv4 and IPv6 address types.\n            --\n            -- OBJECT        ipNetToPhysicalNetAddress\n            -- SYNTAX        InetAddress (Size(4 | 8 | 16 | 20))\n            -- DESCRIPTION\n            --     This MIB requires support for only global and\n            --     non-global IPv4 and IPv6 addresses and so the size\n            --     can be 4, 8, 16, or 20 bytes.\n            --\n            -- OBJECT        ipDefaultRouterAddressType\n            -- SYNTAX        InetAddressType {ipv4(1), ipv6(2),\n            --                                ipv4z(3), ipv6z(4)}\n            -- DESCRIPTION\n            --     This MIB requires support for only global and\n            --     non-global IPv4 and IPv6 address types.\n            --\n            -- OBJECT        ipDefaultRouterAddress\n            -- SYNTAX        InetAddress (Size(4 | 8 | 16 | 20))\n            -- DESCRIPTION\n            --     This MIB requires support for only global and\n            --     non-global IPv4 and IPv6 addresses and so the size\n            --     can be 4, 8, 16, or 20 bytes.')
ipv4GeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 3)).setObjects(*(("IP-MIB", "ipForwarding"), ("IP-MIB", "ipDefaultTTL"), ("IP-MIB", "ipReasmTimeout"),))
if mibBuilder.loadTexts: ipv4GeneralGroup.setDescription('The group of IPv4-specific objects for basic management of\n            IPv4 entities.')
ipv4IfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 4)).setObjects(*(("IP-MIB", "ipv4InterfaceReasmMaxSize"), ("IP-MIB", "ipv4InterfaceEnableStatus"), ("IP-MIB", "ipv4InterfaceRetransmitTime"),))
if mibBuilder.loadTexts: ipv4IfGroup.setDescription('The group of IPv4-specific objects for basic management of\n            IPv4 interfaces.')
ipv6GeneralGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 5)).setObjects(*(("IP-MIB", "ipv6IpForwarding"), ("IP-MIB", "ipv6IpDefaultHopLimit"),))
if mibBuilder.loadTexts: ipv6GeneralGroup2.setDescription('The IPv6 group of objects providing for basic management of\n            IPv6 entities.')
ipv6IfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 6)).setObjects(*(("IP-MIB", "ipv6InterfaceReasmMaxSize"), ("IP-MIB", "ipv6InterfaceIdentifier"), ("IP-MIB", "ipv6InterfaceEnableStatus"), ("IP-MIB", "ipv6InterfaceReachableTime"), ("IP-MIB", "ipv6InterfaceRetransmitTime"), ("IP-MIB", "ipv6InterfaceForwarding"),))
if mibBuilder.loadTexts: ipv6IfGroup.setDescription('The group of IPv6-specific objects for basic management of\n            IPv6 interfaces.')
ipLastChangeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 7)).setObjects(*(("IP-MIB", "ipv4InterfaceTableLastChange"), ("IP-MIB", "ipv6InterfaceTableLastChange"), ("IP-MIB", "ipIfStatsTableLastChange"),))
if mibBuilder.loadTexts: ipLastChangeGroup.setDescription('The last change objects associated with this MIB.  These\n            objects are optional for all agents.  They SHOULD be\n            implemented on agents where it is possible to determine the\n            proper values.  Where it is not possible to determine the\n            proper values, for example when the tables are split amongst\n            several sub-agents using AgentX, the agent MUST NOT\n            implement these objects to return an incorrect or static\n            value.')
ipSystemStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 8)).setObjects(*(("IP-MIB", "ipSystemStatsInReceives"), ("IP-MIB", "ipSystemStatsInOctets"), ("IP-MIB", "ipSystemStatsInHdrErrors"), ("IP-MIB", "ipSystemStatsInNoRoutes"), ("IP-MIB", "ipSystemStatsInAddrErrors"), ("IP-MIB", "ipSystemStatsInUnknownProtos"), ("IP-MIB", "ipSystemStatsInTruncatedPkts"), ("IP-MIB", "ipSystemStatsInForwDatagrams"), ("IP-MIB", "ipSystemStatsReasmReqds"), ("IP-MIB", "ipSystemStatsReasmOKs"), ("IP-MIB", "ipSystemStatsReasmFails"), ("IP-MIB", "ipSystemStatsInDiscards"), ("IP-MIB", "ipSystemStatsInDelivers"), ("IP-MIB", "ipSystemStatsOutRequests"), ("IP-MIB", "ipSystemStatsOutNoRoutes"), ("IP-MIB", "ipSystemStatsOutForwDatagrams"), ("IP-MIB", "ipSystemStatsOutDiscards"), ("IP-MIB", "ipSystemStatsOutFragReqds"), ("IP-MIB", "ipSystemStatsOutFragOKs"), ("IP-MIB", "ipSystemStatsOutFragFails"), ("IP-MIB", "ipSystemStatsOutFragCreates"), ("IP-MIB", "ipSystemStatsOutTransmits"), ("IP-MIB", "ipSystemStatsOutOctets"), ("IP-MIB", "ipSystemStatsInMcastPkts"), ("IP-MIB", "ipSystemStatsInMcastOctets"), ("IP-MIB", "ipSystemStatsOutMcastPkts"), ("IP-MIB", "ipSystemStatsOutMcastOctets"), ("IP-MIB", "ipSystemStatsDiscontinuityTime"), ("IP-MIB", "ipSystemStatsRefreshRate"),))
if mibBuilder.loadTexts: ipSystemStatsGroup.setDescription('IP system wide statistics.')
ipv4SystemStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 9)).setObjects(*(("IP-MIB", "ipSystemStatsInBcastPkts"), ("IP-MIB", "ipSystemStatsOutBcastPkts"),))
if mibBuilder.loadTexts: ipv4SystemStatsGroup.setDescription('IPv4 only system wide statistics.')
ipSystemStatsHCOctetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 10)).setObjects(*(("IP-MIB", "ipSystemStatsHCInOctets"), ("IP-MIB", "ipSystemStatsHCOutOctets"), ("IP-MIB", "ipSystemStatsHCInMcastOctets"), ("IP-MIB", "ipSystemStatsHCOutMcastOctets"),))
if mibBuilder.loadTexts: ipSystemStatsHCOctetGroup.setDescription('IP system wide statistics for systems that may overflow the\n            standard octet counters within 1 hour.')
ipSystemStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 11)).setObjects(*(("IP-MIB", "ipSystemStatsHCInReceives"), ("IP-MIB", "ipSystemStatsHCInForwDatagrams"), ("IP-MIB", "ipSystemStatsHCInDelivers"), ("IP-MIB", "ipSystemStatsHCOutRequests"), ("IP-MIB", "ipSystemStatsHCOutForwDatagrams"), ("IP-MIB", "ipSystemStatsHCOutTransmits"), ("IP-MIB", "ipSystemStatsHCInMcastPkts"), ("IP-MIB", "ipSystemStatsHCOutMcastPkts"),))
if mibBuilder.loadTexts: ipSystemStatsHCPacketGroup.setDescription('IP system wide statistics for systems that may overflow the\n            standard packet counters within 1 hour.')
ipv4SystemStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 12)).setObjects(*(("IP-MIB", "ipSystemStatsHCInBcastPkts"), ("IP-MIB", "ipSystemStatsHCOutBcastPkts"),))
if mibBuilder.loadTexts: ipv4SystemStatsHCPacketGroup.setDescription('IPv4 only system wide statistics for systems that may\n            overflow the standard packet counters within 1 hour.')
ipIfStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 13)).setObjects(*(("IP-MIB", "ipIfStatsInReceives"), ("IP-MIB", "ipIfStatsInOctets"), ("IP-MIB", "ipIfStatsInHdrErrors"), ("IP-MIB", "ipIfStatsInNoRoutes"), ("IP-MIB", "ipIfStatsInAddrErrors"), ("IP-MIB", "ipIfStatsInUnknownProtos"), ("IP-MIB", "ipIfStatsInTruncatedPkts"), ("IP-MIB", "ipIfStatsInForwDatagrams"), ("IP-MIB", "ipIfStatsReasmReqds"), ("IP-MIB", "ipIfStatsReasmOKs"), ("IP-MIB", "ipIfStatsReasmFails"), ("IP-MIB", "ipIfStatsInDiscards"), ("IP-MIB", "ipIfStatsInDelivers"), ("IP-MIB", "ipIfStatsOutRequests"), ("IP-MIB", "ipIfStatsOutForwDatagrams"), ("IP-MIB", "ipIfStatsOutDiscards"), ("IP-MIB", "ipIfStatsOutFragReqds"), ("IP-MIB", "ipIfStatsOutFragOKs"), ("IP-MIB", "ipIfStatsOutFragFails"), ("IP-MIB", "ipIfStatsOutFragCreates"), ("IP-MIB", "ipIfStatsOutTransmits"), ("IP-MIB", "ipIfStatsOutOctets"), ("IP-MIB", "ipIfStatsInMcastPkts"), ("IP-MIB", "ipIfStatsInMcastOctets"), ("IP-MIB", "ipIfStatsOutMcastPkts"), ("IP-MIB", "ipIfStatsOutMcastOctets"), ("IP-MIB", "ipIfStatsDiscontinuityTime"), ("IP-MIB", "ipIfStatsRefreshRate"),))
if mibBuilder.loadTexts: ipIfStatsGroup.setDescription('IP per-interface statistics.')
ipv4IfStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 14)).setObjects(*(("IP-MIB", "ipIfStatsInBcastPkts"), ("IP-MIB", "ipIfStatsOutBcastPkts"),))
if mibBuilder.loadTexts: ipv4IfStatsGroup.setDescription('IPv4 only per-interface statistics.')
ipIfStatsHCOctetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 15)).setObjects(*(("IP-MIB", "ipIfStatsHCInOctets"), ("IP-MIB", "ipIfStatsHCOutOctets"), ("IP-MIB", "ipIfStatsHCInMcastOctets"), ("IP-MIB", "ipIfStatsHCOutMcastOctets"),))
if mibBuilder.loadTexts: ipIfStatsHCOctetGroup.setDescription('IP per-interfaces statistics for systems that include\n            interfaces that may overflow the standard octet\n            counters within 1 hour.')
ipIfStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 16)).setObjects(*(("IP-MIB", "ipIfStatsHCInReceives"), ("IP-MIB", "ipIfStatsHCInForwDatagrams"), ("IP-MIB", "ipIfStatsHCInDelivers"), ("IP-MIB", "ipIfStatsHCOutRequests"), ("IP-MIB", "ipIfStatsHCOutForwDatagrams"), ("IP-MIB", "ipIfStatsHCOutTransmits"), ("IP-MIB", "ipIfStatsHCInMcastPkts"), ("IP-MIB", "ipIfStatsHCOutMcastPkts"),))
if mibBuilder.loadTexts: ipIfStatsHCPacketGroup.setDescription('IP per-interfaces statistics for systems that include\n            interfaces that may overflow the standard packet counters\n            within 1 hour.')
ipv4IfStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 17)).setObjects(*(("IP-MIB", "ipIfStatsHCInBcastPkts"), ("IP-MIB", "ipIfStatsHCOutBcastPkts"),))
if mibBuilder.loadTexts: ipv4IfStatsHCPacketGroup.setDescription('IPv4 only per-interface statistics for systems that include\n            interfaces that may overflow the standard packet counters\n            within 1 hour.')
ipAddressPrefixGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 18)).setObjects(*(("IP-MIB", "ipAddressPrefixOrigin"), ("IP-MIB", "ipAddressPrefixOnLinkFlag"), ("IP-MIB", "ipAddressPrefixAutonomousFlag"), ("IP-MIB", "ipAddressPrefixAdvPreferredLifetime"), ("IP-MIB", "ipAddressPrefixAdvValidLifetime"),))
if mibBuilder.loadTexts: ipAddressPrefixGroup.setDescription('The group of objects for providing information about address\n            prefixes used by this node.')
ipAddressGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 19)).setObjects(*(("IP-MIB", "ipAddressSpinLock"), ("IP-MIB", "ipAddressIfIndex"), ("IP-MIB", "ipAddressType"), ("IP-MIB", "ipAddressPrefix"), ("IP-MIB", "ipAddressOrigin"), ("IP-MIB", "ipAddressStatus"), ("IP-MIB", "ipAddressCreated"), ("IP-MIB", "ipAddressLastChanged"), ("IP-MIB", "ipAddressRowStatus"), ("IP-MIB", "ipAddressStorageType"),))
if mibBuilder.loadTexts: ipAddressGroup.setDescription("The group of objects for providing information about the\n            addresses relevant to this entity's interfaces.")
ipNetToPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 20)).setObjects(*(("IP-MIB", "ipNetToPhysicalPhysAddress"), ("IP-MIB", "ipNetToPhysicalLastUpdated"), ("IP-MIB", "ipNetToPhysicalType"), ("IP-MIB", "ipNetToPhysicalState"), ("IP-MIB", "ipNetToPhysicalRowStatus"),))
if mibBuilder.loadTexts: ipNetToPhysicalGroup.setDescription('The group of objects for providing information about the\n            mappings of network address to physical address known to\n            this node.')
ipv6ScopeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 21)).setObjects(*(("IP-MIB", "ipv6ScopeZoneIndexLinkLocal"), ("IP-MIB", "ipv6ScopeZoneIndex3"), ("IP-MIB", "ipv6ScopeZoneIndexAdminLocal"), ("IP-MIB", "ipv6ScopeZoneIndexSiteLocal"), ("IP-MIB", "ipv6ScopeZoneIndex6"), ("IP-MIB", "ipv6ScopeZoneIndex7"), ("IP-MIB", "ipv6ScopeZoneIndexOrganizationLocal"), ("IP-MIB", "ipv6ScopeZoneIndex9"), ("IP-MIB", "ipv6ScopeZoneIndexA"), ("IP-MIB", "ipv6ScopeZoneIndexB"), ("IP-MIB", "ipv6ScopeZoneIndexC"), ("IP-MIB", "ipv6ScopeZoneIndexD"),))
if mibBuilder.loadTexts: ipv6ScopeGroup.setDescription('The group of objects for managing IPv6 scope zones.')
ipDefaultRouterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 22)).setObjects(*(("IP-MIB", "ipDefaultRouterLifetime"), ("IP-MIB", "ipDefaultRouterPreference"),))
if mibBuilder.loadTexts: ipDefaultRouterGroup.setDescription('The group of objects for providing information about default\n            routers known to this node.')
ipv6RouterAdvertGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 23)).setObjects(*(("IP-MIB", "ipv6RouterAdvertSpinLock"), ("IP-MIB", "ipv6RouterAdvertSendAdverts"), ("IP-MIB", "ipv6RouterAdvertMaxInterval"), ("IP-MIB", "ipv6RouterAdvertMinInterval"), ("IP-MIB", "ipv6RouterAdvertManagedFlag"), ("IP-MIB", "ipv6RouterAdvertOtherConfigFlag"), ("IP-MIB", "ipv6RouterAdvertLinkMTU"), ("IP-MIB", "ipv6RouterAdvertReachableTime"), ("IP-MIB", "ipv6RouterAdvertRetransmitTime"), ("IP-MIB", "ipv6RouterAdvertCurHopLimit"), ("IP-MIB", "ipv6RouterAdvertDefaultLifetime"), ("IP-MIB", "ipv6RouterAdvertRowStatus"),))
if mibBuilder.loadTexts: ipv6RouterAdvertGroup.setDescription('The group of objects for controlling information advertised\n            by IPv6 routers.')
icmpStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 24)).setObjects(*(("IP-MIB", "icmpStatsInMsgs"), ("IP-MIB", "icmpStatsInErrors"), ("IP-MIB", "icmpStatsOutMsgs"), ("IP-MIB", "icmpStatsOutErrors"), ("IP-MIB", "icmpMsgStatsInPkts"), ("IP-MIB", "icmpMsgStatsOutPkts"),))
if mibBuilder.loadTexts: icmpStatsGroup.setDescription('The group of objects providing ICMP statistics.')
ipInReceives = MibScalar((1, 3, 6, 1, 2, 1, 4, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInReceives.setDescription('The total number of input datagrams received from\n            interfaces, including those received in error.\n\n            This object has been deprecated, as a new IP version-neutral\n\n\n            table has been added.  It is loosely replaced by\n            ipSystemStatsInRecieves.')
ipInHdrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInHdrErrors.setDescription('The number of input datagrams discarded due to errors in\n            their IPv4 headers, including bad checksums, version number\n            mismatch, other format errors, time-to-live exceeded, errors\n            discovered in processing their IPv4 options, etc.\n\n            This object has been deprecated as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsInHdrErrors.')
ipInAddrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInAddrErrors.setDescription("The number of input datagrams discarded because the IPv4\n            address in their IPv4 header's destination field was not a\n            valid address to be received at this entity.  This count\n            includes invalid addresses (e.g., 0.0.0.0) and addresses of\n            unsupported Classes (e.g., Class E).  For entities which are\n            not IPv4 routers, and therefore do not forward datagrams,\n            this counter includes datagrams discarded because the\n            destination address was not a local address.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsInAddrErrors.")
ipForwDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 4, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipForwDatagrams.setDescription('The number of input datagrams for which this entity was not\n            their final IPv4 destination, as a result of which an\n            attempt was made to find a route to forward them to that\n            final destination.  In entities which do not act as IPv4\n            routers, this counter will include only those packets which\n\n\n            were Source-Routed via this entity, and the Source-Route\n            option processing was successful.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsInForwDatagrams.')
ipInUnknownProtos = MibScalar((1, 3, 6, 1, 2, 1, 4, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInUnknownProtos.setDescription('The number of locally-addressed datagrams received\n            successfully but discarded because of an unknown or\n            unsupported protocol.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsInUnknownProtos.')
ipInDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDiscards.setDescription('The number of input IPv4 datagrams for which no problems\n            were encountered to prevent their continued processing, but\n            which were discarded (e.g., for lack of buffer space).  Note\n            that this counter does not include any datagrams discarded\n            while awaiting re-assembly.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsInDiscards.')
ipInDelivers = MibScalar((1, 3, 6, 1, 2, 1, 4, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDelivers.setDescription('The total number of input datagrams successfully delivered\n            to IPv4 user-protocols (including ICMP).\n\n            This object has been deprecated as a new IP version neutral\n            table has been added.  It is loosely replaced by\n\n\n            ipSystemStatsIndelivers.')
ipOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 4, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutRequests.setDescription('The total number of IPv4 datagrams which local IPv4 user\n            protocols (including ICMP) supplied to IPv4 in requests for\n            transmission.  Note that this counter does not include any\n            datagrams counted in ipForwDatagrams.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsOutRequests.')
ipOutDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutDiscards.setDescription('The number of output IPv4 datagrams for which no problem was\n            encountered to prevent their transmission to their\n            destination, but which were discarded (e.g., for lack of\n            buffer space).  Note that this counter would include\n            datagrams counted in ipForwDatagrams if any such packets met\n            this (discretionary) discard criterion.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsOutDiscards.')
ipOutNoRoutes = MibScalar((1, 3, 6, 1, 2, 1, 4, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutNoRoutes.setDescription("The number of IPv4 datagrams discarded because no route\n            could be found to transmit them to their destination.  Note\n            that this counter includes any packets counted in\n            ipForwDatagrams which meet this `no-route' criterion.  Note\n            that this includes any datagrams which a host cannot route\n            because all of its default routers are down.\n\n            This object has been deprecated, as a new IP version-neutral\n\n\n            table has been added.  It is loosely replaced by\n            ipSystemStatsOutNoRoutes.")
ipReasmReqds = MibScalar((1, 3, 6, 1, 2, 1, 4, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmReqds.setDescription('The number of IPv4 fragments received which needed to be\n            reassembled at this entity.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsReasmReqds.')
ipReasmOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmOKs.setDescription('The number of IPv4 datagrams successfully re-assembled.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsReasmOKs.')
ipReasmFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmFails.setDescription('The number of failures detected by the IPv4 re-assembly\n            algorithm (for whatever reason: timed out, errors, etc).\n            Note that this is not necessarily a count of discarded IPv4\n            fragments since some algorithms (notably the algorithm in\n            RFC 815) can lose track of the number of fragments by\n            combining them as they are received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsReasmFails.')
ipFragOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragOKs.setDescription('The number of IPv4 datagrams that have been successfully\n            fragmented at this entity.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsOutFragOKs.')
ipFragFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragFails.setDescription("The number of IPv4 datagrams that have been discarded\n            because they needed to be fragmented at this entity but\n            could not be, e.g., because their Don't Fragment flag was\n            set.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsOutFragFails.")
ipFragCreates = MibScalar((1, 3, 6, 1, 2, 1, 4, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragCreates.setDescription('The number of IPv4 datagram fragments that have been\n            generated as a result of fragmentation at this entity.\n\n            This object has been deprecated as a new IP version neutral\n            table has been added.  It is loosely replaced by\n            ipSystemStatsOutFragCreates.')
ipRoutingDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipRoutingDiscards.setDescription('The number of routing entries which were chosen to be\n            discarded even though they are valid.  One possible reason\n            for discarding such an entry could be to free-up buffer\n            space for other routing entries.\n\n\n            This object was defined in pre-IPv6 versions of the IP MIB.\n            It was implicitly IPv4 only, but the original specifications\n            did not indicate this protocol restriction.  In order to\n            clarify the specifications, this object has been deprecated\n            and a similar, but more thoroughly clarified, object has\n            been added to the IP-FORWARD-MIB.')
ipAddrTable = MibTable((1, 3, 6, 1, 2, 1, 4, 20), )
if mibBuilder.loadTexts: ipAddrTable.setDescription("The table of addressing information relevant to this\n            entity's IPv4 addresses.\n\n            This table has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by the\n            ipAddressTable although several objects that weren't deemed\n            useful weren't carried forward while another\n            (ipAdEntReasmMaxSize) was moved to the ipv4InterfaceTable.")
ipAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 20, 1), ).setIndexNames((0, "IP-MIB", "ipAdEntAddr"))
if mibBuilder.loadTexts: ipAddrEntry.setDescription("The addressing information for one of this entity's IPv4\n            addresses.")
ipAdEntAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntAddr.setDescription("The IPv4 address to which this entry's addressing\n            information pertains.")
ipAdEntIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntIfIndex.setDescription("The index value which uniquely identifies the interface to\n            which this entry is applicable.  The interface identified by\n            a particular value of this index is the same interface as\n            identified by the same value of the IF-MIB's ifIndex.")
ipAdEntNetMask = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntNetMask.setDescription('The subnet mask associated with the IPv4 address of this\n            entry.  The value of the mask is an IPv4 address with all\n            the network bits set to 1 and all the hosts bits set to 0.')
ipAdEntBcastAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntBcastAddr.setDescription('The value of the least-significant bit in the IPv4 broadcast\n            address used for sending datagrams on the (logical)\n            interface associated with the IPv4 address of this entry.\n            For example, when the Internet standard all-ones broadcast\n            address is used, the value will be 1.  This value applies to\n            both the subnet and network broadcast addresses used by the\n            entity on this (logical) interface.')
ipAdEntReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntReasmMaxSize.setDescription('The size of the largest IPv4 datagram which this entity can\n            re-assemble from incoming IPv4 fragmented datagrams received\n            on this interface.')
ipNetToMediaTable = MibTable((1, 3, 6, 1, 2, 1, 4, 22), )
if mibBuilder.loadTexts: ipNetToMediaTable.setDescription('The IPv4 Address Translation table used for mapping from\n            IPv4 addresses to physical addresses.\n\n            This table has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by the\n            ipNetToPhysicalTable.')
ipNetToMediaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 22, 1), ).setIndexNames((0, "IP-MIB", "ipNetToMediaIfIndex"), (0, "IP-MIB", "ipNetToMediaNetAddress"))
if mibBuilder.loadTexts: ipNetToMediaEntry.setDescription("Each entry contains one IpAddress to `physical' address\n            equivalence.")
ipNetToMediaIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaIfIndex.setDescription("The interface on which this entry's equivalence is\n            effective.  The interface identified by a particular value\n            of this index is the same interface as identified by the\n\n\n            same value of the IF-MIB's ifIndex.\n\n            This object predates the rule limiting index objects to a\n            max access value of 'not-accessible' and so continues to use\n            a value of 'read-create'.")
ipNetToMediaPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 2), PhysAddress().subtype(subtypeSpec=ValueSizeConstraint(0,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaPhysAddress.setDescription("The media-dependent `physical' address.  This object should\n            return 0 when this entry is in the 'incomplete' state.\n\n            As the entries in this table are typically not persistent\n            when this object is written the entity should not save the\n            change to non-volatile storage.  Note: a stronger\n            requirement is not used because this object was previously\n            defined.")
ipNetToMediaNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 3), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaNetAddress.setDescription("The IpAddress corresponding to the media-dependent\n            `physical' address.\n\n            This object predates the rule limiting index objects to a\n            max access value of 'not-accessible' and so continues to use\n            a value of 'read-create'.")
ipNetToMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaType.setDescription('The type of mapping.\n\n            Setting this object to the value invalid(2) has the effect\n\n\n            of invalidating the corresponding entry in the\n            ipNetToMediaTable.  That is, it effectively dis-associates\n            the interface identified with said entry from the mapping\n            identified with said entry.  It is an implementation-\n            specific matter as to whether the agent removes an\n            invalidated entry from the table.  Accordingly, management\n            stations must be prepared to receive tabular information\n            from agents that corresponds to entries not currently in\n            use.  Proper interpretation of such entries requires\n            examination of the relevant ipNetToMediaType object.\n\n            As the entries in this table are typically not persistent\n            when this object is written the entity should not save the\n            change to non-volatile storage.  Note: a stronger\n            requirement is not used because this object was previously\n            defined.')
icmpInMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInMsgs.setDescription('The total number of ICMP messages which the entity received.\n            Note that this counter includes all those counted by\n            icmpInErrors.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            icmpStatsInMsgs.')
icmpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInErrors.setDescription('The number of ICMP messages which the entity received but\n            determined as having ICMP-specific errors (bad ICMP\n            checksums, bad length, etc.).\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            icmpStatsInErrors.')
icmpInDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInDestUnreachs.setDescription('The number of ICMP Destination Unreachable messages\n            received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimeExcds.setDescription('The number of ICMP Time Exceeded messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInParmProbs.setDescription('The number of ICMP Parameter Problem messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInSrcQuenchs.setDescription('The number of ICMP Source Quench messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInRedirects.setDescription('The number of ICMP Redirect messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchos.setDescription('The number of ICMP Echo (request) messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchoReps.setDescription('The number of ICMP Echo Reply messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestamps.setDescription('The number of ICMP Timestamp (request) messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestampReps.setDescription('The number of ICMP Timestamp Reply messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMasks.setDescription('The number of ICMP Address Mask Request messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpInAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMaskReps.setDescription('The number of ICMP Address Mask Reply messages received.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutMsgs.setDescription('The total number of ICMP messages which this entity\n            attempted to send.  Note that this counter includes all\n            those counted by icmpOutErrors.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            icmpStatsOutMsgs.')
icmpOutErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutErrors.setDescription("The number of ICMP messages which this entity did not send\n            due to problems discovered within ICMP, such as a lack of\n            buffers.  This value should not include errors discovered\n            outside the ICMP layer, such as the inability of IP to route\n            the resultant datagram.  In some implementations, there may\n            be no types of error which contribute to this counter's\n            value.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by\n            icmpStatsOutErrors.")
icmpOutDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutDestUnreachs.setDescription('The number of ICMP Destination Unreachable messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimeExcds.setDescription('The number of ICMP Time Exceeded messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutParmProbs.setDescription('The number of ICMP Parameter Problem messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutSrcQuenchs.setDescription('The number of ICMP Source Quench messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutRedirects.setDescription('The number of ICMP Redirect messages sent.  For a host, this\n            object will always be zero, since hosts do not send\n            redirects.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchos.setDescription('The number of ICMP Echo (request) messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchoReps.setDescription('The number of ICMP Echo Reply messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestamps.setDescription('The number of ICMP Timestamp (request) messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestampReps.setDescription('The number of ICMP Timestamp Reply messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMasks.setDescription('The number of ICMP Address Mask Request messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
icmpOutAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMaskReps.setDescription('The number of ICMP Address Mask Reply messages sent.\n\n            This object has been deprecated, as a new IP version-neutral\n            table has been added.  It is loosely replaced by a column in\n            the icmpMsgStatsTable.')
ipMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 48, 2, 1, 1)).setObjects(*(("IP-MIB", "ipGroup"), ("IP-MIB", "icmpGroup"),))
if mibBuilder.loadTexts: ipMIBCompliance.setDescription('The compliance statement for systems that implement only\n            IPv4.  For version-independence, this compliance statement\n            is deprecated in favor of ipMIBCompliance2.')
ipGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 1)).setObjects(*(("IP-MIB", "ipForwarding"), ("IP-MIB", "ipDefaultTTL"), ("IP-MIB", "ipInReceives"), ("IP-MIB", "ipInHdrErrors"), ("IP-MIB", "ipInAddrErrors"), ("IP-MIB", "ipForwDatagrams"), ("IP-MIB", "ipInUnknownProtos"), ("IP-MIB", "ipInDiscards"), ("IP-MIB", "ipInDelivers"), ("IP-MIB", "ipOutRequests"), ("IP-MIB", "ipOutDiscards"), ("IP-MIB", "ipOutNoRoutes"), ("IP-MIB", "ipReasmTimeout"), ("IP-MIB", "ipReasmReqds"), ("IP-MIB", "ipReasmOKs"), ("IP-MIB", "ipReasmFails"), ("IP-MIB", "ipFragOKs"), ("IP-MIB", "ipFragFails"), ("IP-MIB", "ipFragCreates"), ("IP-MIB", "ipAdEntAddr"), ("IP-MIB", "ipAdEntIfIndex"), ("IP-MIB", "ipAdEntNetMask"), ("IP-MIB", "ipAdEntBcastAddr"), ("IP-MIB", "ipAdEntReasmMaxSize"), ("IP-MIB", "ipNetToMediaIfIndex"), ("IP-MIB", "ipNetToMediaPhysAddress"), ("IP-MIB", "ipNetToMediaNetAddress"), ("IP-MIB", "ipNetToMediaType"), ("IP-MIB", "ipRoutingDiscards"),))
if mibBuilder.loadTexts: ipGroup.setDescription('The ip group of objects providing for basic management of IP\n            entities, exclusive of the management of IP routes.\n\n\n            As part of the version independence, this group has been\n            deprecated.  ')
icmpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 2)).setObjects(*(("IP-MIB", "icmpInMsgs"), ("IP-MIB", "icmpInErrors"), ("IP-MIB", "icmpInDestUnreachs"), ("IP-MIB", "icmpInTimeExcds"), ("IP-MIB", "icmpInParmProbs"), ("IP-MIB", "icmpInSrcQuenchs"), ("IP-MIB", "icmpInRedirects"), ("IP-MIB", "icmpInEchos"), ("IP-MIB", "icmpInEchoReps"), ("IP-MIB", "icmpInTimestamps"), ("IP-MIB", "icmpInTimestampReps"), ("IP-MIB", "icmpInAddrMasks"), ("IP-MIB", "icmpInAddrMaskReps"), ("IP-MIB", "icmpOutMsgs"), ("IP-MIB", "icmpOutErrors"), ("IP-MIB", "icmpOutDestUnreachs"), ("IP-MIB", "icmpOutTimeExcds"), ("IP-MIB", "icmpOutParmProbs"), ("IP-MIB", "icmpOutSrcQuenchs"), ("IP-MIB", "icmpOutRedirects"), ("IP-MIB", "icmpOutEchos"), ("IP-MIB", "icmpOutEchoReps"), ("IP-MIB", "icmpOutTimestamps"), ("IP-MIB", "icmpOutTimestampReps"), ("IP-MIB", "icmpOutAddrMasks"), ("IP-MIB", "icmpOutAddrMaskReps"),))
if mibBuilder.loadTexts: icmpGroup.setDescription('The icmp group of objects providing ICMP statistics.\n\n            As part of the version independence, this group has been\n            deprecated.  ')
mibBuilder.exportSymbols("IP-MIB", icmpInTimestampReps=icmpInTimestampReps, ipIfStatsHCInDelivers=ipIfStatsHCInDelivers, ipNetToPhysicalLastUpdated=ipNetToPhysicalLastUpdated, icmpStatsOutMsgs=icmpStatsOutMsgs, ipv6ScopeGroup=ipv6ScopeGroup, ipMIBGroups=ipMIBGroups, ipSystemStatsInForwDatagrams=ipSystemStatsInForwDatagrams, ipSystemStatsOutOctets=ipSystemStatsOutOctets, ipv4IfGroup=ipv4IfGroup, ipv6ScopeZoneIndexEntry=ipv6ScopeZoneIndexEntry, ipAdEntReasmMaxSize=ipAdEntReasmMaxSize, ipSystemStatsInReceives=ipSystemStatsInReceives, ipAddressGroup=ipAddressGroup, ipIfStatsInDelivers=ipIfStatsInDelivers, ipIfStatsHCOutBcastPkts=ipIfStatsHCOutBcastPkts, ipSystemStatsGroup=ipSystemStatsGroup, ipIfStatsInTruncatedPkts=ipIfStatsInTruncatedPkts, ipIfStatsInMcastPkts=ipIfStatsInMcastPkts, ipSystemStatsInMcastPkts=ipSystemStatsInMcastPkts, ipv4IfStatsGroup=ipv4IfStatsGroup, ipTrafficStats=ipTrafficStats, ipIfStatsOutMcastOctets=ipIfStatsOutMcastOctets, ipAdEntBcastAddr=ipAdEntBcastAddr, ipAddressCreated=ipAddressCreated, IpAddressPrefixOriginTC=IpAddressPrefixOriginTC, ipSystemStatsHCOutTransmits=ipSystemStatsHCOutTransmits, ipAddressRowStatus=ipAddressRowStatus, icmp=icmp, ipInReceives=ipInReceives, ipAdEntNetMask=ipAdEntNetMask, ipv4SystemStatsGroup=ipv4SystemStatsGroup, ipInAddrErrors=ipInAddrErrors, ipIfStatsInBcastPkts=ipIfStatsInBcastPkts, ipIfStatsInReceives=ipIfStatsInReceives, ipSystemStatsReasmReqds=ipSystemStatsReasmReqds, ipIfStatsHCOutOctets=ipIfStatsHCOutOctets, ipAddressPrefixPrefix=ipAddressPrefixPrefix, icmpMsgStatsOutPkts=icmpMsgStatsOutPkts, ipIfStatsInAddrErrors=ipIfStatsInAddrErrors, ipIfStatsOutFragReqds=ipIfStatsOutFragReqds, ipv4GeneralGroup=ipv4GeneralGroup, ipReasmTimeout=ipReasmTimeout, ipIfStatsReasmReqds=ipIfStatsReasmReqds, ipIfStatsReasmOKs=ipIfStatsReasmOKs, ipv6RouterAdvertSpinLock=ipv6RouterAdvertSpinLock, ipSystemStatsOutBcastPkts=ipSystemStatsOutBcastPkts, ipv4IfStatsHCPacketGroup=ipv4IfStatsHCPacketGroup, ipSystemStatsInAddrErrors=ipSystemStatsInAddrErrors, ipIfStatsOutForwDatagrams=ipIfStatsOutForwDatagrams, ipRoutingDiscards=ipRoutingDiscards, ipv6ScopeZoneIndexTable=ipv6ScopeZoneIndexTable, ipAdEntIfIndex=ipAdEntIfIndex, ipv6ScopeZoneIndexOrganizationLocal=ipv6ScopeZoneIndexOrganizationLocal, ipNetToPhysicalIfIndex=ipNetToPhysicalIfIndex, ipv6RouterAdvertRetransmitTime=ipv6RouterAdvertRetransmitTime, ipIfStatsInForwDatagrams=ipIfStatsInForwDatagrams, icmpOutErrors=icmpOutErrors, icmpOutSrcQuenchs=icmpOutSrcQuenchs, ipNetToPhysicalNetAddressType=ipNetToPhysicalNetAddressType, ipSystemStatsHCPacketGroup=ipSystemStatsHCPacketGroup, ipAddressPrefixEntry=ipAddressPrefixEntry, ipInDiscards=ipInDiscards, ipDefaultRouterAddressType=ipDefaultRouterAddressType, ipv6ScopeZoneIndexSiteLocal=ipv6ScopeZoneIndexSiteLocal, ipIfStatsInNoRoutes=ipIfStatsInNoRoutes, ipv6RouterAdvertGroup=ipv6RouterAdvertGroup, ipSystemStatsDiscontinuityTime=ipSystemStatsDiscontinuityTime, ipGroup=ipGroup, ipv6ScopeZoneIndex6=ipv6ScopeZoneIndex6, ipIfStatsHCInForwDatagrams=ipIfStatsHCInForwDatagrams, ipAddressPrefixAdvPreferredLifetime=ipAddressPrefixAdvPreferredLifetime, ipDefaultRouterGroup=ipDefaultRouterGroup, ipReasmFails=ipReasmFails, ip=ip, ipv6InterfaceTableLastChange=ipv6InterfaceTableLastChange, ipIfStatsHCOutMcastPkts=ipIfStatsHCOutMcastPkts, ipOutDiscards=ipOutDiscards, ipSystemStatsHCOutBcastPkts=ipSystemStatsHCOutBcastPkts, ipv6RouterAdvertReachableTime=ipv6RouterAdvertReachableTime, icmpInSrcQuenchs=icmpInSrcQuenchs, icmpOutAddrMaskReps=icmpOutAddrMaskReps, ipSystemStatsHCInBcastPkts=ipSystemStatsHCInBcastPkts, ipMIBCompliance=ipMIBCompliance, ipv6ScopeZoneIndexC=ipv6ScopeZoneIndexC, ipDefaultRouterIfIndex=ipDefaultRouterIfIndex, ipDefaultTTL=ipDefaultTTL, ipv6IpForwarding=ipv6IpForwarding, ipAddressType=ipAddressType, icmpMsgStatsInPkts=icmpMsgStatsInPkts, ipSystemStatsRefreshRate=ipSystemStatsRefreshRate, ipAddressPrefixLength=ipAddressPrefixLength, icmpOutDestUnreachs=icmpOutDestUnreachs, icmpStatsInErrors=icmpStatsInErrors, ipInDelivers=ipInDelivers, ipv4InterfaceTableLastChange=ipv4InterfaceTableLastChange, ipIfStatsHCInMcastOctets=ipIfStatsHCInMcastOctets, ipSystemStatsOutForwDatagrams=ipSystemStatsOutForwDatagrams, ipv4SystemStatsHCPacketGroup=ipv4SystemStatsHCPacketGroup, ipv6RouterAdvertRowStatus=ipv6RouterAdvertRowStatus, ipOutNoRoutes=ipOutNoRoutes, ipAddressPrefixTable=ipAddressPrefixTable, ipv6ScopeZoneIndexLinkLocal=ipv6ScopeZoneIndexLinkLocal, ipIfStatsGroup=ipIfStatsGroup, ipSystemStatsInDiscards=ipSystemStatsInDiscards, ipv6InterfaceEnableStatus=ipv6InterfaceEnableStatus, ipIfStatsHCInReceives=ipIfStatsHCInReceives, ipv6InterfaceEntry=ipv6InterfaceEntry, ipIfStatsEntry=ipIfStatsEntry, icmpStatsGroup=icmpStatsGroup, ipv6InterfaceRetransmitTime=ipv6InterfaceRetransmitTime, ipNetToPhysicalPhysAddress=ipNetToPhysicalPhysAddress, ipIfStatsOutFragFails=ipIfStatsOutFragFails, ipv6RouterAdvertLinkMTU=ipv6RouterAdvertLinkMTU, ipSystemStatsHCOutMcastOctets=ipSystemStatsHCOutMcastOctets, ipSystemStatsHCInMcastPkts=ipSystemStatsHCInMcastPkts, icmpInMsgs=icmpInMsgs, icmpOutAddrMasks=icmpOutAddrMasks, ipDefaultRouterPreference=ipDefaultRouterPreference, icmpInEchos=icmpInEchos, ipv6IpDefaultHopLimit=ipv6IpDefaultHopLimit, icmpInAddrMasks=icmpInAddrMasks, ipDefaultRouterTable=ipDefaultRouterTable, ipv6InterfaceTable=ipv6InterfaceTable, ipv6ScopeZoneIndexD=ipv6ScopeZoneIndexD, ipSystemStatsInNoRoutes=ipSystemStatsInNoRoutes, ipAddressPrefixType=ipAddressPrefixType, ipSystemStatsInDelivers=ipSystemStatsInDelivers, ipSystemStatsHCInOctets=ipSystemStatsHCInOctets, ipSystemStatsInTruncatedPkts=ipSystemStatsInTruncatedPkts, ipIfStatsTable=ipIfStatsTable, ipIfStatsHCInMcastPkts=ipIfStatsHCInMcastPkts, ipv6ScopeZoneIndex7=ipv6ScopeZoneIndex7, Ipv6AddressIfIdentifierTC=Ipv6AddressIfIdentifierTC, icmpOutTimestampReps=icmpOutTimestampReps, ipv4InterfaceTable=ipv4InterfaceTable, icmpInParmProbs=icmpInParmProbs, ipIfStatsHCInBcastPkts=ipIfStatsHCInBcastPkts, icmpInDestUnreachs=icmpInDestUnreachs, ipNetToPhysicalRowStatus=ipNetToPhysicalRowStatus, ipNetToMediaTable=ipNetToMediaTable, ipAddressTable=ipAddressTable, ipv4InterfaceEntry=ipv4InterfaceEntry, ipIfStatsHCInOctets=ipIfStatsHCInOctets, icmpOutRedirects=icmpOutRedirects, ipv6RouterAdvertMinInterval=ipv6RouterAdvertMinInterval, ipv6ScopeZoneIndexA=ipv6ScopeZoneIndexA, ipSystemStatsInHdrErrors=ipSystemStatsInHdrErrors, ipReasmOKs=ipReasmOKs, icmpGroup=icmpGroup, ipSystemStatsInMcastOctets=ipSystemStatsInMcastOctets, ipIfStatsOutRequests=ipIfStatsOutRequests, ipAddressPrefix=ipAddressPrefix, ipIfStatsOutMcastPkts=ipIfStatsOutMcastPkts, ipNetToPhysicalState=ipNetToPhysicalState, ipMIBCompliances=ipMIBCompliances, icmpInTimestamps=icmpInTimestamps, ipIfStatsIfIndex=ipIfStatsIfIndex, icmpOutMsgs=icmpOutMsgs, ipFragFails=ipFragFails, ipAddressStorageType=ipAddressStorageType, ipMIBConformance=ipMIBConformance, icmpOutParmProbs=icmpOutParmProbs, icmpMsgStatsTable=icmpMsgStatsTable, ipAddressEntry=ipAddressEntry, ipInHdrErrors=ipInHdrErrors, ipAddressStatus=ipAddressStatus, ipNetToPhysicalGroup=ipNetToPhysicalGroup, ipv6InterfaceIdentifier=ipv6InterfaceIdentifier, ipIfStatsHCOutForwDatagrams=ipIfStatsHCOutForwDatagrams, ipDefaultRouterEntry=ipDefaultRouterEntry, icmpInTimeExcds=icmpInTimeExcds, ipIfStatsRefreshRate=ipIfStatsRefreshRate, ipSystemStatsHCInForwDatagrams=ipSystemStatsHCInForwDatagrams, ipv4InterfaceIfIndex=ipv4InterfaceIfIndex, ipNetToMediaPhysAddress=ipNetToMediaPhysAddress, ipIfStatsInOctets=ipIfStatsInOctets, ipv6ScopeZoneIndex9=ipv6ScopeZoneIndex9, ipv6ScopeZoneIndexIfIndex=ipv6ScopeZoneIndexIfIndex, ipv6RouterAdvertOtherConfigFlag=ipv6RouterAdvertOtherConfigFlag, ipv6RouterAdvertCurHopLimit=ipv6RouterAdvertCurHopLimit, icmpStatsTable=icmpStatsTable, icmpStatsOutErrors=icmpStatsOutErrors, ipLastChangeGroup=ipLastChangeGroup, icmpOutEchos=icmpOutEchos, ipIfStatsIPVersion=ipIfStatsIPVersion, ipDefaultRouterAddress=ipDefaultRouterAddress, ipAddrTable=ipAddrTable, ipSystemStatsOutFragOKs=ipSystemStatsOutFragOKs, ipDefaultRouterLifetime=ipDefaultRouterLifetime, ipNetToMediaEntry=ipNetToMediaEntry, ipIfStatsOutBcastPkts=ipIfStatsOutBcastPkts, ipSystemStatsOutMcastOctets=ipSystemStatsOutMcastOctets, IpAddressOriginTC=IpAddressOriginTC, ipIfStatsInUnknownProtos=ipIfStatsInUnknownProtos, icmpMsgStatsType=icmpMsgStatsType, icmpOutEchoReps=icmpOutEchoReps, ipAddrEntry=ipAddrEntry, ipAddressLastChanged=ipAddressLastChanged, ipAddressAddrType=ipAddressAddrType, ipIfStatsHCOutMcastOctets=ipIfStatsHCOutMcastOctets, ipIfStatsHCPacketGroup=ipIfStatsHCPacketGroup, ipSystemStatsHCInDelivers=ipSystemStatsHCInDelivers, ipv6InterfaceIfIndex=ipv6InterfaceIfIndex, ipIfStatsTableLastChange=ipIfStatsTableLastChange, ipIfStatsInHdrErrors=ipIfStatsInHdrErrors, ipAddressPrefixIfIndex=ipAddressPrefixIfIndex, icmpStatsEntry=icmpStatsEntry, ipAddressPrefixAutonomousFlag=ipAddressPrefixAutonomousFlag, ipForwarding=ipForwarding, ipSystemStatsOutMcastPkts=ipSystemStatsOutMcastPkts, ipSystemStatsInBcastPkts=ipSystemStatsInBcastPkts, ipv6InterfaceForwarding=ipv6InterfaceForwarding, ipMIB=ipMIB, ipSystemStatsHCInMcastOctets=ipSystemStatsHCInMcastOctets, ipSystemStatsOutNoRoutes=ipSystemStatsOutNoRoutes, ipIfStatsHCOutRequests=ipIfStatsHCOutRequests, icmpStatsInMsgs=icmpStatsInMsgs, ipSystemStatsOutFragFails=ipSystemStatsOutFragFails, ipIfStatsOutFragOKs=ipIfStatsOutFragOKs, ipReasmReqds=ipReasmReqds, ipSystemStatsOutFragReqds=ipSystemStatsOutFragReqds, icmpOutTimeExcds=icmpOutTimeExcds, ipv6ScopeZoneIndex3=ipv6ScopeZoneIndex3, ipIfStatsOutOctets=ipIfStatsOutOctets, ipNetToPhysicalNetAddress=ipNetToPhysicalNetAddress, ipv6ScopeZoneIndexAdminLocal=ipv6ScopeZoneIndexAdminLocal, ipv4InterfaceRetransmitTime=ipv4InterfaceRetransmitTime, ipSystemStatsOutRequests=ipSystemStatsOutRequests, ipSystemStatsEntry=ipSystemStatsEntry, ipSystemStatsIPVersion=ipSystemStatsIPVersion, ipSystemStatsHCOutRequests=ipSystemStatsHCOutRequests, ipAddressOrigin=ipAddressOrigin, ipNetToPhysicalType=ipNetToPhysicalType, ipv6IfGroup=ipv6IfGroup, ipFragOKs=ipFragOKs, icmpInEchoReps=icmpInEchoReps, ipIfStatsHCOctetGroup=ipIfStatsHCOctetGroup, ipAddressSpinLock=ipAddressSpinLock, icmpInAddrMaskReps=icmpInAddrMaskReps, ipv6RouterAdvertIfIndex=ipv6RouterAdvertIfIndex, ipv6GeneralGroup2=ipv6GeneralGroup2, icmpStatsIPVersion=icmpStatsIPVersion, icmpOutTimestamps=icmpOutTimestamps, ipSystemStatsReasmOKs=ipSystemStatsReasmOKs, ipSystemStatsHCOutForwDatagrams=ipSystemStatsHCOutForwDatagrams, ipIfStatsOutDiscards=ipIfStatsOutDiscards, ipSystemStatsReasmFails=ipSystemStatsReasmFails, ipv6RouterAdvertSendAdverts=ipv6RouterAdvertSendAdverts, IpAddressStatusTC=IpAddressStatusTC, ipNetToMediaIfIndex=ipNetToMediaIfIndex, ipIfStatsDiscontinuityTime=ipIfStatsDiscontinuityTime, ipSystemStatsHCOctetGroup=ipSystemStatsHCOctetGroup, ipSystemStatsOutFragCreates=ipSystemStatsOutFragCreates, ipSystemStatsOutDiscards=ipSystemStatsOutDiscards)
mibBuilder.exportSymbols("IP-MIB", ipIfStatsOutFragCreates=ipIfStatsOutFragCreates, ipSystemStatsTable=ipSystemStatsTable, ipAddressPrefixAdvValidLifetime=ipAddressPrefixAdvValidLifetime, icmpInRedirects=icmpInRedirects, ipv6RouterAdvertManagedFlag=ipv6RouterAdvertManagedFlag, ipNetToMediaType=ipNetToMediaType, ipv6RouterAdvertEntry=ipv6RouterAdvertEntry, ipv6RouterAdvertTable=ipv6RouterAdvertTable, ipv4InterfaceEnableStatus=ipv4InterfaceEnableStatus, ipv4InterfaceReasmMaxSize=ipv4InterfaceReasmMaxSize, ipSystemStatsHCOutMcastPkts=ipSystemStatsHCOutMcastPkts, ipAddressPrefixOrigin=ipAddressPrefixOrigin, ipIfStatsReasmFails=ipIfStatsReasmFails, ipv6InterfaceReachableTime=ipv6InterfaceReachableTime, icmpInErrors=icmpInErrors, ipAddressAddr=ipAddressAddr, ipv6InterfaceReasmMaxSize=ipv6InterfaceReasmMaxSize, ipSystemStatsHCInReceives=ipSystemStatsHCInReceives, ipSystemStatsInUnknownProtos=ipSystemStatsInUnknownProtos, icmpMsgStatsEntry=icmpMsgStatsEntry, ipInUnknownProtos=ipInUnknownProtos, ipSystemStatsOutTransmits=ipSystemStatsOutTransmits, ipOutRequests=ipOutRequests, ipSystemStatsInOctets=ipSystemStatsInOctets, ipAddressPrefixOnLinkFlag=ipAddressPrefixOnLinkFlag, ipAddressIfIndex=ipAddressIfIndex, ipIfStatsHCOutTransmits=ipIfStatsHCOutTransmits, ipIfStatsInMcastOctets=ipIfStatsInMcastOctets, icmpMsgStatsIPVersion=icmpMsgStatsIPVersion, ipv6ScopeZoneIndexB=ipv6ScopeZoneIndexB, ipv6RouterAdvertMaxInterval=ipv6RouterAdvertMaxInterval, ipNetToPhysicalTable=ipNetToPhysicalTable, ipSystemStatsHCOutOctets=ipSystemStatsHCOutOctets, ipNetToPhysicalEntry=ipNetToPhysicalEntry, ipMIBCompliance2=ipMIBCompliance2, ipFragCreates=ipFragCreates, PYSNMP_MODULE_ID=ipMIB, ipAdEntAddr=ipAdEntAddr, ipNetToMediaNetAddress=ipNetToMediaNetAddress, ipAddressPrefixGroup=ipAddressPrefixGroup, ipv6RouterAdvertDefaultLifetime=ipv6RouterAdvertDefaultLifetime, ipForwDatagrams=ipForwDatagrams, ipIfStatsInDiscards=ipIfStatsInDiscards, ipIfStatsOutTransmits=ipIfStatsOutTransmits)
