# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IssueUpdateContract(Model):
    """Issue update Parameters.

    :param created_date: Date and time when the issue was created.
    :type created_date: datetime
    :param state: Status of the issue. Possible values include: 'proposed',
     'open', 'removed', 'resolved', 'closed'
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created
     for.
    :type api_id: str
    :param title: The issue title.
    :type title: str
    :param description: Text describing the issue.
    :type description: str
    :param user_id: A resource identifier for the user created the issue.
    :type user_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IssueUpdateContract, self).__init__(**kwargs)
        self.created_date = kwargs.get('created_date', None)
        self.state = kwargs.get('state', None)
        self.api_id = kwargs.get('api_id', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.user_id = kwargs.get('user_id', None)
