from __future__ import annotations

import unittest

from pymatgen.core.structure import Structure
from pymatgen.io.prismatic import Prismatic
from pymatgen.util.testing import TEST_FILES_DIR


class TestPrismatic(unittest.TestCase):
    def test_to_str(self):
        structure = Structure.from_file(f"{TEST_FILES_DIR}/CuCl.cif")
        prismatic = Prismatic(structure)
        prismatic_str = prismatic.to_str()
        assert prismatic_str.startswith(
            """Generated by pymatgen
6.52372159 6.52372159 6.52372159
29"""
        )
        assert prismatic_str.endswith("-1")
