// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// Copyright (c) 1999, Thomas A. Fine
//
// License to copy, modify, and distribute for both commercial and
// non-commercial use is herby granted, provided this notice
// is preserved.
//
// Email to my last name at head.cfa.harvard.edu
// http://hea-www.harvard.edu/~fine/
//
// ----
//
// Copyright (C) 2009 Simon Howard
// Copyright (C) 2002-2004  The DOSBox Team
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//-----------------------------------------------------------------------------
//
// Small (4x8) bitmap font for low resolution displays.
//
// Based on the Atari-Small font by Tom Fine.  The original font was standard
// ASCII only; this has been extended to the full Extended ASCII range with
// scaled-down versions of the full-size DOS font (txt_font.h)
//
//-----------------------------------------------------------------------------

static unsigned char small_font_data[] = {

    // ------ Characters 0-31 have been remade to match the ------
    //              DOS control code ASCII characters.

    // Character 0:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 1:

    0x00,                    // |    |
    0x00,                    // |    |
    0x50,                    // | # #|
    0x00,                    // |    |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 2:

    0x60,                    // | ## |
    0xf0,                    // |####|
    0xa0,                    // |# # |
    0xf0,                    // |####|
    0x80,                    // |#   |
    0xd0,                    // |## #|
    0xf0,                    // |####|
    0x60,                    // | ## |

    // Character 3:

    0x00,                    // |    |
    0x00,                    // |    |
    0x50,                    // | # #|
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 4:

    0x00,                    // |    |
    0x00,                    // |    |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 5:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 6:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 7:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x60,                    // | ## |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 8:

    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0x90,                    // |#  #|
    0x90,                    // |#  #|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|

    // Character 9:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x90,                    // |#  #|
    0x90,                    // |#  #|
    0x60,                    // | ## |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 10:

    0xf0,                    // |####|
    0xf0,                    // |####|
    0x90,                    // |#  #|
    0x60,                    // | ## |
    0x60,                    // | ## |
    0x90,                    // |#  #|
    0xf0,                    // |####|
    0xf0,                    // |####|

    // Character 11:

    0x00,                    // |    |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 12:

    0x00,                    // |    |
    0x60,                    // | ## |
    0x90,                    // |#  #|
    0x60,                    // | ## |
    0xf0,                    // |####|
    0x60,                    // | ## |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 13:

    0x00,                    // |    |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 14:

    0x00,                    // |    |
    0x70,                    // | ###|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0xd0,                    // |## #|
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 15:

    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |

    // Character 16:

    0x00,                    // |    |
    0x80,                    // |#   |
    0xc0,                    // |##  |
    0xe0,                    // |### |
    0xc0,                    // |##  |
    0x80,                    // |#   |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 17:

    0x00,                    // |    |
    0x10,                    // |   #|
    0x30,                    // |  ##|
    0x70,                    // | ###|
    0x30,                    // |  ##|
    0x10,                    // |   #|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 18:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 19:

    0x00,                    // |    |
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x00,                    // |    |
    0x50,                    // | # #|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 20:

    0x00,                    // |    |
    0xf0,                    // |####|
    0x90,                    // |#  #|
    0xd0,                    // |## #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 21:

    0x60,                    // | ## |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x90,                    // |#  #|
    0x60,                    // | ## |
    0x10,                    // |   #|
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 22:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 23:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0xf0,                    // |####|

    // Character 24:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 25:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 26:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0xf0,                    // |####|
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 27:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0xf0,                    // |####|
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 28:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 29:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xf0,                    // |####|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 30:

    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 31:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // ------  Characters 32-127 are from Atari-Small ------

    // Character 32:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 33:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 34:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 35:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 36:

    0x40,                    // | #  |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x40,                    // | #  |

    // Character 37:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 38:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 39:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 40:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 41:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 42:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 43:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 44:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |

    // Character 45:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 46:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 47:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 48:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 49:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 50:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 51:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 52:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 53:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0xc0,                    // |##  |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 54:

    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 55:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 56:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 57:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 58:

    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 59:

    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 60:

    0x00,                    // |    |
    0x00,                    // |    |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 61:

    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 62:

    0x00,                    // |    |
    0x00,                    // |    |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 63:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 64:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 65:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 66:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 67:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 68:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 69:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 70:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 71:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 72:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 73:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 74:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 75:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 76:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 77:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 78:

    0x00,                    // |    |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 79:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 80:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 81:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 82:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 83:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 84:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 85:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 86:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 87:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 88:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 89:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 90:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 91:

    0x00,                    // |    |
    0x60,                    // | ## |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 92:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 93:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 94:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 95:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|

    // Character 96:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 97:

    0x00,                    // |    |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 98:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 99:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 100:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 101:

    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 102:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 103:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0xc0,                    // |##  |

    // Character 104:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 105:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 106:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xc0,                    // |##  |

    // Character 107:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 108:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 109:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 110:

    0x00,                    // |    |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 111:

    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 112:

    0x00,                    // |    |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0x80,                    // |#   |
    0x80,                    // |#   |

    // Character 113:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 114:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 115:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0xc0,                    // |##  |
    0x00,                    // |    |

    // Character 116:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 117:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 118:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 119:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 120:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 121:

    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0xc0,                    // |##  |

    // Character 122:

    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 123:

    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 124:

    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 125:

    0x80,                    // |#   |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 126:

    0x00,                    // |    |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 127:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |

    // ------ Characters 128-255 are scaled-down from the full size ------
    //        DOS font.  Some of these have been fixed up, the rest
    //                      need to be fixed up :-)

    // Character 128:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xc0,                    // |##  |


    // Character 129:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 130:

    0x40,                    // | #  |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |


    // Character 131:

    0x20,                    // |  # |
    0x50,                    // | # #|
    0xc0,                    // |##  |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 132:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 133:

    0x40,                    // | #  |
    0x20,                    // |  # |
    0xc0,                    // |##  |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 134:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 135:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0xc0,                    // |##  |

    // Character 136:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 137:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 138:

    0x40,                    // | #  |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |


    // Character 139:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 140:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 141:

    0x40,                    // | #  |
    0x20,                    // |  # |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 142:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 143:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 144:

    0x20,                    // |  # |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0xc0,                    // |##  |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 145:

    0x00,                    // |    |
    0x00,                    // |    |
    0xb0,                    // |# ##|
    0x50,                    // | # #|
    0x70,                    // | ###|
    0xa0,                    // |# # |
    0x70,                    // | ###|
    0x00,                    // |    |

    // Character 146:

    0x00,                    // |    |
    0x70,                    // | ###|
    0xa0,                    // |# # |
    0xf0,                    // |####|
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xb0,                    // |# ##|
    0x00,                    // |    |

    // Character 147:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 148:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 149:

    0x40,                    // | #  |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 150:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 151:

    0x40,                    // | #  |
    0x20,                    // |  # |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 152:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0xc0,                    // |##  |

    // Character 153:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 154:

    0xa0,                    // |# # |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |


    // Character 155:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 156:

    0x30,                    // |  ##|
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xf0,                    // |####|
    0x00,                    // |    |

    // Character 157:

    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 158:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xb0,                    // |# ##|
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 159:

    0x10,                    // |   #|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x70,                    // | ###|
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 160:

    0x20,                    // |  # |
    0x40,                    // | #  |
    0xc0,                    // |##  |
    0x20,                    // |  # |
    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 161:

    0x20,                    // |  # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 162:

    0x40,                    // | #  |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 163:

    0x20,                    // |  # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0x00,                    // |    |


    // Character 164:

    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 165:

    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x90,                    // |#  #|
    0xd0,                    // |## #|
    0xb0,                    // |# ##|
    0x90,                    // |#  #|
    0x00,                    // |    |


    // Character 166:

    0x60,                    // | ## |
    0xa0,                    // |# # |
    0x70,                    // | ###|
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 167:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 168:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 169:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 170:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x70,                    // | ###|
    0x10,                    // |   #|
    0x10,                    // |   #|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 171:

    0x80,                    // |#   |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xb0,                    // |# ##|
    0x10,                    // |   #|
    0x20,                    // |  # |
    0x30,                    // |  ##|

    // Character 172:

    0x80,                    // |#   |
    0x80,                    // |#   |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x50,                    // | # #|
    0x70,                    // | ###|
    0x10,                    // |   #|

    // Character 173:

    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 174:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x50,                    // | # #|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 175:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xa0,                    // |# # |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 176:

    0x10,                    // |   #|
    0x40,                    // | #  |
    0x10,                    // |   #|
    0x40,                    // | #  |
    0x10,                    // |   #|
    0x40,                    // | #  |
    0x10,                    // |   #|
    0x40,                    // | #  |

    // Character 177:

    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x50,                    // | # #|
    0xa0,                    // |# # |

    // Character 178:

    0xd0,                    // |## #|
    0x70,                    // | ###|
    0xd0,                    // |## #|
    0x70,                    // | ###|
    0xd0,                    // |## #|
    0x70,                    // | ###|
    0xd0,                    // |## #|
    0x70,                    // | ###|

    // Character 179:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 180:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 181:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 182:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0xd0,                    // |## #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 183:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 184:

    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 185:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0xd0,                    // |## #|
    0x10,                    // |   #|
    0xd0,                    // |## #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 186:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 187:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x10,                    // |   #|
    0xd0,                    // |## #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 188:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0xd0,                    // |## #|
    0x10,                    // |   #|
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 189:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 190:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 191:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 192:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 193:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 194:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 195:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 196:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 197:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xf0,                    // |####|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 198:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 199:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 200:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x40,                    // | #  |
    0x70,                    // | ###|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 201:

    0x00,                    // |    |
    0x00,                    // |    |
    0x70,                    // | ###|
    0x40,                    // | #  |
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 202:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0xd0,                    // |## #|
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 203:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0xd0,                    // |## #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 204:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 205:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 206:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0xd0,                    // |## #|
    0x00,                    // |    |
    0xd0,                    // |## #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 207:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0xf0,                    // |####|
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 208:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 209:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x00,                    // |    |
    0xf0,                    // |####|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 210:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 211:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x70,                    // | ###|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 212:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 213:

    0x00,                    // |    |
    0x00,                    // |    |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 214:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x70,                    // | ###|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 215:

    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0xf0,                    // |####|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x50,                    // | # #|

    // Character 216:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0xf0,                    // |####|
    0x20,                    // |  # |
    0xf0,                    // |####|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 217:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 218:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 219:

    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|

    // Character 220:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|

    // Character 221:

    0xc0,                    // |##  |
    0xc0,                    // |##  |
    0xc0,                    // |##  |
    0xc0,                    // |##  |
    0xc0,                    // |##  |
    0xc0,                    // |##  |
    0xc0,                    // |##  |
    0xc0,                    // |##  |

    // Character 222:

    0x30,                    // |  ##|
    0x30,                    // |  ##|
    0x30,                    // |  ##|
    0x30,                    // |  ##|
    0x30,                    // |  ##|
    0x30,                    // |  ##|
    0x30,                    // |  ##|
    0x30,                    // |  ##|

    // Character 223:

    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 224:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x50,                    // | # #|
    0x00,                    // |    |

    // Character 225:

    0x00,                    // |    |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0xc0,                    // |##  |
    0xa0,                    // |# # |
    0x90,                    // |#  #|
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 226:

    0x00,                    // |    |
    0xf0,                    // |####|
    0x90,                    // |#  #|
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 227:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 228:

    0x00,                    // |    |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 229:

    0x00,                    // |    |
    0x00,                    // |    |
    0x70,                    // | ###|
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 230:

    0x00,                    // |    |
    0x00,                    // |    |
    0x50,                    // | # #|
    0x50,                    // | # #|
    0x70,                    // | ###|
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 231:

    0x00,                    // |    |
    0x00,                    // |    |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x00,                    // |    |

    // Character 232:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 233:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 234:

    0x00,                    // |    |
    0x60,                    // | ## |
    0x90,                    // |#  #|
    0x90,                    // |#  #|
    0x60,                    // | ## |
    0x60,                    // | ## |
    0xf0,                    // |####|
    0x00,                    // |    |

    // Character 235:


    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 236:

    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0xb0,                    // |# ##|
    0xd0,                    // |## #|
    0x60,                    // | ## |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 237:

    0x00,                    // |    |
    0x10,                    // |   #|
    0xf0,                    // |####|
    0x90,                    // |#  #|
    0x90,                    // |#  #|
    0xf0,                    // |####|
    0x80,                    // |#   |
    0x00,                    // |    |

    // Character 238:

    0x00,                    // |    |
    0x60,                    // | ## |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x80,                    // |#   |
    0x80,                    // |#   |
    0x60,                    // | ## |
    0x00,                    // |    |

    // Character 239:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |

    // Character 240:

    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 241:

    0x00,                    // |    |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x40,                    // | #  |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 242:

    0x00,                    // |    |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 243:

    0x00,                    // |    |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0x80,                    // |#   |
    0x40,                    // | #  |
    0x20,                    // |  # |
    0xe0,                    // |### |
    0x00,                    // |    |

    // Character 244:

    0x00,                    // |    |
    0x10,                    // |   #|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |

    // Character 245:

    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 246:

    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |

    // Character 247:

    0x00,                    // |    |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x50,                    // | # #|
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 248:

    0x40,                    // | #  |
    0xa0,                    // |# # |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 249:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x60,                    // | ## |
    0x60,                    // | ## |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 250:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x40,                    // | #  |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 251:

    0x30,                    // |  ##|
    0x20,                    // |  # |
    0x20,                    // |  # |
    0xa0,                    // |# # |
    0x60,                    // | ## |
    0x20,                    // |  # |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 252:

    0xe0,                    // |### |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0xa0,                    // |# # |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 253:

    0xc0,                    // |##  |
    0x20,                    // |  # |
    0x40,                    // | #  |
    0xe0,                    // |### |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 254:

    0x00,                    // |    |
    0x00,                    // |    |
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0xf0,                    // |####|
    0x00,                    // |    |
    0x00,                    // |    |

    // Character 255:

    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
    0x00,                    // |    |
};

static txt_font_t small_font =
{
    small_font_data,
    4,                   // width
    8                    // height
};


