<?php
/**
*
* common [Română]
*
* @package language
* @version $Id: common.php 9464 2009-04-17 15:52:40Z acydburn $
* @translate $Id: common.php 9464 yyyy-mm-dd hh:mm:ss www.phpbb.ro (shara21jonny) Exp $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
    exit;
}

if (empty($lang) || !is_array($lang))
{
    $lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » „ ” …
//

$lang = array_merge($lang, array(
    'TRANSLATION_INFO'  => 'Translation/Traducere: <a href="http://www.phpbb.ro/">phpBB România</a>',
    'DIRECTION'         => 'ltr',
    'DATE_FORMAT'       => '|d M Y|',   // 01 Jan 2007 (with Relative days enabled)
    'USER_LANG'         => 'ro',

    '1_DAY'         => '1 zi',
    '1_MONTH'       => '1 lună',
    '1_YEAR'        => '1 an',
    '2_WEEKS'       => '2 săptămâni',
    '3_MONTHS'      => '3 luni',
    '6_MONTHS'      => '6 luni',
    '7_DAYS'        => '7 zile',

    'ACCOUNT_ALREADY_ACTIVATED'     => 'Contul dumneavoastră a fost deja activat.',
    'ACCOUNT_DEACTIVATED'           => 'Contul dumneavoastră a fost dezactivat manual şi poate fi reactivat doar de către un administrator.',
    'ACCOUNT_NOT_ACTIVATED'         => 'Contul dumneavoastră încă nu a fost activat.',
    'ACP'                           => 'Panoul administratorului',
    'ACTIVE'                        => 'activ',
    'ACTIVE_ERROR'                  => 'Numele de utilizator specificat este momentan inactiv. Dacă aveţi probleme cu activarea contului, vă rugăm să contactaţi un administrator.',
    'ADMINISTRATOR'                 => 'Administrator',
    'ADMINISTRATORS'                => 'Administratori',
    'AGE'                           => 'Vârsta',
    'AIM'                           => 'AIM',
    'ALLOWED'                       => 'Permis',
    'ALL_FILES'                     => 'Toate fişierele',
    'ALL_FORUMS'                    => 'Toate forumurile',
    'ALL_MESSAGES'                  => 'Toate mesajele',
    'ALL_POSTS'                     => 'Toate mesajele',
    'ALL_TIMES'                     => 'Ora este %1$s %2$s',
    'ALL_TOPICS'                    => 'Toate subiectele',
    'AND'                           => 'Şi',
    'ARE_WATCHING_FORUM'            => 'Aţi subscris pentru a fi notificat de mesajele noi publicate în acest forum.',
    'ARE_WATCHING_TOPIC'            => 'Aţi subscris pentru a fi notificat de mesajele noi publicate în acest subiect.',
    'ASCENDING'                     => 'Crescător',
    'ATTACHMENTS'                   => 'Fişiere ataşate',
    'ATTACHED_IMAGE_NOT_IMAGE'      => 'Fişierul imagine pe care încercaţi să-l ataşaţi este invalid.',
    'AUTHOR'                        => 'Autor',
    'AUTH_NO_PROFILE_CREATED'       => 'Crearea profilului de utilizator nu a fost efectuată cu succes.',
    'AVATAR_DISALLOWED_CONTENT'			=> 'Încărcarea a fost respinsă deoarece fişierul încărcat a fost identificat ca un posibil atac vector.',
    'AVATAR_DISALLOWED_EXTENSION'   => 'Fişierul nu poate fi afişat deoarece extensia <strong>%s</strong> nu este permisă.',
    'AVATAR_EMPTY_REMOTE_DATA'      => 'Avatarul specificat nu a putut fi încărcat pentru că datele de la distanţă sunt invalide sau corupte.',
    'AVATAR_EMPTY_FILEUPLOAD'       => 'Fişierul avatar încărcat este gol.',
    'AVATAR_INVALID_FILENAME'       => '%s este un nume de fişier invalid.',
    'AVATAR_NOT_UPLOADED'           => 'Avatarul nu a putut fi încărcat.',
    'AVATAR_NO_SIZE'                => 'Lungimea sau înălţimea avatarului specificat în legătură nu a putut fi determinată. Vă rugăm să le introduceţi manual.',
    'AVATAR_PARTIAL_UPLOAD'         => 'Fişierul specificat a fost încărcat doar parţial.',
    'AVATAR_PHP_SIZE_NA'            => 'Dimensiunea fişierului avatar este prea mare.<br />Dimensiunea maximă permisă setată în php.ini nu a putut fi determinată.',
    'AVATAR_PHP_SIZE_OVERRUN'       => 'Dimensiunea fişierului avatar este prea mare. Dimensiunea maximă permisă pentru încărcare este de %1$d %2$s.<br />Ţineţi minte că aceasta este setată în php.ini şi nu poate fi suprascrisă.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'Avatarul specificat nu poate fi încărcat deoarece cererea a expirat.',
    'AVATAR_URL_INVALID'            => 'URL-ul specificat este invalid.',
    'AVATAR_URL_NOT_FOUND'          => 'Fişierul specificat nu a putut fi găsit.',
    'AVATAR_WRONG_FILESIZE'         => 'Dimensiunea fişierului avatar trebuie să fie între 0 şi %1$d %2$s.',
    'AVATAR_WRONG_SIZE'             => 'Avatarul trimis este de %5$d pixeli lungime şi %6$d pixeli înălţime. Avatarurile trebuie să fie de cel puţin %1$d pixeli lungime şi %2$d pixeli înălţime, dar nu mai mari de %3$d pixeli lungime şi %4$d pixeli înălţime.',

    'BACK_TO_TOP'           => 'Sus',
    'BACK_TO_PREV'          => 'Înapoi la pagina anterioară',
    'BAN_TRIGGERED_BY_EMAIL'=> 'Adresa dumneavostră de e-mail a fost interzisă.',
    'BAN_TRIGGERED_BY_IP'   => 'Adresa dumneavostră de IP a fost interzisă.',
    'BAN_TRIGGERED_BY_USER' => 'Numele dumneavostră de utilizator a fost interzis.',
    'BBCODE_GUIDE'          => 'Ghidul codului BB',
    'BCC'                   => 'BCC',
    'BIRTHDAYS'             => 'Zile de naştere',
    'BOARD_BAN_PERM'        => 'Accesul dumneavoastră a fost interzis <strong>permanent</strong> pe acest forum.<br /><br />Vă rugăm să contactaţi %2$sadministratorul forumului%3$s pentru mai multe informaţii.',
    'BOARD_BAN_REASON'      => 'Motivul interzicerii: <strong>%s</strong>',
    'BOARD_BAN_TIME'        => 'Accesul dumneavoastră a fost interzis pe acest forum până<strong>%1$s</strong>.<br /><br />Vă rugăm să contactaţi %2$sadministratorul forumului%3$s pentru mai multe informaţii.',
    'BOARD_DISABLE'         => 'Ne pare rău, dar acest forum este momentan indisponibil.',
    'BOARD_DISABLED'        => 'Acest forum este momentan dezactivat.',
    'BOARD_UNAVAILABLE'     => 'Ne pare rău, dar acest forum, momentan nu este disponibil. Vă rugăm să încercaţi din nou în câteva minute.',
    'BROWSING_FORUM'      => 'Utilizatorii ce navighează pe acest forum: %1$s',
    'BROWSING_FORUM_GUEST'  => 'Utilizatorii ce navighează pe acest forum: %1$s şi %2$d vizitator',
    'BROWSING_FORUM_GUESTS' => 'Utilizatorii ce navighează pe acest forum: %1$s şi %2$d vizitatori',
    'BYTES'                 => 'Octeţi',

    'CANCEL'                => 'Anulează',
    'CHANGE'                => 'Schimbă',
    'CHANGE_FONT_SIZE'      => 'Schimbă dimensiunea fontului',
    'CHANGING_PREFERENCES'  => 'Schimbare preferinţe forum',
    'CHANGING_PROFILE'      => 'Schimbare preferinţe profil',
    'CLICK_VIEW_PRIVMSG'    => '%sDu-te în căsuţa cu mesaje private%s',
    'COLLAPSE_VIEW'         => 'Vizualizare restrânsă',
    'CLOSE_WINDOW'          => 'Închide fereastra',
    'COLOUR_SWATCH'         => 'Schimbă culoarea',
    'COMMA_SEPARATOR'       => ', ',    // Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
    'CONFIRM'               => 'Confirmă',
    'CONFIRM_CODE'          => 'Codul de confirmare',
    'CONFIRM_CODE_EXPLAIN'  => 'Introduceţi codul exact cum apare. Nu există diferenţă între literele mari şi cele mici.',
    'CONFIRM_CODE_WRONG'    => 'Codul de confirmare introdus este incorect.',
    'CONFIRM_OPERATION'     => 'Sunteţi sigur că vreţi să continuaţi această operaţiune?',
    'CONGRATULATIONS'       => 'La mulți ani! ',
    'CONNECTION_FAILED'     => 'Conexiune eşuată.',
    'CONNECTION_SUCCESS'    => 'Conexiunea a fost efectuată cu succes!',
    'COOKIES_DELETED'       => 'Toate cookie-urile forumului au fost şterse cu succes.',
    'CURRENT_TIME'          => 'Acum este %s',

    'DAY'                   => 'Zi',
    'DAYS'                  => 'Zile',
    'DELETE'                => 'Şterge',
    'DELETE_ALL'            => 'Şterge tot',
    'DELETE_COOKIES'        => 'Şterge toate cookie-urile forumului',
    'DELETE_MARKED'         => 'Şterge mesajele marcate',
    'DELETE_POST'           => 'Şterge mesaj',
    'DELIMITER'             => 'Delimitator',
    'DESCENDING'            => 'Descrescător',
    'DISABLED'              => 'Dezactivat',
    'DISPLAY'               => 'Afişează',
    'DISPLAY_GUESTS'        => 'Afişează vizitatori',
    'DISPLAY_MESSAGES'      => 'Afişează mesajele din ultimele',
    'DISPLAY_POSTS'         => 'Afişează mesajele din ultimele',
    'DISPLAY_TOPICS'        => 'Afişează subiectele din ultimele',
    'DOWNLOADED'            => 'Descărcat',
    'DOWNLOADING_FILE'      => 'Fişierul se descarcă',
    'DOWNLOAD_COUNT'        => 'Descărcat de %d dată',
    'DOWNLOAD_COUNTS'       => 'Descărcat de %d ori',
    'DOWNLOAD_COUNT_NONE'   => 'Încă nu a fost descărcat',
    'VIEWED_COUNT'          => 'Vizualizat de %d dată',
    'VIEWED_COUNTS'         => 'Vizualizat de %d ori',
    'VIEWED_COUNT_NONE'     => 'Încă nu a fost vizualizat',

    'EDIT_POST'                         => 'Modifică mesaj',
    'EMAIL'                             => 'E-mail',  // Short form for EMAIL_ADDRESS
    'EMAIL_ADDRESS'                     => 'Adresă de e-mail',
	'EMAIL_INVALID_EMAIL'				=> 'Adresa de e-mail introdusă este invalidă.',
    'EMAIL_SMTP_ERROR_RESPONSE'         => 'Probleme în trimiterea e-mail-ului la <strong>Linia %1$s</strong>. Răspuns: %2$s.',
    'EMPTY_SUBJECT'                     => 'Trebuie să specificaţi un subiect când scrieţi un subiect nou.',
    'EMPTY_MESSAGE_SUBJECT'             => 'Trebuie să specificaţi un subiect când compuneţi un mesaj nou.',
    'ENABLED'                           => 'Activat',
    'ENCLOSURE'                         => 'Împrejmuire',
	'ENTER_USERNAME'					=> 'Introduceți nume utilizator',
    'ERR_CHANGING_DIRECTORY'            => 'Nu s-a putut schimba directorul.',
    'ERR_CONNECTING_SERVER'             => 'Eroare în efectuarea conexiunii către server.',
    'ERR_JAB_AUTH'                      => 'Nu s-a putut autentifica la serverul de Jabber.',
    'ERR_JAB_CONNECT'                   => 'Nu s-a putut conecta la serverul de Jabber.',
    'ERR_UNABLE_TO_LOGIN'               => 'Numele de utilizator sau parola specificată sunt greşite.',
    'ERR_UNWATCHING'               => 'Eroare la încercarea de dezabonare.',
    'ERR_WATCHING'                  => 'Eroare la încercarea de abonare.', 
    'ERR_WRONG_PATH_TO_PHPBB'           => 'Calea specificată către phpBB este invalidă.',
    'EXPAND_VIEW'                       => 'Vizualizare extinsă',
    'EXTENSION'                         => 'Extensie',
    'EXTENSION_DISABLED_AFTER_POSTING'  => 'Extensia <strong>%s</strong> a fost dezactivată şi nu mai poate fi afişată.',

    'FAQ'                   => 'FAQ',
    'FAQ_EXPLAIN'           => 'Întrebări puse frecvent',
    'FILENAME'              => 'Nume fişier',
    'FILESIZE'              => 'Dimensiune fişier',
    'FILEDATE'              => 'Dată fişier',
    'FILE_COMMENT'          => 'Comentariu fişier',
    'FILE_NOT_FOUND'        => 'Fişierul cerut nu a putut fi găsit.',
    'FIND_USERNAME'         => 'Caută un membru',
    'FOLDER'                => 'Folder',
    'FORGOT_PASS'           => 'Am uitat parola',
    'FORM_INVALID'          => 'Formularul trimis a fost invalid. Incercaţi să-l retrimiteţi.',
    'FORUM'                 => 'Forum',
    'FORUMS'                => 'Forumuri',
    'FORUMS_MARKED'         => 'Forumurile au fost marcate ca fiind citite.',
    'FORUM_CAT'             => 'Categorie forum',
    'FORUM_INDEX'           => 'Prima pagină',
    'FORUM_LINK'            => 'Link forum',
    'FORUM_LOCATION'        => 'Locaţie forum',
    'FORUM_LOCKED'          => 'Forum închis',
    'FORUM_RULES'           => 'Reguli forum',
    'FORUM_RULES_LINK'      => 'Accesează link-ul pentru a putea vedea regulile forumului',
    'FROM'                  => 'de la',
    'FSOCK_DISABLED'        => 'Operaţiunea nu a putut fi finalizată deoarece funcţia <var>fsockopen</var> a fost dezactivată sau serverul care este interogat nu a fost găsit.',
	'FSOCK_TIMEOUT'			=> 'Nu am putut ajunge la serverul din rețea.',

    'FTP_FSOCK_HOST'                => 'Host FTP',
    'FTP_FSOCK_HOST_EXPLAIN'        => 'Serverul FTP folosit pentru conexiunea cu siteul dumneavoastră.',
    'FTP_FSOCK_PASSWORD'            => 'Parola FTP',
    'FTP_FSOCK_PASSWORD_EXPLAIN'    => 'Parola pentru numele de utilizator FTP.',
    'FTP_FSOCK_PORT'                => 'Port FTP',
    'FTP_FSOCK_PORT_EXPLAIN'        => 'Portul folosit pentru conexiunea cu serverul dumneavoastră.',
    'FTP_FSOCK_ROOT_PATH'           => 'Calea către phpBBH',
    'FTP_FSOCK_ROOT_PATH_EXPLAIN'   => 'Calea către rădăcina forumului phpBB.',
    'FTP_FSOCK_TIMEOUT'             => 'Sesiunea FTP a expirat',
    'FTP_FSOCK_TIMEOUT_EXPLAIN'     => 'Timpul, în secunde, pe care sistemul îl va aştepta pentru a primi un răspuns de la server.',
    'FTP_FSOCK_USERNAME'            => 'Nume de utilizator FTP',
    'FTP_FSOCK_USERNAME_EXPLAIN'    => 'Numele de utilizator folosit pentru conexiunea cu serverul dumneavoastră.',

    'FTP_HOST'                  => 'Host FTP',
    'FTP_HOST_EXPLAIN'          => 'Serverul FTP folosit pentru conexiunea cu siteul dumneavoastră.',
    'FTP_PASSWORD'              => 'Parola FTP',
    'FTP_PASSWORD_EXPLAIN'      => 'Parola pentru numele de utilizator FTP.',
    'FTP_PORT'                  => 'Port FTP',
    'FTP_PORT_EXPLAIN'          => 'Portul folosit pentru conexiunea cu serverul dumneavoastră.',
    'FTP_ROOT_PATH'             => 'Calea către phpBBH',
    'FTP_ROOT_PATH_EXPLAIN'     => 'Calea către rădăcina forumului phpBB.',
    'FTP_TIMEOUT'               => 'Sesiunea FTP a expirat',
    'FTP_TIMEOUT_EXPLAIN'       => 'Timpul, în secunde, pe care sistemul îl va aştepta pentru a primi un răspuns de la server.',
    'FTP_USERNAME'              => 'Nume de utilizator FTP',
    'FTP_USERNAME_EXPLAIN'      => 'Numele de utilizator folosit pentru conexiunea cu serverul dumneavoastră.',

    'GENERAL_ERROR'             => 'Eroare generală',
    'GB'						=> 'GB',
		'GIB'						=> 'GiB',
    'GO'                        => 'Du-te',
    'GOTO_PAGE'                 => 'Du-te la pagina',
    'GROUP'                     => 'Grup',
    'GROUPS'                    => 'Grupuri',
    'GROUP_ERR_TYPE'            => 'Tipul de grup specificat este nepotrivit.',
    'GROUP_ERR_USERNAME'        => 'Numele grupului nu a fost specificat.',
    'GROUP_ERR_USER_LONG'       => 'Numele grupului nu poate depăşi 60 de caractere. Numele grupului specificat este prea mare.',
    'GUEST'                     => 'Vizitator',
    'GUEST_USERS_ONLINE'        => 'Sunt %d vizitatori conectaţi',
    'GUEST_USERS_TOTAL'         => '%d vizitatori',
    'GUEST_USERS_ZERO_ONLINE'   => 'Sunt 0 vizitatori conectaţi',
    'GUEST_USERS_ZERO_TOTAL'    => '0 vizitatori',
    'GUEST_USER_ONLINE'         => 'Este %d vizitator conectat',
    'GUEST_USER_TOTAL'          => '%d vizitator',
    'G_ADMINISTRATORS'          => 'Administratori',
    'G_BOTS'                    => 'Boţi',
    'G_GUESTS'                  => 'Vizitatori',
    'G_REGISTERED'              => 'Utilizatori înregistraţi',
    'G_REGISTERED_COPPA'        => 'Utilizatori COPPA înregistraţi',
    'G_GLOBAL_MODERATORS'       => 'Moderatori globali',
    'G_NEWLY_REGISTERED'		=> 'Utilizatori înregistraţi recent',

    'HIDDEN_USERS_ONLINE'       => '%d utilizatori invizibili conectaţi',
    'HIDDEN_USERS_TOTAL'        => '%d invizibili',
    'HIDDEN_USERS_TOTAL_AND'        => '%d invizibili şi ',
    'HIDDEN_USERS_ZERO_ONLINE'  => '0 utilizatori invizibili conectaţi',
    'HIDDEN_USERS_ZERO_TOTAL'   => '0 invizibili',
    'HIDDEN_USERS_ZERO_TOTAL_AND'   => '0 invizibili şi ',
    'HIDDEN_USER_ONLINE'        => '%d utilizator invizibil conectat',
    'HIDDEN_USER_TOTAL'         => '%d invizibil',
    'HIDDEN_USER_TOTAL_AND'         => '%d invizibil şi ',
    'HIDE_GUESTS'               => 'Ascunde vizitatori',
    'HIDE_ME'                   => 'Ascunde starea mea online în această sesiune',
    'HOURS'                     => 'Ore',
    'HOME'                      => 'Acasă',

    'ICQ'                       => 'ICQ',
    'ICQ_STATUS'                => 'Status ICQ',    
    'IF'                        => 'Dacă',
    'IMAGE'                     => 'Imagine',
    'IMAGE_FILETYPE_INVALID'    => 'Tip de fişier imagine %d pentru tipul mime %s nu este suportat.',
    'IMAGE_FILETYPE_MISMATCH'   => 'Tip de fişier imagine nepotrivit: extensie aşteptată %1$s, dar este furnizată extensie %2$s.',
    'IN'                        => 'în',
    'INDEX'                     => 'Prima pagină',
    'INFORMATION'               => 'Informaţie',
    'INTERESTS'                 => 'Interese',
    'INVALID_DIGEST_CHALLENGE'  => 'Cerere invalidă de sistematizare.',
    'INVALID_EMAIL_LOG'         => '<strong>%s</strong> o adresă de e-mail posibil invalidă?',
    'IP'                        => 'IP',
    'IP_BLACKLISTED'            => 'IP-ul dumneavoastră %1$s a fost blocat pentru că este în lista neagră. Pentru detalii vizualizaţi <a href="%2$s">%2$s</a>.',

    'JABBER'                => 'Jabber',
    'JOINED'                => 'Membru din',
    'JUMP_PAGE'             => 'Introduceţi numărul paginii la care doriţi să vă duceţi.',
    'JUMP_TO'               => 'Mergi la',
    'JUMP_TO_PAGE'          => 'Click pentru a vă duce la pagina…',

    'KB'                    => 'KB',
    'KIB'                   => 'KiB',

    'LAST_POST'                         => 'Ultimul mesaj',
    'LAST_UPDATED'                      => 'Ultima actualizare',
    'LAST_VISIT'                        => 'Ultima vizită',
    'LDAP_NO_LDAP_EXTENSION'            => 'Extensia LDAP nu este valabilă.',
    'LDAP_NO_SERVER_CONNECTION'         => 'Nu s-a putut efectua conexiunea la server-ul LDAP.',
    'LDAP_SEARCH_FAILED'            => 'O eroare a apărut în timpul căutării în directorul LDAP.',
    'LEGEND'                            => 'Legendă',
    'LOCATION'                          => 'Localitate',
    'LOCK_POST'                         => 'Închide mesaj',
    'LOCK_POST_EXPLAIN'                 => 'Previne editarea',
    'LOCK_TOPIC'                        => 'Închide subiect',
    'LOGIN'								=> 'Autentificare',
	'LOGIN_CHECK_PM'					=> 'Autentifică-te pentru a-ţi verifica mesajele private.',
    'LOGIN_CONFIRMATION'                => 'Confirmare autentificare',
    'LOGIN_CONFIRM_EXPLAIN'             => 'Pentru a preveni conturile forţate, forumul vă cere să introduceţi un cod de confirmare după un număr maxim de încercări de autentificare eşuate. Codul este afişat în imaginea de mai jos. Dacă aveţi probleme cu vizualizarea acestuia sau nu puteţi citi codul, vă rugăm să contactaţi %sAdministratorul forumului%s.',
    'LOGIN_ERROR_ATTEMPTS'              => 'Aţi depăşit numărul maxim de încercări de autentificare. Adiţional cu numele de utilizator şi parola mai trebuie să verificaţi componenta afişată mai jos.',
    'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'  => 'Nu aţi fost autentificat de Apache.',
    'LOGIN_ERROR_PASSWORD'              => 'Aţi specificat o parolă incorectă. Vă rugăm să vă verificaţi parola şi să încercaţi din nou. Dacă continuaţi să aveţi probleme, vă rugăm să contactaţi %sAdministratorul forumului%s.',
    'LOGIN_ERROR_PASSWORD_CONVERT'      => 'Nu a fost posibil să fie convertită parola în timpul actualizării softului de forum. Vă rugăm să %scereţi o nouă parolă%s. Dacă continuaţi să aveţi probleme, vă rugăm să contactaţi %sAdministratorul forumului%s.',
    'LOGIN_ERROR_USERNAME'              => 'Aţi specificat un nume de utilizator incorect. Vă rugăm să vă verificaţi numele de utilizator şi să încercaţi din nou. Dacă continuaţi să aveţi probleme, vă rugăm să contactaţi %sAdministratorul forumului%s.',
    'LOGIN_FORUM'                       => 'Pentru a vizualiza sau scrie în acest forum, trebuie să introduceţi parola.',
    'LOGIN_INFO'                        => 'Pentru a vă autentifica, trebuie să vă înregistraţi. Înregistrarea durează câteva secunde, dar vă va oferi facilităţi suplimentare. Administratorul forumului poate de asemenea să acorde permisiuni suplimentare utilizatorilor înregistraţi. Înainte de a vă autentifica, asiguraţi-vă că sunteţi familiarizat cu termenii noştri de folosire şi politicile asociate. Vă rugăm să vă asiguraţi că aţi citit regulile forumului înainte să navigaţi pe acesta.',
    'LOGIN_VIEWFORUM'                   => 'Necesită să fiţi înregistrat şi autentificat pentru a putea vizualiza acest forum.',
    'LOGIN_EXPLAIN_EDIT'                => 'Pentru a putea modifica mesajele din acest forum, trebuie să vă înregistraţi şi să vă autentificaţi.',
    'LOGIN_EXPLAIN_VIEWONLINE'          => 'Pentru a putea vizualiza lista cu cei care sunt online, trebuie să vă înregistraţi şi să vă autentificaţi.',
    'LOGOUT'							=> 'Deconectare',
	'LOGOUT_USER'						=> 'Deconectare [ %s ]',
	'LOG_ME_IN'							=> 'Autentifică-mă automat la fiecare vizită',

    'MARK'                  => 'Marchează',
    'MARK_ALL'              => 'Marchează toate',
    'MARK_FORUMS_READ'      => 'Marchează forumurile ca fiind citite',
	'MARK_SUBFORUMS_READ'	=> 'Marchează subforumurile ca fiind citite',
    'MB'                    => 'MB',
    'MIB'                   => 'MiB',
    'MCP'                   => 'Panoul moderatorului',
    'MEMBERLIST'            => 'Membri',
    'MEMBERLIST_EXPLAIN'    => 'Vezi lista completă a membrilor',
    'MERGE'                 => 'Uneşte',
    'MERGE_POSTS'           => 'Mută mesaje',
    'MERGE_TOPIC'           => 'Uneşte subiecte',
    'MESSAGE'               => 'Mesaj',
    'MESSAGES'              => 'Mesaje',
    'MESSAGE_BODY'          => 'Corpul mesajului',
    'MINUTES'               => 'Minute',
    'MODERATE'              => 'Moderează',
    'MODERATOR'             => 'Moderator',
    'MODERATORS'            => 'Moderatori',
	'MODULE_NOT_ACCESS'		=> 'Modulul nu este accesibil',
 	'MODULE_NOT_FIND'		=> 'Nu pot găsi modulul %s',
 	'MODULE_FILE_INCORRECT_CLASS'	=> 'Fișierul modulului %s nu conține clasa corectă [%s]',
    'MONTH'                 => 'Lună',
    'MOVE'                  => 'Mută',
    'MSNM'                  => 'MSNM/WLM',  

    'NA'                        => 'N/A',
    'NEWEST_USER'               => 'Cel mai nou membru <strong>%s</strong>',
    'NEW_MESSAGE'               => 'Mesaj nou',
    'NEW_MESSAGES'              => 'Mesaje noi',
    'NEW_PM'                    => '<strong>%d</strong> mesaj nou',
    'NEW_PMS'                   => '<strong>%d</strong> mesaje noi',
    'NEW_POST'                  => 'Mesaj nou',
    'NEW_POSTS'                 => 'Mesaje noi',
    'NEXT'                      => 'Următorul',        // Used in pagination
    'NEXT_STEP'                 => 'Următorul',
    'NEVER'                     => 'Niciodată',
    'NO'                        => 'Nu',
    'NOT_ALLOWED_MANAGE_GROUP'  => 'Nu sunteţi autorizat să conduceţi acest grup.',
    'NOT_AUTHORISED'            => 'Nu sunteţi autorizat să accesaţi această zonă.',
    'NOT_WATCHING_FORUM'        => 'Nu mai sunteţi abonat la actualizările acestui forum.',
    'NOT_WATCHING_TOPIC'        => 'Nu mai sunteţi abonat la acest subiect.',
    'NOTIFY_ADMIN'              => 'Vă rugăm să anunţaţi administratorul forumului sau webmaster-ul.',
    'NOTIFY_ADMIN_EMAIL'        => 'Va rugăm să anunţati administratorul forumului sau webmaster-ul: <a href="mailto:%1$s">%1$s</a>',
    'NO_ACCESS_ATTACHMENT'      => 'Nu sunteţi autorizat să accesaţi acest fişier.',
    'NO_ACTION'                 => 'Nicio acţiune specificată.',
    'NO_ADMINISTRATORS'			=> 'Nu sunt administratori.',
    'NO_AUTH_ADMIN'             => 'Accesul la Panoul administratorului este interzis pentru că nu aveţi permisiuni administrative.',
    'NO_AUTH_ADMIN_USER_DIFFER' => 'Nu puteţi să vă reautentificaţi ca un alt utilizator.',
    'NO_AUTH_OPERATION'         => 'Nu aveţi permisiunile necesare pentru a termina această operaţie.',
    'NO_CONNECT_TO_SMTP_HOST'   => 'Nu s-a putut efectua conexiunea către hostul smtp: %1$s : %2$s',
    'NO_BIRTHDAYS'              => 'Nicio zi de naştere astăzi',
    'NO_EMAIL_MESSAGE'          => 'E-mailul a fost gol.',
    'NO_EMAIL_RESPONSE_CODE'    => 'Nu s-au putut lua codurile de răspuns ale server-ului mail.',
    'NO_EMAIL_SUBJECT'          => 'Nu aţi specificat subiectul e-mailului.',
    'NO_FORUM'                  => 'Forumul selectat nu există.',
    'NO_FORUMS'                 => 'Nu există forumuri.',
    'NO_GROUP'                  => 'Grupul cerut nu există.',
    'NO_GROUP_MEMBERS'          => 'Acest grup momentan nu are membri.',
    'NO_IPS_DEFINED'            => 'Niciun IP sau hostname nu a fost definit',
    'NO_MEMBERS'                => 'Niciun membru nu a fost găsit pentru aceste criterii de căutare.',
    'NO_MESSAGES'               => 'Niciun mesaj',
    'NO_MODE'                   => 'Niciun mod specificat.',
    'NO_MODERATORS'				=> 'Nu sunt moderatori.',
    'NO_NEW_MESSAGES'           => 'Niciun mesaj nou',
    'NO_NEW_PM'                 => '<strong>0</strong> mesaje noi',
    'NO_NEW_POSTS'              => 'Niciun mesaj nou',
    'NO_ONLINE_USERS'           => 'Niciun utilizator înregistrat',
    'NO_POSTS'                  => 'Niciun mesaj',
    'NO_POSTS_TIME_FRAME'       => 'Nu există niciun mesaj în interiorul acestui subiect pentru perioada de timp selectată.',
    'NO_FEED_ENABLED'			=> 'Fluxurile nu sunt disponibile pentru acest forum.',
	'NO_FEED'					=> 'Fluxul solicitat nu este disponibil.',
	'NO_STYLE_DATA'				=> 'Nu au putut fi obținute datele stilului',
    'NO_SUBJECT'                => 'Niciun subiect specificat',                 // Used for posts having no subject defined but displayed within management pages.
    'NO_SUCH_SEARCH_MODULE'     => 'Backend-ul de căutare specificat nu există.',
    'NO_SUPPORTED_AUTH_METHODS' => 'Nu există nicio metodă de autentificare.',
    'NO_TOPIC'                  => 'Subiectul specificat nu există.',
    'NO_TOPIC_FORUM'            => 'Subiectul sau forumul nu există.', 
    'NO_TOPICS'                 => 'Nu există subiecte sau mesaje în acest forum.',
    'NO_TOPICS_TIME_FRAME'      => 'Nu există niciun subiect în interiorul acestui forum pentru perioada de timp selectată.',
    'NO_UNREAD_PM'              => '<strong>0</strong> mesaje necitite',
    'NO_UNREAD_POSTS'         => 'Niciun mesaj necitit',
    'NO_UPLOAD_FORM_FOUND'      => 'Încărcare iniţiată, dar nu a fost găsit niciun formular de încărcare valid.',
    'NO_USER'                   => 'Utilizatorul specificat nu există.',
    'NO_USERS'                  => 'Utilizatorii specificaţi nu există.',
    'NO_USER_SPECIFIED'         => 'Nu a fost specificat niciun nume de utilizator.',
     // Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
  'NUM_POSTS_IN_QUEUE'      => array(
      0         => 'Niciun mesaj în lista de aşteptare',      // 0
      1         => '1 mesaj în lista de aşteptare',      // 1
      2         => '%d mesaje în lista de aşteptare',      // 2+
   ),
    'OCCUPATION'                => 'Ocupaţia',
    'OFFLINE'                   => 'Neconectat',
    'ONLINE'                    => 'Conectat',
    'ONLINE_BUDDIES'            => 'Prieteni conectaţi',
    'ONLINE_USERS_TOTAL'        => 'În total sunt <strong>%d</strong> utilizatori conectaţi :: ',
    'ONLINE_USERS_ZERO_TOTAL'   => 'În total sunt <strong>0</strong> utilizatori conectaţi :: ',
    'ONLINE_USER_TOTAL'         => 'În total există <strong>%d</strong> utilizator conectat :: ',
    'OPTIONS'                   => 'Opţiuni',

    'PAGE_OF'               => 'Pagina <strong>%1$d</strong> din <strong>%2$d</strong>',
    'PASSWORD'              => 'Parolă',
    'PIXEL'									=> 'px',
    'PLAY_QUICKTIME_FILE'   => 'Deschide fişierul Quicktime',
    'PM'                    => 'Mesaj privat',
    'PM_REPORTED'         => 'Apăsaţi aici ca să citiţi raportul',
    'POSTING_MESSAGE'       => 'Scrie mesaj în %s',
    'POSTING_PRIVATE_MESSAGE'   => 'Compune mesaj privat',
    'POST'                  => 'Mesaj',
    'POST_ANNOUNCEMENT'     => 'Anunţ',
    'POST_STICKY'           => 'Important',
    'POSTED'                => 'Scris',
    'POSTED_IN_FORUM'       => 'în',
    'POSTED_ON_DATE'        => 'pe',
    'POSTS'                 => 'Mesaje',
    'POSTS_UNAPPROVED'      => 'Cel puţin un mesaj din acest subiect nu a fost aprobat.',
    'POST_BY_AUTHOR'        => 'de',
    'POST_BY_FOE'           => 'Acest mesaj a fost făcut de <strong>%1$s</strong> care este momentan în lista de ignore. %2$sAfişează acest mesaj%3$s.',
    'POST_DAY'              => '%.2f mesaje pe zi',
    'POST_DETAILS'          => 'Detalii mesaj',
    'POST_NEW_TOPIC'        => 'Scrie un subiect nou',
    'POST_PCT'              => '%.2f%% din toate mesajele',
    'POST_PCT_ACTIVE'       => '%.2f%% din mesajele utilizatorului',
    'POST_PCT_ACTIVE_OWN'   => '%.2f%% din mesajele dumneavoastră',
    'POST_REPLY'            => 'Răspunde',
    'POST_REPORTED'         => 'Accesaţi pentru a consulta raportul',
    'POST_SUBJECT'          => 'Subiectul mesajului',
    'POST_TIME'             => 'Dată mesaj',
    'POST_TOPIC'            => 'Scrie un subiect nou',
    'POST_UNAPPROVED'       => 'Acest mesaj aşteaptă pentru a fi aprobat',
	'POWERED_BY'			=> 'Furnizat de %s',
    'PREVIEW'               => 'Previzualizează',
    'PREVIOUS'              => 'Anterior',      // Used in pagination
    'PREVIOUS_STEP'         => 'Anterior',
    'PRIVACY'               => 'Politica de confidenţialitate',
    'PRIVATE_MESSAGE'       => 'Mesaj privat',
    'PRIVATE_MESSAGES'      => 'Mesaje private',
    'PRIVATE_MESSAGING'     => 'Mesageria privată',
    'PROFILE'               => 'Panoul utilizatorului',
	'RANK'						=> 'Rang',

    'READING_FORUM'             => 'Vizualizare subiecte în %s',
    'READING_GLOBAL_ANNOUNCE'   => 'Citeşte anunţurile globale',
    'READING_LINK'              => 'Accesare linkul forumului %s',
    'READING_TOPIC'             => 'Citeşte subiect în %s',
    'READ_PROFILE'              => 'Profil',
    'REASON'                    => 'Motiv',
    'RECORD_ONLINE_USERS'       => 'Cei mai mulţi utilizatori conectaţi au fost <strong>%1$s</strong> pe %2$s',
    'REDIRECT'                  => 'Redirecţionează',
    'REDIRECTS'                 => 'Totalul redirecţionărilor',
    'REGISTER'                  => 'Înregistrare',
    'REGISTERED_USERS'          => 'Utilizatori înregistraţi:',
    'REG_USERS_ONLINE'          => 'Sunt %d utilizatori înregistraţi şi ',
    'REG_USERS_TOTAL'           => '%d înregistraţi, ',
    'REG_USERS_TOTAL_AND'       => '%d înregistraţi şi ',
    'REG_USERS_ZERO_ONLINE'     => 'Sunt 0 utilizatori înregistraţi şi ',
    'REG_USERS_ZERO_TOTAL'      => '0 înregistraţi, ',
    'REG_USERS_ZERO_TOTAL_AND'  => '0 înregistraţi şi ',
    'REG_USER_ONLINE'           => 'Este %d utilizator înregistrat şi ',
    'REG_USER_TOTAL'            => '%d înregistrat, ',
    'REG_USER_TOTAL_AND'        => '%d înregistrat şi ',
    'REMOVE'                    => 'Elimină',
    'REMOVE_INSTALL'            => 'Şterge, mută sau redenumeşte directorul install înainte de a folosi forumul. Dacă acest director este în continuare prezent, numai Panoul administratorului (PA) va fi accesibil.',
    'REPLIES'                   => 'Răspunsuri',
    'REPLY_WITH_QUOTE'          => 'Răspuns cu citat',
    'REPLYING_GLOBAL_ANNOUNCE'  => 'Răspuns la anunţul global',
    'REPLYING_MESSAGE'          => 'Răspunde mesajului din %s',
    'REPORT_BY'                 => 'Raportat de',
    'REPORT_POST'               => 'Raportează acest mesaj',
    'REPORTING_POST'            => 'Raportând mesajul',
    'RESEND_ACTIVATION'         => 'Retrimite e-mail-ul de activare',
    'RESET'                     => 'Resetare',
    'RESTORE_PERMISSIONS'       => 'Restabilire permisiuni',
    'RETURN_INDEX'              => '%sÎnapoi la prima pagină%s',
    'RETURN_FORUM'              => '%sÎnapoi la ultimul forum vizitat%s',
    'RETURN_PAGE'               => '%sÎnapoi la pagina anterioară%s',
    'RETURN_TOPIC'              => '%sÎnapoi la ultimul subiect vizitat%s',
    'RETURN_TO'                 => 'Înapoi la',
    'FEED'						=> 'Flux',
	  'FEED_NEWS'					=> 'Ştiri',
	  'FEED_TOPICS_ACTIVE'		=> 'Subiecte active',
	  'FEED_TOPICS_NEW'			=> 'Subiecte noi',
    'RULES_ATTACH_CAN'          => '<strong>Puteţi</strong> publica fişiere ataşate în acest forum',
    'RULES_ATTACH_CANNOT'       => '<strong>Nu puteţi</strong> publica fişiere ataşate în acest forum',
    'RULES_DELETE_CAN'          => '<strong>Puteţi</strong> şterge mesajele dumneavoastră în acest forum',
    'RULES_DELETE_CANNOT'       => '<strong>Nu puteţi</strong> şterge mesajele dumneavoastră în acest forum',
    'RULES_DOWNLOAD_CAN'        => '<strong>Puteţi</strong> descărca fişierele ataşate din acest forum',
    'RULES_DOWNLOAD_CANNOT'     => '<strong>Nu puteţi</strong> descărca fişierele ataşate din acest forum',
    'RULES_EDIT_CAN'            => '<strong>Puteţi</strong> modifica mesajele dumneavoastră în acest forum',
    'RULES_EDIT_CANNOT'         => '<strong>Nu puteţi</strong> modifica mesajele dumneavoastră în acest forum',
    'RULES_LOCK_CAN'            => '<strong>Puteţi</strong> închide subiectele dumneavoastră în acest forum',
    'RULES_LOCK_CANNOT'         => '<strong>Nu puteţi</strong> închide subiectele dumneavoastră în acest forum',
    'RULES_POST_CAN'            => '<strong>Puteţi</strong> scrie subiecte noi în acest forum',
    'RULES_POST_CANNOT'         => '<strong>Nu puteţi</strong> scrie subiecte noi în acest forum',
    'RULES_REPLY_CAN'           => '<strong>Puteţi</strong> răspunde subiectelor din acest forum',
    'RULES_REPLY_CANNOT'        => '<strong>Nu puteţi</strong> răspunde subiectelor din acest forum',
    'RULES_VOTE_CAN'            => '<strong>Puteţi</strong> vota în chestionarele din acest forum',
    'RULES_VOTE_CANNOT'         => '<strong>Nu puteţi</strong> vota în chestionarele din acest forum',

    'SEARCH'                    => 'Căutare',
    'SEARCH_MINI'               => 'Căutare…',
    'SEARCH_ADV'                => 'Căutare avansată',
    'SEARCH_ADV_EXPLAIN'        => 'Vezi opţiuni căutare avansată',
    'SEARCH_KEYWORDS'           => 'Căutare după cuvinte cheie',
    'SEARCHING_FORUMS'          => 'Căutare forumuri',
    'SEARCH_ACTIVE_TOPICS'      => 'Vezi subiecte active',
    'SEARCH_FOR'                => 'Căutare după',
    'SEARCH_FORUM'              => 'Căutare în acest forum…',   
    'SEARCH_NEW'                => 'Vezi mesaje noi',
    'SEARCH_POSTS_BY'           => 'Căutare mesaje după',
    'SEARCH_SELF'               => 'Vezi mesaje proprii',
    'SEARCH_TOPIC'              => 'Căutare în acest subiect…',
    'SEARCH_UNANSWERED'         => 'Vezi mesaje fără răspuns',
    'SEARCH_UNREAD'				=> 'Vezi mesaje necitite',
	'SEARCH_USER_POSTS'			=> 'Caută mesajele utilizatorului',
    'SECONDS'                   => 'Secunde',
    'SELECT'                    => 'Selectaţi',
    'SELECT_ALL_CODE'           => 'Selectaţi tot',
    'SELECT_DESTINATION_FORUM'  => 'Vă rugăm să selectaţi un forum destinaţie',
    'SELECT_FORUM'              => 'Selectaţi un forum',
    'SEND_EMAIL'                => 'E-mail', // Used for submit buttons
    'SEND_EMAIL_USER'           => 'E-mail',                // Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
    'SEND_PRIVATE_MESSAGE'      => 'Trimiteţi mesaj privat',
    'SETTINGS'                  => 'Setări',
    'SIGNATURE'                 => 'Semnătură',
    'SKIP'                      => 'Treci peste conţinut',
    'SMTP_NO_AUTH_SUPPORT'      => 'Server-ul SMTP nu suportă autentificarea.',
    'SORRY_AUTH_READ'           => 'Nu sunteţi autorizat să citiţi acest forum.',
    'SORRY_AUTH_VIEW_ATTACH'    => 'Nu sunteţi autorizat să descărcaţi acest fişier ataşat.',
    'SORT_BY'                   => 'Sortează după',
    'SORT_JOINED'               => 'Data înregistrării',
    'SORT_LOCATION'             => 'Localitate',
    'SORT_RANK'                 => 'Rang',
    'SORT_POSTS'				=> 'Mesaje',
    'SORT_TOPIC_TITLE'          => 'Titlul subiectului',
    'SORT_USERNAME'             => 'Nume de utilizator',
    'SPLIT_TOPIC'               => 'Desparte subiect',
    'SQL_ERROR_OCCURRED'        => 'O eroare SQL a apărut în timp ce pagina era în lucru. Vă rugăm să contactaţi %sAdministratorul forumului%s dacă problema persistă.',
    'STATISTICS'                => 'Statistici',
    'START_WATCHING_FORUM'      => 'Abonare forum',
    'START_WATCHING_TOPIC'      => 'Abonare subiect',
    'STOP_WATCHING_FORUM'       => 'Dezabonare forum',
    'STOP_WATCHING_TOPIC'       => 'Dezabonare subiect',
    'SUBFORUM'                  => 'Subforum',
    'SUBFORUMS'                 => 'Subforumuri',
    'SUBJECT'                   => 'Subiect',
    'SUBMIT'                    => 'Trimite',

	'TB'				=> 'TB',
    'TERMS_USE'         => 'Termeni de utilizare',
    'TEST_CONNECTION'   => 'Testează conexiunea',
    'THE_TEAM'          => 'Echipa',
	'TIB'				=> 'TiB',
    'TIME'              => 'Data',
    'TOO_LARGE'                  => 'Valoarea specificată este prea mare.',
    'TOO_LARGE_MAX_RECIPIENTS'      => 'Valoarea introdusă pentru setarea <strong>Numărul maxim permis de destinatari pentru fiecare mesaj privat</strong> este prea mare.',

    'TOO_LONG'                  => 'Valoarea specificată este prea lungă.', 

    'TOO_LONG_AIM'                  => 'Cuvântul introdus este prea lung.',
    'TOO_LONG_CONFIRM_CODE'         => 'Codul de confirmare introdus este prea lung.',
    'TOO_LONG_DATEFORMAT'           => 'Formatul datei introdus este prea lung.',
    'TOO_LONG_ICQ'                  => 'Numărul ICQ introdus este prea lung.',
    'TOO_LONG_INTERESTS'            => 'Cuvântul pentru interese introdus este prea lung.',
    'TOO_LONG_JABBER'               => 'Numele contului Jabber introdus este prea lung.',
    'TOO_LONG_LOCATION'             => 'Locaţia introdusă este prea lungă.',
    'TOO_LONG_MSN'                  => 'Numele MSN/WLM introdus este prea lung.',
    'TOO_LONG_NEW_PASSWORD'         => 'Parola introdusă este prea lungă.',
    'TOO_LONG_OCCUPATION'           => 'Cuvântul pentru ocupaţie introdus este prea lung.',
    'TOO_LONG_PASSWORD_CONFIRM'     => 'Confirmarea parolei introdusă este prea lungă.',
    'TOO_LONG_USER_PASSWORD'        => 'Parola introdusă este prea lungă.',
    'TOO_LONG_USERNAME'             => 'Numele de utilizator introdus este prea lung.',
    'TOO_LONG_EMAIL'                => 'Adresa de e-mail introdusă este prea lungă.',
    'TOO_LONG_EMAIL_CONFIRM'        => 'Confirmarea adresei de e-mail introdusă este prea lungă.',
    'TOO_LONG_WEBSITE'              => 'Adresa site-ului web introdusă este prea lungă.',
    'TOO_LONG_YIM'                  => 'Numele Yahoo! Messenger introdus este prea lung.',

    'TOO_MANY_VOTE_OPTIONS'         => 'Aţi încercat să votaţi la prea multe opţiuni.',
    'TOO_SHORT'                     => 'Valoarea specificată este prea scurtă.',

    'TOO_SHORT_AIM'                 => 'Cuvântul introdus este prea scurt.',
    'TOO_SHORT_CONFIRM_CODE'        => 'Codul de confirmare introdus este prea scurt.',
    'TOO_SHORT_DATEFORMAT'          => 'Formatul datei introduse este prea scurt.',
    'TOO_SHORT_ICQ'                 => 'Numărul ICQ introdus este prea scurt.',
    'TOO_SHORT_INTERESTS'           => 'Cuvântul pentru interese introdus este prea scurt.',
    'TOO_SHORT_JABBER'              => 'Numele contului Jabber introdus este prea scurt.',
    'TOO_SHORT_LOCATION'            => 'Locaţia introdusă este prea scurtă.',
    'TOO_SHORT_MSN'                 => 'Numele MSN/WLM introdus este prea scurt.',
    'TOO_SHORT_NEW_PASSWORD'        => 'Parola introdusă este prea scurtă.',
    'TOO_SHORT_OCCUPATION'          => 'Ocupaţia introdusă este prea scurtă.',
    'TOO_SHORT_PASSWORD_CONFIRM'    => 'Confirmarea parolei introdusă este prea scurtă.',
    'TOO_SHORT_USER_PASSWORD'       => 'Parola introdusă este prea scurtă.',
    'TOO_SHORT_USERNAME'            => 'Numele de utilizator introdus este prea scurt.',
    'TOO_SHORT_EMAIL'               => 'Adresa de e-mail introdusă este prea scurtă.',
    'TOO_SHORT_EMAIL_CONFIRM'       => 'Confirmarea adresei de e-mail introdusă este prea scurtă.',
    'TOO_SHORT_WEBSITE'             => 'Adresa site-ului web introdusă este prea scurtă.',
    'TOO_SHORT_YIM'                 => 'Numele Yahoo! Messenger introdus este prea scurt.',
    'TOO_SMALL'                  => 'Valoare specificată este prea mică.',
    'TOO_SMALL_MAX_RECIPIENTS'      => 'Valoarea introdusă pentru setarea <strong>Numărul maxim permis de destinatari pentru fiecare mesaj privat</strong> este prea mică.',


    'TOPIC'             => 'Subiect',
    'TOPICS'            => 'Subiecte',
    'TOPICS_UNAPPROVED'	=> 'Cel puţin un subiect din acest forum nu a fost aprobat.',
    'TOPIC_ICON'        => 'Iconiţă subiect',
    'TOPIC_LOCKED'      => 'Acest subiect este închis, nu puteţi modifica mesaje sau să scrieţi răspunsuri viitoare.',
    'TOPIC_LOCKED_SHORT'=> 'Subiect închis',
    'TOPIC_MOVED'       => 'Subiect mutat',
    'TOPIC_REVIEW'      => 'Subiect revizuit',
    'TOPIC_TITLE'       => 'Titlu subiect',
    'TOPIC_UNAPPROVED'  => 'Acest subiect nu a fost aprobat',
    'TOTAL_ATTACHMENTS' => 'Fişier(e) ataşat(e)',
    'TOTAL_LOG'         => '1 log',
    'TOTAL_LOGS'        => '%d loguri',
    'TOTAL_NO_PM'       => '0 mesaje private în total',
    'TOTAL_PM'          => '1 mesaj privat în total',
    'TOTAL_PMS'         => '%d mesaje private în total',
    'TOTAL_POSTS'       => 'Total mesaje',
    'TOTAL_POSTS_OTHER' => 'Total mesaje <strong>%d</strong>',
    'TOTAL_POSTS_ZERO'  => 'Total mesaje <strong>0</strong>',
    'TOPIC_REPORTED'    => 'Acest subiect a fost raportat',
    'TOTAL_TOPICS_OTHER'=> 'Total subiecte <strong>%d</strong>',
    'TOTAL_TOPICS_ZERO' => 'Total subiecte <strong>0</strong>',
    'TOTAL_USERS_OTHER' => 'Total membri <strong>%d</strong>',
    'TOTAL_USERS_ZERO'  => 'Total membri <strong>0</strong>',
    'TRACKED_PHP_ERROR' => 'Erori PHP depistate: %s',

    'UNABLE_GET_IMAGE_SIZE' => 'Nu a fost posibilă determinarea dimensiunilor imaginii. Vă rugăm să verificați dacă adresa URL este corectă.',
    'UNABLE_TO_DELIVER_FILE'=> 'Nu s-a putut trimite fişierul.',
    'UNKNOWN_BROWSER'       => 'Browser necunoscut',
    'UNMARK_ALL'            => 'Deselectează toate',
    'UNREAD_MESSAGES'       => 'Mesaje necitite',
    'UNREAD_PM'             => '<strong>%d</strong> mesaj necitit',
    'UNREAD_PMS'            => '<strong>%d</strong> mesaje necitite',
    'UNREAD_POST'         => 'Mesaj necitit',
    'UNREAD_POSTS'         => 'Mesaje necitite',
	'UNWATCH_FORUM_CONFIRM'		=> 'Sunteți sigur că doriți să vă dezabonați de la acest forum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Sunteți sigur că doriți să vă dezabonați de la forumul „%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Sunteți sigur că doriți să vă dezabonați de la acest subiect?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Sunteți sigur că doriți să vă dezabonați de la subiectul „%s”?',
    'UNWATCHED_FORUMS'      => 'Nu mai sunteţi abonat la forumurile selectate.',
    'UNWATCHED_TOPICS'      => 'Nu mai sunteţi abonat subiectele selectate.',
    'UNWATCHED_FORUMS_TOPICS'   => 'Nu mai sunteţi abonat la intrările selectate.',
    'UPDATE'                => 'Actualizat',
    'UPLOAD_IN_PROGRESS'    => 'Încărcarea este momentan în progres.',
    'URL_REDIRECT'          => 'Dacă browserul dumneavoastră nu suportă redirecţionări meta, atunci %sdaţi un clik AICI pentru a fi redirecţionat%s.',
    'USERGROUPS'            => 'Grupuri',
    'USERNAME'              => 'Nume utilizator',
    'USERNAMES'             => 'Nume utilizatori',
    'USER_AVATAR'           => 'Avatar utilizator',
    'USER_CANNOT_READ'      => 'Nu puteţi citi mesajele din acest forum.',
    'USER_POST'             => '%d mesaj',
    'USER_POSTS'            => '%d mesaje',
    'USERS'                 => 'Utilizatori',
    'USE_PERMISSIONS'       => 'Testează permisiunile utilizatorului',
    'USER_NEW_PERMISSION_DISALLOWED'	=> 'Ne pare rău dar nu sunteţi autorizat să folosiţi această funcţionalitate. E posibil să vă fi înregistrat aici recent şi să fie nevoie să participaţi mai mult ca să puteţi folosi această funcţionalitate.',

    'VARIANT_DATE_SEPARATOR'    => ' / ',   // Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
    'VIEWED'                    => 'Vizualizat',
    'VIEWING_FAQ'               => 'Vizualizare FAQ',
    'VIEWING_MEMBERS'           => 'Vizualizare detalii membru',
    'VIEWING_ONLINE'            => 'Vizualizare cine este conectat',
    'VIEWING_MCP'               => 'Vizualizare Panou moderator',
    'VIEWING_MEMBER_PROFILE'    => 'Vizualizare profil membru',
    'VIEWING_PRIVATE_MESSAGES'  => 'Vizualizare mesaje private',
    'VIEWING_REGISTER'          => 'Înregistrare cont',
    'VIEWING_UCP'               => 'Vizualizare Panou utilizator',
    'VIEWS'                     => 'Vizualizări',
    'VIEW_BOOKMARKS'            => 'Vezi bookmark-uri',
    'VIEW_FORUM_LOGS'           => 'Consultare loguri',
    'VIEW_LATEST_POST'          => 'Vezi ultimul mesaj',
    'VIEW_NEWEST_POST'          => 'Vezi ultimul mesaj necitit',
    'VIEW_NOTES'                => 'Vezi notiţele utilizatorului',
    'VIEW_ONLINE_TIME'          => 'date care se bazează pe utilizatorii activi în ultimul %d minut',
    'VIEW_ONLINE_TIMES'         => 'date care se bazează pe utilizatorii activi în ultimele %d minute',
    'VIEW_TOPIC'                => 'Vezi subiect',
    'VIEW_TOPIC_ANNOUNCEMENT'   => 'Anunţ: ',
    'VIEW_TOPIC_GLOBAL'         => 'Anunţ global: ',
    'VIEW_TOPIC_LOCKED'         => 'Închis: ',
    'VIEW_TOPIC_LOGS'           => 'Consultare loguri',
    'VIEW_TOPIC_MOVED'          => 'Mutat: ',
    'VIEW_TOPIC_POLL'           => 'Chestionar: ',
    'VIEW_TOPIC_STICKY'         => 'Important: ',
    'VISIT_WEBSITE'             => 'Vizitează site web',

    'WARNINGS'          => 'Avertismente',
    'WARN_USER'         => 'Avertizează utilizator',
	'WATCH_FORUM_CONFIRM'	=> 'Sunteți sigur că doriți să vă abonați la acest forum?',
	'WATCH_FORUM_DETAILED'	=> 'Sunteți sigur că doriți să vă abonați la forumul „%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Sunteți sigur că doriți să vă abonați la acest subiect?',
	'WATCH_TOPIC_DETAILED'	=> 'Sunteți sigur că doriți să vă abonați la subiectul „%s”?',
    'WELCOME_SUBJECT'   => 'Bine aţi venit în forumurile %s',
    'WEBSITE'           => 'Site web',
    'WHOIS'             => 'Cine este',
    'WHO_IS_ONLINE'     => 'Cine este conectat',
    'WRONG_PASSWORD'    => 'Aţi introdus o parolă incorectă.',
	'WRONG_DATA_COLOUR'			=> 'Valoarea culorii introduse este invalidă.',

    'WRONG_DATA_ICQ'            => 'Numărul introdus nu este un număr ICQ valid.',
    'WRONG_DATA_JABBER'         => 'Numele introdus nu este un nume de cont Jabber valid.',
    'WRONG_DATA_LANG'           => 'Limba specificată nu este validă.',
    'WRONG_DATA_WEBSITE'        => 'Adresa site-ului web trebuie să fie un url valid, incluzând şi protocolul. De exemplu, http://www.example.com/.',
    'WROTE'                     => 'scrie',

    'YEAR'              => 'An',
    'YEAR_MONTH_DAY'    => '(YYYY-MM-DD)',
    'YES'               => 'Da',
    'YIM'               => 'YIM',   
    'YOU_LAST_VISIT'    => 'Ultima vizită a fost: %s',
    'YOU_NEW_PM'        => 'Un nou mesaj privat vă aşteaptă în căsuţa cu mesaje private.',
    'YOU_NEW_PMS'       => 'Noi mesaje private vă aşteaptă în căsuţa cu mesaje private.',
    'YOU_NO_NEW_PM'     => 'Nu aveţi niciun mesaj privat.',

    'datetime'          => array(
        'TODAY'     => 'Astăzi, ',
        'TOMORROW'  => 'Mâine, ',
        'YESTERDAY' => 'Ieri, ',
        'AGO'		=> array(
			0		=> 'mai puţin de un minut în urmă',
			1		=> '%d minut în urmă',
			2		=> '%d minute în urmă',
			60		=> '1 oră în urmă',
		),  
        'Sunday'    => 'Duminică',
        'Monday'    => 'Luni',
        'Tuesday'   => 'Marţi',
        'Wednesday' => 'Miercuri',
        'Thursday'  => 'Joi',
        'Friday'    => 'Vineri',
        'Saturday'  => 'Sâmbătă',

        'Sun'       => 'Dum',
        'Mon'       => 'Lun',
        'Tue'       => 'Mar',
        'Wed'       => 'Mie',
        'Thu'       => 'Joi',
        'Fri'       => 'Vin',
        'Sat'       => 'Sâm',

        'January'   => 'Ianuarie',
        'February'  => 'Februarie',
        'March'     => 'Martie',
        'April'     => 'Aprilie',
        'May'       => 'Mai',
        'June'      => 'Iunie',
        'July'      => 'Iulie',
        'August'    => 'August',
        'September' => 'Septembrie',
        'October'   => 'Octombrie',
        'November'  => 'Noiembrie',
        'December'  => 'Decembrie',

        'Jan'       => 'Ian',
        'Feb'       => 'Feb',
        'Mar'       => 'Mar',
        'Apr'       => 'Apr',
        'May_short' => 'Mai',   // Short representation of "May". May_short used because in english the short and long date are the same for May.
        'Jun'       => 'Iun',
        'Jul'       => 'Iul',
        'Aug'       => 'Aug',
        'Sep'       => 'Sep',
        'Oct'       => 'Oct',
        'Nov'       => 'Noi',
        'Dec'       => 'Dec',
    ),

    'tz'                => array(
        '-12'   => 'UTC - 12',
        '-11'   => 'UTC - 11',
        '-10'   => 'UTC - 10',
        '-9.5'  => 'UTC - 9:30',
        '-9'    => 'UTC - 9',
        '-8'    => 'UTC - 8',
        '-7'    => 'UTC - 7',
        '-6'    => 'UTC - 6',
        '-5'    => 'UTC - 5',
        '-4.5'   => 'UTC - 4:30',
        '-4'    => 'UTC - 4',
        '-3.5'  => 'UTC - 3:30',
        '-3'    => 'UTC - 3',
        '-2'    => 'UTC - 2',
        '-1'    => 'UTC - 1',
        '0'     => 'UTC',
        '1'     => 'UTC + 1',
        '2'     => 'UTC + 2',
        '3'     => 'UTC + 3',
        '3.5'   => 'UTC + 3:30',
        '4'     => 'UTC + 4',
        '4.5'   => 'UTC + 4:30',
        '5'     => 'UTC + 5',
        '5.5'   => 'UTC + 5:30',
        '5.75'  => 'UTC + 5:45',
        '6'     => 'UTC + 6',
        '6.5'   => 'UTC + 6:30',
        '7'     => 'UTC + 7',
        '8'     => 'UTC + 8',
        '8.75'  => 'UTC + 8:45',
        '9'     => 'UTC + 9',
        '9.5'   => 'UTC + 9:30',
        '10'    => 'UTC + 10',
        '10.5'  => 'UTC + 10:30',
        '11'    => 'UTC + 11',
        '11.5'  => 'UTC + 11:30',
        '12'    => 'UTC + 12',
        '12.75' => 'UTC + 12:45',
        '13'    => 'UTC + 13',
        '14'    => 'UTC + 14',
        'dst'   => '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
    ),

    'tz_zones'  => array(
        '-12'   => '[UTC - 12] Ora insulei Baker',
        '-11'   => '[UTC - 11] Ora Niue Time, Samoa Standard',
        '-10'   => '[UTC - 10] Ora Hawaii-Aleutian Standard Time, insulei Cook',
        '-9.5'  => '[UTC - 9:30] Ora insulelor Marquesas',
        '-9'    => '[UTC - 9] Ora Alaska Standard, insula Gambier',
        '-8'    => '[UTC - 8] Ora Pacific Standard',
        '-7'    => '[UTC - 7] Ora Mountain Standard',
        '-6'    => '[UTC - 6] Ora Central Standard',
        '-5'    => '[UTC - 5] Ora Eastern Standard',
        '-4.5'   => '[UTC - 4:30] Ora Venezuela Standard',
        '-4'    => '[UTC - 4] Ora Atlantic Standard',
        '-3.5'  => '[UTC - 3:30] Ora Newfoundland Standard',
        '-3'    => '[UTC - 3] Ora Amazon Standard, Central Greenland',
        '-2'    => '[UTC - 2] Ora Fernando de Noronha, South Georgia &amp; insulele South Sandwich',
        '-1'    => '[UTC - 1] Ora Azores Standard, Capul Verde, Eastern Greenland',
        '0'     => '[UTC] Ora Western European, Greenwich Mean Time',
        '1'     => '[UTC + 1] Ora Central European, West African',
        '2'     => '[UTC + 2] Ora Eastern European, Central African',
        '3'     => '[UTC + 3] Ora Moscova Standard, Eastern African',
        '3.5'   => '[UTC + 3:30] Ora Iran Standard',
        '4'     => '[UTC + 4] Ora Gulf Standard, Samara Standard',
        '4.5'   => '[UTC + 4:30] Ora Afghanistan',
        '5'     => '[UTC + 5] Ora Pakistan Standard, Yekaterinburg Standard',
        '5.5'   => '[UTC + 5:30] Ora Indian Standard, Sri Lanka',
        '5.75'  => '[UTC + 5:45] Ora Nepal',
        '6'     => '[UTC + 6] Ora Bangladesh, Bhutan, Novosibirsk Standard',
        '6.5'   => '[UTC + 6:30] Ora insulelor Cocos, Myanmar',
        '7'     => '[UTC + 7] Ora Indochina, Krasnoyarsk Standard',
        '8'     => '[UTC + 8] Ora Chinese Standard, Australian Western Standard, Irkutsk Standard',
        '8.75'  => '[UTC + 8:45] Ora Southeastern Western Australia Standard',
        '9'     => '[UTC + 9] Ora Japan Standard, Korea Standard, Chita Standard',
        '9.5'   => '[UTC + 9:30] Ora Australian Central Standard',
        '10'    => '[UTC + 10] Ora Australian Eastern Standard, Vladivostok Standard',
        '10.5'  => '[UTC + 10:30] Ora Lord Howe Standard',
        '11'    => '[UTC + 11] Ora insulei Solomon, Magadan Standard',
        '11.5'  => '[UTC + 11:30] Ora insulei Norfolk',
        '12'    => '[UTC + 12] Ora New Zealand, Fiji, Kamchatka Standard',
        '12.75' => '[UTC + 12:45] Ora insulelor Chatham',
        '13'    => '[UTC + 13] Ora Tonga, insulelor Phoenix',
        '14'    => '[UTC + 14] Ora insulei Line',
    ),

    // The value is only an example and will get replaced by the current time on view
    'dateformats'   => array(
        'd M Y, H:i'            => '01 Ian 2007, 13:37',
        'd M Y H:i'             => '01 Ian 2007 13:37',
        'M jS, \'y, H:i'        => '1 Ian, \'07, 13:37',
        'D M d, Y g:i a'        => 'Lun Ian 01, 2007 1:37 pm',
        'F jS, Y, g:i a'        => '1 Ianuarie, 2007, 1:37 pm',
        '|d M Y|, H:i'          => 'Astăzi, 13:37 / 01 Ian 2007, 13:37',
        '|F jS, Y|, g:i a'      => 'Astăzi, 1:37 pm / 1 Ianuarie, 2007, 1:37 pm'
    ),

    // The default dateformat which will be used on new installs in this language
    // Translators should change this if a the usual date format is different
    'default_dateformat'    => 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));

?>