#ifndef PANDORA_H
#define PANDORA_H 1

/* gimp plugin boilerplate, needed for any plugin with UI */

#ifdef IN_GIMP_TREE
#include "config.h"
#include "libgimp/stdplugins-intl.h"
#else
/* gimptool doesn't understand these: */
#define _(s)   s
#define N_(s)  s
#define INIT_I18N() 
#define INIT_I18N_UI() 
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <libgen.h>

#include <gtk/gtk.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

/* Backwards compatibility defines for gimp 1.2: */
#ifdef G_N_ELEMENTS   /* Gimp 1.3 */

#define GIMP_ENABLE_COMPAT_CRUFT
#include <libgimp/gimpcompat.h>

#define MAYBE_CONST const

#else  /* It's 1.2 after all */

#define GIMP_1_2 1
#define GimpRunMode gint32
#define drawable_id id
#define G_CALLBACK GTK_SIGNAL_FUNC
#define G_OBJECT GTK_OBJECT
#define g_signal_connect gtk_signal_connect
#define gtk_check_button_new_with_mnemonic gtk_check_button_new_with_label

#define GTK_STOCK_CANCEL _("Cancel")
#define GTK_STOCK_OK _("Ok")

#define G_N_ELEMENTS(a) ((sizeof a) / (sizeof (*(a))))

#define MAYBE_CONST

#endif /* G_N_ELEMENTS, gimp 1.2 backward compatibility */

#endif /* PANDORA_H */
