###############################################################################
# OpenVAS Vulnerability Test
# $Id: snitz_forums_2000_37637.nasl 7589 2010-05-07 14:33:00Z chandra $
#
# Snitz Forums 2000 'X-Forwarded-For' SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100431);
 script_bugtraq_id(37637);
 script_version ("1.0-$Revision: 7589 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Snitz Forums 2000 'X-Forwarded-For' SQL Injection Vulnerability");

desc = "Overview:
Snitz Forums 2000 is prone to an SQL-injection vulnerability because
it fails to sufficiently sanitize user-supplied data before using it
in an SQL query.

Exploiting this issue could allow an attacker to compromise the
application, access or modify data, or exploit latent vulnerabilities
in the underlying database.

Snitz Forums 2000 3.4.07 is vulnerable; other versions may also
be affected.

References:
http://www.securityfocus.com/bid/37637
http://forum.snitz.com/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Snitz Forums 2000 version is 3.4.07");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("snitz_forums_2000_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_asp(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/SnitzForums")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "3.4.07")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);

