###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sami_ftp_serv_mult_cmd_dos_vuln.nasl 491 2008-11-18 19:39:24Z nov $
#
# Sami FTP Server Multiple Commands Denial of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800305);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5105","CVE-2008-5106");
  script_bugtraq_id(27817);
  script_name("Sami FTP Server Multiple Commands Denial of Service Vulnerability");
  desc = "

  Overview: This host is running Sami FTP Server and is prone to remote denial
  of service vulnerability.

  Vulnerability Insight:
  The flaw exists in server, due to improper handling of input passed ot the
  commands (e.g., APPE, CWD, DELE, MKD, RMD, RETR, RNFR, RNTO, SIZE, and STOR).

  Impact:
  Successful exploitation will allow remote attackers to deny the service.

  Affected Software/OS:
  KarjaSoft Sami FTP Server version 2.0.2 and prior

  Fix: No solution/patch is available as on 18th November, 2008. Information
  regarding this issue will updated once the solution details are available.

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5105
  http://www.securityfocus.com/archive/1/archive/1/488198/100/200/threaded

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Sami FTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(get_port_state(port))
{
  banner = get_ftp_banner(port:port);
  if("Sami FTP Server" >!< banner){
    exit(0);
  }

  ftpVer = eregmatch(pattern:"Sami FTP Server ([0-9.]+)", string:banner);
  if(ftpVer != NULL)
  {
    # Grep versions 2.0.2 and prior
    if(version_is_less_equal(version:ftpVer[1], test_version:"2.0.2")){
      security_hole(port);
    }
  }
}
