###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dovecot_base_dir_sec_bypass_vuln.nasl 5899 2009-11-30 11:17:55Z nov $
#
# Dovecot 'base_dir' Insecure Permissions Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it undr the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801055);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3897");
  script_bugtraq_id(37084);
  script_name("Dovecot 'base_dir' Insecure Permissions Security Bypass Vulnerability");
  desc = "
  Overview: This host has Dovecot installed and is prone to Security Bypass
  Vulnerability

  Vulnerability Insight:
  This flaw is caused due to insecure permissions (0777) being set on the 'base_dir'
  directory and its parents, which could allow malicious users to replace auth
  sockets and log in as other users.

  Impact:
  Successful attack could allow malicious people to log in as another user,
  which may aid in further attacks.

  Impact Level: System

  Affected Software/OS:
  Dovecot versions 1.2 before 1.2.8

  Fix: Apply the patch or upgrade to Dovecot version 1.2.8
  http://www.dovecot.org/download.html

  References:
  http://xforce.iss.net/xforce/xfdb/54363
  http://www.vupen.com/english/advisories/2009/3306
  http://www.dovecot.org/list/dovecot-news/2009-November/000143.html

  CVSS Score:
    CVSS Base Score      : 4.6 (AV:L/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Dovecot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_dovecot_detect.nasl");
  script_require_keys("Dovecot/Ver");
  exit(0);
}


include("version_func.inc");

dovecotVer = get_kb_item("Dovecot/Ver");
if((dovecotVer != NULL) && (dovecotVer =~ "^1\.2"))
{
  if(version_is_less(version:dovecotVer, test_version:"1.2.8")){
    security_warning(0);
  }
}
