/*
 *  Copyright (c) 2009,2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "LightParser_p.h"

#include "GTLCore/Debug.h"
#include "GTLFragment/Lexer_p.h"

using namespace OpenRijn;

struct LightParser::Private {
  GTLFragment::Lexer* lexer;
  GTLCore::String name;
  Source::SourceType sourceType;
};

LightParser::LightParser( GTLFragment::Lexer* lexer ) : ParserBase(0, lexer), d(new Private)
{
  d->lexer = lexer;
}

LightParser::~LightParser()
{
  
}

GTLCore::AST::Tree* LightParser::parse()
{
  d->name = "";
  
  getNextToken();
  // Start by ingoring metadata if any
  if( currentToken().type == GTLCore::Token::INFERIOR )
  {
    eatLoopOf( GTLCore::Token::INFERIOR, GTLCore::Token::SUPPERIOR );
    if( isOfType( currentToken(), GTLCore::Token::SEMI ) )
    {
      getNextToken();
    }
  }
  
  // Parse "import"
  while( currentToken().type == GTLCore::Token::IMPORT )
  {
    getNextToken();
    if( isOfType( currentToken(), GTLCore::Token::STRING_CONSTANT ) )
    {
    }
    checkNextTokenIsSemi();
    getNextToken();
  }
  
  GTL_DEBUG("Parse body");
  bool isKernel = false;
  if( currentToken().type == GTLCore::Token::LIBRARY ) {
    d->sourceType = Source::Library;
  } else {
    d->sourceType = Source::Drawing;
    isKernel = true;
  }
  getNextToken();
  if( isOfType( currentToken(), GTLCore::Token::IDENTIFIER ) )
  {
    d->name = currentToken().string;
  }
  
  getNextToken();
  if( isOfType( currentToken(), GTLCore::Token::STARTBRACE ) )
  {
    getNextToken();
    while(true)
    {
      switch(currentToken().type)
      {
        case GTLCore::Token::END_OF_FILE:
        case GTLCore::Token::ENDBRACE:
          return 0;
        case GTLCore::Token::DEPENDENT:
        case GTLCore::Token::CONST:
          eatUntil(GTLCore::Token::SEMI, GTLCore::Token::SEMI);
          getNextToken(); // eath the ';'
          break;
        case GTLCore::Token::STRUCT:
          eatUntil(GTLCore::Token::ENDBRACE, GTLCore::Token::ENDBRACE);
          getNextToken(); // eat the '}'
          getNextToken(); // eat the ';'
          break;
        default:
        {
          getNextToken(); // Return type
          if( currentToken().type == GTLCore::Token::IDENTIFIER )
          {
            GTL_DEBUG(currentToken().string);
            getNextToken();
            eatUntil( GTLCore::Token::ENDBRACKET, GTLCore::Token::ENDBRACKET );
            getNextToken(); // eath the ')'
            eatLoopOf( GTLCore::Token::STARTBRACE, GTLCore::Token::ENDBRACE );
          }
        }
      }
      
    }
  }
  
  return 0;
}

void LightParser::eatUntil( GTLCore::Token::Type type1,  GTLCore::Token::Type type2)
{
  while( currentToken().type != type1 and currentToken().type != type2 and currentToken().type != GTLCore::Token::END_OF_FILE )
  {
//     GTL_DEBUG( currentToken().type << " " << GTLCore::Token::typeToString(currentToken().type));
    getNextToken();
  }
}

void LightParser::eatLoopOf( GTLCore::Token::Type start, GTLCore::Token::Type end)
{
  int count = 0;
  do
  {
    if( currentToken().type == start )
    {
      ++count;
    } else if( currentToken().type == end ) {
      --count;
    }
    getNextToken();
  } while( count > 0 and currentToken().type != GTLCore::Token::END_OF_FILE  );
}

GTLCore::String LightParser::name() const
{
  return d->name;
}

Source::SourceType LightParser::sourceType() const
{
  return d->sourceType;
}
