///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2006, Industrial Light & Magic, a division of Lucas
// Digital Ltd. LLC
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// *       Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// *       Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
// *       Neither the name of Industrial Light & Magic nor the names of
// its contributors may be used to endorse or promote products derived
// from this software without specific prior written permission. 
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
///////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_FILE_READING_THREAD_H
#define INCLUDED_FILE_READING_THREAD_H

//-----------------------------------------------------------------------------
//
//	class FileReadingThread
//
//	The file reading thread for the playExr application; reads
//	image files and hands the pixels to the display thread.
//
//-----------------------------------------------------------------------------

#include <IlmThread.h>
#include <string>

class ImageBuffers;


class FileReadingThread: IlmThread::Thread
{
  public:

    //----------------------------------------------------------------
    // Constructor - stores the arguments passed by the caller,
    // and starts the thread by calling run(), below.  The caller
    // must not destroy the FileReadingThread object while the
    // thread is running.
    //
    // Arguments:
    //
    // fileNameTemplate		The file name for frame f will
    //				be generated by calling
    //				fileNameForFrame (fileNameTemplate, f)
    //
    // firstFrame, lastFrame	Range of frame numbers to be loaded.
    //				after loading the last frame, the
    //				file reading thread starts over with
    //				the first frame.
    //
    // imageBuffers		A ring buffer for the pixel data
    //				loaded from the image files.  The
    //				ring buffer has enough space for
    //				imageBuffers.numBuffers() images.
    //				Two semaphores track the number of
    //				empty and full image buffers.
    //				The file reading thread fills the
    //				buffers, and the display thread
    //				empties them.
    //----------------------------------------------------------------

    FileReadingThread
	(const char fileNameTemplate[],
	 int firstFrame,
	 int lastFrame,
	 ImageBuffers &imageBuffers);
	 
    virtual void run();

  private:

    const std::string	_fileNameTemplate;
    int			_firstFrame;
    int			_lastFrame;
    ImageBuffers &	_imageBuffers;
};

#endif
