/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import org.chefproject.util.Time;

public class TimeRange
implements Cloneable {
    protected boolean m_startIncluded = true;
    protected boolean m_endIncluded = true;
    protected Time m_startTime = null;
    protected Time m_endTime = null;

    protected Object clone() {
        TimeRange obj = new TimeRange(this.m_startTime.makeClone(), this.m_endTime.makeClone(), this.m_startIncluded, this.m_endIncluded);
        return obj;
    }

    public TimeRange(Time start, Time end, boolean startIncluded, boolean endIncluded) {
        this.m_startTime = start;
        this.m_endTime = end;
        this.m_startIncluded = startIncluded;
        this.m_endIncluded = endIncluded;
        if (this.m_startTime.getTime() > this.m_endTime.getTime()) {
            Time t = this.m_startTime;
            this.m_startTime = this.m_endTime;
            this.m_endTime = t;
        }
    }

    public TimeRange(String str) throws Invalid {
        this.parse(str, null, null);
    }

    public TimeRange(String str, Time earliest, Time latest) throws Invalid {
        this.parse(str, earliest, latest);
    }

    public TimeRange(Time startAndEnd) {
        this(startAndEnd, startAndEnd, true, true);
    }

    public TimeRange(long start, long duration) {
        this.m_startTime = new Time(start);
        this.m_endTime = new Time(start + duration);
        this.m_startIncluded = true;
        this.m_endIncluded = true;
        if (this.m_startTime.getTime() > this.m_endTime.getTime()) {
            Time t = this.m_startTime;
            this.m_startTime = this.m_endTime;
            this.m_endTime = t;
        }
    }

    public TimeRange(Time start, Time end) {
        this(start, end, true, true);
    }

    public TimeRange(RandomAccessFile file) throws IOException {
        this.m_startIncluded = file.readBoolean();
        this.m_endIncluded = file.readBoolean();
        this.m_startTime = new Time(file.readLong());
        this.m_endTime = new Time(file.readLong());
        if (this.m_startTime.getTime() > this.m_endTime.getTime()) {
            Time t = this.m_startTime;
            this.m_startTime = this.m_endTime;
            this.m_endTime = t;
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        file.writeBoolean(this.m_startIncluded);
        file.writeBoolean(this.m_endIncluded);
        file.writeLong(this.m_startTime.getTime());
        file.writeLong(this.m_endTime.getTime());
    }

    public boolean contains(Time time) {
        boolean inRange = true;
        if (time.before(this.m_startTime) || time.after(this.m_endTime)) {
            inRange = false;
        } else if (!this.m_startIncluded && time.equals(this.m_startTime)) {
            inRange = false;
        } else if (!this.m_endIncluded && time.equals(this.m_endTime)) {
            inRange = false;
        }
        return inRange;
    }

    public boolean overlaps(TimeRange range) {
        boolean overlaps = false;
        if (range.contains(this.firstTime())) {
            overlaps = true;
        } else if (range.contains(this.lastTime())) {
            overlaps = true;
        } else if (this.contains(range)) {
            overlaps = true;
        }
        return overlaps;
    }

    public boolean contains(TimeRange range) {
        return this.contains(range.firstTime()) && this.contains(range.lastTime());
    }

    public Time firstTime() {
        return this.firstTime(1L);
    }

    public Time lastTime() {
        return this.lastTime(1L);
    }

    public Time firstTime(long fudge) {
        if (this.m_startIncluded) {
            return this.m_startTime;
        }
        return new Time(this.m_startTime.getTime() + fudge);
    }

    public Time lastTime(long fudge) {
        if (this.m_endIncluded) {
            return this.m_endTime;
        }
        return new Time(this.m_endTime.getTime() - fudge);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.m_startTime);
        if (!this.m_startTime.equals(this.m_endTime)) {
            if (this.m_startIncluded && this.m_endIncluded) {
                buf.append('-');
            } else if (!this.m_startIncluded && !this.m_endIncluded) {
                buf.append('~');
            } else if (!this.m_startIncluded) {
                buf.append('[');
            } else {
                buf.append(']');
            }
            buf.append(this.m_endTime);
        }
        return buf.toString();
    }

    public String toStringHR() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.m_startTime.toStringGmtFull());
        if (!this.m_startTime.equals(this.m_endTime)) {
            if (this.m_startIncluded && this.m_endIncluded) {
                buf.append(" - ");
            } else if (!this.m_startIncluded && !this.m_endIncluded) {
                buf.append(" ~ ");
            } else if (!this.m_startIncluded) {
                buf.append(" [ ");
            } else {
                buf.append(" ] ");
            }
            buf.append(this.m_endTime.toStringGmtFull());
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof TimeRange) {
            equals = ((TimeRange)obj).m_startIncluded == this.m_startIncluded && ((TimeRange)obj).m_endIncluded == this.m_endIncluded && ((TimeRange)obj).m_startTime.equals(this.m_startTime) && ((TimeRange)obj).m_endTime.equals(this.m_endTime);
        }
        return equals;
    }

    public long duration() {
        return this.lastTime().getTime() - this.firstTime().getTime();
    }

    protected void parse(String str, Time earliest, Time latest) throws Invalid {
        StringTokenizer tokenizer = new StringTokenizer(str, "[]~-", true);
        int tokenCount = 0;
        long startMs = -1L;
        long endMs = -1L;
        this.m_startTime = null;
        this.m_endTime = null;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            block0 : switch (++tokenCount) {
                case 1: {
                    if (next.equals("*")) {
                        if (latest == null) {
                            throw new Invalid("* null");
                        }
                        this.m_startTime = latest;
                        break;
                    }
                    if (next.equals("!")) {
                        if (earliest == null) {
                            throw new Invalid("! null");
                        }
                        this.m_startTime = earliest;
                        break;
                    }
                    if (next.charAt(0) == '=') {
                        startMs = Long.parseLong(next.substring(1));
                        break;
                    }
                    this.m_startTime = new Time(next);
                    break;
                }
                case 2: {
                    switch (next.charAt(0)) {
                        case '[': {
                            this.m_startIncluded = false;
                            this.m_endIncluded = true;
                            break block0;
                        }
                        case ']': {
                            this.m_startIncluded = true;
                            this.m_endIncluded = false;
                            break block0;
                        }
                        case '~': {
                            this.m_startIncluded = false;
                            this.m_endIncluded = false;
                            break block0;
                        }
                        case '-': {
                            this.m_startIncluded = true;
                            this.m_endIncluded = true;
                            break block0;
                        }
                    }
                    throw new Invalid(next.charAt(0) + " invalid");
                }
                case 3: {
                    if (next.equals("*")) {
                        if (latest == null) {
                            throw new Invalid("* null");
                        }
                        this.m_endTime = latest;
                        break;
                    }
                    if (next.equals("!")) {
                        if (earliest == null) {
                            throw new Invalid("! null");
                        }
                        this.m_endTime = earliest;
                        break;
                    }
                    if (next.charAt(0) == '=') {
                        endMs = Long.parseLong(next.substring(1));
                        break;
                    }
                    this.m_endTime = new Time(next);
                    break;
                }
                default: {
                    throw new Invalid(">3 tokens");
                }
            }
        }
        if (startMs != -1L && endMs != -1L) {
            throw new Invalid("==");
        }
        if (startMs != -1L) {
            if (this.m_endTime == null) {
                throw new Invalid("=, * null");
            }
            this.m_startTime = new Time(this.m_endTime.getTime() - startMs);
        } else if (endMs != -1L) {
            if (this.m_startTime == null) {
                throw new Invalid("=, ! null");
            }
            this.m_endTime = new Time(this.m_startTime.getTime() + endMs);
        }
        if (tokenCount == 1) {
            this.m_endTime = this.m_startTime;
            this.m_startIncluded = true;
            this.m_endIncluded = true;
        }
        if (this.m_startTime.getTime() > this.m_endTime.getTime()) {
            Time t = this.m_startTime;
            this.m_startTime = this.m_endTime;
            this.m_endTime = t;
        }
    }

    public void shiftBackward(long i) {
        this.m_startTime.setTime(this.m_startTime.getTime() - i);
        this.m_endTime.setTime(this.m_endTime.getTime() - i);
    }

    public void shiftForward(long i) {
        this.m_startTime.setTime(this.m_startTime.getTime() + i);
        this.m_endTime.setTime(this.m_endTime.getTime() + i);
    }

    public void zoom(double f) {
        long oldRange = this.m_endTime.getTime() - this.m_startTime.getTime();
        long center = this.m_startTime.getTime() + oldRange / 2L;
        long newRange = (long)((double)oldRange * f);
        this.m_startTime.setTime(center - newRange / 2L);
        this.m_endTime.setTime(center + newRange / 2L);
    }

    public TimeRange makeClone() {
        return (TimeRange)this.clone();
    }

    public boolean isSingleTime() {
        return this.m_startTime.equals(this.m_endTime) && this.m_startIncluded && this.m_endIncluded;
    }

    public class Invalid
    extends Exception {
        public Invalid() {
        }

        public Invalid(String s) {
            super(s);
        }
    }
}

