/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp_stdlib.h"
#include "ntp_calendar.h"
#include "ntp_unixtime.h"
#include <string.h>

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_DaySplitMerge(void);
extern void test_SplitYearDays1(void);
extern void test_SplitYearDays2(void);
extern void test_RataDie1(void);
extern void test_LeapYears1(void);
extern void test_LeapYears2(void);
extern void test_RoundTripDate(void);
extern void test_RoundTripYearStart(void);
extern void test_RoundTripMonthStart(void);
extern void test_RoundTripWeekStart(void);
extern void test_RoundTripDayStart(void);
extern void test_IsoCalYearsToWeeks(void);
extern void test_IsoCalWeeksToYearStart(void);
extern void test_IsoCalWeeksToYearEnd(void);
extern void test_DaySecToDate(void);
extern void test_NtpToNtp(void);
extern void test_NtpToTime(void);


//=======Suite Setup=====
static void suite_setup(void)
{
extern int change_logfile(const char*, int);
change_logfile("stderr", 0);
}

//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  suite_setup();
  UnityBegin("calendar.c");
  RUN_TEST(test_DaySplitMerge, 24);
  RUN_TEST(test_SplitYearDays1, 25);
  RUN_TEST(test_SplitYearDays2, 26);
  RUN_TEST(test_RataDie1, 27);
  RUN_TEST(test_LeapYears1, 28);
  RUN_TEST(test_LeapYears2, 29);
  RUN_TEST(test_RoundTripDate, 30);
  RUN_TEST(test_RoundTripYearStart, 31);
  RUN_TEST(test_RoundTripMonthStart, 32);
  RUN_TEST(test_RoundTripWeekStart, 33);
  RUN_TEST(test_RoundTripDayStart, 34);
  RUN_TEST(test_IsoCalYearsToWeeks, 35);
  RUN_TEST(test_IsoCalWeeksToYearStart, 36);
  RUN_TEST(test_IsoCalWeeksToYearEnd, 37);
  RUN_TEST(test_DaySecToDate, 38);
  RUN_TEST(test_NtpToNtp, 40);
  RUN_TEST(test_NtpToTime, 41);

  return (UnityEnd());
}
