from pybindgen import Module, FileCodeSink, param, retval, cppclass, typehandlers


import pybindgen.settings
import warnings

class ErrorHandler(pybindgen.settings.ErrorHandler):
    def handle_error(self, wrapper, exception, traceback_):
        warnings.warn("exception %r in wrapper %s" % (exception, wrapper))
        return True
pybindgen.settings.error_handler = ErrorHandler()


import sys

def module_init():
    root_module = Module('ns.lte', cpp_namespace='::ns3')
    return root_module

def register_types(module):
    root_module = module.get_root()
    
    ## log.h (module 'core'): ns3::LogLevel [enumeration]
    module.add_enum('LogLevel', ['LOG_NONE', 'LOG_ERROR', 'LOG_LEVEL_ERROR', 'LOG_WARN', 'LOG_LEVEL_WARN', 'LOG_DEBUG', 'LOG_LEVEL_DEBUG', 'LOG_INFO', 'LOG_LEVEL_INFO', 'LOG_FUNCTION', 'LOG_LEVEL_FUNCTION', 'LOG_LOGIC', 'LOG_LEVEL_LOGIC', 'LOG_ALL', 'LOG_LEVEL_ALL', 'LOG_PREFIX_FUNC', 'LOG_PREFIX_TIME', 'LOG_PREFIX_NODE', 'LOG_PREFIX_LEVEL', 'LOG_PREFIX_ALL'], import_from_module='ns.core')
    ## ff-mac-common.h (module 'lte'): ns3::Result_e [enumeration]
    module.add_enum('Result_e', ['SUCCESS', 'FAILURE'])
    ## ff-mac-common.h (module 'lte'): ns3::SetupRelease_e [enumeration]
    module.add_enum('SetupRelease_e', ['setup', 'release'])
    ## ff-mac-common.h (module 'lte'): ns3::CeBitmap_e [enumeration]
    module.add_enum('CeBitmap_e', ['TA', 'DRX', 'CR'])
    ## ff-mac-common.h (module 'lte'): ns3::NormalExtended_e [enumeration]
    module.add_enum('NormalExtended_e', ['normal', 'extended'])
    ## address.h (module 'network'): ns3::Address [class]
    module.add_class('Address', import_from_module='ns.network')
    ## address.h (module 'network'): ns3::Address::MaxSize_e [enumeration]
    module.add_enum('MaxSize_e', ['MAX_SIZE'], outer_class=root_module['ns3::Address'], import_from_module='ns.network')
    ## eps-bearer.h (module 'lte'): ns3::AllocationRetentionPriority [struct]
    module.add_class('AllocationRetentionPriority')
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList [class]
    module.add_class('AttributeConstructionList', import_from_module='ns.core')
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::Item [struct]
    module.add_class('Item', import_from_module='ns.core', outer_class=root_module['ns3::AttributeConstructionList'])
    typehandlers.add_type_alias('std::list< ns3::AttributeConstructionList::Item > const_iterator', 'ns3::AttributeConstructionList::CIterator')
    typehandlers.add_type_alias('std::list< ns3::AttributeConstructionList::Item > const_iterator*', 'ns3::AttributeConstructionList::CIterator*')
    typehandlers.add_type_alias('std::list< ns3::AttributeConstructionList::Item > const_iterator&', 'ns3::AttributeConstructionList::CIterator&')
    ## spectrum-model.h (module 'spectrum'): ns3::BandInfo [struct]
    module.add_class('BandInfo', import_from_module='ns.spectrum')
    ## buffer.h (module 'network'): ns3::Buffer [class]
    module.add_class('Buffer', import_from_module='ns.network')
    ## buffer.h (module 'network'): ns3::Buffer::Iterator [class]
    module.add_class('Iterator', import_from_module='ns.network', outer_class=root_module['ns3::Buffer'])
    ## lte-common.h (module 'lte'): ns3::BufferSizeLevelBsr [class]
    module.add_class('BufferSizeLevelBsr')
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s [struct]
    module.add_class('BuildBroadcastListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s::Type_e [enumeration]
    module.add_enum('Type_e', ['BCCH', 'PCCH'], outer_class=root_module['ns3::BuildBroadcastListElement_s'])
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s [struct]
    module.add_class('BuildDataListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::BuildRarListElement_s [struct]
    module.add_class('BuildRarListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::BwPart_s [struct]
    module.add_class('BwPart_s')
    ## packet.h (module 'network'): ns3::ByteTagIterator [class]
    module.add_class('ByteTagIterator', import_from_module='ns.network')
    ## packet.h (module 'network'): ns3::ByteTagIterator::Item [class]
    module.add_class('Item', import_from_module='ns.network', outer_class=root_module['ns3::ByteTagIterator'])
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList [class]
    module.add_class('ByteTagList', import_from_module='ns.network')
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator [class]
    module.add_class('Iterator', import_from_module='ns.network', outer_class=root_module['ns3::ByteTagList'])
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item [struct]
    module.add_class('Item', import_from_module='ns.network', outer_class=root_module['ns3::ByteTagList::Iterator'])
    ## callback.h (module 'core'): ns3::CallbackBase [class]
    module.add_class('CallbackBase', import_from_module='ns.core')
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t [struct]
    module.add_class('CqasFlowPerf_t')
    ## ff-mac-common.h (module 'lte'): ns3::CqiConfig_s [struct]
    module.add_class('CqiConfig_s')
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s [struct]
    module.add_class('CqiListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::CqiType_e [enumeration]
    module.add_enum('CqiType_e', ['P10', 'P11', 'P20', 'P21', 'A12', 'A22', 'A20', 'A30', 'A31'], outer_class=root_module['ns3::CqiListElement_s'])
    ## data-output-interface.h (module 'stats'): ns3::DataOutputCallback [class]
    module.add_class('DataOutputCallback', import_from_module='ns.stats', allow_subclassing=True)
    ## data-rate.h (module 'network'): ns3::DataRate [class]
    module.add_class('DataRate', import_from_module='ns.network')
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeAccessor> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::AttributeAccessor'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeChecker> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::AttributeChecker'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeValue> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::AttributeValue'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::CallbackImplBase> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::CallbackImplBase'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::EpcTft> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::EpcTft'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::EventImpl> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::EventImpl'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::Hash::Implementation> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::Hash::Implementation'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteChunkProcessor> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::LteChunkProcessor'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteControlMessage> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::LteControlMessage'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteHarqPhy> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::LteHarqPhy'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::NixVector> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::NixVector'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::Packet> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::Packet'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumModel> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::SpectrumModel'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumSignalParameters> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::SpectrumSignalParameters'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumValue> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::SpectrumValue'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::TraceSourceAccessor> [struct]
    module.add_class('DefaultDeleter', import_from_module='ns.core', template_parameters=['ns3::TraceSourceAccessor'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::VendorSpecificValue> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::VendorSpecificValue'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::X2CellInfo> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::X2CellInfo'])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::X2IfaceInfo> [struct]
    module.add_class('DefaultDeleter', template_parameters=['ns3::X2IfaceInfo'])
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s [struct]
    module.add_class('DlDciListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::Format_e [enumeration]
    module.add_enum('Format_e', ['ONE', 'ONE_A', 'ONE_B', 'ONE_C', 'ONE_D', 'TWO', 'TWO_A', 'TWO_B'], outer_class=root_module['ns3::DlDciListElement_s'])
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::VrbFormat_e [enumeration]
    module.add_enum('VrbFormat_e', ['VRB_DISTRIBUTED', 'VRB_LOCALIZED'], outer_class=root_module['ns3::DlDciListElement_s'])
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::Ngap_e [enumeration]
    module.add_enum('Ngap_e', ['GAP1', 'GAP2'], outer_class=root_module['ns3::DlDciListElement_s'])
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s [struct]
    module.add_class('DlInfoListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s::HarqStatus_e [enumeration]
    module.add_enum('HarqStatus_e', ['ACK', 'NACK', 'DTX'], outer_class=root_module['ns3::DlInfoListElement_s'])
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo [struct]
    module.add_class('DlSchedulingCallbackInfo')
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s [struct]
    module.add_class('DrxConfig_s')
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider [class]
    module.add_class('EpcEnbS1SapProvider', allow_subclassing=True)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::BearerToBeSwitched [struct]
    module.add_class('BearerToBeSwitched', outer_class=root_module['ns3::EpcEnbS1SapProvider'])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters [struct]
    module.add_class('PathSwitchRequestParameters', outer_class=root_module['ns3::EpcEnbS1SapProvider'])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser [class]
    module.add_class('EpcEnbS1SapUser', allow_subclassing=True)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters [struct]
    module.add_class('DataRadioBearerSetupRequestParameters', outer_class=root_module['ns3::EpcEnbS1SapUser'])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters [struct]
    module.add_class('InitialContextSetupRequestParameters', outer_class=root_module['ns3::EpcEnbS1SapUser'])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters [struct]
    module.add_class('PathSwitchRequestAcknowledgeParameters', outer_class=root_module['ns3::EpcEnbS1SapUser'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap [class]
    module.add_class('EpcS11Sap')
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Fteid [struct]
    module.add_class('Fteid', outer_class=root_module['ns3::EpcS11Sap'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::GtpcMessage [struct]
    module.add_class('GtpcMessage', outer_class=root_module['ns3::EpcS11Sap'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Uli [struct]
    module.add_class('Uli', outer_class=root_module['ns3::EpcS11Sap'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme [class]
    module.add_class('EpcS11SapMme', parent=root_module['ns3::EpcS11Sap'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated [struct]
    module.add_class('BearerContextCreated', outer_class=root_module['ns3::EpcS11SapMme'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextRemoved [struct]
    module.add_class('BearerContextRemoved', outer_class=root_module['ns3::EpcS11SapMme'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::CreateSessionResponseMessage [struct]
    module.add_class('CreateSessionResponseMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapMme'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::DeleteBearerRequestMessage [struct]
    module.add_class('DeleteBearerRequestMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapMme'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::ModifyBearerResponseMessage [struct]
    module.add_class('ModifyBearerResponseMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapMme'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::ModifyBearerResponseMessage::Cause [enumeration]
    module.add_enum('Cause', ['REQUEST_ACCEPTED', 'REQUEST_ACCEPTED_PARTIALLY', 'REQUEST_REJECTED', 'CONTEXT_NOT_FOUND'], outer_class=root_module['ns3::EpcS11SapMme::ModifyBearerResponseMessage'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw [class]
    module.add_class('EpcS11SapSgw', parent=root_module['ns3::EpcS11Sap'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw [struct]
    module.add_class('BearerContextRemovedSgwPgw', outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated [struct]
    module.add_class('BearerContextToBeCreated', outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeRemoved [struct]
    module.add_class('BearerContextToBeRemoved', outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::CreateSessionRequestMessage [struct]
    module.add_class('CreateSessionRequestMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerCommandMessage [struct]
    module.add_class('DeleteBearerCommandMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerResponseMessage [struct]
    module.add_class('DeleteBearerResponseMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::ModifyBearerRequestMessage [struct]
    module.add_class('ModifyBearerRequestMessage', parent=root_module['ns3::EpcS11Sap::GtpcMessage'], outer_class=root_module['ns3::EpcS11SapSgw'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSap [class]
    module.add_class('EpcS1apSap')
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb [class]
    module.add_class('EpcS1apSapEnb', parent=root_module['ns3::EpcS1apSap'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem [struct]
    module.add_class('ErabSwitchedInUplinkItem', outer_class=root_module['ns3::EpcS1apSapEnb'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem [struct]
    module.add_class('ErabToBeSetupItem', outer_class=root_module['ns3::EpcS1apSapEnb'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme [class]
    module.add_class('EpcS1apSapMme', parent=root_module['ns3::EpcS1apSap'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSetupItem [struct]
    module.add_class('ErabSetupItem', outer_class=root_module['ns3::EpcS1apSapMme'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem [struct]
    module.add_class('ErabSwitchedInDownlinkItem', outer_class=root_module['ns3::EpcS1apSapMme'])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabToBeReleasedIndication [struct]
    module.add_class('ErabToBeReleasedIndication', outer_class=root_module['ns3::EpcS1apSapMme'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap [class]
    module.add_class('EpcX2Sap')
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UlInterferenceOverloadIndicationItem [enumeration]
    module.add_enum('UlInterferenceOverloadIndicationItem', ['HighInterference', 'MediumInterference', 'LowInterference'], outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::LoadIndicator [enumeration]
    module.add_enum('LoadIndicator', ['LowLoad', 'MediumLoad', 'HighLoad', 'Overload'], outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::IdCause [enumeration]
    module.add_enum('IdCause', ['HandoverDesirableForRadioReason', 'TimeCriticalHandover'], outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem [struct]
    module.add_class('CellInformationItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem [struct]
    module.add_class('CellMeasurementResultItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CompositeAvailCapacity [struct]
    module.add_class('CompositeAvailCapacity', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabAdmittedItem [struct]
    module.add_class('ErabAdmittedItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabNotAdmittedItem [struct]
    module.add_class('ErabNotAdmittedItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem [struct]
    module.add_class('ErabToBeSetupItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem [struct]
    module.add_class('ErabsSubjectToStatusTransferItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams [struct]
    module.add_class('HandoverPreparationFailureParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams [struct]
    module.add_class('HandoverRequestAckParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams [struct]
    module.add_class('HandoverRequestParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::LoadInformationParams [struct]
    module.add_class('LoadInformationParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand [struct]
    module.add_class('RelativeNarrowbandTxBand', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams [struct]
    module.add_class('ResourceStatusUpdateParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams [struct]
    module.add_class('SnStatusTransferParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams [struct]
    module.add_class('UeContextReleaseParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams [struct]
    module.add_class('UeDataParams', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UlHighInterferenceInformationItem [struct]
    module.add_class('UlHighInterferenceInformationItem', outer_class=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2SapProvider [class]
    module.add_class('EpcX2SapProvider', parent=root_module['ns3::EpcX2Sap'])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2SapUser [class]
    module.add_class('EpcX2SapUser', parent=root_module['ns3::EpcX2Sap'])
    ## lte-common.h (module 'lte'): ns3::EutranMeasurementMapping [class]
    module.add_class('EutranMeasurementMapping')
    ## event-id.h (module 'core'): ns3::EventId [class]
    module.add_class('EventId', import_from_module='ns.core')
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider [class]
    module.add_class('FfMacCschedSapProvider', allow_subclassing=True)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters [struct]
    module.add_class('CschedCellConfigReqParameters', outer_class=root_module['ns3::FfMacCschedSapProvider'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::HoppingMode_e [enumeration]
    module.add_enum('HoppingMode_e', ['inter', 'interintra'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::PhichResource_e [enumeration]
    module.add_enum('PhichResource_e', ['PHICH_R_ONE_SIXTH', 'PHICH_R_HALF', 'PHICH_R_ONE', 'PHICH_R_TWO'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::DuplexMode_e [enumeration]
    module.add_enum('DuplexMode_e', ['DM_TDD', 'DM_FDD'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::Enable64Qam_e [enumeration]
    module.add_enum('Enable64Qam_e', ['MOD_16QAM', 'MOD_64QAM'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters [struct]
    module.add_class('CschedLcConfigReqParameters', outer_class=root_module['ns3::FfMacCschedSapProvider'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters [struct]
    module.add_class('CschedLcReleaseReqParameters', outer_class=root_module['ns3::FfMacCschedSapProvider'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters [struct]
    module.add_class('CschedUeConfigReqParameters', outer_class=root_module['ns3::FfMacCschedSapProvider'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::MeasGapConfigPattern_e [enumeration]
    module.add_enum('MeasGapConfigPattern_e', ['MGP_GP1', 'MGP_GP2', 'OFF'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::OpenClosedLoop_e [enumeration]
    module.add_enum('OpenClosedLoop_e', ['noneloop', 'openloop', 'closedloop'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::RepMode_e [enumeration]
    module.add_enum('RepMode_e', ['rm12', 'rm20', 'rm22', 'rm30', 'rm31', 'nonemode'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::FeedbackMode_e [enumeration]
    module.add_enum('FeedbackMode_e', ['bundling', 'multiplexing'], outer_class=root_module['ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters [struct]
    module.add_class('CschedUeReleaseReqParameters', outer_class=root_module['ns3::FfMacCschedSapProvider'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser [class]
    module.add_class('FfMacCschedSapUser', allow_subclassing=True)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters [struct]
    module.add_class('CschedCellConfigCnfParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters [struct]
    module.add_class('CschedCellConfigUpdateIndParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters [struct]
    module.add_class('CschedLcConfigCnfParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters [struct]
    module.add_class('CschedLcReleaseCnfParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters [struct]
    module.add_class('CschedUeConfigCnfParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters [struct]
    module.add_class('CschedUeConfigUpdateIndParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters [struct]
    module.add_class('CschedUeReleaseCnfParameters', outer_class=root_module['ns3::FfMacCschedSapUser'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider [class]
    module.add_class('FfMacSchedSapProvider', allow_subclassing=True)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters [struct]
    module.add_class('SchedDlCqiInfoReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters [struct]
    module.add_class('SchedDlMacBufferReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters [struct]
    module.add_class('SchedDlPagingBufferReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters [struct]
    module.add_class('SchedDlRachInfoReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters [struct]
    module.add_class('SchedDlRlcBufferReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters [struct]
    module.add_class('SchedDlTriggerReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters [struct]
    module.add_class('SchedUlCqiInfoReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters [struct]
    module.add_class('SchedUlMacCtrlInfoReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters [struct]
    module.add_class('SchedUlNoiseInterferenceReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters [struct]
    module.add_class('SchedUlSrInfoReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters [struct]
    module.add_class('SchedUlTriggerReqParameters', outer_class=root_module['ns3::FfMacSchedSapProvider'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser [class]
    module.add_class('FfMacSchedSapUser', allow_subclassing=True)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters [struct]
    module.add_class('SchedDlConfigIndParameters', outer_class=root_module['ns3::FfMacSchedSapUser'])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedUlConfigIndParameters [struct]
    module.add_class('SchedUlConfigIndParameters', outer_class=root_module['ns3::FfMacSchedSapUser'])
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation [struct]
    module.add_class('GbrQosInformation')
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes [class]
    module.add_class('GtpcIes')
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::Cause_t [enumeration]
    module.add_enum('Cause_t', ['RESERVED', 'REQUEST_ACCEPTED'], outer_class=root_module['ns3::GtpcIes'])
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t [struct]
    module.add_class('HarqProcessInfoElement_t')
    ## hash.h (module 'core'): ns3::Hasher [class]
    module.add_class('Hasher', import_from_module='ns.core')
    ## ff-mac-common.h (module 'lte'): ns3::HigherLayerSelected_s [struct]
    module.add_class('HigherLayerSelected_s')
    ## lte-common.h (module 'lte'): ns3::ImsiLcidPair_t [struct]
    module.add_class('ImsiLcidPair_t')
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress [class]
    module.add_class('Inet6SocketAddress', import_from_module='ns.network')
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress [class]
    root_module['ns3::Inet6SocketAddress'].implicitly_converts_to(root_module['ns3::Address'])
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress [class]
    module.add_class('InetSocketAddress', import_from_module='ns.network')
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress [class]
    root_module['ns3::InetSocketAddress'].implicitly_converts_to(root_module['ns3::Address'])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address [class]
    module.add_class('Ipv4Address', import_from_module='ns.network')
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address [class]
    root_module['ns3::Ipv4Address'].implicitly_converts_to(root_module['ns3::Address'])
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4AddressHelper [class]
    module.add_class('Ipv4AddressHelper', import_from_module='ns.internet')
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4InterfaceAddress [class]
    module.add_class('Ipv4InterfaceAddress', import_from_module='ns.internet')
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4InterfaceAddress::InterfaceAddressScope_e [enumeration]
    module.add_enum('InterfaceAddressScope_e', ['HOST', 'LINK', 'GLOBAL'], outer_class=root_module['ns3::Ipv4InterfaceAddress'], import_from_module='ns.internet')
    ## ipv4-interface-container.h (module 'internet'): ns3::Ipv4InterfaceContainer [class]
    module.add_class('Ipv4InterfaceContainer', import_from_module='ns.internet')
    typehandlers.add_type_alias('std::vector< std::pair< ns3::Ptr< ns3::Ipv4 >, unsigned int > > const_iterator', 'ns3::Ipv4InterfaceContainer::Iterator')
    typehandlers.add_type_alias('std::vector< std::pair< ns3::Ptr< ns3::Ipv4 >, unsigned int > > const_iterator*', 'ns3::Ipv4InterfaceContainer::Iterator*')
    typehandlers.add_type_alias('std::vector< std::pair< ns3::Ptr< ns3::Ipv4 >, unsigned int > > const_iterator&', 'ns3::Ipv4InterfaceContainer::Iterator&')
    ## ipv4-address.h (module 'network'): ns3::Ipv4Mask [class]
    module.add_class('Ipv4Mask', import_from_module='ns.network')
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address [class]
    module.add_class('Ipv6Address', import_from_module='ns.network')
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address [class]
    root_module['ns3::Ipv6Address'].implicitly_converts_to(root_module['ns3::Address'])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6AddressHelper [class]
    module.add_class('Ipv6AddressHelper', import_from_module='ns.internet')
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress [class]
    module.add_class('Ipv6InterfaceAddress', import_from_module='ns.internet')
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::State_e [enumeration]
    module.add_enum('State_e', ['TENTATIVE', 'DEPRECATED', 'PREFERRED', 'PERMANENT', 'HOMEADDRESS', 'TENTATIVE_OPTIMISTIC', 'INVALID'], outer_class=root_module['ns3::Ipv6InterfaceAddress'], import_from_module='ns.internet')
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::Scope_e [enumeration]
    module.add_enum('Scope_e', ['HOST', 'LINKLOCAL', 'GLOBAL'], outer_class=root_module['ns3::Ipv6InterfaceAddress'], import_from_module='ns.internet')
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6InterfaceContainer [class]
    module.add_class('Ipv6InterfaceContainer', import_from_module='ns.internet')
    typehandlers.add_type_alias('std::vector< std::pair< ns3::Ptr< ns3::Ipv6 >, unsigned int > > const_iterator', 'ns3::Ipv6InterfaceContainer::Iterator')
    typehandlers.add_type_alias('std::vector< std::pair< ns3::Ptr< ns3::Ipv6 >, unsigned int > > const_iterator*', 'ns3::Ipv6InterfaceContainer::Iterator*')
    typehandlers.add_type_alias('std::vector< std::pair< ns3::Ptr< ns3::Ipv6 >, unsigned int > > const_iterator&', 'ns3::Ipv6InterfaceContainer::Iterator&')
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix [class]
    module.add_class('Ipv6Prefix', import_from_module='ns.network')
    ## log.h (module 'core'): ns3::LogComponent [class]
    module.add_class('LogComponent', import_from_module='ns.core')
    typehandlers.add_type_alias('std::map< std::string, ns3::LogComponent * >', 'ns3::LogComponent::ComponentList')
    typehandlers.add_type_alias('std::map< std::string, ns3::LogComponent * >*', 'ns3::LogComponent::ComponentList*')
    typehandlers.add_type_alias('std::map< std::string, ns3::LogComponent * >&', 'ns3::LogComponent::ComponentList&')
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s [struct]
    module.add_class('LogicalChannelConfigListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::Direction_e [enumeration]
    module.add_enum('Direction_e', ['DIR_UL', 'DIR_DL', 'DIR_BOTH'], outer_class=root_module['ns3::LogicalChannelConfigListElement_s'])
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::QosBearerType_e [enumeration]
    module.add_enum('QosBearerType_e', ['QBT_NON_GBR', 'QBT_GBR'], outer_class=root_module['ns3::LogicalChannelConfigListElement_s'])
    ## lte-anr-sap.h (module 'lte'): ns3::LteAnrSapProvider [class]
    module.add_class('LteAnrSapProvider', allow_subclassing=True)
    ## lte-anr-sap.h (module 'lte'): ns3::LteAnrSapUser [class]
    module.add_class('LteAnrSapUser', allow_subclassing=True)
    ## lte-as-sap.h (module 'lte'): ns3::LteAsSapProvider [class]
    module.add_class('LteAsSapProvider', allow_subclassing=True)
    ## lte-as-sap.h (module 'lte'): ns3::LteAsSapUser [class]
    module.add_class('LteAsSapUser', allow_subclassing=True)
    ## lte-ccm-mac-sap.h (module 'lte'): ns3::LteCcmMacSapProvider [class]
    module.add_class('LteCcmMacSapProvider', allow_subclassing=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider [class]
    module.add_class('LteCcmRrcSapProvider', allow_subclassing=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LcsConfig [struct]
    module.add_class('LcsConfig', outer_class=root_module['ns3::LteCcmRrcSapProvider'])
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapUser [class]
    module.add_class('LteCcmRrcSapUser', allow_subclassing=True)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider [class]
    module.add_class('LteEnbCmacSapProvider', allow_subclassing=True)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue [struct]
    module.add_class('AllocateNcRaPreambleReturnValue', outer_class=root_module['ns3::LteEnbCmacSapProvider'])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo [struct]
    module.add_class('LcInfo', outer_class=root_module['ns3::LteEnbCmacSapProvider'])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig [struct]
    module.add_class('RachConfig', outer_class=root_module['ns3::LteEnbCmacSapProvider'])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::UeConfig [struct]
    module.add_class('UeConfig', outer_class=root_module['ns3::LteEnbCmacSapProvider'])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser [class]
    module.add_class('LteEnbCmacSapUser', allow_subclassing=True)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::UeConfig [struct]
    module.add_class('UeConfig', outer_class=root_module['ns3::LteEnbCmacSapUser'])
    ## lte-enb-cphy-sap.h (module 'lte'): ns3::LteEnbCphySapProvider [class]
    module.add_class('LteEnbCphySapProvider', allow_subclassing=True)
    ## lte-enb-cphy-sap.h (module 'lte'): ns3::LteEnbCphySapUser [class]
    module.add_class('LteEnbCphySapUser')
    ## lte-enb-phy-sap.h (module 'lte'): ns3::LteEnbPhySapProvider [class]
    module.add_class('LteEnbPhySapProvider', allow_subclassing=True)
    ## lte-enb-phy-sap.h (module 'lte'): ns3::LteEnbPhySapUser [class]
    module.add_class('LteEnbPhySapUser', allow_subclassing=True)
    ## lte-common.h (module 'lte'): ns3::LteFfConverter [class]
    module.add_class('LteFfConverter')
    ## lte-ffr-rrc-sap.h (module 'lte'): ns3::LteFfrRrcSapProvider [class]
    module.add_class('LteFfrRrcSapProvider', allow_subclassing=True)
    ## lte-ffr-rrc-sap.h (module 'lte'): ns3::LteFfrRrcSapUser [class]
    module.add_class('LteFfrRrcSapUser', allow_subclassing=True)
    ## lte-ffr-sap.h (module 'lte'): ns3::LteFfrSapProvider [class]
    module.add_class('LteFfrSapProvider', allow_subclassing=True)
    ## lte-ffr-sap.h (module 'lte'): ns3::LteFfrSapUser [class]
    module.add_class('LteFfrSapUser')
    ## lte-common.h (module 'lte'): ns3::LteFlowId_t [struct]
    module.add_class('LteFlowId_t')
    ## lte-global-pathloss-database.h (module 'lte'): ns3::LteGlobalPathlossDatabase [class]
    module.add_class('LteGlobalPathlossDatabase', allow_subclassing=True)
    ## lte-handover-management-sap.h (module 'lte'): ns3::LteHandoverManagementSapProvider [class]
    module.add_class('LteHandoverManagementSapProvider', allow_subclassing=True)
    ## lte-handover-management-sap.h (module 'lte'): ns3::LteHandoverManagementSapUser [class]
    module.add_class('LteHandoverManagementSapUser', allow_subclassing=True)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider [class]
    module.add_class('LteMacSapProvider', allow_subclassing=True)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters [struct]
    module.add_class('ReportBufferStatusParameters', outer_class=root_module['ns3::LteMacSapProvider'])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters [struct]
    module.add_class('TransmitPduParameters', outer_class=root_module['ns3::LteMacSapProvider'])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser [class]
    module.add_class('LteMacSapUser', allow_subclassing=True)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters [struct]
    module.add_class('ReceivePduParameters', outer_class=root_module['ns3::LteMacSapUser'])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters [struct]
    module.add_class('TxOpportunityParameters', outer_class=root_module['ns3::LteMacSapUser'])
    ## lte-mi-error-model.h (module 'lte'): ns3::LteMiErrorModel [class]
    module.add_class('LteMiErrorModel')
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider [class]
    module.add_class('LtePdcpSapProvider', allow_subclassing=True)
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::TransmitPdcpSduParameters [struct]
    module.add_class('TransmitPdcpSduParameters', outer_class=root_module['ns3::LtePdcpSapProvider'])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser [class]
    module.add_class('LtePdcpSapUser', allow_subclassing=True)
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::ReceivePdcpSduParameters [struct]
    module.add_class('ReceivePdcpSduParameters', outer_class=root_module['ns3::LtePdcpSapUser'])
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider [class]
    module.add_class('LteRlcSapProvider', allow_subclassing=True)
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::TransmitPdcpPduParameters [struct]
    module.add_class('TransmitPdcpPduParameters', outer_class=root_module['ns3::LteRlcSapProvider'])
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapUser [class]
    module.add_class('LteRlcSapUser', allow_subclassing=True)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap [class]
    module.add_class('LteRrcSap')
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReestablishmentCause [enumeration]
    module.add_enum('ReestablishmentCause', ['RECONFIGURATION_FAILURE', 'HANDOVER_FAILURE', 'OTHER_FAILURE'], outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoCommon [struct]
    module.add_class('AntennaInfoCommon', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoDedicated [struct]
    module.add_class('AntennaInfoDedicated', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoUl [struct]
    module.add_class('AntennaInfoUl', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig [struct]
    module.add_class('AsConfig', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::BlackCellsToAddMod [struct]
    module.add_class('BlackCellsToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierBandwidthEutra [struct]
    module.add_class('CarrierBandwidthEutra', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierFreqEutra [struct]
    module.add_class('CarrierFreqEutra', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo [struct]
    module.add_class('CellAccessRelatedInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellIdentification [struct]
    module.add_class('CellIdentification', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellSelectionInfo [struct]
    module.add_class('CellSelectionInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellsToAddMod [struct]
    module.add_class('CellsToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo [struct]
    module.add_class('CgiInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod [struct]
    module.add_class('DrbToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::FreqInfo [struct]
    module.add_class('FreqInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::HandoverPreparationInfo [struct]
    module.add_class('HandoverPreparationInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig [struct]
    module.add_class('LogicalChannelConfig', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MasterInformationBlock [struct]
    module.add_class('MasterInformationBlock', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig [struct]
    module.add_class('MeasConfig', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig [struct]
    module.add_class('MeasGapConfig', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::action [enumeration]
    module.add_enum('action', ['SETUP', 'RESET'], outer_class=root_module['ns3::LteRrcSap::MeasGapConfig'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::gap [enumeration]
    module.add_enum('gap', ['GP0', 'GP1'], outer_class=root_module['ns3::LteRrcSap::MeasGapConfig'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasIdToAddMod [struct]
    module.add_class('MeasIdToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra [struct]
    module.add_class('MeasObjectEutra', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectToAddMod [struct]
    module.add_class('MeasObjectToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell [struct]
    module.add_class('MeasResultBestNeighCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra [struct]
    module.add_class('MeasResultEutra', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell [struct]
    module.add_class('MeasResultScell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList [struct]
    module.add_class('MeasResultServFreqList', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults [struct]
    module.add_class('MeasResults', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasurementReport [struct]
    module.add_class('MeasurementReport', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo [struct]
    module.add_class('MobilityControlInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters [struct]
    module.add_class('MobilityStateParameters', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonCriticalExtensionConfiguration [struct]
    module.add_class('NonCriticalExtensionConfiguration', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonUlConfiguration [struct]
    module.add_class('NonUlConfiguration', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigCommon [struct]
    module.add_class('PdschConfigCommon', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigDedicated [struct]
    module.add_class('PdschConfigDedicated', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigDedicated::db [enumeration]
    module.add_enum('db', ['dB_6', 'dB_4dot77', 'dB_3', 'dB_1dot77', 'dB0', 'dB1', 'dB2', 'dB3'], outer_class=root_module['ns3::LteRrcSap::PdschConfigDedicated'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysCellIdRange [struct]
    module.add_class('PhysCellIdRange', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated [struct]
    module.add_class('PhysicalConfigDedicated', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell [struct]
    module.add_class('PhysicalConfigDedicatedSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PlmnIdentityInfo [struct]
    module.add_class('PlmnIdentityInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PrachConfigSCell [struct]
    module.add_class('PrachConfigSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PreambleInfo [struct]
    module.add_class('PreambleInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PuschConfigDedicatedSCell [struct]
    module.add_class('PuschConfigDedicatedSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::QuantityConfig [struct]
    module.add_class('QuantityConfig', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RaSupervisionInfo [struct]
    module.add_class('RaSupervisionInfo', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigCommon [struct]
    module.add_class('RachConfigCommon', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigDedicated [struct]
    module.add_class('RachConfigDedicated', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommon [struct]
    module.add_class('RadioResourceConfigCommon', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell [struct]
    module.add_class('RadioResourceConfigCommonSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSib [struct]
    module.add_class('RadioResourceConfigCommonSib', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated [struct]
    module.add_class('RadioResourceConfigDedicated', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicatedSCell [struct]
    module.add_class('RadioResourceConfigDedicatedSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReestabUeIdentity [struct]
    module.add_class('ReestabUeIdentity', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra [struct]
    module.add_class('ReportConfigEutra', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra [enumeration]
    module.add_enum('', ['EVENT', 'PERIODICAL'], outer_class=root_module['ns3::LteRrcSap::ReportConfigEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra [enumeration]
    module.add_enum('', ['EVENT_A1', 'EVENT_A2', 'EVENT_A3', 'EVENT_A4', 'EVENT_A5'], outer_class=root_module['ns3::LteRrcSap::ReportConfigEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::report [enumeration]
    module.add_enum('report', ['REPORT_STRONGEST_CELLS', 'REPORT_CGI'], outer_class=root_module['ns3::LteRrcSap::ReportConfigEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra [enumeration]
    module.add_enum('', ['RSRP', 'RSRQ'], outer_class=root_module['ns3::LteRrcSap::ReportConfigEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra [enumeration]
    module.add_enum('', ['SAME_AS_TRIGGER_QUANTITY', 'BOTH'], outer_class=root_module['ns3::LteRrcSap::ReportConfigEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra [enumeration]
    module.add_enum('', ['MS120', 'MS240', 'MS480', 'MS640', 'MS1024', 'MS2048', 'MS5120', 'MS10240', 'MIN1', 'MIN6', 'MIN12', 'MIN30', 'MIN60', 'SPARE3', 'SPARE2', 'SPARE1'], outer_class=root_module['ns3::LteRrcSap::ReportConfigEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigToAddMod [struct]
    module.add_class('ReportConfigToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RlcConfig [struct]
    module.add_class('RlcConfig', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RlcConfig::direction [enumeration]
    module.add_enum('direction', ['AM', 'UM_BI_DIRECTIONAL', 'UM_UNI_DIRECTIONAL_UL', 'UM_UNI_DIRECTIONAL_DL'], outer_class=root_module['ns3::LteRrcSap::RlcConfig'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration [struct]
    module.add_class('RrcConnectionReconfiguration', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfigurationCompleted [struct]
    module.add_class('RrcConnectionReconfigurationCompleted', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishment [struct]
    module.add_class('RrcConnectionReestablishment', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentComplete [struct]
    module.add_class('RrcConnectionReestablishmentComplete', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentReject [struct]
    module.add_class('RrcConnectionReestablishmentReject', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentRequest [struct]
    module.add_class('RrcConnectionReestablishmentRequest', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReject [struct]
    module.add_class('RrcConnectionReject', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRelease [struct]
    module.add_class('RrcConnectionRelease', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRequest [struct]
    module.add_class('RrcConnectionRequest', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetup [struct]
    module.add_class('RrcConnectionSetup', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetupCompleted [struct]
    module.add_class('RrcConnectionSetupCompleted', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod [struct]
    module.add_class('SCellToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon [struct]
    module.add_class('SoundingRsUlConfigCommon', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon::action [enumeration]
    module.add_enum('action', ['SETUP', 'RESET'], outer_class=root_module['ns3::LteRrcSap::SoundingRsUlConfigCommon'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated [struct]
    module.add_class('SoundingRsUlConfigDedicated', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated::action [enumeration]
    module.add_enum('action', ['SETUP', 'RESET'], outer_class=root_module['ns3::LteRrcSap::SoundingRsUlConfigDedicated'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars [struct]
    module.add_class('SpeedStatePars', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars::action [enumeration]
    module.add_enum('action', ['SETUP', 'RESET'], outer_class=root_module['ns3::LteRrcSap::SpeedStatePars'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStateScaleFactors [struct]
    module.add_class('SpeedStateScaleFactors', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SrbToAddMod [struct]
    module.add_class('SrbToAddMod', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformation [struct]
    module.add_class('SystemInformation', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType1 [struct]
    module.add_class('SystemInformationBlockType1', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType2 [struct]
    module.add_class('SystemInformationBlockType2', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ThresholdEutra [struct]
    module.add_class('ThresholdEutra', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ThresholdEutra [enumeration]
    module.add_enum('', ['THRESHOLD_RSRP', 'THRESHOLD_RSRQ'], outer_class=root_module['ns3::LteRrcSap::ThresholdEutra'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::TxFailParam [struct]
    module.add_class('TxFailParam', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration [struct]
    module.add_class('UlConfiguration', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlCommonSCell [struct]
    module.add_class('UlPowerControlCommonSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlDedicatedSCell [struct]
    module.add_class('UlPowerControlDedicatedSCell', outer_class=root_module['ns3::LteRrcSap'])
    ## lte-chunk-processor.h (module 'lte'): ns3::LteSpectrumValueCatcher [class]
    module.add_class('LteSpectrumValueCatcher')
    ## lte-spectrum-value-helper.h (module 'lte'): ns3::LteSpectrumValueHelper [class]
    module.add_class('LteSpectrumValueHelper')
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider [class]
    module.add_class('LteUeCcmRrcSapProvider', allow_subclassing=True)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LcsConfig [struct]
    module.add_class('LcsConfig', outer_class=root_module['ns3::LteUeCcmRrcSapProvider'])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapUser [class]
    module.add_class('LteUeCcmRrcSapUser', allow_subclassing=True)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider [class]
    module.add_class('LteUeCmacSapProvider', allow_subclassing=True)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig [struct]
    module.add_class('LogicalChannelConfig', outer_class=root_module['ns3::LteUeCmacSapProvider'])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig [struct]
    module.add_class('RachConfig', outer_class=root_module['ns3::LteUeCmacSapProvider'])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapUser [class]
    module.add_class('LteUeCmacSapUser', allow_subclassing=True)
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t [struct]
    module.add_class('LteUeConfig_t')
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapProvider [class]
    module.add_class('LteUeCphySapProvider', allow_subclassing=True)
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser [class]
    module.add_class('LteUeCphySapUser', allow_subclassing=True)
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsElement [struct]
    module.add_class('UeMeasurementsElement', outer_class=root_module['ns3::LteUeCphySapUser'])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsParameters [struct]
    module.add_class('UeMeasurementsParameters', outer_class=root_module['ns3::LteUeCphySapUser'])
    ## lte-ue-phy-sap.h (module 'lte'): ns3::LteUePhySapProvider [class]
    module.add_class('LteUePhySapProvider', allow_subclassing=True)
    ## lte-ue-phy-sap.h (module 'lte'): ns3::LteUePhySapUser [class]
    module.add_class('LteUePhySapUser', allow_subclassing=True)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider [class]
    module.add_class('LteUeRrcSapProvider', parent=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::CompleteSetupParameters [struct]
    module.add_class('CompleteSetupParameters', outer_class=root_module['ns3::LteUeRrcSapProvider'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser [class]
    module.add_class('LteUeRrcSapUser', parent=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::SetupParameters [struct]
    module.add_class('SetupParameters', outer_class=root_module['ns3::LteUeRrcSapUser'])
    ## mac48-address.h (module 'network'): ns3::Mac48Address [class]
    module.add_class('Mac48Address', import_from_module='ns.network')
    typehandlers.add_type_alias('void ( * ) ( ns3::Mac48Address )', 'ns3::Mac48Address::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Mac48Address )*', 'ns3::Mac48Address::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Mac48Address )&', 'ns3::Mac48Address::TracedCallback&')
    ## mac48-address.h (module 'network'): ns3::Mac48Address [class]
    root_module['ns3::Mac48Address'].implicitly_converts_to(root_module['ns3::Address'])
    ## mac64-address.h (module 'network'): ns3::Mac64Address [class]
    module.add_class('Mac64Address', import_from_module='ns.network')
    ## mac64-address.h (module 'network'): ns3::Mac64Address [class]
    root_module['ns3::Mac64Address'].implicitly_converts_to(root_module['ns3::Address'])
    ## mac8-address.h (module 'network'): ns3::Mac8Address [class]
    module.add_class('Mac8Address', import_from_module='ns.network')
    ## mac8-address.h (module 'network'): ns3::Mac8Address [class]
    root_module['ns3::Mac8Address'].implicitly_converts_to(root_module['ns3::Address'])
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s [struct]
    module.add_class('MacCeListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s::MacCeType_e [enumeration]
    module.add_enum('MacCeType_e', ['BSR', 'PHR', 'CRNTI'], outer_class=root_module['ns3::MacCeListElement_s'])
    ## ff-mac-common.h (module 'lte'): ns3::MacCeValue_u [struct]
    module.add_class('MacCeValue_u')
    ## names.h (module 'core'): ns3::Names [class]
    module.add_class('Names', import_from_module='ns.core')
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer [class]
    module.add_class('NetDeviceContainer', import_from_module='ns.network')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::NetDevice > > const_iterator', 'ns3::NetDeviceContainer::Iterator')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::NetDevice > > const_iterator*', 'ns3::NetDeviceContainer::Iterator*')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::NetDevice > > const_iterator&', 'ns3::NetDeviceContainer::Iterator&')
    ## node-container.h (module 'network'): ns3::NodeContainer [class]
    module.add_class('NodeContainer', import_from_module='ns.network')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::Node > > const_iterator', 'ns3::NodeContainer::Iterator')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::Node > > const_iterator*', 'ns3::NodeContainer::Iterator*')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::Node > > const_iterator&', 'ns3::NodeContainer::Iterator&')
    ## object-base.h (module 'core'): ns3::ObjectBase [class]
    module.add_class('ObjectBase', import_from_module='ns.core', allow_subclassing=True)
    ## object.h (module 'core'): ns3::ObjectDeleter [struct]
    module.add_class('ObjectDeleter', import_from_module='ns.core')
    ## object-factory.h (module 'core'): ns3::ObjectFactory [class]
    module.add_class('ObjectFactory', import_from_module='ns.core')
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata [class]
    module.add_class('PacketMetadata', import_from_module='ns.network')
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item [struct]
    module.add_class('Item', import_from_module='ns.network', outer_class=root_module['ns3::PacketMetadata'])
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::ItemType [enumeration]
    module.add_enum('ItemType', ['PAYLOAD', 'HEADER', 'TRAILER'], outer_class=root_module['ns3::PacketMetadata::Item'], import_from_module='ns.network')
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::ItemIterator [class]
    module.add_class('ItemIterator', import_from_module='ns.network', outer_class=root_module['ns3::PacketMetadata'])
    ## packet.h (module 'network'): ns3::PacketTagIterator [class]
    module.add_class('PacketTagIterator', import_from_module='ns.network')
    ## packet.h (module 'network'): ns3::PacketTagIterator::Item [class]
    module.add_class('Item', import_from_module='ns.network', outer_class=root_module['ns3::PacketTagIterator'])
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList [class]
    module.add_class('PacketTagList', import_from_module='ns.network')
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData [struct]
    module.add_class('TagData', import_from_module='ns.network', outer_class=root_module['ns3::PacketTagList'])
    ## ff-mac-common.h (module 'lte'): ns3::PagingInfoListElement_s [struct]
    module.add_class('PagingInfoListElement_s')
    ## log.h (module 'core'): ns3::ParameterLogger [class]
    module.add_class('ParameterLogger', import_from_module='ns.core')
    ## ff-mac-common.h (module 'lte'): ns3::PhichListElement_s [struct]
    module.add_class('PhichListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::PhichListElement_s::Phich_e [enumeration]
    module.add_enum('Phich_e', ['ACK', 'NACK'], outer_class=root_module['ns3::PhichListElement_s'])
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters [struct]
    module.add_class('PhyReceptionStatParameters')
    typehandlers.add_type_alias('void ( * ) ( ns3::PhyReceptionStatParameters const )', 'ns3::PhyReceptionStatParameters::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::PhyReceptionStatParameters const )*', 'ns3::PhyReceptionStatParameters::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::PhyReceptionStatParameters const )&', 'ns3::PhyReceptionStatParameters::TracedCallback&')
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters [struct]
    module.add_class('PhyTransmissionStatParameters')
    typehandlers.add_type_alias('void ( * ) ( ns3::PhyTransmissionStatParameters const )', 'ns3::PhyTransmissionStatParameters::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::PhyTransmissionStatParameters const )*', 'ns3::PhyTransmissionStatParameters::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::PhyTransmissionStatParameters const )&', 'ns3::PhyTransmissionStatParameters::TracedCallback&')
    ## ff-mac-common.h (module 'lte'): ns3::RachListElement_s [struct]
    module.add_class('RachListElement_s')
    ## radio-bearer-stats-connector.h (module 'lte'): ns3::RadioBearerStatsConnector [class]
    module.add_class('RadioBearerStatsConnector')
    ## lte-rrc-protocol-real.h (module 'lte'): ns3::RealProtocolRlcSapUser [class]
    module.add_class('RealProtocolRlcSapUser', parent=root_module['ns3::LteRlcSapUser'])
    ## ff-mac-common.h (module 'lte'): ns3::RlcPduListElement_s [struct]
    module.add_class('RlcPduListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::SbMeasResult_s [struct]
    module.add_class('SbMeasResult_s')
    ## lte-rlc-sequence-number.h (module 'lte'): ns3::SequenceNumber10 [class]
    module.add_class('SequenceNumber10')
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s [struct]
    module.add_class('SiConfiguration_s')
    ## ff-mac-common.h (module 'lte'): ns3::SiMessageListElement_s [struct]
    module.add_class('SiMessageListElement_s')
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter> [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::ObjectBase'], template_parameters=['ns3::Object', 'ns3::ObjectBase', 'ns3::ObjectDeleter'])
    ## simulator.h (module 'core'): ns3::Simulator [class]
    module.add_class('Simulator', import_from_module='ns.core', destructor_visibility='private')
    ## simulator.h (module 'core'): ns3::Simulator [enumeration]
    module.add_enum('', ['NO_CONTEXT'], outer_class=root_module['ns3::Simulator'], import_from_module='ns.core')
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s [struct]
    module.add_class('SpsConfig_s')
    ## ff-mac-common.h (module 'lte'): ns3::SrConfig_s [struct]
    module.add_class('SrConfig_s')
    ## ff-mac-common.h (module 'lte'): ns3::SrListElement_s [struct]
    module.add_class('SrListElement_s')
    ## data-calculator.h (module 'stats'): ns3::StatisticalSummary [class]
    module.add_class('StatisticalSummary', import_from_module='ns.stats', allow_subclassing=True)
    ## tag.h (module 'network'): ns3::Tag [class]
    module.add_class('Tag', import_from_module='ns.network', parent=root_module['ns3::ObjectBase'])
    ## tag-buffer.h (module 'network'): ns3::TagBuffer [class]
    module.add_class('TagBuffer', import_from_module='ns.network')
    ## lte-spectrum-phy.h (module 'lte'): ns3::TbId_t [struct]
    module.add_class('TbId_t')
    ## lte-mi-error-model.h (module 'lte'): ns3::TbStats_t [struct]
    module.add_class('TbStats_t')
    ## nstime.h (module 'core'): ns3::TimeWithUnit [class]
    module.add_class('TimeWithUnit', import_from_module='ns.core')
    ## lte-common.h (module 'lte'): ns3::TransmissionModesLayers [class]
    module.add_class('TransmissionModesLayers')
    ## type-id.h (module 'core'): ns3::TypeId [class]
    module.add_class('TypeId', import_from_module='ns.core')
    ## type-id.h (module 'core'): ns3::TypeId::AttributeFlag [enumeration]
    module.add_enum('AttributeFlag', ['ATTR_GET', 'ATTR_SET', 'ATTR_CONSTRUCT', 'ATTR_SGC'], outer_class=root_module['ns3::TypeId'], import_from_module='ns.core')
    ## type-id.h (module 'core'): ns3::TypeId::SupportLevel [enumeration]
    module.add_enum('SupportLevel', ['SUPPORTED', 'DEPRECATED', 'OBSOLETE'], outer_class=root_module['ns3::TypeId'], import_from_module='ns.core')
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation [struct]
    module.add_class('AttributeInformation', import_from_module='ns.core', outer_class=root_module['ns3::TypeId'])
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation [struct]
    module.add_class('TraceSourceInformation', import_from_module='ns.core', outer_class=root_module['ns3::TypeId'])
    typehandlers.add_type_alias('uint32_t', 'ns3::TypeId::hash_t')
    typehandlers.add_type_alias('uint32_t*', 'ns3::TypeId::hash_t*')
    typehandlers.add_type_alias('uint32_t&', 'ns3::TypeId::hash_t&')
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s [struct]
    module.add_class('UeCapabilities_s')
    ## ff-mac-common.h (module 'lte'): ns3::UeSelected_s [struct]
    module.add_class('UeSelected_s')
    ## ff-mac-common.h (module 'lte'): ns3::UlCqi_s [struct]
    module.add_class('UlCqi_s')
    ## ff-mac-common.h (module 'lte'): ns3::UlCqi_s::Type_e [enumeration]
    module.add_enum('Type_e', ['SRS', 'PUSCH', 'PUCCH_1', 'PUCCH_2', 'PRACH'], outer_class=root_module['ns3::UlCqi_s'])
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s [struct]
    module.add_class('UlDciListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s [struct]
    module.add_class('UlGrant_s')
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s [struct]
    module.add_class('UlInfoListElement_s')
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::ReceptionStatus_e [enumeration]
    module.add_enum('ReceptionStatus_e', ['Ok', 'NotOk', 'NotValid'], outer_class=root_module['ns3::UlInfoListElement_s'])
    ## lte-global-pathloss-database.h (module 'lte'): ns3::UplinkLteGlobalPathlossDatabase [class]
    module.add_class('UplinkLteGlobalPathlossDatabase', parent=root_module['ns3::LteGlobalPathlossDatabase'])
    ## vector.h (module 'core'): ns3::Vector2D [class]
    module.add_class('Vector2D', import_from_module='ns.core')
    ## vector.h (module 'core'): ns3::Vector3D [class]
    module.add_class('Vector3D', import_from_module='ns.core')
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificListElement_s [struct]
    module.add_class('VendorSpecificListElement_s')
    ## empty.h (module 'core'): ns3::empty [class]
    module.add_class('empty', import_from_module='ns.core')
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t [struct]
    module.add_class('fdbetsFlowPerf_t')
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t [struct]
    module.add_class('fdtbfqsFlowPerf_t')
    ## int64x64-128.h (module 'core'): ns3::int64x64_t [class]
    module.add_class('int64x64_t', import_from_module='ns.core')
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::impl_type [enumeration]
    module.add_enum('impl_type', ['int128_impl', 'cairo_impl', 'ld_impl'], outer_class=root_module['ns3::int64x64_t'], import_from_module='ns.core')
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t [struct]
    module.add_class('pfsFlowPerf_t')
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t [struct]
    module.add_class('pssFlowPerf_t')
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t [struct]
    module.add_class('tbInfo_t')
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t [struct]
    module.add_class('tdbetsFlowPerf_t')
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t [struct]
    module.add_class('tdtbfqsFlowPerf_t')
    ## chunk.h (module 'network'): ns3::Chunk [class]
    module.add_class('Chunk', import_from_module='ns.network', parent=root_module['ns3::ObjectBase'])
    ## lte-global-pathloss-database.h (module 'lte'): ns3::DownlinkLteGlobalPathlossDatabase [class]
    module.add_class('DownlinkLteGlobalPathlossDatabase', parent=root_module['ns3::LteGlobalPathlossDatabase'])
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer [class]
    module.add_class('EpsBearer', parent=root_module['ns3::ObjectBase'])
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::Qci [enumeration]
    module.add_enum('Qci', ['GBR_CONV_VOICE', 'GBR_CONV_VIDEO', 'GBR_GAMING', 'GBR_NON_CONV_VIDEO', 'GBR_MC_PUSH_TO_TALK', 'GBR_NMC_PUSH_TO_TALK', 'GBR_MC_VIDEO', 'GBR_V2X', 'NGBR_IMS', 'NGBR_VIDEO_TCP_OPERATOR', 'NGBR_VOICE_VIDEO_GAMING', 'NGBR_VIDEO_TCP_PREMIUM', 'NGBR_VIDEO_TCP_DEFAULT', 'NGBR_MC_DELAY_SIGNAL', 'NGBR_MC_DATA', 'NGBR_V2X', 'NGBR_LOW_LAT_EMBB', 'DGBR_DISCRETE_AUT_SMALL', 'DGBR_DISCRETE_AUT_LARGE', 'DGBR_ITS', 'DGBR_ELECTRICITY'], outer_class=root_module['ns3::EpsBearer'])
    ## eps-bearer-tag.h (module 'lte'): ns3::EpsBearerTag [class]
    module.add_class('EpsBearerTag', parent=root_module['ns3::Tag'])
    ## header.h (module 'network'): ns3::Header [class]
    module.add_class('Header', import_from_module='ns.network', parent=root_module['ns3::Chunk'])
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header [class]
    module.add_class('Ipv4Header', import_from_module='ns.internet', parent=root_module['ns3::Header'])
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header::DscpType [enumeration]
    module.add_enum('DscpType', ['DscpDefault', 'DSCP_CS1', 'DSCP_AF11', 'DSCP_AF12', 'DSCP_AF13', 'DSCP_CS2', 'DSCP_AF21', 'DSCP_AF22', 'DSCP_AF23', 'DSCP_CS3', 'DSCP_AF31', 'DSCP_AF32', 'DSCP_AF33', 'DSCP_CS4', 'DSCP_AF41', 'DSCP_AF42', 'DSCP_AF43', 'DSCP_CS5', 'DSCP_EF', 'DSCP_CS6', 'DSCP_CS7'], outer_class=root_module['ns3::Ipv4Header'], import_from_module='ns.internet')
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header::EcnType [enumeration]
    module.add_enum('EcnType', ['ECN_NotECT', 'ECN_ECT1', 'ECN_ECT0', 'ECN_CE'], outer_class=root_module['ns3::Ipv4Header'], import_from_module='ns.internet')
    ## lte-ccm-mac-sap.h (module 'lte'): ns3::LteCcmMacSapUser [class]
    module.add_class('LteCcmMacSapUser', parent=root_module['ns3::LteMacSapUser'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider [class]
    module.add_class('LteEnbRrcSapProvider', parent=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters [struct]
    module.add_class('CompleteSetupUeParameters', outer_class=root_module['ns3::LteEnbRrcSapProvider'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser [class]
    module.add_class('LteEnbRrcSapUser', parent=root_module['ns3::LteRrcSap'])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::SetupUeParameters [struct]
    module.add_class('SetupUeParameters', outer_class=root_module['ns3::LteEnbRrcSapUser'])
    ## lte-pdcp-header.h (module 'lte'): ns3::LtePdcpHeader [class]
    module.add_class('LtePdcpHeader', parent=root_module['ns3::Header'])
    ## lte-pdcp-header.h (module 'lte'): ns3::LtePdcpHeader [enumeration]
    module.add_enum('', ['CONTROL_PDU', 'DATA_PDU'], outer_class=root_module['ns3::LtePdcpHeader'])
    ## lte-phy-tag.h (module 'lte'): ns3::LtePhyTag [class]
    module.add_class('LtePhyTag', parent=root_module['ns3::Tag'])
    ## lte-radio-bearer-tag.h (module 'lte'): ns3::LteRadioBearerTag [class]
    module.add_class('LteRadioBearerTag', parent=root_module['ns3::Tag'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader [class]
    module.add_class('LteRlcAmHeader', parent=root_module['ns3::Header'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::DataControlPdu_t [enumeration]
    module.add_enum('DataControlPdu_t', ['CONTROL_PDU', 'DATA_PDU'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::ControPduType_t [enumeration]
    module.add_enum('ControPduType_t', ['STATUS_PDU'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::FramingInfoFirstByte_t [enumeration]
    module.add_enum('FramingInfoFirstByte_t', ['FIRST_BYTE', 'NO_FIRST_BYTE'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::FramingInfoLastByte_t [enumeration]
    module.add_enum('FramingInfoLastByte_t', ['LAST_BYTE', 'NO_LAST_BYTE'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::ExtensionBit_t [enumeration]
    module.add_enum('ExtensionBit_t', ['DATA_FIELD_FOLLOWS', 'E_LI_FIELDS_FOLLOWS'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::ResegmentationFlag_t [enumeration]
    module.add_enum('ResegmentationFlag_t', ['PDU', 'SEGMENT'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::PollingBit_t [enumeration]
    module.add_enum('PollingBit_t', ['STATUS_REPORT_NOT_REQUESTED', 'STATUS_REPORT_IS_REQUESTED'], outer_class=root_module['ns3::LteRlcAmHeader'])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::LastSegmentFlag_t [enumeration]
    module.add_enum('LastSegmentFlag_t', ['NO_LAST_PDU_SEGMENT', 'LAST_PDU_SEGMENT'], outer_class=root_module['ns3::LteRlcAmHeader'])
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::DataControlPdu_t', 'ns3::LteRlcAmHeader::DataControlPdu_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::DataControlPdu_t*', 'ns3::LteRlcAmHeader::DataControlPdu_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::DataControlPdu_t&', 'ns3::LteRlcAmHeader::DataControlPdu_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ControPduType_t', 'ns3::LteRlcAmHeader::ControPduType_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ControPduType_t*', 'ns3::LteRlcAmHeader::ControPduType_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ControPduType_t&', 'ns3::LteRlcAmHeader::ControPduType_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::FramingInfoFirstByte_t', 'ns3::LteRlcAmHeader::FramingInfoFirstByte_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::FramingInfoFirstByte_t*', 'ns3::LteRlcAmHeader::FramingInfoFirstByte_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::FramingInfoFirstByte_t&', 'ns3::LteRlcAmHeader::FramingInfoFirstByte_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::FramingInfoLastByte_t', 'ns3::LteRlcAmHeader::FramingInfoLastByte_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::FramingInfoLastByte_t*', 'ns3::LteRlcAmHeader::FramingInfoLastByte_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::FramingInfoLastByte_t&', 'ns3::LteRlcAmHeader::FramingInfoLastByte_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ExtensionBit_t', 'ns3::LteRlcAmHeader::ExtensionBit_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ExtensionBit_t*', 'ns3::LteRlcAmHeader::ExtensionBit_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ExtensionBit_t&', 'ns3::LteRlcAmHeader::ExtensionBit_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ResegmentationFlag_t', 'ns3::LteRlcAmHeader::ResegmentationFlag_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ResegmentationFlag_t*', 'ns3::LteRlcAmHeader::ResegmentationFlag_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::ResegmentationFlag_t&', 'ns3::LteRlcAmHeader::ResegmentationFlag_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::PollingBit_t', 'ns3::LteRlcAmHeader::PollingBit_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::PollingBit_t*', 'ns3::LteRlcAmHeader::PollingBit_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::PollingBit_t&', 'ns3::LteRlcAmHeader::PollingBit_t&')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::LastSegmentFlag_t', 'ns3::LteRlcAmHeader::LastSegmentFlag_t')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::LastSegmentFlag_t*', 'ns3::LteRlcAmHeader::LastSegmentFlag_t*')
    typehandlers.add_type_alias('ns3::LteRlcAmHeader::LastSegmentFlag_t&', 'ns3::LteRlcAmHeader::LastSegmentFlag_t&')
    ## lte-rlc-header.h (module 'lte'): ns3::LteRlcHeader [class]
    module.add_class('LteRlcHeader', parent=root_module['ns3::Header'])
    ## lte-rlc-header.h (module 'lte'): ns3::LteRlcHeader::ExtensionBit_t [enumeration]
    module.add_enum('ExtensionBit_t', ['DATA_FIELD_FOLLOWS', 'E_LI_FIELDS_FOLLOWS'], outer_class=root_module['ns3::LteRlcHeader'])
    ## lte-rlc-header.h (module 'lte'): ns3::LteRlcHeader::FramingInfoFirstByte_t [enumeration]
    module.add_enum('FramingInfoFirstByte_t', ['FIRST_BYTE', 'NO_FIRST_BYTE'], outer_class=root_module['ns3::LteRlcHeader'])
    ## lte-rlc-header.h (module 'lte'): ns3::LteRlcHeader::FramingInfoLastByte_t [enumeration]
    module.add_enum('FramingInfoLastByte_t', ['LAST_BYTE', 'NO_LAST_BYTE'], outer_class=root_module['ns3::LteRlcHeader'])
    typehandlers.add_type_alias('ns3::LteRlcHeader::ExtensionBit_t', 'ns3::LteRlcHeader::ExtensionBit_t')
    typehandlers.add_type_alias('ns3::LteRlcHeader::ExtensionBit_t*', 'ns3::LteRlcHeader::ExtensionBit_t*')
    typehandlers.add_type_alias('ns3::LteRlcHeader::ExtensionBit_t&', 'ns3::LteRlcHeader::ExtensionBit_t&')
    typehandlers.add_type_alias('ns3::LteRlcHeader::FramingInfoFirstByte_t', 'ns3::LteRlcHeader::FramingInfoFirstByte_t')
    typehandlers.add_type_alias('ns3::LteRlcHeader::FramingInfoFirstByte_t*', 'ns3::LteRlcHeader::FramingInfoFirstByte_t*')
    typehandlers.add_type_alias('ns3::LteRlcHeader::FramingInfoFirstByte_t&', 'ns3::LteRlcHeader::FramingInfoFirstByte_t&')
    typehandlers.add_type_alias('ns3::LteRlcHeader::FramingInfoLastByte_t', 'ns3::LteRlcHeader::FramingInfoLastByte_t')
    typehandlers.add_type_alias('ns3::LteRlcHeader::FramingInfoLastByte_t*', 'ns3::LteRlcHeader::FramingInfoLastByte_t*')
    typehandlers.add_type_alias('ns3::LteRlcHeader::FramingInfoLastByte_t&', 'ns3::LteRlcHeader::FramingInfoLastByte_t&')
    ## lte-rlc-sdu-status-tag.h (module 'lte'): ns3::LteRlcSduStatusTag [class]
    module.add_class('LteRlcSduStatusTag', parent=root_module['ns3::Tag'])
    ## lte-rlc-sdu-status-tag.h (module 'lte'): ns3::LteRlcSduStatusTag::SduStatus_t [enumeration]
    module.add_enum('SduStatus_t', ['FULL_SDU', 'FIRST_SEGMENT', 'MIDDLE_SEGMENT', 'LAST_SEGMENT', 'ANY_SEGMENT'], outer_class=root_module['ns3::LteRlcSduStatusTag'])
    typehandlers.add_type_alias('ns3::LteRlcSduStatusTag::SduStatus_t', 'ns3::LteRlcSduStatusTag::SduStatus_t')
    typehandlers.add_type_alias('ns3::LteRlcSduStatusTag::SduStatus_t*', 'ns3::LteRlcSduStatusTag::SduStatus_t*')
    typehandlers.add_type_alias('ns3::LteRlcSduStatusTag::SduStatus_t&', 'ns3::LteRlcSduStatusTag::SduStatus_t&')
    ## object.h (module 'core'): ns3::Object [class]
    module.add_class('Object', import_from_module='ns.core', parent=root_module['ns3::SimpleRefCount< ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter >'])
    ## object.h (module 'core'): ns3::Object::AggregateIterator [class]
    module.add_class('AggregateIterator', import_from_module='ns.core', outer_class=root_module['ns3::Object'])
    ## packet-burst.h (module 'network'): ns3::PacketBurst [class]
    module.add_class('PacketBurst', import_from_module='ns.network', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::PacketBurst const > )', 'ns3::PacketBurst::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::PacketBurst const > )*', 'ns3::PacketBurst::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::PacketBurst const > )&', 'ns3::PacketBurst::TracedCallback&')
    ## lte-pdcp-tag.h (module 'lte'): ns3::PdcpTag [class]
    module.add_class('PdcpTag', parent=root_module['ns3::Tag'])
    ## propagation-delay-model.h (module 'propagation'): ns3::PropagationDelayModel [class]
    module.add_class('PropagationDelayModel', import_from_module='ns.propagation', parent=root_module['ns3::Object'])
    ## propagation-loss-model.h (module 'propagation'): ns3::PropagationLossModel [class]
    module.add_class('PropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::Object'])
    ## radio-environment-map-helper.h (module 'lte'): ns3::RadioEnvironmentMapHelper [class]
    module.add_class('RadioEnvironmentMapHelper', parent=root_module['ns3::Object'])
    ## propagation-delay-model.h (module 'propagation'): ns3::RandomPropagationDelayModel [class]
    module.add_class('RandomPropagationDelayModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationDelayModel'])
    ## propagation-loss-model.h (module 'propagation'): ns3::RandomPropagationLossModel [class]
    module.add_class('RandomPropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## random-variable-stream.h (module 'core'): ns3::RandomVariableStream [class]
    module.add_class('RandomVariableStream', import_from_module='ns.core', parent=root_module['ns3::Object'])
    ## propagation-loss-model.h (module 'propagation'): ns3::RangePropagationLossModel [class]
    module.add_class('RangePropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## lte-rlc-tag.h (module 'lte'): ns3::RlcTag [class]
    module.add_class('RlcTag', parent=root_module['ns3::Tag'])
    ## random-variable-stream.h (module 'core'): ns3::SequentialRandomVariable [class]
    module.add_class('SequentialRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter<ns3::AttributeAccessor> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::AttributeAccessor', 'ns3::empty', 'ns3::DefaultDeleter<ns3::AttributeAccessor>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter<ns3::AttributeChecker> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::AttributeChecker', 'ns3::empty', 'ns3::DefaultDeleter<ns3::AttributeChecker>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter<ns3::AttributeValue> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::AttributeValue', 'ns3::empty', 'ns3::DefaultDeleter<ns3::AttributeValue>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter<ns3::CallbackImplBase> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::CallbackImplBase', 'ns3::empty', 'ns3::DefaultDeleter<ns3::CallbackImplBase>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EpcTft, ns3::empty, ns3::DefaultDeleter<ns3::EpcTft> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::EpcTft', 'ns3::empty', 'ns3::DefaultDeleter<ns3::EpcTft>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter<ns3::EpcTftClassifier> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::EpcTftClassifier', 'ns3::empty', 'ns3::DefaultDeleter<ns3::EpcTftClassifier>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EventImpl, ns3::empty, ns3::DefaultDeleter<ns3::EventImpl> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::EventImpl', 'ns3::empty', 'ns3::DefaultDeleter<ns3::EventImpl>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter<ns3::Hash::Implementation> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::Hash::Implementation', 'ns3::empty', 'ns3::DefaultDeleter<ns3::Hash::Implementation>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4MulticastRoute> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::Ipv4MulticastRoute', 'ns3::empty', 'ns3::DefaultDeleter<ns3::Ipv4MulticastRoute>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4Route> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::Ipv4Route', 'ns3::empty', 'ns3::DefaultDeleter<ns3::Ipv4Route>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter<ns3::LteChunkProcessor> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::LteChunkProcessor', 'ns3::empty', 'ns3::DefaultDeleter<ns3::LteChunkProcessor>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter<ns3::LteControlMessage> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::LteControlMessage', 'ns3::empty', 'ns3::DefaultDeleter<ns3::LteControlMessage>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter<ns3::LteHarqPhy> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::LteHarqPhy', 'ns3::empty', 'ns3::DefaultDeleter<ns3::LteHarqPhy>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::NixVector, ns3::empty, ns3::DefaultDeleter<ns3::NixVector> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::NixVector', 'ns3::empty', 'ns3::DefaultDeleter<ns3::NixVector>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Packet, ns3::empty, ns3::DefaultDeleter<ns3::Packet> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::Packet', 'ns3::empty', 'ns3::DefaultDeleter<ns3::Packet>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumModel> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::SpectrumModel', 'ns3::empty', 'ns3::DefaultDeleter<ns3::SpectrumModel>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumSignalParameters> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::SpectrumSignalParameters', 'ns3::empty', 'ns3::DefaultDeleter<ns3::SpectrumSignalParameters>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumValue> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::SpectrumValue', 'ns3::empty', 'ns3::DefaultDeleter<ns3::SpectrumValue>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter<ns3::TraceSourceAccessor> > [class]
    module.add_class('SimpleRefCount', import_from_module='ns.core', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::TraceSourceAccessor', 'ns3::empty', 'ns3::DefaultDeleter<ns3::TraceSourceAccessor>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter<ns3::VendorSpecificValue> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::VendorSpecificValue', 'ns3::empty', 'ns3::DefaultDeleter<ns3::VendorSpecificValue>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2CellInfo> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::X2CellInfo', 'ns3::empty', 'ns3::DefaultDeleter<ns3::X2CellInfo>'])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2IfaceInfo> > [class]
    module.add_class('SimpleRefCount', memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'), automatic_type_narrowing=True, parent=root_module['ns3::empty'], template_parameters=['ns3::X2IfaceInfo', 'ns3::empty', 'ns3::DefaultDeleter<ns3::X2IfaceInfo>'])
    ## socket.h (module 'network'): ns3::Socket [class]
    module.add_class('Socket', import_from_module='ns.network', parent=root_module['ns3::Object'])
    ## socket.h (module 'network'): ns3::Socket::SocketErrno [enumeration]
    module.add_enum('SocketErrno', ['ERROR_NOTERROR', 'ERROR_ISCONN', 'ERROR_NOTCONN', 'ERROR_MSGSIZE', 'ERROR_AGAIN', 'ERROR_SHUTDOWN', 'ERROR_OPNOTSUPP', 'ERROR_AFNOSUPPORT', 'ERROR_INVAL', 'ERROR_BADF', 'ERROR_NOROUTETOHOST', 'ERROR_NODEV', 'ERROR_ADDRNOTAVAIL', 'ERROR_ADDRINUSE', 'SOCKET_ERRNO_LAST'], outer_class=root_module['ns3::Socket'], import_from_module='ns.network')
    ## socket.h (module 'network'): ns3::Socket::SocketType [enumeration]
    module.add_enum('SocketType', ['NS3_SOCK_STREAM', 'NS3_SOCK_SEQPACKET', 'NS3_SOCK_DGRAM', 'NS3_SOCK_RAW'], outer_class=root_module['ns3::Socket'], import_from_module='ns.network')
    ## socket.h (module 'network'): ns3::Socket::SocketPriority [enumeration]
    module.add_enum('SocketPriority', ['NS3_PRIO_BESTEFFORT', 'NS3_PRIO_FILLER', 'NS3_PRIO_BULK', 'NS3_PRIO_INTERACTIVE_BULK', 'NS3_PRIO_INTERACTIVE', 'NS3_PRIO_CONTROL'], outer_class=root_module['ns3::Socket'], import_from_module='ns.network')
    ## socket.h (module 'network'): ns3::Socket::Ipv6MulticastFilterMode [enumeration]
    module.add_enum('Ipv6MulticastFilterMode', ['INCLUDE', 'EXCLUDE'], outer_class=root_module['ns3::Socket'], import_from_module='ns.network')
    ## socket.h (module 'network'): ns3::SocketIpTosTag [class]
    module.add_class('SocketIpTosTag', import_from_module='ns.network', parent=root_module['ns3::Tag'])
    ## socket.h (module 'network'): ns3::SocketIpTtlTag [class]
    module.add_class('SocketIpTtlTag', import_from_module='ns.network', parent=root_module['ns3::Tag'])
    ## socket.h (module 'network'): ns3::SocketIpv6HopLimitTag [class]
    module.add_class('SocketIpv6HopLimitTag', import_from_module='ns.network', parent=root_module['ns3::Tag'])
    ## socket.h (module 'network'): ns3::SocketIpv6TclassTag [class]
    module.add_class('SocketIpv6TclassTag', import_from_module='ns.network', parent=root_module['ns3::Tag'])
    ## socket.h (module 'network'): ns3::SocketPriorityTag [class]
    module.add_class('SocketPriorityTag', import_from_module='ns.network', parent=root_module['ns3::Tag'])
    ## socket.h (module 'network'): ns3::SocketSetDontFragmentTag [class]
    module.add_class('SocketSetDontFragmentTag', import_from_module='ns.network', parent=root_module['ns3::Tag'])
    ## spectrum-interference.h (module 'spectrum'): ns3::SpectrumInterference [class]
    module.add_class('SpectrumInterference', import_from_module='ns.spectrum', parent=root_module['ns3::Object'])
    ## spectrum-model.h (module 'spectrum'): ns3::SpectrumModel [class]
    module.add_class('SpectrumModel', import_from_module='ns.spectrum', parent=root_module['ns3::SimpleRefCount< ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumModel> >'])
    ## spectrum-phy.h (module 'spectrum'): ns3::SpectrumPhy [class]
    module.add_class('SpectrumPhy', import_from_module='ns.spectrum', parent=root_module['ns3::Object'])
    ## spectrum-propagation-loss-model.h (module 'spectrum'): ns3::SpectrumPropagationLossModel [class]
    module.add_class('SpectrumPropagationLossModel', import_from_module='ns.spectrum', parent=root_module['ns3::Object'])
    ## spectrum-signal-parameters.h (module 'spectrum'): ns3::SpectrumSignalParameters [struct]
    module.add_class('SpectrumSignalParameters', import_from_module='ns.spectrum', parent=root_module['ns3::SimpleRefCount< ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumSignalParameters> >'])
    ## spectrum-value.h (module 'spectrum'): ns3::SpectrumValue [class]
    module.add_class('SpectrumValue', import_from_module='ns.spectrum', parent=root_module['ns3::SimpleRefCount< ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumValue> >'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumValue > )', 'ns3::SpectrumValue::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumValue > )*', 'ns3::SpectrumValue::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumValue > )&', 'ns3::SpectrumValue::TracedCallback&')
    ## propagation-loss-model.h (module 'propagation'): ns3::ThreeLogDistancePropagationLossModel [class]
    module.add_class('ThreeLogDistancePropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## nstime.h (module 'core'): ns3::Time [class]
    module.add_class('Time', import_from_module='ns.core')
    ## nstime.h (module 'core'): ns3::Time::Unit [enumeration]
    module.add_enum('Unit', ['Y', 'D', 'H', 'MIN', 'S', 'MS', 'US', 'NS', 'PS', 'FS', 'LAST'], outer_class=root_module['ns3::Time'], import_from_module='ns.core')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time )', 'ns3::Time::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time )*', 'ns3::Time::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time )&', 'ns3::Time::TracedCallback&')
    ## nstime.h (module 'core'): ns3::Time [class]
    root_module['ns3::Time'].implicitly_converts_to(root_module['ns3::int64x64_t'])
    ## trace-source-accessor.h (module 'core'): ns3::TraceSourceAccessor [class]
    module.add_class('TraceSourceAccessor', import_from_module='ns.core', parent=root_module['ns3::SimpleRefCount< ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter<ns3::TraceSourceAccessor> >'])
    ## trailer.h (module 'network'): ns3::Trailer [class]
    module.add_class('Trailer', import_from_module='ns.network', parent=root_module['ns3::Chunk'])
    ## random-variable-stream.h (module 'core'): ns3::TriangularRandomVariable [class]
    module.add_class('TriangularRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## propagation-loss-model.h (module 'propagation'): ns3::TwoRayGroundPropagationLossModel [class]
    module.add_class('TwoRayGroundPropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## lte-enb-rrc.h (module 'lte'): ns3::UeManager [class]
    module.add_class('UeManager', parent=root_module['ns3::Object'])
    ## lte-enb-rrc.h (module 'lte'): ns3::UeManager::State [enumeration]
    module.add_enum('State', ['INITIAL_RANDOM_ACCESS', 'CONNECTION_SETUP', 'CONNECTION_REJECTED', 'ATTACH_REQUEST', 'CONNECTED_NORMALLY', 'CONNECTION_RECONFIGURATION', 'CONNECTION_REESTABLISHMENT', 'HANDOVER_PREPARATION', 'HANDOVER_JOINING', 'HANDOVER_PATH_SWITCH', 'HANDOVER_LEAVING', 'NUM_STATES'], outer_class=root_module['ns3::UeManager'])
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, ns3::UeManager::State const, ns3::UeManager::State const )', 'ns3::UeManager::StateTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, ns3::UeManager::State const, ns3::UeManager::State const )*', 'ns3::UeManager::StateTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, ns3::UeManager::State const, ns3::UeManager::State const )&', 'ns3::UeManager::StateTracedCallback&')
    ## random-variable-stream.h (module 'core'): ns3::UniformRandomVariable [class]
    module.add_class('UniformRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificValue [struct]
    module.add_class('VendorSpecificValue', parent=root_module['ns3::SimpleRefCount< ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter<ns3::VendorSpecificValue> >'])
    ## random-variable-stream.h (module 'core'): ns3::WeibullRandomVariable [class]
    module.add_class('WeibullRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## epc-x2.h (module 'lte'): ns3::X2CellInfo [class]
    module.add_class('X2CellInfo', parent=root_module['ns3::SimpleRefCount< ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2CellInfo> >'])
    ## epc-x2.h (module 'lte'): ns3::X2IfaceInfo [class]
    module.add_class('X2IfaceInfo', parent=root_module['ns3::SimpleRefCount< ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2IfaceInfo> >'])
    ## random-variable-stream.h (module 'core'): ns3::ZetaRandomVariable [class]
    module.add_class('ZetaRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## random-variable-stream.h (module 'core'): ns3::ZipfRandomVariable [class]
    module.add_class('ZipfRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## application.h (module 'network'): ns3::Application [class]
    module.add_class('Application', import_from_module='ns.network', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Time const &, ns3::Address const & )', 'ns3::Application::DelayAddressCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time const &, ns3::Address const & )*', 'ns3::Application::DelayAddressCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time const &, ns3::Address const & )&', 'ns3::Application::DelayAddressCallback&')
    typehandlers.add_type_alias('void ( * ) ( std::string const &, std::string const & )', 'ns3::Application::StateTransitionCallback')
    typehandlers.add_type_alias('void ( * ) ( std::string const &, std::string const & )*', 'ns3::Application::StateTransitionCallback*')
    typehandlers.add_type_alias('void ( * ) ( std::string const &, std::string const & )&', 'ns3::Application::StateTransitionCallback&')
    ## lte-asn1-header.h (module 'lte'): ns3::Asn1Header [class]
    module.add_class('Asn1Header', parent=root_module['ns3::Header'])
    ## attribute.h (module 'core'): ns3::AttributeAccessor [class]
    module.add_class('AttributeAccessor', import_from_module='ns.core', parent=root_module['ns3::SimpleRefCount< ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter<ns3::AttributeAccessor> >'])
    ## attribute.h (module 'core'): ns3::AttributeChecker [class]
    module.add_class('AttributeChecker', import_from_module='ns.core', automatic_type_narrowing=True, allow_subclassing=False, parent=root_module['ns3::SimpleRefCount< ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter<ns3::AttributeChecker> >'])
    ## attribute.h (module 'core'): ns3::AttributeValue [class]
    module.add_class('AttributeValue', import_from_module='ns.core', automatic_type_narrowing=True, allow_subclassing=False, parent=root_module['ns3::SimpleRefCount< ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter<ns3::AttributeValue> >'])
    ## boolean.h (module 'core'): ns3::BooleanChecker [class]
    module.add_class('BooleanChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## boolean.h (module 'core'): ns3::BooleanValue [class]
    module.add_class('BooleanValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## callback.h (module 'core'): ns3::CallbackChecker [class]
    module.add_class('CallbackChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## callback.h (module 'core'): ns3::CallbackImplBase [class]
    module.add_class('CallbackImplBase', import_from_module='ns.core', parent=root_module['ns3::SimpleRefCount< ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter<ns3::CallbackImplBase> >'])
    ## callback.h (module 'core'): ns3::CallbackValue [class]
    module.add_class('CallbackValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## cc-helper.h (module 'lte'): ns3::CcHelper [class]
    module.add_class('CcHelper', parent=root_module['ns3::Object'])
    ## channel.h (module 'network'): ns3::Channel [class]
    module.add_class('Channel', import_from_module='ns.network', parent=root_module['ns3::Object'])
    ## component-carrier.h (module 'lte'): ns3::ComponentCarrier [class]
    module.add_class('ComponentCarrier', parent=root_module['ns3::Object'])
    ## component-carrier.h (module 'lte'): ns3::ComponentCarrierBaseStation [class]
    module.add_class('ComponentCarrierBaseStation', parent=root_module['ns3::ComponentCarrier'])
    ## component-carrier-enb.h (module 'lte'): ns3::ComponentCarrierEnb [class]
    module.add_class('ComponentCarrierEnb', parent=root_module['ns3::ComponentCarrierBaseStation'])
    ## component-carrier-ue.h (module 'lte'): ns3::ComponentCarrierUe [class]
    module.add_class('ComponentCarrierUe', parent=root_module['ns3::ComponentCarrier'])
    ## random-variable-stream.h (module 'core'): ns3::ConstantRandomVariable [class]
    module.add_class('ConstantRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## propagation-delay-model.h (module 'propagation'): ns3::ConstantSpeedPropagationDelayModel [class]
    module.add_class('ConstantSpeedPropagationDelayModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationDelayModel'])
    ## data-calculator.h (module 'stats'): ns3::DataCalculator [class]
    module.add_class('DataCalculator', import_from_module='ns.stats', parent=root_module['ns3::Object'])
    ## data-output-interface.h (module 'stats'): ns3::DataOutputInterface [class]
    module.add_class('DataOutputInterface', import_from_module='ns.stats', parent=root_module['ns3::Object'])
    ## data-rate.h (module 'network'): ns3::DataRateChecker [class]
    module.add_class('DataRateChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## data-rate.h (module 'network'): ns3::DataRateValue [class]
    module.add_class('DataRateValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## random-variable-stream.h (module 'core'): ns3::DeterministicRandomVariable [class]
    module.add_class('DeterministicRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## double.h (module 'core'): ns3::DoubleValue [class]
    module.add_class('DoubleValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## random-variable-stream.h (module 'core'): ns3::EmpiricalRandomVariable [class]
    module.add_class('EmpiricalRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## attribute.h (module 'core'): ns3::EmptyAttributeAccessor [class]
    module.add_class('EmptyAttributeAccessor', import_from_module='ns.core', parent=root_module['ns3::AttributeAccessor'])
    ## attribute.h (module 'core'): ns3::EmptyAttributeChecker [class]
    module.add_class('EmptyAttributeChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## attribute.h (module 'core'): ns3::EmptyAttributeValue [class]
    module.add_class('EmptyAttributeValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## enum.h (module 'core'): ns3::EnumChecker [class]
    module.add_class('EnumChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## enum.h (module 'core'): ns3::EnumValue [class]
    module.add_class('EnumValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## epc-enb-application.h (module 'lte'): ns3::EpcEnbApplication [class]
    module.add_class('EpcEnbApplication', parent=root_module['ns3::Application'])
    ## epc-enb-application.h (module 'lte'): ns3::EpcEnbApplication::EpsFlowId_t [struct]
    module.add_class('EpsFlowId_t', outer_class=root_module['ns3::EpcEnbApplication'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet > )', 'ns3::EpcEnbApplication::RxTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet > )*', 'ns3::EpcEnbApplication::RxTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet > )&', 'ns3::EpcEnbApplication::RxTracedCallback&')
    ## epc-helper.h (module 'lte'): ns3::EpcHelper [class]
    module.add_class('EpcHelper', parent=root_module['ns3::Object'])
    ## epc-mme-application.h (module 'lte'): ns3::EpcMmeApplication [class]
    module.add_class('EpcMmeApplication', parent=root_module['ns3::Application'])
    ## epc-pgw-application.h (module 'lte'): ns3::EpcPgwApplication [class]
    module.add_class('EpcPgwApplication', parent=root_module['ns3::Application'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet > )', 'ns3::EpcPgwApplication::RxTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet > )*', 'ns3::EpcPgwApplication::RxTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet > )&', 'ns3::EpcPgwApplication::RxTracedCallback&')
    ## epc-sgw-application.h (module 'lte'): ns3::EpcSgwApplication [class]
    module.add_class('EpcSgwApplication', parent=root_module['ns3::Application'])
    ## epc-tft.h (module 'lte'): ns3::EpcTft [class]
    module.add_class('EpcTft', parent=root_module['ns3::SimpleRefCount< ns3::EpcTft, ns3::empty, ns3::DefaultDeleter<ns3::EpcTft> >'])
    ## epc-tft.h (module 'lte'): ns3::EpcTft::Direction [enumeration]
    module.add_enum('Direction', ['DOWNLINK', 'UPLINK', 'BIDIRECTIONAL'], outer_class=root_module['ns3::EpcTft'])
    ## epc-tft.h (module 'lte'): ns3::EpcTft::PacketFilter [struct]
    module.add_class('PacketFilter', outer_class=root_module['ns3::EpcTft'])
    ## epc-tft-classifier.h (module 'lte'): ns3::EpcTftClassifier [class]
    module.add_class('EpcTftClassifier', parent=root_module['ns3::SimpleRefCount< ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter<ns3::EpcTftClassifier> >'])
    ## epc-ue-nas.h (module 'lte'): ns3::EpcUeNas [class]
    module.add_class('EpcUeNas', parent=root_module['ns3::Object'])
    ## epc-ue-nas.h (module 'lte'): ns3::EpcUeNas::State [enumeration]
    module.add_enum('State', ['OFF', 'ATTACHING', 'IDLE_REGISTERED', 'CONNECTING_TO_EPC', 'ACTIVE', 'NUM_STATES'], outer_class=root_module['ns3::EpcUeNas'])
    typehandlers.add_type_alias('void ( * ) ( ns3::EpcUeNas::State const, ns3::EpcUeNas::State const )', 'ns3::EpcUeNas::StateTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::EpcUeNas::State const, ns3::EpcUeNas::State const )*', 'ns3::EpcUeNas::StateTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::EpcUeNas::State const, ns3::EpcUeNas::State const )&', 'ns3::EpcUeNas::StateTracedCallback&')
    ## epc-x2.h (module 'lte'): ns3::EpcX2 [class]
    module.add_class('EpcX2', parent=root_module['ns3::Object'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2HandoverPreparationFailureHeader [class]
    module.add_class('EpcX2HandoverPreparationFailureHeader', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2HandoverRequestAckHeader [class]
    module.add_class('EpcX2HandoverRequestAckHeader', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2HandoverRequestHeader [class]
    module.add_class('EpcX2HandoverRequestHeader', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2Header [class]
    module.add_class('EpcX2Header', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2Header::ProcedureCode_t [enumeration]
    module.add_enum('ProcedureCode_t', ['HandoverPreparation', 'LoadIndication', 'SnStatusTransfer', 'UeContextRelease', 'ResourceStatusReporting'], outer_class=root_module['ns3::EpcX2Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2Header::TypeOfMessage_t [enumeration]
    module.add_enum('TypeOfMessage_t', ['InitiatingMessage', 'SuccessfulOutcome', 'UnsuccessfulOutcome'], outer_class=root_module['ns3::EpcX2Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2LoadInformationHeader [class]
    module.add_class('EpcX2LoadInformationHeader', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2ResourceStatusUpdateHeader [class]
    module.add_class('EpcX2ResourceStatusUpdateHeader', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2SnStatusTransferHeader [class]
    module.add_class('EpcX2SnStatusTransferHeader', parent=root_module['ns3::Header'])
    ## epc-x2-header.h (module 'lte'): ns3::EpcX2UeContextReleaseHeader [class]
    module.add_class('EpcX2UeContextReleaseHeader', parent=root_module['ns3::Header'])
    ## random-variable-stream.h (module 'core'): ns3::ErlangRandomVariable [class]
    module.add_class('ErlangRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## event-impl.h (module 'core'): ns3::EventImpl [class]
    module.add_class('EventImpl', import_from_module='ns.core', parent=root_module['ns3::SimpleRefCount< ns3::EventImpl, ns3::empty, ns3::DefaultDeleter<ns3::EventImpl> >'])
    ## random-variable-stream.h (module 'core'): ns3::ExponentialRandomVariable [class]
    module.add_class('ExponentialRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## ff-mac-scheduler.h (module 'lte'): ns3::FfMacScheduler [class]
    module.add_class('FfMacScheduler', parent=root_module['ns3::Object'])
    ## ff-mac-scheduler.h (module 'lte'): ns3::FfMacScheduler::UlCqiFilter_t [enumeration]
    module.add_enum('UlCqiFilter_t', ['SRS_UL_CQI', 'PUSCH_UL_CQI'], outer_class=root_module['ns3::FfMacScheduler'])
    ## propagation-loss-model.h (module 'propagation'): ns3::FixedRssLossModel [class]
    module.add_class('FixedRssLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## propagation-loss-model.h (module 'propagation'): ns3::FriisPropagationLossModel [class]
    module.add_class('FriisPropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## random-variable-stream.h (module 'core'): ns3::GammaRandomVariable [class]
    module.add_class('GammaRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcHeader [class]
    module.add_class('GtpcHeader', parent=root_module['ns3::Header'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcHeader::InterfaceType_t [enumeration]
    module.add_enum('InterfaceType_t', ['S1U_ENB_GTPU', 'S5_SGW_GTPU', 'S5_PGW_GTPU', 'S5_SGW_GTPC', 'S5_PGW_GTPC', 'S11_MME_GTPC'], outer_class=root_module['ns3::GtpcHeader'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcHeader::MessageType_t [enumeration]
    module.add_enum('MessageType_t', ['Reserved', 'CreateSessionRequest', 'CreateSessionResponse', 'ModifyBearerRequest', 'ModifyBearerResponse', 'DeleteSessionRequest', 'DeleteSessionResponse', 'DeleteBearerCommand', 'DeleteBearerRequest', 'DeleteBearerResponse'], outer_class=root_module['ns3::GtpcHeader'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcHeader::Fteid_t [struct]
    module.add_class('Fteid_t', outer_class=root_module['ns3::GtpcHeader'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcModifyBearerRequestMessage [class]
    module.add_class('GtpcModifyBearerRequestMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcModifyBearerRequestMessage::BearerContextToBeModified [struct]
    module.add_class('BearerContextToBeModified', outer_class=root_module['ns3::GtpcModifyBearerRequestMessage'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcModifyBearerResponseMessage [class]
    module.add_class('GtpcModifyBearerResponseMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## epc-gtpu-header.h (module 'lte'): ns3::GtpuHeader [class]
    module.add_class('GtpuHeader', parent=root_module['ns3::Header'])
    ## integer.h (module 'core'): ns3::IntegerValue [class]
    module.add_class('IntegerValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## ipv4.h (module 'internet'): ns3::Ipv4 [class]
    module.add_class('Ipv4', import_from_module='ns.internet', parent=root_module['ns3::Object'])
    ## ipv4-address.h (module 'network'): ns3::Ipv4AddressChecker [class]
    module.add_class('Ipv4AddressChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## ipv4-address.h (module 'network'): ns3::Ipv4AddressValue [class]
    module.add_class('Ipv4AddressValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## ipv4-address.h (module 'network'): ns3::Ipv4MaskChecker [class]
    module.add_class('Ipv4MaskChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## ipv4-address.h (module 'network'): ns3::Ipv4MaskValue [class]
    module.add_class('Ipv4MaskValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## ipv4-route.h (module 'internet'): ns3::Ipv4MulticastRoute [class]
    module.add_class('Ipv4MulticastRoute', import_from_module='ns.internet', parent=root_module['ns3::SimpleRefCount< ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4MulticastRoute> >'])
    ## ipv4-route.h (module 'internet'): ns3::Ipv4Route [class]
    module.add_class('Ipv4Route', import_from_module='ns.internet', parent=root_module['ns3::SimpleRefCount< ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4Route> >'])
    ## ipv6.h (module 'internet'): ns3::Ipv6 [class]
    module.add_class('Ipv6', import_from_module='ns.internet', parent=root_module['ns3::Object'])
    ## ipv6-address.h (module 'network'): ns3::Ipv6AddressChecker [class]
    module.add_class('Ipv6AddressChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## ipv6-address.h (module 'network'): ns3::Ipv6AddressValue [class]
    module.add_class('Ipv6AddressValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## ipv6-address.h (module 'network'): ns3::Ipv6PrefixChecker [class]
    module.add_class('Ipv6PrefixChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## ipv6-address.h (module 'network'): ns3::Ipv6PrefixValue [class]
    module.add_class('Ipv6PrefixValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## propagation-loss-model.h (module 'propagation'): ns3::LogDistancePropagationLossModel [class]
    module.add_class('LogDistancePropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## random-variable-stream.h (module 'core'): ns3::LogNormalRandomVariable [class]
    module.add_class('LogNormalRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## lte-amc.h (module 'lte'): ns3::LteAmc [class]
    module.add_class('LteAmc', parent=root_module['ns3::Object'])
    ## lte-amc.h (module 'lte'): ns3::LteAmc::AmcModel [enumeration]
    module.add_enum('AmcModel', ['PiroEW2010', 'MiErrorModel'], outer_class=root_module['ns3::LteAmc'])
    ## lte-anr.h (module 'lte'): ns3::LteAnr [class]
    module.add_class('LteAnr', parent=root_module['ns3::Object'])
    ## lte-chunk-processor.h (module 'lte'): ns3::LteChunkProcessor [class]
    module.add_class('LteChunkProcessor', parent=root_module['ns3::SimpleRefCount< ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter<ns3::LteChunkProcessor> >'])
    ## lte-control-messages.h (module 'lte'): ns3::LteControlMessage [class]
    module.add_class('LteControlMessage', parent=root_module['ns3::SimpleRefCount< ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter<ns3::LteControlMessage> >'])
    ## lte-control-messages.h (module 'lte'): ns3::LteControlMessage::MessageType [enumeration]
    module.add_enum('MessageType', ['DL_DCI', 'UL_DCI', 'DL_CQI', 'UL_CQI', 'BSR', 'DL_HARQ', 'RACH_PREAMBLE', 'RAR', 'MIB', 'SIB1'], outer_class=root_module['ns3::LteControlMessage'])
    ## lte-enb-component-carrier-manager.h (module 'lte'): ns3::LteEnbComponentCarrierManager [class]
    module.add_class('LteEnbComponentCarrierManager', parent=root_module['ns3::Object'])
    ## lte-enb-mac.h (module 'lte'): ns3::LteEnbMac [class]
    module.add_class('LteEnbMac', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( uint32_t const, uint32_t const, uint16_t const, uint8_t const, uint16_t const, uint8_t const, uint16_t const, uint8_t const )', 'ns3::LteEnbMac::DlSchedulingTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint32_t const, uint32_t const, uint16_t const, uint8_t const, uint16_t const, uint8_t const, uint16_t const, uint8_t const )*', 'ns3::LteEnbMac::DlSchedulingTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint32_t const, uint32_t const, uint16_t const, uint8_t const, uint16_t const, uint8_t const, uint16_t const, uint8_t const )&', 'ns3::LteEnbMac::DlSchedulingTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint32_t const, uint32_t const, uint16_t const, uint8_t const, uint16_t const )', 'ns3::LteEnbMac::UlSchedulingTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint32_t const, uint32_t const, uint16_t const, uint8_t const, uint16_t const )*', 'ns3::LteEnbMac::UlSchedulingTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint32_t const, uint32_t const, uint16_t const, uint8_t const, uint16_t const )&', 'ns3::LteEnbMac::UlSchedulingTracedCallback&')
    ## lte-enb-rrc.h (module 'lte'): ns3::LteEnbRrc [class]
    module.add_class('LteEnbRrc', parent=root_module['ns3::Object'])
    ## lte-enb-rrc.h (module 'lte'): ns3::LteEnbRrc::LteEpsBearerToRlcMapping_t [enumeration]
    module.add_enum('LteEpsBearerToRlcMapping_t', ['RLC_SM_ALWAYS', 'RLC_UM_ALWAYS', 'RLC_AM_ALWAYS', 'PER_BASED'], outer_class=root_module['ns3::LteEnbRrc'])
    typehandlers.add_type_alias('void ( * ) ( uint16_t const, uint16_t const )', 'ns3::LteEnbRrc::NewUeContextTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t const, uint16_t const )*', 'ns3::LteEnbRrc::NewUeContextTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t const, uint16_t const )&', 'ns3::LteEnbRrc::NewUeContextTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const )', 'ns3::LteEnbRrc::ConnectionHandoverTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const )*', 'ns3::LteEnbRrc::ConnectionHandoverTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const )&', 'ns3::LteEnbRrc::ConnectionHandoverTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, uint16_t const )', 'ns3::LteEnbRrc::HandoverStartTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, uint16_t const )*', 'ns3::LteEnbRrc::HandoverStartTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, uint16_t const )&', 'ns3::LteEnbRrc::HandoverStartTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, ns3::LteRrcSap::MeasurementReport const )', 'ns3::LteEnbRrc::ReceiveReportTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, ns3::LteRrcSap::MeasurementReport const )*', 'ns3::LteEnbRrc::ReceiveReportTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, ns3::LteRrcSap::MeasurementReport const )&', 'ns3::LteEnbRrc::ReceiveReportTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, std::string const )', 'ns3::LteEnbRrc::TimerExpiryTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, std::string const )*', 'ns3::LteEnbRrc::TimerExpiryTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t const, uint16_t const, uint16_t const, std::string const )&', 'ns3::LteEnbRrc::TimerExpiryTracedCallback&')
    ## lte-rrc-protocol-ideal.h (module 'lte'): ns3::LteEnbRrcProtocolIdeal [class]
    module.add_class('LteEnbRrcProtocolIdeal', parent=root_module['ns3::Object'])
    ## lte-rrc-protocol-real.h (module 'lte'): ns3::LteEnbRrcProtocolReal [class]
    module.add_class('LteEnbRrcProtocolReal', parent=root_module['ns3::Object'])
    ## lte-ffr-algorithm.h (module 'lte'): ns3::LteFfrAlgorithm [class]
    module.add_class('LteFfrAlgorithm', parent=root_module['ns3::Object'])
    ## lte-ffr-distributed-algorithm.h (module 'lte'): ns3::LteFfrDistributedAlgorithm [class]
    module.add_class('LteFfrDistributedAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-ffr-enhanced-algorithm.h (module 'lte'): ns3::LteFfrEnhancedAlgorithm [class]
    module.add_class('LteFfrEnhancedAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-ffr-soft-algorithm.h (module 'lte'): ns3::LteFfrSoftAlgorithm [class]
    module.add_class('LteFfrSoftAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-fr-hard-algorithm.h (module 'lte'): ns3::LteFrHardAlgorithm [class]
    module.add_class('LteFrHardAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-fr-no-op-algorithm.h (module 'lte'): ns3::LteFrNoOpAlgorithm [class]
    module.add_class('LteFrNoOpAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-fr-soft-algorithm.h (module 'lte'): ns3::LteFrSoftAlgorithm [class]
    module.add_class('LteFrSoftAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-fr-strict-algorithm.h (module 'lte'): ns3::LteFrStrictAlgorithm [class]
    module.add_class('LteFrStrictAlgorithm', parent=root_module['ns3::LteFfrAlgorithm'])
    ## lte-handover-algorithm.h (module 'lte'): ns3::LteHandoverAlgorithm [class]
    module.add_class('LteHandoverAlgorithm', parent=root_module['ns3::Object'])
    ## lte-harq-phy.h (module 'lte'): ns3::LteHarqPhy [class]
    module.add_class('LteHarqPhy', parent=root_module['ns3::SimpleRefCount< ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter<ns3::LteHarqPhy> >'])
    ## lte-helper.h (module 'lte'): ns3::LteHelper [class]
    module.add_class('LteHelper', parent=root_module['ns3::Object'])
    ## lte-hex-grid-enb-topology-helper.h (module 'lte'): ns3::LteHexGridEnbTopologyHelper [class]
    module.add_class('LteHexGridEnbTopologyHelper', parent=root_module['ns3::Object'])
    ## lte-interference.h (module 'lte'): ns3::LteInterference [class]
    module.add_class('LteInterference', parent=root_module['ns3::Object'])
    ## lte-pdcp.h (module 'lte'): ns3::LtePdcp [class]
    module.add_class('LtePdcp', parent=root_module['ns3::Object'])
    ## lte-pdcp.h (module 'lte'): ns3::LtePdcp::Status [struct]
    module.add_class('Status', outer_class=root_module['ns3::LtePdcp'])
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t )', 'ns3::LtePdcp::PduTxTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t )*', 'ns3::LtePdcp::PduTxTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t )&', 'ns3::LtePdcp::PduTxTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint16_t const, uint8_t const, uint32_t const, uint64_t const )', 'ns3::LtePdcp::PduRxTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t const, uint8_t const, uint32_t const, uint64_t const )*', 'ns3::LtePdcp::PduRxTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t const, uint8_t const, uint32_t const, uint64_t const )&', 'ns3::LtePdcp::PduRxTracedCallback&')
    ## lte-phy.h (module 'lte'): ns3::LtePhy [class]
    module.add_class('LtePhy', parent=root_module['ns3::Object'])
    ## lte-radio-bearer-info.h (module 'lte'): ns3::LteRadioBearerInfo [class]
    module.add_class('LteRadioBearerInfo', parent=root_module['ns3::Object'])
    ## lte-rlc.h (module 'lte'): ns3::LteRlc [class]
    module.add_class('LteRlc', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t )', 'ns3::LteRlc::NotifyTxTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t )*', 'ns3::LteRlc::NotifyTxTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t )&', 'ns3::LteRlc::NotifyTxTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t, uint64_t )', 'ns3::LteRlc::ReceiveTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t, uint64_t )*', 'ns3::LteRlc::ReceiveTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint8_t, uint32_t, uint64_t )&', 'ns3::LteRlc::ReceiveTracedCallback&')
    ## lte-rlc-am.h (module 'lte'): ns3::LteRlcAm [class]
    module.add_class('LteRlcAm', parent=root_module['ns3::LteRlc'])
    ## lte-rlc.h (module 'lte'): ns3::LteRlcSm [class]
    module.add_class('LteRlcSm', parent=root_module['ns3::LteRlc'])
    ## lte-rlc-tm.h (module 'lte'): ns3::LteRlcTm [class]
    module.add_class('LteRlcTm', parent=root_module['ns3::LteRlc'])
    ## lte-rlc-um.h (module 'lte'): ns3::LteRlcUm [class]
    module.add_class('LteRlcUm', parent=root_module['ns3::LteRlc'])
    ## lte-radio-bearer-info.h (module 'lte'): ns3::LteSignalingRadioBearerInfo [class]
    module.add_class('LteSignalingRadioBearerInfo', parent=root_module['ns3::LteRadioBearerInfo'])
    ## lte-spectrum-phy.h (module 'lte'): ns3::LteSpectrumPhy [class]
    module.add_class('LteSpectrumPhy', parent=root_module['ns3::SpectrumPhy'])
    ## lte-spectrum-phy.h (module 'lte'): ns3::LteSpectrumPhy::State [enumeration]
    module.add_enum('State', ['IDLE', 'TX_DL_CTRL', 'TX_DATA', 'TX_UL_SRS', 'RX_DL_CTRL', 'RX_DATA', 'RX_UL_SRS'], outer_class=root_module['ns3::LteSpectrumPhy'])
    ## lte-spectrum-signal-parameters.h (module 'lte'): ns3::LteSpectrumSignalParameters [struct]
    module.add_class('LteSpectrumSignalParameters', parent=root_module['ns3::SpectrumSignalParameters'])
    ## lte-spectrum-signal-parameters.h (module 'lte'): ns3::LteSpectrumSignalParametersDataFrame [struct]
    module.add_class('LteSpectrumSignalParametersDataFrame', parent=root_module['ns3::SpectrumSignalParameters'])
    ## lte-spectrum-signal-parameters.h (module 'lte'): ns3::LteSpectrumSignalParametersDlCtrlFrame [struct]
    module.add_class('LteSpectrumSignalParametersDlCtrlFrame', parent=root_module['ns3::SpectrumSignalParameters'])
    ## lte-spectrum-signal-parameters.h (module 'lte'): ns3::LteSpectrumSignalParametersUlSrsFrame [struct]
    module.add_class('LteSpectrumSignalParametersUlSrsFrame', parent=root_module['ns3::SpectrumSignalParameters'])
    ## lte-stats-calculator.h (module 'lte'): ns3::LteStatsCalculator [class]
    module.add_class('LteStatsCalculator', parent=root_module['ns3::Object'])
    ## lte-ue-component-carrier-manager.h (module 'lte'): ns3::LteUeComponentCarrierManager [class]
    module.add_class('LteUeComponentCarrierManager', parent=root_module['ns3::Object'])
    ## lte-ue-mac.h (module 'lte'): ns3::LteUeMac [class]
    module.add_class('LteUeMac', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( uint64_t, bool, uint8_t, uint8_t )', 'ns3::LteUeMac::RaResponseTimeoutTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, bool, uint8_t, uint8_t )*', 'ns3::LteUeMac::RaResponseTimeoutTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, bool, uint8_t, uint8_t )&', 'ns3::LteUeMac::RaResponseTimeoutTracedCallback&')
    ## lte-ue-phy.h (module 'lte'): ns3::LteUePhy [class]
    module.add_class('LteUePhy', parent=root_module['ns3::LtePhy'])
    ## lte-ue-phy.h (module 'lte'): ns3::LteUePhy::State [enumeration]
    module.add_enum('State', ['CELL_SEARCH', 'SYNCHRONIZED', 'NUM_STATES'], outer_class=root_module['ns3::LteUePhy'])
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, ns3::LteUePhy::State, ns3::LteUePhy::State )', 'ns3::LteUePhy::StateTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, ns3::LteUePhy::State, ns3::LteUePhy::State )*', 'ns3::LteUePhy::StateTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, ns3::LteUePhy::State, ns3::LteUePhy::State )&', 'ns3::LteUePhy::StateTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, double, uint8_t )', 'ns3::LteUePhy::RsrpSinrTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, double, uint8_t )*', 'ns3::LteUePhy::RsrpSinrTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, double, uint8_t )&', 'ns3::LteUePhy::RsrpSinrTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, double, bool, uint8_t )', 'ns3::LteUePhy::RsrpRsrqTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, double, bool, uint8_t )*', 'ns3::LteUePhy::RsrpRsrqTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, double, bool, uint8_t )&', 'ns3::LteUePhy::RsrpRsrqTracedCallback&')
    ## lte-ue-power-control.h (module 'lte'): ns3::LteUePowerControl [class]
    module.add_class('LteUePowerControl', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double )', 'ns3::LteUePowerControl::TxPowerTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double )*', 'ns3::LteUePowerControl::TxPowerTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double )&', 'ns3::LteUePowerControl::TxPowerTracedCallback&')
    ## lte-ue-rrc.h (module 'lte'): ns3::LteUeRrc [class]
    module.add_class('LteUeRrc', parent=root_module['ns3::Object'])
    ## lte-ue-rrc.h (module 'lte'): ns3::LteUeRrc::State [enumeration]
    module.add_enum('State', ['IDLE_START', 'IDLE_CELL_SEARCH', 'IDLE_WAIT_MIB_SIB1', 'IDLE_WAIT_MIB', 'IDLE_WAIT_SIB1', 'IDLE_CAMPED_NORMALLY', 'IDLE_WAIT_SIB2', 'IDLE_RANDOM_ACCESS', 'IDLE_CONNECTING', 'CONNECTED_NORMALLY', 'CONNECTED_HANDOVER', 'CONNECTED_PHY_PROBLEM', 'CONNECTED_REESTABLISHING', 'NUM_STATES'], outer_class=root_module['ns3::LteUeRrc'])
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t )', 'ns3::LteUeRrc::CellSelectionTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t )*', 'ns3::LteUeRrc::CellSelectionTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t )&', 'ns3::LteUeRrc::CellSelectionTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t )', 'ns3::LteUeRrc::ImsiCidRntiTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t )*', 'ns3::LteUeRrc::ImsiCidRntiTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t )&', 'ns3::LteUeRrc::ImsiCidRntiTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, uint16_t )', 'ns3::LteUeRrc::MibSibHandoverTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, uint16_t )*', 'ns3::LteUeRrc::MibSibHandoverTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, uint16_t )&', 'ns3::LteUeRrc::MibSibHandoverTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, ns3::LteUeRrc::State, ns3::LteUeRrc::State )', 'ns3::LteUeRrc::StateTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, ns3::LteUeRrc::State, ns3::LteUeRrc::State )*', 'ns3::LteUeRrc::StateTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, ns3::LteUeRrc::State, ns3::LteUeRrc::State )&', 'ns3::LteUeRrc::StateTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::LteUeRrc >, std::list< ns3::LteRrcSap::SCellToAddMod > )', 'ns3::LteUeRrc::SCarrierConfiguredTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::LteUeRrc >, std::list< ns3::LteRrcSap::SCellToAddMod > )*', 'ns3::LteUeRrc::SCarrierConfiguredTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::LteUeRrc >, std::list< ns3::LteRrcSap::SCellToAddMod > )&', 'ns3::LteUeRrc::SCarrierConfiguredTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, std::string, uint16_t )', 'ns3::LteUeRrc::PhySyncDetectionTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, std::string, uint16_t )*', 'ns3::LteUeRrc::PhySyncDetectionTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, std::string, uint16_t )&', 'ns3::LteUeRrc::PhySyncDetectionTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, uint8_t )', 'ns3::LteUeRrc::ImsiCidRntiCountTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, uint8_t )*', 'ns3::LteUeRrc::ImsiCidRntiCountTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint64_t, uint16_t, uint16_t, uint8_t )&', 'ns3::LteUeRrc::ImsiCidRntiCountTracedCallback&')
    ## lte-rrc-protocol-ideal.h (module 'lte'): ns3::LteUeRrcProtocolIdeal [class]
    module.add_class('LteUeRrcProtocolIdeal', parent=root_module['ns3::Object'])
    ## lte-rrc-protocol-real.h (module 'lte'): ns3::LteUeRrcProtocolReal [class]
    module.add_class('LteUeRrcProtocolReal', parent=root_module['ns3::Object'])
    ## mac48-address.h (module 'network'): ns3::Mac48AddressChecker [class]
    module.add_class('Mac48AddressChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## mac48-address.h (module 'network'): ns3::Mac48AddressValue [class]
    module.add_class('Mac48AddressValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## mac64-address.h (module 'network'): ns3::Mac64AddressChecker [class]
    module.add_class('Mac64AddressChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## mac64-address.h (module 'network'): ns3::Mac64AddressValue [class]
    module.add_class('Mac64AddressValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## mac-stats-calculator.h (module 'lte'): ns3::MacStatsCalculator [class]
    module.add_class('MacStatsCalculator', parent=root_module['ns3::LteStatsCalculator'])
    ## propagation-loss-model.h (module 'propagation'): ns3::MatrixPropagationLossModel [class]
    module.add_class('MatrixPropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## lte-control-messages.h (module 'lte'): ns3::MibLteControlMessage [class]
    module.add_class('MibLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## basic-data-calculators.h (module 'stats'): ns3::MinMaxAvgTotalCalculator<unsigned int> [class]
    module.add_class('MinMaxAvgTotalCalculator', import_from_module='ns.stats', parent=[root_module['ns3::DataCalculator'], root_module['ns3::StatisticalSummary']], template_parameters=['unsigned int'])
    ## basic-data-calculators.h (module 'stats'): ns3::MinMaxAvgTotalCalculator<unsigned long long> [class]
    module.add_class('MinMaxAvgTotalCalculator', import_from_module='ns.stats', parent=[root_module['ns3::DataCalculator'], root_module['ns3::StatisticalSummary']], template_parameters=['unsigned long long'])
    ## mobility-model.h (module 'mobility'): ns3::MobilityModel [class]
    module.add_class('MobilityModel', import_from_module='ns.mobility', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::MobilityModel const > )', 'ns3::MobilityModel::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::MobilityModel const > )*', 'ns3::MobilityModel::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::MobilityModel const > )&', 'ns3::MobilityModel::TracedCallback&')
    ## propagation-loss-model.h (module 'propagation'): ns3::NakagamiPropagationLossModel [class]
    module.add_class('NakagamiPropagationLossModel', import_from_module='ns.propagation', parent=root_module['ns3::PropagationLossModel'])
    ## net-device.h (module 'network'): ns3::NetDevice [class]
    module.add_class('NetDevice', import_from_module='ns.network', parent=root_module['ns3::Object'])
    ## net-device.h (module 'network'): ns3::NetDevice::PacketType [enumeration]
    module.add_enum('PacketType', ['PACKET_HOST', 'NS3_PACKET_HOST', 'PACKET_BROADCAST', 'NS3_PACKET_BROADCAST', 'PACKET_MULTICAST', 'NS3_PACKET_MULTICAST', 'PACKET_OTHERHOST', 'NS3_PACKET_OTHERHOST'], outer_class=root_module['ns3::NetDevice'], import_from_module='ns.network')
    typehandlers.add_type_alias('void ( * ) (  )', 'ns3::NetDevice::LinkChangeTracedCallback')
    typehandlers.add_type_alias('void ( * ) (  )*', 'ns3::NetDevice::LinkChangeTracedCallback*')
    typehandlers.add_type_alias('void ( * ) (  )&', 'ns3::NetDevice::LinkChangeTracedCallback&')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::NetDevice::ReceiveCallback')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::NetDevice::ReceiveCallback*')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::NetDevice::ReceiveCallback&')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::Address const &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >', 'ns3::NetDevice::PromiscReceiveCallback')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::Address const &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::NetDevice::PromiscReceiveCallback*')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::Address const &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::NetDevice::PromiscReceiveCallback&')
    ## nix-vector.h (module 'network'): ns3::NixVector [class]
    module.add_class('NixVector', import_from_module='ns.network', parent=root_module['ns3::SimpleRefCount< ns3::NixVector, ns3::empty, ns3::DefaultDeleter<ns3::NixVector> >'])
    ## no-backhaul-epc-helper.h (module 'lte'): ns3::NoBackhaulEpcHelper [class]
    module.add_class('NoBackhaulEpcHelper', parent=root_module['ns3::EpcHelper'])
    ## no-op-component-carrier-manager.h (module 'lte'): ns3::NoOpComponentCarrierManager [class]
    module.add_class('NoOpComponentCarrierManager', parent=root_module['ns3::LteEnbComponentCarrierManager'])
    ## no-op-handover-algorithm.h (module 'lte'): ns3::NoOpHandoverAlgorithm [class]
    module.add_class('NoOpHandoverAlgorithm', parent=root_module['ns3::LteHandoverAlgorithm'])
    ## node.h (module 'network'): ns3::Node [class]
    module.add_class('Node', import_from_module='ns.network', parent=root_module['ns3::Object'])
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::Address const &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >', 'ns3::Node::ProtocolHandler')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::Address const &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::Node::ProtocolHandler*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::NetDevice >, ns3::Ptr< ns3::Packet const >, unsigned short, ns3::Address const &, ns3::Address const &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::Node::ProtocolHandler&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::NetDevice >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::Node::DeviceAdditionListener')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::NetDevice >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::Node::DeviceAdditionListener*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::NetDevice >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::Node::DeviceAdditionListener&')
    ## random-variable-stream.h (module 'core'): ns3::NormalRandomVariable [class]
    module.add_class('NormalRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## object-factory.h (module 'core'): ns3::ObjectFactoryChecker [class]
    module.add_class('ObjectFactoryChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## object-factory.h (module 'core'): ns3::ObjectFactoryValue [class]
    module.add_class('ObjectFactoryValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## packet.h (module 'network'): ns3::Packet [class]
    module.add_class('Packet', import_from_module='ns.network', parent=root_module['ns3::SimpleRefCount< ns3::Packet, ns3::empty, ns3::DefaultDeleter<ns3::Packet> >'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const > )', 'ns3::Packet::TracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const > )*', 'ns3::Packet::TracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const > )&', 'ns3::Packet::TracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, ns3::Address const & )', 'ns3::Packet::AddressTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, ns3::Address const & )*', 'ns3::Packet::AddressTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, ns3::Address const & )&', 'ns3::Packet::AddressTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const > const, ns3::Address const &, ns3::Address const & )', 'ns3::Packet::TwoAddressTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const > const, ns3::Address const &, ns3::Address const & )*', 'ns3::Packet::TwoAddressTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const > const, ns3::Address const &, ns3::Address const & )&', 'ns3::Packet::TwoAddressTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, ns3::Mac48Address )', 'ns3::Packet::Mac48AddressTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, ns3::Mac48Address )*', 'ns3::Packet::Mac48AddressTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, ns3::Mac48Address )&', 'ns3::Packet::Mac48AddressTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint32_t, uint32_t )', 'ns3::Packet::SizeTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint32_t, uint32_t )*', 'ns3::Packet::SizeTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint32_t, uint32_t )&', 'ns3::Packet::SizeTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, double )', 'ns3::Packet::SinrTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, double )*', 'ns3::Packet::SinrTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::Packet const >, double )&', 'ns3::Packet::SinrTracedCallback&')
    ## random-variable-stream.h (module 'core'): ns3::ParetoRandomVariable [class]
    module.add_class('ParetoRandomVariable', import_from_module='ns.core', parent=root_module['ns3::RandomVariableStream'])
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::PfFfMacScheduler [class]
    module.add_class('PfFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## phy-rx-stats-calculator.h (module 'lte'): ns3::PhyRxStatsCalculator [class]
    module.add_class('PhyRxStatsCalculator', parent=root_module['ns3::LteStatsCalculator'])
    ## phy-stats-calculator.h (module 'lte'): ns3::PhyStatsCalculator [class]
    module.add_class('PhyStatsCalculator', parent=root_module['ns3::LteStatsCalculator'])
    ## phy-tx-stats-calculator.h (module 'lte'): ns3::PhyTxStatsCalculator [class]
    module.add_class('PhyTxStatsCalculator', parent=root_module['ns3::LteStatsCalculator'])
    ## point-to-point-epc-helper.h (module 'lte'): ns3::PointToPointEpcHelper [class]
    module.add_class('PointToPointEpcHelper', parent=root_module['ns3::NoBackhaulEpcHelper'])
    ## pointer.h (module 'core'): ns3::PointerChecker [class]
    module.add_class('PointerChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## pointer.h (module 'core'): ns3::PointerValue [class]
    module.add_class('PointerValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::PssFfMacScheduler [class]
    module.add_class('PssFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## lte-control-messages.h (module 'lte'): ns3::RachPreambleLteControlMessage [class]
    module.add_class('RachPreambleLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## radio-bearer-stats-calculator.h (module 'lte'): ns3::RadioBearerStatsCalculator [class]
    module.add_class('RadioBearerStatsCalculator', parent=root_module['ns3::LteStatsCalculator'])
    ## lte-control-messages.h (module 'lte'): ns3::RarLteControlMessage [class]
    module.add_class('RarLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## lte-control-messages.h (module 'lte'): ns3::RarLteControlMessage::Rar [struct]
    module.add_class('Rar', outer_class=root_module['ns3::RarLteControlMessage'])
    ## rem-spectrum-phy.h (module 'lte'): ns3::RemSpectrumPhy [class]
    module.add_class('RemSpectrumPhy', parent=root_module['ns3::SpectrumPhy'])
    ## no-op-component-carrier-manager.h (module 'lte'): ns3::RrComponentCarrierManager [class]
    module.add_class('RrComponentCarrierManager', parent=root_module['ns3::NoOpComponentCarrierManager'])
    ## rr-ff-mac-scheduler.h (module 'lte'): ns3::RrFfMacScheduler [class]
    module.add_class('RrFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcAsn1Header [class]
    module.add_class('RrcAsn1Header', parent=root_module['ns3::Asn1Header'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcDlCcchMessage [class]
    module.add_class('RrcDlCcchMessage', parent=root_module['ns3::RrcAsn1Header'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcDlDcchMessage [class]
    module.add_class('RrcDlDcchMessage', parent=root_module['ns3::RrcAsn1Header'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcUlCcchMessage [class]
    module.add_class('RrcUlCcchMessage', parent=root_module['ns3::RrcAsn1Header'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcUlDcchMessage [class]
    module.add_class('RrcUlDcchMessage', parent=root_module['ns3::RrcAsn1Header'])
    ## lte-control-messages.h (module 'lte'): ns3::Sib1LteControlMessage [class]
    module.add_class('Sib1LteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## simple-ue-component-carrier-manager.h (module 'lte'): ns3::SimpleUeComponentCarrierManager [class]
    module.add_class('SimpleUeComponentCarrierManager', parent=root_module['ns3::LteUeComponentCarrierManager'])
    ## spectrum-channel.h (module 'spectrum'): ns3::SpectrumChannel [class]
    module.add_class('SpectrumChannel', import_from_module='ns.spectrum', parent=root_module['ns3::Channel'])
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumPhy const >, ns3::Ptr< ns3::SpectrumPhy const >, double )', 'ns3::SpectrumChannel::LossTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumPhy const >, ns3::Ptr< ns3::SpectrumPhy const >, double )*', 'ns3::SpectrumChannel::LossTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumPhy const >, ns3::Ptr< ns3::SpectrumPhy const >, double )&', 'ns3::SpectrumChannel::LossTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::MobilityModel const >, ns3::Ptr< ns3::MobilityModel const >, double, double, double, double )', 'ns3::SpectrumChannel::GainTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::MobilityModel const >, ns3::Ptr< ns3::MobilityModel const >, double, double, double, double )*', 'ns3::SpectrumChannel::GainTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::MobilityModel const >, ns3::Ptr< ns3::MobilityModel const >, double, double, double, double )&', 'ns3::SpectrumChannel::GainTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumSignalParameters > )', 'ns3::SpectrumChannel::SignalParametersTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumSignalParameters > )*', 'ns3::SpectrumChannel::SignalParametersTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Ptr< ns3::SpectrumSignalParameters > )&', 'ns3::SpectrumChannel::SignalParametersTracedCallback&')
    ## lte-vendor-specific-parameters.h (module 'lte'): ns3::SrsCqiRntiVsp [class]
    module.add_class('SrsCqiRntiVsp', parent=root_module['ns3::VendorSpecificValue'])
    ## string.h (module 'core'): ns3::StringChecker [class]
    module.add_class('StringChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## string.h (module 'core'): ns3::StringValue [class]
    module.add_class('StringValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::TdBetFfMacScheduler [class]
    module.add_class('TdBetFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## tdmt-ff-mac-scheduler.h (module 'lte'): ns3::TdMtFfMacScheduler [class]
    module.add_class('TdMtFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::TdTbfqFfMacScheduler [class]
    module.add_class('TdTbfqFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## nstime.h (module 'core'): ns3::TimeValue [class]
    module.add_class('TimeValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## tta-ff-mac-scheduler.h (module 'lte'): ns3::TtaFfMacScheduler [class]
    module.add_class('TtaFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## type-id.h (module 'core'): ns3::TypeIdChecker [class]
    module.add_class('TypeIdChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## type-id.h (module 'core'): ns3::TypeIdValue [class]
    module.add_class('TypeIdValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## uinteger.h (module 'core'): ns3::UintegerValue [class]
    module.add_class('UintegerValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## lte-control-messages.h (module 'lte'): ns3::UlDciLteControlMessage [class]
    module.add_class('UlDciLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## vector.h (module 'core'): ns3::Vector2DChecker [class]
    module.add_class('Vector2DChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## vector.h (module 'core'): ns3::Vector2DValue [class]
    module.add_class('Vector2DValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## vector.h (module 'core'): ns3::Vector3DChecker [class]
    module.add_class('Vector3DChecker', import_from_module='ns.core', parent=root_module['ns3::AttributeChecker'])
    ## vector.h (module 'core'): ns3::Vector3DValue [class]
    module.add_class('Vector3DValue', import_from_module='ns.core', parent=root_module['ns3::AttributeValue'])
    ## virtual-net-device.h (module 'virtual-net-device'): ns3::VirtualNetDevice [class]
    module.add_class('VirtualNetDevice', import_from_module='ns.virtual_net_device', parent=root_module['ns3::NetDevice'])
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::Packet >, ns3::Address const &, ns3::Address const &, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::VirtualNetDevice::SendCallback')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::Packet >, ns3::Address const &, ns3::Address const &, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::VirtualNetDevice::SendCallback*')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::Packet >, ns3::Address const &, ns3::Address const &, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::VirtualNetDevice::SendCallback&')
    ## a2-a4-rsrq-handover-algorithm.h (module 'lte'): ns3::A2A4RsrqHandoverAlgorithm [class]
    module.add_class('A2A4RsrqHandoverAlgorithm', parent=root_module['ns3::LteHandoverAlgorithm'])
    ## a3-rsrp-handover-algorithm.h (module 'lte'): ns3::A3RsrpHandoverAlgorithm [class]
    module.add_class('A3RsrpHandoverAlgorithm', parent=root_module['ns3::LteHandoverAlgorithm'])
    ## address.h (module 'network'): ns3::AddressChecker [class]
    module.add_class('AddressChecker', import_from_module='ns.network', parent=root_module['ns3::AttributeChecker'])
    ## address.h (module 'network'): ns3::AddressValue [class]
    module.add_class('AddressValue', import_from_module='ns.network', parent=root_module['ns3::AttributeValue'])
    ## lte-control-messages.h (module 'lte'): ns3::BsrLteControlMessage [class]
    module.add_class('BsrLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## callback.h (module 'core'): ns3::CallbackImpl<bool, ns3::Ptr<ns3::NetDevice>, ns3::Ptr<const ns3::Packet>, unsigned short, const ns3::Address &, const ns3::Address &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['bool', 'ns3::Ptr<ns3::NetDevice>', 'ns3::Ptr<const ns3::Packet>', 'unsigned short', 'const ns3::Address &', 'const ns3::Address &', 'ns3::NetDevice::PacketType', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<bool, ns3::Ptr<ns3::NetDevice>, ns3::Ptr<const ns3::Packet>, unsigned short, const ns3::Address &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['bool', 'ns3::Ptr<ns3::NetDevice>', 'ns3::Ptr<const ns3::Packet>', 'unsigned short', 'const ns3::Address &', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<bool, ns3::Ptr<ns3::Packet>, const ns3::Address &, const ns3::Address &, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['bool', 'ns3::Ptr<ns3::Packet>', 'const ns3::Address &', 'const ns3::Address &', 'unsigned short', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<bool, ns3::Ptr<ns3::Socket>, const ns3::Address &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['bool', 'ns3::Ptr<ns3::Socket>', 'const ns3::Address &', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<ns3::ObjectBase *, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['ns3::ObjectBase *', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, const ns3::SpectrumValue &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'const ns3::SpectrumValue &', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::DlSchedulingCallbackInfo, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::DlSchedulingCallbackInfo', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::EpcUeNas::State, ns3::EpcUeNas::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::EpcUeNas::State', 'ns3::EpcUeNas::State', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::PhyReceptionStatParameters, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::PhyReceptionStatParameters', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::PhyTransmissionStatParameters, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::PhyTransmissionStatParameters', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<const ns3::MobilityModel>, ns3::Ptr<const ns3::MobilityModel>, double, double, double, double, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<const ns3::MobilityModel>', 'ns3::Ptr<const ns3::MobilityModel>', 'double', 'double', 'double', 'double', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<const ns3::MobilityModel>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<const ns3::MobilityModel>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<const ns3::Packet>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<const ns3::Packet>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<const ns3::PacketBurst>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<const ns3::PacketBurst>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<const ns3::SpectrumPhy>, ns3::Ptr<const ns3::SpectrumPhy>, double, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<const ns3::SpectrumPhy>', 'ns3::Ptr<const ns3::SpectrumPhy>', 'double', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::LteUeRrc>, std::list<ns3::LteRrcSap::SCellToAddMod, std::allocator<ns3::LteRrcSap::SCellToAddMod> >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::LteUeRrc>', 'std::list<ns3::LteRrcSap::SCellToAddMod, std::allocator<ns3::LteRrcSap::SCellToAddMod> >', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::NetDevice>, ns3::Ptr<const ns3::Packet>, unsigned short, const ns3::Address &, const ns3::Address &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::NetDevice>', 'ns3::Ptr<const ns3::Packet>', 'unsigned short', 'const ns3::Address &', 'const ns3::Address &', 'ns3::NetDevice::PacketType', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::NetDevice>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::NetDevice>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::Packet>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::Packet>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::Socket>, const ns3::Address &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::Socket>', 'const ns3::Address &', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::Socket>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::Socket>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::Socket>, unsigned int, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::Socket>', 'unsigned int', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::Ptr<ns3::SpectrumSignalParameters>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::Ptr<ns3::SpectrumSignalParameters>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned int, unsigned int, unsigned short, unsigned char, unsigned short, unsigned char, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned int', 'unsigned int', 'unsigned short', 'unsigned char', 'unsigned short', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, bool, unsigned char, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'bool', 'unsigned char', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, ns3::LteRrcSap::MeasurementReport, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'ns3::LteRrcSap::MeasurementReport', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, ns3::LteUeRrc::State, ns3::LteUeRrc::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'ns3::LteUeRrc::State', 'ns3::LteUeRrc::State', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, ns3::UeManager::State, ns3::UeManager::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'ns3::UeManager::State', 'ns3::UeManager::State', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, std::basic_string<char>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'std::basic_string<char>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, std::basic_string<char>, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'std::basic_string<char>', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned long long, unsigned short, unsigned short, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned long long', 'unsigned short', 'unsigned short', 'unsigned short', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, ns3::Ptr<ns3::SpectrumValue>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'ns3::Ptr<ns3::SpectrumValue>', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned char, unsigned int, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned char', 'unsigned int', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned char, unsigned int, unsigned long long, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned char', 'unsigned int', 'unsigned long long', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned short, double, double, bool, unsigned char, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned short', 'double', 'double', 'bool', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned short, double, double, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned short', 'double', 'double', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned short, double, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned short', 'double', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned short, double, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned short', 'double', 'unsigned char', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned short, ns3::LteUePhy::State, ns3::LteUePhy::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned short', 'ns3::LteUePhy::State', 'ns3::LteUePhy::State', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## callback.h (module 'core'): ns3::CallbackImpl<void, unsigned short, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> [class]
    module.add_class('CallbackImpl', import_from_module='ns.core', parent=root_module['ns3::CallbackImplBase'], template_parameters=['void', 'unsigned short', 'unsigned short', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty', 'ns3::empty'])
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqaFfMacScheduler [class]
    module.add_class('CqaFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## lte-control-messages.h (module 'lte'): ns3::DlCqiLteControlMessage [class]
    module.add_class('DlCqiLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## lte-control-messages.h (module 'lte'): ns3::DlDciLteControlMessage [class]
    module.add_class('DlDciLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## lte-control-messages.h (module 'lte'): ns3::DlHarqFeedbackLteControlMessage [class]
    module.add_class('DlHarqFeedbackLteControlMessage', parent=root_module['ns3::LteControlMessage'])
    ## emu-epc-helper.h (module 'lte'): ns3::EmuEpcHelper [class]
    module.add_class('EmuEpcHelper', parent=root_module['ns3::NoBackhaulEpcHelper'])
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::FdBetFfMacScheduler [class]
    module.add_class('FdBetFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## fdmt-ff-mac-scheduler.h (module 'lte'): ns3::FdMtFfMacScheduler [class]
    module.add_class('FdMtFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::FdTbfqFfMacScheduler [class]
    module.add_class('FdTbfqFfMacScheduler', parent=root_module['ns3::FfMacScheduler'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcCreateSessionRequestMessage [class]
    module.add_class('GtpcCreateSessionRequestMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcCreateSessionRequestMessage::BearerContextToBeCreated [struct]
    module.add_class('BearerContextToBeCreated', outer_class=root_module['ns3::GtpcCreateSessionRequestMessage'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcCreateSessionResponseMessage [class]
    module.add_class('GtpcCreateSessionResponseMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcCreateSessionResponseMessage::BearerContextCreated [struct]
    module.add_class('BearerContextCreated', outer_class=root_module['ns3::GtpcCreateSessionResponseMessage'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcDeleteBearerCommandMessage [class]
    module.add_class('GtpcDeleteBearerCommandMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcDeleteBearerCommandMessage::BearerContext [struct]
    module.add_class('BearerContext', outer_class=root_module['ns3::GtpcDeleteBearerCommandMessage'])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcDeleteBearerRequestMessage [class]
    module.add_class('GtpcDeleteBearerRequestMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcDeleteBearerResponseMessage [class]
    module.add_class('GtpcDeleteBearerResponseMessage', parent=[root_module['ns3::GtpcHeader'], root_module['ns3::GtpcIes']])
    ## lte-rrc-header.h (module 'lte'): ns3::HandoverPreparationInfoHeader [class]
    module.add_class('HandoverPreparationInfoHeader', parent=root_module['ns3::RrcAsn1Header'])
    ## lte-radio-bearer-info.h (module 'lte'): ns3::LteDataRadioBearerInfo [class]
    module.add_class('LteDataRadioBearerInfo', parent=root_module['ns3::LteRadioBearerInfo'])
    ## lte-enb-phy.h (module 'lte'): ns3::LteEnbPhy [class]
    module.add_class('LteEnbPhy', parent=root_module['ns3::LtePhy'])
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, uint8_t )', 'ns3::LteEnbPhy::ReportUeSinrTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, uint8_t )*', 'ns3::LteEnbPhy::ReportUeSinrTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t, double, uint8_t )&', 'ns3::LteEnbPhy::ReportUeSinrTracedCallback&')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, ns3::Ptr< ns3::SpectrumValue > )', 'ns3::LteEnbPhy::ReportInterferenceTracedCallback')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, ns3::Ptr< ns3::SpectrumValue > )*', 'ns3::LteEnbPhy::ReportInterferenceTracedCallback*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, ns3::Ptr< ns3::SpectrumValue > )&', 'ns3::LteEnbPhy::ReportInterferenceTracedCallback&')
    ## lte-net-device.h (module 'lte'): ns3::LteNetDevice [class]
    module.add_class('LteNetDevice', parent=root_module['ns3::NetDevice'])
    ## lte-ue-net-device.h (module 'lte'): ns3::LteUeNetDevice [class]
    module.add_class('LteUeNetDevice', parent=root_module['ns3::LteNetDevice'])
    ## lte-rrc-header.h (module 'lte'): ns3::MeasurementReportHeader [class]
    module.add_class('MeasurementReportHeader', parent=root_module['ns3::RrcUlDcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReconfigurationCompleteHeader [class]
    module.add_class('RrcConnectionReconfigurationCompleteHeader', parent=root_module['ns3::RrcUlDcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReconfigurationHeader [class]
    module.add_class('RrcConnectionReconfigurationHeader', parent=root_module['ns3::RrcDlDcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReestablishmentCompleteHeader [class]
    module.add_class('RrcConnectionReestablishmentCompleteHeader', parent=root_module['ns3::RrcUlDcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReestablishmentHeader [class]
    module.add_class('RrcConnectionReestablishmentHeader', parent=root_module['ns3::RrcDlCcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReestablishmentRejectHeader [class]
    module.add_class('RrcConnectionReestablishmentRejectHeader', parent=root_module['ns3::RrcDlCcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReestablishmentRequestHeader [class]
    module.add_class('RrcConnectionReestablishmentRequestHeader', parent=root_module['ns3::RrcUlCcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionRejectHeader [class]
    module.add_class('RrcConnectionRejectHeader', parent=root_module['ns3::RrcDlCcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionReleaseHeader [class]
    module.add_class('RrcConnectionReleaseHeader', parent=root_module['ns3::RrcDlDcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionRequestHeader [class]
    module.add_class('RrcConnectionRequestHeader', parent=root_module['ns3::RrcUlCcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionSetupCompleteHeader [class]
    module.add_class('RrcConnectionSetupCompleteHeader', parent=root_module['ns3::RrcUlDcchMessage'])
    ## lte-rrc-header.h (module 'lte'): ns3::RrcConnectionSetupHeader [class]
    module.add_class('RrcConnectionSetupHeader', parent=root_module['ns3::RrcDlCcchMessage'])
    ## lte-enb-net-device.h (module 'lte'): ns3::LteEnbNetDevice [class]
    module.add_class('LteEnbNetDevice', parent=root_module['ns3::LteNetDevice'])
    module.add_container('std::vector< ns3::CeBitmap_e >', 'ns3::CeBitmap_e', container_type='vector')
    module.add_container('std::vector< std::vector< ns3::RlcPduListElement_s > >', 'std::vector< ns3::RlcPduListElement_s >', container_type='vector')
    module.add_container('std::vector< unsigned char >', 'unsigned char', container_type='vector')
    module.add_container('std::vector< unsigned short >', 'short unsigned int', container_type='vector')
    module.add_container('std::vector< ns3::DlInfoListElement_s::HarqStatus_e >', 'ns3::DlInfoListElement_s::HarqStatus_e', container_type='vector')
    module.add_container('std::list< ns3::EpcEnbS1SapProvider::BearerToBeSwitched >', 'ns3::EpcEnbS1SapProvider::BearerToBeSwitched', container_type='list')
    module.add_container('std::list< ns3::EpcS11SapMme::BearerContextCreated >', 'ns3::EpcS11SapMme::BearerContextCreated', container_type='list')
    module.add_container('std::list< ns3::EpcS11SapMme::BearerContextRemoved >', 'ns3::EpcS11SapMme::BearerContextRemoved', container_type='list')
    module.add_container('std::list< ns3::EpcS11SapSgw::BearerContextToBeCreated >', 'ns3::EpcS11SapSgw::BearerContextToBeCreated', container_type='list')
    module.add_container('std::list< ns3::EpcS11SapSgw::BearerContextToBeRemoved >', 'ns3::EpcS11SapSgw::BearerContextToBeRemoved', container_type='list')
    module.add_container('std::list< ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw >', 'ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw', container_type='list')
    module.add_container('std::list< ns3::EpcS1apSapEnb::ErabToBeSetupItem >', 'ns3::EpcS1apSapEnb::ErabToBeSetupItem', container_type='list')
    module.add_container('std::list< ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem >', 'ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem', container_type='list')
    module.add_container('std::list< ns3::EpcS1apSapMme::ErabToBeReleasedIndication >', 'ns3::EpcS1apSapMme::ErabToBeReleasedIndication', container_type='list')
    module.add_container('std::list< ns3::EpcS1apSapMme::ErabSetupItem >', 'ns3::EpcS1apSapMme::ErabSetupItem', container_type='list')
    module.add_container('std::list< ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem >', 'ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem', container_type='list')
    module.add_container('std::vector< bool >', 'bool', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::UlInterferenceOverloadIndicationItem >', 'ns3::EpcX2Sap::UlInterferenceOverloadIndicationItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::UlHighInterferenceInformationItem >', 'ns3::EpcX2Sap::UlHighInterferenceInformationItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::ErabToBeSetupItem >', 'ns3::EpcX2Sap::ErabToBeSetupItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::ErabAdmittedItem >', 'ns3::EpcX2Sap::ErabAdmittedItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::ErabNotAdmittedItem >', 'ns3::EpcX2Sap::ErabNotAdmittedItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem >', 'ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::CellInformationItem >', 'ns3::EpcX2Sap::CellInformationItem', container_type='vector')
    module.add_container('std::vector< ns3::EpcX2Sap::CellMeasurementResultItem >', 'ns3::EpcX2Sap::CellMeasurementResultItem', container_type='vector')
    module.add_container('std::vector< ns3::VendorSpecificListElement_s >', 'ns3::VendorSpecificListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::LogicalChannelConfigListElement_s >', 'ns3::LogicalChannelConfigListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::PagingInfoListElement_s >', 'ns3::PagingInfoListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::DlInfoListElement_s >', 'ns3::DlInfoListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::RachListElement_s >', 'ns3::RachListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::CqiListElement_s >', 'ns3::CqiListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::UlInfoListElement_s >', 'ns3::UlInfoListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::SrListElement_s >', 'ns3::SrListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::MacCeListElement_s >', 'ns3::MacCeListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::BuildDataListElement_s >', 'ns3::BuildDataListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::BuildRarListElement_s >', 'ns3::BuildRarListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::BuildBroadcastListElement_s >', 'ns3::BuildBroadcastListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::UlDciListElement_s >', 'ns3::UlDciListElement_s', container_type='vector')
    module.add_container('std::vector< ns3::PhichListElement_s >', 'ns3::PhichListElement_s', container_type='vector')
    module.add_container('std::list< ns3::EpcTft::PacketFilter >', 'ns3::EpcTft::PacketFilter', container_type='list')
    module.add_container('std::map< std::string, ns3::LogComponent * >', ('std::string', 'ns3::LogComponent *'), container_type='map')
    module.add_container('std::vector< ns3::LteCcmRrcSapProvider::LcsConfig >', 'ns3::LteCcmRrcSapProvider::LcsConfig', container_type='vector')
    module.add_container('std::vector< ns3::LteRrcSap::LogicalChannelConfig >', 'ns3::LteRrcSap::LogicalChannelConfig', container_type='vector')
    module.add_container('std::map< unsigned short, std::vector< double > >', ('short unsigned int', 'std::vector< double >'), container_type='map')
    module.add_container('std::vector< int >', 'int', container_type='vector')
    module.add_container('ns3::HarqProcessInfoList_t', 'ns3::HarqProcessInfoElement_t', container_type='vector')
    module.add_container('std::list< ns3::LteRrcSap::SrbToAddMod >', 'ns3::LteRrcSap::SrbToAddMod', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::DrbToAddMod >', 'ns3::LteRrcSap::DrbToAddMod', container_type='list')
    module.add_container('std::list< unsigned char >', 'unsigned char', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::CellsToAddMod >', 'ns3::LteRrcSap::CellsToAddMod', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::BlackCellsToAddMod >', 'ns3::LteRrcSap::BlackCellsToAddMod', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::MeasObjectToAddMod >', 'ns3::LteRrcSap::MeasObjectToAddMod', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::ReportConfigToAddMod >', 'ns3::LteRrcSap::ReportConfigToAddMod', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::MeasIdToAddMod >', 'ns3::LteRrcSap::MeasIdToAddMod', container_type='list')
    module.add_container('std::list< unsigned int >', 'unsigned int', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::MeasResultScell >', 'ns3::LteRrcSap::MeasResultScell', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::MeasResultBestNeighCell >', 'ns3::LteRrcSap::MeasResultBestNeighCell', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::MeasResultEutra >', 'ns3::LteRrcSap::MeasResultEutra', container_type='list')
    module.add_container('std::list< ns3::LteRrcSap::SCellToAddMod >', 'ns3::LteRrcSap::SCellToAddMod', container_type='list')
    module.add_container('std::map< int, double >', ('int', 'double'), container_type='map')
    module.add_container('std::vector< ns3::LteUeCcmRrcSapProvider::LcsConfig >', 'ns3::LteUeCcmRrcSapProvider::LcsConfig', container_type='vector')
    module.add_container('std::vector< ns3::LteUeCphySapUser::UeMeasurementsElement >', 'ns3::LteUeCphySapUser::UeMeasurementsElement', container_type='vector')
    module.add_container('std::vector< ns3::HigherLayerSelected_s >', 'ns3::HigherLayerSelected_s', container_type='vector')
    module.add_container('std::vector< ns3::SiMessageListElement_s >', 'ns3::SiMessageListElement_s', container_type='vector')
    module.add_container('std::list< ns3::Ptr< ns3::Packet > >', 'ns3::Ptr< ns3::Packet >', container_type='list')
    module.add_container('std::vector< ns3::Ipv6Address >', 'ns3::Ipv6Address', container_type='vector')
    module.add_container('std::vector< double >', 'double', container_type='vector')
    module.add_container('ns3::Bands', 'ns3::BandInfo', container_type='vector')
    module.add_container('std::map< unsigned char, ns3::ComponentCarrier >', ('unsigned char', 'ns3::ComponentCarrier'), container_type='map')
    module.add_container('std::list< ns3::GtpcModifyBearerRequestMessage::BearerContextToBeModified >', 'ns3::GtpcModifyBearerRequestMessage::BearerContextToBeModified', container_type='list')
    module.add_container('std::map< unsigned int, unsigned int >', ('unsigned int', 'unsigned int'), container_type='map')
    module.add_container('std::map< unsigned char, ns3::Ptr< ns3::ComponentCarrierBaseStation > >', ('unsigned char', 'ns3::Ptr< ns3::ComponentCarrierBaseStation >'), container_type='map')
    module.add_container('std::list< ns3::Ptr< ns3::LteControlMessage > >', 'ns3::Ptr< ns3::LteControlMessage >', container_type='list')
    module.add_container('std::list< ns3::GtpcCreateSessionRequestMessage::BearerContextToBeCreated >', 'ns3::GtpcCreateSessionRequestMessage::BearerContextToBeCreated', container_type='list')
    module.add_container('std::list< ns3::GtpcCreateSessionResponseMessage::BearerContextCreated >', 'ns3::GtpcCreateSessionResponseMessage::BearerContextCreated', container_type='list')
    module.add_container('std::list< ns3::GtpcDeleteBearerCommandMessage::BearerContext >', 'ns3::GtpcDeleteBearerCommandMessage::BearerContext', container_type='list')
    module.add_container('std::list< ns3::UlDciLteControlMessage >', 'ns3::UlDciLteControlMessage', container_type='list')
    module.add_container('std::map< unsigned char, ns3::Ptr< ns3::ComponentCarrierUe > >', ('unsigned char', 'ns3::Ptr< ns3::ComponentCarrierUe >'), container_type='map')
    typehandlers.add_type_alias('std::vector< unsigned char >', 'ns3::DlHarqProcessesStatus_t')
    typehandlers.add_type_alias('std::vector< unsigned char >*', 'ns3::DlHarqProcessesStatus_t*')
    typehandlers.add_type_alias('std::vector< unsigned char >&', 'ns3::DlHarqProcessesStatus_t&')
    typehandlers.add_type_alias('std::vector< unsigned char >', 'ns3::DlHarqProcessesTimer_t')
    typehandlers.add_type_alias('std::vector< unsigned char >*', 'ns3::DlHarqProcessesTimer_t*')
    typehandlers.add_type_alias('std::vector< unsigned char >&', 'ns3::DlHarqProcessesTimer_t&')
    typehandlers.add_type_alias('std::vector< ns3::DlDciListElement_s >', 'ns3::DlHarqProcessesDciBuffer_t')
    typehandlers.add_type_alias('std::vector< ns3::DlDciListElement_s >*', 'ns3::DlHarqProcessesDciBuffer_t*')
    typehandlers.add_type_alias('std::vector< ns3::DlDciListElement_s >&', 'ns3::DlHarqProcessesDciBuffer_t&')
    typehandlers.add_type_alias('std::vector< std::vector< ns3::RlcPduListElement_s > >', 'ns3::RlcPduList_t')
    typehandlers.add_type_alias('std::vector< std::vector< ns3::RlcPduListElement_s > >*', 'ns3::RlcPduList_t*')
    typehandlers.add_type_alias('std::vector< std::vector< ns3::RlcPduListElement_s > >&', 'ns3::RlcPduList_t&')
    typehandlers.add_type_alias('std::vector< std::vector< std::vector< ns3::RlcPduListElement_s > > >', 'ns3::DlHarqRlcPduListBuffer_t')
    typehandlers.add_type_alias('std::vector< std::vector< std::vector< ns3::RlcPduListElement_s > > >*', 'ns3::DlHarqRlcPduListBuffer_t*')
    typehandlers.add_type_alias('std::vector< std::vector< std::vector< ns3::RlcPduListElement_s > > >&', 'ns3::DlHarqRlcPduListBuffer_t&')
    typehandlers.add_type_alias('std::vector< ns3::UlDciListElement_s >', 'ns3::UlHarqProcessesDciBuffer_t')
    typehandlers.add_type_alias('std::vector< ns3::UlDciListElement_s >*', 'ns3::UlHarqProcessesDciBuffer_t*')
    typehandlers.add_type_alias('std::vector< ns3::UlDciListElement_s >&', 'ns3::UlHarqProcessesDciBuffer_t&')
    typehandlers.add_type_alias('std::vector< unsigned char >', 'ns3::UlHarqProcessesStatus_t')
    typehandlers.add_type_alias('std::vector< unsigned char >*', 'ns3::UlHarqProcessesStatus_t*')
    typehandlers.add_type_alias('std::vector< unsigned char >&', 'ns3::UlHarqProcessesStatus_t&')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, unsigned int >', 'ns3::Uint32Map')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, unsigned int >*', 'ns3::Uint32Map*')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, unsigned int >&', 'ns3::Uint32Map&')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, unsigned long long >', 'ns3::Uint64Map')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, unsigned long long >*', 'ns3::Uint64Map*')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, unsigned long long >&', 'ns3::Uint64Map&')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::Ptr< ns3::MinMaxAvgTotalCalculator< unsigned int > > >', 'ns3::Uint32StatsMap')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::Ptr< ns3::MinMaxAvgTotalCalculator< unsigned int > > >*', 'ns3::Uint32StatsMap*')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::Ptr< ns3::MinMaxAvgTotalCalculator< unsigned int > > >&', 'ns3::Uint32StatsMap&')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::Ptr< ns3::MinMaxAvgTotalCalculator< unsigned long long > > >', 'ns3::Uint64StatsMap')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::Ptr< ns3::MinMaxAvgTotalCalculator< unsigned long long > > >*', 'ns3::Uint64StatsMap*')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::Ptr< ns3::MinMaxAvgTotalCalculator< unsigned long long > > >&', 'ns3::Uint64StatsMap&')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, double >', 'ns3::DoubleMap')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, double >*', 'ns3::DoubleMap*')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, double >&', 'ns3::DoubleMap&')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::LteFlowId_t >', 'ns3::FlowIdMap')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::LteFlowId_t >*', 'ns3::FlowIdMap*')
    typehandlers.add_type_alias('std::map< ns3::ImsiLcidPair_t, ns3::LteFlowId_t >&', 'ns3::FlowIdMap&')
    typehandlers.add_type_alias('std::vector< std::vector< ns3::Ptr< ns3::PacketBurst > > >', 'ns3::DlHarqProcessesBuffer_t')
    typehandlers.add_type_alias('std::vector< std::vector< ns3::Ptr< ns3::PacketBurst > > >*', 'ns3::DlHarqProcessesBuffer_t*')
    typehandlers.add_type_alias('std::vector< std::vector< ns3::Ptr< ns3::PacketBurst > > >&', 'ns3::DlHarqProcessesBuffer_t&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::SpectrumValue const &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LteChunkProcessorCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::SpectrumValue const &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LteChunkProcessorCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::SpectrumValue const &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LteChunkProcessorCallback&')
    typehandlers.add_type_alias('std::map< ns3::TbId_t, ns3::tbInfo_t >', 'ns3::expectedTbs_t')
    typehandlers.add_type_alias('std::map< ns3::TbId_t, ns3::tbInfo_t >*', 'ns3::expectedTbs_t*')
    typehandlers.add_type_alias('std::map< ns3::TbId_t, ns3::tbInfo_t >&', 'ns3::expectedTbs_t&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyRxDataEndErrorCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyRxDataEndErrorCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyRxDataEndErrorCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyRxDataEndOkCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyRxDataEndOkCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyRxDataEndOkCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, std::list< ns3::Ptr< ns3::LteControlMessage > >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyRxCtrlEndOkCallback')
    typehandlers.add_type_alias('ns3::Callback< void, std::list< ns3::Ptr< ns3::LteControlMessage > >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyRxCtrlEndOkCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, std::list< ns3::Ptr< ns3::LteControlMessage > >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyRxCtrlEndOkCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyRxCtrlEndErrorCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyRxCtrlEndErrorCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyRxCtrlEndErrorCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, unsigned short, ns3::Ptr< ns3::SpectrumValue >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyRxPssCallback')
    typehandlers.add_type_alias('ns3::Callback< void, unsigned short, ns3::Ptr< ns3::SpectrumValue >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyRxPssCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, unsigned short, ns3::Ptr< ns3::SpectrumValue >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyRxPssCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::DlInfoListElement_s, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyDlHarqFeedbackCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::DlInfoListElement_s, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyDlHarqFeedbackCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::DlInfoListElement_s, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyDlHarqFeedbackCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::UlInfoListElement_s, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::LtePhyUlHarqFeedbackCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::UlInfoListElement_s, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::LtePhyUlHarqFeedbackCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::UlInfoListElement_s, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::LtePhyUlHarqFeedbackCallback&')
    typehandlers.add_type_alias('std::vector< ns3::HarqProcessInfoElement_t >', 'ns3::HarqProcessInfoList_t')
    typehandlers.add_type_alias('std::vector< ns3::HarqProcessInfoElement_t >*', 'ns3::HarqProcessInfoList_t*')
    typehandlers.add_type_alias('std::vector< ns3::HarqProcessInfoElement_t >&', 'ns3::HarqProcessInfoList_t&')
    typehandlers.add_type_alias('void ( * ) ( std::ostream & )', 'ns3::TimePrinter')
    typehandlers.add_type_alias('void ( * ) ( std::ostream & )*', 'ns3::TimePrinter*')
    typehandlers.add_type_alias('void ( * ) ( std::ostream & )&', 'ns3::TimePrinter&')
    typehandlers.add_type_alias('void ( * ) ( std::ostream & )', 'ns3::NodePrinter')
    typehandlers.add_type_alias('void ( * ) ( std::ostream & )*', 'ns3::NodePrinter*')
    typehandlers.add_type_alias('void ( * ) ( std::ostream & )&', 'ns3::NodePrinter&')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::GenericPhyTxStartCallback')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::GenericPhyTxStartCallback*')
    typehandlers.add_type_alias('ns3::Callback< bool, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::GenericPhyTxStartCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet const >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::GenericPhyTxEndCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet const >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::GenericPhyTxEndCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet const >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::GenericPhyTxEndCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::GenericPhyRxStartCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::GenericPhyRxStartCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::GenericPhyRxStartCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::GenericPhyRxEndErrorCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::GenericPhyRxEndErrorCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::GenericPhyRxEndErrorCallback&')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 'ns3::GenericPhyRxEndOkCallback')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >*', 'ns3::GenericPhyRxEndOkCallback*')
    typehandlers.add_type_alias('ns3::Callback< void, ns3::Ptr< ns3::Packet >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >&', 'ns3::GenericPhyRxEndOkCallback&')
    typehandlers.add_type_alias('ns3::Vector3D', 'ns3::Vector')
    typehandlers.add_type_alias('ns3::Vector3D*', 'ns3::Vector*')
    typehandlers.add_type_alias('ns3::Vector3D&', 'ns3::Vector&')
    module.add_typedef(root_module['ns3::Vector3D'], 'Vector')
    typehandlers.add_type_alias('ns3::Vector3DValue', 'ns3::VectorValue')
    typehandlers.add_type_alias('ns3::Vector3DValue*', 'ns3::VectorValue*')
    typehandlers.add_type_alias('ns3::Vector3DValue&', 'ns3::VectorValue&')
    module.add_typedef(root_module['ns3::Vector3DValue'], 'VectorValue')
    typehandlers.add_type_alias('ns3::Vector3DChecker', 'ns3::VectorChecker')
    typehandlers.add_type_alias('ns3::Vector3DChecker*', 'ns3::VectorChecker*')
    typehandlers.add_type_alias('ns3::Vector3DChecker&', 'ns3::VectorChecker&')
    module.add_typedef(root_module['ns3::Vector3DChecker'], 'VectorChecker')
    typehandlers.add_type_alias('std::vector< double >', 'ns3::Values')
    typehandlers.add_type_alias('std::vector< double >*', 'ns3::Values*')
    typehandlers.add_type_alias('std::vector< double >&', 'ns3::Values&')
    typehandlers.add_type_alias('std::vector< ns3::BandInfo >', 'ns3::Bands')
    typehandlers.add_type_alias('std::vector< ns3::BandInfo >*', 'ns3::Bands*')
    typehandlers.add_type_alias('std::vector< ns3::BandInfo >&', 'ns3::Bands&')
    typehandlers.add_type_alias('uint32_t', 'ns3::SpectrumModelUid_t')
    typehandlers.add_type_alias('uint32_t*', 'ns3::SpectrumModelUid_t*')
    typehandlers.add_type_alias('uint32_t&', 'ns3::SpectrumModelUid_t&')
    
    ## Register a nested module for the namespace Config
    
    nested_module = module.add_cpp_namespace('Config')
    register_types_ns3_Config(nested_module)
    
    
    ## Register a nested module for the namespace FatalImpl
    
    nested_module = module.add_cpp_namespace('FatalImpl')
    register_types_ns3_FatalImpl(nested_module)
    
    
    ## Register a nested module for the namespace Hash
    
    nested_module = module.add_cpp_namespace('Hash')
    register_types_ns3_Hash(nested_module)
    
    
    ## Register a nested module for the namespace TracedValueCallback
    
    nested_module = module.add_cpp_namespace('TracedValueCallback')
    register_types_ns3_TracedValueCallback(nested_module)
    
    
    ## Register a nested module for the namespace internal
    
    nested_module = module.add_cpp_namespace('internal')
    register_types_ns3_internal(nested_module)
    

def register_types_ns3_Config(module):
    root_module = module.get_root()
    
    ## config.h (module 'core'): ns3::Config::MatchContainer [class]
    module.add_class('MatchContainer', import_from_module='ns.core')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::Object > > const_iterator', 'ns3::Config::MatchContainer::Iterator')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::Object > > const_iterator*', 'ns3::Config::MatchContainer::Iterator*')
    typehandlers.add_type_alias('std::vector< ns3::Ptr< ns3::Object > > const_iterator&', 'ns3::Config::MatchContainer::Iterator&')
    module.add_container('std::vector< ns3::Ptr< ns3::Object > >', 'ns3::Ptr< ns3::Object >', container_type='vector')
    module.add_container('std::vector< std::string >', 'std::string', container_type='vector')

def register_types_ns3_FatalImpl(module):
    root_module = module.get_root()
    

def register_types_ns3_Hash(module):
    root_module = module.get_root()
    
    ## hash-function.h (module 'core'): ns3::Hash::Implementation [class]
    module.add_class('Implementation', import_from_module='ns.core', parent=root_module['ns3::SimpleRefCount< ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter<ns3::Hash::Implementation> >'])
    typehandlers.add_type_alias('uint32_t ( * ) ( char const *, std::size_t const )', 'ns3::Hash::Hash32Function_ptr')
    typehandlers.add_type_alias('uint32_t ( * ) ( char const *, std::size_t const )*', 'ns3::Hash::Hash32Function_ptr*')
    typehandlers.add_type_alias('uint32_t ( * ) ( char const *, std::size_t const )&', 'ns3::Hash::Hash32Function_ptr&')
    typehandlers.add_type_alias('uint64_t ( * ) ( char const *, std::size_t const )', 'ns3::Hash::Hash64Function_ptr')
    typehandlers.add_type_alias('uint64_t ( * ) ( char const *, std::size_t const )*', 'ns3::Hash::Hash64Function_ptr*')
    typehandlers.add_type_alias('uint64_t ( * ) ( char const *, std::size_t const )&', 'ns3::Hash::Hash64Function_ptr&')
    
    ## Register a nested module for the namespace Function
    
    nested_module = module.add_cpp_namespace('Function')
    register_types_ns3_Hash_Function(nested_module)
    

def register_types_ns3_Hash_Function(module):
    root_module = module.get_root()
    
    ## hash-fnv.h (module 'core'): ns3::Hash::Function::Fnv1a [class]
    module.add_class('Fnv1a', import_from_module='ns.core', parent=root_module['ns3::Hash::Implementation'])
    ## hash-function.h (module 'core'): ns3::Hash::Function::Hash32 [class]
    module.add_class('Hash32', import_from_module='ns.core', parent=root_module['ns3::Hash::Implementation'])
    ## hash-function.h (module 'core'): ns3::Hash::Function::Hash64 [class]
    module.add_class('Hash64', import_from_module='ns.core', parent=root_module['ns3::Hash::Implementation'])
    ## hash-murmur3.h (module 'core'): ns3::Hash::Function::Murmur3 [class]
    module.add_class('Murmur3', import_from_module='ns.core', parent=root_module['ns3::Hash::Implementation'])

def register_types_ns3_TracedValueCallback(module):
    root_module = module.get_root()
    
    typehandlers.add_type_alias('void ( * ) ( ns3::Time, ns3::Time )', 'ns3::TracedValueCallback::Time')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time, ns3::Time )*', 'ns3::TracedValueCallback::Time*')
    typehandlers.add_type_alias('void ( * ) ( ns3::Time, ns3::Time )&', 'ns3::TracedValueCallback::Time&')
    typehandlers.add_type_alias('void ( * ) ( bool, bool )', 'ns3::TracedValueCallback::Bool')
    typehandlers.add_type_alias('void ( * ) ( bool, bool )*', 'ns3::TracedValueCallback::Bool*')
    typehandlers.add_type_alias('void ( * ) ( bool, bool )&', 'ns3::TracedValueCallback::Bool&')
    typehandlers.add_type_alias('void ( * ) ( int8_t, int8_t )', 'ns3::TracedValueCallback::Int8')
    typehandlers.add_type_alias('void ( * ) ( int8_t, int8_t )*', 'ns3::TracedValueCallback::Int8*')
    typehandlers.add_type_alias('void ( * ) ( int8_t, int8_t )&', 'ns3::TracedValueCallback::Int8&')
    typehandlers.add_type_alias('void ( * ) ( uint8_t, uint8_t )', 'ns3::TracedValueCallback::Uint8')
    typehandlers.add_type_alias('void ( * ) ( uint8_t, uint8_t )*', 'ns3::TracedValueCallback::Uint8*')
    typehandlers.add_type_alias('void ( * ) ( uint8_t, uint8_t )&', 'ns3::TracedValueCallback::Uint8&')
    typehandlers.add_type_alias('void ( * ) ( int16_t, int16_t )', 'ns3::TracedValueCallback::Int16')
    typehandlers.add_type_alias('void ( * ) ( int16_t, int16_t )*', 'ns3::TracedValueCallback::Int16*')
    typehandlers.add_type_alias('void ( * ) ( int16_t, int16_t )&', 'ns3::TracedValueCallback::Int16&')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t )', 'ns3::TracedValueCallback::Uint16')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t )*', 'ns3::TracedValueCallback::Uint16*')
    typehandlers.add_type_alias('void ( * ) ( uint16_t, uint16_t )&', 'ns3::TracedValueCallback::Uint16&')
    typehandlers.add_type_alias('void ( * ) ( int32_t, int32_t )', 'ns3::TracedValueCallback::Int32')
    typehandlers.add_type_alias('void ( * ) ( int32_t, int32_t )*', 'ns3::TracedValueCallback::Int32*')
    typehandlers.add_type_alias('void ( * ) ( int32_t, int32_t )&', 'ns3::TracedValueCallback::Int32&')
    typehandlers.add_type_alias('void ( * ) ( uint32_t, uint32_t )', 'ns3::TracedValueCallback::Uint32')
    typehandlers.add_type_alias('void ( * ) ( uint32_t, uint32_t )*', 'ns3::TracedValueCallback::Uint32*')
    typehandlers.add_type_alias('void ( * ) ( uint32_t, uint32_t )&', 'ns3::TracedValueCallback::Uint32&')
    typehandlers.add_type_alias('void ( * ) ( double, double )', 'ns3::TracedValueCallback::Double')
    typehandlers.add_type_alias('void ( * ) ( double, double )*', 'ns3::TracedValueCallback::Double*')
    typehandlers.add_type_alias('void ( * ) ( double, double )&', 'ns3::TracedValueCallback::Double&')
    typehandlers.add_type_alias('void ( * ) (  )', 'ns3::TracedValueCallback::Void')
    typehandlers.add_type_alias('void ( * ) (  )*', 'ns3::TracedValueCallback::Void*')
    typehandlers.add_type_alias('void ( * ) (  )&', 'ns3::TracedValueCallback::Void&')

def register_types_ns3_internal(module):
    root_module = module.get_root()
    

def register_methods(root_module):
    register_Ns3Address_methods(root_module, root_module['ns3::Address'])
    register_Ns3AllocationRetentionPriority_methods(root_module, root_module['ns3::AllocationRetentionPriority'])
    register_Ns3AttributeConstructionList_methods(root_module, root_module['ns3::AttributeConstructionList'])
    register_Ns3AttributeConstructionListItem_methods(root_module, root_module['ns3::AttributeConstructionList::Item'])
    register_Ns3BandInfo_methods(root_module, root_module['ns3::BandInfo'])
    register_Ns3Buffer_methods(root_module, root_module['ns3::Buffer'])
    register_Ns3BufferIterator_methods(root_module, root_module['ns3::Buffer::Iterator'])
    register_Ns3BufferSizeLevelBsr_methods(root_module, root_module['ns3::BufferSizeLevelBsr'])
    register_Ns3BuildBroadcastListElement_s_methods(root_module, root_module['ns3::BuildBroadcastListElement_s'])
    register_Ns3BuildDataListElement_s_methods(root_module, root_module['ns3::BuildDataListElement_s'])
    register_Ns3BuildRarListElement_s_methods(root_module, root_module['ns3::BuildRarListElement_s'])
    register_Ns3BwPart_s_methods(root_module, root_module['ns3::BwPart_s'])
    register_Ns3ByteTagIterator_methods(root_module, root_module['ns3::ByteTagIterator'])
    register_Ns3ByteTagIteratorItem_methods(root_module, root_module['ns3::ByteTagIterator::Item'])
    register_Ns3ByteTagList_methods(root_module, root_module['ns3::ByteTagList'])
    register_Ns3ByteTagListIterator_methods(root_module, root_module['ns3::ByteTagList::Iterator'])
    register_Ns3ByteTagListIteratorItem_methods(root_module, root_module['ns3::ByteTagList::Iterator::Item'])
    register_Ns3CallbackBase_methods(root_module, root_module['ns3::CallbackBase'])
    register_Ns3CqasFlowPerf_t_methods(root_module, root_module['ns3::CqasFlowPerf_t'])
    register_Ns3CqiConfig_s_methods(root_module, root_module['ns3::CqiConfig_s'])
    register_Ns3CqiListElement_s_methods(root_module, root_module['ns3::CqiListElement_s'])
    register_Ns3DataOutputCallback_methods(root_module, root_module['ns3::DataOutputCallback'])
    register_Ns3DataRate_methods(root_module, root_module['ns3::DataRate'])
    register_Ns3DefaultDeleter__Ns3AttributeAccessor_methods(root_module, root_module['ns3::DefaultDeleter< ns3::AttributeAccessor >'])
    register_Ns3DefaultDeleter__Ns3AttributeChecker_methods(root_module, root_module['ns3::DefaultDeleter< ns3::AttributeChecker >'])
    register_Ns3DefaultDeleter__Ns3AttributeValue_methods(root_module, root_module['ns3::DefaultDeleter< ns3::AttributeValue >'])
    register_Ns3DefaultDeleter__Ns3CallbackImplBase_methods(root_module, root_module['ns3::DefaultDeleter< ns3::CallbackImplBase >'])
    register_Ns3DefaultDeleter__Ns3EpcTft_methods(root_module, root_module['ns3::DefaultDeleter< ns3::EpcTft >'])
    register_Ns3DefaultDeleter__Ns3EventImpl_methods(root_module, root_module['ns3::DefaultDeleter< ns3::EventImpl >'])
    register_Ns3DefaultDeleter__Ns3HashImplementation_methods(root_module, root_module['ns3::DefaultDeleter< ns3::Hash::Implementation >'])
    register_Ns3DefaultDeleter__Ns3LteChunkProcessor_methods(root_module, root_module['ns3::DefaultDeleter< ns3::LteChunkProcessor >'])
    register_Ns3DefaultDeleter__Ns3LteControlMessage_methods(root_module, root_module['ns3::DefaultDeleter< ns3::LteControlMessage >'])
    register_Ns3DefaultDeleter__Ns3LteHarqPhy_methods(root_module, root_module['ns3::DefaultDeleter< ns3::LteHarqPhy >'])
    register_Ns3DefaultDeleter__Ns3NixVector_methods(root_module, root_module['ns3::DefaultDeleter< ns3::NixVector >'])
    register_Ns3DefaultDeleter__Ns3Packet_methods(root_module, root_module['ns3::DefaultDeleter< ns3::Packet >'])
    register_Ns3DefaultDeleter__Ns3SpectrumModel_methods(root_module, root_module['ns3::DefaultDeleter< ns3::SpectrumModel >'])
    register_Ns3DefaultDeleter__Ns3SpectrumSignalParameters_methods(root_module, root_module['ns3::DefaultDeleter< ns3::SpectrumSignalParameters >'])
    register_Ns3DefaultDeleter__Ns3SpectrumValue_methods(root_module, root_module['ns3::DefaultDeleter< ns3::SpectrumValue >'])
    register_Ns3DefaultDeleter__Ns3TraceSourceAccessor_methods(root_module, root_module['ns3::DefaultDeleter< ns3::TraceSourceAccessor >'])
    register_Ns3DefaultDeleter__Ns3VendorSpecificValue_methods(root_module, root_module['ns3::DefaultDeleter< ns3::VendorSpecificValue >'])
    register_Ns3DefaultDeleter__Ns3X2CellInfo_methods(root_module, root_module['ns3::DefaultDeleter< ns3::X2CellInfo >'])
    register_Ns3DefaultDeleter__Ns3X2IfaceInfo_methods(root_module, root_module['ns3::DefaultDeleter< ns3::X2IfaceInfo >'])
    register_Ns3DlDciListElement_s_methods(root_module, root_module['ns3::DlDciListElement_s'])
    register_Ns3DlInfoListElement_s_methods(root_module, root_module['ns3::DlInfoListElement_s'])
    register_Ns3DlSchedulingCallbackInfo_methods(root_module, root_module['ns3::DlSchedulingCallbackInfo'])
    register_Ns3DrxConfig_s_methods(root_module, root_module['ns3::DrxConfig_s'])
    register_Ns3EpcEnbS1SapProvider_methods(root_module, root_module['ns3::EpcEnbS1SapProvider'])
    register_Ns3EpcEnbS1SapProviderBearerToBeSwitched_methods(root_module, root_module['ns3::EpcEnbS1SapProvider::BearerToBeSwitched'])
    register_Ns3EpcEnbS1SapProviderPathSwitchRequestParameters_methods(root_module, root_module['ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters'])
    register_Ns3EpcEnbS1SapUser_methods(root_module, root_module['ns3::EpcEnbS1SapUser'])
    register_Ns3EpcEnbS1SapUserDataRadioBearerSetupRequestParameters_methods(root_module, root_module['ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters'])
    register_Ns3EpcEnbS1SapUserInitialContextSetupRequestParameters_methods(root_module, root_module['ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters'])
    register_Ns3EpcEnbS1SapUserPathSwitchRequestAcknowledgeParameters_methods(root_module, root_module['ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters'])
    register_Ns3EpcS11Sap_methods(root_module, root_module['ns3::EpcS11Sap'])
    register_Ns3EpcS11SapFteid_methods(root_module, root_module['ns3::EpcS11Sap::Fteid'])
    register_Ns3EpcS11SapGtpcMessage_methods(root_module, root_module['ns3::EpcS11Sap::GtpcMessage'])
    register_Ns3EpcS11SapUli_methods(root_module, root_module['ns3::EpcS11Sap::Uli'])
    register_Ns3EpcS11SapMme_methods(root_module, root_module['ns3::EpcS11SapMme'])
    register_Ns3EpcS11SapMmeBearerContextCreated_methods(root_module, root_module['ns3::EpcS11SapMme::BearerContextCreated'])
    register_Ns3EpcS11SapMmeBearerContextRemoved_methods(root_module, root_module['ns3::EpcS11SapMme::BearerContextRemoved'])
    register_Ns3EpcS11SapMmeCreateSessionResponseMessage_methods(root_module, root_module['ns3::EpcS11SapMme::CreateSessionResponseMessage'])
    register_Ns3EpcS11SapMmeDeleteBearerRequestMessage_methods(root_module, root_module['ns3::EpcS11SapMme::DeleteBearerRequestMessage'])
    register_Ns3EpcS11SapMmeModifyBearerResponseMessage_methods(root_module, root_module['ns3::EpcS11SapMme::ModifyBearerResponseMessage'])
    register_Ns3EpcS11SapSgw_methods(root_module, root_module['ns3::EpcS11SapSgw'])
    register_Ns3EpcS11SapSgwBearerContextRemovedSgwPgw_methods(root_module, root_module['ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw'])
    register_Ns3EpcS11SapSgwBearerContextToBeCreated_methods(root_module, root_module['ns3::EpcS11SapSgw::BearerContextToBeCreated'])
    register_Ns3EpcS11SapSgwBearerContextToBeRemoved_methods(root_module, root_module['ns3::EpcS11SapSgw::BearerContextToBeRemoved'])
    register_Ns3EpcS11SapSgwCreateSessionRequestMessage_methods(root_module, root_module['ns3::EpcS11SapSgw::CreateSessionRequestMessage'])
    register_Ns3EpcS11SapSgwDeleteBearerCommandMessage_methods(root_module, root_module['ns3::EpcS11SapSgw::DeleteBearerCommandMessage'])
    register_Ns3EpcS11SapSgwDeleteBearerResponseMessage_methods(root_module, root_module['ns3::EpcS11SapSgw::DeleteBearerResponseMessage'])
    register_Ns3EpcS11SapSgwModifyBearerRequestMessage_methods(root_module, root_module['ns3::EpcS11SapSgw::ModifyBearerRequestMessage'])
    register_Ns3EpcS1apSap_methods(root_module, root_module['ns3::EpcS1apSap'])
    register_Ns3EpcS1apSapEnb_methods(root_module, root_module['ns3::EpcS1apSapEnb'])
    register_Ns3EpcS1apSapEnbErabSwitchedInUplinkItem_methods(root_module, root_module['ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem'])
    register_Ns3EpcS1apSapEnbErabToBeSetupItem_methods(root_module, root_module['ns3::EpcS1apSapEnb::ErabToBeSetupItem'])
    register_Ns3EpcS1apSapMme_methods(root_module, root_module['ns3::EpcS1apSapMme'])
    register_Ns3EpcS1apSapMmeErabSetupItem_methods(root_module, root_module['ns3::EpcS1apSapMme::ErabSetupItem'])
    register_Ns3EpcS1apSapMmeErabSwitchedInDownlinkItem_methods(root_module, root_module['ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem'])
    register_Ns3EpcS1apSapMmeErabToBeReleasedIndication_methods(root_module, root_module['ns3::EpcS1apSapMme::ErabToBeReleasedIndication'])
    register_Ns3EpcX2Sap_methods(root_module, root_module['ns3::EpcX2Sap'])
    register_Ns3EpcX2SapCellInformationItem_methods(root_module, root_module['ns3::EpcX2Sap::CellInformationItem'])
    register_Ns3EpcX2SapCellMeasurementResultItem_methods(root_module, root_module['ns3::EpcX2Sap::CellMeasurementResultItem'])
    register_Ns3EpcX2SapCompositeAvailCapacity_methods(root_module, root_module['ns3::EpcX2Sap::CompositeAvailCapacity'])
    register_Ns3EpcX2SapErabAdmittedItem_methods(root_module, root_module['ns3::EpcX2Sap::ErabAdmittedItem'])
    register_Ns3EpcX2SapErabNotAdmittedItem_methods(root_module, root_module['ns3::EpcX2Sap::ErabNotAdmittedItem'])
    register_Ns3EpcX2SapErabToBeSetupItem_methods(root_module, root_module['ns3::EpcX2Sap::ErabToBeSetupItem'])
    register_Ns3EpcX2SapErabsSubjectToStatusTransferItem_methods(root_module, root_module['ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem'])
    register_Ns3EpcX2SapHandoverPreparationFailureParams_methods(root_module, root_module['ns3::EpcX2Sap::HandoverPreparationFailureParams'])
    register_Ns3EpcX2SapHandoverRequestAckParams_methods(root_module, root_module['ns3::EpcX2Sap::HandoverRequestAckParams'])
    register_Ns3EpcX2SapHandoverRequestParams_methods(root_module, root_module['ns3::EpcX2Sap::HandoverRequestParams'])
    register_Ns3EpcX2SapLoadInformationParams_methods(root_module, root_module['ns3::EpcX2Sap::LoadInformationParams'])
    register_Ns3EpcX2SapRelativeNarrowbandTxBand_methods(root_module, root_module['ns3::EpcX2Sap::RelativeNarrowbandTxBand'])
    register_Ns3EpcX2SapResourceStatusUpdateParams_methods(root_module, root_module['ns3::EpcX2Sap::ResourceStatusUpdateParams'])
    register_Ns3EpcX2SapSnStatusTransferParams_methods(root_module, root_module['ns3::EpcX2Sap::SnStatusTransferParams'])
    register_Ns3EpcX2SapUeContextReleaseParams_methods(root_module, root_module['ns3::EpcX2Sap::UeContextReleaseParams'])
    register_Ns3EpcX2SapUeDataParams_methods(root_module, root_module['ns3::EpcX2Sap::UeDataParams'])
    register_Ns3EpcX2SapUlHighInterferenceInformationItem_methods(root_module, root_module['ns3::EpcX2Sap::UlHighInterferenceInformationItem'])
    register_Ns3EpcX2SapProvider_methods(root_module, root_module['ns3::EpcX2SapProvider'])
    register_Ns3EpcX2SapUser_methods(root_module, root_module['ns3::EpcX2SapUser'])
    register_Ns3EutranMeasurementMapping_methods(root_module, root_module['ns3::EutranMeasurementMapping'])
    register_Ns3EventId_methods(root_module, root_module['ns3::EventId'])
    register_Ns3FfMacCschedSapProvider_methods(root_module, root_module['ns3::FfMacCschedSapProvider'])
    register_Ns3FfMacCschedSapProviderCschedCellConfigReqParameters_methods(root_module, root_module['ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters'])
    register_Ns3FfMacCschedSapProviderCschedLcConfigReqParameters_methods(root_module, root_module['ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters'])
    register_Ns3FfMacCschedSapProviderCschedLcReleaseReqParameters_methods(root_module, root_module['ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters'])
    register_Ns3FfMacCschedSapProviderCschedUeConfigReqParameters_methods(root_module, root_module['ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters'])
    register_Ns3FfMacCschedSapProviderCschedUeReleaseReqParameters_methods(root_module, root_module['ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters'])
    register_Ns3FfMacCschedSapUser_methods(root_module, root_module['ns3::FfMacCschedSapUser'])
    register_Ns3FfMacCschedSapUserCschedCellConfigCnfParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters'])
    register_Ns3FfMacCschedSapUserCschedCellConfigUpdateIndParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters'])
    register_Ns3FfMacCschedSapUserCschedLcConfigCnfParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters'])
    register_Ns3FfMacCschedSapUserCschedLcReleaseCnfParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters'])
    register_Ns3FfMacCschedSapUserCschedUeConfigCnfParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters'])
    register_Ns3FfMacCschedSapUserCschedUeConfigUpdateIndParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters'])
    register_Ns3FfMacCschedSapUserCschedUeReleaseCnfParameters_methods(root_module, root_module['ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters'])
    register_Ns3FfMacSchedSapProvider_methods(root_module, root_module['ns3::FfMacSchedSapProvider'])
    register_Ns3FfMacSchedSapProviderSchedDlCqiInfoReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedDlMacBufferReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedDlPagingBufferReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedDlRachInfoReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedDlRlcBufferReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedDlTriggerReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedUlCqiInfoReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedUlMacCtrlInfoReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedUlNoiseInterferenceReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedUlSrInfoReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters'])
    register_Ns3FfMacSchedSapProviderSchedUlTriggerReqParameters_methods(root_module, root_module['ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters'])
    register_Ns3FfMacSchedSapUser_methods(root_module, root_module['ns3::FfMacSchedSapUser'])
    register_Ns3FfMacSchedSapUserSchedDlConfigIndParameters_methods(root_module, root_module['ns3::FfMacSchedSapUser::SchedDlConfigIndParameters'])
    register_Ns3FfMacSchedSapUserSchedUlConfigIndParameters_methods(root_module, root_module['ns3::FfMacSchedSapUser::SchedUlConfigIndParameters'])
    register_Ns3GbrQosInformation_methods(root_module, root_module['ns3::GbrQosInformation'])
    register_Ns3GtpcIes_methods(root_module, root_module['ns3::GtpcIes'])
    register_Ns3HarqProcessInfoElement_t_methods(root_module, root_module['ns3::HarqProcessInfoElement_t'])
    register_Ns3Hasher_methods(root_module, root_module['ns3::Hasher'])
    register_Ns3HigherLayerSelected_s_methods(root_module, root_module['ns3::HigherLayerSelected_s'])
    register_Ns3ImsiLcidPair_t_methods(root_module, root_module['ns3::ImsiLcidPair_t'])
    register_Ns3Inet6SocketAddress_methods(root_module, root_module['ns3::Inet6SocketAddress'])
    register_Ns3InetSocketAddress_methods(root_module, root_module['ns3::InetSocketAddress'])
    register_Ns3Ipv4Address_methods(root_module, root_module['ns3::Ipv4Address'])
    register_Ns3Ipv4AddressHelper_methods(root_module, root_module['ns3::Ipv4AddressHelper'])
    register_Ns3Ipv4InterfaceAddress_methods(root_module, root_module['ns3::Ipv4InterfaceAddress'])
    register_Ns3Ipv4InterfaceContainer_methods(root_module, root_module['ns3::Ipv4InterfaceContainer'])
    register_Ns3Ipv4Mask_methods(root_module, root_module['ns3::Ipv4Mask'])
    register_Ns3Ipv6Address_methods(root_module, root_module['ns3::Ipv6Address'])
    register_Ns3Ipv6AddressHelper_methods(root_module, root_module['ns3::Ipv6AddressHelper'])
    register_Ns3Ipv6InterfaceAddress_methods(root_module, root_module['ns3::Ipv6InterfaceAddress'])
    register_Ns3Ipv6InterfaceContainer_methods(root_module, root_module['ns3::Ipv6InterfaceContainer'])
    register_Ns3Ipv6Prefix_methods(root_module, root_module['ns3::Ipv6Prefix'])
    register_Ns3LogComponent_methods(root_module, root_module['ns3::LogComponent'])
    register_Ns3LogicalChannelConfigListElement_s_methods(root_module, root_module['ns3::LogicalChannelConfigListElement_s'])
    register_Ns3LteAnrSapProvider_methods(root_module, root_module['ns3::LteAnrSapProvider'])
    register_Ns3LteAnrSapUser_methods(root_module, root_module['ns3::LteAnrSapUser'])
    register_Ns3LteAsSapProvider_methods(root_module, root_module['ns3::LteAsSapProvider'])
    register_Ns3LteAsSapUser_methods(root_module, root_module['ns3::LteAsSapUser'])
    register_Ns3LteCcmMacSapProvider_methods(root_module, root_module['ns3::LteCcmMacSapProvider'])
    register_Ns3LteCcmRrcSapProvider_methods(root_module, root_module['ns3::LteCcmRrcSapProvider'])
    register_Ns3LteCcmRrcSapProviderLcsConfig_methods(root_module, root_module['ns3::LteCcmRrcSapProvider::LcsConfig'])
    register_Ns3LteCcmRrcSapUser_methods(root_module, root_module['ns3::LteCcmRrcSapUser'])
    register_Ns3LteEnbCmacSapProvider_methods(root_module, root_module['ns3::LteEnbCmacSapProvider'])
    register_Ns3LteEnbCmacSapProviderAllocateNcRaPreambleReturnValue_methods(root_module, root_module['ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue'])
    register_Ns3LteEnbCmacSapProviderLcInfo_methods(root_module, root_module['ns3::LteEnbCmacSapProvider::LcInfo'])
    register_Ns3LteEnbCmacSapProviderRachConfig_methods(root_module, root_module['ns3::LteEnbCmacSapProvider::RachConfig'])
    register_Ns3LteEnbCmacSapProviderUeConfig_methods(root_module, root_module['ns3::LteEnbCmacSapProvider::UeConfig'])
    register_Ns3LteEnbCmacSapUser_methods(root_module, root_module['ns3::LteEnbCmacSapUser'])
    register_Ns3LteEnbCmacSapUserUeConfig_methods(root_module, root_module['ns3::LteEnbCmacSapUser::UeConfig'])
    register_Ns3LteEnbCphySapProvider_methods(root_module, root_module['ns3::LteEnbCphySapProvider'])
    register_Ns3LteEnbCphySapUser_methods(root_module, root_module['ns3::LteEnbCphySapUser'])
    register_Ns3LteEnbPhySapProvider_methods(root_module, root_module['ns3::LteEnbPhySapProvider'])
    register_Ns3LteEnbPhySapUser_methods(root_module, root_module['ns3::LteEnbPhySapUser'])
    register_Ns3LteFfConverter_methods(root_module, root_module['ns3::LteFfConverter'])
    register_Ns3LteFfrRrcSapProvider_methods(root_module, root_module['ns3::LteFfrRrcSapProvider'])
    register_Ns3LteFfrRrcSapUser_methods(root_module, root_module['ns3::LteFfrRrcSapUser'])
    register_Ns3LteFfrSapProvider_methods(root_module, root_module['ns3::LteFfrSapProvider'])
    register_Ns3LteFfrSapUser_methods(root_module, root_module['ns3::LteFfrSapUser'])
    register_Ns3LteFlowId_t_methods(root_module, root_module['ns3::LteFlowId_t'])
    register_Ns3LteGlobalPathlossDatabase_methods(root_module, root_module['ns3::LteGlobalPathlossDatabase'])
    register_Ns3LteHandoverManagementSapProvider_methods(root_module, root_module['ns3::LteHandoverManagementSapProvider'])
    register_Ns3LteHandoverManagementSapUser_methods(root_module, root_module['ns3::LteHandoverManagementSapUser'])
    register_Ns3LteMacSapProvider_methods(root_module, root_module['ns3::LteMacSapProvider'])
    register_Ns3LteMacSapProviderReportBufferStatusParameters_methods(root_module, root_module['ns3::LteMacSapProvider::ReportBufferStatusParameters'])
    register_Ns3LteMacSapProviderTransmitPduParameters_methods(root_module, root_module['ns3::LteMacSapProvider::TransmitPduParameters'])
    register_Ns3LteMacSapUser_methods(root_module, root_module['ns3::LteMacSapUser'])
    register_Ns3LteMacSapUserReceivePduParameters_methods(root_module, root_module['ns3::LteMacSapUser::ReceivePduParameters'])
    register_Ns3LteMacSapUserTxOpportunityParameters_methods(root_module, root_module['ns3::LteMacSapUser::TxOpportunityParameters'])
    register_Ns3LteMiErrorModel_methods(root_module, root_module['ns3::LteMiErrorModel'])
    register_Ns3LtePdcpSapProvider_methods(root_module, root_module['ns3::LtePdcpSapProvider'])
    register_Ns3LtePdcpSapProviderTransmitPdcpSduParameters_methods(root_module, root_module['ns3::LtePdcpSapProvider::TransmitPdcpSduParameters'])
    register_Ns3LtePdcpSapUser_methods(root_module, root_module['ns3::LtePdcpSapUser'])
    register_Ns3LtePdcpSapUserReceivePdcpSduParameters_methods(root_module, root_module['ns3::LtePdcpSapUser::ReceivePdcpSduParameters'])
    register_Ns3LteRlcSapProvider_methods(root_module, root_module['ns3::LteRlcSapProvider'])
    register_Ns3LteRlcSapProviderTransmitPdcpPduParameters_methods(root_module, root_module['ns3::LteRlcSapProvider::TransmitPdcpPduParameters'])
    register_Ns3LteRlcSapUser_methods(root_module, root_module['ns3::LteRlcSapUser'])
    register_Ns3LteRrcSap_methods(root_module, root_module['ns3::LteRrcSap'])
    register_Ns3LteRrcSapAntennaInfoCommon_methods(root_module, root_module['ns3::LteRrcSap::AntennaInfoCommon'])
    register_Ns3LteRrcSapAntennaInfoDedicated_methods(root_module, root_module['ns3::LteRrcSap::AntennaInfoDedicated'])
    register_Ns3LteRrcSapAntennaInfoUl_methods(root_module, root_module['ns3::LteRrcSap::AntennaInfoUl'])
    register_Ns3LteRrcSapAsConfig_methods(root_module, root_module['ns3::LteRrcSap::AsConfig'])
    register_Ns3LteRrcSapBlackCellsToAddMod_methods(root_module, root_module['ns3::LteRrcSap::BlackCellsToAddMod'])
    register_Ns3LteRrcSapCarrierBandwidthEutra_methods(root_module, root_module['ns3::LteRrcSap::CarrierBandwidthEutra'])
    register_Ns3LteRrcSapCarrierFreqEutra_methods(root_module, root_module['ns3::LteRrcSap::CarrierFreqEutra'])
    register_Ns3LteRrcSapCellAccessRelatedInfo_methods(root_module, root_module['ns3::LteRrcSap::CellAccessRelatedInfo'])
    register_Ns3LteRrcSapCellIdentification_methods(root_module, root_module['ns3::LteRrcSap::CellIdentification'])
    register_Ns3LteRrcSapCellSelectionInfo_methods(root_module, root_module['ns3::LteRrcSap::CellSelectionInfo'])
    register_Ns3LteRrcSapCellsToAddMod_methods(root_module, root_module['ns3::LteRrcSap::CellsToAddMod'])
    register_Ns3LteRrcSapCgiInfo_methods(root_module, root_module['ns3::LteRrcSap::CgiInfo'])
    register_Ns3LteRrcSapDrbToAddMod_methods(root_module, root_module['ns3::LteRrcSap::DrbToAddMod'])
    register_Ns3LteRrcSapFreqInfo_methods(root_module, root_module['ns3::LteRrcSap::FreqInfo'])
    register_Ns3LteRrcSapHandoverPreparationInfo_methods(root_module, root_module['ns3::LteRrcSap::HandoverPreparationInfo'])
    register_Ns3LteRrcSapLogicalChannelConfig_methods(root_module, root_module['ns3::LteRrcSap::LogicalChannelConfig'])
    register_Ns3LteRrcSapMasterInformationBlock_methods(root_module, root_module['ns3::LteRrcSap::MasterInformationBlock'])
    register_Ns3LteRrcSapMeasConfig_methods(root_module, root_module['ns3::LteRrcSap::MeasConfig'])
    register_Ns3LteRrcSapMeasGapConfig_methods(root_module, root_module['ns3::LteRrcSap::MeasGapConfig'])
    register_Ns3LteRrcSapMeasIdToAddMod_methods(root_module, root_module['ns3::LteRrcSap::MeasIdToAddMod'])
    register_Ns3LteRrcSapMeasObjectEutra_methods(root_module, root_module['ns3::LteRrcSap::MeasObjectEutra'])
    register_Ns3LteRrcSapMeasObjectToAddMod_methods(root_module, root_module['ns3::LteRrcSap::MeasObjectToAddMod'])
    register_Ns3LteRrcSapMeasResultBestNeighCell_methods(root_module, root_module['ns3::LteRrcSap::MeasResultBestNeighCell'])
    register_Ns3LteRrcSapMeasResultEutra_methods(root_module, root_module['ns3::LteRrcSap::MeasResultEutra'])
    register_Ns3LteRrcSapMeasResultScell_methods(root_module, root_module['ns3::LteRrcSap::MeasResultScell'])
    register_Ns3LteRrcSapMeasResultServFreqList_methods(root_module, root_module['ns3::LteRrcSap::MeasResultServFreqList'])
    register_Ns3LteRrcSapMeasResults_methods(root_module, root_module['ns3::LteRrcSap::MeasResults'])
    register_Ns3LteRrcSapMeasurementReport_methods(root_module, root_module['ns3::LteRrcSap::MeasurementReport'])
    register_Ns3LteRrcSapMobilityControlInfo_methods(root_module, root_module['ns3::LteRrcSap::MobilityControlInfo'])
    register_Ns3LteRrcSapMobilityStateParameters_methods(root_module, root_module['ns3::LteRrcSap::MobilityStateParameters'])
    register_Ns3LteRrcSapNonCriticalExtensionConfiguration_methods(root_module, root_module['ns3::LteRrcSap::NonCriticalExtensionConfiguration'])
    register_Ns3LteRrcSapNonUlConfiguration_methods(root_module, root_module['ns3::LteRrcSap::NonUlConfiguration'])
    register_Ns3LteRrcSapPdschConfigCommon_methods(root_module, root_module['ns3::LteRrcSap::PdschConfigCommon'])
    register_Ns3LteRrcSapPdschConfigDedicated_methods(root_module, root_module['ns3::LteRrcSap::PdschConfigDedicated'])
    register_Ns3LteRrcSapPhysCellIdRange_methods(root_module, root_module['ns3::LteRrcSap::PhysCellIdRange'])
    register_Ns3LteRrcSapPhysicalConfigDedicated_methods(root_module, root_module['ns3::LteRrcSap::PhysicalConfigDedicated'])
    register_Ns3LteRrcSapPhysicalConfigDedicatedSCell_methods(root_module, root_module['ns3::LteRrcSap::PhysicalConfigDedicatedSCell'])
    register_Ns3LteRrcSapPlmnIdentityInfo_methods(root_module, root_module['ns3::LteRrcSap::PlmnIdentityInfo'])
    register_Ns3LteRrcSapPrachConfigSCell_methods(root_module, root_module['ns3::LteRrcSap::PrachConfigSCell'])
    register_Ns3LteRrcSapPreambleInfo_methods(root_module, root_module['ns3::LteRrcSap::PreambleInfo'])
    register_Ns3LteRrcSapPuschConfigDedicatedSCell_methods(root_module, root_module['ns3::LteRrcSap::PuschConfigDedicatedSCell'])
    register_Ns3LteRrcSapQuantityConfig_methods(root_module, root_module['ns3::LteRrcSap::QuantityConfig'])
    register_Ns3LteRrcSapRaSupervisionInfo_methods(root_module, root_module['ns3::LteRrcSap::RaSupervisionInfo'])
    register_Ns3LteRrcSapRachConfigCommon_methods(root_module, root_module['ns3::LteRrcSap::RachConfigCommon'])
    register_Ns3LteRrcSapRachConfigDedicated_methods(root_module, root_module['ns3::LteRrcSap::RachConfigDedicated'])
    register_Ns3LteRrcSapRadioResourceConfigCommon_methods(root_module, root_module['ns3::LteRrcSap::RadioResourceConfigCommon'])
    register_Ns3LteRrcSapRadioResourceConfigCommonSCell_methods(root_module, root_module['ns3::LteRrcSap::RadioResourceConfigCommonSCell'])
    register_Ns3LteRrcSapRadioResourceConfigCommonSib_methods(root_module, root_module['ns3::LteRrcSap::RadioResourceConfigCommonSib'])
    register_Ns3LteRrcSapRadioResourceConfigDedicated_methods(root_module, root_module['ns3::LteRrcSap::RadioResourceConfigDedicated'])
    register_Ns3LteRrcSapRadioResourceConfigDedicatedSCell_methods(root_module, root_module['ns3::LteRrcSap::RadioResourceConfigDedicatedSCell'])
    register_Ns3LteRrcSapReestabUeIdentity_methods(root_module, root_module['ns3::LteRrcSap::ReestabUeIdentity'])
    register_Ns3LteRrcSapReportConfigEutra_methods(root_module, root_module['ns3::LteRrcSap::ReportConfigEutra'])
    register_Ns3LteRrcSapReportConfigToAddMod_methods(root_module, root_module['ns3::LteRrcSap::ReportConfigToAddMod'])
    register_Ns3LteRrcSapRlcConfig_methods(root_module, root_module['ns3::LteRrcSap::RlcConfig'])
    register_Ns3LteRrcSapRrcConnectionReconfiguration_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReconfiguration'])
    register_Ns3LteRrcSapRrcConnectionReconfigurationCompleted_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReconfigurationCompleted'])
    register_Ns3LteRrcSapRrcConnectionReestablishment_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReestablishment'])
    register_Ns3LteRrcSapRrcConnectionReestablishmentComplete_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReestablishmentComplete'])
    register_Ns3LteRrcSapRrcConnectionReestablishmentReject_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReestablishmentReject'])
    register_Ns3LteRrcSapRrcConnectionReestablishmentRequest_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReestablishmentRequest'])
    register_Ns3LteRrcSapRrcConnectionReject_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionReject'])
    register_Ns3LteRrcSapRrcConnectionRelease_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionRelease'])
    register_Ns3LteRrcSapRrcConnectionRequest_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionRequest'])
    register_Ns3LteRrcSapRrcConnectionSetup_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionSetup'])
    register_Ns3LteRrcSapRrcConnectionSetupCompleted_methods(root_module, root_module['ns3::LteRrcSap::RrcConnectionSetupCompleted'])
    register_Ns3LteRrcSapSCellToAddMod_methods(root_module, root_module['ns3::LteRrcSap::SCellToAddMod'])
    register_Ns3LteRrcSapSoundingRsUlConfigCommon_methods(root_module, root_module['ns3::LteRrcSap::SoundingRsUlConfigCommon'])
    register_Ns3LteRrcSapSoundingRsUlConfigDedicated_methods(root_module, root_module['ns3::LteRrcSap::SoundingRsUlConfigDedicated'])
    register_Ns3LteRrcSapSpeedStatePars_methods(root_module, root_module['ns3::LteRrcSap::SpeedStatePars'])
    register_Ns3LteRrcSapSpeedStateScaleFactors_methods(root_module, root_module['ns3::LteRrcSap::SpeedStateScaleFactors'])
    register_Ns3LteRrcSapSrbToAddMod_methods(root_module, root_module['ns3::LteRrcSap::SrbToAddMod'])
    register_Ns3LteRrcSapSystemInformation_methods(root_module, root_module['ns3::LteRrcSap::SystemInformation'])
    register_Ns3LteRrcSapSystemInformationBlockType1_methods(root_module, root_module['ns3::LteRrcSap::SystemInformationBlockType1'])
    register_Ns3LteRrcSapSystemInformationBlockType2_methods(root_module, root_module['ns3::LteRrcSap::SystemInformationBlockType2'])
    register_Ns3LteRrcSapThresholdEutra_methods(root_module, root_module['ns3::LteRrcSap::ThresholdEutra'])
    register_Ns3LteRrcSapTxFailParam_methods(root_module, root_module['ns3::LteRrcSap::TxFailParam'])
    register_Ns3LteRrcSapUlConfiguration_methods(root_module, root_module['ns3::LteRrcSap::UlConfiguration'])
    register_Ns3LteRrcSapUlPowerControlCommonSCell_methods(root_module, root_module['ns3::LteRrcSap::UlPowerControlCommonSCell'])
    register_Ns3LteRrcSapUlPowerControlDedicatedSCell_methods(root_module, root_module['ns3::LteRrcSap::UlPowerControlDedicatedSCell'])
    register_Ns3LteSpectrumValueCatcher_methods(root_module, root_module['ns3::LteSpectrumValueCatcher'])
    register_Ns3LteSpectrumValueHelper_methods(root_module, root_module['ns3::LteSpectrumValueHelper'])
    register_Ns3LteUeCcmRrcSapProvider_methods(root_module, root_module['ns3::LteUeCcmRrcSapProvider'])
    register_Ns3LteUeCcmRrcSapProviderLcsConfig_methods(root_module, root_module['ns3::LteUeCcmRrcSapProvider::LcsConfig'])
    register_Ns3LteUeCcmRrcSapUser_methods(root_module, root_module['ns3::LteUeCcmRrcSapUser'])
    register_Ns3LteUeCmacSapProvider_methods(root_module, root_module['ns3::LteUeCmacSapProvider'])
    register_Ns3LteUeCmacSapProviderLogicalChannelConfig_methods(root_module, root_module['ns3::LteUeCmacSapProvider::LogicalChannelConfig'])
    register_Ns3LteUeCmacSapProviderRachConfig_methods(root_module, root_module['ns3::LteUeCmacSapProvider::RachConfig'])
    register_Ns3LteUeCmacSapUser_methods(root_module, root_module['ns3::LteUeCmacSapUser'])
    register_Ns3LteUeConfig_t_methods(root_module, root_module['ns3::LteUeConfig_t'])
    register_Ns3LteUeCphySapProvider_methods(root_module, root_module['ns3::LteUeCphySapProvider'])
    register_Ns3LteUeCphySapUser_methods(root_module, root_module['ns3::LteUeCphySapUser'])
    register_Ns3LteUeCphySapUserUeMeasurementsElement_methods(root_module, root_module['ns3::LteUeCphySapUser::UeMeasurementsElement'])
    register_Ns3LteUeCphySapUserUeMeasurementsParameters_methods(root_module, root_module['ns3::LteUeCphySapUser::UeMeasurementsParameters'])
    register_Ns3LteUePhySapProvider_methods(root_module, root_module['ns3::LteUePhySapProvider'])
    register_Ns3LteUePhySapUser_methods(root_module, root_module['ns3::LteUePhySapUser'])
    register_Ns3LteUeRrcSapProvider_methods(root_module, root_module['ns3::LteUeRrcSapProvider'])
    register_Ns3LteUeRrcSapProviderCompleteSetupParameters_methods(root_module, root_module['ns3::LteUeRrcSapProvider::CompleteSetupParameters'])
    register_Ns3LteUeRrcSapUser_methods(root_module, root_module['ns3::LteUeRrcSapUser'])
    register_Ns3LteUeRrcSapUserSetupParameters_methods(root_module, root_module['ns3::LteUeRrcSapUser::SetupParameters'])
    register_Ns3Mac48Address_methods(root_module, root_module['ns3::Mac48Address'])
    register_Ns3Mac64Address_methods(root_module, root_module['ns3::Mac64Address'])
    register_Ns3Mac8Address_methods(root_module, root_module['ns3::Mac8Address'])
    register_Ns3MacCeListElement_s_methods(root_module, root_module['ns3::MacCeListElement_s'])
    register_Ns3MacCeValue_u_methods(root_module, root_module['ns3::MacCeValue_u'])
    register_Ns3Names_methods(root_module, root_module['ns3::Names'])
    register_Ns3NetDeviceContainer_methods(root_module, root_module['ns3::NetDeviceContainer'])
    register_Ns3NodeContainer_methods(root_module, root_module['ns3::NodeContainer'])
    register_Ns3ObjectBase_methods(root_module, root_module['ns3::ObjectBase'])
    register_Ns3ObjectDeleter_methods(root_module, root_module['ns3::ObjectDeleter'])
    register_Ns3ObjectFactory_methods(root_module, root_module['ns3::ObjectFactory'])
    register_Ns3PacketMetadata_methods(root_module, root_module['ns3::PacketMetadata'])
    register_Ns3PacketMetadataItem_methods(root_module, root_module['ns3::PacketMetadata::Item'])
    register_Ns3PacketMetadataItemIterator_methods(root_module, root_module['ns3::PacketMetadata::ItemIterator'])
    register_Ns3PacketTagIterator_methods(root_module, root_module['ns3::PacketTagIterator'])
    register_Ns3PacketTagIteratorItem_methods(root_module, root_module['ns3::PacketTagIterator::Item'])
    register_Ns3PacketTagList_methods(root_module, root_module['ns3::PacketTagList'])
    register_Ns3PacketTagListTagData_methods(root_module, root_module['ns3::PacketTagList::TagData'])
    register_Ns3PagingInfoListElement_s_methods(root_module, root_module['ns3::PagingInfoListElement_s'])
    register_Ns3ParameterLogger_methods(root_module, root_module['ns3::ParameterLogger'])
    register_Ns3PhichListElement_s_methods(root_module, root_module['ns3::PhichListElement_s'])
    register_Ns3PhyReceptionStatParameters_methods(root_module, root_module['ns3::PhyReceptionStatParameters'])
    register_Ns3PhyTransmissionStatParameters_methods(root_module, root_module['ns3::PhyTransmissionStatParameters'])
    register_Ns3RachListElement_s_methods(root_module, root_module['ns3::RachListElement_s'])
    register_Ns3RadioBearerStatsConnector_methods(root_module, root_module['ns3::RadioBearerStatsConnector'])
    register_Ns3RealProtocolRlcSapUser_methods(root_module, root_module['ns3::RealProtocolRlcSapUser'])
    register_Ns3RlcPduListElement_s_methods(root_module, root_module['ns3::RlcPduListElement_s'])
    register_Ns3SbMeasResult_s_methods(root_module, root_module['ns3::SbMeasResult_s'])
    register_Ns3SequenceNumber10_methods(root_module, root_module['ns3::SequenceNumber10'])
    register_Ns3SiConfiguration_s_methods(root_module, root_module['ns3::SiConfiguration_s'])
    register_Ns3SiMessageListElement_s_methods(root_module, root_module['ns3::SiMessageListElement_s'])
    register_Ns3SimpleRefCount__Ns3Object_Ns3ObjectBase_Ns3ObjectDeleter_methods(root_module, root_module['ns3::SimpleRefCount< ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter >'])
    register_Ns3Simulator_methods(root_module, root_module['ns3::Simulator'])
    register_Ns3SpsConfig_s_methods(root_module, root_module['ns3::SpsConfig_s'])
    register_Ns3SrConfig_s_methods(root_module, root_module['ns3::SrConfig_s'])
    register_Ns3SrListElement_s_methods(root_module, root_module['ns3::SrListElement_s'])
    register_Ns3StatisticalSummary_methods(root_module, root_module['ns3::StatisticalSummary'])
    register_Ns3Tag_methods(root_module, root_module['ns3::Tag'])
    register_Ns3TagBuffer_methods(root_module, root_module['ns3::TagBuffer'])
    register_Ns3TbId_t_methods(root_module, root_module['ns3::TbId_t'])
    register_Ns3TbStats_t_methods(root_module, root_module['ns3::TbStats_t'])
    register_Ns3TimeWithUnit_methods(root_module, root_module['ns3::TimeWithUnit'])
    register_Ns3TransmissionModesLayers_methods(root_module, root_module['ns3::TransmissionModesLayers'])
    register_Ns3TypeId_methods(root_module, root_module['ns3::TypeId'])
    register_Ns3TypeIdAttributeInformation_methods(root_module, root_module['ns3::TypeId::AttributeInformation'])
    register_Ns3TypeIdTraceSourceInformation_methods(root_module, root_module['ns3::TypeId::TraceSourceInformation'])
    register_Ns3UeCapabilities_s_methods(root_module, root_module['ns3::UeCapabilities_s'])
    register_Ns3UeSelected_s_methods(root_module, root_module['ns3::UeSelected_s'])
    register_Ns3UlCqi_s_methods(root_module, root_module['ns3::UlCqi_s'])
    register_Ns3UlDciListElement_s_methods(root_module, root_module['ns3::UlDciListElement_s'])
    register_Ns3UlGrant_s_methods(root_module, root_module['ns3::UlGrant_s'])
    register_Ns3UlInfoListElement_s_methods(root_module, root_module['ns3::UlInfoListElement_s'])
    register_Ns3UplinkLteGlobalPathlossDatabase_methods(root_module, root_module['ns3::UplinkLteGlobalPathlossDatabase'])
    register_Ns3Vector2D_methods(root_module, root_module['ns3::Vector2D'])
    register_Ns3Vector3D_methods(root_module, root_module['ns3::Vector3D'])
    register_Ns3VendorSpecificListElement_s_methods(root_module, root_module['ns3::VendorSpecificListElement_s'])
    register_Ns3Empty_methods(root_module, root_module['ns3::empty'])
    register_Ns3FdbetsFlowPerf_t_methods(root_module, root_module['ns3::fdbetsFlowPerf_t'])
    register_Ns3FdtbfqsFlowPerf_t_methods(root_module, root_module['ns3::fdtbfqsFlowPerf_t'])
    register_Ns3Int64x64_t_methods(root_module, root_module['ns3::int64x64_t'])
    register_Ns3PfsFlowPerf_t_methods(root_module, root_module['ns3::pfsFlowPerf_t'])
    register_Ns3PssFlowPerf_t_methods(root_module, root_module['ns3::pssFlowPerf_t'])
    register_Ns3TbInfo_t_methods(root_module, root_module['ns3::tbInfo_t'])
    register_Ns3TdbetsFlowPerf_t_methods(root_module, root_module['ns3::tdbetsFlowPerf_t'])
    register_Ns3TdtbfqsFlowPerf_t_methods(root_module, root_module['ns3::tdtbfqsFlowPerf_t'])
    register_Ns3Chunk_methods(root_module, root_module['ns3::Chunk'])
    register_Ns3DownlinkLteGlobalPathlossDatabase_methods(root_module, root_module['ns3::DownlinkLteGlobalPathlossDatabase'])
    register_Ns3EpsBearer_methods(root_module, root_module['ns3::EpsBearer'])
    register_Ns3EpsBearerTag_methods(root_module, root_module['ns3::EpsBearerTag'])
    register_Ns3Header_methods(root_module, root_module['ns3::Header'])
    register_Ns3Ipv4Header_methods(root_module, root_module['ns3::Ipv4Header'])
    register_Ns3LteCcmMacSapUser_methods(root_module, root_module['ns3::LteCcmMacSapUser'])
    register_Ns3LteEnbRrcSapProvider_methods(root_module, root_module['ns3::LteEnbRrcSapProvider'])
    register_Ns3LteEnbRrcSapProviderCompleteSetupUeParameters_methods(root_module, root_module['ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters'])
    register_Ns3LteEnbRrcSapUser_methods(root_module, root_module['ns3::LteEnbRrcSapUser'])
    register_Ns3LteEnbRrcSapUserSetupUeParameters_methods(root_module, root_module['ns3::LteEnbRrcSapUser::SetupUeParameters'])
    register_Ns3LtePdcpHeader_methods(root_module, root_module['ns3::LtePdcpHeader'])
    register_Ns3LtePhyTag_methods(root_module, root_module['ns3::LtePhyTag'])
    register_Ns3LteRadioBearerTag_methods(root_module, root_module['ns3::LteRadioBearerTag'])
    register_Ns3LteRlcAmHeader_methods(root_module, root_module['ns3::LteRlcAmHeader'])
    register_Ns3LteRlcHeader_methods(root_module, root_module['ns3::LteRlcHeader'])
    register_Ns3LteRlcSduStatusTag_methods(root_module, root_module['ns3::LteRlcSduStatusTag'])
    register_Ns3Object_methods(root_module, root_module['ns3::Object'])
    register_Ns3ObjectAggregateIterator_methods(root_module, root_module['ns3::Object::AggregateIterator'])
    register_Ns3PacketBurst_methods(root_module, root_module['ns3::PacketBurst'])
    register_Ns3PdcpTag_methods(root_module, root_module['ns3::PdcpTag'])
    register_Ns3PropagationDelayModel_methods(root_module, root_module['ns3::PropagationDelayModel'])
    register_Ns3PropagationLossModel_methods(root_module, root_module['ns3::PropagationLossModel'])
    register_Ns3RadioEnvironmentMapHelper_methods(root_module, root_module['ns3::RadioEnvironmentMapHelper'])
    register_Ns3RandomPropagationDelayModel_methods(root_module, root_module['ns3::RandomPropagationDelayModel'])
    register_Ns3RandomPropagationLossModel_methods(root_module, root_module['ns3::RandomPropagationLossModel'])
    register_Ns3RandomVariableStream_methods(root_module, root_module['ns3::RandomVariableStream'])
    register_Ns3RangePropagationLossModel_methods(root_module, root_module['ns3::RangePropagationLossModel'])
    register_Ns3RlcTag_methods(root_module, root_module['ns3::RlcTag'])
    register_Ns3SequentialRandomVariable_methods(root_module, root_module['ns3::SequentialRandomVariable'])
    register_Ns3SimpleRefCount__Ns3AttributeAccessor_Ns3Empty_Ns3DefaultDeleter__lt__ns3AttributeAccessor__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter<ns3::AttributeAccessor> >'])
    register_Ns3SimpleRefCount__Ns3AttributeChecker_Ns3Empty_Ns3DefaultDeleter__lt__ns3AttributeChecker__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter<ns3::AttributeChecker> >'])
    register_Ns3SimpleRefCount__Ns3AttributeValue_Ns3Empty_Ns3DefaultDeleter__lt__ns3AttributeValue__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter<ns3::AttributeValue> >'])
    register_Ns3SimpleRefCount__Ns3CallbackImplBase_Ns3Empty_Ns3DefaultDeleter__lt__ns3CallbackImplBase__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter<ns3::CallbackImplBase> >'])
    register_Ns3SimpleRefCount__Ns3EpcTft_Ns3Empty_Ns3DefaultDeleter__lt__ns3EpcTft__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::EpcTft, ns3::empty, ns3::DefaultDeleter<ns3::EpcTft> >'])
    register_Ns3SimpleRefCount__Ns3EpcTftClassifier_Ns3Empty_Ns3DefaultDeleter__lt__ns3EpcTftClassifier__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter<ns3::EpcTftClassifier> >'])
    register_Ns3SimpleRefCount__Ns3EventImpl_Ns3Empty_Ns3DefaultDeleter__lt__ns3EventImpl__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::EventImpl, ns3::empty, ns3::DefaultDeleter<ns3::EventImpl> >'])
    register_Ns3SimpleRefCount__Ns3HashImplementation_Ns3Empty_Ns3DefaultDeleter__lt__ns3HashImplementation__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter<ns3::Hash::Implementation> >'])
    register_Ns3SimpleRefCount__Ns3Ipv4MulticastRoute_Ns3Empty_Ns3DefaultDeleter__lt__ns3Ipv4MulticastRoute__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4MulticastRoute> >'])
    register_Ns3SimpleRefCount__Ns3Ipv4Route_Ns3Empty_Ns3DefaultDeleter__lt__ns3Ipv4Route__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4Route> >'])
    register_Ns3SimpleRefCount__Ns3LteChunkProcessor_Ns3Empty_Ns3DefaultDeleter__lt__ns3LteChunkProcessor__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter<ns3::LteChunkProcessor> >'])
    register_Ns3SimpleRefCount__Ns3LteControlMessage_Ns3Empty_Ns3DefaultDeleter__lt__ns3LteControlMessage__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter<ns3::LteControlMessage> >'])
    register_Ns3SimpleRefCount__Ns3LteHarqPhy_Ns3Empty_Ns3DefaultDeleter__lt__ns3LteHarqPhy__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter<ns3::LteHarqPhy> >'])
    register_Ns3SimpleRefCount__Ns3NixVector_Ns3Empty_Ns3DefaultDeleter__lt__ns3NixVector__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::NixVector, ns3::empty, ns3::DefaultDeleter<ns3::NixVector> >'])
    register_Ns3SimpleRefCount__Ns3Packet_Ns3Empty_Ns3DefaultDeleter__lt__ns3Packet__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::Packet, ns3::empty, ns3::DefaultDeleter<ns3::Packet> >'])
    register_Ns3SimpleRefCount__Ns3SpectrumModel_Ns3Empty_Ns3DefaultDeleter__lt__ns3SpectrumModel__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumModel> >'])
    register_Ns3SimpleRefCount__Ns3SpectrumSignalParameters_Ns3Empty_Ns3DefaultDeleter__lt__ns3SpectrumSignalParameters__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumSignalParameters> >'])
    register_Ns3SimpleRefCount__Ns3SpectrumValue_Ns3Empty_Ns3DefaultDeleter__lt__ns3SpectrumValue__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumValue> >'])
    register_Ns3SimpleRefCount__Ns3TraceSourceAccessor_Ns3Empty_Ns3DefaultDeleter__lt__ns3TraceSourceAccessor__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter<ns3::TraceSourceAccessor> >'])
    register_Ns3SimpleRefCount__Ns3VendorSpecificValue_Ns3Empty_Ns3DefaultDeleter__lt__ns3VendorSpecificValue__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter<ns3::VendorSpecificValue> >'])
    register_Ns3SimpleRefCount__Ns3X2CellInfo_Ns3Empty_Ns3DefaultDeleter__lt__ns3X2CellInfo__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2CellInfo> >'])
    register_Ns3SimpleRefCount__Ns3X2IfaceInfo_Ns3Empty_Ns3DefaultDeleter__lt__ns3X2IfaceInfo__gt___methods(root_module, root_module['ns3::SimpleRefCount< ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2IfaceInfo> >'])
    register_Ns3Socket_methods(root_module, root_module['ns3::Socket'])
    register_Ns3SocketIpTosTag_methods(root_module, root_module['ns3::SocketIpTosTag'])
    register_Ns3SocketIpTtlTag_methods(root_module, root_module['ns3::SocketIpTtlTag'])
    register_Ns3SocketIpv6HopLimitTag_methods(root_module, root_module['ns3::SocketIpv6HopLimitTag'])
    register_Ns3SocketIpv6TclassTag_methods(root_module, root_module['ns3::SocketIpv6TclassTag'])
    register_Ns3SocketPriorityTag_methods(root_module, root_module['ns3::SocketPriorityTag'])
    register_Ns3SocketSetDontFragmentTag_methods(root_module, root_module['ns3::SocketSetDontFragmentTag'])
    register_Ns3SpectrumInterference_methods(root_module, root_module['ns3::SpectrumInterference'])
    register_Ns3SpectrumModel_methods(root_module, root_module['ns3::SpectrumModel'])
    register_Ns3SpectrumPhy_methods(root_module, root_module['ns3::SpectrumPhy'])
    register_Ns3SpectrumPropagationLossModel_methods(root_module, root_module['ns3::SpectrumPropagationLossModel'])
    register_Ns3SpectrumSignalParameters_methods(root_module, root_module['ns3::SpectrumSignalParameters'])
    register_Ns3SpectrumValue_methods(root_module, root_module['ns3::SpectrumValue'])
    register_Ns3ThreeLogDistancePropagationLossModel_methods(root_module, root_module['ns3::ThreeLogDistancePropagationLossModel'])
    register_Ns3Time_methods(root_module, root_module['ns3::Time'])
    register_Ns3TraceSourceAccessor_methods(root_module, root_module['ns3::TraceSourceAccessor'])
    register_Ns3Trailer_methods(root_module, root_module['ns3::Trailer'])
    register_Ns3TriangularRandomVariable_methods(root_module, root_module['ns3::TriangularRandomVariable'])
    register_Ns3TwoRayGroundPropagationLossModel_methods(root_module, root_module['ns3::TwoRayGroundPropagationLossModel'])
    register_Ns3UeManager_methods(root_module, root_module['ns3::UeManager'])
    register_Ns3UniformRandomVariable_methods(root_module, root_module['ns3::UniformRandomVariable'])
    register_Ns3VendorSpecificValue_methods(root_module, root_module['ns3::VendorSpecificValue'])
    register_Ns3WeibullRandomVariable_methods(root_module, root_module['ns3::WeibullRandomVariable'])
    register_Ns3X2CellInfo_methods(root_module, root_module['ns3::X2CellInfo'])
    register_Ns3X2IfaceInfo_methods(root_module, root_module['ns3::X2IfaceInfo'])
    register_Ns3ZetaRandomVariable_methods(root_module, root_module['ns3::ZetaRandomVariable'])
    register_Ns3ZipfRandomVariable_methods(root_module, root_module['ns3::ZipfRandomVariable'])
    register_Ns3Application_methods(root_module, root_module['ns3::Application'])
    register_Ns3Asn1Header_methods(root_module, root_module['ns3::Asn1Header'])
    register_Ns3AttributeAccessor_methods(root_module, root_module['ns3::AttributeAccessor'])
    register_Ns3AttributeChecker_methods(root_module, root_module['ns3::AttributeChecker'])
    register_Ns3AttributeValue_methods(root_module, root_module['ns3::AttributeValue'])
    register_Ns3BooleanChecker_methods(root_module, root_module['ns3::BooleanChecker'])
    register_Ns3BooleanValue_methods(root_module, root_module['ns3::BooleanValue'])
    register_Ns3CallbackChecker_methods(root_module, root_module['ns3::CallbackChecker'])
    register_Ns3CallbackImplBase_methods(root_module, root_module['ns3::CallbackImplBase'])
    register_Ns3CallbackValue_methods(root_module, root_module['ns3::CallbackValue'])
    register_Ns3CcHelper_methods(root_module, root_module['ns3::CcHelper'])
    register_Ns3Channel_methods(root_module, root_module['ns3::Channel'])
    register_Ns3ComponentCarrier_methods(root_module, root_module['ns3::ComponentCarrier'])
    register_Ns3ComponentCarrierBaseStation_methods(root_module, root_module['ns3::ComponentCarrierBaseStation'])
    register_Ns3ComponentCarrierEnb_methods(root_module, root_module['ns3::ComponentCarrierEnb'])
    register_Ns3ComponentCarrierUe_methods(root_module, root_module['ns3::ComponentCarrierUe'])
    register_Ns3ConstantRandomVariable_methods(root_module, root_module['ns3::ConstantRandomVariable'])
    register_Ns3ConstantSpeedPropagationDelayModel_methods(root_module, root_module['ns3::ConstantSpeedPropagationDelayModel'])
    register_Ns3DataCalculator_methods(root_module, root_module['ns3::DataCalculator'])
    register_Ns3DataOutputInterface_methods(root_module, root_module['ns3::DataOutputInterface'])
    register_Ns3DataRateChecker_methods(root_module, root_module['ns3::DataRateChecker'])
    register_Ns3DataRateValue_methods(root_module, root_module['ns3::DataRateValue'])
    register_Ns3DeterministicRandomVariable_methods(root_module, root_module['ns3::DeterministicRandomVariable'])
    register_Ns3DoubleValue_methods(root_module, root_module['ns3::DoubleValue'])
    register_Ns3EmpiricalRandomVariable_methods(root_module, root_module['ns3::EmpiricalRandomVariable'])
    register_Ns3EmptyAttributeAccessor_methods(root_module, root_module['ns3::EmptyAttributeAccessor'])
    register_Ns3EmptyAttributeChecker_methods(root_module, root_module['ns3::EmptyAttributeChecker'])
    register_Ns3EmptyAttributeValue_methods(root_module, root_module['ns3::EmptyAttributeValue'])
    register_Ns3EnumChecker_methods(root_module, root_module['ns3::EnumChecker'])
    register_Ns3EnumValue_methods(root_module, root_module['ns3::EnumValue'])
    register_Ns3EpcEnbApplication_methods(root_module, root_module['ns3::EpcEnbApplication'])
    register_Ns3EpcEnbApplicationEpsFlowId_t_methods(root_module, root_module['ns3::EpcEnbApplication::EpsFlowId_t'])
    register_Ns3EpcHelper_methods(root_module, root_module['ns3::EpcHelper'])
    register_Ns3EpcMmeApplication_methods(root_module, root_module['ns3::EpcMmeApplication'])
    register_Ns3EpcPgwApplication_methods(root_module, root_module['ns3::EpcPgwApplication'])
    register_Ns3EpcSgwApplication_methods(root_module, root_module['ns3::EpcSgwApplication'])
    register_Ns3EpcTft_methods(root_module, root_module['ns3::EpcTft'])
    register_Ns3EpcTftPacketFilter_methods(root_module, root_module['ns3::EpcTft::PacketFilter'])
    register_Ns3EpcTftClassifier_methods(root_module, root_module['ns3::EpcTftClassifier'])
    register_Ns3EpcUeNas_methods(root_module, root_module['ns3::EpcUeNas'])
    register_Ns3EpcX2_methods(root_module, root_module['ns3::EpcX2'])
    register_Ns3EpcX2HandoverPreparationFailureHeader_methods(root_module, root_module['ns3::EpcX2HandoverPreparationFailureHeader'])
    register_Ns3EpcX2HandoverRequestAckHeader_methods(root_module, root_module['ns3::EpcX2HandoverRequestAckHeader'])
    register_Ns3EpcX2HandoverRequestHeader_methods(root_module, root_module['ns3::EpcX2HandoverRequestHeader'])
    register_Ns3EpcX2Header_methods(root_module, root_module['ns3::EpcX2Header'])
    register_Ns3EpcX2LoadInformationHeader_methods(root_module, root_module['ns3::EpcX2LoadInformationHeader'])
    register_Ns3EpcX2ResourceStatusUpdateHeader_methods(root_module, root_module['ns3::EpcX2ResourceStatusUpdateHeader'])
    register_Ns3EpcX2SnStatusTransferHeader_methods(root_module, root_module['ns3::EpcX2SnStatusTransferHeader'])
    register_Ns3EpcX2UeContextReleaseHeader_methods(root_module, root_module['ns3::EpcX2UeContextReleaseHeader'])
    register_Ns3ErlangRandomVariable_methods(root_module, root_module['ns3::ErlangRandomVariable'])
    register_Ns3EventImpl_methods(root_module, root_module['ns3::EventImpl'])
    register_Ns3ExponentialRandomVariable_methods(root_module, root_module['ns3::ExponentialRandomVariable'])
    register_Ns3FfMacScheduler_methods(root_module, root_module['ns3::FfMacScheduler'])
    register_Ns3FixedRssLossModel_methods(root_module, root_module['ns3::FixedRssLossModel'])
    register_Ns3FriisPropagationLossModel_methods(root_module, root_module['ns3::FriisPropagationLossModel'])
    register_Ns3GammaRandomVariable_methods(root_module, root_module['ns3::GammaRandomVariable'])
    register_Ns3GtpcHeader_methods(root_module, root_module['ns3::GtpcHeader'])
    register_Ns3GtpcHeaderFteid_t_methods(root_module, root_module['ns3::GtpcHeader::Fteid_t'])
    register_Ns3GtpcModifyBearerRequestMessage_methods(root_module, root_module['ns3::GtpcModifyBearerRequestMessage'])
    register_Ns3GtpcModifyBearerRequestMessageBearerContextToBeModified_methods(root_module, root_module['ns3::GtpcModifyBearerRequestMessage::BearerContextToBeModified'])
    register_Ns3GtpcModifyBearerResponseMessage_methods(root_module, root_module['ns3::GtpcModifyBearerResponseMessage'])
    register_Ns3GtpuHeader_methods(root_module, root_module['ns3::GtpuHeader'])
    register_Ns3IntegerValue_methods(root_module, root_module['ns3::IntegerValue'])
    register_Ns3Ipv4_methods(root_module, root_module['ns3::Ipv4'])
    register_Ns3Ipv4AddressChecker_methods(root_module, root_module['ns3::Ipv4AddressChecker'])
    register_Ns3Ipv4AddressValue_methods(root_module, root_module['ns3::Ipv4AddressValue'])
    register_Ns3Ipv4MaskChecker_methods(root_module, root_module['ns3::Ipv4MaskChecker'])
    register_Ns3Ipv4MaskValue_methods(root_module, root_module['ns3::Ipv4MaskValue'])
    register_Ns3Ipv4MulticastRoute_methods(root_module, root_module['ns3::Ipv4MulticastRoute'])
    register_Ns3Ipv4Route_methods(root_module, root_module['ns3::Ipv4Route'])
    register_Ns3Ipv6_methods(root_module, root_module['ns3::Ipv6'])
    register_Ns3Ipv6AddressChecker_methods(root_module, root_module['ns3::Ipv6AddressChecker'])
    register_Ns3Ipv6AddressValue_methods(root_module, root_module['ns3::Ipv6AddressValue'])
    register_Ns3Ipv6PrefixChecker_methods(root_module, root_module['ns3::Ipv6PrefixChecker'])
    register_Ns3Ipv6PrefixValue_methods(root_module, root_module['ns3::Ipv6PrefixValue'])
    register_Ns3LogDistancePropagationLossModel_methods(root_module, root_module['ns3::LogDistancePropagationLossModel'])
    register_Ns3LogNormalRandomVariable_methods(root_module, root_module['ns3::LogNormalRandomVariable'])
    register_Ns3LteAmc_methods(root_module, root_module['ns3::LteAmc'])
    register_Ns3LteAnr_methods(root_module, root_module['ns3::LteAnr'])
    register_Ns3LteChunkProcessor_methods(root_module, root_module['ns3::LteChunkProcessor'])
    register_Ns3LteControlMessage_methods(root_module, root_module['ns3::LteControlMessage'])
    register_Ns3LteEnbComponentCarrierManager_methods(root_module, root_module['ns3::LteEnbComponentCarrierManager'])
    register_Ns3LteEnbMac_methods(root_module, root_module['ns3::LteEnbMac'])
    register_Ns3LteEnbRrc_methods(root_module, root_module['ns3::LteEnbRrc'])
    register_Ns3LteEnbRrcProtocolIdeal_methods(root_module, root_module['ns3::LteEnbRrcProtocolIdeal'])
    register_Ns3LteEnbRrcProtocolReal_methods(root_module, root_module['ns3::LteEnbRrcProtocolReal'])
    register_Ns3LteFfrAlgorithm_methods(root_module, root_module['ns3::LteFfrAlgorithm'])
    register_Ns3LteFfrDistributedAlgorithm_methods(root_module, root_module['ns3::LteFfrDistributedAlgorithm'])
    register_Ns3LteFfrEnhancedAlgorithm_methods(root_module, root_module['ns3::LteFfrEnhancedAlgorithm'])
    register_Ns3LteFfrSoftAlgorithm_methods(root_module, root_module['ns3::LteFfrSoftAlgorithm'])
    register_Ns3LteFrHardAlgorithm_methods(root_module, root_module['ns3::LteFrHardAlgorithm'])
    register_Ns3LteFrNoOpAlgorithm_methods(root_module, root_module['ns3::LteFrNoOpAlgorithm'])
    register_Ns3LteFrSoftAlgorithm_methods(root_module, root_module['ns3::LteFrSoftAlgorithm'])
    register_Ns3LteFrStrictAlgorithm_methods(root_module, root_module['ns3::LteFrStrictAlgorithm'])
    register_Ns3LteHandoverAlgorithm_methods(root_module, root_module['ns3::LteHandoverAlgorithm'])
    register_Ns3LteHarqPhy_methods(root_module, root_module['ns3::LteHarqPhy'])
    register_Ns3LteHelper_methods(root_module, root_module['ns3::LteHelper'])
    register_Ns3LteHexGridEnbTopologyHelper_methods(root_module, root_module['ns3::LteHexGridEnbTopologyHelper'])
    register_Ns3LteInterference_methods(root_module, root_module['ns3::LteInterference'])
    register_Ns3LtePdcp_methods(root_module, root_module['ns3::LtePdcp'])
    register_Ns3LtePdcpStatus_methods(root_module, root_module['ns3::LtePdcp::Status'])
    register_Ns3LtePhy_methods(root_module, root_module['ns3::LtePhy'])
    register_Ns3LteRadioBearerInfo_methods(root_module, root_module['ns3::LteRadioBearerInfo'])
    register_Ns3LteRlc_methods(root_module, root_module['ns3::LteRlc'])
    register_Ns3LteRlcAm_methods(root_module, root_module['ns3::LteRlcAm'])
    register_Ns3LteRlcSm_methods(root_module, root_module['ns3::LteRlcSm'])
    register_Ns3LteRlcTm_methods(root_module, root_module['ns3::LteRlcTm'])
    register_Ns3LteRlcUm_methods(root_module, root_module['ns3::LteRlcUm'])
    register_Ns3LteSignalingRadioBearerInfo_methods(root_module, root_module['ns3::LteSignalingRadioBearerInfo'])
    register_Ns3LteSpectrumPhy_methods(root_module, root_module['ns3::LteSpectrumPhy'])
    register_Ns3LteSpectrumSignalParameters_methods(root_module, root_module['ns3::LteSpectrumSignalParameters'])
    register_Ns3LteSpectrumSignalParametersDataFrame_methods(root_module, root_module['ns3::LteSpectrumSignalParametersDataFrame'])
    register_Ns3LteSpectrumSignalParametersDlCtrlFrame_methods(root_module, root_module['ns3::LteSpectrumSignalParametersDlCtrlFrame'])
    register_Ns3LteSpectrumSignalParametersUlSrsFrame_methods(root_module, root_module['ns3::LteSpectrumSignalParametersUlSrsFrame'])
    register_Ns3LteStatsCalculator_methods(root_module, root_module['ns3::LteStatsCalculator'])
    register_Ns3LteUeComponentCarrierManager_methods(root_module, root_module['ns3::LteUeComponentCarrierManager'])
    register_Ns3LteUeMac_methods(root_module, root_module['ns3::LteUeMac'])
    register_Ns3LteUePhy_methods(root_module, root_module['ns3::LteUePhy'])
    register_Ns3LteUePowerControl_methods(root_module, root_module['ns3::LteUePowerControl'])
    register_Ns3LteUeRrc_methods(root_module, root_module['ns3::LteUeRrc'])
    register_Ns3LteUeRrcProtocolIdeal_methods(root_module, root_module['ns3::LteUeRrcProtocolIdeal'])
    register_Ns3LteUeRrcProtocolReal_methods(root_module, root_module['ns3::LteUeRrcProtocolReal'])
    register_Ns3Mac48AddressChecker_methods(root_module, root_module['ns3::Mac48AddressChecker'])
    register_Ns3Mac48AddressValue_methods(root_module, root_module['ns3::Mac48AddressValue'])
    register_Ns3Mac64AddressChecker_methods(root_module, root_module['ns3::Mac64AddressChecker'])
    register_Ns3Mac64AddressValue_methods(root_module, root_module['ns3::Mac64AddressValue'])
    register_Ns3MacStatsCalculator_methods(root_module, root_module['ns3::MacStatsCalculator'])
    register_Ns3MatrixPropagationLossModel_methods(root_module, root_module['ns3::MatrixPropagationLossModel'])
    register_Ns3MibLteControlMessage_methods(root_module, root_module['ns3::MibLteControlMessage'])
    register_Ns3MinMaxAvgTotalCalculator__Unsigned_int_methods(root_module, root_module['ns3::MinMaxAvgTotalCalculator< unsigned int >'])
    register_Ns3MinMaxAvgTotalCalculator__Unsigned_long_methods(root_module, root_module['ns3::MinMaxAvgTotalCalculator< unsigned long long >'])
    register_Ns3MobilityModel_methods(root_module, root_module['ns3::MobilityModel'])
    register_Ns3NakagamiPropagationLossModel_methods(root_module, root_module['ns3::NakagamiPropagationLossModel'])
    register_Ns3NetDevice_methods(root_module, root_module['ns3::NetDevice'])
    register_Ns3NixVector_methods(root_module, root_module['ns3::NixVector'])
    register_Ns3NoBackhaulEpcHelper_methods(root_module, root_module['ns3::NoBackhaulEpcHelper'])
    register_Ns3NoOpComponentCarrierManager_methods(root_module, root_module['ns3::NoOpComponentCarrierManager'])
    register_Ns3NoOpHandoverAlgorithm_methods(root_module, root_module['ns3::NoOpHandoverAlgorithm'])
    register_Ns3Node_methods(root_module, root_module['ns3::Node'])
    register_Ns3NormalRandomVariable_methods(root_module, root_module['ns3::NormalRandomVariable'])
    register_Ns3ObjectFactoryChecker_methods(root_module, root_module['ns3::ObjectFactoryChecker'])
    register_Ns3ObjectFactoryValue_methods(root_module, root_module['ns3::ObjectFactoryValue'])
    register_Ns3Packet_methods(root_module, root_module['ns3::Packet'])
    register_Ns3ParetoRandomVariable_methods(root_module, root_module['ns3::ParetoRandomVariable'])
    register_Ns3PfFfMacScheduler_methods(root_module, root_module['ns3::PfFfMacScheduler'])
    register_Ns3PhyRxStatsCalculator_methods(root_module, root_module['ns3::PhyRxStatsCalculator'])
    register_Ns3PhyStatsCalculator_methods(root_module, root_module['ns3::PhyStatsCalculator'])
    register_Ns3PhyTxStatsCalculator_methods(root_module, root_module['ns3::PhyTxStatsCalculator'])
    register_Ns3PointToPointEpcHelper_methods(root_module, root_module['ns3::PointToPointEpcHelper'])
    register_Ns3PointerChecker_methods(root_module, root_module['ns3::PointerChecker'])
    register_Ns3PointerValue_methods(root_module, root_module['ns3::PointerValue'])
    register_Ns3PssFfMacScheduler_methods(root_module, root_module['ns3::PssFfMacScheduler'])
    register_Ns3RachPreambleLteControlMessage_methods(root_module, root_module['ns3::RachPreambleLteControlMessage'])
    register_Ns3RadioBearerStatsCalculator_methods(root_module, root_module['ns3::RadioBearerStatsCalculator'])
    register_Ns3RarLteControlMessage_methods(root_module, root_module['ns3::RarLteControlMessage'])
    register_Ns3RarLteControlMessageRar_methods(root_module, root_module['ns3::RarLteControlMessage::Rar'])
    register_Ns3RemSpectrumPhy_methods(root_module, root_module['ns3::RemSpectrumPhy'])
    register_Ns3RrComponentCarrierManager_methods(root_module, root_module['ns3::RrComponentCarrierManager'])
    register_Ns3RrFfMacScheduler_methods(root_module, root_module['ns3::RrFfMacScheduler'])
    register_Ns3RrcAsn1Header_methods(root_module, root_module['ns3::RrcAsn1Header'])
    register_Ns3RrcDlCcchMessage_methods(root_module, root_module['ns3::RrcDlCcchMessage'])
    register_Ns3RrcDlDcchMessage_methods(root_module, root_module['ns3::RrcDlDcchMessage'])
    register_Ns3RrcUlCcchMessage_methods(root_module, root_module['ns3::RrcUlCcchMessage'])
    register_Ns3RrcUlDcchMessage_methods(root_module, root_module['ns3::RrcUlDcchMessage'])
    register_Ns3Sib1LteControlMessage_methods(root_module, root_module['ns3::Sib1LteControlMessage'])
    register_Ns3SimpleUeComponentCarrierManager_methods(root_module, root_module['ns3::SimpleUeComponentCarrierManager'])
    register_Ns3SpectrumChannel_methods(root_module, root_module['ns3::SpectrumChannel'])
    register_Ns3SrsCqiRntiVsp_methods(root_module, root_module['ns3::SrsCqiRntiVsp'])
    register_Ns3StringChecker_methods(root_module, root_module['ns3::StringChecker'])
    register_Ns3StringValue_methods(root_module, root_module['ns3::StringValue'])
    register_Ns3TdBetFfMacScheduler_methods(root_module, root_module['ns3::TdBetFfMacScheduler'])
    register_Ns3TdMtFfMacScheduler_methods(root_module, root_module['ns3::TdMtFfMacScheduler'])
    register_Ns3TdTbfqFfMacScheduler_methods(root_module, root_module['ns3::TdTbfqFfMacScheduler'])
    register_Ns3TimeValue_methods(root_module, root_module['ns3::TimeValue'])
    register_Ns3TtaFfMacScheduler_methods(root_module, root_module['ns3::TtaFfMacScheduler'])
    register_Ns3TypeIdChecker_methods(root_module, root_module['ns3::TypeIdChecker'])
    register_Ns3TypeIdValue_methods(root_module, root_module['ns3::TypeIdValue'])
    register_Ns3UintegerValue_methods(root_module, root_module['ns3::UintegerValue'])
    register_Ns3UlDciLteControlMessage_methods(root_module, root_module['ns3::UlDciLteControlMessage'])
    register_Ns3Vector2DChecker_methods(root_module, root_module['ns3::Vector2DChecker'])
    register_Ns3Vector2DValue_methods(root_module, root_module['ns3::Vector2DValue'])
    register_Ns3Vector3DChecker_methods(root_module, root_module['ns3::Vector3DChecker'])
    register_Ns3Vector3DValue_methods(root_module, root_module['ns3::Vector3DValue'])
    register_Ns3VirtualNetDevice_methods(root_module, root_module['ns3::VirtualNetDevice'])
    register_Ns3A2A4RsrqHandoverAlgorithm_methods(root_module, root_module['ns3::A2A4RsrqHandoverAlgorithm'])
    register_Ns3A3RsrpHandoverAlgorithm_methods(root_module, root_module['ns3::A3RsrpHandoverAlgorithm'])
    register_Ns3AddressChecker_methods(root_module, root_module['ns3::AddressChecker'])
    register_Ns3AddressValue_methods(root_module, root_module['ns3::AddressValue'])
    register_Ns3BsrLteControlMessage_methods(root_module, root_module['ns3::BsrLteControlMessage'])
    register_Ns3CallbackImpl__Bool_Ns3Ptr__lt__ns3NetDevice__gt___Ns3Ptr__lt__const_ns3Packet__gt___Unsigned_short_Const_ns3Address___amp___Const_ns3Address___amp___Ns3NetDevicePacketType_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< bool, ns3::Ptr<ns3::NetDevice>, ns3::Ptr<const ns3::Packet>, unsigned short, const ns3::Address &, const ns3::Address &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Bool_Ns3Ptr__lt__ns3NetDevice__gt___Ns3Ptr__lt__const_ns3Packet__gt___Unsigned_short_Const_ns3Address___amp___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< bool, ns3::Ptr<ns3::NetDevice>, ns3::Ptr<const ns3::Packet>, unsigned short, const ns3::Address &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Bool_Ns3Ptr__lt__ns3Packet__gt___Const_ns3Address___amp___Const_ns3Address___amp___Unsigned_short_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< bool, ns3::Ptr<ns3::Packet>, const ns3::Address &, const ns3::Address &, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Bool_Ns3Ptr__lt__ns3Socket__gt___Const_ns3Address___amp___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< bool, ns3::Ptr<ns3::Socket>, const ns3::Address &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Ns3ObjectBase___star___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< ns3::ObjectBase *, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Const_ns3SpectrumValue___amp___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, const ns3::SpectrumValue &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3DlSchedulingCallbackInfo_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::DlSchedulingCallbackInfo, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3EpcUeNasState_Ns3EpcUeNasState_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::EpcUeNas::State, ns3::EpcUeNas::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3PhyReceptionStatParameters_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::PhyReceptionStatParameters, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3PhyTransmissionStatParameters_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::PhyTransmissionStatParameters, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__const_ns3MobilityModel__gt___Ns3Ptr__lt__const_ns3MobilityModel__gt___Double_Double_Double_Double_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<const ns3::MobilityModel>, ns3::Ptr<const ns3::MobilityModel>, double, double, double, double, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__const_ns3MobilityModel__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<const ns3::MobilityModel>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__const_ns3Packet__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<const ns3::Packet>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__const_ns3PacketBurst__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<const ns3::PacketBurst>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__const_ns3SpectrumPhy__gt___Ns3Ptr__lt__const_ns3SpectrumPhy__gt___Double_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<const ns3::SpectrumPhy>, ns3::Ptr<const ns3::SpectrumPhy>, double, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3LteUeRrc__gt___StdList__lt__ns3LteRrcSapSCellToAddMod__stdAllocator__lt__ns3LteRrcSapSCellToAddMod__gt_____gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::LteUeRrc>, std::list<ns3::LteRrcSap::SCellToAddMod, std::allocator<ns3::LteRrcSap::SCellToAddMod> >, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3NetDevice__gt___Ns3Ptr__lt__const_ns3Packet__gt___Unsigned_short_Const_ns3Address___amp___Const_ns3Address___amp___Ns3NetDevicePacketType_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::NetDevice>, ns3::Ptr<const ns3::Packet>, unsigned short, const ns3::Address &, const ns3::Address &, ns3::NetDevice::PacketType, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3NetDevice__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::NetDevice>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3Packet__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::Packet>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3Socket__gt___Const_ns3Address___amp___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::Socket>, const ns3::Address &, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3Socket__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::Socket>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3Socket__gt___Unsigned_int_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::Socket>, unsigned int, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Ptr__lt__ns3SpectrumSignalParameters__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::Ptr<ns3::SpectrumSignalParameters>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_int_Unsigned_int_Unsigned_short_Unsigned_char_Unsigned_short_Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned int, unsigned int, unsigned short, unsigned char, unsigned short, unsigned char, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Bool_Unsigned_char_Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, bool, unsigned char, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_Ns3LteRrcSapMeasurementReport_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, ns3::LteRrcSap::MeasurementReport, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_Ns3LteUeRrcState_Ns3LteUeRrcState_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, ns3::LteUeRrc::State, ns3::LteUeRrc::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_Ns3UeManagerState_Ns3UeManagerState_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, ns3::UeManager::State, ns3::UeManager::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_StdBasic_string__lt__char__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, std::basic_string<char>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_StdBasic_string__lt__char__gt___Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, std::basic_string<char>, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_long_Unsigned_short_Unsigned_short_Unsigned_short_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned long long, unsigned short, unsigned short, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Ns3Ptr__lt__ns3SpectrumValue__gt___Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, ns3::Ptr<ns3::SpectrumValue>, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_char_Unsigned_int_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned char, unsigned int, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_char_Unsigned_int_Unsigned_long_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned char, unsigned int, unsigned long long, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_short_Double_Double_Bool_Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned short, double, double, bool, unsigned char, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_short_Double_Double_Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned short, double, double, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_short_Double_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned short, double, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_short_Double_Unsigned_char_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned short, double, unsigned char, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_short_Ns3LteUePhyState_Ns3LteUePhyState_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned short, ns3::LteUePhy::State, ns3::LteUePhy::State, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CallbackImpl__Void_Unsigned_short_Unsigned_short_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_Ns3Empty_methods(root_module, root_module['ns3::CallbackImpl< void, unsigned short, unsigned short, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >'])
    register_Ns3CqaFfMacScheduler_methods(root_module, root_module['ns3::CqaFfMacScheduler'])
    register_Ns3DlCqiLteControlMessage_methods(root_module, root_module['ns3::DlCqiLteControlMessage'])
    register_Ns3DlDciLteControlMessage_methods(root_module, root_module['ns3::DlDciLteControlMessage'])
    register_Ns3DlHarqFeedbackLteControlMessage_methods(root_module, root_module['ns3::DlHarqFeedbackLteControlMessage'])
    register_Ns3EmuEpcHelper_methods(root_module, root_module['ns3::EmuEpcHelper'])
    register_Ns3FdBetFfMacScheduler_methods(root_module, root_module['ns3::FdBetFfMacScheduler'])
    register_Ns3FdMtFfMacScheduler_methods(root_module, root_module['ns3::FdMtFfMacScheduler'])
    register_Ns3FdTbfqFfMacScheduler_methods(root_module, root_module['ns3::FdTbfqFfMacScheduler'])
    register_Ns3GtpcCreateSessionRequestMessage_methods(root_module, root_module['ns3::GtpcCreateSessionRequestMessage'])
    register_Ns3GtpcCreateSessionRequestMessageBearerContextToBeCreated_methods(root_module, root_module['ns3::GtpcCreateSessionRequestMessage::BearerContextToBeCreated'])
    register_Ns3GtpcCreateSessionResponseMessage_methods(root_module, root_module['ns3::GtpcCreateSessionResponseMessage'])
    register_Ns3GtpcCreateSessionResponseMessageBearerContextCreated_methods(root_module, root_module['ns3::GtpcCreateSessionResponseMessage::BearerContextCreated'])
    register_Ns3GtpcDeleteBearerCommandMessage_methods(root_module, root_module['ns3::GtpcDeleteBearerCommandMessage'])
    register_Ns3GtpcDeleteBearerCommandMessageBearerContext_methods(root_module, root_module['ns3::GtpcDeleteBearerCommandMessage::BearerContext'])
    register_Ns3GtpcDeleteBearerRequestMessage_methods(root_module, root_module['ns3::GtpcDeleteBearerRequestMessage'])
    register_Ns3GtpcDeleteBearerResponseMessage_methods(root_module, root_module['ns3::GtpcDeleteBearerResponseMessage'])
    register_Ns3HandoverPreparationInfoHeader_methods(root_module, root_module['ns3::HandoverPreparationInfoHeader'])
    register_Ns3LteDataRadioBearerInfo_methods(root_module, root_module['ns3::LteDataRadioBearerInfo'])
    register_Ns3LteEnbPhy_methods(root_module, root_module['ns3::LteEnbPhy'])
    register_Ns3LteNetDevice_methods(root_module, root_module['ns3::LteNetDevice'])
    register_Ns3LteUeNetDevice_methods(root_module, root_module['ns3::LteUeNetDevice'])
    register_Ns3MeasurementReportHeader_methods(root_module, root_module['ns3::MeasurementReportHeader'])
    register_Ns3RrcConnectionReconfigurationCompleteHeader_methods(root_module, root_module['ns3::RrcConnectionReconfigurationCompleteHeader'])
    register_Ns3RrcConnectionReconfigurationHeader_methods(root_module, root_module['ns3::RrcConnectionReconfigurationHeader'])
    register_Ns3RrcConnectionReestablishmentCompleteHeader_methods(root_module, root_module['ns3::RrcConnectionReestablishmentCompleteHeader'])
    register_Ns3RrcConnectionReestablishmentHeader_methods(root_module, root_module['ns3::RrcConnectionReestablishmentHeader'])
    register_Ns3RrcConnectionReestablishmentRejectHeader_methods(root_module, root_module['ns3::RrcConnectionReestablishmentRejectHeader'])
    register_Ns3RrcConnectionReestablishmentRequestHeader_methods(root_module, root_module['ns3::RrcConnectionReestablishmentRequestHeader'])
    register_Ns3RrcConnectionRejectHeader_methods(root_module, root_module['ns3::RrcConnectionRejectHeader'])
    register_Ns3RrcConnectionReleaseHeader_methods(root_module, root_module['ns3::RrcConnectionReleaseHeader'])
    register_Ns3RrcConnectionRequestHeader_methods(root_module, root_module['ns3::RrcConnectionRequestHeader'])
    register_Ns3RrcConnectionSetupCompleteHeader_methods(root_module, root_module['ns3::RrcConnectionSetupCompleteHeader'])
    register_Ns3RrcConnectionSetupHeader_methods(root_module, root_module['ns3::RrcConnectionSetupHeader'])
    register_Ns3LteEnbNetDevice_methods(root_module, root_module['ns3::LteEnbNetDevice'])
    register_Ns3ConfigMatchContainer_methods(root_module, root_module['ns3::Config::MatchContainer'])
    register_Ns3HashImplementation_methods(root_module, root_module['ns3::Hash::Implementation'])
    register_Ns3HashFunctionFnv1a_methods(root_module, root_module['ns3::Hash::Function::Fnv1a'])
    register_Ns3HashFunctionHash32_methods(root_module, root_module['ns3::Hash::Function::Hash32'])
    register_Ns3HashFunctionHash64_methods(root_module, root_module['ns3::Hash::Function::Hash64'])
    register_Ns3HashFunctionMurmur3_methods(root_module, root_module['ns3::Hash::Function::Murmur3'])
    return

def register_Ns3Address_methods(root_module, cls):
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    cls.add_output_stream_operator()
    ## address.h (module 'network'): ns3::Address::Address() [constructor]
    cls.add_constructor([])
    ## address.h (module 'network'): ns3::Address::Address(uint8_t type, uint8_t const * buffer, uint8_t len) [constructor]
    cls.add_constructor([param('uint8_t', 'type'), param('uint8_t const *', 'buffer'), param('uint8_t', 'len')])
    ## address.h (module 'network'): ns3::Address::Address(ns3::Address const & address) [constructor]
    cls.add_constructor([param('ns3::Address const &', 'address')])
    ## address.h (module 'network'): bool ns3::Address::CheckCompatible(uint8_t type, uint8_t len) const [member function]
    cls.add_method('CheckCompatible', 
                   'bool', 
                   [param('uint8_t', 'type'), param('uint8_t', 'len')], 
                   is_const=True)
    ## address.h (module 'network'): uint32_t ns3::Address::CopyAllFrom(uint8_t const * buffer, uint8_t len) [member function]
    cls.add_method('CopyAllFrom', 
                   'uint32_t', 
                   [param('uint8_t const *', 'buffer'), param('uint8_t', 'len')])
    ## address.h (module 'network'): uint32_t ns3::Address::CopyAllTo(uint8_t * buffer, uint8_t len) const [member function]
    cls.add_method('CopyAllTo', 
                   'uint32_t', 
                   [param('uint8_t *', 'buffer'), param('uint8_t', 'len')], 
                   is_const=True)
    ## address.h (module 'network'): uint32_t ns3::Address::CopyFrom(uint8_t const * buffer, uint8_t len) [member function]
    cls.add_method('CopyFrom', 
                   'uint32_t', 
                   [param('uint8_t const *', 'buffer'), param('uint8_t', 'len')])
    ## address.h (module 'network'): uint32_t ns3::Address::CopyTo(uint8_t * buffer) const [member function]
    cls.add_method('CopyTo', 
                   'uint32_t', 
                   [param('uint8_t *', 'buffer')], 
                   is_const=True)
    ## address.h (module 'network'): void ns3::Address::Deserialize(ns3::TagBuffer buffer) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'buffer')])
    ## address.h (module 'network'): uint8_t ns3::Address::GetLength() const [member function]
    cls.add_method('GetLength', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## address.h (module 'network'): uint32_t ns3::Address::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## address.h (module 'network'): bool ns3::Address::IsInvalid() const [member function]
    cls.add_method('IsInvalid', 
                   'bool', 
                   [], 
                   is_const=True)
    ## address.h (module 'network'): bool ns3::Address::IsMatchingType(uint8_t type) const [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('uint8_t', 'type')], 
                   is_const=True)
    ## address.h (module 'network'): static uint8_t ns3::Address::Register() [member function]
    cls.add_method('Register', 
                   'uint8_t', 
                   [], 
                   is_static=True)
    ## address.h (module 'network'): void ns3::Address::Serialize(ns3::TagBuffer buffer) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'buffer')], 
                   is_const=True)
    return

def register_Ns3AllocationRetentionPriority_methods(root_module, cls):
    ## eps-bearer.h (module 'lte'): ns3::AllocationRetentionPriority::AllocationRetentionPriority(ns3::AllocationRetentionPriority const & arg0) [constructor]
    cls.add_constructor([param('ns3::AllocationRetentionPriority const &', 'arg0')])
    ## eps-bearer.h (module 'lte'): ns3::AllocationRetentionPriority::AllocationRetentionPriority() [constructor]
    cls.add_constructor([])
    ## eps-bearer.h (module 'lte'): ns3::AllocationRetentionPriority::preemptionCapability [variable]
    cls.add_instance_attribute('preemptionCapability', 'bool', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::AllocationRetentionPriority::preemptionVulnerability [variable]
    cls.add_instance_attribute('preemptionVulnerability', 'bool', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::AllocationRetentionPriority::priorityLevel [variable]
    cls.add_instance_attribute('priorityLevel', 'uint8_t', is_const=False)
    return

def register_Ns3AttributeConstructionList_methods(root_module, cls):
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::AttributeConstructionList(ns3::AttributeConstructionList const & arg0) [constructor]
    cls.add_constructor([param('ns3::AttributeConstructionList const &', 'arg0')])
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::AttributeConstructionList() [constructor]
    cls.add_constructor([])
    ## attribute-construction-list.h (module 'core'): void ns3::AttributeConstructionList::Add(std::string name, ns3::Ptr<const ns3::AttributeChecker> checker, ns3::Ptr<ns3::AttributeValue> value) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'name'), param('ns3::Ptr< ns3::AttributeChecker const >', 'checker'), param('ns3::Ptr< ns3::AttributeValue >', 'value')])
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::CIterator ns3::AttributeConstructionList::Begin() const [member function]
    cls.add_method('Begin', 
                   'ns3::AttributeConstructionList::CIterator', 
                   [], 
                   is_const=True)
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::CIterator ns3::AttributeConstructionList::End() const [member function]
    cls.add_method('End', 
                   'ns3::AttributeConstructionList::CIterator', 
                   [], 
                   is_const=True)
    ## attribute-construction-list.h (module 'core'): ns3::Ptr<ns3::AttributeValue> ns3::AttributeConstructionList::Find(ns3::Ptr<const ns3::AttributeChecker> checker) const [member function]
    cls.add_method('Find', 
                   'ns3::Ptr< ns3::AttributeValue >', 
                   [param('ns3::Ptr< ns3::AttributeChecker const >', 'checker')], 
                   is_const=True)
    return

def register_Ns3AttributeConstructionListItem_methods(root_module, cls):
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::Item::Item() [constructor]
    cls.add_constructor([])
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::Item::Item(ns3::AttributeConstructionList::Item const & arg0) [constructor]
    cls.add_constructor([param('ns3::AttributeConstructionList::Item const &', 'arg0')])
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::Item::checker [variable]
    cls.add_instance_attribute('checker', 'ns3::Ptr< ns3::AttributeChecker const >', is_const=False)
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::Item::name [variable]
    cls.add_instance_attribute('name', 'std::string', is_const=False)
    ## attribute-construction-list.h (module 'core'): ns3::AttributeConstructionList::Item::value [variable]
    cls.add_instance_attribute('value', 'ns3::Ptr< ns3::AttributeValue >', is_const=False)
    return

def register_Ns3BandInfo_methods(root_module, cls):
    ## spectrum-model.h (module 'spectrum'): ns3::BandInfo::BandInfo() [constructor]
    cls.add_constructor([])
    ## spectrum-model.h (module 'spectrum'): ns3::BandInfo::BandInfo(ns3::BandInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::BandInfo const &', 'arg0')])
    ## spectrum-model.h (module 'spectrum'): ns3::BandInfo::fc [variable]
    cls.add_instance_attribute('fc', 'double', is_const=False)
    ## spectrum-model.h (module 'spectrum'): ns3::BandInfo::fh [variable]
    cls.add_instance_attribute('fh', 'double', is_const=False)
    ## spectrum-model.h (module 'spectrum'): ns3::BandInfo::fl [variable]
    cls.add_instance_attribute('fl', 'double', is_const=False)
    return

def register_Ns3Buffer_methods(root_module, cls):
    ## buffer.h (module 'network'): ns3::Buffer::Buffer(ns3::Buffer const & o) [constructor]
    cls.add_constructor([param('ns3::Buffer const &', 'o')])
    ## buffer.h (module 'network'): ns3::Buffer::Buffer() [constructor]
    cls.add_constructor([])
    ## buffer.h (module 'network'): ns3::Buffer::Buffer(uint32_t dataSize) [constructor]
    cls.add_constructor([param('uint32_t', 'dataSize')])
    ## buffer.h (module 'network'): ns3::Buffer::Buffer(uint32_t dataSize, bool initialize) [constructor]
    cls.add_constructor([param('uint32_t', 'dataSize'), param('bool', 'initialize')])
    ## buffer.h (module 'network'): void ns3::Buffer::AddAtEnd(uint32_t end) [member function]
    cls.add_method('AddAtEnd', 
                   'void', 
                   [param('uint32_t', 'end')])
    ## buffer.h (module 'network'): void ns3::Buffer::AddAtEnd(ns3::Buffer const & o) [member function]
    cls.add_method('AddAtEnd', 
                   'void', 
                   [param('ns3::Buffer const &', 'o')])
    ## buffer.h (module 'network'): void ns3::Buffer::AddAtStart(uint32_t start) [member function]
    cls.add_method('AddAtStart', 
                   'void', 
                   [param('uint32_t', 'start')])
    ## buffer.h (module 'network'): ns3::Buffer::Iterator ns3::Buffer::Begin() const [member function]
    cls.add_method('Begin', 
                   'ns3::Buffer::Iterator', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): void ns3::Buffer::CopyData(std::ostream * os, uint32_t size) const [member function]
    cls.add_method('CopyData', 
                   'void', 
                   [param('std::ostream *', 'os'), param('uint32_t', 'size')], 
                   is_const=True)
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::CopyData(uint8_t * buffer, uint32_t size) const [member function]
    cls.add_method('CopyData', 
                   'uint32_t', 
                   [param('uint8_t *', 'buffer'), param('uint32_t', 'size')], 
                   is_const=True)
    ## buffer.h (module 'network'): ns3::Buffer ns3::Buffer::CreateFragment(uint32_t start, uint32_t length) const [member function]
    cls.add_method('CreateFragment', 
                   'ns3::Buffer', 
                   [param('uint32_t', 'start'), param('uint32_t', 'length')], 
                   is_const=True)
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Deserialize(uint8_t const * buffer, uint32_t size) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('uint8_t const *', 'buffer'), param('uint32_t', 'size')])
    ## buffer.h (module 'network'): ns3::Buffer::Iterator ns3::Buffer::End() const [member function]
    cls.add_method('End', 
                   'ns3::Buffer::Iterator', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::GetSize() const [member function]
    cls.add_method('GetSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): uint8_t const * ns3::Buffer::PeekData() const [member function]
    cls.add_method('PeekData', 
                   'uint8_t const *', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): void ns3::Buffer::RemoveAtEnd(uint32_t end) [member function]
    cls.add_method('RemoveAtEnd', 
                   'void', 
                   [param('uint32_t', 'end')])
    ## buffer.h (module 'network'): void ns3::Buffer::RemoveAtStart(uint32_t start) [member function]
    cls.add_method('RemoveAtStart', 
                   'void', 
                   [param('uint32_t', 'start')])
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Serialize(uint8_t * buffer, uint32_t maxSize) const [member function]
    cls.add_method('Serialize', 
                   'uint32_t', 
                   [param('uint8_t *', 'buffer'), param('uint32_t', 'maxSize')], 
                   is_const=True)
    return

def register_Ns3BufferIterator_methods(root_module, cls):
    ## buffer.h (module 'network'): ns3::Buffer::Iterator::Iterator(ns3::Buffer::Iterator const & arg0) [constructor]
    cls.add_constructor([param('ns3::Buffer::Iterator const &', 'arg0')])
    ## buffer.h (module 'network'): ns3::Buffer::Iterator::Iterator() [constructor]
    cls.add_constructor([])
    ## buffer.h (module 'network'): uint16_t ns3::Buffer::Iterator::CalculateIpChecksum(uint16_t size) [member function]
    cls.add_method('CalculateIpChecksum', 
                   'uint16_t', 
                   [param('uint16_t', 'size')])
    ## buffer.h (module 'network'): uint16_t ns3::Buffer::Iterator::CalculateIpChecksum(uint16_t size, uint32_t initialChecksum) [member function]
    cls.add_method('CalculateIpChecksum', 
                   'uint16_t', 
                   [param('uint16_t', 'size'), param('uint32_t', 'initialChecksum')])
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Iterator::GetDistanceFrom(ns3::Buffer::Iterator const & o) const [member function]
    cls.add_method('GetDistanceFrom', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator const &', 'o')], 
                   is_const=True)
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Iterator::GetRemainingSize() const [member function]
    cls.add_method('GetRemainingSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Iterator::GetSize() const [member function]
    cls.add_method('GetSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): bool ns3::Buffer::Iterator::IsEnd() const [member function]
    cls.add_method('IsEnd', 
                   'bool', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): bool ns3::Buffer::Iterator::IsStart() const [member function]
    cls.add_method('IsStart', 
                   'bool', 
                   [], 
                   is_const=True)
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Next() [member function]
    cls.add_method('Next', 
                   'void', 
                   [])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Next(uint32_t delta) [member function]
    cls.add_method('Next', 
                   'void', 
                   [param('uint32_t', 'delta')])
    ## buffer.h (module 'network'): uint8_t ns3::Buffer::Iterator::PeekU8() [member function]
    cls.add_method('PeekU8', 
                   'uint8_t', 
                   [])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Prev() [member function]
    cls.add_method('Prev', 
                   'void', 
                   [])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Prev(uint32_t delta) [member function]
    cls.add_method('Prev', 
                   'void', 
                   [param('uint32_t', 'delta')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Read(uint8_t * buffer, uint32_t size) [member function]
    cls.add_method('Read', 
                   'void', 
                   [param('uint8_t *', 'buffer'), param('uint32_t', 'size')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Read(ns3::Buffer::Iterator start, uint32_t size) [member function]
    cls.add_method('Read', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start'), param('uint32_t', 'size')])
    ## buffer.h (module 'network'): uint16_t ns3::Buffer::Iterator::ReadLsbtohU16() [member function]
    cls.add_method('ReadLsbtohU16', 
                   'uint16_t', 
                   [])
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Iterator::ReadLsbtohU32() [member function]
    cls.add_method('ReadLsbtohU32', 
                   'uint32_t', 
                   [])
    ## buffer.h (module 'network'): uint64_t ns3::Buffer::Iterator::ReadLsbtohU64() [member function]
    cls.add_method('ReadLsbtohU64', 
                   'uint64_t', 
                   [])
    ## buffer.h (module 'network'): uint16_t ns3::Buffer::Iterator::ReadNtohU16() [member function]
    cls.add_method('ReadNtohU16', 
                   'uint16_t', 
                   [])
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Iterator::ReadNtohU32() [member function]
    cls.add_method('ReadNtohU32', 
                   'uint32_t', 
                   [])
    ## buffer.h (module 'network'): uint64_t ns3::Buffer::Iterator::ReadNtohU64() [member function]
    cls.add_method('ReadNtohU64', 
                   'uint64_t', 
                   [])
    ## buffer.h (module 'network'): uint16_t ns3::Buffer::Iterator::ReadU16() [member function]
    cls.add_method('ReadU16', 
                   'uint16_t', 
                   [])
    ## buffer.h (module 'network'): uint32_t ns3::Buffer::Iterator::ReadU32() [member function]
    cls.add_method('ReadU32', 
                   'uint32_t', 
                   [])
    ## buffer.h (module 'network'): uint64_t ns3::Buffer::Iterator::ReadU64() [member function]
    cls.add_method('ReadU64', 
                   'uint64_t', 
                   [])
    ## buffer.h (module 'network'): uint8_t ns3::Buffer::Iterator::ReadU8() [member function]
    cls.add_method('ReadU8', 
                   'uint8_t', 
                   [])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Write(uint8_t const * buffer, uint32_t size) [member function]
    cls.add_method('Write', 
                   'void', 
                   [param('uint8_t const *', 'buffer'), param('uint32_t', 'size')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::Write(ns3::Buffer::Iterator start, ns3::Buffer::Iterator end) [member function]
    cls.add_method('Write', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start'), param('ns3::Buffer::Iterator', 'end')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteHtolsbU16(uint16_t data) [member function]
    cls.add_method('WriteHtolsbU16', 
                   'void', 
                   [param('uint16_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteHtolsbU32(uint32_t data) [member function]
    cls.add_method('WriteHtolsbU32', 
                   'void', 
                   [param('uint32_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteHtolsbU64(uint64_t data) [member function]
    cls.add_method('WriteHtolsbU64', 
                   'void', 
                   [param('uint64_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteHtonU16(uint16_t data) [member function]
    cls.add_method('WriteHtonU16', 
                   'void', 
                   [param('uint16_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteHtonU32(uint32_t data) [member function]
    cls.add_method('WriteHtonU32', 
                   'void', 
                   [param('uint32_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteHtonU64(uint64_t data) [member function]
    cls.add_method('WriteHtonU64', 
                   'void', 
                   [param('uint64_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteU16(uint16_t data) [member function]
    cls.add_method('WriteU16', 
                   'void', 
                   [param('uint16_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteU32(uint32_t data) [member function]
    cls.add_method('WriteU32', 
                   'void', 
                   [param('uint32_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteU64(uint64_t data) [member function]
    cls.add_method('WriteU64', 
                   'void', 
                   [param('uint64_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteU8(uint8_t data) [member function]
    cls.add_method('WriteU8', 
                   'void', 
                   [param('uint8_t', 'data')])
    ## buffer.h (module 'network'): void ns3::Buffer::Iterator::WriteU8(uint8_t data, uint32_t len) [member function]
    cls.add_method('WriteU8', 
                   'void', 
                   [param('uint8_t', 'data'), param('uint32_t', 'len')])
    return

def register_Ns3BufferSizeLevelBsr_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::BufferSizeLevelBsr::BufferSizeLevelBsr() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::BufferSizeLevelBsr::BufferSizeLevelBsr(ns3::BufferSizeLevelBsr const & arg0) [constructor]
    cls.add_constructor([param('ns3::BufferSizeLevelBsr const &', 'arg0')])
    ## lte-common.h (module 'lte'): static uint32_t ns3::BufferSizeLevelBsr::BsrId2BufferSize(uint8_t val) [member function]
    cls.add_method('BsrId2BufferSize', 
                   'uint32_t', 
                   [param('uint8_t', 'val')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static uint8_t ns3::BufferSizeLevelBsr::BufferSize2BsrId(uint32_t val) [member function]
    cls.add_method('BufferSize2BsrId', 
                   'uint8_t', 
                   [param('uint32_t', 'val')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): ns3::BufferSizeLevelBsr::m_bufferSizeLevelBsr [variable]
    cls.add_static_attribute('m_bufferSizeLevelBsr', 'int [ 64 ]', is_const=False)
    return

def register_Ns3BuildBroadcastListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s::BuildBroadcastListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s::BuildBroadcastListElement_s(ns3::BuildBroadcastListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::BuildBroadcastListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s::m_dci [variable]
    cls.add_instance_attribute('m_dci', 'ns3::DlDciListElement_s', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s::m_index [variable]
    cls.add_instance_attribute('m_index', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildBroadcastListElement_s::m_type [variable]
    cls.add_instance_attribute('m_type', 'ns3::BuildBroadcastListElement_s::Type_e', is_const=False)
    return

def register_Ns3BuildDataListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s::BuildDataListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s::BuildDataListElement_s(ns3::BuildDataListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::BuildDataListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s::m_ceBitmap [variable]
    cls.add_instance_attribute('m_ceBitmap', 'std::vector< ns3::CeBitmap_e >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s::m_dci [variable]
    cls.add_instance_attribute('m_dci', 'ns3::DlDciListElement_s', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s::m_rlcPduList [variable]
    cls.add_instance_attribute('m_rlcPduList', 'std::vector< std::vector< ns3::RlcPduListElement_s > >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildDataListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3BuildRarListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::BuildRarListElement_s::BuildRarListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::BuildRarListElement_s::BuildRarListElement_s(ns3::BuildRarListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::BuildRarListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::BuildRarListElement_s::m_dci [variable]
    cls.add_instance_attribute('m_dci', 'ns3::DlDciListElement_s', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildRarListElement_s::m_grant [variable]
    cls.add_instance_attribute('m_grant', 'ns3::UlGrant_s', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BuildRarListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3BwPart_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::BwPart_s::BwPart_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::BwPart_s::BwPart_s(ns3::BwPart_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::BwPart_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::BwPart_s::m_bwPartIndex [variable]
    cls.add_instance_attribute('m_bwPartIndex', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BwPart_s::m_cqi [variable]
    cls.add_instance_attribute('m_cqi', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::BwPart_s::m_sb [variable]
    cls.add_instance_attribute('m_sb', 'uint8_t', is_const=False)
    return

def register_Ns3ByteTagIterator_methods(root_module, cls):
    ## packet.h (module 'network'): ns3::ByteTagIterator::ByteTagIterator(ns3::ByteTagIterator const & arg0) [constructor]
    cls.add_constructor([param('ns3::ByteTagIterator const &', 'arg0')])
    ## packet.h (module 'network'): bool ns3::ByteTagIterator::HasNext() const [member function]
    cls.add_method('HasNext', 
                   'bool', 
                   [], 
                   is_const=True)
    ## packet.h (module 'network'): ns3::ByteTagIterator::Item ns3::ByteTagIterator::Next() [member function]
    cls.add_method('Next', 
                   'ns3::ByteTagIterator::Item', 
                   [])
    return

def register_Ns3ByteTagIteratorItem_methods(root_module, cls):
    ## packet.h (module 'network'): ns3::ByteTagIterator::Item::Item(ns3::ByteTagIterator::Item const & arg0) [constructor]
    cls.add_constructor([param('ns3::ByteTagIterator::Item const &', 'arg0')])
    ## packet.h (module 'network'): uint32_t ns3::ByteTagIterator::Item::GetEnd() const [member function]
    cls.add_method('GetEnd', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## packet.h (module 'network'): uint32_t ns3::ByteTagIterator::Item::GetStart() const [member function]
    cls.add_method('GetStart', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## packet.h (module 'network'): void ns3::ByteTagIterator::Item::GetTag(ns3::Tag & tag) const [member function]
    cls.add_method('GetTag', 
                   'void', 
                   [param('ns3::Tag &', 'tag')], 
                   is_const=True)
    ## packet.h (module 'network'): ns3::TypeId ns3::ByteTagIterator::Item::GetTypeId() const [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True)
    return

def register_Ns3ByteTagList_methods(root_module, cls):
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::ByteTagList() [constructor]
    cls.add_constructor([])
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::ByteTagList(ns3::ByteTagList const & o) [constructor]
    cls.add_constructor([param('ns3::ByteTagList const &', 'o')])
    ## byte-tag-list.h (module 'network'): ns3::TagBuffer ns3::ByteTagList::Add(ns3::TypeId tid, uint32_t bufferSize, int32_t start, int32_t end) [member function]
    cls.add_method('Add', 
                   'ns3::TagBuffer', 
                   [param('ns3::TypeId', 'tid'), param('uint32_t', 'bufferSize'), param('int32_t', 'start'), param('int32_t', 'end')])
    ## byte-tag-list.h (module 'network'): void ns3::ByteTagList::Add(ns3::ByteTagList const & o) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::ByteTagList const &', 'o')])
    ## byte-tag-list.h (module 'network'): void ns3::ByteTagList::AddAtEnd(int32_t appendOffset) [member function]
    cls.add_method('AddAtEnd', 
                   'void', 
                   [param('int32_t', 'appendOffset')])
    ## byte-tag-list.h (module 'network'): void ns3::ByteTagList::AddAtStart(int32_t prependOffset) [member function]
    cls.add_method('AddAtStart', 
                   'void', 
                   [param('int32_t', 'prependOffset')])
    ## byte-tag-list.h (module 'network'): void ns3::ByteTagList::Adjust(int32_t adjustment) [member function]
    cls.add_method('Adjust', 
                   'void', 
                   [param('int32_t', 'adjustment')])
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator ns3::ByteTagList::Begin(int32_t offsetStart, int32_t offsetEnd) const [member function]
    cls.add_method('Begin', 
                   'ns3::ByteTagList::Iterator', 
                   [param('int32_t', 'offsetStart'), param('int32_t', 'offsetEnd')], 
                   is_const=True)
    ## byte-tag-list.h (module 'network'): void ns3::ByteTagList::RemoveAll() [member function]
    cls.add_method('RemoveAll', 
                   'void', 
                   [])
    return

def register_Ns3ByteTagListIterator_methods(root_module, cls):
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Iterator(ns3::ByteTagList::Iterator const & arg0) [constructor]
    cls.add_constructor([param('ns3::ByteTagList::Iterator const &', 'arg0')])
    ## byte-tag-list.h (module 'network'): uint32_t ns3::ByteTagList::Iterator::GetOffsetStart() const [member function]
    cls.add_method('GetOffsetStart', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## byte-tag-list.h (module 'network'): bool ns3::ByteTagList::Iterator::HasNext() const [member function]
    cls.add_method('HasNext', 
                   'bool', 
                   [], 
                   is_const=True)
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item ns3::ByteTagList::Iterator::Next() [member function]
    cls.add_method('Next', 
                   'ns3::ByteTagList::Iterator::Item', 
                   [])
    return

def register_Ns3ByteTagListIteratorItem_methods(root_module, cls):
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::Item(ns3::ByteTagList::Iterator::Item const & arg0) [constructor]
    cls.add_constructor([param('ns3::ByteTagList::Iterator::Item const &', 'arg0')])
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::Item(ns3::TagBuffer buf) [constructor]
    cls.add_constructor([param('ns3::TagBuffer', 'buf')])
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::buf [variable]
    cls.add_instance_attribute('buf', 'ns3::TagBuffer', is_const=False)
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::end [variable]
    cls.add_instance_attribute('end', 'int32_t', is_const=False)
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::size [variable]
    cls.add_instance_attribute('size', 'uint32_t', is_const=False)
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::start [variable]
    cls.add_instance_attribute('start', 'int32_t', is_const=False)
    ## byte-tag-list.h (module 'network'): ns3::ByteTagList::Iterator::Item::tid [variable]
    cls.add_instance_attribute('tid', 'ns3::TypeId', is_const=False)
    return

def register_Ns3CallbackBase_methods(root_module, cls):
    ## callback.h (module 'core'): ns3::CallbackBase::CallbackBase(ns3::CallbackBase const & arg0) [constructor]
    cls.add_constructor([param('ns3::CallbackBase const &', 'arg0')])
    ## callback.h (module 'core'): ns3::CallbackBase::CallbackBase() [constructor]
    cls.add_constructor([])
    ## callback.h (module 'core'): ns3::Ptr<ns3::CallbackImplBase> ns3::CallbackBase::GetImpl() const [member function]
    cls.add_method('GetImpl', 
                   'ns3::Ptr< ns3::CallbackImplBase >', 
                   [], 
                   is_const=True)
    ## callback.h (module 'core'): ns3::CallbackBase::CallbackBase(ns3::Ptr<ns3::CallbackImplBase> impl) [constructor]
    cls.add_constructor([param('ns3::Ptr< ns3::CallbackImplBase >', 'impl')], 
                        visibility='protected')
    return

def register_Ns3CqasFlowPerf_t_methods(root_module, cls):
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::CqasFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::CqasFlowPerf_t(ns3::CqasFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::CqasFlowPerf_t const &', 'arg0')])
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::lastAveragedThroughput [variable]
    cls.add_instance_attribute('lastAveragedThroughput', 'double', is_const=False)
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::lastTtiBytesTransmitted [variable]
    cls.add_instance_attribute('lastTtiBytesTransmitted', 'unsigned int', is_const=False)
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::secondLastAveragedThroughput [variable]
    cls.add_instance_attribute('secondLastAveragedThroughput', 'double', is_const=False)
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::targetThroughput [variable]
    cls.add_instance_attribute('targetThroughput', 'double', is_const=False)
    ## cqa-ff-mac-scheduler.h (module 'lte'): ns3::CqasFlowPerf_t::totalBytesTransmitted [variable]
    cls.add_instance_attribute('totalBytesTransmitted', 'long unsigned int', is_const=False)
    return

def register_Ns3CqiConfig_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::CqiConfig_s::CqiConfig_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::CqiConfig_s::CqiConfig_s(ns3::CqiConfig_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::CqiConfig_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::CqiConfig_s::m_action [variable]
    cls.add_instance_attribute('m_action', 'ns3::SetupRelease_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiConfig_s::m_cqiSchedInterval [variable]
    cls.add_instance_attribute('m_cqiSchedInterval', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiConfig_s::m_riSchedInterval [variable]
    cls.add_instance_attribute('m_riSchedInterval', 'uint8_t', is_const=False)
    return

def register_Ns3CqiListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::CqiListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::CqiListElement_s(ns3::CqiListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::CqiListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::m_cqiType [variable]
    cls.add_instance_attribute('m_cqiType', 'ns3::CqiListElement_s::CqiType_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::m_ri [variable]
    cls.add_instance_attribute('m_ri', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::m_sbMeasResult [variable]
    cls.add_instance_attribute('m_sbMeasResult', 'ns3::SbMeasResult_s', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::m_wbCqi [variable]
    cls.add_instance_attribute('m_wbCqi', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::CqiListElement_s::m_wbPmi [variable]
    cls.add_instance_attribute('m_wbPmi', 'uint8_t', is_const=False)
    return

def register_Ns3DataOutputCallback_methods(root_module, cls):
    ## data-output-interface.h (module 'stats'): ns3::DataOutputCallback::DataOutputCallback() [constructor]
    cls.add_constructor([])
    ## data-output-interface.h (module 'stats'): ns3::DataOutputCallback::DataOutputCallback(ns3::DataOutputCallback const & arg0) [constructor]
    cls.add_constructor([param('ns3::DataOutputCallback const &', 'arg0')])
    ## data-output-interface.h (module 'stats'): void ns3::DataOutputCallback::OutputSingleton(std::string key, std::string variable, int val) [member function]
    cls.add_method('OutputSingleton', 
                   'void', 
                   [param('std::string', 'key'), param('std::string', 'variable'), param('int', 'val')], 
                   is_virtual=True, is_pure_virtual=True)
    ## data-output-interface.h (module 'stats'): void ns3::DataOutputCallback::OutputSingleton(std::string key, std::string variable, uint32_t val) [member function]
    cls.add_method('OutputSingleton', 
                   'void', 
                   [param('std::string', 'key'), param('std::string', 'variable'), param('uint32_t', 'val')], 
                   is_virtual=True, is_pure_virtual=True)
    ## data-output-interface.h (module 'stats'): void ns3::DataOutputCallback::OutputSingleton(std::string key, std::string variable, double val) [member function]
    cls.add_method('OutputSingleton', 
                   'void', 
                   [param('std::string', 'key'), param('std::string', 'variable'), param('double', 'val')], 
                   is_virtual=True, is_pure_virtual=True)
    ## data-output-interface.h (module 'stats'): void ns3::DataOutputCallback::OutputSingleton(std::string key, std::string variable, std::string val) [member function]
    cls.add_method('OutputSingleton', 
                   'void', 
                   [param('std::string', 'key'), param('std::string', 'variable'), param('std::string', 'val')], 
                   is_virtual=True, is_pure_virtual=True)
    ## data-output-interface.h (module 'stats'): void ns3::DataOutputCallback::OutputSingleton(std::string key, std::string variable, ns3::Time val) [member function]
    cls.add_method('OutputSingleton', 
                   'void', 
                   [param('std::string', 'key'), param('std::string', 'variable'), param('ns3::Time', 'val')], 
                   is_virtual=True, is_pure_virtual=True)
    ## data-output-interface.h (module 'stats'): void ns3::DataOutputCallback::OutputStatistic(std::string key, std::string variable, ns3::StatisticalSummary const * statSum) [member function]
    cls.add_method('OutputStatistic', 
                   'void', 
                   [param('std::string', 'key'), param('std::string', 'variable'), param('ns3::StatisticalSummary const *', 'statSum')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3DataRate_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('<=')
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('>')
    cls.add_binary_comparison_operator('>=')
    ## data-rate.h (module 'network'): ns3::DataRate::DataRate(ns3::DataRate const & arg0) [constructor]
    cls.add_constructor([param('ns3::DataRate const &', 'arg0')])
    ## data-rate.h (module 'network'): ns3::DataRate::DataRate() [constructor]
    cls.add_constructor([])
    ## data-rate.h (module 'network'): ns3::DataRate::DataRate(uint64_t bps) [constructor]
    cls.add_constructor([param('uint64_t', 'bps')])
    ## data-rate.h (module 'network'): ns3::DataRate::DataRate(std::string rate) [constructor]
    cls.add_constructor([param('std::string', 'rate')])
    ## data-rate.h (module 'network'): ns3::Time ns3::DataRate::CalculateBitsTxTime(uint32_t bits) const [member function]
    cls.add_method('CalculateBitsTxTime', 
                   'ns3::Time', 
                   [param('uint32_t', 'bits')], 
                   is_const=True)
    ## data-rate.h (module 'network'): ns3::Time ns3::DataRate::CalculateBytesTxTime(uint32_t bytes) const [member function]
    cls.add_method('CalculateBytesTxTime', 
                   'ns3::Time', 
                   [param('uint32_t', 'bytes')], 
                   is_const=True)
    ## data-rate.h (module 'network'): double ns3::DataRate::CalculateTxTime(uint32_t bytes) const [member function]
    cls.add_method('CalculateTxTime', 
                   'double', 
                   [param('uint32_t', 'bytes')], 
                   is_const=True, deprecated=True)
    ## data-rate.h (module 'network'): uint64_t ns3::DataRate::GetBitRate() const [member function]
    cls.add_method('GetBitRate', 
                   'uint64_t', 
                   [], 
                   is_const=True)
    return

def register_Ns3DefaultDeleter__Ns3AttributeAccessor_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeAccessor>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeAccessor>::DefaultDeleter(ns3::DefaultDeleter<ns3::AttributeAccessor> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::AttributeAccessor > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::AttributeAccessor>::Delete(ns3::AttributeAccessor * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::AttributeAccessor *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3AttributeChecker_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeChecker>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeChecker>::DefaultDeleter(ns3::DefaultDeleter<ns3::AttributeChecker> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::AttributeChecker > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::AttributeChecker>::Delete(ns3::AttributeChecker * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::AttributeChecker *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3AttributeValue_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeValue>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::AttributeValue>::DefaultDeleter(ns3::DefaultDeleter<ns3::AttributeValue> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::AttributeValue > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::AttributeValue>::Delete(ns3::AttributeValue * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::AttributeValue *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3CallbackImplBase_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::CallbackImplBase>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::CallbackImplBase>::DefaultDeleter(ns3::DefaultDeleter<ns3::CallbackImplBase> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::CallbackImplBase > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::CallbackImplBase>::Delete(ns3::CallbackImplBase * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::CallbackImplBase *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3EpcTft_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::EpcTft>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::EpcTft>::DefaultDeleter(ns3::DefaultDeleter<ns3::EpcTft> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::EpcTft > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::EpcTft>::Delete(ns3::EpcTft * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::EpcTft *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3EventImpl_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::EventImpl>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::EventImpl>::DefaultDeleter(ns3::DefaultDeleter<ns3::EventImpl> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::EventImpl > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::EventImpl>::Delete(ns3::EventImpl * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::EventImpl *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3HashImplementation_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::Hash::Implementation>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::Hash::Implementation>::DefaultDeleter(ns3::DefaultDeleter<ns3::Hash::Implementation> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::Hash::Implementation > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::Hash::Implementation>::Delete(ns3::Hash::Implementation * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::Hash::Implementation *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3LteChunkProcessor_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteChunkProcessor>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteChunkProcessor>::DefaultDeleter(ns3::DefaultDeleter<ns3::LteChunkProcessor> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::LteChunkProcessor > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::LteChunkProcessor>::Delete(ns3::LteChunkProcessor * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::LteChunkProcessor *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3LteControlMessage_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteControlMessage>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteControlMessage>::DefaultDeleter(ns3::DefaultDeleter<ns3::LteControlMessage> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::LteControlMessage > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::LteControlMessage>::Delete(ns3::LteControlMessage * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::LteControlMessage *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3LteHarqPhy_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteHarqPhy>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::LteHarqPhy>::DefaultDeleter(ns3::DefaultDeleter<ns3::LteHarqPhy> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::LteHarqPhy > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::LteHarqPhy>::Delete(ns3::LteHarqPhy * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::LteHarqPhy *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3NixVector_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::NixVector>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::NixVector>::DefaultDeleter(ns3::DefaultDeleter<ns3::NixVector> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::NixVector > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::NixVector>::Delete(ns3::NixVector * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::NixVector *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3Packet_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::Packet>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::Packet>::DefaultDeleter(ns3::DefaultDeleter<ns3::Packet> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::Packet > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::Packet>::Delete(ns3::Packet * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::Packet *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3SpectrumModel_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumModel>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumModel>::DefaultDeleter(ns3::DefaultDeleter<ns3::SpectrumModel> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::SpectrumModel > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::SpectrumModel>::Delete(ns3::SpectrumModel * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::SpectrumModel *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3SpectrumSignalParameters_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumSignalParameters>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumSignalParameters>::DefaultDeleter(ns3::DefaultDeleter<ns3::SpectrumSignalParameters> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::SpectrumSignalParameters > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::SpectrumSignalParameters>::Delete(ns3::SpectrumSignalParameters * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::SpectrumSignalParameters *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3SpectrumValue_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumValue>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::SpectrumValue>::DefaultDeleter(ns3::DefaultDeleter<ns3::SpectrumValue> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::SpectrumValue > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::SpectrumValue>::Delete(ns3::SpectrumValue * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::SpectrumValue *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3TraceSourceAccessor_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::TraceSourceAccessor>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::TraceSourceAccessor>::DefaultDeleter(ns3::DefaultDeleter<ns3::TraceSourceAccessor> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::TraceSourceAccessor > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::TraceSourceAccessor>::Delete(ns3::TraceSourceAccessor * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::TraceSourceAccessor *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3VendorSpecificValue_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::VendorSpecificValue>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::VendorSpecificValue>::DefaultDeleter(ns3::DefaultDeleter<ns3::VendorSpecificValue> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::VendorSpecificValue > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::VendorSpecificValue>::Delete(ns3::VendorSpecificValue * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::VendorSpecificValue *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3X2CellInfo_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::X2CellInfo>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::X2CellInfo>::DefaultDeleter(ns3::DefaultDeleter<ns3::X2CellInfo> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::X2CellInfo > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::X2CellInfo>::Delete(ns3::X2CellInfo * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::X2CellInfo *', 'object')], 
                   is_static=True)
    return

def register_Ns3DefaultDeleter__Ns3X2IfaceInfo_methods(root_module, cls):
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::X2IfaceInfo>::DefaultDeleter() [constructor]
    cls.add_constructor([])
    ## default-deleter.h (module 'core'): ns3::DefaultDeleter<ns3::X2IfaceInfo>::DefaultDeleter(ns3::DefaultDeleter<ns3::X2IfaceInfo> const & arg0) [constructor]
    cls.add_constructor([param('ns3::DefaultDeleter< ns3::X2IfaceInfo > const &', 'arg0')])
    ## default-deleter.h (module 'core'): static void ns3::DefaultDeleter<ns3::X2IfaceInfo>::Delete(ns3::X2IfaceInfo * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::X2IfaceInfo *', 'object')], 
                   is_static=True)
    return

def register_Ns3DlDciListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::DlDciListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::DlDciListElement_s(ns3::DlDciListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::DlDciListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_aggrLevel [variable]
    cls.add_instance_attribute('m_aggrLevel', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_cceIndex [variable]
    cls.add_instance_attribute('m_cceIndex', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_dai [variable]
    cls.add_instance_attribute('m_dai', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_dlPowerOffset [variable]
    cls.add_instance_attribute('m_dlPowerOffset', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_format [variable]
    cls.add_instance_attribute('m_format', 'ns3::DlDciListElement_s::Format_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_harqProcess [variable]
    cls.add_instance_attribute('m_harqProcess', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_mcs [variable]
    cls.add_instance_attribute('m_mcs', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_nGap [variable]
    cls.add_instance_attribute('m_nGap', 'ns3::DlDciListElement_s::Ngap_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_ndi [variable]
    cls.add_instance_attribute('m_ndi', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_pdcchOrder [variable]
    cls.add_instance_attribute('m_pdcchOrder', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_pdcchPowerOffset [variable]
    cls.add_instance_attribute('m_pdcchPowerOffset', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_prachMaskIndex [variable]
    cls.add_instance_attribute('m_prachMaskIndex', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_preambleIndex [variable]
    cls.add_instance_attribute('m_preambleIndex', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_precodingInfo [variable]
    cls.add_instance_attribute('m_precodingInfo', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_rbBitmap [variable]
    cls.add_instance_attribute('m_rbBitmap', 'uint32_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_rbShift [variable]
    cls.add_instance_attribute('m_rbShift', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_resAlloc [variable]
    cls.add_instance_attribute('m_resAlloc', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_rv [variable]
    cls.add_instance_attribute('m_rv', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_spsRelease [variable]
    cls.add_instance_attribute('m_spsRelease', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_tbSwap [variable]
    cls.add_instance_attribute('m_tbSwap', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_tbsIdx [variable]
    cls.add_instance_attribute('m_tbsIdx', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_tbsSize [variable]
    cls.add_instance_attribute('m_tbsSize', 'std::vector< unsigned short >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_tpc [variable]
    cls.add_instance_attribute('m_tpc', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlDciListElement_s::m_vrbFormat [variable]
    cls.add_instance_attribute('m_vrbFormat', 'ns3::DlDciListElement_s::VrbFormat_e', is_const=False)
    return

def register_Ns3DlInfoListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s::DlInfoListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s::DlInfoListElement_s(ns3::DlInfoListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::DlInfoListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s::m_harqProcessId [variable]
    cls.add_instance_attribute('m_harqProcessId', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s::m_harqStatus [variable]
    cls.add_instance_attribute('m_harqStatus', 'std::vector< ns3::DlInfoListElement_s::HarqStatus_e >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DlInfoListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3DlSchedulingCallbackInfo_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::DlSchedulingCallbackInfo() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::DlSchedulingCallbackInfo(ns3::DlSchedulingCallbackInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::DlSchedulingCallbackInfo const &', 'arg0')])
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::componentCarrierId [variable]
    cls.add_instance_attribute('componentCarrierId', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::frameNo [variable]
    cls.add_instance_attribute('frameNo', 'uint32_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::mcsTb1 [variable]
    cls.add_instance_attribute('mcsTb1', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::mcsTb2 [variable]
    cls.add_instance_attribute('mcsTb2', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::sizeTb1 [variable]
    cls.add_instance_attribute('sizeTb1', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::sizeTb2 [variable]
    cls.add_instance_attribute('sizeTb2', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::DlSchedulingCallbackInfo::subframeNo [variable]
    cls.add_instance_attribute('subframeNo', 'uint32_t', is_const=False)
    return

def register_Ns3DrxConfig_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::DrxConfig_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::DrxConfig_s(ns3::DrxConfig_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::DrxConfig_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_drxInactivityTimer [variable]
    cls.add_instance_attribute('m_drxInactivityTimer', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_drxRetransmissionTimer [variable]
    cls.add_instance_attribute('m_drxRetransmissionTimer', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_drxShortCycleTimer [variable]
    cls.add_instance_attribute('m_drxShortCycleTimer', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_longDrxCycle [variable]
    cls.add_instance_attribute('m_longDrxCycle', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_longDrxCycleStartOffset [variable]
    cls.add_instance_attribute('m_longDrxCycleStartOffset', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_onDurationTimer [variable]
    cls.add_instance_attribute('m_onDurationTimer', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::DrxConfig_s::m_shortDrxCycle [variable]
    cls.add_instance_attribute('m_shortDrxCycle', 'uint16_t', is_const=False)
    return

def register_Ns3EpcEnbS1SapProvider_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::EpcEnbS1SapProvider() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::EpcEnbS1SapProvider(ns3::EpcEnbS1SapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapProvider const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapProvider::DoSendReleaseIndication(uint64_t imsi, uint16_t rnti, uint8_t bearerId) [member function]
    cls.add_method('DoSendReleaseIndication', 
                   'void', 
                   [param('uint64_t', 'imsi'), param('uint16_t', 'rnti'), param('uint8_t', 'bearerId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapProvider::InitialUeMessage(uint64_t imsi, uint16_t rnti) [member function]
    cls.add_method('InitialUeMessage', 
                   'void', 
                   [param('uint64_t', 'imsi'), param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapProvider::PathSwitchRequest(ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters params) [member function]
    cls.add_method('PathSwitchRequest', 
                   'void', 
                   [param('ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapProvider::UeContextRelease(uint16_t rnti) [member function]
    cls.add_method('UeContextRelease', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcEnbS1SapProviderBearerToBeSwitched_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::BearerToBeSwitched::BearerToBeSwitched() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::BearerToBeSwitched::BearerToBeSwitched(ns3::EpcEnbS1SapProvider::BearerToBeSwitched const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapProvider::BearerToBeSwitched const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::BearerToBeSwitched::epsBearerId [variable]
    cls.add_instance_attribute('epsBearerId', 'uint8_t', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::BearerToBeSwitched::teid [variable]
    cls.add_instance_attribute('teid', 'uint32_t', is_const=False)
    return

def register_Ns3EpcEnbS1SapProviderPathSwitchRequestParameters_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters::PathSwitchRequestParameters() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters::PathSwitchRequestParameters(ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters::bearersToBeSwitched [variable]
    cls.add_instance_attribute('bearersToBeSwitched', 'std::list< ns3::EpcEnbS1SapProvider::BearerToBeSwitched >', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters::cellId [variable]
    cls.add_instance_attribute('cellId', 'uint16_t', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters::mmeUeS1Id [variable]
    cls.add_instance_attribute('mmeUeS1Id', 'uint32_t', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapProvider::PathSwitchRequestParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3EpcEnbS1SapUser_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::EpcEnbS1SapUser() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::EpcEnbS1SapUser(ns3::EpcEnbS1SapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapUser const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequest(ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters params) [member function]
    cls.add_method('DataRadioBearerSetupRequest', 
                   'void', 
                   [param('ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapUser::InitialContextSetupRequest(ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters params) [member function]
    cls.add_method('InitialContextSetupRequest', 
                   'void', 
                   [param('ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-enb-s1-sap.h (module 'lte'): void ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledge(ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters params) [member function]
    cls.add_method('PathSwitchRequestAcknowledge', 
                   'void', 
                   [param('ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcEnbS1SapUserDataRadioBearerSetupRequestParameters_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::DataRadioBearerSetupRequestParameters() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::DataRadioBearerSetupRequestParameters(ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::bearer [variable]
    cls.add_instance_attribute('bearer', 'ns3::EpsBearer', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::bearerId [variable]
    cls.add_instance_attribute('bearerId', 'uint8_t', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::gtpTeid [variable]
    cls.add_instance_attribute('gtpTeid', 'uint32_t', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::DataRadioBearerSetupRequestParameters::transportLayerAddress [variable]
    cls.add_instance_attribute('transportLayerAddress', 'ns3::Ipv4Address', is_const=False)
    return

def register_Ns3EpcEnbS1SapUserInitialContextSetupRequestParameters_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters::InitialContextSetupRequestParameters() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters::InitialContextSetupRequestParameters(ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::InitialContextSetupRequestParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3EpcEnbS1SapUserPathSwitchRequestAcknowledgeParameters_methods(root_module, cls):
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters::PathSwitchRequestAcknowledgeParameters() [constructor]
    cls.add_constructor([])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters::PathSwitchRequestAcknowledgeParameters(ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters const &', 'arg0')])
    ## epc-enb-s1-sap.h (module 'lte'): ns3::EpcEnbS1SapUser::PathSwitchRequestAcknowledgeParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3EpcS11Sap_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::EpcS11Sap() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::EpcS11Sap(ns3::EpcS11Sap const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11Sap const &', 'arg0')])
    return

def register_Ns3EpcS11SapFteid_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Fteid::Fteid() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Fteid::Fteid(ns3::EpcS11Sap::Fteid const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11Sap::Fteid const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Fteid::address [variable]
    cls.add_instance_attribute('address', 'ns3::Ipv4Address', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Fteid::teid [variable]
    cls.add_instance_attribute('teid', 'uint32_t', is_const=False)
    return

def register_Ns3EpcS11SapGtpcMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::GtpcMessage::GtpcMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::GtpcMessage::GtpcMessage(ns3::EpcS11Sap::GtpcMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11Sap::GtpcMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::GtpcMessage::teid [variable]
    cls.add_instance_attribute('teid', 'uint32_t', is_const=False)
    return

def register_Ns3EpcS11SapUli_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Uli::Uli() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Uli::Uli(ns3::EpcS11Sap::Uli const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11Sap::Uli const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11Sap::Uli::gci [variable]
    cls.add_instance_attribute('gci', 'uint16_t', is_const=False)
    return

def register_Ns3EpcS11SapMme_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::EpcS11SapMme() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::EpcS11SapMme(ns3::EpcS11SapMme const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapMme const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapMme::CreateSessionResponse(ns3::EpcS11SapMme::CreateSessionResponseMessage msg) [member function]
    cls.add_method('CreateSessionResponse', 
                   'void', 
                   [param('ns3::EpcS11SapMme::CreateSessionResponseMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapMme::DeleteBearerRequest(ns3::EpcS11SapMme::DeleteBearerRequestMessage msg) [member function]
    cls.add_method('DeleteBearerRequest', 
                   'void', 
                   [param('ns3::EpcS11SapMme::DeleteBearerRequestMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapMme::ModifyBearerResponse(ns3::EpcS11SapMme::ModifyBearerResponseMessage msg) [member function]
    cls.add_method('ModifyBearerResponse', 
                   'void', 
                   [param('ns3::EpcS11SapMme::ModifyBearerResponseMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcS11SapMmeBearerContextCreated_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated::BearerContextCreated() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated::BearerContextCreated(ns3::EpcS11SapMme::BearerContextCreated const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapMme::BearerContextCreated const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated::bearerLevelQos [variable]
    cls.add_instance_attribute('bearerLevelQos', 'ns3::EpsBearer', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated::epsBearerId [variable]
    cls.add_instance_attribute('epsBearerId', 'uint8_t', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated::sgwFteid [variable]
    cls.add_instance_attribute('sgwFteid', 'ns3::EpcS11Sap::Fteid', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextCreated::tft [variable]
    cls.add_instance_attribute('tft', 'ns3::Ptr< ns3::EpcTft >', is_const=False)
    return

def register_Ns3EpcS11SapMmeBearerContextRemoved_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextRemoved::BearerContextRemoved() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextRemoved::BearerContextRemoved(ns3::EpcS11SapMme::BearerContextRemoved const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapMme::BearerContextRemoved const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::BearerContextRemoved::epsBearerId [variable]
    cls.add_instance_attribute('epsBearerId', 'uint8_t', is_const=False)
    return

def register_Ns3EpcS11SapMmeCreateSessionResponseMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::CreateSessionResponseMessage::CreateSessionResponseMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::CreateSessionResponseMessage::CreateSessionResponseMessage(ns3::EpcS11SapMme::CreateSessionResponseMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapMme::CreateSessionResponseMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::CreateSessionResponseMessage::bearerContextsCreated [variable]
    cls.add_instance_attribute('bearerContextsCreated', 'std::list< ns3::EpcS11SapMme::BearerContextCreated >', is_const=False)
    return

def register_Ns3EpcS11SapMmeDeleteBearerRequestMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::DeleteBearerRequestMessage::DeleteBearerRequestMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::DeleteBearerRequestMessage::DeleteBearerRequestMessage(ns3::EpcS11SapMme::DeleteBearerRequestMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapMme::DeleteBearerRequestMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::DeleteBearerRequestMessage::bearerContextsRemoved [variable]
    cls.add_instance_attribute('bearerContextsRemoved', 'std::list< ns3::EpcS11SapMme::BearerContextRemoved >', is_const=False)
    return

def register_Ns3EpcS11SapMmeModifyBearerResponseMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::ModifyBearerResponseMessage::ModifyBearerResponseMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::ModifyBearerResponseMessage::ModifyBearerResponseMessage(ns3::EpcS11SapMme::ModifyBearerResponseMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapMme::ModifyBearerResponseMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapMme::ModifyBearerResponseMessage::cause [variable]
    cls.add_instance_attribute('cause', 'ns3::EpcS11SapMme::ModifyBearerResponseMessage::Cause', is_const=False)
    return

def register_Ns3EpcS11SapSgw_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::EpcS11SapSgw() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::EpcS11SapSgw(ns3::EpcS11SapSgw const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapSgw::CreateSessionRequest(ns3::EpcS11SapSgw::CreateSessionRequestMessage msg) [member function]
    cls.add_method('CreateSessionRequest', 
                   'void', 
                   [param('ns3::EpcS11SapSgw::CreateSessionRequestMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapSgw::DeleteBearerCommand(ns3::EpcS11SapSgw::DeleteBearerCommandMessage msg) [member function]
    cls.add_method('DeleteBearerCommand', 
                   'void', 
                   [param('ns3::EpcS11SapSgw::DeleteBearerCommandMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapSgw::DeleteBearerResponse(ns3::EpcS11SapSgw::DeleteBearerResponseMessage msg) [member function]
    cls.add_method('DeleteBearerResponse', 
                   'void', 
                   [param('ns3::EpcS11SapSgw::DeleteBearerResponseMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s11-sap.h (module 'lte'): void ns3::EpcS11SapSgw::ModifyBearerRequest(ns3::EpcS11SapSgw::ModifyBearerRequestMessage msg) [member function]
    cls.add_method('ModifyBearerRequest', 
                   'void', 
                   [param('ns3::EpcS11SapSgw::ModifyBearerRequestMessage', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcS11SapSgwBearerContextRemovedSgwPgw_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw::BearerContextRemovedSgwPgw() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw::BearerContextRemovedSgwPgw(ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw::epsBearerId [variable]
    cls.add_instance_attribute('epsBearerId', 'uint8_t', is_const=False)
    return

def register_Ns3EpcS11SapSgwBearerContextToBeCreated_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated::BearerContextToBeCreated() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated::BearerContextToBeCreated(ns3::EpcS11SapSgw::BearerContextToBeCreated const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::BearerContextToBeCreated const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated::bearerLevelQos [variable]
    cls.add_instance_attribute('bearerLevelQos', 'ns3::EpsBearer', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated::epsBearerId [variable]
    cls.add_instance_attribute('epsBearerId', 'uint8_t', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated::sgwFteid [variable]
    cls.add_instance_attribute('sgwFteid', 'ns3::EpcS11Sap::Fteid', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeCreated::tft [variable]
    cls.add_instance_attribute('tft', 'ns3::Ptr< ns3::EpcTft >', is_const=False)
    return

def register_Ns3EpcS11SapSgwBearerContextToBeRemoved_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeRemoved::BearerContextToBeRemoved() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeRemoved::BearerContextToBeRemoved(ns3::EpcS11SapSgw::BearerContextToBeRemoved const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::BearerContextToBeRemoved const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::BearerContextToBeRemoved::epsBearerId [variable]
    cls.add_instance_attribute('epsBearerId', 'uint8_t', is_const=False)
    return

def register_Ns3EpcS11SapSgwCreateSessionRequestMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::CreateSessionRequestMessage::CreateSessionRequestMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::CreateSessionRequestMessage::CreateSessionRequestMessage(ns3::EpcS11SapSgw::CreateSessionRequestMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::CreateSessionRequestMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::CreateSessionRequestMessage::bearerContextsToBeCreated [variable]
    cls.add_instance_attribute('bearerContextsToBeCreated', 'std::list< ns3::EpcS11SapSgw::BearerContextToBeCreated >', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::CreateSessionRequestMessage::imsi [variable]
    cls.add_instance_attribute('imsi', 'uint64_t', is_const=False)
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::CreateSessionRequestMessage::uli [variable]
    cls.add_instance_attribute('uli', 'ns3::EpcS11Sap::Uli', is_const=False)
    return

def register_Ns3EpcS11SapSgwDeleteBearerCommandMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerCommandMessage::DeleteBearerCommandMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerCommandMessage::DeleteBearerCommandMessage(ns3::EpcS11SapSgw::DeleteBearerCommandMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::DeleteBearerCommandMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerCommandMessage::bearerContextsToBeRemoved [variable]
    cls.add_instance_attribute('bearerContextsToBeRemoved', 'std::list< ns3::EpcS11SapSgw::BearerContextToBeRemoved >', is_const=False)
    return

def register_Ns3EpcS11SapSgwDeleteBearerResponseMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerResponseMessage::DeleteBearerResponseMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerResponseMessage::DeleteBearerResponseMessage(ns3::EpcS11SapSgw::DeleteBearerResponseMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::DeleteBearerResponseMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::DeleteBearerResponseMessage::bearerContextsRemoved [variable]
    cls.add_instance_attribute('bearerContextsRemoved', 'std::list< ns3::EpcS11SapSgw::BearerContextRemovedSgwPgw >', is_const=False)
    return

def register_Ns3EpcS11SapSgwModifyBearerRequestMessage_methods(root_module, cls):
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::ModifyBearerRequestMessage::ModifyBearerRequestMessage() [constructor]
    cls.add_constructor([])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::ModifyBearerRequestMessage::ModifyBearerRequestMessage(ns3::EpcS11SapSgw::ModifyBearerRequestMessage const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS11SapSgw::ModifyBearerRequestMessage const &', 'arg0')])
    ## epc-s11-sap.h (module 'lte'): ns3::EpcS11SapSgw::ModifyBearerRequestMessage::uli [variable]
    cls.add_instance_attribute('uli', 'ns3::EpcS11Sap::Uli', is_const=False)
    return

def register_Ns3EpcS1apSap_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSap::EpcS1apSap() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSap::EpcS1apSap(ns3::EpcS1apSap const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSap const &', 'arg0')])
    return

def register_Ns3EpcS1apSapEnb_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::EpcS1apSapEnb() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::EpcS1apSapEnb(ns3::EpcS1apSapEnb const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapEnb const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): void ns3::EpcS1apSapEnb::InitialContextSetupRequest(uint64_t mmeUeS1Id, uint16_t enbUeS1Id, std::list<ns3::EpcS1apSapEnb::ErabToBeSetupItem, std::allocator<ns3::EpcS1apSapEnb::ErabToBeSetupItem> > erabToBeSetupList) [member function]
    cls.add_method('InitialContextSetupRequest', 
                   'void', 
                   [param('uint64_t', 'mmeUeS1Id'), param('uint16_t', 'enbUeS1Id'), param('std::list< ns3::EpcS1apSapEnb::ErabToBeSetupItem >', 'erabToBeSetupList')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s1ap-sap.h (module 'lte'): void ns3::EpcS1apSapEnb::PathSwitchRequestAcknowledge(uint64_t enbUeS1Id, uint64_t mmeUeS1Id, uint16_t cgi, std::list<ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem, std::allocator<ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem> > erabToBeSwitchedInUplinkList) [member function]
    cls.add_method('PathSwitchRequestAcknowledge', 
                   'void', 
                   [param('uint64_t', 'enbUeS1Id'), param('uint64_t', 'mmeUeS1Id'), param('uint16_t', 'cgi'), param('std::list< ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem >', 'erabToBeSwitchedInUplinkList')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcS1apSapEnbErabSwitchedInUplinkItem_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem::ErabSwitchedInUplinkItem() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem::ErabSwitchedInUplinkItem(ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem::enbTeid [variable]
    cls.add_instance_attribute('enbTeid', 'uint32_t', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint8_t', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabSwitchedInUplinkItem::transportLayerAddress [variable]
    cls.add_instance_attribute('transportLayerAddress', 'ns3::Ipv4Address', is_const=False)
    return

def register_Ns3EpcS1apSapEnbErabToBeSetupItem_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem::ErabToBeSetupItem() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem::ErabToBeSetupItem(ns3::EpcS1apSapEnb::ErabToBeSetupItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapEnb::ErabToBeSetupItem const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint8_t', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem::erabLevelQosParameters [variable]
    cls.add_instance_attribute('erabLevelQosParameters', 'ns3::EpsBearer', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem::sgwTeid [variable]
    cls.add_instance_attribute('sgwTeid', 'uint32_t', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapEnb::ErabToBeSetupItem::transportLayerAddress [variable]
    cls.add_instance_attribute('transportLayerAddress', 'ns3::Ipv4Address', is_const=False)
    return

def register_Ns3EpcS1apSapMme_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::EpcS1apSapMme() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::EpcS1apSapMme(ns3::EpcS1apSapMme const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapMme const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): void ns3::EpcS1apSapMme::ErabReleaseIndication(uint64_t mmeUeS1Id, uint16_t enbUeS1Id, std::list<ns3::EpcS1apSapMme::ErabToBeReleasedIndication, std::allocator<ns3::EpcS1apSapMme::ErabToBeReleasedIndication> > erabToBeReleaseIndication) [member function]
    cls.add_method('ErabReleaseIndication', 
                   'void', 
                   [param('uint64_t', 'mmeUeS1Id'), param('uint16_t', 'enbUeS1Id'), param('std::list< ns3::EpcS1apSapMme::ErabToBeReleasedIndication >', 'erabToBeReleaseIndication')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s1ap-sap.h (module 'lte'): void ns3::EpcS1apSapMme::InitialContextSetupResponse(uint64_t mmeUeS1Id, uint16_t enbUeS1Id, std::list<ns3::EpcS1apSapMme::ErabSetupItem, std::allocator<ns3::EpcS1apSapMme::ErabSetupItem> > erabSetupList) [member function]
    cls.add_method('InitialContextSetupResponse', 
                   'void', 
                   [param('uint64_t', 'mmeUeS1Id'), param('uint16_t', 'enbUeS1Id'), param('std::list< ns3::EpcS1apSapMme::ErabSetupItem >', 'erabSetupList')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s1ap-sap.h (module 'lte'): void ns3::EpcS1apSapMme::InitialUeMessage(uint64_t mmeUeS1Id, uint16_t enbUeS1Id, uint64_t stmsi, uint16_t ecgi) [member function]
    cls.add_method('InitialUeMessage', 
                   'void', 
                   [param('uint64_t', 'mmeUeS1Id'), param('uint16_t', 'enbUeS1Id'), param('uint64_t', 'stmsi'), param('uint16_t', 'ecgi')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-s1ap-sap.h (module 'lte'): void ns3::EpcS1apSapMme::PathSwitchRequest(uint64_t enbUeS1Id, uint64_t mmeUeS1Id, uint16_t gci, std::list<ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem, std::allocator<ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem> > erabToBeSwitchedInDownlinkList) [member function]
    cls.add_method('PathSwitchRequest', 
                   'void', 
                   [param('uint64_t', 'enbUeS1Id'), param('uint64_t', 'mmeUeS1Id'), param('uint16_t', 'gci'), param('std::list< ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem >', 'erabToBeSwitchedInDownlinkList')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcS1apSapMmeErabSetupItem_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSetupItem::ErabSetupItem() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSetupItem::ErabSetupItem(ns3::EpcS1apSapMme::ErabSetupItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapMme::ErabSetupItem const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSetupItem::enbTeid [variable]
    cls.add_instance_attribute('enbTeid', 'uint32_t', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSetupItem::enbTransportLayerAddress [variable]
    cls.add_instance_attribute('enbTransportLayerAddress', 'ns3::Ipv4Address', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSetupItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcS1apSapMmeErabSwitchedInDownlinkItem_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem::ErabSwitchedInDownlinkItem() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem::ErabSwitchedInDownlinkItem(ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem::enbTeid [variable]
    cls.add_instance_attribute('enbTeid', 'uint32_t', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem::enbTransportLayerAddress [variable]
    cls.add_instance_attribute('enbTransportLayerAddress', 'ns3::Ipv4Address', is_const=False)
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabSwitchedInDownlinkItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcS1apSapMmeErabToBeReleasedIndication_methods(root_module, cls):
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabToBeReleasedIndication::ErabToBeReleasedIndication() [constructor]
    cls.add_constructor([])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabToBeReleasedIndication::ErabToBeReleasedIndication(ns3::EpcS1apSapMme::ErabToBeReleasedIndication const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcS1apSapMme::ErabToBeReleasedIndication const &', 'arg0')])
    ## epc-s1ap-sap.h (module 'lte'): ns3::EpcS1apSapMme::ErabToBeReleasedIndication::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint8_t', is_const=False)
    return

def register_Ns3EpcX2Sap_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::EpcX2Sap() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::EpcX2Sap(ns3::EpcX2Sap const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::m_maxPdcpSn [variable]
    cls.add_static_attribute('m_maxPdcpSn', 'uint16_t const', is_const=True)
    return

def register_Ns3EpcX2SapCellInformationItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem::CellInformationItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem::CellInformationItem(ns3::EpcX2Sap::CellInformationItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::CellInformationItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem::relativeNarrowbandTxBand [variable]
    cls.add_instance_attribute('relativeNarrowbandTxBand', 'ns3::EpcX2Sap::RelativeNarrowbandTxBand', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem::ulHighInterferenceInformationList [variable]
    cls.add_instance_attribute('ulHighInterferenceInformationList', 'std::vector< ns3::EpcX2Sap::UlHighInterferenceInformationItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellInformationItem::ulInterferenceOverloadIndicationList [variable]
    cls.add_instance_attribute('ulInterferenceOverloadIndicationList', 'std::vector< ns3::EpcX2Sap::UlInterferenceOverloadIndicationItem >', is_const=False)
    return

def register_Ns3EpcX2SapCellMeasurementResultItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::CellMeasurementResultItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::CellMeasurementResultItem(ns3::EpcX2Sap::CellMeasurementResultItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::CellMeasurementResultItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::dlCompositeAvailableCapacity [variable]
    cls.add_instance_attribute('dlCompositeAvailableCapacity', 'ns3::EpcX2Sap::CompositeAvailCapacity', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::dlGbrPrbUsage [variable]
    cls.add_instance_attribute('dlGbrPrbUsage', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::dlHardwareLoadIndicator [variable]
    cls.add_instance_attribute('dlHardwareLoadIndicator', 'ns3::EpcX2Sap::LoadIndicator', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::dlNonGbrPrbUsage [variable]
    cls.add_instance_attribute('dlNonGbrPrbUsage', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::dlS1TnlLoadIndicator [variable]
    cls.add_instance_attribute('dlS1TnlLoadIndicator', 'ns3::EpcX2Sap::LoadIndicator', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::dlTotalPrbUsage [variable]
    cls.add_instance_attribute('dlTotalPrbUsage', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::ulCompositeAvailableCapacity [variable]
    cls.add_instance_attribute('ulCompositeAvailableCapacity', 'ns3::EpcX2Sap::CompositeAvailCapacity', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::ulGbrPrbUsage [variable]
    cls.add_instance_attribute('ulGbrPrbUsage', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::ulHardwareLoadIndicator [variable]
    cls.add_instance_attribute('ulHardwareLoadIndicator', 'ns3::EpcX2Sap::LoadIndicator', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::ulNonGbrPrbUsage [variable]
    cls.add_instance_attribute('ulNonGbrPrbUsage', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::ulS1TnlLoadIndicator [variable]
    cls.add_instance_attribute('ulS1TnlLoadIndicator', 'ns3::EpcX2Sap::LoadIndicator', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CellMeasurementResultItem::ulTotalPrbUsage [variable]
    cls.add_instance_attribute('ulTotalPrbUsage', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapCompositeAvailCapacity_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CompositeAvailCapacity::CompositeAvailCapacity() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CompositeAvailCapacity::CompositeAvailCapacity(ns3::EpcX2Sap::CompositeAvailCapacity const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::CompositeAvailCapacity const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CompositeAvailCapacity::capacityValue [variable]
    cls.add_instance_attribute('capacityValue', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::CompositeAvailCapacity::cellCapacityClassValue [variable]
    cls.add_instance_attribute('cellCapacityClassValue', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapErabAdmittedItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabAdmittedItem::ErabAdmittedItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabAdmittedItem::ErabAdmittedItem(ns3::EpcX2Sap::ErabAdmittedItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::ErabAdmittedItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabAdmittedItem::dlGtpTeid [variable]
    cls.add_instance_attribute('dlGtpTeid', 'uint32_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabAdmittedItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabAdmittedItem::ulGtpTeid [variable]
    cls.add_instance_attribute('ulGtpTeid', 'uint32_t', is_const=False)
    return

def register_Ns3EpcX2SapErabNotAdmittedItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabNotAdmittedItem::ErabNotAdmittedItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabNotAdmittedItem::ErabNotAdmittedItem(ns3::EpcX2Sap::ErabNotAdmittedItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::ErabNotAdmittedItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabNotAdmittedItem::cause [variable]
    cls.add_instance_attribute('cause', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabNotAdmittedItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapErabToBeSetupItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::ErabToBeSetupItem(ns3::EpcX2Sap::ErabToBeSetupItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::ErabToBeSetupItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::ErabToBeSetupItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::dlForwarding [variable]
    cls.add_instance_attribute('dlForwarding', 'bool', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::erabLevelQosParameters [variable]
    cls.add_instance_attribute('erabLevelQosParameters', 'ns3::EpsBearer', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::gtpTeid [variable]
    cls.add_instance_attribute('gtpTeid', 'uint32_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabToBeSetupItem::transportLayerAddress [variable]
    cls.add_instance_attribute('transportLayerAddress', 'ns3::Ipv4Address', is_const=False)
    return

def register_Ns3EpcX2SapErabsSubjectToStatusTransferItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::ErabsSubjectToStatusTransferItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::ErabsSubjectToStatusTransferItem(ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::dlHfn [variable]
    cls.add_instance_attribute('dlHfn', 'uint32_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::dlPdcpSn [variable]
    cls.add_instance_attribute('dlPdcpSn', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::erabId [variable]
    cls.add_instance_attribute('erabId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::receiveStatusOfUlPdcpSdus [variable]
    cls.add_instance_attribute('receiveStatusOfUlPdcpSdus', 'std::bitset< 4096 >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::ulHfn [variable]
    cls.add_instance_attribute('ulHfn', 'uint32_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem::ulPdcpSn [variable]
    cls.add_instance_attribute('ulPdcpSn', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapHandoverPreparationFailureParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::HandoverPreparationFailureParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::HandoverPreparationFailureParams(ns3::EpcX2Sap::HandoverPreparationFailureParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::HandoverPreparationFailureParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::cause [variable]
    cls.add_instance_attribute('cause', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::criticalityDiagnostics [variable]
    cls.add_instance_attribute('criticalityDiagnostics', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::oldEnbUeX2apId [variable]
    cls.add_instance_attribute('oldEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverPreparationFailureParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapHandoverRequestAckParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::HandoverRequestAckParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::HandoverRequestAckParams(ns3::EpcX2Sap::HandoverRequestAckParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::HandoverRequestAckParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::admittedBearers [variable]
    cls.add_instance_attribute('admittedBearers', 'std::vector< ns3::EpcX2Sap::ErabAdmittedItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::newEnbUeX2apId [variable]
    cls.add_instance_attribute('newEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::notAdmittedBearers [variable]
    cls.add_instance_attribute('notAdmittedBearers', 'std::vector< ns3::EpcX2Sap::ErabNotAdmittedItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::oldEnbUeX2apId [variable]
    cls.add_instance_attribute('oldEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::rrcContext [variable]
    cls.add_instance_attribute('rrcContext', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestAckParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapHandoverRequestParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::HandoverRequestParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::HandoverRequestParams(ns3::EpcX2Sap::HandoverRequestParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::HandoverRequestParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::bearers [variable]
    cls.add_instance_attribute('bearers', 'std::vector< ns3::EpcX2Sap::ErabToBeSetupItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::cause [variable]
    cls.add_instance_attribute('cause', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::mmeUeS1apId [variable]
    cls.add_instance_attribute('mmeUeS1apId', 'uint32_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::oldEnbUeX2apId [variable]
    cls.add_instance_attribute('oldEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::rrcContext [variable]
    cls.add_instance_attribute('rrcContext', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::ueAggregateMaxBitRateDownlink [variable]
    cls.add_instance_attribute('ueAggregateMaxBitRateDownlink', 'uint64_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::HandoverRequestParams::ueAggregateMaxBitRateUplink [variable]
    cls.add_instance_attribute('ueAggregateMaxBitRateUplink', 'uint64_t', is_const=False)
    return

def register_Ns3EpcX2SapLoadInformationParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::LoadInformationParams::LoadInformationParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::LoadInformationParams::LoadInformationParams(ns3::EpcX2Sap::LoadInformationParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::LoadInformationParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::LoadInformationParams::cellInformationList [variable]
    cls.add_instance_attribute('cellInformationList', 'std::vector< ns3::EpcX2Sap::CellInformationItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::LoadInformationParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapRelativeNarrowbandTxBand_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::RelativeNarrowbandTxBand() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::RelativeNarrowbandTxBand(ns3::EpcX2Sap::RelativeNarrowbandTxBand const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::RelativeNarrowbandTxBand const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::antennaPorts [variable]
    cls.add_instance_attribute('antennaPorts', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::pB [variable]
    cls.add_instance_attribute('pB', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::pdcchInterferenceImpact [variable]
    cls.add_instance_attribute('pdcchInterferenceImpact', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::rntpPerPrbList [variable]
    cls.add_instance_attribute('rntpPerPrbList', 'std::vector< bool >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::RelativeNarrowbandTxBand::rntpThreshold [variable]
    cls.add_instance_attribute('rntpThreshold', 'int16_t', is_const=False)
    return

def register_Ns3EpcX2SapResourceStatusUpdateParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams::ResourceStatusUpdateParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams::ResourceStatusUpdateParams(ns3::EpcX2Sap::ResourceStatusUpdateParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::ResourceStatusUpdateParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams::cellMeasurementResultList [variable]
    cls.add_instance_attribute('cellMeasurementResultList', 'std::vector< ns3::EpcX2Sap::CellMeasurementResultItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams::enb1MeasurementId [variable]
    cls.add_instance_attribute('enb1MeasurementId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams::enb2MeasurementId [variable]
    cls.add_instance_attribute('enb2MeasurementId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::ResourceStatusUpdateParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapSnStatusTransferParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::SnStatusTransferParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::SnStatusTransferParams(ns3::EpcX2Sap::SnStatusTransferParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::SnStatusTransferParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::erabsSubjectToStatusTransferList [variable]
    cls.add_instance_attribute('erabsSubjectToStatusTransferList', 'std::vector< ns3::EpcX2Sap::ErabsSubjectToStatusTransferItem >', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::newEnbUeX2apId [variable]
    cls.add_instance_attribute('newEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::oldEnbUeX2apId [variable]
    cls.add_instance_attribute('oldEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::SnStatusTransferParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapUeContextReleaseParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams::UeContextReleaseParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams::UeContextReleaseParams(ns3::EpcX2Sap::UeContextReleaseParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::UeContextReleaseParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams::newEnbUeX2apId [variable]
    cls.add_instance_attribute('newEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams::oldEnbUeX2apId [variable]
    cls.add_instance_attribute('oldEnbUeX2apId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeContextReleaseParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    return

def register_Ns3EpcX2SapUeDataParams_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams::UeDataParams() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams::UeDataParams(ns3::EpcX2Sap::UeDataParams const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::UeDataParams const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams::gtpTeid [variable]
    cls.add_instance_attribute('gtpTeid', 'uint32_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams::sourceCellId [variable]
    cls.add_instance_attribute('sourceCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UeDataParams::ueData [variable]
    cls.add_instance_attribute('ueData', 'ns3::Ptr< ns3::Packet >', is_const=False)
    return

def register_Ns3EpcX2SapUlHighInterferenceInformationItem_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UlHighInterferenceInformationItem::UlHighInterferenceInformationItem() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UlHighInterferenceInformationItem::UlHighInterferenceInformationItem(ns3::EpcX2Sap::UlHighInterferenceInformationItem const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2Sap::UlHighInterferenceInformationItem const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UlHighInterferenceInformationItem::targetCellId [variable]
    cls.add_instance_attribute('targetCellId', 'uint16_t', is_const=False)
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2Sap::UlHighInterferenceInformationItem::ulHighInterferenceIndicationList [variable]
    cls.add_instance_attribute('ulHighInterferenceIndicationList', 'std::vector< bool >', is_const=False)
    return

def register_Ns3EpcX2SapProvider_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2SapProvider::EpcX2SapProvider() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2SapProvider::EpcX2SapProvider(ns3::EpcX2SapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2SapProvider const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendHandoverPreparationFailure(ns3::EpcX2Sap::HandoverPreparationFailureParams params) [member function]
    cls.add_method('SendHandoverPreparationFailure', 
                   'void', 
                   [param('ns3::EpcX2Sap::HandoverPreparationFailureParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendHandoverRequest(ns3::EpcX2Sap::HandoverRequestParams params) [member function]
    cls.add_method('SendHandoverRequest', 
                   'void', 
                   [param('ns3::EpcX2Sap::HandoverRequestParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendHandoverRequestAck(ns3::EpcX2Sap::HandoverRequestAckParams params) [member function]
    cls.add_method('SendHandoverRequestAck', 
                   'void', 
                   [param('ns3::EpcX2Sap::HandoverRequestAckParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendLoadInformation(ns3::EpcX2Sap::LoadInformationParams params) [member function]
    cls.add_method('SendLoadInformation', 
                   'void', 
                   [param('ns3::EpcX2Sap::LoadInformationParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendResourceStatusUpdate(ns3::EpcX2Sap::ResourceStatusUpdateParams params) [member function]
    cls.add_method('SendResourceStatusUpdate', 
                   'void', 
                   [param('ns3::EpcX2Sap::ResourceStatusUpdateParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendSnStatusTransfer(ns3::EpcX2Sap::SnStatusTransferParams params) [member function]
    cls.add_method('SendSnStatusTransfer', 
                   'void', 
                   [param('ns3::EpcX2Sap::SnStatusTransferParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendUeContextRelease(ns3::EpcX2Sap::UeContextReleaseParams params) [member function]
    cls.add_method('SendUeContextRelease', 
                   'void', 
                   [param('ns3::EpcX2Sap::UeContextReleaseParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapProvider::SendUeData(ns3::EpcX2Sap::UeDataParams params) [member function]
    cls.add_method('SendUeData', 
                   'void', 
                   [param('ns3::EpcX2Sap::UeDataParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EpcX2SapUser_methods(root_module, cls):
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2SapUser::EpcX2SapUser() [constructor]
    cls.add_constructor([])
    ## epc-x2-sap.h (module 'lte'): ns3::EpcX2SapUser::EpcX2SapUser(ns3::EpcX2SapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpcX2SapUser const &', 'arg0')])
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvHandoverPreparationFailure(ns3::EpcX2Sap::HandoverPreparationFailureParams params) [member function]
    cls.add_method('RecvHandoverPreparationFailure', 
                   'void', 
                   [param('ns3::EpcX2Sap::HandoverPreparationFailureParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvHandoverRequest(ns3::EpcX2Sap::HandoverRequestParams params) [member function]
    cls.add_method('RecvHandoverRequest', 
                   'void', 
                   [param('ns3::EpcX2Sap::HandoverRequestParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvHandoverRequestAck(ns3::EpcX2Sap::HandoverRequestAckParams params) [member function]
    cls.add_method('RecvHandoverRequestAck', 
                   'void', 
                   [param('ns3::EpcX2Sap::HandoverRequestAckParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvLoadInformation(ns3::EpcX2Sap::LoadInformationParams params) [member function]
    cls.add_method('RecvLoadInformation', 
                   'void', 
                   [param('ns3::EpcX2Sap::LoadInformationParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvResourceStatusUpdate(ns3::EpcX2Sap::ResourceStatusUpdateParams params) [member function]
    cls.add_method('RecvResourceStatusUpdate', 
                   'void', 
                   [param('ns3::EpcX2Sap::ResourceStatusUpdateParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvSnStatusTransfer(ns3::EpcX2Sap::SnStatusTransferParams params) [member function]
    cls.add_method('RecvSnStatusTransfer', 
                   'void', 
                   [param('ns3::EpcX2Sap::SnStatusTransferParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvUeContextRelease(ns3::EpcX2Sap::UeContextReleaseParams params) [member function]
    cls.add_method('RecvUeContextRelease', 
                   'void', 
                   [param('ns3::EpcX2Sap::UeContextReleaseParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## epc-x2-sap.h (module 'lte'): void ns3::EpcX2SapUser::RecvUeData(ns3::EpcX2Sap::UeDataParams params) [member function]
    cls.add_method('RecvUeData', 
                   'void', 
                   [param('ns3::EpcX2Sap::UeDataParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3EutranMeasurementMapping_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::EutranMeasurementMapping::EutranMeasurementMapping() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::EutranMeasurementMapping::EutranMeasurementMapping(ns3::EutranMeasurementMapping const & arg0) [constructor]
    cls.add_constructor([param('ns3::EutranMeasurementMapping const &', 'arg0')])
    ## lte-common.h (module 'lte'): static int8_t ns3::EutranMeasurementMapping::ActualA3Offset2IeValue(double a3OffsetDb) [member function]
    cls.add_method('ActualA3Offset2IeValue', 
                   'int8_t', 
                   [param('double', 'a3OffsetDb')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static uint8_t ns3::EutranMeasurementMapping::ActualHysteresis2IeValue(double hysteresisDb) [member function]
    cls.add_method('ActualHysteresis2IeValue', 
                   'uint8_t', 
                   [param('double', 'hysteresisDb')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static uint8_t ns3::EutranMeasurementMapping::Db2RsrqRange(double db) [member function]
    cls.add_method('Db2RsrqRange', 
                   'uint8_t', 
                   [param('double', 'db')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static uint8_t ns3::EutranMeasurementMapping::Dbm2RsrpRange(double dbm) [member function]
    cls.add_method('Dbm2RsrpRange', 
                   'uint8_t', 
                   [param('double', 'dbm')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::IeValue2ActualA3Offset(int8_t a3OffsetIeValue) [member function]
    cls.add_method('IeValue2ActualA3Offset', 
                   'double', 
                   [param('int8_t', 'a3OffsetIeValue')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::IeValue2ActualHysteresis(uint8_t hysteresisIeValue) [member function]
    cls.add_method('IeValue2ActualHysteresis', 
                   'double', 
                   [param('uint8_t', 'hysteresisIeValue')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::IeValue2ActualQQualMin(int8_t qQualMinIeValue) [member function]
    cls.add_method('IeValue2ActualQQualMin', 
                   'double', 
                   [param('int8_t', 'qQualMinIeValue')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::IeValue2ActualQRxLevMin(int8_t qRxLevMinIeValue) [member function]
    cls.add_method('IeValue2ActualQRxLevMin', 
                   'double', 
                   [param('int8_t', 'qRxLevMinIeValue')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::QuantizeRsrp(double v) [member function]
    cls.add_method('QuantizeRsrp', 
                   'double', 
                   [param('double', 'v')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::QuantizeRsrq(double v) [member function]
    cls.add_method('QuantizeRsrq', 
                   'double', 
                   [param('double', 'v')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::RsrpRange2Dbm(uint8_t range) [member function]
    cls.add_method('RsrpRange2Dbm', 
                   'double', 
                   [param('uint8_t', 'range')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::EutranMeasurementMapping::RsrqRange2Db(uint8_t range) [member function]
    cls.add_method('RsrqRange2Db', 
                   'double', 
                   [param('uint8_t', 'range')], 
                   is_static=True)
    return

def register_Ns3EventId_methods(root_module, cls):
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    ## event-id.h (module 'core'): ns3::EventId::EventId(ns3::EventId const & arg0) [constructor]
    cls.add_constructor([param('ns3::EventId const &', 'arg0')])
    ## event-id.h (module 'core'): ns3::EventId::EventId() [constructor]
    cls.add_constructor([])
    ## event-id.h (module 'core'): ns3::EventId::EventId(ns3::Ptr<ns3::EventImpl> const & impl, uint64_t ts, uint32_t context, uint32_t uid) [constructor]
    cls.add_constructor([param('ns3::Ptr< ns3::EventImpl > const &', 'impl'), param('uint64_t', 'ts'), param('uint32_t', 'context'), param('uint32_t', 'uid')])
    ## event-id.h (module 'core'): void ns3::EventId::Cancel() [member function]
    cls.add_method('Cancel', 
                   'void', 
                   [])
    ## event-id.h (module 'core'): uint32_t ns3::EventId::GetContext() const [member function]
    cls.add_method('GetContext', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## event-id.h (module 'core'): uint64_t ns3::EventId::GetTs() const [member function]
    cls.add_method('GetTs', 
                   'uint64_t', 
                   [], 
                   is_const=True)
    ## event-id.h (module 'core'): uint32_t ns3::EventId::GetUid() const [member function]
    cls.add_method('GetUid', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## event-id.h (module 'core'): bool ns3::EventId::IsExpired() const [member function]
    cls.add_method('IsExpired', 
                   'bool', 
                   [], 
                   is_const=True)
    ## event-id.h (module 'core'): bool ns3::EventId::IsRunning() const [member function]
    cls.add_method('IsRunning', 
                   'bool', 
                   [], 
                   is_const=True)
    ## event-id.h (module 'core'): ns3::EventImpl * ns3::EventId::PeekEventImpl() const [member function]
    cls.add_method('PeekEventImpl', 
                   'ns3::EventImpl *', 
                   [], 
                   is_const=True)
    return

def register_Ns3FfMacCschedSapProvider_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::FfMacCschedSapProvider() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::FfMacCschedSapProvider(ns3::FfMacCschedSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapProvider const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapProvider::CschedCellConfigReq(ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters const & params) [member function]
    cls.add_method('CschedCellConfigReq', 
                   'void', 
                   [param('ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapProvider::CschedLcConfigReq(ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters const & params) [member function]
    cls.add_method('CschedLcConfigReq', 
                   'void', 
                   [param('ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapProvider::CschedLcReleaseReq(ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters const & params) [member function]
    cls.add_method('CschedLcReleaseReq', 
                   'void', 
                   [param('ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapProvider::CschedUeConfigReq(ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters const & params) [member function]
    cls.add_method('CschedUeConfigReq', 
                   'void', 
                   [param('ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapProvider::CschedUeReleaseReq(ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters const & params) [member function]
    cls.add_method('CschedUeReleaseReq', 
                   'void', 
                   [param('ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3FfMacCschedSapProviderCschedCellConfigReqParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::CschedCellConfigReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::CschedCellConfigReqParameters(ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_antennaPortsCount [variable]
    cls.add_instance_attribute('m_antennaPortsCount', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_deltaPucchShift [variable]
    cls.add_instance_attribute('m_deltaPucchShift', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_dlBandwidth [variable]
    cls.add_instance_attribute('m_dlBandwidth', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_dlCyclicPrefixLength [variable]
    cls.add_instance_attribute('m_dlCyclicPrefixLength', 'ns3::NormalExtended_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_duplexMode [variable]
    cls.add_instance_attribute('m_duplexMode', 'ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::DuplexMode_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_enable64Qam [variable]
    cls.add_instance_attribute('m_enable64Qam', 'ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::Enable64Qam_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_hoppingMode [variable]
    cls.add_instance_attribute('m_hoppingMode', 'ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::HoppingMode_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_initialNrOfPdcchOfdmSymbols [variable]
    cls.add_instance_attribute('m_initialNrOfPdcchOfdmSymbols', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_macContentionResolutionTimer [variable]
    cls.add_instance_attribute('m_macContentionResolutionTimer', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_maxHarqMsg3Tx [variable]
    cls.add_instance_attribute('m_maxHarqMsg3Tx', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_mbsfnSubframeConfigRfOffset [variable]
    cls.add_instance_attribute('m_mbsfnSubframeConfigRfOffset', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_mbsfnSubframeConfigRfPeriod [variable]
    cls.add_instance_attribute('m_mbsfnSubframeConfigRfPeriod', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_mbsfnSubframeConfigSfAllocation [variable]
    cls.add_instance_attribute('m_mbsfnSubframeConfigSfAllocation', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_n1PucchAn [variable]
    cls.add_instance_attribute('m_n1PucchAn', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_nSb [variable]
    cls.add_instance_attribute('m_nSb', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_ncsAn [variable]
    cls.add_instance_attribute('m_ncsAn', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_nrbCqi [variable]
    cls.add_instance_attribute('m_nrbCqi', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_phichDuration [variable]
    cls.add_instance_attribute('m_phichDuration', 'ns3::NormalExtended_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_phichResource [variable]
    cls.add_instance_attribute('m_phichResource', 'ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::PhichResource_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_prachConfigurationIndex [variable]
    cls.add_instance_attribute('m_prachConfigurationIndex', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_prachFreqOffset [variable]
    cls.add_instance_attribute('m_prachFreqOffset', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_puschHoppingOffset [variable]
    cls.add_instance_attribute('m_puschHoppingOffset', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_raResponseWindowSize [variable]
    cls.add_instance_attribute('m_raResponseWindowSize', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_siConfiguration [variable]
    cls.add_instance_attribute('m_siConfiguration', 'ns3::SiConfiguration_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_specialSubframePatterns [variable]
    cls.add_instance_attribute('m_specialSubframePatterns', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_srsBandwidthConfiguration [variable]
    cls.add_instance_attribute('m_srsBandwidthConfiguration', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_srsMaxUpPts [variable]
    cls.add_instance_attribute('m_srsMaxUpPts', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_srsSubframeConfiguration [variable]
    cls.add_instance_attribute('m_srsSubframeConfiguration', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_srsSubframeOffset [variable]
    cls.add_instance_attribute('m_srsSubframeOffset', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_subframeAssignment [variable]
    cls.add_instance_attribute('m_subframeAssignment', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_ulBandwidth [variable]
    cls.add_instance_attribute('m_ulBandwidth', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_ulCyclicPrefixLength [variable]
    cls.add_instance_attribute('m_ulCyclicPrefixLength', 'ns3::NormalExtended_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedCellConfigReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapProviderCschedLcConfigReqParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters::CschedLcConfigReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters::CschedLcConfigReqParameters(ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters::m_logicalChannelConfigList [variable]
    cls.add_instance_attribute('m_logicalChannelConfigList', 'std::vector< ns3::LogicalChannelConfigListElement_s >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters::m_reconfigureFlag [variable]
    cls.add_instance_attribute('m_reconfigureFlag', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcConfigReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapProviderCschedLcReleaseReqParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters::CschedLcReleaseReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters::CschedLcReleaseReqParameters(ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters::m_logicalChannelIdentity [variable]
    cls.add_instance_attribute('m_logicalChannelIdentity', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedLcReleaseReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapProviderCschedUeConfigReqParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::CschedUeConfigReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::CschedUeConfigReqParameters(ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ackNackRepetitionFactor [variable]
    cls.add_instance_attribute('m_ackNackRepetitionFactor', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ackNackSrsSimultaneousTransmission [variable]
    cls.add_instance_attribute('m_ackNackSrsSimultaneousTransmission', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_aperiodicCqiRepMode [variable]
    cls.add_instance_attribute('m_aperiodicCqiRepMode', 'ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::RepMode_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_betaOffsetAckIndex [variable]
    cls.add_instance_attribute('m_betaOffsetAckIndex', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_betaOffsetCqiIndex [variable]
    cls.add_instance_attribute('m_betaOffsetCqiIndex', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_betaOffsetRiIndex [variable]
    cls.add_instance_attribute('m_betaOffsetRiIndex', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_cqiConfig [variable]
    cls.add_instance_attribute('m_cqiConfig', 'ns3::CqiConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_cqiConfigPresent [variable]
    cls.add_instance_attribute('m_cqiConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_drxConfig [variable]
    cls.add_instance_attribute('m_drxConfig', 'ns3::DrxConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_drxConfigPresent [variable]
    cls.add_instance_attribute('m_drxConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_maxHarqTx [variable]
    cls.add_instance_attribute('m_maxHarqTx', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_measGapConfigPattern [variable]
    cls.add_instance_attribute('m_measGapConfigPattern', 'ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::MeasGapConfigPattern_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_measGapConfigSubframeOffset [variable]
    cls.add_instance_attribute('m_measGapConfigSubframeOffset', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_reconfigureFlag [variable]
    cls.add_instance_attribute('m_reconfigureFlag', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_simultaneousAckNackAndCqi [variable]
    cls.add_instance_attribute('m_simultaneousAckNackAndCqi', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_spsConfig [variable]
    cls.add_instance_attribute('m_spsConfig', 'ns3::SpsConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_spsConfigPresent [variable]
    cls.add_instance_attribute('m_spsConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_srConfig [variable]
    cls.add_instance_attribute('m_srConfig', 'ns3::SrConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_srConfigPresent [variable]
    cls.add_instance_attribute('m_srConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_tddAckNackFeedbackMode [variable]
    cls.add_instance_attribute('m_tddAckNackFeedbackMode', 'ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::FeedbackMode_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_timeAlignmentTimer [variable]
    cls.add_instance_attribute('m_timeAlignmentTimer', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_transmissionMode [variable]
    cls.add_instance_attribute('m_transmissionMode', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ttiBundling [variable]
    cls.add_instance_attribute('m_ttiBundling', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ueAggregatedMaximumBitrateDl [variable]
    cls.add_instance_attribute('m_ueAggregatedMaximumBitrateDl', 'uint64_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ueAggregatedMaximumBitrateUl [variable]
    cls.add_instance_attribute('m_ueAggregatedMaximumBitrateUl', 'uint64_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ueCapabilities [variable]
    cls.add_instance_attribute('m_ueCapabilities', 'ns3::UeCapabilities_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_ueTransmitAntennaSelection [variable]
    cls.add_instance_attribute('m_ueTransmitAntennaSelection', 'ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::OpenClosedLoop_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeConfigReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapProviderCschedUeReleaseReqParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters::CschedUeReleaseReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters::CschedUeReleaseReqParameters(ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapProvider::CschedUeReleaseReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUser_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::FfMacCschedSapUser() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::FfMacCschedSapUser(ns3::FfMacCschedSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedCellConfigCnf(ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters const & params) [member function]
    cls.add_method('CschedCellConfigCnf', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedCellConfigUpdateInd(ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters const & params) [member function]
    cls.add_method('CschedCellConfigUpdateInd', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedLcConfigCnf(ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters const & params) [member function]
    cls.add_method('CschedLcConfigCnf', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedLcReleaseCnf(ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters const & params) [member function]
    cls.add_method('CschedLcReleaseCnf', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedUeConfigCnf(ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters const & params) [member function]
    cls.add_method('CschedUeConfigCnf', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedUeConfigUpdateInd(ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters const & params) [member function]
    cls.add_method('CschedUeConfigUpdateInd', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-csched-sap.h (module 'lte'): void ns3::FfMacCschedSapUser::CschedUeReleaseCnf(ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters const & params) [member function]
    cls.add_method('CschedUeReleaseCnf', 
                   'void', 
                   [param('ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3FfMacCschedSapUserCschedCellConfigCnfParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters::CschedCellConfigCnfParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters::CschedCellConfigCnfParameters(ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters::m_result [variable]
    cls.add_instance_attribute('m_result', 'ns3::Result_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigCnfParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUserCschedCellConfigUpdateIndParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters::CschedCellConfigUpdateIndParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters::CschedCellConfigUpdateIndParameters(ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters::m_prbUtilizationDl [variable]
    cls.add_instance_attribute('m_prbUtilizationDl', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters::m_prbUtilizationUl [variable]
    cls.add_instance_attribute('m_prbUtilizationUl', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedCellConfigUpdateIndParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUserCschedLcConfigCnfParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters::CschedLcConfigCnfParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters::CschedLcConfigCnfParameters(ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters::m_logicalChannelIdentity [variable]
    cls.add_instance_attribute('m_logicalChannelIdentity', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters::m_result [variable]
    cls.add_instance_attribute('m_result', 'ns3::Result_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcConfigCnfParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUserCschedLcReleaseCnfParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters::CschedLcReleaseCnfParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters::CschedLcReleaseCnfParameters(ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters::m_logicalChannelIdentity [variable]
    cls.add_instance_attribute('m_logicalChannelIdentity', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters::m_result [variable]
    cls.add_instance_attribute('m_result', 'ns3::Result_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedLcReleaseCnfParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUserCschedUeConfigCnfParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters::CschedUeConfigCnfParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters::CschedUeConfigCnfParameters(ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters::m_result [variable]
    cls.add_instance_attribute('m_result', 'ns3::Result_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigCnfParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUserCschedUeConfigUpdateIndParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::CschedUeConfigUpdateIndParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::CschedUeConfigUpdateIndParameters(ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_cqiConfig [variable]
    cls.add_instance_attribute('m_cqiConfig', 'ns3::CqiConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_cqiConfigPresent [variable]
    cls.add_instance_attribute('m_cqiConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_spsConfig [variable]
    cls.add_instance_attribute('m_spsConfig', 'ns3::SpsConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_spsConfigPresent [variable]
    cls.add_instance_attribute('m_spsConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_srConfig [variable]
    cls.add_instance_attribute('m_srConfig', 'ns3::SrConfig_s', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_srConfigPresent [variable]
    cls.add_instance_attribute('m_srConfigPresent', 'bool', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_transmissionMode [variable]
    cls.add_instance_attribute('m_transmissionMode', 'uint8_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeConfigUpdateIndParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacCschedSapUserCschedUeReleaseCnfParameters_methods(root_module, cls):
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters::CschedUeReleaseCnfParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters::CschedUeReleaseCnfParameters(ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters const &', 'arg0')])
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters::m_result [variable]
    cls.add_instance_attribute('m_result', 'ns3::Result_e', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-csched-sap.h (module 'lte'): ns3::FfMacCschedSapUser::CschedUeReleaseCnfParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProvider_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::FfMacSchedSapProvider() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::FfMacSchedSapProvider(ns3::FfMacSchedSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedDlCqiInfoReq(ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters const & params) [member function]
    cls.add_method('SchedDlCqiInfoReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedDlMacBufferReq(ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters const & params) [member function]
    cls.add_method('SchedDlMacBufferReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedDlPagingBufferReq(ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters const & params) [member function]
    cls.add_method('SchedDlPagingBufferReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedDlRachInfoReq(ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters const & params) [member function]
    cls.add_method('SchedDlRachInfoReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedDlRlcBufferReq(ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters const & params) [member function]
    cls.add_method('SchedDlRlcBufferReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedDlTriggerReq(ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters const & params) [member function]
    cls.add_method('SchedDlTriggerReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedUlCqiInfoReq(ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters const & params) [member function]
    cls.add_method('SchedUlCqiInfoReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReq(ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters const & params) [member function]
    cls.add_method('SchedUlMacCtrlInfoReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReq(ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters const & params) [member function]
    cls.add_method('SchedUlNoiseInterferenceReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedUlSrInfoReq(ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters const & params) [member function]
    cls.add_method('SchedUlSrInfoReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapProvider::SchedUlTriggerReq(ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters const & params) [member function]
    cls.add_method('SchedUlTriggerReq', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3FfMacSchedSapProviderSchedDlCqiInfoReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters::SchedDlCqiInfoReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters::SchedDlCqiInfoReqParameters(ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters::m_cqiList [variable]
    cls.add_instance_attribute('m_cqiList', 'std::vector< ns3::CqiListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedDlMacBufferReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters::SchedDlMacBufferReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters::SchedDlMacBufferReqParameters(ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters::m_ceBitmap [variable]
    cls.add_instance_attribute('m_ceBitmap', 'ns3::CeBitmap_e', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlMacBufferReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedDlPagingBufferReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters::SchedDlPagingBufferReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters::SchedDlPagingBufferReqParameters(ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters::m_pagingInfoList [variable]
    cls.add_instance_attribute('m_pagingInfoList', 'std::vector< ns3::PagingInfoListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlPagingBufferReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedDlRachInfoReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters::SchedDlRachInfoReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters::SchedDlRachInfoReqParameters(ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters::m_rachList [variable]
    cls.add_instance_attribute('m_rachList', 'std::vector< ns3::RachListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRachInfoReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedDlRlcBufferReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::SchedDlRlcBufferReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::SchedDlRlcBufferReqParameters(ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_logicalChannelIdentity [variable]
    cls.add_instance_attribute('m_logicalChannelIdentity', 'uint8_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_rlcRetransmissionHolDelay [variable]
    cls.add_instance_attribute('m_rlcRetransmissionHolDelay', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_rlcRetransmissionQueueSize [variable]
    cls.add_instance_attribute('m_rlcRetransmissionQueueSize', 'uint32_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_rlcStatusPduSize [variable]
    cls.add_instance_attribute('m_rlcStatusPduSize', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_rlcTransmissionQueueHolDelay [variable]
    cls.add_instance_attribute('m_rlcTransmissionQueueHolDelay', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_rlcTransmissionQueueSize [variable]
    cls.add_instance_attribute('m_rlcTransmissionQueueSize', 'uint32_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlRlcBufferReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedDlTriggerReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters::SchedDlTriggerReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters::SchedDlTriggerReqParameters(ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters::m_dlInfoList [variable]
    cls.add_instance_attribute('m_dlInfoList', 'std::vector< ns3::DlInfoListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedDlTriggerReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedUlCqiInfoReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters::SchedUlCqiInfoReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters::SchedUlCqiInfoReqParameters(ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters::m_ulCqi [variable]
    cls.add_instance_attribute('m_ulCqi', 'ns3::UlCqi_s', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedUlMacCtrlInfoReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters::SchedUlMacCtrlInfoReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters::SchedUlMacCtrlInfoReqParameters(ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters::m_macCeList [variable]
    cls.add_instance_attribute('m_macCeList', 'std::vector< ns3::MacCeListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlMacCtrlInfoReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedUlNoiseInterferenceReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters::SchedUlNoiseInterferenceReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters::SchedUlNoiseInterferenceReqParameters(ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters::m_rip [variable]
    cls.add_instance_attribute('m_rip', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters::m_tnp [variable]
    cls.add_instance_attribute('m_tnp', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlNoiseInterferenceReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedUlSrInfoReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters::SchedUlSrInfoReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters::SchedUlSrInfoReqParameters(ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters::m_srList [variable]
    cls.add_instance_attribute('m_srList', 'std::vector< ns3::SrListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlSrInfoReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapProviderSchedUlTriggerReqParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters::SchedUlTriggerReqParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters::SchedUlTriggerReqParameters(ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters::m_sfnSf [variable]
    cls.add_instance_attribute('m_sfnSf', 'uint16_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters::m_ulInfoList [variable]
    cls.add_instance_attribute('m_ulInfoList', 'std::vector< ns3::UlInfoListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapProvider::SchedUlTriggerReqParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapUser_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::FfMacSchedSapUser() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::FfMacSchedSapUser(ns3::FfMacSchedSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapUser const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapUser::SchedDlConfigInd(ns3::FfMacSchedSapUser::SchedDlConfigIndParameters const & params) [member function]
    cls.add_method('SchedDlConfigInd', 
                   'void', 
                   [param('ns3::FfMacSchedSapUser::SchedDlConfigIndParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## ff-mac-sched-sap.h (module 'lte'): void ns3::FfMacSchedSapUser::SchedUlConfigInd(ns3::FfMacSchedSapUser::SchedUlConfigIndParameters const & params) [member function]
    cls.add_method('SchedUlConfigInd', 
                   'void', 
                   [param('ns3::FfMacSchedSapUser::SchedUlConfigIndParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3FfMacSchedSapUserSchedDlConfigIndParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::SchedDlConfigIndParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::SchedDlConfigIndParameters(ns3::FfMacSchedSapUser::SchedDlConfigIndParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapUser::SchedDlConfigIndParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::m_buildBroadcastList [variable]
    cls.add_instance_attribute('m_buildBroadcastList', 'std::vector< ns3::BuildBroadcastListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::m_buildDataList [variable]
    cls.add_instance_attribute('m_buildDataList', 'std::vector< ns3::BuildDataListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::m_buildRarList [variable]
    cls.add_instance_attribute('m_buildRarList', 'std::vector< ns3::BuildRarListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::m_nrOfPdcchOfdmSymbols [variable]
    cls.add_instance_attribute('m_nrOfPdcchOfdmSymbols', 'uint8_t', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedDlConfigIndParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3FfMacSchedSapUserSchedUlConfigIndParameters_methods(root_module, cls):
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedUlConfigIndParameters::SchedUlConfigIndParameters() [constructor]
    cls.add_constructor([])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedUlConfigIndParameters::SchedUlConfigIndParameters(ns3::FfMacSchedSapUser::SchedUlConfigIndParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::FfMacSchedSapUser::SchedUlConfigIndParameters const &', 'arg0')])
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedUlConfigIndParameters::m_dciList [variable]
    cls.add_instance_attribute('m_dciList', 'std::vector< ns3::UlDciListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedUlConfigIndParameters::m_phichList [variable]
    cls.add_instance_attribute('m_phichList', 'std::vector< ns3::PhichListElement_s >', is_const=False)
    ## ff-mac-sched-sap.h (module 'lte'): ns3::FfMacSchedSapUser::SchedUlConfigIndParameters::m_vendorSpecificList [variable]
    cls.add_instance_attribute('m_vendorSpecificList', 'std::vector< ns3::VendorSpecificListElement_s >', is_const=False)
    return

def register_Ns3GbrQosInformation_methods(root_module, cls):
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation::GbrQosInformation(ns3::GbrQosInformation const & arg0) [constructor]
    cls.add_constructor([param('ns3::GbrQosInformation const &', 'arg0')])
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation::GbrQosInformation() [constructor]
    cls.add_constructor([])
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation::gbrDl [variable]
    cls.add_instance_attribute('gbrDl', 'uint64_t', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation::gbrUl [variable]
    cls.add_instance_attribute('gbrUl', 'uint64_t', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation::mbrDl [variable]
    cls.add_instance_attribute('mbrDl', 'uint64_t', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::GbrQosInformation::mbrUl [variable]
    cls.add_instance_attribute('mbrUl', 'uint64_t', is_const=False)
    return

def register_Ns3GtpcIes_methods(root_module, cls):
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeImsi [variable]
    cls.add_instance_attribute('serializedSizeImsi', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeCause [variable]
    cls.add_instance_attribute('serializedSizeCause', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeEbi [variable]
    cls.add_instance_attribute('serializedSizeEbi', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeBearerQos [variable]
    cls.add_instance_attribute('serializedSizeBearerQos', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizePacketFilter [variable]
    cls.add_instance_attribute('serializedSizePacketFilter', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::GetSerializedSizeBearerTft(std::list<ns3::EpcTft::PacketFilter, std::allocator<ns3::EpcTft::PacketFilter> > packetFilters) const [member function]
    cls.add_method('GetSerializedSizeBearerTft', 
                   'uint32_t', 
                   [param('std::list< ns3::EpcTft::PacketFilter >', 'packetFilters')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeUliEcgi [variable]
    cls.add_instance_attribute('serializedSizeUliEcgi', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeFteid [variable]
    cls.add_instance_attribute('serializedSizeFteid', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::serializedSizeBearerContextHeader [variable]
    cls.add_instance_attribute('serializedSizeBearerContextHeader', 'uint32_t const', is_const=True)
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeImsi(ns3::Buffer::Iterator & i, uint64_t imsi) const [member function]
    cls.add_method('SerializeImsi', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint64_t', 'imsi')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeImsi(ns3::Buffer::Iterator & i, uint64_t & imsi) [member function]
    cls.add_method('DeserializeImsi', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint64_t &', 'imsi')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeCause(ns3::Buffer::Iterator & i, ns3::GtpcIes::Cause_t cause) const [member function]
    cls.add_method('SerializeCause', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::GtpcIes::Cause_t', 'cause')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeCause(ns3::Buffer::Iterator & i, ns3::GtpcIes::Cause_t & cause) [member function]
    cls.add_method('DeserializeCause', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::GtpcIes::Cause_t &', 'cause')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeEbi(ns3::Buffer::Iterator & i, uint8_t epsBearerId) const [member function]
    cls.add_method('SerializeEbi', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint8_t', 'epsBearerId')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeEbi(ns3::Buffer::Iterator & i, uint8_t & epsBearerId) [member function]
    cls.add_method('DeserializeEbi', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint8_t &', 'epsBearerId')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::WriteHtonU40(ns3::Buffer::Iterator & i, uint64_t data) const [member function]
    cls.add_method('WriteHtonU40', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint64_t', 'data')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint64_t ns3::GtpcIes::ReadNtohU40(ns3::Buffer::Iterator & i) [member function]
    cls.add_method('ReadNtohU40', 
                   'uint64_t', 
                   [param('ns3::Buffer::Iterator &', 'i')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeBearerQos(ns3::Buffer::Iterator & i, ns3::EpsBearer bearerQos) const [member function]
    cls.add_method('SerializeBearerQos', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::EpsBearer', 'bearerQos')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeBearerQos(ns3::Buffer::Iterator & i, ns3::EpsBearer & bearerQos) [member function]
    cls.add_method('DeserializeBearerQos', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::EpsBearer &', 'bearerQos')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeBearerTft(ns3::Buffer::Iterator & i, std::list<ns3::EpcTft::PacketFilter, std::allocator<ns3::EpcTft::PacketFilter> > packetFilters) const [member function]
    cls.add_method('SerializeBearerTft', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('std::list< ns3::EpcTft::PacketFilter >', 'packetFilters')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeBearerTft(ns3::Buffer::Iterator & i, ns3::Ptr<ns3::EpcTft> epcTft) [member function]
    cls.add_method('DeserializeBearerTft', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::Ptr< ns3::EpcTft >', 'epcTft')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeUliEcgi(ns3::Buffer::Iterator & i, uint32_t uliEcgi) const [member function]
    cls.add_method('SerializeUliEcgi', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint32_t', 'uliEcgi')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeUliEcgi(ns3::Buffer::Iterator & i, uint32_t & uliEcgi) [member function]
    cls.add_method('DeserializeUliEcgi', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint32_t &', 'uliEcgi')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeFteid(ns3::Buffer::Iterator & i, ns3::GtpcHeader::Fteid_t fteid) const [member function]
    cls.add_method('SerializeFteid', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::GtpcHeader::Fteid_t', 'fteid')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeFteid(ns3::Buffer::Iterator & i, ns3::GtpcHeader::Fteid_t & fteid) [member function]
    cls.add_method('DeserializeFteid', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('ns3::GtpcHeader::Fteid_t &', 'fteid')])
    ## epc-gtpc-header.h (module 'lte'): void ns3::GtpcIes::SerializeBearerContextHeader(ns3::Buffer::Iterator & i, uint16_t length) const [member function]
    cls.add_method('SerializeBearerContextHeader', 
                   'void', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint16_t', 'length')], 
                   is_const=True)
    ## epc-gtpc-header.h (module 'lte'): uint32_t ns3::GtpcIes::DeserializeBearerContextHeader(ns3::Buffer::Iterator & i, uint16_t & length) [member function]
    cls.add_method('DeserializeBearerContextHeader', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator &', 'i'), param('uint16_t &', 'length')])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::GtpcIes(ns3::GtpcIes const & arg0) [constructor]
    cls.add_constructor([param('ns3::GtpcIes const &', 'arg0')])
    ## epc-gtpc-header.h (module 'lte'): ns3::GtpcIes::GtpcIes() [constructor]
    cls.add_constructor([])
    return

def register_Ns3HarqProcessInfoElement_t_methods(root_module, cls):
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t::HarqProcessInfoElement_t() [constructor]
    cls.add_constructor([])
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t::HarqProcessInfoElement_t(ns3::HarqProcessInfoElement_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::HarqProcessInfoElement_t const &', 'arg0')])
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t::m_codeBits [variable]
    cls.add_instance_attribute('m_codeBits', 'uint16_t', is_const=False)
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t::m_infoBits [variable]
    cls.add_instance_attribute('m_infoBits', 'uint16_t', is_const=False)
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t::m_mi [variable]
    cls.add_instance_attribute('m_mi', 'double', is_const=False)
    ## lte-harq-phy.h (module 'lte'): ns3::HarqProcessInfoElement_t::m_rv [variable]
    cls.add_instance_attribute('m_rv', 'uint8_t', is_const=False)
    return

def register_Ns3Hasher_methods(root_module, cls):
    ## hash.h (module 'core'): ns3::Hasher::Hasher(ns3::Hasher const & arg0) [constructor]
    cls.add_constructor([param('ns3::Hasher const &', 'arg0')])
    ## hash.h (module 'core'): ns3::Hasher::Hasher() [constructor]
    cls.add_constructor([])
    ## hash.h (module 'core'): ns3::Hasher::Hasher(ns3::Ptr<ns3::Hash::Implementation> hp) [constructor]
    cls.add_constructor([param('ns3::Ptr< ns3::Hash::Implementation >', 'hp')])
    ## hash.h (module 'core'): uint32_t ns3::Hasher::GetHash32(char const * buffer, std::size_t const size) [member function]
    cls.add_method('GetHash32', 
                   'uint32_t', 
                   [param('char const *', 'buffer'), param('std::size_t const', 'size')])
    ## hash.h (module 'core'): uint32_t ns3::Hasher::GetHash32(std::string const s) [member function]
    cls.add_method('GetHash32', 
                   'uint32_t', 
                   [param('std::string const', 's')])
    ## hash.h (module 'core'): uint64_t ns3::Hasher::GetHash64(char const * buffer, std::size_t const size) [member function]
    cls.add_method('GetHash64', 
                   'uint64_t', 
                   [param('char const *', 'buffer'), param('std::size_t const', 'size')])
    ## hash.h (module 'core'): uint64_t ns3::Hasher::GetHash64(std::string const s) [member function]
    cls.add_method('GetHash64', 
                   'uint64_t', 
                   [param('std::string const', 's')])
    ## hash.h (module 'core'): ns3::Hasher & ns3::Hasher::clear() [member function]
    cls.add_method('clear', 
                   'ns3::Hasher &', 
                   [])
    return

def register_Ns3HigherLayerSelected_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::HigherLayerSelected_s::HigherLayerSelected_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::HigherLayerSelected_s::HigherLayerSelected_s(ns3::HigherLayerSelected_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::HigherLayerSelected_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::HigherLayerSelected_s::m_sbCqi [variable]
    cls.add_instance_attribute('m_sbCqi', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::HigherLayerSelected_s::m_sbPmi [variable]
    cls.add_instance_attribute('m_sbPmi', 'uint8_t', is_const=False)
    return

def register_Ns3ImsiLcidPair_t_methods(root_module, cls):
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('==')
    ## lte-common.h (module 'lte'): ns3::ImsiLcidPair_t::ImsiLcidPair_t(ns3::ImsiLcidPair_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::ImsiLcidPair_t const &', 'arg0')])
    ## lte-common.h (module 'lte'): ns3::ImsiLcidPair_t::ImsiLcidPair_t() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::ImsiLcidPair_t::ImsiLcidPair_t(uint64_t const a, uint8_t const b) [constructor]
    cls.add_constructor([param('uint64_t const', 'a'), param('uint8_t const', 'b')])
    ## lte-common.h (module 'lte'): ns3::ImsiLcidPair_t::m_imsi [variable]
    cls.add_instance_attribute('m_imsi', 'uint64_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::ImsiLcidPair_t::m_lcId [variable]
    cls.add_instance_attribute('m_lcId', 'uint8_t', is_const=False)
    return

def register_Ns3Inet6SocketAddress_methods(root_module, cls):
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress::Inet6SocketAddress(ns3::Inet6SocketAddress const & arg0) [constructor]
    cls.add_constructor([param('ns3::Inet6SocketAddress const &', 'arg0')])
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress::Inet6SocketAddress(ns3::Ipv6Address ipv6, uint16_t port) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address', 'ipv6'), param('uint16_t', 'port')])
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress::Inet6SocketAddress(ns3::Ipv6Address ipv6) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address', 'ipv6')])
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress::Inet6SocketAddress(uint16_t port) [constructor]
    cls.add_constructor([param('uint16_t', 'port')])
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress::Inet6SocketAddress(char const * ipv6, uint16_t port) [constructor]
    cls.add_constructor([param('char const *', 'ipv6'), param('uint16_t', 'port')])
    ## inet6-socket-address.h (module 'network'): ns3::Inet6SocketAddress::Inet6SocketAddress(char const * ipv6) [constructor]
    cls.add_constructor([param('char const *', 'ipv6')])
    ## inet6-socket-address.h (module 'network'): static ns3::Inet6SocketAddress ns3::Inet6SocketAddress::ConvertFrom(ns3::Address const & addr) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::Inet6SocketAddress', 
                   [param('ns3::Address const &', 'addr')], 
                   is_static=True)
    ## inet6-socket-address.h (module 'network'): ns3::Ipv6Address ns3::Inet6SocketAddress::GetIpv6() const [member function]
    cls.add_method('GetIpv6', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_const=True)
    ## inet6-socket-address.h (module 'network'): uint16_t ns3::Inet6SocketAddress::GetPort() const [member function]
    cls.add_method('GetPort', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## inet6-socket-address.h (module 'network'): static bool ns3::Inet6SocketAddress::IsMatchingType(ns3::Address const & addr) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'addr')], 
                   is_static=True)
    ## inet6-socket-address.h (module 'network'): void ns3::Inet6SocketAddress::SetIpv6(ns3::Ipv6Address ipv6) [member function]
    cls.add_method('SetIpv6', 
                   'void', 
                   [param('ns3::Ipv6Address', 'ipv6')])
    ## inet6-socket-address.h (module 'network'): void ns3::Inet6SocketAddress::SetPort(uint16_t port) [member function]
    cls.add_method('SetPort', 
                   'void', 
                   [param('uint16_t', 'port')])
    return

def register_Ns3InetSocketAddress_methods(root_module, cls):
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress::InetSocketAddress(ns3::InetSocketAddress const & arg0) [constructor]
    cls.add_constructor([param('ns3::InetSocketAddress const &', 'arg0')])
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress::InetSocketAddress(ns3::Ipv4Address ipv4, uint16_t port) [constructor]
    cls.add_constructor([param('ns3::Ipv4Address', 'ipv4'), param('uint16_t', 'port')])
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress::InetSocketAddress(ns3::Ipv4Address ipv4) [constructor]
    cls.add_constructor([param('ns3::Ipv4Address', 'ipv4')])
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress::InetSocketAddress(uint16_t port) [constructor]
    cls.add_constructor([param('uint16_t', 'port')])
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress::InetSocketAddress(char const * ipv4, uint16_t port) [constructor]
    cls.add_constructor([param('char const *', 'ipv4'), param('uint16_t', 'port')])
    ## inet-socket-address.h (module 'network'): ns3::InetSocketAddress::InetSocketAddress(char const * ipv4) [constructor]
    cls.add_constructor([param('char const *', 'ipv4')])
    ## inet-socket-address.h (module 'network'): static ns3::InetSocketAddress ns3::InetSocketAddress::ConvertFrom(ns3::Address const & address) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::InetSocketAddress', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## inet-socket-address.h (module 'network'): ns3::Ipv4Address ns3::InetSocketAddress::GetIpv4() const [member function]
    cls.add_method('GetIpv4', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_const=True)
    ## inet-socket-address.h (module 'network'): uint16_t ns3::InetSocketAddress::GetPort() const [member function]
    cls.add_method('GetPort', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## inet-socket-address.h (module 'network'): uint8_t ns3::InetSocketAddress::GetTos() const [member function]
    cls.add_method('GetTos', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## inet-socket-address.h (module 'network'): static bool ns3::InetSocketAddress::IsMatchingType(ns3::Address const & address) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## inet-socket-address.h (module 'network'): void ns3::InetSocketAddress::SetIpv4(ns3::Ipv4Address address) [member function]
    cls.add_method('SetIpv4', 
                   'void', 
                   [param('ns3::Ipv4Address', 'address')])
    ## inet-socket-address.h (module 'network'): void ns3::InetSocketAddress::SetPort(uint16_t port) [member function]
    cls.add_method('SetPort', 
                   'void', 
                   [param('uint16_t', 'port')])
    ## inet-socket-address.h (module 'network'): void ns3::InetSocketAddress::SetTos(uint8_t tos) [member function]
    cls.add_method('SetTos', 
                   'void', 
                   [param('uint8_t', 'tos')])
    return

def register_Ns3Ipv4Address_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address::Ipv4Address(ns3::Ipv4Address const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv4Address const &', 'arg0')])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address::Ipv4Address() [constructor]
    cls.add_constructor([])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address::Ipv4Address(uint32_t address) [constructor]
    cls.add_constructor([param('uint32_t', 'address')])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address::Ipv4Address(char const * address) [constructor]
    cls.add_constructor([param('char const *', 'address')])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address ns3::Ipv4Address::CombineMask(ns3::Ipv4Mask const & mask) const [member function]
    cls.add_method('CombineMask', 
                   'ns3::Ipv4Address', 
                   [param('ns3::Ipv4Mask const &', 'mask')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Address ns3::Ipv4Address::ConvertFrom(ns3::Address const & address) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::Ipv4Address', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Address ns3::Ipv4Address::Deserialize(uint8_t const * buf) [member function]
    cls.add_method('Deserialize', 
                   'ns3::Ipv4Address', 
                   [param('uint8_t const *', 'buf')], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): uint32_t ns3::Ipv4Address::Get() const [member function]
    cls.add_method('Get', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Address ns3::Ipv4Address::GetAny() [member function]
    cls.add_method('GetAny', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Address ns3::Ipv4Address::GetBroadcast() [member function]
    cls.add_method('GetBroadcast', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Address ns3::Ipv4Address::GetLoopback() [member function]
    cls.add_method('GetLoopback', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): ns3::Ipv4Address ns3::Ipv4Address::GetSubnetDirectedBroadcast(ns3::Ipv4Mask const & mask) const [member function]
    cls.add_method('GetSubnetDirectedBroadcast', 
                   'ns3::Ipv4Address', 
                   [param('ns3::Ipv4Mask const &', 'mask')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Address ns3::Ipv4Address::GetZero() [member function]
    cls.add_method('GetZero', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsAny() const [member function]
    cls.add_method('IsAny', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsBroadcast() const [member function]
    cls.add_method('IsBroadcast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsEqual(ns3::Ipv4Address const & other) const [member function]
    cls.add_method('IsEqual', 
                   'bool', 
                   [param('ns3::Ipv4Address const &', 'other')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsLocalMulticast() const [member function]
    cls.add_method('IsLocalMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsLocalhost() const [member function]
    cls.add_method('IsLocalhost', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): static bool ns3::Ipv4Address::IsMatchingType(ns3::Address const & address) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsMulticast() const [member function]
    cls.add_method('IsMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Address::IsSubnetDirectedBroadcast(ns3::Ipv4Mask const & mask) const [member function]
    cls.add_method('IsSubnetDirectedBroadcast', 
                   'bool', 
                   [param('ns3::Ipv4Mask const &', 'mask')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): void ns3::Ipv4Address::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): void ns3::Ipv4Address::Serialize(uint8_t * buf) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('uint8_t *', 'buf')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): void ns3::Ipv4Address::Set(uint32_t address) [member function]
    cls.add_method('Set', 
                   'void', 
                   [param('uint32_t', 'address')])
    ## ipv4-address.h (module 'network'): void ns3::Ipv4Address::Set(char const * address) [member function]
    cls.add_method('Set', 
                   'void', 
                   [param('char const *', 'address')])
    return

def register_Ns3Ipv4AddressHelper_methods(root_module, cls):
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4AddressHelper::Ipv4AddressHelper(ns3::Ipv4AddressHelper const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv4AddressHelper const &', 'arg0')])
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4AddressHelper::Ipv4AddressHelper() [constructor]
    cls.add_constructor([])
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4AddressHelper::Ipv4AddressHelper(ns3::Ipv4Address network, ns3::Ipv4Mask mask, ns3::Ipv4Address base="0.0.0.1") [constructor]
    cls.add_constructor([param('ns3::Ipv4Address', 'network'), param('ns3::Ipv4Mask', 'mask'), param('ns3::Ipv4Address', 'base', default_value='"0.0.0.1"')])
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4InterfaceContainer ns3::Ipv4AddressHelper::Assign(ns3::NetDeviceContainer const & c) [member function]
    cls.add_method('Assign', 
                   'ns3::Ipv4InterfaceContainer', 
                   [param('ns3::NetDeviceContainer const &', 'c')])
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4AddressHelper::NewAddress() [member function]
    cls.add_method('NewAddress', 
                   'ns3::Ipv4Address', 
                   [])
    ## ipv4-address-helper.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4AddressHelper::NewNetwork() [member function]
    cls.add_method('NewNetwork', 
                   'ns3::Ipv4Address', 
                   [])
    ## ipv4-address-helper.h (module 'internet'): void ns3::Ipv4AddressHelper::SetBase(ns3::Ipv4Address network, ns3::Ipv4Mask mask, ns3::Ipv4Address base="0.0.0.1") [member function]
    cls.add_method('SetBase', 
                   'void', 
                   [param('ns3::Ipv4Address', 'network'), param('ns3::Ipv4Mask', 'mask'), param('ns3::Ipv4Address', 'base', default_value='"0.0.0.1"')])
    return

def register_Ns3Ipv4InterfaceAddress_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4InterfaceAddress::Ipv4InterfaceAddress() [constructor]
    cls.add_constructor([])
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4InterfaceAddress::Ipv4InterfaceAddress(ns3::Ipv4Address local, ns3::Ipv4Mask mask) [constructor]
    cls.add_constructor([param('ns3::Ipv4Address', 'local'), param('ns3::Ipv4Mask', 'mask')])
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4InterfaceAddress::Ipv4InterfaceAddress(ns3::Ipv4InterfaceAddress const & o) [constructor]
    cls.add_constructor([param('ns3::Ipv4InterfaceAddress const &', 'o')])
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4InterfaceAddress::GetBroadcast() const [member function]
    cls.add_method('GetBroadcast', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_const=True)
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4InterfaceAddress::GetLocal() const [member function]
    cls.add_method('GetLocal', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_const=True)
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4Mask ns3::Ipv4InterfaceAddress::GetMask() const [member function]
    cls.add_method('GetMask', 
                   'ns3::Ipv4Mask', 
                   [], 
                   is_const=True)
    ## ipv4-interface-address.h (module 'internet'): ns3::Ipv4InterfaceAddress::InterfaceAddressScope_e ns3::Ipv4InterfaceAddress::GetScope() const [member function]
    cls.add_method('GetScope', 
                   'ns3::Ipv4InterfaceAddress::InterfaceAddressScope_e', 
                   [], 
                   is_const=True)
    ## ipv4-interface-address.h (module 'internet'): bool ns3::Ipv4InterfaceAddress::IsSecondary() const [member function]
    cls.add_method('IsSecondary', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-interface-address.h (module 'internet'): void ns3::Ipv4InterfaceAddress::SetBroadcast(ns3::Ipv4Address broadcast) [member function]
    cls.add_method('SetBroadcast', 
                   'void', 
                   [param('ns3::Ipv4Address', 'broadcast')])
    ## ipv4-interface-address.h (module 'internet'): void ns3::Ipv4InterfaceAddress::SetLocal(ns3::Ipv4Address local) [member function]
    cls.add_method('SetLocal', 
                   'void', 
                   [param('ns3::Ipv4Address', 'local')])
    ## ipv4-interface-address.h (module 'internet'): void ns3::Ipv4InterfaceAddress::SetMask(ns3::Ipv4Mask mask) [member function]
    cls.add_method('SetMask', 
                   'void', 
                   [param('ns3::Ipv4Mask', 'mask')])
    ## ipv4-interface-address.h (module 'internet'): void ns3::Ipv4InterfaceAddress::SetPrimary() [member function]
    cls.add_method('SetPrimary', 
                   'void', 
                   [])
    ## ipv4-interface-address.h (module 'internet'): void ns3::Ipv4InterfaceAddress::SetScope(ns3::Ipv4InterfaceAddress::InterfaceAddressScope_e scope) [member function]
    cls.add_method('SetScope', 
                   'void', 
                   [param('ns3::Ipv4InterfaceAddress::InterfaceAddressScope_e', 'scope')])
    ## ipv4-interface-address.h (module 'internet'): void ns3::Ipv4InterfaceAddress::SetSecondary() [member function]
    cls.add_method('SetSecondary', 
                   'void', 
                   [])
    return

def register_Ns3Ipv4InterfaceContainer_methods(root_module, cls):
    ## ipv4-interface-container.h (module 'internet'): ns3::Ipv4InterfaceContainer::Ipv4InterfaceContainer(ns3::Ipv4InterfaceContainer const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv4InterfaceContainer const &', 'arg0')])
    ## ipv4-interface-container.h (module 'internet'): ns3::Ipv4InterfaceContainer::Ipv4InterfaceContainer() [constructor]
    cls.add_constructor([])
    ## ipv4-interface-container.h (module 'internet'): void ns3::Ipv4InterfaceContainer::Add(ns3::Ipv4InterfaceContainer const & other) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ipv4InterfaceContainer const &', 'other')])
    ## ipv4-interface-container.h (module 'internet'): void ns3::Ipv4InterfaceContainer::Add(ns3::Ptr<ns3::Ipv4> ipv4, uint32_t interface) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ptr< ns3::Ipv4 >', 'ipv4'), param('uint32_t', 'interface')])
    ## ipv4-interface-container.h (module 'internet'): void ns3::Ipv4InterfaceContainer::Add(std::pair<ns3::Ptr<ns3::Ipv4>, unsigned int> ipInterfacePair) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::pair< ns3::Ptr< ns3::Ipv4 >, unsigned int >', 'ipInterfacePair')])
    ## ipv4-interface-container.h (module 'internet'): void ns3::Ipv4InterfaceContainer::Add(std::string ipv4Name, uint32_t interface) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'ipv4Name'), param('uint32_t', 'interface')])
    ## ipv4-interface-container.h (module 'internet'): ns3::Ipv4InterfaceContainer::Iterator ns3::Ipv4InterfaceContainer::Begin() const [member function]
    cls.add_method('Begin', 
                   'ns3::Ipv4InterfaceContainer::Iterator', 
                   [], 
                   is_const=True)
    ## ipv4-interface-container.h (module 'internet'): ns3::Ipv4InterfaceContainer::Iterator ns3::Ipv4InterfaceContainer::End() const [member function]
    cls.add_method('End', 
                   'ns3::Ipv4InterfaceContainer::Iterator', 
                   [], 
                   is_const=True)
    ## ipv4-interface-container.h (module 'internet'): std::pair<ns3::Ptr<ns3::Ipv4>, unsigned int> ns3::Ipv4InterfaceContainer::Get(uint32_t i) const [member function]
    cls.add_method('Get', 
                   'std::pair< ns3::Ptr< ns3::Ipv4 >, unsigned int >', 
                   [param('uint32_t', 'i')], 
                   is_const=True)
    ## ipv4-interface-container.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4InterfaceContainer::GetAddress(uint32_t i, uint32_t j=0) const [member function]
    cls.add_method('GetAddress', 
                   'ns3::Ipv4Address', 
                   [param('uint32_t', 'i'), param('uint32_t', 'j', default_value='0')], 
                   is_const=True)
    ## ipv4-interface-container.h (module 'internet'): uint32_t ns3::Ipv4InterfaceContainer::GetN() const [member function]
    cls.add_method('GetN', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## ipv4-interface-container.h (module 'internet'): void ns3::Ipv4InterfaceContainer::SetMetric(uint32_t i, uint16_t metric) [member function]
    cls.add_method('SetMetric', 
                   'void', 
                   [param('uint32_t', 'i'), param('uint16_t', 'metric')])
    return

def register_Ns3Ipv4Mask_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    ## ipv4-address.h (module 'network'): ns3::Ipv4Mask::Ipv4Mask(ns3::Ipv4Mask const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv4Mask const &', 'arg0')])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Mask::Ipv4Mask() [constructor]
    cls.add_constructor([])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Mask::Ipv4Mask(uint32_t mask) [constructor]
    cls.add_constructor([param('uint32_t', 'mask')])
    ## ipv4-address.h (module 'network'): ns3::Ipv4Mask::Ipv4Mask(char const * mask) [constructor]
    cls.add_constructor([param('char const *', 'mask')])
    ## ipv4-address.h (module 'network'): uint32_t ns3::Ipv4Mask::Get() const [member function]
    cls.add_method('Get', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): uint32_t ns3::Ipv4Mask::GetInverse() const [member function]
    cls.add_method('GetInverse', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Mask ns3::Ipv4Mask::GetLoopback() [member function]
    cls.add_method('GetLoopback', 
                   'ns3::Ipv4Mask', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Mask ns3::Ipv4Mask::GetOnes() [member function]
    cls.add_method('GetOnes', 
                   'ns3::Ipv4Mask', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): uint16_t ns3::Ipv4Mask::GetPrefixLength() const [member function]
    cls.add_method('GetPrefixLength', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): static ns3::Ipv4Mask ns3::Ipv4Mask::GetZero() [member function]
    cls.add_method('GetZero', 
                   'ns3::Ipv4Mask', 
                   [], 
                   is_static=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Mask::IsEqual(ns3::Ipv4Mask other) const [member function]
    cls.add_method('IsEqual', 
                   'bool', 
                   [param('ns3::Ipv4Mask', 'other')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): bool ns3::Ipv4Mask::IsMatch(ns3::Ipv4Address a, ns3::Ipv4Address b) const [member function]
    cls.add_method('IsMatch', 
                   'bool', 
                   [param('ns3::Ipv4Address', 'a'), param('ns3::Ipv4Address', 'b')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): void ns3::Ipv4Mask::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True)
    ## ipv4-address.h (module 'network'): void ns3::Ipv4Mask::Set(uint32_t mask) [member function]
    cls.add_method('Set', 
                   'void', 
                   [param('uint32_t', 'mask')])
    return

def register_Ns3Ipv6Address_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address::Ipv6Address() [constructor]
    cls.add_constructor([])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address::Ipv6Address(char const * address) [constructor]
    cls.add_constructor([param('char const *', 'address')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address::Ipv6Address(uint8_t * address) [constructor]
    cls.add_constructor([param('uint8_t *', 'address')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address::Ipv6Address(ns3::Ipv6Address const & addr) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address const &', 'addr')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address::Ipv6Address(ns3::Ipv6Address const * addr) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address const *', 'addr')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Address ns3::Ipv6Address::CombinePrefix(ns3::Ipv6Prefix const & prefix) [member function]
    cls.add_method('CombinePrefix', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Ipv6Prefix const &', 'prefix')])
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::ConvertFrom(ns3::Address const & address) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::Deserialize(uint8_t const * buf) [member function]
    cls.add_method('Deserialize', 
                   'ns3::Ipv6Address', 
                   [param('uint8_t const *', 'buf')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetAllHostsMulticast() [member function]
    cls.add_method('GetAllHostsMulticast', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetAllNodesMulticast() [member function]
    cls.add_method('GetAllNodesMulticast', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetAllRoutersMulticast() [member function]
    cls.add_method('GetAllRoutersMulticast', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetAny() [member function]
    cls.add_method('GetAny', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Address::GetBytes(uint8_t * buf) const [member function]
    cls.add_method('GetBytes', 
                   'void', 
                   [param('uint8_t *', 'buf')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): ns3::Ipv4Address ns3::Ipv6Address::GetIpv4MappedAddress() const [member function]
    cls.add_method('GetIpv4MappedAddress', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetLoopback() [member function]
    cls.add_method('GetLoopback', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetOnes() [member function]
    cls.add_method('GetOnes', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::GetZero() [member function]
    cls.add_method('GetZero', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsAllHostsMulticast() const [member function]
    cls.add_method('IsAllHostsMulticast', 
                   'bool', 
                   [], 
                   is_const=True, deprecated=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsAllNodesMulticast() const [member function]
    cls.add_method('IsAllNodesMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsAllRoutersMulticast() const [member function]
    cls.add_method('IsAllRoutersMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsAny() const [member function]
    cls.add_method('IsAny', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsDocumentation() const [member function]
    cls.add_method('IsDocumentation', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsEqual(ns3::Ipv6Address const & other) const [member function]
    cls.add_method('IsEqual', 
                   'bool', 
                   [param('ns3::Ipv6Address const &', 'other')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsIpv4MappedAddress() const [member function]
    cls.add_method('IsIpv4MappedAddress', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsLinkLocal() const [member function]
    cls.add_method('IsLinkLocal', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsLinkLocalMulticast() const [member function]
    cls.add_method('IsLinkLocalMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsLocalhost() const [member function]
    cls.add_method('IsLocalhost', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): static bool ns3::Ipv6Address::IsMatchingType(ns3::Address const & address) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsMulticast() const [member function]
    cls.add_method('IsMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Address::IsSolicitedMulticast() const [member function]
    cls.add_method('IsSolicitedMulticast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredAddress(ns3::Mac16Address addr, ns3::Ipv6Address prefix) [member function]
    cls.add_method('MakeAutoconfiguredAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac16Address', 'addr'), param('ns3::Ipv6Address', 'prefix')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredAddress(ns3::Mac48Address addr, ns3::Ipv6Address prefix) [member function]
    cls.add_method('MakeAutoconfiguredAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac48Address', 'addr'), param('ns3::Ipv6Address', 'prefix')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredAddress(ns3::Mac64Address addr, ns3::Ipv6Address prefix) [member function]
    cls.add_method('MakeAutoconfiguredAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac64Address', 'addr'), param('ns3::Ipv6Address', 'prefix')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredAddress(ns3::Mac8Address addr, ns3::Ipv6Address prefix) [member function]
    cls.add_method('MakeAutoconfiguredAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac8Address', 'addr'), param('ns3::Ipv6Address', 'prefix')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredLinkLocalAddress(ns3::Mac16Address mac) [member function]
    cls.add_method('MakeAutoconfiguredLinkLocalAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac16Address', 'mac')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredLinkLocalAddress(ns3::Mac48Address mac) [member function]
    cls.add_method('MakeAutoconfiguredLinkLocalAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac48Address', 'mac')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredLinkLocalAddress(ns3::Mac64Address mac) [member function]
    cls.add_method('MakeAutoconfiguredLinkLocalAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac64Address', 'mac')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeAutoconfiguredLinkLocalAddress(ns3::Mac8Address mac) [member function]
    cls.add_method('MakeAutoconfiguredLinkLocalAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Mac8Address', 'mac')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeIpv4MappedAddress(ns3::Ipv4Address addr) [member function]
    cls.add_method('MakeIpv4MappedAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Ipv4Address', 'addr')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Address ns3::Ipv6Address::MakeSolicitedAddress(ns3::Ipv6Address addr) [member function]
    cls.add_method('MakeSolicitedAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Ipv6Address', 'addr')], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Address::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Address::Serialize(uint8_t * buf) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('uint8_t *', 'buf')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Address::Set(char const * address) [member function]
    cls.add_method('Set', 
                   'void', 
                   [param('char const *', 'address')])
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Address::Set(uint8_t * address) [member function]
    cls.add_method('Set', 
                   'void', 
                   [param('uint8_t *', 'address')])
    return

def register_Ns3Ipv6AddressHelper_methods(root_module, cls):
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6AddressHelper::Ipv6AddressHelper(ns3::Ipv6AddressHelper const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv6AddressHelper const &', 'arg0')])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6AddressHelper::Ipv6AddressHelper() [constructor]
    cls.add_constructor([])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6AddressHelper::Ipv6AddressHelper(ns3::Ipv6Address network, ns3::Ipv6Prefix prefix, ns3::Ipv6Address base=ns3::Ipv6Address("::1")) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address', 'network'), param('ns3::Ipv6Prefix', 'prefix'), param('ns3::Ipv6Address', 'base', default_value='ns3::Ipv6Address("::1")')])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6InterfaceContainer ns3::Ipv6AddressHelper::Assign(ns3::NetDeviceContainer const & c) [member function]
    cls.add_method('Assign', 
                   'ns3::Ipv6InterfaceContainer', 
                   [param('ns3::NetDeviceContainer const &', 'c')])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6InterfaceContainer ns3::Ipv6AddressHelper::Assign(ns3::NetDeviceContainer const & c, std::vector<bool, std::allocator<bool> > withConfiguration) [member function]
    cls.add_method('Assign', 
                   'ns3::Ipv6InterfaceContainer', 
                   [param('ns3::NetDeviceContainer const &', 'c'), param('std::vector< bool >', 'withConfiguration')])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6InterfaceContainer ns3::Ipv6AddressHelper::AssignWithoutAddress(ns3::NetDeviceContainer const & c) [member function]
    cls.add_method('AssignWithoutAddress', 
                   'ns3::Ipv6InterfaceContainer', 
                   [param('ns3::NetDeviceContainer const &', 'c')])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6Address ns3::Ipv6AddressHelper::NewAddress(ns3::Address addr) [member function]
    cls.add_method('NewAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Address', 'addr')])
    ## ipv6-address-helper.h (module 'internet'): ns3::Ipv6Address ns3::Ipv6AddressHelper::NewAddress() [member function]
    cls.add_method('NewAddress', 
                   'ns3::Ipv6Address', 
                   [])
    ## ipv6-address-helper.h (module 'internet'): void ns3::Ipv6AddressHelper::NewNetwork() [member function]
    cls.add_method('NewNetwork', 
                   'void', 
                   [])
    ## ipv6-address-helper.h (module 'internet'): void ns3::Ipv6AddressHelper::SetBase(ns3::Ipv6Address network, ns3::Ipv6Prefix prefix, ns3::Ipv6Address base=ns3::Ipv6Address("::1")) [member function]
    cls.add_method('SetBase', 
                   'void', 
                   [param('ns3::Ipv6Address', 'network'), param('ns3::Ipv6Prefix', 'prefix'), param('ns3::Ipv6Address', 'base', default_value='ns3::Ipv6Address("::1")')])
    return

def register_Ns3Ipv6InterfaceAddress_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::Ipv6InterfaceAddress() [constructor]
    cls.add_constructor([])
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::Ipv6InterfaceAddress(ns3::Ipv6Address address) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address', 'address')])
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::Ipv6InterfaceAddress(ns3::Ipv6Address address, ns3::Ipv6Prefix prefix) [constructor]
    cls.add_constructor([param('ns3::Ipv6Address', 'address'), param('ns3::Ipv6Prefix', 'prefix')])
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::Ipv6InterfaceAddress(ns3::Ipv6InterfaceAddress const & o) [constructor]
    cls.add_constructor([param('ns3::Ipv6InterfaceAddress const &', 'o')])
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6Address ns3::Ipv6InterfaceAddress::GetAddress() const [member function]
    cls.add_method('GetAddress', 
                   'ns3::Ipv6Address', 
                   [], 
                   is_const=True)
    ## ipv6-interface-address.h (module 'internet'): uint32_t ns3::Ipv6InterfaceAddress::GetNsDadUid() const [member function]
    cls.add_method('GetNsDadUid', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6Prefix ns3::Ipv6InterfaceAddress::GetPrefix() const [member function]
    cls.add_method('GetPrefix', 
                   'ns3::Ipv6Prefix', 
                   [], 
                   is_const=True)
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::Scope_e ns3::Ipv6InterfaceAddress::GetScope() const [member function]
    cls.add_method('GetScope', 
                   'ns3::Ipv6InterfaceAddress::Scope_e', 
                   [], 
                   is_const=True)
    ## ipv6-interface-address.h (module 'internet'): ns3::Ipv6InterfaceAddress::State_e ns3::Ipv6InterfaceAddress::GetState() const [member function]
    cls.add_method('GetState', 
                   'ns3::Ipv6InterfaceAddress::State_e', 
                   [], 
                   is_const=True)
    ## ipv6-interface-address.h (module 'internet'): bool ns3::Ipv6InterfaceAddress::IsInSameSubnet(ns3::Ipv6Address b) const [member function]
    cls.add_method('IsInSameSubnet', 
                   'bool', 
                   [param('ns3::Ipv6Address', 'b')], 
                   is_const=True)
    ## ipv6-interface-address.h (module 'internet'): void ns3::Ipv6InterfaceAddress::SetAddress(ns3::Ipv6Address address) [member function]
    cls.add_method('SetAddress', 
                   'void', 
                   [param('ns3::Ipv6Address', 'address')])
    ## ipv6-interface-address.h (module 'internet'): void ns3::Ipv6InterfaceAddress::SetNsDadUid(uint32_t uid) [member function]
    cls.add_method('SetNsDadUid', 
                   'void', 
                   [param('uint32_t', 'uid')])
    ## ipv6-interface-address.h (module 'internet'): void ns3::Ipv6InterfaceAddress::SetScope(ns3::Ipv6InterfaceAddress::Scope_e scope) [member function]
    cls.add_method('SetScope', 
                   'void', 
                   [param('ns3::Ipv6InterfaceAddress::Scope_e', 'scope')])
    ## ipv6-interface-address.h (module 'internet'): void ns3::Ipv6InterfaceAddress::SetState(ns3::Ipv6InterfaceAddress::State_e state) [member function]
    cls.add_method('SetState', 
                   'void', 
                   [param('ns3::Ipv6InterfaceAddress::State_e', 'state')])
    return

def register_Ns3Ipv6InterfaceContainer_methods(root_module, cls):
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6InterfaceContainer::Ipv6InterfaceContainer(ns3::Ipv6InterfaceContainer const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv6InterfaceContainer const &', 'arg0')])
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6InterfaceContainer::Ipv6InterfaceContainer() [constructor]
    cls.add_constructor([])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::Add(ns3::Ptr<ns3::Ipv6> ipv6, uint32_t interface) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ptr< ns3::Ipv6 >', 'ipv6'), param('uint32_t', 'interface')])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::Add(ns3::Ipv6InterfaceContainer const & c) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ipv6InterfaceContainer const &', 'c')])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::Add(std::string ipv6Name, uint32_t interface) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'ipv6Name'), param('uint32_t', 'interface')])
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6InterfaceContainer::Iterator ns3::Ipv6InterfaceContainer::Begin() const [member function]
    cls.add_method('Begin', 
                   'ns3::Ipv6InterfaceContainer::Iterator', 
                   [], 
                   is_const=True)
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6InterfaceContainer::Iterator ns3::Ipv6InterfaceContainer::End() const [member function]
    cls.add_method('End', 
                   'ns3::Ipv6InterfaceContainer::Iterator', 
                   [], 
                   is_const=True)
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6Address ns3::Ipv6InterfaceContainer::GetAddress(uint32_t i, uint32_t j) const [member function]
    cls.add_method('GetAddress', 
                   'ns3::Ipv6Address', 
                   [param('uint32_t', 'i'), param('uint32_t', 'j')], 
                   is_const=True)
    ## ipv6-interface-container.h (module 'internet'): uint32_t ns3::Ipv6InterfaceContainer::GetInterfaceIndex(uint32_t i) const [member function]
    cls.add_method('GetInterfaceIndex', 
                   'uint32_t', 
                   [param('uint32_t', 'i')], 
                   is_const=True)
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6Address ns3::Ipv6InterfaceContainer::GetLinkLocalAddress(uint32_t i) [member function]
    cls.add_method('GetLinkLocalAddress', 
                   'ns3::Ipv6Address', 
                   [param('uint32_t', 'i')])
    ## ipv6-interface-container.h (module 'internet'): ns3::Ipv6Address ns3::Ipv6InterfaceContainer::GetLinkLocalAddress(ns3::Ipv6Address address) [member function]
    cls.add_method('GetLinkLocalAddress', 
                   'ns3::Ipv6Address', 
                   [param('ns3::Ipv6Address', 'address')])
    ## ipv6-interface-container.h (module 'internet'): uint32_t ns3::Ipv6InterfaceContainer::GetN() const [member function]
    cls.add_method('GetN', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::SetDefaultRoute(uint32_t i, uint32_t router) [member function]
    cls.add_method('SetDefaultRoute', 
                   'void', 
                   [param('uint32_t', 'i'), param('uint32_t', 'router')])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::SetDefaultRoute(uint32_t i, ns3::Ipv6Address routerAddr) [member function]
    cls.add_method('SetDefaultRoute', 
                   'void', 
                   [param('uint32_t', 'i'), param('ns3::Ipv6Address', 'routerAddr')])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::SetDefaultRouteInAllNodes(uint32_t router) [member function]
    cls.add_method('SetDefaultRouteInAllNodes', 
                   'void', 
                   [param('uint32_t', 'router')])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::SetDefaultRouteInAllNodes(ns3::Ipv6Address routerAddr) [member function]
    cls.add_method('SetDefaultRouteInAllNodes', 
                   'void', 
                   [param('ns3::Ipv6Address', 'routerAddr')])
    ## ipv6-interface-container.h (module 'internet'): void ns3::Ipv6InterfaceContainer::SetForwarding(uint32_t i, bool state) [member function]
    cls.add_method('SetForwarding', 
                   'void', 
                   [param('uint32_t', 'i'), param('bool', 'state')])
    return

def register_Ns3Ipv6Prefix_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix::Ipv6Prefix() [constructor]
    cls.add_constructor([])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix::Ipv6Prefix(uint8_t * prefix) [constructor]
    cls.add_constructor([param('uint8_t *', 'prefix')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix::Ipv6Prefix(char const * prefix) [constructor]
    cls.add_constructor([param('char const *', 'prefix')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix::Ipv6Prefix(uint8_t prefix) [constructor]
    cls.add_constructor([param('uint8_t', 'prefix')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix::Ipv6Prefix(ns3::Ipv6Prefix const & prefix) [constructor]
    cls.add_constructor([param('ns3::Ipv6Prefix const &', 'prefix')])
    ## ipv6-address.h (module 'network'): ns3::Ipv6Prefix::Ipv6Prefix(ns3::Ipv6Prefix const * prefix) [constructor]
    cls.add_constructor([param('ns3::Ipv6Prefix const *', 'prefix')])
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Prefix::GetBytes(uint8_t * buf) const [member function]
    cls.add_method('GetBytes', 
                   'void', 
                   [param('uint8_t *', 'buf')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Prefix ns3::Ipv6Prefix::GetLoopback() [member function]
    cls.add_method('GetLoopback', 
                   'ns3::Ipv6Prefix', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Prefix ns3::Ipv6Prefix::GetOnes() [member function]
    cls.add_method('GetOnes', 
                   'ns3::Ipv6Prefix', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): uint8_t ns3::Ipv6Prefix::GetPrefixLength() const [member function]
    cls.add_method('GetPrefixLength', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): static ns3::Ipv6Prefix ns3::Ipv6Prefix::GetZero() [member function]
    cls.add_method('GetZero', 
                   'ns3::Ipv6Prefix', 
                   [], 
                   is_static=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Prefix::IsEqual(ns3::Ipv6Prefix const & other) const [member function]
    cls.add_method('IsEqual', 
                   'bool', 
                   [param('ns3::Ipv6Prefix const &', 'other')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): bool ns3::Ipv6Prefix::IsMatch(ns3::Ipv6Address a, ns3::Ipv6Address b) const [member function]
    cls.add_method('IsMatch', 
                   'bool', 
                   [param('ns3::Ipv6Address', 'a'), param('ns3::Ipv6Address', 'b')], 
                   is_const=True)
    ## ipv6-address.h (module 'network'): void ns3::Ipv6Prefix::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True)
    return

def register_Ns3LogComponent_methods(root_module, cls):
    ## log.h (module 'core'): ns3::LogComponent::LogComponent(ns3::LogComponent const & arg0) [constructor]
    cls.add_constructor([param('ns3::LogComponent const &', 'arg0')])
    ## log.h (module 'core'): ns3::LogComponent::LogComponent(std::string const & name, std::string const & file, ns3::LogLevel const mask=::ns3::LogLevel::LOG_NONE) [constructor]
    cls.add_constructor([param('std::string const &', 'name'), param('std::string const &', 'file'), param('ns3::LogLevel const', 'mask', default_value='::ns3::LogLevel::LOG_NONE')])
    ## log.h (module 'core'): void ns3::LogComponent::Disable(ns3::LogLevel const level) [member function]
    cls.add_method('Disable', 
                   'void', 
                   [param('ns3::LogLevel const', 'level')])
    ## log.h (module 'core'): void ns3::LogComponent::Enable(ns3::LogLevel const level) [member function]
    cls.add_method('Enable', 
                   'void', 
                   [param('ns3::LogLevel const', 'level')])
    ## log.h (module 'core'): std::string ns3::LogComponent::File() const [member function]
    cls.add_method('File', 
                   'std::string', 
                   [], 
                   is_const=True)
    ## log.h (module 'core'): static ns3::LogComponent::ComponentList * ns3::LogComponent::GetComponentList() [member function]
    cls.add_method('GetComponentList', 
                   'ns3::LogComponent::ComponentList *', 
                   [], 
                   is_static=True)
    ## log.h (module 'core'): static std::string ns3::LogComponent::GetLevelLabel(ns3::LogLevel const level) [member function]
    cls.add_method('GetLevelLabel', 
                   'std::string', 
                   [param('ns3::LogLevel const', 'level')], 
                   is_static=True)
    ## log.h (module 'core'): bool ns3::LogComponent::IsEnabled(ns3::LogLevel const level) const [member function]
    cls.add_method('IsEnabled', 
                   'bool', 
                   [param('ns3::LogLevel const', 'level')], 
                   is_const=True)
    ## log.h (module 'core'): bool ns3::LogComponent::IsNoneEnabled() const [member function]
    cls.add_method('IsNoneEnabled', 
                   'bool', 
                   [], 
                   is_const=True)
    ## log.h (module 'core'): char const * ns3::LogComponent::Name() const [member function]
    cls.add_method('Name', 
                   'char const *', 
                   [], 
                   is_const=True)
    ## log.h (module 'core'): void ns3::LogComponent::SetMask(ns3::LogLevel const level) [member function]
    cls.add_method('SetMask', 
                   'void', 
                   [param('ns3::LogLevel const', 'level')])
    return

def register_Ns3LogicalChannelConfigListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::LogicalChannelConfigListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::LogicalChannelConfigListElement_s(ns3::LogicalChannelConfigListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::LogicalChannelConfigListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_direction [variable]
    cls.add_instance_attribute('m_direction', 'ns3::LogicalChannelConfigListElement_s::Direction_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_eRabGuaranteedBitrateDl [variable]
    cls.add_instance_attribute('m_eRabGuaranteedBitrateDl', 'uint64_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_eRabGuaranteedBitrateUl [variable]
    cls.add_instance_attribute('m_eRabGuaranteedBitrateUl', 'uint64_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_eRabMaximulBitrateDl [variable]
    cls.add_instance_attribute('m_eRabMaximulBitrateDl', 'uint64_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_eRabMaximulBitrateUl [variable]
    cls.add_instance_attribute('m_eRabMaximulBitrateUl', 'uint64_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_logicalChannelGroup [variable]
    cls.add_instance_attribute('m_logicalChannelGroup', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_logicalChannelIdentity [variable]
    cls.add_instance_attribute('m_logicalChannelIdentity', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_qci [variable]
    cls.add_instance_attribute('m_qci', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::LogicalChannelConfigListElement_s::m_qosBearerType [variable]
    cls.add_instance_attribute('m_qosBearerType', 'ns3::LogicalChannelConfigListElement_s::QosBearerType_e', is_const=False)
    return

def register_Ns3LteAnrSapProvider_methods(root_module, cls):
    ## lte-anr-sap.h (module 'lte'): ns3::LteAnrSapProvider::LteAnrSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-anr-sap.h (module 'lte'): ns3::LteAnrSapProvider::LteAnrSapProvider(ns3::LteAnrSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteAnrSapProvider const &', 'arg0')])
    ## lte-anr-sap.h (module 'lte'): void ns3::LteAnrSapProvider::AddNeighbourRelation(uint16_t cellId) [member function]
    cls.add_method('AddNeighbourRelation', 
                   'void', 
                   [param('uint16_t', 'cellId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-anr-sap.h (module 'lte'): bool ns3::LteAnrSapProvider::GetNoHo(uint16_t cellId) const [member function]
    cls.add_method('GetNoHo', 
                   'bool', 
                   [param('uint16_t', 'cellId')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## lte-anr-sap.h (module 'lte'): bool ns3::LteAnrSapProvider::GetNoRemove(uint16_t cellId) const [member function]
    cls.add_method('GetNoRemove', 
                   'bool', 
                   [param('uint16_t', 'cellId')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## lte-anr-sap.h (module 'lte'): bool ns3::LteAnrSapProvider::GetNoX2(uint16_t cellId) const [member function]
    cls.add_method('GetNoX2', 
                   'bool', 
                   [param('uint16_t', 'cellId')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## lte-anr-sap.h (module 'lte'): void ns3::LteAnrSapProvider::ReportUeMeas(ns3::LteRrcSap::MeasResults measResults) [member function]
    cls.add_method('ReportUeMeas', 
                   'void', 
                   [param('ns3::LteRrcSap::MeasResults', 'measResults')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteAnrSapUser_methods(root_module, cls):
    ## lte-anr-sap.h (module 'lte'): ns3::LteAnrSapUser::LteAnrSapUser() [constructor]
    cls.add_constructor([])
    ## lte-anr-sap.h (module 'lte'): ns3::LteAnrSapUser::LteAnrSapUser(ns3::LteAnrSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteAnrSapUser const &', 'arg0')])
    ## lte-anr-sap.h (module 'lte'): uint8_t ns3::LteAnrSapUser::AddUeMeasReportConfigForAnr(ns3::LteRrcSap::ReportConfigEutra reportConfig) [member function]
    cls.add_method('AddUeMeasReportConfigForAnr', 
                   'uint8_t', 
                   [param('ns3::LteRrcSap::ReportConfigEutra', 'reportConfig')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteAsSapProvider_methods(root_module, cls):
    ## lte-as-sap.h (module 'lte'): ns3::LteAsSapProvider::LteAsSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-as-sap.h (module 'lte'): ns3::LteAsSapProvider::LteAsSapProvider(ns3::LteAsSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteAsSapProvider const &', 'arg0')])
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapProvider::Connect() [member function]
    cls.add_method('Connect', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapProvider::Disconnect() [member function]
    cls.add_method('Disconnect', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapProvider::ForceCampedOnEnb(uint16_t cellId, uint32_t dlEarfcn) [member function]
    cls.add_method('ForceCampedOnEnb', 
                   'void', 
                   [param('uint16_t', 'cellId'), param('uint32_t', 'dlEarfcn')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapProvider::SendData(ns3::Ptr<ns3::Packet> packet, uint8_t bid) [member function]
    cls.add_method('SendData', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'packet'), param('uint8_t', 'bid')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapProvider::SetCsgWhiteList(uint32_t csgId) [member function]
    cls.add_method('SetCsgWhiteList', 
                   'void', 
                   [param('uint32_t', 'csgId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapProvider::StartCellSelection(uint32_t dlEarfcn) [member function]
    cls.add_method('StartCellSelection', 
                   'void', 
                   [param('uint32_t', 'dlEarfcn')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteAsSapUser_methods(root_module, cls):
    ## lte-as-sap.h (module 'lte'): ns3::LteAsSapUser::LteAsSapUser() [constructor]
    cls.add_constructor([])
    ## lte-as-sap.h (module 'lte'): ns3::LteAsSapUser::LteAsSapUser(ns3::LteAsSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteAsSapUser const &', 'arg0')])
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapUser::NotifyConnectionFailed() [member function]
    cls.add_method('NotifyConnectionFailed', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapUser::NotifyConnectionReleased() [member function]
    cls.add_method('NotifyConnectionReleased', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapUser::NotifyConnectionSuccessful() [member function]
    cls.add_method('NotifyConnectionSuccessful', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-as-sap.h (module 'lte'): void ns3::LteAsSapUser::RecvData(ns3::Ptr<ns3::Packet> packet) [member function]
    cls.add_method('RecvData', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'packet')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteCcmMacSapProvider_methods(root_module, cls):
    ## lte-ccm-mac-sap.h (module 'lte'): ns3::LteCcmMacSapProvider::LteCcmMacSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ccm-mac-sap.h (module 'lte'): ns3::LteCcmMacSapProvider::LteCcmMacSapProvider(ns3::LteCcmMacSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteCcmMacSapProvider const &', 'arg0')])
    ## lte-ccm-mac-sap.h (module 'lte'): void ns3::LteCcmMacSapProvider::ReportMacCeToScheduler(ns3::MacCeListElement_s bsr) [member function]
    cls.add_method('ReportMacCeToScheduler', 
                   'void', 
                   [param('ns3::MacCeListElement_s', 'bsr')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-mac-sap.h (module 'lte'): void ns3::LteCcmMacSapProvider::ReportSrToScheduler(uint16_t rnti) [member function]
    cls.add_method('ReportSrToScheduler', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteCcmRrcSapProvider_methods(root_module, cls):
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LteCcmRrcSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LteCcmRrcSapProvider(ns3::LteCcmRrcSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteCcmRrcSapProvider const &', 'arg0')])
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapProvider::AddLc(ns3::LteEnbCmacSapProvider::LcInfo lcInfo, ns3::LteMacSapUser * msu) [member function]
    cls.add_method('AddLc', 
                   'void', 
                   [param('ns3::LteEnbCmacSapProvider::LcInfo', 'lcInfo'), param('ns3::LteMacSapUser *', 'msu')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapProvider::AddUe(uint16_t rnti, uint8_t state) [member function]
    cls.add_method('AddUe', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'state')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteMacSapUser * ns3::LteCcmRrcSapProvider::ConfigureSignalBearer(ns3::LteEnbCmacSapProvider::LcInfo lcInfo, ns3::LteMacSapUser * rlcMacSapUser) [member function]
    cls.add_method('ConfigureSignalBearer', 
                   'ns3::LteMacSapUser *', 
                   [param('ns3::LteEnbCmacSapProvider::LcInfo', 'lcInfo'), param('ns3::LteMacSapUser *', 'rlcMacSapUser')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): std::vector<unsigned char, std::allocator<unsigned char> > ns3::LteCcmRrcSapProvider::ReleaseDataRadioBearer(uint16_t rnti, uint8_t lcid) [member function]
    cls.add_method('ReleaseDataRadioBearer', 
                   'std::vector< unsigned char >', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'lcid')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapProvider::RemoveUe(uint16_t rnti) [member function]
    cls.add_method('RemoveUe', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapProvider::ReportUeMeas(uint16_t rnti, ns3::LteRrcSap::MeasResults measResults) [member function]
    cls.add_method('ReportUeMeas', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::MeasResults', 'measResults')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): std::vector<ns3::LteCcmRrcSapProvider::LcsConfig, std::allocator<ns3::LteCcmRrcSapProvider::LcsConfig> > ns3::LteCcmRrcSapProvider::SetupDataRadioBearer(ns3::EpsBearer bearer, uint8_t bearerId, uint16_t rnti, uint8_t lcid, uint8_t lcGroup, ns3::LteMacSapUser * msu) [member function]
    cls.add_method('SetupDataRadioBearer', 
                   'std::vector< ns3::LteCcmRrcSapProvider::LcsConfig >', 
                   [param('ns3::EpsBearer', 'bearer'), param('uint8_t', 'bearerId'), param('uint16_t', 'rnti'), param('uint8_t', 'lcid'), param('uint8_t', 'lcGroup'), param('ns3::LteMacSapUser *', 'msu')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteCcmRrcSapProviderLcsConfig_methods(root_module, cls):
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LcsConfig::LcsConfig() [constructor]
    cls.add_constructor([])
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LcsConfig::LcsConfig(ns3::LteCcmRrcSapProvider::LcsConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteCcmRrcSapProvider::LcsConfig const &', 'arg0')])
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LcsConfig::componentCarrierId [variable]
    cls.add_instance_attribute('componentCarrierId', 'uint16_t', is_const=False)
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LcsConfig::lc [variable]
    cls.add_instance_attribute('lc', 'ns3::LteEnbCmacSapProvider::LcInfo', is_const=False)
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapProvider::LcsConfig::msu [variable]
    cls.add_instance_attribute('msu', 'ns3::LteMacSapUser *', is_const=False)
    return

def register_Ns3LteCcmRrcSapUser_methods(root_module, cls):
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapUser::LteCcmRrcSapUser() [constructor]
    cls.add_constructor([])
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::LteCcmRrcSapUser::LteCcmRrcSapUser(ns3::LteCcmRrcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteCcmRrcSapUser const &', 'arg0')])
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapUser::AddLcs(std::vector<ns3::LteRrcSap::LogicalChannelConfig, std::allocator<ns3::LteRrcSap::LogicalChannelConfig> > lcConfig) [member function]
    cls.add_method('AddLcs', 
                   'void', 
                   [param('std::vector< ns3::LteRrcSap::LogicalChannelConfig >', 'lcConfig')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): uint8_t ns3::LteCcmRrcSapUser::AddUeMeasReportConfigForComponentCarrier(ns3::LteRrcSap::ReportConfigEutra reportConfig) [member function]
    cls.add_method('AddUeMeasReportConfigForComponentCarrier', 
                   'uint8_t', 
                   [param('ns3::LteRrcSap::ReportConfigEutra', 'reportConfig')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): ns3::Ptr<ns3::UeManager> ns3::LteCcmRrcSapUser::GetUeManager(uint16_t rnti) [member function]
    cls.add_method('GetUeManager', 
                   'ns3::Ptr< ns3::UeManager >', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapUser::ReleaseLcs(uint16_t rnti, uint8_t lcid) [member function]
    cls.add_method('ReleaseLcs', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'lcid')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapUser::SetNumberOfComponentCarriers(uint16_t noOfComponentCarriers) [member function]
    cls.add_method('SetNumberOfComponentCarriers', 
                   'void', 
                   [param('uint16_t', 'noOfComponentCarriers')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-rrc-sap.h (module 'lte'): void ns3::LteCcmRrcSapUser::TriggerComponentCarrier(uint16_t rnti, uint16_t targetCellId) [member function]
    cls.add_method('TriggerComponentCarrier', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint16_t', 'targetCellId')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbCmacSapProvider_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LteEnbCmacSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LteEnbCmacSapProvider(ns3::LteEnbCmacSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapProvider const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::AddLc(ns3::LteEnbCmacSapProvider::LcInfo lcinfo, ns3::LteMacSapUser * msu) [member function]
    cls.add_method('AddLc', 
                   'void', 
                   [param('ns3::LteEnbCmacSapProvider::LcInfo', 'lcinfo'), param('ns3::LteMacSapUser *', 'msu')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::AddUe(uint16_t rnti) [member function]
    cls.add_method('AddUe', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue ns3::LteEnbCmacSapProvider::AllocateNcRaPreamble(uint16_t rnti) [member function]
    cls.add_method('AllocateNcRaPreamble', 
                   'ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::ConfigureMac(uint8_t ulBandwidth, uint8_t dlBandwidth) [member function]
    cls.add_method('ConfigureMac', 
                   'void', 
                   [param('uint8_t', 'ulBandwidth'), param('uint8_t', 'dlBandwidth')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig ns3::LteEnbCmacSapProvider::GetRachConfig() [member function]
    cls.add_method('GetRachConfig', 
                   'ns3::LteEnbCmacSapProvider::RachConfig', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::ReconfigureLc(ns3::LteEnbCmacSapProvider::LcInfo lcinfo) [member function]
    cls.add_method('ReconfigureLc', 
                   'void', 
                   [param('ns3::LteEnbCmacSapProvider::LcInfo', 'lcinfo')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::ReleaseLc(uint16_t rnti, uint8_t lcid) [member function]
    cls.add_method('ReleaseLc', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'lcid')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::RemoveUe(uint16_t rnti) [member function]
    cls.add_method('RemoveUe', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapProvider::UeUpdateConfigurationReq(ns3::LteEnbCmacSapProvider::UeConfig params) [member function]
    cls.add_method('UeUpdateConfigurationReq', 
                   'void', 
                   [param('ns3::LteEnbCmacSapProvider::UeConfig', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbCmacSapProviderAllocateNcRaPreambleReturnValue_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue::AllocateNcRaPreambleReturnValue() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue::AllocateNcRaPreambleReturnValue(ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue::raPrachMaskIndex [variable]
    cls.add_instance_attribute('raPrachMaskIndex', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue::raPreambleId [variable]
    cls.add_instance_attribute('raPreambleId', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::AllocateNcRaPreambleReturnValue::valid [variable]
    cls.add_instance_attribute('valid', 'bool', is_const=False)
    return

def register_Ns3LteEnbCmacSapProviderLcInfo_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::LcInfo() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::LcInfo(ns3::LteEnbCmacSapProvider::LcInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapProvider::LcInfo const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::gbrDl [variable]
    cls.add_instance_attribute('gbrDl', 'uint64_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::gbrUl [variable]
    cls.add_instance_attribute('gbrUl', 'uint64_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::isGbr [variable]
    cls.add_instance_attribute('isGbr', 'bool', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::lcGroup [variable]
    cls.add_instance_attribute('lcGroup', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::lcId [variable]
    cls.add_instance_attribute('lcId', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::mbrDl [variable]
    cls.add_instance_attribute('mbrDl', 'uint64_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::mbrUl [variable]
    cls.add_instance_attribute('mbrUl', 'uint64_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::qci [variable]
    cls.add_instance_attribute('qci', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::LcInfo::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteEnbCmacSapProviderRachConfig_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig::RachConfig() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig::RachConfig(ns3::LteEnbCmacSapProvider::RachConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapProvider::RachConfig const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig::connEstFailCount [variable]
    cls.add_instance_attribute('connEstFailCount', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig::numberOfRaPreambles [variable]
    cls.add_instance_attribute('numberOfRaPreambles', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig::preambleTransMax [variable]
    cls.add_instance_attribute('preambleTransMax', 'uint8_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::RachConfig::raResponseWindowSize [variable]
    cls.add_instance_attribute('raResponseWindowSize', 'uint8_t', is_const=False)
    return

def register_Ns3LteEnbCmacSapProviderUeConfig_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::UeConfig::UeConfig() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::UeConfig::UeConfig(ns3::LteEnbCmacSapProvider::UeConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapProvider::UeConfig const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::UeConfig::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapProvider::UeConfig::m_transmissionMode [variable]
    cls.add_instance_attribute('m_transmissionMode', 'uint8_t', is_const=False)
    return

def register_Ns3LteEnbCmacSapUser_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::LteEnbCmacSapUser() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::LteEnbCmacSapUser(ns3::LteEnbCmacSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapUser const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): uint16_t ns3::LteEnbCmacSapUser::AllocateTemporaryCellRnti() [member function]
    cls.add_method('AllocateTemporaryCellRnti', 
                   'uint16_t', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): bool ns3::LteEnbCmacSapUser::IsRandomAccessCompleted(uint16_t rnti) [member function]
    cls.add_method('IsRandomAccessCompleted', 
                   'bool', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapUser::NotifyLcConfigResult(uint16_t rnti, uint8_t lcid, bool success) [member function]
    cls.add_method('NotifyLcConfigResult', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'lcid'), param('bool', 'success')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cmac-sap.h (module 'lte'): void ns3::LteEnbCmacSapUser::RrcConfigurationUpdateInd(ns3::LteEnbCmacSapUser::UeConfig params) [member function]
    cls.add_method('RrcConfigurationUpdateInd', 
                   'void', 
                   [param('ns3::LteEnbCmacSapUser::UeConfig', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbCmacSapUserUeConfig_methods(root_module, cls):
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::UeConfig::UeConfig() [constructor]
    cls.add_constructor([])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::UeConfig::UeConfig(ns3::LteEnbCmacSapUser::UeConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCmacSapUser::UeConfig const &', 'arg0')])
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::UeConfig::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## lte-enb-cmac-sap.h (module 'lte'): ns3::LteEnbCmacSapUser::UeConfig::m_transmissionMode [variable]
    cls.add_instance_attribute('m_transmissionMode', 'uint8_t', is_const=False)
    return

def register_Ns3LteEnbCphySapProvider_methods(root_module, cls):
    ## lte-enb-cphy-sap.h (module 'lte'): ns3::LteEnbCphySapProvider::LteEnbCphySapProvider() [constructor]
    cls.add_constructor([])
    ## lte-enb-cphy-sap.h (module 'lte'): ns3::LteEnbCphySapProvider::LteEnbCphySapProvider(ns3::LteEnbCphySapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCphySapProvider const &', 'arg0')])
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::AddUe(uint16_t rnti) [member function]
    cls.add_method('AddUe', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): int8_t ns3::LteEnbCphySapProvider::GetReferenceSignalPower() [member function]
    cls.add_method('GetReferenceSignalPower', 
                   'int8_t', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::RemoveUe(uint16_t rnti) [member function]
    cls.add_method('RemoveUe', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetBandwidth(uint8_t ulBandwidth, uint8_t dlBandwidth) [member function]
    cls.add_method('SetBandwidth', 
                   'void', 
                   [param('uint8_t', 'ulBandwidth'), param('uint8_t', 'dlBandwidth')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetCellId(uint16_t cellId) [member function]
    cls.add_method('SetCellId', 
                   'void', 
                   [param('uint16_t', 'cellId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetEarfcn(uint32_t ulEarfcn, uint32_t dlEarfcn) [member function]
    cls.add_method('SetEarfcn', 
                   'void', 
                   [param('uint32_t', 'ulEarfcn'), param('uint32_t', 'dlEarfcn')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetMasterInformationBlock(ns3::LteRrcSap::MasterInformationBlock mib) [member function]
    cls.add_method('SetMasterInformationBlock', 
                   'void', 
                   [param('ns3::LteRrcSap::MasterInformationBlock', 'mib')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetPa(uint16_t rnti, double pa) [member function]
    cls.add_method('SetPa', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('double', 'pa')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetSrsConfigurationIndex(uint16_t rnti, uint16_t srsCi) [member function]
    cls.add_method('SetSrsConfigurationIndex', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint16_t', 'srsCi')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetSystemInformationBlockType1(ns3::LteRrcSap::SystemInformationBlockType1 sib1) [member function]
    cls.add_method('SetSystemInformationBlockType1', 
                   'void', 
                   [param('ns3::LteRrcSap::SystemInformationBlockType1', 'sib1')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-cphy-sap.h (module 'lte'): void ns3::LteEnbCphySapProvider::SetTransmissionMode(uint16_t rnti, uint8_t txMode) [member function]
    cls.add_method('SetTransmissionMode', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'txMode')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbCphySapUser_methods(root_module, cls):
    ## lte-enb-cphy-sap.h (module 'lte'): ns3::LteEnbCphySapUser::LteEnbCphySapUser() [constructor]
    cls.add_constructor([])
    ## lte-enb-cphy-sap.h (module 'lte'): ns3::LteEnbCphySapUser::LteEnbCphySapUser(ns3::LteEnbCphySapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbCphySapUser const &', 'arg0')])
    return

def register_Ns3LteEnbPhySapProvider_methods(root_module, cls):
    ## lte-enb-phy-sap.h (module 'lte'): ns3::LteEnbPhySapProvider::LteEnbPhySapProvider() [constructor]
    cls.add_constructor([])
    ## lte-enb-phy-sap.h (module 'lte'): ns3::LteEnbPhySapProvider::LteEnbPhySapProvider(ns3::LteEnbPhySapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbPhySapProvider const &', 'arg0')])
    ## lte-enb-phy-sap.h (module 'lte'): uint8_t ns3::LteEnbPhySapProvider::GetMacChTtiDelay() [member function]
    cls.add_method('GetMacChTtiDelay', 
                   'uint8_t', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapProvider::SendLteControlMessage(ns3::Ptr<ns3::LteControlMessage> msg) [member function]
    cls.add_method('SendLteControlMessage', 
                   'void', 
                   [param('ns3::Ptr< ns3::LteControlMessage >', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapProvider::SendMacPdu(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('SendMacPdu', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbPhySapUser_methods(root_module, cls):
    ## lte-enb-phy-sap.h (module 'lte'): ns3::LteEnbPhySapUser::LteEnbPhySapUser() [constructor]
    cls.add_constructor([])
    ## lte-enb-phy-sap.h (module 'lte'): ns3::LteEnbPhySapUser::LteEnbPhySapUser(ns3::LteEnbPhySapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbPhySapUser const &', 'arg0')])
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::DlInfoListElementHarqFeeback(ns3::DlInfoListElement_s params) [member function]
    cls.add_method('DlInfoListElementHarqFeeback', 
                   'void', 
                   [param('ns3::DlInfoListElement_s', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::ReceiveLteControlMessage(ns3::Ptr<ns3::LteControlMessage> msg) [member function]
    cls.add_method('ReceiveLteControlMessage', 
                   'void', 
                   [param('ns3::Ptr< ns3::LteControlMessage >', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::ReceivePhyPdu(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('ReceivePhyPdu', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::ReceiveRachPreamble(uint32_t prachId) [member function]
    cls.add_method('ReceiveRachPreamble', 
                   'void', 
                   [param('uint32_t', 'prachId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::SubframeIndication(uint32_t frameNo, uint32_t subframeNo) [member function]
    cls.add_method('SubframeIndication', 
                   'void', 
                   [param('uint32_t', 'frameNo'), param('uint32_t', 'subframeNo')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::UlCqiReport(ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters ulcqi) [member function]
    cls.add_method('UlCqiReport', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters', 'ulcqi')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-enb-phy-sap.h (module 'lte'): void ns3::LteEnbPhySapUser::UlInfoListElementHarqFeeback(ns3::UlInfoListElement_s params) [member function]
    cls.add_method('UlInfoListElementHarqFeeback', 
                   'void', 
                   [param('ns3::UlInfoListElement_s', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteFfConverter_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::LteFfConverter::LteFfConverter() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::LteFfConverter::LteFfConverter(ns3::LteFfConverter const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteFfConverter const &', 'arg0')])
    ## lte-common.h (module 'lte'): static uint16_t ns3::LteFfConverter::double2fpS11dot3(double val) [member function]
    cls.add_method('double2fpS11dot3', 
                   'uint16_t', 
                   [param('double', 'val')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::LteFfConverter::fpS11dot3toDouble(uint16_t val) [member function]
    cls.add_method('fpS11dot3toDouble', 
                   'double', 
                   [param('uint16_t', 'val')], 
                   is_static=True)
    ## lte-common.h (module 'lte'): static double ns3::LteFfConverter::getMinFpS11dot3Value() [member function]
    cls.add_method('getMinFpS11dot3Value', 
                   'double', 
                   [], 
                   is_static=True)
    return

def register_Ns3LteFfrRrcSapProvider_methods(root_module, cls):
    ## lte-ffr-rrc-sap.h (module 'lte'): ns3::LteFfrRrcSapProvider::LteFfrRrcSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ffr-rrc-sap.h (module 'lte'): ns3::LteFfrRrcSapProvider::LteFfrRrcSapProvider(ns3::LteFfrRrcSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteFfrRrcSapProvider const &', 'arg0')])
    ## lte-ffr-rrc-sap.h (module 'lte'): void ns3::LteFfrRrcSapProvider::RecvLoadInformation(ns3::EpcX2Sap::LoadInformationParams params) [member function]
    cls.add_method('RecvLoadInformation', 
                   'void', 
                   [param('ns3::EpcX2Sap::LoadInformationParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-rrc-sap.h (module 'lte'): void ns3::LteFfrRrcSapProvider::ReportUeMeas(uint16_t rnti, ns3::LteRrcSap::MeasResults measResults) [member function]
    cls.add_method('ReportUeMeas', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::MeasResults', 'measResults')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-rrc-sap.h (module 'lte'): void ns3::LteFfrRrcSapProvider::SetBandwidth(uint8_t ulBandwidth, uint8_t dlBandwidth) [member function]
    cls.add_method('SetBandwidth', 
                   'void', 
                   [param('uint8_t', 'ulBandwidth'), param('uint8_t', 'dlBandwidth')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-rrc-sap.h (module 'lte'): void ns3::LteFfrRrcSapProvider::SetCellId(uint16_t cellId) [member function]
    cls.add_method('SetCellId', 
                   'void', 
                   [param('uint16_t', 'cellId')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteFfrRrcSapUser_methods(root_module, cls):
    ## lte-ffr-rrc-sap.h (module 'lte'): ns3::LteFfrRrcSapUser::LteFfrRrcSapUser() [constructor]
    cls.add_constructor([])
    ## lte-ffr-rrc-sap.h (module 'lte'): ns3::LteFfrRrcSapUser::LteFfrRrcSapUser(ns3::LteFfrRrcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteFfrRrcSapUser const &', 'arg0')])
    ## lte-ffr-rrc-sap.h (module 'lte'): uint8_t ns3::LteFfrRrcSapUser::AddUeMeasReportConfigForFfr(ns3::LteRrcSap::ReportConfigEutra reportConfig) [member function]
    cls.add_method('AddUeMeasReportConfigForFfr', 
                   'uint8_t', 
                   [param('ns3::LteRrcSap::ReportConfigEutra', 'reportConfig')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-rrc-sap.h (module 'lte'): void ns3::LteFfrRrcSapUser::SendLoadInformation(ns3::EpcX2Sap::LoadInformationParams params) [member function]
    cls.add_method('SendLoadInformation', 
                   'void', 
                   [param('ns3::EpcX2Sap::LoadInformationParams', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-rrc-sap.h (module 'lte'): void ns3::LteFfrRrcSapUser::SetPdschConfigDedicated(uint16_t rnti, ns3::LteRrcSap::PdschConfigDedicated pdschConfigDedicated) [member function]
    cls.add_method('SetPdschConfigDedicated', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::PdschConfigDedicated', 'pdschConfigDedicated')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteFfrSapProvider_methods(root_module, cls):
    ## lte-ffr-sap.h (module 'lte'): ns3::LteFfrSapProvider::LteFfrSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ffr-sap.h (module 'lte'): ns3::LteFfrSapProvider::LteFfrSapProvider(ns3::LteFfrSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteFfrSapProvider const &', 'arg0')])
    ## lte-ffr-sap.h (module 'lte'): std::vector<bool, std::allocator<bool> > ns3::LteFfrSapProvider::GetAvailableDlRbg() [member function]
    cls.add_method('GetAvailableDlRbg', 
                   'std::vector< bool >', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): std::vector<bool, std::allocator<bool> > ns3::LteFfrSapProvider::GetAvailableUlRbg() [member function]
    cls.add_method('GetAvailableUlRbg', 
                   'std::vector< bool >', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): uint8_t ns3::LteFfrSapProvider::GetMinContinuousUlBandwidth() [member function]
    cls.add_method('GetMinContinuousUlBandwidth', 
                   'uint8_t', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): uint8_t ns3::LteFfrSapProvider::GetTpc(uint16_t rnti) [member function]
    cls.add_method('GetTpc', 
                   'uint8_t', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): bool ns3::LteFfrSapProvider::IsDlRbgAvailableForUe(int i, uint16_t rnti) [member function]
    cls.add_method('IsDlRbgAvailableForUe', 
                   'bool', 
                   [param('int', 'i'), param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): bool ns3::LteFfrSapProvider::IsUlRbgAvailableForUe(int i, uint16_t rnti) [member function]
    cls.add_method('IsUlRbgAvailableForUe', 
                   'bool', 
                   [param('int', 'i'), param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): void ns3::LteFfrSapProvider::ReportDlCqiInfo(ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters const & params) [member function]
    cls.add_method('ReportDlCqiInfo', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedDlCqiInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): void ns3::LteFfrSapProvider::ReportUlCqiInfo(ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters const & params) [member function]
    cls.add_method('ReportUlCqiInfo', 
                   'void', 
                   [param('ns3::FfMacSchedSapProvider::SchedUlCqiInfoReqParameters const &', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ffr-sap.h (module 'lte'): void ns3::LteFfrSapProvider::ReportUlCqiInfo(std::map<unsigned short, std::vector<double, std::allocator<double> >, std::less<unsigned short>, std::allocator<std::pair<const unsigned short, std::vector<double, std::allocator<double> > > > > ulCqiMap) [member function]
    cls.add_method('ReportUlCqiInfo', 
                   'void', 
                   [param('std::map< unsigned short, std::vector< double > >', 'ulCqiMap')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteFfrSapUser_methods(root_module, cls):
    ## lte-ffr-sap.h (module 'lte'): ns3::LteFfrSapUser::LteFfrSapUser() [constructor]
    cls.add_constructor([])
    ## lte-ffr-sap.h (module 'lte'): ns3::LteFfrSapUser::LteFfrSapUser(ns3::LteFfrSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteFfrSapUser const &', 'arg0')])
    return

def register_Ns3LteFlowId_t_methods(root_module, cls):
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('==')
    ## lte-common.h (module 'lte'): ns3::LteFlowId_t::LteFlowId_t(ns3::LteFlowId_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteFlowId_t const &', 'arg0')])
    ## lte-common.h (module 'lte'): ns3::LteFlowId_t::LteFlowId_t() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::LteFlowId_t::LteFlowId_t(uint16_t const a, uint8_t const b) [constructor]
    cls.add_constructor([param('uint16_t const', 'a'), param('uint8_t const', 'b')])
    ## lte-common.h (module 'lte'): ns3::LteFlowId_t::m_lcId [variable]
    cls.add_instance_attribute('m_lcId', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::LteFlowId_t::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteGlobalPathlossDatabase_methods(root_module, cls):
    ## lte-global-pathloss-database.h (module 'lte'): ns3::LteGlobalPathlossDatabase::LteGlobalPathlossDatabase() [constructor]
    cls.add_constructor([])
    ## lte-global-pathloss-database.h (module 'lte'): ns3::LteGlobalPathlossDatabase::LteGlobalPathlossDatabase(ns3::LteGlobalPathlossDatabase const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteGlobalPathlossDatabase const &', 'arg0')])
    ## lte-global-pathloss-database.h (module 'lte'): double ns3::LteGlobalPathlossDatabase::GetPathloss(uint16_t cellId, uint64_t imsi) [member function]
    cls.add_method('GetPathloss', 
                   'double', 
                   [param('uint16_t', 'cellId'), param('uint64_t', 'imsi')])
    ## lte-global-pathloss-database.h (module 'lte'): void ns3::LteGlobalPathlossDatabase::Print() [member function]
    cls.add_method('Print', 
                   'void', 
                   [])
    ## lte-global-pathloss-database.h (module 'lte'): void ns3::LteGlobalPathlossDatabase::UpdatePathloss(std::string context, ns3::Ptr<const ns3::SpectrumPhy> txPhy, ns3::Ptr<const ns3::SpectrumPhy> rxPhy, double lossDb) [member function]
    cls.add_method('UpdatePathloss', 
                   'void', 
                   [param('std::string', 'context'), param('ns3::Ptr< ns3::SpectrumPhy const >', 'txPhy'), param('ns3::Ptr< ns3::SpectrumPhy const >', 'rxPhy'), param('double', 'lossDb')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteHandoverManagementSapProvider_methods(root_module, cls):
    ## lte-handover-management-sap.h (module 'lte'): ns3::LteHandoverManagementSapProvider::LteHandoverManagementSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-handover-management-sap.h (module 'lte'): ns3::LteHandoverManagementSapProvider::LteHandoverManagementSapProvider(ns3::LteHandoverManagementSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteHandoverManagementSapProvider const &', 'arg0')])
    ## lte-handover-management-sap.h (module 'lte'): void ns3::LteHandoverManagementSapProvider::ReportUeMeas(uint16_t rnti, ns3::LteRrcSap::MeasResults measResults) [member function]
    cls.add_method('ReportUeMeas', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::MeasResults', 'measResults')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteHandoverManagementSapUser_methods(root_module, cls):
    ## lte-handover-management-sap.h (module 'lte'): ns3::LteHandoverManagementSapUser::LteHandoverManagementSapUser() [constructor]
    cls.add_constructor([])
    ## lte-handover-management-sap.h (module 'lte'): ns3::LteHandoverManagementSapUser::LteHandoverManagementSapUser(ns3::LteHandoverManagementSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteHandoverManagementSapUser const &', 'arg0')])
    ## lte-handover-management-sap.h (module 'lte'): uint8_t ns3::LteHandoverManagementSapUser::AddUeMeasReportConfigForHandover(ns3::LteRrcSap::ReportConfigEutra reportConfig) [member function]
    cls.add_method('AddUeMeasReportConfigForHandover', 
                   'uint8_t', 
                   [param('ns3::LteRrcSap::ReportConfigEutra', 'reportConfig')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-handover-management-sap.h (module 'lte'): void ns3::LteHandoverManagementSapUser::TriggerHandover(uint16_t rnti, uint16_t targetCellId) [member function]
    cls.add_method('TriggerHandover', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint16_t', 'targetCellId')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteMacSapProvider_methods(root_module, cls):
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::LteMacSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::LteMacSapProvider(ns3::LteMacSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMacSapProvider const &', 'arg0')])
    ## lte-mac-sap.h (module 'lte'): void ns3::LteMacSapProvider::ReportBufferStatus(ns3::LteMacSapProvider::ReportBufferStatusParameters params) [member function]
    cls.add_method('ReportBufferStatus', 
                   'void', 
                   [param('ns3::LteMacSapProvider::ReportBufferStatusParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-mac-sap.h (module 'lte'): void ns3::LteMacSapProvider::TransmitPdu(ns3::LteMacSapProvider::TransmitPduParameters params) [member function]
    cls.add_method('TransmitPdu', 
                   'void', 
                   [param('ns3::LteMacSapProvider::TransmitPduParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteMacSapProviderReportBufferStatusParameters_methods(root_module, cls):
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::ReportBufferStatusParameters() [constructor]
    cls.add_constructor([])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::ReportBufferStatusParameters(ns3::LteMacSapProvider::ReportBufferStatusParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMacSapProvider::ReportBufferStatusParameters const &', 'arg0')])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::retxQueueHolDelay [variable]
    cls.add_instance_attribute('retxQueueHolDelay', 'uint16_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::retxQueueSize [variable]
    cls.add_instance_attribute('retxQueueSize', 'uint32_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::statusPduSize [variable]
    cls.add_instance_attribute('statusPduSize', 'uint16_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::txQueueHolDelay [variable]
    cls.add_instance_attribute('txQueueHolDelay', 'uint16_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::ReportBufferStatusParameters::txQueueSize [variable]
    cls.add_instance_attribute('txQueueSize', 'uint32_t', is_const=False)
    return

def register_Ns3LteMacSapProviderTransmitPduParameters_methods(root_module, cls):
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::TransmitPduParameters() [constructor]
    cls.add_constructor([])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::TransmitPduParameters(ns3::LteMacSapProvider::TransmitPduParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMacSapProvider::TransmitPduParameters const &', 'arg0')])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::componentCarrierId [variable]
    cls.add_instance_attribute('componentCarrierId', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::harqProcessId [variable]
    cls.add_instance_attribute('harqProcessId', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::layer [variable]
    cls.add_instance_attribute('layer', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::pdu [variable]
    cls.add_instance_attribute('pdu', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapProvider::TransmitPduParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteMacSapUser_methods(root_module, cls):
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::LteMacSapUser() [constructor]
    cls.add_constructor([])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::LteMacSapUser(ns3::LteMacSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMacSapUser const &', 'arg0')])
    ## lte-mac-sap.h (module 'lte'): void ns3::LteMacSapUser::NotifyHarqDeliveryFailure() [member function]
    cls.add_method('NotifyHarqDeliveryFailure', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-mac-sap.h (module 'lte'): void ns3::LteMacSapUser::NotifyTxOpportunity(ns3::LteMacSapUser::TxOpportunityParameters params) [member function]
    cls.add_method('NotifyTxOpportunity', 
                   'void', 
                   [param('ns3::LteMacSapUser::TxOpportunityParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-mac-sap.h (module 'lte'): void ns3::LteMacSapUser::ReceivePdu(ns3::LteMacSapUser::ReceivePduParameters params) [member function]
    cls.add_method('ReceivePdu', 
                   'void', 
                   [param('ns3::LteMacSapUser::ReceivePduParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteMacSapUserReceivePduParameters_methods(root_module, cls):
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters::ReceivePduParameters(ns3::LteMacSapUser::ReceivePduParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMacSapUser::ReceivePduParameters const &', 'arg0')])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters::ReceivePduParameters() [constructor]
    cls.add_constructor([])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters::ReceivePduParameters(ns3::Ptr<ns3::Packet> const & p, uint16_t rnti, uint8_t lcid) [constructor]
    cls.add_constructor([param('ns3::Ptr< ns3::Packet > const &', 'p'), param('uint16_t', 'rnti'), param('uint8_t', 'lcid')])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters::p [variable]
    cls.add_instance_attribute('p', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::ReceivePduParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteMacSapUserTxOpportunityParameters_methods(root_module, cls):
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::TxOpportunityParameters(ns3::LteMacSapUser::TxOpportunityParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMacSapUser::TxOpportunityParameters const &', 'arg0')])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::TxOpportunityParameters(uint32_t bytes, uint8_t layer, uint8_t harqId, uint8_t ccId, uint16_t rnti, uint8_t lcId) [constructor]
    cls.add_constructor([param('uint32_t', 'bytes'), param('uint8_t', 'layer'), param('uint8_t', 'harqId'), param('uint8_t', 'ccId'), param('uint16_t', 'rnti'), param('uint8_t', 'lcId')])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::TxOpportunityParameters() [constructor]
    cls.add_constructor([])
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::bytes [variable]
    cls.add_instance_attribute('bytes', 'uint32_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::componentCarrierId [variable]
    cls.add_instance_attribute('componentCarrierId', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::harqId [variable]
    cls.add_instance_attribute('harqId', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::layer [variable]
    cls.add_instance_attribute('layer', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-mac-sap.h (module 'lte'): ns3::LteMacSapUser::TxOpportunityParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteMiErrorModel_methods(root_module, cls):
    ## lte-mi-error-model.h (module 'lte'): ns3::LteMiErrorModel::LteMiErrorModel() [constructor]
    cls.add_constructor([])
    ## lte-mi-error-model.h (module 'lte'): ns3::LteMiErrorModel::LteMiErrorModel(ns3::LteMiErrorModel const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteMiErrorModel const &', 'arg0')])
    ## lte-mi-error-model.h (module 'lte'): static double ns3::LteMiErrorModel::GetPcfichPdcchError(ns3::SpectrumValue const & sinr) [member function]
    cls.add_method('GetPcfichPdcchError', 
                   'double', 
                   [param('ns3::SpectrumValue const &', 'sinr')], 
                   is_static=True)
    ## lte-mi-error-model.h (module 'lte'): static ns3::TbStats_t ns3::LteMiErrorModel::GetTbDecodificationStats(ns3::SpectrumValue const & sinr, std::vector<int, std::allocator<int> > const & map, uint16_t size, uint8_t mcs, ns3::HarqProcessInfoList_t miHistory) [member function]
    cls.add_method('GetTbDecodificationStats', 
                   'ns3::TbStats_t', 
                   [param('ns3::SpectrumValue const &', 'sinr'), param('std::vector< int > const &', 'map'), param('uint16_t', 'size'), param('uint8_t', 'mcs'), param('std::vector< ns3::HarqProcessInfoElement_t >', 'miHistory')], 
                   is_static=True)
    ## lte-mi-error-model.h (module 'lte'): static double ns3::LteMiErrorModel::MappingMiBler(double mib, uint8_t ecrId, uint16_t cbSize) [member function]
    cls.add_method('MappingMiBler', 
                   'double', 
                   [param('double', 'mib'), param('uint8_t', 'ecrId'), param('uint16_t', 'cbSize')], 
                   is_static=True)
    ## lte-mi-error-model.h (module 'lte'): static double ns3::LteMiErrorModel::Mib(ns3::SpectrumValue const & sinr, std::vector<int, std::allocator<int> > const & map, uint8_t mcs) [member function]
    cls.add_method('Mib', 
                   'double', 
                   [param('ns3::SpectrumValue const &', 'sinr'), param('std::vector< int > const &', 'map'), param('uint8_t', 'mcs')], 
                   is_static=True)
    return

def register_Ns3LtePdcpSapProvider_methods(root_module, cls):
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::LtePdcpSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::LtePdcpSapProvider(ns3::LtePdcpSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LtePdcpSapProvider const &', 'arg0')])
    ## lte-pdcp-sap.h (module 'lte'): void ns3::LtePdcpSapProvider::TransmitPdcpSdu(ns3::LtePdcpSapProvider::TransmitPdcpSduParameters params) [member function]
    cls.add_method('TransmitPdcpSdu', 
                   'void', 
                   [param('ns3::LtePdcpSapProvider::TransmitPdcpSduParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LtePdcpSapProviderTransmitPdcpSduParameters_methods(root_module, cls):
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::TransmitPdcpSduParameters::TransmitPdcpSduParameters() [constructor]
    cls.add_constructor([])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::TransmitPdcpSduParameters::TransmitPdcpSduParameters(ns3::LtePdcpSapProvider::TransmitPdcpSduParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LtePdcpSapProvider::TransmitPdcpSduParameters const &', 'arg0')])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::TransmitPdcpSduParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::TransmitPdcpSduParameters::pdcpSdu [variable]
    cls.add_instance_attribute('pdcpSdu', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapProvider::TransmitPdcpSduParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LtePdcpSapUser_methods(root_module, cls):
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::LtePdcpSapUser() [constructor]
    cls.add_constructor([])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::LtePdcpSapUser(ns3::LtePdcpSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LtePdcpSapUser const &', 'arg0')])
    ## lte-pdcp-sap.h (module 'lte'): void ns3::LtePdcpSapUser::ReceivePdcpSdu(ns3::LtePdcpSapUser::ReceivePdcpSduParameters params) [member function]
    cls.add_method('ReceivePdcpSdu', 
                   'void', 
                   [param('ns3::LtePdcpSapUser::ReceivePdcpSduParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LtePdcpSapUserReceivePdcpSduParameters_methods(root_module, cls):
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::ReceivePdcpSduParameters::ReceivePdcpSduParameters() [constructor]
    cls.add_constructor([])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::ReceivePdcpSduParameters::ReceivePdcpSduParameters(ns3::LtePdcpSapUser::ReceivePdcpSduParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LtePdcpSapUser::ReceivePdcpSduParameters const &', 'arg0')])
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::ReceivePdcpSduParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::ReceivePdcpSduParameters::pdcpSdu [variable]
    cls.add_instance_attribute('pdcpSdu', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## lte-pdcp-sap.h (module 'lte'): ns3::LtePdcpSapUser::ReceivePdcpSduParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteRlcSapProvider_methods(root_module, cls):
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::LteRlcSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::LteRlcSapProvider(ns3::LteRlcSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRlcSapProvider const &', 'arg0')])
    ## lte-rlc-sap.h (module 'lte'): void ns3::LteRlcSapProvider::TransmitPdcpPdu(ns3::LteRlcSapProvider::TransmitPdcpPduParameters params) [member function]
    cls.add_method('TransmitPdcpPdu', 
                   'void', 
                   [param('ns3::LteRlcSapProvider::TransmitPdcpPduParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteRlcSapProviderTransmitPdcpPduParameters_methods(root_module, cls):
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::TransmitPdcpPduParameters::TransmitPdcpPduParameters() [constructor]
    cls.add_constructor([])
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::TransmitPdcpPduParameters::TransmitPdcpPduParameters(ns3::LteRlcSapProvider::TransmitPdcpPduParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRlcSapProvider::TransmitPdcpPduParameters const &', 'arg0')])
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::TransmitPdcpPduParameters::lcid [variable]
    cls.add_instance_attribute('lcid', 'uint8_t', is_const=False)
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::TransmitPdcpPduParameters::pdcpPdu [variable]
    cls.add_instance_attribute('pdcpPdu', 'ns3::Ptr< ns3::Packet >', is_const=False)
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapProvider::TransmitPdcpPduParameters::rnti [variable]
    cls.add_instance_attribute('rnti', 'uint16_t', is_const=False)
    return

def register_Ns3LteRlcSapUser_methods(root_module, cls):
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapUser::LteRlcSapUser() [constructor]
    cls.add_constructor([])
    ## lte-rlc-sap.h (module 'lte'): ns3::LteRlcSapUser::LteRlcSapUser(ns3::LteRlcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRlcSapUser const &', 'arg0')])
    ## lte-rlc-sap.h (module 'lte'): void ns3::LteRlcSapUser::ReceivePdcpPdu(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('ReceivePdcpPdu', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteRrcSap_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LteRrcSap() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LteRrcSap(ns3::LteRrcSap const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): static double ns3::LteRrcSap::ConvertPdschConfigDedicated2Double(ns3::LteRrcSap::PdschConfigDedicated pdschConfigDedicated) [member function]
    cls.add_method('ConvertPdschConfigDedicated2Double', 
                   'double', 
                   [param('ns3::LteRrcSap::PdschConfigDedicated', 'pdschConfigDedicated')], 
                   is_static=True)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MaxReportCells [variable]
    cls.add_static_attribute('MaxReportCells', 'uint8_t const', is_const=True)
    return

def register_Ns3LteRrcSapAntennaInfoCommon_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoCommon::AntennaInfoCommon() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoCommon::AntennaInfoCommon(ns3::LteRrcSap::AntennaInfoCommon const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::AntennaInfoCommon const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoCommon::antennaPortsCount [variable]
    cls.add_instance_attribute('antennaPortsCount', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapAntennaInfoDedicated_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoDedicated::AntennaInfoDedicated() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoDedicated::AntennaInfoDedicated(ns3::LteRrcSap::AntennaInfoDedicated const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::AntennaInfoDedicated const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoDedicated::transmissionMode [variable]
    cls.add_instance_attribute('transmissionMode', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapAntennaInfoUl_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoUl::AntennaInfoUl() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoUl::AntennaInfoUl(ns3::LteRrcSap::AntennaInfoUl const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::AntennaInfoUl const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AntennaInfoUl::transmissionMode [variable]
    cls.add_instance_attribute('transmissionMode', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapAsConfig_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::AsConfig() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::AsConfig(ns3::LteRrcSap::AsConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::AsConfig const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceDlCarrierFreq [variable]
    cls.add_instance_attribute('sourceDlCarrierFreq', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceMasterInformationBlock [variable]
    cls.add_instance_attribute('sourceMasterInformationBlock', 'ns3::LteRrcSap::MasterInformationBlock', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceMeasConfig [variable]
    cls.add_instance_attribute('sourceMeasConfig', 'ns3::LteRrcSap::MeasConfig', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceRadioResourceConfig [variable]
    cls.add_instance_attribute('sourceRadioResourceConfig', 'ns3::LteRrcSap::RadioResourceConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceSystemInformationBlockType1 [variable]
    cls.add_instance_attribute('sourceSystemInformationBlockType1', 'ns3::LteRrcSap::SystemInformationBlockType1', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceSystemInformationBlockType2 [variable]
    cls.add_instance_attribute('sourceSystemInformationBlockType2', 'ns3::LteRrcSap::SystemInformationBlockType2', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::AsConfig::sourceUeIdentity [variable]
    cls.add_instance_attribute('sourceUeIdentity', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapBlackCellsToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::BlackCellsToAddMod::BlackCellsToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::BlackCellsToAddMod::BlackCellsToAddMod(ns3::LteRrcSap::BlackCellsToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::BlackCellsToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::BlackCellsToAddMod::cellIndex [variable]
    cls.add_instance_attribute('cellIndex', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::BlackCellsToAddMod::physCellIdRange [variable]
    cls.add_instance_attribute('physCellIdRange', 'ns3::LteRrcSap::PhysCellIdRange', is_const=False)
    return

def register_Ns3LteRrcSapCarrierBandwidthEutra_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierBandwidthEutra::CarrierBandwidthEutra() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierBandwidthEutra::CarrierBandwidthEutra(ns3::LteRrcSap::CarrierBandwidthEutra const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CarrierBandwidthEutra const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierBandwidthEutra::dlBandwidth [variable]
    cls.add_instance_attribute('dlBandwidth', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierBandwidthEutra::ulBandwidth [variable]
    cls.add_instance_attribute('ulBandwidth', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapCarrierFreqEutra_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierFreqEutra::CarrierFreqEutra() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierFreqEutra::CarrierFreqEutra(ns3::LteRrcSap::CarrierFreqEutra const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CarrierFreqEutra const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierFreqEutra::dlCarrierFreq [variable]
    cls.add_instance_attribute('dlCarrierFreq', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CarrierFreqEutra::ulCarrierFreq [variable]
    cls.add_instance_attribute('ulCarrierFreq', 'uint32_t', is_const=False)
    return

def register_Ns3LteRrcSapCellAccessRelatedInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo::CellAccessRelatedInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo::CellAccessRelatedInfo(ns3::LteRrcSap::CellAccessRelatedInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CellAccessRelatedInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo::cellIdentity [variable]
    cls.add_instance_attribute('cellIdentity', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo::csgIdentity [variable]
    cls.add_instance_attribute('csgIdentity', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo::csgIndication [variable]
    cls.add_instance_attribute('csgIndication', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellAccessRelatedInfo::plmnIdentityInfo [variable]
    cls.add_instance_attribute('plmnIdentityInfo', 'ns3::LteRrcSap::PlmnIdentityInfo', is_const=False)
    return

def register_Ns3LteRrcSapCellIdentification_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellIdentification::CellIdentification() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellIdentification::CellIdentification(ns3::LteRrcSap::CellIdentification const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CellIdentification const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellIdentification::dlCarrierFreq [variable]
    cls.add_instance_attribute('dlCarrierFreq', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellIdentification::physCellId [variable]
    cls.add_instance_attribute('physCellId', 'uint32_t', is_const=False)
    return

def register_Ns3LteRrcSapCellSelectionInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellSelectionInfo::CellSelectionInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellSelectionInfo::CellSelectionInfo(ns3::LteRrcSap::CellSelectionInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CellSelectionInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellSelectionInfo::qQualMin [variable]
    cls.add_instance_attribute('qQualMin', 'int8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellSelectionInfo::qRxLevMin [variable]
    cls.add_instance_attribute('qRxLevMin', 'int8_t', is_const=False)
    return

def register_Ns3LteRrcSapCellsToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellsToAddMod::CellsToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellsToAddMod::CellsToAddMod(ns3::LteRrcSap::CellsToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CellsToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellsToAddMod::cellIndex [variable]
    cls.add_instance_attribute('cellIndex', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellsToAddMod::cellIndividualOffset [variable]
    cls.add_instance_attribute('cellIndividualOffset', 'int8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CellsToAddMod::physCellId [variable]
    cls.add_instance_attribute('physCellId', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapCgiInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo::CgiInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo::CgiInfo(ns3::LteRrcSap::CgiInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::CgiInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo::cellIdentity [variable]
    cls.add_instance_attribute('cellIdentity', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo::plmnIdentity [variable]
    cls.add_instance_attribute('plmnIdentity', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo::plmnIdentityList [variable]
    cls.add_instance_attribute('plmnIdentityList', 'std::list< unsigned int >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::CgiInfo::trackingAreaCode [variable]
    cls.add_instance_attribute('trackingAreaCode', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapDrbToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::DrbToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::DrbToAddMod(ns3::LteRrcSap::DrbToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::DrbToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::drbIdentity [variable]
    cls.add_instance_attribute('drbIdentity', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::epsBearerIdentity [variable]
    cls.add_instance_attribute('epsBearerIdentity', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::logicalChannelConfig [variable]
    cls.add_instance_attribute('logicalChannelConfig', 'ns3::LteRrcSap::LogicalChannelConfig', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::logicalChannelIdentity [variable]
    cls.add_instance_attribute('logicalChannelIdentity', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::DrbToAddMod::rlcConfig [variable]
    cls.add_instance_attribute('rlcConfig', 'ns3::LteRrcSap::RlcConfig', is_const=False)
    return

def register_Ns3LteRrcSapFreqInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::FreqInfo::FreqInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::FreqInfo::FreqInfo(ns3::LteRrcSap::FreqInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::FreqInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::FreqInfo::ulBandwidth [variable]
    cls.add_instance_attribute('ulBandwidth', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::FreqInfo::ulCarrierFreq [variable]
    cls.add_instance_attribute('ulCarrierFreq', 'uint32_t', is_const=False)
    return

def register_Ns3LteRrcSapHandoverPreparationInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::HandoverPreparationInfo::HandoverPreparationInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::HandoverPreparationInfo::HandoverPreparationInfo(ns3::LteRrcSap::HandoverPreparationInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::HandoverPreparationInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::HandoverPreparationInfo::asConfig [variable]
    cls.add_instance_attribute('asConfig', 'ns3::LteRrcSap::AsConfig', is_const=False)
    return

def register_Ns3LteRrcSapLogicalChannelConfig_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig::LogicalChannelConfig() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig::LogicalChannelConfig(ns3::LteRrcSap::LogicalChannelConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::LogicalChannelConfig const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig::bucketSizeDurationMs [variable]
    cls.add_instance_attribute('bucketSizeDurationMs', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig::logicalChannelGroup [variable]
    cls.add_instance_attribute('logicalChannelGroup', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig::prioritizedBitRateKbps [variable]
    cls.add_instance_attribute('prioritizedBitRateKbps', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::LogicalChannelConfig::priority [variable]
    cls.add_instance_attribute('priority', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapMasterInformationBlock_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MasterInformationBlock::MasterInformationBlock() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MasterInformationBlock::MasterInformationBlock(ns3::LteRrcSap::MasterInformationBlock const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MasterInformationBlock const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MasterInformationBlock::dlBandwidth [variable]
    cls.add_instance_attribute('dlBandwidth', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MasterInformationBlock::systemFrameNumber [variable]
    cls.add_instance_attribute('systemFrameNumber', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasConfig_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::MeasConfig() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::MeasConfig(ns3::LteRrcSap::MeasConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasConfig const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::haveMeasGapConfig [variable]
    cls.add_instance_attribute('haveMeasGapConfig', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::haveQuantityConfig [variable]
    cls.add_instance_attribute('haveQuantityConfig', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::haveSmeasure [variable]
    cls.add_instance_attribute('haveSmeasure', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::haveSpeedStatePars [variable]
    cls.add_instance_attribute('haveSpeedStatePars', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::measGapConfig [variable]
    cls.add_instance_attribute('measGapConfig', 'ns3::LteRrcSap::MeasGapConfig', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::measIdToAddModList [variable]
    cls.add_instance_attribute('measIdToAddModList', 'std::list< ns3::LteRrcSap::MeasIdToAddMod >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::measIdToRemoveList [variable]
    cls.add_instance_attribute('measIdToRemoveList', 'std::list< unsigned char >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::measObjectToAddModList [variable]
    cls.add_instance_attribute('measObjectToAddModList', 'std::list< ns3::LteRrcSap::MeasObjectToAddMod >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::measObjectToRemoveList [variable]
    cls.add_instance_attribute('measObjectToRemoveList', 'std::list< unsigned char >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::quantityConfig [variable]
    cls.add_instance_attribute('quantityConfig', 'ns3::LteRrcSap::QuantityConfig', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::reportConfigToAddModList [variable]
    cls.add_instance_attribute('reportConfigToAddModList', 'std::list< ns3::LteRrcSap::ReportConfigToAddMod >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::reportConfigToRemoveList [variable]
    cls.add_instance_attribute('reportConfigToRemoveList', 'std::list< unsigned char >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::sMeasure [variable]
    cls.add_instance_attribute('sMeasure', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasConfig::speedStatePars [variable]
    cls.add_instance_attribute('speedStatePars', 'ns3::LteRrcSap::SpeedStatePars', is_const=False)
    return

def register_Ns3LteRrcSapMeasGapConfig_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::MeasGapConfig() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::MeasGapConfig(ns3::LteRrcSap::MeasGapConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasGapConfig const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::gapOffsetChoice [variable]
    cls.add_instance_attribute('gapOffsetChoice', 'ns3::LteRrcSap::MeasGapConfig::gap', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::gapOffsetValue [variable]
    cls.add_instance_attribute('gapOffsetValue', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasGapConfig::type [variable]
    cls.add_instance_attribute('type', 'ns3::LteRrcSap::MeasGapConfig::action', is_const=False)
    return

def register_Ns3LteRrcSapMeasIdToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasIdToAddMod::MeasIdToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasIdToAddMod::MeasIdToAddMod(ns3::LteRrcSap::MeasIdToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasIdToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasIdToAddMod::measId [variable]
    cls.add_instance_attribute('measId', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasIdToAddMod::measObjectId [variable]
    cls.add_instance_attribute('measObjectId', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasIdToAddMod::reportConfigId [variable]
    cls.add_instance_attribute('reportConfigId', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasObjectEutra_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::MeasObjectEutra() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::MeasObjectEutra(ns3::LteRrcSap::MeasObjectEutra const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasObjectEutra const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::allowedMeasBandwidth [variable]
    cls.add_instance_attribute('allowedMeasBandwidth', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::blackCellsToAddModList [variable]
    cls.add_instance_attribute('blackCellsToAddModList', 'std::list< ns3::LteRrcSap::BlackCellsToAddMod >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::blackCellsToRemoveList [variable]
    cls.add_instance_attribute('blackCellsToRemoveList', 'std::list< unsigned char >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::carrierFreq [variable]
    cls.add_instance_attribute('carrierFreq', 'uint32_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::cellForWhichToReportCGI [variable]
    cls.add_instance_attribute('cellForWhichToReportCGI', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::cellsToAddModList [variable]
    cls.add_instance_attribute('cellsToAddModList', 'std::list< ns3::LteRrcSap::CellsToAddMod >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::cellsToRemoveList [variable]
    cls.add_instance_attribute('cellsToRemoveList', 'std::list< unsigned char >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::haveCellForWhichToReportCGI [variable]
    cls.add_instance_attribute('haveCellForWhichToReportCGI', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::neighCellConfig [variable]
    cls.add_instance_attribute('neighCellConfig', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::offsetFreq [variable]
    cls.add_instance_attribute('offsetFreq', 'int8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectEutra::presenceAntennaPort1 [variable]
    cls.add_instance_attribute('presenceAntennaPort1', 'bool', is_const=False)
    return

def register_Ns3LteRrcSapMeasObjectToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectToAddMod::MeasObjectToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectToAddMod::MeasObjectToAddMod(ns3::LteRrcSap::MeasObjectToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasObjectToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectToAddMod::measObjectEutra [variable]
    cls.add_instance_attribute('measObjectEutra', 'ns3::LteRrcSap::MeasObjectEutra', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasObjectToAddMod::measObjectId [variable]
    cls.add_instance_attribute('measObjectId', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasResultBestNeighCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::MeasResultBestNeighCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::MeasResultBestNeighCell(ns3::LteRrcSap::MeasResultBestNeighCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasResultBestNeighCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::haveRsrpResult [variable]
    cls.add_instance_attribute('haveRsrpResult', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::haveRsrqResult [variable]
    cls.add_instance_attribute('haveRsrqResult', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::physCellId [variable]
    cls.add_instance_attribute('physCellId', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::rsrpResult [variable]
    cls.add_instance_attribute('rsrpResult', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::rsrqResult [variable]
    cls.add_instance_attribute('rsrqResult', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultBestNeighCell::servFreqId [variable]
    cls.add_instance_attribute('servFreqId', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasResultEutra_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::MeasResultEutra() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::MeasResultEutra(ns3::LteRrcSap::MeasResultEutra const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasResultEutra const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::cgiInfo [variable]
    cls.add_instance_attribute('cgiInfo', 'ns3::LteRrcSap::CgiInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::haveCgiInfo [variable]
    cls.add_instance_attribute('haveCgiInfo', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::haveRsrpResult [variable]
    cls.add_instance_attribute('haveRsrpResult', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::haveRsrqResult [variable]
    cls.add_instance_attribute('haveRsrqResult', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::physCellId [variable]
    cls.add_instance_attribute('physCellId', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::rsrpResult [variable]
    cls.add_instance_attribute('rsrpResult', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultEutra::rsrqResult [variable]
    cls.add_instance_attribute('rsrqResult', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasResultScell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::MeasResultScell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::MeasResultScell(ns3::LteRrcSap::MeasResultScell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasResultScell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::haveRsrpResult [variable]
    cls.add_instance_attribute('haveRsrpResult', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::haveRsrqResult [variable]
    cls.add_instance_attribute('haveRsrqResult', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::rsrpResult [variable]
    cls.add_instance_attribute('rsrpResult', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::rsrqResult [variable]
    cls.add_instance_attribute('rsrqResult', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultScell::servFreqId [variable]
    cls.add_instance_attribute('servFreqId', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasResultServFreqList_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList::MeasResultServFreqList() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList::MeasResultServFreqList(ns3::LteRrcSap::MeasResultServFreqList const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasResultServFreqList const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList::haveMeasurementResultsNeighCell [variable]
    cls.add_instance_attribute('haveMeasurementResultsNeighCell', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList::haveMeasurementResultsServingSCells [variable]
    cls.add_instance_attribute('haveMeasurementResultsServingSCells', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList::measResultBestNeighCell [variable]
    cls.add_instance_attribute('measResultBestNeighCell', 'std::list< ns3::LteRrcSap::MeasResultBestNeighCell >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResultServFreqList::measResultScell [variable]
    cls.add_instance_attribute('measResultScell', 'std::list< ns3::LteRrcSap::MeasResultScell >', is_const=False)
    return

def register_Ns3LteRrcSapMeasResults_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::MeasResults() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::MeasResults(ns3::LteRrcSap::MeasResults const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasResults const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::haveMeasResultNeighCells [variable]
    cls.add_instance_attribute('haveMeasResultNeighCells', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::haveScellsMeas [variable]
    cls.add_instance_attribute('haveScellsMeas', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::measId [variable]
    cls.add_instance_attribute('measId', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::measResultListEutra [variable]
    cls.add_instance_attribute('measResultListEutra', 'std::list< ns3::LteRrcSap::MeasResultEutra >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::measScellResultList [variable]
    cls.add_instance_attribute('measScellResultList', 'ns3::LteRrcSap::MeasResultServFreqList', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::rsrpResult [variable]
    cls.add_instance_attribute('rsrpResult', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasResults::rsrqResult [variable]
    cls.add_instance_attribute('rsrqResult', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapMeasurementReport_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasurementReport::MeasurementReport() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasurementReport::MeasurementReport(ns3::LteRrcSap::MeasurementReport const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MeasurementReport const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MeasurementReport::measResults [variable]
    cls.add_instance_attribute('measResults', 'ns3::LteRrcSap::MeasResults', is_const=False)
    return

def register_Ns3LteRrcSapMobilityControlInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::MobilityControlInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::MobilityControlInfo(ns3::LteRrcSap::MobilityControlInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MobilityControlInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::carrierBandwidth [variable]
    cls.add_instance_attribute('carrierBandwidth', 'ns3::LteRrcSap::CarrierBandwidthEutra', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::carrierFreq [variable]
    cls.add_instance_attribute('carrierFreq', 'ns3::LteRrcSap::CarrierFreqEutra', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::haveCarrierBandwidth [variable]
    cls.add_instance_attribute('haveCarrierBandwidth', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::haveCarrierFreq [variable]
    cls.add_instance_attribute('haveCarrierFreq', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::haveRachConfigDedicated [variable]
    cls.add_instance_attribute('haveRachConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::newUeIdentity [variable]
    cls.add_instance_attribute('newUeIdentity', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::rachConfigDedicated [variable]
    cls.add_instance_attribute('rachConfigDedicated', 'ns3::LteRrcSap::RachConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::radioResourceConfigCommon [variable]
    cls.add_instance_attribute('radioResourceConfigCommon', 'ns3::LteRrcSap::RadioResourceConfigCommon', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityControlInfo::targetPhysCellId [variable]
    cls.add_instance_attribute('targetPhysCellId', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapMobilityStateParameters_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters::MobilityStateParameters() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters::MobilityStateParameters(ns3::LteRrcSap::MobilityStateParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::MobilityStateParameters const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters::nCellChangeHigh [variable]
    cls.add_instance_attribute('nCellChangeHigh', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters::nCellChangeMedium [variable]
    cls.add_instance_attribute('nCellChangeMedium', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters::tEvaluation [variable]
    cls.add_instance_attribute('tEvaluation', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::MobilityStateParameters::tHystNormal [variable]
    cls.add_instance_attribute('tHystNormal', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapNonCriticalExtensionConfiguration_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonCriticalExtensionConfiguration::NonCriticalExtensionConfiguration() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonCriticalExtensionConfiguration::NonCriticalExtensionConfiguration(ns3::LteRrcSap::NonCriticalExtensionConfiguration const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::NonCriticalExtensionConfiguration const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonCriticalExtensionConfiguration::sCellToReleaseList [variable]
    cls.add_instance_attribute('sCellToReleaseList', 'std::list< unsigned int >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonCriticalExtensionConfiguration::sCellsToAddModList [variable]
    cls.add_instance_attribute('sCellsToAddModList', 'std::list< ns3::LteRrcSap::SCellToAddMod >', is_const=False)
    return

def register_Ns3LteRrcSapNonUlConfiguration_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonUlConfiguration::NonUlConfiguration() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonUlConfiguration::NonUlConfiguration(ns3::LteRrcSap::NonUlConfiguration const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::NonUlConfiguration const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonUlConfiguration::antennaInfoCommon [variable]
    cls.add_instance_attribute('antennaInfoCommon', 'ns3::LteRrcSap::AntennaInfoCommon', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonUlConfiguration::dlBandwidth [variable]
    cls.add_instance_attribute('dlBandwidth', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::NonUlConfiguration::pdschConfigCommon [variable]
    cls.add_instance_attribute('pdschConfigCommon', 'ns3::LteRrcSap::PdschConfigCommon', is_const=False)
    return

def register_Ns3LteRrcSapPdschConfigCommon_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigCommon::PdschConfigCommon() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigCommon::PdschConfigCommon(ns3::LteRrcSap::PdschConfigCommon const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PdschConfigCommon const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigCommon::pb [variable]
    cls.add_instance_attribute('pb', 'int8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigCommon::referenceSignalPower [variable]
    cls.add_instance_attribute('referenceSignalPower', 'int8_t', is_const=False)
    return

def register_Ns3LteRrcSapPdschConfigDedicated_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigDedicated::PdschConfigDedicated() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigDedicated::PdschConfigDedicated(ns3::LteRrcSap::PdschConfigDedicated const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PdschConfigDedicated const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PdschConfigDedicated::pa [variable]
    cls.add_instance_attribute('pa', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapPhysCellIdRange_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysCellIdRange::PhysCellIdRange() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysCellIdRange::PhysCellIdRange(ns3::LteRrcSap::PhysCellIdRange const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PhysCellIdRange const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysCellIdRange::haveRange [variable]
    cls.add_instance_attribute('haveRange', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysCellIdRange::range [variable]
    cls.add_instance_attribute('range', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysCellIdRange::start [variable]
    cls.add_instance_attribute('start', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapPhysicalConfigDedicated_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::PhysicalConfigDedicated() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::PhysicalConfigDedicated(ns3::LteRrcSap::PhysicalConfigDedicated const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PhysicalConfigDedicated const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::antennaInfo [variable]
    cls.add_instance_attribute('antennaInfo', 'ns3::LteRrcSap::AntennaInfoDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::haveAntennaInfoDedicated [variable]
    cls.add_instance_attribute('haveAntennaInfoDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::havePdschConfigDedicated [variable]
    cls.add_instance_attribute('havePdschConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::haveSoundingRsUlConfigDedicated [variable]
    cls.add_instance_attribute('haveSoundingRsUlConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::pdschConfigDedicated [variable]
    cls.add_instance_attribute('pdschConfigDedicated', 'ns3::LteRrcSap::PdschConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicated::soundingRsUlConfigDedicated [variable]
    cls.add_instance_attribute('soundingRsUlConfigDedicated', 'ns3::LteRrcSap::SoundingRsUlConfigDedicated', is_const=False)
    return

def register_Ns3LteRrcSapPhysicalConfigDedicatedSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::PhysicalConfigDedicatedSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::PhysicalConfigDedicatedSCell(ns3::LteRrcSap::PhysicalConfigDedicatedSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PhysicalConfigDedicatedSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::antennaInfo [variable]
    cls.add_instance_attribute('antennaInfo', 'ns3::LteRrcSap::AntennaInfoDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::antennaInfoUl [variable]
    cls.add_instance_attribute('antennaInfoUl', 'ns3::LteRrcSap::AntennaInfoDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::crossCarrierSchedulingConfig [variable]
    cls.add_instance_attribute('crossCarrierSchedulingConfig', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::haveAntennaInfoDedicated [variable]
    cls.add_instance_attribute('haveAntennaInfoDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::haveAntennaInfoUlDedicated [variable]
    cls.add_instance_attribute('haveAntennaInfoUlDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::haveNonUlConfiguration [variable]
    cls.add_instance_attribute('haveNonUlConfiguration', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::havePdschConfigDedicated [variable]
    cls.add_instance_attribute('havePdschConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::haveSoundingRsUlConfigDedicated [variable]
    cls.add_instance_attribute('haveSoundingRsUlConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::haveUlConfiguration [variable]
    cls.add_instance_attribute('haveUlConfiguration', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::pdschConfigDedicated [variable]
    cls.add_instance_attribute('pdschConfigDedicated', 'ns3::LteRrcSap::PdschConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::pushConfigDedicatedSCell [variable]
    cls.add_instance_attribute('pushConfigDedicatedSCell', 'ns3::LteRrcSap::PuschConfigDedicatedSCell', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::soundingRsUlConfigDedicated [variable]
    cls.add_instance_attribute('soundingRsUlConfigDedicated', 'ns3::LteRrcSap::SoundingRsUlConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PhysicalConfigDedicatedSCell::ulPowerControlDedicatedSCell [variable]
    cls.add_instance_attribute('ulPowerControlDedicatedSCell', 'ns3::LteRrcSap::UlPowerControlDedicatedSCell', is_const=False)
    return

def register_Ns3LteRrcSapPlmnIdentityInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PlmnIdentityInfo::PlmnIdentityInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PlmnIdentityInfo::PlmnIdentityInfo(ns3::LteRrcSap::PlmnIdentityInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PlmnIdentityInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PlmnIdentityInfo::plmnIdentity [variable]
    cls.add_instance_attribute('plmnIdentity', 'uint32_t', is_const=False)
    return

def register_Ns3LteRrcSapPrachConfigSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PrachConfigSCell::PrachConfigSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PrachConfigSCell::PrachConfigSCell(ns3::LteRrcSap::PrachConfigSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PrachConfigSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PrachConfigSCell::index [variable]
    cls.add_instance_attribute('index', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapPreambleInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PreambleInfo::PreambleInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PreambleInfo::PreambleInfo(ns3::LteRrcSap::PreambleInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PreambleInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PreambleInfo::numberOfRaPreambles [variable]
    cls.add_instance_attribute('numberOfRaPreambles', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapPuschConfigDedicatedSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PuschConfigDedicatedSCell::PuschConfigDedicatedSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PuschConfigDedicatedSCell::PuschConfigDedicatedSCell(ns3::LteRrcSap::PuschConfigDedicatedSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::PuschConfigDedicatedSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::PuschConfigDedicatedSCell::nPuschIdentity [variable]
    cls.add_instance_attribute('nPuschIdentity', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapQuantityConfig_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::QuantityConfig::QuantityConfig() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::QuantityConfig::QuantityConfig(ns3::LteRrcSap::QuantityConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::QuantityConfig const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::QuantityConfig::filterCoefficientRSRP [variable]
    cls.add_instance_attribute('filterCoefficientRSRP', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::QuantityConfig::filterCoefficientRSRQ [variable]
    cls.add_instance_attribute('filterCoefficientRSRQ', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRaSupervisionInfo_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RaSupervisionInfo::RaSupervisionInfo() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RaSupervisionInfo::RaSupervisionInfo(ns3::LteRrcSap::RaSupervisionInfo const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RaSupervisionInfo const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RaSupervisionInfo::preambleTransMax [variable]
    cls.add_instance_attribute('preambleTransMax', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RaSupervisionInfo::raResponseWindowSize [variable]
    cls.add_instance_attribute('raResponseWindowSize', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRachConfigCommon_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigCommon::RachConfigCommon() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigCommon::RachConfigCommon(ns3::LteRrcSap::RachConfigCommon const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RachConfigCommon const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigCommon::preambleInfo [variable]
    cls.add_instance_attribute('preambleInfo', 'ns3::LteRrcSap::PreambleInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigCommon::raSupervisionInfo [variable]
    cls.add_instance_attribute('raSupervisionInfo', 'ns3::LteRrcSap::RaSupervisionInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigCommon::txFailParam [variable]
    cls.add_instance_attribute('txFailParam', 'ns3::LteRrcSap::TxFailParam', is_const=False)
    return

def register_Ns3LteRrcSapRachConfigDedicated_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigDedicated::RachConfigDedicated() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigDedicated::RachConfigDedicated(ns3::LteRrcSap::RachConfigDedicated const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RachConfigDedicated const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigDedicated::raPrachMaskIndex [variable]
    cls.add_instance_attribute('raPrachMaskIndex', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RachConfigDedicated::raPreambleIndex [variable]
    cls.add_instance_attribute('raPreambleIndex', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRadioResourceConfigCommon_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommon::RadioResourceConfigCommon() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommon::RadioResourceConfigCommon(ns3::LteRrcSap::RadioResourceConfigCommon const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RadioResourceConfigCommon const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommon::rachConfigCommon [variable]
    cls.add_instance_attribute('rachConfigCommon', 'ns3::LteRrcSap::RachConfigCommon', is_const=False)
    return

def register_Ns3LteRrcSapRadioResourceConfigCommonSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell::RadioResourceConfigCommonSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell::RadioResourceConfigCommonSCell(ns3::LteRrcSap::RadioResourceConfigCommonSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RadioResourceConfigCommonSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell::haveNonUlConfiguration [variable]
    cls.add_instance_attribute('haveNonUlConfiguration', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell::haveUlConfiguration [variable]
    cls.add_instance_attribute('haveUlConfiguration', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell::nonUlConfiguration [variable]
    cls.add_instance_attribute('nonUlConfiguration', 'ns3::LteRrcSap::NonUlConfiguration', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSCell::ulConfiguration [variable]
    cls.add_instance_attribute('ulConfiguration', 'ns3::LteRrcSap::UlConfiguration', is_const=False)
    return

def register_Ns3LteRrcSapRadioResourceConfigCommonSib_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSib::RadioResourceConfigCommonSib() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSib::RadioResourceConfigCommonSib(ns3::LteRrcSap::RadioResourceConfigCommonSib const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RadioResourceConfigCommonSib const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSib::pdschConfigCommon [variable]
    cls.add_instance_attribute('pdschConfigCommon', 'ns3::LteRrcSap::PdschConfigCommon', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigCommonSib::rachConfigCommon [variable]
    cls.add_instance_attribute('rachConfigCommon', 'ns3::LteRrcSap::RachConfigCommon', is_const=False)
    return

def register_Ns3LteRrcSapRadioResourceConfigDedicated_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::RadioResourceConfigDedicated() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::RadioResourceConfigDedicated(ns3::LteRrcSap::RadioResourceConfigDedicated const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RadioResourceConfigDedicated const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::drbToAddModList [variable]
    cls.add_instance_attribute('drbToAddModList', 'std::list< ns3::LteRrcSap::DrbToAddMod >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::drbToReleaseList [variable]
    cls.add_instance_attribute('drbToReleaseList', 'std::list< unsigned char >', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::havePhysicalConfigDedicated [variable]
    cls.add_instance_attribute('havePhysicalConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::physicalConfigDedicated [variable]
    cls.add_instance_attribute('physicalConfigDedicated', 'ns3::LteRrcSap::PhysicalConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicated::srbToAddModList [variable]
    cls.add_instance_attribute('srbToAddModList', 'std::list< ns3::LteRrcSap::SrbToAddMod >', is_const=False)
    return

def register_Ns3LteRrcSapRadioResourceConfigDedicatedSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicatedSCell::RadioResourceConfigDedicatedSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicatedSCell::RadioResourceConfigDedicatedSCell(ns3::LteRrcSap::RadioResourceConfigDedicatedSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RadioResourceConfigDedicatedSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RadioResourceConfigDedicatedSCell::physicalConfigDedicatedSCell [variable]
    cls.add_instance_attribute('physicalConfigDedicatedSCell', 'ns3::LteRrcSap::PhysicalConfigDedicatedSCell', is_const=False)
    return

def register_Ns3LteRrcSapReestabUeIdentity_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReestabUeIdentity::ReestabUeIdentity() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReestabUeIdentity::ReestabUeIdentity(ns3::LteRrcSap::ReestabUeIdentity const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::ReestabUeIdentity const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReestabUeIdentity::cRnti [variable]
    cls.add_instance_attribute('cRnti', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReestabUeIdentity::physCellId [variable]
    cls.add_instance_attribute('physCellId', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapReportConfigEutra_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::ReportConfigEutra(ns3::LteRrcSap::ReportConfigEutra const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::ReportConfigEutra const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::ReportConfigEutra() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::a3Offset [variable]
    cls.add_instance_attribute('a3Offset', 'int8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::hysteresis [variable]
    cls.add_instance_attribute('hysteresis', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::maxReportCells [variable]
    cls.add_instance_attribute('maxReportCells', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::purpose [variable]
    cls.add_instance_attribute('purpose', 'ns3::LteRrcSap::ReportConfigEutra::report', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::reportAmount [variable]
    cls.add_instance_attribute('reportAmount', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::reportOnLeave [variable]
    cls.add_instance_attribute('reportOnLeave', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::threshold1 [variable]
    cls.add_instance_attribute('threshold1', 'ns3::LteRrcSap::ThresholdEutra', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::threshold2 [variable]
    cls.add_instance_attribute('threshold2', 'ns3::LteRrcSap::ThresholdEutra', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigEutra::timeToTrigger [variable]
    cls.add_instance_attribute('timeToTrigger', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapReportConfigToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigToAddMod::ReportConfigToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigToAddMod::ReportConfigToAddMod(ns3::LteRrcSap::ReportConfigToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::ReportConfigToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigToAddMod::reportConfigEutra [variable]
    cls.add_instance_attribute('reportConfigEutra', 'ns3::LteRrcSap::ReportConfigEutra', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ReportConfigToAddMod::reportConfigId [variable]
    cls.add_instance_attribute('reportConfigId', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRlcConfig_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RlcConfig::RlcConfig() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RlcConfig::RlcConfig(ns3::LteRrcSap::RlcConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RlcConfig const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RlcConfig::choice [variable]
    cls.add_instance_attribute('choice', 'ns3::LteRrcSap::RlcConfig::direction', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionReconfiguration_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::RrcConnectionReconfiguration() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::RrcConnectionReconfiguration(ns3::LteRrcSap::RrcConnectionReconfiguration const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReconfiguration const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::haveMeasConfig [variable]
    cls.add_instance_attribute('haveMeasConfig', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::haveMobilityControlInfo [variable]
    cls.add_instance_attribute('haveMobilityControlInfo', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::haveNonCriticalExtension [variable]
    cls.add_instance_attribute('haveNonCriticalExtension', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::haveRadioResourceConfigDedicated [variable]
    cls.add_instance_attribute('haveRadioResourceConfigDedicated', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::measConfig [variable]
    cls.add_instance_attribute('measConfig', 'ns3::LteRrcSap::MeasConfig', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::mobilityControlInfo [variable]
    cls.add_instance_attribute('mobilityControlInfo', 'ns3::LteRrcSap::MobilityControlInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::nonCriticalExtension [variable]
    cls.add_instance_attribute('nonCriticalExtension', 'ns3::LteRrcSap::NonCriticalExtensionConfiguration', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::radioResourceConfigDedicated [variable]
    cls.add_instance_attribute('radioResourceConfigDedicated', 'ns3::LteRrcSap::RadioResourceConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionReconfigurationCompleted_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfigurationCompleted::RrcConnectionReconfigurationCompleted() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfigurationCompleted::RrcConnectionReconfigurationCompleted(ns3::LteRrcSap::RrcConnectionReconfigurationCompleted const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReconfigurationCompleted const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfigurationCompleted::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionReestablishment_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishment::RrcConnectionReestablishment() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishment::RrcConnectionReestablishment(ns3::LteRrcSap::RrcConnectionReestablishment const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReestablishment const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishment::radioResourceConfigDedicated [variable]
    cls.add_instance_attribute('radioResourceConfigDedicated', 'ns3::LteRrcSap::RadioResourceConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishment::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionReestablishmentComplete_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentComplete::RrcConnectionReestablishmentComplete() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentComplete::RrcConnectionReestablishmentComplete(ns3::LteRrcSap::RrcConnectionReestablishmentComplete const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReestablishmentComplete const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentComplete::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionReestablishmentReject_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentReject::RrcConnectionReestablishmentReject() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentReject::RrcConnectionReestablishmentReject(ns3::LteRrcSap::RrcConnectionReestablishmentReject const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReestablishmentReject const &', 'arg0')])
    return

def register_Ns3LteRrcSapRrcConnectionReestablishmentRequest_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentRequest::RrcConnectionReestablishmentRequest() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentRequest::RrcConnectionReestablishmentRequest(ns3::LteRrcSap::RrcConnectionReestablishmentRequest const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReestablishmentRequest const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentRequest::reestablishmentCause [variable]
    cls.add_instance_attribute('reestablishmentCause', 'ns3::LteRrcSap::ReestablishmentCause', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReestablishmentRequest::ueIdentity [variable]
    cls.add_instance_attribute('ueIdentity', 'ns3::LteRrcSap::ReestabUeIdentity', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionReject_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReject::RrcConnectionReject() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReject::RrcConnectionReject(ns3::LteRrcSap::RrcConnectionReject const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionReject const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReject::waitTime [variable]
    cls.add_instance_attribute('waitTime', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionRelease_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRelease::RrcConnectionRelease() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRelease::RrcConnectionRelease(ns3::LteRrcSap::RrcConnectionRelease const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionRelease const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRelease::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionRequest_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRequest::RrcConnectionRequest() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRequest::RrcConnectionRequest(ns3::LteRrcSap::RrcConnectionRequest const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionRequest const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionRequest::ueIdentity [variable]
    cls.add_instance_attribute('ueIdentity', 'uint64_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionSetup_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetup::RrcConnectionSetup() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetup::RrcConnectionSetup(ns3::LteRrcSap::RrcConnectionSetup const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionSetup const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetup::radioResourceConfigDedicated [variable]
    cls.add_instance_attribute('radioResourceConfigDedicated', 'ns3::LteRrcSap::RadioResourceConfigDedicated', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetup::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapRrcConnectionSetupCompleted_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetupCompleted::RrcConnectionSetupCompleted() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetupCompleted::RrcConnectionSetupCompleted(ns3::LteRrcSap::RrcConnectionSetupCompleted const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::RrcConnectionSetupCompleted const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionSetupCompleted::rrcTransactionIdentifier [variable]
    cls.add_instance_attribute('rrcTransactionIdentifier', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapSCellToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::SCellToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::SCellToAddMod(ns3::LteRrcSap::SCellToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SCellToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::cellIdentification [variable]
    cls.add_instance_attribute('cellIdentification', 'ns3::LteRrcSap::CellIdentification', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::haveRadioResourceConfigDedicatedSCell [variable]
    cls.add_instance_attribute('haveRadioResourceConfigDedicatedSCell', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::radioResourceConfigCommonSCell [variable]
    cls.add_instance_attribute('radioResourceConfigCommonSCell', 'ns3::LteRrcSap::RadioResourceConfigCommonSCell', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::radioResourceConfigDedicateSCell [variable]
    cls.add_instance_attribute('radioResourceConfigDedicateSCell', 'ns3::LteRrcSap::RadioResourceConfigDedicatedSCell', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SCellToAddMod::sCellIndex [variable]
    cls.add_instance_attribute('sCellIndex', 'uint32_t', is_const=False)
    return

def register_Ns3LteRrcSapSoundingRsUlConfigCommon_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon::SoundingRsUlConfigCommon() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon::SoundingRsUlConfigCommon(ns3::LteRrcSap::SoundingRsUlConfigCommon const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SoundingRsUlConfigCommon const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon::srsBandwidthConfig [variable]
    cls.add_instance_attribute('srsBandwidthConfig', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon::srsSubframeConfig [variable]
    cls.add_instance_attribute('srsSubframeConfig', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigCommon::type [variable]
    cls.add_instance_attribute('type', 'ns3::LteRrcSap::SoundingRsUlConfigCommon::action', is_const=False)
    return

def register_Ns3LteRrcSapSoundingRsUlConfigDedicated_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated::SoundingRsUlConfigDedicated() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated::SoundingRsUlConfigDedicated(ns3::LteRrcSap::SoundingRsUlConfigDedicated const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SoundingRsUlConfigDedicated const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated::srsBandwidth [variable]
    cls.add_instance_attribute('srsBandwidth', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated::srsConfigIndex [variable]
    cls.add_instance_attribute('srsConfigIndex', 'uint16_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SoundingRsUlConfigDedicated::type [variable]
    cls.add_instance_attribute('type', 'ns3::LteRrcSap::SoundingRsUlConfigDedicated::action', is_const=False)
    return

def register_Ns3LteRrcSapSpeedStatePars_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars::SpeedStatePars() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars::SpeedStatePars(ns3::LteRrcSap::SpeedStatePars const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SpeedStatePars const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars::mobilityStateParameters [variable]
    cls.add_instance_attribute('mobilityStateParameters', 'ns3::LteRrcSap::MobilityStateParameters', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars::timeToTriggerSf [variable]
    cls.add_instance_attribute('timeToTriggerSf', 'ns3::LteRrcSap::SpeedStateScaleFactors', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStatePars::type [variable]
    cls.add_instance_attribute('type', 'ns3::LteRrcSap::SpeedStatePars::action', is_const=False)
    return

def register_Ns3LteRrcSapSpeedStateScaleFactors_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStateScaleFactors::SpeedStateScaleFactors() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStateScaleFactors::SpeedStateScaleFactors(ns3::LteRrcSap::SpeedStateScaleFactors const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SpeedStateScaleFactors const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStateScaleFactors::sfHigh [variable]
    cls.add_instance_attribute('sfHigh', 'uint8_t', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SpeedStateScaleFactors::sfMedium [variable]
    cls.add_instance_attribute('sfMedium', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapSrbToAddMod_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SrbToAddMod::SrbToAddMod() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SrbToAddMod::SrbToAddMod(ns3::LteRrcSap::SrbToAddMod const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SrbToAddMod const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SrbToAddMod::logicalChannelConfig [variable]
    cls.add_instance_attribute('logicalChannelConfig', 'ns3::LteRrcSap::LogicalChannelConfig', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SrbToAddMod::srbIdentity [variable]
    cls.add_instance_attribute('srbIdentity', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapSystemInformation_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformation::SystemInformation() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformation::SystemInformation(ns3::LteRrcSap::SystemInformation const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SystemInformation const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformation::haveSib2 [variable]
    cls.add_instance_attribute('haveSib2', 'bool', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformation::sib2 [variable]
    cls.add_instance_attribute('sib2', 'ns3::LteRrcSap::SystemInformationBlockType2', is_const=False)
    return

def register_Ns3LteRrcSapSystemInformationBlockType1_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType1::SystemInformationBlockType1() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType1::SystemInformationBlockType1(ns3::LteRrcSap::SystemInformationBlockType1 const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SystemInformationBlockType1 const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType1::cellAccessRelatedInfo [variable]
    cls.add_instance_attribute('cellAccessRelatedInfo', 'ns3::LteRrcSap::CellAccessRelatedInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType1::cellSelectionInfo [variable]
    cls.add_instance_attribute('cellSelectionInfo', 'ns3::LteRrcSap::CellSelectionInfo', is_const=False)
    return

def register_Ns3LteRrcSapSystemInformationBlockType2_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType2::SystemInformationBlockType2() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType2::SystemInformationBlockType2(ns3::LteRrcSap::SystemInformationBlockType2 const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::SystemInformationBlockType2 const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType2::freqInfo [variable]
    cls.add_instance_attribute('freqInfo', 'ns3::LteRrcSap::FreqInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::SystemInformationBlockType2::radioResourceConfigCommon [variable]
    cls.add_instance_attribute('radioResourceConfigCommon', 'ns3::LteRrcSap::RadioResourceConfigCommonSib', is_const=False)
    return

def register_Ns3LteRrcSapThresholdEutra_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ThresholdEutra::ThresholdEutra() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ThresholdEutra::ThresholdEutra(ns3::LteRrcSap::ThresholdEutra const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::ThresholdEutra const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::ThresholdEutra::range [variable]
    cls.add_instance_attribute('range', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapTxFailParam_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::TxFailParam::TxFailParam() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::TxFailParam::TxFailParam(ns3::LteRrcSap::TxFailParam const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::TxFailParam const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::TxFailParam::connEstFailCount [variable]
    cls.add_instance_attribute('connEstFailCount', 'uint8_t', is_const=False)
    return

def register_Ns3LteRrcSapUlConfiguration_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration::UlConfiguration() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration::UlConfiguration(ns3::LteRrcSap::UlConfiguration const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::UlConfiguration const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration::prachConfigSCell [variable]
    cls.add_instance_attribute('prachConfigSCell', 'ns3::LteRrcSap::PrachConfigSCell', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration::soundingRsUlConfigCommon [variable]
    cls.add_instance_attribute('soundingRsUlConfigCommon', 'ns3::LteRrcSap::SoundingRsUlConfigCommon', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration::ulFreqInfo [variable]
    cls.add_instance_attribute('ulFreqInfo', 'ns3::LteRrcSap::FreqInfo', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlConfiguration::ulPowerControlCommonSCell [variable]
    cls.add_instance_attribute('ulPowerControlCommonSCell', 'ns3::LteRrcSap::UlPowerControlCommonSCell', is_const=False)
    return

def register_Ns3LteRrcSapUlPowerControlCommonSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlCommonSCell::UlPowerControlCommonSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlCommonSCell::UlPowerControlCommonSCell(ns3::LteRrcSap::UlPowerControlCommonSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::UlPowerControlCommonSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlCommonSCell::alpha [variable]
    cls.add_instance_attribute('alpha', 'uint16_t', is_const=False)
    return

def register_Ns3LteRrcSapUlPowerControlDedicatedSCell_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlDedicatedSCell::UlPowerControlDedicatedSCell() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlDedicatedSCell::UlPowerControlDedicatedSCell(ns3::LteRrcSap::UlPowerControlDedicatedSCell const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRrcSap::UlPowerControlDedicatedSCell const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::UlPowerControlDedicatedSCell::pSrsOffset [variable]
    cls.add_instance_attribute('pSrsOffset', 'uint16_t', is_const=False)
    return

def register_Ns3LteSpectrumValueCatcher_methods(root_module, cls):
    ## lte-chunk-processor.h (module 'lte'): ns3::LteSpectrumValueCatcher::LteSpectrumValueCatcher() [constructor]
    cls.add_constructor([])
    ## lte-chunk-processor.h (module 'lte'): ns3::LteSpectrumValueCatcher::LteSpectrumValueCatcher(ns3::LteSpectrumValueCatcher const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteSpectrumValueCatcher const &', 'arg0')])
    ## lte-chunk-processor.h (module 'lte'): ns3::Ptr<ns3::SpectrumValue> ns3::LteSpectrumValueCatcher::GetValue() [member function]
    cls.add_method('GetValue', 
                   'ns3::Ptr< ns3::SpectrumValue >', 
                   [])
    ## lte-chunk-processor.h (module 'lte'): void ns3::LteSpectrumValueCatcher::ReportValue(ns3::SpectrumValue const & value) [member function]
    cls.add_method('ReportValue', 
                   'void', 
                   [param('ns3::SpectrumValue const &', 'value')])
    return

def register_Ns3LteSpectrumValueHelper_methods(root_module, cls):
    ## lte-spectrum-value-helper.h (module 'lte'): ns3::LteSpectrumValueHelper::LteSpectrumValueHelper() [constructor]
    cls.add_constructor([])
    ## lte-spectrum-value-helper.h (module 'lte'): ns3::LteSpectrumValueHelper::LteSpectrumValueHelper(ns3::LteSpectrumValueHelper const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteSpectrumValueHelper const &', 'arg0')])
    ## lte-spectrum-value-helper.h (module 'lte'): static ns3::Ptr<ns3::SpectrumValue> ns3::LteSpectrumValueHelper::CreateNoisePowerSpectralDensity(uint32_t earfcn, uint8_t bandwidth, double noiseFigure) [member function]
    cls.add_method('CreateNoisePowerSpectralDensity', 
                   'ns3::Ptr< ns3::SpectrumValue >', 
                   [param('uint32_t', 'earfcn'), param('uint8_t', 'bandwidth'), param('double', 'noiseFigure')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static ns3::Ptr<ns3::SpectrumValue> ns3::LteSpectrumValueHelper::CreateNoisePowerSpectralDensity(double noiseFigure, ns3::Ptr<ns3::SpectrumModel> spectrumModel) [member function]
    cls.add_method('CreateNoisePowerSpectralDensity', 
                   'ns3::Ptr< ns3::SpectrumValue >', 
                   [param('double', 'noiseFigure'), param('ns3::Ptr< ns3::SpectrumModel >', 'spectrumModel')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static ns3::Ptr<ns3::SpectrumValue> ns3::LteSpectrumValueHelper::CreateTxPowerSpectralDensity(uint32_t earfcn, uint8_t bandwidth, double powerTx, std::vector<int, std::allocator<int> > activeRbs) [member function]
    cls.add_method('CreateTxPowerSpectralDensity', 
                   'ns3::Ptr< ns3::SpectrumValue >', 
                   [param('uint32_t', 'earfcn'), param('uint8_t', 'bandwidth'), param('double', 'powerTx'), param('std::vector< int >', 'activeRbs')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static ns3::Ptr<ns3::SpectrumValue> ns3::LteSpectrumValueHelper::CreateTxPowerSpectralDensity(uint32_t earfcn, uint8_t bandwidth, double powerTx, std::map<int, double, std::less<int>, std::allocator<std::pair<const int, double> > > powerTxMap, std::vector<int, std::allocator<int> > activeRbs) [member function]
    cls.add_method('CreateTxPowerSpectralDensity', 
                   'ns3::Ptr< ns3::SpectrumValue >', 
                   [param('uint32_t', 'earfcn'), param('uint8_t', 'bandwidth'), param('double', 'powerTx'), param('std::map< int, double >', 'powerTxMap'), param('std::vector< int >', 'activeRbs')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static ns3::Ptr<ns3::SpectrumValue> ns3::LteSpectrumValueHelper::CreateUlTxPowerSpectralDensity(uint16_t earfcn, uint8_t bandwidth, double powerTx, std::vector<int, std::allocator<int> > activeRbs) [member function]
    cls.add_method('CreateUlTxPowerSpectralDensity', 
                   'ns3::Ptr< ns3::SpectrumValue >', 
                   [param('uint16_t', 'earfcn'), param('uint8_t', 'bandwidth'), param('double', 'powerTx'), param('std::vector< int >', 'activeRbs')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static double ns3::LteSpectrumValueHelper::GetCarrierFrequency(uint32_t earfcn) [member function]
    cls.add_method('GetCarrierFrequency', 
                   'double', 
                   [param('uint32_t', 'earfcn')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static double ns3::LteSpectrumValueHelper::GetChannelBandwidth(uint8_t txBandwidthConf) [member function]
    cls.add_method('GetChannelBandwidth', 
                   'double', 
                   [param('uint8_t', 'txBandwidthConf')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static uint16_t ns3::LteSpectrumValueHelper::GetDownlinkCarrierBand(uint32_t nDl) [member function]
    cls.add_method('GetDownlinkCarrierBand', 
                   'uint16_t', 
                   [param('uint32_t', 'nDl')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static double ns3::LteSpectrumValueHelper::GetDownlinkCarrierFrequency(uint32_t earfcn) [member function]
    cls.add_method('GetDownlinkCarrierFrequency', 
                   'double', 
                   [param('uint32_t', 'earfcn')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static ns3::Ptr<ns3::SpectrumModel> ns3::LteSpectrumValueHelper::GetSpectrumModel(uint32_t earfcn, uint8_t bandwidth) [member function]
    cls.add_method('GetSpectrumModel', 
                   'ns3::Ptr< ns3::SpectrumModel >', 
                   [param('uint32_t', 'earfcn'), param('uint8_t', 'bandwidth')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static uint16_t ns3::LteSpectrumValueHelper::GetUplinkCarrierBand(uint32_t nUl) [member function]
    cls.add_method('GetUplinkCarrierBand', 
                   'uint16_t', 
                   [param('uint32_t', 'nUl')], 
                   is_static=True)
    ## lte-spectrum-value-helper.h (module 'lte'): static double ns3::LteSpectrumValueHelper::GetUplinkCarrierFrequency(uint32_t earfcn) [member function]
    cls.add_method('GetUplinkCarrierFrequency', 
                   'double', 
                   [param('uint32_t', 'earfcn')], 
                   is_static=True)
    return

def register_Ns3LteUeCcmRrcSapProvider_methods(root_module, cls):
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LteUeCcmRrcSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LteUeCcmRrcSapProvider(ns3::LteUeCcmRrcSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCcmRrcSapProvider const &', 'arg0')])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): std::vector<ns3::LteUeCcmRrcSapProvider::LcsConfig, std::allocator<ns3::LteUeCcmRrcSapProvider::LcsConfig> > ns3::LteUeCcmRrcSapProvider::AddLc(uint8_t lcId, ns3::LteUeCmacSapProvider::LogicalChannelConfig lcConfig, ns3::LteMacSapUser * msu) [member function]
    cls.add_method('AddLc', 
                   'std::vector< ns3::LteUeCcmRrcSapProvider::LcsConfig >', 
                   [param('uint8_t', 'lcId'), param('ns3::LteUeCmacSapProvider::LogicalChannelConfig', 'lcConfig'), param('ns3::LteMacSapUser *', 'msu')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteMacSapUser * ns3::LteUeCcmRrcSapProvider::ConfigureSignalBearer(uint8_t lcid, ns3::LteUeCmacSapProvider::LogicalChannelConfig lcConfig, ns3::LteMacSapUser * msu) [member function]
    cls.add_method('ConfigureSignalBearer', 
                   'ns3::LteMacSapUser *', 
                   [param('uint8_t', 'lcid'), param('ns3::LteUeCmacSapProvider::LogicalChannelConfig', 'lcConfig'), param('ns3::LteMacSapUser *', 'msu')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): void ns3::LteUeCcmRrcSapProvider::NotifyConnectionReconfigurationMsg() [member function]
    cls.add_method('NotifyConnectionReconfigurationMsg', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): std::vector<unsigned short, std::allocator<unsigned short> > ns3::LteUeCcmRrcSapProvider::RemoveLc(uint8_t lcid) [member function]
    cls.add_method('RemoveLc', 
                   'std::vector< unsigned short >', 
                   [param('uint8_t', 'lcid')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): void ns3::LteUeCcmRrcSapProvider::Reset() [member function]
    cls.add_method('Reset', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeCcmRrcSapProviderLcsConfig_methods(root_module, cls):
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LcsConfig::LcsConfig() [constructor]
    cls.add_constructor([])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LcsConfig::LcsConfig(ns3::LteUeCcmRrcSapProvider::LcsConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCcmRrcSapProvider::LcsConfig const &', 'arg0')])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LcsConfig::componentCarrierId [variable]
    cls.add_instance_attribute('componentCarrierId', 'uint8_t', is_const=False)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LcsConfig::lcConfig [variable]
    cls.add_instance_attribute('lcConfig', 'ns3::LteUeCmacSapProvider::LogicalChannelConfig', is_const=False)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapProvider::LcsConfig::msu [variable]
    cls.add_instance_attribute('msu', 'ns3::LteMacSapUser *', is_const=False)
    return

def register_Ns3LteUeCcmRrcSapUser_methods(root_module, cls):
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapUser::LteUeCcmRrcSapUser() [constructor]
    cls.add_constructor([])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): ns3::LteUeCcmRrcSapUser::LteUeCcmRrcSapUser(ns3::LteUeCcmRrcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCcmRrcSapUser const &', 'arg0')])
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): void ns3::LteUeCcmRrcSapUser::ComponentCarrierEnabling(std::vector<unsigned char, std::allocator<unsigned char> > componentCarrierList) [member function]
    cls.add_method('ComponentCarrierEnabling', 
                   'void', 
                   [param('std::vector< unsigned char >', 'componentCarrierList')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-ccm-rrc-sap.h (module 'lte'): void ns3::LteUeCcmRrcSapUser::SetNumberOfComponentCarriers(uint16_t noOfComponentCarriers) [member function]
    cls.add_method('SetNumberOfComponentCarriers', 
                   'void', 
                   [param('uint16_t', 'noOfComponentCarriers')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeCmacSapProvider_methods(root_module, cls):
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LteUeCmacSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LteUeCmacSapProvider(ns3::LteUeCmacSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCmacSapProvider const &', 'arg0')])
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::AddLc(uint8_t lcId, ns3::LteUeCmacSapProvider::LogicalChannelConfig lcConfig, ns3::LteMacSapUser * msu) [member function]
    cls.add_method('AddLc', 
                   'void', 
                   [param('uint8_t', 'lcId'), param('ns3::LteUeCmacSapProvider::LogicalChannelConfig', 'lcConfig'), param('ns3::LteMacSapUser *', 'msu')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::ConfigureRach(ns3::LteUeCmacSapProvider::RachConfig rc) [member function]
    cls.add_method('ConfigureRach', 
                   'void', 
                   [param('ns3::LteUeCmacSapProvider::RachConfig', 'rc')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::NotifyConnectionSuccessful() [member function]
    cls.add_method('NotifyConnectionSuccessful', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::RemoveLc(uint8_t lcId) [member function]
    cls.add_method('RemoveLc', 
                   'void', 
                   [param('uint8_t', 'lcId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::Reset() [member function]
    cls.add_method('Reset', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::SetImsi(uint64_t imsi) [member function]
    cls.add_method('SetImsi', 
                   'void', 
                   [param('uint64_t', 'imsi')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::SetRnti(uint16_t rnti) [member function]
    cls.add_method('SetRnti', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::StartContentionBasedRandomAccessProcedure() [member function]
    cls.add_method('StartContentionBasedRandomAccessProcedure', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapProvider::StartNonContentionBasedRandomAccessProcedure(uint16_t rnti, uint8_t rapId, uint8_t prachMask) [member function]
    cls.add_method('StartNonContentionBasedRandomAccessProcedure', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'rapId'), param('uint8_t', 'prachMask')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeCmacSapProviderLogicalChannelConfig_methods(root_module, cls):
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig::LogicalChannelConfig() [constructor]
    cls.add_constructor([])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig::LogicalChannelConfig(ns3::LteUeCmacSapProvider::LogicalChannelConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCmacSapProvider::LogicalChannelConfig const &', 'arg0')])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig::bucketSizeDurationMs [variable]
    cls.add_instance_attribute('bucketSizeDurationMs', 'uint16_t', is_const=False)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig::logicalChannelGroup [variable]
    cls.add_instance_attribute('logicalChannelGroup', 'uint8_t', is_const=False)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig::prioritizedBitRateKbps [variable]
    cls.add_instance_attribute('prioritizedBitRateKbps', 'uint16_t', is_const=False)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::LogicalChannelConfig::priority [variable]
    cls.add_instance_attribute('priority', 'uint8_t', is_const=False)
    return

def register_Ns3LteUeCmacSapProviderRachConfig_methods(root_module, cls):
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig::RachConfig() [constructor]
    cls.add_constructor([])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig::RachConfig(ns3::LteUeCmacSapProvider::RachConfig const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCmacSapProvider::RachConfig const &', 'arg0')])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig::connEstFailCount [variable]
    cls.add_instance_attribute('connEstFailCount', 'uint8_t', is_const=False)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig::numberOfRaPreambles [variable]
    cls.add_instance_attribute('numberOfRaPreambles', 'uint8_t', is_const=False)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig::preambleTransMax [variable]
    cls.add_instance_attribute('preambleTransMax', 'uint8_t', is_const=False)
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapProvider::RachConfig::raResponseWindowSize [variable]
    cls.add_instance_attribute('raResponseWindowSize', 'uint8_t', is_const=False)
    return

def register_Ns3LteUeCmacSapUser_methods(root_module, cls):
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapUser::LteUeCmacSapUser() [constructor]
    cls.add_constructor([])
    ## lte-ue-cmac-sap.h (module 'lte'): ns3::LteUeCmacSapUser::LteUeCmacSapUser(ns3::LteUeCmacSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCmacSapUser const &', 'arg0')])
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapUser::NotifyRandomAccessFailed() [member function]
    cls.add_method('NotifyRandomAccessFailed', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapUser::NotifyRandomAccessSuccessful() [member function]
    cls.add_method('NotifyRandomAccessSuccessful', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cmac-sap.h (module 'lte'): void ns3::LteUeCmacSapUser::SetTemporaryCellRnti(uint16_t rnti) [member function]
    cls.add_method('SetTemporaryCellRnti', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeConfig_t_methods(root_module, cls):
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('==')
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t::LteUeConfig_t(ns3::LteUeConfig_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeConfig_t const &', 'arg0')])
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t::LteUeConfig_t() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t::m_reconfigureFlag [variable]
    cls.add_instance_attribute('m_reconfigureFlag', 'bool', is_const=False)
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t::m_srsConfigurationIndex [variable]
    cls.add_instance_attribute('m_srsConfigurationIndex', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::LteUeConfig_t::m_transmissionMode [variable]
    cls.add_instance_attribute('m_transmissionMode', 'uint8_t', is_const=False)
    return

def register_Ns3LteUeCphySapProvider_methods(root_module, cls):
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapProvider::LteUeCphySapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapProvider::LteUeCphySapProvider(ns3::LteUeCphySapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCphySapProvider const &', 'arg0')])
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::ConfigureReferenceSignalPower(int8_t referenceSignalPower) [member function]
    cls.add_method('ConfigureReferenceSignalPower', 
                   'void', 
                   [param('int8_t', 'referenceSignalPower')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::ConfigureUplink(uint32_t ulEarfcn, uint8_t ulBandwidth) [member function]
    cls.add_method('ConfigureUplink', 
                   'void', 
                   [param('uint32_t', 'ulEarfcn'), param('uint8_t', 'ulBandwidth')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::Reset() [member function]
    cls.add_method('Reset', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::ResetPhyAfterRlf() [member function]
    cls.add_method('ResetPhyAfterRlf', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::ResetRlfParams() [member function]
    cls.add_method('ResetRlfParams', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetDlBandwidth(uint8_t dlBandwidth) [member function]
    cls.add_method('SetDlBandwidth', 
                   'void', 
                   [param('uint8_t', 'dlBandwidth')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetImsi(uint64_t imsi) [member function]
    cls.add_method('SetImsi', 
                   'void', 
                   [param('uint64_t', 'imsi')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetPa(double pa) [member function]
    cls.add_method('SetPa', 
                   'void', 
                   [param('double', 'pa')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetRnti(uint16_t rnti) [member function]
    cls.add_method('SetRnti', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetRsrpFilterCoefficient(uint8_t rsrpFilterCoefficient) [member function]
    cls.add_method('SetRsrpFilterCoefficient', 
                   'void', 
                   [param('uint8_t', 'rsrpFilterCoefficient')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetSrsConfigurationIndex(uint16_t srcCi) [member function]
    cls.add_method('SetSrsConfigurationIndex', 
                   'void', 
                   [param('uint16_t', 'srcCi')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SetTransmissionMode(uint8_t txMode) [member function]
    cls.add_method('SetTransmissionMode', 
                   'void', 
                   [param('uint8_t', 'txMode')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::StartCellSearch(uint32_t dlEarfcn) [member function]
    cls.add_method('StartCellSearch', 
                   'void', 
                   [param('uint32_t', 'dlEarfcn')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::StartInSnycDetection() [member function]
    cls.add_method('StartInSnycDetection', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SynchronizeWithEnb(uint16_t cellId) [member function]
    cls.add_method('SynchronizeWithEnb', 
                   'void', 
                   [param('uint16_t', 'cellId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapProvider::SynchronizeWithEnb(uint16_t cellId, uint32_t dlEarfcn) [member function]
    cls.add_method('SynchronizeWithEnb', 
                   'void', 
                   [param('uint16_t', 'cellId'), param('uint32_t', 'dlEarfcn')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeCphySapUser_methods(root_module, cls):
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::LteUeCphySapUser() [constructor]
    cls.add_constructor([])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::LteUeCphySapUser(ns3::LteUeCphySapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCphySapUser const &', 'arg0')])
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapUser::NotifyInSync() [member function]
    cls.add_method('NotifyInSync', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapUser::NotifyOutOfSync() [member function]
    cls.add_method('NotifyOutOfSync', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapUser::RecvMasterInformationBlock(uint16_t cellId, ns3::LteRrcSap::MasterInformationBlock mib) [member function]
    cls.add_method('RecvMasterInformationBlock', 
                   'void', 
                   [param('uint16_t', 'cellId'), param('ns3::LteRrcSap::MasterInformationBlock', 'mib')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapUser::RecvSystemInformationBlockType1(uint16_t cellId, ns3::LteRrcSap::SystemInformationBlockType1 sib1) [member function]
    cls.add_method('RecvSystemInformationBlockType1', 
                   'void', 
                   [param('uint16_t', 'cellId'), param('ns3::LteRrcSap::SystemInformationBlockType1', 'sib1')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapUser::ReportUeMeasurements(ns3::LteUeCphySapUser::UeMeasurementsParameters params) [member function]
    cls.add_method('ReportUeMeasurements', 
                   'void', 
                   [param('ns3::LteUeCphySapUser::UeMeasurementsParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-cphy-sap.h (module 'lte'): void ns3::LteUeCphySapUser::ResetSyncIndicationCounter() [member function]
    cls.add_method('ResetSyncIndicationCounter', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeCphySapUserUeMeasurementsElement_methods(root_module, cls):
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsElement::UeMeasurementsElement() [constructor]
    cls.add_constructor([])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsElement::UeMeasurementsElement(ns3::LteUeCphySapUser::UeMeasurementsElement const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCphySapUser::UeMeasurementsElement const &', 'arg0')])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsElement::m_cellId [variable]
    cls.add_instance_attribute('m_cellId', 'uint16_t', is_const=False)
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsElement::m_rsrp [variable]
    cls.add_instance_attribute('m_rsrp', 'double', is_const=False)
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsElement::m_rsrq [variable]
    cls.add_instance_attribute('m_rsrq', 'double', is_const=False)
    return

def register_Ns3LteUeCphySapUserUeMeasurementsParameters_methods(root_module, cls):
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsParameters::UeMeasurementsParameters() [constructor]
    cls.add_constructor([])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsParameters::UeMeasurementsParameters(ns3::LteUeCphySapUser::UeMeasurementsParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeCphySapUser::UeMeasurementsParameters const &', 'arg0')])
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsParameters::m_componentCarrierId [variable]
    cls.add_instance_attribute('m_componentCarrierId', 'uint8_t', is_const=False)
    ## lte-ue-cphy-sap.h (module 'lte'): ns3::LteUeCphySapUser::UeMeasurementsParameters::m_ueMeasurementsList [variable]
    cls.add_instance_attribute('m_ueMeasurementsList', 'std::vector< ns3::LteUeCphySapUser::UeMeasurementsElement >', is_const=False)
    return

def register_Ns3LteUePhySapProvider_methods(root_module, cls):
    ## lte-ue-phy-sap.h (module 'lte'): ns3::LteUePhySapProvider::LteUePhySapProvider() [constructor]
    cls.add_constructor([])
    ## lte-ue-phy-sap.h (module 'lte'): ns3::LteUePhySapProvider::LteUePhySapProvider(ns3::LteUePhySapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUePhySapProvider const &', 'arg0')])
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapProvider::NotifyConnectionSuccessful() [member function]
    cls.add_method('NotifyConnectionSuccessful', 
                   'void', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapProvider::SendLteControlMessage(ns3::Ptr<ns3::LteControlMessage> msg) [member function]
    cls.add_method('SendLteControlMessage', 
                   'void', 
                   [param('ns3::Ptr< ns3::LteControlMessage >', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapProvider::SendMacPdu(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('SendMacPdu', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapProvider::SendRachPreamble(uint32_t prachId, uint32_t raRnti) [member function]
    cls.add_method('SendRachPreamble', 
                   'void', 
                   [param('uint32_t', 'prachId'), param('uint32_t', 'raRnti')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUePhySapUser_methods(root_module, cls):
    ## lte-ue-phy-sap.h (module 'lte'): ns3::LteUePhySapUser::LteUePhySapUser() [constructor]
    cls.add_constructor([])
    ## lte-ue-phy-sap.h (module 'lte'): ns3::LteUePhySapUser::LteUePhySapUser(ns3::LteUePhySapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUePhySapUser const &', 'arg0')])
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapUser::ReceiveLteControlMessage(ns3::Ptr<ns3::LteControlMessage> msg) [member function]
    cls.add_method('ReceiveLteControlMessage', 
                   'void', 
                   [param('ns3::Ptr< ns3::LteControlMessage >', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapUser::ReceivePhyPdu(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('ReceivePhyPdu', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ue-phy-sap.h (module 'lte'): void ns3::LteUePhySapUser::SubframeIndication(uint32_t frameNo, uint32_t subframeNo) [member function]
    cls.add_method('SubframeIndication', 
                   'void', 
                   [param('uint32_t', 'frameNo'), param('uint32_t', 'subframeNo')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeRrcSapProvider_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::LteUeRrcSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::LteUeRrcSapProvider(ns3::LteUeRrcSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeRrcSapProvider const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::CompleteSetup(ns3::LteUeRrcSapProvider::CompleteSetupParameters params) [member function]
    cls.add_method('CompleteSetup', 
                   'void', 
                   [param('ns3::LteUeRrcSapProvider::CompleteSetupParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvRrcConnectionReconfiguration(ns3::LteRrcSap::RrcConnectionReconfiguration msg) [member function]
    cls.add_method('RecvRrcConnectionReconfiguration', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReconfiguration', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvRrcConnectionReestablishment(ns3::LteRrcSap::RrcConnectionReestablishment msg) [member function]
    cls.add_method('RecvRrcConnectionReestablishment', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReestablishment', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvRrcConnectionReestablishmentReject(ns3::LteRrcSap::RrcConnectionReestablishmentReject msg) [member function]
    cls.add_method('RecvRrcConnectionReestablishmentReject', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReestablishmentReject', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvRrcConnectionReject(ns3::LteRrcSap::RrcConnectionReject msg) [member function]
    cls.add_method('RecvRrcConnectionReject', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReject', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvRrcConnectionRelease(ns3::LteRrcSap::RrcConnectionRelease msg) [member function]
    cls.add_method('RecvRrcConnectionRelease', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionRelease', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvRrcConnectionSetup(ns3::LteRrcSap::RrcConnectionSetup msg) [member function]
    cls.add_method('RecvRrcConnectionSetup', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionSetup', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapProvider::RecvSystemInformation(ns3::LteRrcSap::SystemInformation msg) [member function]
    cls.add_method('RecvSystemInformation', 
                   'void', 
                   [param('ns3::LteRrcSap::SystemInformation', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeRrcSapProviderCompleteSetupParameters_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::CompleteSetupParameters::CompleteSetupParameters() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::CompleteSetupParameters::CompleteSetupParameters(ns3::LteUeRrcSapProvider::CompleteSetupParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeRrcSapProvider::CompleteSetupParameters const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::CompleteSetupParameters::srb0SapUser [variable]
    cls.add_instance_attribute('srb0SapUser', 'ns3::LteRlcSapUser *', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapProvider::CompleteSetupParameters::srb1SapUser [variable]
    cls.add_instance_attribute('srb1SapUser', 'ns3::LtePdcpSapUser *', is_const=False)
    return

def register_Ns3LteUeRrcSapUser_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::LteUeRrcSapUser() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::LteUeRrcSapUser(ns3::LteUeRrcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeRrcSapUser const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendIdealUeContextRemoveRequest(uint16_t rnti) [member function]
    cls.add_method('SendIdealUeContextRemoveRequest', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendMeasurementReport(ns3::LteRrcSap::MeasurementReport msg) [member function]
    cls.add_method('SendMeasurementReport', 
                   'void', 
                   [param('ns3::LteRrcSap::MeasurementReport', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendRrcConnectionReconfigurationCompleted(ns3::LteRrcSap::RrcConnectionReconfigurationCompleted msg) [member function]
    cls.add_method('SendRrcConnectionReconfigurationCompleted', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReconfigurationCompleted', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendRrcConnectionReestablishmentComplete(ns3::LteRrcSap::RrcConnectionReestablishmentComplete msg) [member function]
    cls.add_method('SendRrcConnectionReestablishmentComplete', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReestablishmentComplete', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendRrcConnectionReestablishmentRequest(ns3::LteRrcSap::RrcConnectionReestablishmentRequest msg) [member function]
    cls.add_method('SendRrcConnectionReestablishmentRequest', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionReestablishmentRequest', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendRrcConnectionRequest(ns3::LteRrcSap::RrcConnectionRequest msg) [member function]
    cls.add_method('SendRrcConnectionRequest', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionRequest', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::SendRrcConnectionSetupCompleted(ns3::LteRrcSap::RrcConnectionSetupCompleted msg) [member function]
    cls.add_method('SendRrcConnectionSetupCompleted', 
                   'void', 
                   [param('ns3::LteRrcSap::RrcConnectionSetupCompleted', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteUeRrcSapUser::Setup(ns3::LteUeRrcSapUser::SetupParameters params) [member function]
    cls.add_method('Setup', 
                   'void', 
                   [param('ns3::LteUeRrcSapUser::SetupParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteUeRrcSapUserSetupParameters_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::SetupParameters::SetupParameters() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::SetupParameters::SetupParameters(ns3::LteUeRrcSapUser::SetupParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteUeRrcSapUser::SetupParameters const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::SetupParameters::srb0SapProvider [variable]
    cls.add_instance_attribute('srb0SapProvider', 'ns3::LteRlcSapProvider *', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteUeRrcSapUser::SetupParameters::srb1SapProvider [variable]
    cls.add_instance_attribute('srb1SapProvider', 'ns3::LtePdcpSapProvider *', is_const=False)
    return

def register_Ns3Mac48Address_methods(root_module, cls):
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    cls.add_output_stream_operator()
    ## mac48-address.h (module 'network'): ns3::Mac48Address::Mac48Address(ns3::Mac48Address const & arg0) [constructor]
    cls.add_constructor([param('ns3::Mac48Address const &', 'arg0')])
    ## mac48-address.h (module 'network'): ns3::Mac48Address::Mac48Address() [constructor]
    cls.add_constructor([])
    ## mac48-address.h (module 'network'): ns3::Mac48Address::Mac48Address(char const * str) [constructor]
    cls.add_constructor([param('char const *', 'str')])
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::Allocate() [member function]
    cls.add_method('Allocate', 
                   'ns3::Mac48Address', 
                   [], 
                   is_static=True)
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::ConvertFrom(ns3::Address const & address) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::Mac48Address', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## mac48-address.h (module 'network'): void ns3::Mac48Address::CopyFrom(uint8_t const * buffer) [member function]
    cls.add_method('CopyFrom', 
                   'void', 
                   [param('uint8_t const *', 'buffer')])
    ## mac48-address.h (module 'network'): void ns3::Mac48Address::CopyTo(uint8_t * buffer) const [member function]
    cls.add_method('CopyTo', 
                   'void', 
                   [param('uint8_t *', 'buffer')], 
                   is_const=True)
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::GetBroadcast() [member function]
    cls.add_method('GetBroadcast', 
                   'ns3::Mac48Address', 
                   [], 
                   is_static=True)
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::GetMulticast(ns3::Ipv4Address address) [member function]
    cls.add_method('GetMulticast', 
                   'ns3::Mac48Address', 
                   [param('ns3::Ipv4Address', 'address')], 
                   is_static=True)
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::GetMulticast(ns3::Ipv6Address address) [member function]
    cls.add_method('GetMulticast', 
                   'ns3::Mac48Address', 
                   [param('ns3::Ipv6Address', 'address')], 
                   is_static=True)
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::GetMulticast6Prefix() [member function]
    cls.add_method('GetMulticast6Prefix', 
                   'ns3::Mac48Address', 
                   [], 
                   is_static=True)
    ## mac48-address.h (module 'network'): static ns3::Mac48Address ns3::Mac48Address::GetMulticastPrefix() [member function]
    cls.add_method('GetMulticastPrefix', 
                   'ns3::Mac48Address', 
                   [], 
                   is_static=True)
    ## mac48-address.h (module 'network'): bool ns3::Mac48Address::IsBroadcast() const [member function]
    cls.add_method('IsBroadcast', 
                   'bool', 
                   [], 
                   is_const=True)
    ## mac48-address.h (module 'network'): bool ns3::Mac48Address::IsGroup() const [member function]
    cls.add_method('IsGroup', 
                   'bool', 
                   [], 
                   is_const=True)
    ## mac48-address.h (module 'network'): static bool ns3::Mac48Address::IsMatchingType(ns3::Address const & address) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    return

def register_Ns3Mac64Address_methods(root_module, cls):
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<')
    cls.add_output_stream_operator()
    ## mac64-address.h (module 'network'): ns3::Mac64Address::Mac64Address(ns3::Mac64Address const & arg0) [constructor]
    cls.add_constructor([param('ns3::Mac64Address const &', 'arg0')])
    ## mac64-address.h (module 'network'): ns3::Mac64Address::Mac64Address() [constructor]
    cls.add_constructor([])
    ## mac64-address.h (module 'network'): ns3::Mac64Address::Mac64Address(char const * str) [constructor]
    cls.add_constructor([param('char const *', 'str')])
    ## mac64-address.h (module 'network'): static ns3::Mac64Address ns3::Mac64Address::Allocate() [member function]
    cls.add_method('Allocate', 
                   'ns3::Mac64Address', 
                   [], 
                   is_static=True)
    ## mac64-address.h (module 'network'): static ns3::Mac64Address ns3::Mac64Address::ConvertFrom(ns3::Address const & address) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::Mac64Address', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## mac64-address.h (module 'network'): void ns3::Mac64Address::CopyFrom(uint8_t const * buffer) [member function]
    cls.add_method('CopyFrom', 
                   'void', 
                   [param('uint8_t const *', 'buffer')])
    ## mac64-address.h (module 'network'): void ns3::Mac64Address::CopyTo(uint8_t * buffer) const [member function]
    cls.add_method('CopyTo', 
                   'void', 
                   [param('uint8_t *', 'buffer')], 
                   is_const=True)
    ## mac64-address.h (module 'network'): static bool ns3::Mac64Address::IsMatchingType(ns3::Address const & address) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    return

def register_Ns3Mac8Address_methods(root_module, cls):
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_output_stream_operator()
    ## mac8-address.h (module 'network'): ns3::Mac8Address::Mac8Address(ns3::Mac8Address const & arg0) [constructor]
    cls.add_constructor([param('ns3::Mac8Address const &', 'arg0')])
    ## mac8-address.h (module 'network'): ns3::Mac8Address::Mac8Address() [constructor]
    cls.add_constructor([])
    ## mac8-address.h (module 'network'): ns3::Mac8Address::Mac8Address(uint8_t addr) [constructor]
    cls.add_constructor([param('uint8_t', 'addr')])
    ## mac8-address.h (module 'network'): static ns3::Mac8Address ns3::Mac8Address::Allocate() [member function]
    cls.add_method('Allocate', 
                   'ns3::Mac8Address', 
                   [], 
                   is_static=True)
    ## mac8-address.h (module 'network'): static ns3::Mac8Address ns3::Mac8Address::ConvertFrom(ns3::Address const & address) [member function]
    cls.add_method('ConvertFrom', 
                   'ns3::Mac8Address', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    ## mac8-address.h (module 'network'): void ns3::Mac8Address::CopyFrom(uint8_t const * pBuffer) [member function]
    cls.add_method('CopyFrom', 
                   'void', 
                   [param('uint8_t const *', 'pBuffer')])
    ## mac8-address.h (module 'network'): void ns3::Mac8Address::CopyTo(uint8_t * pBuffer) const [member function]
    cls.add_method('CopyTo', 
                   'void', 
                   [param('uint8_t *', 'pBuffer')], 
                   is_const=True)
    ## mac8-address.h (module 'network'): static ns3::Mac8Address ns3::Mac8Address::GetBroadcast() [member function]
    cls.add_method('GetBroadcast', 
                   'ns3::Mac8Address', 
                   [], 
                   is_static=True)
    ## mac8-address.h (module 'network'): static bool ns3::Mac8Address::IsMatchingType(ns3::Address const & address) [member function]
    cls.add_method('IsMatchingType', 
                   'bool', 
                   [param('ns3::Address const &', 'address')], 
                   is_static=True)
    return

def register_Ns3MacCeListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s::MacCeListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s::MacCeListElement_s(ns3::MacCeListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::MacCeListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s::m_macCeType [variable]
    cls.add_instance_attribute('m_macCeType', 'ns3::MacCeListElement_s::MacCeType_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s::m_macCeValue [variable]
    cls.add_instance_attribute('m_macCeValue', 'ns3::MacCeValue_u', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::MacCeListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3MacCeValue_u_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::MacCeValue_u::MacCeValue_u() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::MacCeValue_u::MacCeValue_u(ns3::MacCeValue_u const & arg0) [constructor]
    cls.add_constructor([param('ns3::MacCeValue_u const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::MacCeValue_u::m_bufferStatus [variable]
    cls.add_instance_attribute('m_bufferStatus', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::MacCeValue_u::m_crnti [variable]
    cls.add_instance_attribute('m_crnti', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::MacCeValue_u::m_phr [variable]
    cls.add_instance_attribute('m_phr', 'uint8_t', is_const=False)
    return

def register_Ns3Names_methods(root_module, cls):
    ## names.h (module 'core'): ns3::Names::Names() [constructor]
    cls.add_constructor([])
    ## names.h (module 'core'): ns3::Names::Names(ns3::Names const & arg0) [constructor]
    cls.add_constructor([param('ns3::Names const &', 'arg0')])
    ## names.h (module 'core'): static void ns3::Names::Add(std::string name, ns3::Ptr<ns3::Object> object) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'name'), param('ns3::Ptr< ns3::Object >', 'object')], 
                   is_static=True)
    ## names.h (module 'core'): static void ns3::Names::Add(std::string path, std::string name, ns3::Ptr<ns3::Object> object) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'path'), param('std::string', 'name'), param('ns3::Ptr< ns3::Object >', 'object')], 
                   is_static=True)
    ## names.h (module 'core'): static void ns3::Names::Add(ns3::Ptr<ns3::Object> context, std::string name, ns3::Ptr<ns3::Object> object) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ptr< ns3::Object >', 'context'), param('std::string', 'name'), param('ns3::Ptr< ns3::Object >', 'object')], 
                   is_static=True)
    ## names.h (module 'core'): static void ns3::Names::Clear() [member function]
    cls.add_method('Clear', 
                   'void', 
                   [], 
                   is_static=True)
    ## names.h (module 'core'): static std::string ns3::Names::FindName(ns3::Ptr<ns3::Object> object) [member function]
    cls.add_method('FindName', 
                   'std::string', 
                   [param('ns3::Ptr< ns3::Object >', 'object')], 
                   is_static=True)
    ## names.h (module 'core'): static std::string ns3::Names::FindPath(ns3::Ptr<ns3::Object> object) [member function]
    cls.add_method('FindPath', 
                   'std::string', 
                   [param('ns3::Ptr< ns3::Object >', 'object')], 
                   is_static=True)
    ## names.h (module 'core'): static void ns3::Names::Rename(std::string oldpath, std::string newname) [member function]
    cls.add_method('Rename', 
                   'void', 
                   [param('std::string', 'oldpath'), param('std::string', 'newname')], 
                   is_static=True)
    ## names.h (module 'core'): static void ns3::Names::Rename(std::string path, std::string oldname, std::string newname) [member function]
    cls.add_method('Rename', 
                   'void', 
                   [param('std::string', 'path'), param('std::string', 'oldname'), param('std::string', 'newname')], 
                   is_static=True)
    ## names.h (module 'core'): static void ns3::Names::Rename(ns3::Ptr<ns3::Object> context, std::string oldname, std::string newname) [member function]
    cls.add_method('Rename', 
                   'void', 
                   [param('ns3::Ptr< ns3::Object >', 'context'), param('std::string', 'oldname'), param('std::string', 'newname')], 
                   is_static=True)
    return

def register_Ns3NetDeviceContainer_methods(root_module, cls):
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::NetDeviceContainer(ns3::NetDeviceContainer const & arg0) [constructor]
    cls.add_constructor([param('ns3::NetDeviceContainer const &', 'arg0')])
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::NetDeviceContainer() [constructor]
    cls.add_constructor([])
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::NetDeviceContainer(ns3::Ptr<ns3::NetDevice> dev) [constructor]
    cls.add_constructor([param('ns3::Ptr< ns3::NetDevice >', 'dev')])
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::NetDeviceContainer(std::string devName) [constructor]
    cls.add_constructor([param('std::string', 'devName')])
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::NetDeviceContainer(ns3::NetDeviceContainer const & a, ns3::NetDeviceContainer const & b) [constructor]
    cls.add_constructor([param('ns3::NetDeviceContainer const &', 'a'), param('ns3::NetDeviceContainer const &', 'b')])
    ## net-device-container.h (module 'network'): void ns3::NetDeviceContainer::Add(ns3::NetDeviceContainer other) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::NetDeviceContainer', 'other')])
    ## net-device-container.h (module 'network'): void ns3::NetDeviceContainer::Add(ns3::Ptr<ns3::NetDevice> device) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ptr< ns3::NetDevice >', 'device')])
    ## net-device-container.h (module 'network'): void ns3::NetDeviceContainer::Add(std::string deviceName) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'deviceName')])
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::Iterator ns3::NetDeviceContainer::Begin() const [member function]
    cls.add_method('Begin', 
                   'ns3::NetDeviceContainer::Iterator', 
                   [], 
                   is_const=True)
    ## net-device-container.h (module 'network'): ns3::NetDeviceContainer::Iterator ns3::NetDeviceContainer::End() const [member function]
    cls.add_method('End', 
                   'ns3::NetDeviceContainer::Iterator', 
                   [], 
                   is_const=True)
    ## net-device-container.h (module 'network'): ns3::Ptr<ns3::NetDevice> ns3::NetDeviceContainer::Get(uint32_t i) const [member function]
    cls.add_method('Get', 
                   'ns3::Ptr< ns3::NetDevice >', 
                   [param('uint32_t', 'i')], 
                   is_const=True)
    ## net-device-container.h (module 'network'): uint32_t ns3::NetDeviceContainer::GetN() const [member function]
    cls.add_method('GetN', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    return

def register_Ns3NodeContainer_methods(root_module, cls):
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(ns3::NodeContainer const & arg0) [constructor]
    cls.add_constructor([param('ns3::NodeContainer const &', 'arg0')])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer() [constructor]
    cls.add_constructor([])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(ns3::Ptr<ns3::Node> node) [constructor]
    cls.add_constructor([param('ns3::Ptr< ns3::Node >', 'node')])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(std::string nodeName) [constructor]
    cls.add_constructor([param('std::string', 'nodeName')])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(ns3::NodeContainer const & a, ns3::NodeContainer const & b) [constructor]
    cls.add_constructor([param('ns3::NodeContainer const &', 'a'), param('ns3::NodeContainer const &', 'b')])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(ns3::NodeContainer const & a, ns3::NodeContainer const & b, ns3::NodeContainer const & c) [constructor]
    cls.add_constructor([param('ns3::NodeContainer const &', 'a'), param('ns3::NodeContainer const &', 'b'), param('ns3::NodeContainer const &', 'c')])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(ns3::NodeContainer const & a, ns3::NodeContainer const & b, ns3::NodeContainer const & c, ns3::NodeContainer const & d) [constructor]
    cls.add_constructor([param('ns3::NodeContainer const &', 'a'), param('ns3::NodeContainer const &', 'b'), param('ns3::NodeContainer const &', 'c'), param('ns3::NodeContainer const &', 'd')])
    ## node-container.h (module 'network'): ns3::NodeContainer::NodeContainer(ns3::NodeContainer const & a, ns3::NodeContainer const & b, ns3::NodeContainer const & c, ns3::NodeContainer const & d, ns3::NodeContainer const & e) [constructor]
    cls.add_constructor([param('ns3::NodeContainer const &', 'a'), param('ns3::NodeContainer const &', 'b'), param('ns3::NodeContainer const &', 'c'), param('ns3::NodeContainer const &', 'd'), param('ns3::NodeContainer const &', 'e')])
    ## node-container.h (module 'network'): void ns3::NodeContainer::Add(ns3::NodeContainer other) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::NodeContainer', 'other')])
    ## node-container.h (module 'network'): void ns3::NodeContainer::Add(ns3::Ptr<ns3::Node> node) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Ptr< ns3::Node >', 'node')])
    ## node-container.h (module 'network'): void ns3::NodeContainer::Add(std::string nodeName) [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('std::string', 'nodeName')])
    ## node-container.h (module 'network'): ns3::NodeContainer::Iterator ns3::NodeContainer::Begin() const [member function]
    cls.add_method('Begin', 
                   'ns3::NodeContainer::Iterator', 
                   [], 
                   is_const=True)
    ## node-container.h (module 'network'): bool ns3::NodeContainer::Contains(uint32_t id) const [member function]
    cls.add_method('Contains', 
                   'bool', 
                   [param('uint32_t', 'id')], 
                   is_const=True)
    ## node-container.h (module 'network'): void ns3::NodeContainer::Create(uint32_t n) [member function]
    cls.add_method('Create', 
                   'void', 
                   [param('uint32_t', 'n')])
    ## node-container.h (module 'network'): void ns3::NodeContainer::Create(uint32_t n, uint32_t systemId) [member function]
    cls.add_method('Create', 
                   'void', 
                   [param('uint32_t', 'n'), param('uint32_t', 'systemId')])
    ## node-container.h (module 'network'): ns3::NodeContainer::Iterator ns3::NodeContainer::End() const [member function]
    cls.add_method('End', 
                   'ns3::NodeContainer::Iterator', 
                   [], 
                   is_const=True)
    ## node-container.h (module 'network'): ns3::Ptr<ns3::Node> ns3::NodeContainer::Get(uint32_t i) const [member function]
    cls.add_method('Get', 
                   'ns3::Ptr< ns3::Node >', 
                   [param('uint32_t', 'i')], 
                   is_const=True)
    ## node-container.h (module 'network'): static ns3::NodeContainer ns3::NodeContainer::GetGlobal() [member function]
    cls.add_method('GetGlobal', 
                   'ns3::NodeContainer', 
                   [], 
                   is_static=True)
    ## node-container.h (module 'network'): uint32_t ns3::NodeContainer::GetN() const [member function]
    cls.add_method('GetN', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    return

def register_Ns3ObjectBase_methods(root_module, cls):
    ## object-base.h (module 'core'): ns3::ObjectBase::ObjectBase() [constructor]
    cls.add_constructor([])
    ## object-base.h (module 'core'): ns3::ObjectBase::ObjectBase(ns3::ObjectBase const & arg0) [constructor]
    cls.add_constructor([param('ns3::ObjectBase const &', 'arg0')])
    ## object-base.h (module 'core'): void ns3::ObjectBase::GetAttribute(std::string name, ns3::AttributeValue & value) const [member function]
    cls.add_method('GetAttribute', 
                   'void', 
                   [param('std::string', 'name'), param('ns3::AttributeValue &', 'value')], 
                   is_const=True)
    ## object-base.h (module 'core'): bool ns3::ObjectBase::GetAttributeFailSafe(std::string name, ns3::AttributeValue & value) const [member function]
    cls.add_method('GetAttributeFailSafe', 
                   'bool', 
                   [param('std::string', 'name'), param('ns3::AttributeValue &', 'value')], 
                   is_const=True)
    ## object-base.h (module 'core'): ns3::TypeId ns3::ObjectBase::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## object-base.h (module 'core'): static ns3::TypeId ns3::ObjectBase::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## object-base.h (module 'core'): void ns3::ObjectBase::SetAttribute(std::string name, ns3::AttributeValue const & value) [member function]
    cls.add_method('SetAttribute', 
                   'void', 
                   [param('std::string', 'name'), param('ns3::AttributeValue const &', 'value')])
    ## object-base.h (module 'core'): bool ns3::ObjectBase::SetAttributeFailSafe(std::string name, ns3::AttributeValue const & value) [member function]
    cls.add_method('SetAttributeFailSafe', 
                   'bool', 
                   [param('std::string', 'name'), param('ns3::AttributeValue const &', 'value')])
    ## object-base.h (module 'core'): bool ns3::ObjectBase::TraceConnect(std::string name, std::string context, ns3::CallbackBase const & cb) [member function]
    cls.add_method('TraceConnect', 
                   'bool', 
                   [param('std::string', 'name'), param('std::string', 'context'), param('ns3::CallbackBase const &', 'cb')])
    ## object-base.h (module 'core'): bool ns3::ObjectBase::TraceConnectWithoutContext(std::string name, ns3::CallbackBase const & cb) [member function]
    cls.add_method('TraceConnectWithoutContext', 
                   'bool', 
                   [param('std::string', 'name'), param('ns3::CallbackBase const &', 'cb')])
    ## object-base.h (module 'core'): bool ns3::ObjectBase::TraceDisconnect(std::string name, std::string context, ns3::CallbackBase const & cb) [member function]
    cls.add_method('TraceDisconnect', 
                   'bool', 
                   [param('std::string', 'name'), param('std::string', 'context'), param('ns3::CallbackBase const &', 'cb')])
    ## object-base.h (module 'core'): bool ns3::ObjectBase::TraceDisconnectWithoutContext(std::string name, ns3::CallbackBase const & cb) [member function]
    cls.add_method('TraceDisconnectWithoutContext', 
                   'bool', 
                   [param('std::string', 'name'), param('ns3::CallbackBase const &', 'cb')])
    ## object-base.h (module 'core'): void ns3::ObjectBase::ConstructSelf(ns3::AttributeConstructionList const & attributes) [member function]
    cls.add_method('ConstructSelf', 
                   'void', 
                   [param('ns3::AttributeConstructionList const &', 'attributes')], 
                   visibility='protected')
    ## object-base.h (module 'core'): void ns3::ObjectBase::NotifyConstructionCompleted() [member function]
    cls.add_method('NotifyConstructionCompleted', 
                   'void', 
                   [], 
                   is_virtual=True, visibility='protected')
    return

def register_Ns3ObjectDeleter_methods(root_module, cls):
    ## object.h (module 'core'): ns3::ObjectDeleter::ObjectDeleter() [constructor]
    cls.add_constructor([])
    ## object.h (module 'core'): ns3::ObjectDeleter::ObjectDeleter(ns3::ObjectDeleter const & arg0) [constructor]
    cls.add_constructor([param('ns3::ObjectDeleter const &', 'arg0')])
    ## object.h (module 'core'): static void ns3::ObjectDeleter::Delete(ns3::Object * object) [member function]
    cls.add_method('Delete', 
                   'void', 
                   [param('ns3::Object *', 'object')], 
                   is_static=True)
    return

def register_Ns3ObjectFactory_methods(root_module, cls):
    cls.add_output_stream_operator()
    ## object-factory.h (module 'core'): ns3::ObjectFactory::ObjectFactory(ns3::ObjectFactory const & arg0) [constructor]
    cls.add_constructor([param('ns3::ObjectFactory const &', 'arg0')])
    ## object-factory.h (module 'core'): ns3::ObjectFactory::ObjectFactory() [constructor]
    cls.add_constructor([])
    ## object-factory.h (module 'core'): ns3::ObjectFactory::ObjectFactory(std::string typeId) [constructor]
    cls.add_constructor([param('std::string', 'typeId')])
    ## object-factory.h (module 'core'): ns3::Ptr<ns3::Object> ns3::ObjectFactory::Create() const [member function]
    cls.add_method('Create', 
                   'ns3::Ptr< ns3::Object >', 
                   [], 
                   is_const=True)
    ## object-factory.h (module 'core'): ns3::TypeId ns3::ObjectFactory::GetTypeId() const [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True)
    ## object-factory.h (module 'core'): bool ns3::ObjectFactory::IsTypeIdSet() const [member function]
    cls.add_method('IsTypeIdSet', 
                   'bool', 
                   [], 
                   is_const=True)
    ## object-factory.h (module 'core'): void ns3::ObjectFactory::Set(std::string name, ns3::AttributeValue const & value) [member function]
    cls.add_method('Set', 
                   'void', 
                   [param('std::string', 'name'), param('ns3::AttributeValue const &', 'value')])
    ## object-factory.h (module 'core'): void ns3::ObjectFactory::SetTypeId(ns3::TypeId tid) [member function]
    cls.add_method('SetTypeId', 
                   'void', 
                   [param('ns3::TypeId', 'tid')])
    ## object-factory.h (module 'core'): void ns3::ObjectFactory::SetTypeId(char const * tid) [member function]
    cls.add_method('SetTypeId', 
                   'void', 
                   [param('char const *', 'tid')])
    ## object-factory.h (module 'core'): void ns3::ObjectFactory::SetTypeId(std::string tid) [member function]
    cls.add_method('SetTypeId', 
                   'void', 
                   [param('std::string', 'tid')])
    return

def register_Ns3PacketMetadata_methods(root_module, cls):
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::PacketMetadata(uint64_t uid, uint32_t size) [constructor]
    cls.add_constructor([param('uint64_t', 'uid'), param('uint32_t', 'size')])
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::PacketMetadata(ns3::PacketMetadata const & o) [constructor]
    cls.add_constructor([param('ns3::PacketMetadata const &', 'o')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::AddAtEnd(ns3::PacketMetadata const & o) [member function]
    cls.add_method('AddAtEnd', 
                   'void', 
                   [param('ns3::PacketMetadata const &', 'o')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::AddHeader(ns3::Header const & header, uint32_t size) [member function]
    cls.add_method('AddHeader', 
                   'void', 
                   [param('ns3::Header const &', 'header'), param('uint32_t', 'size')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::AddPaddingAtEnd(uint32_t end) [member function]
    cls.add_method('AddPaddingAtEnd', 
                   'void', 
                   [param('uint32_t', 'end')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::AddTrailer(ns3::Trailer const & trailer, uint32_t size) [member function]
    cls.add_method('AddTrailer', 
                   'void', 
                   [param('ns3::Trailer const &', 'trailer'), param('uint32_t', 'size')])
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::ItemIterator ns3::PacketMetadata::BeginItem(ns3::Buffer buffer) const [member function]
    cls.add_method('BeginItem', 
                   'ns3::PacketMetadata::ItemIterator', 
                   [param('ns3::Buffer', 'buffer')], 
                   is_const=True)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata ns3::PacketMetadata::CreateFragment(uint32_t start, uint32_t end) const [member function]
    cls.add_method('CreateFragment', 
                   'ns3::PacketMetadata', 
                   [param('uint32_t', 'start'), param('uint32_t', 'end')], 
                   is_const=True)
    ## packet-metadata.h (module 'network'): uint32_t ns3::PacketMetadata::Deserialize(uint8_t const * buffer, uint32_t size) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('uint8_t const *', 'buffer'), param('uint32_t', 'size')])
    ## packet-metadata.h (module 'network'): static void ns3::PacketMetadata::Enable() [member function]
    cls.add_method('Enable', 
                   'void', 
                   [], 
                   is_static=True)
    ## packet-metadata.h (module 'network'): static void ns3::PacketMetadata::EnableChecking() [member function]
    cls.add_method('EnableChecking', 
                   'void', 
                   [], 
                   is_static=True)
    ## packet-metadata.h (module 'network'): uint32_t ns3::PacketMetadata::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## packet-metadata.h (module 'network'): uint64_t ns3::PacketMetadata::GetUid() const [member function]
    cls.add_method('GetUid', 
                   'uint64_t', 
                   [], 
                   is_const=True)
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::RemoveAtEnd(uint32_t end) [member function]
    cls.add_method('RemoveAtEnd', 
                   'void', 
                   [param('uint32_t', 'end')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::RemoveAtStart(uint32_t start) [member function]
    cls.add_method('RemoveAtStart', 
                   'void', 
                   [param('uint32_t', 'start')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::RemoveHeader(ns3::Header const & header, uint32_t size) [member function]
    cls.add_method('RemoveHeader', 
                   'void', 
                   [param('ns3::Header const &', 'header'), param('uint32_t', 'size')])
    ## packet-metadata.h (module 'network'): void ns3::PacketMetadata::RemoveTrailer(ns3::Trailer const & trailer, uint32_t size) [member function]
    cls.add_method('RemoveTrailer', 
                   'void', 
                   [param('ns3::Trailer const &', 'trailer'), param('uint32_t', 'size')])
    ## packet-metadata.h (module 'network'): uint32_t ns3::PacketMetadata::Serialize(uint8_t * buffer, uint32_t maxSize) const [member function]
    cls.add_method('Serialize', 
                   'uint32_t', 
                   [param('uint8_t *', 'buffer'), param('uint32_t', 'maxSize')], 
                   is_const=True)
    return

def register_Ns3PacketMetadataItem_methods(root_module, cls):
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::Item() [constructor]
    cls.add_constructor([])
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::Item(ns3::PacketMetadata::Item const & arg0) [constructor]
    cls.add_constructor([param('ns3::PacketMetadata::Item const &', 'arg0')])
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::current [variable]
    cls.add_instance_attribute('current', 'ns3::Buffer::Iterator', is_const=False)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::currentSize [variable]
    cls.add_instance_attribute('currentSize', 'uint32_t', is_const=False)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::currentTrimedFromEnd [variable]
    cls.add_instance_attribute('currentTrimedFromEnd', 'uint32_t', is_const=False)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::currentTrimedFromStart [variable]
    cls.add_instance_attribute('currentTrimedFromStart', 'uint32_t', is_const=False)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::isFragment [variable]
    cls.add_instance_attribute('isFragment', 'bool', is_const=False)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::tid [variable]
    cls.add_instance_attribute('tid', 'ns3::TypeId', is_const=False)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item::type [variable]
    cls.add_instance_attribute('type', 'ns3::PacketMetadata::Item::ItemType', is_const=False)
    return

def register_Ns3PacketMetadataItemIterator_methods(root_module, cls):
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::ItemIterator::ItemIterator(ns3::PacketMetadata::ItemIterator const & arg0) [constructor]
    cls.add_constructor([param('ns3::PacketMetadata::ItemIterator const &', 'arg0')])
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::ItemIterator::ItemIterator(ns3::PacketMetadata const * metadata, ns3::Buffer buffer) [constructor]
    cls.add_constructor([param('ns3::PacketMetadata const *', 'metadata'), param('ns3::Buffer', 'buffer')])
    ## packet-metadata.h (module 'network'): bool ns3::PacketMetadata::ItemIterator::HasNext() const [member function]
    cls.add_method('HasNext', 
                   'bool', 
                   [], 
                   is_const=True)
    ## packet-metadata.h (module 'network'): ns3::PacketMetadata::Item ns3::PacketMetadata::ItemIterator::Next() [member function]
    cls.add_method('Next', 
                   'ns3::PacketMetadata::Item', 
                   [])
    return

def register_Ns3PacketTagIterator_methods(root_module, cls):
    ## packet.h (module 'network'): ns3::PacketTagIterator::PacketTagIterator(ns3::PacketTagIterator const & arg0) [constructor]
    cls.add_constructor([param('ns3::PacketTagIterator const &', 'arg0')])
    ## packet.h (module 'network'): bool ns3::PacketTagIterator::HasNext() const [member function]
    cls.add_method('HasNext', 
                   'bool', 
                   [], 
                   is_const=True)
    ## packet.h (module 'network'): ns3::PacketTagIterator::Item ns3::PacketTagIterator::Next() [member function]
    cls.add_method('Next', 
                   'ns3::PacketTagIterator::Item', 
                   [])
    return

def register_Ns3PacketTagIteratorItem_methods(root_module, cls):
    ## packet.h (module 'network'): ns3::PacketTagIterator::Item::Item(ns3::PacketTagIterator::Item const & arg0) [constructor]
    cls.add_constructor([param('ns3::PacketTagIterator::Item const &', 'arg0')])
    ## packet.h (module 'network'): void ns3::PacketTagIterator::Item::GetTag(ns3::Tag & tag) const [member function]
    cls.add_method('GetTag', 
                   'void', 
                   [param('ns3::Tag &', 'tag')], 
                   is_const=True)
    ## packet.h (module 'network'): ns3::TypeId ns3::PacketTagIterator::Item::GetTypeId() const [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True)
    return

def register_Ns3PacketTagList_methods(root_module, cls):
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::PacketTagList() [constructor]
    cls.add_constructor([])
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::PacketTagList(ns3::PacketTagList const & o) [constructor]
    cls.add_constructor([param('ns3::PacketTagList const &', 'o')])
    ## packet-tag-list.h (module 'network'): void ns3::PacketTagList::Add(ns3::Tag const & tag) const [member function]
    cls.add_method('Add', 
                   'void', 
                   [param('ns3::Tag const &', 'tag')], 
                   is_const=True)
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData const * ns3::PacketTagList::Head() const [member function]
    cls.add_method('Head', 
                   'ns3::PacketTagList::TagData const *', 
                   [], 
                   is_const=True)
    ## packet-tag-list.h (module 'network'): bool ns3::PacketTagList::Peek(ns3::Tag & tag) const [member function]
    cls.add_method('Peek', 
                   'bool', 
                   [param('ns3::Tag &', 'tag')], 
                   is_const=True)
    ## packet-tag-list.h (module 'network'): bool ns3::PacketTagList::Remove(ns3::Tag & tag) [member function]
    cls.add_method('Remove', 
                   'bool', 
                   [param('ns3::Tag &', 'tag')])
    ## packet-tag-list.h (module 'network'): void ns3::PacketTagList::RemoveAll() [member function]
    cls.add_method('RemoveAll', 
                   'void', 
                   [])
    ## packet-tag-list.h (module 'network'): bool ns3::PacketTagList::Replace(ns3::Tag & tag) [member function]
    cls.add_method('Replace', 
                   'bool', 
                   [param('ns3::Tag &', 'tag')])
    return

def register_Ns3PacketTagListTagData_methods(root_module, cls):
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::TagData() [constructor]
    cls.add_constructor([])
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::TagData(ns3::PacketTagList::TagData const & arg0) [constructor]
    cls.add_constructor([param('ns3::PacketTagList::TagData const &', 'arg0')])
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::count [variable]
    cls.add_instance_attribute('count', 'uint32_t', is_const=False)
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::data [variable]
    cls.add_instance_attribute('data', 'uint8_t [ 1 ]', is_const=False)
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::next [variable]
    cls.add_instance_attribute('next', 'ns3::PacketTagList::TagData *', is_const=False)
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::size [variable]
    cls.add_instance_attribute('size', 'uint32_t', is_const=False)
    ## packet-tag-list.h (module 'network'): ns3::PacketTagList::TagData::tid [variable]
    cls.add_instance_attribute('tid', 'ns3::TypeId', is_const=False)
    return

def register_Ns3PagingInfoListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::PagingInfoListElement_s::PagingInfoListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::PagingInfoListElement_s::PagingInfoListElement_s(ns3::PagingInfoListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::PagingInfoListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::PagingInfoListElement_s::m_pagingIndex [variable]
    cls.add_instance_attribute('m_pagingIndex', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::PagingInfoListElement_s::m_pagingMessageSize [variable]
    cls.add_instance_attribute('m_pagingMessageSize', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::PagingInfoListElement_s::m_pagingSubframe [variable]
    cls.add_instance_attribute('m_pagingSubframe', 'uint8_t', is_const=False)
    return

def register_Ns3ParameterLogger_methods(root_module, cls):
    ## log.h (module 'core'): ns3::ParameterLogger::ParameterLogger(ns3::ParameterLogger const & arg0) [constructor]
    cls.add_constructor([param('ns3::ParameterLogger const &', 'arg0')])
    ## log.h (module 'core'): ns3::ParameterLogger::ParameterLogger(std::ostream & os) [constructor]
    cls.add_constructor([param('std::ostream &', 'os')])
    return

def register_Ns3PhichListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::PhichListElement_s::PhichListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::PhichListElement_s::PhichListElement_s(ns3::PhichListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::PhichListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::PhichListElement_s::m_phich [variable]
    cls.add_instance_attribute('m_phich', 'ns3::PhichListElement_s::Phich_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::PhichListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3PhyReceptionStatParameters_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::PhyReceptionStatParameters() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::PhyReceptionStatParameters(ns3::PhyReceptionStatParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::PhyReceptionStatParameters const &', 'arg0')])
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_ccId [variable]
    cls.add_instance_attribute('m_ccId', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_cellId [variable]
    cls.add_instance_attribute('m_cellId', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_correctness [variable]
    cls.add_instance_attribute('m_correctness', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_imsi [variable]
    cls.add_instance_attribute('m_imsi', 'uint64_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_layer [variable]
    cls.add_instance_attribute('m_layer', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_mcs [variable]
    cls.add_instance_attribute('m_mcs', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_ndi [variable]
    cls.add_instance_attribute('m_ndi', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_rv [variable]
    cls.add_instance_attribute('m_rv', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_size [variable]
    cls.add_instance_attribute('m_size', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_timestamp [variable]
    cls.add_instance_attribute('m_timestamp', 'int64_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyReceptionStatParameters::m_txMode [variable]
    cls.add_instance_attribute('m_txMode', 'uint8_t', is_const=False)
    return

def register_Ns3PhyTransmissionStatParameters_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::PhyTransmissionStatParameters() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::PhyTransmissionStatParameters(ns3::PhyTransmissionStatParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::PhyTransmissionStatParameters const &', 'arg0')])
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_ccId [variable]
    cls.add_instance_attribute('m_ccId', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_cellId [variable]
    cls.add_instance_attribute('m_cellId', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_imsi [variable]
    cls.add_instance_attribute('m_imsi', 'uint64_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_layer [variable]
    cls.add_instance_attribute('m_layer', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_mcs [variable]
    cls.add_instance_attribute('m_mcs', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_ndi [variable]
    cls.add_instance_attribute('m_ndi', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_rv [variable]
    cls.add_instance_attribute('m_rv', 'uint8_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_size [variable]
    cls.add_instance_attribute('m_size', 'uint16_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_timestamp [variable]
    cls.add_instance_attribute('m_timestamp', 'int64_t', is_const=False)
    ## lte-common.h (module 'lte'): ns3::PhyTransmissionStatParameters::m_txMode [variable]
    cls.add_instance_attribute('m_txMode', 'uint8_t', is_const=False)
    return

def register_Ns3RachListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::RachListElement_s::RachListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::RachListElement_s::RachListElement_s(ns3::RachListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::RachListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::RachListElement_s::m_estimatedSize [variable]
    cls.add_instance_attribute('m_estimatedSize', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::RachListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3RadioBearerStatsConnector_methods(root_module, cls):
    ## radio-bearer-stats-connector.h (module 'lte'): ns3::RadioBearerStatsConnector::RadioBearerStatsConnector(ns3::RadioBearerStatsConnector const & arg0) [constructor]
    cls.add_constructor([param('ns3::RadioBearerStatsConnector const &', 'arg0')])
    ## radio-bearer-stats-connector.h (module 'lte'): ns3::RadioBearerStatsConnector::RadioBearerStatsConnector() [constructor]
    cls.add_constructor([])
    ## radio-bearer-stats-connector.h (module 'lte'): static void ns3::RadioBearerStatsConnector::CreatedDrbEnb(ns3::RadioBearerStatsConnector * c, std::string context, uint64_t imsi, uint16_t cellid, uint16_t rnti, uint8_t lcid) [member function]
    cls.add_method('CreatedDrbEnb', 
                   'void', 
                   [param('ns3::RadioBearerStatsConnector *', 'c'), param('std::string', 'context'), param('uint64_t', 'imsi'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti'), param('uint8_t', 'lcid')], 
                   is_static=True)
    ## radio-bearer-stats-connector.h (module 'lte'): static void ns3::RadioBearerStatsConnector::CreatedDrbUe(ns3::RadioBearerStatsConnector * c, std::string context, uint64_t imsi, uint16_t cellid, uint16_t rnti, uint8_t lcid) [member function]
    cls.add_method('CreatedDrbUe', 
                   'void', 
                   [param('ns3::RadioBearerStatsConnector *', 'c'), param('std::string', 'context'), param('uint64_t', 'imsi'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti'), param('uint8_t', 'lcid')], 
                   is_static=True)
    ## radio-bearer-stats-connector.h (module 'lte'): static void ns3::RadioBearerStatsConnector::CreatedSrb1Ue(ns3::RadioBearerStatsConnector * c, std::string context, uint64_t imsi, uint16_t cellid, uint16_t rnti) [member function]
    cls.add_method('CreatedSrb1Ue', 
                   'void', 
                   [param('ns3::RadioBearerStatsConnector *', 'c'), param('std::string', 'context'), param('uint64_t', 'imsi'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti')], 
                   is_static=True)
    ## radio-bearer-stats-connector.h (module 'lte'): void ns3::RadioBearerStatsConnector::DisconnectTracesEnb(std::string context, uint64_t imsi, uint16_t cellid, uint16_t rnti) [member function]
    cls.add_method('DisconnectTracesEnb', 
                   'void', 
                   [param('std::string', 'context'), param('uint64_t', 'imsi'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti')])
    ## radio-bearer-stats-connector.h (module 'lte'): void ns3::RadioBearerStatsConnector::DisconnectTracesUe(std::string context, uint64_t imsi, uint16_t cellid, uint16_t rnti) [member function]
    cls.add_method('DisconnectTracesUe', 
                   'void', 
                   [param('std::string', 'context'), param('uint64_t', 'imsi'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti')])
    ## radio-bearer-stats-connector.h (module 'lte'): void ns3::RadioBearerStatsConnector::EnablePdcpStats(ns3::Ptr<ns3::RadioBearerStatsCalculator> pdcpStats) [member function]
    cls.add_method('EnablePdcpStats', 
                   'void', 
                   [param('ns3::Ptr< ns3::RadioBearerStatsCalculator >', 'pdcpStats')])
    ## radio-bearer-stats-connector.h (module 'lte'): void ns3::RadioBearerStatsConnector::EnableRlcStats(ns3::Ptr<ns3::RadioBearerStatsCalculator> rlcStats) [member function]
    cls.add_method('EnableRlcStats', 
                   'void', 
                   [param('ns3::Ptr< ns3::RadioBearerStatsCalculator >', 'rlcStats')])
    ## radio-bearer-stats-connector.h (module 'lte'): void ns3::RadioBearerStatsConnector::EnsureConnected() [member function]
    cls.add_method('EnsureConnected', 
                   'void', 
                   [])
    ## radio-bearer-stats-connector.h (module 'lte'): static void ns3::RadioBearerStatsConnector::NotifyNewUeContextEnb(ns3::RadioBearerStatsConnector * c, std::string context, uint16_t cellid, uint16_t rnti) [member function]
    cls.add_method('NotifyNewUeContextEnb', 
                   'void', 
                   [param('ns3::RadioBearerStatsConnector *', 'c'), param('std::string', 'context'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti')], 
                   is_static=True)
    ## radio-bearer-stats-connector.h (module 'lte'): static void ns3::RadioBearerStatsConnector::NotifyRandomAccessSuccessfulUe(ns3::RadioBearerStatsConnector * c, std::string context, uint64_t imsi, uint16_t cellid, uint16_t rnti) [member function]
    cls.add_method('NotifyRandomAccessSuccessfulUe', 
                   'void', 
                   [param('ns3::RadioBearerStatsConnector *', 'c'), param('std::string', 'context'), param('uint64_t', 'imsi'), param('uint16_t', 'cellid'), param('uint16_t', 'rnti')], 
                   is_static=True)
    return

def register_Ns3RealProtocolRlcSapUser_methods(root_module, cls):
    ## lte-rrc-protocol-real.h (module 'lte'): ns3::RealProtocolRlcSapUser::RealProtocolRlcSapUser(ns3::RealProtocolRlcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::RealProtocolRlcSapUser const &', 'arg0')])
    ## lte-rrc-protocol-real.h (module 'lte'): ns3::RealProtocolRlcSapUser::RealProtocolRlcSapUser(ns3::LteEnbRrcProtocolReal * pdcp, uint16_t rnti) [constructor]
    cls.add_constructor([param('ns3::LteEnbRrcProtocolReal *', 'pdcp'), param('uint16_t', 'rnti')])
    ## lte-rrc-protocol-real.h (module 'lte'): void ns3::RealProtocolRlcSapUser::ReceivePdcpPdu(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('ReceivePdcpPdu', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True)
    return

def register_Ns3RlcPduListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::RlcPduListElement_s::RlcPduListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::RlcPduListElement_s::RlcPduListElement_s(ns3::RlcPduListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::RlcPduListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::RlcPduListElement_s::m_logicalChannelIdentity [variable]
    cls.add_instance_attribute('m_logicalChannelIdentity', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::RlcPduListElement_s::m_size [variable]
    cls.add_instance_attribute('m_size', 'uint16_t', is_const=False)
    return

def register_Ns3SbMeasResult_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::SbMeasResult_s::SbMeasResult_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::SbMeasResult_s::SbMeasResult_s(ns3::SbMeasResult_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::SbMeasResult_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::SbMeasResult_s::m_bwPart [variable]
    cls.add_instance_attribute('m_bwPart', 'ns3::BwPart_s', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SbMeasResult_s::m_higherLayerSelected [variable]
    cls.add_instance_attribute('m_higherLayerSelected', 'std::vector< ns3::HigherLayerSelected_s >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SbMeasResult_s::m_ueSelected [variable]
    cls.add_instance_attribute('m_ueSelected', 'ns3::UeSelected_s', is_const=False)
    return

def register_Ns3SequenceNumber10_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_numeric_operator('+', root_module['ns3::SequenceNumber10'], root_module['ns3::SequenceNumber10'], param('uint16_t', 'right'))
    cls.add_binary_numeric_operator('-', root_module['ns3::SequenceNumber10'], root_module['ns3::SequenceNumber10'], param('uint16_t', 'right'))
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('<=')
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('>')
    cls.add_binary_comparison_operator('>=')
    ## lte-rlc-sequence-number.h (module 'lte'): ns3::SequenceNumber10::SequenceNumber10() [constructor]
    cls.add_constructor([])
    ## lte-rlc-sequence-number.h (module 'lte'): ns3::SequenceNumber10::SequenceNumber10(uint16_t value) [constructor]
    cls.add_constructor([param('uint16_t', 'value')])
    ## lte-rlc-sequence-number.h (module 'lte'): ns3::SequenceNumber10::SequenceNumber10(ns3::SequenceNumber10 const & value) [constructor]
    cls.add_constructor([param('ns3::SequenceNumber10 const &', 'value')])
    ## lte-rlc-sequence-number.h (module 'lte'): uint16_t ns3::SequenceNumber10::GetValue() const [member function]
    cls.add_method('GetValue', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-sequence-number.h (module 'lte'): void ns3::SequenceNumber10::SetModulusBase(ns3::SequenceNumber10 modulusBase) [member function]
    cls.add_method('SetModulusBase', 
                   'void', 
                   [param('ns3::SequenceNumber10', 'modulusBase')])
    ## lte-rlc-sequence-number.h (module 'lte'): void ns3::SequenceNumber10::SetModulusBase(uint16_t modulusBase) [member function]
    cls.add_method('SetModulusBase', 
                   'void', 
                   [param('uint16_t', 'modulusBase')])
    return

def register_Ns3SiConfiguration_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s::SiConfiguration_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s::SiConfiguration_s(ns3::SiConfiguration_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::SiConfiguration_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s::m_sfn [variable]
    cls.add_instance_attribute('m_sfn', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s::m_siMessageList [variable]
    cls.add_instance_attribute('m_siMessageList', 'std::vector< ns3::SiMessageListElement_s >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s::m_siWindowLength [variable]
    cls.add_instance_attribute('m_siWindowLength', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SiConfiguration_s::m_sib1Length [variable]
    cls.add_instance_attribute('m_sib1Length', 'uint16_t', is_const=False)
    return

def register_Ns3SiMessageListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::SiMessageListElement_s::SiMessageListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::SiMessageListElement_s::SiMessageListElement_s(ns3::SiMessageListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::SiMessageListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::SiMessageListElement_s::m_length [variable]
    cls.add_instance_attribute('m_length', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SiMessageListElement_s::m_periodicity [variable]
    cls.add_instance_attribute('m_periodicity', 'uint16_t', is_const=False)
    return

def register_Ns3SimpleRefCount__Ns3Object_Ns3ObjectBase_Ns3ObjectDeleter_methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter>::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter>::SimpleRefCount(ns3::SimpleRefCount<ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter> const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::Object, ns3::ObjectBase, ns3::ObjectDeleter > const &', 'o')])
    return

def register_Ns3Simulator_methods(root_module, cls):
    ## simulator.h (module 'core'): ns3::Simulator::Simulator(ns3::Simulator const & arg0) [constructor]
    cls.add_constructor([param('ns3::Simulator const &', 'arg0')])
    ## simulator.h (module 'core'): static void ns3::Simulator::Cancel(ns3::EventId const & id) [member function]
    cls.add_method('Cancel', 
                   'void', 
                   [param('ns3::EventId const &', 'id')], 
                   is_static=True)
    ## simulator.h (module 'core'): static void ns3::Simulator::Destroy() [member function]
    cls.add_method('Destroy', 
                   'void', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static uint32_t ns3::Simulator::GetContext() [member function]
    cls.add_method('GetContext', 
                   'uint32_t', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static ns3::Time ns3::Simulator::GetDelayLeft(ns3::EventId const & id) [member function]
    cls.add_method('GetDelayLeft', 
                   'ns3::Time', 
                   [param('ns3::EventId const &', 'id')], 
                   is_static=True)
    ## simulator.h (module 'core'): static uint64_t ns3::Simulator::GetEventCount() [member function]
    cls.add_method('GetEventCount', 
                   'uint64_t', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static ns3::Ptr<ns3::SimulatorImpl> ns3::Simulator::GetImplementation() [member function]
    cls.add_method('GetImplementation', 
                   'ns3::Ptr< ns3::SimulatorImpl >', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static ns3::Time ns3::Simulator::GetMaximumSimulationTime() [member function]
    cls.add_method('GetMaximumSimulationTime', 
                   'ns3::Time', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static uint32_t ns3::Simulator::GetSystemId() [member function]
    cls.add_method('GetSystemId', 
                   'uint32_t', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static bool ns3::Simulator::IsExpired(ns3::EventId const & id) [member function]
    cls.add_method('IsExpired', 
                   'bool', 
                   [param('ns3::EventId const &', 'id')], 
                   is_static=True)
    ## simulator.h (module 'core'): static bool ns3::Simulator::IsFinished() [member function]
    cls.add_method('IsFinished', 
                   'bool', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static ns3::Time ns3::Simulator::Now() [member function]
    cls.add_method('Now', 
                   'ns3::Time', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static void ns3::Simulator::Remove(ns3::EventId const & id) [member function]
    cls.add_method('Remove', 
                   'void', 
                   [param('ns3::EventId const &', 'id')], 
                   is_static=True)
    ## simulator.h (module 'core'): static void ns3::Simulator::SetImplementation(ns3::Ptr<ns3::SimulatorImpl> impl) [member function]
    cls.add_method('SetImplementation', 
                   'void', 
                   [param('ns3::Ptr< ns3::SimulatorImpl >', 'impl')], 
                   is_static=True)
    ## simulator.h (module 'core'): static void ns3::Simulator::SetScheduler(ns3::ObjectFactory schedulerFactory) [member function]
    cls.add_method('SetScheduler', 
                   'void', 
                   [param('ns3::ObjectFactory', 'schedulerFactory')], 
                   is_static=True)
    ## simulator.h (module 'core'): static void ns3::Simulator::Stop() [member function]
    cls.add_method('Stop', 
                   'void', 
                   [], 
                   is_static=True)
    ## simulator.h (module 'core'): static void ns3::Simulator::Stop(ns3::Time const & delay) [member function]
    cls.add_method('Stop', 
                   'void', 
                   [param('ns3::Time const &', 'delay')], 
                   is_static=True)
    return

def register_Ns3SpsConfig_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::SpsConfig_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::SpsConfig_s(ns3::SpsConfig_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::SpsConfig_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::m_implicitReleaseAfter [variable]
    cls.add_instance_attribute('m_implicitReleaseAfter', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::m_n1PucchAnPersistentList [variable]
    cls.add_instance_attribute('m_n1PucchAnPersistentList', 'std::vector< unsigned short >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::m_n1PucchAnPersistentListSize [variable]
    cls.add_instance_attribute('m_n1PucchAnPersistentListSize', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::m_numberOfConfSpsProcesses [variable]
    cls.add_instance_attribute('m_numberOfConfSpsProcesses', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::m_semiPersistSchedIntervalDl [variable]
    cls.add_instance_attribute('m_semiPersistSchedIntervalDl', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SpsConfig_s::m_semiPersistSchedIntervalUl [variable]
    cls.add_instance_attribute('m_semiPersistSchedIntervalUl', 'uint16_t', is_const=False)
    return

def register_Ns3SrConfig_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::SrConfig_s::SrConfig_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::SrConfig_s::SrConfig_s(ns3::SrConfig_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::SrConfig_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::SrConfig_s::m_action [variable]
    cls.add_instance_attribute('m_action', 'ns3::SetupRelease_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SrConfig_s::m_dsrTransMax [variable]
    cls.add_instance_attribute('m_dsrTransMax', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::SrConfig_s::m_schedInterval [variable]
    cls.add_instance_attribute('m_schedInterval', 'uint8_t', is_const=False)
    return

def register_Ns3SrListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::SrListElement_s::SrListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::SrListElement_s::SrListElement_s(ns3::SrListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::SrListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::SrListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3StatisticalSummary_methods(root_module, cls):
    ## data-calculator.h (module 'stats'): ns3::StatisticalSummary::StatisticalSummary() [constructor]
    cls.add_constructor([])
    ## data-calculator.h (module 'stats'): ns3::StatisticalSummary::StatisticalSummary(ns3::StatisticalSummary const & arg0) [constructor]
    cls.add_constructor([param('ns3::StatisticalSummary const &', 'arg0')])
    ## data-calculator.h (module 'stats'): long int ns3::StatisticalSummary::getCount() const [member function]
    cls.add_method('getCount', 
                   'long int', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getMax() const [member function]
    cls.add_method('getMax', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getMean() const [member function]
    cls.add_method('getMean', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getMin() const [member function]
    cls.add_method('getMin', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getSqrSum() const [member function]
    cls.add_method('getSqrSum', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getStddev() const [member function]
    cls.add_method('getStddev', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getSum() const [member function]
    cls.add_method('getSum', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## data-calculator.h (module 'stats'): double ns3::StatisticalSummary::getVariance() const [member function]
    cls.add_method('getVariance', 
                   'double', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3Tag_methods(root_module, cls):
    ## tag.h (module 'network'): ns3::Tag::Tag() [constructor]
    cls.add_constructor([])
    ## tag.h (module 'network'): ns3::Tag::Tag(ns3::Tag const & arg0) [constructor]
    cls.add_constructor([param('ns3::Tag const &', 'arg0')])
    ## tag.h (module 'network'): void ns3::Tag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True, is_pure_virtual=True)
    ## tag.h (module 'network'): uint32_t ns3::Tag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## tag.h (module 'network'): static ns3::TypeId ns3::Tag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## tag.h (module 'network'): void ns3::Tag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## tag.h (module 'network'): void ns3::Tag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3TagBuffer_methods(root_module, cls):
    ## tag-buffer.h (module 'network'): ns3::TagBuffer::TagBuffer(ns3::TagBuffer const & arg0) [constructor]
    cls.add_constructor([param('ns3::TagBuffer const &', 'arg0')])
    ## tag-buffer.h (module 'network'): ns3::TagBuffer::TagBuffer(uint8_t * start, uint8_t * end) [constructor]
    cls.add_constructor([param('uint8_t *', 'start'), param('uint8_t *', 'end')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::CopyFrom(ns3::TagBuffer o) [member function]
    cls.add_method('CopyFrom', 
                   'void', 
                   [param('ns3::TagBuffer', 'o')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::Read(uint8_t * buffer, uint32_t size) [member function]
    cls.add_method('Read', 
                   'void', 
                   [param('uint8_t *', 'buffer'), param('uint32_t', 'size')])
    ## tag-buffer.h (module 'network'): double ns3::TagBuffer::ReadDouble() [member function]
    cls.add_method('ReadDouble', 
                   'double', 
                   [])
    ## tag-buffer.h (module 'network'): uint16_t ns3::TagBuffer::ReadU16() [member function]
    cls.add_method('ReadU16', 
                   'uint16_t', 
                   [])
    ## tag-buffer.h (module 'network'): uint32_t ns3::TagBuffer::ReadU32() [member function]
    cls.add_method('ReadU32', 
                   'uint32_t', 
                   [])
    ## tag-buffer.h (module 'network'): uint64_t ns3::TagBuffer::ReadU64() [member function]
    cls.add_method('ReadU64', 
                   'uint64_t', 
                   [])
    ## tag-buffer.h (module 'network'): uint8_t ns3::TagBuffer::ReadU8() [member function]
    cls.add_method('ReadU8', 
                   'uint8_t', 
                   [])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::TrimAtEnd(uint32_t trim) [member function]
    cls.add_method('TrimAtEnd', 
                   'void', 
                   [param('uint32_t', 'trim')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::Write(uint8_t const * buffer, uint32_t size) [member function]
    cls.add_method('Write', 
                   'void', 
                   [param('uint8_t const *', 'buffer'), param('uint32_t', 'size')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::WriteDouble(double v) [member function]
    cls.add_method('WriteDouble', 
                   'void', 
                   [param('double', 'v')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::WriteU16(uint16_t v) [member function]
    cls.add_method('WriteU16', 
                   'void', 
                   [param('uint16_t', 'v')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::WriteU32(uint32_t v) [member function]
    cls.add_method('WriteU32', 
                   'void', 
                   [param('uint32_t', 'v')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::WriteU64(uint64_t v) [member function]
    cls.add_method('WriteU64', 
                   'void', 
                   [param('uint64_t', 'v')])
    ## tag-buffer.h (module 'network'): void ns3::TagBuffer::WriteU8(uint8_t v) [member function]
    cls.add_method('WriteU8', 
                   'void', 
                   [param('uint8_t', 'v')])
    return

def register_Ns3TbId_t_methods(root_module, cls):
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('==')
    ## lte-spectrum-phy.h (module 'lte'): ns3::TbId_t::TbId_t(ns3::TbId_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::TbId_t const &', 'arg0')])
    ## lte-spectrum-phy.h (module 'lte'): ns3::TbId_t::TbId_t() [constructor]
    cls.add_constructor([])
    ## lte-spectrum-phy.h (module 'lte'): ns3::TbId_t::TbId_t(uint16_t const a, uint8_t const b) [constructor]
    cls.add_constructor([param('uint16_t const', 'a'), param('uint8_t const', 'b')])
    ## lte-spectrum-phy.h (module 'lte'): ns3::TbId_t::m_layer [variable]
    cls.add_instance_attribute('m_layer', 'uint8_t', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::TbId_t::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    return

def register_Ns3TbStats_t_methods(root_module, cls):
    ## lte-mi-error-model.h (module 'lte'): ns3::TbStats_t::TbStats_t() [constructor]
    cls.add_constructor([])
    ## lte-mi-error-model.h (module 'lte'): ns3::TbStats_t::TbStats_t(ns3::TbStats_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::TbStats_t const &', 'arg0')])
    ## lte-mi-error-model.h (module 'lte'): ns3::TbStats_t::mi [variable]
    cls.add_instance_attribute('mi', 'double', is_const=False)
    ## lte-mi-error-model.h (module 'lte'): ns3::TbStats_t::tbler [variable]
    cls.add_instance_attribute('tbler', 'double', is_const=False)
    return

def register_Ns3TimeWithUnit_methods(root_module, cls):
    cls.add_output_stream_operator()
    ## nstime.h (module 'core'): ns3::TimeWithUnit::TimeWithUnit(ns3::TimeWithUnit const & arg0) [constructor]
    cls.add_constructor([param('ns3::TimeWithUnit const &', 'arg0')])
    ## nstime.h (module 'core'): ns3::TimeWithUnit::TimeWithUnit(ns3::Time const time, ns3::Time::Unit const unit) [constructor]
    cls.add_constructor([param('ns3::Time const', 'time'), param('ns3::Time::Unit const', 'unit')])
    return

def register_Ns3TransmissionModesLayers_methods(root_module, cls):
    ## lte-common.h (module 'lte'): ns3::TransmissionModesLayers::TransmissionModesLayers() [constructor]
    cls.add_constructor([])
    ## lte-common.h (module 'lte'): ns3::TransmissionModesLayers::TransmissionModesLayers(ns3::TransmissionModesLayers const & arg0) [constructor]
    cls.add_constructor([param('ns3::TransmissionModesLayers const &', 'arg0')])
    ## lte-common.h (module 'lte'): static uint8_t ns3::TransmissionModesLayers::TxMode2LayerNum(uint8_t txMode) [member function]
    cls.add_method('TxMode2LayerNum', 
                   'uint8_t', 
                   [param('uint8_t', 'txMode')], 
                   is_static=True)
    return

def register_Ns3TypeId_methods(root_module, cls):
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('!=')
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('<')
    ## type-id.h (module 'core'): ns3::TypeId::TypeId(char const * name) [constructor]
    cls.add_constructor([param('char const *', 'name')])
    ## type-id.h (module 'core'): ns3::TypeId::TypeId() [constructor]
    cls.add_constructor([])
    ## type-id.h (module 'core'): ns3::TypeId::TypeId(ns3::TypeId const & o) [constructor]
    cls.add_constructor([param('ns3::TypeId const &', 'o')])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::AddAttribute(std::string name, std::string help, ns3::AttributeValue const & initialValue, ns3::Ptr<const ns3::AttributeAccessor> accessor, ns3::Ptr<const ns3::AttributeChecker> checker, ns3::TypeId::SupportLevel supportLevel=::ns3::TypeId::SupportLevel::SUPPORTED, std::string const & supportMsg="") [member function]
    cls.add_method('AddAttribute', 
                   'ns3::TypeId', 
                   [param('std::string', 'name'), param('std::string', 'help'), param('ns3::AttributeValue const &', 'initialValue'), param('ns3::Ptr< ns3::AttributeAccessor const >', 'accessor'), param('ns3::Ptr< ns3::AttributeChecker const >', 'checker'), param('ns3::TypeId::SupportLevel', 'supportLevel', default_value='::ns3::TypeId::SupportLevel::SUPPORTED'), param('std::string const &', 'supportMsg', default_value='""')])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::AddAttribute(std::string name, std::string help, uint32_t flags, ns3::AttributeValue const & initialValue, ns3::Ptr<const ns3::AttributeAccessor> accessor, ns3::Ptr<const ns3::AttributeChecker> checker, ns3::TypeId::SupportLevel supportLevel=::ns3::TypeId::SupportLevel::SUPPORTED, std::string const & supportMsg="") [member function]
    cls.add_method('AddAttribute', 
                   'ns3::TypeId', 
                   [param('std::string', 'name'), param('std::string', 'help'), param('uint32_t', 'flags'), param('ns3::AttributeValue const &', 'initialValue'), param('ns3::Ptr< ns3::AttributeAccessor const >', 'accessor'), param('ns3::Ptr< ns3::AttributeChecker const >', 'checker'), param('ns3::TypeId::SupportLevel', 'supportLevel', default_value='::ns3::TypeId::SupportLevel::SUPPORTED'), param('std::string const &', 'supportMsg', default_value='""')])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::AddTraceSource(std::string name, std::string help, ns3::Ptr<const ns3::TraceSourceAccessor> accessor) [member function]
    cls.add_method('AddTraceSource', 
                   'ns3::TypeId', 
                   [param('std::string', 'name'), param('std::string', 'help'), param('ns3::Ptr< ns3::TraceSourceAccessor const >', 'accessor')], 
                   deprecated=True)
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::AddTraceSource(std::string name, std::string help, ns3::Ptr<const ns3::TraceSourceAccessor> accessor, std::string callback, ns3::TypeId::SupportLevel supportLevel=::ns3::TypeId::SupportLevel::SUPPORTED, std::string const & supportMsg="") [member function]
    cls.add_method('AddTraceSource', 
                   'ns3::TypeId', 
                   [param('std::string', 'name'), param('std::string', 'help'), param('ns3::Ptr< ns3::TraceSourceAccessor const >', 'accessor'), param('std::string', 'callback'), param('ns3::TypeId::SupportLevel', 'supportLevel', default_value='::ns3::TypeId::SupportLevel::SUPPORTED'), param('std::string const &', 'supportMsg', default_value='""')])
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation ns3::TypeId::GetAttribute(std::size_t i) const [member function]
    cls.add_method('GetAttribute', 
                   'ns3::TypeId::AttributeInformation', 
                   [param('std::size_t', 'i')], 
                   is_const=True)
    ## type-id.h (module 'core'): std::string ns3::TypeId::GetAttributeFullName(std::size_t i) const [member function]
    cls.add_method('GetAttributeFullName', 
                   'std::string', 
                   [param('std::size_t', 'i')], 
                   is_const=True)
    ## type-id.h (module 'core'): std::size_t ns3::TypeId::GetAttributeN() const [member function]
    cls.add_method('GetAttributeN', 
                   'std::size_t', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): ns3::Callback<ns3::ObjectBase *, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty> ns3::TypeId::GetConstructor() const [member function]
    cls.add_method('GetConstructor', 
                   'ns3::Callback< ns3::ObjectBase *, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty, ns3::empty >', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): std::string ns3::TypeId::GetGroupName() const [member function]
    cls.add_method('GetGroupName', 
                   'std::string', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): ns3::TypeId::hash_t ns3::TypeId::GetHash() const [member function]
    cls.add_method('GetHash', 
                   'ns3::TypeId::hash_t', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): std::string ns3::TypeId::GetName() const [member function]
    cls.add_method('GetName', 
                   'std::string', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::GetParent() const [member function]
    cls.add_method('GetParent', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): static ns3::TypeId ns3::TypeId::GetRegistered(uint16_t i) [member function]
    cls.add_method('GetRegistered', 
                   'ns3::TypeId', 
                   [param('uint16_t', 'i')], 
                   is_static=True)
    ## type-id.h (module 'core'): static uint16_t ns3::TypeId::GetRegisteredN() [member function]
    cls.add_method('GetRegisteredN', 
                   'uint16_t', 
                   [], 
                   is_static=True)
    ## type-id.h (module 'core'): std::size_t ns3::TypeId::GetSize() const [member function]
    cls.add_method('GetSize', 
                   'std::size_t', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation ns3::TypeId::GetTraceSource(std::size_t i) const [member function]
    cls.add_method('GetTraceSource', 
                   'ns3::TypeId::TraceSourceInformation', 
                   [param('std::size_t', 'i')], 
                   is_const=True)
    ## type-id.h (module 'core'): std::size_t ns3::TypeId::GetTraceSourceN() const [member function]
    cls.add_method('GetTraceSourceN', 
                   'std::size_t', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): uint16_t ns3::TypeId::GetUid() const [member function]
    cls.add_method('GetUid', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): bool ns3::TypeId::HasConstructor() const [member function]
    cls.add_method('HasConstructor', 
                   'bool', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): bool ns3::TypeId::HasParent() const [member function]
    cls.add_method('HasParent', 
                   'bool', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::HideFromDocumentation() [member function]
    cls.add_method('HideFromDocumentation', 
                   'ns3::TypeId', 
                   [])
    ## type-id.h (module 'core'): bool ns3::TypeId::IsChildOf(ns3::TypeId other) const [member function]
    cls.add_method('IsChildOf', 
                   'bool', 
                   [param('ns3::TypeId', 'other')], 
                   is_const=True)
    ## type-id.h (module 'core'): bool ns3::TypeId::LookupAttributeByName(std::string name, ns3::TypeId::AttributeInformation * info) const [member function]
    cls.add_method('LookupAttributeByName', 
                   'bool', 
                   [param('std::string', 'name'), param('ns3::TypeId::AttributeInformation *', 'info', transfer_ownership=False)], 
                   is_const=True)
    ## type-id.h (module 'core'): static ns3::TypeId ns3::TypeId::LookupByHash(ns3::TypeId::hash_t hash) [member function]
    cls.add_method('LookupByHash', 
                   'ns3::TypeId', 
                   [param('uint32_t', 'hash')], 
                   is_static=True)
    ## type-id.h (module 'core'): static bool ns3::TypeId::LookupByHashFailSafe(ns3::TypeId::hash_t hash, ns3::TypeId * tid) [member function]
    cls.add_method('LookupByHashFailSafe', 
                   'bool', 
                   [param('uint32_t', 'hash'), param('ns3::TypeId *', 'tid')], 
                   is_static=True)
    ## type-id.h (module 'core'): static ns3::TypeId ns3::TypeId::LookupByName(std::string name) [member function]
    cls.add_method('LookupByName', 
                   'ns3::TypeId', 
                   [param('std::string', 'name')], 
                   is_static=True)
    ## type-id.h (module 'core'): ns3::Ptr<const ns3::TraceSourceAccessor> ns3::TypeId::LookupTraceSourceByName(std::string name) const [member function]
    cls.add_method('LookupTraceSourceByName', 
                   'ns3::Ptr< ns3::TraceSourceAccessor const >', 
                   [param('std::string', 'name')], 
                   is_const=True)
    ## type-id.h (module 'core'): ns3::Ptr<const ns3::TraceSourceAccessor> ns3::TypeId::LookupTraceSourceByName(std::string name, ns3::TypeId::TraceSourceInformation * info) const [member function]
    cls.add_method('LookupTraceSourceByName', 
                   'ns3::Ptr< ns3::TraceSourceAccessor const >', 
                   [param('std::string', 'name'), param('ns3::TypeId::TraceSourceInformation *', 'info')], 
                   is_const=True)
    ## type-id.h (module 'core'): bool ns3::TypeId::MustHideFromDocumentation() const [member function]
    cls.add_method('MustHideFromDocumentation', 
                   'bool', 
                   [], 
                   is_const=True)
    ## type-id.h (module 'core'): bool ns3::TypeId::SetAttributeInitialValue(std::size_t i, ns3::Ptr<const ns3::AttributeValue> initialValue) [member function]
    cls.add_method('SetAttributeInitialValue', 
                   'bool', 
                   [param('std::size_t', 'i'), param('ns3::Ptr< ns3::AttributeValue const >', 'initialValue')])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::SetGroupName(std::string groupName) [member function]
    cls.add_method('SetGroupName', 
                   'ns3::TypeId', 
                   [param('std::string', 'groupName')])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::SetParent(ns3::TypeId tid) [member function]
    cls.add_method('SetParent', 
                   'ns3::TypeId', 
                   [param('ns3::TypeId', 'tid')])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::SetParent() [member function]
    cls.add_method('SetParent', 
                   'ns3::TypeId', 
                   [], 
                   template_parameters=['ns3::Object'])
    ## type-id.h (module 'core'): ns3::TypeId ns3::TypeId::SetSize(std::size_t size) [member function]
    cls.add_method('SetSize', 
                   'ns3::TypeId', 
                   [param('std::size_t', 'size')])
    ## type-id.h (module 'core'): void ns3::TypeId::SetUid(uint16_t uid) [member function]
    cls.add_method('SetUid', 
                   'void', 
                   [param('uint16_t', 'uid')])
    return

def register_Ns3TypeIdAttributeInformation_methods(root_module, cls):
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::AttributeInformation() [constructor]
    cls.add_constructor([])
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::AttributeInformation(ns3::TypeId::AttributeInformation const & arg0) [constructor]
    cls.add_constructor([param('ns3::TypeId::AttributeInformation const &', 'arg0')])
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::accessor [variable]
    cls.add_instance_attribute('accessor', 'ns3::Ptr< ns3::AttributeAccessor const >', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::checker [variable]
    cls.add_instance_attribute('checker', 'ns3::Ptr< ns3::AttributeChecker const >', is_const=False)
    cls.add_instance_attribute('flags', 'uint32_t', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::help [variable]
    cls.add_instance_attribute('help', 'std::string', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::initialValue [variable]
    cls.add_instance_attribute('initialValue', 'ns3::Ptr< ns3::AttributeValue const >', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::name [variable]
    cls.add_instance_attribute('name', 'std::string', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::originalInitialValue [variable]
    cls.add_instance_attribute('originalInitialValue', 'ns3::Ptr< ns3::AttributeValue const >', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::supportLevel [variable]
    cls.add_instance_attribute('supportLevel', 'ns3::TypeId::SupportLevel', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::AttributeInformation::supportMsg [variable]
    cls.add_instance_attribute('supportMsg', 'std::string', is_const=False)
    return

def register_Ns3TypeIdTraceSourceInformation_methods(root_module, cls):
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::TraceSourceInformation() [constructor]
    cls.add_constructor([])
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::TraceSourceInformation(ns3::TypeId::TraceSourceInformation const & arg0) [constructor]
    cls.add_constructor([param('ns3::TypeId::TraceSourceInformation const &', 'arg0')])
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::accessor [variable]
    cls.add_instance_attribute('accessor', 'ns3::Ptr< ns3::TraceSourceAccessor const >', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::callback [variable]
    cls.add_instance_attribute('callback', 'std::string', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::help [variable]
    cls.add_instance_attribute('help', 'std::string', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::name [variable]
    cls.add_instance_attribute('name', 'std::string', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::supportLevel [variable]
    cls.add_instance_attribute('supportLevel', 'ns3::TypeId::SupportLevel', is_const=False)
    ## type-id.h (module 'core'): ns3::TypeId::TraceSourceInformation::supportMsg [variable]
    cls.add_instance_attribute('supportMsg', 'std::string', is_const=False)
    return

def register_Ns3UeCapabilities_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::UeCapabilities_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::UeCapabilities_s(ns3::UeCapabilities_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::UeCapabilities_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::m_halfDuplex [variable]
    cls.add_instance_attribute('m_halfDuplex', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::m_intraSfHopping [variable]
    cls.add_instance_attribute('m_intraSfHopping', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::m_resAllocType1 [variable]
    cls.add_instance_attribute('m_resAllocType1', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::m_type2Sb1 [variable]
    cls.add_instance_attribute('m_type2Sb1', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UeCapabilities_s::m_ueCategory [variable]
    cls.add_instance_attribute('m_ueCategory', 'uint8_t', is_const=False)
    return

def register_Ns3UeSelected_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::UeSelected_s::UeSelected_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::UeSelected_s::UeSelected_s(ns3::UeSelected_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::UeSelected_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::UeSelected_s::m_sbCqi [variable]
    cls.add_instance_attribute('m_sbCqi', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UeSelected_s::m_sbList [variable]
    cls.add_instance_attribute('m_sbList', 'std::vector< unsigned char >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UeSelected_s::m_sbPmi [variable]
    cls.add_instance_attribute('m_sbPmi', 'uint8_t', is_const=False)
    return

def register_Ns3UlCqi_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::UlCqi_s::UlCqi_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::UlCqi_s::UlCqi_s(ns3::UlCqi_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::UlCqi_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::UlCqi_s::m_sinr [variable]
    cls.add_instance_attribute('m_sinr', 'std::vector< unsigned short >', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlCqi_s::m_type [variable]
    cls.add_instance_attribute('m_type', 'ns3::UlCqi_s::Type_e', is_const=False)
    return

def register_Ns3UlDciListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::UlDciListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::UlDciListElement_s(ns3::UlDciListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::UlDciListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_aggrLevel [variable]
    cls.add_instance_attribute('m_aggrLevel', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_cceIndex [variable]
    cls.add_instance_attribute('m_cceIndex', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_cqiRequest [variable]
    cls.add_instance_attribute('m_cqiRequest', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_dai [variable]
    cls.add_instance_attribute('m_dai', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_freqHopping [variable]
    cls.add_instance_attribute('m_freqHopping', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_hopping [variable]
    cls.add_instance_attribute('m_hopping', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_mcs [variable]
    cls.add_instance_attribute('m_mcs', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_n2Dmrs [variable]
    cls.add_instance_attribute('m_n2Dmrs', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_ndi [variable]
    cls.add_instance_attribute('m_ndi', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_pdcchPowerOffset [variable]
    cls.add_instance_attribute('m_pdcchPowerOffset', 'int8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_rbLen [variable]
    cls.add_instance_attribute('m_rbLen', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_rbStart [variable]
    cls.add_instance_attribute('m_rbStart', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_tbSize [variable]
    cls.add_instance_attribute('m_tbSize', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_tpc [variable]
    cls.add_instance_attribute('m_tpc', 'int8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_ueTxAntennaSelection [variable]
    cls.add_instance_attribute('m_ueTxAntennaSelection', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlDciListElement_s::m_ulIndex [variable]
    cls.add_instance_attribute('m_ulIndex', 'uint8_t', is_const=False)
    return

def register_Ns3UlGrant_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::UlGrant_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::UlGrant_s(ns3::UlGrant_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::UlGrant_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_cqiRequest [variable]
    cls.add_instance_attribute('m_cqiRequest', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_hopping [variable]
    cls.add_instance_attribute('m_hopping', 'bool', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_mcs [variable]
    cls.add_instance_attribute('m_mcs', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_rbLen [variable]
    cls.add_instance_attribute('m_rbLen', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_rbStart [variable]
    cls.add_instance_attribute('m_rbStart', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_tbSize [variable]
    cls.add_instance_attribute('m_tbSize', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_tpc [variable]
    cls.add_instance_attribute('m_tpc', 'int8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlGrant_s::m_ulDelay [variable]
    cls.add_instance_attribute('m_ulDelay', 'bool', is_const=False)
    return

def register_Ns3UlInfoListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::UlInfoListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::UlInfoListElement_s(ns3::UlInfoListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::UlInfoListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::m_receptionStatus [variable]
    cls.add_instance_attribute('m_receptionStatus', 'ns3::UlInfoListElement_s::ReceptionStatus_e', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::m_rnti [variable]
    cls.add_instance_attribute('m_rnti', 'uint16_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::m_tpc [variable]
    cls.add_instance_attribute('m_tpc', 'uint8_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::UlInfoListElement_s::m_ulReception [variable]
    cls.add_instance_attribute('m_ulReception', 'std::vector< unsigned short >', is_const=False)
    return

def register_Ns3UplinkLteGlobalPathlossDatabase_methods(root_module, cls):
    ## lte-global-pathloss-database.h (module 'lte'): ns3::UplinkLteGlobalPathlossDatabase::UplinkLteGlobalPathlossDatabase() [constructor]
    cls.add_constructor([])
    ## lte-global-pathloss-database.h (module 'lte'): ns3::UplinkLteGlobalPathlossDatabase::UplinkLteGlobalPathlossDatabase(ns3::UplinkLteGlobalPathlossDatabase const & arg0) [constructor]
    cls.add_constructor([param('ns3::UplinkLteGlobalPathlossDatabase const &', 'arg0')])
    ## lte-global-pathloss-database.h (module 'lte'): void ns3::UplinkLteGlobalPathlossDatabase::UpdatePathloss(std::string context, ns3::Ptr<const ns3::SpectrumPhy> txPhy, ns3::Ptr<const ns3::SpectrumPhy> rxPhy, double lossDb) [member function]
    cls.add_method('UpdatePathloss', 
                   'void', 
                   [param('std::string', 'context'), param('ns3::Ptr< ns3::SpectrumPhy const >', 'txPhy'), param('ns3::Ptr< ns3::SpectrumPhy const >', 'rxPhy'), param('double', 'lossDb')], 
                   is_virtual=True)
    return

def register_Ns3Vector2D_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('<')
    cls.add_binary_numeric_operator('-', root_module['ns3::Vector2D'], root_module['ns3::Vector2D'], param('ns3::Vector2D const &', 'right'))
    cls.add_binary_numeric_operator('+', root_module['ns3::Vector2D'], root_module['ns3::Vector2D'], param('ns3::Vector2D const &', 'right'))
    ## vector.h (module 'core'): ns3::Vector2D::Vector2D(ns3::Vector2D const & arg0) [constructor]
    cls.add_constructor([param('ns3::Vector2D const &', 'arg0')])
    ## vector.h (module 'core'): ns3::Vector2D::Vector2D(double _x, double _y) [constructor]
    cls.add_constructor([param('double', '_x'), param('double', '_y')])
    ## vector.h (module 'core'): ns3::Vector2D::Vector2D() [constructor]
    cls.add_constructor([])
    ## vector.h (module 'core'): double ns3::Vector2D::GetLength() const [member function]
    cls.add_method('GetLength', 
                   'double', 
                   [], 
                   is_const=True)
    ## vector.h (module 'core'): ns3::Vector2D::x [variable]
    cls.add_instance_attribute('x', 'double', is_const=False)
    ## vector.h (module 'core'): ns3::Vector2D::y [variable]
    cls.add_instance_attribute('y', 'double', is_const=False)
    return

def register_Ns3Vector3D_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('<')
    cls.add_binary_numeric_operator('-', root_module['ns3::Vector3D'], root_module['ns3::Vector3D'], param('ns3::Vector3D const &', 'right'))
    cls.add_binary_numeric_operator('+', root_module['ns3::Vector3D'], root_module['ns3::Vector3D'], param('ns3::Vector3D const &', 'right'))
    ## vector.h (module 'core'): ns3::Vector3D::Vector3D(ns3::Vector3D const & arg0) [constructor]
    cls.add_constructor([param('ns3::Vector3D const &', 'arg0')])
    ## vector.h (module 'core'): ns3::Vector3D::Vector3D(double _x, double _y, double _z) [constructor]
    cls.add_constructor([param('double', '_x'), param('double', '_y'), param('double', '_z')])
    ## vector.h (module 'core'): ns3::Vector3D::Vector3D() [constructor]
    cls.add_constructor([])
    ## vector.h (module 'core'): double ns3::Vector3D::GetLength() const [member function]
    cls.add_method('GetLength', 
                   'double', 
                   [], 
                   is_const=True)
    ## vector.h (module 'core'): ns3::Vector3D::x [variable]
    cls.add_instance_attribute('x', 'double', is_const=False)
    ## vector.h (module 'core'): ns3::Vector3D::y [variable]
    cls.add_instance_attribute('y', 'double', is_const=False)
    ## vector.h (module 'core'): ns3::Vector3D::z [variable]
    cls.add_instance_attribute('z', 'double', is_const=False)
    return

def register_Ns3VendorSpecificListElement_s_methods(root_module, cls):
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificListElement_s::VendorSpecificListElement_s() [constructor]
    cls.add_constructor([])
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificListElement_s::VendorSpecificListElement_s(ns3::VendorSpecificListElement_s const & arg0) [constructor]
    cls.add_constructor([param('ns3::VendorSpecificListElement_s const &', 'arg0')])
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificListElement_s::m_length [variable]
    cls.add_instance_attribute('m_length', 'uint32_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificListElement_s::m_type [variable]
    cls.add_instance_attribute('m_type', 'uint32_t', is_const=False)
    ## ff-mac-common.h (module 'lte'): ns3::VendorSpecificListElement_s::m_value [variable]
    cls.add_instance_attribute('m_value', 'ns3::Ptr< ns3::VendorSpecificValue >', is_const=False)
    return

def register_Ns3Empty_methods(root_module, cls):
    ## empty.h (module 'core'): ns3::empty::empty() [constructor]
    cls.add_constructor([])
    ## empty.h (module 'core'): ns3::empty::empty(ns3::empty const & arg0) [constructor]
    cls.add_constructor([param('ns3::empty const &', 'arg0')])
    return

def register_Ns3FdbetsFlowPerf_t_methods(root_module, cls):
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t::fdbetsFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t::fdbetsFlowPerf_t(ns3::fdbetsFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::fdbetsFlowPerf_t const &', 'arg0')])
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t::lastAveragedThroughput [variable]
    cls.add_instance_attribute('lastAveragedThroughput', 'double', is_const=False)
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t::lastTtiBytesTrasmitted [variable]
    cls.add_instance_attribute('lastTtiBytesTrasmitted', 'unsigned int', is_const=False)
    ## fdbet-ff-mac-scheduler.h (module 'lte'): ns3::fdbetsFlowPerf_t::totalBytesTransmitted [variable]
    cls.add_instance_attribute('totalBytesTransmitted', 'long unsigned int', is_const=False)
    return

def register_Ns3FdtbfqsFlowPerf_t_methods(root_module, cls):
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::fdtbfqsFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::fdtbfqsFlowPerf_t(ns3::fdtbfqsFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::fdtbfqsFlowPerf_t const &', 'arg0')])
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::burstCredit [variable]
    cls.add_instance_attribute('burstCredit', 'uint32_t', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::counter [variable]
    cls.add_instance_attribute('counter', 'int', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::creditableThreshold [variable]
    cls.add_instance_attribute('creditableThreshold', 'uint32_t', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::debtLimit [variable]
    cls.add_instance_attribute('debtLimit', 'int', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::maxTokenPoolSize [variable]
    cls.add_instance_attribute('maxTokenPoolSize', 'uint32_t', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::packetArrivalRate [variable]
    cls.add_instance_attribute('packetArrivalRate', 'uint64_t', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::tokenGenerationRate [variable]
    cls.add_instance_attribute('tokenGenerationRate', 'uint64_t', is_const=False)
    ## fdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::fdtbfqsFlowPerf_t::tokenPoolSize [variable]
    cls.add_instance_attribute('tokenPoolSize', 'uint32_t', is_const=False)
    return

def register_Ns3Int64x64_t_methods(root_module, cls):
    cls.add_binary_numeric_operator('*', root_module['ns3::Time'], root_module['ns3::int64x64_t'], param('ns3::Time const &', 'right'))
    cls.add_binary_numeric_operator('+', root_module['ns3::int64x64_t'], root_module['ns3::int64x64_t'], param('ns3::int64x64_t const &', 'right'))
    cls.add_binary_numeric_operator('-', root_module['ns3::int64x64_t'], root_module['ns3::int64x64_t'], param('ns3::int64x64_t const &', 'right'))
    cls.add_binary_numeric_operator('*', root_module['ns3::int64x64_t'], root_module['ns3::int64x64_t'], param('ns3::int64x64_t const &', 'right'))
    cls.add_binary_numeric_operator('/', root_module['ns3::int64x64_t'], root_module['ns3::int64x64_t'], param('ns3::int64x64_t const &', 'right'))
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_comparison_operator('<=')
    cls.add_binary_comparison_operator('>=')
    cls.add_output_stream_operator()
    cls.add_binary_comparison_operator('==')
    cls.add_binary_comparison_operator('<')
    cls.add_binary_comparison_operator('>')
    cls.add_inplace_numeric_operator('+=', param('ns3::int64x64_t const &', 'right'))
    cls.add_inplace_numeric_operator('-=', param('ns3::int64x64_t const &', 'right'))
    cls.add_inplace_numeric_operator('*=', param('ns3::int64x64_t const &', 'right'))
    cls.add_inplace_numeric_operator('/=', param('ns3::int64x64_t const &', 'right'))
    cls.add_unary_numeric_operator('-')
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t() [constructor]
    cls.add_constructor([])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(double const value) [constructor]
    cls.add_constructor([param('double const', 'value')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(long double const value) [constructor]
    cls.add_constructor([param('long double const', 'value')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(int const v) [constructor]
    cls.add_constructor([param('int const', 'v')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(long int const v) [constructor]
    cls.add_constructor([param('long int const', 'v')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(long long int const v) [constructor]
    cls.add_constructor([param('long long int const', 'v')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(unsigned int const v) [constructor]
    cls.add_constructor([param('unsigned int const', 'v')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(long unsigned int const v) [constructor]
    cls.add_constructor([param('long unsigned int const', 'v')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(long long unsigned int const v) [constructor]
    cls.add_constructor([param('long long unsigned int const', 'v')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(int64_t const hi, uint64_t const lo) [constructor]
    cls.add_constructor([param('int64_t const', 'hi'), param('uint64_t const', 'lo')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::int64x64_t(ns3::int64x64_t const & o) [constructor]
    cls.add_constructor([param('ns3::int64x64_t const &', 'o')])
    ## int64x64-128.h (module 'core'): double ns3::int64x64_t::GetDouble() const [member function]
    cls.add_method('GetDouble', 
                   'double', 
                   [], 
                   is_const=True)
    ## int64x64-128.h (module 'core'): int64_t ns3::int64x64_t::GetHigh() const [member function]
    cls.add_method('GetHigh', 
                   'int64_t', 
                   [], 
                   is_const=True)
    ## int64x64-128.h (module 'core'): uint64_t ns3::int64x64_t::GetLow() const [member function]
    cls.add_method('GetLow', 
                   'uint64_t', 
                   [], 
                   is_const=True)
    ## int64x64-128.h (module 'core'): static ns3::int64x64_t ns3::int64x64_t::Invert(uint64_t const v) [member function]
    cls.add_method('Invert', 
                   'ns3::int64x64_t', 
                   [param('uint64_t const', 'v')], 
                   is_static=True)
    ## int64x64-128.h (module 'core'): void ns3::int64x64_t::MulByInvert(ns3::int64x64_t const & o) [member function]
    cls.add_method('MulByInvert', 
                   'void', 
                   [param('ns3::int64x64_t const &', 'o')])
    ## int64x64-128.h (module 'core'): ns3::int64x64_t::implementation [variable]
    cls.add_static_attribute('implementation', 'ns3::int64x64_t::impl_type const', is_const=True)
    return

def register_Ns3PfsFlowPerf_t_methods(root_module, cls):
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t::pfsFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t::pfsFlowPerf_t(ns3::pfsFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::pfsFlowPerf_t const &', 'arg0')])
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t::lastAveragedThroughput [variable]
    cls.add_instance_attribute('lastAveragedThroughput', 'double', is_const=False)
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t::lastTtiBytesTrasmitted [variable]
    cls.add_instance_attribute('lastTtiBytesTrasmitted', 'unsigned int', is_const=False)
    ## pf-ff-mac-scheduler.h (module 'lte'): ns3::pfsFlowPerf_t::totalBytesTransmitted [variable]
    cls.add_instance_attribute('totalBytesTransmitted', 'long unsigned int', is_const=False)
    return

def register_Ns3PssFlowPerf_t_methods(root_module, cls):
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::pssFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::pssFlowPerf_t(ns3::pssFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::pssFlowPerf_t const &', 'arg0')])
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::lastAveragedThroughput [variable]
    cls.add_instance_attribute('lastAveragedThroughput', 'double', is_const=False)
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::lastTtiBytesTransmitted [variable]
    cls.add_instance_attribute('lastTtiBytesTransmitted', 'unsigned int', is_const=False)
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::secondLastAveragedThroughput [variable]
    cls.add_instance_attribute('secondLastAveragedThroughput', 'double', is_const=False)
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::targetThroughput [variable]
    cls.add_instance_attribute('targetThroughput', 'double', is_const=False)
    ## pss-ff-mac-scheduler.h (module 'lte'): ns3::pssFlowPerf_t::totalBytesTransmitted [variable]
    cls.add_instance_attribute('totalBytesTransmitted', 'long unsigned int', is_const=False)
    return

def register_Ns3TbInfo_t_methods(root_module, cls):
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::tbInfo_t() [constructor]
    cls.add_constructor([])
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::tbInfo_t(ns3::tbInfo_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::tbInfo_t const &', 'arg0')])
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::corrupt [variable]
    cls.add_instance_attribute('corrupt', 'bool', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::downlink [variable]
    cls.add_instance_attribute('downlink', 'bool', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::harqFeedbackSent [variable]
    cls.add_instance_attribute('harqFeedbackSent', 'bool', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::harqProcessId [variable]
    cls.add_instance_attribute('harqProcessId', 'uint8_t', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::mcs [variable]
    cls.add_instance_attribute('mcs', 'uint8_t', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::mi [variable]
    cls.add_instance_attribute('mi', 'double', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::ndi [variable]
    cls.add_instance_attribute('ndi', 'uint8_t', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::rbBitmap [variable]
    cls.add_instance_attribute('rbBitmap', 'std::vector< int >', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::rv [variable]
    cls.add_instance_attribute('rv', 'uint8_t', is_const=False)
    ## lte-spectrum-phy.h (module 'lte'): ns3::tbInfo_t::size [variable]
    cls.add_instance_attribute('size', 'uint16_t', is_const=False)
    return

def register_Ns3TdbetsFlowPerf_t_methods(root_module, cls):
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t::tdbetsFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t::tdbetsFlowPerf_t(ns3::tdbetsFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::tdbetsFlowPerf_t const &', 'arg0')])
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t::lastAveragedThroughput [variable]
    cls.add_instance_attribute('lastAveragedThroughput', 'double', is_const=False)
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t::lastTtiBytesTrasmitted [variable]
    cls.add_instance_attribute('lastTtiBytesTrasmitted', 'unsigned int', is_const=False)
    ## tdbet-ff-mac-scheduler.h (module 'lte'): ns3::tdbetsFlowPerf_t::totalBytesTransmitted [variable]
    cls.add_instance_attribute('totalBytesTransmitted', 'long unsigned int', is_const=False)
    return

def register_Ns3TdtbfqsFlowPerf_t_methods(root_module, cls):
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::tdtbfqsFlowPerf_t() [constructor]
    cls.add_constructor([])
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::tdtbfqsFlowPerf_t(ns3::tdtbfqsFlowPerf_t const & arg0) [constructor]
    cls.add_constructor([param('ns3::tdtbfqsFlowPerf_t const &', 'arg0')])
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::burstCredit [variable]
    cls.add_instance_attribute('burstCredit', 'uint32_t', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::counter [variable]
    cls.add_instance_attribute('counter', 'int', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::creditableThreshold [variable]
    cls.add_instance_attribute('creditableThreshold', 'uint32_t', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::debtLimit [variable]
    cls.add_instance_attribute('debtLimit', 'int', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::flowStart [variable]
    cls.add_instance_attribute('flowStart', 'ns3::Time', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::maxTokenPoolSize [variable]
    cls.add_instance_attribute('maxTokenPoolSize', 'uint32_t', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::packetArrivalRate [variable]
    cls.add_instance_attribute('packetArrivalRate', 'uint64_t', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::tokenGenerationRate [variable]
    cls.add_instance_attribute('tokenGenerationRate', 'uint64_t', is_const=False)
    ## tdtbfq-ff-mac-scheduler.h (module 'lte'): ns3::tdtbfqsFlowPerf_t::tokenPoolSize [variable]
    cls.add_instance_attribute('tokenPoolSize', 'uint32_t', is_const=False)
    return

def register_Ns3Chunk_methods(root_module, cls):
    ## chunk.h (module 'network'): ns3::Chunk::Chunk() [constructor]
    cls.add_constructor([])
    ## chunk.h (module 'network'): ns3::Chunk::Chunk(ns3::Chunk const & arg0) [constructor]
    cls.add_constructor([param('ns3::Chunk const &', 'arg0')])
    ## chunk.h (module 'network'): uint32_t ns3::Chunk::Deserialize(ns3::Buffer::Iterator start) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_virtual=True, is_pure_virtual=True)
    ## chunk.h (module 'network'): uint32_t ns3::Chunk::Deserialize(ns3::Buffer::Iterator start, ns3::Buffer::Iterator end) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start'), param('ns3::Buffer::Iterator', 'end')], 
                   is_virtual=True)
    ## chunk.h (module 'network'): static ns3::TypeId ns3::Chunk::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## chunk.h (module 'network'): void ns3::Chunk::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3DownlinkLteGlobalPathlossDatabase_methods(root_module, cls):
    ## lte-global-pathloss-database.h (module 'lte'): ns3::DownlinkLteGlobalPathlossDatabase::DownlinkLteGlobalPathlossDatabase() [constructor]
    cls.add_constructor([])
    ## lte-global-pathloss-database.h (module 'lte'): ns3::DownlinkLteGlobalPathlossDatabase::DownlinkLteGlobalPathlossDatabase(ns3::DownlinkLteGlobalPathlossDatabase const & arg0) [constructor]
    cls.add_constructor([param('ns3::DownlinkLteGlobalPathlossDatabase const &', 'arg0')])
    ## lte-global-pathloss-database.h (module 'lte'): void ns3::DownlinkLteGlobalPathlossDatabase::UpdatePathloss(std::string context, ns3::Ptr<const ns3::SpectrumPhy> txPhy, ns3::Ptr<const ns3::SpectrumPhy> rxPhy, double lossDb) [member function]
    cls.add_method('UpdatePathloss', 
                   'void', 
                   [param('std::string', 'context'), param('ns3::Ptr< ns3::SpectrumPhy const >', 'txPhy'), param('ns3::Ptr< ns3::SpectrumPhy const >', 'rxPhy'), param('double', 'lossDb')], 
                   is_virtual=True)
    return

def register_Ns3EpsBearer_methods(root_module, cls):
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::EpsBearer() [constructor]
    cls.add_constructor([])
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::EpsBearer(ns3::EpsBearer::Qci x) [constructor]
    cls.add_constructor([param('ns3::EpsBearer::Qci', 'x')])
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::EpsBearer(ns3::EpsBearer::Qci x, ns3::GbrQosInformation y) [constructor]
    cls.add_constructor([param('ns3::EpsBearer::Qci', 'x'), param('ns3::GbrQosInformation', 'y')])
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::EpsBearer(ns3::EpsBearer const & o) [constructor]
    cls.add_constructor([param('ns3::EpsBearer const &', 'o')])
    ## eps-bearer.h (module 'lte'): ns3::TypeId ns3::EpsBearer::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## eps-bearer.h (module 'lte'): uint16_t ns3::EpsBearer::GetPacketDelayBudgetMs() const [member function]
    cls.add_method('GetPacketDelayBudgetMs', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## eps-bearer.h (module 'lte'): double ns3::EpsBearer::GetPacketErrorLossRate() const [member function]
    cls.add_method('GetPacketErrorLossRate', 
                   'double', 
                   [], 
                   is_const=True)
    ## eps-bearer.h (module 'lte'): uint8_t ns3::EpsBearer::GetPriority() const [member function]
    cls.add_method('GetPriority', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## eps-bearer.h (module 'lte'): uint8_t ns3::EpsBearer::GetRelease() const [member function]
    cls.add_method('GetRelease', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## eps-bearer.h (module 'lte'): static ns3::TypeId ns3::EpsBearer::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## eps-bearer.h (module 'lte'): bool ns3::EpsBearer::IsGbr() const [member function]
    cls.add_method('IsGbr', 
                   'bool', 
                   [], 
                   is_const=True)
    ## eps-bearer.h (module 'lte'): void ns3::EpsBearer::SetRelease(uint8_t release) [member function]
    cls.add_method('SetRelease', 
                   'void', 
                   [param('uint8_t', 'release')])
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::arp [variable]
    cls.add_instance_attribute('arp', 'ns3::AllocationRetentionPriority', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::gbrQosInfo [variable]
    cls.add_instance_attribute('gbrQosInfo', 'ns3::GbrQosInformation', is_const=False)
    ## eps-bearer.h (module 'lte'): ns3::EpsBearer::qci [variable]
    cls.add_instance_attribute('qci', 'ns3::EpsBearer::Qci', is_const=False)
    return

def register_Ns3EpsBearerTag_methods(root_module, cls):
    ## eps-bearer-tag.h (module 'lte'): ns3::EpsBearerTag::EpsBearerTag(ns3::EpsBearerTag const & arg0) [constructor]
    cls.add_constructor([param('ns3::EpsBearerTag const &', 'arg0')])
    ## eps-bearer-tag.h (module 'lte'): ns3::EpsBearerTag::EpsBearerTag() [constructor]
    cls.add_constructor([])
    ## eps-bearer-tag.h (module 'lte'): ns3::EpsBearerTag::EpsBearerTag(uint16_t rnti, uint8_t bid) [constructor]
    cls.add_constructor([param('uint16_t', 'rnti'), param('uint8_t', 'bid')])
    ## eps-bearer-tag.h (module 'lte'): void ns3::EpsBearerTag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True)
    ## eps-bearer-tag.h (module 'lte'): uint8_t ns3::EpsBearerTag::GetBid() const [member function]
    cls.add_method('GetBid', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## eps-bearer-tag.h (module 'lte'): ns3::TypeId ns3::EpsBearerTag::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## eps-bearer-tag.h (module 'lte'): uint16_t ns3::EpsBearerTag::GetRnti() const [member function]
    cls.add_method('GetRnti', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## eps-bearer-tag.h (module 'lte'): uint32_t ns3::EpsBearerTag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## eps-bearer-tag.h (module 'lte'): static ns3::TypeId ns3::EpsBearerTag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## eps-bearer-tag.h (module 'lte'): void ns3::EpsBearerTag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## eps-bearer-tag.h (module 'lte'): void ns3::EpsBearerTag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True)
    ## eps-bearer-tag.h (module 'lte'): void ns3::EpsBearerTag::SetBid(uint8_t bid) [member function]
    cls.add_method('SetBid', 
                   'void', 
                   [param('uint8_t', 'bid')])
    ## eps-bearer-tag.h (module 'lte'): void ns3::EpsBearerTag::SetRnti(uint16_t rnti) [member function]
    cls.add_method('SetRnti', 
                   'void', 
                   [param('uint16_t', 'rnti')])
    return

def register_Ns3Header_methods(root_module, cls):
    cls.add_output_stream_operator()
    ## header.h (module 'network'): ns3::Header::Header() [constructor]
    cls.add_constructor([])
    ## header.h (module 'network'): ns3::Header::Header(ns3::Header const & arg0) [constructor]
    cls.add_constructor([param('ns3::Header const &', 'arg0')])
    ## header.h (module 'network'): uint32_t ns3::Header::Deserialize(ns3::Buffer::Iterator start) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_virtual=True, is_pure_virtual=True)
    ## header.h (module 'network'): uint32_t ns3::Header::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## header.h (module 'network'): static ns3::TypeId ns3::Header::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## header.h (module 'network'): void ns3::Header::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## header.h (module 'network'): void ns3::Header::Serialize(ns3::Buffer::Iterator start) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3Ipv4Header_methods(root_module, cls):
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header::Ipv4Header(ns3::Ipv4Header const & arg0) [constructor]
    cls.add_constructor([param('ns3::Ipv4Header const &', 'arg0')])
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header::Ipv4Header() [constructor]
    cls.add_constructor([])
    ## ipv4-header.h (module 'internet'): uint32_t ns3::Ipv4Header::Deserialize(ns3::Buffer::Iterator start) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_virtual=True)
    ## ipv4-header.h (module 'internet'): std::string ns3::Ipv4Header::DscpTypeToString(ns3::Ipv4Header::DscpType dscp) const [member function]
    cls.add_method('DscpTypeToString', 
                   'std::string', 
                   [param('ns3::Ipv4Header::DscpType', 'dscp')], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): std::string ns3::Ipv4Header::EcnTypeToString(ns3::Ipv4Header::EcnType ecn) const [member function]
    cls.add_method('EcnTypeToString', 
                   'std::string', 
                   [param('ns3::Ipv4Header::EcnType', 'ecn')], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::EnableChecksum() [member function]
    cls.add_method('EnableChecksum', 
                   'void', 
                   [])
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4Header::GetDestination() const [member function]
    cls.add_method('GetDestination', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header::DscpType ns3::Ipv4Header::GetDscp() const [member function]
    cls.add_method('GetDscp', 
                   'ns3::Ipv4Header::DscpType', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Header::EcnType ns3::Ipv4Header::GetEcn() const [member function]
    cls.add_method('GetEcn', 
                   'ns3::Ipv4Header::EcnType', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): uint16_t ns3::Ipv4Header::GetFragmentOffset() const [member function]
    cls.add_method('GetFragmentOffset', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): uint16_t ns3::Ipv4Header::GetIdentification() const [member function]
    cls.add_method('GetIdentification', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): ns3::TypeId ns3::Ipv4Header::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## ipv4-header.h (module 'internet'): uint16_t ns3::Ipv4Header::GetPayloadSize() const [member function]
    cls.add_method('GetPayloadSize', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): uint8_t ns3::Ipv4Header::GetProtocol() const [member function]
    cls.add_method('GetProtocol', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): uint32_t ns3::Ipv4Header::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## ipv4-header.h (module 'internet'): ns3::Ipv4Address ns3::Ipv4Header::GetSource() const [member function]
    cls.add_method('GetSource', 
                   'ns3::Ipv4Address', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): uint8_t ns3::Ipv4Header::GetTos() const [member function]
    cls.add_method('GetTos', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): uint8_t ns3::Ipv4Header::GetTtl() const [member function]
    cls.add_method('GetTtl', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): static ns3::TypeId ns3::Ipv4Header::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## ipv4-header.h (module 'internet'): bool ns3::Ipv4Header::IsChecksumOk() const [member function]
    cls.add_method('IsChecksumOk', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): bool ns3::Ipv4Header::IsDontFragment() const [member function]
    cls.add_method('IsDontFragment', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): bool ns3::Ipv4Header::IsLastFragment() const [member function]
    cls.add_method('IsLastFragment', 
                   'bool', 
                   [], 
                   is_const=True)
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::Serialize(ns3::Buffer::Iterator start) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_const=True, is_virtual=True)
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetDestination(ns3::Ipv4Address destination) [member function]
    cls.add_method('SetDestination', 
                   'void', 
                   [param('ns3::Ipv4Address', 'destination')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetDontFragment() [member function]
    cls.add_method('SetDontFragment', 
                   'void', 
                   [])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetDscp(ns3::Ipv4Header::DscpType dscp) [member function]
    cls.add_method('SetDscp', 
                   'void', 
                   [param('ns3::Ipv4Header::DscpType', 'dscp')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetEcn(ns3::Ipv4Header::EcnType ecn) [member function]
    cls.add_method('SetEcn', 
                   'void', 
                   [param('ns3::Ipv4Header::EcnType', 'ecn')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetFragmentOffset(uint16_t offsetBytes) [member function]
    cls.add_method('SetFragmentOffset', 
                   'void', 
                   [param('uint16_t', 'offsetBytes')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetIdentification(uint16_t identification) [member function]
    cls.add_method('SetIdentification', 
                   'void', 
                   [param('uint16_t', 'identification')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetLastFragment() [member function]
    cls.add_method('SetLastFragment', 
                   'void', 
                   [])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetMayFragment() [member function]
    cls.add_method('SetMayFragment', 
                   'void', 
                   [])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetMoreFragments() [member function]
    cls.add_method('SetMoreFragments', 
                   'void', 
                   [])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetPayloadSize(uint16_t size) [member function]
    cls.add_method('SetPayloadSize', 
                   'void', 
                   [param('uint16_t', 'size')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetProtocol(uint8_t num) [member function]
    cls.add_method('SetProtocol', 
                   'void', 
                   [param('uint8_t', 'num')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetSource(ns3::Ipv4Address source) [member function]
    cls.add_method('SetSource', 
                   'void', 
                   [param('ns3::Ipv4Address', 'source')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetTos(uint8_t tos) [member function]
    cls.add_method('SetTos', 
                   'void', 
                   [param('uint8_t', 'tos')])
    ## ipv4-header.h (module 'internet'): void ns3::Ipv4Header::SetTtl(uint8_t ttl) [member function]
    cls.add_method('SetTtl', 
                   'void', 
                   [param('uint8_t', 'ttl')])
    return

def register_Ns3LteCcmMacSapUser_methods(root_module, cls):
    ## lte-ccm-mac-sap.h (module 'lte'): ns3::LteCcmMacSapUser::LteCcmMacSapUser() [constructor]
    cls.add_constructor([])
    ## lte-ccm-mac-sap.h (module 'lte'): ns3::LteCcmMacSapUser::LteCcmMacSapUser(ns3::LteCcmMacSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteCcmMacSapUser const &', 'arg0')])
    ## lte-ccm-mac-sap.h (module 'lte'): void ns3::LteCcmMacSapUser::NotifyPrbOccupancy(double prbOccupancy, uint8_t componentCarrierId) [member function]
    cls.add_method('NotifyPrbOccupancy', 
                   'void', 
                   [param('double', 'prbOccupancy'), param('uint8_t', 'componentCarrierId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-mac-sap.h (module 'lte'): void ns3::LteCcmMacSapUser::UlReceiveMacCe(ns3::MacCeListElement_s bsr, uint8_t componentCarrierId) [member function]
    cls.add_method('UlReceiveMacCe', 
                   'void', 
                   [param('ns3::MacCeListElement_s', 'bsr'), param('uint8_t', 'componentCarrierId')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-ccm-mac-sap.h (module 'lte'): void ns3::LteCcmMacSapUser::UlReceiveSr(uint16_t rnti, uint8_t componentCarrierId) [member function]
    cls.add_method('UlReceiveSr', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('uint8_t', 'componentCarrierId')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbRrcSapProvider_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::LteEnbRrcSapProvider() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::LteEnbRrcSapProvider(ns3::LteEnbRrcSapProvider const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbRrcSapProvider const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::CompleteSetupUe(uint16_t rnti, ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters params) [member function]
    cls.add_method('CompleteSetupUe', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvIdealUeContextRemoveRequest(uint16_t rnti) [member function]
    cls.add_method('RecvIdealUeContextRemoveRequest', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvMeasurementReport(uint16_t rnti, ns3::LteRrcSap::MeasurementReport msg) [member function]
    cls.add_method('RecvMeasurementReport', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::MeasurementReport', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvRrcConnectionReconfigurationCompleted(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReconfigurationCompleted msg) [member function]
    cls.add_method('RecvRrcConnectionReconfigurationCompleted', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReconfigurationCompleted', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvRrcConnectionReestablishmentComplete(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReestablishmentComplete msg) [member function]
    cls.add_method('RecvRrcConnectionReestablishmentComplete', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReestablishmentComplete', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvRrcConnectionReestablishmentRequest(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReestablishmentRequest msg) [member function]
    cls.add_method('RecvRrcConnectionReestablishmentRequest', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReestablishmentRequest', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvRrcConnectionRequest(uint16_t rnti, ns3::LteRrcSap::RrcConnectionRequest msg) [member function]
    cls.add_method('RecvRrcConnectionRequest', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionRequest', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapProvider::RecvRrcConnectionSetupCompleted(uint16_t rnti, ns3::LteRrcSap::RrcConnectionSetupCompleted msg) [member function]
    cls.add_method('RecvRrcConnectionSetupCompleted', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionSetupCompleted', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbRrcSapProviderCompleteSetupUeParameters_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters::CompleteSetupUeParameters() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters::CompleteSetupUeParameters(ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters::srb0SapUser [variable]
    cls.add_instance_attribute('srb0SapUser', 'ns3::LteRlcSapUser *', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapProvider::CompleteSetupUeParameters::srb1SapUser [variable]
    cls.add_instance_attribute('srb1SapUser', 'ns3::LtePdcpSapUser *', is_const=False)
    return

def register_Ns3LteEnbRrcSapUser_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::LteEnbRrcSapUser() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::LteEnbRrcSapUser(ns3::LteEnbRrcSapUser const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbRrcSapUser const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::RrcConnectionReconfiguration ns3::LteEnbRrcSapUser::DecodeHandoverCommand(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('DecodeHandoverCommand', 
                   'ns3::LteRrcSap::RrcConnectionReconfiguration', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteRrcSap::HandoverPreparationInfo ns3::LteEnbRrcSapUser::DecodeHandoverPreparationInformation(ns3::Ptr<ns3::Packet> p) [member function]
    cls.add_method('DecodeHandoverPreparationInformation', 
                   'ns3::LteRrcSap::HandoverPreparationInfo', 
                   [param('ns3::Ptr< ns3::Packet >', 'p')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): ns3::Ptr<ns3::Packet> ns3::LteEnbRrcSapUser::EncodeHandoverCommand(ns3::LteRrcSap::RrcConnectionReconfiguration msg) [member function]
    cls.add_method('EncodeHandoverCommand', 
                   'ns3::Ptr< ns3::Packet >', 
                   [param('ns3::LteRrcSap::RrcConnectionReconfiguration', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): ns3::Ptr<ns3::Packet> ns3::LteEnbRrcSapUser::EncodeHandoverPreparationInformation(ns3::LteRrcSap::HandoverPreparationInfo msg) [member function]
    cls.add_method('EncodeHandoverPreparationInformation', 
                   'ns3::Ptr< ns3::Packet >', 
                   [param('ns3::LteRrcSap::HandoverPreparationInfo', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::RemoveUe(uint16_t rnti) [member function]
    cls.add_method('RemoveUe', 
                   'void', 
                   [param('uint16_t', 'rnti')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendRrcConnectionReconfiguration(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReconfiguration msg) [member function]
    cls.add_method('SendRrcConnectionReconfiguration', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReconfiguration', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendRrcConnectionReestablishment(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReestablishment msg) [member function]
    cls.add_method('SendRrcConnectionReestablishment', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReestablishment', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendRrcConnectionReestablishmentReject(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReestablishmentReject msg) [member function]
    cls.add_method('SendRrcConnectionReestablishmentReject', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReestablishmentReject', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendRrcConnectionReject(uint16_t rnti, ns3::LteRrcSap::RrcConnectionReject msg) [member function]
    cls.add_method('SendRrcConnectionReject', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionReject', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendRrcConnectionRelease(uint16_t rnti, ns3::LteRrcSap::RrcConnectionRelease msg) [member function]
    cls.add_method('SendRrcConnectionRelease', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionRelease', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendRrcConnectionSetup(uint16_t rnti, ns3::LteRrcSap::RrcConnectionSetup msg) [member function]
    cls.add_method('SendRrcConnectionSetup', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteRrcSap::RrcConnectionSetup', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SendSystemInformation(uint16_t cellId, ns3::LteRrcSap::SystemInformation msg) [member function]
    cls.add_method('SendSystemInformation', 
                   'void', 
                   [param('uint16_t', 'cellId'), param('ns3::LteRrcSap::SystemInformation', 'msg')], 
                   is_virtual=True, is_pure_virtual=True)
    ## lte-rrc-sap.h (module 'lte'): void ns3::LteEnbRrcSapUser::SetupUe(uint16_t rnti, ns3::LteEnbRrcSapUser::SetupUeParameters params) [member function]
    cls.add_method('SetupUe', 
                   'void', 
                   [param('uint16_t', 'rnti'), param('ns3::LteEnbRrcSapUser::SetupUeParameters', 'params')], 
                   is_virtual=True, is_pure_virtual=True)
    return

def register_Ns3LteEnbRrcSapUserSetupUeParameters_methods(root_module, cls):
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::SetupUeParameters::SetupUeParameters() [constructor]
    cls.add_constructor([])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::SetupUeParameters::SetupUeParameters(ns3::LteEnbRrcSapUser::SetupUeParameters const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteEnbRrcSapUser::SetupUeParameters const &', 'arg0')])
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::SetupUeParameters::srb0SapProvider [variable]
    cls.add_instance_attribute('srb0SapProvider', 'ns3::LteRlcSapProvider *', is_const=False)
    ## lte-rrc-sap.h (module 'lte'): ns3::LteEnbRrcSapUser::SetupUeParameters::srb1SapProvider [variable]
    cls.add_instance_attribute('srb1SapProvider', 'ns3::LtePdcpSapProvider *', is_const=False)
    return

def register_Ns3LtePdcpHeader_methods(root_module, cls):
    ## lte-pdcp-header.h (module 'lte'): ns3::LtePdcpHeader::LtePdcpHeader(ns3::LtePdcpHeader const & arg0) [constructor]
    cls.add_constructor([param('ns3::LtePdcpHeader const &', 'arg0')])
    ## lte-pdcp-header.h (module 'lte'): ns3::LtePdcpHeader::LtePdcpHeader() [constructor]
    cls.add_constructor([])
    ## lte-pdcp-header.h (module 'lte'): uint32_t ns3::LtePdcpHeader::Deserialize(ns3::Buffer::Iterator start) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_virtual=True)
    ## lte-pdcp-header.h (module 'lte'): uint8_t ns3::LtePdcpHeader::GetDcBit() const [member function]
    cls.add_method('GetDcBit', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-pdcp-header.h (module 'lte'): ns3::TypeId ns3::LtePdcpHeader::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-header.h (module 'lte'): uint16_t ns3::LtePdcpHeader::GetSequenceNumber() const [member function]
    cls.add_method('GetSequenceNumber', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## lte-pdcp-header.h (module 'lte'): uint32_t ns3::LtePdcpHeader::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-header.h (module 'lte'): static ns3::TypeId ns3::LtePdcpHeader::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-pdcp-header.h (module 'lte'): void ns3::LtePdcpHeader::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-header.h (module 'lte'): void ns3::LtePdcpHeader::Serialize(ns3::Buffer::Iterator start) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-header.h (module 'lte'): void ns3::LtePdcpHeader::SetDcBit(uint8_t dcBit) [member function]
    cls.add_method('SetDcBit', 
                   'void', 
                   [param('uint8_t', 'dcBit')])
    ## lte-pdcp-header.h (module 'lte'): void ns3::LtePdcpHeader::SetSequenceNumber(uint16_t sequenceNumber) [member function]
    cls.add_method('SetSequenceNumber', 
                   'void', 
                   [param('uint16_t', 'sequenceNumber')])
    return

def register_Ns3LtePhyTag_methods(root_module, cls):
    ## lte-phy-tag.h (module 'lte'): ns3::LtePhyTag::LtePhyTag(ns3::LtePhyTag const & arg0) [constructor]
    cls.add_constructor([param('ns3::LtePhyTag const &', 'arg0')])
    ## lte-phy-tag.h (module 'lte'): ns3::LtePhyTag::LtePhyTag() [constructor]
    cls.add_constructor([])
    ## lte-phy-tag.h (module 'lte'): ns3::LtePhyTag::LtePhyTag(uint16_t cellId) [constructor]
    cls.add_constructor([param('uint16_t', 'cellId')])
    ## lte-phy-tag.h (module 'lte'): void ns3::LtePhyTag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True)
    ## lte-phy-tag.h (module 'lte'): uint16_t ns3::LtePhyTag::GetCellId() const [member function]
    cls.add_method('GetCellId', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## lte-phy-tag.h (module 'lte'): ns3::TypeId ns3::LtePhyTag::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-phy-tag.h (module 'lte'): uint32_t ns3::LtePhyTag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-phy-tag.h (module 'lte'): static ns3::TypeId ns3::LtePhyTag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-phy-tag.h (module 'lte'): void ns3::LtePhyTag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-phy-tag.h (module 'lte'): void ns3::LtePhyTag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True)
    return

def register_Ns3LteRadioBearerTag_methods(root_module, cls):
    ## lte-radio-bearer-tag.h (module 'lte'): ns3::LteRadioBearerTag::LteRadioBearerTag(ns3::LteRadioBearerTag const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRadioBearerTag const &', 'arg0')])
    ## lte-radio-bearer-tag.h (module 'lte'): ns3::LteRadioBearerTag::LteRadioBearerTag() [constructor]
    cls.add_constructor([])
    ## lte-radio-bearer-tag.h (module 'lte'): ns3::LteRadioBearerTag::LteRadioBearerTag(uint16_t rnti, uint8_t lcId) [constructor]
    cls.add_constructor([param('uint16_t', 'rnti'), param('uint8_t', 'lcId')])
    ## lte-radio-bearer-tag.h (module 'lte'): ns3::LteRadioBearerTag::LteRadioBearerTag(uint16_t rnti, uint8_t lcId, uint8_t layer) [constructor]
    cls.add_constructor([param('uint16_t', 'rnti'), param('uint8_t', 'lcId'), param('uint8_t', 'layer')])
    ## lte-radio-bearer-tag.h (module 'lte'): void ns3::LteRadioBearerTag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True)
    ## lte-radio-bearer-tag.h (module 'lte'): ns3::TypeId ns3::LteRadioBearerTag::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-radio-bearer-tag.h (module 'lte'): uint8_t ns3::LteRadioBearerTag::GetLayer() const [member function]
    cls.add_method('GetLayer', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-radio-bearer-tag.h (module 'lte'): uint8_t ns3::LteRadioBearerTag::GetLcid() const [member function]
    cls.add_method('GetLcid', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-radio-bearer-tag.h (module 'lte'): uint16_t ns3::LteRadioBearerTag::GetRnti() const [member function]
    cls.add_method('GetRnti', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## lte-radio-bearer-tag.h (module 'lte'): uint32_t ns3::LteRadioBearerTag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-radio-bearer-tag.h (module 'lte'): static ns3::TypeId ns3::LteRadioBearerTag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-radio-bearer-tag.h (module 'lte'): void ns3::LteRadioBearerTag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-radio-bearer-tag.h (module 'lte'): void ns3::LteRadioBearerTag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True)
    ## lte-radio-bearer-tag.h (module 'lte'): void ns3::LteRadioBearerTag::SetLayer(uint8_t layer) [member function]
    cls.add_method('SetLayer', 
                   'void', 
                   [param('uint8_t', 'layer')])
    ## lte-radio-bearer-tag.h (module 'lte'): void ns3::LteRadioBearerTag::SetLcid(uint8_t lcid) [member function]
    cls.add_method('SetLcid', 
                   'void', 
                   [param('uint8_t', 'lcid')])
    ## lte-radio-bearer-tag.h (module 'lte'): void ns3::LteRadioBearerTag::SetRnti(uint16_t rnti) [member function]
    cls.add_method('SetRnti', 
                   'void', 
                   [param('uint16_t', 'rnti')])
    return

def register_Ns3LteRlcAmHeader_methods(root_module, cls):
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::LteRlcAmHeader(ns3::LteRlcAmHeader const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRlcAmHeader const &', 'arg0')])
    ## lte-rlc-am-header.h (module 'lte'): ns3::LteRlcAmHeader::LteRlcAmHeader() [constructor]
    cls.add_constructor([])
    ## lte-rlc-am-header.h (module 'lte'): uint32_t ns3::LteRlcAmHeader::Deserialize(ns3::Buffer::Iterator start) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_virtual=True)
    ## lte-rlc-am-header.h (module 'lte'): ns3::SequenceNumber10 ns3::LteRlcAmHeader::GetAckSn() const [member function]
    cls.add_method('GetAckSn', 
                   'ns3::SequenceNumber10', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): uint8_t ns3::LteRlcAmHeader::GetFramingInfo() const [member function]
    cls.add_method('GetFramingInfo', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): ns3::TypeId ns3::LteRlcAmHeader::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-am-header.h (module 'lte'): uint16_t ns3::LteRlcAmHeader::GetLastOffset() const [member function]
    cls.add_method('GetLastOffset', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): uint8_t ns3::LteRlcAmHeader::GetLastSegmentFlag() const [member function]
    cls.add_method('GetLastSegmentFlag', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): uint8_t ns3::LteRlcAmHeader::GetPollingBit() const [member function]
    cls.add_method('GetPollingBit', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): uint8_t ns3::LteRlcAmHeader::GetResegmentationFlag() const [member function]
    cls.add_method('GetResegmentationFlag', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): uint16_t ns3::LteRlcAmHeader::GetSegmentOffset() const [member function]
    cls.add_method('GetSegmentOffset', 
                   'uint16_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): ns3::SequenceNumber10 ns3::LteRlcAmHeader::GetSequenceNumber() const [member function]
    cls.add_method('GetSequenceNumber', 
                   'ns3::SequenceNumber10', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): uint32_t ns3::LteRlcAmHeader::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-am-header.h (module 'lte'): static ns3::TypeId ns3::LteRlcAmHeader::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-rlc-am-header.h (module 'lte'): bool ns3::LteRlcAmHeader::IsControlPdu() const [member function]
    cls.add_method('IsControlPdu', 
                   'bool', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): bool ns3::LteRlcAmHeader::IsDataPdu() const [member function]
    cls.add_method('IsDataPdu', 
                   'bool', 
                   [], 
                   is_const=True)
    ## lte-rlc-am-header.h (module 'lte'): bool ns3::LteRlcAmHeader::IsNackPresent(ns3::SequenceNumber10 nack) [member function]
    cls.add_method('IsNackPresent', 
                   'bool', 
                   [param('ns3::SequenceNumber10', 'nack')])
    ## lte-rlc-am-header.h (module 'lte'): bool ns3::LteRlcAmHeader::OneMoreNackWouldFitIn(uint16_t bytes) [member function]
    cls.add_method('OneMoreNackWouldFitIn', 
                   'bool', 
                   [param('uint16_t', 'bytes')])
    ## lte-rlc-am-header.h (module 'lte'): uint8_t ns3::LteRlcAmHeader::PopExtensionBit() [member function]
    cls.add_method('PopExtensionBit', 
                   'uint8_t', 
                   [])
    ## lte-rlc-am-header.h (module 'lte'): uint16_t ns3::LteRlcAmHeader::PopLengthIndicator() [member function]
    cls.add_method('PopLengthIndicator', 
                   'uint16_t', 
                   [])
    ## lte-rlc-am-header.h (module 'lte'): int ns3::LteRlcAmHeader::PopNack() [member function]
    cls.add_method('PopNack', 
                   'int', 
                   [])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::PushExtensionBit(uint8_t extensionBit) [member function]
    cls.add_method('PushExtensionBit', 
                   'void', 
                   [param('uint8_t', 'extensionBit')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::PushLengthIndicator(uint16_t lengthIndicator) [member function]
    cls.add_method('PushLengthIndicator', 
                   'void', 
                   [param('uint16_t', 'lengthIndicator')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::PushNack(int nack) [member function]
    cls.add_method('PushNack', 
                   'void', 
                   [param('int', 'nack')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::Serialize(ns3::Buffer::Iterator start) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetAckSn(ns3::SequenceNumber10 ackSn) [member function]
    cls.add_method('SetAckSn', 
                   'void', 
                   [param('ns3::SequenceNumber10', 'ackSn')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetControlPdu(uint8_t controlPduType) [member function]
    cls.add_method('SetControlPdu', 
                   'void', 
                   [param('uint8_t', 'controlPduType')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetDataPdu() [member function]
    cls.add_method('SetDataPdu', 
                   'void', 
                   [])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetFramingInfo(uint8_t framingInfo) [member function]
    cls.add_method('SetFramingInfo', 
                   'void', 
                   [param('uint8_t', 'framingInfo')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetLastSegmentFlag(uint8_t lsf) [member function]
    cls.add_method('SetLastSegmentFlag', 
                   'void', 
                   [param('uint8_t', 'lsf')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetPollingBit(uint8_t pollingBit) [member function]
    cls.add_method('SetPollingBit', 
                   'void', 
                   [param('uint8_t', 'pollingBit')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetResegmentationFlag(uint8_t resegFlag) [member function]
    cls.add_method('SetResegmentationFlag', 
                   'void', 
                   [param('uint8_t', 'resegFlag')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetSegmentOffset(uint16_t segmentOffset) [member function]
    cls.add_method('SetSegmentOffset', 
                   'void', 
                   [param('uint16_t', 'segmentOffset')])
    ## lte-rlc-am-header.h (module 'lte'): void ns3::LteRlcAmHeader::SetSequenceNumber(ns3::SequenceNumber10 sequenceNumber) [member function]
    cls.add_method('SetSequenceNumber', 
                   'void', 
                   [param('ns3::SequenceNumber10', 'sequenceNumber')])
    return

def register_Ns3LteRlcHeader_methods(root_module, cls):
    ## lte-rlc-header.h (module 'lte'): ns3::LteRlcHeader::LteRlcHeader(ns3::LteRlcHeader const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRlcHeader const &', 'arg0')])
    ## lte-rlc-header.h (module 'lte'): ns3::LteRlcHeader::LteRlcHeader() [constructor]
    cls.add_constructor([])
    ## lte-rlc-header.h (module 'lte'): uint32_t ns3::LteRlcHeader::Deserialize(ns3::Buffer::Iterator start) [member function]
    cls.add_method('Deserialize', 
                   'uint32_t', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_virtual=True)
    ## lte-rlc-header.h (module 'lte'): uint8_t ns3::LteRlcHeader::GetFramingInfo() const [member function]
    cls.add_method('GetFramingInfo', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-header.h (module 'lte'): ns3::TypeId ns3::LteRlcHeader::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-header.h (module 'lte'): ns3::SequenceNumber10 ns3::LteRlcHeader::GetSequenceNumber() const [member function]
    cls.add_method('GetSequenceNumber', 
                   'ns3::SequenceNumber10', 
                   [], 
                   is_const=True)
    ## lte-rlc-header.h (module 'lte'): uint32_t ns3::LteRlcHeader::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-header.h (module 'lte'): static ns3::TypeId ns3::LteRlcHeader::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-rlc-header.h (module 'lte'): uint8_t ns3::LteRlcHeader::PopExtensionBit() [member function]
    cls.add_method('PopExtensionBit', 
                   'uint8_t', 
                   [])
    ## lte-rlc-header.h (module 'lte'): uint16_t ns3::LteRlcHeader::PopLengthIndicator() [member function]
    cls.add_method('PopLengthIndicator', 
                   'uint16_t', 
                   [])
    ## lte-rlc-header.h (module 'lte'): void ns3::LteRlcHeader::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-header.h (module 'lte'): void ns3::LteRlcHeader::PushExtensionBit(uint8_t extensionBit) [member function]
    cls.add_method('PushExtensionBit', 
                   'void', 
                   [param('uint8_t', 'extensionBit')])
    ## lte-rlc-header.h (module 'lte'): void ns3::LteRlcHeader::PushLengthIndicator(uint16_t lengthIndicator) [member function]
    cls.add_method('PushLengthIndicator', 
                   'void', 
                   [param('uint16_t', 'lengthIndicator')])
    ## lte-rlc-header.h (module 'lte'): void ns3::LteRlcHeader::Serialize(ns3::Buffer::Iterator start) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::Buffer::Iterator', 'start')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-header.h (module 'lte'): void ns3::LteRlcHeader::SetFramingInfo(uint8_t framingInfo) [member function]
    cls.add_method('SetFramingInfo', 
                   'void', 
                   [param('uint8_t', 'framingInfo')])
    ## lte-rlc-header.h (module 'lte'): void ns3::LteRlcHeader::SetSequenceNumber(ns3::SequenceNumber10 sequenceNumber) [member function]
    cls.add_method('SetSequenceNumber', 
                   'void', 
                   [param('ns3::SequenceNumber10', 'sequenceNumber')])
    return

def register_Ns3LteRlcSduStatusTag_methods(root_module, cls):
    ## lte-rlc-sdu-status-tag.h (module 'lte'): ns3::LteRlcSduStatusTag::LteRlcSduStatusTag(ns3::LteRlcSduStatusTag const & arg0) [constructor]
    cls.add_constructor([param('ns3::LteRlcSduStatusTag const &', 'arg0')])
    ## lte-rlc-sdu-status-tag.h (module 'lte'): ns3::LteRlcSduStatusTag::LteRlcSduStatusTag() [constructor]
    cls.add_constructor([])
    ## lte-rlc-sdu-status-tag.h (module 'lte'): void ns3::LteRlcSduStatusTag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): ns3::TypeId ns3::LteRlcSduStatusTag::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): uint32_t ns3::LteRlcSduStatusTag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): uint8_t ns3::LteRlcSduStatusTag::GetStatus() const [member function]
    cls.add_method('GetStatus', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): static ns3::TypeId ns3::LteRlcSduStatusTag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): void ns3::LteRlcSduStatusTag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): void ns3::LteRlcSduStatusTag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-sdu-status-tag.h (module 'lte'): void ns3::LteRlcSduStatusTag::SetStatus(uint8_t status) [member function]
    cls.add_method('SetStatus', 
                   'void', 
                   [param('uint8_t', 'status')])
    return

def register_Ns3Object_methods(root_module, cls):
    ## object.h (module 'core'): ns3::Object::Object() [constructor]
    cls.add_constructor([])
    ## object.h (module 'core'): void ns3::Object::AggregateObject(ns3::Ptr<ns3::Object> other) [member function]
    cls.add_method('AggregateObject', 
                   'void', 
                   [param('ns3::Ptr< ns3::Object >', 'other')])
    ## object.h (module 'core'): void ns3::Object::Dispose() [member function]
    cls.add_method('Dispose', 
                   'void', 
                   [])
    ## object.h (module 'core'): ns3::Object::AggregateIterator ns3::Object::GetAggregateIterator() const [member function]
    cls.add_method('GetAggregateIterator', 
                   'ns3::Object::AggregateIterator', 
                   [], 
                   is_const=True)
    ## object.h (module 'core'): ns3::TypeId ns3::Object::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## object.h (module 'core'): static ns3::TypeId ns3::Object::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## object.h (module 'core'): void ns3::Object::Initialize() [member function]
    cls.add_method('Initialize', 
                   'void', 
                   [])
    ## object.h (module 'core'): bool ns3::Object::IsInitialized() const [member function]
    cls.add_method('IsInitialized', 
                   'bool', 
                   [], 
                   is_const=True)
    ## object.h (module 'core'): ns3::Object::Object(ns3::Object const & o) [constructor]
    cls.add_constructor([param('ns3::Object const &', 'o')], 
                        visibility='protected')
    ## object.h (module 'core'): void ns3::Object::DoDispose() [member function]
    cls.add_method('DoDispose', 
                   'void', 
                   [], 
                   is_virtual=True, visibility='protected')
    ## object.h (module 'core'): void ns3::Object::DoInitialize() [member function]
    cls.add_method('DoInitialize', 
                   'void', 
                   [], 
                   is_virtual=True, visibility='protected')
    ## object.h (module 'core'): void ns3::Object::NotifyNewAggregate() [member function]
    cls.add_method('NotifyNewAggregate', 
                   'void', 
                   [], 
                   is_virtual=True, visibility='protected')
    return

def register_Ns3ObjectAggregateIterator_methods(root_module, cls):
    ## object.h (module 'core'): ns3::Object::AggregateIterator::AggregateIterator(ns3::Object::AggregateIterator const & arg0) [constructor]
    cls.add_constructor([param('ns3::Object::AggregateIterator const &', 'arg0')])
    ## object.h (module 'core'): ns3::Object::AggregateIterator::AggregateIterator() [constructor]
    cls.add_constructor([])
    ## object.h (module 'core'): bool ns3::Object::AggregateIterator::HasNext() const [member function]
    cls.add_method('HasNext', 
                   'bool', 
                   [], 
                   is_const=True)
    ## object.h (module 'core'): ns3::Ptr<const ns3::Object> ns3::Object::AggregateIterator::Next() [member function]
    cls.add_method('Next', 
                   'ns3::Ptr< ns3::Object const >', 
                   [])
    return

def register_Ns3PacketBurst_methods(root_module, cls):
    ## packet-burst.h (module 'network'): ns3::PacketBurst::PacketBurst(ns3::PacketBurst const & arg0) [constructor]
    cls.add_constructor([param('ns3::PacketBurst const &', 'arg0')])
    ## packet-burst.h (module 'network'): ns3::PacketBurst::PacketBurst() [constructor]
    cls.add_constructor([])
    ## packet-burst.h (module 'network'): void ns3::PacketBurst::AddPacket(ns3::Ptr<ns3::Packet> packet) [member function]
    cls.add_method('AddPacket', 
                   'void', 
                   [param('ns3::Ptr< ns3::Packet >', 'packet')])
    ## packet-burst.h (module 'network'): std::list<ns3::Ptr<ns3::Packet>, std::allocator<ns3::Ptr<ns3::Packet> > >::const_iterator ns3::PacketBurst::Begin() const [member function]
    cls.add_method('Begin', 
                   'std::list< ns3::Ptr< ns3::Packet > > const_iterator', 
                   [], 
                   is_const=True)
    ## packet-burst.h (module 'network'): ns3::Ptr<ns3::PacketBurst> ns3::PacketBurst::Copy() const [member function]
    cls.add_method('Copy', 
                   'ns3::Ptr< ns3::PacketBurst >', 
                   [], 
                   is_const=True)
    ## packet-burst.h (module 'network'): std::list<ns3::Ptr<ns3::Packet>, std::allocator<ns3::Ptr<ns3::Packet> > >::const_iterator ns3::PacketBurst::End() const [member function]
    cls.add_method('End', 
                   'std::list< ns3::Ptr< ns3::Packet > > const_iterator', 
                   [], 
                   is_const=True)
    ## packet-burst.h (module 'network'): uint32_t ns3::PacketBurst::GetNPackets() const [member function]
    cls.add_method('GetNPackets', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## packet-burst.h (module 'network'): std::list<ns3::Ptr<ns3::Packet>, std::allocator<ns3::Ptr<ns3::Packet> > > ns3::PacketBurst::GetPackets() const [member function]
    cls.add_method('GetPackets', 
                   'std::list< ns3::Ptr< ns3::Packet > >', 
                   [], 
                   is_const=True)
    ## packet-burst.h (module 'network'): uint32_t ns3::PacketBurst::GetSize() const [member function]
    cls.add_method('GetSize', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## packet-burst.h (module 'network'): static ns3::TypeId ns3::PacketBurst::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## packet-burst.h (module 'network'): void ns3::PacketBurst::DoDispose() [member function]
    cls.add_method('DoDispose', 
                   'void', 
                   [], 
                   is_virtual=True, visibility='private')
    return

def register_Ns3PdcpTag_methods(root_module, cls):
    ## lte-pdcp-tag.h (module 'lte'): ns3::PdcpTag::PdcpTag(ns3::PdcpTag const & arg0) [constructor]
    cls.add_constructor([param('ns3::PdcpTag const &', 'arg0')])
    ## lte-pdcp-tag.h (module 'lte'): ns3::PdcpTag::PdcpTag() [constructor]
    cls.add_constructor([])
    ## lte-pdcp-tag.h (module 'lte'): ns3::PdcpTag::PdcpTag(ns3::Time senderTimestamp) [constructor]
    cls.add_constructor([param('ns3::Time', 'senderTimestamp')])
    ## lte-pdcp-tag.h (module 'lte'): void ns3::PdcpTag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True)
    ## lte-pdcp-tag.h (module 'lte'): ns3::TypeId ns3::PdcpTag::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-tag.h (module 'lte'): ns3::Time ns3::PdcpTag::GetSenderTimestamp() const [member function]
    cls.add_method('GetSenderTimestamp', 
                   'ns3::Time', 
                   [], 
                   is_const=True)
    ## lte-pdcp-tag.h (module 'lte'): uint32_t ns3::PdcpTag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-tag.h (module 'lte'): static ns3::TypeId ns3::PdcpTag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-pdcp-tag.h (module 'lte'): void ns3::PdcpTag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-tag.h (module 'lte'): void ns3::PdcpTag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True)
    ## lte-pdcp-tag.h (module 'lte'): void ns3::PdcpTag::SetSenderTimestamp(ns3::Time senderTimestamp) [member function]
    cls.add_method('SetSenderTimestamp', 
                   'void', 
                   [param('ns3::Time', 'senderTimestamp')])
    return

def register_Ns3PropagationDelayModel_methods(root_module, cls):
    ## propagation-delay-model.h (module 'propagation'): ns3::PropagationDelayModel::PropagationDelayModel() [constructor]
    cls.add_constructor([])
    ## propagation-delay-model.h (module 'propagation'): ns3::PropagationDelayModel::PropagationDelayModel(ns3::PropagationDelayModel const & arg0) [constructor]
    cls.add_constructor([param('ns3::PropagationDelayModel const &', 'arg0')])
    ## propagation-delay-model.h (module 'propagation'): int64_t ns3::PropagationDelayModel::AssignStreams(int64_t stream) [member function]
    cls.add_method('AssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')])
    ## propagation-delay-model.h (module 'propagation'): ns3::Time ns3::PropagationDelayModel::GetDelay(ns3::Ptr<ns3::MobilityModel> a, ns3::Ptr<ns3::MobilityModel> b) const [member function]
    cls.add_method('GetDelay', 
                   'ns3::Time', 
                   [param('ns3::Ptr< ns3::MobilityModel >', 'a'), param('ns3::Ptr< ns3::MobilityModel >', 'b')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## propagation-delay-model.h (module 'propagation'): static ns3::TypeId ns3::PropagationDelayModel::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## propagation-delay-model.h (module 'propagation'): int64_t ns3::PropagationDelayModel::DoAssignStreams(int64_t stream) [member function]
    cls.add_method('DoAssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')], 
                   is_virtual=True, is_pure_virtual=True, visibility='private')
    return

def register_Ns3PropagationLossModel_methods(root_module, cls):
    ## propagation-loss-model.h (module 'propagation'): static ns3::TypeId ns3::PropagationLossModel::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## propagation-loss-model.h (module 'propagation'): ns3::PropagationLossModel::PropagationLossModel() [constructor]
    cls.add_constructor([])
    ## propagation-loss-model.h (module 'propagation'): void ns3::PropagationLossModel::SetNext(ns3::Ptr<ns3::PropagationLossModel> next) [member function]
    cls.add_method('SetNext', 
                   'void', 
                   [param('ns3::Ptr< ns3::PropagationLossModel >', 'next')])
    ## propagation-loss-model.h (module 'propagation'): ns3::Ptr<ns3::PropagationLossModel> ns3::PropagationLossModel::GetNext() [member function]
    cls.add_method('GetNext', 
                   'ns3::Ptr< ns3::PropagationLossModel >', 
                   [])
    ## propagation-loss-model.h (module 'propagation'): double ns3::PropagationLossModel::CalcRxPower(double txPowerDbm, ns3::Ptr<ns3::MobilityModel> a, ns3::Ptr<ns3::MobilityModel> b) const [member function]
    cls.add_method('CalcRxPower', 
                   'double', 
                   [param('double', 'txPowerDbm'), param('ns3::Ptr< ns3::MobilityModel >', 'a'), param('ns3::Ptr< ns3::MobilityModel >', 'b')], 
                   is_const=True)
    ## propagation-loss-model.h (module 'propagation'): int64_t ns3::PropagationLossModel::AssignStreams(int64_t stream) [member function]
    cls.add_method('AssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')])
    ## propagation-loss-model.h (module 'propagation'): double ns3::PropagationLossModel::DoCalcRxPower(double txPowerDbm, ns3::Ptr<ns3::MobilityModel> a, ns3::Ptr<ns3::MobilityModel> b) const [member function]
    cls.add_method('DoCalcRxPower', 
                   'double', 
                   [param('double', 'txPowerDbm'), param('ns3::Ptr< ns3::MobilityModel >', 'a'), param('ns3::Ptr< ns3::MobilityModel >', 'b')], 
                   is_const=True, is_virtual=True, is_pure_virtual=True, visibility='private')
    ## propagation-loss-model.h (module 'propagation'): int64_t ns3::PropagationLossModel::DoAssignStreams(int64_t stream) [member function]
    cls.add_method('DoAssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')], 
                   is_virtual=True, is_pure_virtual=True, visibility='private')
    return

def register_Ns3RadioEnvironmentMapHelper_methods(root_module, cls):
    ## radio-environment-map-helper.h (module 'lte'): ns3::RadioEnvironmentMapHelper::RadioEnvironmentMapHelper() [constructor]
    cls.add_constructor([])
    ## radio-environment-map-helper.h (module 'lte'): void ns3::RadioEnvironmentMapHelper::DoDispose() [member function]
    cls.add_method('DoDispose', 
                   'void', 
                   [], 
                   is_virtual=True)
    ## radio-environment-map-helper.h (module 'lte'): uint8_t ns3::RadioEnvironmentMapHelper::GetBandwidth() const [member function]
    cls.add_method('GetBandwidth', 
                   'uint8_t', 
                   [], 
                   is_const=True)
    ## radio-environment-map-helper.h (module 'lte'): static ns3::TypeId ns3::RadioEnvironmentMapHelper::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## radio-environment-map-helper.h (module 'lte'): void ns3::RadioEnvironmentMapHelper::Install() [member function]
    cls.add_method('Install', 
                   'void', 
                   [])
    ## radio-environment-map-helper.h (module 'lte'): void ns3::RadioEnvironmentMapHelper::SetBandwidth(uint8_t bw) [member function]
    cls.add_method('SetBandwidth', 
                   'void', 
                   [param('uint8_t', 'bw')])
    return

def register_Ns3RandomPropagationDelayModel_methods(root_module, cls):
    ## propagation-delay-model.h (module 'propagation'): ns3::RandomPropagationDelayModel::RandomPropagationDelayModel(ns3::RandomPropagationDelayModel const & arg0) [constructor]
    cls.add_constructor([param('ns3::RandomPropagationDelayModel const &', 'arg0')])
    ## propagation-delay-model.h (module 'propagation'): ns3::RandomPropagationDelayModel::RandomPropagationDelayModel() [constructor]
    cls.add_constructor([])
    ## propagation-delay-model.h (module 'propagation'): ns3::Time ns3::RandomPropagationDelayModel::GetDelay(ns3::Ptr<ns3::MobilityModel> a, ns3::Ptr<ns3::MobilityModel> b) const [member function]
    cls.add_method('GetDelay', 
                   'ns3::Time', 
                   [param('ns3::Ptr< ns3::MobilityModel >', 'a'), param('ns3::Ptr< ns3::MobilityModel >', 'b')], 
                   is_const=True, is_virtual=True)
    ## propagation-delay-model.h (module 'propagation'): static ns3::TypeId ns3::RandomPropagationDelayModel::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## propagation-delay-model.h (module 'propagation'): int64_t ns3::RandomPropagationDelayModel::DoAssignStreams(int64_t stream) [member function]
    cls.add_method('DoAssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')], 
                   is_virtual=True, visibility='private')
    return

def register_Ns3RandomPropagationLossModel_methods(root_module, cls):
    ## propagation-loss-model.h (module 'propagation'): static ns3::TypeId ns3::RandomPropagationLossModel::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## propagation-loss-model.h (module 'propagation'): ns3::RandomPropagationLossModel::RandomPropagationLossModel() [constructor]
    cls.add_constructor([])
    ## propagation-loss-model.h (module 'propagation'): double ns3::RandomPropagationLossModel::DoCalcRxPower(double txPowerDbm, ns3::Ptr<ns3::MobilityModel> a, ns3::Ptr<ns3::MobilityModel> b) const [member function]
    cls.add_method('DoCalcRxPower', 
                   'double', 
                   [param('double', 'txPowerDbm'), param('ns3::Ptr< ns3::MobilityModel >', 'a'), param('ns3::Ptr< ns3::MobilityModel >', 'b')], 
                   is_const=True, is_virtual=True, visibility='private')
    ## propagation-loss-model.h (module 'propagation'): int64_t ns3::RandomPropagationLossModel::DoAssignStreams(int64_t stream) [member function]
    cls.add_method('DoAssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')], 
                   is_virtual=True, visibility='private')
    return

def register_Ns3RandomVariableStream_methods(root_module, cls):
    ## random-variable-stream.h (module 'core'): static ns3::TypeId ns3::RandomVariableStream::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## random-variable-stream.h (module 'core'): ns3::RandomVariableStream::RandomVariableStream() [constructor]
    cls.add_constructor([])
    ## random-variable-stream.h (module 'core'): void ns3::RandomVariableStream::SetStream(int64_t stream) [member function]
    cls.add_method('SetStream', 
                   'void', 
                   [param('int64_t', 'stream')])
    ## random-variable-stream.h (module 'core'): int64_t ns3::RandomVariableStream::GetStream() const [member function]
    cls.add_method('GetStream', 
                   'int64_t', 
                   [], 
                   is_const=True)
    ## random-variable-stream.h (module 'core'): void ns3::RandomVariableStream::SetAntithetic(bool isAntithetic) [member function]
    cls.add_method('SetAntithetic', 
                   'void', 
                   [param('bool', 'isAntithetic')])
    ## random-variable-stream.h (module 'core'): bool ns3::RandomVariableStream::IsAntithetic() const [member function]
    cls.add_method('IsAntithetic', 
                   'bool', 
                   [], 
                   is_const=True)
    ## random-variable-stream.h (module 'core'): double ns3::RandomVariableStream::GetValue() [member function]
    cls.add_method('GetValue', 
                   'double', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## random-variable-stream.h (module 'core'): uint32_t ns3::RandomVariableStream::GetInteger() [member function]
    cls.add_method('GetInteger', 
                   'uint32_t', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## random-variable-stream.h (module 'core'): ns3::RngStream * ns3::RandomVariableStream::Peek() const [member function]
    cls.add_method('Peek', 
                   'ns3::RngStream *', 
                   [], 
                   is_const=True, visibility='protected')
    return

def register_Ns3RangePropagationLossModel_methods(root_module, cls):
    ## propagation-loss-model.h (module 'propagation'): static ns3::TypeId ns3::RangePropagationLossModel::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## propagation-loss-model.h (module 'propagation'): ns3::RangePropagationLossModel::RangePropagationLossModel() [constructor]
    cls.add_constructor([])
    ## propagation-loss-model.h (module 'propagation'): double ns3::RangePropagationLossModel::DoCalcRxPower(double txPowerDbm, ns3::Ptr<ns3::MobilityModel> a, ns3::Ptr<ns3::MobilityModel> b) const [member function]
    cls.add_method('DoCalcRxPower', 
                   'double', 
                   [param('double', 'txPowerDbm'), param('ns3::Ptr< ns3::MobilityModel >', 'a'), param('ns3::Ptr< ns3::MobilityModel >', 'b')], 
                   is_const=True, is_virtual=True, visibility='private')
    ## propagation-loss-model.h (module 'propagation'): int64_t ns3::RangePropagationLossModel::DoAssignStreams(int64_t stream) [member function]
    cls.add_method('DoAssignStreams', 
                   'int64_t', 
                   [param('int64_t', 'stream')], 
                   is_virtual=True, visibility='private')
    return

def register_Ns3RlcTag_methods(root_module, cls):
    ## lte-rlc-tag.h (module 'lte'): ns3::RlcTag::RlcTag(ns3::RlcTag const & arg0) [constructor]
    cls.add_constructor([param('ns3::RlcTag const &', 'arg0')])
    ## lte-rlc-tag.h (module 'lte'): ns3::RlcTag::RlcTag() [constructor]
    cls.add_constructor([])
    ## lte-rlc-tag.h (module 'lte'): ns3::RlcTag::RlcTag(ns3::Time senderTimestamp) [constructor]
    cls.add_constructor([param('ns3::Time', 'senderTimestamp')])
    ## lte-rlc-tag.h (module 'lte'): void ns3::RlcTag::Deserialize(ns3::TagBuffer i) [member function]
    cls.add_method('Deserialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_virtual=True)
    ## lte-rlc-tag.h (module 'lte'): ns3::TypeId ns3::RlcTag::GetInstanceTypeId() const [member function]
    cls.add_method('GetInstanceTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-tag.h (module 'lte'): ns3::Time ns3::RlcTag::GetSenderTimestamp() const [member function]
    cls.add_method('GetSenderTimestamp', 
                   'ns3::Time', 
                   [], 
                   is_const=True)
    ## lte-rlc-tag.h (module 'lte'): uint32_t ns3::RlcTag::GetSerializedSize() const [member function]
    cls.add_method('GetSerializedSize', 
                   'uint32_t', 
                   [], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-tag.h (module 'lte'): static ns3::TypeId ns3::RlcTag::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## lte-rlc-tag.h (module 'lte'): void ns3::RlcTag::Print(std::ostream & os) const [member function]
    cls.add_method('Print', 
                   'void', 
                   [param('std::ostream &', 'os')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-tag.h (module 'lte'): void ns3::RlcTag::Serialize(ns3::TagBuffer i) const [member function]
    cls.add_method('Serialize', 
                   'void', 
                   [param('ns3::TagBuffer', 'i')], 
                   is_const=True, is_virtual=True)
    ## lte-rlc-tag.h (module 'lte'): void ns3::RlcTag::SetSenderTimestamp(ns3::Time senderTimestamp) [member function]
    cls.add_method('SetSenderTimestamp', 
                   'void', 
                   [param('ns3::Time', 'senderTimestamp')])
    return

def register_Ns3SequentialRandomVariable_methods(root_module, cls):
    ## random-variable-stream.h (module 'core'): static ns3::TypeId ns3::SequentialRandomVariable::GetTypeId() [member function]
    cls.add_method('GetTypeId', 
                   'ns3::TypeId', 
                   [], 
                   is_static=True)
    ## random-variable-stream.h (module 'core'): ns3::SequentialRandomVariable::SequentialRandomVariable() [constructor]
    cls.add_constructor([])
    ## random-variable-stream.h (module 'core'): double ns3::SequentialRandomVariable::GetMin() const [member function]
    cls.add_method('GetMin', 
                   'double', 
                   [], 
                   is_const=True)
    ## random-variable-stream.h (module 'core'): double ns3::SequentialRandomVariable::GetMax() const [member function]
    cls.add_method('GetMax', 
                   'double', 
                   [], 
                   is_const=True)
    ## random-variable-stream.h (module 'core'): ns3::Ptr<ns3::RandomVariableStream> ns3::SequentialRandomVariable::GetIncrement() const [member function]
    cls.add_method('GetIncrement', 
                   'ns3::Ptr< ns3::RandomVariableStream >', 
                   [], 
                   is_const=True)
    ## random-variable-stream.h (module 'core'): uint32_t ns3::SequentialRandomVariable::GetConsecutive() const [member function]
    cls.add_method('GetConsecutive', 
                   'uint32_t', 
                   [], 
                   is_const=True)
    ## random-variable-stream.h (module 'core'): double ns3::SequentialRandomVariable::GetValue() [member function]
    cls.add_method('GetValue', 
                   'double', 
                   [], 
                   is_virtual=True)
    ## random-variable-stream.h (module 'core'): uint32_t ns3::SequentialRandomVariable::GetInteger() [member function]
    cls.add_method('GetInteger', 
                   'uint32_t', 
                   [], 
                   is_virtual=True)
    return

def register_Ns3SimpleRefCount__Ns3AttributeAccessor_Ns3Empty_Ns3DefaultDeleter__lt__ns3AttributeAccessor__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter<ns3::AttributeAccessor> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter<ns3::AttributeAccessor> >::SimpleRefCount(ns3::SimpleRefCount<ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter<ns3::AttributeAccessor> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::AttributeAccessor, ns3::empty, ns3::DefaultDeleter< ns3::AttributeAccessor > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3AttributeChecker_Ns3Empty_Ns3DefaultDeleter__lt__ns3AttributeChecker__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter<ns3::AttributeChecker> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter<ns3::AttributeChecker> >::SimpleRefCount(ns3::SimpleRefCount<ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter<ns3::AttributeChecker> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::AttributeChecker, ns3::empty, ns3::DefaultDeleter< ns3::AttributeChecker > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3AttributeValue_Ns3Empty_Ns3DefaultDeleter__lt__ns3AttributeValue__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter<ns3::AttributeValue> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter<ns3::AttributeValue> >::SimpleRefCount(ns3::SimpleRefCount<ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter<ns3::AttributeValue> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::AttributeValue, ns3::empty, ns3::DefaultDeleter< ns3::AttributeValue > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3CallbackImplBase_Ns3Empty_Ns3DefaultDeleter__lt__ns3CallbackImplBase__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter<ns3::CallbackImplBase> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter<ns3::CallbackImplBase> >::SimpleRefCount(ns3::SimpleRefCount<ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter<ns3::CallbackImplBase> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::CallbackImplBase, ns3::empty, ns3::DefaultDeleter< ns3::CallbackImplBase > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3EpcTft_Ns3Empty_Ns3DefaultDeleter__lt__ns3EpcTft__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EpcTft, ns3::empty, ns3::DefaultDeleter<ns3::EpcTft> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EpcTft, ns3::empty, ns3::DefaultDeleter<ns3::EpcTft> >::SimpleRefCount(ns3::SimpleRefCount<ns3::EpcTft, ns3::empty, ns3::DefaultDeleter<ns3::EpcTft> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::EpcTft, ns3::empty, ns3::DefaultDeleter< ns3::EpcTft > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3EpcTftClassifier_Ns3Empty_Ns3DefaultDeleter__lt__ns3EpcTftClassifier__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter<ns3::EpcTftClassifier> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter<ns3::EpcTftClassifier> >::SimpleRefCount(ns3::SimpleRefCount<ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter<ns3::EpcTftClassifier> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::EpcTftClassifier, ns3::empty, ns3::DefaultDeleter< ns3::EpcTftClassifier > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3EventImpl_Ns3Empty_Ns3DefaultDeleter__lt__ns3EventImpl__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EventImpl, ns3::empty, ns3::DefaultDeleter<ns3::EventImpl> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::EventImpl, ns3::empty, ns3::DefaultDeleter<ns3::EventImpl> >::SimpleRefCount(ns3::SimpleRefCount<ns3::EventImpl, ns3::empty, ns3::DefaultDeleter<ns3::EventImpl> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::EventImpl, ns3::empty, ns3::DefaultDeleter< ns3::EventImpl > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3HashImplementation_Ns3Empty_Ns3DefaultDeleter__lt__ns3HashImplementation__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter<ns3::Hash::Implementation> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter<ns3::Hash::Implementation> >::SimpleRefCount(ns3::SimpleRefCount<ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter<ns3::Hash::Implementation> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::Hash::Implementation, ns3::empty, ns3::DefaultDeleter< ns3::Hash::Implementation > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3Ipv4MulticastRoute_Ns3Empty_Ns3DefaultDeleter__lt__ns3Ipv4MulticastRoute__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4MulticastRoute> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4MulticastRoute> >::SimpleRefCount(ns3::SimpleRefCount<ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4MulticastRoute> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::Ipv4MulticastRoute, ns3::empty, ns3::DefaultDeleter< ns3::Ipv4MulticastRoute > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3Ipv4Route_Ns3Empty_Ns3DefaultDeleter__lt__ns3Ipv4Route__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4Route> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4Route> >::SimpleRefCount(ns3::SimpleRefCount<ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter<ns3::Ipv4Route> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::Ipv4Route, ns3::empty, ns3::DefaultDeleter< ns3::Ipv4Route > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3LteChunkProcessor_Ns3Empty_Ns3DefaultDeleter__lt__ns3LteChunkProcessor__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter<ns3::LteChunkProcessor> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter<ns3::LteChunkProcessor> >::SimpleRefCount(ns3::SimpleRefCount<ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter<ns3::LteChunkProcessor> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::LteChunkProcessor, ns3::empty, ns3::DefaultDeleter< ns3::LteChunkProcessor > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3LteControlMessage_Ns3Empty_Ns3DefaultDeleter__lt__ns3LteControlMessage__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter<ns3::LteControlMessage> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter<ns3::LteControlMessage> >::SimpleRefCount(ns3::SimpleRefCount<ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter<ns3::LteControlMessage> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::LteControlMessage, ns3::empty, ns3::DefaultDeleter< ns3::LteControlMessage > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3LteHarqPhy_Ns3Empty_Ns3DefaultDeleter__lt__ns3LteHarqPhy__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter<ns3::LteHarqPhy> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter<ns3::LteHarqPhy> >::SimpleRefCount(ns3::SimpleRefCount<ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter<ns3::LteHarqPhy> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::LteHarqPhy, ns3::empty, ns3::DefaultDeleter< ns3::LteHarqPhy > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3NixVector_Ns3Empty_Ns3DefaultDeleter__lt__ns3NixVector__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::NixVector, ns3::empty, ns3::DefaultDeleter<ns3::NixVector> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::NixVector, ns3::empty, ns3::DefaultDeleter<ns3::NixVector> >::SimpleRefCount(ns3::SimpleRefCount<ns3::NixVector, ns3::empty, ns3::DefaultDeleter<ns3::NixVector> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::NixVector, ns3::empty, ns3::DefaultDeleter< ns3::NixVector > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3Packet_Ns3Empty_Ns3DefaultDeleter__lt__ns3Packet__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Packet, ns3::empty, ns3::DefaultDeleter<ns3::Packet> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::Packet, ns3::empty, ns3::DefaultDeleter<ns3::Packet> >::SimpleRefCount(ns3::SimpleRefCount<ns3::Packet, ns3::empty, ns3::DefaultDeleter<ns3::Packet> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::Packet, ns3::empty, ns3::DefaultDeleter< ns3::Packet > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3SpectrumModel_Ns3Empty_Ns3DefaultDeleter__lt__ns3SpectrumModel__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumModel> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumModel> >::SimpleRefCount(ns3::SimpleRefCount<ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumModel> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::SpectrumModel, ns3::empty, ns3::DefaultDeleter< ns3::SpectrumModel > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3SpectrumSignalParameters_Ns3Empty_Ns3DefaultDeleter__lt__ns3SpectrumSignalParameters__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumSignalParameters> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumSignalParameters> >::SimpleRefCount(ns3::SimpleRefCount<ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumSignalParameters> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::SpectrumSignalParameters, ns3::empty, ns3::DefaultDeleter< ns3::SpectrumSignalParameters > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3SpectrumValue_Ns3Empty_Ns3DefaultDeleter__lt__ns3SpectrumValue__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumValue> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumValue> >::SimpleRefCount(ns3::SimpleRefCount<ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter<ns3::SpectrumValue> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::SpectrumValue, ns3::empty, ns3::DefaultDeleter< ns3::SpectrumValue > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3TraceSourceAccessor_Ns3Empty_Ns3DefaultDeleter__lt__ns3TraceSourceAccessor__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter<ns3::TraceSourceAccessor> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter<ns3::TraceSourceAccessor> >::SimpleRefCount(ns3::SimpleRefCount<ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter<ns3::TraceSourceAccessor> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::TraceSourceAccessor, ns3::empty, ns3::DefaultDeleter< ns3::TraceSourceAccessor > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3VendorSpecificValue_Ns3Empty_Ns3DefaultDeleter__lt__ns3VendorSpecificValue__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter<ns3::VendorSpecificValue> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter<ns3::VendorSpecificValue> >::SimpleRefCount(ns3::SimpleRefCount<ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter<ns3::VendorSpecificValue> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::VendorSpecificValue, ns3::empty, ns3::DefaultDeleter< ns3::VendorSpecificValue > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3X2CellInfo_Ns3Empty_Ns3DefaultDeleter__lt__ns3X2CellInfo__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2CellInfo> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2CellInfo> >::SimpleRefCount(ns3::SimpleRefCount<ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2CellInfo> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::X2CellInfo, ns3::empty, ns3::DefaultDeleter< ns3::X2CellInfo > > const &', 'o')])
    return

def register_Ns3SimpleRefCount__Ns3X2IfaceInfo_Ns3Empty_Ns3DefaultDeleter__lt__ns3X2IfaceInfo__gt___methods(root_module, cls):
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2IfaceInfo> >::SimpleRefCount() [constructor]
    cls.add_constructor([])
    ## simple-ref-count.h (module 'core'): ns3::SimpleRefCount<ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2IfaceInfo> >::SimpleRefCount(ns3::SimpleRefCount<ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter<ns3::X2IfaceInfo> > const & o) [constructor]
    cls.add_constructor([param('ns3::SimpleRefCount< ns3::X2IfaceInfo, ns3::empty, ns3::DefaultDeleter< ns3::X2IfaceInfo > > const &', 'o')])
    return

def register_Ns3Socket_methods(root_module, cls):
    ## socket.h (module 'network'): ns3::Socket::Socket(ns3::Socket const & arg0) [constructor]
    cls.add_constructor([param('ns3::Socket const &', 'arg0')])
    ## socket.h (module 'network'): ns3::Socket::Socket() [constructor]
    cls.add_constructor([])
    ## socket.h (module 'network'): int ns3::Socket::Bind(ns3::Address const & address) [member function]
    cls.add_method('Bind', 
                   'int', 
                   [param('ns3::Address const &', 'address')], 
                   is_virtual=True, is_pure_virtual=True)
    ## socket.h (module 'network'): int ns3::Socket::Bind() [member function]
    cls.add_method('Bind', 
                   'int', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## socket.h (module 'network'): int ns3::Socket::Bind6() [member function]
    cls.add_method('Bind6', 
                   'int', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## socket.h (module 'network'): void ns3::Socket::BindToNetDevice(ns3::Ptr<ns3::NetDevice> netdevice) [member function]
    cls.add_method('BindToNetDevice', 
                   'void', 
                   [param('ns3::Ptr< ns3::NetDevice >', 'netdevice')], 
                   is_virtual=True)
    ## socket.h (module 'network'): int ns3::Socket::Close() [member function]
    cls.add_method('Close', 
                   'int', 
                   [], 
                   is_virtual=True, is_pure_virtual=True)
    ## socket.h (module 'network'): int ns3::Socket::Connect(ns3::Address const & address) [member function]
    cls.add_method('Connect', 
                   'int', 
                   [param('ns3::Address const &', 'address')], 
                   is_virtual=True, is_pure_virtual=True)
    ## socket.h (module 'network'): static ns3::Ptr<ns3::Socket> ns3::Socket::CreateSocket(ns3::Ptr<ns3::Node> node, ns3::TypeId tid) [member function]
    cls.add_method('CreateSocket', 
                   'ns3::Ptr< ns3::Socket >', 
                   [param('ns3::Ptr< ns3::Node >', 'node'), param('ns3::TypeId', 'tid')], 
                   is_static=True)
    ## socket.h (module 'network'): bool ns3::Socket::GetAllowBroadcast() const [member function]
    cls.add_method('GetAllowBroadcast', 
                   'bool', 
                   [], 
                   is_const=True, is_virtual=True, is_pure_virtual=True)
    ## socket.h (module 'network'): ns3::Ptr<ns3::NetDevice> ns3::Socket::GetBoundNetDevice() [member function]
    cls.add_method('GetBoundN