# Contributing to NCL

Thank you for your interest in NCL. We welcome contributions from everyone. There are many ways to contribute, such as, but not limited to:

- New features
- Bug reports, bug fixes
- Corrections/clarifications to documentation
- NCL scripts (utilities, computational routines, etc.)
- Examples (techniques, novel graphics, etc.)
- Suggestions for new features
- Commentary on the Roadmap

## How to Contribute

- Contributions to the NCL source code (new features, bug fixes, etc.) should be submitted as [pull-requests](https://help.github.com/articles/about-pull-requests/). We broadly follow the [GitFlow](https://datasift.github.io/gitflow/IntroducingGitFlow.html) work flow.
- Bug reports should be filed as an [issue](https://github.com/NCAR/ncl/issues) on GitHub.
- Examples, scripts, documentation fixes may be submitted via the **ncl-talk@ucar.edu** email group. ([Registration](http://mailman.ucar.edu/mailman/listinfo/ncl-talk) is required).
- Suggestions, commentary may be submitted ( to-be-filled-in)

## Code of Conduct

In contributing to NCL, you agree to follow our [Code of Conduct](CODE_OF_CONDUCT.md).

## License

[NCL's license](LICENSE) is based on the <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.

## Additional Resources

- The [NCL website](http://ncl.ucar.edu/) is a source for comprehensive documentation and extensive examples.
- [Installing](http://ncl.ucar.edu/Download/) NCL from prebuilt binaries or via conda.
