# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.compositer import Compositer


class CompressCompositer(Compositer):
    r"""
    CompressCompositer - Implements compressed tree based compositing.
    
    Superclass: Compositer
    
    CompressCompositer operates in multiple processes.  Each
    compositer has a render window.  They use MultiProcessController
    to communicate the color and depth buffer to process 0's render
    window. It will not handle transparency.  Compositing is run length
    encoding of background pixels.
    
    SECTION See Also CompositeManager.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompressCompositer, obj, update, **traits)
    
    def composite_image_pair(self, *args):
        """
        composite_image_pair(localZ:FloatArray, localP:DataArray,
            remoteZ:FloatArray, remoteP:DataArray,
            outZ:FloatArray, outP:DataArray) -> None
        C++: static void composite_image_pair(FloatArray *localZ,
            DataArray *localP, FloatArray *remoteZ,
            DataArray *remoteP, FloatArray *outZ,
            DataArray *outP)"""
        my_args = deref_array(args, [('vtkFloatArray', 'vtkDataArray', 'vtkFloatArray', 'vtkDataArray', 'vtkFloatArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.CompositeImagePair, *my_args)
        return ret

    def compress(self, *args):
        """
        compress(zIn:FloatArray, pIn:DataArray, zOut:FloatArray,
            pOut:DataArray) -> None
        C++: static void compress(FloatArray *zIn, DataArray *pIn,
            FloatArray *zOut, DataArray *pOut)
        I am granting access to these methods and making them static So I
        can create a tile_display_compositer which uses compression.
        """
        my_args = deref_array(args, [('vtkFloatArray', 'vtkDataArray', 'vtkFloatArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.Compress, *my_args)
        return ret

    def uncompress(self, *args):
        """
        uncompress(zIn:FloatArray, pIn:DataArray,
            zOut:FloatArray, pOut:DataArray, lengthOut:int) -> None
        C++: static void uncompress(FloatArray *zIn, DataArray *pIn,
             FloatArray *zOut, DataArray *pOut, int lengthOut)"""
        my_args = deref_array(args, [('vtkFloatArray', 'vtkDataArray', 'vtkFloatArray', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.Uncompress, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_processes',
    'GetNumberOfProcesses'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'number_of_processes',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompressCompositer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CompressCompositer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_processes', 'object_name']),
            title='Edit CompressCompositer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompressCompositer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

