
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileBoxPlotVisualiserAttributes.h
    \brief Definition of BoxPlotVisualiser Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef BoxPlotVisualiserAttributes_H
#define BoxPlotVisualiserAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class BoxPlotVisualiserAttributes 
{
public:
//  --  constructor
    BoxPlotVisualiserAttributes();
    
//  --  destructor
    virtual ~BoxPlotVisualiserAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BoxPlotVisualiserAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool box_;
	double box_width_;
	bool box_border_;
	int box_border_thickness_;
	bool median_;
	int median_thickness_;
	string whisker_;
	double whisker_box_width_;
	bool whisker_box_border_;
	int whisker_box_border_thickness_;
	int whisker_line_thickness_;
	unique_ptr<Colour> box_colour_;
	unique_ptr<Colour> box_border_colour_;
	LineStyle box_border_style_;
	unique_ptr<Colour> median_colour_;
	LineStyle median_style_;
	unique_ptr<Colour> whisker_box_colour_;
	unique_ptr<Colour> whisker_box_border_colour_;
	LineStyle whisker_box_border_style_;
	unique_ptr<Colour> whisker_line_colour_;
	LineStyle whisker_line_style_;
	 

private:
	friend ostream& operator<<(ostream& s,const BoxPlotVisualiserAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

