/*
 * Copyright (C) 2013-2016 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.15
import QMenuModel 1.0 as QMenuModel
import GlobalShortcut 1.0
import Lomiri.Platform 1.0

Item {
    id: root
    objectName: "volumeControl"
    visible: false

    // TODO Work around http://pad.lv/1293478 until qmenumodel knows to cast
    readonly property int stepUp: 1
    readonly property int stepDown: -1

    GlobalShortcut {
        id: muteShortcut
        shortcut: Qt.Key_VolumeMute
        onTriggered: toggleMute()
    }

    QMenuModel.QDBusActionGroup {
        id: actionGroup
        busType: QMenuModel.DBus.SessionBus
        busName: "org.ayatana.indicator.sound"
        objectPath: "/org/ayatana/indicator/sound"

        property variant actionObject: action("volume")
        // temporary workaround for lp:1623166
        property variant muteActionObject: Platform.isPC ? action("mute") : action("silent-mode")
    }

    function volumeUp() {
        actionGroup.actionObject.activate(stepUp);
    }

    function volumeDown() {
        actionGroup.actionObject.activate(stepDown);
    }

    function toggleMute() {
        actionGroup.muteActionObject.activate();
    }

    Component.onCompleted: {
        actionGroup.start();
    }
}
