/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef UPLOADER_LIB_UPLOAD_DAEMON_H
#define UPLOADER_LIB_UPLOAD_DAEMON_H

#include <lomiri/transfers/base_daemon.h>

namespace Lomiri {

using namespace Transfers;

namespace UploadManager {

namespace Daemon {

class UploadDaemon : public BaseDaemon {
    Q_OBJECT

 public:
    UploadDaemon(QObject *parent = 0);
    UploadDaemon(ManagerFactory* managerFactory,
                 System::Application* app,
                 System::DBusConnection* conn,
                 System::Timer* timer,
                 QObject *parent = 0);

 public slots:
    virtual void start();
    virtual void start(const QString& path) override;
};

}  // Daemon

}  // UploadManager

}  // Lomiri

#endif

