
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDnsLookup.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDnsLookup>
#include <QChildEvent>
#include <QDnsDomainNameRecord>
#include <QDnsHostAddressRecord>
#include <QDnsMailExchangeRecord>
#include <QDnsServiceRecord>
#include <QDnsTextRecord>
#include <QEvent>
#include <QHostAddress>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDnsLookup

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QDnsLookup::staticMetaObject);
}


// void QDnsLookup::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup *)cls)->abort ();
}


// QList<QDnsDomainNameRecord> QDnsLookup::canonicalNameRecords()


static void _init_f_canonicalNameRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsDomainNameRecord> > ();
}

static void _call_f_canonicalNameRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsDomainNameRecord> > ((QList<QDnsDomainNameRecord>)((QDnsLookup *)cls)->canonicalNameRecords ());
}


// QDnsLookup::Error QDnsLookup::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDnsLookup::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QDnsLookup::Error>::target_type > ((qt_gsi::Converter<QDnsLookup::Error>::target_type)qt_gsi::CppToQtAdaptor<QDnsLookup::Error>(((QDnsLookup *)cls)->error ()));
}


// QString QDnsLookup::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDnsLookup *)cls)->errorString ());
}


// QList<QDnsHostAddressRecord> QDnsLookup::hostAddressRecords()


static void _init_f_hostAddressRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsHostAddressRecord> > ();
}

static void _call_f_hostAddressRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsHostAddressRecord> > ((QList<QDnsHostAddressRecord>)((QDnsLookup *)cls)->hostAddressRecords ());
}


// bool QDnsLookup::isFinished()


static void _init_f_isFinished_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFinished_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDnsLookup *)cls)->isFinished ());
}


// void QDnsLookup::lookup()


static void _init_f_lookup_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_lookup_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup *)cls)->lookup ();
}


// QList<QDnsMailExchangeRecord> QDnsLookup::mailExchangeRecords()


static void _init_f_mailExchangeRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsMailExchangeRecord> > ();
}

static void _call_f_mailExchangeRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsMailExchangeRecord> > ((QList<QDnsMailExchangeRecord>)((QDnsLookup *)cls)->mailExchangeRecords ());
}


// QString QDnsLookup::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDnsLookup *)cls)->name ());
}


// QList<QDnsDomainNameRecord> QDnsLookup::nameServerRecords()


static void _init_f_nameServerRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsDomainNameRecord> > ();
}

static void _call_f_nameServerRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsDomainNameRecord> > ((QList<QDnsDomainNameRecord>)((QDnsLookup *)cls)->nameServerRecords ());
}


// QHostAddress QDnsLookup::nameserver()


static void _init_f_nameserver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_nameserver_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QDnsLookup *)cls)->nameserver ());
}


// QList<QDnsDomainNameRecord> QDnsLookup::pointerRecords()


static void _init_f_pointerRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsDomainNameRecord> > ();
}

static void _call_f_pointerRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsDomainNameRecord> > ((QList<QDnsDomainNameRecord>)((QDnsLookup *)cls)->pointerRecords ());
}


// QList<QDnsServiceRecord> QDnsLookup::serviceRecords()


static void _init_f_serviceRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsServiceRecord> > ();
}

static void _call_f_serviceRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsServiceRecord> > ((QList<QDnsServiceRecord>)((QDnsLookup *)cls)->serviceRecords ());
}


// void QDnsLookup::setName(const QString &name)


static void _init_f_setName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup *)cls)->setName (arg1);
}


// void QDnsLookup::setNameserver(const QHostAddress &nameserver)


static void _init_f_setNameserver_2518 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameserver");
  decl->add_arg<const QHostAddress & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNameserver_2518 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = gsi::arg_reader<const QHostAddress & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup *)cls)->setNameserver (arg1);
}


// void QDnsLookup::setType(QDnsLookup::Type)


static void _init_f_setType_1978 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QDnsLookup::Type>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setType_1978 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDnsLookup::Type>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QDnsLookup::Type>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup *)cls)->setType (qt_gsi::QtToCppAdaptor<QDnsLookup::Type>(arg1).cref());
}


// QList<QDnsTextRecord> QDnsLookup::textRecords()


static void _init_f_textRecords_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QDnsTextRecord> > ();
}

static void _call_f_textRecords_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QDnsTextRecord> > ((QList<QDnsTextRecord>)((QDnsLookup *)cls)->textRecords ());
}


// QDnsLookup::Type QDnsLookup::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDnsLookup::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QDnsLookup::Type>::target_type > ((qt_gsi::Converter<QDnsLookup::Type>::target_type)qt_gsi::CppToQtAdaptor<QDnsLookup::Type>(((QDnsLookup *)cls)->type ()));
}


// static QString QDnsLookup::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QDnsLookup::tr (arg1, arg2, arg3));
}


// static QString QDnsLookup::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QDnsLookup::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QDnsLookup () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("abort", "@brief Method void QDnsLookup::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
  methods += new qt_gsi::GenericMethod ("canonicalNameRecords", "@brief Method QList<QDnsDomainNameRecord> QDnsLookup::canonicalNameRecords()\n", true, &_init_f_canonicalNameRecords_c0, &_call_f_canonicalNameRecords_c0);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QDnsLookup::Error QDnsLookup::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod (":errorString", "@brief Method QString QDnsLookup::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("hostAddressRecords", "@brief Method QList<QDnsHostAddressRecord> QDnsLookup::hostAddressRecords()\n", true, &_init_f_hostAddressRecords_c0, &_call_f_hostAddressRecords_c0);
  methods += new qt_gsi::GenericMethod ("isFinished?", "@brief Method bool QDnsLookup::isFinished()\n", true, &_init_f_isFinished_c0, &_call_f_isFinished_c0);
  methods += new qt_gsi::GenericMethod ("lookup", "@brief Method void QDnsLookup::lookup()\n", false, &_init_f_lookup_0, &_call_f_lookup_0);
  methods += new qt_gsi::GenericMethod ("mailExchangeRecords", "@brief Method QList<QDnsMailExchangeRecord> QDnsLookup::mailExchangeRecords()\n", true, &_init_f_mailExchangeRecords_c0, &_call_f_mailExchangeRecords_c0);
  methods += new qt_gsi::GenericMethod (":name", "@brief Method QString QDnsLookup::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("nameServerRecords", "@brief Method QList<QDnsDomainNameRecord> QDnsLookup::nameServerRecords()\n", true, &_init_f_nameServerRecords_c0, &_call_f_nameServerRecords_c0);
  methods += new qt_gsi::GenericMethod (":nameserver", "@brief Method QHostAddress QDnsLookup::nameserver()\n", true, &_init_f_nameserver_c0, &_call_f_nameserver_c0);
  methods += new qt_gsi::GenericMethod ("pointerRecords", "@brief Method QList<QDnsDomainNameRecord> QDnsLookup::pointerRecords()\n", true, &_init_f_pointerRecords_c0, &_call_f_pointerRecords_c0);
  methods += new qt_gsi::GenericMethod ("serviceRecords", "@brief Method QList<QDnsServiceRecord> QDnsLookup::serviceRecords()\n", true, &_init_f_serviceRecords_c0, &_call_f_serviceRecords_c0);
  methods += new qt_gsi::GenericMethod ("setName|name=", "@brief Method void QDnsLookup::setName(const QString &name)\n", false, &_init_f_setName_2025, &_call_f_setName_2025);
  methods += new qt_gsi::GenericMethod ("setNameserver|nameserver=", "@brief Method void QDnsLookup::setNameserver(const QHostAddress &nameserver)\n", false, &_init_f_setNameserver_2518, &_call_f_setNameserver_2518);
  methods += new qt_gsi::GenericMethod ("setType|type=", "@brief Method void QDnsLookup::setType(QDnsLookup::Type)\n", false, &_init_f_setType_1978, &_call_f_setType_1978);
  methods += new qt_gsi::GenericMethod ("textRecords", "@brief Method QList<QDnsTextRecord> QDnsLookup::textRecords()\n", true, &_init_f_textRecords_c0, &_call_f_textRecords_c0);
  methods += new qt_gsi::GenericMethod (":type", "@brief Method QDnsLookup::Type QDnsLookup::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QDnsLookup::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QDnsLookup::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("nameChanged(const QString &)", "nameChanged", gsi::arg("name"), "@brief Signal declaration for QDnsLookup::nameChanged(const QString &name)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QHostAddress & > ("nameserverChanged(const QHostAddress &)", "nameserverChanged", gsi::arg("nameserver"), "@brief Signal declaration for QDnsLookup::nameserverChanged(const QHostAddress &nameserver)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QDnsLookup::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QDnsLookup::Type>::target_type & > ("typeChanged(QDnsLookup::Type)", "typeChanged", gsi::arg("type"), "@brief Signal declaration for QDnsLookup::typeChanged(QDnsLookup::Type type)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDnsLookup::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDnsLookup::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QDnsLookup> decl_QDnsLookup (qtdecl_QObject (), "QtNetwork", "QDnsLookup_Native",
  methods_QDnsLookup (),
  "@hide\n@alias QDnsLookup");

GSI_QTNETWORK_PUBLIC gsi::Class<QDnsLookup> &qtdecl_QDnsLookup () { return decl_QDnsLookup; }

}


class QDnsLookup_Adaptor : public QDnsLookup, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDnsLookup_Adaptor();

  //  [adaptor ctor] QDnsLookup::QDnsLookup(QObject *parent)
  QDnsLookup_Adaptor() : QDnsLookup()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDnsLookup::QDnsLookup(QObject *parent)
  QDnsLookup_Adaptor(QObject *parent) : QDnsLookup(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, QObject *parent)
  QDnsLookup_Adaptor(QDnsLookup::Type type, const QString &name) : QDnsLookup(type, name)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, QObject *parent)
  QDnsLookup_Adaptor(QDnsLookup::Type type, const QString &name, QObject *parent) : QDnsLookup(type, name, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, const QHostAddress &nameserver, QObject *parent)
  QDnsLookup_Adaptor(QDnsLookup::Type type, const QString &name, const QHostAddress &nameserver) : QDnsLookup(type, name, nameserver)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, const QHostAddress &nameserver, QObject *parent)
  QDnsLookup_Adaptor(QDnsLookup::Type type, const QString &name, const QHostAddress &nameserver, QObject *parent) : QDnsLookup(type, name, nameserver, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QDnsLookup::isSignalConnected(const QMetaMethod &signal)
  bool fp_QDnsLookup_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QDnsLookup::isSignalConnected(signal);
  }

  //  [expose] int QDnsLookup::receivers(const char *signal)
  int fp_QDnsLookup_receivers_c1731 (const char *signal) const {
    return QDnsLookup::receivers(signal);
  }

  //  [expose] QObject *QDnsLookup::sender()
  QObject * fp_QDnsLookup_sender_c0 () const {
    return QDnsLookup::sender();
  }

  //  [expose] int QDnsLookup::senderSignalIndex()
  int fp_QDnsLookup_senderSignalIndex_c0 () const {
    return QDnsLookup::senderSignalIndex();
  }

  //  [emitter impl] void QDnsLookup::destroyed(QObject *)
  void emitter_QDnsLookup_destroyed_1302(QObject *arg1)
  {
    emit QDnsLookup::destroyed(arg1);
  }

  //  [adaptor impl] bool QDnsLookup::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QDnsLookup::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QDnsLookup_Adaptor, bool, QEvent *>(&QDnsLookup_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QDnsLookup::event(arg1);
    }
  }

  //  [adaptor impl] bool QDnsLookup::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QDnsLookup::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QDnsLookup_Adaptor, bool, QObject *, QEvent *>(&QDnsLookup_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QDnsLookup::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QDnsLookup::finished()
  void emitter_QDnsLookup_finished_0()
  {
    emit QDnsLookup::finished();
  }

  //  [emitter impl] void QDnsLookup::nameChanged(const QString &name)
  void emitter_QDnsLookup_nameChanged_2025(const QString &name)
  {
    emit QDnsLookup::nameChanged(name);
  }

  //  [emitter impl] void QDnsLookup::nameserverChanged(const QHostAddress &nameserver)
  void emitter_QDnsLookup_nameserverChanged_2518(const QHostAddress &nameserver)
  {
    emit QDnsLookup::nameserverChanged(nameserver);
  }

  //  [emitter impl] void QDnsLookup::objectNameChanged(const QString &objectName)
  void emitter_QDnsLookup_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QDnsLookup::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QDnsLookup::typeChanged(QDnsLookup::Type type)
  void emitter_QDnsLookup_typeChanged_1978(QDnsLookup::Type type)
  {
    emit QDnsLookup::typeChanged(type);
  }

  //  [adaptor impl] void QDnsLookup::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QDnsLookup::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QDnsLookup_Adaptor, QChildEvent *>(&QDnsLookup_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QDnsLookup::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QDnsLookup::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QDnsLookup::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QDnsLookup_Adaptor, QEvent *>(&QDnsLookup_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QDnsLookup::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QDnsLookup::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QDnsLookup::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QDnsLookup_Adaptor, const QMetaMethod &>(&QDnsLookup_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QDnsLookup::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QDnsLookup::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QDnsLookup::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QDnsLookup_Adaptor, QTimerEvent *>(&QDnsLookup_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QDnsLookup::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QDnsLookup_Adaptor::~QDnsLookup_Adaptor() { }

//  Constructor QDnsLookup::QDnsLookup(QObject *parent) (adaptor class)

static void _init_ctor_QDnsLookup_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QDnsLookup_Adaptor> ();
}

static void _call_ctor_QDnsLookup_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QDnsLookup_Adaptor *> (new QDnsLookup_Adaptor (arg1));
}


//  Constructor QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, QObject *parent) (adaptor class)

static void _init_ctor_QDnsLookup_Adaptor_5089 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QDnsLookup::Type>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QDnsLookup_Adaptor> ();
}

static void _call_ctor_QDnsLookup_Adaptor_5089 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDnsLookup::Type>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QDnsLookup::Type>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QObject *arg3 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QDnsLookup_Adaptor *> (new QDnsLookup_Adaptor (qt_gsi::QtToCppAdaptor<QDnsLookup::Type>(arg1).cref(), arg2, arg3));
}


//  Constructor QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, const QHostAddress &nameserver, QObject *parent) (adaptor class)

static void _init_ctor_QDnsLookup_Adaptor_7499 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QDnsLookup::Type>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("nameserver");
  decl->add_arg<const QHostAddress & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_3);
  decl->set_return_new<QDnsLookup_Adaptor> ();
}

static void _call_ctor_QDnsLookup_Adaptor_7499 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDnsLookup::Type>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QDnsLookup::Type>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const QHostAddress &arg3 = gsi::arg_reader<const QHostAddress & >() (args, heap);
  QObject *arg4 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QDnsLookup_Adaptor *> (new QDnsLookup_Adaptor (qt_gsi::QtToCppAdaptor<QDnsLookup::Type>(arg1).cref(), arg2, arg3, arg4));
}


// void QDnsLookup::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QDnsLookup_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QDnsLookup::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDnsLookup_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QDnsLookup::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QDnsLookup_Adaptor *)cls)->emitter_QDnsLookup_destroyed_1302 (arg1);
}


// void QDnsLookup::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QDnsLookup_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QDnsLookup::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDnsLookup_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDnsLookup_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QDnsLookup::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDnsLookup_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QDnsLookup_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QDnsLookup::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QDnsLookup_Adaptor *)cls)->emitter_QDnsLookup_finished_0 ();
}


// exposed bool QDnsLookup::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QDnsLookup_Adaptor *)cls)->fp_QDnsLookup_isSignalConnected_c2394 (arg1));
}


// emitter void QDnsLookup::nameChanged(const QString &name)

static void _init_emitter_nameChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_nameChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QDnsLookup_Adaptor *)cls)->emitter_QDnsLookup_nameChanged_2025 (arg1);
}


// emitter void QDnsLookup::nameserverChanged(const QHostAddress &nameserver)

static void _init_emitter_nameserverChanged_2518 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nameserver");
  decl->add_arg<const QHostAddress & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_nameserverChanged_2518 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = gsi::arg_reader<const QHostAddress & >() (args, heap);
  ((QDnsLookup_Adaptor *)cls)->emitter_QDnsLookup_nameserverChanged_2518 (arg1);
}


// emitter void QDnsLookup::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QDnsLookup_Adaptor *)cls)->emitter_QDnsLookup_objectNameChanged_4567 (arg1);
}


// exposed int QDnsLookup::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QDnsLookup_Adaptor *)cls)->fp_QDnsLookup_receivers_c1731 (arg1));
}


// exposed QObject *QDnsLookup::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QDnsLookup_Adaptor *)cls)->fp_QDnsLookup_sender_c0 ());
}


// exposed int QDnsLookup::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDnsLookup_Adaptor *)cls)->fp_QDnsLookup_senderSignalIndex_c0 ());
}


// void QDnsLookup::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDnsLookup_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QDnsLookup_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QDnsLookup::typeChanged(QDnsLookup::Type type)

static void _init_emitter_typeChanged_1978 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QDnsLookup::Type>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_typeChanged_1978 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDnsLookup::Type>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QDnsLookup::Type>::target_type & >() (args, heap);
  ((QDnsLookup_Adaptor *)cls)->emitter_QDnsLookup_typeChanged_1978 (arg1);
}


namespace gsi
{

gsi::Class<QDnsLookup> &qtdecl_QDnsLookup ();

static gsi::Methods methods_QDnsLookup_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDnsLookup::QDnsLookup(QObject *parent)\nThis method creates an object of class QDnsLookup.", &_init_ctor_QDnsLookup_Adaptor_1302, &_call_ctor_QDnsLookup_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, QObject *parent)\nThis method creates an object of class QDnsLookup.", &_init_ctor_QDnsLookup_Adaptor_5089, &_call_ctor_QDnsLookup_Adaptor_5089);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDnsLookup::QDnsLookup(QDnsLookup::Type type, const QString &name, const QHostAddress &nameserver, QObject *parent)\nThis method creates an object of class QDnsLookup.", &_init_ctor_QDnsLookup_Adaptor_7499, &_call_ctor_QDnsLookup_Adaptor_7499);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QDnsLookup::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QDnsLookup::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QDnsLookup::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QDnsLookup::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QDnsLookup::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QDnsLookup::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QDnsLookup::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QDnsLookup::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_nameChanged", "@brief Emitter for signal void QDnsLookup::nameChanged(const QString &name)\nCall this method to emit this signal.", false, &_init_emitter_nameChanged_2025, &_call_emitter_nameChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_nameserverChanged", "@brief Emitter for signal void QDnsLookup::nameserverChanged(const QHostAddress &nameserver)\nCall this method to emit this signal.", false, &_init_emitter_nameserverChanged_2518, &_call_emitter_nameserverChanged_2518);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QDnsLookup::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QDnsLookup::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QDnsLookup::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QDnsLookup::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QDnsLookup::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_typeChanged", "@brief Emitter for signal void QDnsLookup::typeChanged(QDnsLookup::Type type)\nCall this method to emit this signal.", false, &_init_emitter_typeChanged_1978, &_call_emitter_typeChanged_1978);
  return methods;
}

gsi::Class<QDnsLookup_Adaptor> decl_QDnsLookup_Adaptor (qtdecl_QDnsLookup (), "QtNetwork", "QDnsLookup",
  methods_QDnsLookup_Adaptor (),
  "@qt\n@brief Binding of QDnsLookup");

}


//  Implementation of the enum wrapper class for QDnsLookup::Error
namespace qt_gsi
{

static gsi::Enum<QDnsLookup::Error> decl_QDnsLookup_Error_Enum ("QtNetwork", "QDnsLookup_Error",
    gsi::enum_const ("NoError", QDnsLookup::NoError, "@brief Enum constant QDnsLookup::NoError") +
    gsi::enum_const ("ResolverError", QDnsLookup::ResolverError, "@brief Enum constant QDnsLookup::ResolverError") +
    gsi::enum_const ("OperationCancelledError", QDnsLookup::OperationCancelledError, "@brief Enum constant QDnsLookup::OperationCancelledError") +
    gsi::enum_const ("InvalidRequestError", QDnsLookup::InvalidRequestError, "@brief Enum constant QDnsLookup::InvalidRequestError") +
    gsi::enum_const ("InvalidReplyError", QDnsLookup::InvalidReplyError, "@brief Enum constant QDnsLookup::InvalidReplyError") +
    gsi::enum_const ("ServerFailureError", QDnsLookup::ServerFailureError, "@brief Enum constant QDnsLookup::ServerFailureError") +
    gsi::enum_const ("ServerRefusedError", QDnsLookup::ServerRefusedError, "@brief Enum constant QDnsLookup::ServerRefusedError") +
    gsi::enum_const ("NotFoundError", QDnsLookup::NotFoundError, "@brief Enum constant QDnsLookup::NotFoundError"),
  "@qt\n@brief This class represents the QDnsLookup::Error enum");

static gsi::QFlagsClass<QDnsLookup::Error > decl_QDnsLookup_Error_Enums ("QtNetwork", "QDnsLookup_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QDnsLookup::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDnsLookup> inject_QDnsLookup_Error_Enum_in_parent (decl_QDnsLookup_Error_Enum.defs ());
static gsi::ClassExt<QDnsLookup> decl_QDnsLookup_Error_Enum_as_child (decl_QDnsLookup_Error_Enum, "Error");
static gsi::ClassExt<QDnsLookup> decl_QDnsLookup_Error_Enums_as_child (decl_QDnsLookup_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QDnsLookup::Type
namespace qt_gsi
{

static gsi::Enum<QDnsLookup::Type> decl_QDnsLookup_Type_Enum ("QtNetwork", "QDnsLookup_Type",
    gsi::enum_const ("A", QDnsLookup::A, "@brief Enum constant QDnsLookup::A") +
    gsi::enum_const ("AAAA", QDnsLookup::AAAA, "@brief Enum constant QDnsLookup::AAAA") +
    gsi::enum_const ("ANY", QDnsLookup::ANY, "@brief Enum constant QDnsLookup::ANY") +
    gsi::enum_const ("CNAME", QDnsLookup::CNAME, "@brief Enum constant QDnsLookup::CNAME") +
    gsi::enum_const ("MX", QDnsLookup::MX, "@brief Enum constant QDnsLookup::MX") +
    gsi::enum_const ("NS", QDnsLookup::NS, "@brief Enum constant QDnsLookup::NS") +
    gsi::enum_const ("PTR", QDnsLookup::PTR, "@brief Enum constant QDnsLookup::PTR") +
    gsi::enum_const ("SRV", QDnsLookup::SRV, "@brief Enum constant QDnsLookup::SRV") +
    gsi::enum_const ("TXT", QDnsLookup::TXT, "@brief Enum constant QDnsLookup::TXT"),
  "@qt\n@brief This class represents the QDnsLookup::Type enum");

static gsi::QFlagsClass<QDnsLookup::Type > decl_QDnsLookup_Type_Enums ("QtNetwork", "QDnsLookup_QFlags_Type",
  "@qt\n@brief This class represents the QFlags<QDnsLookup::Type> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDnsLookup> inject_QDnsLookup_Type_Enum_in_parent (decl_QDnsLookup_Type_Enum.defs ());
static gsi::ClassExt<QDnsLookup> decl_QDnsLookup_Type_Enum_as_child (decl_QDnsLookup_Type_Enum, "Type");
static gsi::ClassExt<QDnsLookup> decl_QDnsLookup_Type_Enums_as_child (decl_QDnsLookup_Type_Enums, "QFlags_Type");

}

