/*
Copyright (c) 2015 - present Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "CUDA2HIP.h"

// Map of all functions
const std::map<llvm::StringRef, hipCounter> CUDA_DNN_FUNCTION_MAP {

  // NOTE: MIOPEN_EXPORT miopenStatus_t miopenGetVersion(size_t* major, size_t* minor, size_t* patch) and size_t CUDNNWINAPI cudnnGetVersion(void) have different signatures
  {"cudnnGetVersion",                                          {"hipdnnGetVersion",                                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetCudartVersion",                                    {"hipdnnGetCudartVersion",                                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetMaxDeviceVersion",                                 {"hipdnnGetMaxDeviceVersion",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnQueryRuntimeError",                                   {"hipdnnQueryRuntimeError",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetProperty",                                         {"hipdnnGetProperty",                                         "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetErrorString",                                      {"hipdnnGetErrorString",                                      "miopenGetErrorString",                                               CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnIm2Col",                                              {"hipdnnIm2Col",                                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnCreate",                                              {"hipdnnCreate",                                              "miopenCreate",                                                       CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDestroy",                                             {"hipdnnDestroy",                                             "miopenDestroy",                                                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetStream",                                           {"hipdnnSetStream",                                           "miopenSetStream",                                                    CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetStream",                                           {"hipdnnGetStream",                                           "miopenGetStream",                                                    CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetCallback",                                         {"hipdnnSetCallback",                                         "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetCallback",                                         {"hipdnnGetCallback",                                         "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnAdvInferVersionCheck",                                {"hipdnnAdvInferVersionCheck",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnAdvTrainVersionCheck",                                {"hipdnnAdvTrainVersionCheck",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnCnnInferVersionCheck",                                {"hipdnnCnnInferVersionCheck",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnCnnTrainVersionCheck",                                {"hipdnnCnnTrainVersionCheck",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnOpsInferVersionCheck",                                {"hipdnnOpsInferVersionCheck",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnOpsTrainVersionCheck",                                {"hipdnnOpsTrainVersionCheck",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Tensor functions
  {"cudnnCreateTensorDescriptor",                              {"hipdnnCreateTensorDescriptor",                              "miopenCreateTensorDescriptor",                                       CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetTensor4dDescriptor",                               {"hipdnnSetTensor4dDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnSetTensor4dDescriptorEx",                             {"hipdnnSetTensor4dDescriptorEx",                             "miopenSet4dTensorDescriptorEx",                                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetTensor4dDescriptor",                               {"hipdnnGetTensor4dDescriptor",                               "miopenGet4dTensorDescriptor",                                        CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetTensorNdDescriptor",                               {"hipdnnSetTensorNdDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnSetTensorNdDescriptorEx",                             {"hipdnnSetTensorNdDescriptorEx",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetTensorNdDescriptor",                               {"hipdnnGetTensorNdDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetTensorSizeInBytes",                                {"hipdnnGetTensorSizeInBytes",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyTensorDescriptor",                             {"hipdnnDestroyTensorDescriptor",                             "miopenDestroyTensorDescriptor",                                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnTransformTensor",                                     {"hipdnnTransformTensor",                                     "miopenTransformTensor",                                              CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnTransformTensorEx",                                   {"hipdnnTransformTensorEx",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnInitTransformDest",                                   {"hipdnnInitTransformDest",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnCreateTensorTransformDescriptor",                     {"hipdnnCreateTensorTransformDescriptor",                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetTensorTransformDescriptor",                        {"hipdnnSetTensorTransformDescriptor",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetTensorTransformDescriptor",                        {"hipdnnGetTensorTransformDescriptor",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyTensorTransformDescriptor",                    {"hipdnnDestroyTensorTransformDescriptor",                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnAddTensor",                                           {"hipdnnAddTensor",                                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnCreateOpTensorDescriptor",                            {"hipdnnCreateOpTensorDescriptor",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnSetOpTensorDescriptor",                               {"hipdnnSetOpTensorDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetOpTensorDescriptor",                               {"hipdnnGetOpTensorDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnDestroyOpTensorDescriptor",                           {"hipdnnDestroyOpTensorDescriptor",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnOpTensor",                                            {"hipdnnOpTensor",                                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetFoldedConvBackwardDataDescriptors",                {"hipdnnGetFoldedConvBackwardDataDescriptors",                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Reduce Tensor functions
  {"cudnnCreateReduceTensorDescriptor",                        {"hipdnnCreateReduceTensorDescriptor",                        "miopenCreateReduceTensorDescriptor",                                 CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetReduceTensorDescriptor",                           {"hipdnnSetReduceTensorDescriptor",                           "miopenSetReduceTensorDescriptor",                                    CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetReduceTensorDescriptor",                           {"hipdnnGetReduceTensorDescriptor",                           "miopenGetReduceTensorDescriptor",                                    CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDestroyReduceTensorDescriptor",                       {"hipdnnDestroyReduceTensorDescriptor",                       "miopenDestroyReduceTensorDescriptor",                                CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetReductionIndicesSize",                             {"hipdnnGetReductionIndicesSize",                             "miopenGetReductionIndicesSize",                                      CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnGetReductionWorkspaceSize",                           {"hipdnnGetReductionWorkspaceSize",                           "miopenGetReductionWorkspaceSize",                                    CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnReduceTensor",                                        {"hipdnnReduceTensor",                                        "miopenReduceTensor",                                                 CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetTensor",                                           {"hipdnnSetTensor",                                           "miopenSetTensor",                                                    CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnScaleTensor",                                         {"hipdnnScaleTensor",                                         "miopenScaleTensor",                                                  CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDeriveNormTensorDescriptor",                          {"hipdnnDeriveNormTensorDescriptor",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Filter functions
  {"cudnnCreateFilterDescriptor",                              {"hipdnnCreateFilterDescriptor",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnSetFilter4dDescriptor",                               {"hipdnnSetFilter4dDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetFilter4dDescriptor",                               {"hipdnnGetFilter4dDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnSetFilterNdDescriptor",                               {"hipdnnSetFilterNdDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetFilterNdDescriptor",                               {"hipdnnGetFilterNdDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetFilterSizeInBytes",                                {"hipdnnGetFilterSizeInBytes",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnTransformFilter",                                     {"hipdnnTransformFilter",                                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyFilterDescriptor",                             {"hipdnnDestroyFilterDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnReorderFilterAndBias",                                {"hipdnnReorderFilterAndBias",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Convolution functions
  {"cudnnCreateConvolutionDescriptor",                         {"hipdnnCreateConvolutionDescriptor",                         "miopenCreateConvolutionDescriptor",                                  CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetConvolutionMathType",                              {"hipdnnSetConvolutionMathType",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolutionMathType",                              {"hipdnnGetConvolutionMathType",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetConvolutionGroupCount",                            {"hipdnnSetConvolutionGroupCount",                            "miopenSetConvolutionGroupCount",                                     CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetConvolutionGroupCount",                            {"hipdnnGetConvolutionGroupCount",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetConvolutionReorderType",                           {"hipdnnSetConvolutionReorderType",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetConvolutionReorderType",                           {"hipdnnGetConvolutionReorderType",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetConvolution2dDescriptor",                          {"hipdnnSetConvolution2dDescriptor",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolution2dDescriptor",                          {"hipdnnGetConvolution2dDescriptor",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolution2dForwardOutputDim",                    {"hipdnnGetConvolution2dForwardOutputDim",                    "miopenGetConvolutionForwardOutputDim",                               CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetConvolutionNdDescriptor",                          {"hipdnnSetConvolutionNdDescriptor",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolutionNdDescriptor",                          {"hipdnnGetConvolutionNdDescriptor",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetConvolutionNdForwardOutputDim",                    {"hipdnnGetConvolutionNdForwardOutputDim",                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyConvolutionDescriptor",                        {"hipdnnDestroyConvolutionDescriptor",                        "miopenDestroyConvolutionDescriptor",                                 CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetConvolutionForwardAlgorithmMaxCount",              {"hipdnnGetConvolutionForwardAlgorithmMaxCount",              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnFindConvolutionForwardAlgorithm",                     {"hipdnnFindConvolutionForwardAlgorithm",                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnFindConvolutionForwardAlgorithmEx",                   {"hipdnnFindConvolutionForwardAlgorithmEx",                   "miopenFindConvolutionForwardAlgorithm",                              CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetConvolutionForwardAlgorithm",                      {"hipdnnGetConvolutionForwardAlgorithm",                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cudnnGetConvolutionForwardAlgorithm_v7",                   {"hipdnnGetConvolutionForwardAlgorithm_v7",                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetConvolutionForwardWorkspaceSize",                  {"hipdnnGetConvolutionForwardWorkspaceSize",                  "miopenConvolutionForwardGetWorkSpaceSize",                           CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnConvolutionForward",                                  {"hipdnnConvolutionForward",                                  "miopenConvolutionForward",                                           CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnConvolutionBiasActivationForward",                    {"hipdnnConvolutionBiasActivationForward",                    "miopenConvolutionBiasActivationForward",                             CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnConvolutionBackwardBias",                             {"hipdnnConvolutionBackwardBias",                             "miopenConvolutionBackwardBias",                                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetConvolutionBackwardFilterAlgorithmMaxCount",       {"hipdnnGetConvolutionBackwardFilterAlgorithmMaxCount",       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnFindConvolutionBackwardFilterAlgorithm",              {"hipdnnFindConvolutionBackwardFilterAlgorithm",              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnFindConvolutionBackwardFilterAlgorithmEx",            {"hipdnnFindConvolutionBackwardFilterAlgorithmEx",            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolutionBackwardFilterAlgorithm",               {"hipdnnGetConvolutionBackwardFilterAlgorithm",               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cudnnGetConvolutionBackwardFilterAlgorithm_v7",            {"hipdnnGetConvolutionBackwardFilterAlgorithm_v7",            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetConvolutionBackwardFilterWorkspaceSize",           {"hipdnnGetConvolutionBackwardFilterWorkspaceSize",           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnConvolutionBackwardFilter",                           {"hipdnnConvolutionBackwardFilter",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolutionBackwardDataAlgorithmMaxCount",         {"hipdnnGetConvolutionBackwardDataAlgorithmMaxCount",         "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnFindConvolutionBackwardDataAlgorithm",                {"hipdnnFindConvolutionBackwardDataAlgorithm",                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnFindConvolutionBackwardDataAlgorithmEx",              {"hipdnnFindConvolutionBackwardDataAlgorithmEx",              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetConvolutionBackwardDataAlgorithm",                 {"hipdnnGetConvolutionBackwardDataAlgorithm",                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cudnnGetConvolutionBackwardDataAlgorithm_v7",              {"hipdnnGetConvolutionBackwardDataAlgorithm_v7",              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetConvolutionBackwardDataWorkspaceSize",             {"hipdnnGetConvolutionBackwardDataWorkspaceSize",             "miopenConvolutionBackwardDataGetWorkSpaceSize",                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnConvolutionBackwardData",                             {"hipdnnConvolutionBackwardData",                             "miopenConvolutionBackwardData",                                      CONV_LIB_FUNC, API_DNN, 2}},

  // cuDNN Softmax functions
  {"cudnnSoftmaxForward",                                      {"hipdnnSoftmaxForward",                                      "miopenSoftmaxForward_V2",                                            CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSoftmaxBackward",                                     {"hipdnnSoftmaxBackward",                                     "miopenSoftmaxBackward_V2",                                           CONV_LIB_FUNC, API_DNN, 2}},

  // cuDNN Pooling functions
  {"cudnnCreatePoolingDescriptor",                             {"hipdnnCreatePoolingDescriptor",                             "miopenCreatePoolingDescriptor",                                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetPooling2dDescriptor",                              {"hipdnnSetPooling2dDescriptor",                              "miopenSet2dPoolingDescriptor",                                       CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetPooling2dDescriptor",                              {"hipdnnGetPooling2dDescriptor",                              "miopenGet2dPoolingDescriptor",                                       CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetPoolingNdDescriptor",                              {"hipdnnSetPoolingNdDescriptor",                              "miopenSetNdPoolingDescriptor",                                       CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetPoolingNdDescriptor",                              {"hipdnnGetPoolingNdDescriptor",                              "miopenGetNdPoolingDescriptor",                                       CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnGetPoolingNdForwardOutputDim",                        {"hipdnnGetPoolingNdForwardOutputDim",                        "miopenGetPoolingNdForwardOutputDim",                                 CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnGetPooling2dForwardOutputDim",                        {"hipdnnGetPooling2dForwardOutputDim",                        "miopenGetPoolingForwardOutputDim",                                   CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDestroyPoolingDescriptor",                            {"hipdnnDestroyPoolingDescriptor",                            "miopenDestroyPoolingDescriptor",                                     CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnPoolingForward",                                      {"hipdnnPoolingForward",                                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnPoolingBackward",                                     {"hipdnnPoolingBackward",                                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},

  // cuDNN Activation functions
  {"cudnnCreateActivationDescriptor",                          {"hipdnnCreateActivationDescriptor",                          "miopenCreateActivationDescriptor",                                   CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetActivationDescriptor",                             {"hipdnnSetActivationDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnGetActivationDescriptor",                             {"hipdnnGetActivationDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnDestroyActivationDescriptor",                         {"hipdnnDestroyActivationDescriptor",                         "miopenDestroyActivationDescriptor",                                  CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnActivationForward",                                   {"hipdnnActivationForward",                                   "miopenActivationForward",                                            CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnActivationBackward",                                  {"hipdnnActivationBackward",                                  "miopenActivationBackward",                                           CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetActivationDescriptorSwishBeta",                    {"hipdnnSetActivationDescriptorSwishBeta",                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetActivationDescriptorSwishBeta",                    {"hipdnnGetActivationDescriptorSwishBeta",                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN LRN functions
  {"cudnnCreateLRNDescriptor",                                 {"hipdnnCreateLRNDescriptor",                                 "miopenCreateLRNDescriptor",                                          CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnSetLRNDescriptor",                                    {"hipdnnSetLRNDescriptor",                                    "miopenSetLRNDescriptor",                                             CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetLRNDescriptor",                                    {"hipdnnGetLRNDescriptor",                                    "miopenGetLRNDescriptor",                                             CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDestroyLRNDescriptor",                                {"hipdnnDestroyLRNDescriptor",                                "miopenDestroyLRNDescriptor",                                         CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnLRNCrossChannelForward",                              {"hipdnnLRNCrossChannelForward",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},
  {"cudnnLRNCrossChannelBackward",                             {"hipdnnLRNCrossChannelBackward",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED}},

  // cuDNN Divisive Normalization functions
  {"cudnnDivisiveNormalizationForward",                        {"hipdnnDivisiveNormalizationForward",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDivisiveNormalizationBackward",                       {"hipdnnDivisiveNormalizationBackward",                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Batch Normalization functions
  {"cudnnDeriveBNTensorDescriptor",                            {"hipdnnDeriveBNTensorDescriptor",                            "miopenDeriveBNTensorDescriptor",                                     CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnBatchNormalizationForwardTraining",                   {"hipdnnBatchNormalizationForwardTraining",                   "miopenBatchNormalizationForwardTraining",                            CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnBatchNormalizationForwardTrainingEx",                 {"hipdnnBatchNormalizationForwardTrainingEx",                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBatchNormalizationForwardInference",                  {"hipdnnBatchNormalizationForwardInference",                  "miopenBatchNormalizationForwardInference",                           CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnBatchNormalizationBackward",                          {"hipdnnBatchNormalizationBackward",                          "miopenBatchNormalizationBackward",                                   CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnBatchNormalizationBackwardEx",                        {"hipdnnBatchNormalizationBackwardEx",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize", {"hipdnnGetBatchNormalizationForwardTrainingExWorkspaceSize", "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetBatchNormalizationBackwardExWorkspaceSize",        {"hipdnnGetBatchNormalizationBackwardExWorkspaceSize",        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetBatchNormalizationTrainingExReserveSpaceSize",     {"hipdnnGetBatchNormalizationTrainingExReserveSpaceSize",     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnNormalizationForwardInference",                       {"hipdnnNormalizationForwardInference",                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetNormalizationForwardTrainingWorkspaceSize",        {"hipdnnGetNormalizationForwardTrainingWorkspaceSize",        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetNormalizationBackwardWorkspaceSize",               {"hipdnnGetNormalizationBackwardWorkspaceSize",               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetNormalizationTrainingReserveSpaceSize",            {"hipdnnGetNormalizationTrainingReserveSpaceSize",            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnNormalizationForwardTraining",                        {"hipdnnNormalizationForwardTraining",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnNormalizationBackward",                               {"hipdnnNormalizationBackward",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Spatial Transformer functions
  {"cudnnCreateSpatialTransformerDescriptor",                  {"hipdnnCreateSpatialTransformerDescriptor",                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetSpatialTransformerNdDescriptor",                   {"hipdnnSetSpatialTransformerNdDescriptor",                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroySpatialTransformerDescriptor",                 {"hipdnnDestroySpatialTransformerDescriptor",                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSpatialTfGridGeneratorForward",                       {"hipdnnSpatialTfGridGeneratorForward",                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSpatialTfGridGeneratorBackward",                      {"hipdnnSpatialTfGridGeneratorBackward",                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSpatialTfSamplerForward",                             {"hipdnnSpatialTfSamplerForward",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSpatialTfSamplerBackward",                            {"hipdnnSpatialTfSamplerBackward",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Dropout functions
  {"cudnnCreateDropoutDescriptor",                             {"hipdnnCreateDropoutDescriptor",                             "miopenCreateDropoutDescriptor",                                      CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDestroyDropoutDescriptor",                            {"hipdnnDestroyDropoutDescriptor",                            "miopenDestroyDropoutDescriptor",                                     CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDropoutGetStatesSize",                                {"hipdnnDropoutGetStatesSize",                                "miopenDropoutGetStatesSize",                                         CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDropoutGetReserveSpaceSize",                          {"hipdnnDropoutGetReserveSpaceSize",                          "miopenDropoutGetReserveSpaceSize",                                   CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnSetDropoutDescriptor",                                {"hipdnnSetDropoutDescriptor",                                "miopenSetDropoutDescriptor",                                         CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetDropoutDescriptor",                                {"hipdnnGetDropoutDescriptor",                                "miopenGetDropoutDescriptor",                                         CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnRestoreDropoutDescriptor",                            {"hipdnnRestoreDropoutDescriptor",                            "miopenRestoreDropoutDescriptor",                                     CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnDropoutForward",                                      {"hipdnnDropoutForward",                                      "miopenDropoutForward",                                               CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnDropoutBackward",                                     {"hipdnnDropoutBackward",                                     "miopenDropoutBackward",                                              CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},

  // cuDNN RNN functions
  {"cudnnCreateRNNDescriptor",                                 {"hipdnnCreateRNNDescriptor",                                 "miopenCreateRNNDescriptor",                                          CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnDestroyRNNDescriptor",                                {"hipdnnDestroyRNNDescriptor",                                "miopenDestroyRNNDescriptor",                                         CONV_LIB_FUNC, API_DNN, 2}},
  {"cudnnGetRNNForwardInferenceAlgorithmMaxCount",             {"hipdnnGetRNNForwardInferenceAlgorithmMaxCount",             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnFindRNNForwardInferenceAlgorithmEx",                  {"hipdnnFindRNNForwardInferenceAlgorithmEx",                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNForwardTrainingAlgorithmMaxCount",              {"hipdnnGetRNNForwardTrainingAlgorithmMaxCount",              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnFindRNNForwardTrainingAlgorithmEx",                   {"hipdnnFindRNNForwardTrainingAlgorithmEx",                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNBackwardDataAlgorithmMaxCount",                 {"hipdnnGetRNNBackwardDataAlgorithmMaxCount",                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnFindRNNBackwardDataAlgorithmEx",                      {"hipdnnFindRNNBackwardDataAlgorithmEx",                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNBackwardWeightsAlgorithmMaxCount",              {"hipdnnGetRNNBackwardWeightsAlgorithmMaxCount",              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnFindRNNBackwardWeightsAlgorithmEx",                   {"hipdnnFindRNNBackwardWeightsAlgorithmEx",                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnCreatePersistentRNNPlan",                             {"hipdnnCreatePersistentRNNPlan",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSetPersistentRNNPlan",                                {"hipdnnSetPersistentRNNPlan",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnDestroyPersistentRNNPlan",                            {"hipdnnDestroyPersistentRNNPlan",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  // NOTE" hipdnnSetRNNDescriptor has additional argument hipdnnRNNBiasMode_t *biasMode without default value
  {"cudnnSetRNNDescriptor",                                    {"hipdnnSetRNNDescriptor",                                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  // NOTE" hipdnnGetRNNDescriptor has additional argument hipdnnRNNBiasMode_t *biasMode without default value
  {"cudnnGetRNNDescriptor",                                    {"hipdnnGetRNNDescriptor",                                    "miopenGetRNNDescriptor_V2",                                          CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cudnnGetRNNDescriptor_v6",                                 {"hipdnnGetRNNDescriptor_v6",                                 "miopenGetRNNDescriptor_V2",                                          CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNDescriptor_v8",                                 {"hipdnnGetRNNDescriptor_v8",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetRNNProjectionLayers",                              {"hipdnnSetRNNProjectionLayers",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNProjectionLayers",                              {"hipdnnGetRNNProjectionLayers",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSetRNNAlgorithmDescriptor",                           {"hipdnnSetRNNAlgorithmDescriptor",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSetRNNMatrixMathType",                                {"hipdnnSetRNNMatrixMathType",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNMatrixMathType",                                {"hipdnnGetRNNMatrixMathType",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNWorkspaceSize",                                 {"hipdnnGetRNNWorkspaceSize",                                 "miopenGetRNNWorkspaceSize",                                          CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnGetRNNTrainingReserveSize",                           {"hipdnnGetRNNTrainingReserveSize",                           "miopenGetRNNTrainingReserveSize",                                    CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnGetRNNParamsSize",                                    {"hipdnnGetRNNParamsSize",                                    "miopenGetRNNParamsSize",                                             CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnGetRNNLinLayerMatrixParams",                          {"hipdnnGetRNNLinLayerMatrixParams",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNLinLayerBiasParams",                            {"hipdnnGetRNNLinLayerBiasParams",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRNNForward",                                          {"hipdnnRNNForward",                                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnRNNForwardInference",                                 {"hipdnnRNNForwardInference",                                 "miopenRNNForwardInference",                                          CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnRNNForwardInferenceEx",                               {"hipdnnRNNForwardInferenceEx",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRNNForwardTraining",                                  {"hipdnnRNNForwardTraining",                                  "miopenRNNForwardTraining",                                           CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnRNNForwardTrainingEx",                                {"hipdnnRNNForwardTrainingEx",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRNNBackwardData",                                     {"hipdnnRNNBackwardData",                                     "miopenRNNBackwardData",                                              CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnRNNBackwardData_v8",                                  {"hipdnnRNNBackwardData_v8",                                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnRNNBackwardDataEx",                                   {"hipdnnRNNBackwardDataEx",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRNNBackwardWeights",                                  {"hipdnnRNNBackwardWeights",                                  "miopenRNNBackwardWeights",                                           CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnRNNBackwardWeights_v8",                               {"hipdnnRNNBackwardWeights_v8",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnRNNBackwardWeightsEx",                                {"hipdnnRNNBackwardWeightsEx",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSetRNNDescriptor_v5",                                 {"hipdnnSetRNNDescriptor_v5",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, ROC_UNSUPPORTED | CUDA_DEPRECATED | CUDA_REMOVED}},
  {"cudnnSetRNNDescriptor_v6",                                 {"hipdnnSetRNNDescriptor_v6",                                 "miopenSetRNNDescriptor_V2",                                          CONV_LIB_FUNC, API_DNN, 2, CUDA_DEPRECATED}},
  {"cudnnSetRNNDescriptor_v8",                                 {"hipdnnSetRNNDescriptor_v8",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetRNNPaddingMode",                                   {"hipdnnSetRNNPaddingMode",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNPaddingMode",                                   {"hipdnnGetRNNPaddingMode",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnCreateRNNDataDescriptor",                             {"hipdnnCreateRNNDataDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyRNNDataDescriptor",                            {"hipdnnDestroyRNNDataDescriptor",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetRNNDataDescriptor",                                {"hipdnnSetRNNDataDescriptor",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetRNNDataDescriptor",                                {"hipdnnGetRNNDataDescriptor",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetRNNBiasMode",                                      {"hipdnnSetRNNBiasMode",                                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetRNNBiasMode",                                      {"hipdnnGetRNNBiasMode",                                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnBuildRNNDynamic",                                     {"hipdnnBuildRNNDynamic",                                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetRNNTempSpaceSizes",                                {"hipdnnGetRNNTempSpaceSizes",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetRNNWeightSpaceSize",                               {"hipdnnGetRNNWeightSpaceSize",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetRNNWeightParams",                                  {"hipdnnGetRNNWeightParams",                                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Connectionist Temporal Classification loss functions
  {"cudnnCreateCTCLossDescriptor",                             {"hipdnnCreateCTCLossDescriptor",                             "miopenCreateCTCLossDescriptor",                                      CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnSetCTCLossDescriptor",                                {"hipdnnSetCTCLossDescriptor",                                "miopenSetCTCLossDescriptor",                                         CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnSetCTCLossDescriptor_v8",                             {"hipdnnSetCTCLossDescriptor_v8",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetCTCLossDescriptorEx",                              {"hipdnnSetCTCLossDescriptorEx",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetCTCLossDescriptor",                                {"hipdnnGetCTCLossDescriptor",                                "miopenGetCTCLossDescriptor",                                         CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnGetCTCLossDescriptor_v8",                             {"hipdnnGetCTCLossDescriptor_v8",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetCTCLossDescriptorEx",                              {"hipdnnGetCTCLossDescriptorEx",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyCTCLossDescriptor",                            {"hipdnnDestroyCTCLossDescriptor",                            "miopenDestroyCTCLossDescriptor",                                     CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnCTCLoss",                                             {"hipdnnCTCLoss",                                             "miopenCTCLoss",                                                      CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnCTCLoss_v8",                                          {"hipdnnCTCLoss_v8",                                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetCTCLossWorkspaceSize",                             {"hipdnnGetCTCLossWorkspaceSize",                             "miopenGetCTCLossWorkspaceSize",                                      CONV_LIB_FUNC, API_DNN, 2, HIP_UNSUPPORTED}},
  {"cudnnGetCTCLossWorkspaceSize_v8",                          {"hipdnnGetCTCLossWorkspaceSize_v8",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Algorithm functions
  {"cudnnCreateAlgorithmDescriptor",                           {"hipdnnCreateAlgorithmDescriptor",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSetAlgorithmDescriptor",                              {"hipdnnSetAlgorithmDescriptor",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetAlgorithmDescriptor",                              {"hipdnnGetAlgorithmDescriptor",                              "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnCopyAlgorithmDescriptor",                             {"hipdnnCopyAlgorithmDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnDestroyAlgorithmDescriptor",                          {"hipdnnDestroyAlgorithmDescriptor",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnCreateAlgorithmPerformance",                          {"hipdnnCreateAlgorithmPerformance",                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSetAlgorithmPerformance",                             {"hipdnnSetAlgorithmPerformance",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetAlgorithmPerformance",                             {"hipdnnGetAlgorithmPerformance",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnDestroyAlgorithmPerformance",                         {"hipdnnDestroyAlgorithmPerformance",                         "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnGetAlgorithmSpaceSize",                               {"hipdnnGetAlgorithmSpaceSize",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnSaveAlgorithm",                                       {"hipdnnSaveAlgorithm",                                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRestoreAlgorithm",                                    {"hipdnnRestoreAlgorithm",                                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},

  // cuDNN Clipping functions
  {"cudnnRNNSetClip",                                          {"hipdnnRNNSetClip",                                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRNNSetClip_v8",                                       {"hipdnnRNNSetClip_v8",                                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnRNNGetClip",                                          {"hipdnnRNNGetClip",                                          "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED | CUDA_DEPRECATED}},
  {"cudnnRNNGetClip_v8",                                       {"hipdnnRNNGetClip_v8",                                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Sequence functions
  {"cudnnCreateSeqDataDescriptor",                             {"hipdnnCreateSeqDataDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroySeqDataDescriptor",                            {"hipdnnDestroySeqDataDescriptor",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetSeqDataDescriptor",                                {"hipdnnSetSeqDataDescriptor",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetSeqDataDescriptor",                                {"hipdnnGetSeqDataDescriptor",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Multihead Attention functions
  {"cudnnCreateAttnDescriptor",                                {"hipdnnCreateAttnDescriptor",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyAttnDescriptor",                               {"hipdnnDestroyAttnDescriptor",                               "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetAttnDescriptor",                                   {"hipdnnSetAttnDescriptor",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetAttnDescriptor",                                   {"hipdnnGetAttnDescriptor",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetMultiHeadAttnBuffers",                             {"hipdnnGetMultiHeadAttnBuffers",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetMultiHeadAttnWeights",                             {"hipdnnGetMultiHeadAttnWeights",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnMultiHeadAttnForward",                                {"hipdnnMultiHeadAttnForward",                                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnMultiHeadAttnBackwardData",                           {"hipdnnMultiHeadAttnBackwardData",                           "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnMultiHeadAttnBackwardWeights",                        {"hipdnnMultiHeadAttnBackwardWeights",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Fuse functions
  {"cudnnCreateFusedOpsConstParamPack",                        {"hipdnnCreateFusedOpsConstParamPack",                        "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyFusedOpsConstParamPack",                       {"hipdnnDestroyFusedOpsConstParamPack",                       "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetFusedOpsConstParamPackAttribute",                  {"hipdnnSetFusedOpsConstParamPackAttribute",                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetFusedOpsConstParamPackAttribute",                  {"hipdnnGetFusedOpsConstParamPackAttribute",                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnCreateFusedOpsVariantParamPack",                      {"hipdnnCreateFusedOpsVariantParamPack",                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyFusedOpsVariantParamPack",                     {"hipdnnDestroyFusedOpsVariantParamPack",                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnSetFusedOpsVariantParamPackAttribute",                {"hipdnnSetFusedOpsVariantParamPackAttribute",                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnGetFusedOpsVariantParamPackAttribute",                {"hipdnnGetFusedOpsVariantParamPackAttribute",                "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnCreateFusedOpsPlan",                                  {"hipdnnCreateFusedOpsPlan",                                  "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnDestroyFusedOpsPlan",                                 {"hipdnnDestroyFusedOpsPlan",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnMakeFusedOpsPlan",                                    {"hipdnnMakeFusedOpsPlan",                                    "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnFusedOpsExecute",                                     {"hipdnnFusedOpsExecute",                                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},

  // cuDNN Backend
  {"cudnnBackendCreateDescriptor",                             {"hipdnnBackendCreateDescriptor",                             "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBackendDestroyDescriptor",                            {"hipdnnBackendDestroyDescriptor",                            "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBackendInitialize",                                   {"hipdnnBackendInitialize",                                   "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBackendFinalize",                                     {"hipdnnBackendFinalize",                                     "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBackendSetAttribute",                                 {"hipdnnBackendSetAttribute",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBackendGetAttribute",                                 {"hipdnnBackendGetAttribute",                                 "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
  {"cudnnBackendExecute",                                      {"hipdnnBackendExecute",                                      "",                                                                   CONV_LIB_FUNC, API_DNN, 2, UNSUPPORTED}},
};

const std::map<llvm::StringRef, cudaAPIversions> CUDA_DNN_FUNCTION_VER_MAP {
  {"cudnnCreateRNNDescriptor",                                 {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyRNNDescriptor",                                {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSetRNNDescriptor_v8",                                 {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetRNNDescriptor_v8",                                 {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnSetRNNDescriptor_v6",                                 {CUDNN_60,  CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNDescriptor_v6",                                 {CUDNN_801, CUDNN_801, CUDA_0   }},
  {"cudnnSetRNNMatrixMathType",                                {CUDNN_705, CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNMatrixMathType",                                {CUDNN_713, CUDNN_801, CUDA_0   }},
  {"cudnnSetRNNBiasMode",                                      {CUDNN_750, CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNBiasMode",                                      {CUDNN_750, CUDNN_801, CUDA_0   }},
  {"cudnnRNNSetClip_v8",                                       {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnRNNGetClip_v8",                                       {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnRNNSetClip",                                          {CUDNN_721, CUDNN_801, CUDA_0   }},
  {"cudnnRNNGetClip",                                          {CUDNN_721, CUDNN_801, CUDA_0   }},
  {"cudnnSetRNNProjectionLayers",                              {CUDNN_713, CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNProjectionLayers",                              {CUDNN_713, CUDNN_801, CUDA_0   }},
  {"cudnnCreatePersistentRNNPlan",                             {CUDNN_60,  CUDNN_801, CUDA_0   }},
  {"cudnnDestroyPersistentRNNPlan",                            {CUDNN_60,  CUDNN_801, CUDA_0   }},
  {"cudnnSetPersistentRNNPlan",                                {CUDNN_60,  CUDNN_801, CUDA_0   }},
  {"cudnnBuildRNNDynamic",                                     {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetRNNWorkspaceSize",                                 {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNTrainingReserveSize",                           {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNTempSpaceSizes",                                {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetRNNParamsSize",                                    {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNWeightSpaceSize",                               {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetRNNLinLayerMatrixParams",                          {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNLinLayerBiasParams",                            {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNWeightParams",                                  {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnRNNForwardInference",                                 {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnSetRNNPaddingMode",                                   {CUDNN_721, CUDNN_801, CUDA_0   }},
  {"cudnnGetRNNPaddingMode",                                   {CUDNN_721, CUDNN_801, CUDA_0   }},
  {"cudnnCreateRNNDataDescriptor",                             {CUDNN_721, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyRNNDataDescriptor",                            {CUDNN_721, CUDA_0,    CUDA_0   }},
  {"cudnnSetRNNDataDescriptor",                                {CUDNN_721, CUDA_0,    CUDA_0   }},
  {"cudnnGetRNNDataDescriptor",                                {CUDNN_721, CUDA_0,    CUDA_0   }},
  {"cudnnRNNForwardInferenceEx",                               {CUDNN_721, CUDNN_801, CUDA_0   }},
  {"cudnnRNNForward",                                          {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnSetRNNAlgorithmDescriptor",                           {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnGetRNNForwardInferenceAlgorithmMaxCount",             {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnFindRNNForwardInferenceAlgorithmEx",                  {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnCreateSeqDataDescriptor",                             {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnDestroySeqDataDescriptor",                            {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnSetSeqDataDescriptor",                                {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnGetSeqDataDescriptor",                                {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnCreateAttnDescriptor",                                {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyAttnDescriptor",                               {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnSetAttnDescriptor",                                   {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnGetAttnDescriptor",                                   {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnGetMultiHeadAttnBuffers",                             {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnGetMultiHeadAttnWeights",                             {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnMultiHeadAttnForward",                                {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnAdvInferVersionCheck",                                {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnRNNForwardTraining",                                  {CUDNN_50,  CUDNN_801, CUDA_0   }},
  {"cudnnRNNBackwardData",                                     {CUDNN_50,  CUDNN_802, CUDA_0   }},
  {"cudnnRNNBackwardData_v8",                                  {CUDNN_802, CUDA_0,    CUDA_0   }},
  {"cudnnRNNBackwardWeights",                                  {CUDNN_50,  CUDNN_802, CUDA_0   }},
  {"cudnnRNNBackwardWeights_v8",                               {CUDNN_802, CUDA_0,    CUDA_0   }},
  {"cudnnRNNForwardTrainingEx",                                {CUDNN_721, CUDNN_801, CUDA_0   }},
  {"cudnnRNNBackwardDataEx",                                   {CUDNN_721, CUDNN_802, CUDA_0   }},
  {"cudnnRNNBackwardWeightsEx",                                {CUDNN_721, CUDNN_802, CUDA_0   }},
  {"cudnnGetRNNForwardTrainingAlgorithmMaxCount",              {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnFindRNNForwardTrainingAlgorithmEx",                   {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnGetRNNBackwardDataAlgorithmMaxCount",                 {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnFindRNNBackwardDataAlgorithmEx",                      {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnGetRNNBackwardWeightsAlgorithmMaxCount",              {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnFindRNNBackwardWeightsAlgorithmEx",                   {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnMultiHeadAttnBackwardData",                           {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnMultiHeadAttnBackwardWeights",                        {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnCreateCTCLossDescriptor",                             {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnSetCTCLossDescriptor",                                {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnSetCTCLossDescriptorEx",                              {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnSetCTCLossDescriptor_v8",                             {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetCTCLossDescriptor",                                {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetCTCLossDescriptorEx",                              {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnGetCTCLossDescriptor_v8",                             {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyCTCLossDescriptor",                            {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnCTCLoss",                                             {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnCTCLoss_v8",                                          {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetCTCLossWorkspaceSize",                             {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetCTCLossWorkspaceSize_v8",                          {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnAdvTrainVersionCheck",                                {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendCreateDescriptor",                             {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendDestroyDescriptor",                            {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendInitialize",                                   {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendFinalize",                                     {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendSetAttribute",                                 {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendGetAttribute",                                 {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnBackendExecute",                                      {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnCreateConvolutionDescriptor",                         {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyConvolutionDescriptor",                        {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSetConvolutionMathType",                              {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionMathType",                              {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnSetConvolutionGroupCount",                            {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionGroupCount",                            {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnSetConvolutionReorderType",                           {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionReorderType",                           {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnSetConvolution2dDescriptor",                          {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolution2dDescriptor",                          {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnSetConvolutionNdDescriptor",                          {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionNdDescriptor",                          {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolution2dForwardOutputDim",                    {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionNdForwardOutputDim",                    {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionForwardAlgorithmMaxCount",              {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionForwardAlgorithm_v7",                   {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnFindConvolutionForwardAlgorithm",                     {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnFindConvolutionForwardAlgorithmEx",                   {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnIm2Col",                                              {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnReorderFilterAndBias",                                {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionForwardWorkspaceSize",                  {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnConvolutionForward",                                  {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnConvolutionBiasActivationForward",                    {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardDataAlgorithmMaxCount",         {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnFindConvolutionBackwardDataAlgorithm",                {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnFindConvolutionBackwardDataAlgorithmEx",              {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardDataAlgorithm_v7",              {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardDataWorkspaceSize",             {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnConvolutionBackwardData",                             {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnGetFoldedConvBackwardDataDescriptors",                {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnCnnInferVersionCheck",                                {CUDNN_802, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardFilterAlgorithmMaxCount",       {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnFindConvolutionBackwardFilterAlgorithm",              {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnFindConvolutionBackwardFilterAlgorithmEx",            {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardFilterAlgorithm_v7",            {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardFilterWorkspaceSize",           {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnConvolutionBackwardFilter",                           {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnConvolutionBackwardBias",                             {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateFusedOpsConstParamPack",                        {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyFusedOpsConstParamPack",                       {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnSetFusedOpsConstParamPackAttribute",                  {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnGetFusedOpsConstParamPackAttribute",                  {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnCreateFusedOpsVariantParamPack",                      {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyFusedOpsVariantParamPack",                     {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnSetFusedOpsVariantParamPackAttribute",                {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnGetFusedOpsVariantParamPackAttribute",                {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnCreateFusedOpsPlan",                                  {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyFusedOpsPlan",                                 {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnMakeFusedOpsPlan",                                    {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnFusedOpsExecute",                                     {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnCnnTrainVersionCheck",                                {CUDNN_802, CUDA_0,    CUDA_0   }},
  {"cudnnGetVersion",                                          {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetCudartVersion",                                    {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnGetErrorString",                                      {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnQueryRuntimeError",                                   {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetProperty",                                         {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnCreate",                                              {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroy",                                             {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSetStream",                                           {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnGetStream",                                           {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateTensorDescriptor",                              {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnSetTensor4dDescriptor",                               {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSetTensor4dDescriptorEx",                             {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnGetTensor4dDescriptor",                               {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSetTensorNdDescriptor",                               {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnSetTensorNdDescriptorEx",                             {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnGetTensorNdDescriptor",                               {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetTensorSizeInBytes",                                {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyTensorDescriptor",                             {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnInitTransformDest",                                   {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnCreateTensorTransformDescriptor",                     {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnSetTensorTransformDescriptor",                        {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnGetTensorTransformDescriptor",                        {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyTensorTransformDescriptor",                    {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnTransformTensor",                                     {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnTransformTensorEx",                                   {CUDNN_750, CUDA_0,    CUDA_0   }},
  {"cudnnAddTensor",                                           {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateOpTensorDescriptor",                            {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSetOpTensorDescriptor",                               {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnGetOpTensorDescriptor",                               {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyOpTensorDescriptor",                           {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnOpTensor",                                            {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateReduceTensorDescriptor",                        {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnSetReduceTensorDescriptor",                           {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnGetReduceTensorDescriptor",                           {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyReduceTensorDescriptor",                       {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnGetReductionIndicesSize",                             {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnGetReductionWorkspaceSize",                           {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnReduceTensor",                                        {CUDNN_60,  CUDA_0,    CUDA_0   }},
  {"cudnnSetTensor",                                           {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnScaleTensor",                                         {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateFilterDescriptor",                              {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSetFilter4dDescriptor",                               {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetFilter4dDescriptor",                               {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnSetFilterNdDescriptor",                               {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetFilterNdDescriptor",                               {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetFilterSizeInBytes",                                {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnTransformFilter",                                     {CUDNN_760, CUDA_0,    CUDA_0   }},
  {"cudnnDestroyFilterDescriptor",                             {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSoftmaxForward",                                      {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnCreatePoolingDescriptor",                             {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnSetPooling2dDescriptor",                              {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetPooling2dDescriptor",                              {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnSetPoolingNdDescriptor",                              {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetPoolingNdDescriptor",                              {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetPoolingNdForwardOutputDim",                        {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnGetPooling2dForwardOutputDim",                        {CUDNN_20,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyPoolingDescriptor",                            {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnPoolingForward",                                      {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateActivationDescriptor",                          {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnSetActivationDescriptor",                             {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnGetActivationDescriptor",                             {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyActivationDescriptor",                         {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnActivationForward",                                   {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateLRNDescriptor",                                 {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnSetLRNDescriptor",                                    {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnGetLRNDescriptor",                                    {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyLRNDescriptor",                                {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnLRNCrossChannelForward",                              {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnDivisiveNormalizationForward",                        {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnDeriveBNTensorDescriptor",                            {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnBatchNormalizationForwardInference",                  {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnDeriveNormTensorDescriptor",                          {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnNormalizationForwardInference",                       {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnCreateSpatialTransformerDescriptor",                  {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSetSpatialTransformerNdDescriptor",                   {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroySpatialTransformerDescriptor",                 {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSpatialTfGridGeneratorForward",                       {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSpatialTfSamplerForward",                             {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateDropoutDescriptor",                             {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDestroyDropoutDescriptor",                            {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDropoutGetStatesSize",                                {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDropoutGetReserveSpaceSize",                          {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSetDropoutDescriptor",                                {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnRestoreDropoutDescriptor",                            {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnGetDropoutDescriptor",                                {CUDNN_705, CUDA_0,    CUDA_0   }},
  {"cudnnDropoutForward",                                      {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnCreateAlgorithmDescriptor",                           {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnSetAlgorithmDescriptor",                              {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnGetAlgorithmDescriptor",                              {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnCopyAlgorithmDescriptor",                             {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnDestroyAlgorithmDescriptor",                          {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnCreateAlgorithmPerformance",                          {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnSetAlgorithmPerformance",                             {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnGetAlgorithmPerformance",                             {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnDestroyAlgorithmPerformance",                         {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnGetAlgorithmSpaceSize",                               {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnSaveAlgorithm",                                       {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnRestoreAlgorithm",                                    {CUDNN_713, CUDNN_802, CUDA_0   }},
  {"cudnnSetCallback",                                         {CUDNN_713, CUDA_0,    CUDA_0   }},
  {"cudnnGetCallback",                                         {CUDNN_713, CUDA_0,    CUDA_0   }},
  {"cudnnOpsInferVersionCheck",                                {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnSoftmaxBackward",                                     {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnPoolingBackward",                                     {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnActivationBackward",                                  {CUDNN_10,  CUDA_0,    CUDA_0   }},
  {"cudnnLRNCrossChannelBackward",                             {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnDivisiveNormalizationBackward",                       {CUDNN_30,  CUDA_0,    CUDA_0   }},
  {"cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize", {CUDNN_741, CUDA_0,    CUDA_0   }},
  {"cudnnGetBatchNormalizationBackwardExWorkspaceSize",        {CUDNN_741, CUDA_0,    CUDA_0   }},
  {"cudnnGetBatchNormalizationTrainingExReserveSpaceSize",     {CUDNN_741, CUDA_0,    CUDA_0   }},
  {"cudnnBatchNormalizationForwardTraining",                   {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnBatchNormalizationForwardTrainingEx",                 {CUDNN_741, CUDA_0,    CUDA_0   }},
  {"cudnnBatchNormalizationBackward",                          {CUDNN_40,  CUDA_0,    CUDA_0   }},
  {"cudnnBatchNormalizationBackwardEx",                        {CUDNN_741, CUDA_0,    CUDA_0   }},
  {"cudnnGetNormalizationForwardTrainingWorkspaceSize",        {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetNormalizationBackwardWorkspaceSize",               {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetNormalizationTrainingReserveSpaceSize",            {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnNormalizationForwardTraining",                        {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnNormalizationBackward",                               {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnSpatialTfGridGeneratorBackward",                      {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnSpatialTfSamplerBackward",                            {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnDropoutBackward",                                     {CUDNN_50,  CUDA_0,    CUDA_0   }},
  {"cudnnOpsTrainVersionCheck",                                {CUDNN_801, CUDA_0,    CUDA_0   }},
  {"cudnnGetConvolutionBackwardDataAlgorithm",                 {CUDNN_30,  CUDNN_765, CUDNN_801}},
  {"cudnnGetConvolutionBackwardFilterAlgorithm",               {CUDNN_30,  CUDNN_765, CUDNN_801}},
  {"cudnnGetConvolutionForwardAlgorithm",                      {CUDNN_20,  CUDNN_765, CUDNN_801}},
  {"cudnnGetRNNDescriptor",                                    {CUDNN_705, CUDNN_765, CUDNN_801}},
  {"cudnnSetRNNDescriptor",                                    {CUDNN_50,  CUDNN_765, CUDNN_801}},
  {"cudnnSetRNNDescriptor_v5",                                 {CUDNN_705, CUDNN_765, CUDNN_801}},
  {"cudnnSetActivationDescriptorSwishBeta",                    {CUDNN_820, CUDA_0,    CUDA_0}},
  {"cudnnGetActivationDescriptorSwishBeta",                    {CUDNN_820, CUDA_0,    CUDA_0}},
  {"cudnnGetMaxDeviceVersion",                                 {CUDNN_860, CUDA_0,    CUDA_0}},
};

const std::map<llvm::StringRef, hipAPIversions> HIP_DNN_FUNCTION_VER_MAP {
};

const std::map<unsigned int, llvm::StringRef> CUDA_DNN_API_SECTION_MAP {
  {1, "CUDNN Data types"},
  {2, "CUDNN Functions"},
};
