/*
 * Copyright (C)2005-2013 Haxe Foundation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

// This file is generated, do not edit!
package js.html;

/** The <code>Point</code> class offers methods for performing common geometry operations on two dimensional points.<br><br>
Documentation for this class was provided by <a href="https://developer.mozilla.org/en/JavaScript_code_modules/Geometry.jsm/Point">MDN</a>. */
@:native("Point")
extern class Point
{
	var x : Float;

	var y : Float;

	/** <p>Creates a new <code>Point</code> object.</p>
<pre>let p = new Point(x, y);
</pre>
<p>The new point, <code>p</code>, has the specified X&nbsp;and Y&nbsp;coordinates.</p> */
	function new(?arg0 : Dynamic, ?arg1 : Dynamic) : Void;

}
