// Cycle table for Falcon instructions
// All cycles are given for 4 cycles bus

// Head, Tail, I-Cache Case (r/p/w), No-Cache Case (r/p/w), Instruction


#ifndef FALCON030_CYCLES_H
#define FALCON030_CYCLES_H


struct falcon_cycles_t {
	int head;
	int tail;
	int cache_cycles;
	int cache_cycles_r; 
	int cache_cycles_p; 
	int cache_cycles_w; 
	int noncache_cycles;
	int noncache_cycles_r; 
	int noncache_cycles_p; 
	int noncache_cycles_w; 
};

static const struct falcon_cycles_t table_falcon_cycles [] = {
/*0   */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ORI.B #<data>.W,Dn
/*1   */	{1,	2,	10,1,0,1,	16,1,2,1},	// ORI.B #<data>.W,(An)
/*2   */	{2,	2,	12,1,0,1,	17,1,2,1},	// ORI.B #<data>.W,(An)+
/*3   */	{2,	3,	11,1,0,1,	16,1,2,1},	// ORI.B #<data>.W,-(An)
/*4   */	{2,	1,	11,1,0,1,	17,1,2,1},	// ORI.B #<data>.W,(d16,An)
/*5   */	{8,	3,	15,1,0,1,	22,1,3,1},	// ORI.B #<data>.W,(d8,An,Xn)
/*6   */	{4,	3,	13,1,0,1,	18,1,2,1},	// ORI.B #<data>.W,(xxx).W
/*7   */	{3,	1,	13,1,0,1,	21,1,3,1},	// ORI.B #<data>.W,(xxx).L
/*8   */	{4,	0,	12,0,0,0,	18,0,2,0},	// ORI.B #<data>.W, SR
/*9   */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ORI.W #<data>.W,Dn
/*10  */	{1,	2,	10,1,0,1,	16,1,2,1},	// ORI.W #<data>.W,(An)
/*11  */	{2,	2,	12,1,0,1,	17,1,2,1},	// ORI.W #<data>.W,(An)+
/*12  */	{2,	3,	11,1,0,1,	16,1,2,1},	// ORI.W #<data>.W,-(An)
/*13  */	{2,	1,	11,1,0,1,	17,1,2,1},	// ORI.W #<data>.W,(d16,An)
/*14  */	{8,	3,	15,1,0,1,	22,1,3,1},	// ORI.W #<data>.W,(d8,An,Xn)
/*15  */	{4,	3,	13,1,0,1,	18,1,2,1},	// ORI.W #<data>.W,(xxx).W
/*16  */	{3,	1,	13,1,0,1,	21,1,3,1},	// ORI.W #<data>.W,(xxx).L
/*17  */	{4,	0,	12,0,0,0,	18,0,2,0},	// ORI.W #<data>.W, SR
/*18  */	{8,	0,	 6,0,0,0,	10,0,2,0},	// ORI.L #<data>.L,Dn
/*19  */	{1,	1,	19,1,0,1,	25,1,2,1},	// ORI.L #<data>.L,(An)
/*20  */	{4,	2,	22,1,0,1,	27,1,2,1},	// ORI.L #<data>.L,(An)+
/*21  */	{2,	1,	19,1,0,1,	25,1,2,1},	// ORI.L #<data>.L,-(An)
/*22  */	{4,	1,	21,1,0,1,	30,1,3,1},	// ORI.L #<data>.L,(d16,An)
/*23  */	{8,	3,	25,1,0,1,	32,1,3,1},	// ORI.L #<data>.L,(d8,An,Xn)
/*24  */	{6,	3,	23,1,0,1,	30,1,3,1},	// ORI.L #<data>.L,(xxx).W
/*25  */	{5,	1,	23,1,0,1,	31,1,3,1},	// ORI.L #<data>.L,(xxx).L
/*26  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(An)	(See CHK2 table below)
/*27  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d16,An)	(See CHK2 table below)
/*28  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d8,An,Xn)	(See CHK2 table below)
/*29  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(xxx).W	(See CHK2 table below)
/*30  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(xxx).L	(See CHK2 table below)
/*31  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d16,PC)	(See CHK2 table below)
/*32  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d8,PC,Xn)	(See CHK2 table below)
/*33  */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// BTST.L Dn,Dn
/*34  */	{2,	0,	14,2,0,0,	16,2,1,0},	// MVPMR.W (d16,An),Dn
/*35  */	{1,	1,	 9,1,0,0,	11,1,1,0},	// BTST.B Dn,(An)
/*36  */	{0,	1,	 9,1,0,0,	11,1,1,0},	// BTST.B Dn,(An)+
/*37  */	{2,	2,	10,1,0,0,	12,1,1,0},	// BTST.B Dn,-(An)
/*38  */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B Dn,(d16,An)
/*39  */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B Dn,(d8,An,Xn)
/*40  */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B Dn,(xxx).W
/*41  */	{1,	0,	10,1,0,0,	15,1,2,0},	// BTST.B Dn,(xxx).L
/*42  */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B Dn,(d16,PC)
/*43  */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B Dn,(d8,PC,Xn)
/*44  */	{2,	0,	 6,0,0,0,	10,0,2,0},	// BTST.B Dn,#<data>.B
/*45  */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCHG.L Dn,Dn
/*46  */	{2,	0,	38,4,0,0,	40,4,1,0},	// MVPMR.L (d16,An),Dn
/*47  */	{1,	1,	13,1,0,1,	15,1,1,1},	// BCHG.B Dn,(An)
/*48  */	{0,	1,	13,1,0,1,	15,1,1,1},	// BCHG.B Dn,(An)+
/*49  */	{2,	2,	14,1,0,1,	16,1,1,1},	// BCHG.B Dn,-(An)
/*50  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B Dn,(d16,An)
/*51  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCHG.B Dn,(d8,An,Xn)
/*52  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B Dn,(xxx).W
/*53  */	{1,	0,	14,1,0,1,	19,1,2,1},	// BCHG.B Dn,(xxx).L
/*54  */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCLR.L Dn,Dn
/*55  */	{4,	0,	14,0,0,2,	16,0,1,2},	// MVPRM.W Dn,(d16,An)
/*56  */	{1,	1,	13,1,0,1,	15,1,1,1},	// BCLR.B Dn,(An)
/*57  */	{0,	1,	13,1,0,1,	15,1,1,1},	// BCLR.B Dn,(An)+
/*58  */	{2,	2,	14,1,0,1,	16,1,1,1},	// BCLR.B Dn,-(An)
/*59  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B Dn,(d16,An)
/*60  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCLR.B Dn,(d8,An,Xn)
/*61  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B Dn,(xxx).W
/*62  */	{1,	0,	14,1,0,1,	19,1,2,1},	// BCLR.B Dn,(xxx).L
/*63  */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BSET.L Dn,Dn
/*64  */	{4,	0,	38,0,0,4,	40,0,1,4},	// MVPRM.L Dn,(d16,An)
/*65  */	{1,	1,	13,1,0,1,	15,1,1,1},	// BSET.B Dn,(An)
/*66  */	{0,	1,	13,1,0,1,	15,1,1,1},	// BSET.B Dn,(An)+
/*67  */	{2,	2,	14,1,0,1,	16,1,1,1},	// BSET.B Dn,-(An)
/*68  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B Dn,(d16,An)
/*69  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BSET.B Dn,(d8,An,Xn)
/*70  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B Dn,(xxx).W
/*71  */	{1,	0,	14,1,0,1,	19,1,2,1},	// BSET.B Dn,(xxx).L
/*72  */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ANDI.B #<data>.W,Dn
/*73  */	{1,	2,	10,1,0,1,	16,1,2,1},	// ANDI.B #<data>.W,(An)
/*74  */	{2,	2,	12,1,0,1,	17,1,2,1},	// ANDI.B #<data>.W,(An)+
/*75  */	{2,	3,	11,1,0,1,	16,1,2,1},	// ANDI.B #<data>.W,-(An)
/*76  */	{2,	1,	11,1,0,1,	17,1,2,1},	// ANDI.B #<data>.W,(d16,An)
/*77  */	{6,	3,	15,1,0,1,	22,1,3,1},	// ANDI.B #<data>.W,(d8,An,Xn)
/*78  */	{4,	3,	13,1,0,1,	18,1,2,1},	// ANDI.B #<data>.W,(xxx).W
/*79  */	{3,	1,	13,1,0,1,	21,1,3,1},	// ANDI.B #<data>.W,(xxx).L
/*80  */	{4,	0,	12,0,0,0,	18,0,2,0},	// ANDI.B #<data>.W, SR
/*81  */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ANDI.W #<data>.W,Dn
/*82  */	{1,	2,	10,1,0,1,	16,1,2,1},	// ANDI.W #<data>.W,(An)
/*83  */	{2,	2,	12,1,0,1,	17,1,2,1},	// ANDI.W #<data>.W,(An)+
/*84  */	{2,	3,	11,1,0,1,	16,1,2,1},	// ANDI.W #<data>.W,-(An)
/*85  */	{2,	1,	11,1,0,1,	17,1,2,1},	// ANDI.W #<data>.W,(d16,An)
/*86  */	{6,	3,	15,1,0,1,	22,1,3,1},	// ANDI.W #<data>.W,(d8,An,Xn)
/*87  */	{4,	3,	13,1,0,1,	18,1,2,1},	// ANDI.W #<data>.W,(xxx).W
/*88  */	{3,	1,	13,1,0,1,	21,1,3,1},	// ANDI.W #<data>.W,(xxx).L
/*89  */	{4,	0,	12,0,0,0,	18,0,2,0},	// ANDI.W #<data>.W, SR
/*90  */	{8,	0,	 6,0,0,0,	10,0,2,0},	// ANDI.L #<data>.L,Dn
/*91  */	{1,	1,	19,1,0,1,	25,1,2,1},	// ANDI.L #<data>.L,(An)
/*92  */	{4,	2,	22,1,0,1,	27,1,2,1},	// ANDI.L #<data>.L,(An)+
/*93  */	{2,	1,	19,1,0,1,	25,1,2,1},	// ANDI.L #<data>.L,-(An)
/*94  */	{4,	1,	21,1,0,1,	30,1,3,1},	// ANDI.L #<data>.L,(d16,An)
/*95  */	{8,	3,	25,1,0,1,	32,1,3,1},	// ANDI.L #<data>.L,(d8,An,Xn)
/*96  */	{6,	3,	23,1,0,1,	30,1,3,1},	// ANDI.L #<data>.L,(xxx).W
/*97  */	{5,	1,	23,1,0,1,	31,1,3,1},	// ANDI.L #<data>.L,(xxx).L
/*98  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(An)	(See CHK2 table below)
/*99  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d16,An)	(See CHK2 table below)
/*100 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d8,An,Xn)	(See CHK2 table below)
/*101 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(xxx).W	(See CHK2 table below)
/*102 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(xxx).L	(See CHK2 table below)
/*103 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d16,PC)	(See CHK2 table below)
/*104 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d8,PC,Xn)	(See CHK2 table below)
/*105 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// SUBI.B #<data>.W,Dn
/*106 */	{1,	2,	10,1,0,1,	16,1,2,1},	// SUBI.B #<data>.W,(An)
/*107 */	{2,	2,	12,1,0,1,	17,1,2,1},	// SUBI.B #<data>.W,(An)+
/*108 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBI.B #<data>.W,-(An)
/*109 */	{2,	1,	11,1,0,1,	17,1,2,1},	// SUBI.B #<data>.W,(d16,An)
/*110 */	{6,	3,	15,1,0,1,	22,1,3,1},	// SUBI.B #<data>.W,(d8,An,Xn)
/*111 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBI.B #<data>.W,(xxx).W
/*112 */	{3,	1,	13,1,0,1,	21,1,3,1},	// SUBI.B #<data>.W,(xxx).L
/*113 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// SUBI.W #<data>.W,Dn
/*114 */	{1,	2,	10,1,0,1,	16,1,2,1},	// SUBI.W #<data>.W,(An)
/*115 */	{2,	2,	12,1,0,1,	17,1,2,1},	// SUBI.W #<data>.W,(An)+
/*116 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBI.W #<data>.W,-(An)
/*117 */	{2,	1,	11,1,0,1,	17,1,2,1},	// SUBI.W #<data>.W,(d16,An)
/*118 */	{6,	3,	15,1,0,1,	22,1,3,1},	// SUBI.W #<data>.W,(d8,An,Xn)
/*119 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBI.W #<data>.W,(xxx).W
/*120 */	{3,	1,	13,1,0,1,	21,1,3,1},	// SUBI.W #<data>.W,(xxx).L
/*121 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// SUBI.L #<data>.L,Dn
/*122 */	{1,	1,	19,1,0,1,	25,1,2,1},	// SUBI.L #<data>.L,(An)
/*123 */	{4,	2,	22,1,0,1,	27,1,2,1},	// SUBI.L #<data>.L,(An)+
/*124 */	{2,	1,	19,1,0,1,	25,1,2,1},	// SUBI.L #<data>.L,-(An)
/*125 */	{4,	1,	21,1,0,1,	30,1,3,1},	// SUBI.L #<data>.L,(d16,An)
/*126 */	{8,	3,	25,1,0,1,	32,1,3,1},	// SUBI.L #<data>.L,(d8,An,Xn)
/*127 */	{6,	3,	23,1,0,1,	30,1,3,1},	// SUBI.L #<data>.L,(xxx).W
/*128 */	{5,	1,	23,1,0,1,	31,1,3,1},	// SUBI.L #<data>.L,(xxx).L
/*129 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(An)	(See CHK2 table below)
/*130 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d16,An)	(See CHK2 table below)
/*131 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d8,An,Xn)	(See CHK2 table below)
/*132 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(xxx).W	(See CHK2 table below)
/*133 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(xxx).L	(See CHK2 table below)
/*134 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d16,PC)	(See CHK2 table below)
/*135 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d8,PC,Xn)	(See CHK2 table below)
/*136 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ADDI.B #<data>.W,Dn
/*137 */	{1,	2,	10,1,0,1,	16,1,2,1},	// ADDI.B #<data>.W,(An)
/*138 */	{2,	2,	12,1,0,1,	17,1,2,1},	// ADDI.B #<data>.W,(An)+
/*139 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDI.B #<data>.W,-(An)
/*140 */	{2,	1,	11,1,0,1,	17,1,2,1},	// ADDI.B #<data>.W,(d16,An)
/*141 */	{6,	3,	15,1,0,1,	22,1,3,1},	// ADDI.B #<data>.W,(d8,An,Xn)
/*142 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDI.B #<data>.W,(xxx).W
/*143 */	{3,	1,	13,1,0,1,	21,1,3,1},	// ADDI.B #<data>.W,(xxx).L
/*144 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ADDI.W #<data>.W,Dn
/*145 */	{1,	2,	10,1,0,1,	16,1,2,1},	// ADDI.W #<data>.W,(An)
/*146 */	{2,	2,	12,1,0,1,	17,1,2,1},	// ADDI.W #<data>.W,(An)+
/*147 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDI.W #<data>.W,-(An)
/*148 */	{2,	1,	11,1,0,1,	17,1,2,1},	// ADDI.W #<data>.W,(d16,An)
/*149 */	{6,	3,	15,1,0,1,	22,1,3,1},	// ADDI.W #<data>.W,(d8,An,Xn)
/*150 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDI.W #<data>.W,(xxx).W
/*151 */	{3,	1,	13,1,0,1,	21,1,3,1},	// ADDI.W #<data>.W,(xxx).L
/*152 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// ADDI.L #<data>.L,Dn
/*153 */	{1,	1,	19,1,0,1,	25,1,2,1},	// ADDI.L #<data>.L,(An)
/*154 */	{4,	2,	22,1,0,1,	27,1,2,1},	// ADDI.L #<data>.L,(An)+
/*155 */	{2,	1,	19,1,0,1,	25,1,2,1},	// ADDI.L #<data>.L,-(An)
/*156 */	{4,	1,	21,1,0,1,	30,1,3,1},	// ADDI.L #<data>.L,(d16,An)
/*157 */	{8,	3,	25,1,0,1,	32,1,3,1},	// ADDI.L #<data>.L,(d8,An,Xn)
/*158 */	{6,	3,	23,1,0,1,	30,1,3,1},	// ADDI.L #<data>.L,(xxx).W
/*159 */	{5,	1,	23,1,0,1,	31,1,3,1},	// ADDI.L #<data>.L,(xxx).L
/*160 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// RTM.L Dn			/* Not present in 68030 */
/*161 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// RTM.L An			/* Not present in 68030 */
/*162 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (An)			/* Not present in 68030 */
/*163 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d16,An)		/* Not present in 68030 */
/*164 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d8,An,Xn)		/* Not present in 68030 */
/*165 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (xxx).W		/* Not present in 68030 */
/*166 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (xxx).L		/* Not present in 68030 */
/*167 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d16,PC)		/* Not present in 68030 */
/*168 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d8,PC,Xn)		/* Not present in 68030 */
/*169 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// BTST.L #<data>.W,Dn
/*170 */	{1,	1,	 9,1,0,0,	14,1,2,0},	// BTST.B #<data>.W,(An)
/*171 */	{2,	1,	11,1,0,0,	15,1,2,0},	// BTST.B #<data>.W,(An)+
/*172 */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B #<data>.W,-(An)
/*173 */	{2,	0,	10,1,0,0,	15,1,2,0},	// BTST.B #<data>.W,(d16,An)
/*174 */	{6,	2,	14,1,0,0,	20,1,3,0},	// BTST.B #<data>.W,(d8,An,Xn)
/*175 */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B #<data>.W,(xxx).W
/*176 */	{3,	0,	12,1,0,0,	19,1,3,0},	// BTST.B #<data>.W,(xxx).L
/*177 */	{2,	0,	10,1,0,0,	15,1,2,0},	// BTST.B #<data>.W,(d16,PC)
/*178 */	{6,	2,	14,1,0,0,	20,1,3,0},	// BTST.B #<data>.W,(d8,PC,Xn)
/*179 */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B #<data>.W,#<data>.B	/* Strange OPCODE, value guessed */
/*180 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCHG.L #<data>.W,Dn
/*181 */	{1,	1,	13,1,0,1,	18,1,2,1},	// BCHG.B #<data>.W,(An)
/*182 */	{2,	1,	15,1,0,1,	19,1,2,1},	// BCHG.B #<data>.W,(An)+
/*183 */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B #<data>.W,-(An)
/*184 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BCHG.B #<data>.W,(d16,An)
/*185 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BCHG.B #<data>.W,(d8,An,Xn)
/*186 */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCHG.B #<data>.W,(xxx).W
/*187 */	{3,	0,	16,1,0,1,	23,1,3,1},	// BCHG.B #<data>.W,(xxx).L
/*188 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCLR.L #<data>.W,Dn
/*189 */	{1,	1,	13,1,0,1,	18,1,2,1},	// BCLR.B #<data>.W,(An)
/*190 */	{2,	1,	15,1,0,1,	19,1,2,1},	// BCLR.B #<data>.W,(An)+
/*191 */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B #<data>.W,-(An)
/*192 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BCLR.B #<data>.W,(d16,An)
/*193 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BCLR.B #<data>.W,(d8,An,Xn)
/*194 */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCLR.B #<data>.W,(xxx).W
/*195 */	{3,	0,	16,1,0,1,	23,1,3,1},	// BCLR.B #<data>.W,(xxx).L
/*196 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BSET.L #<data>.W,Dn
/*197 */	{1,	1,	13,1,0,1,	18,1,2,1},	// BSET.B #<data>.W,(An)
/*198 */	{2,	1,	15,1,0,1,	19,1,2,1},	// BSET.B #<data>.W,(An)+
/*199 */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B #<data>.W,-(An)
/*200 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BSET.B #<data>.W,(d16,An)
/*201 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BSET.B #<data>.W,(d8,An,Xn)
/*202 */	{4,	2,	16,1,0,1,	20,1,2,1},	// BSET.B #<data>.W,(xxx).W
/*203 */	{3,	0,	16,1,0,1,	23,1,3,1},	// BSET.B #<data>.W,(xxx).L
/*204 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// EORI.B #<data>.W,Dn
/*205 */	{1,	2,	10,1,0,1,	16,1,2,1},	// EORI.B #<data>.W,(An)
/*206 */	{2,	2,	12,1,0,1,	17,1,2,1},	// EORI.B #<data>.W,(An)+
/*207 */	{2,	3,	11,1,0,1,	16,1,2,1},	// EORI.B #<data>.W,-(An)
/*208 */	{2,	1,	11,1,0,1,	17,1,2,1},	// EORI.B #<data>.W,(d16,An)
/*209 */	{6,	3,	15,1,0,1,	22,1,3,1},	// EORI.B #<data>.W,(d8,An,Xn)
/*210 */	{4,	3,	13,1,0,1,	18,1,2,1},	// EORI.B #<data>.W,(xxx).W
/*211 */	{3,	1,	13,1,0,1,	21,1,3,1},	// EORI.B #<data>.W,(xxx).L
/*212 */	{4,	0,	12,0,0,0,	18,0,2,0},	// EORI.B #<data>.W, SR
/*213 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// EORI.W #<data>.W,Dn
/*214 */	{1,	2,	10,1,0,1,	16,1,2,1},	// EORI.W #<data>.W,(An)
/*215 */	{2,	2,	12,1,0,1,	17,1,2,1},	// EORI.W #<data>.W,(An)+
/*216 */	{2,	3,	11,1,0,1,	16,1,2,1},	// EORI.W #<data>.W,-(An)
/*217 */	{2,	1,	11,1,0,1,	17,1,2,1},	// EORI.W #<data>.W,(d16,An)
/*218 */	{6,	3,	15,1,0,1,	22,1,3,1},	// EORI.W #<data>.W,(d8,An,Xn)
/*219 */	{4,	3,	13,1,0,1,	18,1,2,1},	// EORI.W #<data>.W,(xxx).W
/*220 */	{3,	1,	13,1,0,1,	21,1,3,1},	// EORI.W #<data>.W,(xxx).L
/*221 */	{4,	0,	12,0,0,0,	18,0,2,0},	// EORI.W #<data>.W, SR
/*222 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// EORI.L #<data>.L,Dn
/*223 */	{1,	1,	19,1,0,1,	25,1,2,1},	// EORI.L #<data>.L,(An)
/*224 */	{4,	2,	22,1,0,1,	27,1,2,1},	// EORI.L #<data>.L,(An)+
/*225 */	{2,	1,	19,1,0,1,	25,1,2,1},	// EORI.L #<data>.L,-(An)
/*226 */	{4,	1,	21,1,0,1,	30,1,3,1},	// EORI.L #<data>.L,(d16,An)
/*227 */	{8,	3,	25,1,0,1,	32,1,3,1},	// EORI.L #<data>.L,(d8,An,Xn)
/*228 */	{6,	3,	23,1,0,1,	30,1,3,1},	// EORI.L #<data>.L,(xxx).W
/*229 */	{5,	1,	23,1,0,1,	31,1,3,1},	// EORI.L #<data>.L,(xxx).L
/*230 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(An)		(See CAS table below)
/*231 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(An)+	(See CAS table below)
/*232 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,-(An)	(See CAS table below)
/*233 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(d16,An)	(See CAS table below)
/*234 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(d8,An,Xn)	(See CAS table below)
/*235 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(xxx).W	(See CAS table below)
/*236 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(xxx).L	(See CAS table below)
/*237 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// CMPI.B #<data>.B,Dn
/*238 */	{1,	1,	 7,1,0,0,	12,1,2,0},	// CMPI.B #<data>.W,(An)
/*239 */	{2,	1,	 9,1,0,0,	13,1,2,0},	// CMPI.B #<data>.W,(An)+
/*240 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMPI.B #<data>.W,-(An)
/*241 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.B #<data>.W,(d16,An)
/*242 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.B #<data>.W,(d8,An,Xn)
/*243 */	{4,	2,	10,1,0,0,	14,1,2,0},	// CMPI.B #<data>.W,(xxx).W
/*244 */	{3,	0,	10,1,0,0,	17,1,3,0},	// CMPI.B #<data>.W,(xxx).L
/*245 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.B #<data>.W,(d16,PC)
/*246 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.B #<data>.W,(d8,PC,Xn)
/*247 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// CMPI.W #<data>.W,Dn
/*248 */	{1,	1,	 7,1,0,0,	12,1,2,0},	// CMPI.W #<data>.W,(An)
/*249 */	{2,	1,	 9,1,0,0,	13,1,2,0},	// CMPI.W #<data>.W,(An)+
/*250 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMPI.W #<data>.W,-(An)
/*251 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.W #<data>.W,(d16,An)
/*252 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.W #<data>.W,(d8,An,Xn)
/*253 */	{4,	2,	10,1,0,0,	14,1,2,0},	// CMPI.W #<data>.W,(xxx).W
/*254 */	{3,	0,	10,1,0,0,	17,1,3,0},	// CMPI.W #<data>.W,(xxx).L
/*255 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.W #<data>.W,(d16,PC)
/*256 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.W #<data>.W,(d8,PC,Xn)
/*257 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// CMPI.L #<data>.L,Dn
/*258 */	{1,	0,	12,1,0,0,	17,1,2,0},	// CMPI.L #<data>.L,(An)
/*259 */	{4,	1,	15,1,0,0,	19,1,2,0},	// CMPI.L #<data>.L,(An)+
/*260 */	{2,	0,	12,1,0,0,	17,1,2,0},	// CMPI.L #<data>.L,-(An)
/*261 */	{4,	0,	14,1,0,0,	22,1,3,0},	// CMPI.L #<data>.L,(d16,An)
/*262 */	{8,	2,	18,1,0,0,	24,1,3,0},	// CMPI.L #<data>.L,(d8,An,Xn)
/*263 */	{6,	2,	16,1,0,0,	22,1,3,0},	// CMPI.L #<data>.L,(xxx).W
/*264 */	{5,	0,	16,1,0,0,	23,1,3,0},	// CMPI.L #<data>.L,(xxx).L
/*265 */	{4,	0,	14,1,0,0,	22,1,3,0},	// CMPI.L #<data>.L,(d16,PC)
/*266 */	{8,	2,	18,1,0,0,	24,1,3,0},	// CMPI.L #<data>.L,(d8,PC,Xn)
/*267 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(An)		(See CAS table below)
/*268 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(An)+	(See CAS table below)
/*269 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,-(An)	(See CAS table below)
/*270 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(d16,An)	(See CAS table below)
/*271 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(d8,An,Xn)	(See CAS table below)
/*272 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(xxx).W	(See CAS table below)
/*273 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(xxx).L	(See CAS table below)
/*274 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS2.W #<data>.L		(See CAS2 table below)
/*275 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(An)		(See MOVES table below)
/*276 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(An)+		(See MOVES table below)
/*277 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,-(An)		(See MOVES table below)
/*278 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(d16,An)		(See MOVES table below)
/*279 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(d8,An,Xn)		(See MOVES table below)
/*280 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(xxx).W		(See MOVES table below)
/*281 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(xxx).L		(See MOVES table below)
/*282 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(An)		(See MOVES table below)
/*283 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(An)+		(See MOVES table below)
/*284 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,-(An)		(See MOVES table below)
/*285 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(d16,An)		(See MOVES table below)
/*286 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(d8,An,Xn)		(See MOVES table below)
/*287 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(xxx).W		(See MOVES table below)
/*288 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(xxx).L		(See MOVES table below)
/*289 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(An)		(See MOVES table below)
/*290 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(An)+		(See MOVES table below)
/*291 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,-(An)		(See MOVES table below)
/*292 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(d16,An)		(See MOVES table below)
/*293 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(d8,An,Xn)		(See MOVES table below)
/*294 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(xxx).W		(See MOVES table below)
/*295 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(xxx).L		(See MOVES table below)
/*296 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(An)		(See CAS table below)
/*297 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(An)+	(See CAS table below)
/*298 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,-(An)	(See CAS table below)
/*299 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(d16,An)	(See CAS table below)
/*300 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(d8,An,Xn)	(See CAS table below)
/*301 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(xxx).W	(See CAS table below)
/*302 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(xxx).L	(See CAS table below)
/*303 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS2.L #<data>.L		(See CAS2 table below)
/*304 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.B Dn,Dn
/*305 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.B (An),Dn
/*306 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.B (An)+,Dn
/*307 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// MOVE.B -(An),Dn
/*308 */	{2,	2,	 8,1,0,0,	12,1,1,0},	// MOVE.B (d16,An),Dn
/*309 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.B (d8,An,Xn),Dn
/*310 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.B (xxx).W,Dn
/*311 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// MOVE.B (xxx).L,Dn
/*312 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.B (d16,PC),Dn
/*313 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.B (d8,PC,Xn),Dn
/*314 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// MOVE.B #<data>.B,Dn
/*315 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.B Dn,(An)
/*316 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),(An)
/*317 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,(An)
/*318 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),(An)
/*319 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),(An)
/*320 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),(An)
/*321 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,(An)
/*322 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,(An)
/*323 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),(An)
/*324 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),(An)
/*325 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,(An)
/*326 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.B Dn,(An)+
/*327 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),(An)+
/*328 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,(An)+
/*329 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),(An)+
/*330 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),(An)+
/*331 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),(An)+
/*332 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,(An)+
/*333 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,(An)+
/*334 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),(An)+
/*335 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),(An)+
/*336 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,(An)+
/*337 */	{0,	2,	 6,0,0,1,	 8,0,1,1},	// MOVE.B Dn,-(An)
/*338 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),-(An)
/*339 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,-(An)
/*340 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),-(An)
/*341 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),-(An)
/*342 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),-(An)
/*343 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,-(An)
/*344 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,-(An)
/*345 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),-(An)
/*346 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),-(An)
/*347 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,-(An)
/*348 */	{2,	0,	 6,0,0,1,	 9,0,1,1},	// MOVE.B Dn,(d16,An)
/*349 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),(d16,An)
/*350 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,(d16,An)
/*351 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),(d16,An)
/*352 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),(d16,An)
/*353 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),(d16,An)
/*354 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,(d16,An)
/*355 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,(d16,An)
/*356 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),(d16,An)
/*357 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),(d16,An)
/*358 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,(d16,An)
/*359 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.B Dn,(d8,An,Xn)
/*360 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An),(d8,An,Xn)
/*361 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An)+,(d8,An,Xn)
/*362 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.B -(An),(d8,An,Xn)
/*363 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,An),(d8,An,Xn)
/*364 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,An,Xn),(d8,An,Xn)
/*365 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (xxx).W,(d8,An,Xn)
/*366 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.B (xxx).L,(d8,An,Xn)
/*367 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,PC),(d8,An,Xn)
/*368 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,PC,Xn),(d8,An,Xn)
/*369 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.B #<data>.B,(d8,An,Xn)
/*370 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.B Dn,(xxx).W
/*371 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An),(xxx).W
/*372 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An)+,(xxx).W
/*373 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.B -(An),(xxx).W
/*374 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,An),(xxx).W
/*375 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,An,Xn),(xxx).W
/*376 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (xxx).W,(xxx).W
/*377 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.B (xxx).L,(xxx).W
/*378 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,PC),(xxx).W
/*379 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,PC,Xn),(xxx).W
/*380 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.B #<data>.B,(xxx).W
/*381 */	{0,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B Dn,(xxx).L
/*382 */	{1,	1,	13,1,0,1,	18,1,2,1},	// MOVE.B (An),(xxx).L
/*383 */	{0,	1,	13,1,0,1,	18,1,2,1},	// MOVE.B (An)+,(xxx).L
/*384 */	{2,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B -(An),(xxx).L
/*385 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.B (d16,An),(xxx).L
/*386 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.B (d8,An,Xn),(xxx).L
/*387 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.B (xxx).W,(xxx).L
/*388 */	{1,	0,	14,1,0,1,	22,1,3,1},	// MOVE.B (xxx).L,(xxx).L
/*389 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.B (d16,PC),(xxx).L
/*390 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.B (d8,PC,Xn),(xxx).L
/*391 */	{2,	0,	10,0,0,1,	17,0,3,1},	// MOVE.B #<data>.B,(xxx).L
/*392 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.L Dn,Dn
/*393 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.L An,Dn
/*394 */	{1,	1,	11,1,0,0,	13,1,1,0},	// MOVE.L (An),Dn
/*395 */	{0,	1,	11,1,0,0,	13,1,1,0},	// MOVE.L (An)+,Dn
/*396 */	{2,	2,	12,1,0,0,	14,1,1,0},	// MOVE.L -(An),Dn
/*397 */	{2,	2,	12,1,0,0,	16,1,1,0},	// MOVE.L (d16,An),Dn
/*398 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVE.L (d8,An,Xn),Dn
/*399 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVE.L (xxx).W,Dn
/*400 */	{1,	0,	12,1,0,0,	17,1,2,0},	// MOVE.L (xxx).L,Dn
/*401 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVE.L (d16,PC),Dn
/*402 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVE.L (d8,PC,Xn),Dn
/*403 */	{4,	0,	 6,0,0,0,	10,0,2,0},	// MOVE.L #<data>.L,Dn
/*404 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.L Dn,An
/*405 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.L An,An
/*406 */	{1,	1,	11,1,0,0,	13,1,1,0},	// MOVEA.L (An),An
/*407 */	{0,	1,	11,1,0,0,	13,1,1,0},	// MOVEA.L (An)+,An
/*408 */	{2,	2,	12,1,0,0,	14,1,1,0},	// MOVEA.L -(An),An
/*409 */	{2,	2,	12,1,0,0,	16,1,1,0},	// MOVEA.L (d16,An),An
/*410 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVEA.L (d8,An,Xn),An
/*411 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVEA.L (xxx).W,An
/*412 */	{1,	0,	12,1,0,0,	17,1,2,0},	// MOVEA.L (xxx).L,An
/*413 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVEA.L (d16,PC),An
/*414 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVEA.L (d8,PC,Xn),An
/*415 */	{4,	0,	 6,0,0,0,	10,0,2,0},	// MOVEA.L #<data>.L,An
/*416 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L Dn,(An)
/*417 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L An,(An)
/*418 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(An)
/*419 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(An)
/*420 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(An)
/*421 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(An)
/*422 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(An)
/*423 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(An)
/*424 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(An)
/*425 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(An)
/*426 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(An)
/*427 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(An)
/*428 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L Dn,(An)+
/*429 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L An,(An)+
/*430 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(An)+
/*431 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(An)+
/*432 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(An)+
/*433 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(An)+
/*434 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(An)+
/*435 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(An)+
/*436 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(An)+
/*437 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(An)+
/*438 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(An)+
/*439 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(An)+
/*440 */	{0,	2,	10,0,0,1,	12,0,1,1},	// MOVE.L Dn,-(An)
/*441 */	{0,	2,	10,0,0,1,	12,0,1,1},	// MOVE.L An,-(An)
/*442 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),-(An)
/*443 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,-(An)
/*444 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),-(An)
/*445 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),-(An)
/*446 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),-(An)
/*447 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,-(An)
/*448 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,-(An)
/*449 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),-(An)
/*450 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),-(An)
/*451 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,-(An)
/*452 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L Dn,(d16,An)
/*453 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L An,(d16,An)
/*454 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(d16,An)
/*455 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(d16,An)
/*456 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(d16,An)
/*457 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(d16,An)
/*458 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(d16,An)
/*459 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(d16,An)
/*460 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(d16,An)
/*461 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(d16,An)
/*462 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(d16,An)
/*463 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(d16,An)
/*464 */	{4,	0,	12,0,0,1,	15,0,1,1},	// MOVE.L Dn,(d8,An,Xn)
/*465 */	{4,	0,	12,0,0,1,	15,0,1,1},	// MOVE.L An,(d8,An,Xn)
/*466 */	{5,	1,	21,1,0,1,	24,1,1,1},	// MOVE.L (An),(d8,An,Xn)
/*467 */	{4,	1,	21,1,0,1,	24,1,1,1},	// MOVE.L (An)+,(d8,An,Xn)
/*468 */	{6,	2,	22,1,0,1,	25,1,1,1},	// MOVE.L -(An),(d8,An,Xn)
/*469 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d16,An),(d8,An,Xn)
/*470 */	{8,	2,	24,1,0,1,	29,1,2,1},	// MOVE.L (d8,An,Xn),(d8,An,Xn)
/*471 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (xxx).W,(d8,An,Xn)
/*472 */	{5,	0,	22,1,0,1,	28,1,2,1},	// MOVE.L (xxx).L,(d8,An,Xn)
/*473 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d16,PC),(d8,An,Xn)
/*474 */	{8,	2,	24,1,0,1,	29,1,2,1},	// MOVE.L (d8,PC,Xn),(d8,An,Xn)
/*475 */	{8,	0,	16,0,0,1,	21,0,2,1},	// MOVE.L #<data>.L,(d8,An,Xn)
/*476 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L Dn,(xxx).W
/*477 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L An,(xxx).W
/*478 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(xxx).W
/*479 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(xxx).W
/*480 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(xxx).W
/*481 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(xxx).W
/*482 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(xxx).W
/*483 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(xxx).W
/*484 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(xxx).W
/*485 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(xxx).W
/*486 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(xxx).W
/*487 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(xxx).W
/*488 */	{0,	0,	12,0,0,1,	17,0,2,1},	// MOVE.L Dn,(xxx).L
/*489 */	{0,	0,	12,0,0,1,	17,0,2,1},	// MOVE.L An,(xxx).L
/*490 */	{1,	1,	21,1,0,1,	26,1,2,1},	// MOVE.L (An),(xxx).L
/*491 */	{0,	1,	21,1,0,1,	26,1,2,1},	// MOVE.L (An)+,(xxx).L
/*492 */	{2,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L -(An),(xxx).L
/*493 */	{2,	2,	22,1,0,1,	29,1,3,1},	// MOVE.L (d16,An),(xxx).L
/*494 */	{4,	2,	24,1,0,1,	31,1,3,1},	// MOVE.L (d8,An,Xn),(xxx).L
/*495 */	{2,	2,	22,1,0,1,	29,1,3,1},	// MOVE.L (xxx).W,(xxx).L
/*496 */	{1,	0,	22,1,0,1,	30,1,3,1},	// MOVE.L (xxx).L,(xxx).L
/*497 */	{2,	2,	22,1,0,1,	29,1,3,1},	// MOVE.L (d16,PC),(xxx).L
/*498 */	{4,	2,	24,1,0,1,	31,1,3,1},	// MOVE.L (d8,PC,Xn),(xxx).L
/*499 */	{4,	0,	16,0,0,1,	23,0,3,1},	// MOVE.L #<data>.L,(xxx).L
/*500 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.W Dn,Dn
/*501 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.W An,Dn
/*502 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.W (An),Dn
/*503 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.W (An)+,Dn
/*504 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// MOVE.W -(An),Dn
/*505 */	{2,	2,	 8,1,0,0,	12,1,1,0},	// MOVE.W (d16,An),Dn
/*506 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.W (d8,An,Xn),Dn
/*507 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.W (xxx).W,Dn
/*508 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// MOVE.W (xxx).L,Dn
/*509 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.W (d16,PC),Dn
/*510 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.W (d8,PC,Xn),Dn
/*511 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// MOVE.W #<data>.W,Dn
/*512 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.W Dn,An
/*513 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.W An,An
/*514 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// MOVEA.W (An),An
/*515 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// MOVEA.W (An)+,An
/*516 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// MOVEA.W -(An),An
/*517 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVEA.W (d16,An),An
/*518 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVEA.W (d8,An,Xn),An
/*519 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVEA.W (xxx).W,An
/*520 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// MOVEA.W (xxx).L,An
/*521 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVEA.W (d16,PC),An
/*522 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVEA.W (d8,PC,Xn),An
/*523 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// MOVEA.W #<data>.W,An
/*524 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W Dn,(An)
/*525 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W An,(An)
/*526 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),(An)
/*527 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,(An)
/*528 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),(An)
/*529 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),(An)
/*530 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),(An)
/*531 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,(An)
/*532 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,(An)
/*533 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),(An)
/*534 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),(An)
/*535 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,(An)
/*536 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W Dn,(An)+
/*537 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W An,(An)+
/*538 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),(An)+
/*539 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,(An)+
/*540 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),(An)+
/*541 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),(An)+
/*542 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),(An)+
/*543 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,(An)+
/*544 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,(An)+
/*545 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),(An)+
/*546 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),(An)+
/*547 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,(An)+
/*548 */	{0,	2,	 6,0,0,1,	 8,0,1,1},	// MOVE.W Dn,-(An)
/*549 */	{0,	2,	 6,0,0,1,	 8,0,1,1},	// MOVE.W An,-(An)
/*550 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),-(An)
/*551 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,-(An)
/*552 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),-(An)
/*553 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),-(An)
/*554 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),-(An)
/*555 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,-(An)
/*556 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,-(An)
/*557 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),-(An)
/*558 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),-(An)
/*559 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,-(An)
/*560 */	{2,	0,	 6,0,0,1,	 9,0,1,1},	// MOVE.W Dn,(d16,An)
/*561 */	{2,	0,	 6,0,0,1,	 9,0,1,1},	// MOVE.W An,(d16,An)
/*562 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),(d16,An)
/*563 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,(d16,An)
/*564 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),(d16,An)
/*565 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),(d16,An)
/*566 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),(d16,An)
/*567 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,(d16,An)
/*568 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,(d16,An)
/*569 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),(d16,An)
/*570 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),(d16,An)
/*571 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,(d16,An)
/*572 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W Dn,(d8,An,Xn)
/*573 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W An,(d8,An,Xn)
/*574 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An),(d8,An,Xn)
/*575 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An)+,(d8,An,Xn)
/*576 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.W -(An),(d8,An,Xn)
/*577 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,An),(d8,An,Xn)
/*578 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,An,Xn),(d8,An,Xn)
/*579 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (xxx).W,(d8,An,Xn)
/*580 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.W (xxx).L,(d8,An,Xn)
/*581 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,PC),(d8,An,Xn)
/*582 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,PC,Xn),(d8,An,Xn)
/*583 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.W #<data>.W,(d8,An,Xn)
/*584 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W Dn,(xxx).W
/*585 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W An,(xxx).W
/*586 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An),(xxx).W
/*587 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An)+,(xxx).W
/*588 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.W -(An),(xxx).W
/*589 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,An),(xxx).W
/*590 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,An,Xn),(xxx).W
/*591 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (xxx).W,(xxx).W
/*592 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.W (xxx).L,(xxx).W
/*593 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,PC),(xxx).W
/*594 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,PC,Xn),(xxx).W
/*595 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.W #<data>.W,(xxx).W
/*596 */	{0,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W Dn,(xxx).L
/*597 */	{0,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W An,(xxx).L
/*598 */	{1,	1,	13,1,0,1,	18,1,2,1},	// MOVE.W (An),(xxx).L
/*599 */	{0,	1,	13,1,0,1,	18,1,2,1},	// MOVE.W (An)+,(xxx).L
/*600 */	{2,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W -(An),(xxx).L
/*601 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.W (d16,An),(xxx).L
/*602 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.W (d8,An,Xn),(xxx).L
/*603 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.W (xxx).W,(xxx).L
/*604 */	{1,	0,	14,1,0,1,	22,1,3,1},	// MOVE.W (xxx).L,(xxx).L
/*605 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.W (d16,PC),(xxx).L
/*606 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.W (d8,PC,Xn),(xxx).L
/*607 */	{2,	0,	10,0,0,1,	17,0,3,1},	// MOVE.W #<data>.W,(xxx).L
/*608 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEGX.B Dn
/*609 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEGX.B (An)
/*610 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEGX.B (An)+
/*611 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEGX.B -(An)
/*612 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.B (d16,An)
/*613 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEGX.B (d8,An,Xn)
/*614 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.B (xxx).W
/*615 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEGX.B (xxx).L
/*616 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEGX.W Dn
/*617 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEGX.W (An)
/*618 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEGX.W (An)+
/*619 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEGX.W -(An)
/*620 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.W (d16,An)
/*621 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEGX.W (d8,An,Xn)
/*622 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.W (xxx).W
/*623 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEGX.W (xxx).L
/*624 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEGX.L Dn
/*625 */	{1,	2,	18,1,0,1,	21,1,1,1},	// NEGX.L (An)
/*626 */	{0,	2,	18,1,0,1,	21,1,1,1},	// NEGX.L (An)+
/*627 */	{2,	3,	19,1,0,1,	22,1,1,1},	// NEGX.L -(An)
/*628 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEGX.L (d16,An)
/*629 */	{4,	3,	21,1,0,1,	26,1,2,1},	// NEGX.L (d8,An,Xn)
/*630 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEGX.L (xxx).W
/*631 */	{1,	1,	19,1,0,1,	25,1,2,1},	// NEGX.L (xxx).L
/*632 */	{2,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE.W SR,Dn
/*633 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W SR,(An)
/*634 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W SR,(An)+
/*635 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W SR,-(An)
/*636 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W SR,(d16,An)
/*637 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W SR,(d8,An,Xn)
/*638 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W SR,(xxx).W
/*639 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W SR,(xxx).L
/*640 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L Dn,Dn		(See CHK table below)
/*641 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (An),Dn	(See CHK table below)
/*642 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (An)+,Dn	(See CHK table below)
/*643 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L -(An),Dn	(See CHK table below)
/*644 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d16,An),Dn	(See CHK table below)
/*645 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d8,An,Xn),Dn	(See CHK table below)
/*646 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (xxx).W,Dn	(See CHK table below)
/*647 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (xxx).L,Dn	(See CHK table below)
/*648 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d16,PC),Dn	(See CHK table below)
/*649 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d8,PC,Xn),Dn	(See CHK table below)
/*650 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L #<data>.L,Dn	(See CHK table below)
/*651 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W Dn,Dn		(See CHK table below)
/*652 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (An),Dn	(See CHK table below)
/*653 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (An)+,Dn	(See CHK table below)
/*654 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W -(An),Dn	(See CHK table below)
/*655 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d16,An),Dn	(See CHK table below)
/*656 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d8,An,Xn),Dn	(See CHK table below)
/*657 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (xxx).W,Dn	(See CHK table below)
/*658 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (xxx).L,Dn	(See CHK table below)
/*659 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d16,PC),Dn	(See CHK table below)
/*660 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d8,PC,Xn),Dn	(See CHK table below)
/*661 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W #<data>.W,Dn	(See CHK table below)
/*662 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// LEA.L (An),An
/*663 */	{10,	0,	 8,0,0,0,	15,0,3,0},	// LEA.L (d16,An),An
/*664 */	{12,	0,	10,0,0,0,	16,0,3,0},	// LEA.L (d8,An,Xn),An
/*665 */	{10,	0,	 8,0,0,0,	14,0,3,0},	// LEA.L (xxx).W,An
/*666 */	{12,	0,	10,0,0,0,	16,0,3,0},	// LEA.L (xxx).L,An
/*667 */	{10,	0,	 8,0,0,0,	15,0,3,0},	// LEA.L (d16,PC),An
/*668 */	{12,	0,	10,0,0,0,	16,0,3,0},	// LEA.L (d8,PC,Xn),An
/*669 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CLR.B Dn
/*670 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.B (An)
/*671 */	{0,	1,	 7,0,0,1,	10,0,1,1},	// CLR.B (An)+
/*672 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.B -(An)
/*673 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.B (d16,An)
/*674 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.B (d8,An,Xn)
/*675 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.B (xxx).W
/*676 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.B (xxx).L
/*677 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CLR.W Dn
/*678 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.W (An)
/*679 */	{0,	1,	 7,0,0,1,	10,0,1,1},	// CLR.W (An)+
/*680 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.W -(An)
/*681 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.W (d16,An)
/*682 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.W (d8,An,Xn)
/*683 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.W (xxx).W
/*684 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.W (xxx).L
/*685 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CLR.L Dn
/*686 */	{2,	1,	11,0,0,1,	14,0,1,1},	// CLR.L (An)
/*687 */	{0,	1,	11,0,0,1,	14,0,1,1},	// CLR.L (An)+
/*688 */	{2,	1,	11,0,0,1,	14,0,1,1},	// CLR.L -(An)
/*689 */	{2,	1,	11,0,0,1,	16,0,2,1},	// CLR.L (d16,An)
/*690 */	{4,	1,	13,0,0,1,	18,0,2,1},	// CLR.L (d8,An,Xn)
/*691 */	{2,	1,	11,0,0,1,	16,0,2,1},	// CLR.L (xxx).W
/*692 */	{4,	1,	13,0,0,1,	18,0,2,1},	// CLR.L (xxx).L
/*693 */	{2,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE.B SR,Dn
/*694 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B SR,(An)
/*695 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B SR,(An)+
/*696 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B SR,-(An)
/*697 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B SR,(d16,An)
/*698 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B SR,(d8,An,Xn)
/*699 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B SR,(xxx).W
/*700 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B SR,(xxx).L
/*701 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEG.B Dn
/*702 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEG.B (An)
/*703 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEG.B (An)+
/*704 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEG.B -(An)
/*705 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.B (d16,An)
/*706 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEG.B (d8,An,Xn)
/*707 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.B (xxx).W
/*708 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEG.B (xxx).L
/*709 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEG.W Dn
/*710 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEG.W (An)
/*711 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEG.W (An)+
/*712 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEG.W -(An)
/*713 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.W (d16,An)
/*714 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEG.W (d8,An,Xn)
/*715 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.W (xxx).W
/*716 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEG.W (xxx).L
/*717 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEG.L Dn
/*718 */	{1,	2,	18,1,0,1,	21,1,1,1},	// NEG.L (An)
/*719 */	{0,	2,	18,1,0,1,	21,1,1,1},	// NEG.L (An)+
/*720 */	{2,	3,	19,1,0,1,	22,1,1,1},	// NEG.L -(An)
/*721 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEG.L (d16,An)
/*722 */	{4,	3,	21,1,0,1,	26,1,2,1},	// NEG.L (d8,An,Xn)
/*723 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEG.L (xxx).W
/*724 */	{1,	1,	19,1,0,1,	25,1,2,1},	// NEG.L (xxx).L
/*725 */	{0,	0,	 8,0,0,0,	14,0,2,0},	// MOVE.B Dn,SR
/*726 */	{1,	1,	13,1,0,0,	19,1,2,0},	// MOVE.B (An),SR
/*727 */	{0,	1,	13,1,0,0,	19,1,2,0},	// MOVE.B (An)+,SR
/*728 */	{2,	2,	14,1,0,0,	20,1,2,0},	// MOVE.B -(An),SR
/*729 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.B (d16,An),SR
/*730 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.B (d8,An,Xn),SR
/*731 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.B (xxx).W,SR
/*732 */	{1,	0,	14,1,0,0,	23,1,3,0},	// MOVE.B (xxx).L,SR
/*733 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.B (d16,PC),SR
/*734 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.B (d8,PC,Xn),SR
/*735 */	{2,	0,	10,0,0,0,	18,0,3,0},	// MOVE.B #<data>.B,SR
/*736 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NOT.B Dn
/*737 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NOT.B (An)
/*738 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NOT.B (An)+
/*739 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NOT.B -(An)
/*740 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.B (d16,An)
/*741 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NOT.B (d8,An,Xn)
/*742 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.B (xxx).W
/*743 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NOT.B (xxx).L
/*744 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NOT.W Dn
/*745 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NOT.W (An)
/*746 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NOT.W (An)+
/*747 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NOT.W -(An)
/*748 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.W (d16,An)
/*749 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NOT.W (d8,An,Xn)
/*750 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.W (xxx).W
/*751 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NOT.W (xxx).L
/*752 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NOT.L Dn
/*753 */	{1,	2,	18,1,0,1,	21,1,1,1},	// NOT.L (An)
/*754 */	{0,	2,	18,1,0,1,	21,1,1,1},	// NOT.L (An)+
/*755 */	{2,	3,	19,1,0,1,	22,1,1,1},	// NOT.L -(An)
/*756 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NOT.L (d16,An)
/*757 */	{4,	3,	21,1,0,1,	26,1,2,1},	// NOT.L (d8,An,Xn)
/*758 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NOT.L (xxx).W
/*759 */	{1,	1,	19,1,0,1,	25,1,2,1},	// NOT.L (xxx).L
/*760 */	{0,	0,	 8,0,0,0,	14,0,2,0},	// MOVE.W Dn,SR
/*761 */	{1,	1,	13,1,0,0,	19,1,2,0},	// MOVE.W (An),SR
/*762 */	{0,	1,	13,1,0,0,	19,1,2,0},	// MOVE.W (An)+,SR
/*763 */	{2,	2,	14,1,0,0,	20,1,2,0},	// MOVE.W -(An),SR
/*764 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.W (d16,An),SR
/*765 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.W (d8,An,Xn),SR
/*766 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.W (xxx).W,SR
/*767 */	{1,	0,	14,1,0,0,	23,1,3,0},	// MOVE.W (xxx).L,SR
/*768 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.W (d16,PC),SR
/*769 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.W (d8,PC,Xn),SR
/*770 */	{2,	0,	10,0,0,0,	18,0,3,0},	// MOVE.W #<data>.W,SR
/*771 */	{0,	0,	 6,0,0,0,	 8,0,1,0},	// NBCD.B Dn
/*772 */	{2,	0,	12,0,0,1,	17,0,2,1},	// LINK.L An,#<data>.L
/*773 */	{1,	1,	13,1,0,1,	15,1,1,1},	// NBCD.B (An)	(value guessed (not in motorola 68030UM doc))
/*774 */	{0,	1,	13,1,0,1,	15,1,1,1},	// NBCD.B (An)+	(value guessed (not in motorola 68030UM doc))
/*775 */	{2,	2,	14,1,0,1,	16,1,1,1},	// NBCD.B -(An)	(value guessed (not in motorola 68030UM doc))
/*776 */	{2,	2,	14,1,0,1,	18,1,2,1},	// NBCD.B (d16,An)	(value guessed (not in motorola 68030UM doc))
/*777 */	{4,	2,	16,1,0,1,	20,1,2,1},	// NBCD.B (d8,An,Xn)	(value guessed (not in motorola 68030UM doc))
/*778 */	{2,	2,	14,1,0,1,	18,1,2,1},	// NBCD.B (xxx).W	(value guessed (not in motorola 68030UM doc))
/*779 */	{1,	0,	14,1,0,1,	19,1,2,1},	// NBCD.B (xxx).L	(value guessed (not in motorola 68030UM doc))
/*780 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// SWAP.W Dn
/*781 */	{1,	0,	15,1,0,0,	15,1,0,0},	// BKPTQ.L #<data>
/*782 */	{2,	2,	12,0,0,1,	14,0,1,1},	// PEA.L (An)
/*783 */	{2,	2,	12,0,0,1,	16,0,2,1},	// PEA.L (d16,An)
/*784 */	{4,	2,	14,0,0,1,	18,0,2,1},	// PEA.L (d8,An,Xn)
/*785 */	{2,	2,	12,0,0,1,	16,0,2,1},	// PEA.L (xxx).W
/*786 */	{4,	2,	14,0,0,1,	18,0,2,1},	// PEA.L (xxx).L
/*787 */	{2,	2,	12,0,0,1,	16,0,2,1},	// PEA.L (d16,PC)
/*788 */	{4,	2,	14,0,0,1,	18,0,2,1},	// PEA.L (d8,PC,Xn)
/*789 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXT.W Dn
/*790 */	{6,	0,	 6,0,0,0,	10,0,2,0},	// MVMLE.W #<data>.W,(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*791 */	{6,	0,	 6,0,0,0,	10,0,2,0},	// MVMLE.W #<data>.W,-(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*792 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.W #<data>.W,(d16,An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*793 */	{10,	0,	10,0,0,0,	16,0,3,0},	// MVMLE.W #<data>.W,(d8,An,Xn)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*794 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.W #<data>.W,(xxx).W	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*795 */	{10,	0,	10,0,0,0,	16,0,3,0},	// MVMLE.W #<data>.W,(xxx).L	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*796 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXT.L Dn
/*797 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.L #<data>.W,(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*798 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.L #<data>.W,-(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*799 */	{10,	0,	10,0,0,0,	17,0,3,0},	// MVMLE.L #<data>.W,(d16,An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*800 */	{12,	0,	12,0,0,0,	18,0,3,0},	// MVMLE.L #<data>.W,(d8,An,Xn)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*801 */	{10,	0,	10,0,0,0,	16,0,3,0},	// MVMLE.L #<data>.W,(xxx).W	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*802 */	{12,	0,	12,0,0,0,	18,0,3,0},	// MVMLE.L #<data>.W,(xxx).L	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*803 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXT.B Dn
/*804 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.B Dn
/*805 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// TST.B (An)
/*806 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// TST.B (An)+
/*807 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// TST.B -(An)
/*808 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.B (d16,An)
/*809 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.B (d8,An,Xn)
/*810 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.B (xxx).W
/*811 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// TST.B (xxx).L
/*812 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.B (d16,PC)
/*813 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.B (d8,PC,Xn)
/*814 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// TST.B #<data>.B
/*815 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.W Dn
/*816 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.W An
/*817 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// TST.W (An)
/*818 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// TST.W (An)+
/*819 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// TST.W -(An)
/*820 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.W (d16,An)
/*821 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.W (d8,An,Xn)
/*822 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.W (xxx).W
/*823 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// TST.W (xxx).L
/*824 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.W (d16,PC)
/*825 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.W (d8,PC,Xn)
/*826 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// TST.W #<data>.W
/*827 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.L Dn
/*828 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.L An
/*829 */	{1,	1,	11,1,0,0,	13,1,1,0},	// TST.L (An)
/*830 */	{0,	1,	11,1,0,0,	13,1,1,0},	// TST.L (An)+
/*831 */	{2,	2,	12,1,0,0,	14,1,1,0},	// TST.L -(An)
/*832 */	{2,	2,	12,1,0,0,	16,1,2,0},	// TST.L (d16,An)
/*833 */	{4,	2,	14,1,0,0,	18,1,2,0},	// TST.L (d8,An,Xn)
/*834 */	{2,	2,	12,1,0,0,	16,1,2,0},	// TST.L (xxx).W
/*835 */	{1,	0,	12,1,0,0,	17,1,2,0},	// TST.L (xxx).L
/*836 */	{2,	2,	12,1,0,0,	16,1,2,0},	// TST.L (d16,PC)
/*837 */	{4,	2,	14,1,0,0,	18,1,2,0},	// TST.L (d8,PC,Xn)
/*838 */	{4,	0,	 6,0,0,0,	10,0,2,0},	// TST.L #<data>.L
/*839 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// TAS.B Dn
/*840 */	{8,	0,	18,1,0,1,	20,1,1,1},	// TAS.B (An)
/*841 */	{3,	0,	18,1,0,1,	20,1,1,1},	// TAS.B (An)+
/*842 */	{8,	0,	18,1,0,1,	20,1,1,1},	// TAS.B -(An)
/*843 */	{8,	0,	18,1,0,1,	22,1,2,1},	// TAS.B (d16,An)
/*844 */	{10,	0,	20,1,0,1,	24,1,2,1},	// TAS.B (d8,An,Xn)
/*845 */	{8,	0,	18,1,0,1,	22,1,2,1},	// TAS.B (xxx).W
/*846 */	{10,	0,	20,1,0,1,	24,1,2,1},	// TAS.B (xxx).L
/*847 */	{8,	0,	48,0,0,0,	52,0,2,0},	// MULL.L #<data>.W,Dn			(Max Value)
/*848 */	{3,	0,	54,1,0,0,	59,1,2,0},	// MULL.L #<data>.W,(An)		(Max Value)
/*849 */	{6,	1,	57,1,0,0,	61,1,2,0},	// MULL.L #<data>.W,(An)+		(Max Value)
/*850 */	{4,	0,	54,1,0,0,	59,1,2,0},	// MULL.L #<data>.W,-(An)		(Max Value)
/*851 */	{6,	0,	56,1,0,0,	64,1,3,0},	// MULL.L #<data>.W,(d16,An)		(Max Value)
/*852 */	{10,	2,	60,1,0,0,	66,1,3,0},	// MULL.L #<data>.W,(d8,An,Xn)		(Max Value)
/*853 */	{8,	2,	58,1,0,0,	64,1,3,0},	// MULL.L #<data>.W,(xxx).W		(Max Value)
/*854 */	{7,	0,	58,1,0,0,	65,1,3,0},	// MULL.L #<data>.W,(xxx).L		(Max Value)
/*855 */	{6,	0,	56,1,0,0,	64,1,3,0},	// MULL.L #<data>.W,(d16,PC)		(Max Value)
/*856 */	{10,	2,	60,1,0,0,	66,1,3,0},	// MULL.L #<data>.W,(d8,PC,Xn)		(Max Value)
/*857 */	{10,	0,	50,0,0,0,	56,0,3,0},	// MULL.L #<data>.W,#<data>.L		(Max Value)
/*858 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,Dn			(See DIVL table below)(Max Value)
/*859 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(An)		(See DIVL table below)(Max Value)
/*860 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(An)+		(See DIVL table below)(Max Value)
/*861 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,-(An)		(See DIVL table below)(Max Value)
/*862 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d16,An)		(See DIVL table below)(Max Value)
/*863 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d8,An,Xn)		(See DIVL table below)(Max Value)
/*864 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(xxx).W		(See DIVL table below)(Max Value)
/*865 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(xxx).L		(See DIVL table below)(Max Value)
/*866 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d16,PC)		(See DIVL table below)(Max Value)
/*867 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d8,PC,Xn)		(See DIVL table below)(Max Value)
/*868 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,#<data>.L		(See DIVL table below)(Max Value)
/*869 */	{6,	0,	10,0,0,0,	14,0,2,0},	// MVMEL.W #<data>.W,(An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*870 */	{6,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(An)+	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*871 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(d16,An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*872 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.W #<data>.W,(d8,An,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*873 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(xxx).W	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*874 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.W #<data>.W,(xxx).L	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*875 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(d16,PC)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*876 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.W #<data>.W,(d8,PC,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*877 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.L #<data>.W,(An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*878 */	{6,	0,	14,0,0,0,	18,0,2,0},	// MVMEL.L #<data>.W,(An)+	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*879 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.L #<data>.W,(d16,An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*880 */	{12,	0,	16,0,0,0,	22,0,3,0},	// MVMEL.L #<data>.W,(d8,An,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*881 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.L #<data>.W,(xxx).W	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*882 */	{12,	0,	16,0,0,0,	22,0,3,0},	// MVMEL.L #<data>.W,(xxx).L	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*883 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.L #<data>.W,(d16,PC)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*884 */	{12,	0,	16,0,0,0,	22,0,3,0},	// MVMEL.L #<data>.W,(d8,PC,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*885 */	{0,	0,	28,1,0,4,	34,1,2,4},	// TRAPQ.L #<data>
/*886 */	{0,	0,	 6,0,0,1,	 9,0,1,1},	// LINK.W An,#<data>.W
/*887 */	{0,	0,	 7,1,0,0,	 9,1,1,0},	// UNLK.L An
/*888 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE An,USP.L
/*889 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE USP.L,An
/*890 */	{0,	0,	518,0,0,0,	520,0,1,0}, 	// RESET.L 
/*891 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// NOP.L 
/*892 */	{0,	0,	 8,0,0,0,	12,0,2,0},	// STOP.L #<data>.W
/*893 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// RTE.L			(See RTE table below) 
/*894 */	{2,	0,	12,1,0,0,	18,1,2,0},	// RTD.L #<data>.W
/*895 */	{1,	0,	11,1,0,0,	17,1,2,0},	// RTS.L 
/*896 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPV.L			(See TRAPV table below)
/*897 */	{1,	0,	16,2,0,0,	22,2,2,0},	// RTR.L 
/*898 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// MOVEC2.L #<data>.W
/*899 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVE2C.L #<data>.W		(See MOVEC table below)
/*900 */	{2,	0,	12,0,0,1,	19,0,2,1},	// JSR.L (An)
/*901 */	{4,	0,	14,0,0,1,	21,0,2,1},	// JSR.L (d16,An)
/*902 */	{6,	0,	16,0,0,1,	23,0,2,1},	// JSR.L (d8,An,Xn)
/*903 */	{2,	0,	12,0,0,1,	19,0,2,1},	// JSR.L (xxx).W
/*904 */	{2,	0,	12,0,0,1,	19,0,2,1},	// JSR.L (xxx).L
/*905 */	{4,	0,	14,0,0,1,	21,0,2,1},	// JSR.L (d16,PC)
/*906 */	{6,	0,	16,0,0,1,	23,0,2,1},	// JSR.L (d8,PC,Xn)
/*907 */	{10,	0,	 6,0,0,0,	12,0,2,0},	// JMP.L (An)
/*908 */	{12,	0,	 8,0,0,0,	14,0,2,0},	// JMP.L (d16,An)
/*909 */	{14,	0,	10,0,0,0,	16,0,2,0},	// JMP.L (d8,An,Xn)
/*910 */	{10,	0,	 6,0,0,0,	12,0,2,0},	// JMP.L (xxx).W
/*911 */	{10,	0,	 6,0,0,0,	12,0,2,0},	// JMP.L (xxx).L
/*912 */	{12,	0,	 8,0,0,0,	14,0,2,0},	// JMP.L (d16,PC)
/*913 */	{14,	0,	10,0,0,0,	16,0,2,0},	// JMP.L (d8,PC,Xn)
/*914 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDQ.B #<data>,Dn
/*915 */	{1,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.B #<data>,(An)
/*916 */	{0,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.B #<data>,(An)+
/*917 */	{2,	3,	11,1,0,1,	14,1,1,1},	// ADDQ.B #<data>,-(An)
/*918 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.B #<data>,(d16,An)
/*919 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDQ.B #<data>,(d8,An,Xn)
/*920 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.B #<data>,(xxx).W
/*921 */	{1,	1,	11,1,0,1,	17,1,2,1},	// ADDQ.B #<data>,(xxx).L
/*922 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDQ.W #<data>,Dn
/*923 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDAQ.W #<data>,An
/*924 */	{1,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.W #<data>,(An)
/*925 */	{0,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.W #<data>,(An)+
/*926 */	{2,	3,	11,1,0,1,	14,1,1,1},	// ADDQ.W #<data>,-(An)
/*927 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.W #<data>,(d16,An)
/*928 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDQ.W #<data>,(d8,An,Xn)
/*929 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.W #<data>,(xxx).W
/*930 */	{1,	1,	11,1,0,1,	17,1,2,1},	// ADDQ.W #<data>,(xxx).L
/*931 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDQ.L #<data>,Dn
/*932 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDAQ.L #<data>,An
/*933 */	{1,	2,	18,1,0,1,	21,1,1,1},	// ADDQ.L #<data>,(An)
/*934 */	{0,	2,	18,1,0,1,	21,1,1,1},	// ADDQ.L #<data>,(An)+
/*935 */	{2,	3,	19,1,0,1,	22,1,1,1},	// ADDQ.L #<data>,-(An)
/*936 */	{2,	3,	19,1,0,1,	24,1,2,1},	// ADDQ.L #<data>,(d16,An)
/*937 */	{4,	3,	21,1,0,1,	26,1,2,1},	// ADDQ.L #<data>,(d8,An,Xn)
/*938 */	{2,	3,	19,1,0,1,	24,1,2,1},	// ADDQ.L #<data>,(xxx).W
/*939 */	{1,	1,	19,1,0,1,	25,1,2,1},	// ADDQ.L #<data>,(xxx).L
/*940 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*941 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*942 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*943 */	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*944 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*945 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*946 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*947 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*948 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*949 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*950 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*951 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*952 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBQ.B #<data>,Dn
/*953 */	{1,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.B #<data>,(An)
/*954 */	{0,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.B #<data>,(An)+
/*955 */	{2,	3,	11,1,0,1,	14,1,1,1},	// SUBQ.B #<data>,-(An)
/*956 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.B #<data>,(d16,An)
/*957 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBQ.B #<data>,(d8,An,Xn)
/*958 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.B #<data>,(xxx).W
/*959 */	{1,	1,	11,1,0,1,	17,1,2,1},	// SUBQ.B #<data>,(xxx).L
/*960 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBQ.W #<data>,Dn
/*961 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBAQ.W #<data>,An
/*962 */	{1,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.W #<data>,(An)
/*963 */	{0,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.W #<data>,(An)+
/*964 */	{2,	3,	11,1,0,1,	14,1,1,1},	// SUBQ.W #<data>,-(An)
/*965 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.W #<data>,(d16,An)
/*966 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBQ.W #<data>,(d8,An,Xn)
/*967 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.W #<data>,(xxx).W
/*968 */	{1,	1,	11,1,0,1,	17,1,2,1},	// SUBQ.W #<data>,(xxx).L
/*969 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBQ.L #<data>,Dn
/*970 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBAQ.L #<data>,An
/*971 */	{1,	2,	18,1,0,1,	21,1,1,1},	// SUBQ.L #<data>,(An)
/*972 */	{0,	2,	18,1,0,1,	21,1,1,1},	// SUBQ.L #<data>,(An)+
/*973 */	{2,	3,	19,1,0,1,	22,1,1,1},	// SUBQ.L #<data>,-(An)
/*974 */	{2,	3,	19,1,0,1,	24,1,2,1},	// SUBQ.L #<data>,(d16,An)
/*975 */	{4,	3,	21,1,0,1,	26,1,2,1},	// SUBQ.L #<data>,(d8,An,Xn)
/*976 */	{2,	3,	19,1,0,1,	24,1,2,1},	// SUBQ.L #<data>,(xxx).W
/*977 */	{1,	1,	19,1,0,1,	25,1,2,1},	// SUBQ.L #<data>,(xxx).L
/*978 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*979 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*980 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*981 */	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*982 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*983 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*984 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*985 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*986 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*987 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*988 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*989 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*990 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*991 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*992 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*993 */	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*994 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*995 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*996 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*997 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*998 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*999 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1000*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1001*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1002*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1003*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1004*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1005*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1006*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1007*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1008*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1009*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1010*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1011*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1012*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1013*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1014*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1015*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1016*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1017*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1018*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1019*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1020*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1021*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1022*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1023*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1024*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1025*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1026*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1027*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1028*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1029*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1030*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1031*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1032*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1033*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1034*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1035*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1036*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1037*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1038*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1039*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1040*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1041*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1042*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1043*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1044*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1045*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1046*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1047*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1048*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1049*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1050*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1051*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1052*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1053*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1054*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1055*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1056*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1057*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1058*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1059*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1060*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1061*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1062*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1063*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1064*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1065*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1066*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1067*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1068*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1069*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1070*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1071*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1072*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1073*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1074*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1075*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1076*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1077*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1078*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1079*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1080*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1081*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1082*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1083*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1084*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1085*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1086*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1087*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1088*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1089*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1090*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1091*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1092*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1093*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1094*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1095*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1096*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1097*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1098*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1099*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1100*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1101*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1102*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1103*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1104*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1105*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1106*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1107*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1108*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1109*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1110*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1111*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1112*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1113*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1114*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1115*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1116*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1117*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1118*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1119*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1120*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1121*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1122*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1123*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1124*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1125*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1126*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1127*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1128*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1129*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1130*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1131*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1132*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1133*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1134*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1135*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1136*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1137*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1138*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1139*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1140*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1141*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1142*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1143*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1144*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1145*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1146*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1147*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1148*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1149*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1150*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1151*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1152*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1153*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1154*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1155*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1156*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1157*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1158*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1159*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1160*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1161*/	{2,	0,	 8,0,0,1,	15,0,2,1},	// BSR.W #<data>.W
/*1162*/	{2,	0,	 8,0,0,1,	15,0,2,1},	// BSRQ.B #<data>
/*1163*/	{2,	0,	12,0,0,1,	19,0,2,1},	// BSR.L #<data>.L
/*1164*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1165*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1166*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1167*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1168*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1169*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1170*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1171*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1172*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1173*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1174*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1175*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1176*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1177*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1178*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1179*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1180*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1181*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1182*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1183*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1184*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1185*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1186*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1187*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1188*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1189*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1190*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1191*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1192*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1193*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1194*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1195*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1196*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1197*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1198*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1199*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1200*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1201*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1202*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1203*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1204*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1205*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1206*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEQ.L #<data>,Dn
/*1207*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// OR.B Dn,Dn
/*1208*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// OR.B (An),Dn
/*1209*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// OR.B (An)+,Dn
/*1210*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// OR.B -(An),Dn
/*1211*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// OR.B (d16,An),Dn
/*1212*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.B (d8,An,Xn),Dn
/*1213*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.B (xxx).W,Dn
/*1214*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// OR.B (xxx).L,Dn
/*1215*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.B (d16,PC),Dn
/*1216*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.B (d8,PC,Xn),Dn
/*1217*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// OR.B #<data>.B,Dn
/*1218*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// OR.W Dn,Dn
/*1219*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// OR.W (An),Dn
/*1220*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// OR.W (An)+,Dn
/*1221*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// OR.W -(An),Dn
/*1222*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// OR.W (d16,An),Dn
/*1223*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.W (d8,An,Xn),Dn
/*1224*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.W (xxx).W,Dn
/*1225*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// OR.W (xxx).L,Dn
/*1226*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.W (d16,PC),Dn
/*1227*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.W (d8,PC,Xn),Dn
/*1228*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// OR.W #<data>.W,Dn
/*1229*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// OR.L Dn,Dn
/*1230*/	{1,	1,	11,1,0,0,	13,1,1,0},	// OR.L (An),Dn
/*1231*/	{0,	1,	11,1,0,0,	13,1,1,0},	// OR.L (An)+,Dn
/*1232*/	{2,	2,	12,1,0,0,	14,1,1,0},	// OR.L -(An),Dn
/*1233*/	{2,	2,	12,1,0,0,	16,1,2,0},	// OR.L (d16,An),Dn
/*1234*/	{4,	2,	14,1,0,0,	18,1,2,0},	// OR.L (d8,An,Xn),Dn
/*1235*/	{2,	2,	12,1,0,0,	16,1,2,0},	// OR.L (xxx).W,Dn
/*1236*/	{1,	0,	12,1,0,0,	17,1,2,0},	// OR.L (xxx).L,Dn
/*1237*/	{2,	2,	12,1,0,0,	16,1,2,0},	// OR.L (d16,PC),Dn
/*1238*/	{4,	2,	14,1,0,0,	18,1,2,0},	// OR.L (d8,PC,Xn),Dn
/*1239*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// OR.L #<data>.L,Dn
/*1240*/	{2,	0,	44,0,0,0,	46,0,1,0},	// DIVU.W Dn,Dn			(Max Value)
/*1241*/	{1,	1,	49,1,0,0,	51,1,1,0},	// DIVU.W (An),Dn		(Max Value)
/*1242*/	{0,	1,	49,1,0,0,	51,1,1,0},	// DIVU.W (An)+,Dn		(Max Value)
/*1243*/	{2,	2,	50,1,0,0,	52,1,1,0},	// DIVU.W -(An),Dn		(Max Value)
/*1244*/	{2,	2,	50,1,0,0,	54,1,2,0},	// DIVU.W (d16,An),Dn		(Max Value)
/*1245*/	{4,	2,	52,1,0,0,	56,1,2,0},	// DIVU.W (d8,An,Xn),Dn		(Max Value)
/*1246*/	{2,	2,	50,1,0,0,	54,1,2,0},	// DIVU.W (xxx).W,Dn		(Max Value)
/*1247*/	{1,	0,	50,1,0,0,	55,1,2,0},	// DIVU.W (xxx).L,Dn		(Max Value)
/*1248*/	{2,	2,	50,1,0,0,	54,1,2,0},	// DIVU.W (d16,PC),Dn		(Max Value)
/*1249*/	{4,	2,	52,1,0,0,	56,1,2,0},	// DIVU.W (d8,PC,Xn),Dn		(Max Value)
/*1250*/	{2,	0,	46,0,0,0,	50,0,2,0},	// DIVU.W #<data>.W,Dn		(Max Value)
/*1251*/	{0,	0,	 4,0,0,0,	 6,0,1,0},	// SBCD.B Dn,Dn
/*1252*/	{2,	1,	19,2,0,1,	22,2,1,1},	// SBCD.B -(An),-(An)
/*1253*/	{1,	2,	10,1,0,1,	13,1,1,1},	// OR.B Dn,(An)
/*1254*/	{0,	2,	10,1,0,1,	13,1,1,1},	// OR.B Dn,(An)+
/*1255*/	{2,	3,	11,1,0,1,	14,1,1,1},	// OR.B Dn,-(An)
/*1256*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.B Dn,(d16,An)
/*1257*/	{4,	3,	13,1,0,1,	18,1,2,1},	// OR.B Dn,(d8,An,Xn)
/*1258*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.B Dn,(xxx).W
/*1259*/	{1,	1,	11,1,0,1,	17,1,2,1},	// OR.B Dn,(xxx).L
/*1260*/	{6,	0,	 6,0,0,0,	 8,0,1,0},	// PACK.L Dn,Dn
/*1261*/	{2,	1,	23,1,0,1,	25,1,1,1},	// PACK.L -(An),-(An)
/*1262*/	{1,	2,	10,1,0,1,	13,1,1,1},	// OR.W Dn,(An)
/*1263*/	{0,	2,	10,1,0,1,	13,1,1,1},	// OR.W Dn,(An)+
/*1264*/	{2,	3,	11,1,0,1,	14,1,1,1},	// OR.W Dn,-(An)
/*1265*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.W Dn,(d16,An)
/*1266*/	{4,	3,	13,1,0,1,	18,1,2,1},	// OR.W Dn,(d8,An,Xn)
/*1267*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.W Dn,(xxx).W
/*1268*/	{1,	1,	11,1,0,1,	17,1,2,1},	// OR.W Dn,(xxx).L
/*1269*/	{8,	0,	 8,0,0,0,	10,0,1,0},	// UNPK.L Dn,Dn
/*1270*/	{2,	1,	23,1,0,1,	25,1,1,1},	// UNPK.L -(An),-(An)
/*1271*/	{1,	2,	18,1,0,1,	21,1,1,1},	// OR.L Dn,(An)
/*1272*/	{0,	2,	18,1,0,1,	21,1,1,1},	// OR.L Dn,(An)+
/*1273*/	{2,	3,	19,1,0,1,	22,1,1,1},	// OR.L Dn,-(An)
/*1274*/	{2,	3,	19,1,0,1,	24,1,2,1},	// OR.L Dn,(d16,An)
/*1275*/	{4,	3,	21,1,0,1,	26,1,2,1},	// OR.L Dn,(d8,An,Xn)
/*1276*/	{2,	3,	19,1,0,1,	24,1,2,1},	// OR.L Dn,(xxx).W
/*1277*/	{1,	1,	19,1,0,1,	25,1,2,1},	// OR.L Dn,(xxx).L
/*1278*/	{2,	0,	56,0,0,0,	58,0,1,0},	// DIVS.W Dn,Dn			(Max Value)
/*1279*/	{1,	1,	61,1,0,0,	63,1,1,0},	// DIVS.W (An),Dn		(Max Value)
/*1280*/	{0,	1,	61,1,0,0,	63,1,1,0},	// DIVS.W (An)+,Dn		(Max Value)
/*1281*/	{2,	2,	62,1,0,0,	64,1,1,0},	// DIVS.W -(An),Dn		(Max Value)
/*1282*/	{2,	2,	62,1,0,0,	66,1,2,0},	// DIVS.W (d16,An),Dn		(Max Value)
/*1283*/	{4,	2,	64,1,0,0,	68,1,2,0},	// DIVS.W (d8,An,Xn),Dn		(Max Value)
/*1284*/	{2,	2,	62,1,0,0,	66,1,2,0},	// DIVS.W (xxx).W,Dn		(Max Value)
/*1285*/	{1,	0,	62,1,0,0,	67,1,2,0},	// DIVS.W (xxx).L,Dn		(Max Value)
/*1286*/	{2,	2,	62,1,0,0,	66,1,2,0},	// DIVS.W (d16,PC),Dn		(Max Value)
/*1287*/	{4,	2,	64,1,0,0,	68,1,2,0},	// DIVS.W (d8,PC,Xn),Dn		(Max Value)
/*1288*/	{2,	0,	58,0,0,0,	62,0,2,0},	// DIVS.W #<data>.W,Dn		(Max Value)
/*1289*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.B Dn,Dn
/*1290*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.B (An),Dn
/*1291*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.B (An)+,Dn
/*1292*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// SUB.B -(An),Dn
/*1293*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// SUB.B (d16,An),Dn
/*1294*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.B (d8,An,Xn),Dn
/*1295*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.B (xxx).W,Dn
/*1296*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// SUB.B (xxx).L,Dn
/*1297*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.B (d16,PC),Dn
/*1298*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.B (d8,PC,Xn),Dn
/*1299*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// SUB.B #<data>.B,Dn
/*1300*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.W Dn,Dn
/*1301*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.W An,Dn
/*1302*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.W (An),Dn
/*1303*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.W (An)+,Dn
/*1304*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// SUB.W -(An),Dn
/*1305*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// SUB.W (d16,An),Dn
/*1306*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.W (d8,An,Xn),Dn
/*1307*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.W (xxx).W,Dn
/*1308*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// SUB.W (xxx).L,Dn
/*1309*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.W (d16,PC),Dn
/*1310*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.W (d8,PC,Xn),Dn
/*1311*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// SUB.W #<data>.W,Dn
/*1312*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.L Dn,Dn
/*1313*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.L An,Dn
/*1314*/	{1,	1,	11,1,0,0,	13,1,1,0},	// SUB.L (An),Dn
/*1315*/	{0,	1,	11,1,0,0,	13,1,1,0},	// SUB.L (An)+,Dn
/*1316*/	{2,	2,	12,1,0,0,	14,1,1,0},	// SUB.L -(An),Dn
/*1317*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUB.L (d16,An),Dn
/*1318*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUB.L (d8,An,Xn),Dn
/*1319*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUB.L (xxx).W,Dn
/*1320*/	{1,	0,	12,1,0,0,	17,1,2,0},	// SUB.L (xxx).L,Dn
/*1321*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUB.L (d16,PC),Dn
/*1322*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUB.L (d8,PC,Xn),Dn
/*1323*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// SUB.L #<data>.L,Dn
/*1324*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// SUBA.W Dn,An
/*1325*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// SUBA.W An,An
/*1326*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// SUBA.W (An),An
/*1327*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// SUBA.W (An)+,An
/*1328*/	{2,	2,	10,1,0,0,	12,1,1,0},	// SUBA.W -(An),An
/*1329*/	{2,	2,	10,1,0,0,	14,1,2,0},	// SUBA.W (d16,An),An
/*1330*/	{4,	2,	12,1,0,0,	16,1,2,0},	// SUBA.W (d8,An,Xn),An
/*1331*/	{2,	2,	10,1,0,0,	14,1,2,0},	// SUBA.W (xxx).W,An
/*1332*/	{1,	0,	10,1,0,0,	15,1,2,0},	// SUBA.W (xxx).L,An
/*1333*/	{2,	2,	10,1,0,0,	14,1,2,0},	// SUBA.W (d16,PC),An
/*1334*/	{4,	2,	12,1,0,0,	16,1,2,0},	// SUBA.W (d8,PC,Xn),An
/*1335*/	{2,	0,	 6,0,0,0,	10,0,2,0},	// SUBA.W #<data>.W,An
/*1336*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBX.B Dn,Dn
/*1337*/	{2,	1,	15,2,0,1,	18,2,1,1},	// SUBX.B -(An),-(An)
/*1338*/	{1,	2,	10,1,0,1,	13,1,1,1},	// SUB.B Dn,(An)
/*1339*/	{0,	2,	10,1,0,1,	13,1,1,1},	// SUB.B Dn,(An)+
/*1340*/	{2,	3,	11,1,0,1,	14,1,1,1},	// SUB.B Dn,-(An)
/*1341*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.B Dn,(d16,An)
/*1342*/	{4,	3,	13,1,0,1,	18,1,2,1},	// SUB.B Dn,(d8,An,Xn)
/*1343*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.B Dn,(xxx).W
/*1344*/	{1,	1,	11,1,0,1,	17,1,2,1},	// SUB.B Dn,(xxx).L
/*1345*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBX.W Dn,Dn
/*1346*/	{2,	1,	15,2,0,1,	18,2,1,1},	// SUBX.W -(An),-(An)
/*1347*/	{1,	2,	10,1,0,1,	13,1,1,1},	// SUB.W Dn,(An)
/*1348*/	{0,	2,	10,1,0,1,	13,1,1,1},	// SUB.W Dn,(An)+
/*1349*/	{2,	3,	11,1,0,1,	14,1,1,1},	// SUB.W Dn,-(An)
/*1350*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.W Dn,(d16,An)
/*1351*/	{4,	3,	13,1,0,1,	18,1,2,1},	// SUB.W Dn,(d8,An,Xn)
/*1352*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.W Dn,(xxx).W
/*1353*/	{1,	1,	11,1,0,1,	17,1,2,1},	// SUB.W Dn,(xxx).L
/*1354*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBX.L Dn,Dn
/*1355*/	{2,	1,	27,2,0,1,	30,2,1,1},	// SUBX.L -(An),-(An)
/*1356*/	{1,	2,	18,1,0,1,	21,1,1,1},	// SUB.L Dn,(An)
/*1357*/	{0,	2,	18,1,0,1,	21,1,1,1},	// SUB.L Dn,(An)+
/*1358*/	{2,	3,	19,1,0,1,	22,1,1,1},	// SUB.L Dn,-(An)
/*1359*/	{2,	3,	19,1,0,1,	24,1,2,1},	// SUB.L Dn,(d16,An)
/*1360*/	{4,	3,	21,1,0,1,	26,1,2,1},	// SUB.L Dn,(d8,An,Xn)
/*1361*/	{2,	3,	19,1,0,1,	24,1,2,1},	// SUB.L Dn,(xxx).W
/*1362*/	{1,	1,	19,1,0,1,	25,1,2,1},	// SUB.L Dn,(xxx).L
/*1363*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBA.L Dn,An
/*1364*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBA.L An,An
/*1365*/	{1,	1,	11,1,0,0,	13,1,1,0},	// SUBA.L (An),An
/*1366*/	{0,	1,	11,1,0,0,	13,1,1,0},	// SUBA.L (An)+,An
/*1367*/	{2,	2,	12,1,0,0,	14,1,1,0},	// SUBA.L -(An),An
/*1368*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUBA.L (d16,An),An
/*1369*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUBA.L (d8,An,Xn),An
/*1370*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUBA.L (xxx).W,An
/*1371*/	{1,	0,	12,1,0,0,	17,1,2,0},	// SUBA.L (xxx).L,An
/*1372*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUBA.L (d16,PC),An
/*1373*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUBA.L (d8,PC,Xn),An
/*1374*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// SUBA.L #<data>.L,An
/*1375*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.B Dn,Dn
/*1376*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.B (An),Dn
/*1377*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.B (An)+,Dn
/*1378*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// CMP.B -(An),Dn
/*1379*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.B (d16,An),Dn
/*1380*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.B (d8,An,Xn),Dn
/*1381*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.B (xxx).W,Dn
/*1382*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// CMP.B (xxx).L,Dn
/*1383*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.B (d16,PC),Dn
/*1384*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.B (d8,PC,Xn),Dn
/*1385*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// CMP.B #<data>.B,Dn
/*1386*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.W Dn,Dn
/*1387*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.W An,Dn
/*1388*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.W (An),Dn
/*1389*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.W (An)+,Dn
/*1390*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// CMP.W -(An),Dn
/*1391*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.W (d16,An),Dn
/*1392*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.W (d8,An,Xn),Dn
/*1393*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.W (xxx).W,Dn
/*1394*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// CMP.W (xxx).L,Dn
/*1395*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.W (d16,PC),Dn
/*1396*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.W (d8,PC,Xn),Dn
/*1397*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// CMP.W #<data>.W,Dn
/*1398*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.L Dn,Dn
/*1399*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.L An,Dn
/*1400*/	{1,	1,	11,1,0,0,	13,1,1,0},	// CMP.L (An),Dn
/*1401*/	{0,	1,	11,1,0,0,	13,1,1,0},	// CMP.L (An)+,Dn
/*1402*/	{2,	2,	12,1,0,0,	14,1,1,0},	// CMP.L -(An),Dn
/*1403*/	{2,	2,	12,1,0,0,	16,1,2,0},	// CMP.L (d16,An),Dn
/*1404*/	{4,	2,	14,1,0,0,	18,1,2,0},	// CMP.L (d8,An,Xn),Dn
/*1405*/	{2,	2,	12,1,0,0,	16,1,2,0},	// CMP.L (xxx).W,Dn
/*1406*/	{1,	0,	12,1,0,0,	17,1,2,0},	// CMP.L (xxx).L,Dn
/*1407*/	{2,	2,	12,1,0,0,	16,1,2,0},	// CMP.L (d16,PC),Dn
/*1408*/	{4,	2,	14,1,0,0,	18,1,2,0},	// CMP.L (d8,PC,Xn),Dn
/*1409*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// CMP.L #<data>.L,Dn
/*1410*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.W Dn,An
/*1411*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.W An,An
/*1412*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// CMPA.W (An),An
/*1413*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// CMPA.W (An)+,An
/*1414*/	{2,	2,	10,1,0,0,	12,1,1,0},	// CMPA.W -(An),An
/*1415*/	{2,	2,	10,1,0,0,	14,1,2,0},	// CMPA.W (d16,An),An
/*1416*/	{4,	2,	12,1,0,0,	16,1,2,0},	// CMPA.W (d8,An,Xn),An
/*1417*/	{2,	2,	10,1,0,0,	14,1,2,0},	// CMPA.W (xxx).W,An
/*1418*/	{1,	0,	10,1,0,0,	15,1,2,0},	// CMPA.W (xxx).L,An
/*1419*/	{2,	2,	10,1,0,0,	14,1,2,0},	// CMPA.W (d16,PC),An
/*1420*/	{4,	2,	12,1,0,0,	16,1,2,0},	// CMPA.W (d8,PC,Xn),An
/*1421*/	{2,	0,	 6,0,0,0,	10,0,2,0},	// CMPA.W #<data>.W,An
/*1422*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// EOR.B Dn,Dn
/*1423*/	{0,	0,	12,2,0,0,	14,2,1,0},	// CMPM.B (An)+,(An)+
/*1424*/	{1,	2,	10,1,0,1,	13,1,1,1},	// EOR.B Dn,(An)
/*1425*/	{0,	2,	10,1,0,1,	13,1,1,1},	// EOR.B Dn,(An)+
/*1426*/	{2,	3,	11,1,0,1,	14,1,1,1},	// EOR.B Dn,-(An)
/*1427*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.B Dn,(d16,An)
/*1428*/	{4,	3,	13,1,0,1,	18,1,2,1},	// EOR.B Dn,(d8,An,Xn)
/*1429*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.B Dn,(xxx).W
/*1430*/	{1,	1,	11,1,0,1,	17,1,2,1},	// EOR.B Dn,(xxx).L
/*1431*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// EOR.W Dn,Dn
/*1432*/	{0,	0,	12,2,0,0,	14,2,1,0},	// CMPM.W (An)+,(An)+
/*1433*/	{1,	2,	10,1,0,1,	13,1,1,1},	// EOR.W Dn,(An)
/*1434*/	{0,	2,	10,1,0,1,	13,1,1,1},	// EOR.W Dn,(An)+
/*1435*/	{2,	3,	11,1,0,1,	14,1,1,1},	// EOR.W Dn,-(An)
/*1436*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.W Dn,(d16,An)
/*1437*/	{4,	3,	13,1,0,1,	18,1,2,1},	// EOR.W Dn,(d8,An,Xn)
/*1438*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.W Dn,(xxx).W
/*1439*/	{1,	1,	11,1,0,1,	17,1,2,1},	// EOR.W Dn,(xxx).L
/*1440*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// EOR.L Dn,Dn
/*1441*/	{0,	0,	20,2,0,0,	24,2,1,0},	// CMPM.L (An)+,(An)+
/*1442*/	{1,	2,	18,1,0,1,	21,1,1,1},	// EOR.L Dn,(An)
/*1443*/	{0,	2,	18,1,0,1,	21,1,1,1},	// EOR.L Dn,(An)+
/*1444*/	{2,	3,	19,1,0,1,	22,1,1,1},	// EOR.L Dn,-(An)
/*1445*/	{2,	3,	19,1,0,1,	24,1,2,1},	// EOR.L Dn,(d16,An)
/*1446*/	{4,	3,	21,1,0,1,	26,1,2,1},	// EOR.L Dn,(d8,An,Xn)
/*1447*/	{2,	3,	19,1,0,1,	24,1,2,1},	// EOR.L Dn,(xxx).W
/*1448*/	{1,	1,	19,1,0,1,	25,1,2,1},	// EOR.L Dn,(xxx).L
/*1449*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.L Dn,An
/*1450*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.L An,An
/*1451*/	{1,	1,	13,1,0,0,	15,1,1,0},	// CMPA.L (An),An
/*1452*/	{0,	1,	13,1,0,0,	15,1,1,0},	// CMPA.L (An)+,An
/*1453*/	{2,	2,	14,1,0,0,	16,1,1,0},	// CMPA.L -(An),An
/*1454*/	{2,	2,	14,1,0,0,	18,1,2,0},	// CMPA.L (d16,An),An
/*1455*/	{4,	2,	16,1,0,0,	20,1,2,0},	// CMPA.L (d8,An,Xn),An
/*1456*/	{2,	2,	14,1,0,0,	18,1,2,0},	// CMPA.L (xxx).W,An
/*1457*/	{1,	0,	14,1,0,0,	19,1,2,0},	// CMPA.L (xxx).L,An
/*1458*/	{2,	2,	14,1,0,0,	18,1,2,0},	// CMPA.L (d16,PC),An
/*1459*/	{4,	2,	16,1,0,0,	20,1,2,0},	// CMPA.L (d8,PC,Xn),An
/*1460*/	{4,	0,	 8,0,0,0,	12,0,2,0},	// CMPA.L #<data>.L,An
/*1461*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// AND.B Dn,Dn
/*1462*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// AND.B (An),Dn
/*1463*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// AND.B (An)+,Dn
/*1464*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// AND.B -(An),Dn
/*1465*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// AND.B (d16,An),Dn
/*1466*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.B (d8,An,Xn),Dn
/*1467*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.B (xxx).W,Dn
/*1468*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// AND.B (xxx).L,Dn
/*1469*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.B (d16,PC),Dn
/*1470*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.B (d8,PC,Xn),Dn
/*1471*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// AND.B #<data>.B,Dn
/*1472*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// AND.W Dn,Dn
/*1473*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// AND.W (An),Dn
/*1474*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// AND.W (An)+,Dn
/*1475*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// AND.W -(An),Dn
/*1476*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// AND.W (d16,An),Dn
/*1477*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.W (d8,An,Xn),Dn
/*1478*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.W (xxx).W,Dn
/*1479*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// AND.W (xxx).L,Dn
/*1480*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.W (d16,PC),Dn
/*1481*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.W (d8,PC,Xn),Dn
/*1482*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// AND.W #<data>.W,Dn
/*1483*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// AND.L Dn,Dn
/*1484*/	{1,	1,	11,1,0,0,	13,1,1,0},	// AND.L (An),Dn
/*1485*/	{0,	1,	11,1,0,0,	13,1,1,0},	// AND.L (An)+,Dn
/*1486*/	{2,	2,	12,1,0,0,	14,1,1,0},	// AND.L -(An),Dn
/*1487*/	{2,	2,	12,1,0,0,	16,1,2,0},	// AND.L (d16,An),Dn
/*1488*/	{4,	2,	14,1,0,0,	18,1,2,0},	// AND.L (d8,An,Xn),Dn
/*1489*/	{2,	2,	12,1,0,0,	16,1,2,0},	// AND.L (xxx).W,Dn
/*1490*/	{1,	0,	12,1,0,0,	17,1,2,0},	// AND.L (xxx).L,Dn
/*1491*/	{2,	2,	12,1,0,0,	16,1,2,0},	// AND.L (d16,PC),Dn
/*1492*/	{4,	2,	14,1,0,0,	18,1,2,0},	// AND.L (d8,PC,Xn),Dn
/*1493*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// AND.L #<data>.L,Dn
/*1494*/	{2,	0,	28,0,0,0,	30,0,1,0},	// MULU.W Dn,Dn			(Max Value)
/*1495*/	{3,	1,	33,1,0,0,	35,1,1,0},	// MULU.W (An),Dn		(Max Value)
/*1496*/	{2,	1,	33,1,0,0,	35,1,1,0},	// MULU.W (An)+,Dn		(Max Value)
/*1497*/	{4,	2,	34,1,0,0,	36,1,1,0},	// MULU.W -(An),Dn		(Max Value)
/*1498*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULU.W (d16,An),Dn		(Max Value)
/*1499*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULU.W (d8,An,Xn),Dn		(Max Value)
/*1500*/	{4,	2,	34,1,0,0,	38,1,2,0},	// MULU.W (xxx).W,Dn		(Max Value)
/*1501*/	{3,	0,	34,1,0,0,	39,1,2,0},	// MULU.W (xxx).L,Dn		(Max Value)
/*1502*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULU.W (d16,PC),Dn		(Max Value)
/*1503*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULU.W (d8,PC,Xn),Dn		(Max Value)
/*1504*/	{4,	0,	30,0,0,0,	38,0,2,0},	// MULU.W #<data>.W,Dn		(Max Value)
/*1505*/	{0,	0,	 4,0,0,0,	 6,0,1,0},	// ABCD.B Dn,Dn
/*1506*/	{2,	1,	19,2,0,1,	22,2,1,1},	// ABCD.B -(An),-(An)
/*1507*/	{1,	2,	10,1,0,1,	13,1,1,1},	// AND.B Dn,(An)
/*1508*/	{0,	2,	10,1,0,1,	13,1,1,1},	// AND.B Dn,(An)+
/*1509*/	{2,	3,	11,1,0,1,	14,1,1,1},	// AND.B Dn,-(An)
/*1510*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.B Dn,(d16,An)
/*1511*/	{4,	3,	13,1,0,1,	18,1,2,1},	// AND.B Dn,(d8,An,Xn)
/*1512*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.B Dn,(xxx).W
/*1513*/	{1,	1,	11,1,0,1,	17,1,2,1},	// AND.B Dn,(xxx).L
/*1514*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXG.L Dn,Dn
/*1515*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXG.L An,An
/*1516*/	{1,	2,	10,1,0,1,	13,1,1,1},	// AND.W Dn,(An)
/*1517*/	{0,	2,	10,1,0,1,	13,1,1,1},	// AND.W Dn,(An)+
/*1518*/	{2,	3,	11,1,0,1,	14,1,1,1},	// AND.W Dn,-(An)
/*1519*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.W Dn,(d16,An)
/*1520*/	{4,	3,	13,1,0,1,	18,1,2,1},	// AND.W Dn,(d8,An,Xn)
/*1521*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.W Dn,(xxx).W
/*1522*/	{1,	1,	11,1,0,1,	17,1,2,1},	// AND.W Dn,(xxx).L
/*1523*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXG.L Dn,An
/*1524*/	{1,	2,	18,1,0,1,	21,1,1,1},	// AND.L Dn,(An)
/*1525*/	{0,	2,	18,1,0,1,	21,1,1,1},	// AND.L Dn,(An)+
/*1526*/	{2,	3,	19,1,0,1,	22,1,1,1},	// AND.L Dn,-(An)
/*1527*/	{2,	3,	19,1,0,1,	24,1,2,1},	// AND.L Dn,(d16,An)
/*1528*/	{4,	3,	21,1,0,1,	26,1,2,1},	// AND.L Dn,(d8,An,Xn)
/*1529*/	{2,	3,	19,1,0,1,	24,1,2,1},	// AND.L Dn,(xxx).W
/*1530*/	{1,	1,	19,1,0,1,	25,1,2,1},	// AND.L Dn,(xxx).L
/*1531*/	{2,	0,	28,0,0,0,	30,0,1,0},	// MULS.W Dn,Dn			(Max Value)
/*1532*/	{3,	1,	33,1,0,0,	35,1,1,0},	// MULS.W (An),Dn		(Max Value)
/*1533*/	{2,	1,	33,1,0,0,	35,1,1,0},	// MULS.W (An)+,Dn		(Max Value)
/*1534*/	{4,	2,	34,1,0,0,	36,1,1,0},	// MULS.W -(An),Dn		(Max Value)
/*1535*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULS.W (d16,An),Dn		(Max Value)
/*1536*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULS.W (d8,An,Xn),Dn		(Max Value)
/*1537*/	{4,	2,	34,1,0,0,	38,1,2,0},	// MULS.W (xxx).W,Dn		(Max Value)
/*1538*/	{3,	0,	34,1,0,0,	39,1,2,0},	// MULS.W (xxx).L,Dn		(Max Value)
/*1539*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULS.W (d16,PC),Dn		(Max Value)
/*1540*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULS.W (d8,PC,Xn),Dn		(Max Value)
/*1541*/	{4,	0,	30,0,0,0,	38,0,2,0},	// MULS.W #<data>.W,Dn		(Max Value)
/*1542*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.B Dn,Dn
/*1543*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.B (An),Dn
/*1544*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.B (An)+,Dn
/*1545*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// ADD.B -(An),Dn
/*1546*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// ADD.B (d16,An),Dn
/*1547*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.B (d8,An,Xn),Dn
/*1548*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.B (xxx).W,Dn
/*1549*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// ADD.B (xxx).L,Dn
/*1550*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.B (d16,PC),Dn
/*1551*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.B (d8,PC,Xn),Dn
/*1552*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// ADD.B #<data>.B,Dn
/*1553*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.W Dn,Dn
/*1554*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.W An,Dn
/*1555*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.W (An),Dn
/*1556*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.W (An)+,Dn
/*1557*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// ADD.W -(An),Dn
/*1558*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// ADD.W (d16,An),Dn
/*1559*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.W (d8,An,Xn),Dn
/*1560*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.W (xxx).W,Dn
/*1561*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// ADD.W (xxx).L,Dn
/*1562*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.W (d16,PC),Dn
/*1563*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.W (d8,PC,Xn),Dn
/*1564*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// ADD.W #<data>.W,Dn
/*1565*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.L Dn,Dn
/*1566*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.L An,Dn
/*1567*/	{1,	1,	11,1,0,0,	13,1,1,0},	// ADD.L (An),Dn
/*1568*/	{0,	1,	11,1,0,0,	13,1,1,0},	// ADD.L (An)+,Dn
/*1569*/	{2,	2,	12,1,0,0,	14,1,1,0},	// ADD.L -(An),Dn
/*1570*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADD.L (d16,An),Dn
/*1571*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADD.L (d8,An,Xn),Dn
/*1572*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADD.L (xxx).W,Dn
/*1573*/	{1,	0,	12,1,0,0,	17,1,2,0},	// ADD.L (xxx).L,Dn
/*1574*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADD.L (d16,PC),Dn
/*1575*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADD.L (d8,PC,Xn),Dn
/*1576*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// ADD.L #<data>.L,Dn
/*1577*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ADDA.W Dn,An
/*1578*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ADDA.W An,An
/*1579*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// ADDA.W (An),An
/*1580*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// ADDA.W (An)+,An
/*1581*/	{2,	2,	10,1,0,0,	12,1,1,0},	// ADDA.W -(An),An
/*1582*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ADDA.W (d16,An),An
/*1583*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ADDA.W (d8,An,Xn),An
/*1584*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ADDA.W (xxx).W,An
/*1585*/	{1,	0,	10,1,0,0,	15,1,2,0},	// ADDA.W (xxx).L,An
/*1586*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ADDA.W (d16,PC),An
/*1587*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ADDA.W (d8,PC,Xn),An
/*1588*/	{2,	0,	 6,0,0,0,	10,0,2,0},	// ADDA.W #<data>.W,An
/*1589*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDX.B Dn,Dn
/*1590*/	{2,	1,	15,2,0,1,	18,2,1,1},	// ADDX.B -(An),-(An)
/*1591*/	{1,	2,	10,1,0,1,	13,1,1,1},	// ADD.B Dn,(An)
/*1592*/	{0,	2,	10,1,0,1,	13,1,1,1},	// ADD.B Dn,(An)+
/*1593*/	{2,	3,	11,1,0,1,	14,1,1,1},	// ADD.B Dn,-(An)
/*1594*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.B Dn,(d16,An)
/*1595*/	{4,	3,	13,1,0,1,	18,1,2,1},	// ADD.B Dn,(d8,An,Xn)
/*1596*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.B Dn,(xxx).W
/*1597*/	{1,	1,	11,1,0,1,	17,1,2,1},	// ADD.B Dn,(xxx).L
/*1598*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDX.W Dn,Dn
/*1599*/	{2,	1,	15,2,0,1,	18,2,1,1},	// ADDX.W -(An),-(An)
/*1600*/	{1,	2,	10,1,0,1,	13,1,1,1},	// ADD.W Dn,(An)
/*1601*/	{0,	2,	10,1,0,1,	13,1,1,1},	// ADD.W Dn,(An)+
/*1602*/	{2,	3,	11,1,0,1,	14,1,1,1},	// ADD.W Dn,-(An)
/*1603*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.W Dn,(d16,An)
/*1604*/	{4,	3,	13,1,0,1,	18,1,2,1},	// ADD.W Dn,(d8,An,Xn)
/*1605*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.W Dn,(xxx).W
/*1606*/	{1,	1,	11,1,0,1,	17,1,2,1},	// ADD.W Dn,(xxx).L
/*1607*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDX.L Dn,Dn
/*1608*/	{2,	1,	27,2,0,1,	30,2,1,1},	// ADDX.L -(An),-(An)
/*1609*/	{1,	2,	18,1,0,1,	21,1,1,1},	// ADD.L Dn,(An)
/*1610*/	{0,	2,	18,1,0,1,	21,1,1,1},	// ADD.L Dn,(An)+
/*1611*/	{2,	3,	19,1,0,1,	22,1,1,1},	// ADD.L Dn,-(An)
/*1612*/	{2,	3,	19,1,0,1,	24,1,2,1},	// ADD.L Dn,(d16,An)
/*1613*/	{4,	3,	21,1,0,1,	26,1,2,1},	// ADD.L Dn,(d8,An,Xn)
/*1614*/	{2,	3,	19,1,0,1,	24,1,2,1},	// ADD.L Dn,(xxx).W
/*1615*/	{1,	1,	19,1,0,1,	25,1,2,1},	// ADD.L Dn,(xxx).L
/*1616*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDA.L Dn,An
/*1617*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDA.L An,An
/*1618*/	{1,	1,	11,1,0,0,	13,1,1,0},	// ADDA.L (An),An
/*1619*/	{0,	1,	11,1,0,0,	13,1,1,0},	// ADDA.L (An)+,An
/*1620*/	{2,	2,	12,1,0,0,	14,1,1,0},	// ADDA.L -(An),An
/*1621*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADDA.L (d16,An),An
/*1622*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADDA.L (d8,An,Xn),An
/*1623*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADDA.L (xxx).W,An
/*1624*/	{1,	0,	12,1,0,0,	17,1,2,0},	// ADDA.L (xxx).L,An
/*1625*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADDA.L (d16,PC),An
/*1626*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADDA.L (d8,PC,Xn),An
/*1627*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// ADDA.L #<data>.L,An
/*1628*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ASRQ.B #<data>,Dn
/*1629*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSRQ.B #<data>,Dn
/*1630*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXRQ.B #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1631*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// RORQ.B #<data>,Dn
/*1632*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// ASR.B Dn,Dn		(See ASR table below)
/*1633*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSR.B Dn,Dn		(See LSD table below)
/*1634*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXR.B Dn,Dn
/*1635*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROR.B Dn,Dn
/*1636*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ASRQ.W #<data>,Dn
/*1637*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSRQ.W #<data>,Dn
/*1638*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXRQ.W #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1639*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// RORQ.W #<data>,Dn
/*1640*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// ASR.W Dn,Dn		(See ASR table below)
/*1641*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSR.W Dn,Dn		(See LSD table below)
/*1642*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXR.W Dn,Dn
/*1643*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROR.W Dn,Dn
/*1644*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ASRQ.L #<data>,Dn
/*1645*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSRQ.L #<data>,Dn
/*1646*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXRQ.L #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1647*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// RORQ.L #<data>,Dn
/*1648*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// ASR.L Dn,Dn		(See ASR table below)
/*1649*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSR.L Dn,Dn		(See LSD table below)
/*1650*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXR.L Dn,Dn
/*1651*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROR.L Dn,Dn
/*1652*/	{1,	1,	11,1,0,1,	13,1,1,1},	// ASRW.W (An)
/*1653*/	{0,	1,	11,1,0,1,	13,1,1,1},	// ASRW.W (An)+
/*1654*/	{2,	2,	12,1,0,1,	14,1,1,1},	// ASRW.W -(An)
/*1655*/	{2,	2,	12,1,0,1,	16,1,2,1},	// ASRW.W (d16,An)
/*1656*/	{4,	2,	14,1,0,1,	18,1,2,1},	// ASRW.W (d8,An,Xn)
/*1657*/	{2,	2,	12,1,0,1,	16,1,2,1},	// ASRW.W (xxx).W
/*1658*/	{1,	0,	12,1,0,1,	17,1,2,1},	// ASRW.W (xxx).L
/*1659*/	{2,	0,	 6,0,0,0,	 8,0,1,0},	// ASLQ.B #<data>,Dn
/*1660*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSLQ.B #<data>,Dn
/*1661*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXLQ.B #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1662*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// ROLQ.B #<data>,Dn
/*1663*/	{4,	0,	 8,0,0,0,	10,0,1,0},	// ASL.B Dn,Dn
/*1664*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSL.B Dn,Dn		(See LSD table below)
/*1665*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXL.B Dn,Dn
/*1666*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROL.B Dn,Dn
/*1667*/	{2,	0,	 6,0,0,0,	 8,0,1,0},	// ASLQ.W #<data>,Dn
/*1668*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSLQ.W #<data>,Dn
/*1669*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXLQ.W #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1670*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// ROLQ.W #<data>,Dn
/*1671*/	{4,	0,	 8,0,0,0,	10,0,1,0},	// ASL.W Dn,Dn
/*1672*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSL.W Dn,Dn		(See LSD table below)
/*1673*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXL.W Dn,Dn
/*1674*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROL.W Dn,Dn
/*1675*/	{2,	0,	 6,0,0,0,	 8,0,1,0},	// ASLQ.L #<data>,Dn
/*1676*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSLQ.L #<data>,Dn
/*1677*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXLQ.L #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1678*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// ROLQ.L #<data>,Dn
/*1679*/	{4,	0,	 8,0,0,0,	10,0,1,0},	// ASL.L Dn,Dn
/*1680*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSL.L Dn,Dn		(See LSD table below)
/*1681*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXL.L Dn,Dn
/*1682*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROL.L Dn,Dn
/*1683*/	{1,	1,	13,1,0,1,	15,1,1,1},	// ASLW.W (An)
/*1684*/	{0,	1,	13,1,0,1,	15,1,1,1},	// ASLW.W (An)+
/*1685*/	{2,	2,	14,1,0,1,	16,1,1,1},	// ASLW.W -(An)
/*1686*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ASLW.W (d16,An)
/*1687*/	{4,	2,	16,1,0,1,	20,1,2,1},	// ASLW.W (d8,An,Xn)
/*1688*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ASLW.W (xxx).W
/*1689*/	{1,	0,	14,1,0,1,	19,1,2,1},	// ASLW.W (xxx).L
/*1690*/	{1,	1,	11,1,0,1,	13,1,1,1},	// LSRW.W (An)
/*1691*/	{0,	1,	11,1,0,1,	13,1,1,1},	// LSRW.W (An)+
/*1692*/	{2,	2,	12,1,0,1,	14,1,1,1},	// LSRW.W -(An)
/*1693*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSRW.W (d16,An)
/*1694*/	{4,	2,	14,1,0,1,	18,1,2,1},	// LSRW.W (d8,An,Xn)
/*1695*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSRW.W (xxx).W
/*1696*/	{1,	0,	12,1,0,1,	17,1,2,1},	// LSRW.W (xxx).L
/*1697*/	{1,	1,	11,1,0,1,	13,1,1,1},	// LSLW.W (An)
/*1698*/	{0,	1,	11,1,0,1,	13,1,1,1},	// LSLW.W (An)+
/*1699*/	{2,	2,	12,1,0,1,	14,1,1,1},	// LSLW.W -(An)
/*1700*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSLW.W (d16,An)
/*1701*/	{4,	2,	14,1,0,1,	18,1,2,1},	// LSLW.W (d8,An,Xn)
/*1702*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSLW.W (xxx).W
/*1703*/	{1,	0,	12,1,0,1,	17,1,2,1},	// LSLW.W (xxx).L
/*1704*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// ROXRW.W (An)
/*1705*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// ROXRW.W (An)+
/*1706*/	{2,	2,	10,1,0,0,	12,1,1,0},	// ROXRW.W -(An)
/*1707*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXRW.W (d16,An)
/*1708*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ROXRW.W (d8,An,Xn)
/*1709*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXRW.W (xxx).W
/*1710*/	{1,	0,	10,1,0,0,	15,1,2,0},	// ROXRW.W (xxx).L
/*1711*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// ROXLW.W (An)
/*1712*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// ROXLW.W (An)+
/*1713*/	{2,	2,	10,1,0,0,	12,1,1,0},	// ROXLW.W -(An)
/*1714*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXLW.W (d16,An)
/*1715*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ROXLW.W (d8,An,Xn)
/*1716*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXLW.W (xxx).W
/*1717*/	{1,	0,	10,1,0,0,	15,1,2,0},	// ROXLW.W (xxx).L
/*1718*/	{1,	1,	13,1,0,1,	15,1,1,1},	// RORW.W (An)
/*1719*/	{0,	1,	13,1,0,1,	15,1,1,1},	// RORW.W (An)+
/*1720*/	{2,	2,	14,1,0,1,	16,1,1,1},	// RORW.W -(An)
/*1721*/	{2,	2,	14,1,0,1,	18,1,2,1},	// RORW.W (d16,An)
/*1722*/	{4,	2,	16,1,0,1,	20,1,2,1},	// RORW.W (d8,An,Xn)
/*1723*/	{2,	2,	14,1,0,1,	18,1,2,1},	// RORW.W (xxx).W
/*1724*/	{1,	0,	14,1,0,1,	19,1,2,1},	// RORW.W (xxx).L
/*1725*/	{1,	1,	13,1,0,1,	15,1,1,1},	// ROLW.W (An)
/*1726*/	{0,	1,	13,1,0,1,	15,1,1,1},	// ROLW.W (An)+
/*1727*/	{2,	2,	14,1,0,1,	16,1,1,1},	// ROLW.W -(An)
/*1728*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ROLW.W (d16,An)
/*1729*/	{4,	2,	16,1,0,1,	20,1,2,1},	// ROLW.W (d8,An,Xn)
/*1730*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ROLW.W (xxx).W
/*1731*/	{1,	0,	14,1,0,1,	19,1,2,1},	// ROLW.W (xxx).L
/*1732*/	{8,	0,	 8,0,0,0,	10,0,1,0},	// BFTST.L #<data>.W,Dn
/*1733*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(An)		(See BFTST table below)
/*1734*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d16,An)		(See BFTST table below)
/*1735*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d8,An,Xn)		(See BFTST table below)
/*1736*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(xxx).W		(See BFTST table below)
/*1737*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(xxx).L		(See BFTST table below)
/*1738*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d16,PC)		(See BFTST table below)
/*1739*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d8,PC,Xn)		(See BFTST table below)
/*1740*/	{10,	0,	10,0,0,0,	12,0,1,0},	// BFEXTU.L #<data>.W,Dn
/*1741*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(An)		(See BFEXTU table below)
/*1742*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d16,An)		(See BFEXTU table below)
/*1743*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d8,An,Xn)	(See BFEXTU table below)
/*1744*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(xxx).W		(See BFEXTU table below)
/*1745*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(xxx).L		(See BFEXTU table below)
/*1746*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d16,PC)		(See BFEXTU table below)
/*1747*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d8,PC,Xn)	(See BFEXTU table below)
/*1748*/	{14,	0,	14,0,0,0,	16,0,1,0},	// BFCHG.L #<data>.W,Dn
/*1749*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(An)		(See BFCHG table below)
/*1750*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(d16,An)		(See BFCHG table below)
/*1751*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(d8,An,Xn)		(See BFCHG table below)
/*1752*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(xxx).W		(See BFCHG table below)
/*1753*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(xxx).L		(See BFCHG table below)
/*1754*/	{10,	0,	10,0,0,0,	12,0,1,0},	// BFEXTS.L #<data>.W,Dn
/*1755*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(An)		(See BFEXTS table below)
/*1756*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d16,An)		(See BFEXTS table below)
/*1757*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d8,An,Xn)	(See BFEXTS table below)
/*1758*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(xxx).W		(See BFEXTS table below)
/*1759*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(xxx).L		(See BFEXTS table below)
/*1760*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d16,PC)		(See BFEXTS table below)
/*1761*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d8,PC,Xn)	(See BFEXTS table below)
/*1762*/	{14,	0,	14,0,0,0,	16,0,1,0},	// BFCLR.L #<data>.W,Dn
/*1763*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(An)		(See BFCLR table below)
/*1764*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(d16,An)		(See BFEXTS table below)
/*1765*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(d8,An,Xn)		(See BFEXTS table below)
/*1766*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(xxx).W		(See BFEXTS table below)
/*1767*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(xxx).L		(See BFEXTS table below)
/*1768*/	{20,	0,	20,0,0,0,	22,0,1,0},	// BFFFO.L #<data>.W,Dn
/*1769*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(An)		(See BFFFO table below)
/*1770*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d16,An)		(See BFFFO table below)
/*1771*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d8,An,Xn)		(See BFFFO table below)
/*1772*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(xxx).W		(See BFFFO table below)
/*1773*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(xxx).L		(See BFFFO table below)
/*1774*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d16,PC)		(See BFFFO table below)
/*1775*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d8,PC,Xn)		(See BFFFO table below)
/*1776*/	{14,	0,	14,0,0,0,	16,0,1,0},	// BFSET.L #<data>.W,Dn
/*1777*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(An)		(See BFSET table below)
/*1778*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(d16,An)		(See BFSET table below)
/*1779*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(d8,An,Xn)		(See BFSET table below)
/*1780*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(xxx).W		(See BFSET table below)
/*1781*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(xxx).L		(See BFSET table below)
/*1782*/	{12,	0,	12,0,0,0,	14,0,1,0},	// BFINS.L #<data>.W,Dn
/*1783*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(An)		(See BFINS table below)
/*1784*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(d16,An)		(See BFINS table below)
/*1785*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(d8,An,Xn)		(See BFINS table below)
/*1786*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(xxx).W		(See BFINS table below)
/*1787*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(xxx).L		(See BFINS table below)
/*1788*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L Dn,#<data>.W
/*1789*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L An,#<data>.W
/*1790*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (An),#<data>.W
/*1791*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (d16,An),#<data>.W
/*1792*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (d8,An,Xn),#<data>.W
/*1793*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (xxx).W,#<data>.W
/*1794*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (xxx).L,#<data>.W
/*1795*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,Dn
/*1796*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,An
/*1797*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(An)
/*1798*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(An)+
/*1799*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,-(An)
/*1800*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d16,An)
/*1801*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d8,An,Xn)
/*1802*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(xxx).W
/*1803*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(xxx).L
/*1804*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d16,PC)
/*1805*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d8,PC,Xn)
/*1806*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,#<data>.L
/*1807*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,Dn
/*1808*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FDBcc.L #<data>.W,Dn
/*1809*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(An)
/*1810*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(An)+
/*1811*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,-(An)
/*1812*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(d16,An)
/*1813*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(d8,An,Xn)
/*1814*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(xxx).W
/*1815*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(xxx).L
/*1816*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FTRAPcc.L #<data>.W
/*1817*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FTRAPcc.L #<data>.L
/*1818*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FTRAPcc.L 
/*1819*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FBccQ.L #<data>,#<data>.W
/*1820*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FBccQ.L #<data>,#<data>.L
/*1821*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (An)
/*1822*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L -(An)
/*1823*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (d16,An)
/*1824*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (d8,An,Xn)
/*1825*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (xxx).W
/*1826*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (xxx).L
/*1827*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (An)
/*1828*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (An)+
/*1829*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d16,An)
/*1830*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d8,An,Xn)
/*1831*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (xxx).W
/*1832*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (xxx).L
/*1833*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d16,PC)
/*1834*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d8,PC,Xn)
/*1835*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVLQ.L #<data>,An
/*1836*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVPQ.L #<data>,An
/*1837*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1838*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1839*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1840*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1841*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1842*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1843*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1844*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1845*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHLQ.L #<data>,An
/*1846*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHPQ.L #<data>,An
/*1847*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1848*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1849*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1850*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1851*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1852*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1853*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1854*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1855*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSHN.L (An)
/*1856*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSH.L (An)
/*1857*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSHAN.L (An)
/*1858*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSHA.L (An)
/*1859*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PTESTR.L (An)
/*1860*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PTESTW.L (An)
/*1861*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (An)+,(xxx).L
/*1862*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (xxx).L,(An)+
/*1863*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (An),(xxx).L
/*1864*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (xxx).L,(An)
/*1865*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (An)+,(An)+
};


/** 
  Cycles table for CHK2.BW instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK2_BW [] = {
	{3,	1,	25,2,0,0,	30,2,2,0}, {3,	1,	57,3,0,4,	68,3,4,4},	// CHK2.BW #<data>.W,(An)
	{4,	0,	26,2,0,0,	31,2,2,0}, {4,	0,	58,3,0,4,	69,3,4,4},	// CHK2.BW #<data>.W,(d16,An)
	{8,	2,	30,2,0,0,	36,2,3,0}, {8,	2,	62,3,0,4,	74,3,5,4},	// CHK2.BW #<data>.W,(d8,An,Xn)
	{6,	2,	28,2,0,0,	32,2,2,0}, {6,	2,	60,3,0,4,	70,3,4,4},	// CHK2.BW #<data>.W,(xxx).W
	{5,	0,	28,2,0,0,	35,2,3,0}, {5,	0,	60,3,0,4,	73,3,5,4},	// CHK2.BW #<data>.W,(xxx).L
	{4,	0,	26,2,0,0,	31,2,2,0}, {4,	0,	58,3,0,4,	69,3,4,4},	// CHK2.BW #<data>.W,(d16,PC)
	{8,	2,	30,2,0,0,	36,2,3,0}, {8,	2,	62,3,0,4,	74,3,5,4}	// CHK2.BW #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for CHK2.L instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK2_L [] = {
	{3,	0,	34,2,0,0,	39,2,2,0}, {3,	0,	86,3,0,4,	97,3,4,4},	// CHK2.L #<data>.W,(An)
	{6,	0,	36,2,0,0,	44,2,3,0}, {6,	0,	88,3,0,4,	102,3,5,4},	// CHK2.L #<data>.W,(d16,An)
	{10,	2,	40,2,0,0,	46,2,3,0}, {10,	2,	92,3,0,4,	104,3,5,4},	// CHK2.L #<data>.W,(d8,An,Xn)
	{8,	2,	38,2,0,0,	44,2,3,0}, {8,	2,	90,3,0,4,	102,3,5,4},	// CHK2.L #<data>.W,(xxx).W
	{7,	0,	38,2,0,0,	45,2,3,0}, {7,	0,	90,3,0,4,	103,3,5,4},	// CHK2.L #<data>.W,(xxx).L
	{6,	0,	36,2,0,0,	44,2,3,0}, {6,	0,	88,3,0,4,	102,3,5,4},	// CHK2.L #<data>.W,(d16,PC)
	{10,	2,	40,2,0,0,	46,2,3,0}, {10,	2,	92,3,0,4,	104,3,5,4}	// CHK2.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for CHK.L instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK_L [] = {
	{8,	0,	 8,0,0,0,	10,0,1,0},	{4,	0,	58,1,0,4,	66,1,3,4},// CHK.L Dn,Dn
	{1,	1,	17,1,0,0,	19,1,1,0},	{1,	1,	67,2,0,4,	75,2,3,4},// CHK.L (An),Dn
	{0,	1,	17,1,0,0,	19,1,1,0},	{0,	1,	67,2,0,4,	75,2,3,4},// CHK.L (An)+,Dn
	{2,	2,	18,1,0,0,	20,1,1,0},	{2,	2,	68,2,0,4,	76,2,3,4},// CHK.L -(An),Dn
	{2,	2,	18,1,0,0,	22,1,2,0},	{2,	2,	68,2,0,4,	78,2,4,4},// CHK.L (d16,An),Dn
	{4,	2,	20,1,0,0,	24,1,2,0},	{4,	2,	70,2,0,4,	80,2,4,4},// CHK.L (d8,An,Xn),Dn
	{2,	2,	18,1,0,0,	22,1,2,0},	{2,	2,	68,2,0,4,	78,2,4,4},// CHK.L (xxx).W,Dn
	{1,	0,	18,1,0,0,	23,1,2,0},	{1,	0,	68,2,0,4,	79,2,4,4},// CHK.L (xxx).L,Dn
	{2,	2,	18,1,0,0,	22,1,2,0},	{2,	2,	68,2,0,4,	78,2,4,4},// CHK.L (d16,PC),Dn
	{4,	2,	20,1,0,0,	24,1,2,0},	{4,	2,	70,2,0,4,	80,2,4,4},// CHK.L (d8,PC,Xn),Dn
	{4,	0,	12,0,0,0,	16,0,2,0},	{4,	0,	62,1,0,4,	72,1,4,4} // CHK.L #<data>.L,Dn
};

/** 
  Cycles table for CHK.W  instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK_W [] = {
	{8,	0,	 8,0,0,0,	10,0,1,0},	{4,	0,	38,1,0,4,	46,1,3,4},// CHK.W Dn,Dn
	{1,	1,	13,1,0,0,	15,1,1,0},	{1,	1,	43,2,0,4,	51,2,3,4},// CHK.W (An),Dn
	{0,	1,	13,1,0,0,	15,1,1,0},	{0,	1,	43,2,0,4,	51,2,3,4},// CHK.W (An)+,Dn
	{2,	2,	14,1,0,0,	16,1,1,0},	{2,	2,	44,2,0,4,	52,2,3,4},// CHK.W -(An),Dn
	{2,	2,	14,1,0,0,	18,1,2,0},	{2,	2,	44,2,0,4,	54,2,4,4},// CHK.W (d16,An),Dn
	{4,	2,	16,1,0,0,	20,1,2,0},	{4,	2,	46,2,0,4,	56,2,4,4},// CHK.W (d8,An,Xn),Dn
	{2,	2,	14,1,0,0,	18,1,2,0},	{2,	2,	44,2,0,4,	54,2,4,4},// CHK.W (xxx).W,Dn
	{1,	0,	14,1,0,0,	19,1,2,0},	{1,	0,	44,2,0,4,	55,2,4,4},// CHK.W (xxx).L,Dn
	{2,	2,	14,1,0,0,	18,1,2,0},	{2,	2,	44,2,0,4,	54,2,4,4},// CHK.W (d16,PC),Dn
	{4,	2,	16,1,0,0,	20,1,2,0},	{4,	2,	46,2,0,4,	56,2,4,4},// CHK.W (d8,PC,Xn),Dn
	{2,	0,	10,0,0,0,	14,0,2,0},	{2,	0,	40,1,0,4,	50,1,4,4} // CHK.W #<data>.W,Dn
};

/** 
  Cycles table for CAS.BW  instruction. 
  First column is for successful compare case, 2nd column is for unsuccessful compare case
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS_BW [] = {
	{4,	0,	19,1,0,1,	23,1,2,1}, {4,	0,	15,1,0,0,	19,1,2,0},	// CAS.BW #<data>.W,(An)
	{3,	0,	21,1,0,1,	25,1,2,1}, {3,	0,	17,1,0,0,	21,1,2,0},	// CAS.BW #<data>.W,(An)+
	{4,	0,	19,1,0,1,	23,1,2,1}, {4,	0,	15,1,0,0,	19,1,2,0},	// CAS.BW #<data>.W,-(An)
	{6,	0,	21,1,0,1,	25,1,2,1}, {6,	0,	17,1,0,0,	21,1,2,0},	// CAS.BW #<data>.W,(d16,An)
	{8,	0,	23,1,0,1,	29,1,3,1}, {8,	0,	19,1,0,0,	25,1,3,0},	// CAS.BW #<data>.W,(d8,An,Xn)
	{6,	0,	21,1,0,1,	25,1,2,1}, {6,	0,	17,1,0,0,	21,1,2,0},	// CAS.BW #<data>.W,(xxx).W
	{8,	0,	23,1,0,1,	29,1,3,1}, {8,	0,	19,1,0,0,	25,1,3,0}	// CAS.BW #<data>.W,(xxx).L
};

/** 
  Cycles table for CAS.L  instruction. 
  First column is for successful compare case, 2nd column is for unsuccessful compare case
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS_L [] = {
	{6,	0,	29,1,0,1,	33,1,2,1}, {6,	0,	21,1,0,0,	25,1,2,0},	// CAS.L #<data>.W,(An)
	{5,	0,	31,1,0,1,	35,1,2,1}, {5,	0,	23,1,0,0,	27,1,2,0},	// CAS.L #<data>.W,(An)+
	{6,	0,	29,1,0,1,	33,1,2,1}, {6,	0,	21,1,0,0,	25,1,2,0},	// CAS.L #<data>.W,-(An)
	{8,	0,	31,1,0,1,	38,1,3,1}, {8,	0,	23,1,0,0,	30,1,3,0},	// CAS.L #<data>.W,(d16,An)
	{10,	0,	33,1,0,1,	39,1,3,1}, {10,	0,	25,1,0,0,	31,1,3,0},	// CAS.L #<data>.W,(d8,An,Xn)
	{8,	0,	31,1,0,1,	37,1,3,1}, {8,	0,	23,1,0,0,	29,1,3,0},	// CAS.L #<data>.W,(xxx).W
	{10,	0,	33,1,0,1,	39,1,3,1}, {10,	0,	25,1,0,0,	31,1,3,0}	// CAS.L #<data>.W,(xxx).L
};

/** 
  Cycles table for CAS2.W  instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS2_W [] = {
	{2,	0,	32,2,0,2,	38,2,2,2},	// CAS2.W #<data>.L (successful compare)
	{2,	0,	28,2,0,0,	32,2,2,0}	// CAS2.W #<data>.L (unsuccessful compare)
};

/** 
  Cycles table for CAS2.L  instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS2_L [] = {
	{2,	0,	48,2,0,2,	54,2,2,2},	// CAS2.L #<data>.L (successful compare)
	{2,	0,	36,2,0,0,	40,2,2,0}	// CAS2.L #<data>.L (unsuccessful compare)
};

/** 
  Cycles table for RTE  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_RTE [] = {
	{1,	0,	26,4,0,0,	32,4,2,0},	// RTE.L (Normal four Word)
	{1,	0,	26,4,0,0,	32,4,2,0},	// RTE.L (six Word)
	{1,	0,	20,4,0,0,	20,4,0,0},	// RTE.L (throwaway)
	{1,	0,	40,7,0,0,	44,7,2,0},	// RTE.L (coprocessor)
	{1,	0,	56,10,0,0,	60,10,2,0},	// RTE.L (short fault)
	{1,	0,	126,25,0,0,	120,25,2,0}	// RTE.L (long fault)
};

/** 
  Cycles table for Bcc  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_Bcc [] = {
	{6,	0,	 6,0,0,0,	12,0,2,0},	// Bcc (taken)
	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Bcc.B (not taken)
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// Bcc.W (not taken)
	{6,	0,	 6,0,0,0,	12,0,2,0}	// Bcc.L (not taken)
};

/** 
  Cycles table for DBcc  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_DBcc [] = {
	{6,	0,	 6,0,0,0,	12,0,2,0},	// DBcc (cc = false, count not expired)
	{10,	0,	10,0,0,0,	19,0,3,0},	// DBcc (cc = false, count expired)
	{6,	0,	 6,0,0,0,	10,0,1,0}	// DBcc (cc = true)
};

/** 
  Cycles table for TRAPcc  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPcc [] = {
	{2,	0,	34,1,0,5,	40,1,2,5},	// TRAPcc (trap)
	{4,	0,	 4,0,0,0,	 6,0,1,0}	// TRAPcc (no trap)
};

/** 
  Cycles table for TRAPcc.W  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPcc_W [] = {
	{5,	0,	36,1,0,5,	44,1,3,5},	// TRAPcc.W (trap)
	{6,	0,	 6,0,0,0,	 8,0,1,0}	// TRAPcc.W (no trap)
};

/** 
  Cycles table for TRAPcc.L  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPcc_L [] = {
	{6,	0,	62,1,0,5,	70,1,3,5},	// TRAPcc.L (trap)
	{8,	0,	 8,0,0,0,	12,0,2,0}	// TRAPcc.L (no trap)
};

/** 
  Cycles table for TRAPV  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPV [] = {
	{2,	0,	34,1,0,5,	40,1,2,5},	// TRAPV (trap)
	{4,	0,	 4,0,0,0,	 6,0,1,0}	// TRAPV (no trap)
};

/** 
  Cycles table for DIVU.L instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_DIVU_L [] = {
	{14,	0,	82,0,0,0,	86,0,2,0},	// DIVU.L #<data>.W,Dn
	{1,	0,	88,1,0,0,	93,1,2,0},	// DIVU.L #<data>.W,(An)
	{4,	1,	91,1,0,0,	95,1,2,0},	// DIVU.L #<data>.W,(An)+
	{2,	0,	88,1,0,0,	93,1,2,0},	// DIVU.L #<data>.W,-(An)
	{4,	0,	90,1,0,0,	98,1,3,0},	// DIVU.L #<data>.W,(d16,An)
	{8,	2,	94,1,0,0,	100,1,3,0},	// DIVU.L #<data>.W,(d8,An,Xn)
	{6,	2,	92,1,0,0,	99,1,3,0},	// DIVU.L #<data>.W,(xxx).W
	{5,	0,	92,1,0,0,	98,1,3,0},	// DIVU.L #<data>.W,(xxx).L
	{4,	0,	90,1,0,0,	98,1,3,0},	// DIVU.L #<data>.W,(d16,PC)
	{8,	2,	94,1,0,0,	100,1,3,0},	// DIVU.L #<data>.W,(d8,PC,Xn)
	{6,	0,	84,0,0,0,	90,0,3,0}	// DIVU.L #<data>.W,#<data>.L
};

/** 
  Cycles table for DIVS.L instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_DIVS_L [] = {
	{16,	0,	94,0,0,0,	98,0,2,0},	// DIVS.L #<data>.W,Dn
	{1,	0,	100,1,0,0,	105,1,2,0},	// DIVS.L #<data>.W,(An)
	{4,	1,	103,1,0,0,	107,1,2,0},	// DIVS.L #<data>.W,(An)+
	{2,	0,	100,1,0,0,	105,1,2,0},	// DIVS.L #<data>.W,-(An)
	{4,	0,	102,1,0,0,	110,1,3,0},	// DIVS.L #<data>.W,(d16,An)
	{8,	2,	106,1,0,0,	112,1,3,0},	// DIVS.L #<data>.W,(d8,An,Xn)
	{6,	2,	104,1,0,0,	110,1,3,0},	// DIVS.L #<data>.W,(xxx).W
	{5,	0,	104,1,0,0,	111,1,3,0},	// DIVS.L #<data>.W,(xxx).L
	{4,	0,	102,1,0,0,	110,1,3,0},	// DIVS.L #<data>.W,(d16,PC)
	{8,	2,	106,1,0,0,	112,1,3,0},	// DIVS.L #<data>.W,(d8,PC,Xn)
	{6,	0,	96,0,0,0,	102,0,3,0}	// DIVS.L #<data>.W,#<data>.L
};

/** 
  Cycles table for BFTST Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFTST_Mem [] = {
	{14,	0,	14,1,0,0,	18,1,2,0},	{14,	0,	20,2,0,0,	24,2,2,0},	// BFTST.L #<data>.W,(An)
	{16,	0,	16,1,0,0,	20,1,2,0},	{16,	0,	22,2,0,0,	26,2,2,0},	// BFTST.L #<data>.W,(d16,An)
	{18,	0,	18,1,0,0,	24,1,3,0},	{18,	0,	24,2,0,0,	30,2,3,0},	// BFTST.L #<data>.W,(d8,An,Xn)
	{16,	0,	16,1,0,0,	20,1,2,0},	{16,	0,	22,2,0,0,	26,2,2,0},	// BFTST.L #<data>.W,(xxx).W
	{18,	0,	18,1,0,0,	24,1,3,0},	{18,	0,	24,2,0,0,	30,2,3,0},	// BFTST.L #<data>.W,(xxx).L
	{16,	0,	16,1,0,0,	20,1,2,0},	{16,	0,	22,2,0,0,	26,2,2,0},	// BFTST.L #<data>.W,(d16,PC)
	{18,	0,	18,1,0,0,	24,1,3,0},	{18,	0,	24,2,0,0,	30,2,3,0}	// BFTST.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for BFEXTU Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFEXTU_Mem [] = {
	{14,	0,	16,1,0,0,	20,1,2,0},	{14,	0,	24,2,0,0,	28,2,2,0},	// BFEXTU.L #<data>.W,(An)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTU.L #<data>.W,(d16,An)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTU.L #<data>.W,(d8,An,Xn)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTU.L #<data>.W,(xxx).W
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTU.L #<data>.W,(xxx).L
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTU.L #<data>.W,(d16,PC)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0}	// BFEXTU.L #<data>.W,(d8,PC,Xn)
};
	
/** 
  Cycles table for BFCHG Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFCHG_Mem [] = {
	{14,	0,	20,1,0,1,	24,1,2,1},	{14,	0,	32,2,0,2,	36,2,2,2},	// BFCHG.L #<data>.W,(An)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCHG.L #<data>.W,(d16,An)
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2},	// BFCHG.L #<data>.W,(d8,An,Xn)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCHG.L #<data>.W,(xxx).W
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2}	// BFCHG.L #<data>.W,(xxx).L
};
	
/** 
  Cycles table for BFEXTS Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFEXTS_Mem [] = {
	{14,	0,	16,1,0,0,	20,1,2,0},	{14,	0,	24,2,0,0,	28,2,2,0},	// BFEXTS.L #<data>.W,(An)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTS.L #<data>.W,(d16,An)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTS.L #<data>.W,(d8,An,Xn)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTS.L #<data>.W,(xxx).W
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTS.L #<data>.W,(xxx).L
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTS.L #<data>.W,(d16,PC)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0}	// BFEXTS.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for BFCLR Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFCLR_Mem [] = {
	{14,	0,	20,1,0,1,	24,1,2,1},	{14,	0,	32,2,0,2,	36,2,2,2},	// BFCLR.L #<data>.W,(An)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCLR.L #<data>.W,(d16,An)
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2},	// BFCLR.L #<data>.W,(d8,An,Xn)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCLR.L #<data>.W,(xxx).W
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2}	// BFCLR.L #<data>.W,(xxx).L
};

/** 
  Cycles table for BFFFO Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFFFO_Mem [] = {
	{14,	0,	26,1,0,0,	30,1,2,0},	{14,	0,	34,2,0,0,	38,2,2,0},	// BFFFO.L #<data>.W,(An)
	{16,	0,	28,1,0,0,	32,1,2,0},	{16,	0,	36,2,0,0,	40,2,2,0},	// BFFFO.L #<data>.W,(d16,An)
	{18,	0,	30,1,0,0,	36,1,3,0},	{18,	0,	38,2,0,0,	44,2,3,0},	// BFFFO.L #<data>.W,(d8,An,Xn)
	{16,	0,	28,1,0,0,	32,1,2,0},	{16,	0,	36,2,0,0,	40,2,2,0},	// BFFFO.L #<data>.W,(xxx).W
	{18,	0,	30,1,0,0,	36,1,3,0},	{18,	0,	38,2,0,0,	44,2,3,0},	// BFFFO.L #<data>.W,(xxx).L
	{16,	0,	28,1,0,0,	32,1,2,0},	{16,	0,	36,2,0,0,	40,2,2,0},	// BFFFO.L #<data>.W,(d16,PC)
	{18,	0,	30,1,0,0,	36,1,3,0},	{18,	0,	38,2,0,0,	44,2,3,0}	// BFFFO.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for BFSET Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFSET_Mem [] = {
	{14,	0,	20,1,0,1,	24,1,2,1},	{14,	0,	32,2,0,2,	36,2,2,2},	// BFSET.L #<data>.W,(An)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFSET.L #<data>.W,(d16,An)
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2},	// BFSET.L #<data>.W,(d8,An,Xn)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFSET.L #<data>.W,(xxx).W
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2}	// BFSET.L #<data>.W,(xxx).L
};

/** 
  Cycles table for BFINS Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFINS_Mem [] = {
	{14,	0,	18,1,0,1,	22,1,2,1},	{14,	0,	28,2,0,2,	32,2,2,2},	// BFINS.L #<data>.W,(An)
	{16,	0,	20,1,0,1,	24,1,2,1},	{16,	0,	30,2,0,2,	34,2,2,2},	// BFINS.L #<data>.W,(d16,An)
	{18,	0,	22,1,0,1,	28,1,3,1},	{18,	0,	32,2,0,2,	38,2,3,2},	// BFINS.L #<data>.W,(d8,An,Xn)
	{16,	0,	20,1,0,1,	24,1,2,1},	{16,	0,	30,2,0,2,	34,2,2,2},	// BFINS.L #<data>.W,(xxx).W
	{18,	0,	22,1,0,1,	28,1,3,1},	{18,	0,	32,2,0,2,	38,2,3,2}	// BFINS.L #<data>.W,(xxx).L
};

/** 
  Cycles table for LSD Dx,Dy instruction. 
  LSD can be LSR or LSL. 
  */
static const struct falcon_cycles_t table_falcon_cycles_LSD [] = {
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// LSD.[B/W/L] Dn,Dn	(shift count is less than or equal to the size of data)
	{8,	0,	 8,0,0,0,	10,0,1,0}	// LSD.[B/W/L] Dn,Dn	(shift count is greater than size of data)
};

/** 
  Cycles table for ASR Dx,Dy instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_ASR [] = {
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// ASR.[B/W/L] Dn,Dn	(shift count is less than or equal to the size of data)
	{10,	0,	10,0,0,0,	12,0,1,0}	// ASR.[B/W/L] Dn,Dn	(shift count is greater than size of data)
};

/** 
  Cycles table for MOVEC Rn,Cr-[A/B] instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_MOVEC [] = {
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// MOVEC.L Rn,CR-A	(Control Registers USP,VBR, CAAR,MSP, and ISP)
	{4,	0,	12,0,0,0,	14,0,1,0}	// MOVEC.L Rn,CR-B	(Control Registers SFC, DFC,and CACR)
};


/** 
  Cycles table for MOVES Ea,Rn instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_MOVES_EA_RN [] = {
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.B #<data>.W,(An)		
	{5,	0,	13,1,0,0,	17,1,2,0},	//MOVES.B #<data>.W,(An)+		
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.B #<data>.W,-(An)		
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.B #<data>.W,(d16,An)		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.B #<data>.W,(d8,An,Xn)	
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.B #<data>.W,(xxx).W		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.B #<data>.W,(xxx).L		
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.W #<data>.W,(An)		
	{5,	0,	13,1,0,0,	17,1,2,0},	//MOVES.W #<data>.W,(An)+		
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.W #<data>.W,-(An)		
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.W #<data>.W,(d16,An)		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.W #<data>.W,(d8,An,Xn)	
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.W #<data>.W,(xxx).W		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.W #<data>.W,(xxx).L		
	{10,	0,	17,1,0,0,	21,1,2,0},	//MOVES.L #<data>.W,(An)		
	{7,	0,	19,1,0,0,	23,1,2,0},	//MOVES.L #<data>.W,(An)+		
	{10,	0,	17,1,0,0,	21,1,2,0},	//MOVES.L #<data>.W,-(An)		
	{12,	0,	19,1,0,0,	26,1,2,0},	//MOVES.L #<data>.W,(d16,An)		
	{14,	0,	21,1,0,0,	27,1,3,0},	//MOVES.L #<data>.W,(d8,An,Xn)	
	{12,	0,	19,1,0,0,	25,1,2,0},	//MOVES.L #<data>.W,(xxx).W		
	{14,	0,	21,1,0,0,	27,1,3,0}	//MOVES.L #<data>.W,(xxx).L		
};

/** 
  Cycles table for MOVES Rn,Ea instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_MOVES_RN_EA [] = {
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.B #<data>.W,(An)		
	{4,	1,	11,0,0,1,	16,0,2,1},	//MOVES.B #<data>.W,(An)+		
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.B #<data>.W,-(An)		
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.B #<data>.W,(d16,An)		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.B #<data>.W,(d8,An,Xn)	
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.B #<data>.W,(xxx).W		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.B #<data>.W,(xxx).L		
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.W #<data>.W,(An)		
	{4,	1,	11,0,0,1,	16,0,2,1},	//MOVES.W #<data>.W,(An)+		
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.W #<data>.W,-(An)		
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.W #<data>.W,(d16,An)		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.W #<data>.W,(d8,An,Xn)	
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.W #<data>.W,(xxx).W		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.W #<data>.W,(xxx).L		
	{8,	1,	15,0,0,1,	20,0,2,1},	//MOVES.L #<data>.W,(An)		
	{6,	1,	17,0,0,1,	22,0,2,1},	//MOVES.L #<data>.W,(An)+		
	{8,	1,	15,0,0,1,	20,0,2,1},	//MOVES.L #<data>.W,-(An)		
	{10,	1,	17,0,0,1,	25,0,2,1},	//MOVES.L #<data>.W,(d16,An)		
	{12,	1,	19,0,0,1,	26,0,3,1},	//MOVES.L #<data>.W,(d8,An,Xn)	
	{10,	1,	17,0,0,1,	24,0,3,1},	//MOVES.L #<data>.W,(xxx).W		
	{12,	1,	19,0,0,1,	26,0,3,1}	//MOVES.L #<data>.W,(xxx).L		
};

/** 
  Cycles table for 68030 internal timings. 
  */
static const struct falcon_cycles_t table_falcon_cycles_68030_internal [] = {
	{1,	0,	11,1,0,0,	11,1,0,0},	// BKPT
	{0,	0,	35,2,0,4,	40,2,2,4},	// Interrupt (I-Stack)
	{0,	0,	53,2,0,8,	48,2,2,8},	// Interrupt (M-Stack)
	{0,	0,	518,0,0,0,	520,0,1,0},	// RESET instruction
	{0,	0,	 8,0,0,0,	12,0,2,0},	// STOP
	{0,	0,	34,1,0,5,	40,1,2,5},	// TRACE
	{0,	0,	28,1,0,4,	34,1,2,4},	// Illegal instruction
	{0,	0,	28,1,0,4,	34,1,2,4},	// A-Line Trap
	{0,	0,	28,1,0,4,	34,1,2,4},	// F-Line Trap
	{0,	0,	28,1,0,4,	34,1,2,4},	// Privilege Violation
	{0,	0,	58,1,0,10,	64,1,2,10},	// Bus Cycle Fault (Short)
	{0,	0,	102,1,0,24,	168,1,2,24}	// Bus Cycle Fault (Long)
};

#endif
