{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
{-# OPTIONS_HADDOCK hide #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  Language.Haskell.Exts.Annotated.Parser
-- Copyright   :  (c) Niklas Broberg 2004-2009,
--                Original (c) Simon Marlow, Sven Panne 1997-2000
-- License     :  BSD-style (see the file LICENSE.txt)
--
-- Maintainer  :  Niklas Broberg, d00nibro@chalmers.se
-- Stability   :  stable
-- Portability :  portable
--
--
-----------------------------------------------------------------------------
module Language.Haskell.Exts.InternalParser (
              mparseModule,
              mparseExp,
              mparsePat,
              mparseDecl,
              mparseType,
              mparseStmt,
              mparseImportDecl,
              ngparseModulePragmas,
              ngparseModuleHeadAndImports,
              ngparsePragmasAndModuleHead,
              ngparsePragmasAndModuleName
              ) where
import Language.Haskell.Exts.Annotated.Syntax hiding ( Type(..), Exp(..), Asst(..), XAttr(..), FieldUpdate(..) )
import Language.Haskell.Exts.Annotated.Syntax ( Type, Exp, Asst )
import Language.Haskell.Exts.ParseMonad
import Language.Haskell.Exts.InternalLexer
import Language.Haskell.Exts.ParseUtils
import Language.Haskell.Exts.Annotated.Fixity
import Language.Haskell.Exts.SrcLoc
import Language.Haskell.Exts.Extension

import Control.Monad ( liftM, (<=<), when )
import Control.Applicative ( (<$>) )
import Data.Maybe
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn  = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn14 :: ([Module L]) -> (HappyAbsSyn )
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> ([Module L])
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: ([[ModulePragma L] -> [S] -> L -> Module L]) -> (HappyAbsSyn )
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> ([[ModulePragma L] -> [S] -> L -> Module L])
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (Module L) -> (HappyAbsSyn )
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (Module L)
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (PExp L) -> (HappyAbsSyn )
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (PExp L)
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (([ModulePragma L],[S],L)) -> (HappyAbsSyn )
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (([ModulePragma L],[S],L))
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (([ModulePragma L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (([ModulePragma L],[S],Maybe L))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (ModulePragma L) -> (HappyAbsSyn )
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> (ModulePragma L)
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (([Name L],[S])) -> (HappyAbsSyn )
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (([Name L],[S]))
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([ModulePragma L] -> [S] -> L -> Module L) -> (HappyAbsSyn )
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> ([ModulePragma L] -> [S] -> L -> Module L)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Maybe (ModuleHead L)) -> (HappyAbsSyn )
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> (Maybe (ModuleHead L))
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (Maybe (WarningText L)) -> (HappyAbsSyn )
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> (Maybe (WarningText L))
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: (([ImportDecl L],[Decl L],[S],L)) -> (HappyAbsSyn )
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> (([ImportDecl L],[Decl L],[S],L))
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (([ImportDecl L],[Decl L],[S])) -> (HappyAbsSyn )
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> (([ImportDecl L],[Decl L],[S]))
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([S]) -> (HappyAbsSyn )
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> ([S])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([S]) -> (HappyAbsSyn )
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> ([S])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (Maybe (ExportSpecList L)) -> (HappyAbsSyn )
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> (Maybe (ExportSpecList L))
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (ExportSpecList L) -> (HappyAbsSyn )
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> (ExportSpecList L)
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([S]) -> (HappyAbsSyn )
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> ([S])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (([ExportSpec L],[S])) -> (HappyAbsSyn )
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> (([ExportSpec L],[S]))
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (ExportSpec L) -> (HappyAbsSyn )
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (ExportSpec L)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (QName L) -> (HappyAbsSyn )
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> (QName L)
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (([ImportDecl L],[S])) -> (HappyAbsSyn )
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (([ImportDecl L],[S]))
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (ImportDecl L) -> (HappyAbsSyn )
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (ImportDecl L)
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ((Bool,[S])) -> (HappyAbsSyn )
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> ((Bool,[S]))
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ((Maybe String,[S])) -> (HappyAbsSyn )
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> ((Maybe String,[S]))
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ((Maybe (ModuleName L),[S],Maybe L)) -> (HappyAbsSyn )
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> ((Maybe (ModuleName L),[S],Maybe L))
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: (Maybe (ImportSpecList L)) -> (HappyAbsSyn )
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> (Maybe (ImportSpecList L))
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: (ImportSpecList L) -> (HappyAbsSyn )
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> (ImportSpecList L)
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: ((Bool, Maybe L,[S])) -> (HappyAbsSyn )
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> ((Bool, Maybe L,[S]))
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (([ImportSpec L],[S])) -> (HappyAbsSyn )
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> (([ImportSpec L],[S]))
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: (ImportSpec L) -> (HappyAbsSyn )
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> (ImportSpec L)
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (([CName L],[S])) -> (HappyAbsSyn )
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> (([CName L],[S]))
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (CName L) -> (HappyAbsSyn )
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (CName L)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (Decl L) -> (HappyAbsSyn )
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> (Decl L)
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: ((Maybe Int, [S])) -> (HappyAbsSyn )
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> ((Maybe Int, [S]))
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (Assoc L) -> (HappyAbsSyn )
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (Assoc L)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: (([Op L],[S],L)) -> (HappyAbsSyn )
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> (([Op L],[S],L))
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (Decl L) -> (HappyAbsSyn )
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> (Decl L)
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (Decl L) -> (HappyAbsSyn )
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> (Decl L)
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ([(Maybe String, L)]) -> (HappyAbsSyn )
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> ([(Maybe String, L)])
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: ((Maybe String, L)) -> (HappyAbsSyn )
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> ((Maybe String, L))
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (Maybe (Overlap L)) -> (HappyAbsSyn )
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> (Maybe (Overlap L))
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Maybe ([TypeEqn L], S)) -> (HappyAbsSyn )
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> (Maybe ([TypeEqn L], S))
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: ([TypeEqn L]) -> (HappyAbsSyn )
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> ([TypeEqn L])
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: ([TypeEqn L]) -> (HappyAbsSyn )
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> ([TypeEqn L])
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (TypeEqn L) -> (HappyAbsSyn )
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> (TypeEqn L)
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: (DataOrNew L) -> (HappyAbsSyn )
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> (DataOrNew L)
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (([Type L],[S])) -> (HappyAbsSyn )
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> (([Type L],[S]))
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: (([Decl L],[S])) -> (HappyAbsSyn )
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> (([Decl L],[S]))
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Decl L) -> (HappyAbsSyn )
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (Decl L)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (Binds L) -> (HappyAbsSyn )
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> (Binds L)
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: (Decl L) -> (HappyAbsSyn )
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> (Decl L)
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: (Decl L) -> (HappyAbsSyn )
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> (Decl L)
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (Decl L) -> (HappyAbsSyn )
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> (Decl L)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (([Type L],[S])) -> (HappyAbsSyn )
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> (([Type L],[S]))
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (Type L) -> (HappyAbsSyn )
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> (Type L)
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (Maybe (BooleanFormula L)) -> (HappyAbsSyn )
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> (Maybe (BooleanFormula L))
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (BooleanFormula L) -> (HappyAbsSyn )
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> (BooleanFormula L)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (Binds L) -> (HappyAbsSyn )
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> (Binds L)
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (([Name L],[S],L)) -> (HappyAbsSyn )
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> (([Name L],[S],L))
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (CallConv L) -> (HappyAbsSyn )
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> (CallConv L)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (Maybe (Safety L)) -> (HappyAbsSyn )
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> (Maybe (Safety L))
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: ((Maybe String, Name L, Type L, [S])) -> (HappyAbsSyn )
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> ((Maybe String, Name L, Type L, [S]))
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: ([Rule L]) -> (HappyAbsSyn )
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> ([Rule L])
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (Rule L) -> (HappyAbsSyn )
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> (Rule L)
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (Maybe (Activation L)) -> (HappyAbsSyn )
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (Maybe (Activation L))
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: ((Maybe [RuleVar L],[S])) -> (HappyAbsSyn )
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> ((Maybe [RuleVar L],[S]))
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: ([RuleVar L]) -> (HappyAbsSyn )
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn ) -> ([RuleVar L])
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (RuleVar L) -> (HappyAbsSyn )
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn ) -> (RuleVar L)
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (([([Name L],String)],[S])) -> (HappyAbsSyn )
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn ) -> (([([Name L],String)],[S]))
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: ((([Name L], String),[S])) -> (HappyAbsSyn )
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn ) -> ((([Name L], String),[S]))
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: (([Name L],[S])) -> (HappyAbsSyn )
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn ) -> (([Name L],[S]))
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: (Name L) -> (HappyAbsSyn )
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn ) -> (Name L)
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Annotation L) -> (HappyAbsSyn )
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn ) -> (Annotation L)
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (Type L) -> (HappyAbsSyn )
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn ) -> (Type L)
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (PType L) -> (HappyAbsSyn )
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn ) -> (PType L)
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: (Type L) -> (HappyAbsSyn )
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn ) -> (Type L)
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (PType L) -> (HappyAbsSyn )
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn ) -> (PType L)
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: (Type L) -> (HappyAbsSyn )
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn ) -> (Type L)
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: (PType L) -> (HappyAbsSyn )
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn ) -> (PType L)
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: (PType L) -> (HappyAbsSyn )
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn ) -> (PType L)
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: (Promoted L) -> (HappyAbsSyn )
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn ) -> (Promoted L)
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: ((Bool, [S])) -> (HappyAbsSyn )
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn ) -> ((Bool, [S]))
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (QName L) -> (HappyAbsSyn )
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn ) -> (QName L)
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: (QName L) -> (HappyAbsSyn )
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn ) -> (QName L)
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: (QName L) -> (HappyAbsSyn )
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn ) -> (QName L)
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: (Type L) -> (HappyAbsSyn )
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn ) -> (Type L)
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: (PType L) -> (HappyAbsSyn )
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn ) -> (PType L)
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (PContext L) -> (HappyAbsSyn )
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn ) -> (PContext L)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: (([PType L],[S])) -> (HappyAbsSyn )
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn ) -> (([PType L],[S]))
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (([TyVarBind L],Maybe L)) -> (HappyAbsSyn )
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn ) -> (([TyVarBind L],Maybe L))
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: (TyVarBind L) -> (HappyAbsSyn )
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn ) -> (TyVarBind L)
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: (([Name L],Maybe L)) -> (HappyAbsSyn )
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn ) -> (([Name L],Maybe L))
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: (([Name L],L)) -> (HappyAbsSyn )
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn ) -> (([Name L],L))
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (([FunDep L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn ) -> (([FunDep L],[S],Maybe L))
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (([FunDep L],[S],L)) -> (HappyAbsSyn )
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn ) -> (([FunDep L],[S],L))
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (FunDep L) -> (HappyAbsSyn )
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn ) -> (FunDep L)
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: (([GadtDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn ) -> (([GadtDecl L],[S],Maybe L))
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (([GadtDecl L],[S])) -> (HappyAbsSyn )
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn ) -> (([GadtDecl L],[S]))
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: (([GadtDecl L],[S])) -> (HappyAbsSyn )
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn ) -> (([GadtDecl L],[S]))
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: ([GadtDecl L]) -> (HappyAbsSyn )
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn ) -> ([GadtDecl L])
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: (([QualConDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn ) -> (([QualConDecl L],[S],Maybe L))
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (([QualConDecl L],[S],L)) -> (HappyAbsSyn )
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn ) -> (([QualConDecl L],[S],L))
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (QualConDecl L) -> (HappyAbsSyn )
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn ) -> (QualConDecl L)
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: ((Maybe [TyVarBind L], [S], Maybe L)) -> (HappyAbsSyn )
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn ) -> ((Maybe [TyVarBind L], [S], Maybe L))
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: (ConDecl L) -> (HappyAbsSyn )
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn ) -> (ConDecl L)
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: ((Name L, [Type L], L)) -> (HappyAbsSyn )
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn ) -> ((Name L, [Type L], L))
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: (([FieldDecl L],[S])) -> (HappyAbsSyn )
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn ) -> (([FieldDecl L],[S]))
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: (FieldDecl L) -> (HappyAbsSyn )
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn ) -> (FieldDecl L)
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: (Maybe (Deriving L)) -> (HappyAbsSyn )
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn ) -> (Maybe (Deriving L))
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: (([InstRule L],[S])) -> (HappyAbsSyn )
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn ) -> (([InstRule L],[S]))
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: (InstHead L) -> (HappyAbsSyn )
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn ) -> (InstHead L)
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: (Kind L) -> (HappyAbsSyn )
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn ) -> (Kind L)
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: (Kind L) -> (HappyAbsSyn )
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn ) -> (Kind L)
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: (Kind L) -> (HappyAbsSyn )
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn ) -> (Kind L)
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: (Kind L) -> (HappyAbsSyn )
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn ) -> (Kind L)
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: (Kind L) -> (HappyAbsSyn )
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn ) -> (Kind L)
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: (([Kind L], [S])) -> (HappyAbsSyn )
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn ) -> (([Kind L], [S]))
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyIn140 :: ((Maybe (Kind L), [S])) -> (HappyAbsSyn )
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn ) -> ((Maybe (Kind L), [S]))
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
happyIn141 :: ((Maybe [ClassDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn ) -> ((Maybe [ClassDecl L],[S],Maybe L))
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
happyIn142 :: (([ClassDecl L],[S])) -> (HappyAbsSyn )
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn ) -> (([ClassDecl L],[S]))
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
happyIn143 :: (([ClassDecl L],[S])) -> (HappyAbsSyn )
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn ) -> (([ClassDecl L],[S]))
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
happyIn144 :: (ClassDecl L) -> (HappyAbsSyn )
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn ) -> (ClassDecl L)
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
happyIn145 :: (ClassDecl L) -> (HappyAbsSyn )
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn ) -> (ClassDecl L)
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
happyIn146 :: ((Maybe [InstDecl L],[S],Maybe L)) -> (HappyAbsSyn )
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn ) -> ((Maybe [InstDecl L],[S],Maybe L))
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
happyIn147 :: (([InstDecl L],[S])) -> (HappyAbsSyn )
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn ) -> (([InstDecl L],[S]))
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
happyIn148 :: (([InstDecl L],[S])) -> (HappyAbsSyn )
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn ) -> (([InstDecl L],[S]))
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
happyIn149 :: (InstDecl L) -> (HappyAbsSyn )
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn ) -> (InstDecl L)
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
happyIn150 :: (InstDecl L) -> (HappyAbsSyn )
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn ) -> (InstDecl L)
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
happyIn151 :: (Decl L) -> (HappyAbsSyn )
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn ) -> (Decl L)
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
happyIn152 :: ((Maybe (Binds L),[S])) -> (HappyAbsSyn )
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn ) -> ((Maybe (Binds L),[S]))
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
happyIn153 :: ((Maybe (Type L, S))) -> (HappyAbsSyn )
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn ) -> ((Maybe (Type L, S)))
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
happyIn154 :: (Rhs L) -> (HappyAbsSyn )
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn ) -> (Rhs L)
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
happyIn155 :: (([GuardedRhs L],L)) -> (HappyAbsSyn )
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn ) -> (([GuardedRhs L],L))
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
happyIn156 :: (GuardedRhs L) -> (HappyAbsSyn )
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn ) -> (GuardedRhs L)
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
happyIn157 :: (Exp L) -> (HappyAbsSyn )
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn ) -> (Exp L)
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
happyIn158 :: (PExp L) -> (HappyAbsSyn )
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn ) -> (PExp L)
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
happyIn159 :: (PExp L) -> (HappyAbsSyn )
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn ) -> (PExp L)
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
happyIn160 :: (PExp L) -> (HappyAbsSyn )
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn ) -> (PExp L)
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
happyIn161 :: (PExp L) -> (HappyAbsSyn )
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn ) -> (PExp L)
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
happyIn162 :: (PExp L) -> (HappyAbsSyn )
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn ) -> (PExp L)
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
happyIn163 :: ([S]) -> (HappyAbsSyn )
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn ) -> ([S])
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
happyIn164 :: ([S]) -> (HappyAbsSyn )
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn ) -> ([S])
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
happyIn165 :: (PExp L) -> (HappyAbsSyn )
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn ) -> (PExp L)
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
happyIn166 :: (PExp L) -> (HappyAbsSyn )
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn ) -> (PExp L)
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
happyIn167 :: (PExp L) -> (HappyAbsSyn )
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn ) -> (PExp L)
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
happyIn168 :: ([Pat L]) -> (HappyAbsSyn )
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn ) -> ([Pat L])
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
happyIn169 :: (Pat L) -> (HappyAbsSyn )
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn ) -> (Pat L)
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
happyIn170 :: (PExp L) -> (HappyAbsSyn )
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn ) -> (PExp L)
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
happyIn171 :: (PExp L) -> (HappyAbsSyn )
happyIn171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn171 #-}
happyOut171 :: (HappyAbsSyn ) -> (PExp L)
happyOut171 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut171 #-}
happyIn172 :: (PExp L) -> (HappyAbsSyn )
happyIn172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn172 #-}
happyOut172 :: (HappyAbsSyn ) -> (PExp L)
happyOut172 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut172 #-}
happyIn173 :: ([S]) -> (HappyAbsSyn )
happyIn173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn173 #-}
happyOut173 :: (HappyAbsSyn ) -> ([S])
happyOut173 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut173 #-}
happyIn174 :: (PExp L) -> (HappyAbsSyn )
happyIn174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn174 #-}
happyOut174 :: (HappyAbsSyn ) -> (PExp L)
happyOut174 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut174 #-}
happyIn175 :: (([Maybe (PExp L)],[S])) -> (HappyAbsSyn )
happyIn175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn175 #-}
happyOut175 :: (HappyAbsSyn ) -> (([Maybe (PExp L)],[S]))
happyOut175 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut175 #-}
happyIn176 :: (([Maybe (PExp L)],[S])) -> (HappyAbsSyn )
happyIn176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn176 #-}
happyOut176 :: (HappyAbsSyn ) -> (([Maybe (PExp L)],[S]))
happyOut176 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut176 #-}
happyIn177 :: (([PExp L],[S])) -> (HappyAbsSyn )
happyIn177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn177 #-}
happyOut177 :: (HappyAbsSyn ) -> (([PExp L],[S]))
happyOut177 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut177 #-}
happyIn178 :: (PExp L) -> (HappyAbsSyn )
happyIn178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn178 #-}
happyOut178 :: (HappyAbsSyn ) -> (PExp L)
happyOut178 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut178 #-}
happyIn179 :: (PExp L) -> (HappyAbsSyn )
happyIn179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn179 #-}
happyOut179 :: (HappyAbsSyn ) -> (PExp L)
happyOut179 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut179 #-}
happyIn180 :: ([PExp L]) -> (HappyAbsSyn )
happyIn180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn180 #-}
happyOut180 :: (HappyAbsSyn ) -> ([PExp L])
happyOut180 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut180 #-}
happyIn181 :: (PExp L) -> (HappyAbsSyn )
happyIn181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn181 #-}
happyOut181 :: (HappyAbsSyn ) -> (PExp L)
happyOut181 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut181 #-}
happyIn182 :: (XName L) -> (HappyAbsSyn )
happyIn182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn182 #-}
happyOut182 :: (HappyAbsSyn ) -> (XName L)
happyOut182 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut182 #-}
happyIn183 :: (Loc String) -> (HappyAbsSyn )
happyIn183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn183 #-}
happyOut183 :: (HappyAbsSyn ) -> (Loc String)
happyOut183 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut183 #-}
happyIn184 :: (Loc String) -> (HappyAbsSyn )
happyIn184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn184 #-}
happyOut184 :: (HappyAbsSyn ) -> (Loc String)
happyOut184 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut184 #-}
happyIn185 :: ([ParseXAttr L]) -> (HappyAbsSyn )
happyIn185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn185 #-}
happyOut185 :: (HappyAbsSyn ) -> ([ParseXAttr L])
happyOut185 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut185 #-}
happyIn186 :: (ParseXAttr L) -> (HappyAbsSyn )
happyIn186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn186 #-}
happyOut186 :: (HappyAbsSyn ) -> (ParseXAttr L)
happyOut186 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut186 #-}
happyIn187 :: (Maybe (PExp L)) -> (HappyAbsSyn )
happyIn187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn187 #-}
happyOut187 :: (HappyAbsSyn ) -> (Maybe (PExp L))
happyOut187 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut187 #-}
happyIn188 :: (L -> PExp L) -> (HappyAbsSyn )
happyIn188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn188 #-}
happyOut188 :: (HappyAbsSyn ) -> (L -> PExp L)
happyOut188 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut188 #-}
happyIn189 :: (([PExp L],[S])) -> (HappyAbsSyn )
happyIn189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn189 #-}
happyOut189 :: (HappyAbsSyn ) -> (([PExp L],[S]))
happyOut189 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut189 #-}
happyIn190 :: (([[QualStmt L]],[S])) -> (HappyAbsSyn )
happyIn190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn190 #-}
happyOut190 :: (HappyAbsSyn ) -> (([[QualStmt L]],[S]))
happyOut190 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut190 #-}
happyIn191 :: (([QualStmt L],[S])) -> (HappyAbsSyn )
happyIn191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn191 #-}
happyOut191 :: (HappyAbsSyn ) -> (([QualStmt L],[S]))
happyOut191 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut191 #-}
happyIn192 :: (QualStmt L) -> (HappyAbsSyn )
happyIn192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn192 #-}
happyOut192 :: (HappyAbsSyn ) -> (QualStmt L)
happyOut192 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut192 #-}
happyIn193 :: (QualStmt L) -> (HappyAbsSyn )
happyIn193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn193 #-}
happyOut193 :: (HappyAbsSyn ) -> (QualStmt L)
happyOut193 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut193 #-}
happyIn194 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn194 #-}
happyOut194 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut194 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut194 #-}
happyIn195 :: (Stmt L) -> (HappyAbsSyn )
happyIn195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn195 #-}
happyOut195 :: (HappyAbsSyn ) -> (Stmt L)
happyOut195 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut195 #-}
happyIn196 :: (L -> PExp L) -> (HappyAbsSyn )
happyIn196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn196 #-}
happyOut196 :: (HappyAbsSyn ) -> (L -> PExp L)
happyOut196 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut196 #-}
happyIn197 :: (([Alt L],L,[S])) -> (HappyAbsSyn )
happyIn197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn197 #-}
happyOut197 :: (HappyAbsSyn ) -> (([Alt L],L,[S]))
happyOut197 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut197 #-}
happyIn198 :: (([Alt L],[S])) -> (HappyAbsSyn )
happyIn198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn198 #-}
happyOut198 :: (HappyAbsSyn ) -> (([Alt L],[S]))
happyOut198 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut198 #-}
happyIn199 :: (([Alt L],[S])) -> (HappyAbsSyn )
happyIn199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn199 #-}
happyOut199 :: (HappyAbsSyn ) -> (([Alt L],[S]))
happyOut199 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut199 #-}
happyIn200 :: (Alt L) -> (HappyAbsSyn )
happyIn200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn200 #-}
happyOut200 :: (HappyAbsSyn ) -> (Alt L)
happyOut200 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut200 #-}
happyIn201 :: (Rhs L) -> (HappyAbsSyn )
happyIn201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn201 #-}
happyOut201 :: (HappyAbsSyn ) -> (Rhs L)
happyOut201 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut201 #-}
happyIn202 :: (([GuardedRhs L],L)) -> (HappyAbsSyn )
happyIn202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn202 #-}
happyOut202 :: (HappyAbsSyn ) -> (([GuardedRhs L],L))
happyOut202 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut202 #-}
happyIn203 :: (GuardedRhs L) -> (HappyAbsSyn )
happyIn203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn203 #-}
happyOut203 :: (HappyAbsSyn ) -> (GuardedRhs L)
happyOut203 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut203 #-}
happyIn204 :: (Pat L) -> (HappyAbsSyn )
happyIn204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn204 #-}
happyOut204 :: (HappyAbsSyn ) -> (Pat L)
happyOut204 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut204 #-}
happyIn205 :: (([GuardedRhs L], L, [S])) -> (HappyAbsSyn )
happyIn205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn205 #-}
happyOut205 :: (HappyAbsSyn ) -> (([GuardedRhs L], L, [S]))
happyOut205 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut205 #-}
happyIn206 :: (([GuardedRhs L], [S])) -> (HappyAbsSyn )
happyIn206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn206 #-}
happyOut206 :: (HappyAbsSyn ) -> (([GuardedRhs L], [S]))
happyOut206 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut206 #-}
happyIn207 :: (([GuardedRhs L], [S])) -> (HappyAbsSyn )
happyIn207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn207 #-}
happyOut207 :: (HappyAbsSyn ) -> (([GuardedRhs L], [S]))
happyOut207 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut207 #-}
happyIn208 :: (([Stmt L],L,[S])) -> (HappyAbsSyn )
happyIn208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn208 #-}
happyOut208 :: (HappyAbsSyn ) -> (([Stmt L],L,[S]))
happyOut208 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut208 #-}
happyIn209 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn209 #-}
happyOut209 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut209 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut209 #-}
happyIn210 :: (([Stmt L],[S])) -> (HappyAbsSyn )
happyIn210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn210 #-}
happyOut210 :: (HappyAbsSyn ) -> (([Stmt L],[S]))
happyOut210 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut210 #-}
happyIn211 :: (Stmt L) -> (HappyAbsSyn )
happyIn211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn211 #-}
happyOut211 :: (HappyAbsSyn ) -> (Stmt L)
happyOut211 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut211 #-}
happyIn212 :: (([PFieldUpdate L],[S])) -> (HappyAbsSyn )
happyIn212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn212 #-}
happyOut212 :: (HappyAbsSyn ) -> (([PFieldUpdate L],[S]))
happyOut212 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut212 #-}
happyIn213 :: (PFieldUpdate L) -> (HappyAbsSyn )
happyIn213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn213 #-}
happyOut213 :: (HappyAbsSyn ) -> (PFieldUpdate L)
happyOut213 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut213 #-}
happyIn214 :: (([IPBind L],[S])) -> (HappyAbsSyn )
happyIn214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn214 #-}
happyOut214 :: (HappyAbsSyn ) -> (([IPBind L],[S]))
happyOut214 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut214 #-}
happyIn215 :: (([IPBind L],[S])) -> (HappyAbsSyn )
happyIn215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn215 #-}
happyOut215 :: (HappyAbsSyn ) -> (([IPBind L],[S]))
happyOut215 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut215 #-}
happyIn216 :: (IPBind L) -> (HappyAbsSyn )
happyIn216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn216 #-}
happyOut216 :: (HappyAbsSyn ) -> (IPBind L)
happyOut216 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut216 #-}
happyIn217 :: (PExp L) -> (HappyAbsSyn )
happyIn217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn217 #-}
happyOut217 :: (HappyAbsSyn ) -> (PExp L)
happyOut217 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut217 #-}
happyIn218 :: (Name L) -> (HappyAbsSyn )
happyIn218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn218 #-}
happyOut218 :: (HappyAbsSyn ) -> (Name L)
happyOut218 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut218 #-}
happyIn219 :: (Name L) -> (HappyAbsSyn )
happyIn219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn219 #-}
happyOut219 :: (HappyAbsSyn ) -> (Name L)
happyOut219 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut219 #-}
happyIn220 :: (QName L) -> (HappyAbsSyn )
happyIn220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn220 #-}
happyOut220 :: (HappyAbsSyn ) -> (QName L)
happyOut220 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut220 #-}
happyIn221 :: (IPName L) -> (HappyAbsSyn )
happyIn221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn221 #-}
happyOut221 :: (HappyAbsSyn ) -> (IPName L)
happyOut221 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut221 #-}
happyIn222 :: (Name L) -> (HappyAbsSyn )
happyIn222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn222 #-}
happyOut222 :: (HappyAbsSyn ) -> (Name L)
happyOut222 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut222 #-}
happyIn223 :: (QName L) -> (HappyAbsSyn )
happyIn223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn223 #-}
happyOut223 :: (HappyAbsSyn ) -> (QName L)
happyOut223 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut223 #-}
happyIn224 :: (Name L) -> (HappyAbsSyn )
happyIn224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn224 #-}
happyOut224 :: (HappyAbsSyn ) -> (Name L)
happyOut224 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut224 #-}
happyIn225 :: (QName L) -> (HappyAbsSyn )
happyIn225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn225 #-}
happyOut225 :: (HappyAbsSyn ) -> (QName L)
happyOut225 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut225 #-}
happyIn226 :: (QName L) -> (HappyAbsSyn )
happyIn226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn226 #-}
happyOut226 :: (HappyAbsSyn ) -> (QName L)
happyOut226 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut226 #-}
happyIn227 :: (Name L) -> (HappyAbsSyn )
happyIn227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn227 #-}
happyOut227 :: (HappyAbsSyn ) -> (Name L)
happyOut227 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut227 #-}
happyIn228 :: (QName L) -> (HappyAbsSyn )
happyIn228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn228 #-}
happyOut228 :: (HappyAbsSyn ) -> (QName L)
happyOut228 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut228 #-}
happyIn229 :: (Op L) -> (HappyAbsSyn )
happyIn229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn229 #-}
happyOut229 :: (HappyAbsSyn ) -> (Op L)
happyOut229 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut229 #-}
happyIn230 :: (QOp L) -> (HappyAbsSyn )
happyIn230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn230 #-}
happyOut230 :: (HappyAbsSyn ) -> (QOp L)
happyOut230 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut230 #-}
happyIn231 :: (QOp L) -> (HappyAbsSyn )
happyIn231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn231 #-}
happyOut231 :: (HappyAbsSyn ) -> (QOp L)
happyOut231 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut231 #-}
happyIn232 :: (QName L) -> (HappyAbsSyn )
happyIn232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn232 #-}
happyOut232 :: (HappyAbsSyn ) -> (QName L)
happyOut232 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut232 #-}
happyIn233 :: (QName L) -> (HappyAbsSyn )
happyIn233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn233 #-}
happyOut233 :: (HappyAbsSyn ) -> (QName L)
happyOut233 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut233 #-}
happyIn234 :: (Name L) -> (HappyAbsSyn )
happyIn234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn234 #-}
happyOut234 :: (HappyAbsSyn ) -> (Name L)
happyOut234 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut234 #-}
happyIn235 :: (Name L) -> (HappyAbsSyn )
happyIn235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn235 #-}
happyOut235 :: (HappyAbsSyn ) -> (Name L)
happyOut235 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut235 #-}
happyIn236 :: (IPName L) -> (HappyAbsSyn )
happyIn236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn236 #-}
happyOut236 :: (HappyAbsSyn ) -> (IPName L)
happyOut236 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut236 #-}
happyIn237 :: (QName L) -> (HappyAbsSyn )
happyIn237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn237 #-}
happyOut237 :: (HappyAbsSyn ) -> (QName L)
happyOut237 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut237 #-}
happyIn238 :: (Name L) -> (HappyAbsSyn )
happyIn238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn238 #-}
happyOut238 :: (HappyAbsSyn ) -> (Name L)
happyOut238 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut238 #-}
happyIn239 :: (QName L) -> (HappyAbsSyn )
happyIn239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn239 #-}
happyOut239 :: (HappyAbsSyn ) -> (QName L)
happyOut239 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut239 #-}
happyIn240 :: (Name L) -> (HappyAbsSyn )
happyIn240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn240 #-}
happyOut240 :: (HappyAbsSyn ) -> (Name L)
happyOut240 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut240 #-}
happyIn241 :: (QName L) -> (HappyAbsSyn )
happyIn241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn241 #-}
happyOut241 :: (HappyAbsSyn ) -> (QName L)
happyOut241 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut241 #-}
happyIn242 :: (QName L) -> (HappyAbsSyn )
happyIn242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn242 #-}
happyOut242 :: (HappyAbsSyn ) -> (QName L)
happyOut242 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut242 #-}
happyIn243 :: (Name L) -> (HappyAbsSyn )
happyIn243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn243 #-}
happyOut243 :: (HappyAbsSyn ) -> (Name L)
happyOut243 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut243 #-}
happyIn244 :: (Name L) -> (HappyAbsSyn )
happyIn244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn244 #-}
happyOut244 :: (HappyAbsSyn ) -> (Name L)
happyOut244 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut244 #-}
happyIn245 :: (QName L) -> (HappyAbsSyn )
happyIn245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn245 #-}
happyOut245 :: (HappyAbsSyn ) -> (QName L)
happyOut245 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut245 #-}
happyIn246 :: (Literal L) -> (HappyAbsSyn )
happyIn246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn246 #-}
happyOut246 :: (HappyAbsSyn ) -> (Literal L)
happyOut246 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut246 #-}
happyIn247 :: (S) -> (HappyAbsSyn )
happyIn247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn247 #-}
happyOut247 :: (HappyAbsSyn ) -> (S)
happyOut247 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut247 #-}
happyIn248 :: (S) -> (HappyAbsSyn )
happyIn248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn248 #-}
happyOut248 :: (HappyAbsSyn ) -> (S)
happyOut248 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut248 #-}
happyIn249 :: (Decl L) -> (HappyAbsSyn )
happyIn249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn249 #-}
happyOut249 :: (HappyAbsSyn ) -> (Decl L)
happyOut249 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut249 #-}
happyIn250 :: (Decl L) -> (HappyAbsSyn )
happyIn250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn250 #-}
happyOut250 :: (HappyAbsSyn ) -> (Decl L)
happyOut250 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut250 #-}
happyIn251 :: (Pat L) -> (HappyAbsSyn )
happyIn251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn251 #-}
happyOut251 :: (HappyAbsSyn ) -> (Pat L)
happyOut251 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut251 #-}
happyIn252 :: ([Pat L]) -> (HappyAbsSyn )
happyIn252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn252 #-}
happyOut252 :: (HappyAbsSyn ) -> ([Pat L])
happyOut252 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut252 #-}
happyIn253 :: (PatternSynDirection L) -> (HappyAbsSyn )
happyIn253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn253 #-}
happyOut253 :: (HappyAbsSyn ) -> (PatternSynDirection L)
happyOut253 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut253 #-}
happyIn254 :: (Decl L) -> (HappyAbsSyn )
happyIn254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn254 #-}
happyOut254 :: (HappyAbsSyn ) -> (Decl L)
happyOut254 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut254 #-}
happyIn255 :: ((Maybe [TyVarBind L], [S], Maybe (Context L), Maybe (Context L), Type L )) -> (HappyAbsSyn )
happyIn255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn255 #-}
happyOut255 :: (HappyAbsSyn ) -> ((Maybe [TyVarBind L], [S], Maybe (Context L), Maybe (Context L), Type L ))
happyOut255 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut255 #-}
happyIn256 :: (ModuleName L) -> (HappyAbsSyn )
happyIn256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn256 #-}
happyOut256 :: (HappyAbsSyn ) -> (ModuleName L)
happyOut256 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut256 #-}
happyIn257 :: (Name L) -> (HappyAbsSyn )
happyIn257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn257 #-}
happyOut257 :: (HappyAbsSyn ) -> (Name L)
happyOut257 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut257 #-}
happyIn258 :: (QName L) -> (HappyAbsSyn )
happyIn258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn258 #-}
happyOut258 :: (HappyAbsSyn ) -> (QName L)
happyOut258 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut258 #-}
happyIn259 :: (Name L) -> (HappyAbsSyn )
happyIn259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn259 #-}
happyOut259 :: (HappyAbsSyn ) -> (Name L)
happyOut259 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut259 #-}
happyIn260 :: (Name L) -> (HappyAbsSyn )
happyIn260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn260 #-}
happyOut260 :: (HappyAbsSyn ) -> (Name L)
happyOut260 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut260 #-}
happyIn261 :: (QName L) -> (HappyAbsSyn )
happyIn261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn261 #-}
happyOut261 :: (HappyAbsSyn ) -> (QName L)
happyOut261 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut261 #-}
happyIn262 :: (Name L) -> (HappyAbsSyn )
happyIn262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn262 #-}
happyOut262 :: (HappyAbsSyn ) -> (Name L)
happyOut262 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut262 #-}
happyIn263 :: (([ImportDecl L],[S],L)) -> (HappyAbsSyn )
happyIn263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn263 #-}
happyOut263 :: (HappyAbsSyn ) -> (([ImportDecl L],[S],L))
happyOut263 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut263 #-}
happyIn264 :: ((([ModulePragma L], [S], L), Maybe (ModuleName L))) -> (HappyAbsSyn )
happyIn264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn264 #-}
happyOut264 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleName L)))
happyOut264 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut264 #-}
happyIn265 :: ((([ModulePragma L], [S], L), Maybe (ModuleHead L))) -> (HappyAbsSyn )
happyIn265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn265 #-}
happyOut265 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleHead L)))
happyOut265 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut265 #-}
happyIn266 :: ((([ModulePragma L], [S], L), Maybe (ModuleHead L), Maybe ([ImportDecl L],[S],L))) -> (HappyAbsSyn )
happyIn266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn266 #-}
happyOut266 :: (HappyAbsSyn ) -> ((([ModulePragma L], [S], L), Maybe (ModuleHead L), Maybe ([ImportDecl L],[S],L)))
happyOut266 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut266 #-}
happyInTok :: (Loc Token) -> (HappyAbsSyn )
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> (Loc Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x34\x25\xb8\x24\x69\x09\x9b\x18\x54\x21\x18\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x09\x5c\x05\x20\x09\x82\x09\x1f\x09\x80\x09\x0c\x09\x7e\x09\x7e\x09\xe4\x08\xf2\x08\x00\x00\x47\x09\x00\x00\x00\x00\x80\x07\x00\x00\x00\x00\x00\x00\xe3\x28\x00\x00\x57\x09\x00\x00\x00\x00\x45\x09\xd8\x08\x00\x00\x0d\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x1d\x53\x1d\x61\x1e\xe8\x1e\x00\x00\x25\x28\xe3\x28\xe3\x28\xe3\x28\x34\x25\x00\x00\x34\x25\x34\x25\x34\x25\x9b\x18\x00\x00\x5e\x2b\x11\x2d\x00\x00\x12\x29\x34\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x25\x4f\x09\x00\x00\x00\x00\x00\x00\x3c\x24\x4e\x09\x4d\x09\x84\x28\x4d\x09\x00\x00\x58\x09\x55\x09\x46\x09\x00\x00\x00\x00\xe3\x11\x00\x00\x00\x00\xd5\x1a\x00\x00\x00\x00\xd0\x08\x00\x00\x9b\x18\x2b\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7e\x11\x00\x13\x3a\x15\x59\x19\x00\x00\x00\x00\x00\x00\x34\x25\xdd\x03\x00\x00\x00\x00\x00\x00\x00\x00\xca\x08\xc7\x08\x00\x00\x00\x00\x00\x00\xc7\x08\x37\x09\xbe\x08\x00\x00\xbe\x08\xf1\xff\x00\x00\x00\x00\x35\x09\x12\x29\xd3\x08\xd5\x06\x00\x00\xe3\x08\x00\x00\x00\x00\x25\x09\x00\x00\x3b\x0c\x38\x00\x16\x09\x6c\x2e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x12\xdb\x14\x00\x00\x23\x09\x12\x09\x42\x12\x19\x09\x00\x00\x0d\x09\x08\x09\x00\x00\x7c\x03\x6d\x03\x00\x00\x00\x00\x4b\x02\x11\x09\xdb\x02\x10\x09\x0f\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x09\x00\x00\x0a\x09\x00\x00\xd5\x1a\x00\x00\x00\x00\x00\x00\xd5\x1a\x00\x00\x00\x00\xd5\x1a\x00\x00\x00\x00\x61\x0a\x9b\x18\xd5\x1a\x00\x00\x00\x00\x14\x09\x92\x08\x8d\x08\x00\x00\x64\x1f\x64\x1f\xf1\x08\x00\x00\xe3\x28\x00\x00\xb0\x08\xf7\x08\x00\x00\x00\x00\x00\x00\x00\x00\x95\x08\x53\x02\xb9\x08\x00\x00\xdd\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x14\x66\x03\xe7\x08\x00\x00\x00\x00\xe1\x0a\x57\x0d\xc0\x08\xbf\x08\x70\x06\xbd\x08\xe6\x08\xce\x08\x08\x01\x00\x00\xe3\x28\x00\x00\xc6\x27\x00\x00\xda\x08\xc2\x08\x8e\x02\xc3\x08\xcc\x08\x00\x00\x00\x00\x34\x25\x00\x00\x00\x00\x00\x00\x1b\x2c\x00\x00\x60\x01\xc5\x08\xc1\x08\x00\x00\xcc\x1c\x0b\x03\x00\x00\x05\x06\x45\x1c\x98\x02\xc9\x08\xc8\x08\xc4\x08\xb4\x08\xb2\x08\x00\x00\xe3\x28\xe3\x28\xe3\x28\x34\x25\x78\x2b\x00\x00\x00\x00\x00\x00\x34\x25\x00\x00\x1b\x2c\x9b\x18\x34\x25\x34\x25\x34\x25\x34\x25\x77\x08\x42\x08\x2c\x00\x00\x00\xd5\x06\x38\x00\x00\x00\x00\x00\x00\x00\x30\x2b\x00\x00\x54\x08\x00\x00\xe3\x28\x2e\x08\x00\x00\x00\x00\x00\x00\x00\x00\x79\x02\xe3\x28\xb7\x08\xa4\x08\x6a\x00\x48\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x08\x99\x08\x00\x00\x00\x00\x9e\x08\x97\x08\x8f\x08\xae\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x1b\x00\x00\x00\x00\x83\x02\x00\x00\x00\x00\x34\x25\xc0\x23\x37\x1b\x00\x00\x00\x00\x08\x03\x00\x00\xe8\x1e\x00\x00\xe8\x1e\x34\x25\xd8\x20\x91\x08\x00\x00\x00\x00\xe8\x1e\x34\x25\xd8\x20\x00\x00\x00\x00\x00\x00\x00\x00\x34\x25\x34\x25\x00\x00\x44\x23\x00\x00\x00\x00\x34\x25\x00\x00\x00\x00\x00\x00\xa8\x08\x38\x00\x00\x00\x00\x00\x00\x00\x7c\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x09\x00\x00\x00\x00\x00\x00\xe3\x28\xe6\x00\x9b\x18\x4d\x08\x9b\x08\x40\x08\x00\x00\x00\x00\x00\x00\x0c\x05\x00\x00\x32\x18\xb4\x2c\x8e\x08\x8e\x08\x18\x00\x8e\x08\x98\x08\x99\x2c\x99\x2c\x30\x2b\xc1\x2d\x93\x08\x12\x29\xd8\x26\x00\x00\x5f\x08\x00\x00\x00\x00\x00\x00\x00\x00\x34\x25\x8a\x08\x07\x02\x88\x08\x38\x00\x2b\x08\x00\x00\x34\x25\x00\x00\x34\x25\x86\x08\x82\x08\x64\x1f\x38\x00\x34\x25\x34\x25\x74\x08\xb8\x19\x00\x00\x76\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x2a\x00\x00\x00\x00\xd3\x17\xd3\x17\x00\x00\x00\x00\xd5\x1a\x00\x00\x00\x00\xd2\x03\x00\x00\x5d\x02\x00\x00\x00\x00\x00\x00\xfc\x2c\xd3\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xeb\x0e\x7d\x08\x6d\x08\x38\x00\x38\x00\x4e\x06\x27\x08\x00\x00\x00\x00\xd8\x26\x3a\x08\x58\x08\x56\x08\x53\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x14\x00\x00\x00\x00\x49\x08\x04\x08\xc9\x0c\x46\x08\x46\x08\x00\x00\x39\x08\x00\x00\x00\x00\xd5\x1a\x38\x08\x00\x00\x3c\x08\x00\x00\xa8\x29\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x29\x80\x2a\x00\x00\x00\x00\x00\x00\x45\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x1f\x00\x00\x00\x00\x00\x00\x34\x25\x00\x00\x00\x00\x00\x00\x00\x00\x44\x23\x00\x00\x00\x00\x26\x00\x02\x08\x00\x00\x26\x08\x00\x00\x72\x06\xf3\x05\xeb\x05\xe8\x05\xe7\x05\xe4\x05\xe3\x05\xd4\x05\xcc\x05\xcb\x05\xc8\x05\xc7\x05\xc4\x05\xc3\x05\xa9\x05\x83\x05\x5d\x05\x48\x05\xf8\x04\xdd\x04\xda\x04\x00\x00\xbb\x07\x00\x00\x21\x08\x29\x08\x00\x00\x21\x2a\xb8\x07\x3c\x00\x00\x00\x37\x08\x22\x08\x39\x00\x34\x00\x00\x00\x25\x08\x7e\x2c\x36\x00\x7e\x2c\xd3\x17\x7e\x2c\x7e\x2c\xa7\x2d\xad\x04\xa1\x03\x36\x08\x0d\x08\x59\x19\xd5\x1a\x8d\x03\xd3\x17\xa2\x07\xa1\x07\x9f\x07\x0c\x05\xd3\x17\xd3\x17\x07\x08\xc2\x04\xc2\x04\x59\x04\x59\x04\x7e\x2c\xd3\x17\xab\x06\xd3\x17\x57\x0d\x16\x08\xee\x07\xde\x02\x00\x00\x00\x00\x35\x00\x00\x00\xff\x07\x09\x08\x00\x00\x00\x00\x5c\x20\x06\x08\x38\x00\xf2\x07\xf4\x07\x00\x00\x00\x00\x00\x00\xc8\x22\x00\x00\x18\x03\x00\x00\x00\x00\xe9\x07\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\xd1\x02\x00\x00\x00\x00\xe5\x07\x00\x00\x00\x00\x00\x00\x44\x02\x00\x00\x34\x25\xee\x2b\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x16\x00\x16\x00\x00\x00\x00\x00\x00\x00\x20\x00\x03\x08\xe3\x28\x00\x00\xef\x07\xeb\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbd\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x25\xe0\x1f\x34\x25\xa6\x07\x30\x00\xe0\x1f\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x04\x97\x07\x34\x25\x4c\x22\x00\x00\xdf\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x26\x00\x00\x00\x00\x98\x06\x9c\x07\x7e\x07\x07\x2a\x8d\x07\x0a\x04\x80\x03\x00\x00\x6e\x07\xba\x07\x00\x00\x34\x25\x4c\x22\x5d\x07\x96\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x06\x5b\x07\x00\x00\xad\x07\xbc\x07\x00\x00\xaf\x07\x00\x00\xd3\x17\x00\x00\x00\x00\x00\x00\x57\x07\x00\x00\xe1\x0a\xa7\x07\x00\x00\x9d\x07\xd3\x17\xd0\x21\xd0\x21\xdb\x2d\xdb\x2d\x00\x00\x74\x17\x3d\x07\x3c\x07\x38\x07\x96\x07\x9b\x07\xa4\x07\x87\x07\x47\x07\x9e\x07\x00\x00\x51\x2c\x00\x00\x51\x2c\x00\x00\x00\x00\x00\x00\x95\x07\x8d\x2d\x8d\x2d\x00\x00\x00\x00\x00\x00\xe3\x28\x00\x00\x00\x00\xf8\x00\x07\x02\x8c\x07\x00\x00\x78\x07\x81\x07\x7c\x07\x86\x07\x00\x00\x00\x00\x07\x2a\x00\x00\x07\x2a\x00\x00\x00\x00\x34\x25\xb7\x06\x7f\x07\x54\x27\xf1\x0f\x7f\x07\x0a\x07\x09\x07\x1b\x07\x00\x00\x9e\x25\x00\x00\x55\x06\x00\x00\x00\x00\x79\x07\x6d\x07\x00\x00\x00\x00\x77\x07\x00\x00\x96\x06\x16\x2b\x73\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x07\x00\x00\x75\x07\x00\x00\x00\x00\x07\x2a\x00\x00\x7b\x07\x21\x07\x00\x00\x34\x25\x00\x00\x53\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x25\x5f\x2d\x15\x17\x64\x07\x00\x00\x15\x17\x00\x00\x00\x00\x00\x00\x00\x00\x59\x19\x00\x00\x00\x00\x00\x00\x00\x00\x04\x07\x00\x00\x00\x00\x02\x07\x15\x17\x49\x00\x00\x00\x61\x07\x00\x00\x00\x00\x00\x00\x6c\x25\x56\x07\x00\x00\x00\x00\x54\x07\x00\x00\x45\x07\x00\x00\x84\x07\x84\x01\xd4\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x07\xa0\x02\x00\x00\x00\x00\x00\x00\x45\x2d\x15\x17\x40\x07\x00\x00\x76\x1a\x00\x00\x00\x00\x07\x07\x42\x07\x00\x00\x60\x03\x01\x07\xe0\x06\x35\x07\x34\x07\xde\x02\x00\x00\x00\x00\xdc\x06\x2b\x07\x00\x00\x34\x25\xd0\x21\x26\x07\x00\x00\x34\x25\x34\x25\x34\x25\x00\x00\x33\x07\x00\x00\xdf\x06\xde\x06\xef\x03\x6d\x00\x00\x00\x00\x00\x10\x00\x96\x06\x00\x00\x00\x00\xda\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x06\x00\x00\x00\x00\x00\x00\x1d\x14\x00\x00\x00\x00\x00\x00\x3d\x2e\x57\x00\xbe\x13\x76\x1a\x00\x00\x00\x00\x20\x07\x1f\x07\x7e\x11\xcc\x06\x00\x00\x00\x00\x84\x01\x34\x25\x00\x00\x00\x00\x1e\x07\x11\x07\x17\x1a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x07\x00\x00\x0b\x07\x23\x2e\x00\x00\x59\x19\xa0\x06\xf4\x06\x00\x00\x00\x00\x8d\x06\x00\x07\x2b\x2d\x00\x00\xdb\x2d\xfa\x06\xd1\x06\x00\x00\x34\x25\xdd\x06\xef\x06\xf3\x06\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x2a\xf1\x06\xcd\x25\x00\x00\x8d\x04\x12\x29\x00\x00\x00\x00\x0b\x02\x00\x00\x00\x00\x00\x00\x00\x00\xec\x06\x00\x00\x07\x2a\xf6\x06\x00\x00\x12\x29\x34\x25\xc9\x06\x00\x00\x00\x00\x00\x00\x15\x17\x00\x00\x00\x00\xb6\x16\x00\x00\x00\x00\x00\x00\x17\x1a\x17\x1a\x6e\x0f\xe2\x06\x38\x00\xfc\x2c\x00\x00\x00\x00\xe5\x0d\xd9\x06\x38\x00\x00\x00\x17\x1a\x00\x00\x00\x00\x00\x00\xd6\x06\xa6\x2b\xfa\x18\x00\x00\x17\x1a\x17\x1a\xe6\x06\x00\x00\xd3\x02\xcd\x06\x38\x00\xc6\x06\xd0\x06\x00\x00\x00\x00\x34\x25\x00\x00\x00\x00\x00\x00\xcf\x06\x00\x00\x2b\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x06\x00\x00\x17\x1a\xb8\x19\x30\x03\xec\x02\x00\x00\x00\x00\xc5\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x16\xf7\x10\xf8\x15\xf9\x2a\x00\x00\x00\x00\x99\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x1a\xbc\x03\x00\x00\xb9\x06\x66\x00\xeb\x0e\xc2\x06\x38\x00\x00\x00\x00\x00\x99\x15\x00\x00\x9a\x06\x4f\x06\x00\x00\x00\x00\x00\x00\x51\x2c\x8e\x06\x00\x00\x00\x00\x34\x25\x00\x00\xb8\x06\x00\x00\x00\x00\x00\x00\x17\x1a\x99\x15\x00\x00\x9f\x06\x74\x10\xac\x06\x8c\x06\x9b\x06\x84\x06\x90\x06\x17\x1a\x00\x00\x7b\x13\x90\x06\x68\x0e\x91\x06\x00\x00\x36\x2c\x99\x15\x5f\x13\x12\x03\x91\x06\x8f\x06\x82\x06\x00\x00\x00\x00\x00\x00\x80\x06\xe1\x2c\x51\x02\x00\x00\x00\x00\x9a\x2a\x75\x06\x5a\x26\x00\x00\x00\x00\x00\x00\x36\x2c\x00\x00\x00\x00\x00\x00\x00\x00\x99\x15\x5c\x06\x00\x00\x99\x15\x20\x06\xfb\x05\x00\x00\x99\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x06\x00\x00\x00\x00\x99\x15\x00\x00\xe4\x02\x00\x00\x00\x00\x44\x01\x00\x00\x4c\x06\x00\x00\x00\x00\x2f\x06\x00\x00\x00\x00\x99\x15\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x02\x00\x15\x35\xb8\x39\x0b\x00\xe5\x08\x57\x31\x44\x06\x03\x00\xfd\xff\xff\xff\xfe\xff\x01\x00\x5f\x04\x94\x06\x00\x00\x00\x00\x49\x06\x00\x00\x3d\x06\x00\x00\x00\x00\x00\x00\x0e\x06\x00\x00\x00\x00\x00\x00\x00\x00\xff\x11\x00\x00\x00\x00\x00\x00\x05\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x35\x01\x36\xe1\x35\x88\x35\x00\x00\x48\x2b\xc9\x40\x82\x3e\xb3\x40\x66\x39\x00\x00\xfd\x34\xab\x34\x30\x3e\xd7\x08\x52\x05\x39\x03\x6e\x01\x00\x00\xe4\x04\xc8\x3d\x85\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x3d\x87\xff\x00\x00\x00\x00\x00\x00\xa9\x31\xfc\xff\x7a\xff\xd4\x3e\x62\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x0a\x00\x00\x00\x00\xdf\x0a\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x05\x58\x06\x10\x06\x0c\x0b\x00\x00\x00\x00\x00\x00\x93\x34\xab\x02\x00\x00\x00\x00\x00\x00\xd2\x05\x00\x00\x00\x00\x74\x05\x5b\x05\x00\x00\x00\x00\xf3\xff\x00\x00\x00\x00\x00\x00\x78\x03\x00\x00\x00\x00\x08\x00\x8b\x04\x78\x06\x2c\x05\x00\x00\x00\x00\x0f\x00\x07\x00\x00\x00\x00\x00\x77\x00\x29\x05\x00\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x05\xbc\x08\x00\x00\x00\x00\x00\x00\xa6\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x08\x00\x00\x00\x00\x00\x00\x90\x08\x00\x00\x00\x00\x23\x08\x00\x00\x00\x00\x69\x01\xd6\x0a\x50\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x30\xb9\x30\x00\x00\x00\x00\x77\x40\x00\x00\x00\x00\x62\x05\x00\x00\x11\x00\x0c\x00\x00\x00\x00\x00\xbd\x02\x00\x00\x36\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x00\x3c\x05\x00\x00\x00\x00\x00\x00\xd9\x04\x75\x01\x00\x00\x00\x00\x94\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x40\x00\x00\xbe\x3e\x00\x00\x76\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x3d\x00\x00\x00\x00\x00\x00\x02\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x37\x07\x03\x00\x00\x00\x00\x66\x37\xf5\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x3e\x25\x40\x0f\x40\x41\x34\x74\x02\x00\x00\x00\x00\x00\x00\x1a\x3e\x00\x00\xd5\x03\x78\x08\x60\x3d\x0e\x3d\xf8\x3c\xa6\x3c\xce\x05\x00\x00\xd7\x00\x00\x00\xd4\x04\xd3\x04\x85\x06\x83\x06\xea\x01\x46\x02\x00\x00\x28\x04\x00\x00\xd3\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x02\xbd\x3f\xf4\x04\x71\x06\xe1\x04\x00\x00\x77\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x06\x00\x00\x5f\x06\x00\x00\x9b\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x37\x00\x00\x00\x00\x7d\x02\x00\x00\x00\x00\x50\x39\xfe\x38\xef\x36\x00\x00\x00\x00\x4c\x02\x00\x00\xd1\x36\x00\x00\x78\x36\x90\x3c\x8d\x2e\x00\x00\x00\x00\x00\x00\x5a\x36\x3e\x3c\x3b\x2e\x00\x00\x31\x00\x1b\x00\x00\x00\x28\x3c\xd6\x3b\x00\x00\x67\x30\x00\x00\x00\x00\x1a\x3e\x00\x00\x00\x00\x00\x00\x66\x05\x99\x04\x43\x06\x00\x00\x00\x00\x47\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7d\x0e\x00\x00\x00\x00\x00\x00\x81\x3f\x00\x00\x2b\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x05\x00\x00\xfd\x05\x6f\x01\x31\x05\x2d\x05\x24\x05\x0a\x05\x04\x06\x1c\x02\xd1\x01\x3d\x02\x2a\x00\x00\x00\x9f\x05\x2f\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x38\x6b\xff\xeb\x00\x00\x00\x54\x04\x00\x00\x00\x00\xc0\x3b\x00\x00\x6e\x3b\x00\x00\x34\x04\x4f\x30\x4d\x04\x58\x3b\x06\x3b\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x11\x00\x00\x00\x00\x18\x0a\x06\x0a\x00\x00\x00\x00\x39\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x01\xf8\x09\x00\x00\x37\x06\x33\x06\x00\x00\x00\x00\x00\x00\x00\x00\x92\x02\x00\x00\x00\x00\x25\x04\x1d\x04\xe6\x04\x00\x00\x2c\x04\x00\x00\x19\x3f\xca\x04\x07\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\x05\x00\x00\x32\x0b\xbf\x05\x00\x00\x00\x00\x00\x00\xf6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x03\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x04\x3b\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x2f\x00\x00\x00\x00\x00\x00\xf0\x3a\x00\x00\x00\x00\x00\x00\x93\x05\xd5\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x04\x87\x03\x00\x00\xd2\x02\xe6\x09\xc0\x02\x08\x02\xe9\x01\x61\x04\x00\x00\xde\x03\x00\x00\x77\x0a\x4d\x05\x1c\x00\xcb\x09\x00\x00\x00\x00\x00\x00\x82\x04\xf0\x03\x9c\x09\x23\x04\x42\x04\x3e\x04\xa1\x04\x7d\x04\xfc\x00\x2d\x08\xa7\x01\x12\x08\xf2\x01\x00\x00\x00\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\xff\x00\x00\x00\x00\x18\x38\x00\x00\x86\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x34\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x00\x00\x9e\x3a\x59\x02\x00\x00\x00\x00\x00\x00\x47\x04\x00\x00\x1b\x05\xa5\x04\x00\x00\x00\x00\x00\x00\x00\x00\x85\x03\x6b\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x05\xdf\x04\x53\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x3a\xdf\x2e\x36\x3a\x00\x00\x00\x00\x31\x2f\x00\x00\x00\x00\xce\x04\x00\x00\x3a\x04\x00\x00\xd7\x33\x2f\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x02\x00\x00\x00\x00\x51\x01\xc6\x03\xd8\x03\xea\x10\x0e\x04\x00\x00\x00\x00\x00\x00\xac\x03\x97\x03\x00\x00\xbf\x33\x83\x2f\xa5\x03\xe8\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\xff\x9c\x03\x06\x01\x99\x03\x00\x00\x00\x00\x00\x00\x00\x00\x51\x09\x00\x00\x00\x00\x00\x00\x8f\x03\xe1\x03\x91\x04\x00\x00\x00\x00\x81\x03\xfe\x07\x96\x38\x80\x38\x70\x03\xd6\x01\x00\x00\x36\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x03\xb1\x03\x00\x00\xa7\x02\x00\x00\xa0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x46\x00\xcf\xff\x00\x00\x56\x03\x00\x00\xf4\x17\x00\x00\x00\x00\x00\x00\x23\x03\x52\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x12\x00\x00\x4e\x0b\x00\x00\x00\x00\x6d\x33\x26\x01\x00\x00\x6c\x3e\x9b\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\xff\x00\x00\x00\x00\x26\x03\x00\x00\x00\x00\xc1\x03\x00\x00\x00\x00\x00\x00\x00\x00\xd6\x02\x04\x00\x2b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\x08\x00\x00\x00\x00\x00\x00\x00\x00\x55\x33\x00\x00\x9c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x2d\x03\x01\x44\x04\x00\x00\x00\x00\x36\x04\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x0a\x00\x00\x5d\x03\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x76\x03\xe3\x07\x6c\x03\x00\x00\x80\x02\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x00\x00\x00\x00\x76\x02\x00\x00\x00\x00\x00\x00\xad\xff\xbb\x03\xcb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\xff\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x01\xcf\x07\x00\x00\x00\x00\x1c\x0b\xf2\x02\x00\x00\xcb\x02\x4f\x02\x00\x00\xa1\x00\xb7\x02\x9b\x02\x00\x00\x00\x00\x20\x03\x00\x00\x00\x00\x70\x02\xec\x01\x00\x00\x03\x33\x2e\x38\x00\x00\x00\x00\xeb\x32\x99\x32\x81\x32\x00\x00\x00\x00\x00\x00\xa1\x02\x89\x02\x00\x00\xa8\x01\x00\x00\x00\x00\x57\x04\x8c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x01\x00\x00\x00\x00\x00\x00\xc9\x05\x44\x00\x33\x00\x00\x00\xaf\xff\x10\x01\x04\x04\x3e\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x57\x05\x35\x04\x00\x00\x00\x00\xad\x03\x2f\x32\x00\x00\x00\x00\x00\x00\x00\x00\x03\x05\x50\x00\x37\x00\x5e\x01\x00\x00\x8b\x03\x21\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\xff\x00\x00\x40\x01\xaf\xff\x00\x00\xb3\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x7d\x01\x00\x00\x00\x00\x00\x00\x20\x3a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x02\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x00\x00\x00\x22\x00\x00\x00\x56\x01\xae\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x04\x00\x00\x00\x00\x77\x03\x17\x32\x00\x00\x00\x00\x00\x00\x00\x00\x5e\x03\x00\x00\x00\x00\x22\x09\x42\x00\x3f\x00\x00\x00\x1a\x01\x64\x00\x20\x04\x00\x00\x1b\x01\x73\x00\x00\x00\x00\x00\x6e\x02\x00\x00\xf3\x00\x00\x00\xef\x04\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x00\x04\x04\x00\x00\x1f\x02\x23\x01\x52\x00\x00\x00\xc3\x01\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x31\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x03\x00\x00\x00\x00\x00\x00\x04\x04\x04\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x03\x00\x00\x00\x00\x07\x09\xba\x04\x70\x04\x00\x00\x00\x00\x00\x00\xc1\x07\x00\x00\x00\x00\xce\x02\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x01\x00\x00\x00\x00\x00\x00\x99\x00\x32\x03\x00\x00\x85\x00\x00\x00\x00\x00\x98\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\xce\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x01\x69\x07\x00\x00\x00\x00\x9f\x04\x00\x00\xda\x00\x00\x00\x00\x00\x8f\x00\x62\x01\x00\x00\x83\x0f\x3b\x00\x0e\x03\x00\x00\x00\x00\xd5\x00\x1c\x07\x08\x07\xa5\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x00\x8b\xff\x00\x00\x00\x00\x5b\x00\x00\x00\xe8\xff\x00\x00\x00\x00\x00\x00\xe5\xff\x00\x00\x00\x00\x00\x00\x00\x00\xed\x06\x00\x00\x00\x00\xc3\x06\x68\x00\x19\x00\x00\x00\xb5\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\xff\x00\x00\x00\x00\xa2\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x06\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x4e\xfd\x00\x00\x00\x00\x4e\xfd\x00\x00\x00\x00\x00\x00\x4e\xfd\x4e\xfd\x4e\xfd\x4e\xfd\x00\x00\x00\x00\xea\xff\x2c\xfd\x00\x00\xe2\xff\x00\x00\xe2\xff\x00\x00\x00\x00\x00\x00\xbf\xff\xaf\xfd\x86\xfe\x84\xfe\x7e\xfe\x7d\xfe\x7b\xfe\x79\xfe\x73\xfe\x69\xfe\x64\xfe\x5c\xfe\x59\xfe\x46\xfe\x00\x00\x00\x00\x56\xfe\x57\xfe\x58\xfe\x9f\xfd\x9a\xfd\x72\xfd\x81\xfd\x98\xfd\x95\xfd\x69\xfd\x55\xfe\x7f\xfd\x80\xfd\x6b\xfd\x6a\xfd\x67\xfd\x68\xfd\x58\xfd\x56\xfd\x57\xfd\x55\xfd\x54\xfd\x53\xfd\x52\xfd\x51\xfd\x50\xfd\x4f\xfd\x00\x00\x00\x00\x00\x00\xd0\xfd\x4a\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x4e\xfd\x00\x00\x00\x00\x3b\xfe\x00\x00\x00\x00\x26\xfe\x7b\xfd\x71\xfd\x70\xfd\x6e\xfd\x6f\xfd\x7a\xfd\x79\xfd\x78\xfd\x77\xfd\x76\xfd\x75\xfd\x74\xfd\x73\xfd\x7e\xfd\x00\x00\x4e\xfd\x6c\xfd\x6d\xfd\x7c\xfd\x4e\xfd\x4e\xfd\x4e\xfd\x00\x00\x4e\xfd\x7d\xfd\x00\x00\x00\x00\x00\x00\x17\xff\xed\xfe\x1e\xff\x14\xff\x07\xff\x00\x00\x13\xff\xfb\xfe\x00\x00\xf0\xfe\x00\x00\x00\x00\x37\xfd\xf4\xfe\x12\xff\x38\xfd\xff\xfe\xfe\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x08\xff\xfd\xfe\x09\xff\x00\x00\x00\x00\x36\xfd\x35\xfd\x34\xfd\xe6\xfe\x00\x00\x00\x00\xd6\xff\xd6\xff\xbf\xfd\x00\x00\x4e\xfd\x00\x00\x86\xfe\x00\x00\xe2\xff\xf1\xff\xef\xff\x4e\xfd\x00\x00\xe2\xff\x00\x00\x4d\xff\x00\x00\xd6\xff\xd6\xff\x00\x00\xd7\xff\xd9\xff\x00\x00\x00\x00\x00\x00\x39\xfd\x01\xff\x82\xfd\x66\xfd\x00\xff\x64\xfd\x65\xfd\x00\x00\x00\x00\x83\xfd\x00\x00\x00\x00\x1e\xff\xed\xfe\xe9\xfe\x00\x00\x00\x00\xf8\xfe\x00\x00\x00\x00\xf6\xfe\x39\xfe\xe9\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x63\xfd\x5f\xfd\x62\xfd\x5d\xfd\x59\xfd\xfa\xfe\x5b\xfd\x00\x00\x5e\xfd\xfd\xfe\x5a\xfd\x00\x00\xee\xfe\x11\xff\x15\xff\x00\x00\xf1\xfe\x8b\xfd\x00\x00\x32\xfd\x31\xfd\x00\x00\x00\x00\x00\x00\xec\xfe\x30\xfd\x00\x00\x00\x00\x00\x00\xae\xfd\xb4\xfd\xb4\xfd\x00\x00\x61\xfe\x00\x00\x6a\xfe\xb1\xfd\x71\xfe\x75\xfe\xd6\xff\xd6\xff\x6b\xfe\x00\x00\x6f\xfe\x00\x00\xed\xfd\x21\xfe\x1d\xfe\x20\xfe\x1f\xfe\x1e\xfe\x19\xfe\x18\xfe\x17\xfe\x16\xfe\x14\xfe\x15\xfe\x13\xfe\x12\xfe\x11\xfe\x10\xfe\x0f\xfe\x0e\xfe\x0d\xfe\x0c\xfe\x0b\xfe\x0a\xfe\x09\xfe\x1b\xfe\x1a\xfe\x08\xfe\x07\xfe\x06\xfe\x05\xfe\x04\xfe\x03\xfe\x02\xfe\x01\xfe\x00\xfe\xff\xfd\xfe\xfd\xfd\xfd\xfc\xfd\xfb\xfd\xfa\xfd\xf9\xfd\xf8\xfd\xf7\xfd\xf6\xfd\xf5\xfd\xf4\xfd\xf3\xfd\xf2\xfd\x1c\xfe\xf1\xfd\xf0\xfd\xef\xfd\x3c\xfe\x3d\xfe\x00\x00\x00\x00\x00\x00\x3f\xfe\x3e\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x7d\xfe\x00\x00\x00\x00\x2e\xfe\x00\x00\xbe\xfd\x6c\xfe\x5d\xfe\x00\x00\x62\xfe\x4e\xfd\x38\xfe\xcf\xfd\xce\xfd\x00\x00\x85\xfd\x84\xfd\x00\x00\x8f\xfd\x61\xfd\x60\xfd\x00\x00\x5c\xfd\xe9\xfd\x00\x00\xe8\xfd\xa3\xfd\x00\x00\x00\x00\xa1\xfd\x38\xfe\x00\x00\x00\x00\x00\x00\x8b\xfd\x00\x00\x61\xfd\x60\xfd\xa4\xfd\x5e\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x65\xfe\x87\xfd\x86\xfd\x83\xfe\x91\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbd\xff\x00\x00\x29\xfd\x2b\xfd\x00\x00\x00\x00\xd6\xff\xd6\xff\xd6\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\xff\x24\xff\x9e\xfd\x97\xfd\x00\x00\x00\x00\x00\x00\xd6\xff\x00\x00\x00\x00\xea\xff\xec\xff\x4c\xfd\x4d\xfd\x2d\xfd\x3c\xfd\x3b\xfd\xd6\xff\x2a\xfd\xd6\xff\xc0\xff\xbb\xff\xbe\xff\x7f\xfe\x80\xfe\x81\xfe\x82\xfe\x85\xfe\x00\x00\x00\x00\x7c\xfe\x7a\xfe\x00\x00\xac\xfd\xa9\xfd\x00\x00\x5b\xfe\xab\xfd\xb0\xfd\x5e\xfe\x5f\xfe\x99\xfd\x94\xfd\x49\xfe\x00\x00\x53\xfe\x54\xfe\x00\x00\xa2\xfd\x3a\xfe\x00\x00\x00\x00\x00\x00\x50\xfe\x4f\xfe\x00\x00\xa0\xfd\x00\x00\x4c\xfe\x00\x00\xe7\xfd\x00\x00\x00\x00\x37\xfe\x4b\xfe\x00\x00\x00\x00\x00\x00\x6d\xfe\xd6\xff\xd6\xff\x63\xfe\x00\x00\x00\x00\x48\xfe\x00\x00\x44\xfe\x43\xfe\x00\x00\x42\xfe\x41\xfe\x68\xff\xa2\xff\x00\x00\xd6\xff\x99\xff\x98\xff\x00\x00\x84\xff\x69\xff\x62\xff\x61\xff\x67\xff\x8b\xff\x7d\xfe\x66\xff\x4b\xfd\x65\xff\x00\x00\x00\x00\x00\x00\x72\xff\x00\x00\x00\x00\xa0\xff\x9f\xff\x9e\xff\x7b\xff\x71\xff\x00\x00\x00\x00\x34\xff\x34\xff\x34\xff\x34\xff\x36\xff\x28\xff\x28\xff\x00\x00\x54\xff\x00\x00\x00\x00\xea\xfd\x29\xfe\x00\x00\x23\xfe\x27\xfe\x70\xfe\x25\xfe\x00\x00\x4e\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x72\xfe\x00\x00\x60\xfe\x00\x00\x00\x00\xb2\xfd\xb4\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x1a\xff\x1b\xff\x00\x00\x1c\xff\x1d\xff\x18\xff\xf9\xfe\xf2\xfe\xf3\xfe\xf7\xfe\x10\xff\x0c\xff\x00\x00\xf5\xfe\x0f\xff\x00\x00\x00\x00\x04\xff\x0e\xff\x00\x00\x0d\xff\x0a\xff\x00\x00\x05\xff\x00\x00\x02\xff\xe7\xfe\xe5\xfe\x00\x00\x00\x00\xfc\xfe\xd6\xff\xd6\xff\xc2\xff\xdb\xff\xd8\xff\xde\xff\x6c\xff\x00\x00\x00\x00\x00\x00\x00\x00\xdf\xff\x00\x00\xed\xfd\xe4\xff\xea\xfd\x00\x00\xd4\xff\x00\x00\x00\x00\x4b\xff\x63\xff\x4c\xff\x64\xff\xd6\xff\x6a\xff\x8c\xfe\xd6\xff\xa6\xfd\x58\xfe\x00\x00\xd7\xff\xda\xff\xdd\xff\xef\xfe\x00\x00\x03\xff\x06\xff\x1a\xff\xea\xfe\xe8\xfe\x00\x00\xbe\xfe\xbd\xfe\xbb\xfe\xb7\xfe\xb6\xfe\xb5\xfe\x00\x00\x00\x00\xb9\xfe\x33\xfd\xeb\xfe\x00\x00\x67\xfe\x68\xfe\xb7\xfd\xb5\xfd\xb6\xfd\xb4\xfd\xb8\xfd\x74\xfe\x77\xfe\x00\x00\xbc\xfd\xbd\xfd\xb9\xfd\xd6\xff\x00\x00\x6e\xfe\x2e\xfe\x00\x00\x00\x00\xeb\xfd\x00\x00\xee\xfd\x00\x00\x7f\xfd\x67\xfd\x7b\xfd\x71\xfd\x70\xfd\x6e\xfd\x6f\xfd\x7a\xfd\x79\xfd\x78\xfd\x77\xfd\x76\xfd\x75\xfd\x74\xfd\x73\xfd\x7e\xfd\x6c\xfd\x6d\xfd\x7c\xfd\x7d\xfd\x22\xfe\x00\x00\x55\xff\x53\xff\x51\xff\x4e\xff\x00\x00\x00\x00\x00\x00\x29\xff\x00\x00\x26\xff\x00\x00\x00\x00\x37\xff\x34\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\xff\x6e\xff\x00\x00\xe0\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\xfe\x00\x00\xd7\xff\x9b\xff\x00\x00\x00\x00\xa1\xff\xd2\xfd\x00\x00\xd4\xfd\x00\x00\x4e\xfd\x2f\xfe\x78\xfe\x00\x00\x00\x00\x00\x00\xcb\xfd\xdf\xfd\xdd\xfd\xdc\xfd\xdb\xfd\x00\x00\xcd\xfd\x38\xfe\xe1\xfd\x8e\xfd\xe3\xfd\xe5\xfd\x38\xfe\xe2\xfd\x4d\xfe\x4e\xfe\x00\x00\x30\xfe\x36\xfe\x2c\xfe\x2d\xfe\x51\xfe\x52\xfe\x00\x00\x33\xfe\x00\x00\x00\x00\x5a\xfe\x8a\xfd\x90\xfd\xb9\xff\xbc\xff\x00\x00\x00\x00\xeb\xff\xe8\xff\xe5\xff\x00\x00\x00\x00\x00\x00\x21\xff\x00\x00\x00\x00\xe7\xff\x20\xff\x9d\xfd\x96\xfd\x22\xff\xe6\xff\xe9\xff\xd6\xff\xd6\xff\x00\x00\xba\xff\xad\xfd\xaa\xfd\x35\xfe\x34\xfe\x32\xfe\x31\xfe\xe6\xfd\x00\x00\x00\x00\xda\xfd\x00\x00\x00\x00\xc9\xfd\xca\xfd\xd6\xff\xc6\xfd\x00\x00\xd1\xfd\x00\x00\x00\x00\x47\xfe\xa3\xff\x89\xfd\x88\xfd\x9c\xff\x8d\xfd\x93\xfd\x00\x00\x40\xfe\x9a\xff\xaf\xfe\xc4\xfe\xd9\xfe\x00\x00\xcd\xfe\x60\xff\x00\x00\x49\xff\x8e\xfe\x8a\xfe\x88\xfe\x00\x00\x00\x00\x8e\xfe\x3c\xff\x48\xff\x47\xff\x46\xff\x45\xff\x44\xff\x43\xff\x42\xff\x41\xff\x00\x00\xab\xfe\xe2\xfe\xaf\xfe\x00\x00\x6f\xff\x19\xff\x70\xff\x00\x00\x7d\xff\x7e\xff\x7c\xff\x9d\xfe\x82\xff\x00\x00\x00\x00\x1f\xff\xaf\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x45\xfd\x47\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\xff\x38\xff\x88\xff\x2a\xff\x87\xff\x00\x00\x27\xff\x86\xff\x85\xff\x00\x00\x00\x00\x00\x00\x59\xff\x26\xfe\x2a\xfe\x00\x00\x28\xfe\x24\xfe\x00\x00\xbb\xfd\x71\xfe\xb3\xfd\x00\x00\x00\x00\x00\x00\xbe\xfe\xb4\xfe\xba\xfe\x00\x00\x0b\xff\x00\x00\xc3\xff\xdc\xff\x00\x00\xd7\xff\xa8\xfd\x00\x00\xd7\xff\x6d\xff\x00\x00\x00\x00\x00\x00\xd5\xff\xd0\xff\xf0\xff\x00\x00\x26\xfe\xed\xff\x00\x00\xd0\xff\xce\xff\xcd\xff\xcb\xff\xd1\xff\x00\x00\x00\x00\x00\x00\xe3\xff\xe1\xff\xe0\xff\x6b\xff\xa7\xfd\x00\x00\xa5\xfd\x00\x00\xbc\xfe\xb8\xfe\x00\x00\xb2\xfe\x00\x00\x00\x00\xba\xfd\x00\x00\xec\xfd\x6f\xfe\x52\xff\x50\xff\x4f\xff\x25\xff\x2b\xff\x39\xff\x00\x00\x00\x00\x00\x00\x00\x00\x33\xff\x00\x00\x5a\xff\x5d\xff\x5e\xff\x3d\xfd\x00\x00\x41\xfd\xe6\xfe\x44\xfd\x46\xfd\x49\xfd\x4a\xfd\x97\xff\x7a\xff\x00\x00\x83\xff\x8e\xff\x4e\xfd\x8d\xff\x8c\xff\x92\xff\x00\x00\xdf\xfe\xdd\xfe\x8f\xff\x4e\xfd\x89\xff\x00\x00\x9c\xfd\x00\x00\x00\x00\x00\x00\x40\xff\x3f\xff\x3e\xff\x3d\xff\x90\xfe\x4e\xfd\x00\x00\x8b\xfe\x89\xfe\x91\xfe\x00\x00\x00\x00\xd3\xfe\xd1\xfe\x00\x00\xe6\xfe\xae\xfe\xc4\xfe\x4e\xfd\x94\xff\x00\x00\xc4\xfe\xd9\xfe\x00\x00\x00\x00\x00\x00\xd5\xfd\xd3\xfd\x8e\xfe\xc3\xfd\xc1\xfd\x00\x00\xd7\xff\xc8\xfd\xde\xfd\x00\x00\x00\x00\x00\x00\xcc\xfd\xe0\xfd\xe4\xfd\xb7\xff\xd7\xff\x00\x00\x00\x00\x2e\xfd\x2f\xfd\xb5\xff\x00\x00\xd9\xfd\xd7\xfd\xd8\xfd\xc7\xfd\xc4\xfd\xc2\xfd\xc5\xfd\x9d\xff\x8c\xfd\x92\xfd\xc4\xfe\x91\xff\xc3\xfe\xbf\xfe\x00\x00\xd6\xff\xd6\xff\x93\xff\x00\x00\x00\x00\xc8\xfe\x00\x00\xcf\xfe\xcc\xfe\x00\x00\xf4\xfe\x00\x00\xcd\xfe\x5f\xff\x4a\xff\x00\x00\x00\x00\x8f\xfe\x8a\xff\x00\x00\x00\x00\x00\x00\xd6\xff\xd6\xff\xe2\xfe\xe3\xfe\xe2\xfe\xd6\xff\xd6\xff\x81\xff\x80\xff\x7f\xff\x95\xff\x96\xff\x4e\xfd\x48\xfd\x4e\xfd\x00\x00\x3e\xfd\x00\x00\x00\x00\x58\xff\x56\xff\x32\xff\x00\x00\x00\x00\x2f\xff\x2d\xff\x00\x00\x00\x00\x00\x00\xc0\xfd\x00\x00\x00\x00\xb1\xfe\x00\x00\xe4\xfe\xc6\xff\x00\x00\xcc\xff\xc5\xff\xc4\xff\xc7\xff\x00\x00\x00\x00\xd1\xff\xd2\xff\x00\x00\x00\x00\xcf\xff\xd3\xff\x00\x00\xa6\xff\xa5\xff\xa4\xff\xc9\xff\x00\x00\xb3\xfe\x00\x00\x00\x00\x76\xfe\x00\x00\x00\x00\x00\x00\x2e\xff\x30\xff\x5b\xff\x00\x00\x5c\xff\x3f\xfd\x00\x00\xd6\xff\xd6\xff\x79\xff\x00\x00\x00\x00\x9b\xfe\x00\x00\x00\x00\x00\x00\xdc\xfe\xde\xfe\xa9\xfe\x00\x00\x00\x00\x3a\xff\x00\x00\x9b\xfd\x87\xfe\xd2\xfe\x00\x00\x00\x00\xc8\xfe\xd0\xfe\x00\x00\x00\x00\x00\x00\xce\xfe\x00\x00\x00\x00\x00\x00\xc0\xfe\x00\x00\xc2\xfe\x90\xff\x00\x00\xb8\xff\xc1\xff\xb6\xff\x00\x00\xb2\xff\xd0\xff\xd6\xfd\xc1\xfe\xda\xfe\xdb\xfe\xd6\xff\xd6\xfe\x00\x00\xcb\xfe\x16\xff\x00\x00\x00\x00\x00\x00\xc6\xfe\xca\xfe\xf3\xfe\x3b\xff\xac\xfe\xad\xfe\xa6\xfe\xd6\xff\xa7\xfe\xa5\xfe\x00\x00\x00\x00\x00\x00\xe1\xfe\x9e\xfe\x9f\xfe\x00\x00\x95\xfe\x96\xfe\xd6\xff\x99\xfe\x97\xfe\x98\xfe\x72\xff\x00\x00\x00\x00\x74\xff\x00\x00\x00\x00\x6c\xff\x00\x00\x00\x00\x40\xfd\x57\xff\x00\x00\x35\xff\x00\x00\x00\x00\xb0\xfe\xca\xff\xc8\xff\x00\x00\x00\x00\xee\xff\xa7\xff\x00\x00\x2b\xfe\x00\x00\x42\xfd\x43\xfd\x77\xff\x75\xff\x00\x00\x78\xff\x00\x00\xd7\xff\x9c\xfe\xaf\xfe\x00\x00\x17\xff\xaf\xfe\x00\x00\xa4\xfe\x00\x00\xaf\xfe\xd7\xff\xaa\xfe\xc9\xfe\x00\x00\x00\x00\x00\x00\xd7\xff\xd8\xfe\x00\x00\xd0\xff\xaf\xff\xae\xff\x3a\xfd\xab\xff\x00\x00\x00\x00\xac\xff\xad\xff\x00\x00\x00\x00\xd1\xff\xb3\xff\xd7\xfe\xd5\xfe\x00\x00\xc5\xfe\xc7\xfe\xa8\xfe\xa0\xfe\x00\x00\x00\x00\xa3\xfe\x00\x00\xc4\xfe\xd9\xfe\x9a\xfe\x00\x00\x73\xff\x76\xff\x2c\xff\x66\xfe\x94\xfe\xc4\xfe\x93\xfe\xa2\xfe\x00\x00\x60\xff\x00\x00\xb0\xff\xb4\xff\x00\x00\xa9\xff\x00\x00\xaa\xff\xa8\xff\x00\x00\xa1\xfe\x92\xfe\x00\x00\xd4\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x04\x00\x04\x00\x04\x00\x02\x00\x04\x00\x04\x00\x04\x00\x20\x00\x2f\x00\x11\x00\x12\x00\x13\x00\x3e\x00\x3f\x00\x40\x00\x45\x00\x45\x00\x63\x00\x0b\x00\x0d\x00\x0e\x00\x0b\x00\x37\x00\x14\x00\x0d\x00\x0e\x00\x37\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x1a\x00\x41\x00\xb7\x00\x11\x00\xc2\x00\x41\x00\x16\x00\x42\x00\x0d\x00\x0e\x00\x37\x00\x0d\x00\x0e\x00\xb7\x00\x0d\x00\x0e\x00\x1a\x00\x1f\x00\x20\x00\x37\x00\x41\x00\x13\x00\x1e\x00\x46\x00\x00\x00\x48\x00\x1a\x00\x34\x00\xc2\x00\x41\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x0c\x00\x34\x00\x0d\x00\x0e\x00\x1a\x00\x1b\x00\x22\x00\xc2\x00\x01\x00\xe9\x00\x0d\x00\x0e\x00\x1a\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x1a\x00\xe9\x00\x1d\x00\x1a\x00\x22\x00\x73\x00\x74\x00\x09\x00\xd0\x00\x0b\x00\x0d\x00\x0e\x00\xe9\x00\x09\x00\x75\x00\x1a\x00\xe9\x00\x73\x00\x2f\x00\x00\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xe0\x00\x23\x00\x00\x00\x39\x00\x05\x00\xe9\x00\x4a\x00\x4b\x00\x34\x00\x4e\x00\x26\x00\x34\x00\x5b\x00\x27\x00\x69\x00\xcd\x00\x24\x00\x21\x00\x22\x00\x21\x00\x22\x00\x1a\x00\x6b\x00\x69\x00\x1d\x00\x1a\x00\x3f\x00\x40\x00\x1a\x00\x70\x00\xdc\x00\x1d\x00\xdc\x00\x15\x00\x16\x00\x5e\x00\x26\x00\x11\x00\x8b\x00\x8c\x00\x8d\x00\x30\x00\x31\x00\x2d\x00\x6b\x00\xcd\x00\xcd\x00\x23\x00\xcc\x00\x25\x00\x6a\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x22\x00\x85\x00\xf5\x00\xf6\x00\x85\x00\xdc\x00\xdc\x00\x32\x00\x7a\x00\xdc\x00\xdd\x00\x36\x00\x6a\x00\x38\x00\x39\x00\x3a\x00\x92\x00\xce\x00\xcc\x00\x51\x00\x52\x00\x80\x00\xd0\x00\x7e\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xdb\x00\xdc\x00\xdd\x00\xe9\x00\xdc\x00\xdd\x00\x92\x00\xce\x00\xe0\x00\xe9\x00\xd1\x00\x92\x00\xc0\x00\xe9\x00\x92\x00\xc8\x00\x80\x00\xc0\x00\xce\x00\xb8\x00\xdb\x00\xdc\x00\xdd\x00\xc8\x00\xdf\x00\xe0\x00\x92\x00\xf3\x00\xe9\x00\x75\x00\xcc\x00\xdb\x00\xdc\x00\xdd\x00\xd0\x00\xdf\x00\xe0\x00\xe9\x00\xe9\x00\xe9\x00\xe9\x00\xb8\x00\xe9\x00\xe9\x00\xe9\x00\xf4\x00\xdc\x00\xdd\x00\xce\x00\xe9\x00\xe0\x00\xd1\x00\xe9\x00\x9f\x00\xcc\x00\xa1\x00\xfa\x00\xfc\x00\xfb\x00\xdf\x00\xe0\x00\xdb\x00\xdc\x00\xdd\x00\x89\x00\xdf\x00\xe0\x00\xdc\x00\xdd\x00\xf3\x00\xdc\x00\xdd\x00\x91\x00\x92\x00\x93\x00\x94\x00\x16\x00\x7e\x00\x97\x00\x98\x00\x99\x00\x6c\x00\xcc\x00\x9c\x00\x9d\x00\x9e\x00\xf4\x00\x42\x00\x77\x00\x23\x00\x22\x00\x25\x00\xa5\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xd2\x00\xdc\x00\xdd\x00\xd5\x00\x2d\x00\xd7\x00\xcc\x00\x32\x00\xcc\x00\x22\x00\xd0\x00\x36\x00\xd0\x00\x38\x00\x39\x00\x3a\x00\xe2\x00\xe0\x00\x42\x00\xe5\x00\xe6\x00\x50\x00\xdc\x00\xdd\x00\xdc\x00\xdd\x00\xe0\x00\x9f\x00\xe0\x00\x42\x00\xa2\x00\xdc\x00\x39\x00\xcb\x00\xdf\x00\xe0\x00\xce\x00\xcf\x00\x6d\x00\xd1\x00\x74\x00\x30\x00\x31\x00\xcc\x00\x4a\x00\x4b\x00\xdc\x00\xd0\x00\x6b\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x7e\x00\xf5\x00\xf6\x00\x17\x00\xdc\x00\xdd\x00\x9f\x00\xe8\x00\xe0\x00\x63\x00\xeb\x00\xec\x00\x73\x00\x74\x00\x22\x00\xf0\x00\xf5\x00\xf6\x00\x64\x00\x51\x00\x52\x00\x67\x00\x68\x00\xea\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xd1\x00\xdc\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x89\x00\xdf\x00\xe0\x00\x22\x00\xea\x00\xdf\x00\xe0\x00\x26\x00\x91\x00\x92\x00\x93\x00\x94\x00\x2b\x00\x08\x00\x97\x00\x98\x00\x99\x00\xf5\x00\xf6\x00\x9c\x00\x9d\x00\x9e\x00\x3e\x00\x3f\x00\x40\x00\x23\x00\xda\x00\x25\x00\xa5\x00\x27\x00\x28\x00\x29\x00\x2a\x00\xe1\x00\xe2\x00\xe3\x00\xce\x00\xe5\x00\xe6\x00\xe7\x00\x32\x00\xbd\x00\x25\x00\xea\x00\x36\x00\xc1\x00\x38\x00\x39\x00\x3a\x00\xdb\x00\xdc\x00\xdd\x00\x51\x00\x52\x00\x31\x00\x32\x00\x33\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x6d\x00\xce\x00\xe9\x00\xcb\x00\x64\x00\x31\x00\xce\x00\xcf\x00\x68\x00\xd1\x00\x5a\x00\x5b\x00\xce\x00\xcc\x00\xdb\x00\xdc\x00\xdd\x00\x7e\x00\xf9\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xdb\x00\xdc\x00\xdd\x00\xdc\x00\xdc\x00\xdd\x00\xea\x00\xe8\x00\xdc\x00\xdd\x00\xeb\x00\xec\x00\x51\x00\x52\x00\xd5\x00\xf0\x00\xdc\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x4e\x00\x4f\x00\xca\x00\x07\x00\xe2\x00\xf5\x00\xf6\x00\xcf\x00\xdc\x00\x0d\x00\x0e\x00\xdf\x00\xe0\x00\xa5\x00\xd1\x00\xa7\x00\x89\x00\xdc\x00\xf5\x00\xf6\x00\xdf\x00\xe0\x00\xde\x00\xea\x00\x91\x00\x92\x00\x93\x00\x94\x00\xdf\x00\xe0\x00\x97\x00\x98\x00\x99\x00\xf5\x00\xf6\x00\x9c\x00\x9d\x00\x9e\x00\x6d\x00\x23\x00\xcc\x00\x25\x00\xf5\x00\xf6\x00\xa5\x00\x29\x00\x2a\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x1a\x00\x17\x00\xcc\x00\x32\x00\x7e\x00\xdc\x00\xdd\x00\x36\x00\xe9\x00\x38\x00\x39\x00\x3a\x00\x22\x00\x6b\x00\x6c\x00\x51\x00\x52\x00\x2b\x00\xdc\x00\xdd\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x2e\x00\xe5\x00\xe6\x00\xdc\x00\xd0\x00\xcb\x00\xdf\x00\xe0\x00\xce\x00\xcf\x00\xdc\x00\xd1\x00\x3a\x00\xdf\x00\xe0\x00\xdc\x00\xdc\x00\xdd\x00\xdf\x00\xe0\x00\xe0\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x05\x00\xf5\x00\xf6\x00\xdc\x00\xdd\x00\x17\x00\xed\x00\xe8\x00\xf5\x00\xf6\x00\xeb\x00\xec\x00\x17\x00\xf5\x00\xf6\x00\xf0\x00\x22\x00\x16\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\xcc\x00\x1a\x00\xdc\x00\x75\x00\xd0\x00\xdf\x00\xe0\x00\x28\x00\x17\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x89\x00\xdc\x00\xdd\x00\xf2\x00\x22\x00\xe0\x00\x08\x00\x09\x00\x91\x00\x92\x00\x93\x00\x94\x00\xf5\x00\xf6\x00\x97\x00\x98\x00\x99\x00\x4f\x00\x50\x00\x9c\x00\x9d\x00\x9e\x00\x23\x00\xea\x00\x25\x00\xd1\x00\x4f\x00\x50\x00\xa5\x00\x45\x00\x46\x00\x17\x00\x48\x00\x49\x00\xcc\x00\x25\x00\x16\x00\x4d\x00\xd0\x00\xdf\x00\xe0\x00\x36\x00\x22\x00\x38\x00\x39\x00\x3a\x00\xbd\x00\x31\x00\x32\x00\x33\x00\xdc\x00\xdd\x00\x17\x00\x22\x00\xe0\x00\xdc\x00\xdd\x00\x26\x00\x23\x00\x08\x00\x25\x00\x0a\x00\x2b\x00\x22\x00\xdc\x00\x1b\x00\xcb\x00\xdf\x00\xe0\x00\xce\x00\xcf\x00\x22\x00\xd1\x00\xee\x00\xdc\x00\xdd\x00\x35\x00\x36\x00\x29\x00\x38\x00\x39\x00\x3a\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x25\x00\xf5\x00\xf6\x00\xce\x00\xee\x00\x05\x00\x06\x00\xe8\x00\x0d\x00\x0e\x00\xeb\x00\xec\x00\x31\x00\x32\x00\x33\x00\xf0\x00\xdb\x00\xdc\x00\xdd\x00\x08\x00\x09\x00\xcc\x00\x16\x00\x19\x00\x9f\x00\xd0\x00\x1a\x00\xa2\x00\x81\x00\x82\x00\x83\x00\x17\x00\x22\x00\x4d\x00\x4e\x00\x4f\x00\x89\x00\xdc\x00\xdd\x00\x8a\x00\xdc\x00\xe0\x00\x22\x00\xdf\x00\xe0\x00\x1c\x00\x93\x00\x24\x00\x25\x00\x69\x00\x97\x00\x22\x00\x99\x00\x1c\x00\xcc\x00\x9c\x00\x9d\x00\x9e\x00\xd0\x00\x22\x00\x31\x00\x32\x00\x33\x00\xcc\x00\xa5\x00\xf5\x00\xf6\x00\xd0\x00\x05\x00\x06\x00\xdc\x00\xdd\x00\x89\x00\x9f\x00\xe0\x00\xa1\x00\xc6\x00\xc7\x00\x19\x00\xdc\x00\xdd\x00\x19\x00\x93\x00\xe0\x00\xce\x00\x16\x00\x97\x00\x22\x00\x99\x00\x75\x00\x22\x00\x9c\x00\x9d\x00\x9e\x00\x23\x00\x96\x00\x25\x00\xdb\x00\xdc\x00\xdd\x00\xa5\x00\xe9\x00\xcb\x00\xc6\x00\xc7\x00\xce\x00\xcf\x00\x26\x00\xd1\x00\x75\x00\xa5\x00\xce\x00\xa7\x00\x36\x00\x2d\x00\x38\x00\x39\x00\x3a\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xdb\x00\xdc\x00\xdd\x00\x22\x00\x96\x00\x62\x00\x23\x00\xe8\x00\x25\x00\x28\x00\xeb\x00\xec\x00\xc9\x00\xca\x00\xcb\x00\xf0\x00\xe9\x00\xce\x00\xcf\x00\xa5\x00\xd1\x00\xa7\x00\x05\x00\x06\x00\x35\x00\x36\x00\xe9\x00\x38\x00\x39\x00\x3a\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcc\x00\x0d\x00\x0e\x00\x16\x00\xd0\x00\x05\x00\x06\x00\xe8\x00\x03\x00\xd1\x00\xeb\x00\xec\x00\x19\x00\x08\x00\x09\x00\xf0\x00\xdc\x00\xdd\x00\xda\x00\x19\x00\xe0\x00\x22\x00\x16\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xce\x00\x22\x00\x82\x00\x83\x00\x05\x00\x06\x00\x9f\x00\x19\x00\xa1\x00\x89\x00\x2c\x00\x3b\x00\x3c\x00\xdb\x00\xdc\x00\xdd\x00\x22\x00\xf4\x00\xce\x00\x93\x00\x22\x00\x16\x00\x2e\x00\x97\x00\x9f\x00\x99\x00\x28\x00\xa2\x00\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\x52\x00\xef\x00\x54\x00\xa5\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xda\x00\x89\x00\x5e\x00\x5f\x00\x23\x00\x62\x00\x25\x00\xe1\x00\xe2\x00\x0d\x00\x0e\x00\x93\x00\x7b\x00\x7c\x00\xf2\x00\x97\x00\x29\x00\x99\x00\xa6\x00\x2c\x00\x9c\x00\x9d\x00\x9e\x00\x36\x00\x11\x00\x38\x00\x39\x00\x3a\x00\x1a\x00\xa5\x00\x1c\x00\xcb\x00\xdc\x00\xdd\x00\xce\x00\xcf\x00\xe0\x00\xd1\x00\xbd\x00\xe2\x00\x05\x00\x06\x00\xe5\x00\xe6\x00\x09\x00\x95\x00\x0b\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x64\x00\x65\x00\x1f\x00\xd2\x00\x16\x00\x22\x00\xd5\x00\xe8\x00\xd7\x00\x47\x00\xeb\x00\xec\x00\x1e\x00\xa6\x00\xcb\x00\xf0\x00\x7e\x00\xce\x00\xcf\x00\xe2\x00\xd1\x00\x27\x00\xe5\x00\xe6\x00\xce\x00\x49\x00\x1a\x00\xd1\x00\x1c\x00\x2b\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x84\x00\xdb\x00\xdc\x00\xdd\x00\x7e\x00\xdf\x00\xe0\x00\xe8\x00\x7f\x00\xd1\x00\xeb\x00\xec\x00\xa8\x00\xa9\x00\xaa\x00\xf0\x00\x33\x00\x89\x00\x8e\x00\xdb\x00\xdc\x00\xdd\x00\x01\x00\xdf\x00\xe0\x00\x44\x00\xcf\x00\x93\x00\x8a\x00\x08\x00\x09\x00\x97\x00\x29\x00\x99\x00\x2b\x00\x8a\x00\x9c\x00\x9d\x00\x9e\x00\xdc\x00\x75\x00\xde\x00\xdf\x00\xe0\x00\xf4\x00\xa5\x00\x69\x00\x52\x00\x53\x00\x54\x00\xf2\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xdc\x00\xdd\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x32\x00\xf5\x00\xf6\x00\xce\x00\xa8\x00\xa9\x00\xaa\x00\x39\x00\x3a\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x01\x00\x1a\x00\xdb\x00\xdc\x00\xdd\x00\xe0\x00\xcb\x00\x08\x00\x09\x00\xce\x00\xcf\x00\xe3\x00\xd1\x00\xe5\x00\xe6\x00\xe7\x00\xea\x00\x3b\x00\x3c\x00\x1c\x00\x1d\x00\x1e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x6e\x00\x6f\x00\x70\x00\x3b\x00\x3c\x00\x43\x00\x29\x00\xe8\x00\x2b\x00\x43\x00\xeb\x00\xec\x00\x52\x00\x66\x00\x54\x00\xf0\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xe5\x00\xe6\x00\x5e\x00\x5f\x00\x52\x00\x2b\x00\x54\x00\x2d\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xe5\x00\xe6\x00\x5e\x00\x5f\x00\x6f\x00\x70\x00\x86\x00\x87\x00\x88\x00\x89\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x2d\x00\xdb\x00\xdc\x00\xdd\x00\x93\x00\xdf\x00\xe0\x00\x09\x00\x97\x00\x0b\x00\x99\x00\x15\x00\x16\x00\x9c\x00\x9d\x00\x9e\x00\xcf\x00\xe2\x00\x51\x00\x52\x00\x48\x00\x54\x00\xa5\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xdc\x00\x03\x00\xde\x00\xdf\x00\xe0\x00\x32\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\xab\x00\x39\x00\x3a\x00\x4d\x00\x0d\x00\x0e\x00\xdb\x00\xdc\x00\xdd\x00\xdc\x00\xdf\x00\xe0\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\x51\x00\x52\x00\x53\x00\x54\x00\xcb\x00\x0d\x00\x0e\x00\xce\x00\xcf\x00\x0a\x00\xd1\x00\x38\x00\x39\x00\x3a\x00\xbb\x00\xbc\x00\xbd\x00\xc4\x00\xf5\x00\xf6\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x27\x00\xd1\x00\x29\x00\x27\x00\xcf\x00\x29\x00\xea\x00\xe8\x00\x8c\x00\x8d\x00\x8e\x00\xdb\x00\xdc\x00\xdd\x00\xea\x00\xdf\x00\xe0\x00\xdc\x00\xcf\x00\xde\x00\xdf\x00\xe0\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x27\x00\xdc\x00\x29\x00\xde\x00\xdf\x00\xe0\x00\xf4\x00\x87\x00\x88\x00\x89\x00\x0d\x00\x0e\x00\xf5\x00\xf6\x00\x8c\x00\x8d\x00\x8e\x00\x15\x00\x16\x00\x93\x00\xa8\x00\xa9\x00\xaa\x00\x97\x00\xea\x00\x99\x00\xf5\x00\xf6\x00\x9c\x00\x9d\x00\x9e\x00\xea\x00\xcf\x00\x51\x00\x52\x00\xe1\x00\xe2\x00\xa5\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x2d\x00\xdc\x00\x93\x00\xde\x00\xdf\x00\xe0\x00\x97\x00\x48\x00\x99\x00\x51\x00\x52\x00\x9c\x00\x9d\x00\x9e\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xa5\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xf5\x00\xf6\x00\x0c\x00\x0d\x00\x0e\x00\xcb\x00\xda\x00\x48\x00\xce\x00\xcf\x00\x27\x00\xd1\x00\x29\x00\xe1\x00\xe2\x00\xe3\x00\x48\x00\xe5\x00\xe6\x00\xe7\x00\x48\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x0c\x00\x0d\x00\x0e\x00\xea\x00\x27\x00\xcb\x00\x29\x00\xe8\x00\xce\x00\xcf\x00\x24\x00\xd1\x00\xa8\x00\xa9\x00\xaa\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x51\x00\x52\x00\x0d\x00\x0e\x00\xe8\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x52\x00\x27\x00\x54\x00\x29\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xda\x00\x19\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xd1\x00\xe1\x00\xe2\x00\xe3\x00\xea\x00\xe5\x00\xe6\x00\xe7\x00\xe0\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xf2\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xdc\x00\x0d\x00\x0e\x00\xdf\x00\xe0\x00\x27\x00\x52\x00\x29\x00\x54\x00\xe0\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x9f\x00\xf4\x00\x5e\x00\x5f\x00\xdc\x00\x61\x00\xab\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\x18\x00\x8b\x00\x8c\x00\x8d\x00\x27\x00\x27\x00\x29\x00\x29\x00\x27\x00\x27\x00\x29\x00\x29\x00\x27\x00\x27\x00\x29\x00\x29\x00\x9f\x00\x95\x00\xf5\x00\xf6\x00\x52\x00\x27\x00\x54\x00\x29\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x0d\x00\x0e\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x27\x00\x27\x00\x29\x00\x29\x00\x27\x00\x27\x00\x29\x00\x29\x00\x27\x00\xea\x00\x29\x00\xdc\x00\x0f\x00\x10\x00\xdf\x00\xe0\x00\x27\x00\x52\x00\x29\x00\x54\x00\xf2\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x17\x00\xcf\x00\x5e\x00\x5f\x00\xdc\x00\x61\x00\xa6\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\x2b\x00\xda\x00\x2d\x00\xdc\x00\x62\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe9\x00\xe5\x00\xe6\x00\xe7\x00\x76\x00\x0d\x00\x0e\x00\xf5\x00\xf6\x00\x0d\x00\x0e\x00\x09\x00\x9f\x00\xa9\x00\xaa\x00\x46\x00\x47\x00\xf5\x00\xf6\x00\xcf\x00\x52\x00\x0d\x00\x0e\x00\x09\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xda\x00\x16\x00\xdc\x00\x2d\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\x52\x00\x17\x00\x54\x00\x63\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x0d\x00\x0e\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x0d\x00\x0e\x00\xf5\x00\xf6\x00\x7b\x00\xcf\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x05\x00\x06\x00\x0d\x00\x0e\x00\x08\x00\x09\x00\xda\x00\x63\x00\xdc\x00\x29\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\x17\x00\xe5\x00\xe6\x00\xe7\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x24\x00\x25\x00\x16\x00\x27\x00\xcf\x00\x05\x00\x06\x00\x05\x00\x06\x00\xf5\x00\xf6\x00\x4a\x00\x4b\x00\x31\x00\x32\x00\x33\x00\x22\x00\xdc\x00\x17\x00\xde\x00\xdf\x00\xe0\x00\x52\x00\x1a\x00\x54\x00\x29\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x28\x00\x29\x00\x5e\x00\x5f\x00\x28\x00\x61\x00\x03\x00\x04\x00\x4a\x00\x4b\x00\xf5\x00\xf6\x00\x28\x00\x29\x00\x05\x00\x06\x00\x29\x00\x52\x00\x1a\x00\x54\x00\x29\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x17\x00\x5d\x00\x5e\x00\x5f\x00\x28\x00\x29\x00\x01\x00\x88\x00\x89\x00\x4a\x00\xdc\x00\x05\x00\x06\x00\xdf\x00\xe0\x00\x1c\x00\xcf\x00\x1b\x00\x92\x00\x29\x00\x0f\x00\x4a\x00\x16\x00\x28\x00\x17\x00\x22\x00\x1c\x00\x16\x00\x05\x00\xdc\x00\x17\x00\xde\x00\xdf\x00\xe0\x00\x28\x00\xf5\x00\xf6\x00\x52\x00\x1c\x00\x54\x00\x9f\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x1c\x00\x5d\x00\x5e\x00\x5f\x00\x0c\x00\x17\x00\x27\x00\xf5\x00\xf6\x00\x52\x00\x17\x00\x54\x00\x17\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x22\x00\x5d\x00\x5e\x00\x5f\x00\x52\x00\x22\x00\x54\x00\x47\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x92\x00\x5d\x00\x5e\x00\x5f\x00\x29\x00\x50\x00\x25\x00\x1b\x00\xcf\x00\x1b\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x92\x00\x67\x00\xdc\x00\x17\x00\xde\x00\xdf\x00\xe0\x00\x28\x00\x1b\x00\x1b\x00\x5d\x00\x69\x00\x63\x00\x52\x00\x1a\x00\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x6b\x00\x5d\x00\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xdc\x00\x7c\x00\xde\x00\xdf\x00\xe0\x00\x7a\x00\x22\x00\x2b\x00\x7b\x00\x24\x00\x24\x00\x52\x00\x7b\x00\x54\x00\x1b\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x63\x00\x5d\x00\x5e\x00\x5f\x00\xf5\x00\xf6\x00\x63\x00\x2b\x00\x1b\x00\x28\x00\x52\x00\x1b\x00\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x22\x00\x5d\x00\x5e\x00\x5f\x00\x1b\x00\x7b\x00\xdc\x00\x7b\x00\xde\x00\xdf\x00\xe0\x00\x1f\x00\xcf\x00\x01\x00\x65\x00\x0c\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x17\x00\x16\x00\x29\x00\x22\x00\x17\x00\xdc\x00\xcf\x00\xde\x00\xdf\x00\xe0\x00\x7b\x00\xf5\x00\xf6\x00\x1a\x00\x16\x00\x92\x00\x92\x00\x17\x00\x22\x00\xdc\x00\x1f\x00\xde\x00\xdf\x00\xe0\x00\x24\x00\x25\x00\x1a\x00\x27\x00\x28\x00\x31\x00\xf5\x00\xf6\x00\x17\x00\x0f\x00\x67\x00\x28\x00\x0c\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\xf5\x00\xf6\x00\x1f\x00\x52\x00\xcf\x00\x54\x00\x28\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x28\x00\x5d\x00\x5e\x00\x5f\x00\xdc\x00\x92\x00\xde\x00\xdf\x00\xe0\x00\x92\x00\x92\x00\x29\x00\x22\x00\x7b\x00\x17\x00\x50\x00\x28\x00\x7b\x00\xcf\x00\x7b\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xf5\x00\xf6\x00\xdc\x00\x2b\x00\xde\x00\xdf\x00\xe0\x00\x7b\x00\x52\x00\xcf\x00\x54\x00\x69\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x67\x00\x5d\x00\x5e\x00\x5f\x00\xdc\x00\x7b\x00\xde\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\x63\x00\x7c\x00\x22\x00\x17\x00\x6c\x00\x5e\x00\x52\x00\x17\x00\x54\x00\x05\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x0f\x00\x2b\x00\xf5\x00\xf6\x00\x52\x00\x2b\x00\x54\x00\x22\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x2b\x00\x5d\x00\x5e\x00\x5f\x00\x52\x00\x1c\x00\x54\x00\x1b\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x2c\x00\x5d\x00\x5e\x00\x5f\x00\x41\x00\x1a\x00\x92\x00\x2b\x00\x92\x00\x92\x00\x52\x00\x29\x00\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x09\x00\x5d\x00\x5e\x00\x5f\x00\x1e\x00\x22\x00\xdc\x00\x0f\x00\xde\x00\xdf\x00\xe0\x00\x92\x00\x22\x00\x2b\x00\x92\x00\x4c\x00\x29\x00\x52\x00\x0c\x00\x54\x00\x17\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x22\x00\x5d\x00\x5e\x00\x5f\x00\xf5\x00\xf6\x00\x1a\x00\x28\x00\x0f\x00\x5f\x00\x52\x00\x0f\x00\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x16\x00\x5d\x00\x5e\x00\x5f\x00\x29\x00\x4c\x00\xdc\x00\x52\x00\xde\x00\xdf\x00\xe0\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x52\x00\x46\x00\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x1c\x00\x5d\x00\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xdc\x00\xcf\x00\xde\x00\xdf\x00\xe0\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x1c\x00\x24\x00\x27\x00\x1a\x00\xdc\x00\xcf\x00\xde\x00\xdf\x00\xe0\x00\x1c\x00\x78\x00\x1c\x00\x1b\x00\x47\x00\x0f\x00\xf5\x00\xf6\x00\x17\x00\xdc\x00\x1e\x00\xde\x00\xdf\x00\xe0\x00\x70\x00\x16\x00\xcf\x00\x66\x00\x0c\x00\x24\x00\xf5\x00\xf6\x00\x29\x00\x22\x00\x1c\x00\x7c\x00\x05\x00\x24\x00\x24\x00\xdc\x00\x92\x00\xde\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\x22\x00\x73\x00\x51\x00\x17\x00\x52\x00\x17\x00\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x92\x00\x5d\x00\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xdc\x00\x17\x00\xde\x00\xdf\x00\xe0\x00\x17\x00\x17\x00\xcf\x00\x52\x00\x22\x00\x1f\x00\x22\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xd1\x00\x21\x00\xdc\x00\x2d\x00\xde\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\x1b\x00\xdb\x00\xdc\x00\xdd\x00\x2b\x00\xdf\x00\xe0\x00\xcf\x00\x17\x00\x41\x00\xdc\x00\x41\x00\x41\x00\xdf\x00\xe0\x00\x27\x00\x4c\x00\x1f\x00\xf5\x00\xf6\x00\xdc\x00\x75\x00\xde\x00\xdf\x00\xe0\x00\x52\x00\xf4\x00\x54\x00\x1a\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xf5\x00\xf6\x00\x5e\x00\x5f\x00\x6c\x00\x61\x00\x2d\x00\x92\x00\x0c\x00\x17\x00\xf5\x00\xf6\x00\x92\x00\x17\x00\x17\x00\x17\x00\x17\x00\x52\x00\x22\x00\x54\x00\x1f\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x21\x00\x5d\x00\x5e\x00\x5f\x00\x52\x00\x1f\x00\x54\x00\x17\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x1c\x00\x5d\x00\x5e\x00\x5f\x00\x52\x00\x73\x00\xcf\x00\x32\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x6c\x00\x1b\x00\x93\x00\x1b\x00\x28\x00\xdc\x00\x0f\x00\xde\x00\xdf\x00\xe0\x00\x52\x00\x93\x00\x54\x00\x92\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x93\x00\x0f\x00\x5e\x00\x5f\x00\x0f\x00\x1b\x00\x1b\x00\x1b\x00\x93\x00\xdc\x00\xf5\x00\xf6\x00\xdf\x00\xe0\x00\x2c\x00\x1b\x00\x2c\x00\x52\x00\x83\x00\x54\x00\x93\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x00\x00\x73\x00\x00\x00\x5f\x00\x00\x00\x6b\x00\x1b\x00\xf5\x00\xf6\x00\xff\xff\x52\x00\xff\xff\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x73\x00\x73\x00\x73\x00\x5f\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x52\x00\xff\xff\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xdc\x00\xcf\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x22\x00\xff\xff\x24\x00\x25\x00\xff\xff\x27\x00\x28\x00\x29\x00\xdc\x00\x2b\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xf5\x00\xf6\x00\xff\xff\xdc\x00\xff\xff\xff\xff\xdf\x00\xe0\x00\xff\xff\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xf1\x00\xde\x00\xdf\x00\xe0\x00\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xf1\x00\xff\xff\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xf5\x00\xf6\x00\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x01\x00\xff\xff\x5e\x00\x5f\x00\x05\x00\x06\x00\xff\xff\xff\xff\x52\x00\xcf\x00\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xcf\x00\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xcf\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xf5\x00\xf6\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xcf\x00\xff\xff\x52\x00\x69\x00\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xdc\x00\xcf\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xf5\x00\xf6\x00\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xcf\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xcf\x00\xf5\x00\xf6\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\xff\xff\xff\xff\xff\xff\x25\x00\xdc\x00\x27\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x52\x00\xcf\x00\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xf5\x00\xf6\x00\x5f\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\x5e\x00\x5f\x00\xff\xff\xff\xff\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x52\x00\xff\xff\x54\x00\xff\xff\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\xff\xff\x5f\x00\xd6\x00\xff\xff\xff\xff\xff\xff\xda\x00\xff\xff\xdc\x00\xff\xff\xff\xff\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\xcf\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xcf\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xf5\x00\xf6\x00\xff\xff\xdc\x00\xff\xff\x8b\x00\xdf\x00\xe0\x00\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xf5\x00\xf6\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcf\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xf6\x00\xdc\x00\xff\xff\xde\x00\xdf\x00\xe0\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdc\x00\xff\xff\xff\xff\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xd3\x00\xff\xff\xff\xff\xd6\x00\xff\xff\xd8\x00\xff\xff\xda\x00\xff\xff\xff\xff\xd1\x00\xff\xff\xf5\x00\xf6\x00\xe1\x00\xe2\x00\xe3\x00\xff\xff\xe5\x00\xe6\x00\xe7\x00\xdc\x00\xff\xff\xff\xff\xdf\x00\xe0\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xdc\x00\xdf\x00\xe0\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xf5\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xf4\x00\xff\xff\xff\xff\xf5\x00\xf6\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\x6b\x00\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\xff\xff\x8d\x00\x8e\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\x6b\x00\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\xff\xff\x8d\x00\x8e\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\xff\xff\x74\x00\xff\xff\x76\x00\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\xff\xff\xff\xff\xff\xff\x8d\x00\x8e\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x62\x00\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\x62\x00\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x6d\x00\x6e\x00\x6f\x00\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\xff\xff\x8b\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xd3\x00\x66\x00\x67\x00\xd6\x00\x69\x00\xd8\x00\xff\xff\xda\x00\x6d\x00\x6e\x00\x6f\x00\xff\xff\xff\xff\x72\x00\xe1\x00\xe2\x00\xe3\x00\xff\xff\xe5\x00\xe6\x00\xe7\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xd3\x00\x66\x00\x67\x00\xd6\x00\x69\x00\xd8\x00\xff\xff\xda\x00\x6d\x00\x6e\x00\x6f\x00\xff\xff\xff\xff\x72\x00\xe1\x00\xe2\x00\xe3\x00\xff\xff\xe5\x00\xe6\x00\xe7\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\x61\x00\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\x8e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\x7f\x00\x80\x00\x81\x00\x82\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\x8e\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xff\xff\x3b\x00\x3c\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xff\xff\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xf4\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x67\x00\xff\xff\x69\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\xff\xff\x0b\x00\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x7c\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x24\x00\x8a\x00\xff\xff\x27\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\xdb\x00\xdc\x00\xdd\x00\xff\xff\xdf\x00\xe0\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xff\xff\xff\xff\xff\xff\xf4\x00\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x69\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x24\x00\xd3\x00\xff\xff\x27\x00\xd6\x00\xff\xff\xd8\x00\x8a\x00\xda\x00\x2d\x00\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xe1\x00\xe2\x00\xe3\x00\xff\xff\xe5\x00\xe6\x00\xe7\x00\xff\xff\x3b\x00\x3c\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xff\xff\xdf\x00\xe0\x00\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xf4\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x09\x00\x69\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\x8a\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xff\xff\xd3\x00\x32\x00\xff\xff\xd6\x00\xff\xff\xd8\x00\xff\xff\xda\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xe1\x00\xe2\x00\xe3\x00\x42\x00\xe5\x00\xe6\x00\xe7\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\x32\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf4\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\x22\x00\xff\xff\x24\x00\x25\x00\x42\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\x67\x00\x09\x00\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\x2f\x00\x30\x00\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\x22\x00\xff\xff\x24\x00\x25\x00\x42\x00\x27\x00\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\x22\x00\xff\xff\xff\xff\x25\x00\x42\x00\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\x1f\x00\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\x1f\x00\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\xa5\x00\xff\xff\x69\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\x70\x00\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x7d\x00\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\x8a\x00\xff\xff\x23\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\x67\x00\x09\x00\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x69\x00\xff\xff\x0c\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x69\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\x19\x00\x7c\x00\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\x8a\x00\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\x19\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\x1f\x00\x20\x00\xff\xff\xff\xff\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\x24\x00\x25\x00\xff\xff\x27\x00\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\x1a\x00\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\x78\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\x77\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\x1b\x00\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\x01\x00\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x2d\x00\x66\x00\x67\x00\xff\xff\x69\x00\x6a\x00\x01\x00\x02\x00\xff\xff\xff\xff\x05\x00\x06\x00\x71\x00\x72\x00\xff\xff\xff\xff\xff\xff\x76\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x85\x00\x86\x00\x87\x00\x50\x00\x51\x00\x52\x00\x53\x00\x22\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\xff\xff\x22\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x7e\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\x2f\x00\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x5f\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\xff\xff\xff\xff\x32\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x1e\x00\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\xff\xff\x07\x00\xff\xff\x38\x00\xff\xff\xff\xff\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\x44\x00\xff\xff\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x01\x00\x02\x00\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\xff\xff\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\x1e\x00\x05\x00\x06\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x33\x00\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\x02\x00\x7c\x00\xff\xff\x05\x00\x06\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x7c\x00\x1e\x00\xff\xff\xff\xff\xff\xff\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\x02\x00\x7c\x00\xff\xff\x05\x00\x06\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x7c\x00\x1e\x00\x05\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\xff\xff\x33\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\x05\x00\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\x17\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x01\x00\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x7c\x00\x01\x00\x02\x00\xff\xff\xff\xff\x05\x00\x06\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x7c\x00\x05\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\x69\x00\x05\x00\x06\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\x7c\x00\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\x1c\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\x26\x00\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x79\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xcb\x00\x26\x00\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\xff\xff\x05\x00\x06\x00\x7c\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x66\x00\x67\x00\x05\x00\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\x7c\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x02\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\x01\x00\xff\xff\x66\x00\x67\x00\x05\x00\x69\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\x01\x00\xff\xff\x66\x00\x67\x00\x05\x00\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\x7c\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\x01\x00\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x01\x00\xff\xff\xff\xff\x7c\x00\x05\x00\x06\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\x18\x00\xff\xff\xff\xff\x01\x00\xff\xff\xff\xff\x1e\x00\x7c\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x16\x00\xff\xff\x7c\x00\xff\xff\xff\xff\x01\x00\x50\x00\x51\x00\x52\x00\x53\x00\x69\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\x7c\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x16\x00\xff\xff\xff\xff\xff\xff\x7c\x00\x01\x00\xff\xff\xff\xff\x66\x00\x67\x00\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x25\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\x01\x00\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xa5\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\x16\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x69\x00\x50\x00\x51\x00\x52\x00\x53\x00\x25\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\xff\xff\xff\xff\xcb\x00\xff\xff\x7c\x00\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xe8\x00\xff\xff\x50\x00\x51\x00\x52\x00\x53\x00\xff\xff\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\x69\x00\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\xff\xff\xff\xff\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xff\xff\xb5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xff\xff\xb5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb1\x00\xb2\x00\xb3\x00\xff\xff\xb5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb2\x00\xb3\x00\xff\xff\xb5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb4\x00\xb5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb4\x00\xb5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xbe\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xa5\x00\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xe8\x00\xff\xff\xff\xff\xc3\x00\xff\xff\xc5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x00\xff\xff\xc5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xb4\x00\xb5\x00\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xbe\x00\xff\xff\x9c\x00\x9d\x00\x9e\x00\xc3\x00\xff\xff\xc5\x00\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xc3\x00\xe8\x00\xc5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xb5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xbe\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xa5\x00\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbe\x00\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xc5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xbf\x00\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xe8\x00\xe9\x00\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xe8\x00\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xff\xff\xff\xff\xff\xff\xa4\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xaf\x00\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xb6\x00\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xae\x00\xaf\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xa0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xd4\x00\xff\xff\xd6\x00\xff\xff\xff\xff\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xff\xff\xe4\x00\xff\xff\xe6\x00\xe7\x00\xe8\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xb9\x00\xba\x00\xa5\x00\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xba\x00\xd1\x00\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa3\x00\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa4\x00\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xa3\x00\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xbe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xff\xff\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\x94\x00\xd1\x00\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\x91\x00\x92\x00\x93\x00\x94\x00\xff\xff\xe8\x00\x97\x00\x98\x00\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\x97\x00\xff\xff\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\x99\x00\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\x9b\x00\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\x9b\x00\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xac\x00\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xa8\x00\xa9\x00\xaa\x00\xff\xff\xac\x00\xad\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9c\x00\x9d\x00\x9e\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xa5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xcb\x00\xff\xff\xff\xff\xce\x00\xcf\x00\xff\xff\xd1\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe8\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x12\x00\x0e\x00\x10\x00\x9b\x00\x0c\x00\x9c\x00\x14\x00\x0b\x05\x67\x04\x84\x03\x85\x03\x86\x03\x9f\x03\x8f\x02\x90\x02\x1c\x04\xc4\x03\x26\x02\x39\x02\xa8\x00\x31\x02\x93\x00\xa3\x00\x45\x04\xa8\x00\xfd\x01\xa3\x00\xa8\x00\x31\x02\xa8\x00\xfd\x01\x30\x02\x1b\x04\x70\x02\xe3\x04\xe5\x00\x10\x03\xb1\xff\x98\x04\xa8\x00\xc6\x02\xa3\x00\xa8\x00\x6a\x04\xbe\x01\xa8\x00\x6a\x04\x30\x02\xe4\x04\xe5\x04\xa3\x00\xa4\x00\x4f\x04\x9e\x02\xa1\x00\x87\x01\xa2\x00\x30\x02\x32\x02\xeb\x00\xec\x00\xa8\x00\xc6\x02\xa8\x00\x80\x04\x52\x03\x34\x02\xa8\x00\x70\x04\x4e\xfd\x8e\x01\xc4\x01\xf1\x00\x29\x04\xe6\x00\xa8\x00\xb7\x04\x56\x03\xa8\x00\xb7\x04\xa8\x00\x80\x04\x58\x03\xbf\x01\x88\x01\x58\x03\x13\x03\x0a\x05\x9a\x04\xb3\x00\xeb\x04\xb4\x00\xa8\x00\x70\x04\xbf\x01\xb3\x00\x14\x05\x30\x02\xe6\x00\xa3\x00\x53\x03\x87\x01\x8d\x02\x8e\x02\x8f\x02\x90\x02\x7d\x01\x2a\x04\x87\x01\x14\x03\x36\x00\xe6\x00\x5e\x04\x38\x04\xb8\x04\x66\x03\x14\x03\xb9\x04\x41\x03\xb7\x00\x8d\x04\x1e\x04\x7f\x04\x0d\x05\x52\x04\x51\x04\x52\x04\xce\x04\x17\x00\x05\x05\x88\x01\x30\x02\xa0\x03\x90\x02\x30\x02\xa0\x02\xc6\x03\x88\x01\x7f\x00\x2c\x02\x2d\x02\xee\x03\x06\x03\xee\x04\x73\x01\x74\x01\x75\x01\xb3\x04\xb4\x04\xae\x01\x4e\xfd\xc5\x03\xc5\x03\xcb\x01\x91\x02\xcc\x01\x81\x04\x2e\x02\xce\x01\xcf\x01\xd0\x01\xc6\x04\x6b\x04\x27\x02\x82\x00\x6c\x04\xc6\x03\xc6\x03\xd1\x01\xef\x03\x2b\x00\x7c\x01\xd2\x01\x82\x04\xd3\x01\xd4\x01\xd5\x01\xfb\x02\x24\x03\xe6\x04\xb5\x04\x44\x03\x71\x04\xe7\x04\xf7\x04\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x2a\x00\x2b\x00\x2c\x00\x68\x04\x2b\x00\x7c\x01\x57\x03\x87\x03\x7d\x01\xa5\x00\xad\x00\x59\x03\xfe\x01\xa5\x00\x5c\x03\x33\x02\x72\x04\xff\x01\x46\x04\xc7\x02\x2a\x00\x2b\x00\x2c\x00\x35\x02\x2e\x00\x2f\x00\xed\x02\xe8\x04\xa5\x00\x06\x05\xe6\x04\x2a\x00\x2b\x00\x2c\x00\xe7\x04\x47\x04\x2f\x00\xa5\x00\x0d\x00\x0d\x00\x0d\x00\xc8\x02\x0d\x00\x0d\x00\x0d\x00\x88\x03\x2b\x00\x7c\x01\x87\x03\x94\x00\x7d\x01\xad\x00\x94\x00\xa6\x01\x91\x02\x01\x03\x0f\x00\x13\x00\x11\x00\x80\x00\x2f\x00\x2a\x00\x2b\x00\x2c\x00\xd6\x01\x2e\x00\x2f\x00\x2b\x00\x39\x04\xe8\x04\x2b\x00\x7c\x01\xd7\x01\x1a\x00\xd8\x01\x1c\x00\x73\x03\xfa\x04\x1d\x00\x1e\x00\x1f\x00\xf1\x04\x91\x02\x20\x00\x21\x00\x22\x00\x88\x03\x98\x04\x07\x04\xcb\x01\x13\x03\xcc\x01\x23\x00\x74\x03\xce\x01\xcf\x01\xd0\x01\x15\x03\x2b\x00\x7c\x01\x16\x03\x9d\x03\x17\x03\x53\x04\xd1\x01\x53\x04\xc4\x01\x54\x04\xd2\x01\x54\x04\xd3\x01\xd4\x01\xd5\x01\x18\x03\xe2\x03\x98\x04\x19\x03\xc9\x00\xb3\x02\x2b\x00\x7c\x01\x2b\x00\x7c\x01\x7d\x01\xae\x01\x7d\x01\x23\x03\x03\x03\x7f\x00\xc5\x01\x26\x00\x80\x00\x2f\x00\x27\x00\x28\x00\xfc\x04\x29\x00\xf5\x04\xb6\x04\xb4\x04\x53\x04\x37\x04\x38\x04\x7f\x00\x54\x04\xb4\x02\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xfd\x04\x81\x00\x82\x00\x12\x05\x2b\x00\x7c\x01\xc5\x00\x30\x00\x7d\x01\x26\x02\xd9\x01\xda\x01\x99\x04\x9a\x04\xc4\x04\xdb\x01\xa7\x04\x82\x00\xbf\x03\xb5\x04\x44\x03\xc0\x03\xc1\x03\xca\x04\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x94\x04\x7f\x00\x95\x04\x96\x04\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xd6\x01\x08\x04\x2f\x00\xb6\x01\xcc\x04\x2e\x00\x2f\x00\xb7\x01\xd7\x01\x1a\x00\xd8\x01\x1c\x00\xb8\x01\xcc\x00\x1d\x00\x1e\x00\x1f\x00\x23\x04\x82\x00\x20\x00\x21\x00\x22\x00\x5d\x03\x8f\x02\x90\x02\xcb\x01\xc6\x00\xcc\x01\x23\x00\xcd\x01\xce\x01\xcf\x01\xd0\x01\xaf\x00\xb0\x00\xc7\x00\x24\x03\xc8\x00\xc9\x00\xca\x00\xd1\x01\x6d\x02\xcf\x00\x90\x04\xd2\x01\x6e\x02\xd3\x01\xd4\x01\xd5\x01\x2a\x00\x2b\x00\x2c\x00\xf9\x04\x44\x03\xd1\x00\x4b\x01\xd3\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xdf\x03\x24\x03\x8b\x01\x26\x00\xbf\x03\x01\x05\x27\x00\x28\x00\x6f\x04\x29\x00\x29\x01\x7a\x00\x24\x03\xec\x04\x2a\x00\x2b\x00\x2c\x00\xe0\x03\x8c\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x2a\x00\x2b\x00\x2c\x00\x7f\x00\x2b\x00\x7c\x01\x9e\x04\x30\x00\x2b\x00\x39\x04\xd9\x01\xda\x01\xb5\x04\x44\x03\x7d\x04\xdb\x01\x7f\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xa2\x03\x97\x02\x91\x03\x81\x01\x18\x03\x27\x02\x82\x00\x92\x03\x7f\x00\xa8\x00\x82\x01\x80\x00\x2f\x00\xf7\x01\x43\x04\xf8\x01\xd6\x01\x7f\x00\x4e\x02\x82\x00\x80\x00\x2f\x00\x2d\x00\xa8\x04\xd7\x01\x1a\x00\xd8\x01\x1c\x00\x2e\x00\x2f\x00\x1d\x00\x1e\x00\x1f\x00\x81\x00\x82\x00\x20\x00\x21\x00\x22\x00\x1e\x03\xcb\x01\x18\x04\xcc\x01\x81\x00\x82\x00\x23\x00\x1c\x03\xd0\x01\x94\x02\x95\x02\x96\x02\x97\x02\x30\x02\xc3\x04\x91\x02\xd1\x01\x1f\x03\x2b\x00\x7c\x01\xd2\x01\x65\x04\xd3\x01\xd4\x01\xd5\x01\xc4\x04\x92\x04\x93\x04\xd0\x04\x44\x03\x70\x02\x2b\x00\x7c\x01\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x5d\x01\xf3\x02\xc9\x00\x7f\x00\xa2\x02\x26\x00\x80\x00\x2f\x00\x27\x00\x28\x00\x7f\x00\x29\x00\x5e\x01\x97\x01\x2f\x00\x7f\x00\x2b\x00\xa3\x02\x80\x00\x2f\x00\x7d\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x36\x00\x81\x00\x82\x00\x2b\x00\x5d\x04\x03\x03\xa4\x02\x30\x00\x0e\x02\x82\x00\xd9\x01\xda\x01\x18\x02\x2a\x01\x82\x00\xdb\x01\xc3\x00\xa6\x02\x98\x02\x95\x02\x96\x02\x97\x02\x7a\x01\xfa\x01\x7f\x00\x86\x04\x7b\x01\x80\x00\x2f\x00\x19\x02\x50\x02\x97\x04\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xd6\x01\x2b\x00\x7c\x01\x88\x04\x1c\x02\x7d\x01\xcc\x00\xb3\x00\xd7\x01\x1a\x00\xd8\x01\x1c\x00\x81\x00\x82\x00\x1d\x00\x1e\x00\x1f\x00\x78\x01\x93\x02\x20\x00\x21\x00\x22\x00\xcb\x01\xf7\x03\xcc\x01\x94\x04\x78\x01\x79\x01\x23\x00\xfb\x01\x55\x00\xe0\x02\x56\x00\x57\x00\x7a\x01\xcf\x00\x73\x03\xfc\x01\x7b\x01\x2e\x00\x2f\x00\xa0\x04\xc3\x00\xd3\x01\xd4\x01\xd5\x01\x00\x04\xd1\x00\x4b\x01\xd3\x00\x2b\x00\x7c\x01\xa9\x01\xbc\x01\x7d\x01\x2b\x00\x4a\x03\xbd\x01\xcb\x01\xcc\x00\xcc\x01\xcd\x00\xbe\x01\xc3\x00\x7f\x00\xf9\x03\x26\x00\x80\x00\x2f\x00\x27\x00\x28\x00\x13\x03\x29\x00\xb2\x03\x2b\x00\x4a\x03\x43\x02\x44\x02\x1b\x04\xd3\x01\xd4\x01\xd5\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xcf\x00\x81\x00\x82\x00\x4d\x03\x4b\x03\x36\x00\x37\x00\x30\x00\xd1\x04\xd2\x04\xd9\x01\xda\x01\xd1\x00\x4b\x01\xd3\x00\xdb\x01\x2a\x00\x2b\x00\x2c\x00\xcc\x00\xb3\x00\x7a\x01\x45\x04\x05\x03\xae\x01\x7b\x01\x30\x02\xd7\x02\xa1\x04\xa2\x04\xa3\x04\x16\x02\xc3\x00\xa3\x03\x96\x02\x97\x02\xd6\x01\x2b\x00\x7c\x01\x01\x04\x7f\x00\x7d\x01\xac\x01\x80\x00\x2f\x00\x13\x05\x45\x02\x1b\x03\xcf\x00\x05\x04\x1d\x00\xdf\x04\x1f\x00\xde\x04\x7a\x01\x20\x00\x21\x00\x22\x00\x7b\x01\xdf\x04\xd1\x00\x4b\x01\xd3\x00\x7a\x01\x23\x00\x81\x00\x82\x00\x7b\x01\x36\x00\x37\x00\x2b\x00\x7c\x01\xd6\x01\xa6\x01\x7d\x01\xde\x02\xff\x02\x9b\x01\xd9\x02\x2b\x00\x7c\x01\xb1\x01\x45\x02\x7d\x01\x9c\x01\x45\x04\x1d\x00\xc3\x00\x1f\x00\x06\x04\xc3\x00\x20\x00\x21\x00\x22\x00\xcb\x01\x3c\x04\xcc\x01\x2a\x00\x2b\x00\x2c\x00\x23\x00\x0a\x04\x26\x00\x9a\x01\x9b\x01\x27\x00\x28\x00\x08\x03\x29\x00\x0c\x04\xf7\x01\x9c\x01\xf8\x01\xa0\x04\xae\x01\xd3\x01\xd4\x01\xd5\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x2a\x00\x2b\x00\x2c\x00\xd5\x03\xf6\x01\x0d\x04\xcb\x01\x30\x00\xcc\x01\xe0\x04\xd9\x01\xda\x01\x46\x02\x47\x02\x26\x00\xdb\x01\x20\x04\x27\x00\x48\x02\xf7\x01\x29\x00\xf8\x01\x36\x00\x37\x00\x43\x02\x44\x02\x25\x04\xd3\x01\xd4\x01\xd5\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x7a\x01\xdb\x04\xdc\x04\x0a\x04\x7b\x01\x36\x00\x37\x00\x30\x00\x9d\x00\xad\x00\xd9\x01\xda\x01\xc2\x00\x9e\x00\x9f\x00\xdb\x01\x2b\x00\x7c\x01\xae\x00\x1a\x02\x7d\x01\xc3\x00\x45\x04\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x4e\x03\xac\x01\xf6\x04\xa3\x04\x36\x00\x37\x00\xa6\x01\x1b\x02\xa7\x01\xd6\x01\x27\x04\xbb\x04\x33\x04\x2a\x00\x2b\x00\x2c\x00\x1c\x02\xb1\x00\x50\x03\x45\x02\xd5\x03\x43\x03\x2b\x04\x1d\x00\xae\x01\x1f\x00\xd6\x03\xaf\x01\x20\x00\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x73\x00\x2d\x04\x74\x00\x23\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xf2\x01\xd6\x01\x34\x04\x7d\x00\xcb\x01\x2f\x04\xcc\x01\xaf\x00\xb0\x00\xe1\x04\xe2\x04\x45\x02\x6f\x03\x58\x02\x48\x04\x1d\x00\x48\x03\x1f\x00\x4d\x04\x49\x03\x20\x00\x21\x00\x22\x00\x90\x03\x4a\x04\xd3\x01\xd4\x01\xd5\x01\xce\x04\x23\x00\xd0\x04\x26\x00\x2b\x00\xe1\x03\x27\x00\x28\x00\xe2\x03\x29\x00\x9b\x03\xf2\x02\x36\x00\x37\x00\xf3\x02\xc9\x00\xb3\x00\x9a\x03\xb4\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x6d\x04\x6e\x04\x51\x02\x15\x03\xb5\x00\x1c\x02\x16\x03\x30\x00\x02\x04\xa4\x03\xd9\x01\xda\x01\xb6\x00\x9e\x03\x26\x00\xdb\x01\xb7\x03\x27\x00\x28\x00\x18\x03\x29\x00\xb7\x00\x19\x03\xc9\x00\x2e\x01\xa5\x03\x30\x02\x2f\x01\xf9\x03\xb9\x03\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xba\x03\x2a\x00\x2b\x00\x2c\x00\xbe\x03\x2e\x00\x2f\x00\x30\x00\xc2\x03\xad\x00\xd9\x01\xda\x01\xbe\x04\xf6\x00\xf7\x00\xdb\x01\x38\x03\xd6\x01\xd2\x03\x59\x02\x2b\x00\x2c\x00\x77\x01\x2e\x00\x2f\x00\xc9\x03\x7e\x00\x45\x02\xce\x03\x76\x01\x9f\x00\x1d\x00\x8d\xfe\x1f\x00\x8d\xfe\xd3\x03\x20\x00\x21\x00\x22\x00\x7f\x00\xdd\x03\x2d\x00\x80\x00\x2f\x00\x5a\x02\x23\x00\xdb\x03\x73\x00\x39\x03\x3a\x03\xf3\x03\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x2b\x00\xb3\x03\xbb\x00\x7d\x00\x3b\x03\xbd\x00\xaa\x04\x81\x00\x82\x00\x53\x03\xc4\x04\xf6\x00\xf7\x00\xab\x04\xac\x04\xd6\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x75\x01\xfd\x02\x2a\x00\x2b\x00\x2c\x00\xf9\x02\x26\x00\x76\x01\x9f\x00\x27\x00\x28\x00\x57\x01\x29\x00\xc8\x00\xc9\x00\xca\x00\x0b\x03\x32\x04\x33\x04\x89\x04\x8a\x04\x8b\x04\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xd6\x03\xd7\x03\xd8\x03\x36\x04\x33\x04\x2b\x03\x29\x03\x30\x00\x2a\x03\x34\x03\xd9\x01\xda\x01\x73\x00\x35\x03\x74\x00\xdb\x01\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xf3\x02\xc9\x00\x34\x04\x7d\x00\x73\x00\x70\x02\x74\x00\xea\x03\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x1d\x04\xc9\x00\x34\x04\x7d\x00\x77\x04\xd8\x03\xad\x04\xae\x04\xaf\x04\xb0\x04\x40\x04\x56\x02\x57\x02\x58\x02\xc0\x04\x3c\x03\x96\x01\x2b\x00\x2c\x00\x45\x02\x97\x01\x2f\x00\xb3\x00\x1d\x00\xb4\x00\x1f\x00\xfb\x02\x2d\x02\x20\x00\x21\x00\x22\x00\x7e\x00\xf2\x02\xd4\x04\xd5\x04\x54\x03\xd6\x04\x23\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7f\x00\x80\x03\x2d\x00\x80\x00\x2f\x00\xaa\x04\xfb\x01\x55\x00\x4f\x04\x56\x00\x57\x00\x3a\x02\xab\x04\xac\x04\xfc\x01\xea\x03\xeb\x03\xb8\x01\x2b\x00\x2c\x00\x7f\x00\x97\x01\x2f\x00\x80\x00\x2f\x00\x81\x00\x82\x00\xcb\x03\xcc\x03\xcd\x03\xce\x03\x26\x00\xf4\x03\xf5\x03\x27\x00\x28\x00\x3c\x02\x29\x00\xd8\x04\xd4\x01\xd5\x01\xe6\x03\xe7\x03\xe8\x03\x65\x02\x81\x00\x82\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xef\xfd\xad\x00\xef\xfd\x01\xfe\x7e\x00\x01\xfe\x3f\x02\x30\x00\x25\x03\x26\x03\x27\x03\x59\x02\x2b\x00\x2c\x00\x40\x02\x2e\x00\x2f\x00\x7f\x00\x7e\x00\x2d\x00\x80\x00\x2f\x00\x2d\x03\x2e\x03\x2f\x03\x30\x03\x31\x03\x32\x03\x33\x03\x34\x03\x03\xfe\x7f\x00\x03\xfe\x2d\x00\x80\x00\x2f\x00\x5a\x02\xfe\x04\xaf\x04\xb0\x04\xf4\x03\xf6\x03\x81\x00\x82\x00\x2a\x03\x26\x03\x27\x03\xfc\x02\x2d\x02\x45\x02\x38\x02\xf6\x00\xf7\x00\x1d\x00\x63\x02\x1f\x00\x81\x00\x82\x00\x20\x00\x21\x00\x22\x00\x6b\x02\x7e\x00\x9d\x04\x44\x03\x49\x03\xb0\x00\x23\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xaa\x02\x7f\x00\xd9\x04\x2d\x00\x80\x00\x2f\x00\x1d\x00\x9c\x02\x1f\x00\x73\x04\x44\x03\x20\x00\x21\x00\x22\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x23\x00\x6c\x03\x6d\x03\x56\x02\x57\x02\x58\x02\x81\x00\x82\x00\xa7\x00\xa8\x00\xa9\x00\x26\x00\xc6\x00\x9e\x02\x27\x00\x28\x00\x04\xfe\x29\x00\x04\xfe\xaf\x00\xb0\x00\xc7\x00\xa0\x02\xc8\x00\xc9\x00\xca\x00\xa1\x02\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaa\x00\xa8\x00\xa9\x00\xbc\x02\x0b\xfe\x26\x00\x0b\xfe\x30\x00\x27\x00\x28\x00\xbd\x02\x29\x00\xf5\x00\xf6\x00\xf7\x00\x51\x02\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xac\x02\xad\x02\xae\x02\x43\x03\x44\x03\xa8\x00\x67\x03\x30\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x73\x00\x0c\xfe\x74\x00\x0c\xfe\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xf2\x01\xe7\x02\xc3\x00\x7d\x00\xc4\x00\xbd\x00\xad\x00\xaf\x00\xb0\x00\x57\x01\x85\x01\xc8\x00\xc9\x00\xca\x00\xed\x02\xf2\x01\x59\x02\x2b\x00\x2c\x00\x88\x01\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x7f\x00\x76\x03\x77\x03\x80\x00\x2f\x00\x0d\xfe\x73\x00\x0d\xfe\x74\x00\xf0\x02\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xc0\x00\x5a\x02\xbb\x00\x7d\x00\x7f\x00\x24\x02\xf4\x01\x80\x00\x2f\x00\x81\x00\x82\x00\x8f\x01\x73\x01\x74\x01\x75\x01\x0e\xfe\x0f\xfe\x0e\xfe\x0f\xfe\x10\xfe\x11\xfe\x10\xfe\x11\xfe\x12\xfe\x13\xfe\x12\xfe\x13\xfe\xc5\x00\x00\x02\x81\x00\x82\x00\x73\x00\x15\xfe\x74\x00\x15\xfe\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x79\x03\x7a\x03\xc3\x00\x7d\x00\xc4\x00\xbd\x00\x14\xfe\x16\xfe\x14\xfe\x16\xfe\x17\xfe\x18\xfe\x17\xfe\x18\xfe\x1f\xfe\x2b\x02\x1f\xfe\x7f\x00\x7d\x03\x7e\x03\x80\x00\x2f\x00\x20\xfe\x73\x00\x20\xfe\x74\x00\x36\x02\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x6b\x01\x7e\x00\xbb\x00\x7d\x00\x7f\x00\x83\x04\xf3\x00\x80\x00\x2f\x00\x81\x00\x82\x00\xad\x01\x78\x04\xae\x01\x7f\x00\xac\x00\x2d\x00\x80\x00\x2f\x00\xaf\x00\xb0\x00\xc7\x00\x31\x01\xc8\x00\xc9\x00\xca\x00\x84\x04\x4a\x02\x4b\x02\x81\x00\x82\x00\xa8\x00\x4c\x02\x6d\x01\xc5\x00\x8c\x02\xf7\x00\x99\x02\x9a\x02\x81\x00\x82\x00\x7e\x00\xa6\x02\xba\x02\xbb\x02\x6e\x01\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xf2\x01\x15\x00\x7f\x00\x16\x05\x2d\x00\x80\x00\x2f\x00\xaf\x00\xb0\x00\x73\x00\x11\x05\xba\x00\xdf\x03\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xa8\x00\xe9\x02\xbb\x00\x7d\x00\xbc\x00\xbd\x00\xa8\x00\xea\x02\x81\x00\x82\x00\xdd\x03\x7e\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\xeb\x02\x71\x01\xa8\x00\xee\x02\x37\x02\x9f\x00\xc6\x00\xdf\x03\x7f\x00\x09\x05\x2d\x00\x80\x00\x2f\x00\xaf\x00\xb0\x00\xc7\x00\x0d\x05\xc8\x00\xc9\x00\xca\x00\xa8\x00\x83\x01\xa8\x00\x84\x01\x66\x01\xcf\x00\xee\x04\xb7\x00\x7e\x00\x70\x01\x71\x01\x8a\x01\x8b\x01\x81\x00\x82\x00\x83\x03\x84\x03\xd1\x00\x4b\x01\xd3\x00\xf0\x04\x7f\x00\xf1\x04\x2d\x00\x80\x00\x2f\x00\x73\x00\x30\x02\x74\x00\x1f\xff\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x21\x03\x22\x03\xbb\x00\x7d\x00\x21\x03\xbf\x00\x34\x00\x35\x00\x62\x03\x63\x03\x81\x00\x82\x00\x21\x03\x22\x03\x8a\x01\x8b\x01\xfc\x04\x73\x00\x30\x02\x74\x00\x00\x05\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x03\x05\x16\x05\x7c\x00\x7d\x00\x21\x03\x22\x03\x32\x00\x3e\x02\x3f\x02\xc6\x04\x7f\x00\x8a\x01\x8b\x01\x80\x00\x2f\x00\xcc\x04\x7e\x00\x94\xfd\xc8\x04\xcf\x04\xc8\x03\xc9\x04\x8e\x04\xe1\x04\x90\x04\x1c\x02\x92\x04\xc9\x03\x36\x00\x7f\x00\x9d\x04\x2d\x00\x80\x00\x2f\x00\xbd\x04\x81\x00\x82\x00\x73\x00\xa0\x04\x74\x00\xc0\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xaa\x04\x13\x05\x7c\x00\x7d\x00\xc0\x04\xc2\x04\x5a\x04\x81\x00\x82\x00\x73\x00\x51\x04\x74\x00\x58\x04\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x59\x04\x04\x05\x7c\x00\x7d\x00\x73\x00\x62\x04\x74\x00\x5c\x04\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x61\x04\x07\x05\x7c\x00\x7d\x00\x5d\x04\x58\x00\x60\x04\x67\x04\x7e\x00\x6a\x04\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x63\x04\xda\x03\x7f\x00\x76\x04\x2d\x00\x80\x00\x2f\x00\x75\x04\x95\xfd\x7a\x04\xfb\x03\x6a\x00\xdf\x03\x73\x00\x30\x02\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x17\x00\x09\x05\x7c\x00\x7d\x00\x81\x00\x82\x00\x7f\x00\x70\x00\x2d\x00\x80\x00\x2f\x00\x88\x04\x0b\x03\x70\x02\xd0\x03\x04\x04\x05\x04\x73\x00\xdd\x03\x74\x00\x0c\x04\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xdf\x03\xf2\x04\x7c\x00\x7d\x00\x81\x00\x82\x00\xdf\x03\x17\x04\xa7\x00\x20\x04\x73\x00\x22\x04\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x23\x04\xf4\x04\x7c\x00\x7d\x00\x27\x04\x2d\x04\x7f\x00\x2f\x04\x2d\x00\x80\x00\x2f\x00\x36\x04\x7e\x00\x32\x00\x3f\x04\x40\x04\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x43\x04\x4a\x04\x76\x03\x4c\x04\x4d\x04\x7f\x00\x7e\x00\x2d\x00\x80\x00\x2f\x00\x8e\x03\x81\x00\x82\x00\x30\x02\xc9\x03\x8f\x03\x90\x03\x97\x03\x98\x03\x7f\x00\x99\x03\x2d\x00\x80\x00\x2f\x00\x66\x01\xcf\x00\x02\x02\xb7\x00\x67\x01\x9a\x03\x81\x00\x82\x00\xa2\x03\x9c\x02\xa7\x03\xa8\x03\xa9\x03\xd1\x00\x4b\x01\xd3\x00\x68\x01\x69\x01\x6a\x01\x6b\x01\x81\x00\x82\x00\xaa\x03\x73\x00\x7e\x00\x74\x00\xab\x03\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x21\x03\x00\x05\x7c\x00\x7d\x00\x7f\x00\xac\x03\x2d\x00\x80\x00\x2f\x00\xad\x03\xae\x03\xb9\x03\xed\xfe\xbc\x03\xbe\x03\x58\x00\x21\x03\xc4\x03\x7e\x00\xd0\x03\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x81\x00\x82\x00\x7f\x00\x2a\x03\x2d\x00\x80\x00\x2f\x00\xd0\x03\x73\x00\x7e\x00\x74\x00\x6a\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xda\x03\xc9\x04\x7c\x00\x7d\x00\x7f\x00\xdd\x03\x2d\x00\x80\x00\x2f\x00\x81\x00\x82\x00\xdf\x03\x70\x00\xe4\x03\xf7\x02\x03\x02\xf0\x03\x73\x00\xf8\x02\x63\x04\x36\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\x02\xad\x01\x81\x00\x82\x00\x73\x00\x07\x03\x74\x00\x0b\x03\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x07\x03\xd3\x04\x7c\x00\x7d\x00\x73\x00\x0d\x03\x74\x00\xa7\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x12\x03\x17\x04\x7c\x00\x7d\x00\x1c\x03\x30\x02\x3e\x03\x37\x03\x3f\x03\x40\x03\x73\x00\x47\x03\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xb3\x00\x2a\x04\x7c\x00\x7d\x00\x9e\x02\x5a\x03\x7f\x00\x5b\x03\x2d\x00\x80\x00\x2f\x00\x5d\x03\x5f\x03\x60\x03\x61\x03\x65\x03\x64\x03\x73\x00\x6b\x03\x74\x00\x72\x03\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xe8\xfe\xb6\x03\x7c\x00\x7d\x00\x81\x00\x82\x00\x30\x02\x73\x03\x7c\x03\x3f\x01\x73\x00\x7d\x03\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x80\x03\x1d\x03\x7c\x00\x7d\x00\x76\x03\x3c\x02\x7f\x00\x0f\x02\x2d\x00\x80\x00\x2f\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x73\x00\xa1\x00\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x42\x02\x22\x03\x7c\x00\x7d\x00\x81\x00\x82\x00\x7f\x00\x7e\x00\x2d\x00\x80\x00\x2f\x00\x40\x04\x56\x02\x57\x02\x58\x02\x41\x04\x43\x02\x5f\x02\x61\x02\x67\x02\x7f\x00\x7e\x00\x2d\x00\x80\x00\x2f\x00\x68\x02\x6b\x02\x6d\x02\xc1\x01\x74\x02\x9c\x02\x81\x00\x82\x00\xa5\x01\x7f\x00\x9e\x02\x2d\x00\x80\x00\x2f\x00\xaf\x02\xb0\x02\x7e\x00\xb1\x02\xbf\x02\xd3\x02\x81\x00\x82\x00\xe3\x02\xe4\x02\xe5\x02\xe9\x02\x36\x00\xe6\x02\xe7\x02\x7f\x00\xf5\x02\x2d\x00\x80\x00\x2f\x00\x81\x00\x82\x00\xf0\x02\xa3\x00\x91\x01\x62\xfd\x73\x00\x5f\xfd\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x8f\x01\x95\x01\x7c\x00\x7d\x00\x81\x00\x82\x00\x7f\x00\xa4\x01\x2d\x00\x80\x00\x2f\x00\xa5\x01\xa6\x01\x7e\x00\x10\x02\xb4\x01\xb5\x01\xb4\x01\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xad\x00\xbb\x01\x7f\x00\xae\x01\x2d\x00\x80\x00\x2f\x00\x81\x00\x82\x00\xc1\x01\x59\x02\x2b\x00\x2c\x00\xc6\x01\x2e\x00\x2f\x00\x7e\x00\xc7\x01\xc8\x01\x7f\x00\xca\x01\xcb\x01\x80\x00\x2f\x00\xf4\x01\xf6\x01\xbf\x00\x81\x00\x82\x00\x7f\x00\xfd\x01\x2d\x00\x80\x00\x2f\x00\x73\x00\x5a\x02\x74\x00\x02\x02\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x81\x00\x82\x00\xbb\x00\x7d\x00\x03\x02\x22\x02\x05\x02\x0a\x02\x0c\x02\x5c\xfd\x81\x00\x82\x00\x0b\x02\x13\x02\x14\x02\x15\x02\x17\x02\x73\x00\x1d\x02\x74\x00\x1e\x02\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x21\x02\x32\x01\x7c\x00\x7d\x00\x73\x00\x1f\x02\x74\x00\x22\x02\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x31\x02\x7b\x00\x7c\x00\x7d\x00\x11\x02\xa3\x00\x7e\x00\x2b\x02\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x03\x02\x96\x00\xff\xff\xa7\x00\xd4\x00\x7f\x00\xe3\x00\x2d\x00\x80\x00\x2f\x00\x73\x00\xff\xff\x74\x00\xac\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\xe4\x00\xda\x04\x7d\x00\xe5\x00\xe8\x00\xa7\x00\xe8\x00\xff\xff\x7f\x00\x81\x00\x82\x00\x80\x00\x2f\x00\x5f\x01\x60\x01\xbf\xfd\x73\x00\x6d\x01\xae\x03\xff\xff\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\xa3\x00\xff\xff\xaf\x03\xff\xff\x17\x00\x96\x00\x81\x00\x82\x00\x00\x00\x73\x00\x00\x00\xae\x03\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xa3\x00\x70\x01\xa3\x00\xaf\x03\x00\x00\x00\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x73\x00\x00\x00\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\xbc\x03\x7d\x00\x81\x00\x82\x00\x7f\x00\x7e\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\xb7\x02\x00\x00\x66\x01\xcf\x00\x00\x00\xb7\x00\xb8\x02\x8c\xfe\x7f\x00\x8c\xfe\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\xd1\x00\x4b\x01\xd3\x00\x00\x00\x81\x00\x82\x00\x00\x00\x7f\x00\x00\x00\x00\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x37\x03\x7d\x00\x81\x00\x82\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\xba\x04\x2d\x00\x80\x00\x2f\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xb0\x03\x00\x00\x40\x03\x7d\x00\x81\x00\x82\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x4f\x03\x7d\x00\x81\x00\x82\x00\x00\x00\x00\x00\x73\x00\x00\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x4d\x02\x7d\x00\x73\x00\x00\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x32\x00\x00\x00\x52\x02\x7d\x00\x36\x00\x37\x00\x00\x00\x00\x00\x73\x00\x7e\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x53\x02\x7d\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x73\x00\x00\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\xb1\x02\x7d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x7e\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\xb8\x02\x7d\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x7e\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x81\x00\x82\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x7e\x00\x00\x00\x73\x00\x6a\x00\x45\x03\x00\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x7f\x00\x7e\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x81\x00\x82\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x7e\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x7e\x00\x81\x00\x82\x00\xd6\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xd7\x00\x00\x00\x00\x00\x00\x00\xcf\x00\x7f\x00\xb7\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x4b\x01\xd3\x00\x73\x00\x7e\x00\x30\x04\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x81\x00\x82\x00\x31\x04\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x73\x00\x00\x00\x74\x00\x00\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x0d\x02\x7d\x00\xd5\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\x74\x00\x7e\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\xd4\x00\x7d\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x00\x00\x00\xb8\x00\x00\x00\xb9\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x0e\x04\x0f\x04\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x00\x00\x10\x04\xd8\x00\x00\x00\x00\x00\x00\x00\xd9\x00\x00\x00\x7f\x00\x00\x00\x00\x00\x80\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x04\x12\x04\x00\x00\x00\x00\x00\x00\x7e\x00\x0e\x04\x7a\x04\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x81\x00\x82\x00\xda\x00\xdb\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x7e\x00\x0c\x02\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x00\x00\x00\x00\x00\x00\x7b\x04\x12\x04\x00\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x81\x00\x82\x00\x00\x00\x7f\x00\x00\x00\xb5\x02\x80\x00\x2f\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x03\x55\x02\x56\x02\x57\x02\x58\x02\x81\x00\x82\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x00\x82\x00\x7f\x00\x00\x00\x2d\x00\x80\x00\x2f\x00\x13\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x00\x00\x14\x04\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x61\x01\x00\x00\x00\x00\x62\x01\x00\x00\x78\x03\x00\x00\xd9\x00\x00\x00\x00\x00\x13\x04\x00\x00\x81\x00\x82\x00\xaf\x00\xb0\x00\x64\x01\x00\x00\xc8\x00\xc9\x00\xca\x00\x7f\x00\x00\x00\x00\x00\x14\x04\x2f\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x02\x2b\x00\x2c\x00\x7f\x00\x2e\x00\x2f\x00\x80\x00\x2f\x00\x00\x00\x00\x00\x81\x00\x82\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x5a\x02\x00\x00\x00\x00\x81\x00\x82\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x30\x02\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\xdf\x01\xe0\x01\xe1\x01\xe2\x01\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x17\x00\x00\x00\xe3\x01\xe4\x01\xe5\x01\xe6\x01\x99\x00\x6d\x00\x00\x00\xe7\x01\x00\x00\x6e\x00\x00\x00\x00\x00\xe8\x01\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\xee\x01\x71\x00\x72\x00\x73\x00\xef\x01\xf0\x01\x00\x00\x00\x00\x00\x00\xf1\x01\xf2\x01\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\xdf\x01\xe0\x01\xe1\x01\xe2\x01\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x17\x00\x00\x00\xe3\x01\xe4\x01\xe5\x01\xe6\x01\x99\x00\x6d\x00\x00\x00\xe7\x01\x00\x00\x6e\x00\x00\x00\x00\x00\xe8\x01\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\xee\x01\x71\x00\x72\x00\x73\x00\xef\x01\xf0\x01\x00\x00\x00\x00\x00\x00\xf1\x01\xf2\x01\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\xdf\x01\xe0\x01\xe1\x01\xe2\x01\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\xe3\x01\xe4\x01\xe5\x01\xe6\x01\x99\x00\x6d\x00\x00\x00\xe7\x01\x00\x00\x6e\x00\x00\x00\x00\x00\xe8\x01\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\xee\x01\x71\x00\x72\x00\x73\x00\xef\x01\xf0\x01\x00\x00\x00\x00\x00\x00\xf1\x01\xf2\x01\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x30\x02\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\xa5\x04\xa6\x04\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\xe3\x01\xe4\x01\xe5\x01\x00\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x04\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\xa5\x04\xa6\x04\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\xe3\x01\xe4\x01\xe5\x01\x00\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x04\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x30\x02\x00\x00\x00\x00\xb5\x02\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x61\x01\x68\x00\x69\x00\x62\x01\x6a\x00\xc8\x01\x00\x00\xd9\x00\xe3\x01\xe4\x01\xe5\x01\x00\x00\x00\x00\x6d\x00\xaf\x00\xb0\x00\x64\x01\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x30\x02\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\xb2\x04\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\xe7\x01\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x04\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x61\x01\x68\x00\x69\x00\x62\x01\x6a\x00\x78\x03\x00\x00\xd9\x00\xe3\x01\xe4\x01\xe5\x01\x00\x00\x00\x00\x6d\x00\xaf\x00\xb0\x00\x64\x01\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\x00\x00\x70\x00\x00\x00\xe9\x01\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\xb2\x04\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\xe7\x01\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x04\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\xda\x03\x55\x02\x56\x02\x57\x02\x58\x02\x00\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\xea\x01\xeb\x01\xec\x01\xed\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\xf2\x01\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\xce\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x89\x00\x00\x00\xc3\x00\x8a\x00\x00\x00\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\xd2\x00\xd3\x00\x00\x00\x6b\x03\x55\x02\x56\x02\x57\x02\x58\x02\x00\x00\x8c\x00\x8d\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x02\x2b\x00\x2c\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x5a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x92\x00\x00\x00\x6a\x00\x36\x00\x37\x00\x00\x00\xdd\x00\xb3\x00\x00\x00\xb4\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x70\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\xde\x00\x93\x00\x00\x00\xb7\x00\x00\x00\xad\x00\x00\x00\x00\x00\x00\x00\xdf\x00\x00\x00\xe0\x00\xe1\x00\xe2\x00\x8b\x00\x59\x02\x2b\x00\x2c\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x54\x02\x55\x02\x56\x02\x57\x02\x58\x02\x00\x00\x00\x00\x00\x00\x5a\x02\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\xdd\x00\xb3\x00\x6a\x00\xb4\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\xde\x00\x61\x01\x00\x00\xb7\x00\x62\x01\x00\x00\xc8\x01\x93\x00\xd9\x00\xdf\x00\x00\x00\x20\x02\x00\x00\xe2\x00\x8b\x00\xaf\x00\xb0\x00\x64\x01\x00\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\xad\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x02\x2b\x00\x2c\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x5a\x02\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\xb3\x00\x6a\x00\xb4\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x26\x02\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x93\x00\x95\x03\x56\x02\x57\x02\x58\x02\x00\x00\x61\x01\x8b\x00\x00\x00\x62\x01\x00\x00\x63\x01\x00\x00\xd9\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\xaf\x00\xb0\x00\x64\x01\x8e\x00\xc8\x00\xc9\x00\xca\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\xc2\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\xc3\x00\x8a\x00\x00\x00\xad\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x59\x02\x2b\x00\x2c\x00\x8b\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\xf4\x04\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\xb7\x02\x00\x00\x66\x01\xcf\x00\x8e\x00\xb7\x00\xf9\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x4b\x01\xd3\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x92\x00\x16\xff\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x16\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x7d\x04\xe1\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x86\x04\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\xb7\x02\x00\x00\x66\x01\xcf\x00\x8e\x00\xb7\x00\xb8\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x4b\x01\xd3\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\xce\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\xc3\x00\x00\x00\x00\x00\xcf\x00\x8e\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x4b\x01\xd3\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\xba\x02\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x24\x02\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\xbf\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\xd8\x04\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xb2\x03\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xb2\x03\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x92\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x9d\x03\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x02\x23\x00\x00\x00\x6a\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\xa9\x02\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x70\x00\xaa\x02\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x89\x00\x93\x00\x00\x00\x8a\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x92\x00\x16\xff\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x16\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x02\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x16\x04\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x84\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\x87\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x88\x00\x00\x00\x89\x00\x00\x00\x00\x00\x8a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x6a\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\xdb\x02\x70\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\xac\x01\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x93\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xe2\x02\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\xac\x01\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xab\x01\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\xac\x01\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\xb3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\xac\x01\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x52\x01\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\xc3\x00\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x5b\x01\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\xc3\x00\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x5c\x01\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x4f\x01\x45\x00\x00\x00\x00\x00\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\xcc\x00\xb3\x00\xcd\x00\xb4\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x4a\x01\xcf\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x08\x02\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x02\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\xcf\x02\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x30\x02\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x02\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\xcf\x02\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x6f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x02\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x0a\x03\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x02\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\xf1\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x4a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x32\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x25\x04\x68\x00\x69\x00\x00\x00\x6a\x00\x6b\x00\x32\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x99\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x31\x01\x00\x00\x00\x00\x00\x00\x00\x00\x71\x00\x72\x00\x73\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x8a\x03\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x01\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x03\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x8c\x03\x00\x00\x00\x00\x70\x00\x00\x00\x8d\x03\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x03\x7f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x03\x00\x00\x00\x00\x70\x00\x00\x00\x8d\x03\x00\x00\x8a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x7f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x04\x00\x00\x00\x00\x70\x00\x00\x00\xeb\x04\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x04\x00\x00\x00\x00\x70\x00\x00\x00\xeb\x04\x79\x02\x33\x00\x34\x00\x35\x00\x7a\x02\x37\x00\xfb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x00\x7b\x02\x7c\x02\x7d\x02\x7e\x02\x7f\x02\x80\x02\x81\x02\x82\x02\x83\x02\x84\x02\x85\x02\x86\x02\x87\x02\x88\x02\x0b\x01\x0c\x01\x0d\x01\x0e\x01\x0f\x01\x10\x01\x11\x01\x12\x01\x89\x02\x8a\x02\x15\x01\x8b\x02\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x8c\x02\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x01\x00\x00\x48\x00\x00\x00\x00\x00\xeb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\xeb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x3f\x01\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x00\x00\x00\x00\xeb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x00\x00\x43\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x44\x00\x00\x00\x45\x00\x00\x00\x00\x00\x46\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\xf9\x00\x00\x00\x00\x00\x00\x00\xfa\x00\x00\x00\xfb\x00\x00\x00\x4b\x00\x00\x00\x00\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x00\x00\x52\x00\x53\x00\x54\x00\x00\x00\x55\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x02\x01\x03\x01\x04\x01\x05\x01\x06\x01\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x0e\x01\x0f\x01\x10\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x32\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x00\x00\xb3\x00\x00\x00\xb4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x02\x6f\x03\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x00\x00\x5d\x02\x36\x00\x37\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x02\x00\x00\x00\x00\x5e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x5d\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5e\x02\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x33\x00\x70\x00\x00\x00\x36\x00\x37\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x70\x00\x5d\x02\x00\x00\x00\x00\x00\x00\xcc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x02\x00\x00\x00\x00\x5e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x4b\x01\xd3\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x32\x00\x33\x00\x70\x00\x00\x00\x36\x00\x37\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x02\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x70\x00\x5d\x02\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x01\x0f\x05\x00\x00\x5e\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x00\x00\x36\x00\x00\x00\x00\x00\x10\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x01\x56\x04\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x57\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\xe3\xfe\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x70\x00\x32\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x70\x00\x36\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x01\x00\x00\x00\x00\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\x00\x00\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\xe3\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x00\x00\xe3\xfe\x36\x00\x37\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x31\x01\xe3\xfe\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x9e\x01\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x9f\x01\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x81\x01\x00\x00\x00\x00\x70\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x04\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x3c\x01\x3d\x01\xe9\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x32\x00\x33\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x26\x00\xa0\x01\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x32\x00\x33\x00\x00\x00\x00\x00\x36\x00\x37\x00\x70\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x68\x00\x69\x00\x36\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x01\x00\x00\x00\x00\x70\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x33\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x9e\x01\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x32\x00\x00\x00\x68\x00\x69\x00\x36\x00\x6a\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x7f\x01\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x32\x00\x00\x00\x68\x00\x69\x00\x36\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x02\x00\x00\x00\x00\x70\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x1a\x04\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x32\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x32\x00\x00\x00\x00\x00\x70\x00\x36\x00\x37\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x01\x00\x00\x2d\x01\x00\x00\x00\x00\x32\x00\x00\x00\x00\x00\x2e\x01\x70\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x3b\x04\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x1a\x04\x00\x00\x70\x00\x00\x00\x00\x00\x32\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x6a\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3b\x04\x00\x00\x00\x00\x70\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x93\x02\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x02\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x29\x02\x00\x00\x00\x00\x00\x00\x70\x00\x32\x00\x00\x00\x00\x00\x68\x00\x69\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x65\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x02\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x04\x3b\x04\x1a\x00\x34\x01\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x32\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x23\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x29\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x2a\x02\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x00\x00\x00\x26\x00\x00\x00\x70\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x6a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x30\x00\x00\x00\x58\x00\x8f\x00\x90\x00\x91\x00\x00\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x6a\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\xc9\x02\xca\x02\xcb\x02\xcc\x02\x00\x00\xcd\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x02\xca\x02\xcb\x02\xcc\x02\x00\x00\xcd\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x03\xcb\x02\xcc\x02\x00\x00\xcd\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x03\xcc\x02\x00\x00\xcd\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x03\xc1\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\x03\xc1\x02\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\xc2\x02\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x23\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x30\x00\x00\x00\x00\x00\x69\x03\x00\x00\x06\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x02\x00\x00\x06\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\xc0\x02\xc1\x02\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x24\x00\x00\x00\x20\x00\x21\x00\x22\x00\x05\x02\x00\x00\x06\x02\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x02\x30\x00\x06\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbf\x02\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x03\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\xc2\x02\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x23\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\xed\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x04\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x30\x00\xef\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xbd\x04\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x76\x04\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xfb\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xfc\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xfd\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xff\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x3d\x04\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x93\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xd1\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xe5\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x08\x03\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xa0\x01\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xb7\x00\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x35\x01\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x36\x01\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x99\x00\x9a\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x30\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x52\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x53\x01\x54\x01\x00\x00\x00\x00\x00\x00\x55\x01\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x40\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x41\x01\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x42\x01\x00\x00\x45\x01\x56\x01\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x57\x01\x46\x01\xc8\x00\x58\x01\x59\x01\x30\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x01\x4d\x01\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x4f\x01\x50\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\xd0\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xd1\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xd1\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xd6\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xd9\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xe0\x02\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xa9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x3f\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\xb1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x43\x01\x00\x00\x44\x01\x00\x00\x00\x00\x45\x01\xd9\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\xaf\x00\xb0\x00\x00\x00\x46\x01\x00\x00\x47\x01\x48\x01\x30\x00\x96\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x96\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x03\x0e\x03\x23\x00\x00\x00\x00\x00\x0f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\xfe\x03\x29\x00\x00\x00\x00\x00\x0f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x96\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x96\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\xb4\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\xb5\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x71\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x02\x00\x00\x23\x00\x96\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\xdb\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\xdc\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x02\x23\x00\x37\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x38\x01\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x96\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x03\x05\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x97\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x5a\x04\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xf0\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\xf2\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x68\x03\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x61\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x62\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x68\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x69\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xc4\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\xc5\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xcf\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\xd4\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x91\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x92\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x93\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x94\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\xf2\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\xf4\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\xb9\x01\x1a\x00\x34\x01\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x98\x01\x29\x00\x30\x00\x99\x01\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x33\x01\x1a\x00\x34\x01\x1c\x00\x00\x00\x30\x00\x1d\x00\x1e\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x99\x01\x00\x00\x1f\x00\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x3a\x01\x00\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x01\xe9\x00\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x00\xe9\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x74\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x23\x00\x00\x00\x00\x00\x75\x02\xf6\x00\xf7\x00\x00\x00\x76\x02\x81\x03\x00\x00\x00\x00\x00\x00\x00\x00\x74\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x75\x02\xf6\x00\xf7\x00\x00\x00\x76\x02\x77\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf8\x02\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x02\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x01\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x02\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x01\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3b\x01\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\x01\x21\x00\x22\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x28\x00\x00\x00\x29\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (11, 726) [
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487),
	(488 , happyReduce_488),
	(489 , happyReduce_489),
	(490 , happyReduce_490),
	(491 , happyReduce_491),
	(492 , happyReduce_492),
	(493 , happyReduce_493),
	(494 , happyReduce_494),
	(495 , happyReduce_495),
	(496 , happyReduce_496),
	(497 , happyReduce_497),
	(498 , happyReduce_498),
	(499 , happyReduce_499),
	(500 , happyReduce_500),
	(501 , happyReduce_501),
	(502 , happyReduce_502),
	(503 , happyReduce_503),
	(504 , happyReduce_504),
	(505 , happyReduce_505),
	(506 , happyReduce_506),
	(507 , happyReduce_507),
	(508 , happyReduce_508),
	(509 , happyReduce_509),
	(510 , happyReduce_510),
	(511 , happyReduce_511),
	(512 , happyReduce_512),
	(513 , happyReduce_513),
	(514 , happyReduce_514),
	(515 , happyReduce_515),
	(516 , happyReduce_516),
	(517 , happyReduce_517),
	(518 , happyReduce_518),
	(519 , happyReduce_519),
	(520 , happyReduce_520),
	(521 , happyReduce_521),
	(522 , happyReduce_522),
	(523 , happyReduce_523),
	(524 , happyReduce_524),
	(525 , happyReduce_525),
	(526 , happyReduce_526),
	(527 , happyReduce_527),
	(528 , happyReduce_528),
	(529 , happyReduce_529),
	(530 , happyReduce_530),
	(531 , happyReduce_531),
	(532 , happyReduce_532),
	(533 , happyReduce_533),
	(534 , happyReduce_534),
	(535 , happyReduce_535),
	(536 , happyReduce_536),
	(537 , happyReduce_537),
	(538 , happyReduce_538),
	(539 , happyReduce_539),
	(540 , happyReduce_540),
	(541 , happyReduce_541),
	(542 , happyReduce_542),
	(543 , happyReduce_543),
	(544 , happyReduce_544),
	(545 , happyReduce_545),
	(546 , happyReduce_546),
	(547 , happyReduce_547),
	(548 , happyReduce_548),
	(549 , happyReduce_549),
	(550 , happyReduce_550),
	(551 , happyReduce_551),
	(552 , happyReduce_552),
	(553 , happyReduce_553),
	(554 , happyReduce_554),
	(555 , happyReduce_555),
	(556 , happyReduce_556),
	(557 , happyReduce_557),
	(558 , happyReduce_558),
	(559 , happyReduce_559),
	(560 , happyReduce_560),
	(561 , happyReduce_561),
	(562 , happyReduce_562),
	(563 , happyReduce_563),
	(564 , happyReduce_564),
	(565 , happyReduce_565),
	(566 , happyReduce_566),
	(567 , happyReduce_567),
	(568 , happyReduce_568),
	(569 , happyReduce_569),
	(570 , happyReduce_570),
	(571 , happyReduce_571),
	(572 , happyReduce_572),
	(573 , happyReduce_573),
	(574 , happyReduce_574),
	(575 , happyReduce_575),
	(576 , happyReduce_576),
	(577 , happyReduce_577),
	(578 , happyReduce_578),
	(579 , happyReduce_579),
	(580 , happyReduce_580),
	(581 , happyReduce_581),
	(582 , happyReduce_582),
	(583 , happyReduce_583),
	(584 , happyReduce_584),
	(585 , happyReduce_585),
	(586 , happyReduce_586),
	(587 , happyReduce_587),
	(588 , happyReduce_588),
	(589 , happyReduce_589),
	(590 , happyReduce_590),
	(591 , happyReduce_591),
	(592 , happyReduce_592),
	(593 , happyReduce_593),
	(594 , happyReduce_594),
	(595 , happyReduce_595),
	(596 , happyReduce_596),
	(597 , happyReduce_597),
	(598 , happyReduce_598),
	(599 , happyReduce_599),
	(600 , happyReduce_600),
	(601 , happyReduce_601),
	(602 , happyReduce_602),
	(603 , happyReduce_603),
	(604 , happyReduce_604),
	(605 , happyReduce_605),
	(606 , happyReduce_606),
	(607 , happyReduce_607),
	(608 , happyReduce_608),
	(609 , happyReduce_609),
	(610 , happyReduce_610),
	(611 , happyReduce_611),
	(612 , happyReduce_612),
	(613 , happyReduce_613),
	(614 , happyReduce_614),
	(615 , happyReduce_615),
	(616 , happyReduce_616),
	(617 , happyReduce_617),
	(618 , happyReduce_618),
	(619 , happyReduce_619),
	(620 , happyReduce_620),
	(621 , happyReduce_621),
	(622 , happyReduce_622),
	(623 , happyReduce_623),
	(624 , happyReduce_624),
	(625 , happyReduce_625),
	(626 , happyReduce_626),
	(627 , happyReduce_627),
	(628 , happyReduce_628),
	(629 , happyReduce_629),
	(630 , happyReduce_630),
	(631 , happyReduce_631),
	(632 , happyReduce_632),
	(633 , happyReduce_633),
	(634 , happyReduce_634),
	(635 , happyReduce_635),
	(636 , happyReduce_636),
	(637 , happyReduce_637),
	(638 , happyReduce_638),
	(639 , happyReduce_639),
	(640 , happyReduce_640),
	(641 , happyReduce_641),
	(642 , happyReduce_642),
	(643 , happyReduce_643),
	(644 , happyReduce_644),
	(645 , happyReduce_645),
	(646 , happyReduce_646),
	(647 , happyReduce_647),
	(648 , happyReduce_648),
	(649 , happyReduce_649),
	(650 , happyReduce_650),
	(651 , happyReduce_651),
	(652 , happyReduce_652),
	(653 , happyReduce_653),
	(654 , happyReduce_654),
	(655 , happyReduce_655),
	(656 , happyReduce_656),
	(657 , happyReduce_657),
	(658 , happyReduce_658),
	(659 , happyReduce_659),
	(660 , happyReduce_660),
	(661 , happyReduce_661),
	(662 , happyReduce_662),
	(663 , happyReduce_663),
	(664 , happyReduce_664),
	(665 , happyReduce_665),
	(666 , happyReduce_666),
	(667 , happyReduce_667),
	(668 , happyReduce_668),
	(669 , happyReduce_669),
	(670 , happyReduce_670),
	(671 , happyReduce_671),
	(672 , happyReduce_672),
	(673 , happyReduce_673),
	(674 , happyReduce_674),
	(675 , happyReduce_675),
	(676 , happyReduce_676),
	(677 , happyReduce_677),
	(678 , happyReduce_678),
	(679 , happyReduce_679),
	(680 , happyReduce_680),
	(681 , happyReduce_681),
	(682 , happyReduce_682),
	(683 , happyReduce_683),
	(684 , happyReduce_684),
	(685 , happyReduce_685),
	(686 , happyReduce_686),
	(687 , happyReduce_687),
	(688 , happyReduce_688),
	(689 , happyReduce_689),
	(690 , happyReduce_690),
	(691 , happyReduce_691),
	(692 , happyReduce_692),
	(693 , happyReduce_693),
	(694 , happyReduce_694),
	(695 , happyReduce_695),
	(696 , happyReduce_696),
	(697 , happyReduce_697),
	(698 , happyReduce_698),
	(699 , happyReduce_699),
	(700 , happyReduce_700),
	(701 , happyReduce_701),
	(702 , happyReduce_702),
	(703 , happyReduce_703),
	(704 , happyReduce_704),
	(705 , happyReduce_705),
	(706 , happyReduce_706),
	(707 , happyReduce_707),
	(708 , happyReduce_708),
	(709 , happyReduce_709),
	(710 , happyReduce_710),
	(711 , happyReduce_711),
	(712 , happyReduce_712),
	(713 , happyReduce_713),
	(714 , happyReduce_714),
	(715 , happyReduce_715),
	(716 , happyReduce_716),
	(717 , happyReduce_717),
	(718 , happyReduce_718),
	(719 , happyReduce_719),
	(720 , happyReduce_720),
	(721 , happyReduce_721),
	(722 , happyReduce_722),
	(723 , happyReduce_723),
	(724 , happyReduce_724),
	(725 , happyReduce_725),
	(726 , happyReduce_726)
	]

happy_n_terms = 148 :: Int
happy_n_nonterms = 253 :: Int

happyReduce_11 = happySpecReduce_2  0# happyReduction_11
happyReduction_11 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn14
		 (let (os,ss,l) = happy_var_1 in map (\x -> x os ss l) happy_var_2
	)}}

happyReduce_12 = happySpecReduce_2  1# happyReduction_12
happyReduction_12 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn15
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_13 = happySpecReduce_1  1# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn15
		 ([happy_var_1]
	)}

happyReduce_14 = happyMonadReduce 2# 2# happyReduction_14
happyReduction_14 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	( checkPageModule happy_var_2 happy_var_1)}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_15 = happyMonadReduce 5# 2# happyReduction_15
happyReduction_15 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 XCodeTagOpen) -> 
	case happyOut22 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 XCodeTagClose) -> 
	case happyOut17 happy_x_5 of { happy_var_5 -> 
	( let (os,ss,l) = happy_var_1 in checkHybridModule happy_var_5 (happy_var_3 os ss l) happy_var_2 happy_var_4)}}}}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_16 = happySpecReduce_2  2# happyReduction_16
happyReduction_16 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn16
		 (let (os,ss,l) = happy_var_1 in happy_var_2 os ss l
	)}}

happyReduce_17 = happyMonadReduce 9# 3# happyReduction_17
happyReduction_17 (happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	case happyOut185 happy_x_3 of { happy_var_3 -> 
	case happyOut187 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XStdTagClose) -> 
	case happyOut180 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { (Loc happy_var_7 XCloseTagOpen) -> 
	case happyOut182 happy_x_8 of { happy_var_8 -> 
	case happyOutTok happy_x_9 of { (Loc happy_var_9 XStdTagClose) -> 
	( do { n <- checkEqNames happy_var_2 happy_var_8;
                                                                       let { cn = reverse happy_var_6;
                                                                             as = reverse happy_var_3; };
                                                                       return $ XTag (happy_var_1 <^^> happy_var_9 <** [happy_var_1,happy_var_5,happy_var_7,happy_var_9]) n as happy_var_4 cn })}}}}}}}}}
	) (\r -> happyReturn (happyIn17 r))

happyReduce_18 = happyReduce 5# 3# happyReduction_18
happyReduction_18 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	case happyOut185 happy_x_3 of { happy_var_3 -> 
	case happyOut187 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XEmptyTagClose) -> 
	happyIn17
		 (XETag (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 (reverse happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_19 = happySpecReduce_3  4# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut248 happy_x_3 of { happy_var_3 -> 
	happyIn18
		 (let (os,ss,ml) = happy_var_2 in (os,happy_var_1:ss++[happy_var_3],happy_var_1 <^^> happy_var_3)
	)}}}

happyReduce_20 = happySpecReduce_3  5# happyReduction_20
happyReduction_20 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn19
		 (let (os,ss,ml) = happy_var_3;
                                                             ss' = reverse happy_var_2 ++ ss;
                                                             l'  = case happy_var_2 of
                                                                    [] -> ann happy_var_1
                                                                    _  -> ann happy_var_1 <++> nIS (last happy_var_2);
                                                         in (happy_var_1 : os, ss', Just $ l'  <+?> ml)
	)}}}

happyReduce_21 = happySpecReduce_0  5# happyReduction_21
happyReduction_21  =  happyIn19
		 (([],[],Nothing)
	)

happyReduce_22 = happyReduce 4# 6# happyReduction_22
happyReduction_22 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LANGUAGE) -> 
	case happyOut21 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn20
		 (LanguagePragma (happy_var_1 <^^> happy_var_4 <** (happy_var_1:snd happy_var_2 ++ reverse happy_var_3 ++ [happy_var_4])) (fst happy_var_2)
	) `HappyStk` happyRest}}}}

happyReduce_23 = happySpecReduce_3  6# happyReduction_23
happyReduction_23 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn20
		 (let Loc l (OPTIONS (mc, s)) = happy_var_1
                                                      in OptionsPragma (l <^^> happy_var_3 <** (l:reverse happy_var_2 ++ [happy_var_3])) (readTool mc) s
	)}}}

happyReduce_24 = happySpecReduce_3  6# happyReduction_24
happyReduction_24 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ANN) -> 
	case happyOut94 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn20
		 (AnnModulePragma (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_25 = happySpecReduce_3  7# happyReduction_25
happyReduction_25 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut238 happy_x_3 of { happy_var_3 -> 
	happyIn21
		 ((fst happy_var_1 ++ [happy_var_3], snd happy_var_1 ++ [happy_var_2])
	)}}}

happyReduce_26 = happySpecReduce_2  7# happyReduction_26
happyReduction_26 happy_x_2
	happy_x_1
	 =  case happyOut238 happy_x_2 of { happy_var_2 -> 
	happyIn21
		 (([happy_var_2],[])
	)}

happyReduce_27 = happySpecReduce_2  8# happyReduction_27
happyReduction_27 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (let (is,ds,ss1,inf) = happy_var_2
                 in \os ss l -> Module (l <++> inf <** (ss ++ ss1)) happy_var_1 os is ds
	)}}

happyReduce_28 = happyReduce 5# 9# happyReduction_28
happyReduction_28 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	case happyOut29 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 KW_Where) -> 
	happyIn23
		 (Just $ ModuleHead (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_29 = happySpecReduce_0  9# happyReduction_29
happyReduction_29  =  happyIn23
		 (Nothing
	)

happyReduce_30 = happySpecReduce_3  10# happyReduction_30
happyReduction_30 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DEPRECATED) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn24
		 (let Loc l (StringTok (s,_)) = happy_var_2 in Just $ DeprText (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3]) s
	)}}}

happyReduce_31 = happySpecReduce_3  10# happyReduction_31
happyReduction_31 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 WARNING) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn24
		 (let Loc l (StringTok (s,_)) = happy_var_2 in Just $ WarnText (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3]) s
	)}}}

happyReduce_32 = happySpecReduce_0  10# happyReduction_32
happyReduction_32  =  happyIn24
		 (Nothing
	)

happyReduce_33 = happySpecReduce_3  11# happyReduction_33
happyReduction_33 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn25
		 (let (is,ds,ss) = happy_var_2 in (is,ds,happy_var_1:ss ++ [happy_var_3], happy_var_1 <^^> happy_var_3)
	)}}}

happyReduce_34 = happyReduce 4# 11# happyReduction_34
happyReduction_34 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_2 of { happy_var_2 -> 
	case happyOut248 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (let (is,ds,ss) = happy_var_2 in (is,ds,happy_var_1:ss ++ [happy_var_3], happy_var_1 <^^> happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_35 = happyReduce 4# 12# happyReduction_35
happyReduction_35 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut35 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOut53 happy_x_4 of { happy_var_4 -> 
	happyIn26
		 ((reverse (fst happy_var_2), fst happy_var_4, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3 ++ snd happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_36 = happySpecReduce_2  12# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_2 of { happy_var_2 -> 
	happyIn26
		 (([], fst happy_var_2, reverse happy_var_1 ++ snd happy_var_2)
	)}}

happyReduce_37 = happySpecReduce_3  12# happyReduction_37
happyReduction_37 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut35 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 ((reverse (fst happy_var_2), [], reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_38 = happySpecReduce_1  12# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (([], [], reverse happy_var_1)
	)}

happyReduce_39 = happySpecReduce_2  13# happyReduction_39
happyReduction_39 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	happyIn27
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_40 = happySpecReduce_1  14# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_41 = happySpecReduce_0  14# happyReduction_41
happyReduction_41  =  happyIn28
		 ([]
	)

happyReduce_42 = happySpecReduce_1  15# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn29
		 (Just happy_var_1
	)}

happyReduce_43 = happySpecReduce_0  15# happyReduction_43
happyReduction_43  =  happyIn29
		 (Nothing
	)

happyReduce_44 = happyReduce 4# 16# happyReduction_44
happyReduction_44 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut32 happy_x_2 of { happy_var_2 -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn30
		 (ExportSpecList (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse (snd happy_var_2) ++ happy_var_3 ++ [happy_var_4])) (reverse (fst happy_var_2))
	) `HappyStk` happyRest}}}}

happyReduce_45 = happySpecReduce_3  16# happyReduction_45
happyReduction_45 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn30
		 (ExportSpecList (happy_var_1 <^^> happy_var_3 <** (happy_var_1:happy_var_2++[happy_var_3])) []
	)}}}

happyReduce_46 = happySpecReduce_1  17# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Comma) -> 
	happyIn31
		 ([happy_var_1]
	)}

happyReduce_47 = happySpecReduce_0  17# happyReduction_47
happyReduction_47  =  happyIn31
		 ([  ]
	)

happyReduce_48 = happySpecReduce_3  18# happyReduction_48
happyReduction_48 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_49 = happySpecReduce_1  18# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 (([happy_var_1],[])
	)}

happyReduce_50 = happySpecReduce_1  19# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOut220 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (EVar (ann happy_var_1) happy_var_1
	)}

happyReduce_51 = happyMonadReduce 2# 19# happyReduction_51
happyReduction_51 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut34 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled ExplicitNamespaces;
                                                      return (EAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (TypeNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_52 = happySpecReduce_1  19# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOut258 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (EAbs (ann happy_var_1) (NoNamespace (ann happy_var_1)) happy_var_1
	)}

happyReduce_53 = happyReduce 4# 19# happyReduction_53
happyReduction_53 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut258 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DotDot) -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn33
		 (EThingAll  (ann happy_var_1 <++> nIS happy_var_4 <** [happy_var_2,happy_var_3,happy_var_4]) happy_var_1
	) `HappyStk` happyRest}}}}

happyReduce_54 = happySpecReduce_3  19# happyReduction_54
happyReduction_54 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut258 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn33
		 (EThingWith (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3])    happy_var_1 []
	)}}}

happyReduce_55 = happyReduce 4# 19# happyReduction_55
happyReduction_55 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut258 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn33
		 (EThingWith (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) happy_var_1 (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}

happyReduce_56 = happySpecReduce_2  19# happyReduction_56
happyReduction_56 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	happyIn33
		 (EModuleContents (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_57 = happyMonadReduce 2# 19# happyReduction_57
happyReduction_57 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut223 happy_x_2 of { happy_var_2 -> 
	(  do { checkEnabled PatternSynonyms;
                                                      return $ EAbs (nIS happy_var_1 <++> (ann happy_var_2) <** [happy_var_1])
                                                                 (PatternNamespace (nIS happy_var_1)) happy_var_2 })}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_58 = happySpecReduce_1  20# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOut220 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 (happy_var_1
	)}

happyReduce_59 = happySpecReduce_1  20# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 (happy_var_1
	)}

happyReduce_60 = happySpecReduce_3  21# happyReduction_60
happyReduction_60 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut36 happy_x_3 of { happy_var_3 -> 
	happyIn35
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_61 = happySpecReduce_1  21# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	happyIn35
		 (([happy_var_1],[])
	)}

happyReduce_62 = happyReduce 8# 22# happyReduction_62
happyReduction_62 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Import) -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	case happyOut40 happy_x_5 of { happy_var_5 -> 
	case happyOut256 happy_x_6 of { happy_var_6 -> 
	case happyOut41 happy_x_7 of { happy_var_7 -> 
	case happyOut42 happy_x_8 of { happy_var_8 -> 
	happyIn36
		 (let { (mmn,ss,ml) = happy_var_7 ;
                                      l = nIS happy_var_1 <++> ann happy_var_6 <+?> ml <+?> (fmap ann) happy_var_8 <** (happy_var_1:snd happy_var_2 ++ snd happy_var_3 ++ snd happy_var_4 ++ snd happy_var_5 ++ ss)}
                                 in ImportDecl l happy_var_6 (fst happy_var_4) (fst happy_var_2) (fst happy_var_3) (fst happy_var_5) mmn happy_var_8
	) `HappyStk` happyRest}}}}}}}}

happyReduce_63 = happySpecReduce_2  23# happyReduction_63
happyReduction_63 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SOURCE) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	happyIn37
		 ((True,[happy_var_1,happy_var_2])
	)}}

happyReduce_64 = happySpecReduce_0  23# happyReduction_64
happyReduction_64  =  happyIn37
		 ((False,[])
	)

happyReduce_65 = happyMonadReduce 1# 24# happyReduction_65
happyReduction_65 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	( do { checkEnabledOneOf [Safe, SafeImports, Trustworthy] ;
                                                 return (True, [happy_var_1]) })}
	) (\r -> happyReturn (happyIn38 r))

happyReduce_66 = happySpecReduce_0  24# happyReduction_66
happyReduction_66  =  happyIn38
		 ((False, [])
	)

happyReduce_67 = happySpecReduce_1  25# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn39
		 ((True,[happy_var_1])
	)}

happyReduce_68 = happySpecReduce_0  25# happyReduction_68
happyReduction_68  =  happyIn39
		 ((False, [])
	)

happyReduce_69 = happyMonadReduce 1# 26# happyReduction_69
happyReduction_69 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( do { checkEnabled PackageImports ;
                                                      let { Loc l (StringTok (s,_)) = happy_var_1 } ;
                                                      return $ (Just s,[l]) })}
	) (\r -> happyReturn (happyIn40 r))

happyReduce_70 = happySpecReduce_0  26# happyReduction_70
happyReduction_70  =  happyIn40
		 ((Nothing,[])
	)

happyReduce_71 = happySpecReduce_2  27# happyReduction_71
happyReduction_71 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	case happyOut256 happy_x_2 of { happy_var_2 -> 
	happyIn41
		 ((Just happy_var_2,[happy_var_1],Just (nIS happy_var_1 <++> ann happy_var_2))
	)}}

happyReduce_72 = happySpecReduce_0  27# happyReduction_72
happyReduction_72  =  happyIn41
		 ((Nothing,[],Nothing)
	)

happyReduce_73 = happySpecReduce_1  28# happyReduction_73
happyReduction_73 happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	happyIn42
		 (Just happy_var_1
	)}

happyReduce_74 = happySpecReduce_0  28# happyReduction_74
happyReduction_74  =  happyIn42
		 (Nothing
	)

happyReduce_75 = happyReduce 5# 29# happyReduction_75
happyReduction_75 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn43
		 (let {(b,ml,s) = happy_var_1 ;
                                                      l = (ml <?+> (happy_var_2 <^^> happy_var_5)) <** (s ++ happy_var_2:reverse (snd happy_var_3) ++ happy_var_4 ++ [happy_var_5])}
                                                 in ImportSpecList l b (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}}

happyReduce_76 = happyReduce 4# 29# happyReduction_76
happyReduction_76 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn43
		 (let {(b,ml,s) = happy_var_1 ; l = (ml <?+> (happy_var_2 <^^> happy_var_4)) <** (s ++ happy_var_2:happy_var_3 ++ [happy_var_4])}
                                                 in ImportSpecList l b []
	) `HappyStk` happyRest}}}}

happyReduce_77 = happySpecReduce_1  30# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn44
		 ((True,Just (nIS happy_var_1),[happy_var_1])
	)}

happyReduce_78 = happySpecReduce_0  30# happyReduction_78
happyReduction_78  =  happyIn44
		 ((False,Nothing,[])
	)

happyReduce_79 = happySpecReduce_3  31# happyReduction_79
happyReduction_79 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut46 happy_x_3 of { happy_var_3 -> 
	happyIn45
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_80 = happySpecReduce_1  31# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn45
		 (([happy_var_1],[])
	)}

happyReduce_81 = happySpecReduce_1  32# happyReduction_81
happyReduction_81 happy_x_1
	 =  case happyOut218 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 (IVar (ann happy_var_1) happy_var_1
	)}

happyReduce_82 = happyMonadReduce 2# 32# happyReduction_82
happyReduction_82 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut218 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled ExplicitNamespaces;
                                                      return (IAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (TypeNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}}
	) (\r -> happyReturn (happyIn46 r))

happyReduce_83 = happyMonadReduce 2# 32# happyReduction_83
happyReduction_83 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut222 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled PatternSynonyms;
                                                      return (IAbs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1, srcInfoSpan (ann happy_var_2)]) (PatternNamespace (nIS happy_var_1 <** [happy_var_1])) happy_var_2) })}}
	) (\r -> happyReturn (happyIn46 r))

happyReduce_84 = happySpecReduce_1  32# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 (IAbs (ann happy_var_1) (NoNamespace (ann happy_var_1)) happy_var_1
	)}

happyReduce_85 = happyReduce 4# 32# happyReduction_85
happyReduction_85 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut257 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DotDot) -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn46
		 (IThingAll  (ann happy_var_1 <++> nIS happy_var_4 <** [happy_var_2,happy_var_3,happy_var_4]) happy_var_1
	) `HappyStk` happyRest}}}}

happyReduce_86 = happySpecReduce_3  32# happyReduction_86
happyReduction_86 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut257 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn46
		 (IThingWith (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3])    happy_var_1 []
	)}}}

happyReduce_87 = happyReduce 4# 32# happyReduction_87
happyReduction_87 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut257 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn46
		 (IThingWith (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) happy_var_1 (reverse (fst happy_var_3))
	) `HappyStk` happyRest}}}}

happyReduce_88 = happySpecReduce_3  33# happyReduction_88
happyReduction_88 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_89 = happySpecReduce_1  33# happyReduction_89
happyReduction_89 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (([happy_var_1],[])
	)}

happyReduce_90 = happySpecReduce_1  34# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOut218 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (VarName (ann happy_var_1) happy_var_1
	)}

happyReduce_91 = happySpecReduce_1  34# happyReduction_91
happyReduction_91 happy_x_1
	 =  case happyOut222 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (ConName (ann happy_var_1) happy_var_1
	)}

happyReduce_92 = happySpecReduce_3  35# happyReduction_92
happyReduction_92 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	case happyOut52 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (let (ops,ss,l) = happy_var_3
                                                 in InfixDecl (ann happy_var_1 <++> l <** (snd happy_var_2 ++ reverse ss)) happy_var_1 (fst happy_var_2) (reverse ops)
	)}}}

happyReduce_93 = happySpecReduce_0  36# happyReduction_93
happyReduction_93  =  happyIn50
		 ((Nothing, [])
	)

happyReduce_94 = happyMonadReduce 1# 36# happyReduction_94
happyReduction_94 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	( let Loc l (IntTok (i,_)) = happy_var_1 in checkPrec i >>= \i -> return (Just i, [l]))}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_95 = happySpecReduce_1  37# happyReduction_95
happyReduction_95 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Infix) -> 
	happyIn51
		 (AssocNone  $ nIS happy_var_1
	)}

happyReduce_96 = happySpecReduce_1  37# happyReduction_96
happyReduction_96 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixL) -> 
	happyIn51
		 (AssocLeft  $ nIS happy_var_1
	)}

happyReduce_97 = happySpecReduce_1  37# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixR) -> 
	happyIn51
		 (AssocRight $ nIS happy_var_1
	)}

happyReduce_98 = happySpecReduce_3  38# happyReduction_98
happyReduction_98 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut229 happy_x_3 of { happy_var_3 -> 
	happyIn52
		 (let (ops,ss,l) = happy_var_1 in (happy_var_3 : ops, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_99 = happySpecReduce_1  38# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOut229 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_100 = happyMonadReduce 2# 39# happyReduction_100
happyReduction_100 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	( checkRevDecls (fst happy_var_1) >>= \ds -> return (ds, snd happy_var_1 ++ reverse happy_var_2))}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_101 = happySpecReduce_3  40# happyReduction_101
happyReduction_101 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut55 happy_x_3 of { happy_var_3 -> 
	happyIn54
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_102 = happySpecReduce_1  40# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (([happy_var_1],[])
	)}

happyReduce_103 = happyMonadReduce 1# 41# happyReduction_103
happyReduction_103 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut56 happy_x_1 of { happy_var_1 -> 
	( checkEnabled RoleAnnotations >> return happy_var_1)}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_104 = happyMonadReduce 4# 41# happyReduction_104
happyReduction_104 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut96 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut107 happy_x_4 of { happy_var_4 -> 
	( do { dh <- checkSimpleType happy_var_2;
                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]};
                       return (TypeDecl l dh happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_105 = happyMonadReduce 5# 41# happyReduction_105
happyReduction_105 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Family) -> 
	case happyOut98 happy_x_3 of { happy_var_3 -> 
	case happyOut140 happy_x_4 of { happy_var_4 -> 
	case happyOut60 happy_x_5 of { happy_var_5 -> 
	( do { dh <- checkSimpleType happy_var_3;
                       let {l = nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) (fst happy_var_4) <** (happy_var_1:happy_var_2:snd happy_var_4)};
                       case happy_var_5 of {
                         Nothing    -> return (TypeFamDecl l dh (fst happy_var_4));
                         Just (x,a) -> return (ClosedTypeFamDecl (l <** [a]) dh (fst happy_var_4) x); }})}}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_106 = happyMonadReduce 5# 41# happyReduction_106
happyReduction_106 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Equals) -> 
	case happyOut107 happy_x_5 of { happy_var_5 -> 
	( do { -- no checkSimpleType happy_var_4 since dtype may contain type patterns
                       checkEnabled TypeFamilies ;
                       let {l = nIS happy_var_1 <++> ann happy_var_5 <** [happy_var_1,happy_var_2,happy_var_4]};
                       return (TypeInsDecl l happy_var_3 happy_var_5) })}}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_107 = happyMonadReduce 4# 41# happyReduction_107
happyReduction_107 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOut131 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                       let { (qds,ss,minf) = happy_var_3;
                             l = happy_var_1 <> happy_var_2 <+?> minf <+?> fmap ann happy_var_4 <** ss};
                       checkDataOrNew happy_var_1 qds;
                       return (DataDecl l happy_var_1 cs dh (reverse qds) happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_108 = happyMonadReduce 5# 41# happyReduction_108
happyReduction_108 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOut140 happy_x_3 of { happy_var_3 -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	case happyOut131 happy_x_5 of { happy_var_5 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                       let { (gs,ss,minf) = happy_var_4;
                             l = ann happy_var_1 <+?> minf <+?> fmap ann happy_var_5 <** (snd happy_var_3 ++ ss)};
                       checkDataOrNewG happy_var_1 gs;
                       case (gs, fst happy_var_3) of
                        ([], Nothing) -> return (DataDecl l happy_var_1 cs dh [] happy_var_5)
                        _ -> checkEnabled GADTs >> return (GDataDecl l happy_var_1 cs dh (fst happy_var_3) (reverse gs) happy_var_5) })}}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_109 = happyMonadReduce 4# 41# happyReduction_109
happyReduction_109 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Family) -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	case happyOut140 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_3;
                       let {l = nIS happy_var_1 <++> ann happy_var_3 <+?> (fmap ann) (fst happy_var_4) <** (happy_var_1:happy_var_2:snd happy_var_4)};
                       return (DataFamDecl l cs dh (fst happy_var_4)) })}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_110 = happyMonadReduce 5# 41# happyReduction_110
happyReduction_110 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut123 happy_x_4 of { happy_var_4 -> 
	case happyOut131 happy_x_5 of { happy_var_5 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       checkEnabled TypeFamilies ;
                       let { (qds,ss,minf) = happy_var_4 ;
                             l = happy_var_1 <> happy_var_3 <+?> minf <+?> fmap ann happy_var_5 <** happy_var_2:ss };
                       checkDataOrNew happy_var_1 qds;
                       return (DataInsDecl l happy_var_1 happy_var_3 (reverse qds) happy_var_5) })}}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_111 = happyMonadReduce 6# 41# happyReduction_111
happyReduction_111 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	case happyOut140 happy_x_4 of { happy_var_4 -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	case happyOut131 happy_x_6 of { happy_var_6 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       checkEnabled TypeFamilies ;
                       let {(gs,ss,minf) = happy_var_5;
                            l = ann happy_var_1 <+?> minf <+?> fmap ann happy_var_6 <** (happy_var_2:snd happy_var_4 ++ ss)};
                       checkDataOrNewG happy_var_1 gs;
                       return (GDataInsDecl l happy_var_1 happy_var_3 (fst happy_var_4) (reverse gs) happy_var_6) })}}}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_112 = happyMonadReduce 4# 41# happyReduction_112
happyReduction_112 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Class) -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOut116 happy_x_3 of { happy_var_3 -> 
	case happyOut141 happy_x_4 of { happy_var_4 -> 
	( do { (cs,dh) <- checkClassHeader happy_var_2;
                       let {(fds,ss1,minf1) = happy_var_3;(mcs,ss2,minf2) = happy_var_4} ;
                       let { l = nIS happy_var_1 <++> ann happy_var_2 <+?> minf1 <+?> minf2 <** (happy_var_1:ss1 ++ ss2)} ;
                       return (ClassDecl l cs dh fds mcs) })}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_113 = happyMonadReduce 4# 41# happyReduction_113
happyReduction_113 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Instance) -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	case happyOut146 happy_x_4 of { happy_var_4 -> 
	( do { ih <- checkInstHeader happy_var_3;
                       let {(mis,ss,minf) = happy_var_4};
                       return (InstDecl (nIS happy_var_1 <++> ann happy_var_3 <+?> minf <** (happy_var_1:ss)) happy_var_2 ih mis) })}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_114 = happyMonadReduce 4# 41# happyReduction_114
happyReduction_114 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut59 happy_x_3 of { happy_var_3 -> 
	case happyOut108 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled StandaloneDeriving ;
                       ih <- checkInstHeader happy_var_4;
                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_2]};
                       return (DerivDecl l happy_var_3 ih) })}}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_115 = happyReduce 4# 41# happyReduction_115
happyReduction_115 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut65 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn55
		 (DefaultDecl (happy_var_1 <^^> happy_var_4 <** (happy_var_1:happy_var_2 : snd happy_var_3 ++ [happy_var_4])) (fst happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_116 = happyMonadReduce 1# 41# happyReduction_116
happyReduction_116 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut159 happy_x_1 of { happy_var_1 -> 
	( do
              checkToplevel happy_var_1
              checkExpr happy_var_1 >>= \e -> return (SpliceDecl (ann e) e))}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_117 = happyReduce 5# 41# happyReduction_117
happyReduction_117 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Import) -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	case happyOut82 happy_x_4 of { happy_var_4 -> 
	case happyOut83 happy_x_5 of { happy_var_5 -> 
	happyIn55
		 (let (s,n,t,ss) = happy_var_5 in ForImp (nIS happy_var_1 <++> ann t <** (happy_var_1:happy_var_2:ss)) happy_var_3 happy_var_4 s n t
	) `HappyStk` happyRest}}}}}

happyReduce_118 = happyReduce 4# 41# happyReduction_118
happyReduction_118 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Export) -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	case happyOut83 happy_x_4 of { happy_var_4 -> 
	happyIn55
		 (let (s,n,t,ss) = happy_var_4 in ForExp (nIS happy_var_1 <++> ann t <** (happy_var_1:happy_var_2:ss)) happy_var_3    s n t
	) `HappyStk` happyRest}}}}

happyReduce_119 = happySpecReduce_3  41# happyReduction_119
happyReduction_119 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RULES) -> 
	case happyOut84 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn55
		 (RulePragmaDecl (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) $ reverse happy_var_2
	)}}}

happyReduce_120 = happySpecReduce_3  41# happyReduction_120
happyReduction_120 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DEPRECATED) -> 
	case happyOut90 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn55
		 (DeprPragmaDecl (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_121 = happySpecReduce_3  41# happyReduction_121
happyReduction_121 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 WARNING) -> 
	case happyOut90 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn55
		 (WarnPragmaDecl (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_122 = happySpecReduce_3  41# happyReduction_122
happyReduction_122 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ANN) -> 
	case happyOut94 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn55
		 (AnnPragma      (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_123 = happySpecReduce_1  41# happyReduction_123
happyReduction_123 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (happy_var_1
	)}

happyReduce_124 = happyMonadReduce 4# 42# happyReduction_124
happyReduction_124 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Role) -> 
	case happyOut105 happy_x_3 of { happy_var_3 -> 
	case happyOut57 happy_x_4 of { happy_var_4 -> 
	( mkRoleAnnotDecl happy_var_1 happy_var_2 happy_var_3 (reverse happy_var_4))}}}}
	) (\r -> happyReturn (happyIn56 r))

happyReduce_125 = happySpecReduce_0  43# happyReduction_125
happyReduction_125  =  happyIn57
		 ([]
	)

happyReduce_126 = happySpecReduce_2  43# happyReduction_126
happyReduction_126 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	happyIn57
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_127 = happySpecReduce_1  44# happyReduction_127
happyReduction_127 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn58
		 (let (VarId v) = unLoc happy_var_1 in (Just v, nIS $ loc happy_var_1)
	)}

happyReduce_128 = happySpecReduce_1  44# happyReduction_128
happyReduction_128 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn58
		 ((Nothing, nIS happy_var_1)
	)}

happyReduce_129 = happySpecReduce_2  45# happyReduction_129
happyReduction_129 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 OVERLAP) -> 
	happyIn59
		 (Just (Overlap (nIS happy_var_1))
	)}

happyReduce_130 = happySpecReduce_2  45# happyReduction_130
happyReduction_130 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 INCOHERENT) -> 
	happyIn59
		 (Just (Incoherent (nIS happy_var_1))
	)}

happyReduce_131 = happySpecReduce_2  45# happyReduction_131
happyReduction_131 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 NO_OVERLAP) -> 
	happyIn59
		 (Just (NoOverlap (nIS happy_var_1))
	)}

happyReduce_132 = happySpecReduce_0  45# happyReduction_132
happyReduction_132  =  happyIn59
		 (Nothing
	)

happyReduce_133 = happySpecReduce_0  46# happyReduction_133
happyReduction_133  =  happyIn60
		 (Nothing
	)

happyReduce_134 = happySpecReduce_2  46# happyReduction_134
happyReduction_134 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut61 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (Just (happy_var_2, happy_var_1)
	)}}

happyReduce_135 = happySpecReduce_3  47# happyReduction_135
happyReduction_135 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn61
		 (happy_var_2
	)}

happyReduce_136 = happySpecReduce_3  47# happyReduction_136
happyReduction_136 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn61
		 (happy_var_2
	)}

happyReduce_137 = happySpecReduce_3  48# happyReduction_137
happyReduction_137 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 (happy_var_1 ++ [happy_var_3]
	)}}

happyReduce_138 = happySpecReduce_2  48# happyReduction_138
happyReduction_138 happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 (happy_var_1
	)}

happyReduce_139 = happySpecReduce_1  48# happyReduction_139
happyReduction_139 happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 ([happy_var_1]
	)}

happyReduce_140 = happyMonadReduce 3# 49# happyReduction_140
happyReduction_140 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut95 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled TypeFamilies ;
                        return (TypeEqn (ann happy_var_1 <++> ann happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3) })}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_141 = happySpecReduce_1  50# happyReduction_141
happyReduction_141 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	happyIn64
		 (DataType $ nIS happy_var_1
	)}

happyReduce_142 = happySpecReduce_1  50# happyReduction_142
happyReduction_142 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_NewType) -> 
	happyIn64
		 (NewType  $ nIS happy_var_1
	)}

happyReduce_143 = happyMonadReduce 1# 51# happyReduction_143
happyReduction_143 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut110 happy_x_1 of { happy_var_1 -> 
	( do { ts <- mapM checkType (fst happy_var_1);
                                              return $ (reverse ts, reverse (snd happy_var_1)) })}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_144 = happySpecReduce_1  51# happyReduction_144
happyReduction_144 happy_x_1
	 =  case happyOut97 happy_x_1 of { happy_var_1 -> 
	happyIn65
		 (([happy_var_1],[])
	)}

happyReduce_145 = happySpecReduce_0  51# happyReduction_145
happyReduction_145  =  happyIn65
		 (([],[])
	)

happyReduce_146 = happyMonadReduce 3# 52# happyReduction_146
happyReduction_146 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut67 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevDecls (fst happy_var_2) >>= \ds -> return (ds, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}}
	) (\r -> happyReturn (happyIn66 r))

happyReduce_147 = happySpecReduce_1  52# happyReduction_147
happyReduction_147 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (([],reverse happy_var_1)
	)}

happyReduce_148 = happySpecReduce_3  53# happyReduction_148
happyReduction_148 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut68 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_149 = happySpecReduce_1  53# happyReduction_149
happyReduction_149 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (([happy_var_1],[])
	)}

happyReduce_150 = happySpecReduce_1  54# happyReduction_150
happyReduction_150 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_151 = happySpecReduce_1  54# happyReduction_151
happyReduction_151 happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_152 = happySpecReduce_1  54# happyReduction_152
happyReduction_152 happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_153 = happySpecReduce_1  54# happyReduction_153
happyReduction_153 happy_x_1
	 =  case happyOut249 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_154 = happySpecReduce_1  54# happyReduction_154
happyReduction_154 happy_x_1
	 =  case happyOut254 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_155 = happySpecReduce_3  55# happyReduction_155
happyReduction_155 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn69
		 (BDecls (happy_var_1 <^^> happy_var_3 <** (happy_var_1:snd happy_var_2++[happy_var_3])) (fst happy_var_2)
	)}}}

happyReduce_156 = happySpecReduce_3  55# happyReduction_156
happyReduction_156 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	case happyOut248 happy_x_3 of { happy_var_3 -> 
	happyIn69
		 (let l' = if null (fst happy_var_2) then nIS happy_var_3 else (ann . last $ fst happy_var_2)
                                         in BDecls (nIS happy_var_1 <++> l' <** (happy_var_1:snd happy_var_2++[happy_var_3])) (fst happy_var_2)
	)}}}

happyReduce_157 = happySpecReduce_1  56# happyReduction_157
happyReduction_157 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_158 = happySpecReduce_1  56# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_159 = happyMonadReduce 3# 57# happyReduction_159
happyReduction_159 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	( do { v <- checkSigVar happy_var_1;
                                                               return $ TypeSig (happy_var_1 <> happy_var_3 <** [happy_var_2]) [v] happy_var_3 })}}}
	) (\r -> happyReturn (happyIn71 r))

happyReduce_160 = happyMonadReduce 5# 57# happyReduction_160
happyReduction_160 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut107 happy_x_5 of { happy_var_5 -> 
	( do { v <- checkSigVar happy_var_1;
                                                               let {(vs,ss,_) = happy_var_3 ; l = happy_var_1 <> happy_var_5 <** (happy_var_2 : reverse ss ++ [happy_var_4]) } ;
                                                               return $ TypeSig l (v : reverse vs) happy_var_5 })}}}}}
	) (\r -> happyReturn (happyIn71 r))

happyReduce_161 = happyReduce 4# 58# happyReduction_161
happyReduction_161 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOut220 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn72
		 (let Loc l (INLINE s) = happy_var_1 in InlineSig (l <^^> happy_var_4 <** [l,happy_var_4]) s happy_var_2 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_162 = happyReduce 4# 58# happyReduction_162
happyReduction_162 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 INLINE_CONLIKE) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOut220 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	happyIn72
		 (InlineConlikeSig (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_4]) happy_var_2 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_163 = happyReduce 6# 58# happyReduction_163
happyReduction_163 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 SPECIALISE) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOut220 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut73 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 PragmaEnd) -> 
	happyIn72
		 (SpecSig (happy_var_1 <^^> happy_var_6 <** (happy_var_1: happy_var_4 : snd happy_var_5 ++ [happy_var_6])) happy_var_2 happy_var_3 (fst happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_164 = happyReduce 6# 58# happyReduction_164
happyReduction_164 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOut220 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleColon) -> 
	case happyOut73 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 PragmaEnd) -> 
	happyIn72
		 (let Loc l (SPECIALISE_INLINE s) = happy_var_1
               in SpecInlineSig (l <^^> happy_var_6 <** (l:happy_var_4:snd happy_var_5++[happy_var_6])) s happy_var_2 happy_var_3 (fst happy_var_5)
	) `HappyStk` happyRest}}}}}}

happyReduce_165 = happyMonadReduce 4# 58# happyReduction_165
happyReduction_165 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 SPECIALISE) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 PragmaEnd) -> 
	( do { ih <- checkInstHeader happy_var_3;
                                                               let {l = happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_2,happy_var_4]};
                                                               return $ InstSig l ih })}}}}
	) (\r -> happyReturn (happyIn72 r))

happyReduce_166 = happySpecReduce_3  58# happyReduction_166
happyReduction_166 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 MINIMAL) -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	happyIn72
		 (MinimalPragma (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_167 = happySpecReduce_1  59# happyReduction_167
happyReduction_167 happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	happyIn73
		 (([happy_var_1],[])
	)}

happyReduce_168 = happySpecReduce_3  59# happyReduction_168
happyReduction_168 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	happyIn73
		 ((happy_var_1 : fst happy_var_3, happy_var_2 : snd happy_var_3)
	)}}}

happyReduce_169 = happyMonadReduce 1# 60# happyReduction_169
happyReduction_169 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut108 happy_x_1 of { happy_var_1 -> 
	( checkType $ mkTyForall (ann happy_var_1) Nothing Nothing happy_var_1)}
	) (\r -> happyReturn (happyIn74 r))

happyReduce_170 = happySpecReduce_1  61# happyReduction_170
happyReduction_170 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (Just happy_var_1
	)}

happyReduce_171 = happySpecReduce_0  61# happyReduction_171
happyReduction_171  =  happyIn75
		 (Nothing
	)

happyReduce_172 = happySpecReduce_1  62# happyReduction_172
happyReduction_172 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn76
		 (happy_var_1
	)}

happyReduce_173 = happySpecReduce_3  62# happyReduction_173
happyReduction_173 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut76 happy_x_3 of { happy_var_3 -> 
	happyIn76
		 (OrFormula (ann happy_var_1 <++>  ann happy_var_3 <** [happy_var_2]) [happy_var_1,happy_var_3]
	)}}}

happyReduce_174 = happySpecReduce_1  63# happyReduction_174
happyReduction_174 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_175 = happySpecReduce_3  63# happyReduction_175
happyReduction_175 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (AndFormula (ann happy_var_1 <++> ann happy_var_3 <** [happy_var_2]) [happy_var_1,happy_var_3]
	)}}}

happyReduce_176 = happySpecReduce_3  64# happyReduction_176
happyReduction_176 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut76 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn78
		 (ParenFormula (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_177 = happySpecReduce_1  64# happyReduction_177
happyReduction_177 happy_x_1
	 =  case happyOut218 happy_x_1 of { happy_var_1 -> 
	happyIn78
		 (VarFormula (ann happy_var_1) happy_var_1
	)}

happyReduce_178 = happySpecReduce_1  65# happyReduction_178
happyReduction_178 happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 (happy_var_1
	)}

happyReduce_179 = happySpecReduce_3  65# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut214 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn79
		 (IPBinds (happy_var_1 <^^> happy_var_3 <** snd happy_var_2) (fst happy_var_2)
	)}}}

happyReduce_180 = happySpecReduce_3  65# happyReduction_180
happyReduction_180 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut214 happy_x_2 of { happy_var_2 -> 
	happyIn79
		 (let l' =  ann . last $ fst happy_var_2
                                         in IPBinds (nIS happy_var_1 <++> l' <** snd happy_var_2) (fst happy_var_2)
	)}}

happyReduce_181 = happySpecReduce_3  66# happyReduction_181
happyReduction_181 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut218 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (let (ns,ss,l) = happy_var_1 in (happy_var_3 : ns, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_182 = happyMonadReduce 1# 66# happyReduction_182
happyReduction_182 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut220 happy_x_1 of { happy_var_1 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return ([n],[],ann n) })}
	) (\r -> happyReturn (happyIn80 r))

happyReduce_183 = happySpecReduce_1  67# happyReduction_183
happyReduction_183 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn81
		 (StdCall    (nIS happy_var_1)
	)}

happyReduce_184 = happySpecReduce_1  67# happyReduction_184
happyReduction_184 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn81
		 (CCall      (nIS happy_var_1)
	)}

happyReduce_185 = happySpecReduce_1  67# happyReduction_185
happyReduction_185 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn81
		 (CPlusPlus  (nIS happy_var_1)
	)}

happyReduce_186 = happySpecReduce_1  67# happyReduction_186
happyReduction_186 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn81
		 (DotNet     (nIS happy_var_1)
	)}

happyReduce_187 = happySpecReduce_1  67# happyReduction_187
happyReduction_187 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn81
		 (Jvm        (nIS happy_var_1)
	)}

happyReduce_188 = happySpecReduce_1  67# happyReduction_188
happyReduction_188 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn81
		 (Js         (nIS happy_var_1)
	)}

happyReduce_189 = happySpecReduce_1  67# happyReduction_189
happyReduction_189 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn81
		 (JavaScript (nIS happy_var_1)
	)}

happyReduce_190 = happySpecReduce_1  67# happyReduction_190
happyReduction_190 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn81
		 (CApi       (nIS happy_var_1)
	)}

happyReduce_191 = happySpecReduce_1  68# happyReduction_191
happyReduction_191 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn82
		 (Just $ PlaySafe  (nIS happy_var_1) False
	)}

happyReduce_192 = happySpecReduce_1  68# happyReduction_192
happyReduction_192 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn82
		 (Just $ PlayRisky (nIS happy_var_1)
	)}

happyReduce_193 = happySpecReduce_1  68# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn82
		 (Just $ PlaySafe  (nIS happy_var_1) True
	)}

happyReduce_194 = happySpecReduce_1  68# happyReduction_194
happyReduction_194 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn82
		 (Just $ PlayInterruptible (nIS happy_var_1)
	)}

happyReduce_195 = happySpecReduce_0  68# happyReduction_195
happyReduction_195  =  happyIn82
		 (Nothing
	)

happyReduce_196 = happyReduce 4# 69# happyReduction_196
happyReduction_196 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut219 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut95 happy_x_4 of { happy_var_4 -> 
	happyIn83
		 (let Loc l (StringTok (s,_)) = happy_var_1 in (Just s, happy_var_2, happy_var_4, [l,happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_197 = happySpecReduce_3  69# happyReduction_197
happyReduction_197 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut219 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	happyIn83
		 ((Nothing, happy_var_1, happy_var_3, [happy_var_2])
	)}}}

happyReduce_198 = happySpecReduce_3  70# happyReduction_198
happyReduction_198 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	case happyOut85 happy_x_3 of { happy_var_3 -> 
	happyIn84
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_199 = happySpecReduce_2  70# happyReduction_199
happyReduction_199 happy_x_2
	happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 (happy_var_1
	)}

happyReduce_200 = happySpecReduce_1  70# happyReduction_200
happyReduction_200 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 ([happy_var_1]
	)}

happyReduce_201 = happySpecReduce_0  70# happyReduction_201
happyReduction_201  =  happyIn84
		 ([]
	)

happyReduce_202 = happyMonadReduce 6# 71# happyReduction_202
happyReduction_202 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOut87 happy_x_3 of { happy_var_3 -> 
	case happyOut159 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 Equals) -> 
	case happyOut157 happy_x_6 of { happy_var_6 -> 
	( do { let {Loc l (StringTok (s,_)) = happy_var_1};
                                                                  e <- checkRuleExpr happy_var_4;
                                                                  return $ Rule (nIS l <++> ann happy_var_6 <** l:snd happy_var_3 ++ [happy_var_5]) s happy_var_2 (fst happy_var_3) e happy_var_6 })}}}}}}
	) (\r -> happyReturn (happyIn85 r))

happyReduce_203 = happySpecReduce_0  72# happyReduction_203
happyReduction_203  =  happyIn86
		 (Nothing
	)

happyReduce_204 = happySpecReduce_3  72# happyReduction_204
happyReduction_204 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn86
		 (let Loc l (IntTok (i,_)) = happy_var_2 in Just $ ActiveFrom  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,l,happy_var_3])    (fromInteger i)
	)}}}

happyReduce_205 = happyReduce 4# 72# happyReduction_205
happyReduction_205 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Tilde) -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightSquare) -> 
	happyIn86
		 (let Loc l (IntTok (i,_)) = happy_var_3 in Just $ ActiveUntil (happy_var_1 <^^> happy_var_4 <** [happy_var_1,happy_var_2,l,happy_var_4]) (fromInteger i)
	) `HappyStk` happyRest}}}}

happyReduce_206 = happySpecReduce_0  73# happyReduction_206
happyReduction_206  =  happyIn87
		 ((Nothing,[])
	)

happyReduce_207 = happySpecReduce_3  73# happyReduction_207
happyReduction_207 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	happyIn87
		 ((Just happy_var_2,[happy_var_1,happy_var_3])
	)}}}

happyReduce_208 = happySpecReduce_1  74# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	happyIn88
		 ([happy_var_1]
	)}

happyReduce_209 = happySpecReduce_2  74# happyReduction_209
happyReduction_209 happy_x_2
	happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	happyIn88
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_210 = happySpecReduce_1  75# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn89
		 (RuleVar (ann happy_var_1) happy_var_1
	)}

happyReduce_211 = happyReduce 5# 75# happyReduction_211
happyReduction_211 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut235 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut107 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn89
		 (TypedRuleVar (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_212 = happySpecReduce_3  76# happyReduction_212
happyReduction_212 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	case happyOut91 happy_x_3 of { happy_var_3 -> 
	happyIn90
		 ((fst happy_var_3 : fst happy_var_1, snd happy_var_1 ++ (happy_var_2:snd happy_var_3))
	)}}}

happyReduce_213 = happySpecReduce_2  76# happyReduction_213
happyReduction_213 happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 SemiColon) -> 
	happyIn90
		 ((fst happy_var_1, snd happy_var_1 ++ [happy_var_2])
	)}}

happyReduce_214 = happySpecReduce_1  76# happyReduction_214
happyReduction_214 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn90
		 (([fst happy_var_1],snd happy_var_1)
	)}

happyReduce_215 = happySpecReduce_0  76# happyReduction_215
happyReduction_215  =  happyIn90
		 (([],[])
	)

happyReduce_216 = happySpecReduce_2  77# happyReduction_216
happyReduction_216 happy_x_2
	happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn91
		 (let Loc l (StringTok (s,_)) = happy_var_2 in ((fst happy_var_1,s),snd happy_var_1 ++ [l])
	)}}

happyReduce_217 = happySpecReduce_1  78# happyReduction_217
happyReduction_217 happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	happyIn92
		 (([happy_var_1],[])
	)}

happyReduce_218 = happySpecReduce_3  78# happyReduction_218
happyReduction_218 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	happyIn92
		 ((happy_var_1 : fst happy_var_3, happy_var_2 : snd happy_var_3)
	)}}}

happyReduce_219 = happySpecReduce_1  79# happyReduction_219
happyReduction_219 happy_x_1
	 =  case happyOut222 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 (happy_var_1
	)}

happyReduce_220 = happySpecReduce_1  79# happyReduction_220
happyReduction_220 happy_x_1
	 =  case happyOut218 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 (happy_var_1
	)}

happyReduce_221 = happyMonadReduce 3# 80# happyReduction_221
happyReduction_221 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut238 happy_x_2 of { happy_var_2 -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	( checkExpr happy_var_3 >>= \e -> return (TypeAnn   (nIS happy_var_1 <++> ann e <** [happy_var_1]) happy_var_2 e))}}}
	) (\r -> happyReturn (happyIn94 r))

happyReduce_222 = happyMonadReduce 2# 80# happyReduction_222
happyReduction_222 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	( checkExpr happy_var_2 >>= \e -> return (ModuleAnn (nIS happy_var_1 <++> ann e <** [happy_var_1])    e))}}
	) (\r -> happyReturn (happyIn94 r))

happyReduce_223 = happyMonadReduce 2# 80# happyReduction_223
happyReduction_223 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut93 happy_x_1 of { happy_var_1 -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	( checkExpr happy_var_2 >>= \e -> return (Ann (happy_var_1 <> e) happy_var_1 e))}}
	) (\r -> happyReturn (happyIn94 r))

happyReduce_224 = happyMonadReduce 1# 81# happyReduction_224
happyReduction_224 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut96 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn95 r))

happyReduce_225 = happySpecReduce_1  82# happyReduction_225
happyReduction_225 happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	happyIn96
		 (happy_var_1
	)}

happyReduce_226 = happySpecReduce_3  82# happyReduction_226
happyReduction_226 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOut106 happy_x_2 of { happy_var_2 -> 
	case happyOut96 happy_x_3 of { happy_var_3 -> 
	happyIn96
		 (TyInfix (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_227 = happySpecReduce_3  82# happyReduction_227
happyReduction_227 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOut261 happy_x_2 of { happy_var_2 -> 
	case happyOut96 happy_x_3 of { happy_var_3 -> 
	happyIn96
		 (TyInfix (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_228 = happySpecReduce_3  82# happyReduction_228
happyReduction_228 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	happyIn96
		 (TyFun (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_229 = happyMonadReduce 3# 82# happyReduction_229
happyReduction_229 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Tilde) -> 
	case happyOut100 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabledOneOf [TypeFamilies, GADTs] ;
                                              let {l = happy_var_1 <> happy_var_3 <** [happy_var_2]};
                                              return $ TyPred l $ EqualP l happy_var_1 happy_var_3 })}}}
	) (\r -> happyReturn (happyIn96 r))

happyReduce_230 = happyMonadReduce 1# 83# happyReduction_230
happyReduction_230 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut98 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn97 r))

happyReduce_231 = happySpecReduce_3  84# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut221 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut96 happy_x_3 of { happy_var_3 -> 
	happyIn98
		 (let l = (happy_var_1 <> happy_var_3 <** [happy_var_2]) in TyPred l $ IParam l happy_var_1 happy_var_3
	)}}}

happyReduce_232 = happySpecReduce_1  84# happyReduction_232
happyReduction_232 happy_x_1
	 =  case happyOut96 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 (happy_var_1
	)}

happyReduce_233 = happyMonadReduce 1# 85# happyReduction_233
happyReduction_233 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut100 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn99 r))

happyReduce_234 = happySpecReduce_2  86# happyReduction_234
happyReduction_234 happy_x_2
	happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOut101 happy_x_2 of { happy_var_2 -> 
	happyIn100
		 (TyApp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_235 = happySpecReduce_1  86# happyReduction_235
happyReduction_235 happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	happyIn100
		 (happy_var_1
	)}

happyReduce_236 = happySpecReduce_1  87# happyReduction_236
happyReduction_236 happy_x_1
	 =  case happyOut104 happy_x_1 of { happy_var_1 -> 
	happyIn101
		 (TyCon   (ann happy_var_1) happy_var_1
	)}

happyReduce_237 = happyMonadReduce 1# 87# happyReduction_237
happyReduction_237 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut259 happy_x_1 of { happy_var_1 -> 
	( checkTyVar happy_var_1)}
	) (\r -> happyReturn (happyIn101 r))

happyReduce_238 = happySpecReduce_2  87# happyReduction_238
happyReduction_238 happy_x_2
	happy_x_1
	 =  case happyOut103 happy_x_1 of { happy_var_1 -> 
	case happyOut101 happy_x_2 of { happy_var_2 -> 
	happyIn101
		 (let (bangOrPack, locs) = happy_var_1
                                          in let annot = if bangOrPack then (BangedTy (nIS (last locs) <** locs)) else UnpackedTy (nIS (head locs) <++> nIS (last locs) <** locs)
                                           in bangType (nIS (head locs) <++> ann happy_var_2) annot happy_var_2
	)}}

happyReduce_239 = happySpecReduce_3  87# happyReduction_239
happyReduction_239 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut110 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn101
		 (TyTuple (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (happy_var_3:snd happy_var_2))) Boxed   (reverse (fst happy_var_2))
	)}}}

happyReduce_240 = happySpecReduce_3  87# happyReduction_240
happyReduction_240 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut111 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn101
		 (TyTuple (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (happy_var_3:snd happy_var_2))) Unboxed (reverse (fst happy_var_2))
	)}}}

happyReduce_241 = happySpecReduce_3  87# happyReduction_241
happyReduction_241 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn101
		 (TyList  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_242 = happySpecReduce_3  87# happyReduction_242
happyReduction_242 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ParArrayLeftSquare) -> 
	case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 ParArrayRightSquare) -> 
	happyIn101
		 (TyParArray  (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_243 = happySpecReduce_3  87# happyReduction_243
happyReduction_243 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn101
		 (TyParen (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_244 = happyReduce 5# 87# happyReduction_244
happyReduction_244 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut134 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn101
		 (TyKind  (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_245 = happySpecReduce_3  87# happyReduction_245
happyReduction_245 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THParenEscape) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn101
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in TySplice l $ ParenSplice l happy_var_2
	)}}}

happyReduce_246 = happySpecReduce_1  87# happyReduction_246
happyReduction_246 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn101
		 (let Loc l (THIdEscape s) = happy_var_1 in TySplice (nIS l) $ IdSplice (nIS l) s
	)}

happyReduce_247 = happySpecReduce_1  87# happyReduction_247
happyReduction_247 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn101
		 (TyWildCard (nIS happy_var_1) Nothing
	)}

happyReduce_248 = happyMonadReduce 1# 87# happyReduction_248
happyReduction_248 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut102 happy_x_1 of { happy_var_1 -> 
	( checkEnabled DataKinds >> return (TyPromoted (ann happy_var_1) happy_var_1))}
	) (\r -> happyReturn (happyIn101 r))

happyReduce_249 = happyMonadReduce 4# 88# happyReduction_249
happyReduction_249 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut111 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightSquare) -> 
	( PromotedList  (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse(happy_var_4:snd happy_var_3))) True . reverse <$> mapM checkType (fst happy_var_3))}}}
	) (\r -> happyReturn (happyIn102 r))

happyReduce_250 = happySpecReduce_3  88# happyReduction_250
happyReduction_250 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn102
		 (PromotedList   (happy_var_1 <^^> happy_var_3 <** [happy_var_1, happy_var_3]) True  []
	)}}

happyReduce_251 = happyMonadReduce 3# 88# happyReduction_251
happyReduction_251 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut110 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	( PromotedList  (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse(happy_var_3:snd happy_var_2))) False . reverse <$> mapM checkType (fst happy_var_2))}}}
	) (\r -> happyReturn (happyIn102 r))

happyReduce_252 = happyMonadReduce 4# 88# happyReduction_252
happyReduction_252 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut111 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	( PromotedTuple (happy_var_1 <^^> happy_var_4 <** (happy_var_1:reverse(happy_var_4:snd happy_var_3))) . reverse <$> mapM checkType (fst happy_var_3))}}}
	) (\r -> happyReturn (happyIn102 r))

happyReduce_253 = happySpecReduce_3  88# happyReduction_253
happyReduction_253 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn102
		 (PromotedUnit  (happy_var_1 <^^> happy_var_3 )
	)}}

happyReduce_254 = happySpecReduce_2  88# happyReduction_254
happyReduction_254 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut232 happy_x_2 of { happy_var_2 -> 
	happyIn102
		 (PromotedCon ((noInfoSpan happy_var_1 <++> ann happy_var_2) <** [happy_var_1]) True  happy_var_2
	)}}

happyReduce_255 = happySpecReduce_2  88# happyReduction_255
happyReduction_255 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut258 happy_x_2 of { happy_var_2 -> 
	happyIn102
		 (PromotedCon ((noInfoSpan happy_var_1 <++> ann happy_var_2) <** [happy_var_1]) True  happy_var_2
	)}}

happyReduce_256 = happySpecReduce_1  88# happyReduction_256
happyReduction_256 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (let Loc l (IntTok  (i,raw)) = happy_var_1 in PromotedInteger (nIS l) i raw
	)}

happyReduce_257 = happySpecReduce_1  88# happyReduction_257
happyReduction_257 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (let Loc l (StringTok (s,raw)) = happy_var_1 in PromotedString (nIS l) s raw
	)}

happyReduce_258 = happySpecReduce_1  89# happyReduction_258
happyReduction_258 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	happyIn103
		 ((True, [happy_var_1])
	)}

happyReduce_259 = happySpecReduce_3  89# happyReduction_259
happyReduction_259 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 UNPACK) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 PragmaEnd) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Exclamation) -> 
	happyIn103
		 ((False, [happy_var_1,happy_var_2,happy_var_3])
	)}}}

happyReduce_260 = happySpecReduce_1  90# happyReduction_260
happyReduction_260 happy_x_1
	 =  case happyOut105 happy_x_1 of { happy_var_1 -> 
	happyIn104
		 (happy_var_1
	)}

happyReduce_261 = happySpecReduce_2  90# happyReduction_261
happyReduction_261 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn104
		 (unit_tycon_name              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_262 = happySpecReduce_3  90# happyReduction_262
happyReduction_262 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn104
		 (fun_tycon_name               (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_2,happy_var_3])
	)}}}

happyReduce_263 = happySpecReduce_2  90# happyReduction_263
happyReduction_263 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightSquare) -> 
	happyIn104
		 (list_tycon_name              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_264 = happySpecReduce_3  90# happyReduction_264
happyReduction_264 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn104
		 (tuple_tycon_name             (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse happy_var_2 ++ [happy_var_3])) Boxed (length happy_var_2)
	)}}}

happyReduce_265 = happySpecReduce_2  90# happyReduction_265
happyReduction_265 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn104
		 (unboxed_singleton_tycon_name (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_266 = happySpecReduce_3  90# happyReduction_266
happyReduction_266 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn104
		 (tuple_tycon_name             (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse happy_var_2 ++ [happy_var_3])) Unboxed (length happy_var_2)
	)}}}

happyReduce_267 = happySpecReduce_1  91# happyReduction_267
happyReduction_267 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn105
		 (happy_var_1
	)}

happyReduce_268 = happySpecReduce_3  91# happyReduction_268
happyReduction_268 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut232 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn105
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_269 = happySpecReduce_3  91# happyReduction_269
happyReduction_269 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut241 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn105
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_270 = happySpecReduce_1  92# happyReduction_270
happyReduction_270 happy_x_1
	 =  case happyOut228 happy_x_1 of { happy_var_1 -> 
	happyIn106
		 (happy_var_1
	)}

happyReduce_271 = happyMonadReduce 1# 93# happyReduction_271
happyReduction_271 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut108 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1)}
	) (\r -> happyReturn (happyIn107 r))

happyReduce_272 = happyReduce 4# 94# happyReduction_272
happyReduction_272 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut112 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	case happyOut108 happy_x_4 of { happy_var_4 -> 
	happyIn108
		 (mkTyForall (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) (Just (reverse (fst happy_var_2))) Nothing happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_273 = happySpecReduce_2  94# happyReduction_273
happyReduction_273 happy_x_2
	happy_x_1
	 =  case happyOut109 happy_x_1 of { happy_var_1 -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	happyIn108
		 (mkTyForall (happy_var_1 <> happy_var_2) Nothing (Just happy_var_1) happy_var_2
	)}}

happyReduce_274 = happySpecReduce_1  94# happyReduction_274
happyReduction_274 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn108
		 (happy_var_1
	)}

happyReduce_275 = happyMonadReduce 2# 95# happyReduction_275
happyReduction_275 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleArrow) -> 
	( checkPContext $ (amap (\l -> l <++> nIS happy_var_2 <** (srcInfoPoints l ++ [happy_var_2]))) happy_var_1)}}
	) (\r -> happyReturn (happyIn109 r))

happyReduce_276 = happyMonadReduce 4# 95# happyReduction_276
happyReduction_276 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut100 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Tilde) -> 
	case happyOut100 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DoubleArrow) -> 
	( do { checkEnabledOneOf [TypeFamilies, GADTs];
                                              let {l = happy_var_1 <> happy_var_3 <** [happy_var_2,happy_var_4]};
                                              checkPContext (TyPred l $ EqualP l happy_var_1 happy_var_3) })}}}}
	) (\r -> happyReturn (happyIn109 r))

happyReduce_277 = happySpecReduce_3  96# happyReduction_277
happyReduction_277 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut111 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	happyIn110
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_278 = happySpecReduce_1  97# happyReduction_278
happyReduction_278 happy_x_1
	 =  case happyOut108 happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (([happy_var_1],[])
	)}

happyReduce_279 = happySpecReduce_3  97# happyReduction_279
happyReduction_279 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut111 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut108 happy_x_3 of { happy_var_3 -> 
	happyIn111
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_280 = happySpecReduce_2  98# happyReduction_280
happyReduction_280 happy_x_2
	happy_x_1
	 =  case happyOut112 happy_x_1 of { happy_var_1 -> 
	case happyOut113 happy_x_2 of { happy_var_2 -> 
	happyIn112
		 ((happy_var_2 : fst happy_var_1, Just (snd happy_var_1 <?+> ann happy_var_2))
	)}}

happyReduce_281 = happySpecReduce_0  98# happyReduction_281
happyReduction_281  =  happyIn112
		 (([],Nothing)
	)

happyReduce_282 = happySpecReduce_1  99# happyReduction_282
happyReduction_282 happy_x_1
	 =  case happyOut259 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (UnkindedVar (ann happy_var_1) happy_var_1
	)}

happyReduce_283 = happyReduce 5# 99# happyReduction_283
happyReduction_283 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut134 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn113
		 (KindedVar (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_3,happy_var_5]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_284 = happySpecReduce_2  100# happyReduction_284
happyReduction_284 happy_x_2
	happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	happyIn114
		 ((happy_var_2 : fst happy_var_1, Just (snd happy_var_1 <?+> ann happy_var_2))
	)}}

happyReduce_285 = happySpecReduce_0  100# happyReduction_285
happyReduction_285  =  happyIn114
		 (([], Nothing)
	)

happyReduce_286 = happySpecReduce_2  101# happyReduction_286
happyReduction_286 happy_x_2
	happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	happyIn115
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <?+> ann happy_var_2)
	)}}

happyReduce_287 = happySpecReduce_0  102# happyReduction_287
happyReduction_287  =  happyIn116
		 (([],[], Nothing)
	)

happyReduce_288 = happyMonadReduce 2# 102# happyReduction_288
happyReduction_288 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut117 happy_x_2 of { happy_var_2 -> 
	( do { checkEnabled FunctionalDependencies ;
                                              let {(fds,ss,l) = happy_var_2} ;
                                              return (reverse fds, happy_var_1 : reverse ss, Just (nIS happy_var_1 <++> l)) })}}
	) (\r -> happyReturn (happyIn116 r))

happyReduce_289 = happySpecReduce_3  103# happyReduction_289
happyReduction_289 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut117 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut118 happy_x_3 of { happy_var_3 -> 
	happyIn117
		 (let (fds,ss,l) = happy_var_1 in (happy_var_3 : fds, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_290 = happySpecReduce_1  103# happyReduction_290
happyReduction_290 happy_x_1
	 =  case happyOut118 happy_x_1 of { happy_var_1 -> 
	happyIn117
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_291 = happySpecReduce_3  104# happyReduction_291
happyReduction_291 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut115 happy_x_3 of { happy_var_3 -> 
	happyIn118
		 (FunDep (snd happy_var_1 <?+> nIS happy_var_2 <++> snd happy_var_3 <** [happy_var_2]) (reverse (fst happy_var_1)) (reverse (fst happy_var_3))
	)}}}

happyReduce_292 = happyMonadReduce 4# 105# happyReduction_292
happyReduction_292 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( return (fst happy_var_3, happy_var_1 : happy_var_2 : snd happy_var_3 ++ [happy_var_4], Just $ happy_var_1 <^^> happy_var_4))}}}}
	) (\r -> happyReturn (happyIn119 r))

happyReduce_293 = happyMonadReduce 4# 105# happyReduction_293
happyReduction_293 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOut120 happy_x_3 of { happy_var_3 -> 
	case happyOut248 happy_x_4 of { happy_var_4 -> 
	( return (fst happy_var_3, happy_var_1 : happy_var_2 : snd happy_var_3 ++ [happy_var_4], Just $ happy_var_1 <^^> happy_var_4))}}}}
	) (\r -> happyReturn (happyIn119 r))

happyReduce_294 = happyMonadReduce 0# 105# happyReduction_294
happyReduction_294 (happyRest) tk
	 = happyThen (( checkEnabled EmptyDataDecls >> return ([],[],Nothing))
	) (\r -> happyReturn (happyIn119 r))

happyReduce_295 = happySpecReduce_3  106# happyReduction_295
happyReduction_295 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut121 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn120
		 ((fst happy_var_2, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_296 = happySpecReduce_3  107# happyReduction_296
happyReduction_296 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut121 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut122 happy_x_3 of { happy_var_3 -> 
	happyIn121
		 ((happy_var_3 ++ fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_297 = happySpecReduce_1  107# happyReduction_297
happyReduction_297 happy_x_1
	 =  case happyOut122 happy_x_1 of { happy_var_1 -> 
	happyIn121
		 ((happy_var_1,[])
	)}

happyReduce_298 = happyMonadReduce 3# 108# happyReduction_298
happyReduction_298 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut223 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	( do { c <- checkUnQual happy_var_1;
                                               return [GadtDecl (happy_var_1 <> happy_var_3 <** [happy_var_2]) c Nothing happy_var_3] })}}}
	) (\r -> happyReturn (happyIn122 r))

happyReduce_299 = happyMonadReduce 7# 108# happyReduction_299
happyReduction_299 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut223 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftCurly) -> 
	case happyOut129 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightCurly) -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 RightArrow) -> 
	case happyOut107 happy_x_7 of { happy_var_7 -> 
	( do { c <- checkUnQual happy_var_1;
                                              return [GadtDecl (happy_var_1 <> happy_var_7 <** [happy_var_2,happy_var_3,happy_var_5,happy_var_6] ++ snd happy_var_4) c (Just (reverse $ fst happy_var_4)) happy_var_7] })}}}}}}}
	) (\r -> happyReturn (happyIn122 r))

happyReduce_300 = happySpecReduce_2  109# happyReduction_300
happyReduction_300 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut124 happy_x_2 of { happy_var_2 -> 
	happyIn123
		 (let (ds,ss,l) = happy_var_2 in (ds, happy_var_1 : reverse ss, Just $ nIS happy_var_1 <++> l)
	)}}

happyReduce_301 = happySpecReduce_3  110# happyReduction_301
happyReduction_301 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut125 happy_x_3 of { happy_var_3 -> 
	happyIn124
		 (let (ds,ss,l) = happy_var_1 in (happy_var_3 : ds, happy_var_2 : ss, l <++> ann happy_var_3)
	)}}}

happyReduce_302 = happySpecReduce_1  110# happyReduction_302
happyReduction_302 happy_x_1
	 =  case happyOut125 happy_x_1 of { happy_var_1 -> 
	happyIn124
		 (([happy_var_1],[],ann happy_var_1)
	)}

happyReduce_303 = happyMonadReduce 3# 111# happyReduction_303
happyReduction_303 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut126 happy_x_1 of { happy_var_1 -> 
	case happyOut109 happy_x_2 of { happy_var_2 -> 
	case happyOut127 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled ExistentialQuantification ;
                                               ctxt <- checkContext (Just happy_var_2) ;
                                               let {(mtvs,ss,ml) = happy_var_1} ;
                                               return $ QualConDecl (ml <?+> ann happy_var_3 <** ss) mtvs ctxt happy_var_3 })}}}
	) (\r -> happyReturn (happyIn125 r))

happyReduce_304 = happySpecReduce_2  111# happyReduction_304
happyReduction_304 happy_x_2
	happy_x_1
	 =  case happyOut126 happy_x_1 of { happy_var_1 -> 
	case happyOut127 happy_x_2 of { happy_var_2 -> 
	happyIn125
		 (let (mtvs, ss, ml) = happy_var_1 in QualConDecl (ml <?+> ann happy_var_2 <** ss) mtvs Nothing happy_var_2
	)}}

happyReduce_305 = happyMonadReduce 3# 112# happyReduction_305
happyReduction_305 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut112 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	( checkEnabled ExistentialQuantification >> return (Just (fst happy_var_2), [happy_var_1,happy_var_3], Just $ happy_var_1 <^^> happy_var_3))}}}
	) (\r -> happyReturn (happyIn126 r))

happyReduce_306 = happySpecReduce_0  112# happyReduction_306
happyReduction_306  =  happyIn126
		 ((Nothing, [], Nothing)
	)

happyReduce_307 = happySpecReduce_1  113# happyReduction_307
happyReduction_307 happy_x_1
	 =  case happyOut128 happy_x_1 of { happy_var_1 -> 
	happyIn127
		 (let (n,ts,l) = happy_var_1 in ConDecl l n ts
	)}

happyReduce_308 = happySpecReduce_3  113# happyReduction_308
happyReduction_308 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOut227 happy_x_2 of { happy_var_2 -> 
	case happyOut99 happy_x_3 of { happy_var_3 -> 
	happyIn127
		 (InfixConDecl (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_309 = happyMonadReduce 3# 113# happyReduction_309
happyReduction_309 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut223 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	( do { c <- checkUnQual happy_var_1; return $ RecDecl (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3]) c [] })}}}
	) (\r -> happyReturn (happyIn127 r))

happyReduce_310 = happyMonadReduce 4# 113# happyReduction_310
happyReduction_310 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut223 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut129 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( do { c <- checkUnQual happy_var_1;
                                              return $ RecDecl (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:reverse (snd happy_var_3) ++ [happy_var_4])) c (reverse (fst happy_var_3)) })}}}}
	) (\r -> happyReturn (happyIn127 r))

happyReduce_311 = happyMonadReduce 1# 114# happyReduction_311
happyReduction_311 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut100 happy_x_1 of { happy_var_1 -> 
	( do { (c,ts) <- splitTyConApp happy_var_1;
                                              return (c, ts, ann happy_var_1) })}
	) (\r -> happyReturn (happyIn128 r))

happyReduce_312 = happySpecReduce_3  115# happyReduction_312
happyReduction_312 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut130 happy_x_3 of { happy_var_3 -> 
	happyIn129
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_313 = happySpecReduce_1  115# happyReduction_313
happyReduction_313 happy_x_1
	 =  case happyOut130 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (([happy_var_1],[])
	)}

happyReduce_314 = happySpecReduce_3  116# happyReduction_314
happyReduction_314 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	happyIn130
		 (let (ns,ss,l) = happy_var_1 in FieldDecl (l <++> ann happy_var_3 <** (reverse ss ++ [happy_var_2])) (reverse ns) happy_var_3
	)}}}

happyReduce_315 = happySpecReduce_0  117# happyReduction_315
happyReduction_315  =  happyIn131
		 (Nothing
	)

happyReduce_316 = happySpecReduce_2  117# happyReduction_316
happyReduction_316 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOut133 happy_x_2 of { happy_var_2 -> 
	happyIn131
		 (let l = nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1] in Just $ Deriving l [IRule (ann happy_var_2) Nothing Nothing happy_var_2]
	)}}

happyReduce_317 = happySpecReduce_3  117# happyReduction_317
happyReduction_317 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn131
		 (Just $ Deriving (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_2,happy_var_3]) []
	)}}}

happyReduce_318 = happyReduce 4# 117# happyReduction_318
happyReduction_318 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftParen) -> 
	case happyOut132 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn131
		 (-- Distinguish deriving (Show) from deriving Show (#189)
                                        case fst happy_var_3 of
                                          [ts] -> Just $ Deriving (happy_var_1 <^^> happy_var_4 <** [happy_var_1]) [IParen (happy_var_2 <^^> happy_var_4 <** [happy_var_2,happy_var_4]) ts]
                                          tss  -> Just $ Deriving (happy_var_1 <^^> happy_var_4 <** happy_var_1:happy_var_2: reverse (snd happy_var_3) ++ [happy_var_4]) (reverse tss)
	) `HappyStk` happyRest}}}}

happyReduce_319 = happyMonadReduce 1# 118# happyReduction_319
happyReduction_319 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut111 happy_x_1 of { happy_var_1 -> 
	( checkDeriving (fst happy_var_1) >>= \ds -> return (ds, snd happy_var_1))}
	) (\r -> happyReturn (happyIn132 r))

happyReduce_320 = happySpecReduce_1  119# happyReduction_320
happyReduction_320 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (IHCon (ann happy_var_1) happy_var_1
	)}

happyReduce_321 = happyMonadReduce 1# 120# happyReduction_321
happyReduction_321 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut135 happy_x_1 of { happy_var_1 -> 
	( checkEnabled KindSignatures >> return happy_var_1)}
	) (\r -> happyReturn (happyIn134 r))

happyReduce_322 = happySpecReduce_1  121# happyReduction_322
happyReduction_322 happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	happyIn135
		 (happy_var_1
	)}

happyReduce_323 = happySpecReduce_3  121# happyReduction_323
happyReduction_323 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut135 happy_x_3 of { happy_var_3 -> 
	happyIn135
		 (KindFn (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_324 = happySpecReduce_1  122# happyReduction_324
happyReduction_324 happy_x_1
	 =  case happyOut137 happy_x_1 of { happy_var_1 -> 
	happyIn136
		 (happy_var_1
	)}

happyReduce_325 = happySpecReduce_2  122# happyReduction_325
happyReduction_325 happy_x_2
	happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	case happyOut137 happy_x_2 of { happy_var_2 -> 
	happyIn136
		 (KindApp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_326 = happySpecReduce_1  123# happyReduction_326
happyReduction_326 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Star) -> 
	happyIn137
		 (KindStar  (nIS happy_var_1)
	)}

happyReduce_327 = happySpecReduce_3  123# happyReduction_327
happyReduction_327 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut135 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn137
		 (KindParen (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_328 = happyMonadReduce 1# 123# happyReduction_328
happyReduction_328 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut138 happy_x_1 of { happy_var_1 -> 
	( checkKind happy_var_1 >> return happy_var_1)}
	) (\r -> happyReturn (happyIn137 r))

happyReduce_329 = happyMonadReduce 1# 123# happyReduction_329
happyReduction_329 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut233 happy_x_1 of { happy_var_1 -> 
	( checkEnabled PolyKinds >> return (KindVar (ann happy_var_1) happy_var_1))}
	) (\r -> happyReturn (happyIn137 r))

happyReduce_330 = happySpecReduce_1  124# happyReduction_330
happyReduction_330 happy_x_1
	 =  case happyOut258 happy_x_1 of { happy_var_1 -> 
	happyIn138
		 (KindVar (ann happy_var_1) happy_var_1
	)}

happyReduce_331 = happySpecReduce_2  124# happyReduction_331
happyReduction_331 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn138
		 (let l = happy_var_1 <^^> happy_var_2 in KindVar l (unit_tycon_name l)
	)}}

happyReduce_332 = happyReduce 5# 124# happyReduction_332
happyReduction_332 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut134 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Comma) -> 
	case happyOut139 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightParen) -> 
	happyIn138
		 (KindTuple (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3:reverse (happy_var_5:snd happy_var_4))) (happy_var_2:reverse (fst happy_var_4))
	) `HappyStk` happyRest}}}}}

happyReduce_333 = happySpecReduce_3  124# happyReduction_333
happyReduction_333 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut134 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn138
		 (KindList  ((happy_var_1 <^^> happy_var_3) <** [happy_var_1, happy_var_3]) happy_var_2
	)}}}

happyReduce_334 = happySpecReduce_1  125# happyReduction_334
happyReduction_334 happy_x_1
	 =  case happyOut135 happy_x_1 of { happy_var_1 -> 
	happyIn139
		 (([happy_var_1], [])
	)}

happyReduce_335 = happySpecReduce_3  125# happyReduction_335
happyReduction_335 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut135 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut139 happy_x_3 of { happy_var_3 -> 
	happyIn139
		 ((happy_var_1 : (fst happy_var_3), happy_var_2 : (snd happy_var_3))
	)}}}

happyReduce_336 = happySpecReduce_0  126# happyReduction_336
happyReduction_336  =  happyIn140
		 ((Nothing,[])
	)

happyReduce_337 = happySpecReduce_2  126# happyReduction_337
happyReduction_337 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut134 happy_x_2 of { happy_var_2 -> 
	happyIn140
		 ((Just happy_var_2,[happy_var_1])
	)}}

happyReduce_338 = happyMonadReduce 4# 127# happyReduction_338
happyReduction_338 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut142 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( checkClassBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn141 r))

happyReduce_339 = happyMonadReduce 4# 127# happyReduction_339
happyReduction_339 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOut142 happy_x_3 of { happy_var_3 -> 
	case happyOut248 happy_x_4 of { happy_var_4 -> 
	( do { vs <- checkClassBody (fst happy_var_3);
                                              let { l' = if null (fst happy_var_3) then nIS happy_var_4 else (ann . last $ fst happy_var_3) };
                                              return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (nIS happy_var_1 <++> l')) })}}}}
	) (\r -> happyReturn (happyIn141 r))

happyReduce_340 = happySpecReduce_0  127# happyReduction_340
happyReduction_340  =  happyIn141
		 ((Nothing,[],Nothing)
	)

happyReduce_341 = happyMonadReduce 3# 128# happyReduction_341
happyReduction_341 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut143 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevClsDecls (fst happy_var_2) >>= \cs -> return (cs, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}}
	) (\r -> happyReturn (happyIn142 r))

happyReduce_342 = happySpecReduce_1  128# happyReduction_342
happyReduction_342 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn142
		 (([],reverse happy_var_1)
	)}

happyReduce_343 = happySpecReduce_3  129# happyReduction_343
happyReduction_343 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut143 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut144 happy_x_3 of { happy_var_3 -> 
	happyIn143
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_344 = happySpecReduce_1  129# happyReduction_344
happyReduction_344 happy_x_1
	 =  case happyOut144 happy_x_1 of { happy_var_1 -> 
	happyIn143
		 (([happy_var_1],[])
	)}

happyReduce_345 = happySpecReduce_1  130# happyReduction_345
happyReduction_345 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn144
		 (ClsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_346 = happyMonadReduce 1# 130# happyReduction_346
happyReduction_346 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut145 happy_x_1 of { happy_var_1 -> 
	( checkEnabled TypeFamilies >> return happy_var_1)}
	) (\r -> happyReturn (happyIn144 r))

happyReduce_347 = happyMonadReduce 2# 130# happyReduction_347
happyReduction_347 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	( checkEnabled DefaultSignatures >> checkDefSigDef happy_var_2 >>= \(n,t,l) -> return (ClsDefSig (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1,l]) n t))}}
	) (\r -> happyReturn (happyIn144 r))

happyReduce_348 = happyMonadReduce 3# 131# happyReduction_348
happyReduction_348 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOut140 happy_x_3 of { happy_var_3 -> 
	( do { dh <- checkSimpleType happy_var_2;
                    return (ClsTyFam  (nIS happy_var_1 <++> ann happy_var_2 <+?> (fmap ann) (fst happy_var_3) <** happy_var_1:snd happy_var_3) dh (fst happy_var_3)) })}}}
	) (\r -> happyReturn (happyIn145 r))

happyReduce_349 = happyReduce 4# 131# happyReduction_349
happyReduction_349 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut107 happy_x_4 of { happy_var_4 -> 
	happyIn145
		 (ClsTyDef (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_350 = happyReduce 5# 131# happyReduction_350
happyReduction_350 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Instance) -> 
	case happyOut95 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Equals) -> 
	case happyOut107 happy_x_5 of { happy_var_5 -> 
	happyIn145
		 (ClsTyDef (nIS happy_var_1 <++> ann happy_var_5 <** [happy_var_1,happy_var_2,happy_var_4]) happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_351 = happyMonadReduce 3# 131# happyReduction_351
happyReduction_351 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	case happyOut108 happy_x_2 of { happy_var_2 -> 
	case happyOut140 happy_x_3 of { happy_var_3 -> 
	( do { (cs,dh) <- checkDataHeader happy_var_2;
                    return (ClsDataFam (nIS happy_var_1 <++> ann happy_var_2 <+?> (fmap ann) (fst happy_var_3) <** happy_var_1:snd happy_var_3) cs dh (fst happy_var_3)) })}}}
	) (\r -> happyReturn (happyIn145 r))

happyReduce_352 = happyMonadReduce 4# 132# happyReduction_352
happyReduction_352 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut147 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( checkInstBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn146 r))

happyReduce_353 = happyMonadReduce 4# 132# happyReduction_353
happyReduction_353 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOut147 happy_x_3 of { happy_var_3 -> 
	case happyOut248 happy_x_4 of { happy_var_4 -> 
	( checkInstBody (fst happy_var_3) >>= \vs -> return (Just vs, happy_var_1:happy_var_2: snd happy_var_3 ++ [happy_var_4], Just (happy_var_1 <^^> happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn146 r))

happyReduce_354 = happySpecReduce_0  132# happyReduction_354
happyReduction_354  =  happyIn146
		 ((Nothing, [], Nothing)
	)

happyReduce_355 = happyMonadReduce 3# 133# happyReduction_355
happyReduction_355 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut148 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	( checkRevInstDecls (fst happy_var_2) >>= \is -> return (is, reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3))}}}
	) (\r -> happyReturn (happyIn147 r))

happyReduce_356 = happySpecReduce_1  133# happyReduction_356
happyReduction_356 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn147
		 (([],reverse happy_var_1)
	)}

happyReduce_357 = happySpecReduce_3  134# happyReduction_357
happyReduction_357 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut148 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut149 happy_x_3 of { happy_var_3 -> 
	happyIn148
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_358 = happySpecReduce_1  134# happyReduction_358
happyReduction_358 happy_x_1
	 =  case happyOut149 happy_x_1 of { happy_var_1 -> 
	happyIn148
		 (([happy_var_1],[])
	)}

happyReduce_359 = happySpecReduce_1  135# happyReduction_359
happyReduction_359 happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	happyIn149
		 (InsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_360 = happyMonadReduce 1# 135# happyReduction_360
happyReduction_360 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut150 happy_x_1 of { happy_var_1 -> 
	( checkEnabled TypeFamilies >> return happy_var_1)}
	) (\r -> happyReturn (happyIn149 r))

happyReduce_361 = happySpecReduce_1  135# happyReduction_361
happyReduction_361 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn149
		 (InsDecl (ann happy_var_1) happy_var_1
	)}

happyReduce_362 = happyMonadReduce 1# 135# happyReduction_362
happyReduction_362 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut71 happy_x_1 of { happy_var_1 -> 
	( checkEnabled InstanceSigs >> return (InsDecl (ann happy_var_1) happy_var_1))}
	) (\r -> happyReturn (happyIn149 r))

happyReduce_363 = happyMonadReduce 4# 136# happyReduction_363
happyReduction_363 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut107 happy_x_4 of { happy_var_4 -> 
	( do { -- no checkSimpleType happy_var_4 since dtype may contain type patterns
                       return (InsType (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) happy_var_2 happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn150 r))

happyReduce_364 = happyMonadReduce 4# 136# happyReduction_364
happyReduction_364 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOut123 happy_x_3 of { happy_var_3 -> 
	case happyOut131 happy_x_4 of { happy_var_4 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       let {(ds,ss,minf) = happy_var_3};
                       checkDataOrNew happy_var_1 ds;
                       return (InsData (happy_var_1 <> happy_var_2 <+?> minf <+?> fmap ann happy_var_4 <** ss ) happy_var_1 happy_var_2 (reverse ds) happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn150 r))

happyReduce_365 = happyMonadReduce 5# 136# happyReduction_365
happyReduction_365 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOut140 happy_x_3 of { happy_var_3 -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	case happyOut131 happy_x_5 of { happy_var_5 -> 
	( do { -- (cs,c,t) <- checkDataHeader happy_var_4;
                       let { (gs,ss,minf) = happy_var_4 } ;
                       checkDataOrNewG happy_var_1 gs;
                       return $ InsGData (ann happy_var_1 <+?> minf <+?> fmap ann happy_var_5 <** (snd happy_var_3 ++ ss)) happy_var_1 happy_var_2 (fst happy_var_3) (reverse gs) happy_var_5 })}}}}}
	) (\r -> happyReturn (happyIn150 r))

happyReduce_366 = happyMonadReduce 4# 137# happyReduction_366
happyReduction_366 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOut153 happy_x_2 of { happy_var_2 -> 
	case happyOut154 happy_x_3 of { happy_var_3 -> 
	case happyOut152 happy_x_4 of { happy_var_4 -> 
	( checkValDef ((happy_var_1 <> happy_var_3 <+?> (fmap ann) (fst happy_var_4)) <** (snd happy_var_4)) happy_var_1 happy_var_2 happy_var_3 (fst happy_var_4))}}}}
	) (\r -> happyReturn (happyIn151 r))

happyReduce_367 = happyMonadReduce 4# 137# happyReduction_367
happyReduction_367 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	case happyOut154 happy_x_3 of { happy_var_3 -> 
	case happyOut152 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled BangPatterns ;
                                              let { l = nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1] };
                                              p <- checkPattern (BangPat l happy_var_2);
                                              return $ PatBind (p <> happy_var_3 <+?> (fmap ann) (fst happy_var_4) <** snd happy_var_4)
                                                          p happy_var_3 (fst happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn151 r))

happyReduce_368 = happySpecReduce_2  138# happyReduction_368
happyReduction_368 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	happyIn152
		 ((Just happy_var_2, [happy_var_1])
	)}}

happyReduce_369 = happySpecReduce_0  138# happyReduction_369
happyReduction_369  =  happyIn152
		 ((Nothing, [])
	)

happyReduce_370 = happyMonadReduce 2# 139# happyReduction_370
happyReduction_370 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 DoubleColon) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	( checkEnabled ScopedTypeVariables >> return (Just (happy_var_2, happy_var_1)))}}
	) (\r -> happyReturn (happyIn153 r))

happyReduce_371 = happySpecReduce_0  139# happyReduction_371
happyReduction_371  =  happyIn153
		 (Nothing
	)

happyReduce_372 = happySpecReduce_2  140# happyReduction_372
happyReduction_372 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Equals) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	happyIn154
		 (UnGuardedRhs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_373 = happySpecReduce_1  140# happyReduction_373
happyReduction_373 happy_x_1
	 =  case happyOut155 happy_x_1 of { happy_var_1 -> 
	happyIn154
		 (GuardedRhss (snd happy_var_1) (reverse $ fst happy_var_1)
	)}

happyReduce_374 = happySpecReduce_2  141# happyReduction_374
happyReduction_374 happy_x_2
	happy_x_1
	 =  case happyOut155 happy_x_1 of { happy_var_1 -> 
	case happyOut156 happy_x_2 of { happy_var_2 -> 
	happyIn155
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <++> ann happy_var_2)
	)}}

happyReduce_375 = happySpecReduce_1  141# happyReduction_375
happyReduction_375 happy_x_1
	 =  case happyOut156 happy_x_1 of { happy_var_1 -> 
	happyIn155
		 (([happy_var_1],ann happy_var_1)
	)}

happyReduce_376 = happyMonadReduce 4# 142# happyReduction_376
happyReduction_376 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut194 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	( do { checkPatternGuards (fst happy_var_2);
                                       return $ GuardedRhs (nIS happy_var_1 <++> ann happy_var_4 <** (happy_var_1:snd happy_var_2 ++ [happy_var_3])) (reverse (fst happy_var_2)) happy_var_4 })}}}}
	) (\r -> happyReturn (happyIn156 r))

happyReduce_377 = happyMonadReduce 1# 143# happyReduction_377
happyReduction_377 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut158 happy_x_1 of { happy_var_1 -> 
	( checkExpr happy_var_1)}
	) (\r -> happyReturn (happyIn157 r))

happyReduce_378 = happySpecReduce_3  144# happyReduction_378
happyReduction_378 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DoubleColon) -> 
	case happyOut107 happy_x_3 of { happy_var_3 -> 
	happyIn158
		 (ExpTypeSig      (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_379 = happySpecReduce_1  144# happyReduction_379
happyReduction_379 happy_x_1
	 =  case happyOut159 happy_x_1 of { happy_var_1 -> 
	happyIn158
		 (happy_var_1
	)}

happyReduce_380 = happySpecReduce_2  144# happyReduction_380
happyReduction_380 happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOut230 happy_x_2 of { happy_var_2 -> 
	happyIn158
		 (PostOp          (happy_var_1 <> happy_var_2)          happy_var_1 happy_var_2
	)}}

happyReduce_381 = happySpecReduce_3  144# happyReduction_381
happyReduction_381 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrowTail) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn158
		 (LeftArrApp      (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_382 = happySpecReduce_3  144# happyReduction_382
happyReduction_382 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrowTail) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn158
		 (RightArrApp     (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_383 = happySpecReduce_3  144# happyReduction_383
happyReduction_383 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftDblArrowTail) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn158
		 (LeftArrHighApp  (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_384 = happySpecReduce_3  144# happyReduction_384
happyReduction_384 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightDblArrowTail) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn158
		 (RightArrHighApp (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_385 = happySpecReduce_1  145# happyReduction_385
happyReduction_385 happy_x_1
	 =  case happyOut160 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (happy_var_1
	)}

happyReduce_386 = happySpecReduce_1  145# happyReduction_386
happyReduction_386 happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (happy_var_1
	)}

happyReduce_387 = happySpecReduce_3  146# happyReduction_387
happyReduction_387 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOut230 happy_x_2 of { happy_var_2 -> 
	case happyOut162 happy_x_3 of { happy_var_3 -> 
	happyIn160
		 (InfixApp (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_388 = happySpecReduce_1  146# happyReduction_388
happyReduction_388 happy_x_1
	 =  case happyOut162 happy_x_1 of { happy_var_1 -> 
	happyIn160
		 (happy_var_1
	)}

happyReduce_389 = happySpecReduce_3  147# happyReduction_389
happyReduction_389 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOut230 happy_x_2 of { happy_var_2 -> 
	case happyOut165 happy_x_3 of { happy_var_3 -> 
	happyIn161
		 (InfixApp (happy_var_1 <> happy_var_3) happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_390 = happySpecReduce_1  147# happyReduction_390
happyReduction_390 happy_x_1
	 =  case happyOut165 happy_x_1 of { happy_var_1 -> 
	happyIn161
		 (happy_var_1
	)}

happyReduce_391 = happyReduce 4# 148# happyReduction_391
happyReduction_391 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 Backslash) -> 
	case happyOut168 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut158 happy_x_4 of { happy_var_4 -> 
	happyIn162
		 (Lambda (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_392 = happyReduce 4# 148# happyReduction_392
happyReduction_392 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_In) -> 
	case happyOut158 happy_x_4 of { happy_var_4 -> 
	happyIn162
		 (Let    (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3])    happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_393 = happyReduce 8# 148# happyReduction_393
happyReduction_393 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	case happyOut158 happy_x_2 of { happy_var_2 -> 
	case happyOut163 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 KW_Then) -> 
	case happyOut158 happy_x_5 of { happy_var_5 -> 
	case happyOut163 happy_x_6 of { happy_var_6 -> 
	case happyOutTok happy_x_7 of { (Loc happy_var_7 KW_Else) -> 
	case happyOut158 happy_x_8 of { happy_var_8 -> 
	happyIn162
		 (If     (nIS happy_var_1 <++> ann happy_var_8 <** (happy_var_1:happy_var_3 ++ happy_var_4:happy_var_6 ++ [happy_var_7])) happy_var_2 happy_var_5 happy_var_8
	) `HappyStk` happyRest}}}}}}}}

happyReduce_394 = happyMonadReduce 2# 148# happyReduction_394
happyReduction_394 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	case happyOut205 happy_x_2 of { happy_var_2 -> 
	( checkEnabled MultiWayIf >>
                                           let (alts, inf, ss) = happy_var_2
                                           in return (MultiIf (nIS happy_var_1 <++> inf <** (happy_var_1:ss)) alts))}}
	) (\r -> happyReturn (happyIn162 r))

happyReduce_395 = happyReduce 4# 148# happyReduction_395
happyReduction_395 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Proc) -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut158 happy_x_4 of { happy_var_4 -> 
	happyIn162
		 (Proc   (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3])    happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_396 = happySpecReduce_1  148# happyReduction_396
happyReduction_396 happy_x_1
	 =  case happyOut166 happy_x_1 of { happy_var_1 -> 
	happyIn162
		 (happy_var_1
	)}

happyReduce_397 = happyMonadReduce 1# 149# happyReduction_397
happyReduction_397 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	( checkEnabled DoAndIfThenElse >> return [happy_var_1])}
	) (\r -> happyReturn (happyIn163 r))

happyReduce_398 = happySpecReduce_0  149# happyReduction_398
happyReduction_398  =  happyIn163
		 ([]
	)

happyReduce_399 = happySpecReduce_1  150# happyReduction_399
happyReduction_399 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	happyIn164
		 ([happy_var_1]
	)}

happyReduce_400 = happySpecReduce_0  150# happyReduction_400
happyReduction_400  =  happyIn164
		 ([]
	)

happyReduce_401 = happyReduce 4# 151# happyReduction_401
happyReduction_401 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Case) -> 
	case happyOut158 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_Of) -> 
	case happyOut197 happy_x_4 of { happy_var_4 -> 
	happyIn165
		 (let (als, inf, ss) = happy_var_4 in Case (nIS happy_var_1 <++> inf <** (happy_var_1:happy_var_3:ss)) happy_var_2 als
	) `HappyStk` happyRest}}}}

happyReduce_402 = happyMonadReduce 3# 151# happyReduction_402
happyReduction_402 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Backslash) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Case) -> 
	case happyOut197 happy_x_3 of { happy_var_3 -> 
	( do { checkEnabled LambdaCase ;
                                              let { (als, inf, ss) = happy_var_3 } ;
                                              return (LCase (nIS happy_var_1 <++> inf <** (happy_var_1:happy_var_2:ss)) als) })}}}
	) (\r -> happyReturn (happyIn165 r))

happyReduce_403 = happySpecReduce_2  151# happyReduction_403
happyReduction_403 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn165
		 (NegApp (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_404 = happySpecReduce_2  151# happyReduction_404
happyReduction_404 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Do) -> 
	case happyOut208 happy_x_2 of { happy_var_2 -> 
	happyIn165
		 (let (sts, inf, ss) = happy_var_2 in Do   (nIS happy_var_1 <++> inf <** happy_var_1:ss) sts
	)}}

happyReduce_405 = happySpecReduce_2  151# happyReduction_405
happyReduction_405 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_MDo) -> 
	case happyOut208 happy_x_2 of { happy_var_2 -> 
	happyIn165
		 (let (sts, inf, ss) = happy_var_2 in MDo  (nIS happy_var_1 <++> inf <** happy_var_1:ss) sts
	)}}

happyReduce_406 = happySpecReduce_1  151# happyReduction_406
happyReduction_406 happy_x_1
	 =  case happyOut167 happy_x_1 of { happy_var_1 -> 
	happyIn165
		 (happy_var_1
	)}

happyReduce_407 = happyReduce 4# 152# happyReduction_407
happyReduction_407 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 CORE) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	case happyOut158 happy_x_4 of { happy_var_4 -> 
	happyIn166
		 (let Loc l (StringTok (s,_)) = happy_var_2 in CorePragma (nIS happy_var_1 <++> ann happy_var_4 <** [l,happy_var_3]) s happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_408 = happyReduce 4# 152# happyReduction_408
happyReduction_408 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 SCC) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 PragmaEnd) -> 
	case happyOut158 happy_x_4 of { happy_var_4 -> 
	happyIn166
		 (let Loc l (StringTok (s,_)) = happy_var_2 in SCCPragma  (nIS happy_var_1 <++> ann happy_var_4 <** [l,happy_var_3]) s happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_409 = happyReduce 11# 152# happyReduction_409
happyReduction_409 (happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 GENERATED) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 Colon) -> 
	case happyOutTok happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (Loc happy_var_6 Minus) -> 
	case happyOutTok happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { (Loc happy_var_8 Colon) -> 
	case happyOutTok happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { (Loc happy_var_10 PragmaEnd) -> 
	case happyOut158 happy_x_11 of { happy_var_11 -> 
	happyIn166
		 (let { Loc l0 (StringTok (s,_)) = happy_var_2;
                                                  Loc l1 (IntTok (i1,_))   = happy_var_3;
                                                  Loc l2 (IntTok (i2,_))   = happy_var_5;
                                                  Loc l3 (IntTok (i3,_))   = happy_var_7;
                                                  Loc l4 (IntTok (i4,_))   = happy_var_9}
                                             in GenPragma (nIS happy_var_1 <++> ann happy_var_11 <** [happy_var_1,l0,l1,happy_var_4,l2,happy_var_6,l3,happy_var_8,l4,happy_var_10])
                                                      s (fromInteger i1, fromInteger i2)
                                                        (fromInteger i3, fromInteger i4) happy_var_11
	) `HappyStk` happyRest}}}}}}}}}}}

happyReduce_410 = happySpecReduce_2  153# happyReduction_410
happyReduction_410 happy_x_2
	happy_x_1
	 =  case happyOut167 happy_x_1 of { happy_var_1 -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn167
		 (App (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_411 = happySpecReduce_1  153# happyReduction_411
happyReduction_411 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn167
		 (happy_var_1
	)}

happyReduce_412 = happySpecReduce_2  154# happyReduction_412
happyReduction_412 happy_x_2
	happy_x_1
	 =  case happyOut168 happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_2 of { happy_var_2 -> 
	happyIn168
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_413 = happySpecReduce_1  154# happyReduction_413
happyReduction_413 happy_x_1
	 =  case happyOut169 happy_x_1 of { happy_var_1 -> 
	happyIn168
		 ([happy_var_1]
	)}

happyReduce_414 = happyMonadReduce 1# 155# happyReduction_414
happyReduction_414 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut170 happy_x_1 of { happy_var_1 -> 
	( checkPattern happy_var_1)}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_415 = happyMonadReduce 2# 155# happyReduction_415
happyReduction_415 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	( checkPattern (BangPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2))}}
	) (\r -> happyReturn (happyIn169 r))

happyReduce_416 = happyMonadReduce 3# 156# happyReduction_416
happyReduction_416 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut220 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 At) -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return (AsPat (happy_var_1 <> happy_var_3 <** [happy_var_2]) n happy_var_3) })}}}
	) (\r -> happyReturn (happyIn170 r))

happyReduce_417 = happyMonadReduce 3# 156# happyReduction_417
happyReduction_417 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut220 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RPCAt) -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	( do { n <- checkUnQual happy_var_1;
                                              return (CAsRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) n happy_var_3) })}}}
	) (\r -> happyReturn (happyIn170 r))

happyReduce_418 = happySpecReduce_2  156# happyReduction_418
happyReduction_418 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Tilde) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	happyIn170
		 (IrrPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_419 = happySpecReduce_1  156# happyReduction_419
happyReduction_419 happy_x_1
	 =  case happyOut171 happy_x_1 of { happy_var_1 -> 
	happyIn170
		 (happy_var_1
	)}

happyReduce_420 = happyMonadReduce 3# 157# happyReduction_420
happyReduction_420 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut171 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	( liftM (amap (const (ann happy_var_1 <++> nIS happy_var_3 <** [happy_var_2,happy_var_3]))) $ mkRecConstrOrUpdate happy_var_1 [])}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_421 = happyMonadReduce 4# 157# happyReduction_421
happyReduction_421 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut171 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut212 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	( liftM (amap (const (ann happy_var_1 <++> nIS happy_var_4 <** (happy_var_2:snd happy_var_3 ++ [happy_var_4]))))
                                              $ mkRecConstrOrUpdate happy_var_1 (fst happy_var_3))}}}}
	) (\r -> happyReturn (happyIn171 r))

happyReduce_422 = happySpecReduce_1  157# happyReduction_422
happyReduction_422 happy_x_1
	 =  case happyOut172 happy_x_1 of { happy_var_1 -> 
	happyIn171
		 (happy_var_1
	)}

happyReduce_423 = happySpecReduce_1  158# happyReduction_423
happyReduction_423 happy_x_1
	 =  case happyOut221 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (IPVar (ann happy_var_1) happy_var_1
	)}

happyReduce_424 = happySpecReduce_1  158# happyReduction_424
happyReduction_424 happy_x_1
	 =  case happyOut220 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (Var (ann happy_var_1) happy_var_1
	)}

happyReduce_425 = happySpecReduce_1  158# happyReduction_425
happyReduction_425 happy_x_1
	 =  case happyOut217 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (happy_var_1
	)}

happyReduce_426 = happySpecReduce_1  158# happyReduction_426
happyReduction_426 happy_x_1
	 =  case happyOut246 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (Lit (ann happy_var_1) happy_var_1
	)}

happyReduce_427 = happySpecReduce_3  158# happyReduction_427
happyReduction_427 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn172
		 (Paren (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_428 = happySpecReduce_3  158# happyReduction_428
happyReduction_428 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_3) <** happy_var_1:reverse (snd happy_var_3)) Boxed (Just happy_var_2 : fst happy_var_3)
	)}}}

happyReduce_429 = happyReduce 4# 158# happyReduction_429
happyReduction_429 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOut174 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightParen) -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> happy_var_4 <** happy_var_1:reverse (happy_var_4:happy_var_2)) Boxed
                                                      (replicate (length happy_var_2) Nothing ++ [Just happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_430 = happyReduce 4# 158# happyReduction_430
happyReduction_430 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOut174 happy_x_3 of { happy_var_3 -> 
	case happyOut175 happy_x_4 of { happy_var_4 -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_4) <** happy_var_1:reverse (snd happy_var_4 ++ happy_var_2)) Boxed
                                                      (replicate (length happy_var_2) Nothing ++ Just happy_var_3 : fst happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_431 = happySpecReduce_3  158# happyReduction_431
happyReduction_431 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_3) <** happy_var_1:reverse (snd happy_var_3)) Unboxed (Just happy_var_2 : fst happy_var_3)
	)}}}

happyReduce_432 = happySpecReduce_3  158# happyReduction_432
happyReduction_432 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) Unboxed [Just happy_var_2]
	)}}}

happyReduce_433 = happyReduce 4# 158# happyReduction_433
happyReduction_433 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOut174 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightHashParen) -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> happy_var_4 <** happy_var_1:reverse (happy_var_4:happy_var_2)) Unboxed
                                                      (replicate (length happy_var_2) Nothing ++ [Just happy_var_3])
	) `HappyStk` happyRest}}}}

happyReduce_434 = happyReduce 4# 158# happyReduction_434
happyReduction_434 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOut174 happy_x_3 of { happy_var_3 -> 
	case happyOut176 happy_x_4 of { happy_var_4 -> 
	happyIn172
		 (TupleSection (happy_var_1 <^^> head (snd happy_var_4) <** happy_var_1:reverse (snd happy_var_4 ++ happy_var_2)) Unboxed
                                                      (replicate (length happy_var_2) Nothing ++ Just happy_var_3 : fst happy_var_4)
	) `HappyStk` happyRest}}}}

happyReduce_435 = happySpecReduce_3  158# happyReduction_435
happyReduction_435 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOut188 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightSquare) -> 
	happyIn172
		 (amap (\l -> l <** [happy_var_3]) $ happy_var_2 (happy_var_1 <^^> happy_var_3 <** [happy_var_1])
	)}}}

happyReduce_436 = happySpecReduce_3  158# happyReduction_436
happyReduction_436 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 ParArrayLeftSquare) -> 
	case happyOut196 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 ParArrayRightSquare) -> 
	happyIn172
		 (amap (\l -> l <** [happy_var_3]) $ happy_var_2 (happy_var_1 <^^> happy_var_3 <** [happy_var_1])
	)}}}

happyReduce_437 = happySpecReduce_1  158# happyReduction_437
happyReduction_437 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Underscore) -> 
	happyIn172
		 (WildCard (nIS happy_var_1)
	)}

happyReduce_438 = happyMonadReduce 3# 158# happyReduction_438
happyReduction_438 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut178 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	( checkEnabled RegularPatterns >> return (Paren (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2))}}}
	) (\r -> happyReturn (happyIn172 r))

happyReduce_439 = happySpecReduce_3  158# happyReduction_439
happyReduction_439 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RPGuardOpen) -> 
	case happyOut177 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RPGuardClose) -> 
	happyIn172
		 (SeqRP (happy_var_1 <^^> happy_var_3 <** (happy_var_1:reverse (snd happy_var_2) ++ [happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_440 = happyReduce 5# 158# happyReduction_440
happyReduction_440 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 RPGuardOpen) -> 
	case happyOut158 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Bar) -> 
	case happyOut194 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RPGuardClose) -> 
	happyIn172
		 (GuardRP (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3 : snd happy_var_4 ++ [happy_var_5])) happy_var_2 $ (reverse $ fst happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_441 = happySpecReduce_1  158# happyReduction_441
happyReduction_441 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (happy_var_1
	)}

happyReduce_442 = happySpecReduce_1  158# happyReduction_442
happyReduction_442 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (let Loc l (THIdEscape s) = happy_var_1 in SpliceExp (nIS l) $ IdSplice (nIS l) s
	)}

happyReduce_443 = happySpecReduce_3  158# happyReduction_443
happyReduction_443 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THParenEscape) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn172
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in SpliceExp l $ ParenSplice l happy_var_2
	)}}}

happyReduce_444 = happySpecReduce_3  158# happyReduction_444
happyReduction_444 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THExpQuote) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	happyIn172
		 (let l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) in BracketExp l $ ExpBracket l happy_var_2
	)}}}

happyReduce_445 = happyMonadReduce 3# 158# happyReduction_445
happyReduction_445 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 THPatQuote) -> 
	case happyOut159 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	( do { p <- checkPattern happy_var_2;
                                              let {l = (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) };
                                              return $ BracketExp l $ PatBracket l p })}}}
	) (\r -> happyReturn (happyIn172 r))

happyReduce_446 = happySpecReduce_3  158# happyReduction_446
happyReduction_446 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTypQuote) -> 
	case happyOut107 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 THCloseQuote) -> 
	happyIn172
		 (let l = happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3] in BracketExp l $ TypeBracket l happy_var_2
	)}}}

happyReduce_447 = happyReduce 5# 158# happyReduction_447
happyReduction_447 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 THDecQuote) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	case happyOut248 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 THCloseQuote) -> 
	happyIn172
		 (let l = happy_var_1 <^^> happy_var_5 <** (happy_var_1:snd happy_var_3 ++ [happy_var_5])
                                            in BracketExp l $ DeclBracket (happy_var_1 <^^> happy_var_5 <** (happy_var_2:snd happy_var_3 ++ [happy_var_4,happy_var_5])) (fst happy_var_3)
	) `HappyStk` happyRest}}}}}

happyReduce_448 = happySpecReduce_2  158# happyReduction_448
happyReduction_448 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut220 happy_x_2 of { happy_var_2 -> 
	happyIn172
		 (VarQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_449 = happySpecReduce_2  158# happyReduction_449
happyReduction_449 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THVarQuote) -> 
	case happyOut223 happy_x_2 of { happy_var_2 -> 
	happyIn172
		 (VarQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_450 = happySpecReduce_2  158# happyReduction_450
happyReduction_450 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTyQuote) -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	happyIn172
		 (TypQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) (UnQual (ann happy_var_2) happy_var_2)
	)}}

happyReduce_451 = happySpecReduce_2  158# happyReduction_451
happyReduction_451 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 THTyQuote) -> 
	case happyOut104 happy_x_2 of { happy_var_2 -> 
	happyIn172
		 (TypQuote (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_452 = happySpecReduce_1  158# happyReduction_452
happyReduction_452 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn172
		 (let Loc l (THQuasiQuote (n,q)) = happy_var_1 in QuasiQuote (nIS l) n q
	)}

happyReduce_453 = happySpecReduce_2  159# happyReduction_453
happyReduction_453 happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	happyIn173
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_454 = happySpecReduce_1  159# happyReduction_454
happyReduction_454 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Comma) -> 
	happyIn173
		 ([happy_var_1]
	)}

happyReduce_455 = happySpecReduce_1  160# happyReduction_455
happyReduction_455 happy_x_1
	 =  case happyOut158 happy_x_1 of { happy_var_1 -> 
	happyIn174
		 (happy_var_1
	)}

happyReduce_456 = happySpecReduce_2  160# happyReduction_456
happyReduction_456 happy_x_2
	happy_x_1
	 =  case happyOut231 happy_x_1 of { happy_var_1 -> 
	case happyOut159 happy_x_2 of { happy_var_2 -> 
	happyIn174
		 (PreOp (happy_var_1 <> happy_var_2) happy_var_1 happy_var_2
	)}}

happyReduce_457 = happyMonadReduce 3# 160# happyReduction_457
happyReduction_457 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut158 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightArrow) -> 
	case happyOut204 happy_x_3 of { happy_var_3 -> 
	( do {checkEnabled ViewPatterns;
                                             return $ ViewPat (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3})}}}
	) (\r -> happyReturn (happyIn174 r))

happyReduce_458 = happySpecReduce_3  161# happyReduction_458
happyReduction_458 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOut175 happy_x_3 of { happy_var_3 -> 
	happyIn175
		 (let (mes, ss) = happy_var_3 in (replicate (length happy_var_1 - 1) Nothing ++ Just happy_var_2 : mes, ss ++ happy_var_1)
	)}}}

happyReduce_459 = happySpecReduce_3  161# happyReduction_459
happyReduction_459 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn175
		 ((replicate (length happy_var_1 - 1) Nothing ++ [Just happy_var_2], happy_var_3 : happy_var_1)
	)}}}

happyReduce_460 = happySpecReduce_2  161# happyReduction_460
happyReduction_460 happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn175
		 ((replicate (length happy_var_1) Nothing, happy_var_2 : happy_var_1)
	)}}

happyReduce_461 = happySpecReduce_3  162# happyReduction_461
happyReduction_461 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOut176 happy_x_3 of { happy_var_3 -> 
	happyIn176
		 (let (mes, ss) = happy_var_3 in (replicate (length happy_var_1 - 1) Nothing ++ Just happy_var_2 : mes, ss ++ happy_var_1)
	)}}}

happyReduce_462 = happySpecReduce_3  162# happyReduction_462
happyReduction_462 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOut174 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn176
		 ((replicate (length happy_var_1 - 1) Nothing ++ [Just happy_var_2], happy_var_3 : happy_var_1)
	)}}}

happyReduce_463 = happySpecReduce_2  162# happyReduction_463
happyReduction_463 happy_x_2
	happy_x_1
	 =  case happyOut173 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn176
		 ((replicate (length happy_var_1) Nothing, happy_var_2 : happy_var_1)
	)}}

happyReduce_464 = happySpecReduce_3  163# happyReduction_464
happyReduction_464 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut177 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn177
		 ((happy_var_3 : fst happy_var_1, happy_var_2 : snd happy_var_1)
	)}}}

happyReduce_465 = happySpecReduce_1  163# happyReduction_465
happyReduction_465 happy_x_1
	 =  case happyOut158 happy_x_1 of { happy_var_1 -> 
	happyIn177
		 (([happy_var_1],[])
	)}

happyReduce_466 = happySpecReduce_3  164# happyReduction_466
happyReduction_466 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut158 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut178 happy_x_3 of { happy_var_3 -> 
	happyIn178
		 (EitherRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_467 = happySpecReduce_3  164# happyReduction_467
happyReduction_467 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut158 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn178
		 (EitherRP (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_468 = happyMonadReduce 10# 165# happyReduction_468
happyReduction_468 (happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	case happyOut185 happy_x_3 of { happy_var_3 -> 
	case happyOut187 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XStdTagClose) -> 
	case happyOut180 happy_x_6 of { happy_var_6 -> 
	case happyOut164 happy_x_7 of { happy_var_7 -> 
	case happyOutTok happy_x_8 of { (Loc happy_var_8 XCloseTagOpen) -> 
	case happyOut182 happy_x_9 of { happy_var_9 -> 
	case happyOutTok happy_x_10 of { (Loc happy_var_10 XStdTagClose) -> 
	( do { n <- checkEqNames happy_var_2 happy_var_9;
                                                                       let { cn = reverse happy_var_6;
                                                                             as = reverse happy_var_3;
                                                                             l  = happy_var_1 <^^> happy_var_10 <** [happy_var_1,happy_var_5] ++ happy_var_7 ++ [happy_var_8,srcInfoSpan (ann happy_var_9),happy_var_10] };
                                                                       return $ XTag l n as happy_var_4 cn })}}}}}}}}}}
	) (\r -> happyReturn (happyIn179 r))

happyReduce_469 = happyReduce 5# 165# happyReduction_469
happyReduction_469 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XStdTagOpen) -> 
	case happyOut182 happy_x_2 of { happy_var_2 -> 
	case happyOut185 happy_x_3 of { happy_var_3 -> 
	case happyOut187 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XEmptyTagClose) -> 
	happyIn179
		 (XETag   (happy_var_1 <^^> happy_var_5 <** [happy_var_1,happy_var_5]) happy_var_2 (reverse happy_var_3) happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_470 = happySpecReduce_3  165# happyReduction_470
happyReduction_470 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 XCodeTagOpen) -> 
	case happyOut158 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 XCodeTagClose) -> 
	happyIn179
		 (XExpTag (happy_var_1 <^^> happy_var_3 <** [happy_var_1,happy_var_3]) happy_var_2
	)}}}

happyReduce_471 = happyReduce 5# 165# happyReduction_471
happyReduction_471 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 XChildTagOpen) -> 
	case happyOut180 happy_x_2 of { happy_var_2 -> 
	case happyOut164 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 XCloseTagOpen) -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 XCodeTagClose) -> 
	happyIn179
		 (XChildTag (happy_var_1 <^^> happy_var_5 <** (happy_var_1:happy_var_3++[happy_var_4,happy_var_5])) (reverse happy_var_2)
	) `HappyStk` happyRest}}}}}

happyReduce_472 = happySpecReduce_2  166# happyReduction_472
happyReduction_472 happy_x_2
	happy_x_1
	 =  case happyOut180 happy_x_1 of { happy_var_1 -> 
	case happyOut181 happy_x_2 of { happy_var_2 -> 
	happyIn180
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_473 = happySpecReduce_0  166# happyReduction_473
happyReduction_473  =  happyIn180
		 ([]
	)

happyReduce_474 = happySpecReduce_1  167# happyReduction_474
happyReduction_474 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn181
		 (let Loc l (XPCDATA pcd) = happy_var_1 in XPcdata (nIS l) pcd
	)}

happyReduce_475 = happySpecReduce_3  167# happyReduction_475
happyReduction_475 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 XRPatOpen) -> 
	case happyOut177 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 XRPatClose) -> 
	happyIn181
		 (XRPats (happy_var_1 <^^> happy_var_3 <** (snd happy_var_2 ++ [happy_var_1,happy_var_3])) $ reverse (fst happy_var_2)
	)}}}

happyReduce_476 = happySpecReduce_1  167# happyReduction_476
happyReduction_476 happy_x_1
	 =  case happyOut179 happy_x_1 of { happy_var_1 -> 
	happyIn181
		 (happy_var_1
	)}

happyReduce_477 = happySpecReduce_3  168# happyReduction_477
happyReduction_477 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut183 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Colon) -> 
	case happyOut183 happy_x_3 of { happy_var_3 -> 
	happyIn182
		 (let {Loc l1 s1 = happy_var_1; Loc l2 s2 = happy_var_3}
                                         in XDomName (nIS l1 <++> nIS l2 <** [l1,happy_var_2,l2]) s1 s2
	)}}}

happyReduce_478 = happySpecReduce_1  168# happyReduction_478
happyReduction_478 happy_x_1
	 =  case happyOut183 happy_x_1 of { happy_var_1 -> 
	happyIn182
		 (let Loc l str = happy_var_1 in XName (nIS l) str
	)}

happyReduce_479 = happySpecReduce_1  169# happyReduction_479
happyReduction_479 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn183
		 (let Loc l (VarId  s) = happy_var_1 in Loc l s
	)}

happyReduce_480 = happySpecReduce_1  169# happyReduction_480
happyReduction_480 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn183
		 (let Loc l (ConId  s) = happy_var_1 in Loc l s
	)}

happyReduce_481 = happySpecReduce_1  169# happyReduction_481
happyReduction_481 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn183
		 (let Loc l (DVarId s) = happy_var_1 in Loc l $ mkDVar s
	)}

happyReduce_482 = happySpecReduce_1  169# happyReduction_482
happyReduction_482 happy_x_1
	 =  case happyOut184 happy_x_1 of { happy_var_1 -> 
	happyIn183
		 (happy_var_1
	)}

happyReduce_483 = happySpecReduce_1  170# happyReduction_483
happyReduction_483 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Type) -> 
	happyIn184
		 (Loc happy_var_1 "type"
	)}

happyReduce_484 = happySpecReduce_1  170# happyReduction_484
happyReduction_484 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Class) -> 
	happyIn184
		 (Loc happy_var_1 "class"
	)}

happyReduce_485 = happySpecReduce_1  170# happyReduction_485
happyReduction_485 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Data) -> 
	happyIn184
		 (Loc happy_var_1 "data"
	)}

happyReduce_486 = happySpecReduce_1  170# happyReduction_486
happyReduction_486 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Foreign) -> 
	happyIn184
		 (Loc happy_var_1 "foreign"
	)}

happyReduce_487 = happySpecReduce_1  170# happyReduction_487
happyReduction_487 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Export) -> 
	happyIn184
		 (Loc happy_var_1 "export"
	)}

happyReduce_488 = happySpecReduce_1  170# happyReduction_488
happyReduction_488 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn184
		 (Loc happy_var_1 "safe"
	)}

happyReduce_489 = happySpecReduce_1  170# happyReduction_489
happyReduction_489 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn184
		 (Loc happy_var_1 "unsafe"
	)}

happyReduce_490 = happySpecReduce_1  170# happyReduction_490
happyReduction_490 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn184
		 (Loc happy_var_1 "interruptible"
	)}

happyReduce_491 = happySpecReduce_1  170# happyReduction_491
happyReduction_491 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn184
		 (Loc happy_var_1 "threadsafe"
	)}

happyReduce_492 = happySpecReduce_1  170# happyReduction_492
happyReduction_492 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn184
		 (Loc happy_var_1 "stdcall"
	)}

happyReduce_493 = happySpecReduce_1  170# happyReduction_493
happyReduction_493 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn184
		 (Loc happy_var_1 "ccall"
	)}

happyReduce_494 = happySpecReduce_1  170# happyReduction_494
happyReduction_494 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn184
		 (Loc happy_var_1 "cplusplus"
	)}

happyReduce_495 = happySpecReduce_1  170# happyReduction_495
happyReduction_495 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn184
		 (Loc happy_var_1 "dotnet"
	)}

happyReduce_496 = happySpecReduce_1  170# happyReduction_496
happyReduction_496 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn184
		 (Loc happy_var_1 "jvm"
	)}

happyReduce_497 = happySpecReduce_1  170# happyReduction_497
happyReduction_497 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn184
		 (Loc happy_var_1 "js"
	)}

happyReduce_498 = happySpecReduce_1  170# happyReduction_498
happyReduction_498 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn184
		 (Loc happy_var_1 "javascript"
	)}

happyReduce_499 = happySpecReduce_1  170# happyReduction_499
happyReduction_499 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn184
		 (Loc happy_var_1 "capi"
	)}

happyReduce_500 = happySpecReduce_1  170# happyReduction_500
happyReduction_500 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	happyIn184
		 (Loc happy_var_1 "as"
	)}

happyReduce_501 = happySpecReduce_1  170# happyReduction_501
happyReduction_501 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_By) -> 
	happyIn184
		 (Loc happy_var_1 "by"
	)}

happyReduce_502 = happySpecReduce_1  170# happyReduction_502
happyReduction_502 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Case) -> 
	happyIn184
		 (Loc happy_var_1 "case"
	)}

happyReduce_503 = happySpecReduce_1  170# happyReduction_503
happyReduction_503 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Default) -> 
	happyIn184
		 (Loc happy_var_1 "default"
	)}

happyReduce_504 = happySpecReduce_1  170# happyReduction_504
happyReduction_504 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Deriving) -> 
	happyIn184
		 (Loc happy_var_1 "deriving"
	)}

happyReduce_505 = happySpecReduce_1  170# happyReduction_505
happyReduction_505 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Do) -> 
	happyIn184
		 (Loc happy_var_1 "do"
	)}

happyReduce_506 = happySpecReduce_1  170# happyReduction_506
happyReduction_506 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Else) -> 
	happyIn184
		 (Loc happy_var_1 "else"
	)}

happyReduce_507 = happySpecReduce_1  170# happyReduction_507
happyReduction_507 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Family) -> 
	happyIn184
		 (Loc happy_var_1 "family"
	)}

happyReduce_508 = happySpecReduce_1  170# happyReduction_508
happyReduction_508 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	happyIn184
		 (Loc happy_var_1 "forall"
	)}

happyReduce_509 = happySpecReduce_1  170# happyReduction_509
happyReduction_509 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Group) -> 
	happyIn184
		 (Loc happy_var_1 "group"
	)}

happyReduce_510 = happySpecReduce_1  170# happyReduction_510
happyReduction_510 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn184
		 (Loc happy_var_1 "hiding"
	)}

happyReduce_511 = happySpecReduce_1  170# happyReduction_511
happyReduction_511 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_If) -> 
	happyIn184
		 (Loc happy_var_1 "if"
	)}

happyReduce_512 = happySpecReduce_1  170# happyReduction_512
happyReduction_512 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Import) -> 
	happyIn184
		 (Loc happy_var_1 "import"
	)}

happyReduce_513 = happySpecReduce_1  170# happyReduction_513
happyReduction_513 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_In) -> 
	happyIn184
		 (Loc happy_var_1 "in"
	)}

happyReduce_514 = happySpecReduce_1  170# happyReduction_514
happyReduction_514 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Infix) -> 
	happyIn184
		 (Loc happy_var_1 "infix"
	)}

happyReduce_515 = happySpecReduce_1  170# happyReduction_515
happyReduction_515 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixL) -> 
	happyIn184
		 (Loc happy_var_1 "infixl"
	)}

happyReduce_516 = happySpecReduce_1  170# happyReduction_516
happyReduction_516 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_InfixR) -> 
	happyIn184
		 (Loc happy_var_1 "infixr"
	)}

happyReduce_517 = happySpecReduce_1  170# happyReduction_517
happyReduction_517 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Instance) -> 
	happyIn184
		 (Loc happy_var_1 "instance"
	)}

happyReduce_518 = happySpecReduce_1  170# happyReduction_518
happyReduction_518 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	happyIn184
		 (Loc happy_var_1 "let"
	)}

happyReduce_519 = happySpecReduce_1  170# happyReduction_519
happyReduction_519 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_MDo) -> 
	happyIn184
		 (Loc happy_var_1 "mdo"
	)}

happyReduce_520 = happySpecReduce_1  170# happyReduction_520
happyReduction_520 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Module) -> 
	happyIn184
		 (Loc happy_var_1 "module"
	)}

happyReduce_521 = happySpecReduce_1  170# happyReduction_521
happyReduction_521 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_NewType) -> 
	happyIn184
		 (Loc happy_var_1 "newtype"
	)}

happyReduce_522 = happySpecReduce_1  170# happyReduction_522
happyReduction_522 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Of) -> 
	happyIn184
		 (Loc happy_var_1 "of"
	)}

happyReduce_523 = happySpecReduce_1  170# happyReduction_523
happyReduction_523 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Proc) -> 
	happyIn184
		 (Loc happy_var_1 "proc"
	)}

happyReduce_524 = happySpecReduce_1  170# happyReduction_524
happyReduction_524 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Rec) -> 
	happyIn184
		 (Loc happy_var_1 "rec"
	)}

happyReduce_525 = happySpecReduce_1  170# happyReduction_525
happyReduction_525 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	happyIn184
		 (Loc happy_var_1 "then"
	)}

happyReduce_526 = happySpecReduce_1  170# happyReduction_526
happyReduction_526 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Using) -> 
	happyIn184
		 (Loc happy_var_1 "using"
	)}

happyReduce_527 = happySpecReduce_1  170# happyReduction_527
happyReduction_527 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	happyIn184
		 (Loc happy_var_1 "where"
	)}

happyReduce_528 = happySpecReduce_1  170# happyReduction_528
happyReduction_528 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn184
		 (Loc happy_var_1 "qualified"
	)}

happyReduce_529 = happySpecReduce_2  171# happyReduction_529
happyReduction_529 happy_x_2
	happy_x_1
	 =  case happyOut185 happy_x_1 of { happy_var_1 -> 
	case happyOut186 happy_x_2 of { happy_var_2 -> 
	happyIn185
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_530 = happySpecReduce_0  171# happyReduction_530
happyReduction_530  =  happyIn185
		 ([]
	)

happyReduce_531 = happySpecReduce_3  172# happyReduction_531
happyReduction_531 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut182 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut170 happy_x_3 of { happy_var_3 -> 
	happyIn186
		 (XAttr (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_532 = happySpecReduce_1  173# happyReduction_532
happyReduction_532 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn187
		 (Just happy_var_1
	)}

happyReduce_533 = happySpecReduce_0  173# happyReduction_533
happyReduction_533  =  happyIn187
		 (Nothing
	)

happyReduce_534 = happySpecReduce_1  174# happyReduction_534
happyReduction_534 happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	happyIn188
		 (\l -> List l [happy_var_1]
	)}

happyReduce_535 = happySpecReduce_1  174# happyReduction_535
happyReduction_535 happy_x_1
	 =  case happyOut189 happy_x_1 of { happy_var_1 -> 
	happyIn188
		 (\l -> let (ps,ss) = happy_var_1 in List (l <** reverse ss) (reverse ps)
	)}

happyReduce_536 = happySpecReduce_2  174# happyReduction_536
happyReduction_536 happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DotDot) -> 
	happyIn188
		 (\l -> EnumFrom       (l <** [happy_var_2]) happy_var_1
	)}}

happyReduce_537 = happyReduce 4# 174# happyReduction_537
happyReduction_537 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DotDot) -> 
	happyIn188
		 (\l -> EnumFromThen   (l <** [happy_var_2,happy_var_4]) happy_var_1 happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_538 = happySpecReduce_3  174# happyReduction_538
happyReduction_538 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DotDot) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn188
		 (\l -> EnumFromTo     (l <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_539 = happyReduce 5# 174# happyReduction_539
happyReduction_539 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DotDot) -> 
	case happyOut158 happy_x_5 of { happy_var_5 -> 
	happyIn188
		 (\l -> EnumFromThenTo (l <** [happy_var_2,happy_var_4]) happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_540 = happySpecReduce_3  174# happyReduction_540
happyReduction_540 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut190 happy_x_3 of { happy_var_3 -> 
	happyIn188
		 (\l -> let (stss, ss) = happy_var_3 in ParComp (l <** (happy_var_2:ss)) happy_var_1 (reverse stss)
	)}}}

happyReduce_541 = happySpecReduce_3  175# happyReduction_541
happyReduction_541 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut189 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut174 happy_x_3 of { happy_var_3 -> 
	happyIn189
		 (let (es, ss) = happy_var_1 in (happy_var_3 : es, happy_var_2 : ss)
	)}}}

happyReduce_542 = happySpecReduce_3  175# happyReduction_542
happyReduction_542 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut174 happy_x_3 of { happy_var_3 -> 
	happyIn189
		 (([happy_var_3,happy_var_1], [happy_var_2])
	)}}}

happyReduce_543 = happySpecReduce_3  176# happyReduction_543
happyReduction_543 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut190 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut191 happy_x_3 of { happy_var_3 -> 
	happyIn190
		 (let { (stss, ss1) = happy_var_1;
                                              (sts, ss2) = happy_var_3 }
                                         in (reverse sts : stss, ss1 ++ [happy_var_2] ++ reverse ss2)
	)}}}

happyReduce_544 = happySpecReduce_1  176# happyReduction_544
happyReduction_544 happy_x_1
	 =  case happyOut191 happy_x_1 of { happy_var_1 -> 
	happyIn190
		 (let (sts, ss) = happy_var_1 in ([reverse sts], reverse ss)
	)}

happyReduce_545 = happySpecReduce_3  177# happyReduction_545
happyReduction_545 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut191 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut192 happy_x_3 of { happy_var_3 -> 
	happyIn191
		 (let (sts, ss) = happy_var_1 in (happy_var_3 : sts, happy_var_2 : ss)
	)}}}

happyReduce_546 = happySpecReduce_1  177# happyReduction_546
happyReduction_546 happy_x_1
	 =  case happyOut192 happy_x_1 of { happy_var_1 -> 
	happyIn191
		 (([happy_var_1],[])
	)}

happyReduce_547 = happySpecReduce_1  178# happyReduction_547
happyReduction_547 happy_x_1
	 =  case happyOut193 happy_x_1 of { happy_var_1 -> 
	happyIn192
		 (happy_var_1
	)}

happyReduce_548 = happySpecReduce_1  178# happyReduction_548
happyReduction_548 happy_x_1
	 =  case happyOut195 happy_x_1 of { happy_var_1 -> 
	happyIn192
		 (QualStmt (ann happy_var_1) happy_var_1
	)}

happyReduce_549 = happySpecReduce_2  179# happyReduction_549
happyReduction_549 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	happyIn193
		 (ThenTrans    (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_550 = happyReduce 4# 179# happyReduction_550
happyReduction_550 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_By) -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	happyIn193
		 (ThenBy       (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_551 = happyReduce 4# 179# happyReduction_551
happyReduction_551 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Group) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_By) -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	happyIn193
		 (GroupBy      (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_2,happy_var_3]) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_552 = happyReduce 4# 179# happyReduction_552
happyReduction_552 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Group) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_Using) -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	happyIn193
		 (GroupUsing   (nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_2,happy_var_3]) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_553 = happyReduce 6# 179# happyReduction_553
happyReduction_553 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Then) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 KW_Group) -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 KW_By) -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 KW_Using) -> 
	case happyOut157 happy_x_6 of { happy_var_6 -> 
	happyIn193
		 (GroupByUsing (nIS happy_var_1 <++> ann happy_var_6 <** [happy_var_1,happy_var_2,happy_var_3,happy_var_5]) happy_var_4 happy_var_6
	) `HappyStk` happyRest}}}}}}

happyReduce_554 = happySpecReduce_3  180# happyReduction_554
happyReduction_554 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut194 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut195 happy_x_3 of { happy_var_3 -> 
	happyIn194
		 (let (sts, ss) = happy_var_1 in (happy_var_3 : sts, happy_var_2 : ss)
	)}}}

happyReduce_555 = happySpecReduce_1  180# happyReduction_555
happyReduction_555 happy_x_1
	 =  case happyOut195 happy_x_1 of { happy_var_1 -> 
	happyIn194
		 (([happy_var_1],[])
	)}

happyReduce_556 = happySpecReduce_3  181# happyReduction_556
happyReduction_556 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrow) -> 
	case happyOut157 happy_x_3 of { happy_var_3 -> 
	happyIn195
		 (Generator (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_557 = happySpecReduce_1  181# happyReduction_557
happyReduction_557 happy_x_1
	 =  case happyOut157 happy_x_1 of { happy_var_1 -> 
	happyIn195
		 (Qualifier (ann happy_var_1) happy_var_1
	)}

happyReduce_558 = happySpecReduce_2  181# happyReduction_558
happyReduction_558 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	happyIn195
		 (LetStmt   (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_559 = happySpecReduce_0  182# happyReduction_559
happyReduction_559  =  happyIn196
		 (\l -> ParArray l []
	)

happyReduce_560 = happySpecReduce_1  182# happyReduction_560
happyReduction_560 happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (\l -> ParArray l [happy_var_1]
	)}

happyReduce_561 = happySpecReduce_1  182# happyReduction_561
happyReduction_561 happy_x_1
	 =  case happyOut189 happy_x_1 of { happy_var_1 -> 
	happyIn196
		 (\l -> let (ps,ss) = happy_var_1 in ParArray (l <** reverse ss) (reverse ps)
	)}

happyReduce_562 = happySpecReduce_3  182# happyReduction_562
happyReduction_562 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 DotDot) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn196
		 (\l -> ParArrayFromTo     (l <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_563 = happyReduce 5# 182# happyReduction_563
happyReduction_563 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 DotDot) -> 
	case happyOut158 happy_x_5 of { happy_var_5 -> 
	happyIn196
		 (\l -> ParArrayFromThenTo (l <** [happy_var_2,happy_var_4]) happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_564 = happySpecReduce_3  182# happyReduction_564
happyReduction_564 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut174 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Bar) -> 
	case happyOut190 happy_x_3 of { happy_var_3 -> 
	happyIn196
		 (\l -> let (stss, ss) = happy_var_3 in ParArrayComp (l <** (happy_var_2:ss)) happy_var_1 (reverse stss)
	)}}}

happyReduce_565 = happySpecReduce_3  183# happyReduction_565
happyReduction_565 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut198 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn197
		 ((fst happy_var_2, happy_var_1 <^^> happy_var_3, happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_566 = happySpecReduce_3  183# happyReduction_566
happyReduction_566 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut198 happy_x_2 of { happy_var_2 -> 
	case happyOut248 happy_x_3 of { happy_var_3 -> 
	happyIn197
		 (let l' =  ann . last $ fst happy_var_2
                                         in (fst happy_var_2, nIS happy_var_1 <++> l', happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_567 = happySpecReduce_3  184# happyReduction_567
happyReduction_567 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut199 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn198
		 ((reverse $ fst happy_var_2, happy_var_1 ++ snd happy_var_2 ++ happy_var_3)
	)}}}

happyReduce_568 = happySpecReduce_3  185# happyReduction_568
happyReduction_568 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut199 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut200 happy_x_3 of { happy_var_3 -> 
	happyIn199
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ happy_var_2)
	)}}}

happyReduce_569 = happySpecReduce_1  185# happyReduction_569
happyReduction_569 happy_x_1
	 =  case happyOut200 happy_x_1 of { happy_var_1 -> 
	happyIn199
		 (([happy_var_1],[])
	)}

happyReduce_570 = happySpecReduce_3  186# happyReduction_570
happyReduction_570 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	case happyOut201 happy_x_2 of { happy_var_2 -> 
	case happyOut152 happy_x_3 of { happy_var_3 -> 
	happyIn200
		 (Alt (happy_var_1 <> happy_var_2 <+?> (fmap ann) (fst happy_var_3) <** snd happy_var_3) happy_var_1 happy_var_2 (fst happy_var_3)
	)}}}

happyReduce_571 = happySpecReduce_2  187# happyReduction_571
happyReduction_571 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 RightArrow) -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	happyIn201
		 (UnGuardedRhs (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_572 = happySpecReduce_1  187# happyReduction_572
happyReduction_572 happy_x_1
	 =  case happyOut202 happy_x_1 of { happy_var_1 -> 
	happyIn201
		 (GuardedRhss  (snd happy_var_1) (reverse $ fst happy_var_1)
	)}

happyReduce_573 = happySpecReduce_2  188# happyReduction_573
happyReduction_573 happy_x_2
	happy_x_1
	 =  case happyOut202 happy_x_1 of { happy_var_1 -> 
	case happyOut203 happy_x_2 of { happy_var_2 -> 
	happyIn202
		 ((happy_var_2 : fst happy_var_1, snd happy_var_1 <++> ann happy_var_2)
	)}}

happyReduce_574 = happySpecReduce_1  188# happyReduction_574
happyReduction_574 happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	happyIn202
		 (([happy_var_1], ann happy_var_1)
	)}

happyReduce_575 = happyMonadReduce 4# 189# happyReduction_575
happyReduction_575 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Bar) -> 
	case happyOut194 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightArrow) -> 
	case happyOut157 happy_x_4 of { happy_var_4 -> 
	( do { checkPatternGuards (fst happy_var_2);
                                       let {l = nIS happy_var_1 <++> ann happy_var_4 <** (happy_var_1:snd happy_var_2 ++ [happy_var_3])};
                                       return (GuardedRhs l (reverse (fst happy_var_2)) happy_var_4) })}}}}
	) (\r -> happyReturn (happyIn203 r))

happyReduce_576 = happyMonadReduce 1# 190# happyReduction_576
happyReduction_576 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut158 happy_x_1 of { happy_var_1 -> 
	( checkPattern happy_var_1)}
	) (\r -> happyReturn (happyIn204 r))

happyReduce_577 = happyMonadReduce 2# 190# happyReduction_577
happyReduction_577 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	case happyOut170 happy_x_2 of { happy_var_2 -> 
	( checkPattern (BangPat (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2))}}
	) (\r -> happyReturn (happyIn204 r))

happyReduce_578 = happySpecReduce_3  191# happyReduction_578
happyReduction_578 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut206 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn205
		 ((fst happy_var_2, happy_var_1 <^^> happy_var_3, happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_579 = happySpecReduce_3  191# happyReduction_579
happyReduction_579 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut206 happy_x_2 of { happy_var_2 -> 
	case happyOut248 happy_x_3 of { happy_var_3 -> 
	happyIn205
		 (let l' =  ann . last $ fst happy_var_2
                                           in (fst happy_var_2, nIS happy_var_1 <++> l', happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_580 = happySpecReduce_3  192# happyReduction_580
happyReduction_580 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut207 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn206
		 ((reverse $ fst happy_var_2, happy_var_1 ++ snd happy_var_2 ++ happy_var_3)
	)}}}

happyReduce_581 = happySpecReduce_3  193# happyReduction_581
happyReduction_581 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut207 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut203 happy_x_3 of { happy_var_3 -> 
	happyIn207
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ happy_var_2)
	)}}}

happyReduce_582 = happySpecReduce_1  193# happyReduction_582
happyReduction_582 happy_x_1
	 =  case happyOut203 happy_x_1 of { happy_var_1 -> 
	happyIn207
		 (([happy_var_1], [])
	)}

happyReduce_583 = happySpecReduce_3  194# happyReduction_583
happyReduction_583 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut209 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightCurly) -> 
	happyIn208
		 ((fst happy_var_2, happy_var_1 <^^> happy_var_3, happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_584 = happySpecReduce_3  194# happyReduction_584
happyReduction_584 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut209 happy_x_2 of { happy_var_2 -> 
	case happyOut248 happy_x_3 of { happy_var_3 -> 
	happyIn208
		 (let l' =  ann . last $ fst happy_var_2
                                         in (fst happy_var_2, nIS happy_var_1 <++> l', happy_var_1:snd happy_var_2 ++ [happy_var_3])
	)}}}

happyReduce_585 = happySpecReduce_2  195# happyReduction_585
happyReduction_585 happy_x_2
	happy_x_1
	 =  case happyOut211 happy_x_1 of { happy_var_1 -> 
	case happyOut210 happy_x_2 of { happy_var_2 -> 
	happyIn209
		 ((happy_var_1 : fst happy_var_2, snd happy_var_2)
	)}}

happyReduce_586 = happySpecReduce_2  195# happyReduction_586
happyReduction_586 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	case happyOut209 happy_x_2 of { happy_var_2 -> 
	happyIn209
		 ((fst happy_var_2, happy_var_1 : snd happy_var_2)
	)}}

happyReduce_587 = happySpecReduce_0  195# happyReduction_587
happyReduction_587  =  happyIn209
		 (([],[])
	)

happyReduce_588 = happySpecReduce_2  196# happyReduction_588
happyReduction_588 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 SemiColon) -> 
	case happyOut209 happy_x_2 of { happy_var_2 -> 
	happyIn210
		 ((fst happy_var_2, happy_var_1 : snd happy_var_2)
	)}}

happyReduce_589 = happySpecReduce_0  196# happyReduction_589
happyReduction_589  =  happyIn210
		 (([],[])
	)

happyReduce_590 = happySpecReduce_2  197# happyReduction_590
happyReduction_590 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Let) -> 
	case happyOut79 happy_x_2 of { happy_var_2 -> 
	happyIn211
		 (LetStmt (nIS happy_var_1 <++> ann happy_var_2 <** [happy_var_1]) happy_var_2
	)}}

happyReduce_591 = happySpecReduce_3  197# happyReduction_591
happyReduction_591 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut204 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftArrow) -> 
	case happyOut157 happy_x_3 of { happy_var_3 -> 
	happyIn211
		 (Generator (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_592 = happySpecReduce_1  197# happyReduction_592
happyReduction_592 happy_x_1
	 =  case happyOut157 happy_x_1 of { happy_var_1 -> 
	happyIn211
		 (Qualifier (ann happy_var_1) happy_var_1
	)}

happyReduce_593 = happySpecReduce_2  197# happyReduction_593
happyReduction_593 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Rec) -> 
	case happyOut208 happy_x_2 of { happy_var_2 -> 
	happyIn211
		 (let (stms,inf,ss) = happy_var_2 in RecStmt (nIS happy_var_1 <++> inf <** happy_var_1:ss) stms
	)}}

happyReduce_594 = happySpecReduce_3  198# happyReduction_594
happyReduction_594 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut213 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Comma) -> 
	case happyOut212 happy_x_3 of { happy_var_3 -> 
	happyIn212
		 (let (fbs, ss) = happy_var_3 in (happy_var_1 : fbs, happy_var_2 : ss)
	)}}}

happyReduce_595 = happySpecReduce_1  198# happyReduction_595
happyReduction_595 happy_x_1
	 =  case happyOut213 happy_x_1 of { happy_var_1 -> 
	happyIn212
		 (([happy_var_1],[])
	)}

happyReduce_596 = happyMonadReduce 1# 198# happyReduction_596
happyReduction_596 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 DotDot) -> 
	( do { checkEnabled RecordWildCards `atSrcLoc` (getPointLoc happy_var_1);
                                              return ([FieldWildcard (nIS happy_var_1)], []) })}
	) (\r -> happyReturn (happyIn212 r))

happyReduce_597 = happySpecReduce_3  199# happyReduction_597
happyReduction_597 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut220 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut158 happy_x_3 of { happy_var_3 -> 
	happyIn213
		 (FieldUpdate (happy_var_1 <>happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_598 = happyMonadReduce 1# 199# happyReduction_598
happyReduction_598 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut220 happy_x_1 of { happy_var_1 -> 
	( checkEnabled NamedFieldPuns >> checkQualOrUnQual happy_var_1 >>= return . FieldPun (ann happy_var_1))}
	) (\r -> happyReturn (happyIn213 r))

happyReduce_599 = happySpecReduce_3  200# happyReduction_599
happyReduction_599 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut215 happy_x_2 of { happy_var_2 -> 
	case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn214
		 ((reverse (fst happy_var_2), reverse happy_var_1 ++ snd happy_var_2 ++ reverse happy_var_3)
	)}}}

happyReduce_600 = happySpecReduce_3  201# happyReduction_600
happyReduction_600 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut215 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut216 happy_x_3 of { happy_var_3 -> 
	happyIn215
		 ((happy_var_3 : fst happy_var_1, snd happy_var_1 ++ reverse happy_var_2)
	)}}}

happyReduce_601 = happySpecReduce_1  201# happyReduction_601
happyReduction_601 happy_x_1
	 =  case happyOut216 happy_x_1 of { happy_var_1 -> 
	happyIn215
		 (([happy_var_1],[])
	)}

happyReduce_602 = happySpecReduce_3  202# happyReduction_602
happyReduction_602 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut221 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 Equals) -> 
	case happyOut157 happy_x_3 of { happy_var_3 -> 
	happyIn216
		 (IPBind (happy_var_1 <> happy_var_3 <** [happy_var_2]) happy_var_1 happy_var_3
	)}}}

happyReduce_603 = happySpecReduce_2  203# happyReduction_603
happyReduction_603 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightParen) -> 
	happyIn217
		 (p_unit_con              (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_604 = happySpecReduce_2  203# happyReduction_604
happyReduction_604 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftSquare) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightSquare) -> 
	happyIn217
		 (List                    (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2]) []
	)}}

happyReduce_605 = happySpecReduce_3  203# happyReduction_605
happyReduction_605 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn217
		 (p_tuple_con             (happy_var_1 <^^> happy_var_3 <** happy_var_1:reverse (happy_var_3:happy_var_2)) Boxed (length happy_var_2)
	)}}}

happyReduce_606 = happySpecReduce_2  203# happyReduction_606
happyReduction_606 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 RightHashParen) -> 
	happyIn217
		 (p_unboxed_singleton_con (happy_var_1 <^^> happy_var_2 <** [happy_var_1,happy_var_2])
	)}}

happyReduce_607 = happySpecReduce_3  203# happyReduction_607
happyReduction_607 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftHashParen) -> 
	case happyOut173 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightHashParen) -> 
	happyIn217
		 (p_tuple_con             (happy_var_1 <^^> happy_var_3 <** happy_var_1:reverse (happy_var_3:happy_var_2)) Unboxed (length happy_var_2)
	)}}}

happyReduce_608 = happySpecReduce_1  203# happyReduction_608
happyReduction_608 happy_x_1
	 =  case happyOut223 happy_x_1 of { happy_var_1 -> 
	happyIn217
		 (Con (ann happy_var_1) happy_var_1
	)}

happyReduce_609 = happySpecReduce_1  204# happyReduction_609
happyReduction_609 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn218
		 (happy_var_1
	)}

happyReduce_610 = happySpecReduce_3  204# happyReduction_610
happyReduction_610 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn218
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_611 = happySpecReduce_1  205# happyReduction_611
happyReduction_611 happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	happyIn219
		 (happy_var_1
	)}

happyReduce_612 = happySpecReduce_3  205# happyReduction_612
happyReduction_612 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut243 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn219
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_613 = happySpecReduce_1  206# happyReduction_613
happyReduction_613 happy_x_1
	 =  case happyOut233 happy_x_1 of { happy_var_1 -> 
	happyIn220
		 (happy_var_1
	)}

happyReduce_614 = happySpecReduce_3  206# happyReduction_614
happyReduction_614 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut241 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn220
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_615 = happySpecReduce_1  207# happyReduction_615
happyReduction_615 happy_x_1
	 =  case happyOut236 happy_x_1 of { happy_var_1 -> 
	happyIn221
		 (happy_var_1
	)}

happyReduce_616 = happySpecReduce_1  208# happyReduction_616
happyReduction_616 happy_x_1
	 =  case happyOut238 happy_x_1 of { happy_var_1 -> 
	happyIn222
		 (happy_var_1
	)}

happyReduce_617 = happySpecReduce_3  208# happyReduction_617
happyReduction_617 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut240 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn222
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_618 = happySpecReduce_1  209# happyReduction_618
happyReduction_618 happy_x_1
	 =  case happyOut237 happy_x_1 of { happy_var_1 -> 
	happyIn223
		 (happy_var_1
	)}

happyReduce_619 = happySpecReduce_3  209# happyReduction_619
happyReduction_619 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftParen) -> 
	case happyOut232 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 RightParen) -> 
	happyIn223
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_620 = happySpecReduce_1  210# happyReduction_620
happyReduction_620 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn224
		 (happy_var_1
	)}

happyReduce_621 = happySpecReduce_3  210# happyReduction_621
happyReduction_621 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut235 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn224
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_622 = happySpecReduce_1  211# happyReduction_622
happyReduction_622 happy_x_1
	 =  case happyOut241 happy_x_1 of { happy_var_1 -> 
	happyIn225
		 (happy_var_1
	)}

happyReduce_623 = happySpecReduce_3  211# happyReduction_623
happyReduction_623 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut233 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn225
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_624 = happySpecReduce_1  212# happyReduction_624
happyReduction_624 happy_x_1
	 =  case happyOut242 happy_x_1 of { happy_var_1 -> 
	happyIn226
		 (happy_var_1
	)}

happyReduce_625 = happySpecReduce_3  212# happyReduction_625
happyReduction_625 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut233 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn226
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_626 = happySpecReduce_1  213# happyReduction_626
happyReduction_626 happy_x_1
	 =  case happyOut240 happy_x_1 of { happy_var_1 -> 
	happyIn227
		 (happy_var_1
	)}

happyReduce_627 = happySpecReduce_3  213# happyReduction_627
happyReduction_627 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut238 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn227
		 (fmap (const (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3])) happy_var_2
	)}}}

happyReduce_628 = happySpecReduce_1  214# happyReduction_628
happyReduction_628 happy_x_1
	 =  case happyOut232 happy_x_1 of { happy_var_1 -> 
	happyIn228
		 (happy_var_1
	)}

happyReduce_629 = happySpecReduce_3  214# happyReduction_629
happyReduction_629 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut237 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn228
		 (updateQNameLoc (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_630 = happySpecReduce_1  215# happyReduction_630
happyReduction_630 happy_x_1
	 =  case happyOut224 happy_x_1 of { happy_var_1 -> 
	happyIn229
		 (VarOp (ann happy_var_1) happy_var_1
	)}

happyReduce_631 = happySpecReduce_1  215# happyReduction_631
happyReduction_631 happy_x_1
	 =  case happyOut227 happy_x_1 of { happy_var_1 -> 
	happyIn229
		 (ConOp (ann happy_var_1) happy_var_1
	)}

happyReduce_632 = happySpecReduce_1  216# happyReduction_632
happyReduction_632 happy_x_1
	 =  case happyOut225 happy_x_1 of { happy_var_1 -> 
	happyIn230
		 (QVarOp (ann happy_var_1) happy_var_1
	)}

happyReduce_633 = happySpecReduce_1  216# happyReduction_633
happyReduction_633 happy_x_1
	 =  case happyOut228 happy_x_1 of { happy_var_1 -> 
	happyIn230
		 (QConOp (ann happy_var_1) happy_var_1
	)}

happyReduce_634 = happySpecReduce_1  217# happyReduction_634
happyReduction_634 happy_x_1
	 =  case happyOut226 happy_x_1 of { happy_var_1 -> 
	happyIn231
		 (QVarOp (ann happy_var_1) happy_var_1
	)}

happyReduce_635 = happySpecReduce_1  217# happyReduction_635
happyReduction_635 happy_x_1
	 =  case happyOut228 happy_x_1 of { happy_var_1 -> 
	happyIn231
		 (QConOp (ann happy_var_1) happy_var_1
	)}

happyReduce_636 = happySpecReduce_1  218# happyReduction_636
happyReduction_636 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Colon) -> 
	happyIn232
		 (list_cons_name (nIS happy_var_1)
	)}

happyReduce_637 = happySpecReduce_1  218# happyReduction_637
happyReduction_637 happy_x_1
	 =  case happyOut239 happy_x_1 of { happy_var_1 -> 
	happyIn232
		 (happy_var_1
	)}

happyReduce_638 = happySpecReduce_1  219# happyReduction_638
happyReduction_638 happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	happyIn233
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_639 = happySpecReduce_1  219# happyReduction_639
happyReduction_639 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn233
		 (let {Loc l (QVarId q) = happy_var_1; nis = nIS l}
                                 in Qual nis (ModuleName nis (fst q)) (Ident nis (snd q))
	)}

happyReduce_640 = happySpecReduce_1  220# happyReduction_640
happyReduction_640 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn234
		 (let Loc l (VarId v) = happy_var_1 in Ident (nIS l) v
	)}

happyReduce_641 = happySpecReduce_1  220# happyReduction_641
happyReduction_641 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_As) -> 
	happyIn234
		 (as_name         (nIS happy_var_1)
	)}

happyReduce_642 = happySpecReduce_1  220# happyReduction_642
happyReduction_642 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Qualified) -> 
	happyIn234
		 (qualified_name  (nIS happy_var_1)
	)}

happyReduce_643 = happySpecReduce_1  220# happyReduction_643
happyReduction_643 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Hiding) -> 
	happyIn234
		 (hiding_name     (nIS happy_var_1)
	)}

happyReduce_644 = happySpecReduce_1  220# happyReduction_644
happyReduction_644 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Export) -> 
	happyIn234
		 (export_name     (nIS happy_var_1)
	)}

happyReduce_645 = happySpecReduce_1  220# happyReduction_645
happyReduction_645 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_StdCall) -> 
	happyIn234
		 (stdcall_name    (nIS happy_var_1)
	)}

happyReduce_646 = happySpecReduce_1  220# happyReduction_646
happyReduction_646 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CCall) -> 
	happyIn234
		 (ccall_name      (nIS happy_var_1)
	)}

happyReduce_647 = happySpecReduce_1  220# happyReduction_647
happyReduction_647 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CPlusPlus) -> 
	happyIn234
		 (cplusplus_name  (nIS happy_var_1)
	)}

happyReduce_648 = happySpecReduce_1  220# happyReduction_648
happyReduction_648 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_DotNet) -> 
	happyIn234
		 (dotnet_name     (nIS happy_var_1)
	)}

happyReduce_649 = happySpecReduce_1  220# happyReduction_649
happyReduction_649 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Jvm) -> 
	happyIn234
		 (jvm_name        (nIS happy_var_1)
	)}

happyReduce_650 = happySpecReduce_1  220# happyReduction_650
happyReduction_650 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Js) -> 
	happyIn234
		 (js_name         (nIS happy_var_1)
	)}

happyReduce_651 = happySpecReduce_1  220# happyReduction_651
happyReduction_651 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_JavaScript) -> 
	happyIn234
		 (javascript_name (nIS happy_var_1)
	)}

happyReduce_652 = happySpecReduce_1  220# happyReduction_652
happyReduction_652 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_CApi) -> 
	happyIn234
		 (capi_name       (nIS happy_var_1)
	)}

happyReduce_653 = happySpecReduce_1  221# happyReduction_653
happyReduction_653 happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	happyIn235
		 (happy_var_1
	)}

happyReduce_654 = happySpecReduce_1  221# happyReduction_654
happyReduction_654 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn235
		 (safe_name       (nIS happy_var_1)
	)}

happyReduce_655 = happySpecReduce_1  221# happyReduction_655
happyReduction_655 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn235
		 (unsafe_name     (nIS happy_var_1)
	)}

happyReduce_656 = happySpecReduce_1  221# happyReduction_656
happyReduction_656 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Interruptible) -> 
	happyIn235
		 (interruptible_name (nIS happy_var_1)
	)}

happyReduce_657 = happySpecReduce_1  221# happyReduction_657
happyReduction_657 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn235
		 (threadsafe_name (nIS happy_var_1)
	)}

happyReduce_658 = happySpecReduce_1  221# happyReduction_658
happyReduction_658 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	happyIn235
		 (forall_name	  (nIS happy_var_1)
	)}

happyReduce_659 = happySpecReduce_1  221# happyReduction_659
happyReduction_659 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Family) -> 
	happyIn235
		 (family_name     (nIS happy_var_1)
	)}

happyReduce_660 = happySpecReduce_1  222# happyReduction_660
happyReduction_660 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn236
		 (let Loc l (IDupVarId i) = happy_var_1 in IPDup (nIS l) i
	)}

happyReduce_661 = happySpecReduce_1  222# happyReduction_661
happyReduction_661 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn236
		 (let Loc l (ILinVarId i) = happy_var_1 in IPLin (nIS l) i
	)}

happyReduce_662 = happySpecReduce_1  223# happyReduction_662
happyReduction_662 happy_x_1
	 =  case happyOut238 happy_x_1 of { happy_var_1 -> 
	happyIn237
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_663 = happySpecReduce_1  223# happyReduction_663
happyReduction_663 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn237
		 (let {Loc l (QConId q) = happy_var_1; nis = nIS l} in Qual nis (ModuleName nis (fst q)) (Ident nis (snd q))
	)}

happyReduce_664 = happySpecReduce_1  224# happyReduction_664
happyReduction_664 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn238
		 (let Loc l (ConId c) = happy_var_1 in Ident (nIS l) c
	)}

happyReduce_665 = happySpecReduce_1  225# happyReduction_665
happyReduction_665 happy_x_1
	 =  case happyOut240 happy_x_1 of { happy_var_1 -> 
	happyIn239
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_666 = happySpecReduce_1  225# happyReduction_666
happyReduction_666 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn239
		 (let {Loc l (QConSym q) = happy_var_1; nis = nIS l} in Qual nis (ModuleName nis (fst q)) (Symbol nis (snd q))
	)}

happyReduce_667 = happySpecReduce_1  226# happyReduction_667
happyReduction_667 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn240
		 (let Loc l (ConSym c) = happy_var_1 in Symbol (nIS l) c
	)}

happyReduce_668 = happySpecReduce_1  227# happyReduction_668
happyReduction_668 happy_x_1
	 =  case happyOut243 happy_x_1 of { happy_var_1 -> 
	happyIn241
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_669 = happySpecReduce_1  227# happyReduction_669
happyReduction_669 happy_x_1
	 =  case happyOut245 happy_x_1 of { happy_var_1 -> 
	happyIn241
		 (happy_var_1
	)}

happyReduce_670 = happySpecReduce_1  228# happyReduction_670
happyReduction_670 happy_x_1
	 =  case happyOut244 happy_x_1 of { happy_var_1 -> 
	happyIn242
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_671 = happySpecReduce_1  228# happyReduction_671
happyReduction_671 happy_x_1
	 =  case happyOut245 happy_x_1 of { happy_var_1 -> 
	happyIn242
		 (happy_var_1
	)}

happyReduce_672 = happySpecReduce_1  229# happyReduction_672
happyReduction_672 happy_x_1
	 =  case happyOut244 happy_x_1 of { happy_var_1 -> 
	happyIn243
		 (happy_var_1
	)}

happyReduce_673 = happySpecReduce_1  229# happyReduction_673
happyReduction_673 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	happyIn243
		 (minus_name (nIS happy_var_1)
	)}

happyReduce_674 = happySpecReduce_1  230# happyReduction_674
happyReduction_674 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn244
		 (let Loc l (VarSym v) = happy_var_1 in Symbol (nIS l) v
	)}

happyReduce_675 = happySpecReduce_1  230# happyReduction_675
happyReduction_675 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Exclamation) -> 
	happyIn244
		 (bang_name (nIS happy_var_1)
	)}

happyReduce_676 = happySpecReduce_1  230# happyReduction_676
happyReduction_676 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Dot) -> 
	happyIn244
		 (dot_name  (nIS happy_var_1)
	)}

happyReduce_677 = happySpecReduce_1  230# happyReduction_677
happyReduction_677 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Star) -> 
	happyIn244
		 (star_name (nIS happy_var_1)
	)}

happyReduce_678 = happySpecReduce_1  231# happyReduction_678
happyReduction_678 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn245
		 (let {Loc l (QVarSym q) = happy_var_1; nis = nIS l} in Qual nis (ModuleName nis (fst q)) (Symbol nis (snd q))
	)}

happyReduce_679 = happySpecReduce_1  232# happyReduction_679
happyReduction_679 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (IntTok        (i,raw)) = happy_var_1 in Int        (nIS l) i raw
	)}

happyReduce_680 = happySpecReduce_1  232# happyReduction_680
happyReduction_680 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (Character     (c,raw)) = happy_var_1 in Char       (nIS l) c raw
	)}

happyReduce_681 = happySpecReduce_1  232# happyReduction_681
happyReduction_681 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (FloatTok      (r,raw)) = happy_var_1 in Frac       (nIS l) r raw
	)}

happyReduce_682 = happySpecReduce_1  232# happyReduction_682
happyReduction_682 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (StringTok     (s,raw)) = happy_var_1 in String     (nIS l) s raw
	)}

happyReduce_683 = happySpecReduce_1  232# happyReduction_683
happyReduction_683 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (IntTokHash    (i,raw)) = happy_var_1 in PrimInt    (nIS l) i raw
	)}

happyReduce_684 = happySpecReduce_1  232# happyReduction_684
happyReduction_684 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (WordTokHash   (w,raw)) = happy_var_1 in PrimWord   (nIS l) w raw
	)}

happyReduce_685 = happySpecReduce_1  232# happyReduction_685
happyReduction_685 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (FloatTokHash  (f,raw)) = happy_var_1 in PrimFloat  (nIS l) f raw
	)}

happyReduce_686 = happySpecReduce_1  232# happyReduction_686
happyReduction_686 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (DoubleTokHash (d,raw)) = happy_var_1 in PrimDouble (nIS l) d raw
	)}

happyReduce_687 = happySpecReduce_1  232# happyReduction_687
happyReduction_687 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (CharacterHash (c,raw)) = happy_var_1 in PrimChar   (nIS l) c raw
	)}

happyReduce_688 = happySpecReduce_1  232# happyReduction_688
happyReduction_688 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn246
		 (let Loc l (StringHash    (s,raw)) = happy_var_1 in PrimString (nIS l) s raw
	)}

happyReduce_689 = happyMonadReduce 0# 233# happyReduction_689
happyReduction_689 (happyRest) tk
	 = happyThen (( pushCurrentContext >> getSrcLoc >>= \s -> return $ mkSrcSpan s s {- >>= \x -> trace (show x) (return x) -})
	) (\r -> happyReturn (happyIn247 r))

happyReduce_690 = happySpecReduce_1  234# happyReduction_690
happyReduction_690 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 VRightCurly) -> 
	happyIn248
		 (happy_var_1 {- >>= \x -> trace (show x ++ show x ++ show x) (return x) -}
	)}

happyReduce_691 = happyMonadReduce 1# 234# happyReduction_691
happyReduction_691 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (( popContext >> getSrcLoc >>= \s -> return $ mkSrcSpan s s {- >>= \x -> trace (show x ++ show x) (return x) -})
	) (\r -> happyReturn (happyIn248 r))

happyReduce_692 = happyMonadReduce 1# 235# happyReduction_692
happyReduction_692 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut250 happy_x_1 of { happy_var_1 -> 
	( checkEnabled PatternSynonyms >> return happy_var_1)}
	) (\r -> happyReturn (happyIn249 r))

happyReduce_693 = happyReduce 4# 236# happyReduction_693
happyReduction_693 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut251 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Equals) -> 
	case happyOut204 happy_x_4 of { happy_var_4 -> 
	happyIn250
		 (let l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]
             in PatSyn l happy_var_2 happy_var_4 ImplicitBidirectional
	) `HappyStk` happyRest}}}}

happyReduce_694 = happyReduce 4# 236# happyReduction_694
happyReduction_694 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut251 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftArrow) -> 
	case happyOut204 happy_x_4 of { happy_var_4 -> 
	happyIn250
		 (let l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1,happy_var_3]
               in PatSyn l happy_var_2 happy_var_4 Unidirectional
	) `HappyStk` happyRest}}}}

happyReduce_695 = happyReduce 5# 236# happyReduction_695
happyReduction_695 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut251 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 LeftArrow) -> 
	case happyOut204 happy_x_4 of { happy_var_4 -> 
	case happyOut253 happy_x_5 of { happy_var_5 -> 
	happyIn250
		 (let l = nIS happy_var_1 <++> ann happy_var_4 <** [happy_var_1, happy_var_3]
             in PatSyn l happy_var_2 happy_var_4 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_696 = happySpecReduce_2  237# happyReduction_696
happyReduction_696 happy_x_2
	happy_x_1
	 =  case happyOut222 happy_x_1 of { happy_var_1 -> 
	case happyOut252 happy_x_2 of { happy_var_2 -> 
	happyIn251
		 (let l = case happy_var_2 of
                                 [] -> ann happy_var_1
                                 (_:_) -> ann happy_var_1 <++> (ann $ last happy_var_2)
                        in PApp l (UnQual (ann happy_var_1) happy_var_1) happy_var_2
	)}}

happyReduce_697 = happySpecReduce_3  237# happyReduction_697
happyReduction_697 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	case happyOut239 happy_x_2 of { happy_var_2 -> 
	case happyOut235 happy_x_3 of { happy_var_3 -> 
	happyIn251
		 (PInfixApp (ann happy_var_1 <++> ann happy_var_3) (PVar (ann happy_var_1) happy_var_1) happy_var_2 (PVar (ann happy_var_3) happy_var_3)
	)}}}

happyReduce_698 = happySpecReduce_0  238# happyReduction_698
happyReduction_698  =  happyIn252
		 ([]
	)

happyReduce_699 = happySpecReduce_2  238# happyReduction_699
happyReduction_699 happy_x_2
	happy_x_1
	 =  case happyOut235 happy_x_1 of { happy_var_1 -> 
	case happyOut252 happy_x_2 of { happy_var_2 -> 
	happyIn252
		 (PVar (ann happy_var_1) happy_var_1 : happy_var_2
	)}}

happyReduce_700 = happyMonadReduce 4# 239# happyReduction_700
happyReduction_700 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOutTok happy_x_2 of { (Loc happy_var_2 LeftCurly) -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Loc happy_var_4 RightCurly) -> 
	(  checkExplicitPatSyn happy_var_1 happy_var_2 happy_var_3 happy_var_4)}}}}
	) (\r -> happyReturn (happyIn253 r))

happyReduce_701 = happyMonadReduce 4# 239# happyReduction_701
happyReduction_701 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Where) -> 
	case happyOut247 happy_x_2 of { happy_var_2 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	case happyOut248 happy_x_4 of { happy_var_4 -> 
	(  checkExplicitPatSyn happy_var_1 happy_var_2 happy_var_3 happy_var_4)}}}}
	) (\r -> happyReturn (happyIn253 r))

happyReduce_702 = happyMonadReduce 4# 240# happyReduction_702
happyReduction_702 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Pattern) -> 
	case happyOut222 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 DoubleColon) -> 
	case happyOut255 happy_x_4 of { happy_var_4 -> 
	( do { checkEnabled PatternSynonyms ;
                    let {(qtvs, ps, prov, req, ty) = happy_var_4} ;
                    let {sig = PatSynSig (nIS happy_var_1 <++> ann ty <** [happy_var_1, happy_var_3] ++ ps)  happy_var_2 qtvs prov req ty} ;
                    return sig })}}}}
	) (\r -> happyReturn (happyIn254 r))

happyReduce_703 = happyReduce 4# 241# happyReduction_703
happyReduction_703 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Forall) -> 
	case happyOut112 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 Dot) -> 
	case happyOut255 happy_x_4 of { happy_var_4 -> 
	happyIn255
		 (let (qtvs, ps, prov, req, ty) = happy_var_4
               in (Just (reverse (fst happy_var_2) ++ fromMaybe [] qtvs), (happy_var_1 : happy_var_3 : ps), prov, req, ty)
	) `HappyStk` happyRest}}}}

happyReduce_704 = happyMonadReduce 3# 241# happyReduction_704
happyReduction_704 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut109 happy_x_1 of { happy_var_1 -> 
	case happyOut109 happy_x_2 of { happy_var_2 -> 
	case happyOut98 happy_x_3 of { happy_var_3 -> 
	( do { c1 <- checkContext (Just happy_var_1) ;
                    c2 <- checkContext (Just happy_var_2) ;
                    t  <- checkType happy_var_3 ;
                    return $ (Nothing, [], c1, c2, t) })}}}
	) (\r -> happyReturn (happyIn255 r))

happyReduce_705 = happyMonadReduce 2# 241# happyReduction_705
happyReduction_705 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut109 happy_x_1 of { happy_var_1 -> 
	case happyOut98 happy_x_2 of { happy_var_2 -> 
	( do { c1 <- checkContext (Just happy_var_1);
                     t <- checkType happy_var_2;
                     return (Nothing, [], c1, Nothing, t) })}}
	) (\r -> happyReturn (happyIn255 r))

happyReduce_706 = happyMonadReduce 1# 241# happyReduction_706
happyReduction_706 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut98 happy_x_1 of { happy_var_1 -> 
	( checkType happy_var_1 >>= \t -> return (Nothing, [], Nothing, Nothing, t))}
	) (\r -> happyReturn (happyIn255 r))

happyReduce_707 = happySpecReduce_1  242# happyReduction_707
happyReduction_707 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn256
		 (let Loc l (ConId  n) = happy_var_1 in ModuleName (nIS l) n
	)}

happyReduce_708 = happySpecReduce_1  242# happyReduction_708
happyReduction_708 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn256
		 (let Loc l (QConId n) = happy_var_1 in ModuleName (nIS l) (fst n ++ '.':snd n)
	)}

happyReduce_709 = happySpecReduce_1  243# happyReduction_709
happyReduction_709 happy_x_1
	 =  case happyOut222 happy_x_1 of { happy_var_1 -> 
	happyIn257
		 (happy_var_1
	)}

happyReduce_710 = happySpecReduce_1  244# happyReduction_710
happyReduction_710 happy_x_1
	 =  case happyOut223 happy_x_1 of { happy_var_1 -> 
	happyIn258
		 (happy_var_1
	)}

happyReduce_711 = happySpecReduce_1  245# happyReduction_711
happyReduction_711 happy_x_1
	 =  case happyOut260 happy_x_1 of { happy_var_1 -> 
	happyIn259
		 (happy_var_1
	)}

happyReduce_712 = happySpecReduce_1  246# happyReduction_712
happyReduction_712 happy_x_1
	 =  case happyOut234 happy_x_1 of { happy_var_1 -> 
	happyIn260
		 (happy_var_1
	)}

happyReduce_713 = happySpecReduce_1  246# happyReduction_713
happyReduction_713 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Safe) -> 
	happyIn260
		 (safe_name       (nIS happy_var_1)
	)}

happyReduce_714 = happySpecReduce_1  246# happyReduction_714
happyReduction_714 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Unsafe) -> 
	happyIn260
		 (unsafe_name     (nIS happy_var_1)
	)}

happyReduce_715 = happySpecReduce_1  246# happyReduction_715
happyReduction_715 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 KW_Threadsafe) -> 
	happyIn260
		 (threadsafe_name (nIS happy_var_1)
	)}

happyReduce_716 = happySpecReduce_3  247# happyReduction_716
happyReduction_716 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 BackQuote) -> 
	case happyOut259 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Loc happy_var_3 BackQuote) -> 
	happyIn261
		 (UnQual (happy_var_1 <^^> happy_var_3 <** [happy_var_1, srcInfoSpan (ann happy_var_2), happy_var_3]) happy_var_2
	)}}}

happyReduce_717 = happySpecReduce_1  247# happyReduction_717
happyReduction_717 happy_x_1
	 =  case happyOut262 happy_x_1 of { happy_var_1 -> 
	happyIn261
		 (UnQual (ann happy_var_1) happy_var_1
	)}

happyReduce_718 = happySpecReduce_1  248# happyReduction_718
happyReduction_718 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn262
		 (let Loc l (VarSym x) = happy_var_1 in Symbol (nIS l) x
	)}

happyReduce_719 = happySpecReduce_1  248# happyReduction_719
happyReduction_719 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Loc happy_var_1 Minus) -> 
	happyIn262
		 (Symbol (nIS happy_var_1) "-"
	)}

happyReduce_720 = happyReduce 5# 249# happyReduction_720
happyReduction_720 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Loc happy_var_1 LeftCurly) -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut28 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Loc happy_var_5 RightCurly) -> 
	happyIn263
		 (let (ids, ss) = happy_var_3 in (ids, happy_var_1 : reverse happy_var_2 ++ ss ++ reverse happy_var_4 ++ [happy_var_5], happy_var_1 <^^> happy_var_5)
	) `HappyStk` happyRest}}}}}

happyReduce_721 = happyReduce 5# 249# happyReduction_721
happyReduction_721 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut247 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut28 happy_x_4 of { happy_var_4 -> 
	case happyOut248 happy_x_5 of { happy_var_5 -> 
	happyIn263
		 (let (ids, ss) = happy_var_3 in (ids, happy_var_1 : reverse happy_var_2 ++ ss ++ reverse happy_var_4 ++ [happy_var_5], happy_var_1 <^^> happy_var_5)
	) `HappyStk` happyRest}}}}}

happyReduce_722 = happySpecReduce_3  250# happyReduction_722
happyReduction_722 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut256 happy_x_3 of { happy_var_3 -> 
	happyIn264
		 ((happy_var_1, Just happy_var_3)
	)}}

happyReduce_723 = happySpecReduce_1  250# happyReduction_723
happyReduction_723 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn264
		 ((happy_var_1, Nothing)
	)}

happyReduce_724 = happySpecReduce_2  251# happyReduction_724
happyReduction_724 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn265
		 ((happy_var_1, happy_var_2)
	)}}

happyReduce_725 = happySpecReduce_3  252# happyReduction_725
happyReduction_725 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut263 happy_x_3 of { happy_var_3 -> 
	happyIn266
		 ((happy_var_1, happy_var_2, Just happy_var_3)
	)}}}

happyReduce_726 = happySpecReduce_2  252# happyReduction_726
happyReduction_726 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn266
		 ((happy_var_1, happy_var_2, Nothing)
	)}}

happyNewToken action sts stk
	= lexer(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	Loc _ EOF -> happyDoAction 147# tk action sts stk;
	Loc _ (VarId _) -> cont 1#;
	Loc _ (QVarId _) -> cont 2#;
	Loc _ (IDupVarId _) -> cont 3#;
	Loc _ (ILinVarId _) -> cont 4#;
	Loc _ (ConId _) -> cont 5#;
	Loc _ (QConId _) -> cont 6#;
	Loc _ (DVarId _) -> cont 7#;
	Loc _ (VarSym _) -> cont 8#;
	Loc _ (ConSym _) -> cont 9#;
	Loc _ (QVarSym _) -> cont 10#;
	Loc _ (QConSym _) -> cont 11#;
	Loc _ (IntTok _) -> cont 12#;
	Loc _ (FloatTok _) -> cont 13#;
	Loc _ (Character _) -> cont 14#;
	Loc _ (StringTok _) -> cont 15#;
	Loc _ (IntTokHash _) -> cont 16#;
	Loc _ (WordTokHash _) -> cont 17#;
	Loc _ (FloatTokHash _) -> cont 18#;
	Loc _ (DoubleTokHash _) -> cont 19#;
	Loc _ (CharacterHash _) -> cont 20#;
	Loc _ (StringHash _) -> cont 21#;
	Loc happy_dollar_dollar LeftParen -> cont 22#;
	Loc happy_dollar_dollar RightParen -> cont 23#;
	Loc happy_dollar_dollar LeftHashParen -> cont 24#;
	Loc happy_dollar_dollar RightHashParen -> cont 25#;
	Loc happy_dollar_dollar SemiColon -> cont 26#;
	Loc happy_dollar_dollar LeftCurly -> cont 27#;
	Loc happy_dollar_dollar RightCurly -> cont 28#;
	Loc happy_dollar_dollar VRightCurly -> cont 29#;
	Loc happy_dollar_dollar LeftSquare -> cont 30#;
	Loc happy_dollar_dollar RightSquare -> cont 31#;
	Loc happy_dollar_dollar ParArrayLeftSquare -> cont 32#;
	Loc happy_dollar_dollar ParArrayRightSquare -> cont 33#;
	Loc happy_dollar_dollar Comma -> cont 34#;
	Loc happy_dollar_dollar Underscore -> cont 35#;
	Loc happy_dollar_dollar BackQuote -> cont 36#;
	Loc happy_dollar_dollar Dot -> cont 37#;
	Loc happy_dollar_dollar DotDot -> cont 38#;
	Loc happy_dollar_dollar Colon -> cont 39#;
	Loc happy_dollar_dollar DoubleColon -> cont 40#;
	Loc happy_dollar_dollar Equals -> cont 41#;
	Loc happy_dollar_dollar Backslash -> cont 42#;
	Loc happy_dollar_dollar Bar -> cont 43#;
	Loc happy_dollar_dollar LeftArrow -> cont 44#;
	Loc happy_dollar_dollar RightArrow -> cont 45#;
	Loc happy_dollar_dollar At -> cont 46#;
	Loc happy_dollar_dollar Tilde -> cont 47#;
	Loc happy_dollar_dollar DoubleArrow -> cont 48#;
	Loc happy_dollar_dollar Minus -> cont 49#;
	Loc happy_dollar_dollar Exclamation -> cont 50#;
	Loc happy_dollar_dollar Star -> cont 51#;
	Loc happy_dollar_dollar LeftArrowTail -> cont 52#;
	Loc happy_dollar_dollar RightArrowTail -> cont 53#;
	Loc happy_dollar_dollar LeftDblArrowTail -> cont 54#;
	Loc happy_dollar_dollar RightDblArrowTail -> cont 55#;
	Loc happy_dollar_dollar RPGuardOpen -> cont 56#;
	Loc happy_dollar_dollar RPGuardClose -> cont 57#;
	Loc happy_dollar_dollar RPCAt -> cont 58#;
	Loc _ (THIdEscape _) -> cont 59#;
	Loc happy_dollar_dollar THParenEscape -> cont 60#;
	Loc happy_dollar_dollar THExpQuote -> cont 61#;
	Loc happy_dollar_dollar THPatQuote -> cont 62#;
	Loc happy_dollar_dollar THTypQuote -> cont 63#;
	Loc happy_dollar_dollar THDecQuote -> cont 64#;
	Loc happy_dollar_dollar THCloseQuote -> cont 65#;
	Loc happy_dollar_dollar THVarQuote -> cont 66#;
	Loc happy_dollar_dollar THTyQuote -> cont 67#;
	Loc _ (THQuasiQuote _) -> cont 68#;
	Loc _ (XPCDATA _) -> cont 69#;
	Loc happy_dollar_dollar XStdTagOpen -> cont 70#;
	Loc happy_dollar_dollar XCloseTagOpen -> cont 71#;
	Loc happy_dollar_dollar XCodeTagOpen -> cont 72#;
	Loc happy_dollar_dollar XChildTagOpen -> cont 73#;
	Loc happy_dollar_dollar XStdTagClose -> cont 74#;
	Loc happy_dollar_dollar XEmptyTagClose -> cont 75#;
	Loc happy_dollar_dollar XCodeTagClose -> cont 76#;
	Loc happy_dollar_dollar XRPatOpen -> cont 77#;
	Loc happy_dollar_dollar XRPatClose -> cont 78#;
	Loc happy_dollar_dollar KW_Foreign -> cont 79#;
	Loc happy_dollar_dollar KW_Export -> cont 80#;
	Loc happy_dollar_dollar KW_Safe -> cont 81#;
	Loc happy_dollar_dollar KW_Unsafe -> cont 82#;
	Loc happy_dollar_dollar KW_Threadsafe -> cont 83#;
	Loc happy_dollar_dollar KW_Interruptible -> cont 84#;
	Loc happy_dollar_dollar KW_StdCall -> cont 85#;
	Loc happy_dollar_dollar KW_CCall -> cont 86#;
	Loc happy_dollar_dollar KW_CPlusPlus -> cont 87#;
	Loc happy_dollar_dollar KW_DotNet -> cont 88#;
	Loc happy_dollar_dollar KW_Jvm -> cont 89#;
	Loc happy_dollar_dollar KW_Js -> cont 90#;
	Loc happy_dollar_dollar KW_JavaScript -> cont 91#;
	Loc happy_dollar_dollar KW_CApi -> cont 92#;
	Loc happy_dollar_dollar KW_As -> cont 93#;
	Loc happy_dollar_dollar KW_By -> cont 94#;
	Loc happy_dollar_dollar KW_Case -> cont 95#;
	Loc happy_dollar_dollar KW_Class -> cont 96#;
	Loc happy_dollar_dollar KW_Data -> cont 97#;
	Loc happy_dollar_dollar KW_Default -> cont 98#;
	Loc happy_dollar_dollar KW_Deriving -> cont 99#;
	Loc happy_dollar_dollar KW_Do -> cont 100#;
	Loc happy_dollar_dollar KW_Else -> cont 101#;
	Loc happy_dollar_dollar KW_Family -> cont 102#;
	Loc happy_dollar_dollar KW_Forall -> cont 103#;
	Loc happy_dollar_dollar KW_Group -> cont 104#;
	Loc happy_dollar_dollar KW_Hiding -> cont 105#;
	Loc happy_dollar_dollar KW_If -> cont 106#;
	Loc happy_dollar_dollar KW_Import -> cont 107#;
	Loc happy_dollar_dollar KW_In -> cont 108#;
	Loc happy_dollar_dollar KW_Infix -> cont 109#;
	Loc happy_dollar_dollar KW_InfixL -> cont 110#;
	Loc happy_dollar_dollar KW_InfixR -> cont 111#;
	Loc happy_dollar_dollar KW_Instance -> cont 112#;
	Loc happy_dollar_dollar KW_Let -> cont 113#;
	Loc happy_dollar_dollar KW_MDo -> cont 114#;
	Loc happy_dollar_dollar KW_Module -> cont 115#;
	Loc happy_dollar_dollar KW_NewType -> cont 116#;
	Loc happy_dollar_dollar KW_Of -> cont 117#;
	Loc happy_dollar_dollar KW_Proc -> cont 118#;
	Loc happy_dollar_dollar KW_Rec -> cont 119#;
	Loc happy_dollar_dollar KW_Then -> cont 120#;
	Loc happy_dollar_dollar KW_Type -> cont 121#;
	Loc happy_dollar_dollar KW_Using -> cont 122#;
	Loc happy_dollar_dollar KW_Where -> cont 123#;
	Loc happy_dollar_dollar KW_Qualified -> cont 124#;
	Loc happy_dollar_dollar KW_Role -> cont 125#;
	Loc happy_dollar_dollar KW_Pattern -> cont 126#;
	Loc _ (INLINE _) -> cont 127#;
	Loc happy_dollar_dollar INLINE_CONLIKE -> cont 128#;
	Loc happy_dollar_dollar SPECIALISE -> cont 129#;
	Loc _ (SPECIALISE_INLINE _) -> cont 130#;
	Loc happy_dollar_dollar SOURCE -> cont 131#;
	Loc happy_dollar_dollar RULES -> cont 132#;
	Loc happy_dollar_dollar CORE -> cont 133#;
	Loc happy_dollar_dollar SCC -> cont 134#;
	Loc happy_dollar_dollar GENERATED -> cont 135#;
	Loc happy_dollar_dollar DEPRECATED -> cont 136#;
	Loc happy_dollar_dollar WARNING -> cont 137#;
	Loc happy_dollar_dollar UNPACK -> cont 138#;
	Loc _ (OPTIONS _) -> cont 139#;
	Loc happy_dollar_dollar LANGUAGE -> cont 140#;
	Loc happy_dollar_dollar ANN -> cont 141#;
	Loc happy_dollar_dollar MINIMAL -> cont 142#;
	Loc happy_dollar_dollar NO_OVERLAP -> cont 143#;
	Loc happy_dollar_dollar OVERLAP -> cont 144#;
	Loc happy_dollar_dollar INCOHERENT -> cont 145#;
	Loc happy_dollar_dollar PragmaEnd -> cont 146#;
	_ -> happyError' tk
	})

happyError_ 147# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => P a -> (a -> P b) -> P b
happyThen = (>>=)
happyReturn :: () => a -> P a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> P a
happyReturn1 = happyReturn
happyError' :: () => (Loc Token) -> P a
happyError' tk = parseError tk

mparseModule = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut16 x))

mparseExp = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut157 x))

mparsePat = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut204 x))

mparseDeclAux = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut25 x))

mparseType = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut107 x))

mparseStmt = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut211 x))

mparseImportDecl = happySomeParser where
  happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut36 x))

ngparseModulePragmas = happySomeParser where
  happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut18 x))

ngparseModuleHeadAndImports = happySomeParser where
  happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut266 x))

ngparsePragmasAndModuleHead = happySomeParser where
  happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut265 x))

ngparsePragmasAndModuleName = happySomeParser where
  happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut264 x))

happySeq = happyDontSeq


type L = SrcSpanInfo -- just for convenience
type S = SrcSpan

parseError :: Loc Token -> P a
parseError t = fail $ "Parse error: " ++ showToken (unLoc t)

(<>) :: (Annotated a, Annotated b) => a SrcSpanInfo -> b SrcSpanInfo -> SrcSpanInfo
a <> b = ann a <++> ann b
infixl 6 <>

nIS = noInfoSpan
iS = infoSpan

mparseDecl :: P (Decl SrcSpanInfo)
mparseDecl = do
    (is, ds, _, _) <- mparseDeclAux
    when (not $ null is) $
       fail $ "Expected single declaration, found import declaration"
    checkSingleDecl ds
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 19 "<built-in>" #-}
{-# LINE 1 "/Users/matt/Downloads/ghc-7.10.1.app/Contents/lib/ghc-7.10.1/include/ghcversion.h" #-}


















{-# LINE 20 "<built-in>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 


{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif

{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList






{-# LINE 67 "templates/GenericTemplate.hs" #-}


{-# LINE 77 "templates/GenericTemplate.hs" #-}










infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          

          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     

                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)


{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.

