## Changes in 0.36.1
  - Allow `Cabal-3.12.*`
  - Support `base >= 4.20.0` (`Imports` does not re-export `Data.List.List`)

## Changes in 0.36.0
  - Don't infer `Paths_`-module with `spec-version: 0.36.0` or later

## Changes in 0.35.5
  - Add (undocumented) `list` command

## Changes in 0.35.4
  - Add `--canonical`, which can be used to produce canonical output instead of
    trying to produce minimal diffs
  - Avoid unnecessary writes on `--force` (see #555)
  - When an existing `.cabal` does not align fields then do not align fields in
    the generated `.cabal` file.
  - Fix a bug related to git conflict markers in existing `.cabal` files: When a
    `.cabal` file was essentially unchanged, but contained git conflict markers
    then `hpack` did not write a new `.cabal` file at all.  To address this
    `hpack` now unconditionally writes a new `.cabal` file when the existing
    `.cabal` file contains any git conflict markers.

## Changes in 0.35.3
  - Depend on `crypton` instead of `cryptonite`

## Changes in 0.35.2
  - Add support for `ghc-shared-options`

## Changes in 0.35.1
  - Allow `Cabal-3.8.*`
  - Additions to internal API

## Changes in 0.35.0
  - Add support for `language` (thanks @mpilgrem)
  - Accept Cabal names for fields where Hpack and Cabal use different
    terminology, but still warn (e.g. accept `hs-source-dirs` as an alias for
    `source-dirs`)

## Changes in 0.34.7
  - Support `Cabal-3.6.*`
  - Make sure that verbatim `import` fields are rendered at the beginning of
    a section (see #486)

## Changes in 0.34.6
  - Add `Paths_` module to `autogen-modules` when `cabal-version >= 2`

## Changes in 0.34.5
  - Compatibility with `aeson-2.*`

## Changes in 0.34.4
  - Render `default-extensions` / `other-extensions` line-separated
  - Compatibility with `Cabal-3.4.0.0`

## Changes in 0.34.3
  - Ignore duplicate source directories (see #356)
  - Do not infer duplicate modules (see  #408, #406, #353)
  - Reject empty `then` / `else` sections (see #362)
  - Omit conditionals that are always `false` from generated `.cabal` file
    (see #404)
  - Infer correct `cabal-version` when `Paths_` is used with `RebindableSyntax`
    and `OverloadedStrings` or `OverloadedLists` (see #400)
  - Do not use indentation from any existing `.cabal` file if it is invalid
    (e.g. `0`) (fixes #252)
  - Accept lists for `tested-with` (see #407)
  - Render current directory as `./` instead of `./.` for forward compatibility
    with future version of Cabal

## Changes in 0.34.2
  - Accept subcomponents as dependencies (close #382)

## Changes in 0.34.1
  - Fix a bug in `github: ...` introduced with `0.34.0`
    (f63eb19b956517b4dd8e28dc5785be5889a99298)

## Changes in 0.34.0 (deprecated)
  - Use `PreferNoHash` as default `GenerateHashStrategy`
  - Add support for library `visibility` (see #382)
  - Reject URLs for `github`

## Changes in 0.33.1
  - Add `GenerateHashStrategy`.  The default is `PreferHash` for `0.33.0` and
    will change to `PreferNoHash` with `0.34.0`. See
    https://github.com/sol/hpack/pull/390) for details.

  - Add command-line options `--hash` and `--no-hash`

## Changes in 0.33.0.1
  - Silently ignore missing hash when the cabal file content didn't change at
    all (for forward compatibility with #390)

## Changes in 0.33.0
  - Support GHC 8.8.1: `fail` is no longer a part of `Monad`. Instead, it lives
    in the `MonadFail` class. Adapting our code to this change meant changing
    the types of exporting functions, unfortunately, hence the major version
    bump.

## Changes in 0.32.0
  - Support Cabal 3.0
  - Switch reexported-modules to comma-separated list

## Changes in 0.31.2
  - Add default value for maintainer (see #339)
  - Escape commas and spaces in filenames when generating cabal files

## Changes in 0.31.1
  - Show the header when printing to stdout (see #331)
  - Add help for `--numeric-version`(see #337)

## Changes in 0.31.0
  - Add `mixin` to the fields read by dependencies when they are
    objects (see #318)
  - `hpack` now returns with a successful exit code if the `.cabal`
    file is up to date, even if it was generated by a newer version of
    `hpack`.

## Changes in 0.30.0
  - Warn on duplicate fields (see #283)
  - Always render `cabal-version` as `x.y` instead of `>= x.y` so that `cabal
    check` does not complain (see #322)
  - Extend `build-tools` so that it subsumes Cabal's `build-tools` and
    `build-tool-depends` (see #254)
  - Add support for `system-build-tools`
  - Keep declaration order for literal files in c-sources (and other fields
    that accept glob patterns).  This is crucial as a workaround for
    https://ghc.haskell.org/trac/ghc/ticket/13786 (see #324)

## Changes in 0.29.7
  - Expose more stuff from `Hpack.Yaml` so that it can be used by third parties

## Changes in 0.29.6
  - Add `spec-version` (see #300)

## Changes in 0.29.5
  - Fix a regression related to indentation sniffing (close #310)

## Changes in 0.29.4
  - Desugar ^>= when dependency is a string (see #309)
  - Add support for Apache, MPL and ISC when inferring `license` (see #305)

## Changes in 0.29.3
  - Desugar `^>=` for compatibility with `Cabal < 2` (see #213)
  - Add support for GPL, LGPL and AGPL when inferring `license` (see #305)

## Changes in 0.29.2
  - Add missing `extra-source-files` (see #302)

## Changes in 0.29.1
  - Infer `license` from `license-file`

## Changes in 0.29.0
  - Put the `cabal-version` at the beginning of the generated file. This Is
    required with `cabal-version: 2.1` and higher. (see #292)
  - With `cabal-version: 2.1` or higher omit `>=` when rendering (see #292)
  - Require `cabal-version: 2.2` when SPDX license identifiers are used (see #292)
  - Map cabal-style licenses to SPDX license identifiers when `cabal-version`
    is 2.2 or higher (see #292)

## Changes in 0.28.2
  - Exit with `exitFailure` on `AlreadyGeneratedByNewerHpack` or
    `ExistingCabalFileWasModifiedManually` in `Hpack.printResult`

## Changes in 0.28.1
  - GHC 8.4.1 compatibility

## Changes in 0.28.0
  - Add support for `cxx-options` and `cxx-sources` (see #205)
  - Add support for `data-dir` (see #100)
  - Generate valid `.cabal` files when `verbatim` is used top-level (see #280)

## Changes in 0.27.0
  - Local defaults are now resolved relative to the file they are
    mentioned in, not the CWD that hpack is invoked from.

## Changes in 0.26.0
  - Major refactoring of the exposed API (much cleaner now, but lot's of
    breaking changes!)
  - Remove Git conflict markers before checking the hash of any existing
    `.cabal` files (equivalent to `git checkout --ours`).  This allows to
    regenerate the `.cabal` file on conflicts when rebasing without passing
    `-f` in some cases and helps with preserving the formatting.
  - Allow local files to be used as defaults (#248)

## Changes in 0.25.0
  - Keep non-existing literal files on glob expansion (see #101)

## Changes in 0.24.0
  - Add support for `verbatim` Cabal escape hatch
  - Allow `version` be a numbers
  - Ignore fields that start with an underscore everywhere, not just globally

## Changes in 0.23.0
  - Add support for custom decoders to allow for alternate syntax (e.g. Dhall)
  - `generated-exposed-modules` and `generated-other-modules`, for populating
    the `autogen-modules` field (#207).
  - Corrected `cabal-version` setting for `reexported-modules` inside
    a conditional.

## Changes in 0.22.0
  - Add support for `defaults`
  - Add `--numeric-version`
  - Add support for `signatures`
  - `extra-doc-files` requires setting `cabal-version` to at least
    1.18; this is now done properly.
  - Accept bool for `condition` (see #230)

## Changes in 0.21.2
  - Fix a bug in module inference for conditionals (see #236)
  - Add support for `extra-doc-files`.
  - Add support for `pkg-config-dependencies`

## Changes in 0.21.1
  - Allow dependency constraints to be numbers (see #234)

## Changes in 0.21.0
  - Accept section-specific fields in conditionals (see #175, thanks to Scott
    Fleischman)
  - New section: `internal-libraries`, for Cabal 2's internal libraries (see #200).

## Changes in 0.20.0
  - Do not overwrite any existing cabal file if it has been modified manually

## Changes in 0.19.3
  - Add support for `frameworks` and `extra-frameworks-dirs`

## Changes in 0.19.2
 - Compatibility with `Glob >= 0.9.0`

## Changes in 0.19.1
  - Add `IsList` instance for `Dependencies`

## Changes in 0.19.0
  - Add Paths_* module to executables (see #195, for GHC 8.2.1 compatibility)
  - Allow specifying dependencies as a hash (see #198)

## Changes in 0.18.1
  - Output generated cabal file to `stdout` when `-` is given as a command-line
    option (see #113)
  - Recognize `.chs`, `.y`, `.ly` and `.x` as Haskell modules when inferring
    modules for

## Changes in 0.18.0
  - Make `executable` a shortcut of `executables: { package-name: ... }`
  - Add support for `ghcjs-options` and `js-sources` (see #161)
  - Allow `license-file` to be a list
  - Accept input file on command-line (see #106)
  - Add Paths_* when no modules are specified (see #86)

## Changes in 0.17.1
  - Do not descend into irrelevant directories when inferring modules (see #165)

## Changes in 0.17.0
  - Added custom-setup section
  - Add support for `!include` directives

## Changes in 0.16.0
  - Warn when `name` is missing
  - Support globs in `c-sources`
  - Use binary I/O for cabal files avoiding problems with non-UTF-8 locales
  - Fix rendering of `.` as directory (cabal syntax issue)
