# FilePath [![Hackage version](https://img.shields.io/hackage/v/filepath.svg?label=Hackage)](https://hackage.haskell.org/package/filepath) [![Linux build status](https://img.shields.io/travis/haskell/filepath/master.svg?label=Linux%20build)](https://travis-ci.org/haskell/filepath) [![Windows build status](https://img.shields.io/appveyor/ci/ndmitchell/filepath/master.svg?label=Windows%20build)](https://ci.appveyor.com/project/ndmitchell/filepath)

The `filepath-bytestring` package provides functionality for manipulating `RawFilePath` values (`ByteString`s).
Its interface is equivilant to the `filepath` package.
It provides three modules:

* [`System.FilePath.Posix.ByteString`](http://hackage.haskell.org/package/filepath-bytestring/docs/System-FilePath-Posix-ByteString.html) manipulates POSIX/Linux style `RawFilePath` values (with `/` as the path separator).
* [`System.FilePath.Windows.ByteString`](http://hackage.haskell.org/package/filepath-bytestring/docs/System-FilePath-Windows-ByteString.html) manipulates Windows style `RawFilePath` values (with either `\` or `/` as the path separator, and deals with drives).
* [`System.FilePath.ByteString`](http://hackage.haskell.org/package/filepath-bytestring/docs/System-FilePath-ByteString.html) is an alias for the module appropriate to your platform.

All three modules provide the same API, and the same documentation (calling out differences in the different variants).

### Developer notes

This package's version should be the same as the `filepath` it's derived
from, with an added revision number.

Most of the code is in `System/FilePath/Internal.hs` which is `#include`'d into both `System/FilePath/Posix.hs` and `System/FilePath/Windows.hs` with the `IS_WINDOWS` CPP define set to either `True` or `False`. This Internal module is a bit weird in that it isn't really a Haskell module, but is more an include file.

The library has extensive doc tests. Anything starting with `-- >` is transformed into a doc test as a predicate that must evaluate to `True`. These tests follow a few rules:

* Tests prefixed with `Windows:` or `Posix:` are only tested against that specific implementation - otherwise tests are run against both implementations.
* Any single letter variable, e.g. `x`, is considered universal quantification, and is checked with `QuickCheck`.
* If `Valid x =>` appears at the start of a doc test, that means the property will only be tested with `x` passing the `isValid` predicate.

Also, all exported functions are quickchecked against the ones from
`filepath` to make sure thay generate equivilant results.

The tests can be generated by `Generate.hs` in the root of the repo, and will be placed in `tests/TestGen.hs`. The `TestGen.hs` file is checked into the repo, and the CI scripts check that `TestGen.hs` is in sync with what would be generated a fresh - if you don't regenerate `TestGen.hs` the CI will fail.

The `.ghci` file is set up to allow you to type `ghci` to open the library, then `:go` will regenerate the tests and run them.
