/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.cache;

import org.gradle.api.internal.file.TestFiles;
import org.gradle.internal.serialize.Serializer;

import java.io.File;

public class TestFileContentCacheFactory implements FileContentCacheFactory {
    @Override
    public <V> FileContentCache<V> newCache(String name, int normalizedCacheSize, final Calculator<? extends V> calculator, Serializer<V> serializer) {
        return new FileContentCache<V>() {
            @Override
            public V get(File file) {
                return calculator.calculate(file, TestFiles.fileSystem().stat(file).getType());
            }
        };
    }
}
