# Awesome Design
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Build Status](https://travis-ci.org/gztchan/awesome-design.svg?branch=master)](https://travis-ci.org/gztchan/awesome-design)
[![PRs & Issues Welcome](https://img.shields.io/badge/PRs%20&%20Issues-welcome-brightgreen.svg)](https://github.com/gztchan/awesome-design/pulls)

> Awesome Design focuses on collecting high quality resources and tools which can be used by UI/UX designers in daily work. Thanks to the community,
the repo keeps being updated continuously from people around the world who provide amazing resources.
Don't hesitate to open an [issue](https://github.com/gztchan/awesome-design/issues/new) or create [pull request](https://github.com/gztchan/awesome-design/pulls) to share your intelligence.

![design](/design.png)

#### What should I do with those resources?

People, including developers, designers, scientists and others, create awesome things every single day.
To be honest, we who are not superheroes, can't know all best things from the world. So, for saving your time,
I suggest you to pick those you like, take benefits from them, and finally put it into your kit. :smile:

#### Symbols

- :+1: Recommended
- :computer: macOS only
- :mega: beta, keep watching

#### Contents

- [Soul of Design](#soul-of-design-sunny)
- [Design Leader](#design-leader-dolls)
- [Resources](#resources-package)
- [High Quality Photos](#high-quality-photos-tokyo_tower)
- [Color](#color-art)
- [Font](#font-mahjong)
- [Icon/Logo](#iconlogo-tada)
- [Tool](#tool-wrench)
- [Prototype](#prototype-memo)
- [User Testing](#user-testing-busts_in_silhouette)
- [Mockup](#mockup-hatching_chick)
- [Style Guide/Branding](#style-guidebranding-octocat)
- [Tutorial](#tutorial-school)
- [Book](#book-books)
- [Award](#award)
- [Conference/Festival](#conferencefestival-beers)
- [Podcast](#podcast-radio)
- [Social Network](#social-network-couplecouple)

## Todo

- [ ] Description
- [ ] Remove unavailable/not-cool resources

## Soul of Design :sunny:

- [Design Milk](http://design-milk.com/) - An online magazine dedicated to modern design, offers what’s new in art, architecture, interior design, furniture and decor, fashion and technology.
- [frog](https://www.frogdesign.com/) - A global design and strategy firm.
- [Danish Design Centre](http://danskdesigncenter.dk/)
- [Google Design](https://design.google.com/)
- [Google Art & Culture](https://www.google.com/culturalinstitute/beta/)
- [Airbnb](https://airbnb.design/)
- [Fast.Co Design](https://www.fastcodesign.com/)
- [Smashing Magazine](https://www.smashingmagazine.com/)
- [Design Taxi](http://designtaxi.com/)
- [Yanko Design](http://www.yankodesign.com/)
- [Swiss Miss](http://www.swiss-miss.com/)
- [UX Magazine](http://uxmag.com/)
- [UXBooth](http://www.uxbooth.com/)
- [IDEO](https://www.ideo.com/)
- [Design Shack](https://designshack.net/)
- [Booooooom](http://www.booooooom.com/blog/design/)
- [designmodo](https://designmodo.com/)
- [webdesignerdepot](https://www.webdesignerdepot.com/)
- [UX Movement](http://uxmovement.com/)
- [Speckyboy](https://speckyboy.com/)
- [HUGE](http://www.hugeinc.com/)
- [Sitepoint](https://www.sitepoint.com/)
- [UIE](https://articles.uie.com/)
- [Attack the Front](http://attackthefront.com)
- [codrops](https://tympanus.net/codrops/)
- [The Greate Discontent](https://thegreatdiscontent.com/)
- [Underconsideration](http://underconsideration.com/)
- [Little Big Details](http://littlebigdetails.com/)
- [WAYS WE WORK](http://wayswework.io/)
- [designenvy](https://designenvy.aiga.org/)
- [Creative Review](https://www.creativereview.co.uk/)
- [CREATIVE OVERFLOW](http://creativeoverflow.net/)
- [FORM UP NORTH](http://www.fromupnorth.com/)
- [Facebook](http://facebook.design/)
- [Facebook Design on Medium](https://medium.com/facebook-design)
- [Hacking UI](http://hackingui.com/)
- [THE INDUSTRY](http://theindustry.cc/)
- [Hey Design](https://heydesign.com/)
- [PixelSquid](https://www.pixelsquid.com/)
- [LOGO DESIGN LOVE](http://www.logodesignlove.com/) - A website and book devoted to the design of logos and brand identities.
- [DesignM.ag](https://designm.ag/)
- [Hey Designer](http://heydesigner.com/)
- [Great Apps Timeline](http://greatappstimeline.xyz/)
- [Nicely Done](http://nicelydone.club/)
- [Dropbox Design](https://medium.com/dropbox-design)

## Design Leader :dolls:

- [365 Awesome Designers](http://365awesomedesigners.com/)

## Resources :package:

- [Designer News](https://www.designernews.co/) - A large, global community of people working in design and technology or those interested in the topics.
- [Sidebar](https://sidebar.io/)
- [CodePen](https://codepen.io/)
- [Web Designer News](http://www.webdesignernews.com/)
- [UX for VR](https://www.uxofvr.com/)
- [Reeoo](http://reeoo.com/)
- [CREATIVE BLOQ](http://www.creativebloq.com/) :rocket:
- [Lorem Ipsum](http://www.lipsum.com/feed/html)
- [Pond5](https://www.pond5.com/)
- [Dexigner](https://www.dexigner.com/)
- [Nicce](https://niice.co/)
- [Artwxrk](https://www.artwxrk.com)
- [Designspiration](http://designspiration.net/)
- [Freebiesbug](https://freebiesbug.com/)
- [Muuuuu](http://muuuuu.org/)
- [Muzli](https://muz.li/)
- [The Best Designs](https://www.thebestdesigns.com/)
- [Flat Inspire](http://flatinspire.com/)
- [Site Inspire](https://www.siteinspire.com/)
- [Media Queries](https://mediaqueri.es/)
- [One Page Love](https://onepagelove.com/)
- [Admire the Web](https://www.admiretheweb.com/)
- [Pttrns](https://pttrns.com/)
- [CRAFTED BY LOVE](http://www.craftedbylove.com/#/)
- [Nice Portfolio](http://niceportfol.io/)
- [HTTPSTER](https://httpster.net/)
- [Empty States](http://emptystat.es/)
- [Call to Idea](http://www.calltoidea.com/)
- [flatdsgn](http://flatdsgn.com/)
- [designfridge](http://designfridge.co.uk/)
- [Siiimple](https://siiimple.com/)
- [Zurb PatternTap](http://zurb.com/patterntap)
- [Land Book](https://land-book.com/)
- [worthyofnote](http://worthyofnote.co.uk/)
- [oozled](http://oozled.com/)
- [DESIGN DETAILS](http://www.brianlovin.com/design-details/)
- [officelovin](https://www.officelovin.com/)
- [Best Website](https://bestwebsite.gallery/)
- [FreeDesignResources](http://freedesignresources.net/)
- [Abduzeedo](http://abduzeedo.com/)
- [Material UI](https://www.materialui.co)
- [1stwebdesigner](https://1stwebdesigner.com/blog/)
- [EMOJI CHEAT SHEET](https://www.webpagefx.com/tools/emoji-cheat-sheet/)
- [EMOJI CSS](https://afeld.github.io/emoji-css/?ref=webdesignernews.com)
- [Simple CSS Media Queries](http://michael-gannon.com/media/index.html?ref=webdesignernews.com)
- [ShockFamily](https://www.designshock.com/)
- [SVG PORN](http://www.svgporn.com/)
- [Google Device Metrics](https://design.google.com/devices/)
- [UpLabs](https://www.uplabs.com/)
- [Freebbble](http://freebbble.com/)
- [GraphicBurger](http://graphicburger.com/)
- [Baianat](https://www.baianat.com/resources/)
- [GRAPHBERRY](http://www.graphberry.com/)
- [UX Project Checklist](http://uxchecklist.github.io/)
- [TRIDIV](http://tridiv.com/) - Making 3D in CSS has never been easier
- [function](http://wefunction.com/handmade-font-bundle/)
- [Mobile Mozaic](http://www.mobilemozaic.com/)
- [wwwhere](http://wwwhere.io/)
- [Checkout Pages](http://pages.xyz/type/checkout)
- [Pricing Pages](http://www.pages.xyz/pricing)
- [Product Pages](http://www.pages.xyz/product)
- [Store Pages](http://www.pages.xyz/type/store)
- [Lapa](http://www.lapa.ninja/)
- [Designer Mill](https://www.designermill.com/)
- [Freebiesjedi](http://freebiesjedi.com)
- [Webfieldmanual](https://webfieldmanual.com/) :rocket:
- [Prototyping Tools](http://www.prototypingtools.co/)
- [UXTOOLS](https://uxtools.co/)
- ~~[FFFFOUND](http://ffffound.com/)~~

## High Quality Photos :tokyo_tower:

- [Albumarium](http://albumarium.com/)
- [The Stocks](http://thestocks.im/)
- [Polayoutu](http://www.polayoutu.com/collections)
- [Illusion](http://illusion.scene360.com/)
- [Baubauhaus](http://www.baubauhaus.com/)
- [500px](https://500px.com/) :100:
- [1x](https://1x.com/)
- [LIFE OF PIX](http://www.lifeofpix.com/)
- [Unsplash](https://unsplash.com/)
- [Stokpic](http://stokpic.com/)
- [Raumrot](https://www.howtostartanllc.org/free-stock-photos/)
- [Death to Stock](http://deathtothestockphoto.com/)
- [GRATISOGRAPHYMADE](http://www.gratisography.com/)
- [picjumbo](https://picjumbo.com/)
- [Magdeleine](https://magdeleine.co/browse/)
- [Pexels](https://www.pexels.com/)
- [imcreator](http://imcreator.com/)
- [Startup Stock Photos](http://startupstockphotos.com/)
- [New Old Stock Photos](http://nos.twnsnd.co/)
- [Realistics Shots](http://realisticshots.com/)
- [SplitShire](https://www.splitshire.com/)
- [FANCYCRAVE](http://fancycrave.com/)
- [LIBRESHOT](https://libreshot.com/)
- [FreeJPG](http://en.freejpg.com.ar/)
- [BARN IMAGES](https://barnimages.com/)
- [MMT](https://mmtstock.com/)
- [JAY MANTRI](http://jaymantri.com/)
- [Public Domain Archive](http://publicdomainarchive.com/)
- [FoodiesFeed](https://www.foodiesfeed.com/)
- [Little Visuals](http://littlevisuals.co/)
- [Bucketlistly](http://photos.bucketlistly.com/)
- [Cupcake](http://cupcake.nilssonlee.se/)
- [Pinterest](https://www.pinterest.com/)
- [pixabay](https://pixabay.com/)
- [depositphotos](https://depositphotos.com/)
- [Stocksy](https://www.stocksy.com)
- [butdoesitfloat](http://butdoesitfloat.com/)

## Color :art:

- [Coolors](https://coolors.co/)
- [Colordot](https://color.hailpixel.com/)
- [Brand Colors](https://brandcolors.net/)
- [Material Palette](https://www.materialpalette.com/)
- [FLATCOLORS](http://www.flatuicolorpicker.com/)
- [LOLCOLORS](https://www.webdesignrankings.com/resources/lolcolors/)
- [The days color](http://www.thedayscolor.com/)
- [Color Claim](http://colorclaim.tumblr.com/)
- [Color Hunt](http://colorhunt.co/)
- [CSS Colors](http://colours.neilorangepeel.com/)
- [RGB TO](http://rgb.to/)
- [Color Code](http://www.colourco.de/)
- [colorrrs](http://www.webpagefx.com/web-design/hex-to-rgb/)
- [Nippon Colors](http://nipponcolors.com/)
- [Colorize](https://alexbeals.com/projects/colorize/)
- [Hello Color](http://jxnblk.com/hello-color/)
- [Web Color Data](http://webcolourdata.com/)
- [Color Lisa](http://www.colorlisa.com/)
- [ColorDrop](https://colordrop.io/)
- [colorfavs](http://www.colorfavs.com/)
- [uiGradients](https://uigradients.com/)
- [swiss style color picker](http://swisscolors.net/)
- [HTML color codes](http://htmlcolorcodes.com/)
- [palettr](http://palettr.com/)
- [Paletton](http://paletton.com/)
- [Palettable](http://www.palettable.io/)
- [Colllor](http://colllor.com/)
- [Colorable](http://jxnblk.com/colorable/demos/text/?background=%23FFFFFF&foreground=%23000000) - Get contrast values for every color combination with pass/fail scores for the WCAG accessibility guidelines.
- [Google Colors](https://material.io/guidelines/style/color.html)
- [Color Schemer](http://colorschemr.com/#/app)
- [WebGradients](https://webgradients.com/) - Free collection of 180 linear gradients that you can use as content backdrops in any part of your website.

## Font :mahjong:

- [typography](https://www.typography.com/)
- [i love typography](http://ilovetypography.com/)
- [Type is Beautiful](https://www.typeisbeautiful.com/)
- [Butterick's Practical Typography](http://practicaltypography.com/)
- [Fonts](https://www.fonts.com/)
- [Font Squirrel](https://www.fontsquirrel.com/)
- [Typewolf](https://www.typewolf.com/)
- [Type Novel](http://typenovel.tumblr.com/)
- [FONTS IN USE](https://fontsinuse.com/)
- [Webtype](https://www.webtype.com/)
- [My Fonts](http://www.myfonts.com/)
- [The Designers Foundry](https://www.thedesignersfoundry.com/)
- [Typekit](https://typekit.com/fonts)
- [Google Fonts](https://fonts.google.com/)
- [Google Font Combinations](https://femmebot.github.io/google-type/)
- [JUSTFONT BLOG](http://blog.justfont.com/)
- [Font Library](http://katydecorah.com/font-library/)
- [Type Guide](http://www.typogui.de/)
- [typeanything](https://typeanything.io/)
- [workmark](https://wordmark.it/)
- [fontfling](http://fontfling.com/)
- [glyphr](http://www.glyphrstudio.com/online/)
- [LOST TYPE](http://www.losttype.com/browse/)
- [Brick](http://brick.im/)
- [Village](https://vllg.com/)
- [Klim](https://klim.co.nz/)
- [Milieu Grotesque](https://www.milieugrotesque.com/)
- [Lineto](https://lineto.com/)
- [Colophon](https://www.colophon-foundry.org/)
- [T26](https://www.t26.com/)
- [Typ.io](https://typ.io)
- [TypeNetwork](https://www.typenetwork.com/)
- [Discover.typography](https://discover.typography.com/)
- [The League of Moveable Type](https://www.theleagueofmoveabletype.com/)

## Icon/Logo :tada:

- [macosicongallery](http://macosicongallery.com/)
- [icon54](https://icon54.com)
- [icons8](https://icons8.com/)
- [Icon Finder](https://www.iconfinder.com/)
- [icon dock](http://icondock.com/)
- [genericons](https://genericons.com/)
- [FlatIcons](http://flaticons.net/)
- [FLATICON](http://www.flaticon.com/)
- [Evil Icons](http://evil-icons.io/)
- [Typeicons](http://typicons.com/)
- [thennounproject](https://thenounproject.com/)
- [Nucleoapp](https://nucleoapp.com/)
- [Picons](https://picons.me/)
- [Pictos](http://pictos.cc/)
- [smashicons](https://smashicons.com/)
- [symbolset](https://symbolset.com/icons)
- [logofaves](http://logofaves.com/)
- [Logo of the day](http://logooftheday.com/)
- [LOGOMOOSE](https://www.logomoose.com/)
- [Logospire](http://logospire.com/)
- [Squid.ink](http://thesquid.ink/flat-icons/)
- [Game Icons](http://game-icons.net/)
- [SVG icons](http://svgicons.sparkk.fr/)
- [Material Design Icons](https://materialdesignicons.com/)
- [Material Design Iconic Font](http://zavoloklom.github.io/material-design-iconic-font/index.html)
- [Bytesize](http://danklammer.com/bytesize-icons/)
- [NOVA Material Design Icons](http://www.webalys.com/nova/index.html)
- [ICONSHOP](https://freeiconshop.com/)
- [SIMPLE ICONS](https://simpleicons.org/)
- [iconmonstr](https://iconmonstr.com/)
- [Octions](https://octicons.github.com/)
- [WE LOVE ICON FONTS](http://weloveiconfonts.com/)
- [IconStore](https://iconstore.co/)
- [Google Material Icons](https://design.google.com/icons/)
- [PaymentFont](https://paymentfont.com/)
- [Font Awesome](http://fontawesome.io/)
- [IconMoon](https://icomoon.io/)
- [ICONO](http://saeedalipoor.github.io/icono/)
- [svg-icon](http://leungwensen.github.io/svg-icon/) - An ultimate SVG icons collection DONE RIGHT.
- [Clarity Icons](http://icons.clarity.design/)
- [Iconfont](http://www.iconfont.cn/)

## Tool :wrench:

- [Sketch](https://www.sketchapp.com/) - Professional digital design for Mac. :computer:
  - [Developer](http://developer.sketchapp.com/)
  - [Sketch App Sources](https://www.sketchappsources.com/)
  - [Sketch Repo](https://sketchrepo.com/)
  - [Sketch Plugins](https://github.com/sketchplugins/plugin-directory)
  - [Sketchcasts](https://www.sketchcasts.net/)
  - [Sketch.im](http://sketch.im/)
- [Adobe Photoshop](http://www.adobe.com/products/photoshop.html) - Best imaging and design app is at the core of almost every creative project.
  - [PSD Repo](https://psdrepo.com/)
  - [PSDDD](https://psddd.co/)
- [Adobe Illustrator](http://www.adobe.com/products/illustrator.html) - The industry-standard vector graphics app lets you create logos, icons, sketches, typography, and complex illustrations for print, web, interactive, video, and mobile.
- [Adobe After Effects](http://www.adobe.com/products/aftereffects.html) - Bold new ways to put your ideas in motion.
- [Adobe Project Felix](http://www.adobe.com/products/project-felix.html) - A new app for working with 3D models, materials, and lights with 2D background images to create fully rendered, high-quality images with photorealistic effects.
- [Zeplin](https://zeplin.io/) - Build pixel perfect apps in peace. 
- [Panda](http://usepanda.com/) - A smart news reader built for productivity, powered by integrations. :+1:
- [INBOARD](https://inboardapp.com/) - Organize your inspiration.
- [Sip](http://sipapp.io/) - The best way to collect, organize & share your colors. :computer:
- [RightFont](https://rightfontapp.com/) - The future of font manager software for Mac OS X. 
- [Dropbox](https://www.dropbox.com/) - Get to all your files from anywhere, on any device, and share them with anyone.
- [Iconjar](https://geticonjar.com/) - Organize, search and use icons the easy way. :computer:
- [Affinity Designer](https://affinity.serif.com/en-gb/designer/) - Professional graphic design software for Mac. :+1:
- [Inkscape](https://inkscape.org/en/) - Free vector graphics tool.
- [Specctr](https://specctr.com/cloud/home/) - Instantly create design specs right in your favorite graphic design tool.
- [Figma](https://www.figma.com/) - The first interface design tool with real-time collaboration.
- [Gravit](https://www.gravit.io/) - End-to-end web-based design platform.

## Prototype :memo:

- [Marvel](https://marvelapp.com/) - Simple design, prototyping and collaboration. :+1:
- [InVision](https://www.invisionapp.com/) - The world's leading prototyping, collaboration & workflow platform. :+1:
- [Origami](http://origami.design/) - Design Prototyping. :+1::computer:
- [Framer.js](https://framer.com/) - Design tool for creating interactive designs, interfaces and animations. :+1::computer:
- [Atomic](https://www.atomic.io/) - The prototyping tool designed for teams.
- ~~[Pixate](http://www.pixate.com/) - Make your ideas a reality(@October 31, 2016)~~
- [Proto.io](https://proto.io/) - Prototypes that feel real. 
- [Justinmind](https://www.justinmind.com/) - Prototype Faster, Communicate Better.
- [Principle](http://principleformac.com/) - Animate Your Ideas, Design Better Apps. :computer:
- [Flinto](https://www.flinto.com/) - App prototyping tools for designers.
- [Axure](https://www.axure.com/) - Design the right solution and align your team. :+1:
- [Form](http://www.relativewave.com/form/) - Build and customize native prototypes directly on device. :computer:
- [Bootstrap Studio](https://bootstrapstudio.io/) - A powerful desktop app for creating responsive websites using the Bootstrap framework. 
- [Adobe Experience Design](http://www.adobe.com/products/experience-design.html) - Design, prototype and quickly share user experiences.
- [UXPin](https://www.uxpin.com/) - High fidelity animated prototypes created in minutes.
- [MockingBot](https://modao.cc/) - Mobile prototyping tool without headache. :+1:
- [POP](https://marvelapp.com/pop/?popref=1) - Transform pen and paper ideas into a real working prototype.
- [Prott](https://prottapp.com/) - Prototyping tool for Web, iOS, Android apps.

## User Testing :busts_in_silhouette:

- [Lookback.io](https://lookback.io/) - Capture exactly how users experience your product: no guesswork required.
- [UserTesting](https://www.usertesting.com/) - Get videos of real people speaking their thoughts as they use your website or mobile app. Go beyond analytics and understand why users do what they do.
- [UserBrain](https://userbrain.net/) - Keep getting videos of real people testing your website, web app or prototype and make it ridiculously easy to use.
- [Reflector](http://www.airsquirrels.com/reflector/) - Wireless mirroring and streaming receiver.
- [User Zoom](http://www.userzoom.co.uk/) - All-in-One Agile UX Research Platform.
- [Ethn.io](https://ethn.io/) - Remote user testing suite. Intercept real people for user research.
- [Usabilla](https://usabilla.com/) - Customer feedback and survey tool.
- [UserTest.io](https://usertest.io/) - Remote, easy and simple user testing.
- [Validately](https://validately.com/) - Easy way to recruit testers, launch tests, and analyze results.
- [Users Think](http://usersthink.com/) - Get user feedback from real people, on demand, when you need it.
- [CrazyEgg](https://www.crazyegg.com/) - Heatmapping software.
- [HotJar](https://www.hotjar.com/) - Includes screen recordings, heatmapping, form and funnel analysis and user feedback polls & surveys
- [Inspectlet](https://www.inspectlet.com/) - Captures user actions and browsing, generates heatmaps, records with a realtime timeline :+1:
- [Clicktale](https://www.clicktale.com) - User experience management platform.

## Mockup :hatching_chick:

- [MOCKUPWORLD](https://www.mockupworld.co/)
- [Placeit](https://placeit.net/)
- [Epicpxls](https://www.epicpxls.com/) - UI kits, icons, templates, mockups and more, free
- [360 Mockups](https://360mockups.com/)
- Facebook Mockups
  - [Devices](http://facebook.design/devices)
  - [HandsKit](http://facebook.design/handskit)
- [Scenery](https://www.getscenery.com/) :computer:
- [UINames](https://uinames.com/)
- [NinjaMock](https://ninjamock.com/)
- [Smartmockups app](https://app.smartmockups.com/)

## Style Guide/Branding :octocat:

- [Brand Style Guide Examples](https://saijogeorge.com/brand-style-guide-examples/) - Hand-picked collection of brand style guide examples.
- [Mozilla](https://www.mozilla.org/en-US/styleguide/)
- [Mailchimp](http://ux.mailchimp.com/patterns/)
- [Fontshop](https://www.fontshop.com/styleguide/globals)
- [Lonely Planet](http://rizzo.lonelyplanet.com/styleguide/design-elements/colours)
- [Starbucks](https://www.starbucks.com/static/reference/styleguide/)
- [Yelp](https://www.yelp.com/styleguide)
- [IBM](https://www.ibm.com/design/language/)
- [CodePen](https://codepen.io/guide)
- [Uber](https://www.uber.design)
- [Atlassian](https://www.atlassian.design/)
- [Dropbox](https://www.dropbox.com/branding)
- [Spotify](https://developer.spotify.com/design/)
- [Youtube](https://www.youtube.com/yt/about/brand-resources/)
- [Facebook - Brand Resource Center Book](https://en.facebookbrand.com/)
- [Vimeo](https://press.vimeo.com/brand-guidelines)
- [Ubuntu](http://design.ubuntu.com/)
- [BBC](http://www.bbc.co.uk/gel)
- [Channel4](http://styleguides.channel4.com/E4_StyleGuide.pdf)
- [Twitter](https://brand.twitter.com/)
- [Nike Pro](http://manualcreative.com/project/nike-pro-services/)
- [Medium](https://www.behance.net/gallery/7226653/Medium-Brand-Development)
- [Linkedin](https://brand.linkedin.com/)
- [Red Cross](http://www.redcross.org/images/MEDIA_CustomProductCatalog/m6440103_BrandPoster.pdf)
- [Marvel](https://marvelapp.com/styleguide/overview/introduction)
- [buffer](https://buffer.com/style-guide)
- [VSCO](http://vsco.co/id/journal/p/1)
- [Instagram](https://en.instagram-brand.com/)
- [WhatsApp](https://www.whatsappbrand.com/)
- [Snapchat](https://www.snapchat.com/brand-guidelines#general-usage-guidelines)
- [Atlassian](https://atlassian.design/)
- [Clarity](http://clarity.design)
- Apple
  - [iOS](https://developer.apple.com/ios/human-interface-guidelines/)
  - [macOS](https://developer.apple.com/library/mac/documentation/UserExperience/Conceptual/OSXHIGuidelines/)
- Google
  - [Google Trends](https://newslab.withgoogle.com/assets/docs/google-trends-guide.pdf)
  - [Google Visual Assets Guidelines](https://www.behance.net/gallery/9028077/Google-Visual-Assets-Guidelines-Part-2)
  - [Design for Glass](https://developers.google.com/glass/design/)
  - [Material design](https://material.io/guidelines/)
- Microsoft
  - [Microsoft Design](https://www.microsoft.com/en-us/design)
  - [Fluent Design System](http://fluent.microsoft.com/)
- NASA
  - [2011](https://sservi.nasa.gov/wp-content/uploads/2011/10/NASA_Style_Guide_v2.1.pdf)
  - [1976](https://www.nasa.gov/sites/default/files/atoms/files/nasa_graphics_manual_nhb_1430-2_jan_1976.pdf)

## Tutorial :school:

- [PLURALSIGHT](http://creative.pluralsight.com/11/index.php)
- [Lynda](https://www.lynda.com/)
- [CreativeLive](https://www.creativelive.com/)
- [DesignSchool](https://designschool.canva.com/)
- [Tuts+](https://tutsplus.com/)
- [Udemy](https://www.udemy.com/courses/design/)
- [AboutCG](http://www.aboutcg.com/)
- [DevDojo](https://devdojo.com/)
- [Adobe KnowHow](https://www.adobeknowhow.com/)
- [Platzi](https://courses.platzi.com)
- [greyscalegorilla](https://greyscalegorilla.com/)

## Book :books:

- [Universal Principles of Design](https://www.amazon.com/Universal-Principles-Design-Revised-Updated/dp/1592535879/ref=sr_1_2?s=books&ie=UTF8&qid=1473096298&sr=1-2&keywords=Universal+Methods+of+Design)
- [Universal Methods of Design](https://www.amazon.com/Universal-Methods-Design-Innovative-Effective/dp/1592537561/ref=pd_sim_14_3?ie=UTF8&psc=1&refRID=2NG71RWR7MKGXE1B8GZ3)
- [Don't Make Me Think](https://www.amazon.com/gp/product/0321965515/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=0321965515&linkCode=as2&tag=office03a70-20&linkId=PF4EASLP4EM62N73)
- [About Face: The Essentials of Interaction Design](https://www.amazon.com/gp/product/1118766571/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1118766571&linkCode=as2&tag=office03a70-20&linkId=I5TMKUXHZ43SHHPE)
- [How to Be a Graphic Designer without Losing Your Soul](https://www.amazon.com/Graphic-Designer-without-Losing-Expanded/dp/1568989830)
- [Simple and Usable Web, Mobile, and Interaction Design](https://www.amazon.com/gp/product/0321703545)
- [Lean UX: Applying Lean Principles to Improve User Experience](https://www.amazon.com/Lean-UX-Applying-Principles-Experience/dp/1449311652)
- [Designing Interfaces](https://www.amazon.com/Designing-Interfaces-Jenifer-Tidwell/dp/1449379702)
- [100 Things Every Designer Needs to Know About People](https://www.amazon.com/Things-Designer-People-Voices-Matter/dp/0321767535)
- [The UX Book: Process and Guidelines for Ensuring a Quality User Experience](https://www.amazon.com/UX-Book-Guidelines-Ensuring-Experience/dp/0123852412)
- [Thinking with Type](https://www.amazon.com/gp/product/1568989695/)
- [The Elements of Graphic Design](https://www.amazon.com/Elements-Graphic-Design-Second/dp/1581157622/)

## Award :trophy:

- [Good Design Award](http://www.g-mark.org/?locale=en)
- [Red Dot Award](http://en.red-dot.org/)
- [Apple Design Awards](https://developer.apple.com/design/awards/)
- [iF](http://ifworlddesignguide.com/)
- [FWA](https://thefwa.com/)
- [CSS Design Awards](http://www.cssdesignawards.com/)
- [CSS Awards](https://www.cssawards.net/)
- [Creative AD Awards](http://www.creativeadawards.com/)
- [D&AD](https://www.dandad.org/)
- [Awwwards](https://www.awwwards.com/) - Website Awards - Best Web Design Trends
- [CSS Winner](http://www.csswinner.com/)

## Conference/Festival :beers:

- [Uideo](https://uideo.net)
- [MAX](https://max.adobe.com/)
- [The AIGA Design Conference](http://designconference.aiga.org/#!/)
- [SXSW](https://www.sxsw.com/)
- [ICON9](http://www.theillustrationconference.org/)
- [Mirror](http://www.mirrorconf.com)
- [Interaction](http://interaction16.ixda.org/)
- [Offset](http://www.iloveoffset.com/)
- [99U](http://conference.99u.com/)
- [Typographics](http://typographics.com)
- [Brand New Conference](http://underconsideration.com/brandnewconference/)
- [How Design Live](http://www.howdesignlive.com/)
- [Better by Design](http://betterbydesignconference.com/)
- [What Design Can Do](http://www.whatdesigncando.com/)
- [Design and Content](https://www.designcontentconf.com/)
- [generate](https://www.generateconf.com/)
- [Typo International Design Talks](https://www.typotalks.com/)
- [DesignersFiesta](http://designersfiesta.com/)
- [F5](http://f5fest.com/)
- [Service Design Days](http://servicedesigndays.com/)
- [SemiPermanent](https://www.semipermanent.com)
- [Dribbble Meetups](https://dribbble.com/meetups)
- [CreativeMornings](https://creativemornings.com/)
- [CodePen Meetups](https://blog.codepen.io/meetups/)

## Podcast :radio:

- [99% INVISIBLE](http://99percentinvisible.org/)
- [Designer News Podcast](https://www.designernews.co/podcast/)
- [Shop Talk](http://shoptalkshow.com/)
- [workmode](http://workmode.show/)
- [UX Podcast](http://uxpodcast.com/)
- [Anyway.fm](http://anyway.fm/)
- [The Deeply Graphic Design**](http://thedeependdesign.com/graphic-design-podcast/)
- [Tentative.fm](http://tentative.fm/)
- [Pagebreak](http://www.pagebreakpodcast.com/)
- [On the Grid](http://5by5.tv/onthegrid)
- [Design Matters](http://www.debbiemillman.com/designmatters/)
- [YOUNG GUNS SHOW](http://younggunsshow.com/)
- [The Greate Discontent Podcast](https://thegreatdiscontent.com/podcast)
- [DESIGN DETAILS Podcast](https://spec.fm/podcasts/design-details)
- [Layout.fm](http://layout.fm/)
- [Type is Beautiful](https://itunes.apple.com/podcast/zi-tan-zi-chang/id1041704528)
- [boagworld](https://boagworld.com/show/)
- [Responsive Web Design](https://responsivewebdesign.com/podcast/)
- [Adventures in Design](http://www.adventuresindesignmarket.com/)
- [Let's Make Mistakes](http://www.mistakes.show/)
- [Hacking UI](http://hackingui.com/podcast/)
- [CodePen Radio](https://blog.codepen.io/radio/)

## Social Network :couple::couple:

- [**Dribbble**](https://dribbble.com/) - Show and tell for designers
- [**Behance**](https://www.behance.net/) - Showcase and discover the latest work from top online portfolios by creative professionals across industries.
- [**Medium**](https://medium.com/) - A place to read, write, and interact with the stories that matter most to you.
- [**Fribbble**](http://www.fribbble.com/) - Free PSD files and other free design resources by Dribbblers.
- [**DeviantArt**](http://www.deviantart.com/) - The largest online art gallery and community.
- [**CARGO**](https://2.cargocollective.com)
- [**tumblr**](https://www.tumblr.com/)
- [**/r/web_design**](https://www.reddit.com/r/web_design/) - Subreddit for all things web design.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Tony Chan](https://github.com/gztchan) has waived all copyright and related or neighboring rights to this work.
