![header](https://github.com/loverajoel/jstips/blob/gh-pages/assets/images/jstips-animation.gif)

# JS Tips [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
> Useful JavaScript tips

This is an awesome project about short and useful JavaScript tips that will allow you to improve your code writing. With less than 2 minutes, you will be able to read about performance, conventions, hacks, interview questions and all the items that the future of this awesome language holds for us.

Tips are added frequently (read further if you want to stay in touch).

## Support the community
If you found a JS Tip useful or you like a writer of the community now you are able to show some respect and support with a tip!

### Can you help us enrich it?
Sure, you can help the project in two ways, sending your tip or reviewing future tips.
Any improvements or suggestions are more than welcome!
[Instructions are here](https://github.com/loverajoel/jstips/blob/master/CONTRIBUTING.md).

### Let’s keep in touch

There are a lot of ways to get updates, choose your own

- [Official Blog](http://www.jstips.co)
- [Official Twitter Account](https://twitter.com/tips_js)
- [Hubot](https://github.com/dggriffin/hubot-jstips)
- [Slackbot](https://github.com/radibit/js-tips-slack-bot)
- [js2016.tips](http://js2016.tips/)
- [Hingsir](http://hingsir.com/jstips-site/dist/tips/)
- [Awesomelists](https://awesomelists.top/#/repos/loverajoel/jstips)
- [iOS App](https://goo.gl/Y9WiBc)
- [Android App](https://goo.gl/lYorrU)

> Don't forget to Star★ the repo, as this helps promoting the project!

# Tips list

- 73 - [Hash maps without side effects](http://www.jstips.co/en/javascript/hash-maps-without-side-effects/)
- 72 - [Adventurers Guide to React (Part I)](http://www.jstips.co/en/react/adventurers-guide-to-react/)
- 71 - [VueJS, How VueJS makes a copy-update-replace inside the data binding](http://www.jstips.co/en/more/vuejs-how-vuejs-makes-a-copy-update-replace-inside-the-data-binding/)
- 70 - [Picking and rejecting object properties](http://www.jstips.co/en/javascript/picking-and-rejecting-object-properties/)
- 69 - [Enhancing React components, Composition](http://www.jstips.co/en/react/enhancing-react-components-composition/)
- 68 - [Why you should use Object.is() in equality comparison](http://www.jstips.co/en/javascript/why-you-should-use-Object.is()-in-equality-comparison/)
- 67 - [Recursion, iteration and tail calls in JS](http://www.jstips.co/en/javascript/recursion-iteration-and-tail-calls-in-js/)
- 66 - [State to Props maps with memory](http://www.jstips.co/en/react/state-to-props-maps-with-memory/)
- 65 - [Tapping for quick debugging](http://www.jstips.co/en/javascript/tapping-for-quick-debugging/)
- 64 - [3 Array Hacks](http://www.jstips.co/en/javascript/3-array-hacks/)
- 63 - [Working With Websocket Timeout](http://www.jstips.co/en/javascript/working-with-websocket-timeout/)
- 62 - [Preventing Unwanted Scopes Creation in AngularJs](http://www.jstips.co/en/angular/preventing-unwanted-scopes-creation-in-angularjs/)
- 61 - [Binding objects to functions](http://www.jstips.co/en/javascript/binding-objects-to-functions/)
- 60 - [Three useful hacks](http://www.jstips.co/en/javascript/three-useful-hacks/)
- 59 - [ES6, var vs let](http://www.jstips.co/en/javascript/keyword-var-vs-let/)
- 58 - [Breaking or continuing loop in functional programming](http://www.jstips.co/en/javascript/break-continue-loop-functional/)
- 57 - [Comma operator in JS](http://www.jstips.co/en/javascript/comma-operaton-in-js/)
- 56 - [Copy to Clipboard](http://www.jstips.co/en/javascript/copy-to-clipboard/)
- 55 - [Create an easy loop using an array](http://www.jstips.co/en/javascript/make-easy-loop-on-array/)
- 54 - [How to use optional arguments in functions (with optional callback)](http://www.jstips.co/en/javascript/use-optional-arguments/)
- 53 - [Get File Extension](http://www.jstips.co/en/javascript/get-file-extension/)
- 52 - [Return Values with the 'new' Operator](http://www.jstips.co/en/javascript/return-values-with-the-new-operator/)
- 51 - [DOM event listening made easy](http://www.jstips.co/en/javascript/DOM-event-listening-made-easy/)
- 50 - [Helpful Console Logging Tricks](http://www.jstips.co/en/javascript/helpful-console-log-hacks/)

- 49 - [Easiest way to extract Unix timestamps](http://www.jstips.co/en/javascript/extract-unix-timestamp-easily/)
- 48 - [Reduce builtin function usage](http://www.jstips.co/en/javascript/reminders-about-reduce-function-usage/)
- 47 - [Basics: Declarations](http://www.jstips.co/en/javascript/basics-declarations/)
- 46 - [Detect document ready in pure JS](http://www.jstips.co/en/javascript/detect-document-ready-in-pure-js/)
- 45 - [Calculate the Max/Min value from an array](http://www.jstips.co/en/javascript/calculate-the-max-min-value-from-an-array/)
- 44 - [Know the passing mechanism](http://www.jstips.co/en/javascript/know-the-passing-mechanism/)

- 43 - [Use destructuring in function parameters](http://www.jstips.co/en/javascript/use-destructuring-in-function-parameters/)
- 42 - [Preventing Unapply Attacks](http://www.jstips.co/en/javascript/preventing-unapply-attacks/)
- 41 - [Array average and median](http://www.jstips.co/en/javascript/array-average-and-median/)
- 40 - [Using JSON.stringify](http://www.jstips.co/en/javascript/using-json-stringify/)
- 39 - [Advanced Properties](http://www.jstips.co/en/javascript/advanced-properties/)
- 38 - [Flattening multidimensional Arrays](http://www.jstips.co/en/javascript/flattening-multidimensional-arrays-in-javascript/)

- 37 - [Deduplicate an Array](http://www.jstips.co/en/javascript/deduplicate-an-array/)
- 36 - [Observe DOM changes in extensions](http://www.jstips.co/en/javascript/observe-dom-changes/)
- 35 - [Assignment Operators](http://www.jstips.co/en/javascript/assignment-shorthands/)
- 34 - [Implementing asynchronous loop](http://www.jstips.co/en/javascript/implementing-asynchronous-loops/)
- 33 - [Create Range 0...N easily using one line](http://www.jstips.co/en/javascript/create-range-0...n-easily-using-one-line/)
- 32 - [`Map()` to the rescue: adding order to Object properties](http://www.jstips.co/en/javascript/map-to-the-rescue-adding-order-to-object-properties/)

- 31 - [Avoid modifying or passing `arguments` into other functions — it kills optimization](http://www.jstips.co/en/javascript/avoid-modifying-or-passing-arguments-into-other-functions-it-kills-optimization/)
- 30 - [Converting truthy/falsy values to boolean](http://www.jstips.co/en/javascript/converting-truthy-falsy-values-to-boolean/)
- 29 - [Speed up recursive functions with memoization](http://www.jstips.co/en/javascript/speed-up-recursive-functions-with-memoization/)
- 28 - [Currying vs partial application](http://www.jstips.co/en/javascript/curry-vs-partial-application/)
- 27 - [Short circuit evaluation](http://www.jstips.co/en/javascript/short-circuit-evaluation-in-js/)
- 26 - [Filtering and sorting a list of Strings](http://www.jstips.co/en/javascript/filtering-and-sorting-a-list-of-strings/)
- 25 - [Using immediately invoked function expression](http://www.jstips.co/en/javascript/Using-immediately-invoked-function-expression/)
- 24 - [Use `===` instead of `==`](http://www.jstips.co/en/javascript/use_===_instead_of_==/)
- 23 - [Converting to number fast way](http://www.jstips.co/en/javascript/converting-to-number-fast-way/)
- 22 - [Empty an Array](http://www.jstips.co/en/javascript/two-ways-to-empty-an-array/)
- 21 - [Shuffle an Array](http://www.jstips.co/en/javascript/shuffle-an-array/)
- 20 - [Return objects to enable chaining of functions](http://www.jstips.co/en/javascript/return-objects-to-enable-chaining-of-functions/)
- 19 - [Safe String concatenation](http://www.jstips.co/en/javascript/safe-string-concatenation/)
- 18 - [Truncating the fast (but risky) way](http://www.jstips.co/en/javascript/rounding-the-fast-way/)
- 17 - [Node.js: Run a module if it is not "required"](http://www.jstips.co/en/javascript/nodejs-run-a-module-if-it-is-not-required/)
- 16 - [Passing arguments to callback functions](http://www.jstips.co/en/javascript/passing-arguments-to-callback-functions/)
- 15 - [Even simpler way of using `indexOf` as a contains clause](http://www.jstips.co/en/javascript/even-simpler-way-of-using-indexof-as-a-contains-clause/)
- 14 - [Fat Arrow Functions #ES6](http://www.jstips.co/en/javascript/fat-arrow-functions/)
- 13 - [Measure performance of a code block](http://www.jstips.co/en/javascript/tip-to-measure-performance-of-a-javascript-block/)
- 12 - [Pseudomandatory parameters in ES6 functions #ES6](http://www.jstips.co/en/javascript/pseudomandatory-parameters-in-es6-functions/)
- 11 - [Hoisting](http://www.jstips.co/en/javascript/hoisting/)
- 10 - [Check if a property is in an Object](http://www.jstips.co/en/javascript/check-if-a-property-is-in-a-object/)
- 09 - [Template Strings](http://www.jstips.co/en/javascript/template-strings/)
- 08 - [Converting a Node List to an Array](http://www.jstips.co/en/javascript/converting-a-node-list-to-an-array/)
- 07 - ["use strict" and get lazy](http://www.jstips.co/en/javascript/use-strict-and-get-lazy/)
- 06 - [Writing a single method for arrays and a single element](http://www.jstips.co/en/javascript/writing-a-single-method-for-arrays-and-a-single-element/)
- 05 - [Differences between `undefined` and `null`](http://www.jstips.co/en/javascript/differences-between-undefined-and-null/)
- 04 - [Sorting Strings with accented characters](http://www.jstips.co/en/javascript/sorting-strings-with-accented-characters/)
- 03 - [Improve Nested Conditionals](http://www.jstips.co/en/javascript/improve-nested-conditionals/)
- 02 - [ReactJS - Keys in children components are important](http://www.jstips.co/en/react/keys-in-children-components-are-important/)
- 01 - [AngularJS: `$digest` vs `$apply`](http://www.jstips.co/en/angular/angularjs-digest-vs-apply/)
- 00 - [Insert item inside an Array](http://www.jstips.co/en/javascript/insert-item-inside-an-array/)

### License
[GNU GENERAL PUBLIC LICENSE](https://github.com/loverajoel/jstips/blob/master/LICENSE.md)
