package Rsa

import (
	"io/ioutil"
	"math/big"
	"testing"
	. "gopkg.in/check.v1"
)

func Test(t *testing.T) { TestingT(t) }
type TestSuite struct{}
var _ = Suite(&TestSuite{})


func (s *TestSuite) TestNewPrivateRsaKeyPKCS1(c *C) {
	
	//given
	keyBytes, _ := ioutil.ReadFile("priv.pem")
	
	//when	
	test,e := ReadPrivate(keyBytes)
	
	//then
	c.Assert(e, IsNil)
	c.Assert(test.D, DeepEquals, bigInt("124664500442337916425629948081980373708538939606058968438393904444884872144817323585651521088406960965803456218656807473171367526874204593887158860695954252405916280866383288176587587469870736553178754458686625418367566925639753001190058223163696966510495553421774149906056482201169970508069587759758018186673"))	
	c.Assert(test.Primes, HasLen, 2)
	c.Assert(test.Primes[0], DeepEquals, bigInt("12153319500662601635346432957857245055929638609873673015885135318360261418965835817520733410832489021447922460160007366037402643276624674886502627435389593"))
	c.Assert(test.Primes[1], DeepEquals, bigInt("10891140096045830766355607974974880425030121636560867106153739255802668290122259699296919947637286459736524694263050343032461619592457541146877906031793883"))
	c.Assert(test.E, Equals, 65537)
	c.Assert(test.N, DeepEquals, bigInt("132363505313722155184876628715249052276006747427497555521215412160460427148722445294983292629743653314149228192824806664548107146354876411009845771623017501212568714555984634301944063168503260813720165931647377932654326833738173931173570212088015547040743996672392373035728084429156775233489529905624779259619"))
}

func (s *TestSuite) TestNewPrivateRsaKeyPKCS8(c *C) {
	
	//given
	keyBytes, _ := ioutil.ReadFile("priv.pem")
	
	//when	
	test,e := ReadPrivate(keyBytes)
		
	//then
	c.Assert(e, IsNil)
	c.Assert(test.D, DeepEquals, bigInt("124664500442337916425629948081980373708538939606058968438393904444884872144817323585651521088406960965803456218656807473171367526874204593887158860695954252405916280866383288176587587469870736553178754458686625418367566925639753001190058223163696966510495553421774149906056482201169970508069587759758018186673"))	
	c.Assert(test.Primes, HasLen, 2)
	c.Assert(test.Primes[0], DeepEquals, bigInt("12153319500662601635346432957857245055929638609873673015885135318360261418965835817520733410832489021447922460160007366037402643276624674886502627435389593"))
	c.Assert(test.Primes[1], DeepEquals, bigInt("10891140096045830766355607974974880425030121636560867106153739255802668290122259699296919947637286459736524694263050343032461619592457541146877906031793883"))
	c.Assert(test.E, Equals, 65537)
	c.Assert(test.N, DeepEquals, bigInt("132363505313722155184876628715249052276006747427497555521215412160460427148722445294983292629743653314149228192824806664548107146354876411009845771623017501212568714555984634301944063168503260813720165931647377932654326833738173931173570212088015547040743996672392373035728084429156775233489529905624779259619"))
}

func (s *TestSuite) TestNewPublicRsaKeyPKCS1(c *C) {
	
	//given
	keyBytes, _ := ioutil.ReadFile("pub.pem")
	
	//when	
	test,e := ReadPublic(keyBytes)
		
	//then
	c.Assert(e, IsNil)	
	c.Assert(test.E, Equals, 65537)
	c.Assert(test.N, DeepEquals, bigInt("132363505313722155184876628715249052276006747427497555521215412160460427148722445294983292629743653314149228192824806664548107146354876411009845771623017501212568714555984634301944063168503260813720165931647377932654326833738173931173570212088015547040743996672392373035728084429156775233489529905624779259619"))
}

func (s *TestSuite) TestNewPublicRsaKeyPKIX(c *C) {
	
	//given
	keyBytes, _ := ioutil.ReadFile("pub.key")
	
	//when	
	test,e := ReadPublic(keyBytes)
		
	//then
	c.Assert(e, IsNil)	
	c.Assert(test.E, Equals, 65537)
	c.Assert(test.N, DeepEquals, bigInt("132363505313722155184876628715249052276006747427497555521215412160460427148722445294983292629743653314149228192824806664548107146354876411009845771623017501212568714555984634301944063168503260813720165931647377932654326833738173931173570212088015547040743996672392373035728084429156775233489529905624779259619"))
}

//utils
func bigInt(value string) *big.Int {
	i:=new (big.Int)
	i.SetString(value,10)
	
	return i	
}