package storagepool

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/storagepool/mgmt/2021-08-01/storagepool"

// ACL access Control List (ACL) for an iSCSI Target; defines LUN masking policy
type ACL struct {
	// InitiatorIqn - iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
	InitiatorIqn *string `json:"initiatorIqn,omitempty"`
	// MappedLuns - List of LUN names mapped to the ACL.
	MappedLuns *[]string `json:"mappedLuns,omitempty"`
}

// Disk azure Managed Disk to attach to the Disk Pool.
type Disk struct {
	// ID - Unique Azure Resource ID of the Managed Disk.
	ID *string `json:"id,omitempty"`
}

// DiskPool response for Disk Pool request.
type DiskPool struct {
	autorest.Response `json:"-"`
	// Sku - Determines the SKU of the Disk pool
	*Sku `json:"sku,omitempty"`
	// DiskPoolProperties - Properties of Disk Pool.
	*DiskPoolProperties `json:"properties,omitempty"`
	// ManagedBy - READ-ONLY; Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - READ-ONLY; List of Azure resource ids that manage this resource.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
	// SystemData - READ-ONLY; Resource metadata required by ARM RPC
	SystemData *SystemMetadata `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPool.
func (dp DiskPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Sku != nil {
		objectMap["sku"] = dp.Sku
	}
	if dp.DiskPoolProperties != nil {
		objectMap["properties"] = dp.DiskPoolProperties
	}
	if dp.Tags != nil {
		objectMap["tags"] = dp.Tags
	}
	if dp.Location != nil {
		objectMap["location"] = dp.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskPool struct.
func (dp *DiskPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dp.Sku = &sku
			}
		case "properties":
			if v != nil {
				var diskPoolProperties DiskPoolProperties
				err = json.Unmarshal(*v, &diskPoolProperties)
				if err != nil {
					return err
				}
				dp.DiskPoolProperties = &diskPoolProperties
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				dp.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				dp.ManagedByExtended = &managedByExtended
			}
		case "systemData":
			if v != nil {
				var systemData SystemMetadata
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dp.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dp.Type = &typeVar
			}
		}
	}

	return nil
}

// DiskPoolCreate request payload for create or update Disk Pool request.
type DiskPoolCreate struct {
	// Sku - Determines the SKU of the Disk Pool
	Sku *Sku `json:"sku,omitempty"`
	// DiskPoolCreateProperties - Properties for Disk Pool create request.
	*DiskPoolCreateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
	// ManagedBy - Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - List of Azure resource ids that manage this resource.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolCreate.
func (dpc DiskPoolCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpc.Sku != nil {
		objectMap["sku"] = dpc.Sku
	}
	if dpc.DiskPoolCreateProperties != nil {
		objectMap["properties"] = dpc.DiskPoolCreateProperties
	}
	if dpc.Tags != nil {
		objectMap["tags"] = dpc.Tags
	}
	if dpc.Location != nil {
		objectMap["location"] = dpc.Location
	}
	if dpc.ManagedBy != nil {
		objectMap["managedBy"] = dpc.ManagedBy
	}
	if dpc.ManagedByExtended != nil {
		objectMap["managedByExtended"] = dpc.ManagedByExtended
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskPoolCreate struct.
func (dpc *DiskPoolCreate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dpc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var diskPoolCreateProperties DiskPoolCreateProperties
				err = json.Unmarshal(*v, &diskPoolCreateProperties)
				if err != nil {
					return err
				}
				dpc.DiskPoolCreateProperties = &diskPoolCreateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dpc.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dpc.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dpc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dpc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dpc.Type = &typeVar
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				dpc.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				dpc.ManagedByExtended = &managedByExtended
			}
		}
	}

	return nil
}

// DiskPoolCreateProperties properties for Disk Pool create or update request.
type DiskPoolCreateProperties struct {
	// AvailabilityZones - Logical zone for Disk Pool resource; example: ["1"].
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// Disks - List of Azure Managed Disks to attach to a Disk Pool.
	Disks *[]Disk `json:"disks,omitempty"`
	// SubnetID - Azure Resource ID of a Subnet for the Disk Pool.
	SubnetID *string `json:"subnetId,omitempty"`
	// AdditionalCapabilities - List of additional capabilities for a Disk Pool.
	AdditionalCapabilities *[]string `json:"additionalCapabilities,omitempty"`
}

// DiskPoolListResult list of Disk Pools
type DiskPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of Disk pool objects.
	Value *[]DiskPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolListResult.
func (dplr DiskPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dplr.Value != nil {
		objectMap["value"] = dplr.Value
	}
	return json.Marshal(objectMap)
}

// DiskPoolListResultIterator provides access to a complete listing of DiskPool values.
type DiskPoolListResultIterator struct {
	i    int
	page DiskPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskPoolListResultIterator) Response() DiskPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskPoolListResultIterator) Value() DiskPool {
	if !iter.page.NotDone() {
		return DiskPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskPoolListResultIterator type.
func NewDiskPoolListResultIterator(page DiskPoolListResultPage) DiskPoolListResultIterator {
	return DiskPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dplr DiskPoolListResult) IsEmpty() bool {
	return dplr.Value == nil || len(*dplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dplr DiskPoolListResult) hasNextLink() bool {
	return dplr.NextLink != nil && len(*dplr.NextLink) != 0
}

// diskPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dplr DiskPoolListResult) diskPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dplr.NextLink)))
}

// DiskPoolListResultPage contains a page of DiskPool values.
type DiskPoolListResultPage struct {
	fn   func(context.Context, DiskPoolListResult) (DiskPoolListResult, error)
	dplr DiskPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dplr)
		if err != nil {
			return err
		}
		page.dplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskPoolListResultPage) NotDone() bool {
	return !page.dplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskPoolListResultPage) Response() DiskPoolListResult {
	return page.dplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskPoolListResultPage) Values() []DiskPool {
	if page.dplr.IsEmpty() {
		return nil
	}
	return *page.dplr.Value
}

// Creates a new instance of the DiskPoolListResultPage type.
func NewDiskPoolListResultPage(cur DiskPoolListResult, getNextPage func(context.Context, DiskPoolListResult) (DiskPoolListResult, error)) DiskPoolListResultPage {
	return DiskPoolListResultPage{
		fn:   getNextPage,
		dplr: cur,
	}
}

// DiskPoolProperties disk Pool response properties.
type DiskPoolProperties struct {
	// ProvisioningState - State of the operation on the resource. Possible values include: 'ProvisioningStatesInvalid', 'ProvisioningStatesSucceeded', 'ProvisioningStatesFailed', 'ProvisioningStatesCanceled', 'ProvisioningStatesPending', 'ProvisioningStatesCreating', 'ProvisioningStatesUpdating', 'ProvisioningStatesDeleting'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// AvailabilityZones - Logical zone for Disk Pool resource; example: ["1"].
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// Status - Operational status of the Disk Pool. Possible values include: 'OperationalStatusInvalid', 'OperationalStatusUnknown', 'OperationalStatusHealthy', 'OperationalStatusUnhealthy', 'OperationalStatusUpdating', 'OperationalStatusRunning', 'OperationalStatusStopped', 'OperationalStatusStoppeddeallocated'
	Status OperationalStatus `json:"status,omitempty"`
	// Disks - List of Azure Managed Disks to attach to a Disk Pool.
	Disks *[]Disk `json:"disks,omitempty"`
	// SubnetID - Azure Resource ID of a Subnet for the Disk Pool.
	SubnetID *string `json:"subnetId,omitempty"`
	// AdditionalCapabilities - List of additional capabilities for Disk Pool.
	AdditionalCapabilities *[]string `json:"additionalCapabilities,omitempty"`
}

// DiskPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (DiskPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsCreateOrUpdateFuture.Result.
func (future *DiskPoolsCreateOrUpdateFuture) result(client DiskPoolsClient) (dp DiskPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dp.Response.Response, err = future.GetResult(sender); err == nil && dp.Response.Response.StatusCode != http.StatusNoContent {
		dp, err = client.CreateOrUpdateResponder(dp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsCreateOrUpdateFuture", "Result", dp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskPoolsDeallocateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsDeallocateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsDeallocateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsDeallocateFuture.Result.
func (future *DiskPoolsDeallocateFuture) result(client DiskPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsDeallocateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsDeallocateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsDeleteFuture.Result.
func (future *DiskPoolsDeleteFuture) result(client DiskPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskPoolsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsStartFuture.Result.
func (future *DiskPoolsStartFuture) result(client DiskPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (DiskPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsUpdateFuture.Result.
func (future *DiskPoolsUpdateFuture) result(client DiskPoolsClient) (dp DiskPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dp.Response.Response, err = future.GetResult(sender); err == nil && dp.Response.Response.StatusCode != http.StatusNoContent {
		dp, err = client.UpdateResponder(dp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsUpdateFuture", "Result", dp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiskPoolsUpgradeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DiskPoolsUpgradeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DiskPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DiskPoolsUpgradeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DiskPoolsUpgradeFuture.Result.
func (future *DiskPoolsUpgradeFuture) result(client DiskPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolsUpgradeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.DiskPoolsUpgradeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DiskPoolUpdate request payload for Update Disk Pool request.
type DiskPoolUpdate struct {
	// ManagedBy - Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - List of Azure resource ids that manage this resource.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
	// DiskPoolUpdateProperties - Properties for Disk Pool update request.
	*DiskPoolUpdateProperties `json:"properties,omitempty"`
	// Sku - Determines the SKU of the Disk Pool
	Sku *Sku `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DiskPoolUpdate.
func (dpu DiskPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpu.ManagedBy != nil {
		objectMap["managedBy"] = dpu.ManagedBy
	}
	if dpu.ManagedByExtended != nil {
		objectMap["managedByExtended"] = dpu.ManagedByExtended
	}
	if dpu.DiskPoolUpdateProperties != nil {
		objectMap["properties"] = dpu.DiskPoolUpdateProperties
	}
	if dpu.Sku != nil {
		objectMap["sku"] = dpu.Sku
	}
	if dpu.Tags != nil {
		objectMap["tags"] = dpu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiskPoolUpdate struct.
func (dpu *DiskPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				dpu.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				dpu.ManagedByExtended = &managedByExtended
			}
		case "properties":
			if v != nil {
				var diskPoolUpdateProperties DiskPoolUpdateProperties
				err = json.Unmarshal(*v, &diskPoolUpdateProperties)
				if err != nil {
					return err
				}
				dpu.DiskPoolUpdateProperties = &diskPoolUpdateProperties
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dpu.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dpu.Tags = tags
			}
		}
	}

	return nil
}

// DiskPoolUpdateProperties properties for Disk Pool update request.
type DiskPoolUpdateProperties struct {
	// Disks - List of Azure Managed Disks to attach to a Disk Pool.
	Disks *[]Disk `json:"disks,omitempty"`
}

// DiskPoolZoneInfo disk Pool SKU Details
type DiskPoolZoneInfo struct {
	// AvailabilityZones - READ-ONLY; Logical zone for Disk Pool resource; example: ["1"].
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// AdditionalCapabilities - READ-ONLY; List of additional capabilities for Disk Pool.
	AdditionalCapabilities *[]string `json:"additionalCapabilities,omitempty"`
	// Sku - READ-ONLY; Determines the SKU of VM deployed for Disk Pool
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolZoneInfo.
func (dpzi DiskPoolZoneInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DiskPoolZoneListResult list Disk Pool skus operation response.
type DiskPoolZoneListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of Disk Pool Skus.
	Value *[]DiskPoolZoneInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskPoolZoneListResult.
func (dpzlr DiskPoolZoneListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DiskPoolZoneListResultIterator provides access to a complete listing of DiskPoolZoneInfo values.
type DiskPoolZoneListResultIterator struct {
	i    int
	page DiskPoolZoneListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiskPoolZoneListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolZoneListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiskPoolZoneListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiskPoolZoneListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiskPoolZoneListResultIterator) Response() DiskPoolZoneListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiskPoolZoneListResultIterator) Value() DiskPoolZoneInfo {
	if !iter.page.NotDone() {
		return DiskPoolZoneInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiskPoolZoneListResultIterator type.
func NewDiskPoolZoneListResultIterator(page DiskPoolZoneListResultPage) DiskPoolZoneListResultIterator {
	return DiskPoolZoneListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dpzlr DiskPoolZoneListResult) IsEmpty() bool {
	return dpzlr.Value == nil || len(*dpzlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dpzlr DiskPoolZoneListResult) hasNextLink() bool {
	return dpzlr.NextLink != nil && len(*dpzlr.NextLink) != 0
}

// diskPoolZoneListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dpzlr DiskPoolZoneListResult) diskPoolZoneListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dpzlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dpzlr.NextLink)))
}

// DiskPoolZoneListResultPage contains a page of DiskPoolZoneInfo values.
type DiskPoolZoneListResultPage struct {
	fn    func(context.Context, DiskPoolZoneListResult) (DiskPoolZoneListResult, error)
	dpzlr DiskPoolZoneListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiskPoolZoneListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolZoneListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dpzlr)
		if err != nil {
			return err
		}
		page.dpzlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiskPoolZoneListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiskPoolZoneListResultPage) NotDone() bool {
	return !page.dpzlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiskPoolZoneListResultPage) Response() DiskPoolZoneListResult {
	return page.dpzlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiskPoolZoneListResultPage) Values() []DiskPoolZoneInfo {
	if page.dpzlr.IsEmpty() {
		return nil
	}
	return *page.dpzlr.Value
}

// Creates a new instance of the DiskPoolZoneListResultPage type.
func NewDiskPoolZoneListResultPage(cur DiskPoolZoneListResult, getNextPage func(context.Context, DiskPoolZoneListResult) (DiskPoolZoneListResult, error)) DiskPoolZoneListResultPage {
	return DiskPoolZoneListResultPage{
		fn:    getNextPage,
		dpzlr: cur,
	}
}

// EndpointDependency a domain name that a service is reached at, including details of the current
// connection status.
type EndpointDependency struct {
	// DomainName - The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`
	// EndpointDetails - The IP Addresses and Ports used when connecting to DomainName.
	EndpointDetails *[]EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail current TCP connectivity information from the App Service Environment to a single
// endpoint.
type EndpointDetail struct {
	// IPAddress - An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
	// Latency - The time in milliseconds it takes for a TCP connection to be created from the App Service Environment to this IpAddress at this Port.
	Latency *float64 `json:"latency,omitempty"`
	// IsAccessible - Whether it is possible to create a TCP connection from the App Service Environment to this IpAddress at this Port.
	IsAccessible *bool `json:"isAccessible,omitempty"`
}

// Error the resource management error response.
type Error struct {
	// Error - RP error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse the resource management error response.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IscsiLun LUN to expose the Azure Managed Disk.
type IscsiLun struct {
	// Name - User defined name for iSCSI LUN; example: "lun0"
	Name *string `json:"name,omitempty"`
	// ManagedDiskAzureResourceID - Azure Resource ID of the Managed Disk.
	ManagedDiskAzureResourceID *string `json:"managedDiskAzureResourceId,omitempty"`
	// Lun - READ-ONLY; Specifies the Logical Unit Number of the iSCSI LUN.
	Lun *int32 `json:"lun,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiLun.
func (il IscsiLun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if il.Name != nil {
		objectMap["name"] = il.Name
	}
	if il.ManagedDiskAzureResourceID != nil {
		objectMap["managedDiskAzureResourceId"] = il.ManagedDiskAzureResourceID
	}
	return json.Marshal(objectMap)
}

// IscsiTarget response for iSCSI Target requests.
type IscsiTarget struct {
	autorest.Response `json:"-"`
	// IscsiTargetProperties - Properties for iSCSI Target operations.
	*IscsiTargetProperties `json:"properties,omitempty"`
	// SystemData - Resource metadata required by ARM RPC
	SystemData *SystemMetadata `json:"systemData,omitempty"`
	// ManagedBy - READ-ONLY; Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - READ-ONLY; List of Azure resource ids that manage this resource.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTarget.
func (it IscsiTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if it.IscsiTargetProperties != nil {
		objectMap["properties"] = it.IscsiTargetProperties
	}
	if it.SystemData != nil {
		objectMap["systemData"] = it.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IscsiTarget struct.
func (it *IscsiTarget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iscsiTargetProperties IscsiTargetProperties
				err = json.Unmarshal(*v, &iscsiTargetProperties)
				if err != nil {
					return err
				}
				it.IscsiTargetProperties = &iscsiTargetProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemMetadata
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				it.SystemData = &systemData
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				it.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				it.ManagedByExtended = &managedByExtended
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				it.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				it.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				it.Type = &typeVar
			}
		}
	}

	return nil
}

// IscsiTargetCreate payload for iSCSI Target create or update requests.
type IscsiTargetCreate struct {
	// IscsiTargetCreateProperties - Properties for iSCSI Target create request.
	*IscsiTargetCreateProperties `json:"properties,omitempty"`
	// ManagedBy - Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - List of Azure resource ids that manage this resource.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTargetCreate.
func (itc IscsiTargetCreate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itc.IscsiTargetCreateProperties != nil {
		objectMap["properties"] = itc.IscsiTargetCreateProperties
	}
	if itc.ManagedBy != nil {
		objectMap["managedBy"] = itc.ManagedBy
	}
	if itc.ManagedByExtended != nil {
		objectMap["managedByExtended"] = itc.ManagedByExtended
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IscsiTargetCreate struct.
func (itc *IscsiTargetCreate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iscsiTargetCreateProperties IscsiTargetCreateProperties
				err = json.Unmarshal(*v, &iscsiTargetCreateProperties)
				if err != nil {
					return err
				}
				itc.IscsiTargetCreateProperties = &iscsiTargetCreateProperties
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				itc.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				itc.ManagedByExtended = &managedByExtended
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itc.Type = &typeVar
			}
		}
	}

	return nil
}

// IscsiTargetCreateProperties properties for iSCSI Target create or update request.
type IscsiTargetCreateProperties struct {
	// ACLMode - Mode for Target connectivity. Possible values include: 'IscsiTargetACLModeDynamic', 'IscsiTargetACLModeStatic'
	ACLMode IscsiTargetACLMode `json:"aclMode,omitempty"`
	// TargetIqn - iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
	TargetIqn *string `json:"targetIqn,omitempty"`
	// StaticAcls - Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
	StaticAcls *[]ACL `json:"staticAcls,omitempty"`
	// Luns - List of LUNs to be exposed through iSCSI Target.
	Luns *[]IscsiLun `json:"luns,omitempty"`
}

// IscsiTargetList list of iSCSI Targets.
type IscsiTargetList struct {
	autorest.Response `json:"-"`
	// Value - An array of iSCSI Targets in a Disk Pool.
	Value *[]IscsiTarget `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTargetList.
func (itl IscsiTargetList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itl.Value != nil {
		objectMap["value"] = itl.Value
	}
	return json.Marshal(objectMap)
}

// IscsiTargetListIterator provides access to a complete listing of IscsiTarget values.
type IscsiTargetListIterator struct {
	i    int
	page IscsiTargetListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IscsiTargetListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IscsiTargetListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IscsiTargetListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IscsiTargetListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IscsiTargetListIterator) Response() IscsiTargetList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IscsiTargetListIterator) Value() IscsiTarget {
	if !iter.page.NotDone() {
		return IscsiTarget{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IscsiTargetListIterator type.
func NewIscsiTargetListIterator(page IscsiTargetListPage) IscsiTargetListIterator {
	return IscsiTargetListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itl IscsiTargetList) IsEmpty() bool {
	return itl.Value == nil || len(*itl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itl IscsiTargetList) hasNextLink() bool {
	return itl.NextLink != nil && len(*itl.NextLink) != 0
}

// iscsiTargetListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itl IscsiTargetList) iscsiTargetListPreparer(ctx context.Context) (*http.Request, error) {
	if !itl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itl.NextLink)))
}

// IscsiTargetListPage contains a page of IscsiTarget values.
type IscsiTargetListPage struct {
	fn  func(context.Context, IscsiTargetList) (IscsiTargetList, error)
	itl IscsiTargetList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IscsiTargetListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IscsiTargetListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itl)
		if err != nil {
			return err
		}
		page.itl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IscsiTargetListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IscsiTargetListPage) NotDone() bool {
	return !page.itl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IscsiTargetListPage) Response() IscsiTargetList {
	return page.itl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IscsiTargetListPage) Values() []IscsiTarget {
	if page.itl.IsEmpty() {
		return nil
	}
	return *page.itl.Value
}

// Creates a new instance of the IscsiTargetListPage type.
func NewIscsiTargetListPage(cur IscsiTargetList, getNextPage func(context.Context, IscsiTargetList) (IscsiTargetList, error)) IscsiTargetListPage {
	return IscsiTargetListPage{
		fn:  getNextPage,
		itl: cur,
	}
}

// IscsiTargetProperties response properties for iSCSI Target operations.
type IscsiTargetProperties struct {
	// ACLMode - Mode for Target connectivity. Possible values include: 'IscsiTargetACLModeDynamic', 'IscsiTargetACLModeStatic'
	ACLMode IscsiTargetACLMode `json:"aclMode,omitempty"`
	// StaticAcls - Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
	StaticAcls *[]ACL `json:"staticAcls,omitempty"`
	// Luns - List of LUNs to be exposed through iSCSI Target.
	Luns *[]IscsiLun `json:"luns,omitempty"`
	// TargetIqn - iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
	TargetIqn *string `json:"targetIqn,omitempty"`
	// ProvisioningState - State of the operation on the resource. Possible values include: 'ProvisioningStatesInvalid', 'ProvisioningStatesSucceeded', 'ProvisioningStatesFailed', 'ProvisioningStatesCanceled', 'ProvisioningStatesPending', 'ProvisioningStatesCreating', 'ProvisioningStatesUpdating', 'ProvisioningStatesDeleting'
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
	// Status - Operational status of the iSCSI Target. Possible values include: 'OperationalStatusInvalid', 'OperationalStatusUnknown', 'OperationalStatusHealthy', 'OperationalStatusUnhealthy', 'OperationalStatusUpdating', 'OperationalStatusRunning', 'OperationalStatusStopped', 'OperationalStatusStoppeddeallocated'
	Status OperationalStatus `json:"status,omitempty"`
	// Endpoints - List of private IPv4 addresses to connect to the iSCSI Target.
	Endpoints *[]string `json:"endpoints,omitempty"`
	// Port - The port used by iSCSI Target portal group.
	Port *int32 `json:"port,omitempty"`
	// Sessions - READ-ONLY; List of identifiers for active sessions on the iSCSI target
	Sessions *[]string `json:"sessions,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTargetProperties.
func (itp IscsiTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itp.ACLMode != "" {
		objectMap["aclMode"] = itp.ACLMode
	}
	if itp.StaticAcls != nil {
		objectMap["staticAcls"] = itp.StaticAcls
	}
	if itp.Luns != nil {
		objectMap["luns"] = itp.Luns
	}
	if itp.TargetIqn != nil {
		objectMap["targetIqn"] = itp.TargetIqn
	}
	if itp.ProvisioningState != "" {
		objectMap["provisioningState"] = itp.ProvisioningState
	}
	if itp.Status != "" {
		objectMap["status"] = itp.Status
	}
	if itp.Endpoints != nil {
		objectMap["endpoints"] = itp.Endpoints
	}
	if itp.Port != nil {
		objectMap["port"] = itp.Port
	}
	return json.Marshal(objectMap)
}

// IscsiTargetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IscsiTargetsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IscsiTargetsClient) (IscsiTarget, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IscsiTargetsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IscsiTargetsCreateOrUpdateFuture.Result.
func (future *IscsiTargetsCreateOrUpdateFuture) result(client IscsiTargetsClient) (it IscsiTarget, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		it.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.IscsiTargetsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if it.Response.Response, err = future.GetResult(sender); err == nil && it.Response.Response.StatusCode != http.StatusNoContent {
		it, err = client.CreateOrUpdateResponder(it.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsCreateOrUpdateFuture", "Result", it.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IscsiTargetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IscsiTargetsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IscsiTargetsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IscsiTargetsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IscsiTargetsDeleteFuture.Result.
func (future *IscsiTargetsDeleteFuture) result(client IscsiTargetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.IscsiTargetsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IscsiTargetsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IscsiTargetsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IscsiTargetsClient) (IscsiTarget, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IscsiTargetsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IscsiTargetsUpdateFuture.Result.
func (future *IscsiTargetsUpdateFuture) result(client IscsiTargetsClient) (it IscsiTarget, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		it.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagepool.IscsiTargetsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if it.Response.Response, err = future.GetResult(sender); err == nil && it.Response.Response.StatusCode != http.StatusNoContent {
		it, err = client.UpdateResponder(it.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagepool.IscsiTargetsUpdateFuture", "Result", it.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IscsiTargetUpdate payload for iSCSI Target update requests.
type IscsiTargetUpdate struct {
	// IscsiTargetUpdateProperties - Properties for iSCSI Target update request.
	*IscsiTargetUpdateProperties `json:"properties,omitempty"`
	// ManagedBy - Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// ManagedByExtended - List of Azure resource ids that manage this resource.
	ManagedByExtended *[]string `json:"managedByExtended,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IscsiTargetUpdate.
func (itu IscsiTargetUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itu.IscsiTargetUpdateProperties != nil {
		objectMap["properties"] = itu.IscsiTargetUpdateProperties
	}
	if itu.ManagedBy != nil {
		objectMap["managedBy"] = itu.ManagedBy
	}
	if itu.ManagedByExtended != nil {
		objectMap["managedByExtended"] = itu.ManagedByExtended
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IscsiTargetUpdate struct.
func (itu *IscsiTargetUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iscsiTargetUpdateProperties IscsiTargetUpdateProperties
				err = json.Unmarshal(*v, &iscsiTargetUpdateProperties)
				if err != nil {
					return err
				}
				itu.IscsiTargetUpdateProperties = &iscsiTargetUpdateProperties
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				itu.ManagedBy = &managedBy
			}
		case "managedByExtended":
			if v != nil {
				var managedByExtended []string
				err = json.Unmarshal(*v, &managedByExtended)
				if err != nil {
					return err
				}
				itu.ManagedByExtended = &managedByExtended
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itu.Type = &typeVar
			}
		}
	}

	return nil
}

// IscsiTargetUpdateProperties properties for iSCSI Target update request.
type IscsiTargetUpdateProperties struct {
	// StaticAcls - Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
	StaticAcls *[]ACL `json:"staticAcls,omitempty"`
	// Luns - List of LUNs to be exposed through iSCSI Target.
	Luns *[]IscsiLun `json:"luns,omitempty"`
}

// OperationDisplay metadata about an operation.
type OperationDisplay struct {
	// Provider - Localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized friendly name for the operation, as it should be shown to the user.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation, as it should be shown to the user.
	Description *string `json:"description,omitempty"`
}

// OperationListResult list of operations supported by the RP.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of operations supported by the StoragePool RP.
	Value *[]RPOperation `json:"value,omitempty"`
	// NextLink - URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// OutboundEnvironmentEndpoint endpoints accessed for a common purpose that the App Service Environment
// requires outbound network access to.
type OutboundEnvironmentEndpoint struct {
	// Category - The type of service accessed by the App Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active Directory.
	Category *string `json:"category,omitempty"`
	// Endpoints - The endpoints that the App Service Environment reaches the service at.
	Endpoints *[]EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointList collection of Outbound Environment Endpoints
type OutboundEnvironmentEndpointList struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]OutboundEnvironmentEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundEnvironmentEndpointList.
func (oeel OutboundEnvironmentEndpointList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oeel.Value != nil {
		objectMap["value"] = oeel.Value
	}
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointListIterator provides access to a complete listing of
// OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointListIterator struct {
	i    int
	page OutboundEnvironmentEndpointListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutboundEnvironmentEndpointListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutboundEnvironmentEndpointListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutboundEnvironmentEndpointListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutboundEnvironmentEndpointListIterator) Response() OutboundEnvironmentEndpointList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutboundEnvironmentEndpointListIterator) Value() OutboundEnvironmentEndpoint {
	if !iter.page.NotDone() {
		return OutboundEnvironmentEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutboundEnvironmentEndpointListIterator type.
func NewOutboundEnvironmentEndpointListIterator(page OutboundEnvironmentEndpointListPage) OutboundEnvironmentEndpointListIterator {
	return OutboundEnvironmentEndpointListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oeel OutboundEnvironmentEndpointList) IsEmpty() bool {
	return oeel.Value == nil || len(*oeel.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oeel OutboundEnvironmentEndpointList) hasNextLink() bool {
	return oeel.NextLink != nil && len(*oeel.NextLink) != 0
}

// outboundEnvironmentEndpointListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oeel OutboundEnvironmentEndpointList) outboundEnvironmentEndpointListPreparer(ctx context.Context) (*http.Request, error) {
	if !oeel.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oeel.NextLink)))
}

// OutboundEnvironmentEndpointListPage contains a page of OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointListPage struct {
	fn   func(context.Context, OutboundEnvironmentEndpointList) (OutboundEnvironmentEndpointList, error)
	oeel OutboundEnvironmentEndpointList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutboundEnvironmentEndpointListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oeel)
		if err != nil {
			return err
		}
		page.oeel = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutboundEnvironmentEndpointListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutboundEnvironmentEndpointListPage) NotDone() bool {
	return !page.oeel.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutboundEnvironmentEndpointListPage) Response() OutboundEnvironmentEndpointList {
	return page.oeel
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutboundEnvironmentEndpointListPage) Values() []OutboundEnvironmentEndpoint {
	if page.oeel.IsEmpty() {
		return nil
	}
	return *page.oeel.Value
}

// Creates a new instance of the OutboundEnvironmentEndpointListPage type.
func NewOutboundEnvironmentEndpointListPage(cur OutboundEnvironmentEndpointList, getNextPage func(context.Context, OutboundEnvironmentEndpointList) (OutboundEnvironmentEndpointList, error)) OutboundEnvironmentEndpointListPage {
	return OutboundEnvironmentEndpointListPage{
		fn:   getNextPage,
		oeel: cur,
	}
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource ARM resource model definition.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuCapability capability a resource SKU has.
type ResourceSkuCapability struct {
	// Name - READ-ONLY; Capability name
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; Capability value
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuCapability.
func (rsc ResourceSkuCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuInfo resource SKU Details
type ResourceSkuInfo struct {
	// APIVersion - READ-ONLY; StoragePool RP API version
	APIVersion *string `json:"apiVersion,omitempty"`
	// ResourceType - READ-ONLY; StoragePool resource type
	ResourceType *string `json:"resourceType,omitempty"`
	// Capabilities - READ-ONLY; List of additional capabilities for StoragePool resource.
	Capabilities *[]ResourceSkuCapability `json:"capabilities,omitempty"`
	// LocationInfo - READ-ONLY; Zones and zone capabilities in those locations where the SKU is available.
	LocationInfo *ResourceSkuLocationInfo `json:"locationInfo,omitempty"`
	// Name - READ-ONLY; Sku name
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; Sku tier
	Tier *string `json:"tier,omitempty"`
	// Restrictions - READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuInfo.
func (rsi ResourceSkuInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuListResult list Disk Pool skus operation response.
type ResourceSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of StoragePool resource skus.
	Value *[]ResourceSkuInfo `json:"value,omitempty"`
	// NextLink - URI to fetch the next section of the paginated response.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkuListResultIterator provides access to a complete listing of ResourceSkuInfo values.
type ResourceSkuListResultIterator struct {
	i    int
	page ResourceSkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkuListResultIterator) Response() ResourceSkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkuListResultIterator) Value() ResourceSkuInfo {
	if !iter.page.NotDone() {
		return ResourceSkuInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkuListResultIterator type.
func NewResourceSkuListResultIterator(page ResourceSkuListResultPage) ResourceSkuListResultIterator {
	return ResourceSkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rslr ResourceSkuListResult) IsEmpty() bool {
	return rslr.Value == nil || len(*rslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rslr ResourceSkuListResult) hasNextLink() bool {
	return rslr.NextLink != nil && len(*rslr.NextLink) != 0
}

// resourceSkuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rslr ResourceSkuListResult) resourceSkuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rslr.NextLink)))
}

// ResourceSkuListResultPage contains a page of ResourceSkuInfo values.
type ResourceSkuListResultPage struct {
	fn   func(context.Context, ResourceSkuListResult) (ResourceSkuListResult, error)
	rslr ResourceSkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rslr)
		if err != nil {
			return err
		}
		page.rslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkuListResultPage) NotDone() bool {
	return !page.rslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkuListResultPage) Response() ResourceSkuListResult {
	return page.rslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkuListResultPage) Values() []ResourceSkuInfo {
	if page.rslr.IsEmpty() {
		return nil
	}
	return *page.rslr.Value
}

// Creates a new instance of the ResourceSkuListResultPage type.
func NewResourceSkuListResultPage(cur ResourceSkuListResult, getNextPage func(context.Context, ResourceSkuListResult) (ResourceSkuListResult, error)) ResourceSkuListResultPage {
	return ResourceSkuListResultPage{
		fn:   getNextPage,
		rslr: cur,
	}
}

// ResourceSkuLocationInfo zone and capability info for resource sku
type ResourceSkuLocationInfo struct {
	// Location - READ-ONLY; Location of the SKU
	Location *string `json:"location,omitempty"`
	// Zones - READ-ONLY; List of availability zones where the SKU is supported.
	Zones *[]string `json:"zones,omitempty"`
	// ZoneDetails - READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails *[]ResourceSkuZoneDetails `json:"zoneDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuLocationInfo.
func (rsli ResourceSkuLocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuRestrictionInfo describes an available Compute SKU Restriction Information.
type ResourceSkuRestrictionInfo struct {
	// Locations - READ-ONLY; Locations where the SKU is restricted
	Locations *[]string `json:"locations,omitempty"`
	// Zones - READ-ONLY; List of availability zones where the SKU is restricted.
	Zones *[]string `json:"zones,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuRestrictionInfo.
func (rsri ResourceSkuRestrictionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuRestrictions describes scaling information of a SKU.
type ResourceSkuRestrictions struct {
	// Type - READ-ONLY; The type of restrictions. Possible values include: 'ResourceSkuRestrictionsTypeLocation', 'ResourceSkuRestrictionsTypeZone'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// RestrictionInfo - READ-ONLY; The information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSkuRestrictionInfo `json:"restrictionInfo,omitempty"`
	// ReasonCode - READ-ONLY; The reason for restriction. Possible values include: 'ResourceSkuRestrictionsReasonCodeQuotaID', 'ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuRestrictions.
func (rsr ResourceSkuRestrictions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSkuZoneDetails describes The zonal capabilities of a SKU.
type ResourceSkuZoneDetails struct {
	// Name - READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name *[]string `json:"name,omitempty"`
	// Capabilities - READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities *[]ResourceSkuCapability `json:"capabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSkuZoneDetails.
func (rszd ResourceSkuZoneDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RPOperation description of a StoragePool RP Operation
type RPOperation struct {
	// Name - The name of the operation being performed on this particular object
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation applies to data-plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// ActionType - Indicates the action type.
	ActionType *string `json:"actionType,omitempty"`
	// Display - Additional metadata about RP operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX.
	Origin *string `json:"origin,omitempty"`
}

// Sku sku for ARM resource
type Sku struct {
	// Name - Sku name
	Name *string `json:"name,omitempty"`
	// Tier - Sku tier
	Tier *string `json:"tier,omitempty"`
}

// SystemMetadata metadata pertaining to creation and last modification of the resource.
type SystemMetadata struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The type of identity that last modified the resource.
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
