package mahonia

var jis0212ToUnicode = [65536]uint16{
	0x222F: 0x02D8, // BREVE
	0x2230: 0x02C7, // CARON (Mandarin Chinese third tone)
	0x2231: 0x00B8, // CEDILLA
	0x2232: 0x02D9, // DOT ABOVE (Mandarin Chinese light tone)
	0x2233: 0x02DD, // DOUBLE ACUTE ACCENT
	0x2234: 0x00AF, // MACRON
	0x2235: 0x02DB, // OGONEK
	0x2236: 0x02DA, // RING ABOVE
	0x2237: 0x007E, // TILDE
	0x2238: 0x0384, // GREEK TONOS
	0x2239: 0x0385, // GREEK DIALYTIKA TONOS
	0x2242: 0x00A1, // INVERTED EXCLAMATION MARK
	0x2243: 0x00A6, // BROKEN BAR
	0x2244: 0x00BF, // INVERTED QUESTION MARK
	0x226B: 0x00BA, // MASCULINE ORDINAL INDICATOR
	0x226C: 0x00AA, // FEMININE ORDINAL INDICATOR
	0x226D: 0x00A9, // COPYRIGHT SIGN
	0x226E: 0x00AE, // REGISTERED SIGN
	0x226F: 0x2122, // TRADE MARK SIGN
	0x2270: 0x00A4, // CURRENCY SIGN
	0x2271: 0x2116, // NUMERO SIGN
	0x2661: 0x0386, // GREEK CAPITAL LETTER ALPHA WITH TONOS
	0x2662: 0x0388, // GREEK CAPITAL LETTER EPSILON WITH TONOS
	0x2663: 0x0389, // GREEK CAPITAL LETTER ETA WITH TONOS
	0x2664: 0x038A, // GREEK CAPITAL LETTER IOTA WITH TONOS
	0x2665: 0x03AA, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
	0x2667: 0x038C, // GREEK CAPITAL LETTER OMICRON WITH TONOS
	0x2669: 0x038E, // GREEK CAPITAL LETTER UPSILON WITH TONOS
	0x266A: 0x03AB, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
	0x266C: 0x038F, // GREEK CAPITAL LETTER OMEGA WITH TONOS
	0x2671: 0x03AC, // GREEK SMALL LETTER ALPHA WITH TONOS
	0x2672: 0x03AD, // GREEK SMALL LETTER EPSILON WITH TONOS
	0x2673: 0x03AE, // GREEK SMALL LETTER ETA WITH TONOS
	0x2674: 0x03AF, // GREEK SMALL LETTER IOTA WITH TONOS
	0x2675: 0x03CA, // GREEK SMALL LETTER IOTA WITH DIALYTIKA
	0x2676: 0x0390, // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
	0x2677: 0x03CC, // GREEK SMALL LETTER OMICRON WITH TONOS
	0x2678: 0x03C2, // GREEK SMALL LETTER FINAL SIGMA
	0x2679: 0x03CD, // GREEK SMALL LETTER UPSILON WITH TONOS
	0x267A: 0x03CB, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA
	0x267B: 0x03B0, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
	0x267C: 0x03CE, // GREEK SMALL LETTER OMEGA WITH TONOS
	0x2742: 0x0402, // CYRILLIC CAPITAL LETTER DJE
	0x2743: 0x0403, // CYRILLIC CAPITAL LETTER GJE
	0x2744: 0x0404, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
	0x2745: 0x0405, // CYRILLIC CAPITAL LETTER DZE
	0x2746: 0x0406, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
	0x2747: 0x0407, // CYRILLIC CAPITAL LETTER YI
	0x2748: 0x0408, // CYRILLIC CAPITAL LETTER JE
	0x2749: 0x0409, // CYRILLIC CAPITAL LETTER LJE
	0x274A: 0x040A, // CYRILLIC CAPITAL LETTER NJE
	0x274B: 0x040B, // CYRILLIC CAPITAL LETTER TSHE
	0x274C: 0x040C, // CYRILLIC CAPITAL LETTER KJE
	0x274D: 0x040E, // CYRILLIC CAPITAL LETTER SHORT U
	0x274E: 0x040F, // CYRILLIC CAPITAL LETTER DZHE
	0x2772: 0x0452, // CYRILLIC SMALL LETTER DJE
	0x2773: 0x0453, // CYRILLIC SMALL LETTER GJE
	0x2774: 0x0454, // CYRILLIC SMALL LETTER UKRAINIAN IE
	0x2775: 0x0455, // CYRILLIC SMALL LETTER DZE
	0x2776: 0x0456, // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
	0x2777: 0x0457, // CYRILLIC SMALL LETTER YI
	0x2778: 0x0458, // CYRILLIC SMALL LETTER JE
	0x2779: 0x0459, // CYRILLIC SMALL LETTER LJE
	0x277A: 0x045A, // CYRILLIC SMALL LETTER NJE
	0x277B: 0x045B, // CYRILLIC SMALL LETTER TSHE
	0x277C: 0x045C, // CYRILLIC SMALL LETTER KJE
	0x277D: 0x045E, // CYRILLIC SMALL LETTER SHORT U
	0x277E: 0x045F, // CYRILLIC SMALL LETTER DZHE
	0x2921: 0x00C6, // LATIN CAPITAL LIGATURE AE
	0x2922: 0x0110, // LATIN CAPITAL LETTER D WITH STROKE
	0x2924: 0x0126, // LATIN CAPITAL LETTER H WITH STROKE
	0x2926: 0x0132, // LATIN CAPITAL LIGATURE IJ
	0x2928: 0x0141, // LATIN CAPITAL LETTER L WITH STROKE
	0x2929: 0x013F, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
	0x292B: 0x014A, // LATIN CAPITAL LETTER ENG
	0x292C: 0x00D8, // LATIN CAPITAL LETTER O WITH STROKE
	0x292D: 0x0152, // LATIN CAPITAL LIGATURE OE
	0x292F: 0x0166, // LATIN CAPITAL LETTER T WITH STROKE
	0x2930: 0x00DE, // LATIN CAPITAL LETTER THORN
	0x2941: 0x00E6, // LATIN SMALL LIGATURE AE
	0x2942: 0x0111, // LATIN SMALL LETTER D WITH STROKE
	0x2943: 0x00F0, // LATIN SMALL LETTER ETH
	0x2944: 0x0127, // LATIN SMALL LETTER H WITH STROKE
	0x2945: 0x0131, // LATIN SMALL LETTER DOTLESS I
	0x2946: 0x0133, // LATIN SMALL LIGATURE IJ
	0x2947: 0x0138, // LATIN SMALL LETTER KRA
	0x2948: 0x0142, // LATIN SMALL LETTER L WITH STROKE
	0x2949: 0x0140, // LATIN SMALL LETTER L WITH MIDDLE DOT
	0x294A: 0x0149, // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
	0x294B: 0x014B, // LATIN SMALL LETTER ENG
	0x294C: 0x00F8, // LATIN SMALL LETTER O WITH STROKE
	0x294D: 0x0153, // LATIN SMALL LIGATURE OE
	0x294E: 0x00DF, // LATIN SMALL LETTER SHARP S
	0x294F: 0x0167, // LATIN SMALL LETTER T WITH STROKE
	0x2950: 0x00FE, // LATIN SMALL LETTER THORN
	0x2A21: 0x00C1, // LATIN CAPITAL LETTER A WITH ACUTE
	0x2A22: 0x00C0, // LATIN CAPITAL LETTER A WITH GRAVE
	0x2A23: 0x00C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
	0x2A24: 0x00C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	0x2A25: 0x0102, // LATIN CAPITAL LETTER A WITH BREVE
	0x2A26: 0x01CD, // LATIN CAPITAL LETTER A WITH CARON
	0x2A27: 0x0100, // LATIN CAPITAL LETTER A WITH MACRON
	0x2A28: 0x0104, // LATIN CAPITAL LETTER A WITH OGONEK
	0x2A29: 0x00C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
	0x2A2A: 0x00C3, // LATIN CAPITAL LETTER A WITH TILDE
	0x2A2B: 0x0106, // LATIN CAPITAL LETTER C WITH ACUTE
	0x2A2C: 0x0108, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
	0x2A2D: 0x010C, // LATIN CAPITAL LETTER C WITH CARON
	0x2A2E: 0x00C7, // LATIN CAPITAL LETTER C WITH CEDILLA
	0x2A2F: 0x010A, // LATIN CAPITAL LETTER C WITH DOT ABOVE
	0x2A30: 0x010E, // LATIN CAPITAL LETTER D WITH CARON
	0x2A31: 0x00C9, // LATIN CAPITAL LETTER E WITH ACUTE
	0x2A32: 0x00C8, // LATIN CAPITAL LETTER E WITH GRAVE
	0x2A33: 0x00CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
	0x2A34: 0x00CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	0x2A35: 0x011A, // LATIN CAPITAL LETTER E WITH CARON
	0x2A36: 0x0116, // LATIN CAPITAL LETTER E WITH DOT ABOVE
	0x2A37: 0x0112, // LATIN CAPITAL LETTER E WITH MACRON
	0x2A38: 0x0118, // LATIN CAPITAL LETTER E WITH OGONEK
	0x2A3A: 0x011C, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
	0x2A3B: 0x011E, // LATIN CAPITAL LETTER G WITH BREVE
	0x2A3C: 0x0122, // LATIN CAPITAL LETTER G WITH CEDILLA
	0x2A3D: 0x0120, // LATIN CAPITAL LETTER G WITH DOT ABOVE
	0x2A3E: 0x0124, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
	0x2A3F: 0x00CD, // LATIN CAPITAL LETTER I WITH ACUTE
	0x2A40: 0x00CC, // LATIN CAPITAL LETTER I WITH GRAVE
	0x2A41: 0x00CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
	0x2A42: 0x00CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	0x2A43: 0x01CF, // LATIN CAPITAL LETTER I WITH CARON
	0x2A44: 0x0130, // LATIN CAPITAL LETTER I WITH DOT ABOVE
	0x2A45: 0x012A, // LATIN CAPITAL LETTER I WITH MACRON
	0x2A46: 0x012E, // LATIN CAPITAL LETTER I WITH OGONEK
	0x2A47: 0x0128, // LATIN CAPITAL LETTER I WITH TILDE
	0x2A48: 0x0134, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
	0x2A49: 0x0136, // LATIN CAPITAL LETTER K WITH CEDILLA
	0x2A4A: 0x0139, // LATIN CAPITAL LETTER L WITH ACUTE
	0x2A4B: 0x013D, // LATIN CAPITAL LETTER L WITH CARON
	0x2A4C: 0x013B, // LATIN CAPITAL LETTER L WITH CEDILLA
	0x2A4D: 0x0143, // LATIN CAPITAL LETTER N WITH ACUTE
	0x2A4E: 0x0147, // LATIN CAPITAL LETTER N WITH CARON
	0x2A4F: 0x0145, // LATIN CAPITAL LETTER N WITH CEDILLA
	0x2A50: 0x00D1, // LATIN CAPITAL LETTER N WITH TILDE
	0x2A51: 0x00D3, // LATIN CAPITAL LETTER O WITH ACUTE
	0x2A52: 0x00D2, // LATIN CAPITAL LETTER O WITH GRAVE
	0x2A53: 0x00D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
	0x2A54: 0x00D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	0x2A55: 0x01D1, // LATIN CAPITAL LETTER O WITH CARON
	0x2A56: 0x0150, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
	0x2A57: 0x014C, // LATIN CAPITAL LETTER O WITH MACRON
	0x2A58: 0x00D5, // LATIN CAPITAL LETTER O WITH TILDE
	0x2A59: 0x0154, // LATIN CAPITAL LETTER R WITH ACUTE
	0x2A5A: 0x0158, // LATIN CAPITAL LETTER R WITH CARON
	0x2A5B: 0x0156, // LATIN CAPITAL LETTER R WITH CEDILLA
	0x2A5C: 0x015A, // LATIN CAPITAL LETTER S WITH ACUTE
	0x2A5D: 0x015C, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
	0x2A5E: 0x0160, // LATIN CAPITAL LETTER S WITH CARON
	0x2A5F: 0x015E, // LATIN CAPITAL LETTER S WITH CEDILLA
	0x2A60: 0x0164, // LATIN CAPITAL LETTER T WITH CARON
	0x2A61: 0x0162, // LATIN CAPITAL LETTER T WITH CEDILLA
	0x2A62: 0x00DA, // LATIN CAPITAL LETTER U WITH ACUTE
	0x2A63: 0x00D9, // LATIN CAPITAL LETTER U WITH GRAVE
	0x2A64: 0x00DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
	0x2A65: 0x00DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	0x2A66: 0x016C, // LATIN CAPITAL LETTER U WITH BREVE
	0x2A67: 0x01D3, // LATIN CAPITAL LETTER U WITH CARON
	0x2A68: 0x0170, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
	0x2A69: 0x016A, // LATIN CAPITAL LETTER U WITH MACRON
	0x2A6A: 0x0172, // LATIN CAPITAL LETTER U WITH OGONEK
	0x2A6B: 0x016E, // LATIN CAPITAL LETTER U WITH RING ABOVE
	0x2A6C: 0x0168, // LATIN CAPITAL LETTER U WITH TILDE
	0x2A6D: 0x01D7, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	0x2A6E: 0x01DB, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	0x2A6F: 0x01D9, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	0x2A70: 0x01D5, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	0x2A71: 0x0174, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
	0x2A72: 0x00DD, // LATIN CAPITAL LETTER Y WITH ACUTE
	0x2A73: 0x0178, // LATIN CAPITAL LETTER Y WITH DIAERESIS
	0x2A74: 0x0176, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
	0x2A75: 0x0179, // LATIN CAPITAL LETTER Z WITH ACUTE
	0x2A76: 0x017D, // LATIN CAPITAL LETTER Z WITH CARON
	0x2A77: 0x017B, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
	0x2B21: 0x00E1, // LATIN SMALL LETTER A WITH ACUTE
	0x2B22: 0x00E0, // LATIN SMALL LETTER A WITH GRAVE
	0x2B23: 0x00E4, // LATIN SMALL LETTER A WITH DIAERESIS
	0x2B24: 0x00E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
	0x2B25: 0x0103, // LATIN SMALL LETTER A WITH BREVE
	0x2B26: 0x01CE, // LATIN SMALL LETTER A WITH CARON
	0x2B27: 0x0101, // LATIN SMALL LETTER A WITH MACRON
	0x2B28: 0x0105, // LATIN SMALL LETTER A WITH OGONEK
	0x2B29: 0x00E5, // LATIN SMALL LETTER A WITH RING ABOVE
	0x2B2A: 0x00E3, // LATIN SMALL LETTER A WITH TILDE
	0x2B2B: 0x0107, // LATIN SMALL LETTER C WITH ACUTE
	0x2B2C: 0x0109, // LATIN SMALL LETTER C WITH CIRCUMFLEX
	0x2B2D: 0x010D, // LATIN SMALL LETTER C WITH CARON
	0x2B2E: 0x00E7, // LATIN SMALL LETTER C WITH CEDILLA
	0x2B2F: 0x010B, // LATIN SMALL LETTER C WITH DOT ABOVE
	0x2B30: 0x010F, // LATIN SMALL LETTER D WITH CARON
	0x2B31: 0x00E9, // LATIN SMALL LETTER E WITH ACUTE
	0x2B32: 0x00E8, // LATIN SMALL LETTER E WITH GRAVE
	0x2B33: 0x00EB, // LATIN SMALL LETTER E WITH DIAERESIS
	0x2B34: 0x00EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
	0x2B35: 0x011B, // LATIN SMALL LETTER E WITH CARON
	0x2B36: 0x0117, // LATIN SMALL LETTER E WITH DOT ABOVE
	0x2B37: 0x0113, // LATIN SMALL LETTER E WITH MACRON
	0x2B38: 0x0119, // LATIN SMALL LETTER E WITH OGONEK
	0x2B39: 0x01F5, // LATIN SMALL LETTER G WITH ACUTE
	0x2B3A: 0x011D, // LATIN SMALL LETTER G WITH CIRCUMFLEX
	0x2B3B: 0x011F, // LATIN SMALL LETTER G WITH BREVE
	0x2B3D: 0x0121, // LATIN SMALL LETTER G WITH DOT ABOVE
	0x2B3E: 0x0125, // LATIN SMALL LETTER H WITH CIRCUMFLEX
	0x2B3F: 0x00ED, // LATIN SMALL LETTER I WITH ACUTE
	0x2B40: 0x00EC, // LATIN SMALL LETTER I WITH GRAVE
	0x2B41: 0x00EF, // LATIN SMALL LETTER I WITH DIAERESIS
	0x2B42: 0x00EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
	0x2B43: 0x01D0, // LATIN SMALL LETTER I WITH CARON
	0x2B45: 0x012B, // LATIN SMALL LETTER I WITH MACRON
	0x2B46: 0x012F, // LATIN SMALL LETTER I WITH OGONEK
	0x2B47: 0x0129, // LATIN SMALL LETTER I WITH TILDE
	0x2B48: 0x0135, // LATIN SMALL LETTER J WITH CIRCUMFLEX
	0x2B49: 0x0137, // LATIN SMALL LETTER K WITH CEDILLA
	0x2B4A: 0x013A, // LATIN SMALL LETTER L WITH ACUTE
	0x2B4B: 0x013E, // LATIN SMALL LETTER L WITH CARON
	0x2B4C: 0x013C, // LATIN SMALL LETTER L WITH CEDILLA
	0x2B4D: 0x0144, // LATIN SMALL LETTER N WITH ACUTE
	0x2B4E: 0x0148, // LATIN SMALL LETTER N WITH CARON
	0x2B4F: 0x0146, // LATIN SMALL LETTER N WITH CEDILLA
	0x2B50: 0x00F1, // LATIN SMALL LETTER N WITH TILDE
	0x2B51: 0x00F3, // LATIN SMALL LETTER O WITH ACUTE
	0x2B52: 0x00F2, // LATIN SMALL LETTER O WITH GRAVE
	0x2B53: 0x00F6, // LATIN SMALL LETTER O WITH DIAERESIS
	0x2B54: 0x00F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
	0x2B55: 0x01D2, // LATIN SMALL LETTER O WITH CARON
	0x2B56: 0x0151, // LATIN SMALL LETTER O WITH DOUBLE ACUTE
	0x2B57: 0x014D, // LATIN SMALL LETTER O WITH MACRON
	0x2B58: 0x00F5, // LATIN SMALL LETTER O WITH TILDE
	0x2B59: 0x0155, // LATIN SMALL LETTER R WITH ACUTE
	0x2B5A: 0x0159, // LATIN SMALL LETTER R WITH CARON
	0x2B5B: 0x0157, // LATIN SMALL LETTER R WITH CEDILLA
	0x2B5C: 0x015B, // LATIN SMALL LETTER S WITH ACUTE
	0x2B5D: 0x015D, // LATIN SMALL LETTER S WITH CIRCUMFLEX
	0x2B5E: 0x0161, // LATIN SMALL LETTER S WITH CARON
	0x2B5F: 0x015F, // LATIN SMALL LETTER S WITH CEDILLA
	0x2B60: 0x0165, // LATIN SMALL LETTER T WITH CARON
	0x2B61: 0x0163, // LATIN SMALL LETTER T WITH CEDILLA
	0x2B62: 0x00FA, // LATIN SMALL LETTER U WITH ACUTE
	0x2B63: 0x00F9, // LATIN SMALL LETTER U WITH GRAVE
	0x2B64: 0x00FC, // LATIN SMALL LETTER U WITH DIAERESIS
	0x2B65: 0x00FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
	0x2B66: 0x016D, // LATIN SMALL LETTER U WITH BREVE
	0x2B67: 0x01D4, // LATIN SMALL LETTER U WITH CARON
	0x2B68: 0x0171, // LATIN SMALL LETTER U WITH DOUBLE ACUTE
	0x2B69: 0x016B, // LATIN SMALL LETTER U WITH MACRON
	0x2B6A: 0x0173, // LATIN SMALL LETTER U WITH OGONEK
	0x2B6B: 0x016F, // LATIN SMALL LETTER U WITH RING ABOVE
	0x2B6C: 0x0169, // LATIN SMALL LETTER U WITH TILDE
	0x2B6D: 0x01D8, // LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
	0x2B6E: 0x01DC, // LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
	0x2B6F: 0x01DA, // LATIN SMALL LETTER U WITH DIAERESIS AND CARON
	0x2B70: 0x01D6, // LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
	0x2B71: 0x0175, // LATIN SMALL LETTER W WITH CIRCUMFLEX
	0x2B72: 0x00FD, // LATIN SMALL LETTER Y WITH ACUTE
	0x2B73: 0x00FF, // LATIN SMALL LETTER Y WITH DIAERESIS
	0x2B74: 0x0177, // LATIN SMALL LETTER Y WITH CIRCUMFLEX
	0x2B75: 0x017A, // LATIN SMALL LETTER Z WITH ACUTE
	0x2B76: 0x017E, // LATIN SMALL LETTER Z WITH CARON
	0x2B77: 0x017C, // LATIN SMALL LETTER Z WITH DOT ABOVE
	0x3021: 0x4E02,
	0x3022: 0x4E04,
	0x3023: 0x4E05,
	0x3024: 0x4E0C,
	0x3025: 0x4E12,
	0x3026: 0x4E1F,
	0x3027: 0x4E23,
	0x3028: 0x4E24,
	0x3029: 0x4E28,
	0x302A: 0x4E2B,
	0x302B: 0x4E2E,
	0x302C: 0x4E2F,
	0x302D: 0x4E30,
	0x302E: 0x4E35,
	0x302F: 0x4E40,
	0x3030: 0x4E41,
	0x3031: 0x4E44,
	0x3032: 0x4E47,
	0x3033: 0x4E51,
	0x3034: 0x4E5A,
	0x3035: 0x4E5C,
	0x3036: 0x4E63,
	0x3037: 0x4E68,
	0x3038: 0x4E69,
	0x3039: 0x4E74,
	0x303A: 0x4E75,
	0x303B: 0x4E79,
	0x303C: 0x4E7F,
	0x303D: 0x4E8D,
	0x303E: 0x4E96,
	0x303F: 0x4E97,
	0x3040: 0x4E9D,
	0x3041: 0x4EAF,
	0x3042: 0x4EB9,
	0x3043: 0x4EC3,
	0x3044: 0x4ED0,
	0x3045: 0x4EDA,
	0x3046: 0x4EDB,
	0x3047: 0x4EE0,
	0x3048: 0x4EE1,
	0x3049: 0x4EE2,
	0x304A: 0x4EE8,
	0x304B: 0x4EEF,
	0x304C: 0x4EF1,
	0x304D: 0x4EF3,
	0x304E: 0x4EF5,
	0x304F: 0x4EFD,
	0x3050: 0x4EFE,
	0x3051: 0x4EFF,
	0x3052: 0x4F00,
	0x3053: 0x4F02,
	0x3054: 0x4F03,
	0x3055: 0x4F08,
	0x3056: 0x4F0B,
	0x3057: 0x4F0C,
	0x3058: 0x4F12,
	0x3059: 0x4F15,
	0x305A: 0x4F16,
	0x305B: 0x4F17,
	0x305C: 0x4F19,
	0x305D: 0x4F2E,
	0x305E: 0x4F31,
	0x305F: 0x4F60,
	0x3060: 0x4F33,
	0x3061: 0x4F35,
	0x3062: 0x4F37,
	0x3063: 0x4F39,
	0x3064: 0x4F3B,
	0x3065: 0x4F3E,
	0x3066: 0x4F40,
	0x3067: 0x4F42,
	0x3068: 0x4F48,
	0x3069: 0x4F49,
	0x306A: 0x4F4B,
	0x306B: 0x4F4C,
	0x306C: 0x4F52,
	0x306D: 0x4F54,
	0x306E: 0x4F56,
	0x306F: 0x4F58,
	0x3070: 0x4F5F,
	0x3071: 0x4F63,
	0x3072: 0x4F6A,
	0x3073: 0x4F6C,
	0x3074: 0x4F6E,
	0x3075: 0x4F71,
	0x3076: 0x4F77,
	0x3077: 0x4F78,
	0x3078: 0x4F79,
	0x3079: 0x4F7A,
	0x307A: 0x4F7D,
	0x307B: 0x4F7E,
	0x307C: 0x4F81,
	0x307D: 0x4F82,
	0x307E: 0x4F84,
	0x3121: 0x4F85,
	0x3122: 0x4F89,
	0x3123: 0x4F8A,
	0x3124: 0x4F8C,
	0x3125: 0x4F8E,
	0x3126: 0x4F90,
	0x3127: 0x4F92,
	0x3128: 0x4F93,
	0x3129: 0x4F94,
	0x312A: 0x4F97,
	0x312B: 0x4F99,
	0x312C: 0x4F9A,
	0x312D: 0x4F9E,
	0x312E: 0x4F9F,
	0x312F: 0x4FB2,
	0x3130: 0x4FB7,
	0x3131: 0x4FB9,
	0x3132: 0x4FBB,
	0x3133: 0x4FBC,
	0x3134: 0x4FBD,
	0x3135: 0x4FBE,
	0x3136: 0x4FC0,
	0x3137: 0x4FC1,
	0x3138: 0x4FC5,
	0x3139: 0x4FC6,
	0x313A: 0x4FC8,
	0x313B: 0x4FC9,
	0x313C: 0x4FCB,
	0x313D: 0x4FCC,
	0x313E: 0x4FCD,
	0x313F: 0x4FCF,
	0x3140: 0x4FD2,
	0x3141: 0x4FDC,
	0x3142: 0x4FE0,
	0x3143: 0x4FE2,
	0x3144: 0x4FF0,
	0x3145: 0x4FF2,
	0x3146: 0x4FFC,
	0x3147: 0x4FFD,
	0x3148: 0x4FFF,
	0x3149: 0x5000,
	0x314A: 0x5001,
	0x314B: 0x5004,
	0x314C: 0x5007,
	0x314D: 0x500A,
	0x314E: 0x500C,
	0x314F: 0x500E,
	0x3150: 0x5010,
	0x3151: 0x5013,
	0x3152: 0x5017,
	0x3153: 0x5018,
	0x3154: 0x501B,
	0x3155: 0x501C,
	0x3156: 0x501D,
	0x3157: 0x501E,
	0x3158: 0x5022,
	0x3159: 0x5027,
	0x315A: 0x502E,
	0x315B: 0x5030,
	0x315C: 0x5032,
	0x315D: 0x5033,
	0x315E: 0x5035,
	0x315F: 0x5040,
	0x3160: 0x5041,
	0x3161: 0x5042,
	0x3162: 0x5045,
	0x3163: 0x5046,
	0x3164: 0x504A,
	0x3165: 0x504C,
	0x3166: 0x504E,
	0x3167: 0x5051,
	0x3168: 0x5052,
	0x3169: 0x5053,
	0x316A: 0x5057,
	0x316B: 0x5059,
	0x316C: 0x505F,
	0x316D: 0x5060,
	0x316E: 0x5062,
	0x316F: 0x5063,
	0x3170: 0x5066,
	0x3171: 0x5067,
	0x3172: 0x506A,
	0x3173: 0x506D,
	0x3174: 0x5070,
	0x3175: 0x5071,
	0x3176: 0x503B,
	0x3177: 0x5081,
	0x3178: 0x5083,
	0x3179: 0x5084,
	0x317A: 0x5086,
	0x317B: 0x508A,
	0x317C: 0x508E,
	0x317D: 0x508F,
	0x317E: 0x5090,
	0x3221: 0x5092,
	0x3222: 0x5093,
	0x3223: 0x5094,
	0x3224: 0x5096,
	0x3225: 0x509B,
	0x3226: 0x509C,
	0x3227: 0x509E,
	0x3228: 0x509F,
	0x3229: 0x50A0,
	0x322A: 0x50A1,
	0x322B: 0x50A2,
	0x322C: 0x50AA,
	0x322D: 0x50AF,
	0x322E: 0x50B0,
	0x322F: 0x50B9,
	0x3230: 0x50BA,
	0x3231: 0x50BD,
	0x3232: 0x50C0,
	0x3233: 0x50C3,
	0x3234: 0x50C4,
	0x3235: 0x50C7,
	0x3236: 0x50CC,
	0x3237: 0x50CE,
	0x3238: 0x50D0,
	0x3239: 0x50D3,
	0x323A: 0x50D4,
	0x323B: 0x50D8,
	0x323C: 0x50DC,
	0x323D: 0x50DD,
	0x323E: 0x50DF,
	0x323F: 0x50E2,
	0x3240: 0x50E4,
	0x3241: 0x50E6,
	0x3242: 0x50E8,
	0x3243: 0x50E9,
	0x3244: 0x50EF,
	0x3245: 0x50F1,
	0x3246: 0x50F6,
	0x3247: 0x50FA,
	0x3248: 0x50FE,
	0x3249: 0x5103,
	0x324A: 0x5106,
	0x324B: 0x5107,
	0x324C: 0x5108,
	0x324D: 0x510B,
	0x324E: 0x510C,
	0x324F: 0x510D,
	0x3250: 0x510E,
	0x3251: 0x50F2,
	0x3252: 0x5110,
	0x3253: 0x5117,
	0x3254: 0x5119,
	0x3255: 0x511B,
	0x3256: 0x511C,
	0x3257: 0x511D,
	0x3258: 0x511E,
	0x3259: 0x5123,
	0x325A: 0x5127,
	0x325B: 0x5128,
	0x325C: 0x512C,
	0x325D: 0x512D,
	0x325E: 0x512F,
	0x325F: 0x5131,
	0x3260: 0x5133,
	0x3261: 0x5134,
	0x3262: 0x5135,
	0x3263: 0x5138,
	0x3264: 0x5139,
	0x3265: 0x5142,
	0x3266: 0x514A,
	0x3267: 0x514F,
	0x3268: 0x5153,
	0x3269: 0x5155,
	0x326A: 0x5157,
	0x326B: 0x5158,
	0x326C: 0x515F,
	0x326D: 0x5164,
	0x326E: 0x5166,
	0x326F: 0x517E,
	0x3270: 0x5183,
	0x3271: 0x5184,
	0x3272: 0x518B,
	0x3273: 0x518E,
	0x3274: 0x5198,
	0x3275: 0x519D,
	0x3276: 0x51A1,
	0x3277: 0x51A3,
	0x3278: 0x51AD,
	0x3279: 0x51B8,
	0x327A: 0x51BA,
	0x327B: 0x51BC,
	0x327C: 0x51BE,
	0x327D: 0x51BF,
	0x327E: 0x51C2,
	0x3321: 0x51C8,
	0x3322: 0x51CF,
	0x3323: 0x51D1,
	0x3324: 0x51D2,
	0x3325: 0x51D3,
	0x3326: 0x51D5,
	0x3327: 0x51D8,
	0x3328: 0x51DE,
	0x3329: 0x51E2,
	0x332A: 0x51E5,
	0x332B: 0x51EE,
	0x332C: 0x51F2,
	0x332D: 0x51F3,
	0x332E: 0x51F4,
	0x332F: 0x51F7,
	0x3330: 0x5201,
	0x3331: 0x5202,
	0x3332: 0x5205,
	0x3333: 0x5212,
	0x3334: 0x5213,
	0x3335: 0x5215,
	0x3336: 0x5216,
	0x3337: 0x5218,
	0x3338: 0x5222,
	0x3339: 0x5228,
	0x333A: 0x5231,
	0x333B: 0x5232,
	0x333C: 0x5235,
	0x333D: 0x523C,
	0x333E: 0x5245,
	0x333F: 0x5249,
	0x3340: 0x5255,
	0x3341: 0x5257,
	0x3342: 0x5258,
	0x3343: 0x525A,
	0x3344: 0x525C,
	0x3345: 0x525F,
	0x3346: 0x5260,
	0x3347: 0x5261,
	0x3348: 0x5266,
	0x3349: 0x526E,
	0x334A: 0x5277,
	0x334B: 0x5278,
	0x334C: 0x5279,
	0x334D: 0x5280,
	0x334E: 0x5282,
	0x334F: 0x5285,
	0x3350: 0x528A,
	0x3351: 0x528C,
	0x3352: 0x5293,
	0x3353: 0x5295,
	0x3354: 0x5296,
	0x3355: 0x5297,
	0x3356: 0x5298,
	0x3357: 0x529A,
	0x3358: 0x529C,
	0x3359: 0x52A4,
	0x335A: 0x52A5,
	0x335B: 0x52A6,
	0x335C: 0x52A7,
	0x335D: 0x52AF,
	0x335E: 0x52B0,
	0x335F: 0x52B6,
	0x3360: 0x52B7,
	0x3361: 0x52B8,
	0x3362: 0x52BA,
	0x3363: 0x52BB,
	0x3364: 0x52BD,
	0x3365: 0x52C0,
	0x3366: 0x52C4,
	0x3367: 0x52C6,
	0x3368: 0x52C8,
	0x3369: 0x52CC,
	0x336A: 0x52CF,
	0x336B: 0x52D1,
	0x336C: 0x52D4,
	0x336D: 0x52D6,
	0x336E: 0x52DB,
	0x336F: 0x52DC,
	0x3370: 0x52E1,
	0x3371: 0x52E5,
	0x3372: 0x52E8,
	0x3373: 0x52E9,
	0x3374: 0x52EA,
	0x3375: 0x52EC,
	0x3376: 0x52F0,
	0x3377: 0x52F1,
	0x3378: 0x52F4,
	0x3379: 0x52F6,
	0x337A: 0x52F7,
	0x337B: 0x5300,
	0x337C: 0x5303,
	0x337D: 0x530A,
	0x337E: 0x530B,
	0x3421: 0x530C,
	0x3422: 0x5311,
	0x3423: 0x5313,
	0x3424: 0x5318,
	0x3425: 0x531B,
	0x3426: 0x531C,
	0x3427: 0x531E,
	0x3428: 0x531F,
	0x3429: 0x5325,
	0x342A: 0x5327,
	0x342B: 0x5328,
	0x342C: 0x5329,
	0x342D: 0x532B,
	0x342E: 0x532C,
	0x342F: 0x532D,
	0x3430: 0x5330,
	0x3431: 0x5332,
	0x3432: 0x5335,
	0x3433: 0x533C,
	0x3434: 0x533D,
	0x3435: 0x533E,
	0x3436: 0x5342,
	0x3437: 0x534C,
	0x3438: 0x534B,
	0x3439: 0x5359,
	0x343A: 0x535B,
	0x343B: 0x5361,
	0x343C: 0x5363,
	0x343D: 0x5365,
	0x343E: 0x536C,
	0x343F: 0x536D,
	0x3440: 0x5372,
	0x3441: 0x5379,
	0x3442: 0x537E,
	0x3443: 0x5383,
	0x3444: 0x5387,
	0x3445: 0x5388,
	0x3446: 0x538E,
	0x3447: 0x5393,
	0x3448: 0x5394,
	0x3449: 0x5399,
	0x344A: 0x539D,
	0x344B: 0x53A1,
	0x344C: 0x53A4,
	0x344D: 0x53AA,
	0x344E: 0x53AB,
	0x344F: 0x53AF,
	0x3450: 0x53B2,
	0x3451: 0x53B4,
	0x3452: 0x53B5,
	0x3453: 0x53B7,
	0x3454: 0x53B8,
	0x3455: 0x53BA,
	0x3456: 0x53BD,
	0x3457: 0x53C0,
	0x3458: 0x53C5,
	0x3459: 0x53CF,
	0x345A: 0x53D2,
	0x345B: 0x53D3,
	0x345C: 0x53D5,
	0x345D: 0x53DA,
	0x345E: 0x53DD,
	0x345F: 0x53DE,
	0x3460: 0x53E0,
	0x3461: 0x53E6,
	0x3462: 0x53E7,
	0x3463: 0x53F5,
	0x3464: 0x5402,
	0x3465: 0x5413,
	0x3466: 0x541A,
	0x3467: 0x5421,
	0x3468: 0x5427,
	0x3469: 0x5428,
	0x346A: 0x542A,
	0x346B: 0x542F,
	0x346C: 0x5431,
	0x346D: 0x5434,
	0x346E: 0x5435,
	0x346F: 0x5443,
	0x3470: 0x5444,
	0x3471: 0x5447,
	0x3472: 0x544D,
	0x3473: 0x544F,
	0x3474: 0x545E,
	0x3475: 0x5462,
	0x3476: 0x5464,
	0x3477: 0x5466,
	0x3478: 0x5467,
	0x3479: 0x5469,
	0x347A: 0x546B,
	0x347B: 0x546D,
	0x347C: 0x546E,
	0x347D: 0x5474,
	0x347E: 0x547F,
	0x3521: 0x5481,
	0x3522: 0x5483,
	0x3523: 0x5485,
	0x3524: 0x5488,
	0x3525: 0x5489,
	0x3526: 0x548D,
	0x3527: 0x5491,
	0x3528: 0x5495,
	0x3529: 0x5496,
	0x352A: 0x549C,
	0x352B: 0x549F,
	0x352C: 0x54A1,
	0x352D: 0x54A6,
	0x352E: 0x54A7,
	0x352F: 0x54A9,
	0x3530: 0x54AA,
	0x3531: 0x54AD,
	0x3532: 0x54AE,
	0x3533: 0x54B1,
	0x3534: 0x54B7,
	0x3535: 0x54B9,
	0x3536: 0x54BA,
	0x3537: 0x54BB,
	0x3538: 0x54BF,
	0x3539: 0x54C6,
	0x353A: 0x54CA,
	0x353B: 0x54CD,
	0x353C: 0x54CE,
	0x353D: 0x54E0,
	0x353E: 0x54EA,
	0x353F: 0x54EC,
	0x3540: 0x54EF,
	0x3541: 0x54F6,
	0x3542: 0x54FC,
	0x3543: 0x54FE,
	0x3544: 0x54FF,
	0x3545: 0x5500,
	0x3546: 0x5501,
	0x3547: 0x5505,
	0x3548: 0x5508,
	0x3549: 0x5509,
	0x354A: 0x550C,
	0x354B: 0x550D,
	0x354C: 0x550E,
	0x354D: 0x5515,
	0x354E: 0x552A,
	0x354F: 0x552B,
	0x3550: 0x5532,
	0x3551: 0x5535,
	0x3552: 0x5536,
	0x3553: 0x553B,
	0x3554: 0x553C,
	0x3555: 0x553D,
	0x3556: 0x5541,
	0x3557: 0x5547,
	0x3558: 0x5549,
	0x3559: 0x554A,
	0x355A: 0x554D,
	0x355B: 0x5550,
	0x355C: 0x5551,
	0x355D: 0x5558,
	0x355E: 0x555A,
	0x355F: 0x555B,
	0x3560: 0x555E,
	0x3561: 0x5560,
	0x3562: 0x5561,
	0x3563: 0x5564,
	0x3564: 0x5566,
	0x3565: 0x557F,
	0x3566: 0x5581,
	0x3567: 0x5582,
	0x3568: 0x5586,
	0x3569: 0x5588,
	0x356A: 0x558E,
	0x356B: 0x558F,
	0x356C: 0x5591,
	0x356D: 0x5592,
	0x356E: 0x5593,
	0x356F: 0x5594,
	0x3570: 0x5597,
	0x3571: 0x55A3,
	0x3572: 0x55A4,
	0x3573: 0x55AD,
	0x3574: 0x55B2,
	0x3575: 0x55BF,
	0x3576: 0x55C1,
	0x3577: 0x55C3,
	0x3578: 0x55C6,
	0x3579: 0x55C9,
	0x357A: 0x55CB,
	0x357B: 0x55CC,
	0x357C: 0x55CE,
	0x357D: 0x55D1,
	0x357E: 0x55D2,
	0x3621: 0x55D3,
	0x3622: 0x55D7,
	0x3623: 0x55D8,
	0x3624: 0x55DB,
	0x3625: 0x55DE,
	0x3626: 0x55E2,
	0x3627: 0x55E9,
	0x3628: 0x55F6,
	0x3629: 0x55FF,
	0x362A: 0x5605,
	0x362B: 0x5608,
	0x362C: 0x560A,
	0x362D: 0x560D,
	0x362E: 0x560E,
	0x362F: 0x560F,
	0x3630: 0x5610,
	0x3631: 0x5611,
	0x3632: 0x5612,
	0x3633: 0x5619,
	0x3634: 0x562C,
	0x3635: 0x5630,
	0x3636: 0x5633,
	0x3637: 0x5635,
	0x3638: 0x5637,
	0x3639: 0x5639,
	0x363A: 0x563B,
	0x363B: 0x563C,
	0x363C: 0x563D,
	0x363D: 0x563F,
	0x363E: 0x5640,
	0x363F: 0x5641,
	0x3640: 0x5643,
	0x3641: 0x5644,
	0x3642: 0x5646,
	0x3643: 0x5649,
	0x3644: 0x564B,
	0x3645: 0x564D,
	0x3646: 0x564F,
	0x3647: 0x5654,
	0x3648: 0x565E,
	0x3649: 0x5660,
	0x364A: 0x5661,
	0x364B: 0x5662,
	0x364C: 0x5663,
	0x364D: 0x5666,
	0x364E: 0x5669,
	0x364F: 0x566D,
	0x3650: 0x566F,
	0x3651: 0x5671,
	0x3652: 0x5672,
	0x3653: 0x5675,
	0x3654: 0x5684,
	0x3655: 0x5685,
	0x3656: 0x5688,
	0x3657: 0x568B,
	0x3658: 0x568C,
	0x3659: 0x5695,
	0x365A: 0x5699,
	0x365B: 0x569A,
	0x365C: 0x569D,
	0x365D: 0x569E,
	0x365E: 0x569F,
	0x365F: 0x56A6,
	0x3660: 0x56A7,
	0x3661: 0x56A8,
	0x3662: 0x56A9,
	0x3663: 0x56AB,
	0x3664: 0x56AC,
	0x3665: 0x56AD,
	0x3666: 0x56B1,
	0x3667: 0x56B3,
	0x3668: 0x56B7,
	0x3669: 0x56BE,
	0x366A: 0x56C5,
	0x366B: 0x56C9,
	0x366C: 0x56CA,
	0x366D: 0x56CB,
	0x366E: 0x56CF,
	0x366F: 0x56D0,
	0x3670: 0x56CC,
	0x3671: 0x56CD,
	0x3672: 0x56D9,
	0x3673: 0x56DC,
	0x3674: 0x56DD,
	0x3675: 0x56DF,
	0x3676: 0x56E1,
	0x3677: 0x56E4,
	0x3678: 0x56E5,
	0x3679: 0x56E6,
	0x367A: 0x56E7,
	0x367B: 0x56E8,
	0x367C: 0x56F1,
	0x367D: 0x56EB,
	0x367E: 0x56ED,
	0x3721: 0x56F6,
	0x3722: 0x56F7,
	0x3723: 0x5701,
	0x3724: 0x5702,
	0x3725: 0x5707,
	0x3726: 0x570A,
	0x3727: 0x570C,
	0x3728: 0x5711,
	0x3729: 0x5715,
	0x372A: 0x571A,
	0x372B: 0x571B,
	0x372C: 0x571D,
	0x372D: 0x5720,
	0x372E: 0x5722,
	0x372F: 0x5723,
	0x3730: 0x5724,
	0x3731: 0x5725,
	0x3732: 0x5729,
	0x3733: 0x572A,
	0x3734: 0x572C,
	0x3735: 0x572E,
	0x3736: 0x572F,
	0x3737: 0x5733,
	0x3738: 0x5734,
	0x3739: 0x573D,
	0x373A: 0x573E,
	0x373B: 0x573F,
	0x373C: 0x5745,
	0x373D: 0x5746,
	0x373E: 0x574C,
	0x373F: 0x574D,
	0x3740: 0x5752,
	0x3741: 0x5762,
	0x3742: 0x5765,
	0x3743: 0x5767,
	0x3744: 0x5768,
	0x3745: 0x576B,
	0x3746: 0x576D,
	0x3747: 0x576E,
	0x3748: 0x576F,
	0x3749: 0x5770,
	0x374A: 0x5771,
	0x374B: 0x5773,
	0x374C: 0x5774,
	0x374D: 0x5775,
	0x374E: 0x5777,
	0x374F: 0x5779,
	0x3750: 0x577A,
	0x3751: 0x577B,
	0x3752: 0x577C,
	0x3753: 0x577E,
	0x3754: 0x5781,
	0x3755: 0x5783,
	0x3756: 0x578C,
	0x3757: 0x5794,
	0x3758: 0x5797,
	0x3759: 0x5799,
	0x375A: 0x579A,
	0x375B: 0x579C,
	0x375C: 0x579D,
	0x375D: 0x579E,
	0x375E: 0x579F,
	0x375F: 0x57A1,
	0x3760: 0x5795,
	0x3761: 0x57A7,
	0x3762: 0x57A8,
	0x3763: 0x57A9,
	0x3764: 0x57AC,
	0x3765: 0x57B8,
	0x3766: 0x57BD,
	0x3767: 0x57C7,
	0x3768: 0x57C8,
	0x3769: 0x57CC,
	0x376A: 0x57CF,
	0x376B: 0x57D5,
	0x376C: 0x57DD,
	0x376D: 0x57DE,
	0x376E: 0x57E4,
	0x376F: 0x57E6,
	0x3770: 0x57E7,
	0x3771: 0x57E9,
	0x3772: 0x57ED,
	0x3773: 0x57F0,
	0x3774: 0x57F5,
	0x3775: 0x57F6,
	0x3776: 0x57F8,
	0x3777: 0x57FD,
	0x3778: 0x57FE,
	0x3779: 0x57FF,
	0x377A: 0x5803,
	0x377B: 0x5804,
	0x377C: 0x5808,
	0x377D: 0x5809,
	0x377E: 0x57E1,
	0x3821: 0x580C,
	0x3822: 0x580D,
	0x3823: 0x581B,
	0x3824: 0x581E,
	0x3825: 0x581F,
	0x3826: 0x5820,
	0x3827: 0x5826,
	0x3828: 0x5827,
	0x3829: 0x582D,
	0x382A: 0x5832,
	0x382B: 0x5839,
	0x382C: 0x583F,
	0x382D: 0x5849,
	0x382E: 0x584C,
	0x382F: 0x584D,
	0x3830: 0x584F,
	0x3831: 0x5850,
	0x3832: 0x5855,
	0x3833: 0x585F,
	0x3834: 0x5861,
	0x3835: 0x5864,
	0x3836: 0x5867,
	0x3837: 0x5868,
	0x3838: 0x5878,
	0x3839: 0x587C,
	0x383A: 0x587F,
	0x383B: 0x5880,
	0x383C: 0x5881,
	0x383D: 0x5887,
	0x383E: 0x5888,
	0x383F: 0x5889,
	0x3840: 0x588A,
	0x3841: 0x588C,
	0x3842: 0x588D,
	0x3843: 0x588F,
	0x3844: 0x5890,
	0x3845: 0x5894,
	0x3846: 0x5896,
	0x3847: 0x589D,
	0x3848: 0x58A0,
	0x3849: 0x58A1,
	0x384A: 0x58A2,
	0x384B: 0x58A6,
	0x384C: 0x58A9,
	0x384D: 0x58B1,
	0x384E: 0x58B2,
	0x384F: 0x58C4,
	0x3850: 0x58BC,
	0x3851: 0x58C2,
	0x3852: 0x58C8,
	0x3853: 0x58CD,
	0x3854: 0x58CE,
	0x3855: 0x58D0,
	0x3856: 0x58D2,
	0x3857: 0x58D4,
	0x3858: 0x58D6,
	0x3859: 0x58DA,
	0x385A: 0x58DD,
	0x385B: 0x58E1,
	0x385C: 0x58E2,
	0x385D: 0x58E9,
	0x385E: 0x58F3,
	0x385F: 0x5905,
	0x3860: 0x5906,
	0x3861: 0x590B,
	0x3862: 0x590C,
	0x3863: 0x5912,
	0x3864: 0x5913,
	0x3865: 0x5914,
	0x3866: 0x8641,
	0x3867: 0x591D,
	0x3868: 0x5921,
	0x3869: 0x5923,
	0x386A: 0x5924,
	0x386B: 0x5928,
	0x386C: 0x592F,
	0x386D: 0x5930,
	0x386E: 0x5933,
	0x386F: 0x5935,
	0x3870: 0x5936,
	0x3871: 0x593F,
	0x3872: 0x5943,
	0x3873: 0x5946,
	0x3874: 0x5952,
	0x3875: 0x5953,
	0x3876: 0x5959,
	0x3877: 0x595B,
	0x3878: 0x595D,
	0x3879: 0x595E,
	0x387A: 0x595F,
	0x387B: 0x5961,
	0x387C: 0x5963,
	0x387D: 0x596B,
	0x387E: 0x596D,
	0x3921: 0x596F,
	0x3922: 0x5972,
	0x3923: 0x5975,
	0x3924: 0x5976,
	0x3925: 0x5979,
	0x3926: 0x597B,
	0x3927: 0x597C,
	0x3928: 0x598B,
	0x3929: 0x598C,
	0x392A: 0x598E,
	0x392B: 0x5992,
	0x392C: 0x5995,
	0x392D: 0x5997,
	0x392E: 0x599F,
	0x392F: 0x59A4,
	0x3930: 0x59A7,
	0x3931: 0x59AD,
	0x3932: 0x59AE,
	0x3933: 0x59AF,
	0x3934: 0x59B0,
	0x3935: 0x59B3,
	0x3936: 0x59B7,
	0x3937: 0x59BA,
	0x3938: 0x59BC,
	0x3939: 0x59C1,
	0x393A: 0x59C3,
	0x393B: 0x59C4,
	0x393C: 0x59C8,
	0x393D: 0x59CA,
	0x393E: 0x59CD,
	0x393F: 0x59D2,
	0x3940: 0x59DD,
	0x3941: 0x59DE,
	0x3942: 0x59DF,
	0x3943: 0x59E3,
	0x3944: 0x59E4,
	0x3945: 0x59E7,
	0x3946: 0x59EE,
	0x3947: 0x59EF,
	0x3948: 0x59F1,
	0x3949: 0x59F2,
	0x394A: 0x59F4,
	0x394B: 0x59F7,
	0x394C: 0x5A00,
	0x394D: 0x5A04,
	0x394E: 0x5A0C,
	0x394F: 0x5A0D,
	0x3950: 0x5A0E,
	0x3951: 0x5A12,
	0x3952: 0x5A13,
	0x3953: 0x5A1E,
	0x3954: 0x5A23,
	0x3955: 0x5A24,
	0x3956: 0x5A27,
	0x3957: 0x5A28,
	0x3958: 0x5A2A,
	0x3959: 0x5A2D,
	0x395A: 0x5A30,
	0x395B: 0x5A44,
	0x395C: 0x5A45,
	0x395D: 0x5A47,
	0x395E: 0x5A48,
	0x395F: 0x5A4C,
	0x3960: 0x5A50,
	0x3961: 0x5A55,
	0x3962: 0x5A5E,
	0x3963: 0x5A63,
	0x3964: 0x5A65,
	0x3965: 0x5A67,
	0x3966: 0x5A6D,
	0x3967: 0x5A77,
	0x3968: 0x5A7A,
	0x3969: 0x5A7B,
	0x396A: 0x5A7E,
	0x396B: 0x5A8B,
	0x396C: 0x5A90,
	0x396D: 0x5A93,
	0x396E: 0x5A96,
	0x396F: 0x5A99,
	0x3970: 0x5A9C,
	0x3971: 0x5A9E,
	0x3972: 0x5A9F,
	0x3973: 0x5AA0,
	0x3974: 0x5AA2,
	0x3975: 0x5AA7,
	0x3976: 0x5AAC,
	0x3977: 0x5AB1,
	0x3978: 0x5AB2,
	0x3979: 0x5AB3,
	0x397A: 0x5AB5,
	0x397B: 0x5AB8,
	0x397C: 0x5ABA,
	0x397D: 0x5ABB,
	0x397E: 0x5ABF,
	0x3A21: 0x5AC4,
	0x3A22: 0x5AC6,
	0x3A23: 0x5AC8,
	0x3A24: 0x5ACF,
	0x3A25: 0x5ADA,
	0x3A26: 0x5ADC,
	0x3A27: 0x5AE0,
	0x3A28: 0x5AE5,
	0x3A29: 0x5AEA,
	0x3A2A: 0x5AEE,
	0x3A2B: 0x5AF5,
	0x3A2C: 0x5AF6,
	0x3A2D: 0x5AFD,
	0x3A2E: 0x5B00,
	0x3A2F: 0x5B01,
	0x3A30: 0x5B08,
	0x3A31: 0x5B17,
	0x3A32: 0x5B34,
	0x3A33: 0x5B19,
	0x3A34: 0x5B1B,
	0x3A35: 0x5B1D,
	0x3A36: 0x5B21,
	0x3A37: 0x5B25,
	0x3A38: 0x5B2D,
	0x3A39: 0x5B38,
	0x3A3A: 0x5B41,
	0x3A3B: 0x5B4B,
	0x3A3C: 0x5B4C,
	0x3A3D: 0x5B52,
	0x3A3E: 0x5B56,
	0x3A3F: 0x5B5E,
	0x3A40: 0x5B68,
	0x3A41: 0x5B6E,
	0x3A42: 0x5B6F,
	0x3A43: 0x5B7C,
	0x3A44: 0x5B7D,
	0x3A45: 0x5B7E,
	0x3A46: 0x5B7F,
	0x3A47: 0x5B81,
	0x3A48: 0x5B84,
	0x3A49: 0x5B86,
	0x3A4A: 0x5B8A,
	0x3A4B: 0x5B8E,
	0x3A4C: 0x5B90,
	0x3A4D: 0x5B91,
	0x3A4E: 0x5B93,
	0x3A4F: 0x5B94,
	0x3A50: 0x5B96,
	0x3A51: 0x5BA8,
	0x3A52: 0x5BA9,
	0x3A53: 0x5BAC,
	0x3A54: 0x5BAD,
	0x3A55: 0x5BAF,
	0x3A56: 0x5BB1,
	0x3A57: 0x5BB2,
	0x3A58: 0x5BB7,
	0x3A59: 0x5BBA,
	0x3A5A: 0x5BBC,
	0x3A5B: 0x5BC0,
	0x3A5C: 0x5BC1,
	0x3A5D: 0x5BCD,
	0x3A5E: 0x5BCF,
	0x3A5F: 0x5BD6,
	0x3A60: 0x5BD7,
	0x3A61: 0x5BD8,
	0x3A62: 0x5BD9,
	0x3A63: 0x5BDA,
	0x3A64: 0x5BE0,
	0x3A65: 0x5BEF,
	0x3A66: 0x5BF1,
	0x3A67: 0x5BF4,
	0x3A68: 0x5BFD,
	0x3A69: 0x5C0C,
	0x3A6A: 0x5C17,
	0x3A6B: 0x5C1E,
	0x3A6C: 0x5C1F,
	0x3A6D: 0x5C23,
	0x3A6E: 0x5C26,
	0x3A6F: 0x5C29,
	0x3A70: 0x5C2B,
	0x3A71: 0x5C2C,
	0x3A72: 0x5C2E,
	0x3A73: 0x5C30,
	0x3A74: 0x5C32,
	0x3A75: 0x5C35,
	0x3A76: 0x5C36,
	0x3A77: 0x5C59,
	0x3A78: 0x5C5A,
	0x3A79: 0x5C5C,
	0x3A7A: 0x5C62,
	0x3A7B: 0x5C63,
	0x3A7C: 0x5C67,
	0x3A7D: 0x5C68,
	0x3A7E: 0x5C69,
	0x3B21: 0x5C6D,
	0x3B22: 0x5C70,
	0x3B23: 0x5C74,
	0x3B24: 0x5C75,
	0x3B25: 0x5C7A,
	0x3B26: 0x5C7B,
	0x3B27: 0x5C7C,
	0x3B28: 0x5C7D,
	0x3B29: 0x5C87,
	0x3B2A: 0x5C88,
	0x3B2B: 0x5C8A,
	0x3B2C: 0x5C8F,
	0x3B2D: 0x5C92,
	0x3B2E: 0x5C9D,
	0x3B2F: 0x5C9F,
	0x3B30: 0x5CA0,
	0x3B31: 0x5CA2,
	0x3B32: 0x5CA3,
	0x3B33: 0x5CA6,
	0x3B34: 0x5CAA,
	0x3B35: 0x5CB2,
	0x3B36: 0x5CB4,
	0x3B37: 0x5CB5,
	0x3B38: 0x5CBA,
	0x3B39: 0x5CC9,
	0x3B3A: 0x5CCB,
	0x3B3B: 0x5CD2,
	0x3B3C: 0x5CDD,
	0x3B3D: 0x5CD7,
	0x3B3E: 0x5CEE,
	0x3B3F: 0x5CF1,
	0x3B40: 0x5CF2,
	0x3B41: 0x5CF4,
	0x3B42: 0x5D01,
	0x3B43: 0x5D06,
	0x3B44: 0x5D0D,
	0x3B45: 0x5D12,
	0x3B46: 0x5D2B,
	0x3B47: 0x5D23,
	0x3B48: 0x5D24,
	0x3B49: 0x5D26,
	0x3B4A: 0x5D27,
	0x3B4B: 0x5D31,
	0x3B4C: 0x5D34,
	0x3B4D: 0x5D39,
	0x3B4E: 0x5D3D,
	0x3B4F: 0x5D3F,
	0x3B50: 0x5D42,
	0x3B51: 0x5D43,
	0x3B52: 0x5D46,
	0x3B53: 0x5D48,
	0x3B54: 0x5D55,
	0x3B55: 0x5D51,
	0x3B56: 0x5D59,
	0x3B57: 0x5D4A,
	0x3B58: 0x5D5F,
	0x3B59: 0x5D60,
	0x3B5A: 0x5D61,
	0x3B5B: 0x5D62,
	0x3B5C: 0x5D64,
	0x3B5D: 0x5D6A,
	0x3B5E: 0x5D6D,
	0x3B5F: 0x5D70,
	0x3B60: 0x5D79,
	0x3B61: 0x5D7A,
	0x3B62: 0x5D7E,
	0x3B63: 0x5D7F,
	0x3B64: 0x5D81,
	0x3B65: 0x5D83,
	0x3B66: 0x5D88,
	0x3B67: 0x5D8A,
	0x3B68: 0x5D92,
	0x3B69: 0x5D93,
	0x3B6A: 0x5D94,
	0x3B6B: 0x5D95,
	0x3B6C: 0x5D99,
	0x3B6D: 0x5D9B,
	0x3B6E: 0x5D9F,
	0x3B6F: 0x5DA0,
	0x3B70: 0x5DA7,
	0x3B71: 0x5DAB,
	0x3B72: 0x5DB0,
	0x3B73: 0x5DB4,
	0x3B74: 0x5DB8,
	0x3B75: 0x5DB9,
	0x3B76: 0x5DC3,
	0x3B77: 0x5DC7,
	0x3B78: 0x5DCB,
	0x3B79: 0x5DD0,
	0x3B7A: 0x5DCE,
	0x3B7B: 0x5DD8,
	0x3B7C: 0x5DD9,
	0x3B7D: 0x5DE0,
	0x3B7E: 0x5DE4,
	0x3C21: 0x5DE9,
	0x3C22: 0x5DF8,
	0x3C23: 0x5DF9,
	0x3C24: 0x5E00,
	0x3C25: 0x5E07,
	0x3C26: 0x5E0D,
	0x3C27: 0x5E12,
	0x3C28: 0x5E14,
	0x3C29: 0x5E15,
	0x3C2A: 0x5E18,
	0x3C2B: 0x5E1F,
	0x3C2C: 0x5E20,
	0x3C2D: 0x5E2E,
	0x3C2E: 0x5E28,
	0x3C2F: 0x5E32,
	0x3C30: 0x5E35,
	0x3C31: 0x5E3E,
	0x3C32: 0x5E4B,
	0x3C33: 0x5E50,
	0x3C34: 0x5E49,
	0x3C35: 0x5E51,
	0x3C36: 0x5E56,
	0x3C37: 0x5E58,
	0x3C38: 0x5E5B,
	0x3C39: 0x5E5C,
	0x3C3A: 0x5E5E,
	0x3C3B: 0x5E68,
	0x3C3C: 0x5E6A,
	0x3C3D: 0x5E6B,
	0x3C3E: 0x5E6C,
	0x3C3F: 0x5E6D,
	0x3C40: 0x5E6E,
	0x3C41: 0x5E70,
	0x3C42: 0x5E80,
	0x3C43: 0x5E8B,
	0x3C44: 0x5E8E,
	0x3C45: 0x5EA2,
	0x3C46: 0x5EA4,
	0x3C47: 0x5EA5,
	0x3C48: 0x5EA8,
	0x3C49: 0x5EAA,
	0x3C4A: 0x5EAC,
	0x3C4B: 0x5EB1,
	0x3C4C: 0x5EB3,
	0x3C4D: 0x5EBD,
	0x3C4E: 0x5EBE,
	0x3C4F: 0x5EBF,
	0x3C50: 0x5EC6,
	0x3C51: 0x5ECC,
	0x3C52: 0x5ECB,
	0x3C53: 0x5ECE,
	0x3C54: 0x5ED1,
	0x3C55: 0x5ED2,
	0x3C56: 0x5ED4,
	0x3C57: 0x5ED5,
	0x3C58: 0x5EDC,
	0x3C59: 0x5EDE,
	0x3C5A: 0x5EE5,
	0x3C5B: 0x5EEB,
	0x3C5C: 0x5F02,
	0x3C5D: 0x5F06,
	0x3C5E: 0x5F07,
	0x3C5F: 0x5F08,
	0x3C60: 0x5F0E,
	0x3C61: 0x5F19,
	0x3C62: 0x5F1C,
	0x3C63: 0x5F1D,
	0x3C64: 0x5F21,
	0x3C65: 0x5F22,
	0x3C66: 0x5F23,
	0x3C67: 0x5F24,
	0x3C68: 0x5F28,
	0x3C69: 0x5F2B,
	0x3C6A: 0x5F2C,
	0x3C6B: 0x5F2E,
	0x3C6C: 0x5F30,
	0x3C6D: 0x5F34,
	0x3C6E: 0x5F36,
	0x3C6F: 0x5F3B,
	0x3C70: 0x5F3D,
	0x3C71: 0x5F3F,
	0x3C72: 0x5F40,
	0x3C73: 0x5F44,
	0x3C74: 0x5F45,
	0x3C75: 0x5F47,
	0x3C76: 0x5F4D,
	0x3C77: 0x5F50,
	0x3C78: 0x5F54,
	0x3C79: 0x5F58,
	0x3C7A: 0x5F5B,
	0x3C7B: 0x5F60,
	0x3C7C: 0x5F63,
	0x3C7D: 0x5F64,
	0x3C7E: 0x5F67,
	0x3D21: 0x5F6F,
	0x3D22: 0x5F72,
	0x3D23: 0x5F74,
	0x3D24: 0x5F75,
	0x3D25: 0x5F78,
	0x3D26: 0x5F7A,
	0x3D27: 0x5F7D,
	0x3D28: 0x5F7E,
	0x3D29: 0x5F89,
	0x3D2A: 0x5F8D,
	0x3D2B: 0x5F8F,
	0x3D2C: 0x5F96,
	0x3D2D: 0x5F9C,
	0x3D2E: 0x5F9D,
	0x3D2F: 0x5FA2,
	0x3D30: 0x5FA7,
	0x3D31: 0x5FAB,
	0x3D32: 0x5FA4,
	0x3D33: 0x5FAC,
	0x3D34: 0x5FAF,
	0x3D35: 0x5FB0,
	0x3D36: 0x5FB1,
	0x3D37: 0x5FB8,
	0x3D38: 0x5FC4,
	0x3D39: 0x5FC7,
	0x3D3A: 0x5FC8,
	0x3D3B: 0x5FC9,
	0x3D3C: 0x5FCB,
	0x3D3D: 0x5FD0,
	0x3D3E: 0x5FD1,
	0x3D3F: 0x5FD2,
	0x3D40: 0x5FD3,
	0x3D41: 0x5FD4,
	0x3D42: 0x5FDE,
	0x3D43: 0x5FE1,
	0x3D44: 0x5FE2,
	0x3D45: 0x5FE8,
	0x3D46: 0x5FE9,
	0x3D47: 0x5FEA,
	0x3D48: 0x5FEC,
	0x3D49: 0x5FED,
	0x3D4A: 0x5FEE,
	0x3D4B: 0x5FEF,
	0x3D4C: 0x5FF2,
	0x3D4D: 0x5FF3,
	0x3D4E: 0x5FF6,
	0x3D4F: 0x5FFA,
	0x3D50: 0x5FFC,
	0x3D51: 0x6007,
	0x3D52: 0x600A,
	0x3D53: 0x600D,
	0x3D54: 0x6013,
	0x3D55: 0x6014,
	0x3D56: 0x6017,
	0x3D57: 0x6018,
	0x3D58: 0x601A,
	0x3D59: 0x601F,
	0x3D5A: 0x6024,
	0x3D5B: 0x602D,
	0x3D5C: 0x6033,
	0x3D5D: 0x6035,
	0x3D5E: 0x6040,
	0x3D5F: 0x6047,
	0x3D60: 0x6048,
	0x3D61: 0x6049,
	0x3D62: 0x604C,
	0x3D63: 0x6051,
	0x3D64: 0x6054,
	0x3D65: 0x6056,
	0x3D66: 0x6057,
	0x3D67: 0x605D,
	0x3D68: 0x6061,
	0x3D69: 0x6067,
	0x3D6A: 0x6071,
	0x3D6B: 0x607E,
	0x3D6C: 0x607F,
	0x3D6D: 0x6082,
	0x3D6E: 0x6086,
	0x3D6F: 0x6088,
	0x3D70: 0x608A,
	0x3D71: 0x608E,
	0x3D72: 0x6091,
	0x3D73: 0x6093,
	0x3D74: 0x6095,
	0x3D75: 0x6098,
	0x3D76: 0x609D,
	0x3D77: 0x609E,
	0x3D78: 0x60A2,
	0x3D79: 0x60A4,
	0x3D7A: 0x60A5,
	0x3D7B: 0x60A8,
	0x3D7C: 0x60B0,
	0x3D7D: 0x60B1,
	0x3D7E: 0x60B7,
	0x3E21: 0x60BB,
	0x3E22: 0x60BE,
	0x3E23: 0x60C2,
	0x3E24: 0x60C4,
	0x3E25: 0x60C8,
	0x3E26: 0x60C9,
	0x3E27: 0x60CA,
	0x3E28: 0x60CB,
	0x3E29: 0x60CE,
	0x3E2A: 0x60CF,
	0x3E2B: 0x60D4,
	0x3E2C: 0x60D5,
	0x3E2D: 0x60D9,
	0x3E2E: 0x60DB,
	0x3E2F: 0x60DD,
	0x3E30: 0x60DE,
	0x3E31: 0x60E2,
	0x3E32: 0x60E5,
	0x3E33: 0x60F2,
	0x3E34: 0x60F5,
	0x3E35: 0x60F8,
	0x3E36: 0x60FC,
	0x3E37: 0x60FD,
	0x3E38: 0x6102,
	0x3E39: 0x6107,
	0x3E3A: 0x610A,
	0x3E3B: 0x610C,
	0x3E3C: 0x6110,
	0x3E3D: 0x6111,
	0x3E3E: 0x6112,
	0x3E3F: 0x6113,
	0x3E40: 0x6114,
	0x3E41: 0x6116,
	0x3E42: 0x6117,
	0x3E43: 0x6119,
	0x3E44: 0x611C,
	0x3E45: 0x611E,
	0x3E46: 0x6122,
	0x3E47: 0x612A,
	0x3E48: 0x612B,
	0x3E49: 0x6130,
	0x3E4A: 0x6131,
	0x3E4B: 0x6135,
	0x3E4C: 0x6136,
	0x3E4D: 0x6137,
	0x3E4E: 0x6139,
	0x3E4F: 0x6141,
	0x3E50: 0x6145,
	0x3E51: 0x6146,
	0x3E52: 0x6149,
	0x3E53: 0x615E,
	0x3E54: 0x6160,
	0x3E55: 0x616C,
	0x3E56: 0x6172,
	0x3E57: 0x6178,
	0x3E58: 0x617B,
	0x3E59: 0x617C,
	0x3E5A: 0x617F,
	0x3E5B: 0x6180,
	0x3E5C: 0x6181,
	0x3E5D: 0x6183,
	0x3E5E: 0x6184,
	0x3E5F: 0x618B,
	0x3E60: 0x618D,
	0x3E61: 0x6192,
	0x3E62: 0x6193,
	0x3E63: 0x6197,
	0x3E64: 0x6198,
	0x3E65: 0x619C,
	0x3E66: 0x619D,
	0x3E67: 0x619F,
	0x3E68: 0x61A0,
	0x3E69: 0x61A5,
	0x3E6A: 0x61A8,
	0x3E6B: 0x61AA,
	0x3E6C: 0x61AD,
	0x3E6D: 0x61B8,
	0x3E6E: 0x61B9,
	0x3E6F: 0x61BC,
	0x3E70: 0x61C0,
	0x3E71: 0x61C1,
	0x3E72: 0x61C2,
	0x3E73: 0x61CE,
	0x3E74: 0x61CF,
	0x3E75: 0x61D5,
	0x3E76: 0x61DC,
	0x3E77: 0x61DD,
	0x3E78: 0x61DE,
	0x3E79: 0x61DF,
	0x3E7A: 0x61E1,
	0x3E7B: 0x61E2,
	0x3E7C: 0x61E7,
	0x3E7D: 0x61E9,
	0x3E7E: 0x61E5,
	0x3F21: 0x61EC,
	0x3F22: 0x61ED,
	0x3F23: 0x61EF,
	0x3F24: 0x6201,
	0x3F25: 0x6203,
	0x3F26: 0x6204,
	0x3F27: 0x6207,
	0x3F28: 0x6213,
	0x3F29: 0x6215,
	0x3F2A: 0x621C,
	0x3F2B: 0x6220,
	0x3F2C: 0x6222,
	0x3F2D: 0x6223,
	0x3F2E: 0x6227,
	0x3F2F: 0x6229,
	0x3F30: 0x622B,
	0x3F31: 0x6239,
	0x3F32: 0x623D,
	0x3F33: 0x6242,
	0x3F34: 0x6243,
	0x3F35: 0x6244,
	0x3F36: 0x6246,
	0x3F37: 0x624C,
	0x3F38: 0x6250,
	0x3F39: 0x6251,
	0x3F3A: 0x6252,
	0x3F3B: 0x6254,
	0x3F3C: 0x6256,
	0x3F3D: 0x625A,
	0x3F3E: 0x625C,
	0x3F3F: 0x6264,
	0x3F40: 0x626D,
	0x3F41: 0x626F,
	0x3F42: 0x6273,
	0x3F43: 0x627A,
	0x3F44: 0x627D,
	0x3F45: 0x628D,
	0x3F46: 0x628E,
	0x3F47: 0x628F,
	0x3F48: 0x6290,
	0x3F49: 0x62A6,
	0x3F4A: 0x62A8,
	0x3F4B: 0x62B3,
	0x3F4C: 0x62B6,
	0x3F4D: 0x62B7,
	0x3F4E: 0x62BA,
	0x3F4F: 0x62BE,
	0x3F50: 0x62BF,
	0x3F51: 0x62C4,
	0x3F52: 0x62CE,
	0x3F53: 0x62D5,
	0x3F54: 0x62D6,
	0x3F55: 0x62DA,
	0x3F56: 0x62EA,
	0x3F57: 0x62F2,
	0x3F58: 0x62F4,
	0x3F59: 0x62FC,
	0x3F5A: 0x62FD,
	0x3F5B: 0x6303,
	0x3F5C: 0x6304,
	0x3F5D: 0x630A,
	0x3F5E: 0x630B,
	0x3F5F: 0x630D,
	0x3F60: 0x6310,
	0x3F61: 0x6313,
	0x3F62: 0x6316,
	0x3F63: 0x6318,
	0x3F64: 0x6329,
	0x3F65: 0x632A,
	0x3F66: 0x632D,
	0x3F67: 0x6335,
	0x3F68: 0x6336,
	0x3F69: 0x6339,
	0x3F6A: 0x633C,
	0x3F6B: 0x6341,
	0x3F6C: 0x6342,
	0x3F6D: 0x6343,
	0x3F6E: 0x6344,
	0x3F6F: 0x6346,
	0x3F70: 0x634A,
	0x3F71: 0x634B,
	0x3F72: 0x634E,
	0x3F73: 0x6352,
	0x3F74: 0x6353,
	0x3F75: 0x6354,
	0x3F76: 0x6358,
	0x3F77: 0x635B,
	0x3F78: 0x6365,
	0x3F79: 0x6366,
	0x3F7A: 0x636C,
	0x3F7B: 0x636D,
	0x3F7C: 0x6371,
	0x3F7D: 0x6374,
	0x3F7E: 0x6375,
	0x4021: 0x6378,
	0x4022: 0x637C,
	0x4023: 0x637D,
	0x4024: 0x637F,
	0x4025: 0x6382,
	0x4026: 0x6384,
	0x4027: 0x6387,
	0x4028: 0x638A,
	0x4029: 0x6390,
	0x402A: 0x6394,
	0x402B: 0x6395,
	0x402C: 0x6399,
	0x402D: 0x639A,
	0x402E: 0x639E,
	0x402F: 0x63A4,
	0x4030: 0x63A6,
	0x4031: 0x63AD,
	0x4032: 0x63AE,
	0x4033: 0x63AF,
	0x4034: 0x63BD,
	0x4035: 0x63C1,
	0x4036: 0x63C5,
	0x4037: 0x63C8,
	0x4038: 0x63CE,
	0x4039: 0x63D1,
	0x403A: 0x63D3,
	0x403B: 0x63D4,
	0x403C: 0x63D5,
	0x403D: 0x63DC,
	0x403E: 0x63E0,
	0x403F: 0x63E5,
	0x4040: 0x63EA,
	0x4041: 0x63EC,
	0x4042: 0x63F2,
	0x4043: 0x63F3,
	0x4044: 0x63F5,
	0x4045: 0x63F8,
	0x4046: 0x63F9,
	0x4047: 0x6409,
	0x4048: 0x640A,
	0x4049: 0x6410,
	0x404A: 0x6412,
	0x404B: 0x6414,
	0x404C: 0x6418,
	0x404D: 0x641E,
	0x404E: 0x6420,
	0x404F: 0x6422,
	0x4050: 0x6424,
	0x4051: 0x6425,
	0x4052: 0x6429,
	0x4053: 0x642A,
	0x4054: 0x642F,
	0x4055: 0x6430,
	0x4056: 0x6435,
	0x4057: 0x643D,
	0x4058: 0x643F,
	0x4059: 0x644B,
	0x405A: 0x644F,
	0x405B: 0x6451,
	0x405C: 0x6452,
	0x405D: 0x6453,
	0x405E: 0x6454,
	0x405F: 0x645A,
	0x4060: 0x645B,
	0x4061: 0x645C,
	0x4062: 0x645D,
	0x4063: 0x645F,
	0x4064: 0x6460,
	0x4065: 0x6461,
	0x4066: 0x6463,
	0x4067: 0x646D,
	0x4068: 0x6473,
	0x4069: 0x6474,
	0x406A: 0x647B,
	0x406B: 0x647D,
	0x406C: 0x6485,
	0x406D: 0x6487,
	0x406E: 0x648F,
	0x406F: 0x6490,
	0x4070: 0x6491,
	0x4071: 0x6498,
	0x4072: 0x6499,
	0x4073: 0x649B,
	0x4074: 0x649D,
	0x4075: 0x649F,
	0x4076: 0x64A1,
	0x4077: 0x64A3,
	0x4078: 0x64A6,
	0x4079: 0x64A8,
	0x407A: 0x64AC,
	0x407B: 0x64B3,
	0x407C: 0x64BD,
	0x407D: 0x64BE,
	0x407E: 0x64BF,
	0x4121: 0x64C4,
	0x4122: 0x64C9,
	0x4123: 0x64CA,
	0x4124: 0x64CB,
	0x4125: 0x64CC,
	0x4126: 0x64CE,
	0x4127: 0x64D0,
	0x4128: 0x64D1,
	0x4129: 0x64D5,
	0x412A: 0x64D7,
	0x412B: 0x64E4,
	0x412C: 0x64E5,
	0x412D: 0x64E9,
	0x412E: 0x64EA,
	0x412F: 0x64ED,
	0x4130: 0x64F0,
	0x4131: 0x64F5,
	0x4132: 0x64F7,
	0x4133: 0x64FB,
	0x4134: 0x64FF,
	0x4135: 0x6501,
	0x4136: 0x6504,
	0x4137: 0x6508,
	0x4138: 0x6509,
	0x4139: 0x650A,
	0x413A: 0x650F,
	0x413B: 0x6513,
	0x413C: 0x6514,
	0x413D: 0x6516,
	0x413E: 0x6519,
	0x413F: 0x651B,
	0x4140: 0x651E,
	0x4141: 0x651F,
	0x4142: 0x6522,
	0x4143: 0x6526,
	0x4144: 0x6529,
	0x4145: 0x652E,
	0x4146: 0x6531,
	0x4147: 0x653A,
	0x4148: 0x653C,
	0x4149: 0x653D,
	0x414A: 0x6543,
	0x414B: 0x6547,
	0x414C: 0x6549,
	0x414D: 0x6550,
	0x414E: 0x6552,
	0x414F: 0x6554,
	0x4150: 0x655F,
	0x4151: 0x6560,
	0x4152: 0x6567,
	0x4153: 0x656B,
	0x4154: 0x657A,
	0x4155: 0x657D,
	0x4156: 0x6581,
	0x4157: 0x6585,
	0x4158: 0x658A,
	0x4159: 0x6592,
	0x415A: 0x6595,
	0x415B: 0x6598,
	0x415C: 0x659D,
	0x415D: 0x65A0,
	0x415E: 0x65A3,
	0x415F: 0x65A6,
	0x4160: 0x65AE,
	0x4161: 0x65B2,
	0x4162: 0x65B3,
	0x4163: 0x65B4,
	0x4164: 0x65BF,
	0x4165: 0x65C2,
	0x4166: 0x65C8,
	0x4167: 0x65C9,
	0x4168: 0x65CE,
	0x4169: 0x65D0,
	0x416A: 0x65D4,
	0x416B: 0x65D6,
	0x416C: 0x65D8,
	0x416D: 0x65DF,
	0x416E: 0x65F0,
	0x416F: 0x65F2,
	0x4170: 0x65F4,
	0x4171: 0x65F5,
	0x4172: 0x65F9,
	0x4173: 0x65FE,
	0x4174: 0x65FF,
	0x4175: 0x6600,
	0x4176: 0x6604,
	0x4177: 0x6608,
	0x4178: 0x6609,
	0x4179: 0x660D,
	0x417A: 0x6611,
	0x417B: 0x6612,
	0x417C: 0x6615,
	0x417D: 0x6616,
	0x417E: 0x661D,
	0x4221: 0x661E,
	0x4222: 0x6621,
	0x4223: 0x6622,
	0x4224: 0x6623,
	0x4225: 0x6624,
	0x4226: 0x6626,
	0x4227: 0x6629,
	0x4228: 0x662A,
	0x4229: 0x662B,
	0x422A: 0x662C,
	0x422B: 0x662E,
	0x422C: 0x6630,
	0x422D: 0x6631,
	0x422E: 0x6633,
	0x422F: 0x6639,
	0x4230: 0x6637,
	0x4231: 0x6640,
	0x4232: 0x6645,
	0x4233: 0x6646,
	0x4234: 0x664A,
	0x4235: 0x664C,
	0x4236: 0x6651,
	0x4237: 0x664E,
	0x4238: 0x6657,
	0x4239: 0x6658,
	0x423A: 0x6659,
	0x423B: 0x665B,
	0x423C: 0x665C,
	0x423D: 0x6660,
	0x423E: 0x6661,
	0x423F: 0x66FB,
	0x4240: 0x666A,
	0x4241: 0x666B,
	0x4242: 0x666C,
	0x4243: 0x667E,
	0x4244: 0x6673,
	0x4245: 0x6675,
	0x4246: 0x667F,
	0x4247: 0x6677,
	0x4248: 0x6678,
	0x4249: 0x6679,
	0x424A: 0x667B,
	0x424B: 0x6680,
	0x424C: 0x667C,
	0x424D: 0x668B,
	0x424E: 0x668C,
	0x424F: 0x668D,
	0x4250: 0x6690,
	0x4251: 0x6692,
	0x4252: 0x6699,
	0x4253: 0x669A,
	0x4254: 0x669B,
	0x4255: 0x669C,
	0x4256: 0x669F,
	0x4257: 0x66A0,
	0x4258: 0x66A4,
	0x4259: 0x66AD,
	0x425A: 0x66B1,
	0x425B: 0x66B2,
	0x425C: 0x66B5,
	0x425D: 0x66BB,
	0x425E: 0x66BF,
	0x425F: 0x66C0,
	0x4260: 0x66C2,
	0x4261: 0x66C3,
	0x4262: 0x66C8,
	0x4263: 0x66CC,
	0x4264: 0x66CE,
	0x4265: 0x66CF,
	0x4266: 0x66D4,
	0x4267: 0x66DB,
	0x4268: 0x66DF,
	0x4269: 0x66E8,
	0x426A: 0x66EB,
	0x426B: 0x66EC,
	0x426C: 0x66EE,
	0x426D: 0x66FA,
	0x426E: 0x6705,
	0x426F: 0x6707,
	0x4270: 0x670E,
	0x4271: 0x6713,
	0x4272: 0x6719,
	0x4273: 0x671C,
	0x4274: 0x6720,
	0x4275: 0x6722,
	0x4276: 0x6733,
	0x4277: 0x673E,
	0x4278: 0x6745,
	0x4279: 0x6747,
	0x427A: 0x6748,
	0x427B: 0x674C,
	0x427C: 0x6754,
	0x427D: 0x6755,
	0x427E: 0x675D,
	0x4321: 0x6766,
	0x4322: 0x676C,
	0x4323: 0x676E,
	0x4324: 0x6774,
	0x4325: 0x6776,
	0x4326: 0x677B,
	0x4327: 0x6781,
	0x4328: 0x6784,
	0x4329: 0x678E,
	0x432A: 0x678F,
	0x432B: 0x6791,
	0x432C: 0x6793,
	0x432D: 0x6796,
	0x432E: 0x6798,
	0x432F: 0x6799,
	0x4330: 0x679B,
	0x4331: 0x67B0,
	0x4332: 0x67B1,
	0x4333: 0x67B2,
	0x4334: 0x67B5,
	0x4335: 0x67BB,
	0x4336: 0x67BC,
	0x4337: 0x67BD,
	0x4338: 0x67F9,
	0x4339: 0x67C0,
	0x433A: 0x67C2,
	0x433B: 0x67C3,
	0x433C: 0x67C5,
	0x433D: 0x67C8,
	0x433E: 0x67C9,
	0x433F: 0x67D2,
	0x4340: 0x67D7,
	0x4341: 0x67D9,
	0x4342: 0x67DC,
	0x4343: 0x67E1,
	0x4344: 0x67E6,
	0x4345: 0x67F0,
	0x4346: 0x67F2,
	0x4347: 0x67F6,
	0x4348: 0x67F7,
	0x4349: 0x6852,
	0x434A: 0x6814,
	0x434B: 0x6819,
	0x434C: 0x681D,
	0x434D: 0x681F,
	0x434E: 0x6828,
	0x434F: 0x6827,
	0x4350: 0x682C,
	0x4351: 0x682D,
	0x4352: 0x682F,
	0x4353: 0x6830,
	0x4354: 0x6831,
	0x4355: 0x6833,
	0x4356: 0x683B,
	0x4357: 0x683F,
	0x4358: 0x6844,
	0x4359: 0x6845,
	0x435A: 0x684A,
	0x435B: 0x684C,
	0x435C: 0x6855,
	0x435D: 0x6857,
	0x435E: 0x6858,
	0x435F: 0x685B,
	0x4360: 0x686B,
	0x4361: 0x686E,
	0x4362: 0x686F,
	0x4363: 0x6870,
	0x4364: 0x6871,
	0x4365: 0x6872,
	0x4366: 0x6875,
	0x4367: 0x6879,
	0x4368: 0x687A,
	0x4369: 0x687B,
	0x436A: 0x687C,
	0x436B: 0x6882,
	0x436C: 0x6884,
	0x436D: 0x6886,
	0x436E: 0x6888,
	0x436F: 0x6896,
	0x4370: 0x6898,
	0x4371: 0x689A,
	0x4372: 0x689C,
	0x4373: 0x68A1,
	0x4374: 0x68A3,
	0x4375: 0x68A5,
	0x4376: 0x68A9,
	0x4377: 0x68AA,
	0x4378: 0x68AE,
	0x4379: 0x68B2,
	0x437A: 0x68BB,
	0x437B: 0x68C5,
	0x437C: 0x68C8,
	0x437D: 0x68CC,
	0x437E: 0x68CF,
	0x4421: 0x68D0,
	0x4422: 0x68D1,
	0x4423: 0x68D3,
	0x4424: 0x68D6,
	0x4425: 0x68D9,
	0x4426: 0x68DC,
	0x4427: 0x68DD,
	0x4428: 0x68E5,
	0x4429: 0x68E8,
	0x442A: 0x68EA,
	0x442B: 0x68EB,
	0x442C: 0x68EC,
	0x442D: 0x68ED,
	0x442E: 0x68F0,
	0x442F: 0x68F1,
	0x4430: 0x68F5,
	0x4431: 0x68F6,
	0x4432: 0x68FB,
	0x4433: 0x68FC,
	0x4434: 0x68FD,
	0x4435: 0x6906,
	0x4436: 0x6909,
	0x4437: 0x690A,
	0x4438: 0x6910,
	0x4439: 0x6911,
	0x443A: 0x6913,
	0x443B: 0x6916,
	0x443C: 0x6917,
	0x443D: 0x6931,
	0x443E: 0x6933,
	0x443F: 0x6935,
	0x4440: 0x6938,
	0x4441: 0x693B,
	0x4442: 0x6942,
	0x4443: 0x6945,
	0x4444: 0x6949,
	0x4445: 0x694E,
	0x4446: 0x6957,
	0x4447: 0x695B,
	0x4448: 0x6963,
	0x4449: 0x6964,
	0x444A: 0x6965,
	0x444B: 0x6966,
	0x444C: 0x6968,
	0x444D: 0x6969,
	0x444E: 0x696C,
	0x444F: 0x6970,
	0x4450: 0x6971,
	0x4451: 0x6972,
	0x4452: 0x697A,
	0x4453: 0x697B,
	0x4454: 0x697F,
	0x4455: 0x6980,
	0x4456: 0x698D,
	0x4457: 0x6992,
	0x4458: 0x6996,
	0x4459: 0x6998,
	0x445A: 0x69A1,
	0x445B: 0x69A5,
	0x445C: 0x69A6,
	0x445D: 0x69A8,
	0x445E: 0x69AB,
	0x445F: 0x69AD,
	0x4460: 0x69AF,
	0x4461: 0x69B7,
	0x4462: 0x69B8,
	0x4463: 0x69BA,
	0x4464: 0x69BC,
	0x4465: 0x69C5,
	0x4466: 0x69C8,
	0x4467: 0x69D1,
	0x4468: 0x69D6,
	0x4469: 0x69D7,
	0x446A: 0x69E2,
	0x446B: 0x69E5,
	0x446C: 0x69EE,
	0x446D: 0x69EF,
	0x446E: 0x69F1,
	0x446F: 0x69F3,
	0x4470: 0x69F5,
	0x4471: 0x69FE,
	0x4472: 0x6A00,
	0x4473: 0x6A01,
	0x4474: 0x6A03,
	0x4475: 0x6A0F,
	0x4476: 0x6A11,
	0x4477: 0x6A15,
	0x4478: 0x6A1A,
	0x4479: 0x6A1D,
	0x447A: 0x6A20,
	0x447B: 0x6A24,
	0x447C: 0x6A28,
	0x447D: 0x6A30,
	0x447E: 0x6A32,
	0x4521: 0x6A34,
	0x4522: 0x6A37,
	0x4523: 0x6A3B,
	0x4524: 0x6A3E,
	0x4525: 0x6A3F,
	0x4526: 0x6A45,
	0x4527: 0x6A46,
	0x4528: 0x6A49,
	0x4529: 0x6A4A,
	0x452A: 0x6A4E,
	0x452B: 0x6A50,
	0x452C: 0x6A51,
	0x452D: 0x6A52,
	0x452E: 0x6A55,
	0x452F: 0x6A56,
	0x4530: 0x6A5B,
	0x4531: 0x6A64,
	0x4532: 0x6A67,
	0x4533: 0x6A6A,
	0x4534: 0x6A71,
	0x4535: 0x6A73,
	0x4536: 0x6A7E,
	0x4537: 0x6A81,
	0x4538: 0x6A83,
	0x4539: 0x6A86,
	0x453A: 0x6A87,
	0x453B: 0x6A89,
	0x453C: 0x6A8B,
	0x453D: 0x6A91,
	0x453E: 0x6A9B,
	0x453F: 0x6A9D,
	0x4540: 0x6A9E,
	0x4541: 0x6A9F,
	0x4542: 0x6AA5,
	0x4543: 0x6AAB,
	0x4544: 0x6AAF,
	0x4545: 0x6AB0,
	0x4546: 0x6AB1,
	0x4547: 0x6AB4,
	0x4548: 0x6ABD,
	0x4549: 0x6ABE,
	0x454A: 0x6ABF,
	0x454B: 0x6AC6,
	0x454C: 0x6AC9,
	0x454D: 0x6AC8,
	0x454E: 0x6ACC,
	0x454F: 0x6AD0,
	0x4550: 0x6AD4,
	0x4551: 0x6AD5,
	0x4552: 0x6AD6,
	0x4553: 0x6ADC,
	0x4554: 0x6ADD,
	0x4555: 0x6AE4,
	0x4556: 0x6AE7,
	0x4557: 0x6AEC,
	0x4558: 0x6AF0,
	0x4559: 0x6AF1,
	0x455A: 0x6AF2,
	0x455B: 0x6AFC,
	0x455C: 0x6AFD,
	0x455D: 0x6B02,
	0x455E: 0x6B03,
	0x455F: 0x6B06,
	0x4560: 0x6B07,
	0x4561: 0x6B09,
	0x4562: 0x6B0F,
	0x4563: 0x6B10,
	0x4564: 0x6B11,
	0x4565: 0x6B17,
	0x4566: 0x6B1B,
	0x4567: 0x6B1E,
	0x4568: 0x6B24,
	0x4569: 0x6B28,
	0x456A: 0x6B2B,
	0x456B: 0x6B2C,
	0x456C: 0x6B2F,
	0x456D: 0x6B35,
	0x456E: 0x6B36,
	0x456F: 0x6B3B,
	0x4570: 0x6B3F,
	0x4571: 0x6B46,
	0x4572: 0x6B4A,
	0x4573: 0x6B4D,
	0x4574: 0x6B52,
	0x4575: 0x6B56,
	0x4576: 0x6B58,
	0x4577: 0x6B5D,
	0x4578: 0x6B60,
	0x4579: 0x6B67,
	0x457A: 0x6B6B,
	0x457B: 0x6B6E,
	0x457C: 0x6B70,
	0x457D: 0x6B75,
	0x457E: 0x6B7D,
	0x4621: 0x6B7E,
	0x4622: 0x6B82,
	0x4623: 0x6B85,
	0x4624: 0x6B97,
	0x4625: 0x6B9B,
	0x4626: 0x6B9F,
	0x4627: 0x6BA0,
	0x4628: 0x6BA2,
	0x4629: 0x6BA3,
	0x462A: 0x6BA8,
	0x462B: 0x6BA9,
	0x462C: 0x6BAC,
	0x462D: 0x6BAD,
	0x462E: 0x6BAE,
	0x462F: 0x6BB0,
	0x4630: 0x6BB8,
	0x4631: 0x6BB9,
	0x4632: 0x6BBD,
	0x4633: 0x6BBE,
	0x4634: 0x6BC3,
	0x4635: 0x6BC4,
	0x4636: 0x6BC9,
	0x4637: 0x6BCC,
	0x4638: 0x6BD6,
	0x4639: 0x6BDA,
	0x463A: 0x6BE1,
	0x463B: 0x6BE3,
	0x463C: 0x6BE6,
	0x463D: 0x6BE7,
	0x463E: 0x6BEE,
	0x463F: 0x6BF1,
	0x4640: 0x6BF7,
	0x4641: 0x6BF9,
	0x4642: 0x6BFF,
	0x4643: 0x6C02,
	0x4644: 0x6C04,
	0x4645: 0x6C05,
	0x4646: 0x6C09,
	0x4647: 0x6C0D,
	0x4648: 0x6C0E,
	0x4649: 0x6C10,
	0x464A: 0x6C12,
	0x464B: 0x6C19,
	0x464C: 0x6C1F,
	0x464D: 0x6C26,
	0x464E: 0x6C27,
	0x464F: 0x6C28,
	0x4650: 0x6C2C,
	0x4651: 0x6C2E,
	0x4652: 0x6C33,
	0x4653: 0x6C35,
	0x4654: 0x6C36,
	0x4655: 0x6C3A,
	0x4656: 0x6C3B,
	0x4657: 0x6C3F,
	0x4658: 0x6C4A,
	0x4659: 0x6C4B,
	0x465A: 0x6C4D,
	0x465B: 0x6C4F,
	0x465C: 0x6C52,
	0x465D: 0x6C54,
	0x465E: 0x6C59,
	0x465F: 0x6C5B,
	0x4660: 0x6C5C,
	0x4661: 0x6C6B,
	0x4662: 0x6C6D,
	0x4663: 0x6C6F,
	0x4664: 0x6C74,
	0x4665: 0x6C76,
	0x4666: 0x6C78,
	0x4667: 0x6C79,
	0x4668: 0x6C7B,
	0x4669: 0x6C85,
	0x466A: 0x6C86,
	0x466B: 0x6C87,
	0x466C: 0x6C89,
	0x466D: 0x6C94,
	0x466E: 0x6C95,
	0x466F: 0x6C97,
	0x4670: 0x6C98,
	0x4671: 0x6C9C,
	0x4672: 0x6C9F,
	0x4673: 0x6CB0,
	0x4674: 0x6CB2,
	0x4675: 0x6CB4,
	0x4676: 0x6CC2,
	0x4677: 0x6CC6,
	0x4678: 0x6CCD,
	0x4679: 0x6CCF,
	0x467A: 0x6CD0,
	0x467B: 0x6CD1,
	0x467C: 0x6CD2,
	0x467D: 0x6CD4,
	0x467E: 0x6CD6,
	0x4721: 0x6CDA,
	0x4722: 0x6CDC,
	0x4723: 0x6CE0,
	0x4724: 0x6CE7,
	0x4725: 0x6CE9,
	0x4726: 0x6CEB,
	0x4727: 0x6CEC,
	0x4728: 0x6CEE,
	0x4729: 0x6CF2,
	0x472A: 0x6CF4,
	0x472B: 0x6D04,
	0x472C: 0x6D07,
	0x472D: 0x6D0A,
	0x472E: 0x6D0E,
	0x472F: 0x6D0F,
	0x4730: 0x6D11,
	0x4731: 0x6D13,
	0x4732: 0x6D1A,
	0x4733: 0x6D26,
	0x4734: 0x6D27,
	0x4735: 0x6D28,
	0x4736: 0x6C67,
	0x4737: 0x6D2E,
	0x4738: 0x6D2F,
	0x4739: 0x6D31,
	0x473A: 0x6D39,
	0x473B: 0x6D3C,
	0x473C: 0x6D3F,
	0x473D: 0x6D57,
	0x473E: 0x6D5E,
	0x473F: 0x6D5F,
	0x4740: 0x6D61,
	0x4741: 0x6D65,
	0x4742: 0x6D67,
	0x4743: 0x6D6F,
	0x4744: 0x6D70,
	0x4745: 0x6D7C,
	0x4746: 0x6D82,
	0x4747: 0x6D87,
	0x4748: 0x6D91,
	0x4749: 0x6D92,
	0x474A: 0x6D94,
	0x474B: 0x6D96,
	0x474C: 0x6D97,
	0x474D: 0x6D98,
	0x474E: 0x6DAA,
	0x474F: 0x6DAC,
	0x4750: 0x6DB4,
	0x4751: 0x6DB7,
	0x4752: 0x6DB9,
	0x4753: 0x6DBD,
	0x4754: 0x6DBF,
	0x4755: 0x6DC4,
	0x4756: 0x6DC8,
	0x4757: 0x6DCA,
	0x4758: 0x6DCE,
	0x4759: 0x6DCF,
	0x475A: 0x6DD6,
	0x475B: 0x6DDB,
	0x475C: 0x6DDD,
	0x475D: 0x6DDF,
	0x475E: 0x6DE0,
	0x475F: 0x6DE2,
	0x4760: 0x6DE5,
	0x4761: 0x6DE9,
	0x4762: 0x6DEF,
	0x4763: 0x6DF0,
	0x4764: 0x6DF4,
	0x4765: 0x6DF6,
	0x4766: 0x6DFC,
	0x4767: 0x6E00,
	0x4768: 0x6E04,
	0x4769: 0x6E1E,
	0x476A: 0x6E22,
	0x476B: 0x6E27,
	0x476C: 0x6E32,
	0x476D: 0x6E36,
	0x476E: 0x6E39,
	0x476F: 0x6E3B,
	0x4770: 0x6E3C,
	0x4771: 0x6E44,
	0x4772: 0x6E45,
	0x4773: 0x6E48,
	0x4774: 0x6E49,
	0x4775: 0x6E4B,
	0x4776: 0x6E4F,
	0x4777: 0x6E51,
	0x4778: 0x6E52,
	0x4779: 0x6E53,
	0x477A: 0x6E54,
	0x477B: 0x6E57,
	0x477C: 0x6E5C,
	0x477D: 0x6E5D,
	0x477E: 0x6E5E,
	0x4821: 0x6E62,
	0x4822: 0x6E63,
	0x4823: 0x6E68,
	0x4824: 0x6E73,
	0x4825: 0x6E7B,
	0x4826: 0x6E7D,
	0x4827: 0x6E8D,
	0x4828: 0x6E93,
	0x4829: 0x6E99,
	0x482A: 0x6EA0,
	0x482B: 0x6EA7,
	0x482C: 0x6EAD,
	0x482D: 0x6EAE,
	0x482E: 0x6EB1,
	0x482F: 0x6EB3,
	0x4830: 0x6EBB,
	0x4831: 0x6EBF,
	0x4832: 0x6EC0,
	0x4833: 0x6EC1,
	0x4834: 0x6EC3,
	0x4835: 0x6EC7,
	0x4836: 0x6EC8,
	0x4837: 0x6ECA,
	0x4838: 0x6ECD,
	0x4839: 0x6ECE,
	0x483A: 0x6ECF,
	0x483B: 0x6EEB,
	0x483C: 0x6EED,
	0x483D: 0x6EEE,
	0x483E: 0x6EF9,
	0x483F: 0x6EFB,
	0x4840: 0x6EFD,
	0x4841: 0x6F04,
	0x4842: 0x6F08,
	0x4843: 0x6F0A,
	0x4844: 0x6F0C,
	0x4845: 0x6F0D,
	0x4846: 0x6F16,
	0x4847: 0x6F18,
	0x4848: 0x6F1A,
	0x4849: 0x6F1B,
	0x484A: 0x6F26,
	0x484B: 0x6F29,
	0x484C: 0x6F2A,
	0x484D: 0x6F2F,
	0x484E: 0x6F30,
	0x484F: 0x6F33,
	0x4850: 0x6F36,
	0x4851: 0x6F3B,
	0x4852: 0x6F3C,
	0x4853: 0x6F2D,
	0x4854: 0x6F4F,
	0x4855: 0x6F51,
	0x4856: 0x6F52,
	0x4857: 0x6F53,
	0x4858: 0x6F57,
	0x4859: 0x6F59,
	0x485A: 0x6F5A,
	0x485B: 0x6F5D,
	0x485C: 0x6F5E,
	0x485D: 0x6F61,
	0x485E: 0x6F62,
	0x485F: 0x6F68,
	0x4860: 0x6F6C,
	0x4861: 0x6F7D,
	0x4862: 0x6F7E,
	0x4863: 0x6F83,
	0x4864: 0x6F87,
	0x4865: 0x6F88,
	0x4866: 0x6F8B,
	0x4867: 0x6F8C,
	0x4868: 0x6F8D,
	0x4869: 0x6F90,
	0x486A: 0x6F92,
	0x486B: 0x6F93,
	0x486C: 0x6F94,
	0x486D: 0x6F96,
	0x486E: 0x6F9A,
	0x486F: 0x6F9F,
	0x4870: 0x6FA0,
	0x4871: 0x6FA5,
	0x4872: 0x6FA6,
	0x4873: 0x6FA7,
	0x4874: 0x6FA8,
	0x4875: 0x6FAE,
	0x4876: 0x6FAF,
	0x4877: 0x6FB0,
	0x4878: 0x6FB5,
	0x4879: 0x6FB6,
	0x487A: 0x6FBC,
	0x487B: 0x6FC5,
	0x487C: 0x6FC7,
	0x487D: 0x6FC8,
	0x487E: 0x6FCA,
	0x4921: 0x6FDA,
	0x4922: 0x6FDE,
	0x4923: 0x6FE8,
	0x4924: 0x6FE9,
	0x4925: 0x6FF0,
	0x4926: 0x6FF5,
	0x4927: 0x6FF9,
	0x4928: 0x6FFC,
	0x4929: 0x6FFD,
	0x492A: 0x7000,
	0x492B: 0x7005,
	0x492C: 0x7006,
	0x492D: 0x7007,
	0x492E: 0x700D,
	0x492F: 0x7017,
	0x4930: 0x7020,
	0x4931: 0x7023,
	0x4932: 0x702F,
	0x4933: 0x7034,
	0x4934: 0x7037,
	0x4935: 0x7039,
	0x4936: 0x703C,
	0x4937: 0x7043,
	0x4938: 0x7044,
	0x4939: 0x7048,
	0x493A: 0x7049,
	0x493B: 0x704A,
	0x493C: 0x704B,
	0x493D: 0x7054,
	0x493E: 0x7055,
	0x493F: 0x705D,
	0x4940: 0x705E,
	0x4941: 0x704E,
	0x4942: 0x7064,
	0x4943: 0x7065,
	0x4944: 0x706C,
	0x4945: 0x706E,
	0x4946: 0x7075,
	0x4947: 0x7076,
	0x4948: 0x707E,
	0x4949: 0x7081,
	0x494A: 0x7085,
	0x494B: 0x7086,
	0x494C: 0x7094,
	0x494D: 0x7095,
	0x494E: 0x7096,
	0x494F: 0x7097,
	0x4950: 0x7098,
	0x4951: 0x709B,
	0x4952: 0x70A4,
	0x4953: 0x70AB,
	0x4954: 0x70B0,
	0x4955: 0x70B1,
	0x4956: 0x70B4,
	0x4957: 0x70B7,
	0x4958: 0x70CA,
	0x4959: 0x70D1,
	0x495A: 0x70D3,
	0x495B: 0x70D4,
	0x495C: 0x70D5,
	0x495D: 0x70D6,
	0x495E: 0x70D8,
	0x495F: 0x70DC,
	0x4960: 0x70E4,
	0x4961: 0x70FA,
	0x4962: 0x7103,
	0x4963: 0x7104,
	0x4964: 0x7105,
	0x4965: 0x7106,
	0x4966: 0x7107,
	0x4967: 0x710B,
	0x4968: 0x710C,
	0x4969: 0x710F,
	0x496A: 0x711E,
	0x496B: 0x7120,
	0x496C: 0x712B,
	0x496D: 0x712D,
	0x496E: 0x712F,
	0x496F: 0x7130,
	0x4970: 0x7131,
	0x4971: 0x7138,
	0x4972: 0x7141,
	0x4973: 0x7145,
	0x4974: 0x7146,
	0x4975: 0x7147,
	0x4976: 0x714A,
	0x4977: 0x714B,
	0x4978: 0x7150,
	0x4979: 0x7152,
	0x497A: 0x7157,
	0x497B: 0x715A,
	0x497C: 0x715C,
	0x497D: 0x715E,
	0x497E: 0x7160,
	0x4A21: 0x7168,
	0x4A22: 0x7179,
	0x4A23: 0x7180,
	0x4A24: 0x7185,
	0x4A25: 0x7187,
	0x4A26: 0x718C,
	0x4A27: 0x7192,
	0x4A28: 0x719A,
	0x4A29: 0x719B,
	0x4A2A: 0x71A0,
	0x4A2B: 0x71A2,
	0x4A2C: 0x71AF,
	0x4A2D: 0x71B0,
	0x4A2E: 0x71B2,
	0x4A2F: 0x71B3,
	0x4A30: 0x71BA,
	0x4A31: 0x71BF,
	0x4A32: 0x71C0,
	0x4A33: 0x71C1,
	0x4A34: 0x71C4,
	0x4A35: 0x71CB,
	0x4A36: 0x71CC,
	0x4A37: 0x71D3,
	0x4A38: 0x71D6,
	0x4A39: 0x71D9,
	0x4A3A: 0x71DA,
	0x4A3B: 0x71DC,
	0x4A3C: 0x71F8,
	0x4A3D: 0x71FE,
	0x4A3E: 0x7200,
	0x4A3F: 0x7207,
	0x4A40: 0x7208,
	0x4A41: 0x7209,
	0x4A42: 0x7213,
	0x4A43: 0x7217,
	0x4A44: 0x721A,
	0x4A45: 0x721D,
	0x4A46: 0x721F,
	0x4A47: 0x7224,
	0x4A48: 0x722B,
	0x4A49: 0x722F,
	0x4A4A: 0x7234,
	0x4A4B: 0x7238,
	0x4A4C: 0x7239,
	0x4A4D: 0x7241,
	0x4A4E: 0x7242,
	0x4A4F: 0x7243,
	0x4A50: 0x7245,
	0x4A51: 0x724E,
	0x4A52: 0x724F,
	0x4A53: 0x7250,
	0x4A54: 0x7253,
	0x4A55: 0x7255,
	0x4A56: 0x7256,
	0x4A57: 0x725A,
	0x4A58: 0x725C,
	0x4A59: 0x725E,
	0x4A5A: 0x7260,
	0x4A5B: 0x7263,
	0x4A5C: 0x7268,
	0x4A5D: 0x726B,
	0x4A5E: 0x726E,
	0x4A5F: 0x726F,
	0x4A60: 0x7271,
	0x4A61: 0x7277,
	0x4A62: 0x7278,
	0x4A63: 0x727B,
	0x4A64: 0x727C,
	0x4A65: 0x727F,
	0x4A66: 0x7284,
	0x4A67: 0x7289,
	0x4A68: 0x728D,
	0x4A69: 0x728E,
	0x4A6A: 0x7293,
	0x4A6B: 0x729B,
	0x4A6C: 0x72A8,
	0x4A6D: 0x72AD,
	0x4A6E: 0x72AE,
	0x4A6F: 0x72B1,
	0x4A70: 0x72B4,
	0x4A71: 0x72BE,
	0x4A72: 0x72C1,
	0x4A73: 0x72C7,
	0x4A74: 0x72C9,
	0x4A75: 0x72CC,
	0x4A76: 0x72D5,
	0x4A77: 0x72D6,
	0x4A78: 0x72D8,
	0x4A79: 0x72DF,
	0x4A7A: 0x72E5,
	0x4A7B: 0x72F3,
	0x4A7C: 0x72F4,
	0x4A7D: 0x72FA,
	0x4A7E: 0x72FB,
	0x4B21: 0x72FE,
	0x4B22: 0x7302,
	0x4B23: 0x7304,
	0x4B24: 0x7305,
	0x4B25: 0x7307,
	0x4B26: 0x730B,
	0x4B27: 0x730D,
	0x4B28: 0x7312,
	0x4B29: 0x7313,
	0x4B2A: 0x7318,
	0x4B2B: 0x7319,
	0x4B2C: 0x731E,
	0x4B2D: 0x7322,
	0x4B2E: 0x7324,
	0x4B2F: 0x7327,
	0x4B30: 0x7328,
	0x4B31: 0x732C,
	0x4B32: 0x7331,
	0x4B33: 0x7332,
	0x4B34: 0x7335,
	0x4B35: 0x733A,
	0x4B36: 0x733B,
	0x4B37: 0x733D,
	0x4B38: 0x7343,
	0x4B39: 0x734D,
	0x4B3A: 0x7350,
	0x4B3B: 0x7352,
	0x4B3C: 0x7356,
	0x4B3D: 0x7358,
	0x4B3E: 0x735D,
	0x4B3F: 0x735E,
	0x4B40: 0x735F,
	0x4B41: 0x7360,
	0x4B42: 0x7366,
	0x4B43: 0x7367,
	0x4B44: 0x7369,
	0x4B45: 0x736B,
	0x4B46: 0x736C,
	0x4B47: 0x736E,
	0x4B48: 0x736F,
	0x4B49: 0x7371,
	0x4B4A: 0x7377,
	0x4B4B: 0x7379,
	0x4B4C: 0x737C,
	0x4B4D: 0x7380,
	0x4B4E: 0x7381,
	0x4B4F: 0x7383,
	0x4B50: 0x7385,
	0x4B51: 0x7386,
	0x4B52: 0x738E,
	0x4B53: 0x7390,
	0x4B54: 0x7393,
	0x4B55: 0x7395,
	0x4B56: 0x7397,
	0x4B57: 0x7398,
	0x4B58: 0x739C,
	0x4B59: 0x739E,
	0x4B5A: 0x739F,
	0x4B5B: 0x73A0,
	0x4B5C: 0x73A2,
	0x4B5D: 0x73A5,
	0x4B5E: 0x73A6,
	0x4B5F: 0x73AA,
	0x4B60: 0x73AB,
	0x4B61: 0x73AD,
	0x4B62: 0x73B5,
	0x4B63: 0x73B7,
	0x4B64: 0x73B9,
	0x4B65: 0x73BC,
	0x4B66: 0x73BD,
	0x4B67: 0x73BF,
	0x4B68: 0x73C5,
	0x4B69: 0x73C6,
	0x4B6A: 0x73C9,
	0x4B6B: 0x73CB,
	0x4B6C: 0x73CC,
	0x4B6D: 0x73CF,
	0x4B6E: 0x73D2,
	0x4B6F: 0x73D3,
	0x4B70: 0x73D6,
	0x4B71: 0x73D9,
	0x4B72: 0x73DD,
	0x4B73: 0x73E1,
	0x4B74: 0x73E3,
	0x4B75: 0x73E6,
	0x4B76: 0x73E7,
	0x4B77: 0x73E9,
	0x4B78: 0x73F4,
	0x4B79: 0x73F5,
	0x4B7A: 0x73F7,
	0x4B7B: 0x73F9,
	0x4B7C: 0x73FA,
	0x4B7D: 0x73FB,
	0x4B7E: 0x73FD,
	0x4C21: 0x73FF,
	0x4C22: 0x7400,
	0x4C23: 0x7401,
	0x4C24: 0x7404,
	0x4C25: 0x7407,
	0x4C26: 0x740A,
	0x4C27: 0x7411,
	0x4C28: 0x741A,
	0x4C29: 0x741B,
	0x4C2A: 0x7424,
	0x4C2B: 0x7426,
	0x4C2C: 0x7428,
	0x4C2D: 0x7429,
	0x4C2E: 0x742A,
	0x4C2F: 0x742B,
	0x4C30: 0x742C,
	0x4C31: 0x742D,
	0x4C32: 0x742E,
	0x4C33: 0x742F,
	0x4C34: 0x7430,
	0x4C35: 0x7431,
	0x4C36: 0x7439,
	0x4C37: 0x7440,
	0x4C38: 0x7443,
	0x4C39: 0x7444,
	0x4C3A: 0x7446,
	0x4C3B: 0x7447,
	0x4C3C: 0x744B,
	0x4C3D: 0x744D,
	0x4C3E: 0x7451,
	0x4C3F: 0x7452,
	0x4C40: 0x7457,
	0x4C41: 0x745D,
	0x4C42: 0x7462,
	0x4C43: 0x7466,
	0x4C44: 0x7467,
	0x4C45: 0x7468,
	0x4C46: 0x746B,
	0x4C47: 0x746D,
	0x4C48: 0x746E,
	0x4C49: 0x7471,
	0x4C4A: 0x7472,
	0x4C4B: 0x7480,
	0x4C4C: 0x7481,
	0x4C4D: 0x7485,
	0x4C4E: 0x7486,
	0x4C4F: 0x7487,
	0x4C50: 0x7489,
	0x4C51: 0x748F,
	0x4C52: 0x7490,
	0x4C53: 0x7491,
	0x4C54: 0x7492,
	0x4C55: 0x7498,
	0x4C56: 0x7499,
	0x4C57: 0x749A,
	0x4C58: 0x749C,
	0x4C59: 0x749F,
	0x4C5A: 0x74A0,
	0x4C5B: 0x74A1,
	0x4C5C: 0x74A3,
	0x4C5D: 0x74A6,
	0x4C5E: 0x74A8,
	0x4C5F: 0x74A9,
	0x4C60: 0x74AA,
	0x4C61: 0x74AB,
	0x4C62: 0x74AE,
	0x4C63: 0x74AF,
	0x4C64: 0x74B1,
	0x4C65: 0x74B2,
	0x4C66: 0x74B5,
	0x4C67: 0x74B9,
	0x4C68: 0x74BB,
	0x4C69: 0x74BF,
	0x4C6A: 0x74C8,
	0x4C6B: 0x74C9,
	0x4C6C: 0x74CC,
	0x4C6D: 0x74D0,
	0x4C6E: 0x74D3,
	0x4C6F: 0x74D8,
	0x4C70: 0x74DA,
	0x4C71: 0x74DB,
	0x4C72: 0x74DE,
	0x4C73: 0x74DF,
	0x4C74: 0x74E4,
	0x4C75: 0x74E8,
	0x4C76: 0x74EA,
	0x4C77: 0x74EB,
	0x4C78: 0x74EF,
	0x4C79: 0x74F4,
	0x4C7A: 0x74FA,
	0x4C7B: 0x74FB,
	0x4C7C: 0x74FC,
	0x4C7D: 0x74FF,
	0x4C7E: 0x7506,
	0x4D21: 0x7512,
	0x4D22: 0x7516,
	0x4D23: 0x7517,
	0x4D24: 0x7520,
	0x4D25: 0x7521,
	0x4D26: 0x7524,
	0x4D27: 0x7527,
	0x4D28: 0x7529,
	0x4D29: 0x752A,
	0x4D2A: 0x752F,
	0x4D2B: 0x7536,
	0x4D2C: 0x7539,
	0x4D2D: 0x753D,
	0x4D2E: 0x753E,
	0x4D2F: 0x753F,
	0x4D30: 0x7540,
	0x4D31: 0x7543,
	0x4D32: 0x7547,
	0x4D33: 0x7548,
	0x4D34: 0x754E,
	0x4D35: 0x7550,
	0x4D36: 0x7552,
	0x4D37: 0x7557,
	0x4D38: 0x755E,
	0x4D39: 0x755F,
	0x4D3A: 0x7561,
	0x4D3B: 0x756F,
	0x4D3C: 0x7571,
	0x4D3D: 0x7579,
	0x4D3E: 0x757A,
	0x4D3F: 0x757B,
	0x4D40: 0x757C,
	0x4D41: 0x757D,
	0x4D42: 0x757E,
	0x4D43: 0x7581,
	0x4D44: 0x7585,
	0x4D45: 0x7590,
	0x4D46: 0x7592,
	0x4D47: 0x7593,
	0x4D48: 0x7595,
	0x4D49: 0x7599,
	0x4D4A: 0x759C,
	0x4D4B: 0x75A2,
	0x4D4C: 0x75A4,
	0x4D4D: 0x75B4,
	0x4D4E: 0x75BA,
	0x4D4F: 0x75BF,
	0x4D50: 0x75C0,
	0x4D51: 0x75C1,
	0x4D52: 0x75C4,
	0x4D53: 0x75C6,
	0x4D54: 0x75CC,
	0x4D55: 0x75CE,
	0x4D56: 0x75CF,
	0x4D57: 0x75D7,
	0x4D58: 0x75DC,
	0x4D59: 0x75DF,
	0x4D5A: 0x75E0,
	0x4D5B: 0x75E1,
	0x4D5C: 0x75E4,
	0x4D5D: 0x75E7,
	0x4D5E: 0x75EC,
	0x4D5F: 0x75EE,
	0x4D60: 0x75EF,
	0x4D61: 0x75F1,
	0x4D62: 0x75F9,
	0x4D63: 0x7600,
	0x4D64: 0x7602,
	0x4D65: 0x7603,
	0x4D66: 0x7604,
	0x4D67: 0x7607,
	0x4D68: 0x7608,
	0x4D69: 0x760A,
	0x4D6A: 0x760C,
	0x4D6B: 0x760F,
	0x4D6C: 0x7612,
	0x4D6D: 0x7613,
	0x4D6E: 0x7615,
	0x4D6F: 0x7616,
	0x4D70: 0x7619,
	0x4D71: 0x761B,
	0x4D72: 0x761C,
	0x4D73: 0x761D,
	0x4D74: 0x761E,
	0x4D75: 0x7623,
	0x4D76: 0x7625,
	0x4D77: 0x7626,
	0x4D78: 0x7629,
	0x4D79: 0x762D,
	0x4D7A: 0x7632,
	0x4D7B: 0x7633,
	0x4D7C: 0x7635,
	0x4D7D: 0x7638,
	0x4D7E: 0x7639,
	0x4E21: 0x763A,
	0x4E22: 0x763C,
	0x4E23: 0x764A,
	0x4E24: 0x7640,
	0x4E25: 0x7641,
	0x4E26: 0x7643,
	0x4E27: 0x7644,
	0x4E28: 0x7645,
	0x4E29: 0x7649,
	0x4E2A: 0x764B,
	0x4E2B: 0x7655,
	0x4E2C: 0x7659,
	0x4E2D: 0x765F,
	0x4E2E: 0x7664,
	0x4E2F: 0x7665,
	0x4E30: 0x766D,
	0x4E31: 0x766E,
	0x4E32: 0x766F,
	0x4E33: 0x7671,
	0x4E34: 0x7674,
	0x4E35: 0x7681,
	0x4E36: 0x7685,
	0x4E37: 0x768C,
	0x4E38: 0x768D,
	0x4E39: 0x7695,
	0x4E3A: 0x769B,
	0x4E3B: 0x769C,
	0x4E3C: 0x769D,
	0x4E3D: 0x769F,
	0x4E3E: 0x76A0,
	0x4E3F: 0x76A2,
	0x4E40: 0x76A3,
	0x4E41: 0x76A4,
	0x4E42: 0x76A5,
	0x4E43: 0x76A6,
	0x4E44: 0x76A7,
	0x4E45: 0x76A8,
	0x4E46: 0x76AA,
	0x4E47: 0x76AD,
	0x4E48: 0x76BD,
	0x4E49: 0x76C1,
	0x4E4A: 0x76C5,
	0x4E4B: 0x76C9,
	0x4E4C: 0x76CB,
	0x4E4D: 0x76CC,
	0x4E4E: 0x76CE,
	0x4E4F: 0x76D4,
	0x4E50: 0x76D9,
	0x4E51: 0x76E0,
	0x4E52: 0x76E6,
	0x4E53: 0x76E8,
	0x4E54: 0x76EC,
	0x4E55: 0x76F0,
	0x4E56: 0x76F1,
	0x4E57: 0x76F6,
	0x4E58: 0x76F9,
	0x4E59: 0x76FC,
	0x4E5A: 0x7700,
	0x4E5B: 0x7706,
	0x4E5C: 0x770A,
	0x4E5D: 0x770E,
	0x4E5E: 0x7712,
	0x4E5F: 0x7714,
	0x4E60: 0x7715,
	0x4E61: 0x7717,
	0x4E62: 0x7719,
	0x4E63: 0x771A,
	0x4E64: 0x771C,
	0x4E65: 0x7722,
	0x4E66: 0x7728,
	0x4E67: 0x772D,
	0x4E68: 0x772E,
	0x4E69: 0x772F,
	0x4E6A: 0x7734,
	0x4E6B: 0x7735,
	0x4E6C: 0x7736,
	0x4E6D: 0x7739,
	0x4E6E: 0x773D,
	0x4E6F: 0x773E,
	0x4E70: 0x7742,
	0x4E71: 0x7745,
	0x4E72: 0x7746,
	0x4E73: 0x774A,
	0x4E74: 0x774D,
	0x4E75: 0x774E,
	0x4E76: 0x774F,
	0x4E77: 0x7752,
	0x4E78: 0x7756,
	0x4E79: 0x7757,
	0x4E7A: 0x775C,
	0x4E7B: 0x775E,
	0x4E7C: 0x775F,
	0x4E7D: 0x7760,
	0x4E7E: 0x7762,
	0x4F21: 0x7764,
	0x4F22: 0x7767,
	0x4F23: 0x776A,
	0x4F24: 0x776C,
	0x4F25: 0x7770,
	0x4F26: 0x7772,
	0x4F27: 0x7773,
	0x4F28: 0x7774,
	0x4F29: 0x777A,
	0x4F2A: 0x777D,
	0x4F2B: 0x7780,
	0x4F2C: 0x7784,
	0x4F2D: 0x778C,
	0x4F2E: 0x778D,
	0x4F2F: 0x7794,
	0x4F30: 0x7795,
	0x4F31: 0x7796,
	0x4F32: 0x779A,
	0x4F33: 0x779F,
	0x4F34: 0x77A2,
	0x4F35: 0x77A7,
	0x4F36: 0x77AA,
	0x4F37: 0x77AE,
	0x4F38: 0x77AF,
	0x4F39: 0x77B1,
	0x4F3A: 0x77B5,
	0x4F3B: 0x77BE,
	0x4F3C: 0x77C3,
	0x4F3D: 0x77C9,
	0x4F3E: 0x77D1,
	0x4F3F: 0x77D2,
	0x4F40: 0x77D5,
	0x4F41: 0x77D9,
	0x4F42: 0x77DE,
	0x4F43: 0x77DF,
	0x4F44: 0x77E0,
	0x4F45: 0x77E4,
	0x4F46: 0x77E6,
	0x4F47: 0x77EA,
	0x4F48: 0x77EC,
	0x4F49: 0x77F0,
	0x4F4A: 0x77F1,
	0x4F4B: 0x77F4,
	0x4F4C: 0x77F8,
	0x4F4D: 0x77FB,
	0x4F4E: 0x7805,
	0x4F4F: 0x7806,
	0x4F50: 0x7809,
	0x4F51: 0x780D,
	0x4F52: 0x780E,
	0x4F53: 0x7811,
	0x4F54: 0x781D,
	0x4F55: 0x7821,
	0x4F56: 0x7822,
	0x4F57: 0x7823,
	0x4F58: 0x782D,
	0x4F59: 0x782E,
	0x4F5A: 0x7830,
	0x4F5B: 0x7835,
	0x4F5C: 0x7837,
	0x4F5D: 0x7843,
	0x4F5E: 0x7844,
	0x4F5F: 0x7847,
	0x4F60: 0x7848,
	0x4F61: 0x784C,
	0x4F62: 0x784E,
	0x4F63: 0x7852,
	0x4F64: 0x785C,
	0x4F65: 0x785E,
	0x4F66: 0x7860,
	0x4F67: 0x7861,
	0x4F68: 0x7863,
	0x4F69: 0x7864,
	0x4F6A: 0x7868,
	0x4F6B: 0x786A,
	0x4F6C: 0x786E,
	0x4F6D: 0x787A,
	0x4F6E: 0x787E,
	0x4F6F: 0x788A,
	0x4F70: 0x788F,
	0x4F71: 0x7894,
	0x4F72: 0x7898,
	0x4F73: 0x78A1,
	0x4F74: 0x789D,
	0x4F75: 0x789E,
	0x4F76: 0x789F,
	0x4F77: 0x78A4,
	0x4F78: 0x78A8,
	0x4F79: 0x78AC,
	0x4F7A: 0x78AD,
	0x4F7B: 0x78B0,
	0x4F7C: 0x78B1,
	0x4F7D: 0x78B2,
	0x4F7E: 0x78B3,
	0x5021: 0x78BB,
	0x5022: 0x78BD,
	0x5023: 0x78BF,
	0x5024: 0x78C7,
	0x5025: 0x78C8,
	0x5026: 0x78C9,
	0x5027: 0x78CC,
	0x5028: 0x78CE,
	0x5029: 0x78D2,
	0x502A: 0x78D3,
	0x502B: 0x78D5,
	0x502C: 0x78D6,
	0x502D: 0x78E4,
	0x502E: 0x78DB,
	0x502F: 0x78DF,
	0x5030: 0x78E0,
	0x5031: 0x78E1,
	0x5032: 0x78E6,
	0x5033: 0x78EA,
	0x5034: 0x78F2,
	0x5035: 0x78F3,
	0x5036: 0x7900,
	0x5037: 0x78F6,
	0x5038: 0x78F7,
	0x5039: 0x78FA,
	0x503A: 0x78FB,
	0x503B: 0x78FF,
	0x503C: 0x7906,
	0x503D: 0x790C,
	0x503E: 0x7910,
	0x503F: 0x791A,
	0x5040: 0x791C,
	0x5041: 0x791E,
	0x5042: 0x791F,
	0x5043: 0x7920,
	0x5044: 0x7925,
	0x5045: 0x7927,
	0x5046: 0x7929,
	0x5047: 0x792D,
	0x5048: 0x7931,
	0x5049: 0x7934,
	0x504A: 0x7935,
	0x504B: 0x793B,
	0x504C: 0x793D,
	0x504D: 0x793F,
	0x504E: 0x7944,
	0x504F: 0x7945,
	0x5050: 0x7946,
	0x5051: 0x794A,
	0x5052: 0x794B,
	0x5053: 0x794F,
	0x5054: 0x7951,
	0x5055: 0x7954,
	0x5056: 0x7958,
	0x5057: 0x795B,
	0x5058: 0x795C,
	0x5059: 0x7967,
	0x505A: 0x7969,
	0x505B: 0x796B,
	0x505C: 0x7972,
	0x505D: 0x7979,
	0x505E: 0x797B,
	0x505F: 0x797C,
	0x5060: 0x797E,
	0x5061: 0x798B,
	0x5062: 0x798C,
	0x5063: 0x7991,
	0x5064: 0x7993,
	0x5065: 0x7994,
	0x5066: 0x7995,
	0x5067: 0x7996,
	0x5068: 0x7998,
	0x5069: 0x799B,
	0x506A: 0x799C,
	0x506B: 0x79A1,
	0x506C: 0x79A8,
	0x506D: 0x79A9,
	0x506E: 0x79AB,
	0x506F: 0x79AF,
	0x5070: 0x79B1,
	0x5071: 0x79B4,
	0x5072: 0x79B8,
	0x5073: 0x79BB,
	0x5074: 0x79C2,
	0x5075: 0x79C4,
	0x5076: 0x79C7,
	0x5077: 0x79C8,
	0x5078: 0x79CA,
	0x5079: 0x79CF,
	0x507A: 0x79D4,
	0x507B: 0x79D6,
	0x507C: 0x79DA,
	0x507D: 0x79DD,
	0x507E: 0x79DE,
	0x5121: 0x79E0,
	0x5122: 0x79E2,
	0x5123: 0x79E5,
	0x5124: 0x79EA,
	0x5125: 0x79EB,
	0x5126: 0x79ED,
	0x5127: 0x79F1,
	0x5128: 0x79F8,
	0x5129: 0x79FC,
	0x512A: 0x7A02,
	0x512B: 0x7A03,
	0x512C: 0x7A07,
	0x512D: 0x7A09,
	0x512E: 0x7A0A,
	0x512F: 0x7A0C,
	0x5130: 0x7A11,
	0x5131: 0x7A15,
	0x5132: 0x7A1B,
	0x5133: 0x7A1E,
	0x5134: 0x7A21,
	0x5135: 0x7A27,
	0x5136: 0x7A2B,
	0x5137: 0x7A2D,
	0x5138: 0x7A2F,
	0x5139: 0x7A30,
	0x513A: 0x7A34,
	0x513B: 0x7A35,
	0x513C: 0x7A38,
	0x513D: 0x7A39,
	0x513E: 0x7A3A,
	0x513F: 0x7A44,
	0x5140: 0x7A45,
	0x5141: 0x7A47,
	0x5142: 0x7A48,
	0x5143: 0x7A4C,
	0x5144: 0x7A55,
	0x5145: 0x7A56,
	0x5146: 0x7A59,
	0x5147: 0x7A5C,
	0x5148: 0x7A5D,
	0x5149: 0x7A5F,
	0x514A: 0x7A60,
	0x514B: 0x7A65,
	0x514C: 0x7A67,
	0x514D: 0x7A6A,
	0x514E: 0x7A6D,
	0x514F: 0x7A75,
	0x5150: 0x7A78,
	0x5151: 0x7A7E,
	0x5152: 0x7A80,
	0x5153: 0x7A82,
	0x5154: 0x7A85,
	0x5155: 0x7A86,
	0x5156: 0x7A8A,
	0x5157: 0x7A8B,
	0x5158: 0x7A90,
	0x5159: 0x7A91,
	0x515A: 0x7A94,
	0x515B: 0x7A9E,
	0x515C: 0x7AA0,
	0x515D: 0x7AA3,
	0x515E: 0x7AAC,
	0x515F: 0x7AB3,
	0x5160: 0x7AB5,
	0x5161: 0x7AB9,
	0x5162: 0x7ABB,
	0x5163: 0x7ABC,
	0x5164: 0x7AC6,
	0x5165: 0x7AC9,
	0x5166: 0x7ACC,
	0x5167: 0x7ACE,
	0x5168: 0x7AD1,
	0x5169: 0x7ADB,
	0x516A: 0x7AE8,
	0x516B: 0x7AE9,
	0x516C: 0x7AEB,
	0x516D: 0x7AEC,
	0x516E: 0x7AF1,
	0x516F: 0x7AF4,
	0x5170: 0x7AFB,
	0x5171: 0x7AFD,
	0x5172: 0x7AFE,
	0x5173: 0x7B07,
	0x5174: 0x7B14,
	0x5175: 0x7B1F,
	0x5176: 0x7B23,
	0x5177: 0x7B27,
	0x5178: 0x7B29,
	0x5179: 0x7B2A,
	0x517A: 0x7B2B,
	0x517B: 0x7B2D,
	0x517C: 0x7B2E,
	0x517D: 0x7B2F,
	0x517E: 0x7B30,
	0x5221: 0x7B31,
	0x5222: 0x7B34,
	0x5223: 0x7B3D,
	0x5224: 0x7B3F,
	0x5225: 0x7B40,
	0x5226: 0x7B41,
	0x5227: 0x7B47,
	0x5228: 0x7B4E,
	0x5229: 0x7B55,
	0x522A: 0x7B60,
	0x522B: 0x7B64,
	0x522C: 0x7B66,
	0x522D: 0x7B69,
	0x522E: 0x7B6A,
	0x522F: 0x7B6D,
	0x5230: 0x7B6F,
	0x5231: 0x7B72,
	0x5232: 0x7B73,
	0x5233: 0x7B77,
	0x5234: 0x7B84,
	0x5235: 0x7B89,
	0x5236: 0x7B8E,
	0x5237: 0x7B90,
	0x5238: 0x7B91,
	0x5239: 0x7B96,
	0x523A: 0x7B9B,
	0x523B: 0x7B9E,
	0x523C: 0x7BA0,
	0x523D: 0x7BA5,
	0x523E: 0x7BAC,
	0x523F: 0x7BAF,
	0x5240: 0x7BB0,
	0x5241: 0x7BB2,
	0x5242: 0x7BB5,
	0x5243: 0x7BB6,
	0x5244: 0x7BBA,
	0x5245: 0x7BBB,
	0x5246: 0x7BBC,
	0x5247: 0x7BBD,
	0x5248: 0x7BC2,
	0x5249: 0x7BC5,
	0x524A: 0x7BC8,
	0x524B: 0x7BCA,
	0x524C: 0x7BD4,
	0x524D: 0x7BD6,
	0x524E: 0x7BD7,
	0x524F: 0x7BD9,
	0x5250: 0x7BDA,
	0x5251: 0x7BDB,
	0x5252: 0x7BE8,
	0x5253: 0x7BEA,
	0x5254: 0x7BF2,
	0x5255: 0x7BF4,
	0x5256: 0x7BF5,
	0x5257: 0x7BF8,
	0x5258: 0x7BF9,
	0x5259: 0x7BFA,
	0x525A: 0x7BFC,
	0x525B: 0x7BFE,
	0x525C: 0x7C01,
	0x525D: 0x7C02,
	0x525E: 0x7C03,
	0x525F: 0x7C04,
	0x5260: 0x7C06,
	0x5261: 0x7C09,
	0x5262: 0x7C0B,
	0x5263: 0x7C0C,
	0x5264: 0x7C0E,
	0x5265: 0x7C0F,
	0x5266: 0x7C19,
	0x5267: 0x7C1B,
	0x5268: 0x7C20,
	0x5269: 0x7C25,
	0x526A: 0x7C26,
	0x526B: 0x7C28,
	0x526C: 0x7C2C,
	0x526D: 0x7C31,
	0x526E: 0x7C33,
	0x526F: 0x7C34,
	0x5270: 0x7C36,
	0x5271: 0x7C39,
	0x5272: 0x7C3A,
	0x5273: 0x7C46,
	0x5274: 0x7C4A,
	0x5275: 0x7C55,
	0x5276: 0x7C51,
	0x5277: 0x7C52,
	0x5278: 0x7C53,
	0x5279: 0x7C59,
	0x527A: 0x7C5A,
	0x527B: 0x7C5B,
	0x527C: 0x7C5C,
	0x527D: 0x7C5D,
	0x527E: 0x7C5E,
	0x5321: 0x7C61,
	0x5322: 0x7C63,
	0x5323: 0x7C67,
	0x5324: 0x7C69,
	0x5325: 0x7C6D,
	0x5326: 0x7C6E,
	0x5327: 0x7C70,
	0x5328: 0x7C72,
	0x5329: 0x7C79,
	0x532A: 0x7C7C,
	0x532B: 0x7C7D,
	0x532C: 0x7C86,
	0x532D: 0x7C87,
	0x532E: 0x7C8F,
	0x532F: 0x7C94,
	0x5330: 0x7C9E,
	0x5331: 0x7CA0,
	0x5332: 0x7CA6,
	0x5333: 0x7CB0,
	0x5334: 0x7CB6,
	0x5335: 0x7CB7,
	0x5336: 0x7CBA,
	0x5337: 0x7CBB,
	0x5338: 0x7CBC,
	0x5339: 0x7CBF,
	0x533A: 0x7CC4,
	0x533B: 0x7CC7,
	0x533C: 0x7CC8,
	0x533D: 0x7CC9,
	0x533E: 0x7CCD,
	0x533F: 0x7CCF,
	0x5340: 0x7CD3,
	0x5341: 0x7CD4,
	0x5342: 0x7CD5,
	0x5343: 0x7CD7,
	0x5344: 0x7CD9,
	0x5345: 0x7CDA,
	0x5346: 0x7CDD,
	0x5347: 0x7CE6,
	0x5348: 0x7CE9,
	0x5349: 0x7CEB,
	0x534A: 0x7CF5,
	0x534B: 0x7D03,
	0x534C: 0x7D07,
	0x534D: 0x7D08,
	0x534E: 0x7D09,
	0x534F: 0x7D0F,
	0x5350: 0x7D11,
	0x5351: 0x7D12,
	0x5352: 0x7D13,
	0x5353: 0x7D16,
	0x5354: 0x7D1D,
	0x5355: 0x7D1E,
	0x5356: 0x7D23,
	0x5357: 0x7D26,
	0x5358: 0x7D2A,
	0x5359: 0x7D2D,
	0x535A: 0x7D31,
	0x535B: 0x7D3C,
	0x535C: 0x7D3D,
	0x535D: 0x7D3E,
	0x535E: 0x7D40,
	0x535F: 0x7D41,
	0x5360: 0x7D47,
	0x5361: 0x7D48,
	0x5362: 0x7D4D,
	0x5363: 0x7D51,
	0x5364: 0x7D53,
	0x5365: 0x7D57,
	0x5366: 0x7D59,
	0x5367: 0x7D5A,
	0x5368: 0x7D5C,
	0x5369: 0x7D5D,
	0x536A: 0x7D65,
	0x536B: 0x7D67,
	0x536C: 0x7D6A,
	0x536D: 0x7D70,
	0x536E: 0x7D78,
	0x536F: 0x7D7A,
	0x5370: 0x7D7B,
	0x5371: 0x7D7F,
	0x5372: 0x7D81,
	0x5373: 0x7D82,
	0x5374: 0x7D83,
	0x5375: 0x7D85,
	0x5376: 0x7D86,
	0x5377: 0x7D88,
	0x5378: 0x7D8B,
	0x5379: 0x7D8C,
	0x537A: 0x7D8D,
	0x537B: 0x7D91,
	0x537C: 0x7D96,
	0x537D: 0x7D97,
	0x537E: 0x7D9D,
	0x5421: 0x7D9E,
	0x5422: 0x7DA6,
	0x5423: 0x7DA7,
	0x5424: 0x7DAA,
	0x5425: 0x7DB3,
	0x5426: 0x7DB6,
	0x5427: 0x7DB7,
	0x5428: 0x7DB9,
	0x5429: 0x7DC2,
	0x542A: 0x7DC3,
	0x542B: 0x7DC4,
	0x542C: 0x7DC5,
	0x542D: 0x7DC6,
	0x542E: 0x7DCC,
	0x542F: 0x7DCD,
	0x5430: 0x7DCE,
	0x5431: 0x7DD7,
	0x5432: 0x7DD9,
	0x5433: 0x7E00,
	0x5434: 0x7DE2,
	0x5435: 0x7DE5,
	0x5436: 0x7DE6,
	0x5437: 0x7DEA,
	0x5438: 0x7DEB,
	0x5439: 0x7DED,
	0x543A: 0x7DF1,
	0x543B: 0x7DF5,
	0x543C: 0x7DF6,
	0x543D: 0x7DF9,
	0x543E: 0x7DFA,
	0x543F: 0x7E08,
	0x5440: 0x7E10,
	0x5441: 0x7E11,
	0x5442: 0x7E15,
	0x5443: 0x7E17,
	0x5444: 0x7E1C,
	0x5445: 0x7E1D,
	0x5446: 0x7E20,
	0x5447: 0x7E27,
	0x5448: 0x7E28,
	0x5449: 0x7E2C,
	0x544A: 0x7E2D,
	0x544B: 0x7E2F,
	0x544C: 0x7E33,
	0x544D: 0x7E36,
	0x544E: 0x7E3F,
	0x544F: 0x7E44,
	0x5450: 0x7E45,
	0x5451: 0x7E47,
	0x5452: 0x7E4E,
	0x5453: 0x7E50,
	0x5454: 0x7E52,
	0x5455: 0x7E58,
	0x5456: 0x7E5F,
	0x5457: 0x7E61,
	0x5458: 0x7E62,
	0x5459: 0x7E65,
	0x545A: 0x7E6B,
	0x545B: 0x7E6E,
	0x545C: 0x7E6F,
	0x545D: 0x7E73,
	0x545E: 0x7E78,
	0x545F: 0x7E7E,
	0x5460: 0x7E81,
	0x5461: 0x7E86,
	0x5462: 0x7E87,
	0x5463: 0x7E8A,
	0x5464: 0x7E8D,
	0x5465: 0x7E91,
	0x5466: 0x7E95,
	0x5467: 0x7E98,
	0x5468: 0x7E9A,
	0x5469: 0x7E9D,
	0x546A: 0x7E9E,
	0x546B: 0x7F3C,
	0x546C: 0x7F3B,
	0x546D: 0x7F3D,
	0x546E: 0x7F3E,
	0x546F: 0x7F3F,
	0x5470: 0x7F43,
	0x5471: 0x7F44,
	0x5472: 0x7F47,
	0x5473: 0x7F4F,
	0x5474: 0x7F52,
	0x5475: 0x7F53,
	0x5476: 0x7F5B,
	0x5477: 0x7F5C,
	0x5478: 0x7F5D,
	0x5479: 0x7F61,
	0x547A: 0x7F63,
	0x547B: 0x7F64,
	0x547C: 0x7F65,
	0x547D: 0x7F66,
	0x547E: 0x7F6D,
	0x5521: 0x7F71,
	0x5522: 0x7F7D,
	0x5523: 0x7F7E,
	0x5524: 0x7F7F,
	0x5525: 0x7F80,
	0x5526: 0x7F8B,
	0x5527: 0x7F8D,
	0x5528: 0x7F8F,
	0x5529: 0x7F90,
	0x552A: 0x7F91,
	0x552B: 0x7F96,
	0x552C: 0x7F97,
	0x552D: 0x7F9C,
	0x552E: 0x7FA1,
	0x552F: 0x7FA2,
	0x5530: 0x7FA6,
	0x5531: 0x7FAA,
	0x5532: 0x7FAD,
	0x5533: 0x7FB4,
	0x5534: 0x7FBC,
	0x5535: 0x7FBF,
	0x5536: 0x7FC0,
	0x5537: 0x7FC3,
	0x5538: 0x7FC8,
	0x5539: 0x7FCE,
	0x553A: 0x7FCF,
	0x553B: 0x7FDB,
	0x553C: 0x7FDF,
	0x553D: 0x7FE3,
	0x553E: 0x7FE5,
	0x553F: 0x7FE8,
	0x5540: 0x7FEC,
	0x5541: 0x7FEE,
	0x5542: 0x7FEF,
	0x5543: 0x7FF2,
	0x5544: 0x7FFA,
	0x5545: 0x7FFD,
	0x5546: 0x7FFE,
	0x5547: 0x7FFF,
	0x5548: 0x8007,
	0x5549: 0x8008,
	0x554A: 0x800A,
	0x554B: 0x800D,
	0x554C: 0x800E,
	0x554D: 0x800F,
	0x554E: 0x8011,
	0x554F: 0x8013,
	0x5550: 0x8014,
	0x5551: 0x8016,
	0x5552: 0x801D,
	0x5553: 0x801E,
	0x5554: 0x801F,
	0x5555: 0x8020,
	0x5556: 0x8024,
	0x5557: 0x8026,
	0x5558: 0x802C,
	0x5559: 0x802E,
	0x555A: 0x8030,
	0x555B: 0x8034,
	0x555C: 0x8035,
	0x555D: 0x8037,
	0x555E: 0x8039,
	0x555F: 0x803A,
	0x5560: 0x803C,
	0x5561: 0x803E,
	0x5562: 0x8040,
	0x5563: 0x8044,
	0x5564: 0x8060,
	0x5565: 0x8064,
	0x5566: 0x8066,
	0x5567: 0x806D,
	0x5568: 0x8071,
	0x5569: 0x8075,
	0x556A: 0x8081,
	0x556B: 0x8088,
	0x556C: 0x808E,
	0x556D: 0x809C,
	0x556E: 0x809E,
	0x556F: 0x80A6,
	0x5570: 0x80A7,
	0x5571: 0x80AB,
	0x5572: 0x80B8,
	0x5573: 0x80B9,
	0x5574: 0x80C8,
	0x5575: 0x80CD,
	0x5576: 0x80CF,
	0x5577: 0x80D2,
	0x5578: 0x80D4,
	0x5579: 0x80D5,
	0x557A: 0x80D7,
	0x557B: 0x80D8,
	0x557C: 0x80E0,
	0x557D: 0x80ED,
	0x557E: 0x80EE,
	0x5621: 0x80F0,
	0x5622: 0x80F2,
	0x5623: 0x80F3,
	0x5624: 0x80F6,
	0x5625: 0x80F9,
	0x5626: 0x80FA,
	0x5627: 0x80FE,
	0x5628: 0x8103,
	0x5629: 0x810B,
	0x562A: 0x8116,
	0x562B: 0x8117,
	0x562C: 0x8118,
	0x562D: 0x811C,
	0x562E: 0x811E,
	0x562F: 0x8120,
	0x5630: 0x8124,
	0x5631: 0x8127,
	0x5632: 0x812C,
	0x5633: 0x8130,
	0x5634: 0x8135,
	0x5635: 0x813A,
	0x5636: 0x813C,
	0x5637: 0x8145,
	0x5638: 0x8147,
	0x5639: 0x814A,
	0x563A: 0x814C,
	0x563B: 0x8152,
	0x563C: 0x8157,
	0x563D: 0x8160,
	0x563E: 0x8161,
	0x563F: 0x8167,
	0x5640: 0x8168,
	0x5641: 0x8169,
	0x5642: 0x816D,
	0x5643: 0x816F,
	0x5644: 0x8177,
	0x5645: 0x8181,
	0x5646: 0x8190,
	0x5647: 0x8184,
	0x5648: 0x8185,
	0x5649: 0x8186,
	0x564A: 0x818B,
	0x564B: 0x818E,
	0x564C: 0x8196,
	0x564D: 0x8198,
	0x564E: 0x819B,
	0x564F: 0x819E,
	0x5650: 0x81A2,
	0x5651: 0x81AE,
	0x5652: 0x81B2,
	0x5653: 0x81B4,
	0x5654: 0x81BB,
	0x5655: 0x81CB,
	0x5656: 0x81C3,
	0x5657: 0x81C5,
	0x5658: 0x81CA,
	0x5659: 0x81CE,
	0x565A: 0x81CF,
	0x565B: 0x81D5,
	0x565C: 0x81D7,
	0x565D: 0x81DB,
	0x565E: 0x81DD,
	0x565F: 0x81DE,
	0x5660: 0x81E1,
	0x5661: 0x81E4,
	0x5662: 0x81EB,
	0x5663: 0x81EC,
	0x5664: 0x81F0,
	0x5665: 0x81F1,
	0x5666: 0x81F2,
	0x5667: 0x81F5,
	0x5668: 0x81F6,
	0x5669: 0x81F8,
	0x566A: 0x81F9,
	0x566B: 0x81FD,
	0x566C: 0x81FF,
	0x566D: 0x8200,
	0x566E: 0x8203,
	0x566F: 0x820F,
	0x5670: 0x8213,
	0x5671: 0x8214,
	0x5672: 0x8219,
	0x5673: 0x821A,
	0x5674: 0x821D,
	0x5675: 0x8221,
	0x5676: 0x8222,
	0x5677: 0x8228,
	0x5678: 0x8232,
	0x5679: 0x8234,
	0x567A: 0x823A,
	0x567B: 0x8243,
	0x567C: 0x8244,
	0x567D: 0x8245,
	0x567E: 0x8246,
	0x5721: 0x824B,
	0x5722: 0x824E,
	0x5723: 0x824F,
	0x5724: 0x8251,
	0x5725: 0x8256,
	0x5726: 0x825C,
	0x5727: 0x8260,
	0x5728: 0x8263,
	0x5729: 0x8267,
	0x572A: 0x826D,
	0x572B: 0x8274,
	0x572C: 0x827B,
	0x572D: 0x827D,
	0x572E: 0x827F,
	0x572F: 0x8280,
	0x5730: 0x8281,
	0x5731: 0x8283,
	0x5732: 0x8284,
	0x5733: 0x8287,
	0x5734: 0x8289,
	0x5735: 0x828A,
	0x5736: 0x828E,
	0x5737: 0x8291,
	0x5738: 0x8294,
	0x5739: 0x8296,
	0x573A: 0x8298,
	0x573B: 0x829A,
	0x573C: 0x829B,
	0x573D: 0x82A0,
	0x573E: 0x82A1,
	0x573F: 0x82A3,
	0x5740: 0x82A4,
	0x5741: 0x82A7,
	0x5742: 0x82A8,
	0x5743: 0x82A9,
	0x5744: 0x82AA,
	0x5745: 0x82AE,
	0x5746: 0x82B0,
	0x5747: 0x82B2,
	0x5748: 0x82B4,
	0x5749: 0x82B7,
	0x574A: 0x82BA,
	0x574B: 0x82BC,
	0x574C: 0x82BE,
	0x574D: 0x82BF,
	0x574E: 0x82C6,
	0x574F: 0x82D0,
	0x5750: 0x82D5,
	0x5751: 0x82DA,
	0x5752: 0x82E0,
	0x5753: 0x82E2,
	0x5754: 0x82E4,
	0x5755: 0x82E8,
	0x5756: 0x82EA,
	0x5757: 0x82ED,
	0x5758: 0x82EF,
	0x5759: 0x82F6,
	0x575A: 0x82F7,
	0x575B: 0x82FD,
	0x575C: 0x82FE,
	0x575D: 0x8300,
	0x575E: 0x8301,
	0x575F: 0x8307,
	0x5760: 0x8308,
	0x5761: 0x830A,
	0x5762: 0x830B,
	0x5763: 0x8354,
	0x5764: 0x831B,
	0x5765: 0x831D,
	0x5766: 0x831E,
	0x5767: 0x831F,
	0x5768: 0x8321,
	0x5769: 0x8322,
	0x576A: 0x832C,
	0x576B: 0x832D,
	0x576C: 0x832E,
	0x576D: 0x8330,
	0x576E: 0x8333,
	0x576F: 0x8337,
	0x5770: 0x833A,
	0x5771: 0x833C,
	0x5772: 0x833D,
	0x5773: 0x8342,
	0x5774: 0x8343,
	0x5775: 0x8344,
	0x5776: 0x8347,
	0x5777: 0x834D,
	0x5778: 0x834E,
	0x5779: 0x8351,
	0x577A: 0x8355,
	0x577B: 0x8356,
	0x577C: 0x8357,
	0x577D: 0x8370,
	0x577E: 0x8378,
	0x5821: 0x837D,
	0x5822: 0x837F,
	0x5823: 0x8380,
	0x5824: 0x8382,
	0x5825: 0x8384,
	0x5826: 0x8386,
	0x5827: 0x838D,
	0x5828: 0x8392,
	0x5829: 0x8394,
	0x582A: 0x8395,
	0x582B: 0x8398,
	0x582C: 0x8399,
	0x582D: 0x839B,
	0x582E: 0x839C,
	0x582F: 0x839D,
	0x5830: 0x83A6,
	0x5831: 0x83A7,
	0x5832: 0x83A9,
	0x5833: 0x83AC,
	0x5834: 0x83BE,
	0x5835: 0x83BF,
	0x5836: 0x83C0,
	0x5837: 0x83C7,
	0x5838: 0x83C9,
	0x5839: 0x83CF,
	0x583A: 0x83D0,
	0x583B: 0x83D1,
	0x583C: 0x83D4,
	0x583D: 0x83DD,
	0x583E: 0x8353,
	0x583F: 0x83E8,
	0x5840: 0x83EA,
	0x5841: 0x83F6,
	0x5842: 0x83F8,
	0x5843: 0x83F9,
	0x5844: 0x83FC,
	0x5845: 0x8401,
	0x5846: 0x8406,
	0x5847: 0x840A,
	0x5848: 0x840F,
	0x5849: 0x8411,
	0x584A: 0x8415,
	0x584B: 0x8419,
	0x584C: 0x83AD,
	0x584D: 0x842F,
	0x584E: 0x8439,
	0x584F: 0x8445,
	0x5850: 0x8447,
	0x5851: 0x8448,
	0x5852: 0x844A,
	0x5853: 0x844D,
	0x5854: 0x844F,
	0x5855: 0x8451,
	0x5856: 0x8452,
	0x5857: 0x8456,
	0x5858: 0x8458,
	0x5859: 0x8459,
	0x585A: 0x845A,
	0x585B: 0x845C,
	0x585C: 0x8460,
	0x585D: 0x8464,
	0x585E: 0x8465,
	0x585F: 0x8467,
	0x5860: 0x846A,
	0x5861: 0x8470,
	0x5862: 0x8473,
	0x5863: 0x8474,
	0x5864: 0x8476,
	0x5865: 0x8478,
	0x5866: 0x847C,
	0x5867: 0x847D,
	0x5868: 0x8481,
	0x5869: 0x8485,
	0x586A: 0x8492,
	0x586B: 0x8493,
	0x586C: 0x8495,
	0x586D: 0x849E,
	0x586E: 0x84A6,
	0x586F: 0x84A8,
	0x5870: 0x84A9,
	0x5871: 0x84AA,
	0x5872: 0x84AF,
	0x5873: 0x84B1,
	0x5874: 0x84B4,
	0x5875: 0x84BA,
	0x5876: 0x84BD,
	0x5877: 0x84BE,
	0x5878: 0x84C0,
	0x5879: 0x84C2,
	0x587A: 0x84C7,
	0x587B: 0x84C8,
	0x587C: 0x84CC,
	0x587D: 0x84CF,
	0x587E: 0x84D3,
	0x5921: 0x84DC,
	0x5922: 0x84E7,
	0x5923: 0x84EA,
	0x5924: 0x84EF,
	0x5925: 0x84F0,
	0x5926: 0x84F1,
	0x5927: 0x84F2,
	0x5928: 0x84F7,
	0x5929: 0x8532,
	0x592A: 0x84FA,
	0x592B: 0x84FB,
	0x592C: 0x84FD,
	0x592D: 0x8502,
	0x592E: 0x8503,
	0x592F: 0x8507,
	0x5930: 0x850C,
	0x5931: 0x850E,
	0x5932: 0x8510,
	0x5933: 0x851C,
	0x5934: 0x851E,
	0x5935: 0x8522,
	0x5936: 0x8523,
	0x5937: 0x8524,
	0x5938: 0x8525,
	0x5939: 0x8527,
	0x593A: 0x852A,
	0x593B: 0x852B,
	0x593C: 0x852F,
	0x593D: 0x8533,
	0x593E: 0x8534,
	0x593F: 0x8536,
	0x5940: 0x853F,
	0x5941: 0x8546,
	0x5942: 0x854F,
	0x5943: 0x8550,
	0x5944: 0x8551,
	0x5945: 0x8552,
	0x5946: 0x8553,
	0x5947: 0x8556,
	0x5948: 0x8559,
	0x5949: 0x855C,
	0x594A: 0x855D,
	0x594B: 0x855E,
	0x594C: 0x855F,
	0x594D: 0x8560,
	0x594E: 0x8561,
	0x594F: 0x8562,
	0x5950: 0x8564,
	0x5951: 0x856B,
	0x5952: 0x856F,
	0x5953: 0x8579,
	0x5954: 0x857A,
	0x5955: 0x857B,
	0x5956: 0x857D,
	0x5957: 0x857F,
	0x5958: 0x8581,
	0x5959: 0x8585,
	0x595A: 0x8586,
	0x595B: 0x8589,
	0x595C: 0x858B,
	0x595D: 0x858C,
	0x595E: 0x858F,
	0x595F: 0x8593,
	0x5960: 0x8598,
	0x5961: 0x859D,
	0x5962: 0x859F,
	0x5963: 0x85A0,
	0x5964: 0x85A2,
	0x5965: 0x85A5,
	0x5966: 0x85A7,
	0x5967: 0x85B4,
	0x5968: 0x85B6,
	0x5969: 0x85B7,
	0x596A: 0x85B8,
	0x596B: 0x85BC,
	0x596C: 0x85BD,
	0x596D: 0x85BE,
	0x596E: 0x85BF,
	0x596F: 0x85C2,
	0x5970: 0x85C7,
	0x5971: 0x85CA,
	0x5972: 0x85CB,
	0x5973: 0x85CE,
	0x5974: 0x85AD,
	0x5975: 0x85D8,
	0x5976: 0x85DA,
	0x5977: 0x85DF,
	0x5978: 0x85E0,
	0x5979: 0x85E6,
	0x597A: 0x85E8,
	0x597B: 0x85ED,
	0x597C: 0x85F3,
	0x597D: 0x85F6,
	0x597E: 0x85FC,
	0x5A21: 0x85FF,
	0x5A22: 0x8600,
	0x5A23: 0x8604,
	0x5A24: 0x8605,
	0x5A25: 0x860D,
	0x5A26: 0x860E,
	0x5A27: 0x8610,
	0x5A28: 0x8611,
	0x5A29: 0x8612,
	0x5A2A: 0x8618,
	0x5A2B: 0x8619,
	0x5A2C: 0x861B,
	0x5A2D: 0x861E,
	0x5A2E: 0x8621,
	0x5A2F: 0x8627,
	0x5A30: 0x8629,
	0x5A31: 0x8636,
	0x5A32: 0x8638,
	0x5A33: 0x863A,
	0x5A34: 0x863C,
	0x5A35: 0x863D,
	0x5A36: 0x8640,
	0x5A37: 0x8642,
	0x5A38: 0x8646,
	0x5A39: 0x8652,
	0x5A3A: 0x8653,
	0x5A3B: 0x8656,
	0x5A3C: 0x8657,
	0x5A3D: 0x8658,
	0x5A3E: 0x8659,
	0x5A3F: 0x865D,
	0x5A40: 0x8660,
	0x5A41: 0x8661,
	0x5A42: 0x8662,
	0x5A43: 0x8663,
	0x5A44: 0x8664,
	0x5A45: 0x8669,
	0x5A46: 0x866C,
	0x5A47: 0x866F,
	0x5A48: 0x8675,
	0x5A49: 0x8676,
	0x5A4A: 0x8677,
	0x5A4B: 0x867A,
	0x5A4C: 0x868D,
	0x5A4D: 0x8691,
	0x5A4E: 0x8696,
	0x5A4F: 0x8698,
	0x5A50: 0x869A,
	0x5A51: 0x869C,
	0x5A52: 0x86A1,
	0x5A53: 0x86A6,
	0x5A54: 0x86A7,
	0x5A55: 0x86A8,
	0x5A56: 0x86AD,
	0x5A57: 0x86B1,
	0x5A58: 0x86B3,
	0x5A59: 0x86B4,
	0x5A5A: 0x86B5,
	0x5A5B: 0x86B7,
	0x5A5C: 0x86B8,
	0x5A5D: 0x86B9,
	0x5A5E: 0x86BF,
	0x5A5F: 0x86C0,
	0x5A60: 0x86C1,
	0x5A61: 0x86C3,
	0x5A62: 0x86C5,
	0x5A63: 0x86D1,
	0x5A64: 0x86D2,
	0x5A65: 0x86D5,
	0x5A66: 0x86D7,
	0x5A67: 0x86DA,
	0x5A68: 0x86DC,
	0x5A69: 0x86E0,
	0x5A6A: 0x86E3,
	0x5A6B: 0x86E5,
	0x5A6C: 0x86E7,
	0x5A6D: 0x8688,
	0x5A6E: 0x86FA,
	0x5A6F: 0x86FC,
	0x5A70: 0x86FD,
	0x5A71: 0x8704,
	0x5A72: 0x8705,
	0x5A73: 0x8707,
	0x5A74: 0x870B,
	0x5A75: 0x870E,
	0x5A76: 0x870F,
	0x5A77: 0x8710,
	0x5A78: 0x8713,
	0x5A79: 0x8714,
	0x5A7A: 0x8719,
	0x5A7B: 0x871E,
	0x5A7C: 0x871F,
	0x5A7D: 0x8721,
	0x5A7E: 0x8723,
	0x5B21: 0x8728,
	0x5B22: 0x872E,
	0x5B23: 0x872F,
	0x5B24: 0x8731,
	0x5B25: 0x8732,
	0x5B26: 0x8739,
	0x5B27: 0x873A,
	0x5B28: 0x873C,
	0x5B29: 0x873D,
	0x5B2A: 0x873E,
	0x5B2B: 0x8740,
	0x5B2C: 0x8743,
	0x5B2D: 0x8745,
	0x5B2E: 0x874D,
	0x5B2F: 0x8758,
	0x5B30: 0x875D,
	0x5B31: 0x8761,
	0x5B32: 0x8764,
	0x5B33: 0x8765,
	0x5B34: 0x876F,
	0x5B35: 0x8771,
	0x5B36: 0x8772,
	0x5B37: 0x877B,
	0x5B38: 0x8783,
	0x5B39: 0x8784,
	0x5B3A: 0x8785,
	0x5B3B: 0x8786,
	0x5B3C: 0x8787,
	0x5B3D: 0x8788,
	0x5B3E: 0x8789,
	0x5B3F: 0x878B,
	0x5B40: 0x878C,
	0x5B41: 0x8790,
	0x5B42: 0x8793,
	0x5B43: 0x8795,
	0x5B44: 0x8797,
	0x5B45: 0x8798,
	0x5B46: 0x8799,
	0x5B47: 0x879E,
	0x5B48: 0x87A0,
	0x5B49: 0x87A3,
	0x5B4A: 0x87A7,
	0x5B4B: 0x87AC,
	0x5B4C: 0x87AD,
	0x5B4D: 0x87AE,
	0x5B4E: 0x87B1,
	0x5B4F: 0x87B5,
	0x5B50: 0x87BE,
	0x5B51: 0x87BF,
	0x5B52: 0x87C1,
	0x5B53: 0x87C8,
	0x5B54: 0x87C9,
	0x5B55: 0x87CA,
	0x5B56: 0x87CE,
	0x5B57: 0x87D5,
	0x5B58: 0x87D6,
	0x5B59: 0x87D9,
	0x5B5A: 0x87DA,
	0x5B5B: 0x87DC,
	0x5B5C: 0x87DF,
	0x5B5D: 0x87E2,
	0x5B5E: 0x87E3,
	0x5B5F: 0x87E4,
	0x5B60: 0x87EA,
	0x5B61: 0x87EB,
	0x5B62: 0x87ED,
	0x5B63: 0x87F1,
	0x5B64: 0x87F3,
	0x5B65: 0x87F8,
	0x5B66: 0x87FA,
	0x5B67: 0x87FF,
	0x5B68: 0x8801,
	0x5B69: 0x8803,
	0x5B6A: 0x8806,
	0x5B6B: 0x8809,
	0x5B6C: 0x880A,
	0x5B6D: 0x880B,
	0x5B6E: 0x8810,
	0x5B6F: 0x8819,
	0x5B70: 0x8812,
	0x5B71: 0x8813,
	0x5B72: 0x8814,
	0x5B73: 0x8818,
	0x5B74: 0x881A,
	0x5B75: 0x881B,
	0x5B76: 0x881C,
	0x5B77: 0x881E,
	0x5B78: 0x881F,
	0x5B79: 0x8828,
	0x5B7A: 0x882D,
	0x5B7B: 0x882E,
	0x5B7C: 0x8830,
	0x5B7D: 0x8832,
	0x5B7E: 0x8835,
	0x5C21: 0x883A,
	0x5C22: 0x883C,
	0x5C23: 0x8841,
	0x5C24: 0x8843,
	0x5C25: 0x8845,
	0x5C26: 0x8848,
	0x5C27: 0x8849,
	0x5C28: 0x884A,
	0x5C29: 0x884B,
	0x5C2A: 0x884E,
	0x5C2B: 0x8851,
	0x5C2C: 0x8855,
	0x5C2D: 0x8856,
	0x5C2E: 0x8858,
	0x5C2F: 0x885A,
	0x5C30: 0x885C,
	0x5C31: 0x885F,
	0x5C32: 0x8860,
	0x5C33: 0x8864,
	0x5C34: 0x8869,
	0x5C35: 0x8871,
	0x5C36: 0x8879,
	0x5C37: 0x887B,
	0x5C38: 0x8880,
	0x5C39: 0x8898,
	0x5C3A: 0x889A,
	0x5C3B: 0x889B,
	0x5C3C: 0x889C,
	0x5C3D: 0x889F,
	0x5C3E: 0x88A0,
	0x5C3F: 0x88A8,
	0x5C40: 0x88AA,
	0x5C41: 0x88BA,
	0x5C42: 0x88BD,
	0x5C43: 0x88BE,
	0x5C44: 0x88C0,
	0x5C45: 0x88CA,
	0x5C46: 0x88CB,
	0x5C47: 0x88CC,
	0x5C48: 0x88CD,
	0x5C49: 0x88CE,
	0x5C4A: 0x88D1,
	0x5C4B: 0x88D2,
	0x5C4C: 0x88D3,
	0x5C4D: 0x88DB,
	0x5C4E: 0x88DE,
	0x5C4F: 0x88E7,
	0x5C50: 0x88EF,
	0x5C51: 0x88F0,
	0x5C52: 0x88F1,
	0x5C53: 0x88F5,
	0x5C54: 0x88F7,
	0x5C55: 0x8901,
	0x5C56: 0x8906,
	0x5C57: 0x890D,
	0x5C58: 0x890E,
	0x5C59: 0x890F,
	0x5C5A: 0x8915,
	0x5C5B: 0x8916,
	0x5C5C: 0x8918,
	0x5C5D: 0x8919,
	0x5C5E: 0x891A,
	0x5C5F: 0x891C,
	0x5C60: 0x8920,
	0x5C61: 0x8926,
	0x5C62: 0x8927,
	0x5C63: 0x8928,
	0x5C64: 0x8930,
	0x5C65: 0x8931,
	0x5C66: 0x8932,
	0x5C67: 0x8935,
	0x5C68: 0x8939,
	0x5C69: 0x893A,
	0x5C6A: 0x893E,
	0x5C6B: 0x8940,
	0x5C6C: 0x8942,
	0x5C6D: 0x8945,
	0x5C6E: 0x8946,
	0x5C6F: 0x8949,
	0x5C70: 0x894F,
	0x5C71: 0x8952,
	0x5C72: 0x8957,
	0x5C73: 0x895A,
	0x5C74: 0x895B,
	0x5C75: 0x895C,
	0x5C76: 0x8961,
	0x5C77: 0x8962,
	0x5C78: 0x8963,
	0x5C79: 0x896B,
	0x5C7A: 0x896E,
	0x5C7B: 0x8970,
	0x5C7C: 0x8973,
	0x5C7D: 0x8975,
	0x5C7E: 0x897A,
	0x5D21: 0x897B,
	0x5D22: 0x897C,
	0x5D23: 0x897D,
	0x5D24: 0x8989,
	0x5D25: 0x898D,
	0x5D26: 0x8990,
	0x5D27: 0x8994,
	0x5D28: 0x8995,
	0x5D29: 0x899B,
	0x5D2A: 0x899C,
	0x5D2B: 0x899F,
	0x5D2C: 0x89A0,
	0x5D2D: 0x89A5,
	0x5D2E: 0x89B0,
	0x5D2F: 0x89B4,
	0x5D30: 0x89B5,
	0x5D31: 0x89B6,
	0x5D32: 0x89B7,
	0x5D33: 0x89BC,
	0x5D34: 0x89D4,
	0x5D35: 0x89D5,
	0x5D36: 0x89D6,
	0x5D37: 0x89D7,
	0x5D38: 0x89D8,
	0x5D39: 0x89E5,
	0x5D3A: 0x89E9,
	0x5D3B: 0x89EB,
	0x5D3C: 0x89ED,
	0x5D3D: 0x89F1,
	0x5D3E: 0x89F3,
	0x5D3F: 0x89F6,
	0x5D40: 0x89F9,
	0x5D41: 0x89FD,
	0x5D42: 0x89FF,
	0x5D43: 0x8A04,
	0x5D44: 0x8A05,
	0x5D45: 0x8A07,
	0x5D46: 0x8A0F,
	0x5D47: 0x8A11,
	0x5D48: 0x8A12,
	0x5D49: 0x8A14,
	0x5D4A: 0x8A15,
	0x5D4B: 0x8A1E,
	0x5D4C: 0x8A20,
	0x5D4D: 0x8A22,
	0x5D4E: 0x8A24,
	0x5D4F: 0x8A26,
	0x5D50: 0x8A2B,
	0x5D51: 0x8A2C,
	0x5D52: 0x8A2F,
	0x5D53: 0x8A35,
	0x5D54: 0x8A37,
	0x5D55: 0x8A3D,
	0x5D56: 0x8A3E,
	0x5D57: 0x8A40,
	0x5D58: 0x8A43,
	0x5D59: 0x8A45,
	0x5D5A: 0x8A47,
	0x5D5B: 0x8A49,
	0x5D5C: 0x8A4D,
	0x5D5D: 0x8A4E,
	0x5D5E: 0x8A53,
	0x5D5F: 0x8A56,
	0x5D60: 0x8A57,
	0x5D61: 0x8A58,
	0x5D62: 0x8A5C,
	0x5D63: 0x8A5D,
	0x5D64: 0x8A61,
	0x5D65: 0x8A65,
	0x5D66: 0x8A67,
	0x5D67: 0x8A75,
	0x5D68: 0x8A76,
	0x5D69: 0x8A77,
	0x5D6A: 0x8A79,
	0x5D6B: 0x8A7A,
	0x5D6C: 0x8A7B,
	0x5D6D: 0x8A7E,
	0x5D6E: 0x8A7F,
	0x5D6F: 0x8A80,
	0x5D70: 0x8A83,
	0x5D71: 0x8A86,
	0x5D72: 0x8A8B,
	0x5D73: 0x8A8F,
	0x5D74: 0x8A90,
	0x5D75: 0x8A92,
	0x5D76: 0x8A96,
	0x5D77: 0x8A97,
	0x5D78: 0x8A99,
	0x5D79: 0x8A9F,
	0x5D7A: 0x8AA7,
	0x5D7B: 0x8AA9,
	0x5D7C: 0x8AAE,
	0x5D7D: 0x8AAF,
	0x5D7E: 0x8AB3,
	0x5E21: 0x8AB6,
	0x5E22: 0x8AB7,
	0x5E23: 0x8ABB,
	0x5E24: 0x8ABE,
	0x5E25: 0x8AC3,
	0x5E26: 0x8AC6,
	0x5E27: 0x8AC8,
	0x5E28: 0x8AC9,
	0x5E29: 0x8ACA,
	0x5E2A: 0x8AD1,
	0x5E2B: 0x8AD3,
	0x5E2C: 0x8AD4,
	0x5E2D: 0x8AD5,
	0x5E2E: 0x8AD7,
	0x5E2F: 0x8ADD,
	0x5E30: 0x8ADF,
	0x5E31: 0x8AEC,
	0x5E32: 0x8AF0,
	0x5E33: 0x8AF4,
	0x5E34: 0x8AF5,
	0x5E35: 0x8AF6,
	0x5E36: 0x8AFC,
	0x5E37: 0x8AFF,
	0x5E38: 0x8B05,
	0x5E39: 0x8B06,
	0x5E3A: 0x8B0B,
	0x5E3B: 0x8B11,
	0x5E3C: 0x8B1C,
	0x5E3D: 0x8B1E,
	0x5E3E: 0x8B1F,
	0x5E3F: 0x8B0A,
	0x5E40: 0x8B2D,
	0x5E41: 0x8B30,
	0x5E42: 0x8B37,
	0x5E43: 0x8B3C,
	0x5E44: 0x8B42,
	0x5E45: 0x8B43,
	0x5E46: 0x8B44,
	0x5E47: 0x8B45,
	0x5E48: 0x8B46,
	0x5E49: 0x8B48,
	0x5E4A: 0x8B52,
	0x5E4B: 0x8B53,
	0x5E4C: 0x8B54,
	0x5E4D: 0x8B59,
	0x5E4E: 0x8B4D,
	0x5E4F: 0x8B5E,
	0x5E50: 0x8B63,
	0x5E51: 0x8B6D,
	0x5E52: 0x8B76,
	0x5E53: 0x8B78,
	0x5E54: 0x8B79,
	0x5E55: 0x8B7C,
	0x5E56: 0x8B7E,
	0x5E57: 0x8B81,
	0x5E58: 0x8B84,
	0x5E59: 0x8B85,
	0x5E5A: 0x8B8B,
	0x5E5B: 0x8B8D,
	0x5E5C: 0x8B8F,
	0x5E5D: 0x8B94,
	0x5E5E: 0x8B95,
	0x5E5F: 0x8B9C,
	0x5E60: 0x8B9E,
	0x5E61: 0x8B9F,
	0x5E62: 0x8C38,
	0x5E63: 0x8C39,
	0x5E64: 0x8C3D,
	0x5E65: 0x8C3E,
	0x5E66: 0x8C45,
	0x5E67: 0x8C47,
	0x5E68: 0x8C49,
	0x5E69: 0x8C4B,
	0x5E6A: 0x8C4F,
	0x5E6B: 0x8C51,
	0x5E6C: 0x8C53,
	0x5E6D: 0x8C54,
	0x5E6E: 0x8C57,
	0x5E6F: 0x8C58,
	0x5E70: 0x8C5B,
	0x5E71: 0x8C5D,
	0x5E72: 0x8C59,
	0x5E73: 0x8C63,
	0x5E74: 0x8C64,
	0x5E75: 0x8C66,
	0x5E76: 0x8C68,
	0x5E77: 0x8C69,
	0x5E78: 0x8C6D,
	0x5E79: 0x8C73,
	0x5E7A: 0x8C75,
	0x5E7B: 0x8C76,
	0x5E7C: 0x8C7B,
	0x5E7D: 0x8C7E,
	0x5E7E: 0x8C86,
	0x5F21: 0x8C87,
	0x5F22: 0x8C8B,
	0x5F23: 0x8C90,
	0x5F24: 0x8C92,
	0x5F25: 0x8C93,
	0x5F26: 0x8C99,
	0x5F27: 0x8C9B,
	0x5F28: 0x8C9C,
	0x5F29: 0x8CA4,
	0x5F2A: 0x8CB9,
	0x5F2B: 0x8CBA,
	0x5F2C: 0x8CC5,
	0x5F2D: 0x8CC6,
	0x5F2E: 0x8CC9,
	0x5F2F: 0x8CCB,
	0x5F30: 0x8CCF,
	0x5F31: 0x8CD6,
	0x5F32: 0x8CD5,
	0x5F33: 0x8CD9,
	0x5F34: 0x8CDD,
	0x5F35: 0x8CE1,
	0x5F36: 0x8CE8,
	0x5F37: 0x8CEC,
	0x5F38: 0x8CEF,
	0x5F39: 0x8CF0,
	0x5F3A: 0x8CF2,
	0x5F3B: 0x8CF5,
	0x5F3C: 0x8CF7,
	0x5F3D: 0x8CF8,
	0x5F3E: 0x8CFE,
	0x5F3F: 0x8CFF,
	0x5F40: 0x8D01,
	0x5F41: 0x8D03,
	0x5F42: 0x8D09,
	0x5F43: 0x8D12,
	0x5F44: 0x8D17,
	0x5F45: 0x8D1B,
	0x5F46: 0x8D65,
	0x5F47: 0x8D69,
	0x5F48: 0x8D6C,
	0x5F49: 0x8D6E,
	0x5F4A: 0x8D7F,
	0x5F4B: 0x8D82,
	0x5F4C: 0x8D84,
	0x5F4D: 0x8D88,
	0x5F4E: 0x8D8D,
	0x5F4F: 0x8D90,
	0x5F50: 0x8D91,
	0x5F51: 0x8D95,
	0x5F52: 0x8D9E,
	0x5F53: 0x8D9F,
	0x5F54: 0x8DA0,
	0x5F55: 0x8DA6,
	0x5F56: 0x8DAB,
	0x5F57: 0x8DAC,
	0x5F58: 0x8DAF,
	0x5F59: 0x8DB2,
	0x5F5A: 0x8DB5,
	0x5F5B: 0x8DB7,
	0x5F5C: 0x8DB9,
	0x5F5D: 0x8DBB,
	0x5F5E: 0x8DC0,
	0x5F5F: 0x8DC5,
	0x5F60: 0x8DC6,
	0x5F61: 0x8DC7,
	0x5F62: 0x8DC8,
	0x5F63: 0x8DCA,
	0x5F64: 0x8DCE,
	0x5F65: 0x8DD1,
	0x5F66: 0x8DD4,
	0x5F67: 0x8DD5,
	0x5F68: 0x8DD7,
	0x5F69: 0x8DD9,
	0x5F6A: 0x8DE4,
	0x5F6B: 0x8DE5,
	0x5F6C: 0x8DE7,
	0x5F6D: 0x8DEC,
	0x5F6E: 0x8DF0,
	0x5F6F: 0x8DBC,
	0x5F70: 0x8DF1,
	0x5F71: 0x8DF2,
	0x5F72: 0x8DF4,
	0x5F73: 0x8DFD,
	0x5F74: 0x8E01,
	0x5F75: 0x8E04,
	0x5F76: 0x8E05,
	0x5F77: 0x8E06,
	0x5F78: 0x8E0B,
	0x5F79: 0x8E11,
	0x5F7A: 0x8E14,
	0x5F7B: 0x8E16,
	0x5F7C: 0x8E20,
	0x5F7D: 0x8E21,
	0x5F7E: 0x8E22,
	0x6021: 0x8E23,
	0x6022: 0x8E26,
	0x6023: 0x8E27,
	0x6024: 0x8E31,
	0x6025: 0x8E33,
	0x6026: 0x8E36,
	0x6027: 0x8E37,
	0x6028: 0x8E38,
	0x6029: 0x8E39,
	0x602A: 0x8E3D,
	0x602B: 0x8E40,
	0x602C: 0x8E41,
	0x602D: 0x8E4B,
	0x602E: 0x8E4D,
	0x602F: 0x8E4E,
	0x6030: 0x8E4F,
	0x6031: 0x8E54,
	0x6032: 0x8E5B,
	0x6033: 0x8E5C,
	0x6034: 0x8E5D,
	0x6035: 0x8E5E,
	0x6036: 0x8E61,
	0x6037: 0x8E62,
	0x6038: 0x8E69,
	0x6039: 0x8E6C,
	0x603A: 0x8E6D,
	0x603B: 0x8E6F,
	0x603C: 0x8E70,
	0x603D: 0x8E71,
	0x603E: 0x8E79,
	0x603F: 0x8E7A,
	0x6040: 0x8E7B,
	0x6041: 0x8E82,
	0x6042: 0x8E83,
	0x6043: 0x8E89,
	0x6044: 0x8E90,
	0x6045: 0x8E92,
	0x6046: 0x8E95,
	0x6047: 0x8E9A,
	0x6048: 0x8E9B,
	0x6049: 0x8E9D,
	0x604A: 0x8E9E,
	0x604B: 0x8EA2,
	0x604C: 0x8EA7,
	0x604D: 0x8EA9,
	0x604E: 0x8EAD,
	0x604F: 0x8EAE,
	0x6050: 0x8EB3,
	0x6051: 0x8EB5,
	0x6052: 0x8EBA,
	0x6053: 0x8EBB,
	0x6054: 0x8EC0,
	0x6055: 0x8EC1,
	0x6056: 0x8EC3,
	0x6057: 0x8EC4,
	0x6058: 0x8EC7,
	0x6059: 0x8ECF,
	0x605A: 0x8ED1,
	0x605B: 0x8ED4,
	0x605C: 0x8EDC,
	0x605D: 0x8EE8,
	0x605E: 0x8EEE,
	0x605F: 0x8EF0,
	0x6060: 0x8EF1,
	0x6061: 0x8EF7,
	0x6062: 0x8EF9,
	0x6063: 0x8EFA,
	0x6064: 0x8EED,
	0x6065: 0x8F00,
	0x6066: 0x8F02,
	0x6067: 0x8F07,
	0x6068: 0x8F08,
	0x6069: 0x8F0F,
	0x606A: 0x8F10,
	0x606B: 0x8F16,
	0x606C: 0x8F17,
	0x606D: 0x8F18,
	0x606E: 0x8F1E,
	0x606F: 0x8F20,
	0x6070: 0x8F21,
	0x6071: 0x8F23,
	0x6072: 0x8F25,
	0x6073: 0x8F27,
	0x6074: 0x8F28,
	0x6075: 0x8F2C,
	0x6076: 0x8F2D,
	0x6077: 0x8F2E,
	0x6078: 0x8F34,
	0x6079: 0x8F35,
	0x607A: 0x8F36,
	0x607B: 0x8F37,
	0x607C: 0x8F3A,
	0x607D: 0x8F40,
	0x607E: 0x8F41,
	0x6121: 0x8F43,
	0x6122: 0x8F47,
	0x6123: 0x8F4F,
	0x6124: 0x8F51,
	0x6125: 0x8F52,
	0x6126: 0x8F53,
	0x6127: 0x8F54,
	0x6128: 0x8F55,
	0x6129: 0x8F58,
	0x612A: 0x8F5D,
	0x612B: 0x8F5E,
	0x612C: 0x8F65,
	0x612D: 0x8F9D,
	0x612E: 0x8FA0,
	0x612F: 0x8FA1,
	0x6130: 0x8FA4,
	0x6131: 0x8FA5,
	0x6132: 0x8FA6,
	0x6133: 0x8FB5,
	0x6134: 0x8FB6,
	0x6135: 0x8FB8,
	0x6136: 0x8FBE,
	0x6137: 0x8FC0,
	0x6138: 0x8FC1,
	0x6139: 0x8FC6,
	0x613A: 0x8FCA,
	0x613B: 0x8FCB,
	0x613C: 0x8FCD,
	0x613D: 0x8FD0,
	0x613E: 0x8FD2,
	0x613F: 0x8FD3,
	0x6140: 0x8FD5,
	0x6141: 0x8FE0,
	0x6142: 0x8FE3,
	0x6143: 0x8FE4,
	0x6144: 0x8FE8,
	0x6145: 0x8FEE,
	0x6146: 0x8FF1,
	0x6147: 0x8FF5,
	0x6148: 0x8FF6,
	0x6149: 0x8FFB,
	0x614A: 0x8FFE,
	0x614B: 0x9002,
	0x614C: 0x9004,
	0x614D: 0x9008,
	0x614E: 0x900C,
	0x614F: 0x9018,
	0x6150: 0x901B,
	0x6151: 0x9028,
	0x6152: 0x9029,
	0x6153: 0x902F,
	0x6154: 0x902A,
	0x6155: 0x902C,
	0x6156: 0x902D,
	0x6157: 0x9033,
	0x6158: 0x9034,
	0x6159: 0x9037,
	0x615A: 0x903F,
	0x615B: 0x9043,
	0x615C: 0x9044,
	0x615D: 0x904C,
	0x615E: 0x905B,
	0x615F: 0x905D,
	0x6160: 0x9062,
	0x6161: 0x9066,
	0x6162: 0x9067,
	0x6163: 0x906C,
	0x6164: 0x9070,
	0x6165: 0x9074,
	0x6166: 0x9079,
	0x6167: 0x9085,
	0x6168: 0x9088,
	0x6169: 0x908B,
	0x616A: 0x908C,
	0x616B: 0x908E,
	0x616C: 0x9090,
	0x616D: 0x9095,
	0x616E: 0x9097,
	0x616F: 0x9098,
	0x6170: 0x9099,
	0x6171: 0x909B,
	0x6172: 0x90A0,
	0x6173: 0x90A1,
	0x6174: 0x90A2,
	0x6175: 0x90A5,
	0x6176: 0x90B0,
	0x6177: 0x90B2,
	0x6178: 0x90B3,
	0x6179: 0x90B4,
	0x617A: 0x90B6,
	0x617B: 0x90BD,
	0x617C: 0x90CC,
	0x617D: 0x90BE,
	0x617E: 0x90C3,
	0x6221: 0x90C4,
	0x6222: 0x90C5,
	0x6223: 0x90C7,
	0x6224: 0x90C8,
	0x6225: 0x90D5,
	0x6226: 0x90D7,
	0x6227: 0x90D8,
	0x6228: 0x90D9,
	0x6229: 0x90DC,
	0x622A: 0x90DD,
	0x622B: 0x90DF,
	0x622C: 0x90E5,
	0x622D: 0x90D2,
	0x622E: 0x90F6,
	0x622F: 0x90EB,
	0x6230: 0x90EF,
	0x6231: 0x90F0,
	0x6232: 0x90F4,
	0x6233: 0x90FE,
	0x6234: 0x90FF,
	0x6235: 0x9100,
	0x6236: 0x9104,
	0x6237: 0x9105,
	0x6238: 0x9106,
	0x6239: 0x9108,
	0x623A: 0x910D,
	0x623B: 0x9110,
	0x623C: 0x9114,
	0x623D: 0x9116,
	0x623E: 0x9117,
	0x623F: 0x9118,
	0x6240: 0x911A,
	0x6241: 0x911C,
	0x6242: 0x911E,
	0x6243: 0x9120,
	0x6244: 0x9125,
	0x6245: 0x9122,
	0x6246: 0x9123,
	0x6247: 0x9127,
	0x6248: 0x9129,
	0x6249: 0x912E,
	0x624A: 0x912F,
	0x624B: 0x9131,
	0x624C: 0x9134,
	0x624D: 0x9136,
	0x624E: 0x9137,
	0x624F: 0x9139,
	0x6250: 0x913A,
	0x6251: 0x913C,
	0x6252: 0x913D,
	0x6253: 0x9143,
	0x6254: 0x9147,
	0x6255: 0x9148,
	0x6256: 0x914F,
	0x6257: 0x9153,
	0x6258: 0x9157,
	0x6259: 0x9159,
	0x625A: 0x915A,
	0x625B: 0x915B,
	0x625C: 0x9161,
	0x625D: 0x9164,
	0x625E: 0x9167,
	0x625F: 0x916D,
	0x6260: 0x9174,
	0x6261: 0x9179,
	0x6262: 0x917A,
	0x6263: 0x917B,
	0x6264: 0x9181,
	0x6265: 0x9183,
	0x6266: 0x9185,
	0x6267: 0x9186,
	0x6268: 0x918A,
	0x6269: 0x918E,
	0x626A: 0x9191,
	0x626B: 0x9193,
	0x626C: 0x9194,
	0x626D: 0x9195,
	0x626E: 0x9198,
	0x626F: 0x919E,
	0x6270: 0x91A1,
	0x6271: 0x91A6,
	0x6272: 0x91A8,
	0x6273: 0x91AC,
	0x6274: 0x91AD,
	0x6275: 0x91AE,
	0x6276: 0x91B0,
	0x6277: 0x91B1,
	0x6278: 0x91B2,
	0x6279: 0x91B3,
	0x627A: 0x91B6,
	0x627B: 0x91BB,
	0x627C: 0x91BC,
	0x627D: 0x91BD,
	0x627E: 0x91BF,
	0x6321: 0x91C2,
	0x6322: 0x91C3,
	0x6323: 0x91C5,
	0x6324: 0x91D3,
	0x6325: 0x91D4,
	0x6326: 0x91D7,
	0x6327: 0x91D9,
	0x6328: 0x91DA,
	0x6329: 0x91DE,
	0x632A: 0x91E4,
	0x632B: 0x91E5,
	0x632C: 0x91E9,
	0x632D: 0x91EA,
	0x632E: 0x91EC,
	0x632F: 0x91ED,
	0x6330: 0x91EE,
	0x6331: 0x91EF,
	0x6332: 0x91F0,
	0x6333: 0x91F1,
	0x6334: 0x91F7,
	0x6335: 0x91F9,
	0x6336: 0x91FB,
	0x6337: 0x91FD,
	0x6338: 0x9200,
	0x6339: 0x9201,
	0x633A: 0x9204,
	0x633B: 0x9205,
	0x633C: 0x9206,
	0x633D: 0x9207,
	0x633E: 0x9209,
	0x633F: 0x920A,
	0x6340: 0x920C,
	0x6341: 0x9210,
	0x6342: 0x9212,
	0x6343: 0x9213,
	0x6344: 0x9216,
	0x6345: 0x9218,
	0x6346: 0x921C,
	0x6347: 0x921D,
	0x6348: 0x9223,
	0x6349: 0x9224,
	0x634A: 0x9225,
	0x634B: 0x9226,
	0x634C: 0x9228,
	0x634D: 0x922E,
	0x634E: 0x922F,
	0x634F: 0x9230,
	0x6350: 0x9233,
	0x6351: 0x9235,
	0x6352: 0x9236,
	0x6353: 0x9238,
	0x6354: 0x9239,
	0x6355: 0x923A,
	0x6356: 0x923C,
	0x6357: 0x923E,
	0x6358: 0x9240,
	0x6359: 0x9242,
	0x635A: 0x9243,
	0x635B: 0x9246,
	0x635C: 0x9247,
	0x635D: 0x924A,
	0x635E: 0x924D,
	0x635F: 0x924E,
	0x6360: 0x924F,
	0x6361: 0x9251,
	0x6362: 0x9258,
	0x6363: 0x9259,
	0x6364: 0x925C,
	0x6365: 0x925D,
	0x6366: 0x9260,
	0x6367: 0x9261,
	0x6368: 0x9265,
	0x6369: 0x9267,
	0x636A: 0x9268,
	0x636B: 0x9269,
	0x636C: 0x926E,
	0x636D: 0x926F,
	0x636E: 0x9270,
	0x636F: 0x9275,
	0x6370: 0x9276,
	0x6371: 0x9277,
	0x6372: 0x9278,
	0x6373: 0x9279,
	0x6374: 0x927B,
	0x6375: 0x927C,
	0x6376: 0x927D,
	0x6377: 0x927F,
	0x6378: 0x9288,
	0x6379: 0x9289,
	0x637A: 0x928A,
	0x637B: 0x928D,
	0x637C: 0x928E,
	0x637D: 0x9292,
	0x637E: 0x9297,
	0x6421: 0x9299,
	0x6422: 0x929F,
	0x6423: 0x92A0,
	0x6424: 0x92A4,
	0x6425: 0x92A5,
	0x6426: 0x92A7,
	0x6427: 0x92A8,
	0x6428: 0x92AB,
	0x6429: 0x92AF,
	0x642A: 0x92B2,
	0x642B: 0x92B6,
	0x642C: 0x92B8,
	0x642D: 0x92BA,
	0x642E: 0x92BB,
	0x642F: 0x92BC,
	0x6430: 0x92BD,
	0x6431: 0x92BF,
	0x6432: 0x92C0,
	0x6433: 0x92C1,
	0x6434: 0x92C2,
	0x6435: 0x92C3,
	0x6436: 0x92C5,
	0x6437: 0x92C6,
	0x6438: 0x92C7,
	0x6439: 0x92C8,
	0x643A: 0x92CB,
	0x643B: 0x92CC,
	0x643C: 0x92CD,
	0x643D: 0x92CE,
	0x643E: 0x92D0,
	0x643F: 0x92D3,
	0x6440: 0x92D5,
	0x6441: 0x92D7,
	0x6442: 0x92D8,
	0x6443: 0x92D9,
	0x6444: 0x92DC,
	0x6445: 0x92DD,
	0x6446: 0x92DF,
	0x6447: 0x92E0,
	0x6448: 0x92E1,
	0x6449: 0x92E3,
	0x644A: 0x92E5,
	0x644B: 0x92E7,
	0x644C: 0x92E8,
	0x644D: 0x92EC,
	0x644E: 0x92EE,
	0x644F: 0x92F0,
	0x6450: 0x92F9,
	0x6451: 0x92FB,
	0x6452: 0x92FF,
	0x6453: 0x9300,
	0x6454: 0x9302,
	0x6455: 0x9308,
	0x6456: 0x930D,
	0x6457: 0x9311,
	0x6458: 0x9314,
	0x6459: 0x9315,
	0x645A: 0x931C,
	0x645B: 0x931D,
	0x645C: 0x931E,
	0x645D: 0x931F,
	0x645E: 0x9321,
	0x645F: 0x9324,
	0x6460: 0x9325,
	0x6461: 0x9327,
	0x6462: 0x9329,
	0x6463: 0x932A,
	0x6464: 0x9333,
	0x6465: 0x9334,
	0x6466: 0x9336,
	0x6467: 0x9337,
	0x6468: 0x9347,
	0x6469: 0x9348,
	0x646A: 0x9349,
	0x646B: 0x9350,
	0x646C: 0x9351,
	0x646D: 0x9352,
	0x646E: 0x9355,
	0x646F: 0x9357,
	0x6470: 0x9358,
	0x6471: 0x935A,
	0x6472: 0x935E,
	0x6473: 0x9364,
	0x6474: 0x9365,
	0x6475: 0x9367,
	0x6476: 0x9369,
	0x6477: 0x936A,
	0x6478: 0x936D,
	0x6479: 0x936F,
	0x647A: 0x9370,
	0x647B: 0x9371,
	0x647C: 0x9373,
	0x647D: 0x9374,
	0x647E: 0x9376,
	0x6521: 0x937A,
	0x6522: 0x937D,
	0x6523: 0x937F,
	0x6524: 0x9380,
	0x6525: 0x9381,
	0x6526: 0x9382,
	0x6527: 0x9388,
	0x6528: 0x938A,
	0x6529: 0x938B,
	0x652A: 0x938D,
	0x652B: 0x938F,
	0x652C: 0x9392,
	0x652D: 0x9395,
	0x652E: 0x9398,
	0x652F: 0x939B,
	0x6530: 0x939E,
	0x6531: 0x93A1,
	0x6532: 0x93A3,
	0x6533: 0x93A4,
	0x6534: 0x93A6,
	0x6535: 0x93A8,
	0x6536: 0x93AB,
	0x6537: 0x93B4,
	0x6538: 0x93B5,
	0x6539: 0x93B6,
	0x653A: 0x93BA,
	0x653B: 0x93A9,
	0x653C: 0x93C1,
	0x653D: 0x93C4,
	0x653E: 0x93C5,
	0x653F: 0x93C6,
	0x6540: 0x93C7,
	0x6541: 0x93C9,
	0x6542: 0x93CA,
	0x6543: 0x93CB,
	0x6544: 0x93CC,
	0x6545: 0x93CD,
	0x6546: 0x93D3,
	0x6547: 0x93D9,
	0x6548: 0x93DC,
	0x6549: 0x93DE,
	0x654A: 0x93DF,
	0x654B: 0x93E2,
	0x654C: 0x93E6,
	0x654D: 0x93E7,
	0x654E: 0x93F9,
	0x654F: 0x93F7,
	0x6550: 0x93F8,
	0x6551: 0x93FA,
	0x6552: 0x93FB,
	0x6553: 0x93FD,
	0x6554: 0x9401,
	0x6555: 0x9402,
	0x6556: 0x9404,
	0x6557: 0x9408,
	0x6558: 0x9409,
	0x6559: 0x940D,
	0x655A: 0x940E,
	0x655B: 0x940F,
	0x655C: 0x9415,
	0x655D: 0x9416,
	0x655E: 0x9417,
	0x655F: 0x941F,
	0x6560: 0x942E,
	0x6561: 0x942F,
	0x6562: 0x9431,
	0x6563: 0x9432,
	0x6564: 0x9433,
	0x6565: 0x9434,
	0x6566: 0x943B,
	0x6567: 0x943F,
	0x6568: 0x943D,
	0x6569: 0x9443,
	0x656A: 0x9445,
	0x656B: 0x9448,
	0x656C: 0x944A,
	0x656D: 0x944C,
	0x656E: 0x9455,
	0x656F: 0x9459,
	0x6570: 0x945C,
	0x6571: 0x945F,
	0x6572: 0x9461,
	0x6573: 0x9463,
	0x6574: 0x9468,
	0x6575: 0x946B,
	0x6576: 0x946D,
	0x6577: 0x946E,
	0x6578: 0x946F,
	0x6579: 0x9471,
	0x657A: 0x9472,
	0x657B: 0x9484,
	0x657C: 0x9483,
	0x657D: 0x9578,
	0x657E: 0x9579,
	0x6621: 0x957E,
	0x6622: 0x9584,
	0x6623: 0x9588,
	0x6624: 0x958C,
	0x6625: 0x958D,
	0x6626: 0x958E,
	0x6627: 0x959D,
	0x6628: 0x959E,
	0x6629: 0x959F,
	0x662A: 0x95A1,
	0x662B: 0x95A6,
	0x662C: 0x95A9,
	0x662D: 0x95AB,
	0x662E: 0x95AC,
	0x662F: 0x95B4,
	0x6630: 0x95B6,
	0x6631: 0x95BA,
	0x6632: 0x95BD,
	0x6633: 0x95BF,
	0x6634: 0x95C6,
	0x6635: 0x95C8,
	0x6636: 0x95C9,
	0x6637: 0x95CB,
	0x6638: 0x95D0,
	0x6639: 0x95D1,
	0x663A: 0x95D2,
	0x663B: 0x95D3,
	0x663C: 0x95D9,
	0x663D: 0x95DA,
	0x663E: 0x95DD,
	0x663F: 0x95DE,
	0x6640: 0x95DF,
	0x6641: 0x95E0,
	0x6642: 0x95E4,
	0x6643: 0x95E6,
	0x6644: 0x961D,
	0x6645: 0x961E,
	0x6646: 0x9622,
	0x6647: 0x9624,
	0x6648: 0x9625,
	0x6649: 0x9626,
	0x664A: 0x962C,
	0x664B: 0x9631,
	0x664C: 0x9633,
	0x664D: 0x9637,
	0x664E: 0x9638,
	0x664F: 0x9639,
	0x6650: 0x963A,
	0x6651: 0x963C,
	0x6652: 0x963D,
	0x6653: 0x9641,
	0x6654: 0x9652,
	0x6655: 0x9654,
	0x6656: 0x9656,
	0x6657: 0x9657,
	0x6658: 0x9658,
	0x6659: 0x9661,
	0x665A: 0x966E,
	0x665B: 0x9674,
	0x665C: 0x967B,
	0x665D: 0x967C,
	0x665E: 0x967E,
	0x665F: 0x967F,
	0x6660: 0x9681,
	0x6661: 0x9682,
	0x6662: 0x9683,
	0x6663: 0x9684,
	0x6664: 0x9689,
	0x6665: 0x9691,
	0x6666: 0x9696,
	0x6667: 0x969A,
	0x6668: 0x969D,
	0x6669: 0x969F,
	0x666A: 0x96A4,
	0x666B: 0x96A5,
	0x666C: 0x96A6,
	0x666D: 0x96A9,
	0x666E: 0x96AE,
	0x666F: 0x96AF,
	0x6670: 0x96B3,
	0x6671: 0x96BA,
	0x6672: 0x96CA,
	0x6673: 0x96D2,
	0x6674: 0x5DB2,
	0x6675: 0x96D8,
	0x6676: 0x96DA,
	0x6677: 0x96DD,
	0x6678: 0x96DE,
	0x6679: 0x96DF,
	0x667A: 0x96E9,
	0x667B: 0x96EF,
	0x667C: 0x96F1,
	0x667D: 0x96FA,
	0x667E: 0x9702,
	0x6721: 0x9703,
	0x6722: 0x9705,
	0x6723: 0x9709,
	0x6724: 0x971A,
	0x6725: 0x971B,
	0x6726: 0x971D,
	0x6727: 0x9721,
	0x6728: 0x9722,
	0x6729: 0x9723,
	0x672A: 0x9728,
	0x672B: 0x9731,
	0x672C: 0x9733,
	0x672D: 0x9741,
	0x672E: 0x9743,
	0x672F: 0x974A,
	0x6730: 0x974E,
	0x6731: 0x974F,
	0x6732: 0x9755,
	0x6733: 0x9757,
	0x6734: 0x9758,
	0x6735: 0x975A,
	0x6736: 0x975B,
	0x6737: 0x9763,
	0x6738: 0x9767,
	0x6739: 0x976A,
	0x673A: 0x976E,
	0x673B: 0x9773,
	0x673C: 0x9776,
	0x673D: 0x9777,
	0x673E: 0x9778,
	0x673F: 0x977B,
	0x6740: 0x977D,
	0x6741: 0x977F,
	0x6742: 0x9780,
	0x6743: 0x9789,
	0x6744: 0x9795,
	0x6745: 0x9796,
	0x6746: 0x9797,
	0x6747: 0x9799,
	0x6748: 0x979A,
	0x6749: 0x979E,
	0x674A: 0x979F,
	0x674B: 0x97A2,
	0x674C: 0x97AC,
	0x674D: 0x97AE,
	0x674E: 0x97B1,
	0x674F: 0x97B2,
	0x6750: 0x97B5,
	0x6751: 0x97B6,
	0x6752: 0x97B8,
	0x6753: 0x97B9,
	0x6754: 0x97BA,
	0x6755: 0x97BC,
	0x6756: 0x97BE,
	0x6757: 0x97BF,
	0x6758: 0x97C1,
	0x6759: 0x97C4,
	0x675A: 0x97C5,
	0x675B: 0x97C7,
	0x675C: 0x97C9,
	0x675D: 0x97CA,
	0x675E: 0x97CC,
	0x675F: 0x97CD,
	0x6760: 0x97CE,
	0x6761: 0x97D0,
	0x6762: 0x97D1,
	0x6763: 0x97D4,
	0x6764: 0x97D7,
	0x6765: 0x97D8,
	0x6766: 0x97D9,
	0x6767: 0x97DD,
	0x6768: 0x97DE,
	0x6769: 0x97E0,
	0x676A: 0x97DB,
	0x676B: 0x97E1,
	0x676C: 0x97E4,
	0x676D: 0x97EF,
	0x676E: 0x97F1,
	0x676F: 0x97F4,
	0x6770: 0x97F7,
	0x6771: 0x97F8,
	0x6772: 0x97FA,
	0x6773: 0x9807,
	0x6774: 0x980A,
	0x6775: 0x9819,
	0x6776: 0x980D,
	0x6777: 0x980E,
	0x6778: 0x9814,
	0x6779: 0x9816,
	0x677A: 0x981C,
	0x677B: 0x981E,
	0x677C: 0x9820,
	0x677D: 0x9823,
	0x677E: 0x9826,
	0x6821: 0x982B,
	0x6822: 0x982E,
	0x6823: 0x982F,
	0x6824: 0x9830,
	0x6825: 0x9832,
	0x6826: 0x9833,
	0x6827: 0x9835,
	0x6828: 0x9825,
	0x6829: 0x983E,
	0x682A: 0x9844,
	0x682B: 0x9847,
	0x682C: 0x984A,
	0x682D: 0x9851,
	0x682E: 0x9852,
	0x682F: 0x9853,
	0x6830: 0x9856,
	0x6831: 0x9857,
	0x6832: 0x9859,
	0x6833: 0x985A,
	0x6834: 0x9862,
	0x6835: 0x9863,
	0x6836: 0x9865,
	0x6837: 0x9866,
	0x6838: 0x986A,
	0x6839: 0x986C,
	0x683A: 0x98AB,
	0x683B: 0x98AD,
	0x683C: 0x98AE,
	0x683D: 0x98B0,
	0x683E: 0x98B4,
	0x683F: 0x98B7,
	0x6840: 0x98B8,
	0x6841: 0x98BA,
	0x6842: 0x98BB,
	0x6843: 0x98BF,
	0x6844: 0x98C2,
	0x6845: 0x98C5,
	0x6846: 0x98C8,
	0x6847: 0x98CC,
	0x6848: 0x98E1,
	0x6849: 0x98E3,
	0x684A: 0x98E5,
	0x684B: 0x98E6,
	0x684C: 0x98E7,
	0x684D: 0x98EA,
	0x684E: 0x98F3,
	0x684F: 0x98F6,
	0x6850: 0x9902,
	0x6851: 0x9907,
	0x6852: 0x9908,
	0x6853: 0x9911,
	0x6854: 0x9915,
	0x6855: 0x9916,
	0x6856: 0x9917,
	0x6857: 0x991A,
	0x6858: 0x991B,
	0x6859: 0x991C,
	0x685A: 0x991F,
	0x685B: 0x9922,
	0x685C: 0x9926,
	0x685D: 0x9927,
	0x685E: 0x992B,
	0x685F: 0x9931,
	0x6860: 0x9932,
	0x6861: 0x9933,
	0x6862: 0x9934,
	0x6863: 0x9935,
	0x6864: 0x9939,
	0x6865: 0x993A,
	0x6866: 0x993B,
	0x6867: 0x993C,
	0x6868: 0x9940,
	0x6869: 0x9941,
	0x686A: 0x9946,
	0x686B: 0x9947,
	0x686C: 0x9948,
	0x686D: 0x994D,
	0x686E: 0x994E,
	0x686F: 0x9954,
	0x6870: 0x9958,
	0x6871: 0x9959,
	0x6872: 0x995B,
	0x6873: 0x995C,
	0x6874: 0x995E,
	0x6875: 0x995F,
	0x6876: 0x9960,
	0x6877: 0x999B,
	0x6878: 0x999D,
	0x6879: 0x999F,
	0x687A: 0x99A6,
	0x687B: 0x99B0,
	0x687C: 0x99B1,
	0x687D: 0x99B2,
	0x687E: 0x99B5,
	0x6921: 0x99B9,
	0x6922: 0x99BA,
	0x6923: 0x99BD,
	0x6924: 0x99BF,
	0x6925: 0x99C3,
	0x6926: 0x99C9,
	0x6927: 0x99D3,
	0x6928: 0x99D4,
	0x6929: 0x99D9,
	0x692A: 0x99DA,
	0x692B: 0x99DC,
	0x692C: 0x99DE,
	0x692D: 0x99E7,
	0x692E: 0x99EA,
	0x692F: 0x99EB,
	0x6930: 0x99EC,
	0x6931: 0x99F0,
	0x6932: 0x99F4,
	0x6933: 0x99F5,
	0x6934: 0x99F9,
	0x6935: 0x99FD,
	0x6936: 0x99FE,
	0x6937: 0x9A02,
	0x6938: 0x9A03,
	0x6939: 0x9A04,
	0x693A: 0x9A0B,
	0x693B: 0x9A0C,
	0x693C: 0x9A10,
	0x693D: 0x9A11,
	0x693E: 0x9A16,
	0x693F: 0x9A1E,
	0x6940: 0x9A20,
	0x6941: 0x9A22,
	0x6942: 0x9A23,
	0x6943: 0x9A24,
	0x6944: 0x9A27,
	0x6945: 0x9A2D,
	0x6946: 0x9A2E,
	0x6947: 0x9A33,
	0x6948: 0x9A35,
	0x6949: 0x9A36,
	0x694A: 0x9A38,
	0x694B: 0x9A47,
	0x694C: 0x9A41,
	0x694D: 0x9A44,
	0x694E: 0x9A4A,
	0x694F: 0x9A4B,
	0x6950: 0x9A4C,
	0x6951: 0x9A4E,
	0x6952: 0x9A51,
	0x6953: 0x9A54,
	0x6954: 0x9A56,
	0x6955: 0x9A5D,
	0x6956: 0x9AAA,
	0x6957: 0x9AAC,
	0x6958: 0x9AAE,
	0x6959: 0x9AAF,
	0x695A: 0x9AB2,
	0x695B: 0x9AB4,
	0x695C: 0x9AB5,
	0x695D: 0x9AB6,
	0x695E: 0x9AB9,
	0x695F: 0x9ABB,
	0x6960: 0x9ABE,
	0x6961: 0x9ABF,
	0x6962: 0x9AC1,
	0x6963: 0x9AC3,
	0x6964: 0x9AC6,
	0x6965: 0x9AC8,
	0x6966: 0x9ACE,
	0x6967: 0x9AD0,
	0x6968: 0x9AD2,
	0x6969: 0x9AD5,
	0x696A: 0x9AD6,
	0x696B: 0x9AD7,
	0x696C: 0x9ADB,
	0x696D: 0x9ADC,
	0x696E: 0x9AE0,
	0x696F: 0x9AE4,
	0x6970: 0x9AE5,
	0x6971: 0x9AE7,
	0x6972: 0x9AE9,
	0x6973: 0x9AEC,
	0x6974: 0x9AF2,
	0x6975: 0x9AF3,
	0x6976: 0x9AF5,
	0x6977: 0x9AF9,
	0x6978: 0x9AFA,
	0x6979: 0x9AFD,
	0x697A: 0x9AFF,
	0x697B: 0x9B00,
	0x697C: 0x9B01,
	0x697D: 0x9B02,
	0x697E: 0x9B03,
	0x6A21: 0x9B04,
	0x6A22: 0x9B05,
	0x6A23: 0x9B08,
	0x6A24: 0x9B09,
	0x6A25: 0x9B0B,
	0x6A26: 0x9B0C,
	0x6A27: 0x9B0D,
	0x6A28: 0x9B0E,
	0x6A29: 0x9B10,
	0x6A2A: 0x9B12,
	0x6A2B: 0x9B16,
	0x6A2C: 0x9B19,
	0x6A2D: 0x9B1B,
	0x6A2E: 0x9B1C,
	0x6A2F: 0x9B20,
	0x6A30: 0x9B26,
	0x6A31: 0x9B2B,
	0x6A32: 0x9B2D,
	0x6A33: 0x9B33,
	0x6A34: 0x9B34,
	0x6A35: 0x9B35,
	0x6A36: 0x9B37,
	0x6A37: 0x9B39,
	0x6A38: 0x9B3A,
	0x6A39: 0x9B3D,
	0x6A3A: 0x9B48,
	0x6A3B: 0x9B4B,
	0x6A3C: 0x9B4C,
	0x6A3D: 0x9B55,
	0x6A3E: 0x9B56,
	0x6A3F: 0x9B57,
	0x6A40: 0x9B5B,
	0x6A41: 0x9B5E,
	0x6A42: 0x9B61,
	0x6A43: 0x9B63,
	0x6A44: 0x9B65,
	0x6A45: 0x9B66,
	0x6A46: 0x9B68,
	0x6A47: 0x9B6A,
	0x6A48: 0x9B6B,
	0x6A49: 0x9B6C,
	0x6A4A: 0x9B6D,
	0x6A4B: 0x9B6E,
	0x6A4C: 0x9B73,
	0x6A4D: 0x9B75,
	0x6A4E: 0x9B77,
	0x6A4F: 0x9B78,
	0x6A50: 0x9B79,
	0x6A51: 0x9B7F,
	0x6A52: 0x9B80,
	0x6A53: 0x9B84,
	0x6A54: 0x9B85,
	0x6A55: 0x9B86,
	0x6A56: 0x9B87,
	0x6A57: 0x9B89,
	0x6A58: 0x9B8A,
	0x6A59: 0x9B8B,
	0x6A5A: 0x9B8D,
	0x6A5B: 0x9B8F,
	0x6A5C: 0x9B90,
	0x6A5D: 0x9B94,
	0x6A5E: 0x9B9A,
	0x6A5F: 0x9B9D,
	0x6A60: 0x9B9E,
	0x6A61: 0x9BA6,
	0x6A62: 0x9BA7,
	0x6A63: 0x9BA9,
	0x6A64: 0x9BAC,
	0x6A65: 0x9BB0,
	0x6A66: 0x9BB1,
	0x6A67: 0x9BB2,
	0x6A68: 0x9BB7,
	0x6A69: 0x9BB8,
	0x6A6A: 0x9BBB,
	0x6A6B: 0x9BBC,
	0x6A6C: 0x9BBE,
	0x6A6D: 0x9BBF,
	0x6A6E: 0x9BC1,
	0x6A6F: 0x9BC7,
	0x6A70: 0x9BC8,
	0x6A71: 0x9BCE,
	0x6A72: 0x9BD0,
	0x6A73: 0x9BD7,
	0x6A74: 0x9BD8,
	0x6A75: 0x9BDD,
	0x6A76: 0x9BDF,
	0x6A77: 0x9BE5,
	0x6A78: 0x9BE7,
	0x6A79: 0x9BEA,
	0x6A7A: 0x9BEB,
	0x6A7B: 0x9BEF,
	0x6A7C: 0x9BF3,
	0x6A7D: 0x9BF7,
	0x6A7E: 0x9BF8,
	0x6B21: 0x9BF9,
	0x6B22: 0x9BFA,
	0x6B23: 0x9BFD,
	0x6B24: 0x9BFF,
	0x6B25: 0x9C00,
	0x6B26: 0x9C02,
	0x6B27: 0x9C0B,
	0x6B28: 0x9C0F,
	0x6B29: 0x9C11,
	0x6B2A: 0x9C16,
	0x6B2B: 0x9C18,
	0x6B2C: 0x9C19,
	0x6B2D: 0x9C1A,
	0x6B2E: 0x9C1C,
	0x6B2F: 0x9C1E,
	0x6B30: 0x9C22,
	0x6B31: 0x9C23,
	0x6B32: 0x9C26,
	0x6B33: 0x9C27,
	0x6B34: 0x9C28,
	0x6B35: 0x9C29,
	0x6B36: 0x9C2A,
	0x6B37: 0x9C31,
	0x6B38: 0x9C35,
	0x6B39: 0x9C36,
	0x6B3A: 0x9C37,
	0x6B3B: 0x9C3D,
	0x6B3C: 0x9C41,
	0x6B3D: 0x9C43,
	0x6B3E: 0x9C44,
	0x6B3F: 0x9C45,
	0x6B40: 0x9C49,
	0x6B41: 0x9C4A,
	0x6B42: 0x9C4E,
	0x6B43: 0x9C4F,
	0x6B44: 0x9C50,
	0x6B45: 0x9C53,
	0x6B46: 0x9C54,
	0x6B47: 0x9C56,
	0x6B48: 0x9C58,
	0x6B49: 0x9C5B,
	0x6B4A: 0x9C5D,
	0x6B4B: 0x9C5E,
	0x6B4C: 0x9C5F,
	0x6B4D: 0x9C63,
	0x6B4E: 0x9C69,
	0x6B4F: 0x9C6A,
	0x6B50: 0x9C5C,
	0x6B51: 0x9C6B,
	0x6B52: 0x9C68,
	0x6B53: 0x9C6E,
	0x6B54: 0x9C70,
	0x6B55: 0x9C72,
	0x6B56: 0x9C75,
	0x6B57: 0x9C77,
	0x6B58: 0x9C7B,
	0x6B59: 0x9CE6,
	0x6B5A: 0x9CF2,
	0x6B5B: 0x9CF7,
	0x6B5C: 0x9CF9,
	0x6B5D: 0x9D0B,
	0x6B5E: 0x9D02,
	0x6B5F: 0x9D11,
	0x6B60: 0x9D17,
	0x6B61: 0x9D18,
	0x6B62: 0x9D1C,
	0x6B63: 0x9D1D,
	0x6B64: 0x9D1E,
	0x6B65: 0x9D2F,
	0x6B66: 0x9D30,
	0x6B67: 0x9D32,
	0x6B68: 0x9D33,
	0x6B69: 0x9D34,
	0x6B6A: 0x9D3A,
	0x6B6B: 0x9D3C,
	0x6B6C: 0x9D45,
	0x6B6D: 0x9D3D,
	0x6B6E: 0x9D42,
	0x6B6F: 0x9D43,
	0x6B70: 0x9D47,
	0x6B71: 0x9D4A,
	0x6B72: 0x9D53,
	0x6B73: 0x9D54,
	0x6B74: 0x9D5F,
	0x6B75: 0x9D63,
	0x6B76: 0x9D62,
	0x6B77: 0x9D65,
	0x6B78: 0x9D69,
	0x6B79: 0x9D6A,
	0x6B7A: 0x9D6B,
	0x6B7B: 0x9D70,
	0x6B7C: 0x9D76,
	0x6B7D: 0x9D77,
	0x6B7E: 0x9D7B,
	0x6C21: 0x9D7C,
	0x6C22: 0x9D7E,
	0x6C23: 0x9D83,
	0x6C24: 0x9D84,
	0x6C25: 0x9D86,
	0x6C26: 0x9D8A,
	0x6C27: 0x9D8D,
	0x6C28: 0x9D8E,
	0x6C29: 0x9D92,
	0x6C2A: 0x9D93,
	0x6C2B: 0x9D95,
	0x6C2C: 0x9D96,
	0x6C2D: 0x9D97,
	0x6C2E: 0x9D98,
	0x6C2F: 0x9DA1,
	0x6C30: 0x9DAA,
	0x6C31: 0x9DAC,
	0x6C32: 0x9DAE,
	0x6C33: 0x9DB1,
	0x6C34: 0x9DB5,
	0x6C35: 0x9DB9,
	0x6C36: 0x9DBC,
	0x6C37: 0x9DBF,
	0x6C38: 0x9DC3,
	0x6C39: 0x9DC7,
	0x6C3A: 0x9DC9,
	0x6C3B: 0x9DCA,
	0x6C3C: 0x9DD4,
	0x6C3D: 0x9DD5,
	0x6C3E: 0x9DD6,
	0x6C3F: 0x9DD7,
	0x6C40: 0x9DDA,
	0x6C41: 0x9DDE,
	0x6C42: 0x9DDF,
	0x6C43: 0x9DE0,
	0x6C44: 0x9DE5,
	0x6C45: 0x9DE7,
	0x6C46: 0x9DE9,
	0x6C47: 0x9DEB,
	0x6C48: 0x9DEE,
	0x6C49: 0x9DF0,
	0x6C4A: 0x9DF3,
	0x6C4B: 0x9DF4,
	0x6C4C: 0x9DFE,
	0x6C4D: 0x9E0A,
	0x6C4E: 0x9E02,
	0x6C4F: 0x9E07,
	0x6C50: 0x9E0E,
	0x6C51: 0x9E10,
	0x6C52: 0x9E11,
	0x6C53: 0x9E12,
	0x6C54: 0x9E15,
	0x6C55: 0x9E16,
	0x6C56: 0x9E19,
	0x6C57: 0x9E1C,
	0x6C58: 0x9E1D,
	0x6C59: 0x9E7A,
	0x6C5A: 0x9E7B,
	0x6C5B: 0x9E7C,
	0x6C5C: 0x9E80,
	0x6C5D: 0x9E82,
	0x6C5E: 0x9E83,
	0x6C5F: 0x9E84,
	0x6C60: 0x9E85,
	0x6C61: 0x9E87,
	0x6C62: 0x9E8E,
	0x6C63: 0x9E8F,
	0x6C64: 0x9E96,
	0x6C65: 0x9E98,
	0x6C66: 0x9E9B,
	0x6C67: 0x9E9E,
	0x6C68: 0x9EA4,
	0x6C69: 0x9EA8,
	0x6C6A: 0x9EAC,
	0x6C6B: 0x9EAE,
	0x6C6C: 0x9EAF,
	0x6C6D: 0x9EB0,
	0x6C6E: 0x9EB3,
	0x6C6F: 0x9EB4,
	0x6C70: 0x9EB5,
	0x6C71: 0x9EC6,
	0x6C72: 0x9EC8,
	0x6C73: 0x9ECB,
	0x6C74: 0x9ED5,
	0x6C75: 0x9EDF,
	0x6C76: 0x9EE4,
	0x6C77: 0x9EE7,
	0x6C78: 0x9EEC,
	0x6C79: 0x9EED,
	0x6C7A: 0x9EEE,
	0x6C7B: 0x9EF0,
	0x6C7C: 0x9EF1,
	0x6C7D: 0x9EF2,
	0x6C7E: 0x9EF5,
	0x6D21: 0x9EF8,
	0x6D22: 0x9EFF,
	0x6D23: 0x9F02,
	0x6D24: 0x9F03,
	0x6D25: 0x9F09,
	0x6D26: 0x9F0F,
	0x6D27: 0x9F10,
	0x6D28: 0x9F11,
	0x6D29: 0x9F12,
	0x6D2A: 0x9F14,
	0x6D2B: 0x9F16,
	0x6D2C: 0x9F17,
	0x6D2D: 0x9F19,
	0x6D2E: 0x9F1A,
	0x6D2F: 0x9F1B,
	0x6D30: 0x9F1F,
	0x6D31: 0x9F22,
	0x6D32: 0x9F26,
	0x6D33: 0x9F2A,
	0x6D34: 0x9F2B,
	0x6D35: 0x9F2F,
	0x6D36: 0x9F31,
	0x6D37: 0x9F32,
	0x6D38: 0x9F34,
	0x6D39: 0x9F37,
	0x6D3A: 0x9F39,
	0x6D3B: 0x9F3A,
	0x6D3C: 0x9F3C,
	0x6D3D: 0x9F3D,
	0x6D3E: 0x9F3F,
	0x6D3F: 0x9F41,
	0x6D40: 0x9F43,
	0x6D41: 0x9F44,
	0x6D42: 0x9F45,
	0x6D43: 0x9F46,
	0x6D44: 0x9F47,
	0x6D45: 0x9F53,
	0x6D46: 0x9F55,
	0x6D47: 0x9F56,
	0x6D48: 0x9F57,
	0x6D49: 0x9F58,
	0x6D4A: 0x9F5A,
	0x6D4B: 0x9F5D,
	0x6D4C: 0x9F5E,
	0x6D4D: 0x9F68,
	0x6D4E: 0x9F69,
	0x6D4F: 0x9F6D,
	0x6D50: 0x9F6E,
	0x6D51: 0x9F6F,
	0x6D52: 0x9F70,
	0x6D53: 0x9F71,
	0x6D54: 0x9F73,
	0x6D55: 0x9F75,
	0x6D56: 0x9F7A,
	0x6D57: 0x9F7D,
	0x6D58: 0x9F8F,
	0x6D59: 0x9F90,
	0x6D5A: 0x9F91,
	0x6D5B: 0x9F92,
	0x6D5C: 0x9F94,
	0x6D5D: 0x9F96,
	0x6D5E: 0x9F97,
	0x6D5F: 0x9F9E,
	0x6D60: 0x9FA1,
	0x6D61: 0x9FA2,
	0x6D62: 0x9FA3,
	0x6D63: 0x9FA5,
}
