// Code generated by smithy-go-codegen DO NOT EDIT.

package codecommit

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codecommit/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of commits and changes to a specified file.
func (c *Client) ListFileCommitHistory(ctx context.Context, params *ListFileCommitHistoryInput, optFns ...func(*Options)) (*ListFileCommitHistoryOutput, error) {
	if params == nil {
		params = &ListFileCommitHistoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFileCommitHistory", params, optFns, c.addOperationListFileCommitHistoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFileCommitHistoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFileCommitHistoryInput struct {

	// The full path of the file whose history you want to retrieve, including the
	// name of the file.
	//
	// This member is required.
	FilePath *string

	// The name of the repository that contains the file.
	//
	// This member is required.
	RepositoryName *string

	// The fully quaified reference that identifies the commit that contains the file.
	// For example, you can specify a full commit ID, a tag, a branch name, or a
	// reference such as refs/heads/main . If none is provided, the head commit is used.
	CommitSpecifier *string

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int32

	// An enumeration token that allows the operation to batch the results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListFileCommitHistoryOutput struct {

	// An array of FileVersion objects that form a directed acyclic graph (DAG) of the
	// changes to the file made by the commits that changed the file.
	//
	// This member is required.
	RevisionDag []types.FileVersion

	// An enumeration token that can be used to return the next batch of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFileCommitHistoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListFileCommitHistory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListFileCommitHistory{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFileCommitHistory"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListFileCommitHistoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFileCommitHistory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListFileCommitHistoryPaginatorOptions is the paginator options for
// ListFileCommitHistory
type ListFileCommitHistoryPaginatorOptions struct {
	// A non-zero, non-negative integer used to limit the number of returned results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFileCommitHistoryPaginator is a paginator for ListFileCommitHistory
type ListFileCommitHistoryPaginator struct {
	options   ListFileCommitHistoryPaginatorOptions
	client    ListFileCommitHistoryAPIClient
	params    *ListFileCommitHistoryInput
	nextToken *string
	firstPage bool
}

// NewListFileCommitHistoryPaginator returns a new ListFileCommitHistoryPaginator
func NewListFileCommitHistoryPaginator(client ListFileCommitHistoryAPIClient, params *ListFileCommitHistoryInput, optFns ...func(*ListFileCommitHistoryPaginatorOptions)) *ListFileCommitHistoryPaginator {
	if params == nil {
		params = &ListFileCommitHistoryInput{}
	}

	options := ListFileCommitHistoryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFileCommitHistoryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFileCommitHistoryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFileCommitHistory page.
func (p *ListFileCommitHistoryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFileCommitHistoryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFileCommitHistory(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFileCommitHistoryAPIClient is a client that implements the
// ListFileCommitHistory operation.
type ListFileCommitHistoryAPIClient interface {
	ListFileCommitHistory(context.Context, *ListFileCommitHistoryInput, ...func(*Options)) (*ListFileCommitHistoryOutput, error)
}

var _ ListFileCommitHistoryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFileCommitHistory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFileCommitHistory",
	}
}
