/* 
 * Copyright (C) 2004, 2005 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GT_CONF_H
#define _GT_CONF_H

#include <stdarg.h>
#include <eel/eel.h>
#include <translate.h>

#define GT_CONF_NAMESPACE			"/apps/gnome-translate"
#define GT_CONF_WINDOW				GT_CONF_NAMESPACE "/window"
#define GT_CONF_VIEW_TOOLBARS			GT_CONF_NAMESPACE "/view_toolbars"
#define GT_CONF_VIEW_STATUSBAR			GT_CONF_NAMESPACE "/view_statusbar"
#define GT_CONF_TOOLBARS_STYLE			GT_CONF_NAMESPACE "/toolbars_style"
#define GT_CONF_SOURCE_LANGUAGE			GT_CONF_NAMESPACE "/source_language"
#define GT_CONF_DEST_LANGUAGE			GT_CONF_NAMESPACE "/dest_language"
#define GT_CONF_PANED_POSITION			GT_CONF_NAMESPACE "/paned_position"
#define GT_CONF_PREFERENCES			GT_CONF_NAMESPACE "/preferences"
#define GT_CONF_EDIT_TOOLBARS			GT_CONF_NAMESPACE "/edit_toolbars"
#define GT_CONF_SAVE_TRANSLATED_TEXT_AS_FOLDER	GT_CONF_NAMESPACE "/save_translated_text_as_folder"
#define GT_CONF_INSERT_FROM_FILE_FOLDER		GT_CONF_NAMESPACE "/insert_from_file_folder"
#define GT_CONF_AUTODETECT_LANGUAGE		GT_CONF_NAMESPACE "/autodetect_language"
#define GT_CONF_SERVICES			GT_CONF_NAMESPACE "/services"
#define GT_CONF_TWP_NAMESPACE			GT_CONF_NAMESPACE "/translate_web_page"
#define GT_CONF_TWP_WINDOW			GT_CONF_TWP_NAMESPACE "/window"
#define GT_CONF_TWP_SOURCE_LANGUAGE		GT_CONF_TWP_NAMESPACE "/source_language"
#define GT_CONF_TWP_DEST_LANGUAGE		GT_CONF_TWP_NAMESPACE "/dest_language"
#define GT_CONF_TWP_LOCATION_HISTORY		GT_CONF_TWP_NAMESPACE "/location_history"

void gt_conf_init (void);

void gt_conf_link (gpointer object, ...);
void gt_conf_notification_add (gpointer object,
			       const char *key,
			       GConfClientNotifyFunc callback,
			       gpointer user_data);

typedef struct
{
  TranslateService	*service;
  gboolean		enabled;
} GTConfService;

GSList *gt_conf_get_services (void);
void gt_conf_set_services (const GSList *services);

GTConfService *gt_conf_service_new (TranslateService *service, gboolean enabled);
void gt_conf_service_free (GTConfService *service);

void gt_conf_services_free (GSList *services);
const GTConfService *gt_conf_services_get_from_name (const GSList *services,
						     const char *name);

#endif /* _GT_CONF_H */
