// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gdk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Pixbuf : GLib.Object, GLib.IIcon, GLib.ILoadableIcon {

		public Pixbuf (IntPtr raw) : base(raw) {}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_new(int colorspace, bool has_alpha, int bits_per_sample, int width, int height);

		public Pixbuf (Gdk.Colorspace colorspace, bool has_alpha, int bits_per_sample, int width, int height) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("colorspace");
				vals.Add (new GLib.Value (colorspace));
				names.Add ("has_alpha");
				vals.Add (new GLib.Value (has_alpha));
				names.Add ("bits_per_sample");
				vals.Add (new GLib.Value (bits_per_sample));
				names.Add ("width");
				vals.Add (new GLib.Value (width));
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gdk_pixbuf_new((int) colorspace, has_alpha, bits_per_sample, width, height);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_new_from_bytes(IntPtr data, int colorspace, bool has_alpha, int bits_per_sample, int width, int height, int rowstride);

		public Pixbuf (GLib.Bytes data, Gdk.Colorspace colorspace, bool has_alpha, int bits_per_sample, int width, int height, int rowstride) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("colorspace");
				vals.Add (new GLib.Value (colorspace));
				names.Add ("has_alpha");
				vals.Add (new GLib.Value (has_alpha));
				names.Add ("bits_per_sample");
				vals.Add (new GLib.Value (bits_per_sample));
				names.Add ("width");
				vals.Add (new GLib.Value (width));
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				names.Add ("rowstride");
				vals.Add (new GLib.Value (rowstride));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gdk_pixbuf_new_from_bytes(data == null ? IntPtr.Zero : data.Handle, (int) colorspace, has_alpha, bits_per_sample, width, height, rowstride);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_file(IntPtr filename, out IntPtr error);

		public unsafe Pixbuf (string filename) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			Raw = gdk_pixbuf_new_from_file(native_filename, out error);
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_file_at_scale(IntPtr filename, int width, int height, bool preserve_aspect_ratio, out IntPtr error);

		public unsafe Pixbuf (string filename, int width, int height, bool preserve_aspect_ratio) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("width");
				vals.Add (new GLib.Value (width));
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			Raw = gdk_pixbuf_new_from_file_at_scale(native_filename, width, height, preserve_aspect_ratio, out error);
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_file_at_scale_utf8(IntPtr filename, int width, int height, bool preserve_aspect_ratio, out IntPtr error);

		public static unsafe Pixbuf NewFromFileAtScaleUtf8(string filename, int width, int height, bool preserve_aspect_ratio)
		{
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			Pixbuf result = new Pixbuf (gdk_pixbuf_new_from_file_at_scale_utf8(native_filename, width, height, preserve_aspect_ratio, out error));
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return result;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_file_at_size(IntPtr filename, int width, int height, out IntPtr error);

		public unsafe Pixbuf (string filename, int width, int height) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				names.Add ("width");
				vals.Add (new GLib.Value (width));
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			Raw = gdk_pixbuf_new_from_file_at_size(native_filename, width, height, out error);
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_file_at_size_utf8(IntPtr filename, int width, int height, out IntPtr error);

		public static unsafe Pixbuf NewFromFileAtSizeUtf8(string filename, int width, int height)
		{
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			Pixbuf result = new Pixbuf (gdk_pixbuf_new_from_file_at_size_utf8(native_filename, width, height, out error));
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return result;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_file_utf8(IntPtr filename, out IntPtr error);

		public static unsafe Pixbuf NewFromFileUtf8(string filename)
		{
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr error = IntPtr.Zero;
			Pixbuf result = new Pixbuf (gdk_pixbuf_new_from_file_utf8(native_filename, out error));
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return result;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_resource(IntPtr resource_path, out IntPtr error);

		public static unsafe Pixbuf NewFromResource(string resource_path)
		{
			IntPtr native_resource_path = GLib.Marshaller.StringToPtrGStrdup (resource_path);
			IntPtr error = IntPtr.Zero;
			Pixbuf result = new Pixbuf (gdk_pixbuf_new_from_resource(native_resource_path, out error));
			GLib.Marshaller.Free (native_resource_path);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return result;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_resource_at_scale(IntPtr resource_path, int width, int height, bool preserve_aspect_ratio, out IntPtr error);

		public static unsafe Pixbuf NewFromResourceAtScale(string resource_path, int width, int height, bool preserve_aspect_ratio)
		{
			IntPtr native_resource_path = GLib.Marshaller.StringToPtrGStrdup (resource_path);
			IntPtr error = IntPtr.Zero;
			Pixbuf result = new Pixbuf (gdk_pixbuf_new_from_resource_at_scale(native_resource_path, width, height, preserve_aspect_ratio, out error));
			GLib.Marshaller.Free (native_resource_path);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return result;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_stream(IntPtr stream, IntPtr cancellable, out IntPtr error);

		public unsafe Pixbuf (GLib.InputStream stream, GLib.Cancellable cancellable) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr error = IntPtr.Zero;
			Raw = gdk_pixbuf_new_from_stream(stream == null ? IntPtr.Zero : stream.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_new_from_stream_async(IntPtr stream, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public Pixbuf (GLib.InputStream stream, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			Raw = gdk_pixbuf_new_from_stream_async(stream == null ? IntPtr.Zero : stream.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_stream_at_scale(IntPtr stream, int width, int height, bool preserve_aspect_ratio, IntPtr cancellable, out IntPtr error);

		public unsafe Pixbuf (GLib.InputStream stream, int width, int height, bool preserve_aspect_ratio, GLib.Cancellable cancellable) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (stream != null) {
					names.Add ("width");
					vals.Add (new GLib.Value (width));
				}
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr error = IntPtr.Zero;
			Raw = gdk_pixbuf_new_from_stream_at_scale(stream == null ? IntPtr.Zero : stream.Handle, width, height, preserve_aspect_ratio, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_new_from_stream_at_scale_async(IntPtr stream, int width, int height, bool preserve_aspect_ratio, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public Pixbuf (GLib.InputStream stream, int width, int height, bool preserve_aspect_ratio, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (stream != null) {
					names.Add ("width");
					vals.Add (new GLib.Value (width));
				}
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			Raw = gdk_pixbuf_new_from_stream_at_scale_async(stream == null ? IntPtr.Zero : stream.Handle, width, height, preserve_aspect_ratio, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_new_from_stream_finish(IntPtr async_result, out IntPtr error);

		public unsafe Pixbuf (GLib.IAsyncResult async_result) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr error = IntPtr.Zero;
			Raw = gdk_pixbuf_new_from_stream_finish(async_result == null ? IntPtr.Zero : ((async_result is GLib.Object) ? (async_result as GLib.Object).Handle : (async_result as GLib.AsyncResultAdapter).Handle), out error);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_new_from_xpm_data(IntPtr[] data);

		public Pixbuf (string[] data) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			int cnt_data = data == null ? 0 : data.Length;
			IntPtr[] native_data = new IntPtr [cnt_data];
			for (int i = 0; i < cnt_data; i++)
				native_data [i] = GLib.Marshaller.StringToPtrGStrdup (data[i]);
			Raw = gdk_pixbuf_new_from_xpm_data(native_data);
			for (int i = 0; i < native_data.Length; i++) {
				data [i] = GLib.Marshaller.Utf8PtrToString (native_data[i]);
				GLib.Marshaller.Free (native_data[i]);
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_new_subpixbuf(IntPtr src_pixbuf, int src_x, int src_y, int width, int height);

		public Pixbuf (Gdk.Pixbuf src_pixbuf, int src_x, int src_y, int width, int height) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Pixbuf)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				if (src_pixbuf != null) {
					names.Add ("width");
					vals.Add (new GLib.Value (width));
				}
				names.Add ("height");
				vals.Add (new GLib.Value (height));
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			Raw = gdk_pixbuf_new_subpixbuf(src_pixbuf == null ? IntPtr.Zero : src_pixbuf.Handle, src_x, src_y, width, height);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_get_n_channels(IntPtr raw);

		[GLib.Property ("n-channels")]
		public int NChannels {
			get  {
				int raw_ret = gdk_pixbuf_get_n_channels(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_get_colorspace(IntPtr raw);

		[GLib.Property ("colorspace")]
		public Gdk.Colorspace Colorspace {
			get  {
				int raw_ret = gdk_pixbuf_get_colorspace(Handle);
				Gdk.Colorspace ret = (Gdk.Colorspace) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_pixbuf_get_has_alpha(IntPtr raw);

		[GLib.Property ("has-alpha")]
		public bool HasAlpha {
			get  {
				bool raw_ret = gdk_pixbuf_get_has_alpha(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_get_bits_per_sample(IntPtr raw);

		[GLib.Property ("bits-per-sample")]
		public int BitsPerSample {
			get  {
				int raw_ret = gdk_pixbuf_get_bits_per_sample(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_get_width(IntPtr raw);

		[GLib.Property ("width")]
		public int Width {
			get  {
				int raw_ret = gdk_pixbuf_get_width(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_get_height(IntPtr raw);

		[GLib.Property ("height")]
		public int Height {
			get  {
				int raw_ret = gdk_pixbuf_get_height(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_get_rowstride(IntPtr raw);

		[GLib.Property ("rowstride")]
		public int Rowstride {
			get  {
				int raw_ret = gdk_pixbuf_get_rowstride(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[GLib.Property ("pixel-bytes")]
		public GLib.Bytes PixelBytes {
			get {
				GLib.Value val = GetProperty ("pixel-bytes");
				GLib.Bytes ret = (GLib.Bytes) val;
				val.Dispose ();
				return ret;
			}
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (GLib.Object.class_abi.Fields);

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_apply_embedded_orientation(IntPtr raw);

		public Gdk.Pixbuf ApplyEmbeddedOrientation() {
			IntPtr raw_ret = gdk_pixbuf_apply_embedded_orientation(Handle);
			Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret, true) as Gdk.Pixbuf;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_composite(IntPtr raw, IntPtr dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type, int overall_alpha);

		public void Composite(Gdk.Pixbuf dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, Gdk.InterpType interp_type, int overall_alpha) {
			gdk_pixbuf_composite(Handle, dest == null ? IntPtr.Zero : dest.Handle, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, (int) interp_type, overall_alpha);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_composite_color(IntPtr raw, IntPtr dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type, int overall_alpha, int check_x, int check_y, int check_size, uint color1, uint color2);

		public void CompositeColor(Gdk.Pixbuf dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, Gdk.InterpType interp_type, int overall_alpha, int check_x, int check_y, int check_size, uint color1, uint color2) {
			gdk_pixbuf_composite_color(Handle, dest == null ? IntPtr.Zero : dest.Handle, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, (int) interp_type, overall_alpha, check_x, check_y, check_size, color1, color2);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_copy(IntPtr raw);

		public Gdk.Pixbuf Copy() {
			IntPtr raw_ret = gdk_pixbuf_copy(Handle);
			Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret, true) as Gdk.Pixbuf;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_copy_area(IntPtr raw, int src_x, int src_y, int width, int height, IntPtr dest_pixbuf, int dest_x, int dest_y);

		public void CopyArea(int src_x, int src_y, int width, int height, Gdk.Pixbuf dest_pixbuf, int dest_x, int dest_y) {
			gdk_pixbuf_copy_area(Handle, src_x, src_y, width, height, dest_pixbuf == null ? IntPtr.Zero : dest_pixbuf.Handle, dest_x, dest_y);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_pixbuf_copy_options(IntPtr raw, IntPtr dest_pixbuf);

		public bool CopyOptions(Gdk.Pixbuf dest_pixbuf) {
			bool raw_ret = gdk_pixbuf_copy_options(Handle, dest_pixbuf == null ? IntPtr.Zero : dest_pixbuf.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_pixbuf_error_quark();

		public static int ErrorQuark() {
			int raw_ret = gdk_pixbuf_error_quark();
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_fill(IntPtr raw, uint pixel);

		public void Fill(uint pixel) {
			gdk_pixbuf_fill(Handle, pixel);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_flip(IntPtr raw, bool horizontal);

		public Gdk.Pixbuf Flip(bool horizontal) {
			IntPtr raw_ret = gdk_pixbuf_flip(Handle, horizontal);
			Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret) as Gdk.Pixbuf;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern UIntPtr gdk_pixbuf_get_byte_length(IntPtr raw);

		public ulong ByteLength { 
			get {
				UIntPtr raw_ret = gdk_pixbuf_get_byte_length(Handle);
				ulong ret = (ulong) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_get_file_info(IntPtr filename, out int width, out int height);

		public static Gdk.PixbufFormat GetFileInfo(string filename, out int width, out int height) {
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr raw_ret = gdk_pixbuf_get_file_info(native_filename, out width, out height);
			Gdk.PixbufFormat ret = raw_ret == IntPtr.Zero ? null : (Gdk.PixbufFormat) GLib.Opaque.GetOpaque (raw_ret, typeof (Gdk.PixbufFormat), false);
			GLib.Marshaller.Free (native_filename);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_get_file_info_async(IntPtr filename, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public static void GetFileInfoAsync(string filename, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			gdk_pixbuf_get_file_info_async(native_filename, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_filename);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_pixbuf_get_file_info_finish(IntPtr async_result, out int width, out int height, out IntPtr error);

		public static unsafe Gdk.PixbufFormat GetFileInfoFinish(GLib.IAsyncResult async_result, out int width, out int height) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = gdk_pixbuf_get_file_info_finish(async_result == null ? IntPtr.Zero : ((async_result is GLib.Object) ? (async_result as GLib.Object).Handle : (async_result as GLib.AsyncResultAdapter).Handle), out width, out height, out error);
			Gdk.PixbufFormat ret = raw_ret == IntPtr.Zero ? null : (Gdk.PixbufFormat) GLib.Opaque.GetOpaque (raw_ret, typeof (Gdk.PixbufFormat), false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_get_option(IntPtr raw, IntPtr key);

		public string GetOption(string key) {
			IntPtr native_key = GLib.Marshaller.StringToPtrGStrdup (key);
			IntPtr raw_ret = gdk_pixbuf_get_option(Handle, native_key);
			string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
			GLib.Marshaller.Free (native_key);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern System.IntPtr gdk_pixbuf_get_options(IntPtr raw);

		public System.IntPtr Options { 
			get {
				System.IntPtr raw_ret = gdk_pixbuf_get_options(Handle);
				System.IntPtr ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern byte gdk_pixbuf_get_pixels_with_length(IntPtr raw, out uint length);

		public byte GetPixelsWithLength(out uint length) {
			byte raw_ret = gdk_pixbuf_get_pixels_with_length(Handle, out length);
			byte ret = raw_ret;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gdk_pixbuf_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_read_pixel_bytes(IntPtr raw);

		public GLib.Bytes ReadPixelBytes() {
			IntPtr raw_ret = gdk_pixbuf_read_pixel_bytes(Handle);
			GLib.Bytes ret = new GLib.Bytes(raw_ret);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern byte gdk_pixbuf_read_pixels(IntPtr raw);

		public byte ReadPixels() {
			byte raw_ret = gdk_pixbuf_read_pixels(Handle);
			byte ret = raw_ret;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_pixbuf_remove_option(IntPtr raw, IntPtr key);

		public bool RemoveOption(string key) {
			IntPtr native_key = GLib.Marshaller.StringToPtrGStrdup (key);
			bool raw_ret = gdk_pixbuf_remove_option(Handle, native_key);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_key);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_pixbuf_rotate_simple(IntPtr raw, int angle);

		public Gdk.Pixbuf RotateSimple(Gdk.PixbufRotation angle) {
			IntPtr raw_ret = gdk_pixbuf_rotate_simple(Handle, (int) angle);
			Gdk.Pixbuf ret = GLib.Object.GetObject(raw_ret, true) as Gdk.Pixbuf;
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_saturate_and_pixelate(IntPtr raw, IntPtr dest, float saturation, bool pixelate);

		public void SaturateAndPixelate(Gdk.Pixbuf dest, float saturation, bool pixelate) {
			gdk_pixbuf_saturate_and_pixelate(Handle, dest == null ? IntPtr.Zero : dest.Handle, saturation, pixelate);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool gdk_pixbuf_save_to_stream_finish(IntPtr async_result, out IntPtr error);

		public static unsafe bool SaveToStreamFinish(GLib.IAsyncResult async_result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gdk_pixbuf_save_to_stream_finish(async_result == null ? IntPtr.Zero : ((async_result is GLib.Object) ? (async_result as GLib.Object).Handle : (async_result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool gdk_pixbuf_save_to_streamv(IntPtr raw, IntPtr stream, IntPtr type, IntPtr option_keys, IntPtr option_values, IntPtr cancellable, out IntPtr error);

		public unsafe bool SaveToStreamv(GLib.OutputStream stream, string type, string option_keys, string option_values, GLib.Cancellable cancellable) {
			IntPtr native_type = GLib.Marshaller.StringToPtrGStrdup (type);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gdk_pixbuf_save_to_streamv(Handle, stream == null ? IntPtr.Zero : stream.Handle, native_type, GLib.Marshaller.StringToPtrGStrdup(option_keys), GLib.Marshaller.StringToPtrGStrdup(option_values), cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_type);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_save_to_streamv_async(IntPtr raw, IntPtr stream, IntPtr type, IntPtr option_keys, IntPtr option_values, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void SaveToStreamvAsync(GLib.OutputStream stream, string type, string option_keys, string option_values, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_type = GLib.Marshaller.StringToPtrGStrdup (type);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			gdk_pixbuf_save_to_streamv_async(Handle, stream == null ? IntPtr.Zero : stream.Handle, native_type, GLib.Marshaller.StringToPtrGStrdup(option_keys), GLib.Marshaller.StringToPtrGStrdup(option_values), cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_type);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe bool gdk_pixbuf_savev_utf8(IntPtr raw, IntPtr filename, IntPtr type, IntPtr option_keys, IntPtr option_values, out IntPtr error);

		public unsafe bool SavevUtf8(string filename, string type, string option_keys, string option_values) {
			IntPtr native_filename = GLib.Marshaller.StringToPtrGStrdup (filename);
			IntPtr native_type = GLib.Marshaller.StringToPtrGStrdup (type);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = gdk_pixbuf_savev_utf8(Handle, native_filename, native_type, GLib.Marshaller.StringToPtrGStrdup(option_keys), GLib.Marshaller.StringToPtrGStrdup(option_values), out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_filename);
			GLib.Marshaller.Free (native_type);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_pixbuf_scale(IntPtr raw, IntPtr dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type);

		public void Scale(Gdk.Pixbuf dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, Gdk.InterpType interp_type) {
			gdk_pixbuf_scale(Handle, dest == null ? IntPtr.Zero : dest.Handle, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, (int) interp_type);
		}

		[DllImport("gdk_pixbuf-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_pixbuf_set_option(IntPtr raw, IntPtr key, IntPtr value);

		public bool SetOption(string key, string value) {
			IntPtr native_key = GLib.Marshaller.StringToPtrGStrdup (key);
			IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
			bool raw_ret = gdk_pixbuf_set_option(Handle, native_key, native_value);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_key);
			GLib.Marshaller.Free (native_value);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_icon_equal(IntPtr raw, IntPtr icon2);

		public bool Equal(GLib.IIcon icon2) {
			bool raw_ret = g_icon_equal(Handle, icon2 == null ? IntPtr.Zero : ((icon2 is GLib.Object) ? (icon2 as GLib.Object).Handle : (icon2 as GLib.IconAdapter).Handle));
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_icon_serialize(IntPtr raw);

		public GLib.Variant Serialize() {
			IntPtr raw_ret = g_icon_serialize(Handle);
			GLib.Variant ret = new GLib.Variant(raw_ret);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_icon_to_string(IntPtr raw);

		public override string ToString() {
			IntPtr raw_ret = g_icon_to_string(Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_loadable_icon_load(IntPtr raw, int size, IntPtr type, IntPtr cancellable, out IntPtr error);

		public GLib.InputStream Load(int size, string type, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_loadable_icon_load(Handle, size, GLib.Marshaller.StringToPtrGStrdup(type), cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.InputStream ret = GLib.Object.GetObject(raw_ret) as GLib.InputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_loadable_icon_load_async(IntPtr raw, int size, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void LoadAsync(int size, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_loadable_icon_load_async(Handle, size, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_loadable_icon_load_finish(IntPtr raw, IntPtr res, IntPtr type, out IntPtr error);

		public GLib.InputStream LoadFinish(GLib.IAsyncResult res, string type) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_loadable_icon_load_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), GLib.Marshaller.StringToPtrGStrdup(type), out error);
			GLib.InputStream ret = GLib.Object.GetObject(raw_ret) as GLib.InputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (GLib.Object.abi_info.Fields);

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
