#
# run.rb - several scripts to redirect shell command output to the world
#
# Copyright (c) 2006 by Paul van Tilburg <paul@luon.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Defines:
#   sh - run a command, send output to the user only
#   run - run a command, send the output to the world
#   crun - run a commend, send the output to a channel in the world
#   pstrun - run a command, send the output to the world via @paste
#   ppstrun - run a command, send the output to a player in the world via @paste
#   prefrun - run a command, send the output to the world with each
#             line prefixed

def register_functions
  $scripts.register("sh", "use: /sh <command>\nruns <command> in a subshell and sends output to the screen")
  $scripts.register("run", "use: /run <command>\nruns <command> in a subshell and sends output to the world")
  $scripts.register("crun", "use: /crun <chanalias> <command>\nruns <command> in a subshell and sends output to the channel identified by the <chanalias>")
  $scripts.register("pstrun", "use: /pstrun <command>\nruns <command> in a subshell and sends output via @paste to the world")
  $scripts.register("ppstrun", "use: /ppstrun <player> <command>\nruns <command> in a subshell and sends output via @paste to <player>")
  $scripts.register("prefrun", "use: /prefun <prefix> <command>\nruns <command> in a subshell and sends output to the world with each line preceeded by <prefix>")
end

def sh(cmd)
  if cmd
    $world.status("Executing `#{cmd}`")
    do_cmd(cmd) { |line| $world.status(line) }
  else
    error("use /sh <command>")
  end
end # def sh

def run(cmd)
  if cmd
    $world.sendln("emote LINUXes `#{cmd}`")
    do_cmd(cmd) { |line| $world.sendln("emote | #{line}") }
  else
    error("use /run <command>")
  end
end # def run

def crun(argstr)
  chan, cmd = argstr.split(/\s+/, 2)
  if chan and cmd
    $world.sendln("#{chan} emote LINUXes `#{cmd}`")
    do_cmd(cmd) { |line| $world.sendln("#{chan} emote | #{line}") }
  else
    error("use /crun <chanalias> <command>")
  end
end # def crun

def pstrun(cmd)
  if cmd
    $world.sendln("@paste")
    $world.sendln("$ #{cmd}")
    do_cmd(cmd) { |line| $world.sendln(line) }
    $world.sendln(".")
  else
    error("use /pstrun <command>")
  end
end # def pstrun

def ppstrun(argstr)
  player, cmd = argstr.split(/\s+/, 2)
  if player and cmd
    $world.sendln("@paste #{player}")
    $world.sendln("$ #{cmd}")
    do_cmd(cmd) { |line| $world.sendln(line) }
    $world.sendln(".")
  else
    error("use /ppstrun <player> <command>")
  end
end # def ppstrun

def prefrun(argstr)
  prefix, cmd = argstr.split(/\s+/, 2)
  if prefix and cmd
    do_cmd(cmd) { |line| $world.sendln("#{prefix} #{line}") }
  else
    error("use /prefrun <prefix> <command>")
  end
end # def prefrun

# Helper functions.
def do_cmd(command, &action)
  IO.popen("#{command} 2>&1") do |io|
    io.each_line { |line| yield line.chomp }
  end
end

def error(msg)
  $world.status("Script error: #{msg}")
end
