#include "gm-app-view.h"
#include "gm-commands.h"
#include "gm-pixbuf.h"
#include "dialogs/gm-world-properties-dialog.h"
#include "dialogs/gm-open-world-dialog.h"
#include "dialogs/gm-world-paste-dialog.h"
#include "dialogs/gm-world-logs-dialog.h"
#include "dialogs/gm-worlds-list-dialog.h"
#include "dialogs/gm-preferences-dialog.h"
#include "dialogs/gm-scripts-dialog.h"

/* World callbacks */
void
on_action_world_new(GtkAction *action, GmAppView *view) {
	gm_world_properties_dialog_run_new(NULL);
}

void
on_action_world_open(GtkAction *action, GmAppView *view) {
	gm_open_world_dialog_run();
}

void 
on_action_world_connect(GtkAction *action, GmAppView *view) {
	GmWorld *world = gm_app_view_active_world(view);
  
	if (world != NULL) {
		if (gm_world_disconnected(world)) {
			gm_world_connect(world);
		} else {
			gm_world_disconnect(world);
		}
	}
}

void
on_action_world_paste(GtkAction *action, GmAppView *view) {
	gm_world_paste_dialog_run(view);
}

void
on_action_world_logs(GtkAction *action, GmAppView *view) {
	GtkDialog *dlg;
	GtkTreeView *tview;
	GtkTreeModel *smodel;
	gchar *tmp, *tmp2;
	GtkTreeIter iter;
	gboolean done = FALSE;
	GdkCursor *wait_cursor;
	GmWorld *world = gm_app_view_active_world(view);
  
	dlg = gm_world_logs_dialog_new(gm_app_view_active_world(view), &tview);

	if (dlg != NULL) {
		smodel = gtk_tree_view_get_model(tview);
  	
		while (!done) {
			done = TRUE;
			
			switch (gtk_dialog_run(dlg)) {
				case GTK_RESPONSE_OK:
					if (gtk_tree_selection_get_selected(
							gtk_tree_view_get_selection(tview), &smodel, 
							&iter)) {
						gtk_tree_model_get(smodel, &iter, 0, &tmp, -1);
						tmp2 = g_strconcat(gm_world_path(world), 
								G_DIR_SEPARATOR_S, "logs", G_DIR_SEPARATOR_S, 
								tmp, 
								NULL);
						gtk_widget_set_sensitive(GTK_WIDGET(dlg), FALSE);
	
						wait_cursor = gdk_cursor_new(GDK_WATCH);
						gdk_window_set_cursor(GTK_WIDGET(dlg)->window, 
								wait_cursor);
						gdk_cursor_unref(wait_cursor);

						gm_world_view_open_log(
								gm_app_view_active_world_view(view), tmp2);

						gdk_window_set_cursor(GTK_WIDGET(dlg)->window, NULL);
						g_free(tmp2);
						g_free(tmp);
					} else {
						gm_error_dialog(_("You didn't select a log file"), 
								NULL);
						done = FALSE;
					}
				break;
				default:
				break;
			}
		}

		gtk_widget_destroy(GTK_WIDGET(dlg));
	}
}


void
on_action_world_close(GtkAction *action, GmAppView *view) {
	GmWorld *world = gm_app_view_active_world(view);

	if (world) {
		gm_world_unload(world);
	}
}

void
on_action_world_quit(GtkAction *action, GmAppView *view) {
	gtk_widget_destroy(GTK_WIDGET(view));
}

/* Edit callbacks */
void
on_action_edit_cut(GtkAction *action, GmAppView *view) {
	GtkWidget *active = gtk_window_get_focus(GTK_WINDOW(view));
	GtkClipboard *clip = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	GtkTextBuffer *buf;

	if (active && GTK_IS_TEXT_VIEW(active)) {
		buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(active));
		gtk_text_buffer_cut_clipboard(buf, clip, TRUE);
	}
}

void
on_action_edit_copy(GtkAction *action, GmAppView *view) {
	GtkWidget *active = gtk_window_get_focus(GTK_WINDOW(view));
	GtkClipboard *clip = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	GtkTextBuffer *buf;
	GtkTextIter start, end;
	GmWorldView *world_view;

	world_view = gm_app_view_active_world_view(view);

	if (world_view && active == GTK_WIDGET(gm_world_view_input(world_view))) {
		buf = gm_world_view_buffer(world_view);
		if (gtk_text_buffer_get_selection_bounds(buf, &start, &end)) {
			gtk_text_buffer_copy_clipboard(buf, clip);
			return;
		}
	}

	if (active && GTK_IS_TEXT_VIEW(active)) {
		buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(active));
		gtk_text_buffer_copy_clipboard(buf, clip);
	}
}

void
on_action_edit_paste(GtkAction *action, GmAppView *view) {
	GtkWidget *active = gtk_window_get_focus(GTK_WINDOW(view));
	GtkClipboard *clip = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	GtkTextBuffer *buf;

	if (active && GTK_IS_TEXT_VIEW(active)) {
		buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(active));
		gtk_text_buffer_paste_clipboard(buf, clip, NULL, TRUE);
	}
}

void
on_action_edit_world(GtkAction *action, GmAppView *view) {
	GmWorld *active = gm_app_view_active_world(view);
	
	gm_world_properties_dialog_run(active);
}

void
on_action_edit_worlds(GtkAction *action, GmAppView *view) {
	gm_worlds_list_dialog_run();
}

void
on_action_edit_preferences(GtkAction *action, GmAppView *view) {
	gm_preferences_dialog_run();
}


void 
on_action_edit_scripts(GtkAction *action, GmAppView *view) {
#ifdef HAVE_RUBY
	gm_scripts_dialog_run(view);	
#endif
}

/* View callbacks */
void 
on_action_view_toolbar(GtkAction *action, GmAppView *view) {
	gm_options_set_int(gm_app_options(gm_app_instance()), "show_toolbar", 
			gtk_toggle_action_get_active(GTK_TOGGLE_ACTION(action)) ? 1 : 0);
}

void
on_action_view_userlist(GtkAction *action, GmAppView *view) {
	gm_options_set_int(gm_app_options(gm_app_instance()), "show_userlist", 
			gtk_toggle_action_get_active(GTK_TOGGLE_ACTION(action)) ? 1 : 0);
}

/* Editor callbacks */
void 
on_action_editor_save(GtkAction *action, GmAppView *view) {
	gm_editor_view_save(gm_app_view_active_editor_view(view));
}

void 
on_action_editor_save_close(GtkAction *action, GmAppView *view) {
	GmEditorView *editor_view = gm_app_view_active_editor_view(view);
	
	gm_editor_view_save(editor_view);
	gm_editor_close(gm_editor_view_editor(editor_view));
}

#ifdef HAVE_PARSER
void 
on_action_editor_parse(GtkAction *action, GmAppView *view) {
	gm_editor_view_check_syntax(gm_app_view_active_editor_view(view));
}
#endif

void
on_action_editor_close(GtkAction *action, GmAppView *view) {
	gm_editor_close(gm_editor_view_editor(
			gm_app_view_active_editor_view(view)));
}

/* Toolbar callbacks */
void
on_action_edit_triggers(GtkAction *action, GmAppView *view) {
	GmWorld *active = gm_app_view_active_world(view);
	
	gm_world_properties_dialog_run_triggers(active);
}

/* Help callbacks */
static const gchar *authors[] = {
	N_("Jesse van den Kieboom"),
	N_("Sjoerd Simons (debian package)"),
	NULL
};

static const gchar *artists[] = {
	N_("Simon Gijsen"),
	NULL
};

void
on_action_help_about(GtkAction *action, GmAppView *view) {
	gtk_show_about_dialog(GTK_WINDOW(view),
			"name", _("GnoeMoe"),
			"version", PACKAGE_VERSION,
			"copyright", _("(C) 2004-2005 Icecrew.nl"),
			"comments", _("GnoeMoe Gnome MOO Client"),
			"authors", authors,
			"artists", artists,
			"logo", gm_pixbuf_get("gnoemoe_logo.svg"),
			NULL);
}
