------------------------------------------------------------------------------
--                     Copyright (C) 2018-2019, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

with HAL;

package Font5x5 is

   type Glyph is array (0 .. 4) of HAL.UInt5;

   Font : constant array (0 .. 93) of Glyph :=
     ((2#00100#, -- !
       2#00100#,
       2#00100#,
       2#00000#,
       2#00100#),
      (2#01010#, -- "
       2#01010#,
       2#00000#,
       2#00000#,
       2#00000#),
      (2#01010#, -- #
       2#11111#,
       2#01010#,
       2#11111#,
       2#01010#),
      (2#11110#, -- $
       2#00101#,
       2#01110#,
       2#00100#,
       2#01111#),
      (2#10001#, -- %
       2#01000#,
       2#00100#,
       2#00010#,
       2#10001#),
      (2#00100#, -- &
       2#01010#,
       2#00100#,
       2#01010#,
       2#10100#),
      (2#01000#, -- '
       2#00100#,
       2#00000#,
       2#00000#,
       2#00000#),
      (2#01000#, -- (
       2#00100#,
       2#00100#,
       2#00100#,
       2#01000#),
      (2#00010#, -- )
       2#00100#,
       2#00100#,
       2#00100#,
       2#00010#),
      (2#00000#, -- *
       2#00100#,
       2#01010#,
       2#00100#,
       2#00000#),
      (2#00000#, -- +
       2#00100#,
       2#01110#,
       2#00100#,
       2#00000#),
      (2#00000#, -- ,
       2#00000#,
       2#00000#,
       2#00100#,
       2#00010#),
      (2#00000#, -- -
       2#00000#,
       2#01110#,
       2#00000#,
       2#00000#),
      (2#00000#, --  .
       2#00000#,
       2#00000#,
       2#00000#,
       2#00010#),
      (2#10000#, -- /
       2#01000#,
       2#00100#,
       2#00010#,
       2#00001#),
      (2#01110#, -- 0
       2#10001#,
       2#10001#,
       2#10001#,
       2#01110#),
      (2#00100#, -- 1
       2#00110#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#01110#, -- 2
       2#10001#,
       2#01000#,
       2#00100#,
       2#11111#),
      (2#01111#, -- 3
       2#10000#,
       2#01111#,
       2#10000#,
       2#01111#),
      (2#01000#, -- 4
       2#01010#,
       2#01001#,
       2#11111#,
       2#01000#),
      (2#11111#, -- 5
       2#00001#,
       2#01111#,
       2#10000#,
       2#01111#),
      (2#01110#, -- 6
       2#00001#,
       2#00111#,
       2#01001#,
       2#01110#),
      (2#01110#, -- 7
       2#01000#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#01110#, -- 8
       2#10001#,
       2#01110#,
       2#10001#,
       2#01110#),
      (2#01110#, -- 9
       2#10001#,
       2#11110#,
       2#10000#,
       2#01110#),
      (2#00000#, -- :
       2#00100#,
       2#00000#,
       2#00100#,
       2#00000#),
      (2#00000#, -- ;
       2#00100#,
       2#00000#,
       2#00100#,
       2#00010#),
      (2#00000#, -- <
       2#00100#,
       2#00010#,
       2#00100#,
       2#00000#),
      (2#00000#, -- =
       2#01110#,
       2#00000#,
       2#01110#,
       2#00000#),
      (2#00000#, -- >
       2#00100#,
       2#01000#,
       2#00100#,
       2#00000#),
      (2#00100#, -- ?
       2#01000#,
       2#00100#,
       2#00000#,
       2#00100#),
      (2#01110#, -- @
       2#10001#,
       2#10101#,
       2#10001#,
       2#00110#),
      (2#01110#, -- A
       2#10001#,
       2#11111#,
       2#10001#,
       2#10001#),
      (2#01111#, -- B
       2#10001#,
       2#01111#,
       2#10001#,
       2#01111#),
      (2#11110#, -- C
       2#00001#,
       2#00001#,
       2#00001#,
       2#11110#),
      (2#01111#, -- D
       2#10001#,
       2#10001#,
       2#10001#,
       2#01111#),
      (2#11111#, -- E
       2#00001#,
       2#00111#,
       2#00001#,
       2#11111#),
      (2#11111#, -- F
       2#00001#,
       2#00111#,
       2#00001#,
       2#00001#),
      (2#11110#, -- G
       2#00001#,
       2#11101#,
       2#10001#,
       2#01110#),
      (2#10001#, -- H
       2#10001#,
       2#11111#,
       2#10001#,
       2#10001#),
      (2#00100#, -- I
       2#00100#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#10000#, -- J
       2#10000#,
       2#10000#,
       2#10001#,
       2#01110#),
      (2#01001#, -- K
       2#00101#,
       2#00011#,
       2#00101#,
       2#01001#),
      (2#00001#, -- L
       2#00001#,
       2#00001#,
       2#00001#,
       2#11111#),
      (2#10001#, -- M
       2#11011#,
       2#10101#,
       2#10001#,
       2#10001#),
      (2#10001#, -- N
       2#10011#,
       2#10101#,
       2#11001#,
       2#10001#),
      (2#01110#, -- O
       2#10001#,
       2#10001#,
       2#10001#,
       2#01110#),
      (2#01111#, -- P
       2#10001#,
       2#01111#,
       2#00001#,
       2#00001#),
      (2#01110#, -- Q
       2#10001#,
       2#10001#,
       2#11001#,
       2#11110#),
      (2#01111#, -- R
       2#10001#,
       2#01111#,
       2#01001#,
       2#10001#),
      (2#11110#, -- S
       2#00001#,
       2#01110#,
       2#10000#,
       2#01111#),
      (2#11111#, -- T
       2#00100#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#10001#, -- U
       2#10001#,
       2#10001#,
       2#10001#,
       2#01110#),
      (2#10001#, -- V
       2#10001#,
       2#01010#,
       2#01010#,
       2#00100#),
      (2#10101#, -- W
       2#10101#,
       2#10101#,
       2#01010#,
       2#01010#),
      (2#10001#, -- X
       2#01010#,
       2#00100#,
       2#01010#,
       2#10001#),
      (2#10001#, -- Y
       2#01010#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#11111#, -- Z
       2#01000#,
       2#00100#,
       2#00010#,
       2#11111#),
      (2#01110#, -- [
       2#00010#,
       2#00010#,
       2#00010#,
       2#01110#),
      (2#00001#, -- \
       2#00010#,
       2#00100#,
       2#01000#,
       2#10000#),
      (2#01110#, -- ]
       2#01000#,
       2#01000#,
       2#01000#,
       2#01110#),
      (2#00100#, -- ^
       2#01010#,
       2#10001#,
       2#00000#,
       2#00000#),
      (2#00000#, -- _
       2#00000#,
       2#00000#,
       2#00000#,
       2#11111#),
      (2#00010#, -- `
       2#00100#,
       2#00000#,
       2#00000#,
       2#00000#),
      (2#01111#, -- a
       2#10000#,
       2#11110#,
       2#10001#,
       2#11110#),
      (2#00001#, -- b
       2#01111#,
       2#10001#,
       2#10001#,
       2#01111#),
      (2#01110#, -- c
       2#10001#,
       2#00001#,
       2#10001#,
       2#01110#),
      (2#10000#, -- d
       2#11110#,
       2#10001#,
       2#10001#,
       2#11110#),
      (2#01110#, -- e
       2#10001#,
       2#11111#,
       2#00001#,
       2#11110#),
      (2#11110#, -- f
       2#00001#,
       2#00111#,
       2#00001#,
       2#00001#),
      (2#01110#, -- g
       2#10001#,
       2#11110#,
       2#10000#,
       2#01111#),
      (2#00001#, -- h
       2#01111#,
       2#10001#,
       2#10001#,
       2#10001#),
      (2#00100#, -- i
       2#00000#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#10000#, -- j
       2#10000#,
       2#10000#,
       2#10000#,
       2#01111#),
      (2#10001#, -- k
       2#01001#,
       2#00111#,
       2#01001#,
       2#10001#),
      (2#00001#, -- l
       2#00001#,
       2#00001#,
       2#00001#,
       2#11110#),
      (2#01010#, -- m
       2#10101#,
       2#10101#,
       2#10101#,
       2#10101#),
      (2#01111#, -- n
       2#10001#,
       2#10001#,
       2#10001#,
       2#10001#),
      (2#01110#, -- o
       2#10001#,
       2#10001#,
       2#10001#,
       2#01110#),
      (2#01111#, -- p
       2#10001#,
       2#10001#,
       2#01111#,
       2#00001#),
      (2#11110#, -- q
       2#10001#,
       2#10001#,
       2#11110#,
       2#10000#),
      (2#01101#, -- r
       2#10011#,
       2#00001#,
       2#00001#,
       2#00001#),
      (2#11110#, -- s
       2#00001#,
       2#01110#,
       2#10000#,
       2#01111#),
      (2#00001#, -- t
       2#00111#,
       2#00001#,
       2#10001#,
       2#01110#),
      (2#10001#, -- u
       2#10001#,
       2#10001#,
       2#11001#,
       2#10110#),
      (2#10001#, -- v
       2#10001#,
       2#01010#,
       2#01010#,
       2#00100#),
      (2#10101#, -- w
       2#10101#,
       2#10101#,
       2#10101#,
       2#01010#),
      (2#10001#, -- x
       2#10001#,
       2#01110#,
       2#10001#,
       2#10001#),
      (2#10001#, -- y
       2#10001#,
       2#11110#,
       2#10000#,
       2#01111#),
      (2#11111#, -- z
       2#01000#,
       2#00100#,
       2#00010#,
       2#11111#),
      (2#00100#, -- {
       2#00100#,
       2#00010#,
       2#00100#,
       2#00100#),
      (2#00100#, -- |
       2#00100#,
       2#00100#,
       2#00100#,
       2#00100#),
      (2#00100#, -- }
       2#00100#,
       2#01000#,
       2#00100#,
       2#00100#),
      (2#00000#, -- ~
       2#00000#,
       2#01010#,
       2#10101#,
       2#00000#)
     );
end Font5x5;
