// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef __SampleH
#define __SampleH

#include <stdio.h>

#ifdef USE_NCURSES
#include <curses.h>
#endif

#include "defines.h"

class Sequencer;

class Sample
{
public:
  Sample();
  virtual ~Sample() {};
  virtual int load(Sequencer &, FILE *, int, int, void * = 0, void * = 0) = 0;
  virtual int slideRate(int, unsigned char) const;
  virtual int volumeEnvelopeY(int &, char inSustain, unsigned short *) const
  { return (inSustain ? 64 : 0); }
  virtual int panEnvelopeY(int &, char) const
  { return 32; }
  virtual void decode(char *) const {}
  virtual int pan() const { return -1; }
  virtual int vibratoDepth() const { return -1; }
  virtual int vibratoRate() const { return 0; }
  virtual int vibratoType() const { return -1; }
  void cutFactor(int c) { cutFactor_ = c; }
  int cutFactor() const { return cutFactor_; }
  int number() const { return sampleNum_; }
  short finetune() const { return finetune_; }
  unsigned char volume() const { return volume_; }
  const char *name() const { return name_; }
  void getPatchInfo(struct patch_info &) const;
  int ok() const { return ok_; }
#ifndef USE_X
#ifdef USE_NCURSES
  void printInfo(WINDOW *, int);
#else
  void printInfo(int, const unsigned char);
#endif
#endif

protected:
  int sampleNum_;
  int length_;
  int loopStart;
  int loopEnd;
  int ok_;
  short finetune_;
  unsigned char cutFactor_;
  unsigned char volume_;
  char name_[SAMPNAME_LEN];

  unsigned int mode_;
  unsigned int baseFreq_;
  unsigned int baseNote_;
};

#ifndef USE_X
#ifdef USE_NCURSES
inline void
Sample::printInfo(WINDOW *win, int i)
{
  char num[4];
  
  if (ok_)
    sprintf(num, "%03d", i);
  else
    strcpy(num, "xxx");

  wprintw(win, "%s: L%06u B%06u E%06u V%03u %s\n",
	  num, length_, loopStart, loopEnd, volume_, name_);
}
#else
inline void
Sample::printInfo(int i, unsigned char showEmpty)
{
  char num[4];

  if ((length_ > 0) || showEmpty)
    {
      if (ok_)
	sprintf(num, "%03d", i);
      else
	strcpy(num, "xxx");

      PRINTF("%s: L%06u B%06u E%06u V%03u %s\n",
	     num, length_, loopStart, loopEnd, volume_, name_);
    }
}
#endif
#endif

inline int
Sample::slideRate(int rate, unsigned char slideDir) const
{
  if (slideDir == SLIDE_POS)
    return rate;
  else
    return -rate;
}

inline
Sample::Sample() : length_(0), loopStart(0), loopEnd(0), ok_(0),
  finetune_(0), cutFactor_(1), volume_(0), mode_(0), baseFreq_(0), baseNote_(0)
{
  name_[0] = '\0';
}

#endif
